#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: bam2roi
class: CommandLineTool
cwlVersion: v1.0
doc: "Calculated consecutive regions of coverage from alignment file IN.bam and write\
  \ regions of interest to file OUT.roi. Counting is performed over the entire region\
  \ (including intron and N-regions) based on the CIGAR string of the alignment record.\n\
  \n\n\nFor more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Verbose mode.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Verbose mode.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Very verbose mode.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Very verbose mode.
  type:
  - 'null'
  - string
- doc: SAM/BAM formatted file.  Must be sorted by coordinate.
  id: param_input-file
  inputBinding:
    prefix: -input-file
  label: SAM/BAM formatted file.  Must be sorted by coordinate.
  type: File
- doc: Filename for output-file output file
  id: param_output-file_filename
  inputBinding:
    prefix: -output-file
  label: Filename for output-file output file
  type: string
- default: 'false'
  doc: Calculate strand-specific ROIs (see section Strand Specificness below.
  id: param_strand-specific
  inputBinding:
    prefix: -strand-specific
  label: Calculate strand-specific ROIs (see section Strand Specificness below.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Ignore paired information.  Also see Section ROI Creation Details.
  id: param_ignore-pairing
  inputBinding:
    prefix: -ignore-pairing
  label: Ignore paired information.  Also see Section ROI Creation Details.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Link over skipped bases in the read alignment.
  id: param_link-over-skipped
  inputBinding:
    prefix: -link-over-skipped
  label: Link over skipped bases in the read alignment.
  type:
  - 'null'
  - string
label: Create ROI from BAM file.
outputs:
- doc: Output file with regions of interest.
  id: param_output-file
  label: Output file with regions of interest.
  outputBinding:
    glob: $(inputs.param_output-file_filename)
  type: File
