#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: fx_bam_coverage
class: CommandLineTool
cwlVersion: v1.0
doc: "Compute read coverage and C+G content for a genome.\n\n\n\nFor more information,\
  \ visit http://www.seqan.de"
inputs:
- doc: Path to the reference file.
  id: param_in-reference
  inputBinding:
    prefix: -in-reference
  label: Path to the reference file.
  type: File
- doc: Path to the mapping file to analyze.
  id: param_in-mapping
  inputBinding:
    prefix: -in-mapping
  label: Path to the mapping file to analyze.
  type: File
- default: '10000'
  doc: Set the size of the non-overlapping windows in base pairs.
  id: param_window-size
  inputBinding:
    prefix: -window-size
  label: Set the size of the non-overlapping windows in base pairs.
  type:
  - 'null'
  - int
- doc: Filename for out-path output file
  id: param_out-path_filename
  inputBinding:
    prefix: -out-path
  label: Filename for out-path output file
  type: string
label: Read Coverage Computation.
outputs:
- doc: Path to the resulting file.  If omitted, result is printed to stdout.
  id: param_out-path
  label: Path to the resulting file.  If omitted, result is printed to stdout.
  outputBinding:
    glob: $(inputs.param_out-path_filename)
  type: File
