#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: samcat
class: CommandLineTool
cwlVersion: v1.0
doc: "This tool reads a set of input files in SAM or BAM format and outputs the concatenation\
  \ of them. If the output file name is omitted the result is written to stdout.\n\
  (c) Copyright in 2014 by David Weese.\n\n\n\nFor more information, visit http://www.seqan.de"
inputs:
- doc: Filename for output output file
  id: param_output_filename
  inputBinding:
    prefix: -output
  label: Filename for output output file
  type:
  - 'null'
  - string
- default: 'false'
  doc: 'Use BAM format for standard output. Default: SAM.'
  id: param_bam
  inputBinding:
    prefix: -bam
  label: 'Use BAM format for standard output. Default: SAM.'
  type:
  - 'null'
  - string
- default: 'false'
  doc: Print some stats.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Print some stats.
  type:
  - 'null'
  - string
- doc: Input SAM or BAM file (or - for stdin).
  id: param_argument-0
  inputBinding:
    prefix: -argument-0
  label: Input SAM or BAM file (or - for stdin).
  type: File
label: SAM/BAM file concatenation and conversion
outputs:
- doc: Output file name.
  id: param_output
  label: Output file name.
  outputBinding:
    glob: $(inputs.param_output_filename)
  type:
  - 'null'
  - File
