#!/usr/bin/env cwl-runner

# This CWL file was automatically generated using CTDConverter.
# Visit https://github.com/WorkflowConversion/CTDConverter for more information.

baseCommand: seqcons2
class: CommandLineTool
cwlVersion: v1.0
doc: "Compute consensus from sequences with and without approximate alignment information.\n\
  \n\n\nFor more information, visit http://www.seqan.de"
inputs:
- default: 'false'
  doc: Set verbosity to a minimum.
  id: param_quiet
  inputBinding:
    prefix: -quiet
  label: Set verbosity to a minimum.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable verbose output.
  id: param_verbose
  inputBinding:
    prefix: -verbose
  label: Enable verbose output.
  type:
  - 'null'
  - string
- default: 'false'
  doc: Enable very verbose output.
  id: param_very-verbose
  inputBinding:
    prefix: -very-verbose
  label: Enable very verbose output.
  type:
  - 'null'
  - string
- default: pos_consensus
  doc: Method to perform.  See section Methods below for details.
  id: param_method
  inputBinding:
    prefix: -method
  label: Method to perform.  See section Methods below for details.
  type:
  - 'null'
  - string
- doc: Input file.
  id: param_input-file
  inputBinding:
    prefix: -input-file
  label: Input file.
  type: File
- doc: Filename for output-alignment-file output file
  id: param_output-alignment-file_filename
  inputBinding:
    prefix: -output-alignment-file
  label: Filename for output-alignment-file output file
  type:
  - 'null'
  - string
- doc: Filename for output-consensus-file output file
  id: param_output-consensus-file_filename
  inputBinding:
    prefix: -output-consensus-file
  label: Filename for output-consensus-file output file
  type:
  - 'null'
  - string
- default: '20'
  doc: Minimal overlap length.
  id: param_overlap-min-length
  inputBinding:
    prefix: -overlap-min-length
  label: Minimal overlap length.
  type:
  - 'null'
  - int
- default: '5.0'
  doc: Maximal error rate in overlap as percentage.
  id: param_overlap-max-error
  inputBinding:
    prefix: -overlap-max-error
  label: Maximal error rate in overlap as percentage.
  type:
  - 'null'
  - double
- default: '3'
  doc: Minimal overlap count.
  id: param_overlap-min-count
  inputBinding:
    prefix: -overlap-min-count
  label: Minimal overlap count.
  type:
  - 'null'
  - int
- default: '20'
  doc: Window size to look for alignments.
  id: param_overlap-window-size
  inputBinding:
    prefix: -overlap-window-size
  label: Window size to look for alignments.
  type:
  - 'null'
  - int
- default: '20'
  doc: The k-mer size to use.
  id: param_k-mer-size
  inputBinding:
    prefix: -k-mer-size
  label: The k-mer size to use.
  type:
  - 'null'
  - int
- default: '200'
  doc: Ignore k-mer with higher occurrence count, 0 to disable.
  id: param_k-mer-max-occ
  inputBinding:
    prefix: -k-mer-max-occ
  label: Ignore k-mer with higher occurrence count, 0 to disable.
  type:
  - 'null'
  - int
- default: '10'
  doc: Bandwidth to use for pairwise alignments in realignment.
  id: param_realign-bandwidth
  inputBinding:
    prefix: -realign-bandwidth
  label: Bandwidth to use for pairwise alignments in realignment.
  type:
  - 'null'
  - int
- default: '20'
  doc: Environment for extraction in realignment.
  id: param_realign-environment
  inputBinding:
    prefix: -realign-environment
  label: Environment for extraction in realignment.
  type:
  - 'null'
  - int
label: Compute consensus from sequences.
outputs:
- doc: Output file with alignment.
  id: param_output-alignment-file
  label: Output file with alignment.
  outputBinding:
    glob: $(inputs.param_output-alignment-file_filename)
  type:
  - 'null'
  - File
- doc: Output file with consensus sequence.
  id: param_output-consensus-file
  label: Output file with consensus sequence.
  outputBinding:
    glob: $(inputs.param_output-consensus-file_filename)
  type:
  - 'null'
  - File
