/* example of the shhmsg library
 * by Oohara Yuuma
 * $Id: hello.c,v 1.3 2002/01/20 06:46:34 oohara Exp $
 */
/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the Artistic License.  On a Debian system,
 * you can find its copy at /usr/share/common-licenses/Artistic.
 * THIS PROGRAM IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE
 */
/* to compile:
 * $ gcc -Wall -o hello hello.c -lshhmsg
 */
/* usage:
 * $ ./hello [arguments]
 * If only one argument is given, it shows verbose message.
 * 2 or more arguments cause a error.
 */
/* return value:
 * 0: normal exit
 * 1: too many arguments
 * 99: the shhmsg library is broken
 */
/* for more information, see /usr/share/doc/shhmsg-dev/shhmsg.txt.gz */

/* include the header of the shhmsg library */
#include <shhmsg.h>
/* you don't need <stdio.h> here unless you use EOF or something */

int main(int argc, char *argv[])
{
  /* set the name of this program
   * usually it can be found in argv[0]
   * only the basename (see basename(1)) will be shown
   */
  msgSetName(argv[0]);
  /* turn the output on */
  msgSetQuiet(MSG_OUTPUT);
  /* set the verbosity level
   * a message in msgVerbose() will be shown if and only if this level is
   * greater than or equal to the first argument of msgVerbose()
   * MSG_VERBOSE_NONE means "no verbose message"
   */
  msgSetVerbose(MSG_VERBOSE_NONE);
  /* set the stream for the error message to stderr
   * note that this is the default
   * the return value is the old stream
   */
  if (msgSetErrorStream(stderr) != stderr)
    /* show the error message and exit with the status 99 */
    msgFatal("shhmsg is broken, default of error stream is not stderr!\n");
  /* do a similar thing to the (informational) message stream
   * (default: stdout)
   */
  if (msgSetMessageStream(stdout) != stdout)
    msgFatal("shhmsg is broken, default of message stream is not stdout!\n");
  /* the default of the verbose stream is stderr, but I like it to be stdout,
   * so I set it here
   */
  if (msgSetVerboseStream(stdout) != stderr)
    msgFatal("shhmsg is broken, default of verbose stream is not stderr!\n");
  /* count the number of arguments */
  if (argc == 1)
    /* no argument --- do nothing here */
    ;
  else if (argc == 2)
  {
    /* exactly one argument --- increase the verbosity level */
    msgSetVerbose(2);
    /* always show the program name */
    msgSetShowNameAlways(MSG_ON);
  }
  else
  {
    /* 2 or more arguments --- show error message */
    msgError("too many arguments --- %d arguments\n", argc - 1);
    /* exit manually */
    return 1;
  }
  /* print informational message */
  msgMessage("Hello, world!\n");
  /* print verbose message */
  msgVerbose(1, "more traditional style: hello, world (verbosity level 1)\n");
  msgVerbose(2, "This is a verbose message. (verbosity level 2)\n");
  msgVerbose(9, "No, you will never see this message! (verbosity level 9)\n");
  return 0;
}

