/* EventTable.c generated by valac 0.34.4, the Vala compiler
 * generated from EventTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sqlite3.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_EVENT_ROW (event_row_get_type ())
#define EVENT_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_ROW, EventRow))
#define EVENT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_ROW, EventRowClass))
#define IS_EVENT_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_ROW))
#define IS_EVENT_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_ROW))
#define EVENT_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_ROW, EventRowClass))

typedef struct _EventRow EventRow;
typedef struct _EventRowClass EventRowClass;
typedef struct _EventRowPrivate EventRowPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecEventRow ParamSpecEventRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_EVENT_TABLE (event_table_get_type ())
#define EVENT_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_TABLE, EventTable))
#define EVENT_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_TABLE, EventTableClass))
#define IS_EVENT_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_TABLE))
#define IS_EVENT_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_TABLE))
#define EVENT_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_TABLE, EventTableClass))

typedef struct _EventTable EventTable;
typedef struct _EventTableClass EventTableClass;
typedef struct _EventTablePrivate EventTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_MEDIA_COLLECTION_REGISTRY (media_collection_registry_get_type ())
#define MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistry))
#define MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))
#define IS_MEDIA_COLLECTION_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_COLLECTION_REGISTRY))
#define IS_MEDIA_COLLECTION_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_COLLECTION_REGISTRY))
#define MEDIA_COLLECTION_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_COLLECTION_REGISTRY, MediaCollectionRegistryClass))

typedef struct _MediaCollectionRegistry MediaCollectionRegistry;
typedef struct _MediaCollectionRegistryClass MediaCollectionRegistryClass;
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;
#define _event_row_unref0(var) ((var == NULL) ? NULL : (var = (event_row_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _EventID {
	gint64 id;
};

struct _EventRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EventRowPrivate * priv;
	EventID event_id;
	gchar* name;
	time_t time_created;
	gchar* primary_source_id;
	gchar* comment;
};

struct _EventRowClass {
	GTypeClass parent_class;
	void (*finalize) (EventRow *self);
};

struct _ParamSpecEventRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _EventTable {
	DatabaseTable parent_instance;
	EventTablePrivate * priv;
};

struct _EventTableClass {
	DatabaseTableClass parent_class;
};

struct _PhotoID {
	gint64 id;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer event_row_parent_class = NULL;
static gpointer event_table_parent_class = NULL;
static EventTable* event_table_instance;
static EventTable* event_table_instance = NULL;
extern sqlite3* database_table_db;

GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
#define EVENT_ID_INVALID ((gint64) -1)
void event_id_init (EventID *self, gint64 id);
gboolean event_id_is_invalid (EventID *self);
gboolean event_id_is_valid (EventID *self);
gpointer event_row_ref (gpointer instance);
void event_row_unref (gpointer instance);
GParamSpec* param_spec_event_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_event_row (GValue* value, gpointer v_object);
void value_take_event_row (GValue* value, gpointer v_object);
gpointer value_get_event_row (const GValue* value);
GType event_row_get_type (void) G_GNUC_CONST;
enum  {
	EVENT_ROW_DUMMY_PROPERTY
};
EventRow* event_row_new (void);
EventRow* event_row_construct (GType object_type);
static void event_row_finalize (EventRow* obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_database_table (GValue* value, gpointer v_object);
void value_take_database_table (GValue* value, gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType event_table_get_type (void) G_GNUC_CONST;
enum  {
	EVENT_TABLE_DUMMY_PROPERTY
};
static EventTable* event_table_new (void);
static EventTable* event_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_fatal (const gchar* op, gint res);
void database_table_set_table_name (DatabaseTable* self, const gchar* table_name);
EventTable* event_table_get_instance (void);
static gchar* event_table_source_id_upgrade (EventTable* self, gint64 primary_photo_id, const gchar* primary_source_id);
gpointer media_collection_registry_ref (gpointer instance);
void media_collection_registry_unref (gpointer instance);
GParamSpec* param_spec_media_collection_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_media_collection_registry (GValue* value, gpointer v_object);
void value_take_media_collection_registry (GValue* value, gpointer v_object);
gpointer value_get_media_collection_registry (const GValue* value);
GType media_collection_registry_get_type (void) G_GNUC_CONST;
MediaCollectionRegistry* media_collection_registry_get_instance (void);
gboolean media_collection_registry_is_valid_source_id (MediaCollectionRegistry* self, const gchar* source_id);
#define PHOTO_ID_INVALID ((gint64) -1)
GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id);
void photo_id_init (PhotoID *self, gint64 id);
GQuark database_error_quark (void);
EventRow* event_table_create (EventTable* self, const gchar* primary_source_id, const gchar* comment, GError** error);
gulong now_sec (void);
void database_table_throw_error (const gchar* method, gint res, GError** error);
void event_table_create_from_row (EventTable* self, EventRow* row, EventID* result);
EventRow* event_table_get_row (EventTable* self, EventID* event_id);
void event_table_remove (EventTable* self, EventID* event_id, GError** error);
void database_table_delete_by_id (DatabaseTable* self, gint64 id, GError** error);
GeeArrayList* event_table_get_events (EventTable* self);
gboolean event_table_rename (EventTable* self, EventID* event_id, const gchar* name);
gboolean database_table_update_text_by_id (DatabaseTable* self, gint64 id, const gchar* column, const gchar* text);
gchar* event_table_get_name (EventTable* self, EventID* event_id);
gboolean database_table_select_by_id (DatabaseTable* self, gint64 id, const gchar* columns, sqlite3_stmt** stmt);
gchar* event_table_get_primary_source_id (EventTable* self, EventID* event_id);
gboolean event_table_set_primary_source_id (EventTable* self, EventID* event_id, const gchar* primary_source_id);
time_t event_table_get_time_created (EventTable* self, EventID* event_id);
gboolean event_table_set_comment (EventTable* self, EventID* event_id, const gchar* new_comment);
static void event_table_finalize (DatabaseTable* obj);


void event_id_init (EventID *self, gint64 id) {
	gint64 _tmp0_ = 0LL;
#line 12 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	memset (self, 0, sizeof (EventID));
#line 13 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = id;
#line 13 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	(*self).id = _tmp0_;
#line 227 "EventTable.c"
}


gboolean event_id_is_invalid (EventID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 17 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = _tmp0_ == EVENT_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 240 "EventTable.c"
}


gboolean event_id_is_valid (EventID *self) {
	gboolean result = FALSE;
	gint64 _tmp0_ = 0LL;
#line 21 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = _tmp0_ != EVENT_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 253 "EventTable.c"
}


EventID* event_id_dup (const EventID* self) {
	EventID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	dup = g_new0 (EventID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	memcpy (dup, self, sizeof (EventID));
#line 7 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return dup;
#line 265 "EventTable.c"
}


void event_id_free (EventID* self) {
#line 7 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_free (self);
#line 272 "EventTable.c"
}


GType event_id_get_type (void) {
	static volatile gsize event_id_type_id__volatile = 0;
	if (g_once_init_enter (&event_id_type_id__volatile)) {
		GType event_id_type_id;
		event_id_type_id = g_boxed_type_register_static ("EventID", (GBoxedCopyFunc) event_id_dup, (GBoxedFreeFunc) event_id_free);
		g_once_init_leave (&event_id_type_id__volatile, event_id_type_id);
	}
	return event_id_type_id__volatile;
}


EventRow* event_row_construct (GType object_type) {
	EventRow* self = NULL;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	self = (EventRow*) g_type_create_instance (object_type);
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return self;
#line 293 "EventTable.c"
}


EventRow* event_row_new (void) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return event_row_construct (TYPE_EVENT_ROW);
#line 300 "EventTable.c"
}


static void value_event_row_init (GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	value->data[0].v_pointer = NULL;
#line 307 "EventTable.c"
}


static void value_event_row_free_value (GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		event_row_unref (value->data[0].v_pointer);
#line 316 "EventTable.c"
	}
}


static void value_event_row_copy_value (const GValue* src_value, GValue* dest_value) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (src_value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		dest_value->data[0].v_pointer = event_row_ref (src_value->data[0].v_pointer);
#line 326 "EventTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 330 "EventTable.c"
	}
}


static gpointer value_event_row_peek_pointer (const GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return value->data[0].v_pointer;
#line 338 "EventTable.c"
}


static gchar* value_event_row_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (collect_values[0].v_pointer) {
#line 345 "EventTable.c"
		EventRow* object;
		object = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 352 "EventTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 356 "EventTable.c"
		}
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		value->data[0].v_pointer = event_row_ref (object);
#line 360 "EventTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		value->data[0].v_pointer = NULL;
#line 364 "EventTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return NULL;
#line 368 "EventTable.c"
}


static gchar* value_event_row_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EventRow** object_p;
	object_p = collect_values[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (!object_p) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 379 "EventTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (!value->data[0].v_pointer) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		*object_p = NULL;
#line 385 "EventTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		*object_p = value->data[0].v_pointer;
#line 389 "EventTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		*object_p = event_row_ref (value->data[0].v_pointer);
#line 393 "EventTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return NULL;
#line 397 "EventTable.c"
}


GParamSpec* param_spec_event_row (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEventRow* spec;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_EVENT_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return G_PARAM_SPEC (spec);
#line 411 "EventTable.c"
}


gpointer value_get_event_row (const GValue* value) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW), NULL);
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return value->data[0].v_pointer;
#line 420 "EventTable.c"
}


void value_set_event_row (GValue* value, gpointer v_object) {
	EventRow* old;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		value->data[0].v_pointer = v_object;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		event_row_ref (value->data[0].v_pointer);
#line 440 "EventTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		value->data[0].v_pointer = NULL;
#line 444 "EventTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		event_row_unref (old);
#line 450 "EventTable.c"
	}
}


void value_take_event_row (GValue* value, gpointer v_object) {
	EventRow* old;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_EVENT_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	old = value->data[0].v_pointer;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (v_object) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_EVENT_ROW));
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		value->data[0].v_pointer = v_object;
#line 469 "EventTable.c"
	} else {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		value->data[0].v_pointer = NULL;
#line 473 "EventTable.c"
	}
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (old) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		event_row_unref (old);
#line 479 "EventTable.c"
	}
}


static void event_row_class_init (EventRowClass * klass) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	event_row_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	((EventRowClass *) klass)->finalize = event_row_finalize;
#line 489 "EventTable.c"
}


static void event_row_instance_init (EventRow * self) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	self->ref_count = 1;
#line 496 "EventTable.c"
}


static void event_row_finalize (EventRow* obj) {
	EventRow * self;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_ROW, EventRow);
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_signal_handlers_destroy (self);
#line 27 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (self->name);
#line 29 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (self->primary_source_id);
#line 30 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (self->comment);
#line 512 "EventTable.c"
}


GType event_row_get_type (void) {
	static volatile gsize event_row_type_id__volatile = 0;
	if (g_once_init_enter (&event_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_event_row_init, value_event_row_free_value, value_event_row_copy_value, value_event_row_peek_pointer, "p", value_event_row_collect_value, "p", value_event_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EventRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventRow), 0, (GInstanceInitFunc) event_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType event_row_type_id;
		event_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EventRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&event_row_type_id__volatile, event_row_type_id);
	}
	return event_row_type_id__volatile;
}


gpointer event_row_ref (gpointer instance) {
	EventRow* self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return instance;
#line 537 "EventTable.c"
}


void event_row_unref (gpointer instance) {
	EventRow* self;
	self = instance;
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		EVENT_ROW_GET_CLASS (self)->finalize (self);
#line 25 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 550 "EventTable.c"
	}
}


static EventTable* event_table_construct (GType object_type) {
	EventTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
#line 36 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	self = (EventTable*) database_table_construct (object_type);
#line 38 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = database_table_db;
#line 38 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS EventTable (" "id INTEGER PRIMARY KEY, " "name TEXT, " "primary_photo_id INTEGER, " "time_created INTEGER," "primary_source_id TEXT," "comment TEXT" ")", -1, &_tmp1_, NULL);
#line 38 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 38 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	stmt = _tmp1_;
#line 38 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp2_;
#line 46 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = res;
#line 46 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 48 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = stmt;
#line 48 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = sqlite3_step (_tmp4_);
#line 48 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp5_;
#line 49 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp6_ = res;
#line 49 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp6_ != SQLITE_DONE) {
#line 592 "EventTable.c"
		gint _tmp7_ = 0;
#line 50 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp7_ = res;
#line 50 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		database_table_fatal ("create photo table", _tmp7_);
#line 598 "EventTable.c"
	}
#line 52 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "EventTable");
#line 36 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 36 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return self;
#line 606 "EventTable.c"
}


static EventTable* event_table_new (void) {
#line 36 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return event_table_construct (TYPE_EVENT_TABLE);
#line 613 "EventTable.c"
}


static gpointer _database_table_ref0 (gpointer self) {
#line 59 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 620 "EventTable.c"
}


EventTable* event_table_get_instance (void) {
	EventTable* result = NULL;
	EventTable* _tmp0_ = NULL;
	EventTable* _tmp2_ = NULL;
	EventTable* _tmp3_ = NULL;
#line 56 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = event_table_instance;
#line 56 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp0_ == NULL) {
#line 633 "EventTable.c"
		EventTable* _tmp1_ = NULL;
#line 57 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp1_ = event_table_new ();
#line 57 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_database_table_unref0 (event_table_instance);
#line 57 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		event_table_instance = _tmp1_;
#line 641 "EventTable.c"
	}
#line 59 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp2_ = event_table_instance;
#line 59 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 59 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = _tmp3_;
#line 59 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 651 "EventTable.c"
}


static gchar* event_table_source_id_upgrade (EventTable* self, gint64 primary_photo_id, const gchar* primary_source_id) {
	gchar* result = NULL;
	MediaCollectionRegistry* _tmp0_ = NULL;
	MediaCollectionRegistry* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint64 _tmp7_ = 0LL;
#line 63 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
#line 64 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = media_collection_registry_get_instance ();
#line 64 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = _tmp0_;
#line 64 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp2_ = primary_source_id;
#line 64 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = media_collection_registry_is_valid_source_id (_tmp1_, _tmp2_);
#line 64 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = _tmp3_;
#line 64 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_media_collection_registry_unref0 (_tmp1_);
#line 64 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp4_) {
#line 679 "EventTable.c"
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 65 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp5_ = primary_source_id;
#line 65 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 65 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		result = _tmp6_;
#line 65 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		return result;
#line 690 "EventTable.c"
	}
#line 67 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp7_ = primary_photo_id;
#line 67 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp7_ != PHOTO_ID_INVALID) {
#line 696 "EventTable.c"
		gint64 _tmp8_ = 0LL;
		PhotoID _tmp9_ = {0};
		gchar* _tmp10_ = NULL;
#line 69 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp8_ = primary_photo_id;
#line 69 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		photo_id_init (&_tmp9_, _tmp8_);
#line 69 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp10_ = photo_id_upgrade_photo_id_to_source_id (&_tmp9_);
#line 69 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		result = _tmp10_;
#line 69 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		return result;
#line 710 "EventTable.c"
	}
#line 71 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = NULL;
#line 71 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 716 "EventTable.c"
}


EventRow* event_table_create (EventTable* self, const gchar* primary_source_id, const gchar* comment, GError** error) {
	EventRow* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp3_ = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	time_t time_created = 0;
	gulong _tmp7_ = 0UL;
	sqlite3_stmt* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	GDestroyNotify _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	sqlite3_stmt* _tmp14_ = NULL;
	time_t _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	sqlite3_stmt* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	GDestroyNotify _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	sqlite3_stmt* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	EventRow* row = NULL;
	EventRow* _tmp28_ = NULL;
	EventRow* _tmp29_ = NULL;
	sqlite3* _tmp30_ = NULL;
	gint64 _tmp31_ = 0LL;
	EventRow* _tmp32_ = NULL;
	EventRow* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	EventRow* _tmp36_ = NULL;
	time_t _tmp37_ = 0;
	EventRow* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	GError * _inner_error_ = NULL;
#line 74 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
#line 75 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = primary_source_id;
#line 75 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp1_ != NULL) {
#line 772 "EventTable.c"
		const gchar* _tmp2_ = NULL;
#line 75 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp2_ = primary_source_id;
#line 75 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "") != 0;
#line 778 "EventTable.c"
	} else {
#line 75 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp0_ = FALSE;
#line 782 "EventTable.c"
	}
#line 75 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp0_, "primary_source_id != null && primary_source_id != \"\"");
#line 78 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = database_table_db;
#line 78 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = sqlite3_prepare_v2 (_tmp3_, "INSERT INTO EventTable (primary_source_id, time_created, comment) VALU" \
"ES (?, ?, ?)", -1, &_tmp4_, NULL);
#line 78 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 78 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	stmt = _tmp4_;
#line 78 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp5_;
#line 81 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp6_ = res;
#line 81 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 83 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp7_ = now_sec ();
#line 83 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	time_created = (time_t) _tmp7_;
#line 85 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp8_ = stmt;
#line 85 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp9_ = primary_source_id;
#line 85 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp10_ = g_strdup (_tmp9_);
#line 85 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp11_ = g_free;
#line 85 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp12_ = sqlite3_bind_text (_tmp8_, 1, _tmp10_, -1, _tmp11_);
#line 85 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp12_;
#line 86 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp13_ = res;
#line 86 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 87 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp14_ = stmt;
#line 87 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp15_ = time_created;
#line 87 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp16_ = sqlite3_bind_int64 (_tmp14_, 2, (gint64) _tmp15_);
#line 87 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp16_;
#line 88 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp17_ = res;
#line 88 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 89 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp18_ = stmt;
#line 89 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp19_ = comment;
#line 89 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp20_ = g_strdup (_tmp19_);
#line 89 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp21_ = g_free;
#line 89 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp22_ = sqlite3_bind_text (_tmp18_, 3, _tmp20_, -1, _tmp21_);
#line 89 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp22_;
#line 90 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp23_ = res;
#line 90 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp23_ == SQLITE_OK, "res == Sqlite.OK");
#line 92 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp24_ = stmt;
#line 92 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp25_ = sqlite3_step (_tmp24_);
#line 92 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp25_;
#line 93 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp26_ = res;
#line 93 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp26_ != SQLITE_DONE) {
#line 858 "EventTable.c"
		gint _tmp27_ = 0;
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp27_ = res;
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		database_table_throw_error ("EventTable.create", _tmp27_, &_inner_error_);
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				g_propagate_error (error, _inner_error_);
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				_sqlite3_finalize0 (stmt);
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				return NULL;
#line 874 "EventTable.c"
			} else {
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				_sqlite3_finalize0 (stmt);
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				g_clear_error (&_inner_error_);
#line 94 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				return NULL;
#line 884 "EventTable.c"
			}
		}
	}
#line 96 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp28_ = event_row_new ();
#line 96 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	row = _tmp28_;
#line 97 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp29_ = row;
#line 97 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp30_ = database_table_db;
#line 97 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp31_ = sqlite3_last_insert_rowid (_tmp30_);
#line 97 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	event_id_init (&_tmp29_->event_id, _tmp31_);
#line 98 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp32_ = row;
#line 98 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (_tmp32_->name);
#line 98 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp32_->name = NULL;
#line 99 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp33_ = row;
#line 99 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp34_ = primary_source_id;
#line 99 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp35_ = g_strdup (_tmp34_);
#line 99 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (_tmp33_->primary_source_id);
#line 99 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp33_->primary_source_id = _tmp35_;
#line 100 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp36_ = row;
#line 100 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp37_ = time_created;
#line 100 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp36_->time_created = _tmp37_;
#line 101 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp38_ = row;
#line 101 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp39_ = comment;
#line 101 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp40_ = g_strdup (_tmp39_);
#line 101 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (_tmp38_->comment);
#line 101 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp38_->comment = _tmp40_;
#line 103 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = row;
#line 103 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 103 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 938 "EventTable.c"
}


void event_table_create_from_row (EventTable* self, EventRow* row, EventID* result) {
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	EventRow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GDestroyNotify _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	sqlite3_stmt* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	sqlite3_stmt* _tmp14_ = NULL;
	EventRow* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GDestroyNotify _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	sqlite3_stmt* _tmp21_ = NULL;
	EventRow* _tmp22_ = NULL;
	time_t _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	sqlite3_stmt* _tmp26_ = NULL;
	EventRow* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GDestroyNotify _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	sqlite3_stmt* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	sqlite3* _tmp38_ = NULL;
	gint64 _tmp39_ = 0LL;
	EventID _tmp40_ = {0};
#line 109 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_if_fail (IS_EVENT_TABLE (self));
#line 109 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_if_fail (IS_EVENT_ROW (row));
#line 111 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = database_table_db;
#line 111 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO EventTable (name, primary_photo_id, primary_source_id, tim" \
"e_created, comment) VALUES (?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
#line 111 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 111 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	stmt = _tmp1_;
#line 111 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp2_;
#line 113 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = res;
#line 113 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 115 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = stmt;
#line 115 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = row;
#line 115 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp6_ = _tmp5_->name;
#line 115 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 115 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp8_ = g_free;
#line 115 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp9_ = sqlite3_bind_text (_tmp4_, 1, _tmp7_, -1, _tmp8_);
#line 115 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp9_;
#line 116 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp10_ = res;
#line 116 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp10_ == SQLITE_OK, "res == Sqlite.OK");
#line 117 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp11_ = stmt;
#line 117 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp12_ = sqlite3_bind_int64 (_tmp11_, 2, PHOTO_ID_INVALID);
#line 117 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp12_;
#line 118 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp13_ = res;
#line 118 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 119 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp14_ = stmt;
#line 119 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp15_ = row;
#line 119 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp16_ = _tmp15_->primary_source_id;
#line 119 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 119 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp18_ = g_free;
#line 119 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp19_ = sqlite3_bind_text (_tmp14_, 3, _tmp17_, -1, _tmp18_);
#line 119 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp19_;
#line 120 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp20_ = res;
#line 120 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp20_ == SQLITE_OK, "res == Sqlite.OK");
#line 121 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp21_ = stmt;
#line 121 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp22_ = row;
#line 121 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp23_ = _tmp22_->time_created;
#line 121 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp24_ = sqlite3_bind_int64 (_tmp21_, 4, (gint64) _tmp23_);
#line 121 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp24_;
#line 122 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp25_ = res;
#line 122 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp25_ == SQLITE_OK, "res == Sqlite.OK");
#line 123 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp26_ = stmt;
#line 123 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp27_ = row;
#line 123 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp28_ = _tmp27_->comment;
#line 123 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 123 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp30_ = g_free;
#line 123 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp31_ = sqlite3_bind_text (_tmp26_, 5, _tmp29_, -1, _tmp30_);
#line 123 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp31_;
#line 124 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp32_ = res;
#line 124 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp32_ == SQLITE_OK, "res == Sqlite.OK");
#line 126 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp33_ = stmt;
#line 126 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp34_ = sqlite3_step (_tmp33_);
#line 126 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp34_;
#line 127 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp35_ = res;
#line 127 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp35_ != SQLITE_DONE) {
#line 1090 "EventTable.c"
		gint _tmp36_ = 0;
		EventID _tmp37_ = {0};
#line 128 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp36_ = res;
#line 128 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		database_table_fatal ("Event create_from_row", _tmp36_);
#line 130 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		event_id_init (&_tmp37_, EVENT_ID_INVALID);
#line 130 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		*result = _tmp37_;
#line 130 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_sqlite3_finalize0 (stmt);
#line 130 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		return;
#line 1105 "EventTable.c"
	}
#line 133 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp38_ = database_table_db;
#line 133 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp39_ = sqlite3_last_insert_rowid (_tmp38_);
#line 133 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	event_id_init (&_tmp40_, _tmp39_);
#line 133 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	*result = _tmp40_;
#line 133 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 133 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return;
#line 1119 "EventTable.c"
}


EventRow* event_table_get_row (EventTable* self, EventID* event_id) {
	EventRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	sqlite3_stmt* _tmp4_ = NULL;
	EventID _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	sqlite3_stmt* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	EventRow* row = NULL;
	EventRow* _tmp11_ = NULL;
	EventRow* _tmp12_ = NULL;
	EventID _tmp13_ = {0};
	EventRow* _tmp14_ = NULL;
	sqlite3_stmt* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	EventRow* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	EventRow* _tmp26_ = NULL;
	sqlite3_stmt* _tmp27_ = NULL;
	gint64 _tmp28_ = 0LL;
	sqlite3_stmt* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	EventRow* _tmp32_ = NULL;
	sqlite3_stmt* _tmp33_ = NULL;
	gint64 _tmp34_ = 0LL;
	EventRow* _tmp35_ = NULL;
	sqlite3_stmt* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
#line 136 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
#line 136 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 138 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = database_table_db;
#line 138 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT name, primary_photo_id, primary_source_id, time_created, commen" \
"t FROM EventTable WHERE id=?", -1, &_tmp1_, NULL);
#line 138 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 138 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	stmt = _tmp1_;
#line 138 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp2_;
#line 140 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = res;
#line 140 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 142 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = stmt;
#line 142 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = *event_id;
#line 142 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp6_ = _tmp5_.id;
#line 142 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp7_ = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 142 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp7_;
#line 143 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp8_ = res;
#line 143 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 145 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp9_ = stmt;
#line 145 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp10_ = sqlite3_step (_tmp9_);
#line 145 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp10_ != SQLITE_ROW) {
#line 146 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		result = NULL;
#line 146 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_sqlite3_finalize0 (stmt);
#line 146 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		return result;
#line 1206 "EventTable.c"
	}
#line 148 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp11_ = event_row_new ();
#line 148 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	row = _tmp11_;
#line 149 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp12_ = row;
#line 149 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp13_ = *event_id;
#line 149 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp12_->event_id = _tmp13_;
#line 150 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp14_ = row;
#line 150 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp15_ = stmt;
#line 150 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp16_ = sqlite3_column_text (_tmp15_, 0);
#line 150 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp17_ = g_strdup (_tmp16_);
#line 150 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (_tmp14_->name);
#line 150 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp14_->name = _tmp17_;
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp19_ = row;
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp20_ = _tmp19_->name;
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp20_ != NULL) {
#line 1236 "EventTable.c"
		EventRow* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp21_ = row;
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp22_ = _tmp21_->name;
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp23_ = strlen (_tmp22_);
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp24_ = _tmp23_;
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp18_ = _tmp24_ == 0;
#line 1251 "EventTable.c"
	} else {
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp18_ = FALSE;
#line 1255 "EventTable.c"
	}
#line 151 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp18_) {
#line 1259 "EventTable.c"
		EventRow* _tmp25_ = NULL;
#line 152 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp25_ = row;
#line 152 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_g_free0 (_tmp25_->name);
#line 152 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp25_->name = NULL;
#line 1267 "EventTable.c"
	}
#line 153 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp26_ = row;
#line 153 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp27_ = stmt;
#line 153 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp28_ = sqlite3_column_int64 (_tmp27_, 1);
#line 153 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp29_ = stmt;
#line 153 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp30_ = sqlite3_column_text (_tmp29_, 2);
#line 153 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp31_ = event_table_source_id_upgrade (self, _tmp28_, _tmp30_);
#line 153 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (_tmp26_->primary_source_id);
#line 153 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp26_->primary_source_id = _tmp31_;
#line 154 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp32_ = row;
#line 154 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp33_ = stmt;
#line 154 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp34_ = sqlite3_column_int64 (_tmp33_, 3);
#line 154 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp32_->time_created = (time_t) _tmp34_;
#line 155 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp35_ = row;
#line 155 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp36_ = stmt;
#line 155 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp37_ = sqlite3_column_text (_tmp36_, 4);
#line 155 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp38_ = g_strdup (_tmp37_);
#line 155 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (_tmp35_->comment);
#line 155 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp35_->comment = _tmp38_;
#line 157 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = row;
#line 157 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 157 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 1311 "EventTable.c"
}


void event_table_remove (EventTable* self, EventID* event_id, GError** error) {
	EventID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	GError * _inner_error_ = NULL;
#line 160 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_if_fail (IS_EVENT_TABLE (self));
#line 160 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_if_fail (event_id != NULL);
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = *event_id;
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = _tmp0_.id;
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, &_inner_error_);
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			g_propagate_error (error, _inner_error_);
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			return;
#line 1337 "EventTable.c"
		} else {
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			g_clear_error (&_inner_error_);
#line 161 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			return;
#line 1345 "EventTable.c"
		}
	}
}


GeeArrayList* event_table_get_events (EventTable* self) {
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_ = NULL;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GeeArrayList* event_rows = NULL;
	GeeArrayList* _tmp4_ = NULL;
#line 164 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
#line 166 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = database_table_db;
#line 166 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, name, primary_photo_id, primary_source_id, time_created, co" \
"mment FROM EventTable", -1, &_tmp1_, NULL);
#line 166 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 166 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	stmt = _tmp1_;
#line 166 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	res = _tmp2_;
#line 168 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = res;
#line 168 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 170 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_EVENT_ROW, (GBoxedCopyFunc) event_row_ref, event_row_unref, NULL, NULL, NULL);
#line 170 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	event_rows = _tmp4_;
#line 1381 "EventTable.c"
	{
		gboolean _tmp5_ = FALSE;
#line 171 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp5_ = TRUE;
#line 171 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		while (TRUE) {
#line 1388 "EventTable.c"
			sqlite3_stmt* _tmp6_ = NULL;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			EventRow* row = NULL;
			EventRow* _tmp11_ = NULL;
			EventRow* _tmp12_ = NULL;
			sqlite3_stmt* _tmp13_ = NULL;
			gint64 _tmp14_ = 0LL;
			EventRow* _tmp15_ = NULL;
			sqlite3_stmt* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			EventRow* _tmp19_ = NULL;
			sqlite3_stmt* _tmp20_ = NULL;
			gint64 _tmp21_ = 0LL;
			sqlite3_stmt* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			EventRow* _tmp25_ = NULL;
			sqlite3_stmt* _tmp26_ = NULL;
			gint64 _tmp27_ = 0LL;
			EventRow* _tmp28_ = NULL;
			sqlite3_stmt* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			GeeArrayList* _tmp32_ = NULL;
			EventRow* _tmp33_ = NULL;
#line 171 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			if (!_tmp5_) {
#line 1418 "EventTable.c"
			}
#line 171 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp5_ = FALSE;
#line 172 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp6_ = stmt;
#line 172 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp7_ = sqlite3_step (_tmp6_);
#line 172 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			res = _tmp7_;
#line 173 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp8_ = res;
#line 173 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			if (_tmp8_ == SQLITE_DONE) {
#line 174 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				break;
#line 1434 "EventTable.c"
			} else {
				gint _tmp9_ = 0;
#line 175 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				_tmp9_ = res;
#line 175 "/home/jens/Source/shotwell/src/db/EventTable.vala"
				if (_tmp9_ != SQLITE_ROW) {
#line 1441 "EventTable.c"
					gint _tmp10_ = 0;
#line 176 "/home/jens/Source/shotwell/src/db/EventTable.vala"
					_tmp10_ = res;
#line 176 "/home/jens/Source/shotwell/src/db/EventTable.vala"
					database_table_fatal ("get_events", _tmp10_);
#line 178 "/home/jens/Source/shotwell/src/db/EventTable.vala"
					break;
#line 1449 "EventTable.c"
				}
			}
#line 181 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp11_ = event_row_new ();
#line 181 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			row = _tmp11_;
#line 183 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp12_ = row;
#line 183 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp13_ = stmt;
#line 183 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp14_ = sqlite3_column_int64 (_tmp13_, 0);
#line 183 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			event_id_init (&_tmp12_->event_id, _tmp14_);
#line 184 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp15_ = row;
#line 184 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp16_ = stmt;
#line 184 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp17_ = sqlite3_column_text (_tmp16_, 1);
#line 184 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 184 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_g_free0 (_tmp15_->name);
#line 184 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp15_->name = _tmp18_;
#line 185 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp19_ = row;
#line 185 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp20_ = stmt;
#line 185 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp21_ = sqlite3_column_int64 (_tmp20_, 2);
#line 185 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp22_ = stmt;
#line 185 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp23_ = sqlite3_column_text (_tmp22_, 3);
#line 185 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp24_ = event_table_source_id_upgrade (self, _tmp21_, _tmp23_);
#line 185 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_g_free0 (_tmp19_->primary_source_id);
#line 185 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp19_->primary_source_id = _tmp24_;
#line 186 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp25_ = row;
#line 186 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp26_ = stmt;
#line 186 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp27_ = sqlite3_column_int64 (_tmp26_, 4);
#line 186 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp25_->time_created = (time_t) _tmp27_;
#line 187 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp28_ = row;
#line 187 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp29_ = stmt;
#line 187 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp30_ = sqlite3_column_text (_tmp29_, 5);
#line 187 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 187 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_g_free0 (_tmp28_->comment);
#line 187 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp28_->comment = _tmp31_;
#line 189 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp32_ = event_rows;
#line 189 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_tmp33_ = row;
#line 189 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp33_);
#line 171 "/home/jens/Source/shotwell/src/db/EventTable.vala"
			_event_row_unref0 (row);
#line 1520 "EventTable.c"
		}
	}
#line 192 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = event_rows;
#line 192 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 192 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 1529 "EventTable.c"
}


gboolean event_table_rename (EventTable* self, EventID* event_id, const gchar* name) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	EventID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	gboolean _tmp5_ = FALSE;
#line 195 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), FALSE);
#line 195 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = name;
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp1_ != NULL) {
#line 1548 "EventTable.c"
		const gchar* _tmp2_ = NULL;
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp2_ = name;
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp0_ = _tmp2_;
#line 1554 "EventTable.c"
	} else {
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp0_ = "";
#line 1558 "EventTable.c"
	}
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = *event_id;
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = _tmp3_.id;
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_, "name", _tmp0_);
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = _tmp5_;
#line 196 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 1570 "EventTable.c"
}


gchar* event_table_get_name (EventTable* self, EventID* event_id) {
	gchar* result = NULL;
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	sqlite3_stmt* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gchar* name = NULL;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp14_ = NULL;
#line 199 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
#line 199 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 201 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = *event_id;
#line 201 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = _tmp0_.id;
#line 201 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "name", &_tmp2_);
#line 201 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 201 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	stmt = _tmp2_;
#line 201 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (!_tmp3_) {
#line 202 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		result = NULL;
#line 202 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_sqlite3_finalize0 (stmt);
#line 202 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		return result;
#line 1611 "EventTable.c"
	}
#line 204 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = stmt;
#line 204 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, 0);
#line 204 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 204 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	name = _tmp6_;
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp9_ = name;
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp9_ != NULL) {
#line 1625 "EventTable.c"
		const gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp10_ = name;
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp11_ = strlen (_tmp10_);
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp12_ = _tmp11_;
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp8_ = _tmp12_ > 0;
#line 1637 "EventTable.c"
	} else {
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp8_ = FALSE;
#line 1641 "EventTable.c"
	}
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp8_) {
#line 1645 "EventTable.c"
		const gchar* _tmp13_ = NULL;
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp13_ = name;
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp7_ = _tmp13_;
#line 1651 "EventTable.c"
	} else {
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp7_ = NULL;
#line 1655 "EventTable.c"
	}
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp14_ = g_strdup (_tmp7_);
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = _tmp14_;
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_g_free0 (name);
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 206 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 1667 "EventTable.c"
}


gchar* event_table_get_primary_source_id (EventTable* self, EventID* event_id) {
	gchar* result = NULL;
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	sqlite3_stmt* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	sqlite3_stmt* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
#line 209 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), NULL);
#line 209 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 211 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = *event_id;
#line 211 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = _tmp0_.id;
#line 211 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "primary_source_id", &_tmp2_);
#line 211 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 211 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	stmt = _tmp2_;
#line 211 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (!_tmp3_) {
#line 212 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		result = NULL;
#line 212 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_sqlite3_finalize0 (stmt);
#line 212 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		return result;
#line 1703 "EventTable.c"
	}
#line 214 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = stmt;
#line 214 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, 0);
#line 214 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 214 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = _tmp6_;
#line 214 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 214 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 1717 "EventTable.c"
}


gboolean event_table_set_primary_source_id (EventTable* self, EventID* event_id, const gchar* primary_source_id) {
	gboolean result = FALSE;
	EventID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 217 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), FALSE);
#line 217 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 217 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (primary_source_id != NULL, FALSE);
#line 218 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = *event_id;
#line 218 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = _tmp0_.id;
#line 218 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp2_ = primary_source_id;
#line 218 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "primary_source_id", _tmp2_);
#line 218 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = _tmp3_;
#line 218 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 1745 "EventTable.c"
}


time_t event_table_get_time_created (EventTable* self, EventID* event_id) {
	time_t result = 0;
	sqlite3_stmt* stmt = NULL;
	EventID _tmp0_ = {0};
	gint64 _tmp1_ = 0LL;
	sqlite3_stmt* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	sqlite3_stmt* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
#line 221 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), 0);
#line 221 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (event_id != NULL, 0);
#line 223 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp0_ = *event_id;
#line 223 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = _tmp0_.id;
#line 223 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "time_created", &_tmp2_);
#line 223 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 223 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	stmt = _tmp2_;
#line 223 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (!_tmp3_) {
#line 224 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		result = (time_t) 0;
#line 224 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_sqlite3_finalize0 (stmt);
#line 224 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		return result;
#line 1780 "EventTable.c"
	}
#line 226 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = stmt;
#line 226 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = sqlite3_column_int64 (_tmp4_, 0);
#line 226 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = (time_t) _tmp5_;
#line 226 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_sqlite3_finalize0 (stmt);
#line 226 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 1792 "EventTable.c"
}


gboolean event_table_set_comment (EventTable* self, EventID* event_id, const gchar* new_comment) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	EventID _tmp3_ = {0};
	gint64 _tmp4_ = 0LL;
	gboolean _tmp5_ = FALSE;
#line 229 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (IS_EVENT_TABLE (self), FALSE);
#line 229 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 229 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	g_return_val_if_fail (new_comment != NULL, FALSE);
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp1_ = new_comment;
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	if (_tmp1_ != NULL) {
#line 1813 "EventTable.c"
		const gchar* _tmp2_ = NULL;
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp2_ = new_comment;
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp0_ = _tmp2_;
#line 1819 "EventTable.c"
	} else {
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
		_tmp0_ = "";
#line 1823 "EventTable.c"
	}
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp3_ = *event_id;
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp4_ = _tmp3_.id;
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	_tmp5_ = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp4_, "comment", _tmp0_);
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	result = _tmp5_;
#line 230 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	return result;
#line 1835 "EventTable.c"
}


static void event_table_class_init (EventTableClass * klass) {
#line 33 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	event_table_parent_class = g_type_class_peek_parent (klass);
#line 33 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	((DatabaseTableClass *) klass)->finalize = event_table_finalize;
#line 1844 "EventTable.c"
}


static void event_table_instance_init (EventTable * self) {
}


static void event_table_finalize (DatabaseTable* obj) {
	EventTable * self;
#line 33 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EVENT_TABLE, EventTable);
#line 33 "/home/jens/Source/shotwell/src/db/EventTable.vala"
	DATABASE_TABLE_CLASS (event_table_parent_class)->finalize (obj);
#line 1858 "EventTable.c"
}


GType event_table_get_type (void) {
	static volatile gsize event_table_type_id__volatile = 0;
	if (g_once_init_enter (&event_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EventTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) event_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EventTable), 0, (GInstanceInitFunc) event_table_instance_init, NULL };
		GType event_table_type_id;
		event_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "EventTable", &g_define_type_info, 0);
		g_once_init_leave (&event_table_type_id__volatile, event_table_type_id);
	}
	return event_table_type_id__volatile;
}



