# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/hub_options.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: SiSU information Structuring Universe, command line options
    parsing

=end
module SiSU_Commandline
  begin
    require 'pathname'
  rescue LoadError
    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
      error('pathname NOT FOUND (LoadError)')
  end
  require_relative 'se'                                 # se.rb
  require_relative 'dp_make'                            # dp_make.rb
  class HeaderCommon
    def sisu_document_make_instructions(make_instruct_array=:nil)
      @pagenew=
        @pagebreak=
        @pageline=
        @toc=
        @lv1=@lv2=@lv3=@lv4=@lv5=@lv6=
        @num_top=
        @i18n=
        @man_section=
        @emphasis_set_to=
        @bold_match_list=
        @italics_match_list=
        @substitution_match_list=
        @footer_links=
        @home_button_links=
        @links=
        nil
      make_instruct_array=make_instruct_array==:nil \
      ? SiSU_Env::GetInit.new.sisu_document_make.makefile_read
      : make_instruct_array
      @makeset=false
      if make_instruct_array
        make_instruct_array.each do |para|                                     #% scan document
          if para =~/^(?:@make:|@links:)[+-]?\s/
            case para
            when /^@make:(.+)/m                                                #% header processing - make
              @env=SiSU_Env::InfoEnv.new
              @make=SiSU_Param_Make::MdMake.new($1.strip,@opt,@env).make
              makes=SiSU_Param_Make::MakeHead.new(@make).make_instruct
              @makeset=true
              @pagenew=makes[:pagenew]
              @pagebreak=makes[:pagenew]
              @pageline=makes[:pageline]
              @toc=makes[:toc]
              @lv1=makes[:lv1]
              @lv2=makes[:lv2]
              @lv3=makes[:lv3]
              @lv4=makes[:lv4]
              @lv5=makes[:lv5]
              @lv6=makes[:lv6]
              @num_top=makes[:num_top]
              @i18n=makes[:i18n]
              @man_section=makes[:man_section]
              @emphasis_set_to=makes[:emphasis_set_to]
              @bold_match_list=makes[:bold_match_list]
              @italics_match_list=makes[:italics_match_list]
              @substitution_match_list=makes[:substitution_match_list]
              @footer_links=makes[:footer_links]
              @home_button_links=makes[:home_button_links]
              @home_button_image=makes[:home_button_image]
              @cover_image=makes[:cover_image]
            when /^@links:(.+)/m                                                #% header processing - make
              make_links=SiSU_Param::Parameters::MdMake.new($1.strip,@opt,@env).make_links
              @links,@links_append=make_links.links,make_links.append?
            end
          end
        end                                                                    #% here endeth the common header loop
      end
      { makeset: @makeset,
        pagenew: @pagenew,
        pagebreak: @pagebreak,
        pageline: @pageline,
        toc: @toc,
        lv1: @lv1,
        lv2: @lv2,
        lv3: @lv3,
        lv4: @lv4,
        lv5: @lv5,
        lv6: @lv6,
        num_top: @num_top,
        i18n: @i18n,
        man_section: @man_section,
        emphasis_set_to: @emphasis_set_to,
        bold_match_list: @bold_match_list,
        italics_match_list: @italics_match_list,
        substitution_match_list: @substitution_match_list,
        footer_links: @footer_links,
        home_button_links: @home_button_links,
        home_button_image: @home_button_image,
        cover_image: @cover_image,
        links: @links,
        links_append: @links_append
      }
    end
  end
  class Options
    attr_accessor :selections,:opt_ch,:act,:dir_structure_by,:lingual,:f_pths,:files,:files_mod,:call_path,:base_path,:base_stub,:sub_location,:image_src_path,:paths,:lngs,:f_pth,:pth,:fno,:fns,:fnb,:fnc,:fng,:fncb,:lng,:lng_base,:what,:make_instructions,:make_instructions_pod
    @@act=nil
    def initialize(a,call_path)
      @opt_ch=@f_pth=@pth=@fno=@fns=@fnb=@fnc=@fng=@fncb=@what=@lng=@lng_base=@call_path=@base_path=@base_stub=@image_src_path=@sub_location=''
      @f_pths,@files,@files_mod,@paths,@select_arr,@act=Array.new(5){[]}
      @select_str=nil
      @env=SiSU_Env::InfoEnv.new
      @lng_base=@env.language_default_set
      @dir_structure_by=SiSU_Env::EnvCall.new.output_dir_structure.by?
      @lingual=SiSU_Env::EnvCall.new.mono_multi_lingual?
      @call_path=call_path
      pth=SiSU_Utils::Path.new(call_path)
      @base_path=pth.base_markup
      @base_stub=pth.base_markup_stub
      @image_src_path=pth.image_src
      @a=sisu_glob_rules(a)
      @a.freeze
      @make_instructions=HeaderCommon.new.sisu_document_make_instructions
      @make_instructions_pod=nil
      init
    end
    def find_all(find_flag,opt)
      if find_flag
        x=Dir.glob('*.ss[tm]')
        Px[:lng_lst].each do |d|
          if FileTest.directory?(d)
            x << Dir.glob("#{d}/*.ss[tm]")
          end
        end
        x=x.flatten
        opt + x
      end
    end
    def find_select(find_flag,opt)
      if find_flag
        x=[]
        if opt.inspect =~/"[a-zA-Z][a-zA-Z0-9._-]+?"/
          opt.each do |g|
            x <<=if g =~/.ss[tm]/
              Dir.glob("*#{g}")
            else
              Dir.glob("*#{g}*.ss[tm]")
            end
            Px[:lng_lst].each do |d|
              if FileTest.directory?(d)
                x <<=if g =~/.ss[tm]/
                  Dir.glob("#{d}/*#{g}")
                else
                  Dir.glob("#{d}/*#{g}*.ss[tm]")
                end
              end
            end
          end
        end
        x.flatten
      end
    end
    def sisu_glob_rules(a)
      a=if a.inspect =~/"-[A-Za-z0-9]*[fG]/ \
      or a.inspect =~/"--find"|"--glob"/
        b,f=[],[]
        find_flag=false
        a.each do |y|
          if y =~ /^-/
            if y =~/^-/ \
            && y =~/[fG]|--find|--glob/
              find_flag=true
            end
            b << y
          end
          if find_flag \
          && y !~ /^-/ \
          && y =~ /\S+/
            if y !~/\//
              f << y
            else
              find_flag=false
              puts %{sub-directories "#{y}" cannot be provided for --find or --glob at this time}
            end
          end
        end
        r=Px[:lng_lst_rgx].gsub(/\|#{lng_base}\|/,'|')
        @lang_regx=%r{(?:#{r})}
        if find_flag
          (f.length > 0) \
          ? (b + find_select(find_flag,f))
          : find_all(find_flag,b)
        elsif a.inspect =~/"(?:-\S+?|--\S+?)"/ \
        && a.inspect =~/"#{@lang_regx}\/?"/ \
        && a.inspect =~/"#{lng_base}\/\S+?\.ss[tm]"/
          init_selected_lang_dirs(a)
        else b
        end
      else a
      end
    end
    def init_selected_lang_dirs(a)
      @z=[]
      a.each do |y|
        if y =~/^#{lng_base}\/(\S+?\.ss[tm])$/
          @fn=$1
          @z << y
        elsif y =~/^#{@lang_regx}\/?$/
          @z << "#{y}/#{@fn}"
        else @z << y
        end
      end
      @z
    end
    def init
      a=@a
      s=expand_numeric_shortcuts(a)
      q=set_files_and_paths_and_general_extract(s)
      files=(q[:files].length > 0) ? :true : :false
      @select_arr=opt_cmd_and_mod_adjust(q[:opt_ch],q[:selections],files)
      if a.length > 0
        @what=q[:what] unless q[:what].empty?
        @paths = q[:paths]
        @files = q[:files]
        @f_pths = q[:f_pths]
        @lngs = q[:lngs]
        if @files.length > 0 \
        and @opt_ch.empty? \
        and @select_arr.length==0 #% if no other action called on filename given, default is sisu --v5 -0 [filename(s)] configured as flag default
          shortcut=SiSU_Env::InfoProcessingFlag.new
          @select_arr=['--v5']
          @select_arr << shortcut.act_0.arr #+ ' --dal'
        end
        if @select_arr.inspect =~/--verbose/ \
        && @opt_ch !~/-[ku]*v[ku]*$/
          SiSU_Screen::Ansi.new(
            @opt_ch,
            "\tsisu " + @opt_ch +  ' ' + @select_arr.join(' ') + ' ' + @files.join(' ') + "\n"
          ).print_brown
        end
      end
      @@act ? @act=@@act : @@act=@act=opt_act
      self
    end
    def sisu_document_make_pod
      def makefile_name
        SiSU_Env::GetInit.new.sisu_document_make.makefile_name
      end
      def makefile(pod_make_path)
        "#{pod_make_path}/#{makefile_name}"
      end
      def makefile_read(pod_make_path)
        if FileTest.file?(makefile(pod_make_path))
          sisu_doc_makefile=IO.read(makefile(pod_make_path), mode: 'r:utf-8')
          sisu_doc_makefile.split(/\s*\n\s*\n/m)
        else nil
        end
      end
      self
    end
    def set_files_and_paths_and_general_extract(s)
      c,w='',''
      m,f,pth,lng,lngs=[],[],[],[],[]
      lng_is=''
      a=(s.nil?) \
      ? ['-v']
      : s.split(/\s+/)
      r_l=Px[:lng_lst].join('|')
      a.uniq.each do |x|
        if x =~/^-[a-z0-5]+/i \
        or x =~/^--\S+/
          if x =~/^-([a-z0-5]+)/i
            c << $1
          end
          if x =~/^--\S+/
            m << x
          end
        elsif x =~ /(?:\.(?:(?:-|ssm\.)?sst(?:\.xml)?|ssm|ssi|sx[sdn]\.xml|s[1-3]|kdi|ssp)|\S+?\.ss[mt]\.(?:txz|zip)|sisupod\.(?:txz|zip))$/
          if x =~/\S+?\.ss[mt]\.(?:txz|zip)|sisupod\.(?:txz|zip)/
            if x =~/^(?:https?|file):\/\/\S+/ #\
            end
            pwd=Dir.pwd
            fn_pod=x.gsub(/([^\/]+)\.txz$/,'\1')
            fullname=@env.processing_path.processing + '/sisupod/' + fn_pod
            pt=Pathname.new(fullname)
            FileUtils::mkdir_p(pt.to_s)
            pod_make_path=fullname + '/sisupod/doc/_sisu'
            make_instruct_array=sisu_document_make_pod.makefile_read(pod_make_path)
            @make_instructions_pod=
              HeaderCommon.new.sisu_document_make_instructions(make_instruct_array)
            Dir.chdir(pt.realpath)
            system("
              chdir #{fullname}
              tar xaf #{pwd}/#{x}
              chdir #{pwd}
            ")
            Dir.chdir(pt.realpath.to_s + '/sisupod/doc')
            r=Px[:lng_lst_rgx]
            Dir.entries("#{fullname}/sisupod/doc").each do |d_lng|
              if d_lng =~/^(?:#{r})$/
                Dir.chdir(pt.realpath.to_s + "/sisupod/doc/#{d_lng}")
                filenames=Dir.glob("*.ss[mt]")
                filenames.each do |fn|
                  f_pths << {
                    pth: "#{fullname}/sisupod/doc/#{d_lng}",
                    f: "#{fn}",
                    pth_stub: 'doc',
                    lng: d_lng,
                    lng_is: d_lng,
                    url_base: '',
                    url: ''
                  }
                  Dir.chdir(pwd)
                  f << fn
                end
              end
            end
          elsif x =~/^(?:https?|file):\/\/\S+/ \
          and x =~/\S+?\.ss[mt]$/
            r_url=/(http:\/\/\S+?\/\S+?\/src(?:\/(?:#{r_l}))?)\//
            url_base = (x[r_url,1])
            url = x
            y=x.gsub(/http:\/\/\S+?\/\S+?\/src\//,'')
            t=/(#{r_l})\/[^\/]+?\.ss[tm]$/
            l_p = (y[t,1]) \
              ? y[t,1]
              : nil
            lng << l_p
            lngs << if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            r_f=/(?:#{r_l})\/([^\/]+?\.ss[tm])$/
            fn = (y[r_f,1]) \
              ? y[r_f,1]
              : y
            fn=fn.gsub(/\.((?:ssm\.)?sst)/,'.-\1')
            fullname=Dir.pwd + '/' + fn
            pt=Pathname.new(fullname)
            pth << Dir.pwd
            r_u=/.+?\/([^\/]+)(?:\/(?:#{r_l})$|$)/
            lng_is =if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            f_pths << {
              pth: pt.split[0].realpath.to_s,
              f: pt.split[1].to_s,
              pth_stub: pt.split[0].realpath.to_s[r_u,1],
              lng: (pt.split[0].realpath.to_s[t,1]) \
                ? pt.split[0].realpath.to_s[t,1]
                : nil,
              lng_is: lng_is,
              url_base: url_base,
              url: url
            }
            f << fn
          elsif FileTest.file?(x)
            pt=Pathname.new(x)
            pth << pt.split[0].realpath.to_s     #remove?
            f << pt.split[1].to_s                #remove?
            r_u=/.+?\/([^\/]+)(?:\/(?:#{r_l})$|$)/
            t=/.+\/(#{r_l})$/
            l_p = (pt.split[0].realpath.to_s[t,1]) \
              ? pt.split[0].realpath.to_s[t,1]
              : nil
            lngs << lng_is = if l_p
              l_p
            elsif x =~/~(#{r_l})\.ss[tm]/
              $1
            else lng_base
            end
            f_pths << {
              pth: pt.split[0].realpath.to_s,
              f: pt.split[1].to_s,
              pth_stub: pt.split[0].realpath.to_s[r_u,1],
              lng: lng_is,
              lng_is: lng_is,
              url_base: nil,
              url: nil,
            }
          else  puts "file not found: #{x}"
          end
        elsif x =~ /\.termsheet\.rb$/
          (FileTest.file?(x)) \
          ? (f << x)
          : (puts "file not found: #{x}")
        else w=x
          puts "#{x} in #{a.join(' ')}?"
        end
      end
      {
        opt_ch: c,
        selections: m,
        what: w,
        paths: pth,
        files: f,
        f_pths: f_pths,
        lng: lng_is,
        lngs: lngs,
      }
    end
    def expand_numeric_shortcuts(a)
      s=''
      a.each do |x|
        y=case x
        when /0/
          (x=~/^-0\S+/) \
          ? x.gsub(/^-0(\S+)/,'--act0' + ' -\1')
          : x.gsub(/^-0/,'--act0' + ' ')
        when /1/
          (x=~/^-1\S+/) \
          ? x.gsub(/^-1(\S+)/,'--act1' + ' -\1')
          : x.gsub(/^-1/,'--act1' + ' ')
        when /2/
          (x=~/^-2\S+/) \
          ? x.gsub(/^-2(\S+)/,'--act2' + ' -\1')
          : x.gsub(/^-2/,'--act2' + ' ')
        when /3/
          (x=~/^-3\S+/) \
          ? x.gsub(/^-3(\S+)/,'--act3' + ' -\1')
          : x.gsub(/^-3/,'--act3' + ' ')
        when /4/
          (x=~/^-4\S+/) \
          ? x.gsub(/^-4(\S+)/,'--act4' + ' -\1')
          : x.gsub(/^-4/,'--act4' + ' ')
        when /5/
          (x=~/^-5\S+/) \
          ? x.gsub(/^-5(\S+)/,'--act5' + ' -\1')
          : x.gsub(/^-5/,'--act5' + ' ')
        when /6/
          (x=~/^-6\S+/) \
          ? x.gsub(/^-6(\S+)/,'--act6' + ' -\1')
          : x.gsub(/^-6/,'--act6' + ' ')
        when /7/
          (x=~/^-7\S+/) \
          ? x.gsub(/^-7(\S+)/,'--act7' + ' -\1')
          : x.gsub(/^-7/,'--act7' + ' ')
        when /8/
          (x=~/^-8\S+/) \
          ? x.gsub(/^-8(\S+)/,'--act8' + ' -\1')
          : x.gsub(/^-8/,'--act8' + ' ')
        when /9/
          (x=~/^-9\S+/) \
          ? x.gsub(/^-9(\S+)/,'--act9' + ' -\1')
          : x.gsub(/^-9/,'--act9' + ' ')
        else x
        end
        s << " #{y}" unless y.empty?
      end
      s.strip!
    end
    def opt_cmd_and_mod_adjust(ch,select_arr,files)
      select_arr=select_arr.flatten
      sel_init=select_arr.flatten
      shortcut=SiSU_Env::InfoProcessingFlag.new
      if files ==:true
        if not sel_init.empty? \
        and sel_init.inspect =~/"--act[s0-9]?/
          sel_init.each do |s|
            select_arr <<=case s
            when /--act0/ then shortcut.act_0.arr
            when /--act1/ then shortcut.act_1.arr
            when /--act2/ then shortcut.act_2.arr
            when /--act3/ then shortcut.act_3.arr
            when /--act4/ then shortcut.act_4.arr
            when /--act5/ then shortcut.act_5.arr
            when /--act6/ then shortcut.act_6.arr
            when /--act7/ then shortcut.act_7.arr
            when /--act8/ then shortcut.act_8.arr
            when /--act9/ then shortcut.act_9.arr
            when /--act/  then shortcut.act_info
            end
          end
        end
        if not sel_init.empty? \
        and sel_init.inspect =~/"--pdf-/
          select_arr << '--pdf'
          sel_init.each do |s|
            if s =~ /^--pdf-(?:(?:l|landscape)(?:-(?:a4|letter|a5|b5|legal))?|(?:a4|letter|a5|b5|legal)-(?:l|landscape))$/
              select_arr << '--landscape'
            end
            if s =~ /^--pdf-(?:(?:p|portrait)(?:-(?:a4|letter|a5|b5|legal))?|(?:a4|letter|a5|b5|legal)-(?:p|portrait))$/
              select_arr << '--portrait'
            end
            if s =~ /^--pdf(?:-(?:a4|letter|a5|b5|legal)(?:-(?:[lp]|landscape|portrait))?|(?:-(?:[lp]|landscape|portrait))(?:-(?:a4|letter|a5|b5|legal)))$/
              if s =~ /^--pdf(?:-a4(?:-(?:[lp]|landscape|portrait))?|(?:-(?:[lp]|landscape|portrait))-a4)$/
                select_arr << '--papersize-a4'
              end
              if s =~ /^--pdf(?:-a5(?:-(?:[lp]|landscape|portrait))?|(?:-(?:[lp]|landscape|portrait))-a5)$/
                select_arr << '--papersize-a5'
              end
              if s =~ /^--pdf(?:-b5(?:-(?:[lp]|landscape|portrait))?|(?:-(?:[lp]|landscape|portrait))-b5)$/
                select_arr << '--papersize-b5'
              end
              if s =~ /^--pdf(?:-letter(?:-(?:[lp]|landscape|portrait))?|(?:-(?:[lp]|landscape|portrait))-letter)$/
                select_arr << '--papersize-letter'
              end
              if s =~ /^--pdf(?:-legal(?:-(?:[lp]|landscape|portrait))?|(?:-(?:[lp]|landscape|portrait))-legal)$/
                select_arr << '--papersize-legal'
              end
            end
          end
          select_arr=select_arr.uniq
        end
        if ch.empty? \
        and sel_init.length == 0
          select_arr << shortcut.act_0.arr ################ & --flag empty
        elsif not ch.empty?
          if ch =~/c/ then select_arr << '--color-toggle'
            ch=ch.gsub(/[c]/,'')
          end
          if ch =~/k/ then select_arr << '--color-off'
            ch=ch.gsub(/[k]/,'')
          end
          if ch =~/C/ then select_arr << '--config'
            ch=ch.gsub(/[C]+/,'')
          end
          if ch =~/m/ then select_arr << '--dal'
            ch=ch.gsub(/[m]/,'')
          end
          if ch =~/t/ then select_arr << '--txt'
            ch=ch.gsub(/[t]/,'')
          end
          if ch =~/h/ then select_arr << '--html'
            ch=ch.gsub(/[h]/,'')
          end
          if ch =~/e/ then select_arr << '--epub'
            ch=ch.gsub(/[e]/,'')
          end
          if ch =~/o/ then select_arr << '--odt'
            ch=ch.gsub(/[o]/,'')
          end
          if ch =~/d/ then select_arr << '--docbook'
            ch=ch.gsub(/[d]/,'')
          end
          if ch =~/p/ then select_arr << '--pdf'
            ch=ch.gsub(/[p]/,'')
          end
          if ch =~/w/ then select_arr << '--concordance'
            ch=ch.gsub(/[w]/,'')
          end
          if ch =~/i/ then select_arr << '--manpage'
            ch=ch.gsub(/[i]/,'')
          end
          if ch =~/I/ then select_arr << '--texinfo'
            ch=ch.gsub(/[I]/,'')
          end
          if ch =~/b/ then select_arr << '--xhtml'
            ch=ch.gsub(/[b]/,'')
          end
          if ch =~/x/ then select_arr << '--xml-sax'
            ch=ch.gsub(/[x]/,'')
          end
          if ch =~/X/ then select_arr << '--xml-dom'
            ch=ch.gsub(/[X]/,'')
          end
          if ch =~/j/ then select_arr << '--images'
            ch=ch.gsub(/[j]/,'')
          end
          if ch =~/N/ then select_arr << '--digests'
            ch=ch.gsub(/[N]/,'')
          end
          if ch =~/P/ then select_arr << '--po4a'
            ch=ch.gsub(/[P]/,'')
          end
          if ch =~/d/ then select_arr << '--sqlite'
            ch=ch.gsub(/[d]/,'')
          end
          if ch =~/D/ then select_arr << '--pg'
            ch=ch.gsub(/[D]/,'')
          end
          if ch =~/Q/ then select_arr << '--qrcode'
            ch=ch.gsub(/[Q]/,'')
          end
          if ch =~/s/ then select_arr << '--source'
            ch=ch.gsub(/[s]/,'')
          end
          if ch =~/S/ then select_arr << '--sisupod'
            ch=ch.gsub(/[S]/,'')
          end
          if ch =~/m/ then select_arr << '--manifest'
            ch=ch.gsub(/[m]/,'')
          end
          if ch =~/R/ then select_arr << '--rsync'
            ch=ch.gsub(/[R]/,'')
          end
          if ch =~/r/ then select_arr << '--scp'
            ch=ch.gsub(/[r]/,'')
          end
          if ch =~/g/ then select_arr << '--git'
            ch=ch.gsub(/[g]/,'')
          end
          if ch =~/U/ then select_arr << '--urls'
            ch=ch.gsub(/[u]/,'')
          end
          if ch =~/Z/ then select_arr << '--zap'
            ch=ch.gsub(/[Z]/,'')
          end
          if ch =~/F/ then select_arr << '--sample-search-form'
            ch=ch.gsub(/[F]/,'')
          end
          if ch =~/W/ then select_arr << '--webrick'
            ch=ch.gsub(/[w]/,'')
          end
          if ch =~/M/ then select_arr << '--maintenance'
            ch=ch.gsub(/[M]/,'')
          end
          if ch =~/V/ then select_arr << '--very-verbose'
            ch=ch.gsub(/[V]/,'')
          end
          if ch =~/v/ then select_arr << '--verbose'
            ch=ch.gsub(/[v]/,'')
          end
          if ch =~/q/ then select_arr << '--quiet'
            ch=ch.gsub(/[q]/,'')
          end
          if select_arr.inspect !~/--urls/ \
          and select_arr.inspect \
          !~/"--harvest/
            select_arr << '--urls'
          end
          if select_arr.inspect !~/--dal/ \
          and select_arr.inspect =~/txt|text|html|odt|epub|docbook|xml|pdf|manpage|texinfo|concordance|qrcode|source|sisupod|pg|sqlite|zap/
            select_arr << '--dal'
          end
          if select_arr.inspect !~/--manifest/ \
          and select_arr.inspect =~/txt|text|html|odt|epub|docbook|xml|pdf|manpage|texinfo|concordance|qrcode|source|sisupod|pg|sqlite|zap/
            select_arr << '--manifest'
          end
          if select_arr.inspect !~/--images/ \
          and select_arr.inspect =~/html|odt|docbook|xml|qrcode/
            select_arr << '--images'
          end
        end
      else
        if not sel_init.empty? \
        and sel_init.inspect =~/"--acts?/
          shortcut.act_info
          exit
        end
        if ch =~/c/ then select_arr << '--color-toggle'
          ch=ch.gsub(/[c]/,'')
        end
        if ch =~/k/ then select_arr << '--color-off'
          ch=ch.gsub(/[k]/,'')
        end
        if ch =~/C/ then select_arr << '--config'
          ch=ch.gsub(/[C]+/,'')
        end
        if sel_init.inspect =~/"--createdb"|"--create(?:all)?"|"--dropall"|"--recreate(?:all)?"/
          if ch =~/d/ then select_arr << '--sqlite'
            ch=ch.gsub(/[d]/,'')
          end
          if ch =~/D/ then select_arr << '--pg'
            ch=ch.gsub(/[D]/,'')
          end
        end
        if ch =~/W/ then select_arr << '--webrick'
          ch=ch.gsub(/[w]/,'')
        end
        if ch =~/v/ then select_arr << '--version'
          ch=ch.gsub(/[v]/,'')
        end
        if ch =~/M/ then select_arr << '--maintenance'
          ch=ch.gsub(/[M]/,'')
        end
        if ch =~/V/ then select_arr << '--very-verbose'
          ch=ch.gsub(/[V]/,'')
        end
        if ch =~/q/ then select_arr << '--quiet'
          ch=ch.gsub(/[q]/,'')
        end
      end
      select_arr=select_arr.flatten.compact.uniq.sort
    end
    def opt_act
      select_arr=@select_arr
      @@act=if @@act
        @act=@@act
      else
        act={}
        act[:no_stop]=if select_arr.inspect \
        =~/"--no-stop"|"--errors-as-warnings"/
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:license]=(select_arr.inspect \
        =~/"--license/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:site_init]=(select_arr.inspect \
        =~/"--init"|"--initialize"|"--init-site"|"--conf"|"--config"|"--configure"/) \
        ? { bool: true, set: :on  }
        : { bool: false, set: :na }
        act[:rc]=if select_arr.inspect \
        =~/"--rc=/
          x=Dir.pwd + '/' + select_arr.join.gsub(/--rc=/,'')
          { bool: true, set: :on, inst: x }
        else
          { bool: false, set: :na, inst: '' }
        end
        act[:processing_path]=if select_arr.inspect \
        =~/"--processing-path=/
          base_pth=select_arr.join(';').gsub(/^.*--processing-path=['"]?(.+?)(?:['"]?;.+)?$/,'\1')
          { bool: true, set: :on, inst: base_pth }
        elsif select_arr.inspect \
        =~/"--processing-path/
          { bool: true, set: :on, inst: @base_path }
        else
          { bool: false, set: :na, inst: nil }
        end
        act[:dump]=if select_arr.inspect \
        =~/"--dump=/
          base_pth=select_arr.join(';').
            gsub(/^.*--dump=['"]?(.+?)(?:['"]?;.+)?$/,'\1')
          { bool: true, set: :on, inst: base_pth }
        elsif select_arr.inspect =~/"--dump/
          { bool: true, set: :on, inst: @base_path }
        else
          { bool: false, set: :na, inst: nil }
        end
        act[:redirect]=if select_arr.inspect \
        =~/"--redirect=/
          base_pth=select_arr.join(';').
            gsub(/^.*--redirect=['"]?(.+?)(?:['"]?;.+)?$/,'\1')
          { bool: true, set: :on, inst: base_pth }
        elsif select_arr.inspect \
        =~/"--redirect/
          { bool: true, set: :on, inst: @base_path }
        else
          { bool: false, set: :na, inst: nil }
        end
        act[:switch]=if select_arr.inspect \
        =~/"--switch-off=/
          off_list=select_arr.join(';').
            gsub(/^.*--switch-off=['"]?(.+?)(?:['"];.+)?$/,'\1')
          off_list=off_list.scan(/[^,;\s]+/)
          { bool: false, set: :off, off: off_list}
        else { bool: true, set: :na, off: [] }
        end
        act[:default_language]=if select_arr.inspect \
        =~/"--(?:default-)?language[-=](\S{2})"/
          { set: :on, code: $1 }
        elsif lng_base
          { set: :on, code: lng_base }
        else { set: :na, code: 'en' }
        end
        act[:i18n]=if select_arr.inspect \
        =~/"(?:--monolingual|--i18n-mono(?:lingual)?)"/ #if monolingual possible outputs output_by :filename & :filetype only, without language code in default language name; give warning of conflict settings if monolingual & :language selected
          @lingual=:mono
          { set: :mono }
        elsif select_arr.inspect \
        =~/"(?:--multilingual|--i18n-multi(?:lingual)?)"/
          @lingual=:multi
          { set: :multi }
        else { set: :na }
        end
        act[:output_by]=if select_arr.inspect \
        =~/"--(?:output-)?by-language"/
          @dir_structure_by=:language
          { set: :language }
        elsif select_arr.inspect \
        =~/"--(?:output-)?by-filename"/
          @dir_structure_by=:filename
          { set: :filename }
        elsif select_arr.inspect \
        =~/"--(?:output-)?by-filetype"/
          @dir_structure_by=:filetype
          { set: :filetype }
        else { set: :na }
        end
        act[:ocn]=if select_arr.inspect \
        =~/"--ocn"|"--inc-ocn"|"--numbering"|"--inc-numbering"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--no-ocn"|"--exc-ocn"|"--no-numbering"|"--exc-numbering"/ \
        || act[:switch][:off].inspect =~/"ocn"|"--numbering"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:toc]=if select_arr.inspect \
        =~/"--inc-toc"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-toc"/ \
        || act[:switch][:off].inspect =~/"toc"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:minitoc]=if select_arr.inspect \
        =~/"--inc-minitoc"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-minitoc"/ \
        || act[:switch][:off].inspect =~/"minitoc"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:links_to_manifest]=if select_arr.inspect \
        =~/"--inc-links-to-manifest"|"--inc-manifest-links"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-manifest"/ \
        || act[:switch][:off].inspect =~/"manifest"/ #place lower
          { bool: false, set: :off }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-links-to-manifest"|"--(?:exc|no)-manifest-links"/ \
        || act[:switch][:off].inspect \
        =~/"links_to_manifest"|"manifest_links"|"--(?:exc|no)-manifest"/ \
        || select_arr.inspect \
        =~/"--(?:redirect|dump)/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:manifest_minitoc]=if select_arr.inspect \
        =~/"--inc-manifest-minitoc"|"--inc-minitoc"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-manifest-minitoc"|"--(?:exc|no)-minitoc"/ \
        || act[:switch][:off].inspect =~/"manifest_minitoc"|"minitoc"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:metadata]=if select_arr.inspect \
        =~/"--inc-metadata"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-metadata"/ \
        || act[:switch][:off].inspect =~/"metadata"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:html_minitoc]=if select_arr.inspect \
        =~/"--inc-html-minitoc"|"--inc-minitoc"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-html-minitoc"|"--(?:exc|no)-minitoc"/ \
        || act[:switch][:off].inspect =~/"html_minitoc"|"minitoc"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:html_navigation]=if select_arr.inspect \
        =~/"--inc-html-navigation"|"--inc-navigation"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-html-navigation"|"--(?:exc|no)-navigation"/ \
        || act[:switch][:off].inspect =~/"html_navigation"|"nav"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:html_navigation_bar]=if select_arr.inspect \
        =~/"--inc-html-navigation-bar"|"--inc-navigation-bar"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-html-navigation-bar"|"--(?:exc|no)-navigation-bar"/ \
        || act[:switch][:off].inspect =~/"html_navigation_bar"|"navbar"/
          { bool: false, set: :off }
        else { bool: false, set: :na }
        end
        act[:segsubtoc]=if select_arr.inspect \
        =~/"--inc-segsubtoc"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-segsubtoc"/ \
        || act[:switch][:off].inspect =~/"segsubtoc"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:search_form]=if select_arr.inspect \
        =~/"--inc-search-form"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-search-form"/ \
        || act[:switch][:off].inspect =~/"search_form"|"search"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:html_search_form]=if select_arr.inspect \
        =~/"--inc-html-search-form"|"--inc-search-form"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-html-search-form"|"--(?:exc|no)-search-form"/ \
        || act[:switch][:off].inspect \
        =~/"html_search_form"|"search_form"|"search"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:html_right_pane]=if select_arr.inspect \
        =~/"--inc-html-right-pane"|"--inc-right-pane"|"--inc-html-right-column"|"--inc-right-column"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-html-right-pane"|"--(?:exc|no)-right-pane"|"--(?:exc|no)-html-right-column"|"--(?:exc|no)-right-column"/ \
        || act[:switch][:off].inspect =~/"html_right_pane"|"html_right_column"|"promo"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:html_top_band]=if select_arr.inspect \
        =~/"--inc-html-top-band"|"--inc-top-band"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-html-top-band"|"--(?:exc|no)-top-band"/ \
        || act[:switch][:off].inspect =~/"html-top-band"|"top-band"/
          { bool: false, set: :off }
        else { bool: true, set: :na }
        end
        act[:html]=if select_arr.inspect \
        =~/"--html-strict"/ \
        or ((select_arr.inspect \
        =~/"--html"/) \
        && select_arr.inspect \
        =~/"--strict"/)
          act[:html_strict]={ bool: true, set: :on }
          act[:html_scroll]={ bool: true, set: :on }
          act[:html_seg]={ bool: true, set: :on }
          { bool: true, set: :on }
        elsif (select_arr.inspect \
        =~/"--html"/)
          act[:html_strict]={ bool: false, set: :off }
          act[:html_scroll]={ bool: true, set: :on }
          act[:html_seg]={ bool: true, set: :on }
          { bool: true, set: :on }
        else
          act[:html_strict]=(select_arr.inspect \
          =~/"--strict"/) \
          ? { bool: true, set: :on }
          : { bool: false, set: :na }
          act[:html_scroll]=(select_arr.inspect \
          =~/"--html-scroll"/) \
          ? { bool: true, set: :on }
          : { bool: false, set: :na }
          act[:html_seg]=(select_arr.inspect \
          =~/"--html-seg"/) \
          ? { bool: true, set: :on }
          : { bool: false, set: :na }
          { bool: false, set: :na }
        end
        act[:concordance]=(select_arr.inspect \
        =~/"--concordance"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:images]=(select_arr.inspect \
        =~/"--images"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        if select_arr.inspect \
        =~/"--pdf"/
          if select_arr.inspect \
          =~/"--portrait"/
            act[:pdf]=  { bool: false, set: :na }
            act[:pdf_l]={ bool: false, set: :na }
            act[:pdf_p]={ bool: true, set: :on }
          elsif select_arr.inspect \
          =~/"--landscape"/
            act[:pdf]=  { bool: false, set: :na }
            act[:pdf_l]={ bool: true, set: :on }
            act[:pdf_p]={ bool: false, set: :na }
          else
            act[:pdf]=  { bool: true, set: :on }
            act[:pdf_l]={ bool: true, set: :on }
            act[:pdf_p]={ bool: true, set: :on }
          end
        else
          act[:pdf]=       { bool: false, set: :na }
          act[:pdf_p]=     { bool: false, set: :na }
          act[:pdf_l]=     { bool: false, set: :na }
          act[:pdf_a4]=    { bool: false, set: :na }
          act[:pdf_a5]=    { bool: false, set: :na }
          act[:pdf_b5]=    { bool: false, set: :na }
          act[:pdf_letter]={ bool: false, set: :na }
          act[:pdf_legal]= { bool: false, set: :na }
        end
        if act[:pdf][:set]==:on \
        or act[:pdf_p][:set]==:on \
        or act[:pdf_l][:set]==:on
          act[:pdf_a4]=if select_arr.inspect \
          =~/"--a4"|--papersize-a4"/ \
          or select_arr.inspect \
          =~/"--papersize=\S*a4\b\S*"/ #--papersize=a4,a5
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
          act[:pdf_a5]=if select_arr.inspect \
          =~/"--a5"|"--papersize-a5"/ \
          or select_arr.inspect \
          =~/"--papersize=\S*a5\b\S*"/ #--papersize=a4,a5
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
          act[:pdf_b5]=if select_arr.inspect \
          =~/"--b5"|"--papersize-b5"/ \
          or select_arr.inspect \
          =~/"--papersize=\S*b5\b\S*"/
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
          act[:pdf_letter]=if select_arr.inspect \
          =~/"--letter"|"--papersize-letter"/ \
          or select_arr.inspect \
          =~/"--papersize=\S*letter\b\S*"/
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
          act[:pdf_legal]=if select_arr.inspect \
          =~/"--legal"|"--papersize-legal"/ \
          or select_arr.inspect \
          =~/"--papersize=\S*legal\b\S*"/
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
        end
        act[:epub]=(select_arr.inspect \
        =~/"--epub"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:odt]=if select_arr.inspect \
        =~/"--odt"|"--odf"|"--odt-(?:ocn|numbering)"|"--odf-(?:ocn|numbering)"/
          act[:odt_ocn]=if (select_arr.inspect \
          =~/"--odt-(?:ocn|numbering)"|"--odf-(?:ocn|numbering)"/ \
          or select_arr.inspect \
          =~/"--ocn"|"--inc-ocn"|"--numbering"|"--inc-numbering"/)
            { bool: true, set: :on }
          elsif select_arr.inspect \
          =~/"--no-ocn"|"--exc-ocn"|"--no-numbering"|"--exc-numbering"/
            { bool: false, set: :off }
          else
            { bool: false, set: :na }
          end
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:xml_sax]=(select_arr.inspect \
        =~/"--xml-sax"|"--sax"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:xml_dom]=(select_arr.inspect \
        =~/"--xml-dom"|"--dom"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:xml_docbook_book]=(select_arr.inspect \
        =~/"--docbook"|"--docbook-book"|"--xml-docbook"|"--xml-docbook_book"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:xml_fictionbook]=(select_arr.inspect \
        =~/"--fictionbook"|"--xml-fictionbook"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:xml_scaffold_structure_sisu]=select_arr.inspect \
        =~/"--xml-scaffold"|"--xml-scaffold-sisu"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:xml_scaffold_structure_collapse]=select_arr.inspect \
        =~/"--xml-scaffold-collapse"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:xhtml]=(select_arr.inspect \
        =~/"--xhtml"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:txt]=if select_arr.inspect \
        =~/"--txt"|"--text"|"--plaintext"|"--txt-(?:ocn|numbering)"|"--text-(?:ocn|numbering)"|"--plaintext-(?:ocn|numbering)"/
          act[:txt_ocn]=if (select_arr.inspect \
          =~/"--txt-(?:ocn|numbering)"|"--text-(?:ocn|numbering)"|"--plaintext-(?:ocn|numbering)"/ \
          or select_arr.inspect \
          =~/"--ocn"|"--inc-ocn"|"--numbering"|"--inc-numbering"/)
            { bool: true, set: :on }
          elsif select_arr.inspect \
          =~/"--no-ocn"|"--exc-ocn"|"--no-numbering"|"--exc-numbering"/
            { bool: false, set: :off }
          else
            { bool: false, set: :na }
          end
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:txt_textile]=(select_arr.inspect \
        =~/"--textile"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:txt_asciidoc]=(select_arr.inspect \
        =~/"--asciidoc"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:txt_markdown]=(select_arr.inspect \
        =~/"--markdown"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:txt_rst]=(select_arr.inspect \
        =~/"--rst"|"--rest"|"--restructuredtext"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:manpage]=(select_arr.inspect \
        =~/"--manpage"|"--man"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:texinfo]=(select_arr.inspect \
        =~/"--texinfo"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:psql]=if select_arr.inspect \
        =~/"--pg-\S+"/ \
        or ((select_arr.inspect =~/"--pg"/) \
        && (select_arr.inspect \
        =~/"--createdb"|"--create(?:all)?"|"--dropall"|"--recreate(?:all)?"|"--import"|"--update"|"--remove"/))
          act[:psql_createdb]=if select_arr.inspect \
          =~/"--pg-createdb"|"--createdb"/
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
          if select_arr.inspect \
          =~/"--pg-recreate(?:all)?"|"--recreate(?:all)?"/
            act[:psql_drop]={ bool: true, set: :on }
            act[:psql_create]={ bool: true, set: :on }
          else
            act[:psql_drop]=if select_arr.inspect \
            =~/"--pg-dropall"|"--dropall"/
              { bool: true, set: :on }
            else
              { bool: false, set: :na }
            end
            act[:psql_create]=if select_arr.inspect \
            =~/"--pg-create(?:all)?"|"--create(?:all)?"/
              { bool: true, set: :on }
            else
              { bool: false, set: :na }
            end
          end
          act[:psql_import]=if select_arr.inspect \
          =~/"--pg-import"|"--import"/
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
          act[:psql_update]=if select_arr.inspect \
          =~/"--pg-update"|"--update"/
            act[:psql_remove]={ bool: true, set: :on }
            { bool: true, set: :on }
          else
            act[:psql_remove]=if select_arr.inspect \
            =~/"--pg-remove"|"--remove"/
              { bool: true, set: :on }
            else
              { bool: false, set: :na }
            end
            { bool: false, set: :na }
          end
          { bool: true, set: :on }
        else
          act[:psql_createdb]=
            { bool: false, set: :na }
          act[:psql_drop]=
            { bool: false, set: :na }
          act[:psql_create]=
            { bool: false, set: :na }
          act[:psql_import]=
            { bool: false, set: :na }
          act[:psql_update]=
            { bool: false, set: :na }
          act[:psql_remove]=
            { bool: false, set: :na }
          { bool: false, set: :na }
        end
        act[:sqlite]=if select_arr.inspect \
        =~/"--sqlite-\S+"/ \
        or (select_arr.inspect \
        =~/"--sqlite"/ \
        && select_arr.inspect \
        =~/"--createdb"|"--create(?:all)?"|"--dropall"|"--recreate(?:all)?"|"--import"|"--update"|"--remove"/)
          act[:sqlite_createdb]=if select_arr.inspect \
          =~/"--sqlite-createdb"|"--createdb"/
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
          if select_arr.inspect \
          =~/"--sqlite-recreate(?:all)?"|"--recreate(?:all)?"/
            act[:sqlite_drop]={ bool: true, set: :on }
            act[:sqlite_create]={ bool: true, set: :on }
          else
            act[:sqlite_create]=if select_arr.inspect \
            =~/"--sqlite-create(?:all)?"|"--create(?:all)?"/
              { bool: true, set: :on }
            else
              { bool: false, set: :na }
            end
            act[:sqlite_drop]=if select_arr.inspect \
            =~/"--sqlite-dropall"|"--dropall"/
              { bool: true, set: :on }
            else
              { bool: false, set: :na }
            end
          end
          act[:sqlite_import]=if select_arr.inspect \
          =~/"--sqlite-import"|"--import"/
            { bool: true, set: :on }
          else
            { bool: false, set: :na }
          end
          act[:sqlite_update]=if select_arr.inspect \
          =~/"--sqlite-update"|"--update"/
            act[:sqlite_remove]={ bool: true, set: :on }
            { bool: true, set: :on }
          else
            act[:sqlite_remove]=if select_arr.inspect \
            =~/"--sqlite-remove"|"--sqlite-remove"/
              { bool: true, set: :on }
            else
              { bool: false, set: :na }
            end
            { bool: false, set: :na }
          end
          { bool: true, set: :on }
        else
          act[:sqlite_createdb]=
            { bool: false, set: :na }
          act[:sqlite_drop]=
            { bool: false, set: :na }
          act[:sqlite_create]=
            { bool: false, set: :na }
          act[:sqlite_import]=
            { bool: false, set: :na }
          act[:sqlite_update]=
            { bool: false, set: :na }
          act[:sqlite_remove]=
            { bool: false, set: :na }
          { bool: false, set: :na }
        end
        act[:sqlite_discrete]=select_arr.inspect \
        =~/"--sql"|"--sqlite"/ \
        && (select_arr.inspect \
        !~/"--createdb"|"--create(?:all)?"|"--dropall"|"--recreate(?:all)?"|"--import"|"--update"|"--remove"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:harvest]=(select_arr.inspect \
        =~/"--harvest"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:po4a]=(select_arr.inspect \
        =~/"--po4a"|"--pot?"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:git]=(select_arr.inspect \
        =~/"--git"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:hash_digests]=(select_arr.inspect \
        =~/"--digests?"|"--hash-digests"/) \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:pdf_font_size]=if select_arr.inspect \
        =~/"--(?:pdf-)?font-?size[=-](\d{1,2})(?:pt)?"/
          $1
        else :na
        end
        act[:pdf_hyperlink_colors]=if select_arr.inspect \
        =~/"--pdf-hyperlinks-(?:mono(?:chrome)?|no-color)"/
          :mono
        elsif select_arr.inspect \
        =~/"--pdf-hyperlinks-color"/
          :color
        else :na
        end
        act[:hash_digest_algo]=if select_arr.inspect \
        =~/"--hash-(?:sha)?512"/
          :sha512
        elsif select_arr.inspect \
        =~/"--hash-(?:sha)?256"/
          :sha256
        elsif select_arr.inspect \
        =~/"--hash-md5"/
          :md5
        else :na
        end
        act[:sample_search_form]=if select_arr.inspect \
        =~/"--sample-search-form"/
          if select_arr.inspect \
          =~/"--db[-=]pg"/
            { bool: true, set: :on, db: :pg }
          elsif select_arr.inspect \
          =~/"--db[-=]sqlite"/
            { bool: true, set: :on, db: :sqlite }
          else
            { bool: true, set: :on, db: :na }
          end
        else
          { bool: false, set: :na, db: :na }
        end
        act[:webrick]=select_arr.inspect \
        =~/"--webrick"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:share_source]=select_arr.inspect \
        =~/"--source"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:sisupod]=select_arr.inspect \
        =~/"--sisupod"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:scp]=select_arr.inspect \
        =~/"--scp"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:rsync]=select_arr.inspect \
        =~/"--rsync"|"--remote"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:zap]=select_arr.inspect \
        =~/"--zap"|"--delete"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:urls_all]=select_arr.inspect \
        =~/"--urls-all"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:urls_selected]=if select_arr.inspect \
        =~/"--urls"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--harvest/
          { bool: false, set: :off }
        elsif select_arr.inspect \
        =~/"--verbose"|"--maintenance"/
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:sitemap]=select_arr.inspect \
        =~/"--sitemap"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:qrcode]=select_arr.inspect \
        =~/"--qrcode"/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:help]=select_arr.inspect \
        =~/"--help/ \
        ? { bool: true, set: :on }
        : { bool: false, set: :na }
        act[:ao]=if select_arr.inspect \
        =~/"--ao"|"--dal"/
          { bool: true, set: :on }
        elsif (act[:txt][:set]==:on \
        || act[:txt_textile][:set]==:on \
        || act[:txt_asciidoc][:set]==:on \
        || act[:txt_markdown][:set]==:on \
        || act[:txt_rst][:set]==:on \
        || act[:xhtml][:set]==:on \
        || act[:epub][:set]==:on \
        || act[:html][:set]==:on \
        || act[:html_seg][:set]==:on \
        || act[:html_scroll][:set]==:on \
        || act[:texinfo][:set]==:on \
        || act[:manpage][:set]==:on \
        || act[:hash_digests][:set]==:on \
        || act[:odt][:set]==:on \
        || act[:pdf][:set]==:on \
        || act[:pdf_p][:set]==:on \
        || act[:pdf_l][:set]==:on \
        || act[:qrcode][:set]==:on \
        || act[:share_source][:set]==:on \
        || act[:sisupod][:set]==:on \
        || act[:concordance][:set]==:on \
        || act[:sqlite_discrete][:set]==:on \
        || act[:sqlite_import][:set]==:on \
        || act[:sqlite_update][:set]==:on \
        || act[:sqlite_remove][:set]==:on \
        || act[:psql_import][:set]==:on \
        || act[:psql_update][:set]==:on \
        || act[:psql_remove][:set]==:on \
        || act[:xml_dom][:set]==:on \
        || act[:xml_sax][:set]==:on \
        || act[:xml_docbook_book][:set]==:on \
        || act[:xml_fictionbook][:set]==:on \
        || act[:xml_scaffold_structure_sisu][:set]==:on \
        || act[:xml_scaffold_structure_collapse][:set]==:on )
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:manifest]=if select_arr.inspect \
        =~/"--inc-manifest"/
          { bool: true, set: :on }
        elsif select_arr.inspect \
        =~/"--(?:exc|no)-manifest"/ \
        || act[:switch][:off].inspect =~/"manifest"/
          { bool: false, set: :off }
        elsif select_arr.inspect \
        =~/"--manifest"/
          { bool: true, set: :on }
        elsif (act[:txt][:set]==:on \
        || act[:txt_textile][:set]==:on \
        || act[:txt_asciidoc][:set]==:on \
        || act[:txt_markdown][:set]==:on \
        || act[:txt_rst][:set]==:on \
        || act[:xhtml][:set]==:on \
        || act[:epub][:set]==:on \
        || act[:html][:set]==:on \
        || act[:html_seg][:set]==:on \
        || act[:html_scroll][:set]==:on \
        || act[:texinfo][:set]==:on \
        || act[:manpage][:set]==:on \
        || act[:hash_digests][:set]==:on \
        || act[:odt][:set]==:on \
        || act[:pdf][:set]==:on \
        || act[:pdf_p][:set]==:on \
        || act[:pdf_l][:set]==:on \
        || act[:qrcode][:set]==:on \
        || act[:share_source][:set]==:on \
        || act[:sisupod][:set]==:on \
        || act[:concordance][:set]==:on \
        || act[:xml_dom][:set]==:on \
        || act[:xml_sax][:set]==:on \
        || act[:xml_docbook_book][:set]==:on \
        || act[:xml_fictionbook][:set]==:on \
        || act[:xml_scaffold_structure_sisu][:set]==:on \
        || act[:xml_scaffold_structure_collapse][:set]==:on )
          { bool: true, set: :on }
        else { bool: true, set: :na }
        end
        act[:console_messages] = ''
        act[:verbose]=if select_arr.inspect \
        =~/"--verbose"/
          act[:console_messages] << ' --verbose '
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:verbose_plus]=if select_arr.inspect \
        =~/"--very-verbose"|"--verbose-very"/
          act[:console_messages] << ' --very-verbose '
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:version_info]=if select_arr.inspect \
        =~/"--version"|"--verbose"|"--maintenance"/
          act[:console_messages] << ' --maintenance '
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:quiet]=if (select_arr.inspect =~/"--quiet"/)
          act[:console_messages] << ' --quiet '
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:color_state]=if select_arr.inspect =~/"--color-on"|"--color"/
          act[:console_messages] << ' --color-on '
          { bool: true, set: :on }
        elsif (select_arr.inspect =~/"--color-off"/)
          act[:console_messages] << ' --color-off '
          { bool: false, set: :off }
        else { bool: true, set: :na } #fix default color
        end
#       act[:color_toggle]=if select_arr.inspect =~/"--color-toggle"/
#         true
#       else false
#       end
        act[:maintenance]=if (select_arr.inspect =~/"--maintenance|--keep-processing-files"/)
          act[:console_messages] << ' --maintenance '
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        act[:profile]=if (select_arr.inspect =~/"--profile"/)
          act[:console_messages] << ' --color-off '
          { bool: true, set: :on }
        else
          { bool: false, set: :na }
        end
        @act=act
      end
    end
    def opt_ch
      @opt_ch
    end
    def selections
      def arr
        @select_arr.sort
      end
      def str
        @select_str ||= arr.join(' ')
      end
      self
    end
    def act
      @@act
    end
    def files_mod
      files_mod=files
      @files_mod=files_mod
    end
    def files
      @files
    end
    def f_pth
      @f_pth
    end
    def pth
      @pth
    end
    def sub_location
      pth.gsub(/#{base_path}/,'')
    end
    def lng
      @lng
    end
    def lng_base
      @lng_base
    end
    def fno
      @fno=(fns.nil? || fns.empty?) \
      ? '' \
      : (fns[/(.+?(?:sst|ssm))(?:\.sst)?/,1])
    end
    def fng
      @fng=(fno.nil? || fno.empty?) \
      ? '' \
      : (fno.gsub(/(?:~(?:#{Px[:lng_lst_rgx]}))?(\.ss[tm])$/,'\1'))
    end
    def fns
      @fns
    end
    def fnl
      @fns.gsub(/(\S+?)((?:\.ssm)?\.sst)/,"\\1.#{lng}\\2")
    end
    def what
      @what
    end
    def fnb
      (fns.nil? || fns.empty?) \
      ? '' \
      : (fns[/(.+?)\.(?:(?:-|ssm\.)?sst|ssm)$/,1])
    end
    def fnc
      @fnc=(@fns =~/\.(?:ssm\.sst|ssm)$/) \
      ? fnb + '.ssm.sst'
      : @fns
    end
    def fncb
      @fncb=(@fns =~/(?:\~\S{2,3})?\.(?:ssm\.sst|ssm)$/) \
      ? fnb + '.ssm.sst'
      : @fns.gsub(/(?:\~\S{2,3})?(\.sst)$/,'\1')
    end
  end
end
__END__
note usually named @opt is carried in dp document parameters (usually as @md.opt), @opt is a
subset of @md where @md is passed, contents of @opt are available as @md.opt
passing @opt as well is duplication check for fns & fnb
