# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/se_get_init.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_Get_Init
  require_relative 'constants'                             # constants.rb
  require_relative 'utils'                                 # utils.rb
  require_relative 'se_info_system'                        # se_info_system.rb
  @@noyaml=false
  class GetInit < SiSU_Info_Sys_Gen::InfoSystemGen         # se_info_system.rb
    @@noyaml=false
    @@rc,@@sisu_doc_makefile,@@sisurc_path,@@tx=nil,nil,nil,nil
    @@ad={ promo: nil, promo_list: nil, flag_promo: false }
    @@sdmd=nil
    attr_accessor :yaml
    def initialize
      super()
        @markup_dir_changed_=if @@sdmd==$sisu_document_markup_directory
          false
        else
          @@sdmd=$sisu_document_markup_directory
          true
        end
    end
    def tex
      require_relative 'texpdf_parts'                        # texpdf_parts.rb
      @@tx ||=SiSU_Parts_TeXpdf::TeX.new
    end
    def rc_path_options
      [
        "#{$sisu_document_markup_directory_base_fixed_path}/.sisu/#{SiSU_is[:version_dir]}",
        "#{$sisu_document_markup_directory_base_fixed_path}/.sisu",
        "#{$sisu_document_markup_directory_base_fixed_path}/_sisu/#{SiSU_is[:version_dir]}",
        "#{$sisu_document_markup_directory_base_fixed_path}/_sisu",
        "#{@@home}/.sisu/#{SiSU_is[:version_dir]}",
        "#{@@home}/.sisu",
        "#{@@sisu_etc}/#{SiSU_is[:version_dir]}",
        "#{@@sisu_etc}",
      ]
    end
    def sisu_document_make
      def makefile_name
        S_CONF[:header_make]
      end
      def makefile
        rc_path_options.each do |v|
          if FileTest.exist?("#{v}/#{makefile_name}")
            @sisu_make_path=v
            break
          end
        end
        @sisu_make_file_path=@sisu_make_path \
        ? "#{@sisu_make_path}/#{makefile_name}"
        : nil
      end
      def makefile_read
        if makefile
          sisu_doc_makefile=IO.read(makefile, mode: 'r:utf-8')
          @sisu_doc_makefile=sisu_doc_makefile.split(/\s*\n\s*\n/m)
        end
        @sisu_doc_makefile
      end
      self
    end
    def sisu_yaml
      def rc
        if @markup_dir_changed_
          rc_path_options.each do |v|
            if @@noyaml \
            or FileTest.exist?("#{v}/noyaml")
              STDERR.puts "WARNING - YAML loading switched off, to enable delete the file:\n\t#{v}/noyaml\n\n" unless @@noyaml
              @@noyaml=true
              break
            else
              f=S_CONF[:rc_yml]
              p_f="#{v}/#{f}"
              if FileTest.exist?(p_f)
                begin
                  require 'yaml'
                rescue LoadError
                  SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
                    error('yaml NOT FOUND (LoadError)')
                end
                @@sisurc_path=v
                @@rc=YAML::load(File::open(p_f))
                break
              end
              unless @@rc
                f='sisurc.yaml'
                p_f="#{v}/#{f}"
                if FileTest.exist?(p_f)
                  begin
                    require 'yaml'
                  rescue LoadError
                    SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
                      error('yaml NOT FOUND (LoadError)')
                  end
                  @@sisurc_path=v
                  @@rc=YAML::load(File::open(p_f))
                  break
                end
              end
            end
          end
        end
        @@rc
      end
      def rc_path
        rc
        @@sisurc_path
      end
      self
    end
    def ads #WORK AREA
      tell_no_yaml='WARNING - YAML loading switched off, to enable delete the file:'
      if @markup_dir_changed_
        @ad_path=[
          "#{$sisu_document_markup_directory_base_fixed_path}/.sisu/#{SiSU_is[:version_dir]}/skin/yml",
          "#{$sisu_document_markup_directory_base_fixed_path}/.sisu/skin/yml",
          "#{$sisu_document_markup_directory_base_fixed_path}/_sisu/#{SiSU_is[:version_dir]}/skin/yml",
          "#{$sisu_document_markup_directory_base_fixed_path}/_sisu/skin/yml",
          "#{@@home}/.sisu/#{SiSU_is[:version_dir]}/skin/yml",
          "#{@@home}/.sisu/skin/yml",
          "#{@@sisu_etc}/#{SiSU_is[:version_dir]}/skin/yml",
          "#{@@sisu_etc}/skin/yml",
        ]
        @ad_path.each do |v|
          if @@noyaml \
          or FileTest.exist?("#{v}/noyaml")
            puts tell_no_yaml + "\n\t#{v}/noyaml\n" unless @@noyaml
            @@noyaml=true
            break
          else
            if FileTest.exist?("#{v}/list.yml")
              unless @@ad[:promo_list]
                begin
                  require 'yaml'
                rescue LoadError
                  SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
                    error('yaml NOT FOUND (LoadError)')
                end
                @@ad[:promo_list] ||= YAML::load(File::open("#{v}/list.yml"))
              end
              @@ad[:flag_promo]=true
              break
            end
            @@ad[:flag_promo]=false
          end
        end
        @ad_path.each do |v|
          if @@noyaml \
          or FileTest.exist?("#{v}/noyaml")
            puts tell_no_yaml + "\n\t#{v}/noyaml\n" unless @@noyaml
            @@noyaml=true
            break
          else
            if FileTest.exist?("#{v}/promo.yml")
              unless @@ad[:promo]
                begin
                  require 'yaml'
                rescue LoadError
                  SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).
                    error('yaml NOT FOUND (LoadError)')
                end
                @@ad[:promo] ||= YAML::load(File::open("#{v}/promo.yml"))
              end
              @@ad[:flag_promo]=true
              break
            end
            @@ad[:flag_promo]=false
          end
        end
      end
      @@ad
    end
  end
end
__END__
