# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/se_standardise_lang.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
@@lang_info=nil
module SiSU_Standardise_Lang
  class StandardiseLanguage
    require_relative 'i18n'                  # i18n.rb
    def initialize(l='')
      @language=(l.nil? || l.empty?) \
      ? SiSU_Env::InfoEnv.new.language_default_set
      : l
      @r=%{(?:#{Px[:lng_lst_rgx]})}
      @lang_info=SiSU_i18n::Languages.new
    end
    def lang_lst                       # from i18n
      @@lang_info ||=@lang_info.language.list
    end
    def lang(l='')                     # from i18n
      if l =~/^#{@r}$/
        @lang_info.language.list[l]
      elsif @language =~/^#{@r}$/
        @lang_info.language.list[@language]
      else nil
      end
    end
    def language
      lng={}
      case @language
      when /^am$|Amharic/i                    then d,c,l=false,lang_lst['am'][:c],    lang_lst['am'][:n]
      when /^bg$|Bulgarian/i                  then d,c,l=false,lang_lst['bg'][:c],    lang_lst['bg'][:n]
      when /^bn$|Bengali/i                    then d,c,l=false,lang_lst['bn'][:c],    lang_lst['bn'][:n]
      when /^br$|Breton/i                     then d,c,l=false,lang_lst['br'][:c],    lang_lst['br'][:n]
      when /^ca$|Catalan/i                    then d,c,l=false,lang_lst['ca'][:c],    lang_lst['ca'][:n]
      when /^cs$|Czech/i                      then d,c,l=false,lang_lst['cs'][:c],    lang_lst['cs'][:n]
      when /^cy$|Welsh/i                      then d,c,l=false,lang_lst['cy'][:c],    lang_lst['cy'][:n]
      when /^da$|Danish|Dansk/i               then d,c,l=false,lang_lst['da'][:c],    lang_lst['da'][:n]
      when /^de$|German/i                     then d,c,l=false,lang_lst['de'][:c],    lang_lst['de'][:n]
      when /^el$|Greek/i                      then d,c,l=false,lang_lst['el'][:c],    lang_lst['el'][:n]
      when /^en$|English/i                    then d,c,l=false,lang_lst['en'][:c],    lang_lst['en'][:n]
      when /^eo$|Esperanto/i                  then d,c,l=false,lang_lst['eo'][:c],    lang_lst['eo'][:n]
      when /^es$|Spanish|Espanol/i            then d,c,l=false,lang_lst['es'][:c],    lang_lst['es'][:n]
      when /^et$|Estonian/i                   then d,c,l=false,lang_lst['et'][:c],    lang_lst['et'][:n]
      when /^eu$|Basque/i                     then d,c,l=false,lang_lst['eu'][:c],    lang_lst['eu'][:n]
      when /^fi$|Finnish|Finsk|Suomi/i        then d,c,l=false,lang_lst['fi'][:c],    lang_lst['fi'][:n]
      when /^fr$|French|Francais/i            then d,c,l=false,lang_lst['fr'][:c],    lang_lst['fr'][:n]
      when /^ga$|Irish/i                      then d,c,l=false,lang_lst['ga'][:c],    lang_lst['ga'][:n]
      when /^gl$|Galician/i                   then d,c,l=false,lang_lst['gl'][:c],    lang_lst['gl'][:n]
      when /^he$|Hebrew/i                     then d,c,l=false,lang_lst['he'][:c],    lang_lst['he'][:n]
      when /^hi$|Hindi/i                      then d,c,l=false,lang_lst['hi'][:c],    lang_lst['hi'][:n]
      when /^hr$|Croatian/i                   then d,c,l=false,lang_lst['hr'][:c],    lang_lst['hr'][:n]
      when /^hy$|Armenian/i                   then d,c,l=false,lang_lst['hy'][:c],    lang_lst['hy'][:n]
      when /^ia$|Interlingua/i                then d,c,l=false,lang_lst['ia'][:c],    lang_lst['ia'][:n]
      when /^is$|Icelandic/i                  then d,c,l=false,lang_lst['is'][:c],    lang_lst['is'][:n]
      when /^it$|Italian/i                    then d,c,l=false,lang_lst['it'][:c],    lang_lst['it'][:n]
      when /^la$|Latin/i                      then d,c,l=false,lang_lst['la'][:c],    lang_lst['la'][:n]
      when /^lo$|Lao/i                        then d,c,l=false,lang_lst['lo'][:c],    lang_lst['lo'][:n]
      when /^lt$|Lithuanian/i                 then d,c,l=false,lang_lst['lt'][:c],    lang_lst['lt'][:n]
      when /^lv$|Latvian/i                    then d,c,l=false,lang_lst['lv'][:c],    lang_lst['lv'][:n]
      when /^ml$|Malayalam/i                  then d,c,l=false,lang_lst['ml'][:c],    lang_lst['ml'][:n]
      when /^mr$|Marathi/i                    then d,c,l=false,lang_lst['mr'][:c],    lang_lst['mr'][:n]
      when /^nl$|Dutch/i                      then d,c,l=false,lang_lst['nl'][:c],    lang_lst['nl'][:n]
      when /^no$|Norwegian|Norsk/i            then d,c,l=false,lang_lst['no'][:c],    lang_lst['no'][:n]
      when /^nn$|Norwegian Nynorsk/i          then d,c,l=false,lang_lst['nn'][:c],    lang_lst['nn'][:n]
      when /^oc$|Occitan/i                    then d,c,l=false,lang_lst['oc'][:c],    lang_lst['oc'][:n]
      when /^pl$|Polish/i                     then d,c,l=false,lang_lst['pl'][:c],    lang_lst['pl'][:n]
      when /^pt$|Portuguese/i                 then d,c,l=false,lang_lst['pt'][:c],    lang_lst['pt'][:n]
      when /^pt_BR$|Portuguese Brazil/i       then d,c,l=false,lang_lst['pt_BR'][:c], lang_lst['pt_BR'][:n]
      when /^ro$|Romanian/i                   then d,c,l=false,lang_lst['ro'][:c],    lang_lst['ro'][:n]
      when /^ru$|Russian/i                    then d,c,l=false,lang_lst['ru'][:c],    lang_lst['ru'][:n]
      when /^sa$|Sanskrit/i                   then d,c,l=false,lang_lst['sa'][:c],    lang_lst['sa'][:n]
      when /^se$|Sami/i                       then d,c,l=false,lang_lst['se'][:c],    lang_lst['se'][:n]
      when /^sk$|Slovak/i                     then d,c,l=false,lang_lst['sk'][:c],    lang_lst['sk'][:n]
      when /^sl$|Slovenian/i                  then d,c,l=false,lang_lst['sl'][:c],    lang_lst['sl'][:n]
      when /^sq$|Albanian/i                   then d,c,l=false,lang_lst['sq'][:c],    lang_lst['sq'][:n]
      when /^sr$|Serbian/i                    then d,c,l=false,lang_lst['sr'][:c],    lang_lst['sr'][:n]
      when /^sv$|Swedish|Svensk/i             then d,c,l=false,lang_lst['sv'][:c],    lang_lst['sv'][:n]
      when /^ta$|Tamil/i                      then d,c,l=false,lang_lst['ta'][:c],    lang_lst['ta'][:n]
      when /^te$|Telugu/i                     then d,c,l=false,lang_lst['te'][:c],    lang_lst['te'][:n]
      when /^th$|Thai/i                       then d,c,l=false,lang_lst['th'][:c],    lang_lst['th'][:n]
      when /^tk$|Turkmen/i                    then d,c,l=false,lang_lst['tk'][:c],    lang_lst['tk'][:n]
      when /^tr$|Turkish/i                    then d,c,l=false,lang_lst['tr'][:c],    lang_lst['tr'][:n]
      when /^uk$|Ukranian/i                   then d,c,l=false,lang_lst['uk'][:c],    lang_lst['uk'][:n]
      when /^ur$|Urdu/i                       then d,c,l=false,lang_lst['ur'][:c],    lang_lst['ur'][:n]
      when /^us|American$|/i                  then d,c,l=false,lang_lst['en'][:c],    lang_lst['en'][:n]
      when /^vi$|Vietnamese/i                 then d,c,l=false,lang_lst['vi'][:c],    lang_lst['vi'][:n]
      else                                     d,c,l=true, lang_lst['en'][:c],    lang_lst['en'][:n] #default
      end
      lng[:d],lng[:c],lng[:n]=d,c,l
      lng
    end
    def name
      language[:n].downcase
    end
    def title
      language[:n]
    end
    def code
      language[:c]
    end
    def tex_name
      language[:xlp]
    end
    def file_to_language(file)         # used, fix and remove
      m=/.+?\~(\w{2,3})\.(?:-|ssm\.)?sst$/
      @language=if file =~m ; file[m,1]
      else ''
      end
      language
    end
    def codes
      # Language List po4a
      #   <http://www.debian.org/international/l10n/po/>
      #   Px[:lng_lst] see constants.rb
      # see polyglossia for subset
      #   <http://mirrors.ctan.org/macros/xetex/latex/polyglossia/polyglossia.pdf>
      # also note ISO_639-2
      #   <http://en.wikipedia.org/wiki/ISO_639-2>
      #   <http://en.wikipedia.org/wiki/List_of_ISO_639-2_codes>
      Px[:lng_lst] # constants.rb
    end
  end
end
__END__
