# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Git
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://git.sisudoc.org/gitweb/?p=code/sisu.git;a=blob;f=lib/sisu/v5/src_shared.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: create sisupod filetype and copy it to output directory!

=end
module SiSU_Source
  include SiSU_Env
  class SiSUpodSource
    require_relative 'se'                               # se.rb
    require_relative 'se_hub_particulars'               # se_hub_particulars.rb
    def initialize(opt,build=nil,place=nil)
      @opt=opt
      @date=SiSU_Env::InfoDate.new.dt
      @env=SiSU_Env::InfoEnv.new(opt.fns)
      @ver=SiSU_Env::InfoVersion.instance.get_version
      @v=(@opt.act[:verbose_plus][:set]==:on \
      || @opt.act[:maintenance][:set]==:on) \
      ? 'v' : ''
      @particulars=SiSU_Particulars::CombinedSingleton.instance.get_all(opt)
      @file=@particulars.file
      @local_path="#{@file.output_path.sisupod.dir}"
      processing_sisupod=@env.processing_path.processing_sisupod(opt)
      processing_sisupod.make
      path_pod=processing_sisupod.paths[:sisupod]
      path_pod_fnb=processing_sisupod.paths[:fnb]
      @doc_import_list=[]
      FileUtils::mkdir_p(path_pod) unless FileTest.directory?(path_pod)
      @path_pod={
        fnb:       path_pod_fnb,
        pod:       path_pod,
        doc:       path_pod + '/' + Gt[:doc] + '/' + opt.lng,
        po:        path_pod + '/' + Gt[:po]  + '/' + opt.lng,
        pot:       path_pod + '/' + Gt[:pot],
        conf:      path_pod + '/' + Gt[:conf],
        image:     path_pod + '/' + Gt[:image],
        audio:     path_pod + '/' + Gt[:audio],
        video:     path_pod + '/' + Gt[:video],
      }
    end
    def read
      unless @opt.act[:quiet][:set]==:on
        (@opt.act[:verbose][:set]==:on \
        || @opt.act[:verbose_plus][:set]==:on \
        || @opt.act[:maintenance][:set]==:on) \
        ? SiSU_Screen::Ansi.new(
          @opt.act[:color_state][:set],
          'Assemble SiSU source',
          "[#{@opt.f_pth[:lng_is]}] #{@opt.fno}").
          green_hi_blue
        : ''
      end
      unless @opt.fns.empty?
        directories
        file_array=IO.readlines(@opt.fno,'')
        doc_import_list=pod_source_build(file_array) #this needs to be built in case of multi-lingual for all of them, before single pass tar
        doc_import_list=[@opt.fno, doc_import_list].flatten
        image_extraction(doc_import_list)
        language_versions
      end
    end
    def images_extract(f,images)                                                # consider using param info
      rgx_image=/(?:^|[^_\\])\{(?:\s*|\~\^\s+)(\S+?\.(?:png|jpg|gif)\b)/m
      if f !~/^%+\s/ \
      and f =~rgx_image
        images << f.scan(rgx_image).uniq
      end
      images.flatten
    end
    def image_extraction(doc_import_list)
      @rgx_rb_image=/["']\S*?([a-zA-Z0-9_-]+?\.(?:png|jpg|gif))["']/
      @rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
      doc_import_dir=@opt.sub_location
      images=[]
      if doc_import_list.length > 0
        doc_import_list=doc_import_list.uniq.flatten
        doc_import_list.each do |fn|
          file_array=IO.readlines(fn,'')
          file_array.each do |f|                                               #% work area
            f=f.gsub(/<:=(\S+?)>/,'{ c_\1.png 14x14 }image')                   # embedded symbol (image)
            if f !~/^%+\s/ \
            and f =~@rgx_image
              images=images_extract(f,images)
            end
          end
        end
      end
      gi=SiSU_Env::GetInit.new
      unless FileTest.file?("#{@path_pod[:conf]}/#{gi.makefile_name}")
        if gi.makefile \
        && FileTest.file?(gi.makefile)
          FileUtils::mkdir_p(@path_pod[:conf]) \
            unless FileTest.directory?(@path_pod[:conf])
          FileUtils::cp(gi.makefile,"#{@path_pod[:conf]}/#{gi.makefile_name}")
        end
        #get images from makefile, consider placing in param
      end
      if images \
      and images.length > 1
        images=images.flatten.uniq
        images.delete_if {|x| x =~/https?:\/\// }
        #images=images.sort
        FileUtils::mkdir_p(@path_pod[:image])
        images_pwd=@opt.image_src_path
        ##sequence copies base images, defaults used in all html outputs
          #image_source_base='/usr/share/sisu/image'
          #dir_pwd=Dir.pwd
          #Dir.chdir(image_source_base)
          #base_images=Dir.glob('*')
          #base_images.each do |i|
          #  FileUtils::cp_r(i,"#{images_path_pod}/#{i}")
          #end
          #Dir.chdir(dir_pwd)
        if FileTest.directory?(images_pwd)
          images=images.uniq
          images.each do |i|
            if FileTest.file?("#{images_pwd}/#{i}")
              FileUtils::cp("#{images_pwd}/#{i}","#{@path_pod[:image]}/#{i}")
            else
              STDERR.puts \
                %{\t*WARN* did not find image - "#{images_pwd}/#{i}" [#{__FILE__}:#{__LINE__}]}
            end
          end
        else
          STDERR.puts \
            %{\t*WARN* did not find - #{images_pwd} #{@path_pod[:image]} [#{__FILE__}:#{__LINE__}]}
        end
      end
      if doc_import_list.length > 0 \
      and @opt.fno =~/\.ssm$/
        doc_import_list.each do |f|
          if FileTest.file?("#{@opt.base_path}#{doc_import_dir}/#{f}")
            FileUtils::cp("#{@opt.base_path}#{doc_import_dir}/#{f}","#{@path_pod[:doc]}/#{f}")
          else
            STDERR.puts \
              %{\t*WARN* did not find image - "#{@opt.base_path}#{doc_import_dir}/#{f}" [#{__FILE__}:#{__LINE__}]}
          end
        end
      end
    end
    def language_versions
      x=@env.document_language_versions_found                                  #check multiple document language versions (param not used)
      doc_import_dir=@opt.sub_location
      if x[:f] \
      and x[:f].length > 0                                                     #store multiple document language versions, sisupod
        x[:f].each do |f|
          FileUtils::mkdir_p(@path_pod[:doc]) unless FileTest.directory?(@path_pod[:doc])
          if f[:f] =~/\~(\S{2,3})\.ss[tm]$/
            lng_f=$1
            if @opt.lng == lng_f
              if @opt.fno =~/\.ssm$/
                if FileTest.file?("#{@opt.base_path}#{doc_import_dir}/#{f[:f]}")
                  FileUtils::cp("#{@opt.base_path}#{doc_import_dir}/#{f[:f]}",
                    "#{@path_pod[:doc]}/#{f[:n]}")
                else
                  STDERR.puts \
                    %{\t*WARN* did not find - "#{@opt.base_path}#{doc_import_dir}/#{f[:f]}" [#{__FILE__}:#{__LINE__}]}
                end
              else
                if FileTest.file?("#{@opt.base_path}/#{f[:f]}")
                  cpy= :no
                  cpy=if f[:f] =~ /^#{@opt.f_pth[:lng_is]}\// \
                  or f[:f] =~ /~#{@opt.f_pth[:lng_is]}\.sst/
                    :yes
                  elsif f[:f] !~ /^(?:#{Px[:lng_lst_rgx]})\/|~(?:#{Px[:lng_lst_rgx]})\.sst/ \
                  and @opt.f_pth[:lng_is] == 'en'
                    :yes
                  else :no
                  end
                  if cpy == :yes
                    FileUtils::cp("#{@opt.base_path}/#{f[:f]}",
                      "#{@path_pod[:doc]}/#{f[:n]}")
                  end
                else
                  STDERR.puts \
                    %{\t*WARN* did not find - "#{@opt.base_path}/#{f[:f]}" [#{__FILE__}:#{__LINE__}]}
                end
              end
            end
          else
            if @opt.fno =~/\.ssm$/
              if FileTest.file?("#{@opt.base_path}#{doc_import_dir}/#{f[:f]}")
                FileUtils::cp_r("#{@opt.base_path}#{doc_import_dir}/#{f[:f]}",
                  "#{@path_pod[:doc]}/#{f[:n]}")
              else
                STDERR.puts \
                  %{\t*WARN* did not find - "#{@opt.base_path}#{doc_import_dir}/#{f[:f]}" [#{__FILE__}:#{__LINE__}]}
              end
            else
              if FileTest.file?("#{@opt.base_path}#{doc_import_dir}/#{f[:f]}")
                cpy= :no
                cpy=if f[:f] =~ /^#{@opt.f_pth[:lng_is]}\// \
                or f[:f] =~ /~#{@opt.f_pth[:lng_is]}\.sst/
                  :yes
                elsif f[:f] !~ /^(?:#{Px[:lng_lst_rgx]})\/|~(?:#{Px[:lng_lst_rgx]})\.sst/ \
                and @opt.f_pth[:lng_is] == 'en'
                  :yes
                else :no
                end
                if cpy == :yes
                  FileUtils::cp("#{@opt.base_path}#{doc_import_dir}/#{f[:f]}",
                    "#{@path_pod[:doc]}/#{f[:n]}")
                end
              else
                STDERR.puts \
                  %{\t*WARN* did not find - "#{@opt.base_path}#{doc_import_dir}/#{f[:f]}" [#{__FILE__}:#{__LINE__}]}
              end
            end
          end
        end
      end #NB not all possibilies met, revisit, also in case of composite file may wish to add README
    end
    def directories
      SiSU_Env::InfoEnv.new.sisupod_v4(@opt)
    end
    def ssm_doc_import_list(f)
      if @opt.fno =~/\.ss[mi]$/
        doc_import_list=[]
        if f =~@rgx_doc_import
          doc_import_list << f.scan(@rgx_doc_import)
        end
        doc_import_list.flatten.each do |i|
          if i =~/.ssi/
            file_array=IO.readlines(i,'')
            pod_source_build(file_array)
          end
        end
      end
      doc_import_list.uniq.flatten
    end
    def pod_source_build(file_array)
      @pwd=Dir.pwd
      @rgx_doc_import=/^<<\s*(\S+?\.ss[ti])/
      doc_import_list=[]
      file_array.each do |f|                                                   #% work area
        if f !~/^%+\s/
          if @opt.fno =~/\.ss[mi]$/
            @doc_import_list << ssm_doc_import_list(f)
            doc_import_list=@doc_import_list.flatten.uniq
          end
        end
      end
      doc_import_list
    end
  end
end
__END__
question?:                   should you permit the packing of multiple documents in single .xz ?

  open @opt.fns, parse file
    extract from file content:
      images and copy each image from whatever image source to _sisu/sisupod/sisu/_sisu/image

   remove previously existing contents of _/sisu/sisupod &
   make directory structure:

v3 -->
   _sisu
     sisupod
       doc
         manifest.txt
         en/content.sst                [file content]
         fr/content.sst
         _sisu
           conf
           image (ln -s ../../image)
           audio (ln -s ../../audio)
           video (ln -s ../../video)
       image                           [all images for specific document gathered here]
       audio
       video

v2 -->
   _sisu
     sisupod
       content.sst                     [file content]
       filename.sst                    [link to content.sst]
       _sisu/
         image/                        [all images for specific document gathered here]

sisu
  _sisu
    sisurc.yml
    convert/
    standard_terms/
    image
    processing
      ao/
      tex/
      texinfo/
      tune/
    sisupod

special case

composite file (master), e.g.
SiSU.ssm
