# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
"""
Thunderbird modifications to partial update building
"""

from __future__ import absolute_import, print_function, unicode_literals

from taskgraph.transforms.base import TransformSequence

import logging

logger = logging.getLogger(__name__)

transforms = TransformSequence()


@transforms.add
def update_scopes(config, jobs):
    """
    Firefox does some caching when building partial updates, but there's no bucket for Thunderbird
    at the moment. In the meantime, remove the scope from the task to avoid an error.
    """
    # If no balrog release history, then don't run
    if not config.params.get('release_history'):
        return

    RM_SCOPES = ['auth:aws-s3:read-write:tc-gp-private-1d-us-east-1/releng/mbsdiff-cache/',
                 'secrets:get:project/releng/gecko/build/level-3/datadog-api-key']
    DATADOG_ENV = "DATADOG_API_SECRET"

    for job in jobs:
        task = job['task']
        for rm_scope in RM_SCOPES:
            if rm_scope in task['scopes']:
                task['scopes'].remove(rm_scope)

        payload = task['payload']
        if DATADOG_ENV in payload['env']:
            del payload['env'][DATADOG_ENV]

        # This is only ever going to be on comm-esr68
        payload['env']['ACCEPTED_MAR_CHANNEL_IDS'] = 'thunderbird-comm-release'

        yield job
