/*
 * Copyright (C) 2012-2014 Panasonic Corporation
 *   Author: Masahiro Yamada <yamada.m@jp.panasonic.com>
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <common.h>

/* encoding without TEX remap */
#define NO_MAP	0x00000000 /* No Map */
#define DEVICE	0x00002002 /* Non-shareable Device */
#define NORMAL	0x0000000e /* Normal Memory Write-Back, No Write-Allocate */

#define SSC	NORMAL	/* System Cache: Normal */
#define EXT	DEVICE	/* External Bus: Device */
#define REG	DEVICE	/* IO Register: Device */
#define DDR	DEVICE	/* DDR SDRAM: Device */

#ifdef CONFIG_SPL_BUILD
#define IS_SPL_TEXT_AREA(x)	((x) == ((CONFIG_SPL_TEXT_BASE) >> 20))
#else
#define IS_SPL_TEXT_AREA(x)	((x) == ((CONFIG_SYS_TEXT_BASE) >> 20))
#endif

#define IS_INIT_STACK_AREA(x)	((x) == ((CONFIG_SYS_INIT_SP_ADDR) >> 20))

#define IS_SSC(x)		((IS_SPL_TEXT_AREA(x)) || \
					(IS_INIT_STACK_AREA(x)))
#define IS_EXT(x)		((x) < 0x100)
#define IS_REG(x)		(0x500 <= (x) && (x) < 0x700)
#define IS_DDR(x)		(0x800 <= (x) && (x) < 0xf00)

#define MMU_FLAGS(x)		(IS_SSC(x)) ? SSC : \
					(IS_EXT(x)) ? EXT : \
						(IS_REG(x)) ? REG : \
							(IS_DDR(x)) ? DDR : \
								NO_MAP

#define TBL_ENTRY(x)		(((x) << 20) | (MMU_FLAGS(x)))

const u32 __aligned(PGTABLE_SIZE) init_page_table[PGTABLE_SIZE / sizeof(u32)]
									= {
	TBL_ENTRY(0x000), TBL_ENTRY(0x001), TBL_ENTRY(0x002), TBL_ENTRY(0x003),
	TBL_ENTRY(0x004), TBL_ENTRY(0x005), TBL_ENTRY(0x006), TBL_ENTRY(0x007),
	TBL_ENTRY(0x008), TBL_ENTRY(0x009), TBL_ENTRY(0x00a), TBL_ENTRY(0x00b),
	TBL_ENTRY(0x00c), TBL_ENTRY(0x00d), TBL_ENTRY(0x00e), TBL_ENTRY(0x00f),
	TBL_ENTRY(0x010), TBL_ENTRY(0x011), TBL_ENTRY(0x012), TBL_ENTRY(0x013),
	TBL_ENTRY(0x014), TBL_ENTRY(0x015), TBL_ENTRY(0x016), TBL_ENTRY(0x017),
	TBL_ENTRY(0x018), TBL_ENTRY(0x019), TBL_ENTRY(0x01a), TBL_ENTRY(0x01b),
	TBL_ENTRY(0x01c), TBL_ENTRY(0x01d), TBL_ENTRY(0x01e), TBL_ENTRY(0x01f),
	TBL_ENTRY(0x020), TBL_ENTRY(0x021), TBL_ENTRY(0x022), TBL_ENTRY(0x023),
	TBL_ENTRY(0x024), TBL_ENTRY(0x025), TBL_ENTRY(0x026), TBL_ENTRY(0x027),
	TBL_ENTRY(0x028), TBL_ENTRY(0x029), TBL_ENTRY(0x02a), TBL_ENTRY(0x02b),
	TBL_ENTRY(0x02c), TBL_ENTRY(0x02d), TBL_ENTRY(0x02e), TBL_ENTRY(0x02f),
	TBL_ENTRY(0x030), TBL_ENTRY(0x031), TBL_ENTRY(0x032), TBL_ENTRY(0x033),
	TBL_ENTRY(0x034), TBL_ENTRY(0x035), TBL_ENTRY(0x036), TBL_ENTRY(0x037),
	TBL_ENTRY(0x038), TBL_ENTRY(0x039), TBL_ENTRY(0x03a), TBL_ENTRY(0x03b),
	TBL_ENTRY(0x03c), TBL_ENTRY(0x03d), TBL_ENTRY(0x03e), TBL_ENTRY(0x03f),
	TBL_ENTRY(0x040), TBL_ENTRY(0x041), TBL_ENTRY(0x042), TBL_ENTRY(0x043),
	TBL_ENTRY(0x044), TBL_ENTRY(0x045), TBL_ENTRY(0x046), TBL_ENTRY(0x047),
	TBL_ENTRY(0x048), TBL_ENTRY(0x049), TBL_ENTRY(0x04a), TBL_ENTRY(0x04b),
	TBL_ENTRY(0x04c), TBL_ENTRY(0x04d), TBL_ENTRY(0x04e), TBL_ENTRY(0x04f),
	TBL_ENTRY(0x050), TBL_ENTRY(0x051), TBL_ENTRY(0x052), TBL_ENTRY(0x053),
	TBL_ENTRY(0x054), TBL_ENTRY(0x055), TBL_ENTRY(0x056), TBL_ENTRY(0x057),
	TBL_ENTRY(0x058), TBL_ENTRY(0x059), TBL_ENTRY(0x05a), TBL_ENTRY(0x05b),
	TBL_ENTRY(0x05c), TBL_ENTRY(0x05d), TBL_ENTRY(0x05e), TBL_ENTRY(0x05f),
	TBL_ENTRY(0x060), TBL_ENTRY(0x061), TBL_ENTRY(0x062), TBL_ENTRY(0x063),
	TBL_ENTRY(0x064), TBL_ENTRY(0x065), TBL_ENTRY(0x066), TBL_ENTRY(0x067),
	TBL_ENTRY(0x068), TBL_ENTRY(0x069), TBL_ENTRY(0x06a), TBL_ENTRY(0x06b),
	TBL_ENTRY(0x06c), TBL_ENTRY(0x06d), TBL_ENTRY(0x06e), TBL_ENTRY(0x06f),
	TBL_ENTRY(0x070), TBL_ENTRY(0x071), TBL_ENTRY(0x072), TBL_ENTRY(0x073),
	TBL_ENTRY(0x074), TBL_ENTRY(0x075), TBL_ENTRY(0x076), TBL_ENTRY(0x077),
	TBL_ENTRY(0x078), TBL_ENTRY(0x079), TBL_ENTRY(0x07a), TBL_ENTRY(0x07b),
	TBL_ENTRY(0x07c), TBL_ENTRY(0x07d), TBL_ENTRY(0x07e), TBL_ENTRY(0x07f),
	TBL_ENTRY(0x080), TBL_ENTRY(0x081), TBL_ENTRY(0x082), TBL_ENTRY(0x083),
	TBL_ENTRY(0x084), TBL_ENTRY(0x085), TBL_ENTRY(0x086), TBL_ENTRY(0x087),
	TBL_ENTRY(0x088), TBL_ENTRY(0x089), TBL_ENTRY(0x08a), TBL_ENTRY(0x08b),
	TBL_ENTRY(0x08c), TBL_ENTRY(0x08d), TBL_ENTRY(0x08e), TBL_ENTRY(0x08f),
	TBL_ENTRY(0x090), TBL_ENTRY(0x091), TBL_ENTRY(0x092), TBL_ENTRY(0x093),
	TBL_ENTRY(0x094), TBL_ENTRY(0x095), TBL_ENTRY(0x096), TBL_ENTRY(0x097),
	TBL_ENTRY(0x098), TBL_ENTRY(0x099), TBL_ENTRY(0x09a), TBL_ENTRY(0x09b),
	TBL_ENTRY(0x09c), TBL_ENTRY(0x09d), TBL_ENTRY(0x09e), TBL_ENTRY(0x09f),
	TBL_ENTRY(0x0a0), TBL_ENTRY(0x0a1), TBL_ENTRY(0x0a2), TBL_ENTRY(0x0a3),
	TBL_ENTRY(0x0a4), TBL_ENTRY(0x0a5), TBL_ENTRY(0x0a6), TBL_ENTRY(0x0a7),
	TBL_ENTRY(0x0a8), TBL_ENTRY(0x0a9), TBL_ENTRY(0x0aa), TBL_ENTRY(0x0ab),
	TBL_ENTRY(0x0ac), TBL_ENTRY(0x0ad), TBL_ENTRY(0x0ae), TBL_ENTRY(0x0af),
	TBL_ENTRY(0x0b0), TBL_ENTRY(0x0b1), TBL_ENTRY(0x0b2), TBL_ENTRY(0x0b3),
	TBL_ENTRY(0x0b4), TBL_ENTRY(0x0b5), TBL_ENTRY(0x0b6), TBL_ENTRY(0x0b7),
	TBL_ENTRY(0x0b8), TBL_ENTRY(0x0b9), TBL_ENTRY(0x0ba), TBL_ENTRY(0x0bb),
	TBL_ENTRY(0x0bc), TBL_ENTRY(0x0bd), TBL_ENTRY(0x0be), TBL_ENTRY(0x0bf),
	TBL_ENTRY(0x0c0), TBL_ENTRY(0x0c1), TBL_ENTRY(0x0c2), TBL_ENTRY(0x0c3),
	TBL_ENTRY(0x0c4), TBL_ENTRY(0x0c5), TBL_ENTRY(0x0c6), TBL_ENTRY(0x0c7),
	TBL_ENTRY(0x0c8), TBL_ENTRY(0x0c9), TBL_ENTRY(0x0ca), TBL_ENTRY(0x0cb),
	TBL_ENTRY(0x0cc), TBL_ENTRY(0x0cd), TBL_ENTRY(0x0ce), TBL_ENTRY(0x0cf),
	TBL_ENTRY(0x0d0), TBL_ENTRY(0x0d1), TBL_ENTRY(0x0d2), TBL_ENTRY(0x0d3),
	TBL_ENTRY(0x0d4), TBL_ENTRY(0x0d5), TBL_ENTRY(0x0d6), TBL_ENTRY(0x0d7),
	TBL_ENTRY(0x0d8), TBL_ENTRY(0x0d9), TBL_ENTRY(0x0da), TBL_ENTRY(0x0db),
	TBL_ENTRY(0x0dc), TBL_ENTRY(0x0dd), TBL_ENTRY(0x0de), TBL_ENTRY(0x0df),
	TBL_ENTRY(0x0e0), TBL_ENTRY(0x0e1), TBL_ENTRY(0x0e2), TBL_ENTRY(0x0e3),
	TBL_ENTRY(0x0e4), TBL_ENTRY(0x0e5), TBL_ENTRY(0x0e6), TBL_ENTRY(0x0e7),
	TBL_ENTRY(0x0e8), TBL_ENTRY(0x0e9), TBL_ENTRY(0x0ea), TBL_ENTRY(0x0eb),
	TBL_ENTRY(0x0ec), TBL_ENTRY(0x0ed), TBL_ENTRY(0x0ee), TBL_ENTRY(0x0ef),
	TBL_ENTRY(0x0f0), TBL_ENTRY(0x0f1), TBL_ENTRY(0x0f2), TBL_ENTRY(0x0f3),
	TBL_ENTRY(0x0f4), TBL_ENTRY(0x0f5), TBL_ENTRY(0x0f6), TBL_ENTRY(0x0f7),
	TBL_ENTRY(0x0f8), TBL_ENTRY(0x0f9), TBL_ENTRY(0x0fa), TBL_ENTRY(0x0fb),
	TBL_ENTRY(0x0fc), TBL_ENTRY(0x0fd), TBL_ENTRY(0x0fe), TBL_ENTRY(0x0ff),
	TBL_ENTRY(0x100), TBL_ENTRY(0x101), TBL_ENTRY(0x102), TBL_ENTRY(0x103),
	TBL_ENTRY(0x104), TBL_ENTRY(0x105), TBL_ENTRY(0x106), TBL_ENTRY(0x107),
	TBL_ENTRY(0x108), TBL_ENTRY(0x109), TBL_ENTRY(0x10a), TBL_ENTRY(0x10b),
	TBL_ENTRY(0x10c), TBL_ENTRY(0x10d), TBL_ENTRY(0x10e), TBL_ENTRY(0x10f),
	TBL_ENTRY(0x110), TBL_ENTRY(0x111), TBL_ENTRY(0x112), TBL_ENTRY(0x113),
	TBL_ENTRY(0x114), TBL_ENTRY(0x115), TBL_ENTRY(0x116), TBL_ENTRY(0x117),
	TBL_ENTRY(0x118), TBL_ENTRY(0x119), TBL_ENTRY(0x11a), TBL_ENTRY(0x11b),
	TBL_ENTRY(0x11c), TBL_ENTRY(0x11d), TBL_ENTRY(0x11e), TBL_ENTRY(0x11f),
	TBL_ENTRY(0x120), TBL_ENTRY(0x121), TBL_ENTRY(0x122), TBL_ENTRY(0x123),
	TBL_ENTRY(0x124), TBL_ENTRY(0x125), TBL_ENTRY(0x126), TBL_ENTRY(0x127),
	TBL_ENTRY(0x128), TBL_ENTRY(0x129), TBL_ENTRY(0x12a), TBL_ENTRY(0x12b),
	TBL_ENTRY(0x12c), TBL_ENTRY(0x12d), TBL_ENTRY(0x12e), TBL_ENTRY(0x12f),
	TBL_ENTRY(0x130), TBL_ENTRY(0x131), TBL_ENTRY(0x132), TBL_ENTRY(0x133),
	TBL_ENTRY(0x134), TBL_ENTRY(0x135), TBL_ENTRY(0x136), TBL_ENTRY(0x137),
	TBL_ENTRY(0x138), TBL_ENTRY(0x139), TBL_ENTRY(0x13a), TBL_ENTRY(0x13b),
	TBL_ENTRY(0x13c), TBL_ENTRY(0x13d), TBL_ENTRY(0x13e), TBL_ENTRY(0x13f),
	TBL_ENTRY(0x140), TBL_ENTRY(0x141), TBL_ENTRY(0x142), TBL_ENTRY(0x143),
	TBL_ENTRY(0x144), TBL_ENTRY(0x145), TBL_ENTRY(0x146), TBL_ENTRY(0x147),
	TBL_ENTRY(0x148), TBL_ENTRY(0x149), TBL_ENTRY(0x14a), TBL_ENTRY(0x14b),
	TBL_ENTRY(0x14c), TBL_ENTRY(0x14d), TBL_ENTRY(0x14e), TBL_ENTRY(0x14f),
	TBL_ENTRY(0x150), TBL_ENTRY(0x151), TBL_ENTRY(0x152), TBL_ENTRY(0x153),
	TBL_ENTRY(0x154), TBL_ENTRY(0x155), TBL_ENTRY(0x156), TBL_ENTRY(0x157),
	TBL_ENTRY(0x158), TBL_ENTRY(0x159), TBL_ENTRY(0x15a), TBL_ENTRY(0x15b),
	TBL_ENTRY(0x15c), TBL_ENTRY(0x15d), TBL_ENTRY(0x15e), TBL_ENTRY(0x15f),
	TBL_ENTRY(0x160), TBL_ENTRY(0x161), TBL_ENTRY(0x162), TBL_ENTRY(0x163),
	TBL_ENTRY(0x164), TBL_ENTRY(0x165), TBL_ENTRY(0x166), TBL_ENTRY(0x167),
	TBL_ENTRY(0x168), TBL_ENTRY(0x169), TBL_ENTRY(0x16a), TBL_ENTRY(0x16b),
	TBL_ENTRY(0x16c), TBL_ENTRY(0x16d), TBL_ENTRY(0x16e), TBL_ENTRY(0x16f),
	TBL_ENTRY(0x170), TBL_ENTRY(0x171), TBL_ENTRY(0x172), TBL_ENTRY(0x173),
	TBL_ENTRY(0x174), TBL_ENTRY(0x175), TBL_ENTRY(0x176), TBL_ENTRY(0x177),
	TBL_ENTRY(0x178), TBL_ENTRY(0x179), TBL_ENTRY(0x17a), TBL_ENTRY(0x17b),
	TBL_ENTRY(0x17c), TBL_ENTRY(0x17d), TBL_ENTRY(0x17e), TBL_ENTRY(0x17f),
	TBL_ENTRY(0x180), TBL_ENTRY(0x181), TBL_ENTRY(0x182), TBL_ENTRY(0x183),
	TBL_ENTRY(0x184), TBL_ENTRY(0x185), TBL_ENTRY(0x186), TBL_ENTRY(0x187),
	TBL_ENTRY(0x188), TBL_ENTRY(0x189), TBL_ENTRY(0x18a), TBL_ENTRY(0x18b),
	TBL_ENTRY(0x18c), TBL_ENTRY(0x18d), TBL_ENTRY(0x18e), TBL_ENTRY(0x18f),
	TBL_ENTRY(0x190), TBL_ENTRY(0x191), TBL_ENTRY(0x192), TBL_ENTRY(0x193),
	TBL_ENTRY(0x194), TBL_ENTRY(0x195), TBL_ENTRY(0x196), TBL_ENTRY(0x197),
	TBL_ENTRY(0x198), TBL_ENTRY(0x199), TBL_ENTRY(0x19a), TBL_ENTRY(0x19b),
	TBL_ENTRY(0x19c), TBL_ENTRY(0x19d), TBL_ENTRY(0x19e), TBL_ENTRY(0x19f),
	TBL_ENTRY(0x1a0), TBL_ENTRY(0x1a1), TBL_ENTRY(0x1a2), TBL_ENTRY(0x1a3),
	TBL_ENTRY(0x1a4), TBL_ENTRY(0x1a5), TBL_ENTRY(0x1a6), TBL_ENTRY(0x1a7),
	TBL_ENTRY(0x1a8), TBL_ENTRY(0x1a9), TBL_ENTRY(0x1aa), TBL_ENTRY(0x1ab),
	TBL_ENTRY(0x1ac), TBL_ENTRY(0x1ad), TBL_ENTRY(0x1ae), TBL_ENTRY(0x1af),
	TBL_ENTRY(0x1b0), TBL_ENTRY(0x1b1), TBL_ENTRY(0x1b2), TBL_ENTRY(0x1b3),
	TBL_ENTRY(0x1b4), TBL_ENTRY(0x1b5), TBL_ENTRY(0x1b6), TBL_ENTRY(0x1b7),
	TBL_ENTRY(0x1b8), TBL_ENTRY(0x1b9), TBL_ENTRY(0x1ba), TBL_ENTRY(0x1bb),
	TBL_ENTRY(0x1bc), TBL_ENTRY(0x1bd), TBL_ENTRY(0x1be), TBL_ENTRY(0x1bf),
	TBL_ENTRY(0x1c0), TBL_ENTRY(0x1c1), TBL_ENTRY(0x1c2), TBL_ENTRY(0x1c3),
	TBL_ENTRY(0x1c4), TBL_ENTRY(0x1c5), TBL_ENTRY(0x1c6), TBL_ENTRY(0x1c7),
	TBL_ENTRY(0x1c8), TBL_ENTRY(0x1c9), TBL_ENTRY(0x1ca), TBL_ENTRY(0x1cb),
	TBL_ENTRY(0x1cc), TBL_ENTRY(0x1cd), TBL_ENTRY(0x1ce), TBL_ENTRY(0x1cf),
	TBL_ENTRY(0x1d0), TBL_ENTRY(0x1d1), TBL_ENTRY(0x1d2), TBL_ENTRY(0x1d3),
	TBL_ENTRY(0x1d4), TBL_ENTRY(0x1d5), TBL_ENTRY(0x1d6), TBL_ENTRY(0x1d7),
	TBL_ENTRY(0x1d8), TBL_ENTRY(0x1d9), TBL_ENTRY(0x1da), TBL_ENTRY(0x1db),
	TBL_ENTRY(0x1dc), TBL_ENTRY(0x1dd), TBL_ENTRY(0x1de), TBL_ENTRY(0x1df),
	TBL_ENTRY(0x1e0), TBL_ENTRY(0x1e1), TBL_ENTRY(0x1e2), TBL_ENTRY(0x1e3),
	TBL_ENTRY(0x1e4), TBL_ENTRY(0x1e5), TBL_ENTRY(0x1e6), TBL_ENTRY(0x1e7),
	TBL_ENTRY(0x1e8), TBL_ENTRY(0x1e9), TBL_ENTRY(0x1ea), TBL_ENTRY(0x1eb),
	TBL_ENTRY(0x1ec), TBL_ENTRY(0x1ed), TBL_ENTRY(0x1ee), TBL_ENTRY(0x1ef),
	TBL_ENTRY(0x1f0), TBL_ENTRY(0x1f1), TBL_ENTRY(0x1f2), TBL_ENTRY(0x1f3),
	TBL_ENTRY(0x1f4), TBL_ENTRY(0x1f5), TBL_ENTRY(0x1f6), TBL_ENTRY(0x1f7),
	TBL_ENTRY(0x1f8), TBL_ENTRY(0x1f9), TBL_ENTRY(0x1fa), TBL_ENTRY(0x1fb),
	TBL_ENTRY(0x1fc), TBL_ENTRY(0x1fd), TBL_ENTRY(0x1fe), TBL_ENTRY(0x1ff),
	TBL_ENTRY(0x200), TBL_ENTRY(0x201), TBL_ENTRY(0x202), TBL_ENTRY(0x203),
	TBL_ENTRY(0x204), TBL_ENTRY(0x205), TBL_ENTRY(0x206), TBL_ENTRY(0x207),
	TBL_ENTRY(0x208), TBL_ENTRY(0x209), TBL_ENTRY(0x20a), TBL_ENTRY(0x20b),
	TBL_ENTRY(0x20c), TBL_ENTRY(0x20d), TBL_ENTRY(0x20e), TBL_ENTRY(0x20f),
	TBL_ENTRY(0x210), TBL_ENTRY(0x211), TBL_ENTRY(0x212), TBL_ENTRY(0x213),
	TBL_ENTRY(0x214), TBL_ENTRY(0x215), TBL_ENTRY(0x216), TBL_ENTRY(0x217),
	TBL_ENTRY(0x218), TBL_ENTRY(0x219), TBL_ENTRY(0x21a), TBL_ENTRY(0x21b),
	TBL_ENTRY(0x21c), TBL_ENTRY(0x21d), TBL_ENTRY(0x21e), TBL_ENTRY(0x21f),
	TBL_ENTRY(0x220), TBL_ENTRY(0x221), TBL_ENTRY(0x222), TBL_ENTRY(0x223),
	TBL_ENTRY(0x224), TBL_ENTRY(0x225), TBL_ENTRY(0x226), TBL_ENTRY(0x227),
	TBL_ENTRY(0x228), TBL_ENTRY(0x229), TBL_ENTRY(0x22a), TBL_ENTRY(0x22b),
	TBL_ENTRY(0x22c), TBL_ENTRY(0x22d), TBL_ENTRY(0x22e), TBL_ENTRY(0x22f),
	TBL_ENTRY(0x230), TBL_ENTRY(0x231), TBL_ENTRY(0x232), TBL_ENTRY(0x233),
	TBL_ENTRY(0x234), TBL_ENTRY(0x235), TBL_ENTRY(0x236), TBL_ENTRY(0x237),
	TBL_ENTRY(0x238), TBL_ENTRY(0x239), TBL_ENTRY(0x23a), TBL_ENTRY(0x23b),
	TBL_ENTRY(0x23c), TBL_ENTRY(0x23d), TBL_ENTRY(0x23e), TBL_ENTRY(0x23f),
	TBL_ENTRY(0x240), TBL_ENTRY(0x241), TBL_ENTRY(0x242), TBL_ENTRY(0x243),
	TBL_ENTRY(0x244), TBL_ENTRY(0x245), TBL_ENTRY(0x246), TBL_ENTRY(0x247),
	TBL_ENTRY(0x248), TBL_ENTRY(0x249), TBL_ENTRY(0x24a), TBL_ENTRY(0x24b),
	TBL_ENTRY(0x24c), TBL_ENTRY(0x24d), TBL_ENTRY(0x24e), TBL_ENTRY(0x24f),
	TBL_ENTRY(0x250), TBL_ENTRY(0x251), TBL_ENTRY(0x252), TBL_ENTRY(0x253),
	TBL_ENTRY(0x254), TBL_ENTRY(0x255), TBL_ENTRY(0x256), TBL_ENTRY(0x257),
	TBL_ENTRY(0x258), TBL_ENTRY(0x259), TBL_ENTRY(0x25a), TBL_ENTRY(0x25b),
	TBL_ENTRY(0x25c), TBL_ENTRY(0x25d), TBL_ENTRY(0x25e), TBL_ENTRY(0x25f),
	TBL_ENTRY(0x260), TBL_ENTRY(0x261), TBL_ENTRY(0x262), TBL_ENTRY(0x263),
	TBL_ENTRY(0x264), TBL_ENTRY(0x265), TBL_ENTRY(0x266), TBL_ENTRY(0x267),
	TBL_ENTRY(0x268), TBL_ENTRY(0x269), TBL_ENTRY(0x26a), TBL_ENTRY(0x26b),
	TBL_ENTRY(0x26c), TBL_ENTRY(0x26d), TBL_ENTRY(0x26e), TBL_ENTRY(0x26f),
	TBL_ENTRY(0x270), TBL_ENTRY(0x271), TBL_ENTRY(0x272), TBL_ENTRY(0x273),
	TBL_ENTRY(0x274), TBL_ENTRY(0x275), TBL_ENTRY(0x276), TBL_ENTRY(0x277),
	TBL_ENTRY(0x278), TBL_ENTRY(0x279), TBL_ENTRY(0x27a), TBL_ENTRY(0x27b),
	TBL_ENTRY(0x27c), TBL_ENTRY(0x27d), TBL_ENTRY(0x27e), TBL_ENTRY(0x27f),
	TBL_ENTRY(0x280), TBL_ENTRY(0x281), TBL_ENTRY(0x282), TBL_ENTRY(0x283),
	TBL_ENTRY(0x284), TBL_ENTRY(0x285), TBL_ENTRY(0x286), TBL_ENTRY(0x287),
	TBL_ENTRY(0x288), TBL_ENTRY(0x289), TBL_ENTRY(0x28a), TBL_ENTRY(0x28b),
	TBL_ENTRY(0x28c), TBL_ENTRY(0x28d), TBL_ENTRY(0x28e), TBL_ENTRY(0x28f),
	TBL_ENTRY(0x290), TBL_ENTRY(0x291), TBL_ENTRY(0x292), TBL_ENTRY(0x293),
	TBL_ENTRY(0x294), TBL_ENTRY(0x295), TBL_ENTRY(0x296), TBL_ENTRY(0x297),
	TBL_ENTRY(0x298), TBL_ENTRY(0x299), TBL_ENTRY(0x29a), TBL_ENTRY(0x29b),
	TBL_ENTRY(0x29c), TBL_ENTRY(0x29d), TBL_ENTRY(0x29e), TBL_ENTRY(0x29f),
	TBL_ENTRY(0x2a0), TBL_ENTRY(0x2a1), TBL_ENTRY(0x2a2), TBL_ENTRY(0x2a3),
	TBL_ENTRY(0x2a4), TBL_ENTRY(0x2a5), TBL_ENTRY(0x2a6), TBL_ENTRY(0x2a7),
	TBL_ENTRY(0x2a8), TBL_ENTRY(0x2a9), TBL_ENTRY(0x2aa), TBL_ENTRY(0x2ab),
	TBL_ENTRY(0x2ac), TBL_ENTRY(0x2ad), TBL_ENTRY(0x2ae), TBL_ENTRY(0x2af),
	TBL_ENTRY(0x2b0), TBL_ENTRY(0x2b1), TBL_ENTRY(0x2b2), TBL_ENTRY(0x2b3),
	TBL_ENTRY(0x2b4), TBL_ENTRY(0x2b5), TBL_ENTRY(0x2b6), TBL_ENTRY(0x2b7),
	TBL_ENTRY(0x2b8), TBL_ENTRY(0x2b9), TBL_ENTRY(0x2ba), TBL_ENTRY(0x2bb),
	TBL_ENTRY(0x2bc), TBL_ENTRY(0x2bd), TBL_ENTRY(0x2be), TBL_ENTRY(0x2bf),
	TBL_ENTRY(0x2c0), TBL_ENTRY(0x2c1), TBL_ENTRY(0x2c2), TBL_ENTRY(0x2c3),
	TBL_ENTRY(0x2c4), TBL_ENTRY(0x2c5), TBL_ENTRY(0x2c6), TBL_ENTRY(0x2c7),
	TBL_ENTRY(0x2c8), TBL_ENTRY(0x2c9), TBL_ENTRY(0x2ca), TBL_ENTRY(0x2cb),
	TBL_ENTRY(0x2cc), TBL_ENTRY(0x2cd), TBL_ENTRY(0x2ce), TBL_ENTRY(0x2cf),
	TBL_ENTRY(0x2d0), TBL_ENTRY(0x2d1), TBL_ENTRY(0x2d2), TBL_ENTRY(0x2d3),
	TBL_ENTRY(0x2d4), TBL_ENTRY(0x2d5), TBL_ENTRY(0x2d6), TBL_ENTRY(0x2d7),
	TBL_ENTRY(0x2d8), TBL_ENTRY(0x2d9), TBL_ENTRY(0x2da), TBL_ENTRY(0x2db),
	TBL_ENTRY(0x2dc), TBL_ENTRY(0x2dd), TBL_ENTRY(0x2de), TBL_ENTRY(0x2df),
	TBL_ENTRY(0x2e0), TBL_ENTRY(0x2e1), TBL_ENTRY(0x2e2), TBL_ENTRY(0x2e3),
	TBL_ENTRY(0x2e4), TBL_ENTRY(0x2e5), TBL_ENTRY(0x2e6), TBL_ENTRY(0x2e7),
	TBL_ENTRY(0x2e8), TBL_ENTRY(0x2e9), TBL_ENTRY(0x2ea), TBL_ENTRY(0x2eb),
	TBL_ENTRY(0x2ec), TBL_ENTRY(0x2ed), TBL_ENTRY(0x2ee), TBL_ENTRY(0x2ef),
	TBL_ENTRY(0x2f0), TBL_ENTRY(0x2f1), TBL_ENTRY(0x2f2), TBL_ENTRY(0x2f3),
	TBL_ENTRY(0x2f4), TBL_ENTRY(0x2f5), TBL_ENTRY(0x2f6), TBL_ENTRY(0x2f7),
	TBL_ENTRY(0x2f8), TBL_ENTRY(0x2f9), TBL_ENTRY(0x2fa), TBL_ENTRY(0x2fb),
	TBL_ENTRY(0x2fc), TBL_ENTRY(0x2fd), TBL_ENTRY(0x2fe), TBL_ENTRY(0x2ff),
	TBL_ENTRY(0x300), TBL_ENTRY(0x301), TBL_ENTRY(0x302), TBL_ENTRY(0x303),
	TBL_ENTRY(0x304), TBL_ENTRY(0x305), TBL_ENTRY(0x306), TBL_ENTRY(0x307),
	TBL_ENTRY(0x308), TBL_ENTRY(0x309), TBL_ENTRY(0x30a), TBL_ENTRY(0x30b),
	TBL_ENTRY(0x30c), TBL_ENTRY(0x30d), TBL_ENTRY(0x30e), TBL_ENTRY(0x30f),
	TBL_ENTRY(0x310), TBL_ENTRY(0x311), TBL_ENTRY(0x312), TBL_ENTRY(0x313),
	TBL_ENTRY(0x314), TBL_ENTRY(0x315), TBL_ENTRY(0x316), TBL_ENTRY(0x317),
	TBL_ENTRY(0x318), TBL_ENTRY(0x319), TBL_ENTRY(0x31a), TBL_ENTRY(0x31b),
	TBL_ENTRY(0x31c), TBL_ENTRY(0x31d), TBL_ENTRY(0x31e), TBL_ENTRY(0x31f),
	TBL_ENTRY(0x320), TBL_ENTRY(0x321), TBL_ENTRY(0x322), TBL_ENTRY(0x323),
	TBL_ENTRY(0x324), TBL_ENTRY(0x325), TBL_ENTRY(0x326), TBL_ENTRY(0x327),
	TBL_ENTRY(0x328), TBL_ENTRY(0x329), TBL_ENTRY(0x32a), TBL_ENTRY(0x32b),
	TBL_ENTRY(0x32c), TBL_ENTRY(0x32d), TBL_ENTRY(0x32e), TBL_ENTRY(0x32f),
	TBL_ENTRY(0x330), TBL_ENTRY(0x331), TBL_ENTRY(0x332), TBL_ENTRY(0x333),
	TBL_ENTRY(0x334), TBL_ENTRY(0x335), TBL_ENTRY(0x336), TBL_ENTRY(0x337),
	TBL_ENTRY(0x338), TBL_ENTRY(0x339), TBL_ENTRY(0x33a), TBL_ENTRY(0x33b),
	TBL_ENTRY(0x33c), TBL_ENTRY(0x33d), TBL_ENTRY(0x33e), TBL_ENTRY(0x33f),
	TBL_ENTRY(0x340), TBL_ENTRY(0x341), TBL_ENTRY(0x342), TBL_ENTRY(0x343),
	TBL_ENTRY(0x344), TBL_ENTRY(0x345), TBL_ENTRY(0x346), TBL_ENTRY(0x347),
	TBL_ENTRY(0x348), TBL_ENTRY(0x349), TBL_ENTRY(0x34a), TBL_ENTRY(0x34b),
	TBL_ENTRY(0x34c), TBL_ENTRY(0x34d), TBL_ENTRY(0x34e), TBL_ENTRY(0x34f),
	TBL_ENTRY(0x350), TBL_ENTRY(0x351), TBL_ENTRY(0x352), TBL_ENTRY(0x353),
	TBL_ENTRY(0x354), TBL_ENTRY(0x355), TBL_ENTRY(0x356), TBL_ENTRY(0x357),
	TBL_ENTRY(0x358), TBL_ENTRY(0x359), TBL_ENTRY(0x35a), TBL_ENTRY(0x35b),
	TBL_ENTRY(0x35c), TBL_ENTRY(0x35d), TBL_ENTRY(0x35e), TBL_ENTRY(0x35f),
	TBL_ENTRY(0x360), TBL_ENTRY(0x361), TBL_ENTRY(0x362), TBL_ENTRY(0x363),
	TBL_ENTRY(0x364), TBL_ENTRY(0x365), TBL_ENTRY(0x366), TBL_ENTRY(0x367),
	TBL_ENTRY(0x368), TBL_ENTRY(0x369), TBL_ENTRY(0x36a), TBL_ENTRY(0x36b),
	TBL_ENTRY(0x36c), TBL_ENTRY(0x36d), TBL_ENTRY(0x36e), TBL_ENTRY(0x36f),
	TBL_ENTRY(0x370), TBL_ENTRY(0x371), TBL_ENTRY(0x372), TBL_ENTRY(0x373),
	TBL_ENTRY(0x374), TBL_ENTRY(0x375), TBL_ENTRY(0x376), TBL_ENTRY(0x377),
	TBL_ENTRY(0x378), TBL_ENTRY(0x379), TBL_ENTRY(0x37a), TBL_ENTRY(0x37b),
	TBL_ENTRY(0x37c), TBL_ENTRY(0x37d), TBL_ENTRY(0x37e), TBL_ENTRY(0x37f),
	TBL_ENTRY(0x380), TBL_ENTRY(0x381), TBL_ENTRY(0x382), TBL_ENTRY(0x383),
	TBL_ENTRY(0x384), TBL_ENTRY(0x385), TBL_ENTRY(0x386), TBL_ENTRY(0x387),
	TBL_ENTRY(0x388), TBL_ENTRY(0x389), TBL_ENTRY(0x38a), TBL_ENTRY(0x38b),
	TBL_ENTRY(0x38c), TBL_ENTRY(0x38d), TBL_ENTRY(0x38e), TBL_ENTRY(0x38f),
	TBL_ENTRY(0x390), TBL_ENTRY(0x391), TBL_ENTRY(0x392), TBL_ENTRY(0x393),
	TBL_ENTRY(0x394), TBL_ENTRY(0x395), TBL_ENTRY(0x396), TBL_ENTRY(0x397),
	TBL_ENTRY(0x398), TBL_ENTRY(0x399), TBL_ENTRY(0x39a), TBL_ENTRY(0x39b),
	TBL_ENTRY(0x39c), TBL_ENTRY(0x39d), TBL_ENTRY(0x39e), TBL_ENTRY(0x39f),
	TBL_ENTRY(0x3a0), TBL_ENTRY(0x3a1), TBL_ENTRY(0x3a2), TBL_ENTRY(0x3a3),
	TBL_ENTRY(0x3a4), TBL_ENTRY(0x3a5), TBL_ENTRY(0x3a6), TBL_ENTRY(0x3a7),
	TBL_ENTRY(0x3a8), TBL_ENTRY(0x3a9), TBL_ENTRY(0x3aa), TBL_ENTRY(0x3ab),
	TBL_ENTRY(0x3ac), TBL_ENTRY(0x3ad), TBL_ENTRY(0x3ae), TBL_ENTRY(0x3af),
	TBL_ENTRY(0x3b0), TBL_ENTRY(0x3b1), TBL_ENTRY(0x3b2), TBL_ENTRY(0x3b3),
	TBL_ENTRY(0x3b4), TBL_ENTRY(0x3b5), TBL_ENTRY(0x3b6), TBL_ENTRY(0x3b7),
	TBL_ENTRY(0x3b8), TBL_ENTRY(0x3b9), TBL_ENTRY(0x3ba), TBL_ENTRY(0x3bb),
	TBL_ENTRY(0x3bc), TBL_ENTRY(0x3bd), TBL_ENTRY(0x3be), TBL_ENTRY(0x3bf),
	TBL_ENTRY(0x3c0), TBL_ENTRY(0x3c1), TBL_ENTRY(0x3c2), TBL_ENTRY(0x3c3),
	TBL_ENTRY(0x3c4), TBL_ENTRY(0x3c5), TBL_ENTRY(0x3c6), TBL_ENTRY(0x3c7),
	TBL_ENTRY(0x3c8), TBL_ENTRY(0x3c9), TBL_ENTRY(0x3ca), TBL_ENTRY(0x3cb),
	TBL_ENTRY(0x3cc), TBL_ENTRY(0x3cd), TBL_ENTRY(0x3ce), TBL_ENTRY(0x3cf),
	TBL_ENTRY(0x3d0), TBL_ENTRY(0x3d1), TBL_ENTRY(0x3d2), TBL_ENTRY(0x3d3),
	TBL_ENTRY(0x3d4), TBL_ENTRY(0x3d5), TBL_ENTRY(0x3d6), TBL_ENTRY(0x3d7),
	TBL_ENTRY(0x3d8), TBL_ENTRY(0x3d9), TBL_ENTRY(0x3da), TBL_ENTRY(0x3db),
	TBL_ENTRY(0x3dc), TBL_ENTRY(0x3dd), TBL_ENTRY(0x3de), TBL_ENTRY(0x3df),
	TBL_ENTRY(0x3e0), TBL_ENTRY(0x3e1), TBL_ENTRY(0x3e2), TBL_ENTRY(0x3e3),
	TBL_ENTRY(0x3e4), TBL_ENTRY(0x3e5), TBL_ENTRY(0x3e6), TBL_ENTRY(0x3e7),
	TBL_ENTRY(0x3e8), TBL_ENTRY(0x3e9), TBL_ENTRY(0x3ea), TBL_ENTRY(0x3eb),
	TBL_ENTRY(0x3ec), TBL_ENTRY(0x3ed), TBL_ENTRY(0x3ee), TBL_ENTRY(0x3ef),
	TBL_ENTRY(0x3f0), TBL_ENTRY(0x3f1), TBL_ENTRY(0x3f2), TBL_ENTRY(0x3f3),
	TBL_ENTRY(0x3f4), TBL_ENTRY(0x3f5), TBL_ENTRY(0x3f6), TBL_ENTRY(0x3f7),
	TBL_ENTRY(0x3f8), TBL_ENTRY(0x3f9), TBL_ENTRY(0x3fa), TBL_ENTRY(0x3fb),
	TBL_ENTRY(0x3fc), TBL_ENTRY(0x3fd), TBL_ENTRY(0x3fe), TBL_ENTRY(0x3ff),
	TBL_ENTRY(0x400), TBL_ENTRY(0x401), TBL_ENTRY(0x402), TBL_ENTRY(0x403),
	TBL_ENTRY(0x404), TBL_ENTRY(0x405), TBL_ENTRY(0x406), TBL_ENTRY(0x407),
	TBL_ENTRY(0x408), TBL_ENTRY(0x409), TBL_ENTRY(0x40a), TBL_ENTRY(0x40b),
	TBL_ENTRY(0x40c), TBL_ENTRY(0x40d), TBL_ENTRY(0x40e), TBL_ENTRY(0x40f),
	TBL_ENTRY(0x410), TBL_ENTRY(0x411), TBL_ENTRY(0x412), TBL_ENTRY(0x413),
	TBL_ENTRY(0x414), TBL_ENTRY(0x415), TBL_ENTRY(0x416), TBL_ENTRY(0x417),
	TBL_ENTRY(0x418), TBL_ENTRY(0x419), TBL_ENTRY(0x41a), TBL_ENTRY(0x41b),
	TBL_ENTRY(0x41c), TBL_ENTRY(0x41d), TBL_ENTRY(0x41e), TBL_ENTRY(0x41f),
	TBL_ENTRY(0x420), TBL_ENTRY(0x421), TBL_ENTRY(0x422), TBL_ENTRY(0x423),
	TBL_ENTRY(0x424), TBL_ENTRY(0x425), TBL_ENTRY(0x426), TBL_ENTRY(0x427),
	TBL_ENTRY(0x428), TBL_ENTRY(0x429), TBL_ENTRY(0x42a), TBL_ENTRY(0x42b),
	TBL_ENTRY(0x42c), TBL_ENTRY(0x42d), TBL_ENTRY(0x42e), TBL_ENTRY(0x42f),
	TBL_ENTRY(0x430), TBL_ENTRY(0x431), TBL_ENTRY(0x432), TBL_ENTRY(0x433),
	TBL_ENTRY(0x434), TBL_ENTRY(0x435), TBL_ENTRY(0x436), TBL_ENTRY(0x437),
	TBL_ENTRY(0x438), TBL_ENTRY(0x439), TBL_ENTRY(0x43a), TBL_ENTRY(0x43b),
	TBL_ENTRY(0x43c), TBL_ENTRY(0x43d), TBL_ENTRY(0x43e), TBL_ENTRY(0x43f),
	TBL_ENTRY(0x440), TBL_ENTRY(0x441), TBL_ENTRY(0x442), TBL_ENTRY(0x443),
	TBL_ENTRY(0x444), TBL_ENTRY(0x445), TBL_ENTRY(0x446), TBL_ENTRY(0x447),
	TBL_ENTRY(0x448), TBL_ENTRY(0x449), TBL_ENTRY(0x44a), TBL_ENTRY(0x44b),
	TBL_ENTRY(0x44c), TBL_ENTRY(0x44d), TBL_ENTRY(0x44e), TBL_ENTRY(0x44f),
	TBL_ENTRY(0x450), TBL_ENTRY(0x451), TBL_ENTRY(0x452), TBL_ENTRY(0x453),
	TBL_ENTRY(0x454), TBL_ENTRY(0x455), TBL_ENTRY(0x456), TBL_ENTRY(0x457),
	TBL_ENTRY(0x458), TBL_ENTRY(0x459), TBL_ENTRY(0x45a), TBL_ENTRY(0x45b),
	TBL_ENTRY(0x45c), TBL_ENTRY(0x45d), TBL_ENTRY(0x45e), TBL_ENTRY(0x45f),
	TBL_ENTRY(0x460), TBL_ENTRY(0x461), TBL_ENTRY(0x462), TBL_ENTRY(0x463),
	TBL_ENTRY(0x464), TBL_ENTRY(0x465), TBL_ENTRY(0x466), TBL_ENTRY(0x467),
	TBL_ENTRY(0x468), TBL_ENTRY(0x469), TBL_ENTRY(0x46a), TBL_ENTRY(0x46b),
	TBL_ENTRY(0x46c), TBL_ENTRY(0x46d), TBL_ENTRY(0x46e), TBL_ENTRY(0x46f),
	TBL_ENTRY(0x470), TBL_ENTRY(0x471), TBL_ENTRY(0x472), TBL_ENTRY(0x473),
	TBL_ENTRY(0x474), TBL_ENTRY(0x475), TBL_ENTRY(0x476), TBL_ENTRY(0x477),
	TBL_ENTRY(0x478), TBL_ENTRY(0x479), TBL_ENTRY(0x47a), TBL_ENTRY(0x47b),
	TBL_ENTRY(0x47c), TBL_ENTRY(0x47d), TBL_ENTRY(0x47e), TBL_ENTRY(0x47f),
	TBL_ENTRY(0x480), TBL_ENTRY(0x481), TBL_ENTRY(0x482), TBL_ENTRY(0x483),
	TBL_ENTRY(0x484), TBL_ENTRY(0x485), TBL_ENTRY(0x486), TBL_ENTRY(0x487),
	TBL_ENTRY(0x488), TBL_ENTRY(0x489), TBL_ENTRY(0x48a), TBL_ENTRY(0x48b),
	TBL_ENTRY(0x48c), TBL_ENTRY(0x48d), TBL_ENTRY(0x48e), TBL_ENTRY(0x48f),
	TBL_ENTRY(0x490), TBL_ENTRY(0x491), TBL_ENTRY(0x492), TBL_ENTRY(0x493),
	TBL_ENTRY(0x494), TBL_ENTRY(0x495), TBL_ENTRY(0x496), TBL_ENTRY(0x497),
	TBL_ENTRY(0x498), TBL_ENTRY(0x499), TBL_ENTRY(0x49a), TBL_ENTRY(0x49b),
	TBL_ENTRY(0x49c), TBL_ENTRY(0x49d), TBL_ENTRY(0x49e), TBL_ENTRY(0x49f),
	TBL_ENTRY(0x4a0), TBL_ENTRY(0x4a1), TBL_ENTRY(0x4a2), TBL_ENTRY(0x4a3),
	TBL_ENTRY(0x4a4), TBL_ENTRY(0x4a5), TBL_ENTRY(0x4a6), TBL_ENTRY(0x4a7),
	TBL_ENTRY(0x4a8), TBL_ENTRY(0x4a9), TBL_ENTRY(0x4aa), TBL_ENTRY(0x4ab),
	TBL_ENTRY(0x4ac), TBL_ENTRY(0x4ad), TBL_ENTRY(0x4ae), TBL_ENTRY(0x4af),
	TBL_ENTRY(0x4b0), TBL_ENTRY(0x4b1), TBL_ENTRY(0x4b2), TBL_ENTRY(0x4b3),
	TBL_ENTRY(0x4b4), TBL_ENTRY(0x4b5), TBL_ENTRY(0x4b6), TBL_ENTRY(0x4b7),
	TBL_ENTRY(0x4b8), TBL_ENTRY(0x4b9), TBL_ENTRY(0x4ba), TBL_ENTRY(0x4bb),
	TBL_ENTRY(0x4bc), TBL_ENTRY(0x4bd), TBL_ENTRY(0x4be), TBL_ENTRY(0x4bf),
	TBL_ENTRY(0x4c0), TBL_ENTRY(0x4c1), TBL_ENTRY(0x4c2), TBL_ENTRY(0x4c3),
	TBL_ENTRY(0x4c4), TBL_ENTRY(0x4c5), TBL_ENTRY(0x4c6), TBL_ENTRY(0x4c7),
	TBL_ENTRY(0x4c8), TBL_ENTRY(0x4c9), TBL_ENTRY(0x4ca), TBL_ENTRY(0x4cb),
	TBL_ENTRY(0x4cc), TBL_ENTRY(0x4cd), TBL_ENTRY(0x4ce), TBL_ENTRY(0x4cf),
	TBL_ENTRY(0x4d0), TBL_ENTRY(0x4d1), TBL_ENTRY(0x4d2), TBL_ENTRY(0x4d3),
	TBL_ENTRY(0x4d4), TBL_ENTRY(0x4d5), TBL_ENTRY(0x4d6), TBL_ENTRY(0x4d7),
	TBL_ENTRY(0x4d8), TBL_ENTRY(0x4d9), TBL_ENTRY(0x4da), TBL_ENTRY(0x4db),
	TBL_ENTRY(0x4dc), TBL_ENTRY(0x4dd), TBL_ENTRY(0x4de), TBL_ENTRY(0x4df),
	TBL_ENTRY(0x4e0), TBL_ENTRY(0x4e1), TBL_ENTRY(0x4e2), TBL_ENTRY(0x4e3),
	TBL_ENTRY(0x4e4), TBL_ENTRY(0x4e5), TBL_ENTRY(0x4e6), TBL_ENTRY(0x4e7),
	TBL_ENTRY(0x4e8), TBL_ENTRY(0x4e9), TBL_ENTRY(0x4ea), TBL_ENTRY(0x4eb),
	TBL_ENTRY(0x4ec), TBL_ENTRY(0x4ed), TBL_ENTRY(0x4ee), TBL_ENTRY(0x4ef),
	TBL_ENTRY(0x4f0), TBL_ENTRY(0x4f1), TBL_ENTRY(0x4f2), TBL_ENTRY(0x4f3),
	TBL_ENTRY(0x4f4), TBL_ENTRY(0x4f5), TBL_ENTRY(0x4f6), TBL_ENTRY(0x4f7),
	TBL_ENTRY(0x4f8), TBL_ENTRY(0x4f9), TBL_ENTRY(0x4fa), TBL_ENTRY(0x4fb),
	TBL_ENTRY(0x4fc), TBL_ENTRY(0x4fd), TBL_ENTRY(0x4fe), TBL_ENTRY(0x4ff),
	TBL_ENTRY(0x500), TBL_ENTRY(0x501), TBL_ENTRY(0x502), TBL_ENTRY(0x503),
	TBL_ENTRY(0x504), TBL_ENTRY(0x505), TBL_ENTRY(0x506), TBL_ENTRY(0x507),
	TBL_ENTRY(0x508), TBL_ENTRY(0x509), TBL_ENTRY(0x50a), TBL_ENTRY(0x50b),
	TBL_ENTRY(0x50c), TBL_ENTRY(0x50d), TBL_ENTRY(0x50e), TBL_ENTRY(0x50f),
	TBL_ENTRY(0x510), TBL_ENTRY(0x511), TBL_ENTRY(0x512), TBL_ENTRY(0x513),
	TBL_ENTRY(0x514), TBL_ENTRY(0x515), TBL_ENTRY(0x516), TBL_ENTRY(0x517),
	TBL_ENTRY(0x518), TBL_ENTRY(0x519), TBL_ENTRY(0x51a), TBL_ENTRY(0x51b),
	TBL_ENTRY(0x51c), TBL_ENTRY(0x51d), TBL_ENTRY(0x51e), TBL_ENTRY(0x51f),
	TBL_ENTRY(0x520), TBL_ENTRY(0x521), TBL_ENTRY(0x522), TBL_ENTRY(0x523),
	TBL_ENTRY(0x524), TBL_ENTRY(0x525), TBL_ENTRY(0x526), TBL_ENTRY(0x527),
	TBL_ENTRY(0x528), TBL_ENTRY(0x529), TBL_ENTRY(0x52a), TBL_ENTRY(0x52b),
	TBL_ENTRY(0x52c), TBL_ENTRY(0x52d), TBL_ENTRY(0x52e), TBL_ENTRY(0x52f),
	TBL_ENTRY(0x530), TBL_ENTRY(0x531), TBL_ENTRY(0x532), TBL_ENTRY(0x533),
	TBL_ENTRY(0x534), TBL_ENTRY(0x535), TBL_ENTRY(0x536), TBL_ENTRY(0x537),
	TBL_ENTRY(0x538), TBL_ENTRY(0x539), TBL_ENTRY(0x53a), TBL_ENTRY(0x53b),
	TBL_ENTRY(0x53c), TBL_ENTRY(0x53d), TBL_ENTRY(0x53e), TBL_ENTRY(0x53f),
	TBL_ENTRY(0x540), TBL_ENTRY(0x541), TBL_ENTRY(0x542), TBL_ENTRY(0x543),
	TBL_ENTRY(0x544), TBL_ENTRY(0x545), TBL_ENTRY(0x546), TBL_ENTRY(0x547),
	TBL_ENTRY(0x548), TBL_ENTRY(0x549), TBL_ENTRY(0x54a), TBL_ENTRY(0x54b),
	TBL_ENTRY(0x54c), TBL_ENTRY(0x54d), TBL_ENTRY(0x54e), TBL_ENTRY(0x54f),
	TBL_ENTRY(0x550), TBL_ENTRY(0x551), TBL_ENTRY(0x552), TBL_ENTRY(0x553),
	TBL_ENTRY(0x554), TBL_ENTRY(0x555), TBL_ENTRY(0x556), TBL_ENTRY(0x557),
	TBL_ENTRY(0x558), TBL_ENTRY(0x559), TBL_ENTRY(0x55a), TBL_ENTRY(0x55b),
	TBL_ENTRY(0x55c), TBL_ENTRY(0x55d), TBL_ENTRY(0x55e), TBL_ENTRY(0x55f),
	TBL_ENTRY(0x560), TBL_ENTRY(0x561), TBL_ENTRY(0x562), TBL_ENTRY(0x563),
	TBL_ENTRY(0x564), TBL_ENTRY(0x565), TBL_ENTRY(0x566), TBL_ENTRY(0x567),
	TBL_ENTRY(0x568), TBL_ENTRY(0x569), TBL_ENTRY(0x56a), TBL_ENTRY(0x56b),
	TBL_ENTRY(0x56c), TBL_ENTRY(0x56d), TBL_ENTRY(0x56e), TBL_ENTRY(0x56f),
	TBL_ENTRY(0x570), TBL_ENTRY(0x571), TBL_ENTRY(0x572), TBL_ENTRY(0x573),
	TBL_ENTRY(0x574), TBL_ENTRY(0x575), TBL_ENTRY(0x576), TBL_ENTRY(0x577),
	TBL_ENTRY(0x578), TBL_ENTRY(0x579), TBL_ENTRY(0x57a), TBL_ENTRY(0x57b),
	TBL_ENTRY(0x57c), TBL_ENTRY(0x57d), TBL_ENTRY(0x57e), TBL_ENTRY(0x57f),
	TBL_ENTRY(0x580), TBL_ENTRY(0x581), TBL_ENTRY(0x582), TBL_ENTRY(0x583),
	TBL_ENTRY(0x584), TBL_ENTRY(0x585), TBL_ENTRY(0x586), TBL_ENTRY(0x587),
	TBL_ENTRY(0x588), TBL_ENTRY(0x589), TBL_ENTRY(0x58a), TBL_ENTRY(0x58b),
	TBL_ENTRY(0x58c), TBL_ENTRY(0x58d), TBL_ENTRY(0x58e), TBL_ENTRY(0x58f),
	TBL_ENTRY(0x590), TBL_ENTRY(0x591), TBL_ENTRY(0x592), TBL_ENTRY(0x593),
	TBL_ENTRY(0x594), TBL_ENTRY(0x595), TBL_ENTRY(0x596), TBL_ENTRY(0x597),
	TBL_ENTRY(0x598), TBL_ENTRY(0x599), TBL_ENTRY(0x59a), TBL_ENTRY(0x59b),
	TBL_ENTRY(0x59c), TBL_ENTRY(0x59d), TBL_ENTRY(0x59e), TBL_ENTRY(0x59f),
	TBL_ENTRY(0x5a0), TBL_ENTRY(0x5a1), TBL_ENTRY(0x5a2), TBL_ENTRY(0x5a3),
	TBL_ENTRY(0x5a4), TBL_ENTRY(0x5a5), TBL_ENTRY(0x5a6), TBL_ENTRY(0x5a7),
	TBL_ENTRY(0x5a8), TBL_ENTRY(0x5a9), TBL_ENTRY(0x5aa), TBL_ENTRY(0x5ab),
	TBL_ENTRY(0x5ac), TBL_ENTRY(0x5ad), TBL_ENTRY(0x5ae), TBL_ENTRY(0x5af),
	TBL_ENTRY(0x5b0), TBL_ENTRY(0x5b1), TBL_ENTRY(0x5b2), TBL_ENTRY(0x5b3),
	TBL_ENTRY(0x5b4), TBL_ENTRY(0x5b5), TBL_ENTRY(0x5b6), TBL_ENTRY(0x5b7),
	TBL_ENTRY(0x5b8), TBL_ENTRY(0x5b9), TBL_ENTRY(0x5ba), TBL_ENTRY(0x5bb),
	TBL_ENTRY(0x5bc), TBL_ENTRY(0x5bd), TBL_ENTRY(0x5be), TBL_ENTRY(0x5bf),
	TBL_ENTRY(0x5c0), TBL_ENTRY(0x5c1), TBL_ENTRY(0x5c2), TBL_ENTRY(0x5c3),
	TBL_ENTRY(0x5c4), TBL_ENTRY(0x5c5), TBL_ENTRY(0x5c6), TBL_ENTRY(0x5c7),
	TBL_ENTRY(0x5c8), TBL_ENTRY(0x5c9), TBL_ENTRY(0x5ca), TBL_ENTRY(0x5cb),
	TBL_ENTRY(0x5cc), TBL_ENTRY(0x5cd), TBL_ENTRY(0x5ce), TBL_ENTRY(0x5cf),
	TBL_ENTRY(0x5d0), TBL_ENTRY(0x5d1), TBL_ENTRY(0x5d2), TBL_ENTRY(0x5d3),
	TBL_ENTRY(0x5d4), TBL_ENTRY(0x5d5), TBL_ENTRY(0x5d6), TBL_ENTRY(0x5d7),
	TBL_ENTRY(0x5d8), TBL_ENTRY(0x5d9), TBL_ENTRY(0x5da), TBL_ENTRY(0x5db),
	TBL_ENTRY(0x5dc), TBL_ENTRY(0x5dd), TBL_ENTRY(0x5de), TBL_ENTRY(0x5df),
	TBL_ENTRY(0x5e0), TBL_ENTRY(0x5e1), TBL_ENTRY(0x5e2), TBL_ENTRY(0x5e3),
	TBL_ENTRY(0x5e4), TBL_ENTRY(0x5e5), TBL_ENTRY(0x5e6), TBL_ENTRY(0x5e7),
	TBL_ENTRY(0x5e8), TBL_ENTRY(0x5e9), TBL_ENTRY(0x5ea), TBL_ENTRY(0x5eb),
	TBL_ENTRY(0x5ec), TBL_ENTRY(0x5ed), TBL_ENTRY(0x5ee), TBL_ENTRY(0x5ef),
	TBL_ENTRY(0x5f0), TBL_ENTRY(0x5f1), TBL_ENTRY(0x5f2), TBL_ENTRY(0x5f3),
	TBL_ENTRY(0x5f4), TBL_ENTRY(0x5f5), TBL_ENTRY(0x5f6), TBL_ENTRY(0x5f7),
	TBL_ENTRY(0x5f8), TBL_ENTRY(0x5f9), TBL_ENTRY(0x5fa), TBL_ENTRY(0x5fb),
	TBL_ENTRY(0x5fc), TBL_ENTRY(0x5fd), TBL_ENTRY(0x5fe), TBL_ENTRY(0x5ff),
	TBL_ENTRY(0x600), TBL_ENTRY(0x601), TBL_ENTRY(0x602), TBL_ENTRY(0x603),
	TBL_ENTRY(0x604), TBL_ENTRY(0x605), TBL_ENTRY(0x606), TBL_ENTRY(0x607),
	TBL_ENTRY(0x608), TBL_ENTRY(0x609), TBL_ENTRY(0x60a), TBL_ENTRY(0x60b),
	TBL_ENTRY(0x60c), TBL_ENTRY(0x60d), TBL_ENTRY(0x60e), TBL_ENTRY(0x60f),
	TBL_ENTRY(0x610), TBL_ENTRY(0x611), TBL_ENTRY(0x612), TBL_ENTRY(0x613),
	TBL_ENTRY(0x614), TBL_ENTRY(0x615), TBL_ENTRY(0x616), TBL_ENTRY(0x617),
	TBL_ENTRY(0x618), TBL_ENTRY(0x619), TBL_ENTRY(0x61a), TBL_ENTRY(0x61b),
	TBL_ENTRY(0x61c), TBL_ENTRY(0x61d), TBL_ENTRY(0x61e), TBL_ENTRY(0x61f),
	TBL_ENTRY(0x620), TBL_ENTRY(0x621), TBL_ENTRY(0x622), TBL_ENTRY(0x623),
	TBL_ENTRY(0x624), TBL_ENTRY(0x625), TBL_ENTRY(0x626), TBL_ENTRY(0x627),
	TBL_ENTRY(0x628), TBL_ENTRY(0x629), TBL_ENTRY(0x62a), TBL_ENTRY(0x62b),
	TBL_ENTRY(0x62c), TBL_ENTRY(0x62d), TBL_ENTRY(0x62e), TBL_ENTRY(0x62f),
	TBL_ENTRY(0x630), TBL_ENTRY(0x631), TBL_ENTRY(0x632), TBL_ENTRY(0x633),
	TBL_ENTRY(0x634), TBL_ENTRY(0x635), TBL_ENTRY(0x636), TBL_ENTRY(0x637),
	TBL_ENTRY(0x638), TBL_ENTRY(0x639), TBL_ENTRY(0x63a), TBL_ENTRY(0x63b),
	TBL_ENTRY(0x63c), TBL_ENTRY(0x63d), TBL_ENTRY(0x63e), TBL_ENTRY(0x63f),
	TBL_ENTRY(0x640), TBL_ENTRY(0x641), TBL_ENTRY(0x642), TBL_ENTRY(0x643),
	TBL_ENTRY(0x644), TBL_ENTRY(0x645), TBL_ENTRY(0x646), TBL_ENTRY(0x647),
	TBL_ENTRY(0x648), TBL_ENTRY(0x649), TBL_ENTRY(0x64a), TBL_ENTRY(0x64b),
	TBL_ENTRY(0x64c), TBL_ENTRY(0x64d), TBL_ENTRY(0x64e), TBL_ENTRY(0x64f),
	TBL_ENTRY(0x650), TBL_ENTRY(0x651), TBL_ENTRY(0x652), TBL_ENTRY(0x653),
	TBL_ENTRY(0x654), TBL_ENTRY(0x655), TBL_ENTRY(0x656), TBL_ENTRY(0x657),
	TBL_ENTRY(0x658), TBL_ENTRY(0x659), TBL_ENTRY(0x65a), TBL_ENTRY(0x65b),
	TBL_ENTRY(0x65c), TBL_ENTRY(0x65d), TBL_ENTRY(0x65e), TBL_ENTRY(0x65f),
	TBL_ENTRY(0x660), TBL_ENTRY(0x661), TBL_ENTRY(0x662), TBL_ENTRY(0x663),
	TBL_ENTRY(0x664), TBL_ENTRY(0x665), TBL_ENTRY(0x666), TBL_ENTRY(0x667),
	TBL_ENTRY(0x668), TBL_ENTRY(0x669), TBL_ENTRY(0x66a), TBL_ENTRY(0x66b),
	TBL_ENTRY(0x66c), TBL_ENTRY(0x66d), TBL_ENTRY(0x66e), TBL_ENTRY(0x66f),
	TBL_ENTRY(0x670), TBL_ENTRY(0x671), TBL_ENTRY(0x672), TBL_ENTRY(0x673),
	TBL_ENTRY(0x674), TBL_ENTRY(0x675), TBL_ENTRY(0x676), TBL_ENTRY(0x677),
	TBL_ENTRY(0x678), TBL_ENTRY(0x679), TBL_ENTRY(0x67a), TBL_ENTRY(0x67b),
	TBL_ENTRY(0x67c), TBL_ENTRY(0x67d), TBL_ENTRY(0x67e), TBL_ENTRY(0x67f),
	TBL_ENTRY(0x680), TBL_ENTRY(0x681), TBL_ENTRY(0x682), TBL_ENTRY(0x683),
	TBL_ENTRY(0x684), TBL_ENTRY(0x685), TBL_ENTRY(0x686), TBL_ENTRY(0x687),
	TBL_ENTRY(0x688), TBL_ENTRY(0x689), TBL_ENTRY(0x68a), TBL_ENTRY(0x68b),
	TBL_ENTRY(0x68c), TBL_ENTRY(0x68d), TBL_ENTRY(0x68e), TBL_ENTRY(0x68f),
	TBL_ENTRY(0x690), TBL_ENTRY(0x691), TBL_ENTRY(0x692), TBL_ENTRY(0x693),
	TBL_ENTRY(0x694), TBL_ENTRY(0x695), TBL_ENTRY(0x696), TBL_ENTRY(0x697),
	TBL_ENTRY(0x698), TBL_ENTRY(0x699), TBL_ENTRY(0x69a), TBL_ENTRY(0x69b),
	TBL_ENTRY(0x69c), TBL_ENTRY(0x69d), TBL_ENTRY(0x69e), TBL_ENTRY(0x69f),
	TBL_ENTRY(0x6a0), TBL_ENTRY(0x6a1), TBL_ENTRY(0x6a2), TBL_ENTRY(0x6a3),
	TBL_ENTRY(0x6a4), TBL_ENTRY(0x6a5), TBL_ENTRY(0x6a6), TBL_ENTRY(0x6a7),
	TBL_ENTRY(0x6a8), TBL_ENTRY(0x6a9), TBL_ENTRY(0x6aa), TBL_ENTRY(0x6ab),
	TBL_ENTRY(0x6ac), TBL_ENTRY(0x6ad), TBL_ENTRY(0x6ae), TBL_ENTRY(0x6af),
	TBL_ENTRY(0x6b0), TBL_ENTRY(0x6b1), TBL_ENTRY(0x6b2), TBL_ENTRY(0x6b3),
	TBL_ENTRY(0x6b4), TBL_ENTRY(0x6b5), TBL_ENTRY(0x6b6), TBL_ENTRY(0x6b7),
	TBL_ENTRY(0x6b8), TBL_ENTRY(0x6b9), TBL_ENTRY(0x6ba), TBL_ENTRY(0x6bb),
	TBL_ENTRY(0x6bc), TBL_ENTRY(0x6bd), TBL_ENTRY(0x6be), TBL_ENTRY(0x6bf),
	TBL_ENTRY(0x6c0), TBL_ENTRY(0x6c1), TBL_ENTRY(0x6c2), TBL_ENTRY(0x6c3),
	TBL_ENTRY(0x6c4), TBL_ENTRY(0x6c5), TBL_ENTRY(0x6c6), TBL_ENTRY(0x6c7),
	TBL_ENTRY(0x6c8), TBL_ENTRY(0x6c9), TBL_ENTRY(0x6ca), TBL_ENTRY(0x6cb),
	TBL_ENTRY(0x6cc), TBL_ENTRY(0x6cd), TBL_ENTRY(0x6ce), TBL_ENTRY(0x6cf),
	TBL_ENTRY(0x6d0), TBL_ENTRY(0x6d1), TBL_ENTRY(0x6d2), TBL_ENTRY(0x6d3),
	TBL_ENTRY(0x6d4), TBL_ENTRY(0x6d5), TBL_ENTRY(0x6d6), TBL_ENTRY(0x6d7),
	TBL_ENTRY(0x6d8), TBL_ENTRY(0x6d9), TBL_ENTRY(0x6da), TBL_ENTRY(0x6db),
	TBL_ENTRY(0x6dc), TBL_ENTRY(0x6dd), TBL_ENTRY(0x6de), TBL_ENTRY(0x6df),
	TBL_ENTRY(0x6e0), TBL_ENTRY(0x6e1), TBL_ENTRY(0x6e2), TBL_ENTRY(0x6e3),
	TBL_ENTRY(0x6e4), TBL_ENTRY(0x6e5), TBL_ENTRY(0x6e6), TBL_ENTRY(0x6e7),
	TBL_ENTRY(0x6e8), TBL_ENTRY(0x6e9), TBL_ENTRY(0x6ea), TBL_ENTRY(0x6eb),
	TBL_ENTRY(0x6ec), TBL_ENTRY(0x6ed), TBL_ENTRY(0x6ee), TBL_ENTRY(0x6ef),
	TBL_ENTRY(0x6f0), TBL_ENTRY(0x6f1), TBL_ENTRY(0x6f2), TBL_ENTRY(0x6f3),
	TBL_ENTRY(0x6f4), TBL_ENTRY(0x6f5), TBL_ENTRY(0x6f6), TBL_ENTRY(0x6f7),
	TBL_ENTRY(0x6f8), TBL_ENTRY(0x6f9), TBL_ENTRY(0x6fa), TBL_ENTRY(0x6fb),
	TBL_ENTRY(0x6fc), TBL_ENTRY(0x6fd), TBL_ENTRY(0x6fe), TBL_ENTRY(0x6ff),
	TBL_ENTRY(0x700), TBL_ENTRY(0x701), TBL_ENTRY(0x702), TBL_ENTRY(0x703),
	TBL_ENTRY(0x704), TBL_ENTRY(0x705), TBL_ENTRY(0x706), TBL_ENTRY(0x707),
	TBL_ENTRY(0x708), TBL_ENTRY(0x709), TBL_ENTRY(0x70a), TBL_ENTRY(0x70b),
	TBL_ENTRY(0x70c), TBL_ENTRY(0x70d), TBL_ENTRY(0x70e), TBL_ENTRY(0x70f),
	TBL_ENTRY(0x710), TBL_ENTRY(0x711), TBL_ENTRY(0x712), TBL_ENTRY(0x713),
	TBL_ENTRY(0x714), TBL_ENTRY(0x715), TBL_ENTRY(0x716), TBL_ENTRY(0x717),
	TBL_ENTRY(0x718), TBL_ENTRY(0x719), TBL_ENTRY(0x71a), TBL_ENTRY(0x71b),
	TBL_ENTRY(0x71c), TBL_ENTRY(0x71d), TBL_ENTRY(0x71e), TBL_ENTRY(0x71f),
	TBL_ENTRY(0x720), TBL_ENTRY(0x721), TBL_ENTRY(0x722), TBL_ENTRY(0x723),
	TBL_ENTRY(0x724), TBL_ENTRY(0x725), TBL_ENTRY(0x726), TBL_ENTRY(0x727),
	TBL_ENTRY(0x728), TBL_ENTRY(0x729), TBL_ENTRY(0x72a), TBL_ENTRY(0x72b),
	TBL_ENTRY(0x72c), TBL_ENTRY(0x72d), TBL_ENTRY(0x72e), TBL_ENTRY(0x72f),
	TBL_ENTRY(0x730), TBL_ENTRY(0x731), TBL_ENTRY(0x732), TBL_ENTRY(0x733),
	TBL_ENTRY(0x734), TBL_ENTRY(0x735), TBL_ENTRY(0x736), TBL_ENTRY(0x737),
	TBL_ENTRY(0x738), TBL_ENTRY(0x739), TBL_ENTRY(0x73a), TBL_ENTRY(0x73b),
	TBL_ENTRY(0x73c), TBL_ENTRY(0x73d), TBL_ENTRY(0x73e), TBL_ENTRY(0x73f),
	TBL_ENTRY(0x740), TBL_ENTRY(0x741), TBL_ENTRY(0x742), TBL_ENTRY(0x743),
	TBL_ENTRY(0x744), TBL_ENTRY(0x745), TBL_ENTRY(0x746), TBL_ENTRY(0x747),
	TBL_ENTRY(0x748), TBL_ENTRY(0x749), TBL_ENTRY(0x74a), TBL_ENTRY(0x74b),
	TBL_ENTRY(0x74c), TBL_ENTRY(0x74d), TBL_ENTRY(0x74e), TBL_ENTRY(0x74f),
	TBL_ENTRY(0x750), TBL_ENTRY(0x751), TBL_ENTRY(0x752), TBL_ENTRY(0x753),
	TBL_ENTRY(0x754), TBL_ENTRY(0x755), TBL_ENTRY(0x756), TBL_ENTRY(0x757),
	TBL_ENTRY(0x758), TBL_ENTRY(0x759), TBL_ENTRY(0x75a), TBL_ENTRY(0x75b),
	TBL_ENTRY(0x75c), TBL_ENTRY(0x75d), TBL_ENTRY(0x75e), TBL_ENTRY(0x75f),
	TBL_ENTRY(0x760), TBL_ENTRY(0x761), TBL_ENTRY(0x762), TBL_ENTRY(0x763),
	TBL_ENTRY(0x764), TBL_ENTRY(0x765), TBL_ENTRY(0x766), TBL_ENTRY(0x767),
	TBL_ENTRY(0x768), TBL_ENTRY(0x769), TBL_ENTRY(0x76a), TBL_ENTRY(0x76b),
	TBL_ENTRY(0x76c), TBL_ENTRY(0x76d), TBL_ENTRY(0x76e), TBL_ENTRY(0x76f),
	TBL_ENTRY(0x770), TBL_ENTRY(0x771), TBL_ENTRY(0x772), TBL_ENTRY(0x773),
	TBL_ENTRY(0x774), TBL_ENTRY(0x775), TBL_ENTRY(0x776), TBL_ENTRY(0x777),
	TBL_ENTRY(0x778), TBL_ENTRY(0x779), TBL_ENTRY(0x77a), TBL_ENTRY(0x77b),
	TBL_ENTRY(0x77c), TBL_ENTRY(0x77d), TBL_ENTRY(0x77e), TBL_ENTRY(0x77f),
	TBL_ENTRY(0x780), TBL_ENTRY(0x781), TBL_ENTRY(0x782), TBL_ENTRY(0x783),
	TBL_ENTRY(0x784), TBL_ENTRY(0x785), TBL_ENTRY(0x786), TBL_ENTRY(0x787),
	TBL_ENTRY(0x788), TBL_ENTRY(0x789), TBL_ENTRY(0x78a), TBL_ENTRY(0x78b),
	TBL_ENTRY(0x78c), TBL_ENTRY(0x78d), TBL_ENTRY(0x78e), TBL_ENTRY(0x78f),
	TBL_ENTRY(0x790), TBL_ENTRY(0x791), TBL_ENTRY(0x792), TBL_ENTRY(0x793),
	TBL_ENTRY(0x794), TBL_ENTRY(0x795), TBL_ENTRY(0x796), TBL_ENTRY(0x797),
	TBL_ENTRY(0x798), TBL_ENTRY(0x799), TBL_ENTRY(0x79a), TBL_ENTRY(0x79b),
	TBL_ENTRY(0x79c), TBL_ENTRY(0x79d), TBL_ENTRY(0x79e), TBL_ENTRY(0x79f),
	TBL_ENTRY(0x7a0), TBL_ENTRY(0x7a1), TBL_ENTRY(0x7a2), TBL_ENTRY(0x7a3),
	TBL_ENTRY(0x7a4), TBL_ENTRY(0x7a5), TBL_ENTRY(0x7a6), TBL_ENTRY(0x7a7),
	TBL_ENTRY(0x7a8), TBL_ENTRY(0x7a9), TBL_ENTRY(0x7aa), TBL_ENTRY(0x7ab),
	TBL_ENTRY(0x7ac), TBL_ENTRY(0x7ad), TBL_ENTRY(0x7ae), TBL_ENTRY(0x7af),
	TBL_ENTRY(0x7b0), TBL_ENTRY(0x7b1), TBL_ENTRY(0x7b2), TBL_ENTRY(0x7b3),
	TBL_ENTRY(0x7b4), TBL_ENTRY(0x7b5), TBL_ENTRY(0x7b6), TBL_ENTRY(0x7b7),
	TBL_ENTRY(0x7b8), TBL_ENTRY(0x7b9), TBL_ENTRY(0x7ba), TBL_ENTRY(0x7bb),
	TBL_ENTRY(0x7bc), TBL_ENTRY(0x7bd), TBL_ENTRY(0x7be), TBL_ENTRY(0x7bf),
	TBL_ENTRY(0x7c0), TBL_ENTRY(0x7c1), TBL_ENTRY(0x7c2), TBL_ENTRY(0x7c3),
	TBL_ENTRY(0x7c4), TBL_ENTRY(0x7c5), TBL_ENTRY(0x7c6), TBL_ENTRY(0x7c7),
	TBL_ENTRY(0x7c8), TBL_ENTRY(0x7c9), TBL_ENTRY(0x7ca), TBL_ENTRY(0x7cb),
	TBL_ENTRY(0x7cc), TBL_ENTRY(0x7cd), TBL_ENTRY(0x7ce), TBL_ENTRY(0x7cf),
	TBL_ENTRY(0x7d0), TBL_ENTRY(0x7d1), TBL_ENTRY(0x7d2), TBL_ENTRY(0x7d3),
	TBL_ENTRY(0x7d4), TBL_ENTRY(0x7d5), TBL_ENTRY(0x7d6), TBL_ENTRY(0x7d7),
	TBL_ENTRY(0x7d8), TBL_ENTRY(0x7d9), TBL_ENTRY(0x7da), TBL_ENTRY(0x7db),
	TBL_ENTRY(0x7dc), TBL_ENTRY(0x7dd), TBL_ENTRY(0x7de), TBL_ENTRY(0x7df),
	TBL_ENTRY(0x7e0), TBL_ENTRY(0x7e1), TBL_ENTRY(0x7e2), TBL_ENTRY(0x7e3),
	TBL_ENTRY(0x7e4), TBL_ENTRY(0x7e5), TBL_ENTRY(0x7e6), TBL_ENTRY(0x7e7),
	TBL_ENTRY(0x7e8), TBL_ENTRY(0x7e9), TBL_ENTRY(0x7ea), TBL_ENTRY(0x7eb),
	TBL_ENTRY(0x7ec), TBL_ENTRY(0x7ed), TBL_ENTRY(0x7ee), TBL_ENTRY(0x7ef),
	TBL_ENTRY(0x7f0), TBL_ENTRY(0x7f1), TBL_ENTRY(0x7f2), TBL_ENTRY(0x7f3),
	TBL_ENTRY(0x7f4), TBL_ENTRY(0x7f5), TBL_ENTRY(0x7f6), TBL_ENTRY(0x7f7),
	TBL_ENTRY(0x7f8), TBL_ENTRY(0x7f9), TBL_ENTRY(0x7fa), TBL_ENTRY(0x7fb),
	TBL_ENTRY(0x7fc), TBL_ENTRY(0x7fd), TBL_ENTRY(0x7fe), TBL_ENTRY(0x7ff),
	TBL_ENTRY(0x800), TBL_ENTRY(0x801), TBL_ENTRY(0x802), TBL_ENTRY(0x803),
	TBL_ENTRY(0x804), TBL_ENTRY(0x805), TBL_ENTRY(0x806), TBL_ENTRY(0x807),
	TBL_ENTRY(0x808), TBL_ENTRY(0x809), TBL_ENTRY(0x80a), TBL_ENTRY(0x80b),
	TBL_ENTRY(0x80c), TBL_ENTRY(0x80d), TBL_ENTRY(0x80e), TBL_ENTRY(0x80f),
	TBL_ENTRY(0x810), TBL_ENTRY(0x811), TBL_ENTRY(0x812), TBL_ENTRY(0x813),
	TBL_ENTRY(0x814), TBL_ENTRY(0x815), TBL_ENTRY(0x816), TBL_ENTRY(0x817),
	TBL_ENTRY(0x818), TBL_ENTRY(0x819), TBL_ENTRY(0x81a), TBL_ENTRY(0x81b),
	TBL_ENTRY(0x81c), TBL_ENTRY(0x81d), TBL_ENTRY(0x81e), TBL_ENTRY(0x81f),
	TBL_ENTRY(0x820), TBL_ENTRY(0x821), TBL_ENTRY(0x822), TBL_ENTRY(0x823),
	TBL_ENTRY(0x824), TBL_ENTRY(0x825), TBL_ENTRY(0x826), TBL_ENTRY(0x827),
	TBL_ENTRY(0x828), TBL_ENTRY(0x829), TBL_ENTRY(0x82a), TBL_ENTRY(0x82b),
	TBL_ENTRY(0x82c), TBL_ENTRY(0x82d), TBL_ENTRY(0x82e), TBL_ENTRY(0x82f),
	TBL_ENTRY(0x830), TBL_ENTRY(0x831), TBL_ENTRY(0x832), TBL_ENTRY(0x833),
	TBL_ENTRY(0x834), TBL_ENTRY(0x835), TBL_ENTRY(0x836), TBL_ENTRY(0x837),
	TBL_ENTRY(0x838), TBL_ENTRY(0x839), TBL_ENTRY(0x83a), TBL_ENTRY(0x83b),
	TBL_ENTRY(0x83c), TBL_ENTRY(0x83d), TBL_ENTRY(0x83e), TBL_ENTRY(0x83f),
	TBL_ENTRY(0x840), TBL_ENTRY(0x841), TBL_ENTRY(0x842), TBL_ENTRY(0x843),
	TBL_ENTRY(0x844), TBL_ENTRY(0x845), TBL_ENTRY(0x846), TBL_ENTRY(0x847),
	TBL_ENTRY(0x848), TBL_ENTRY(0x849), TBL_ENTRY(0x84a), TBL_ENTRY(0x84b),
	TBL_ENTRY(0x84c), TBL_ENTRY(0x84d), TBL_ENTRY(0x84e), TBL_ENTRY(0x84f),
	TBL_ENTRY(0x850), TBL_ENTRY(0x851), TBL_ENTRY(0x852), TBL_ENTRY(0x853),
	TBL_ENTRY(0x854), TBL_ENTRY(0x855), TBL_ENTRY(0x856), TBL_ENTRY(0x857),
	TBL_ENTRY(0x858), TBL_ENTRY(0x859), TBL_ENTRY(0x85a), TBL_ENTRY(0x85b),
	TBL_ENTRY(0x85c), TBL_ENTRY(0x85d), TBL_ENTRY(0x85e), TBL_ENTRY(0x85f),
	TBL_ENTRY(0x860), TBL_ENTRY(0x861), TBL_ENTRY(0x862), TBL_ENTRY(0x863),
	TBL_ENTRY(0x864), TBL_ENTRY(0x865), TBL_ENTRY(0x866), TBL_ENTRY(0x867),
	TBL_ENTRY(0x868), TBL_ENTRY(0x869), TBL_ENTRY(0x86a), TBL_ENTRY(0x86b),
	TBL_ENTRY(0x86c), TBL_ENTRY(0x86d), TBL_ENTRY(0x86e), TBL_ENTRY(0x86f),
	TBL_ENTRY(0x870), TBL_ENTRY(0x871), TBL_ENTRY(0x872), TBL_ENTRY(0x873),
	TBL_ENTRY(0x874), TBL_ENTRY(0x875), TBL_ENTRY(0x876), TBL_ENTRY(0x877),
	TBL_ENTRY(0x878), TBL_ENTRY(0x879), TBL_ENTRY(0x87a), TBL_ENTRY(0x87b),
	TBL_ENTRY(0x87c), TBL_ENTRY(0x87d), TBL_ENTRY(0x87e), TBL_ENTRY(0x87f),
	TBL_ENTRY(0x880), TBL_ENTRY(0x881), TBL_ENTRY(0x882), TBL_ENTRY(0x883),
	TBL_ENTRY(0x884), TBL_ENTRY(0x885), TBL_ENTRY(0x886), TBL_ENTRY(0x887),
	TBL_ENTRY(0x888), TBL_ENTRY(0x889), TBL_ENTRY(0x88a), TBL_ENTRY(0x88b),
	TBL_ENTRY(0x88c), TBL_ENTRY(0x88d), TBL_ENTRY(0x88e), TBL_ENTRY(0x88f),
	TBL_ENTRY(0x890), TBL_ENTRY(0x891), TBL_ENTRY(0x892), TBL_ENTRY(0x893),
	TBL_ENTRY(0x894), TBL_ENTRY(0x895), TBL_ENTRY(0x896), TBL_ENTRY(0x897),
	TBL_ENTRY(0x898), TBL_ENTRY(0x899), TBL_ENTRY(0x89a), TBL_ENTRY(0x89b),
	TBL_ENTRY(0x89c), TBL_ENTRY(0x89d), TBL_ENTRY(0x89e), TBL_ENTRY(0x89f),
	TBL_ENTRY(0x8a0), TBL_ENTRY(0x8a1), TBL_ENTRY(0x8a2), TBL_ENTRY(0x8a3),
	TBL_ENTRY(0x8a4), TBL_ENTRY(0x8a5), TBL_ENTRY(0x8a6), TBL_ENTRY(0x8a7),
	TBL_ENTRY(0x8a8), TBL_ENTRY(0x8a9), TBL_ENTRY(0x8aa), TBL_ENTRY(0x8ab),
	TBL_ENTRY(0x8ac), TBL_ENTRY(0x8ad), TBL_ENTRY(0x8ae), TBL_ENTRY(0x8af),
	TBL_ENTRY(0x8b0), TBL_ENTRY(0x8b1), TBL_ENTRY(0x8b2), TBL_ENTRY(0x8b3),
	TBL_ENTRY(0x8b4), TBL_ENTRY(0x8b5), TBL_ENTRY(0x8b6), TBL_ENTRY(0x8b7),
	TBL_ENTRY(0x8b8), TBL_ENTRY(0x8b9), TBL_ENTRY(0x8ba), TBL_ENTRY(0x8bb),
	TBL_ENTRY(0x8bc), TBL_ENTRY(0x8bd), TBL_ENTRY(0x8be), TBL_ENTRY(0x8bf),
	TBL_ENTRY(0x8c0), TBL_ENTRY(0x8c1), TBL_ENTRY(0x8c2), TBL_ENTRY(0x8c3),
	TBL_ENTRY(0x8c4), TBL_ENTRY(0x8c5), TBL_ENTRY(0x8c6), TBL_ENTRY(0x8c7),
	TBL_ENTRY(0x8c8), TBL_ENTRY(0x8c9), TBL_ENTRY(0x8ca), TBL_ENTRY(0x8cb),
	TBL_ENTRY(0x8cc), TBL_ENTRY(0x8cd), TBL_ENTRY(0x8ce), TBL_ENTRY(0x8cf),
	TBL_ENTRY(0x8d0), TBL_ENTRY(0x8d1), TBL_ENTRY(0x8d2), TBL_ENTRY(0x8d3),
	TBL_ENTRY(0x8d4), TBL_ENTRY(0x8d5), TBL_ENTRY(0x8d6), TBL_ENTRY(0x8d7),
	TBL_ENTRY(0x8d8), TBL_ENTRY(0x8d9), TBL_ENTRY(0x8da), TBL_ENTRY(0x8db),
	TBL_ENTRY(0x8dc), TBL_ENTRY(0x8dd), TBL_ENTRY(0x8de), TBL_ENTRY(0x8df),
	TBL_ENTRY(0x8e0), TBL_ENTRY(0x8e1), TBL_ENTRY(0x8e2), TBL_ENTRY(0x8e3),
	TBL_ENTRY(0x8e4), TBL_ENTRY(0x8e5), TBL_ENTRY(0x8e6), TBL_ENTRY(0x8e7),
	TBL_ENTRY(0x8e8), TBL_ENTRY(0x8e9), TBL_ENTRY(0x8ea), TBL_ENTRY(0x8eb),
	TBL_ENTRY(0x8ec), TBL_ENTRY(0x8ed), TBL_ENTRY(0x8ee), TBL_ENTRY(0x8ef),
	TBL_ENTRY(0x8f0), TBL_ENTRY(0x8f1), TBL_ENTRY(0x8f2), TBL_ENTRY(0x8f3),
	TBL_ENTRY(0x8f4), TBL_ENTRY(0x8f5), TBL_ENTRY(0x8f6), TBL_ENTRY(0x8f7),
	TBL_ENTRY(0x8f8), TBL_ENTRY(0x8f9), TBL_ENTRY(0x8fa), TBL_ENTRY(0x8fb),
	TBL_ENTRY(0x8fc), TBL_ENTRY(0x8fd), TBL_ENTRY(0x8fe), TBL_ENTRY(0x8ff),
	TBL_ENTRY(0x900), TBL_ENTRY(0x901), TBL_ENTRY(0x902), TBL_ENTRY(0x903),
	TBL_ENTRY(0x904), TBL_ENTRY(0x905), TBL_ENTRY(0x906), TBL_ENTRY(0x907),
	TBL_ENTRY(0x908), TBL_ENTRY(0x909), TBL_ENTRY(0x90a), TBL_ENTRY(0x90b),
	TBL_ENTRY(0x90c), TBL_ENTRY(0x90d), TBL_ENTRY(0x90e), TBL_ENTRY(0x90f),
	TBL_ENTRY(0x910), TBL_ENTRY(0x911), TBL_ENTRY(0x912), TBL_ENTRY(0x913),
	TBL_ENTRY(0x914), TBL_ENTRY(0x915), TBL_ENTRY(0x916), TBL_ENTRY(0x917),
	TBL_ENTRY(0x918), TBL_ENTRY(0x919), TBL_ENTRY(0x91a), TBL_ENTRY(0x91b),
	TBL_ENTRY(0x91c), TBL_ENTRY(0x91d), TBL_ENTRY(0x91e), TBL_ENTRY(0x91f),
	TBL_ENTRY(0x920), TBL_ENTRY(0x921), TBL_ENTRY(0x922), TBL_ENTRY(0x923),
	TBL_ENTRY(0x924), TBL_ENTRY(0x925), TBL_ENTRY(0x926), TBL_ENTRY(0x927),
	TBL_ENTRY(0x928), TBL_ENTRY(0x929), TBL_ENTRY(0x92a), TBL_ENTRY(0x92b),
	TBL_ENTRY(0x92c), TBL_ENTRY(0x92d), TBL_ENTRY(0x92e), TBL_ENTRY(0x92f),
	TBL_ENTRY(0x930), TBL_ENTRY(0x931), TBL_ENTRY(0x932), TBL_ENTRY(0x933),
	TBL_ENTRY(0x934), TBL_ENTRY(0x935), TBL_ENTRY(0x936), TBL_ENTRY(0x937),
	TBL_ENTRY(0x938), TBL_ENTRY(0x939), TBL_ENTRY(0x93a), TBL_ENTRY(0x93b),
	TBL_ENTRY(0x93c), TBL_ENTRY(0x93d), TBL_ENTRY(0x93e), TBL_ENTRY(0x93f),
	TBL_ENTRY(0x940), TBL_ENTRY(0x941), TBL_ENTRY(0x942), TBL_ENTRY(0x943),
	TBL_ENTRY(0x944), TBL_ENTRY(0x945), TBL_ENTRY(0x946), TBL_ENTRY(0x947),
	TBL_ENTRY(0x948), TBL_ENTRY(0x949), TBL_ENTRY(0x94a), TBL_ENTRY(0x94b),
	TBL_ENTRY(0x94c), TBL_ENTRY(0x94d), TBL_ENTRY(0x94e), TBL_ENTRY(0x94f),
	TBL_ENTRY(0x950), TBL_ENTRY(0x951), TBL_ENTRY(0x952), TBL_ENTRY(0x953),
	TBL_ENTRY(0x954), TBL_ENTRY(0x955), TBL_ENTRY(0x956), TBL_ENTRY(0x957),
	TBL_ENTRY(0x958), TBL_ENTRY(0x959), TBL_ENTRY(0x95a), TBL_ENTRY(0x95b),
	TBL_ENTRY(0x95c), TBL_ENTRY(0x95d), TBL_ENTRY(0x95e), TBL_ENTRY(0x95f),
	TBL_ENTRY(0x960), TBL_ENTRY(0x961), TBL_ENTRY(0x962), TBL_ENTRY(0x963),
	TBL_ENTRY(0x964), TBL_ENTRY(0x965), TBL_ENTRY(0x966), TBL_ENTRY(0x967),
	TBL_ENTRY(0x968), TBL_ENTRY(0x969), TBL_ENTRY(0x96a), TBL_ENTRY(0x96b),
	TBL_ENTRY(0x96c), TBL_ENTRY(0x96d), TBL_ENTRY(0x96e), TBL_ENTRY(0x96f),
	TBL_ENTRY(0x970), TBL_ENTRY(0x971), TBL_ENTRY(0x972), TBL_ENTRY(0x973),
	TBL_ENTRY(0x974), TBL_ENTRY(0x975), TBL_ENTRY(0x976), TBL_ENTRY(0x977),
	TBL_ENTRY(0x978), TBL_ENTRY(0x979), TBL_ENTRY(0x97a), TBL_ENTRY(0x97b),
	TBL_ENTRY(0x97c), TBL_ENTRY(0x97d), TBL_ENTRY(0x97e), TBL_ENTRY(0x97f),
	TBL_ENTRY(0x980), TBL_ENTRY(0x981), TBL_ENTRY(0x982), TBL_ENTRY(0x983),
	TBL_ENTRY(0x984), TBL_ENTRY(0x985), TBL_ENTRY(0x986), TBL_ENTRY(0x987),
	TBL_ENTRY(0x988), TBL_ENTRY(0x989), TBL_ENTRY(0x98a), TBL_ENTRY(0x98b),
	TBL_ENTRY(0x98c), TBL_ENTRY(0x98d), TBL_ENTRY(0x98e), TBL_ENTRY(0x98f),
	TBL_ENTRY(0x990), TBL_ENTRY(0x991), TBL_ENTRY(0x992), TBL_ENTRY(0x993),
	TBL_ENTRY(0x994), TBL_ENTRY(0x995), TBL_ENTRY(0x996), TBL_ENTRY(0x997),
	TBL_ENTRY(0x998), TBL_ENTRY(0x999), TBL_ENTRY(0x99a), TBL_ENTRY(0x99b),
	TBL_ENTRY(0x99c), TBL_ENTRY(0x99d), TBL_ENTRY(0x99e), TBL_ENTRY(0x99f),
	TBL_ENTRY(0x9a0), TBL_ENTRY(0x9a1), TBL_ENTRY(0x9a2), TBL_ENTRY(0x9a3),
	TBL_ENTRY(0x9a4), TBL_ENTRY(0x9a5), TBL_ENTRY(0x9a6), TBL_ENTRY(0x9a7),
	TBL_ENTRY(0x9a8), TBL_ENTRY(0x9a9), TBL_ENTRY(0x9aa), TBL_ENTRY(0x9ab),
	TBL_ENTRY(0x9ac), TBL_ENTRY(0x9ad), TBL_ENTRY(0x9ae), TBL_ENTRY(0x9af),
	TBL_ENTRY(0x9b0), TBL_ENTRY(0x9b1), TBL_ENTRY(0x9b2), TBL_ENTRY(0x9b3),
	TBL_ENTRY(0x9b4), TBL_ENTRY(0x9b5), TBL_ENTRY(0x9b6), TBL_ENTRY(0x9b7),
	TBL_ENTRY(0x9b8), TBL_ENTRY(0x9b9), TBL_ENTRY(0x9ba), TBL_ENTRY(0x9bb),
	TBL_ENTRY(0x9bc), TBL_ENTRY(0x9bd), TBL_ENTRY(0x9be), TBL_ENTRY(0x9bf),
	TBL_ENTRY(0x9c0), TBL_ENTRY(0x9c1), TBL_ENTRY(0x9c2), TBL_ENTRY(0x9c3),
	TBL_ENTRY(0x9c4), TBL_ENTRY(0x9c5), TBL_ENTRY(0x9c6), TBL_ENTRY(0x9c7),
	TBL_ENTRY(0x9c8), TBL_ENTRY(0x9c9), TBL_ENTRY(0x9ca), TBL_ENTRY(0x9cb),
	TBL_ENTRY(0x9cc), TBL_ENTRY(0x9cd), TBL_ENTRY(0x9ce), TBL_ENTRY(0x9cf),
	TBL_ENTRY(0x9d0), TBL_ENTRY(0x9d1), TBL_ENTRY(0x9d2), TBL_ENTRY(0x9d3),
	TBL_ENTRY(0x9d4), TBL_ENTRY(0x9d5), TBL_ENTRY(0x9d6), TBL_ENTRY(0x9d7),
	TBL_ENTRY(0x9d8), TBL_ENTRY(0x9d9), TBL_ENTRY(0x9da), TBL_ENTRY(0x9db),
	TBL_ENTRY(0x9dc), TBL_ENTRY(0x9dd), TBL_ENTRY(0x9de), TBL_ENTRY(0x9df),
	TBL_ENTRY(0x9e0), TBL_ENTRY(0x9e1), TBL_ENTRY(0x9e2), TBL_ENTRY(0x9e3),
	TBL_ENTRY(0x9e4), TBL_ENTRY(0x9e5), TBL_ENTRY(0x9e6), TBL_ENTRY(0x9e7),
	TBL_ENTRY(0x9e8), TBL_ENTRY(0x9e9), TBL_ENTRY(0x9ea), TBL_ENTRY(0x9eb),
	TBL_ENTRY(0x9ec), TBL_ENTRY(0x9ed), TBL_ENTRY(0x9ee), TBL_ENTRY(0x9ef),
	TBL_ENTRY(0x9f0), TBL_ENTRY(0x9f1), TBL_ENTRY(0x9f2), TBL_ENTRY(0x9f3),
	TBL_ENTRY(0x9f4), TBL_ENTRY(0x9f5), TBL_ENTRY(0x9f6), TBL_ENTRY(0x9f7),
	TBL_ENTRY(0x9f8), TBL_ENTRY(0x9f9), TBL_ENTRY(0x9fa), TBL_ENTRY(0x9fb),
	TBL_ENTRY(0x9fc), TBL_ENTRY(0x9fd), TBL_ENTRY(0x9fe), TBL_ENTRY(0x9ff),
	TBL_ENTRY(0xa00), TBL_ENTRY(0xa01), TBL_ENTRY(0xa02), TBL_ENTRY(0xa03),
	TBL_ENTRY(0xa04), TBL_ENTRY(0xa05), TBL_ENTRY(0xa06), TBL_ENTRY(0xa07),
	TBL_ENTRY(0xa08), TBL_ENTRY(0xa09), TBL_ENTRY(0xa0a), TBL_ENTRY(0xa0b),
	TBL_ENTRY(0xa0c), TBL_ENTRY(0xa0d), TBL_ENTRY(0xa0e), TBL_ENTRY(0xa0f),
	TBL_ENTRY(0xa10), TBL_ENTRY(0xa11), TBL_ENTRY(0xa12), TBL_ENTRY(0xa13),
	TBL_ENTRY(0xa14), TBL_ENTRY(0xa15), TBL_ENTRY(0xa16), TBL_ENTRY(0xa17),
	TBL_ENTRY(0xa18), TBL_ENTRY(0xa19), TBL_ENTRY(0xa1a), TBL_ENTRY(0xa1b),
	TBL_ENTRY(0xa1c), TBL_ENTRY(0xa1d), TBL_ENTRY(0xa1e), TBL_ENTRY(0xa1f),
	TBL_ENTRY(0xa20), TBL_ENTRY(0xa21), TBL_ENTRY(0xa22), TBL_ENTRY(0xa23),
	TBL_ENTRY(0xa24), TBL_ENTRY(0xa25), TBL_ENTRY(0xa26), TBL_ENTRY(0xa27),
	TBL_ENTRY(0xa28), TBL_ENTRY(0xa29), TBL_ENTRY(0xa2a), TBL_ENTRY(0xa2b),
	TBL_ENTRY(0xa2c), TBL_ENTRY(0xa2d), TBL_ENTRY(0xa2e), TBL_ENTRY(0xa2f),
	TBL_ENTRY(0xa30), TBL_ENTRY(0xa31), TBL_ENTRY(0xa32), TBL_ENTRY(0xa33),
	TBL_ENTRY(0xa34), TBL_ENTRY(0xa35), TBL_ENTRY(0xa36), TBL_ENTRY(0xa37),
	TBL_ENTRY(0xa38), TBL_ENTRY(0xa39), TBL_ENTRY(0xa3a), TBL_ENTRY(0xa3b),
	TBL_ENTRY(0xa3c), TBL_ENTRY(0xa3d), TBL_ENTRY(0xa3e), TBL_ENTRY(0xa3f),
	TBL_ENTRY(0xa40), TBL_ENTRY(0xa41), TBL_ENTRY(0xa42), TBL_ENTRY(0xa43),
	TBL_ENTRY(0xa44), TBL_ENTRY(0xa45), TBL_ENTRY(0xa46), TBL_ENTRY(0xa47),
	TBL_ENTRY(0xa48), TBL_ENTRY(0xa49), TBL_ENTRY(0xa4a), TBL_ENTRY(0xa4b),
	TBL_ENTRY(0xa4c), TBL_ENTRY(0xa4d), TBL_ENTRY(0xa4e), TBL_ENTRY(0xa4f),
	TBL_ENTRY(0xa50), TBL_ENTRY(0xa51), TBL_ENTRY(0xa52), TBL_ENTRY(0xa53),
	TBL_ENTRY(0xa54), TBL_ENTRY(0xa55), TBL_ENTRY(0xa56), TBL_ENTRY(0xa57),
	TBL_ENTRY(0xa58), TBL_ENTRY(0xa59), TBL_ENTRY(0xa5a), TBL_ENTRY(0xa5b),
	TBL_ENTRY(0xa5c), TBL_ENTRY(0xa5d), TBL_ENTRY(0xa5e), TBL_ENTRY(0xa5f),
	TBL_ENTRY(0xa60), TBL_ENTRY(0xa61), TBL_ENTRY(0xa62), TBL_ENTRY(0xa63),
	TBL_ENTRY(0xa64), TBL_ENTRY(0xa65), TBL_ENTRY(0xa66), TBL_ENTRY(0xa67),
	TBL_ENTRY(0xa68), TBL_ENTRY(0xa69), TBL_ENTRY(0xa6a), TBL_ENTRY(0xa6b),
	TBL_ENTRY(0xa6c), TBL_ENTRY(0xa6d), TBL_ENTRY(0xa6e), TBL_ENTRY(0xa6f),
	TBL_ENTRY(0xa70), TBL_ENTRY(0xa71), TBL_ENTRY(0xa72), TBL_ENTRY(0xa73),
	TBL_ENTRY(0xa74), TBL_ENTRY(0xa75), TBL_ENTRY(0xa76), TBL_ENTRY(0xa77),
	TBL_ENTRY(0xa78), TBL_ENTRY(0xa79), TBL_ENTRY(0xa7a), TBL_ENTRY(0xa7b),
	TBL_ENTRY(0xa7c), TBL_ENTRY(0xa7d), TBL_ENTRY(0xa7e), TBL_ENTRY(0xa7f),
	TBL_ENTRY(0xa80), TBL_ENTRY(0xa81), TBL_ENTRY(0xa82), TBL_ENTRY(0xa83),
	TBL_ENTRY(0xa84), TBL_ENTRY(0xa85), TBL_ENTRY(0xa86), TBL_ENTRY(0xa87),
	TBL_ENTRY(0xa88), TBL_ENTRY(0xa89), TBL_ENTRY(0xa8a), TBL_ENTRY(0xa8b),
	TBL_ENTRY(0xa8c), TBL_ENTRY(0xa8d), TBL_ENTRY(0xa8e), TBL_ENTRY(0xa8f),
	TBL_ENTRY(0xa90), TBL_ENTRY(0xa91), TBL_ENTRY(0xa92), TBL_ENTRY(0xa93),
	TBL_ENTRY(0xa94), TBL_ENTRY(0xa95), TBL_ENTRY(0xa96), TBL_ENTRY(0xa97),
	TBL_ENTRY(0xa98), TBL_ENTRY(0xa99), TBL_ENTRY(0xa9a), TBL_ENTRY(0xa9b),
	TBL_ENTRY(0xa9c), TBL_ENTRY(0xa9d), TBL_ENTRY(0xa9e), TBL_ENTRY(0xa9f),
	TBL_ENTRY(0xaa0), TBL_ENTRY(0xaa1), TBL_ENTRY(0xaa2), TBL_ENTRY(0xaa3),
	TBL_ENTRY(0xaa4), TBL_ENTRY(0xaa5), TBL_ENTRY(0xaa6), TBL_ENTRY(0xaa7),
	TBL_ENTRY(0xaa8), TBL_ENTRY(0xaa9), TBL_ENTRY(0xaaa), TBL_ENTRY(0xaab),
	TBL_ENTRY(0xaac), TBL_ENTRY(0xaad), TBL_ENTRY(0xaae), TBL_ENTRY(0xaaf),
	TBL_ENTRY(0xab0), TBL_ENTRY(0xab1), TBL_ENTRY(0xab2), TBL_ENTRY(0xab3),
	TBL_ENTRY(0xab4), TBL_ENTRY(0xab5), TBL_ENTRY(0xab6), TBL_ENTRY(0xab7),
	TBL_ENTRY(0xab8), TBL_ENTRY(0xab9), TBL_ENTRY(0xaba), TBL_ENTRY(0xabb),
	TBL_ENTRY(0xabc), TBL_ENTRY(0xabd), TBL_ENTRY(0xabe), TBL_ENTRY(0xabf),
	TBL_ENTRY(0xac0), TBL_ENTRY(0xac1), TBL_ENTRY(0xac2), TBL_ENTRY(0xac3),
	TBL_ENTRY(0xac4), TBL_ENTRY(0xac5), TBL_ENTRY(0xac6), TBL_ENTRY(0xac7),
	TBL_ENTRY(0xac8), TBL_ENTRY(0xac9), TBL_ENTRY(0xaca), TBL_ENTRY(0xacb),
	TBL_ENTRY(0xacc), TBL_ENTRY(0xacd), TBL_ENTRY(0xace), TBL_ENTRY(0xacf),
	TBL_ENTRY(0xad0), TBL_ENTRY(0xad1), TBL_ENTRY(0xad2), TBL_ENTRY(0xad3),
	TBL_ENTRY(0xad4), TBL_ENTRY(0xad5), TBL_ENTRY(0xad6), TBL_ENTRY(0xad7),
	TBL_ENTRY(0xad8), TBL_ENTRY(0xad9), TBL_ENTRY(0xada), TBL_ENTRY(0xadb),
	TBL_ENTRY(0xadc), TBL_ENTRY(0xadd), TBL_ENTRY(0xade), TBL_ENTRY(0xadf),
	TBL_ENTRY(0xae0), TBL_ENTRY(0xae1), TBL_ENTRY(0xae2), TBL_ENTRY(0xae3),
	TBL_ENTRY(0xae4), TBL_ENTRY(0xae5), TBL_ENTRY(0xae6), TBL_ENTRY(0xae7),
	TBL_ENTRY(0xae8), TBL_ENTRY(0xae9), TBL_ENTRY(0xaea), TBL_ENTRY(0xaeb),
	TBL_ENTRY(0xaec), TBL_ENTRY(0xaed), TBL_ENTRY(0xaee), TBL_ENTRY(0xaef),
	TBL_ENTRY(0xaf0), TBL_ENTRY(0xaf1), TBL_ENTRY(0xaf2), TBL_ENTRY(0xaf3),
	TBL_ENTRY(0xaf4), TBL_ENTRY(0xaf5), TBL_ENTRY(0xaf6), TBL_ENTRY(0xaf7),
	TBL_ENTRY(0xaf8), TBL_ENTRY(0xaf9), TBL_ENTRY(0xafa), TBL_ENTRY(0xafb),
	TBL_ENTRY(0xafc), TBL_ENTRY(0xafd), TBL_ENTRY(0xafe), TBL_ENTRY(0xaff),
	TBL_ENTRY(0xb00), TBL_ENTRY(0xb01), TBL_ENTRY(0xb02), TBL_ENTRY(0xb03),
	TBL_ENTRY(0xb04), TBL_ENTRY(0xb05), TBL_ENTRY(0xb06), TBL_ENTRY(0xb07),
	TBL_ENTRY(0xb08), TBL_ENTRY(0xb09), TBL_ENTRY(0xb0a), TBL_ENTRY(0xb0b),
	TBL_ENTRY(0xb0c), TBL_ENTRY(0xb0d), TBL_ENTRY(0xb0e), TBL_ENTRY(0xb0f),
	TBL_ENTRY(0xb10), TBL_ENTRY(0xb11), TBL_ENTRY(0xb12), TBL_ENTRY(0xb13),
	TBL_ENTRY(0xb14), TBL_ENTRY(0xb15), TBL_ENTRY(0xb16), TBL_ENTRY(0xb17),
	TBL_ENTRY(0xb18), TBL_ENTRY(0xb19), TBL_ENTRY(0xb1a), TBL_ENTRY(0xb1b),
	TBL_ENTRY(0xb1c), TBL_ENTRY(0xb1d), TBL_ENTRY(0xb1e), TBL_ENTRY(0xb1f),
	TBL_ENTRY(0xb20), TBL_ENTRY(0xb21), TBL_ENTRY(0xb22), TBL_ENTRY(0xb23),
	TBL_ENTRY(0xb24), TBL_ENTRY(0xb25), TBL_ENTRY(0xb26), TBL_ENTRY(0xb27),
	TBL_ENTRY(0xb28), TBL_ENTRY(0xb29), TBL_ENTRY(0xb2a), TBL_ENTRY(0xb2b),
	TBL_ENTRY(0xb2c), TBL_ENTRY(0xb2d), TBL_ENTRY(0xb2e), TBL_ENTRY(0xb2f),
	TBL_ENTRY(0xb30), TBL_ENTRY(0xb31), TBL_ENTRY(0xb32), TBL_ENTRY(0xb33),
	TBL_ENTRY(0xb34), TBL_ENTRY(0xb35), TBL_ENTRY(0xb36), TBL_ENTRY(0xb37),
	TBL_ENTRY(0xb38), TBL_ENTRY(0xb39), TBL_ENTRY(0xb3a), TBL_ENTRY(0xb3b),
	TBL_ENTRY(0xb3c), TBL_ENTRY(0xb3d), TBL_ENTRY(0xb3e), TBL_ENTRY(0xb3f),
	TBL_ENTRY(0xb40), TBL_ENTRY(0xb41), TBL_ENTRY(0xb42), TBL_ENTRY(0xb43),
	TBL_ENTRY(0xb44), TBL_ENTRY(0xb45), TBL_ENTRY(0xb46), TBL_ENTRY(0xb47),
	TBL_ENTRY(0xb48), TBL_ENTRY(0xb49), TBL_ENTRY(0xb4a), TBL_ENTRY(0xb4b),
	TBL_ENTRY(0xb4c), TBL_ENTRY(0xb4d), TBL_ENTRY(0xb4e), TBL_ENTRY(0xb4f),
	TBL_ENTRY(0xb50), TBL_ENTRY(0xb51), TBL_ENTRY(0xb52), TBL_ENTRY(0xb53),
	TBL_ENTRY(0xb54), TBL_ENTRY(0xb55), TBL_ENTRY(0xb56), TBL_ENTRY(0xb57),
	TBL_ENTRY(0xb58), TBL_ENTRY(0xb59), TBL_ENTRY(0xb5a), TBL_ENTRY(0xb5b),
	TBL_ENTRY(0xb5c), TBL_ENTRY(0xb5d), TBL_ENTRY(0xb5e), TBL_ENTRY(0xb5f),
	TBL_ENTRY(0xb60), TBL_ENTRY(0xb61), TBL_ENTRY(0xb62), TBL_ENTRY(0xb63),
	TBL_ENTRY(0xb64), TBL_ENTRY(0xb65), TBL_ENTRY(0xb66), TBL_ENTRY(0xb67),
	TBL_ENTRY(0xb68), TBL_ENTRY(0xb69), TBL_ENTRY(0xb6a), TBL_ENTRY(0xb6b),
	TBL_ENTRY(0xb6c), TBL_ENTRY(0xb6d), TBL_ENTRY(0xb6e), TBL_ENTRY(0xb6f),
	TBL_ENTRY(0xb70), TBL_ENTRY(0xb71), TBL_ENTRY(0xb72), TBL_ENTRY(0xb73),
	TBL_ENTRY(0xb74), TBL_ENTRY(0xb75), TBL_ENTRY(0xb76), TBL_ENTRY(0xb77),
	TBL_ENTRY(0xb78), TBL_ENTRY(0xb79), TBL_ENTRY(0xb7a), TBL_ENTRY(0xb7b),
	TBL_ENTRY(0xb7c), TBL_ENTRY(0xb7d), TBL_ENTRY(0xb7e), TBL_ENTRY(0xb7f),
	TBL_ENTRY(0xb80), TBL_ENTRY(0xb81), TBL_ENTRY(0xb82), TBL_ENTRY(0xb83),
	TBL_ENTRY(0xb84), TBL_ENTRY(0xb85), TBL_ENTRY(0xb86), TBL_ENTRY(0xb87),
	TBL_ENTRY(0xb88), TBL_ENTRY(0xb89), TBL_ENTRY(0xb8a), TBL_ENTRY(0xb8b),
	TBL_ENTRY(0xb8c), TBL_ENTRY(0xb8d), TBL_ENTRY(0xb8e), TBL_ENTRY(0xb8f),
	TBL_ENTRY(0xb90), TBL_ENTRY(0xb91), TBL_ENTRY(0xb92), TBL_ENTRY(0xb93),
	TBL_ENTRY(0xb94), TBL_ENTRY(0xb95), TBL_ENTRY(0xb96), TBL_ENTRY(0xb97),
	TBL_ENTRY(0xb98), TBL_ENTRY(0xb99), TBL_ENTRY(0xb9a), TBL_ENTRY(0xb9b),
	TBL_ENTRY(0xb9c), TBL_ENTRY(0xb9d), TBL_ENTRY(0xb9e), TBL_ENTRY(0xb9f),
	TBL_ENTRY(0xba0), TBL_ENTRY(0xba1), TBL_ENTRY(0xba2), TBL_ENTRY(0xba3),
	TBL_ENTRY(0xba4), TBL_ENTRY(0xba5), TBL_ENTRY(0xba6), TBL_ENTRY(0xba7),
	TBL_ENTRY(0xba8), TBL_ENTRY(0xba9), TBL_ENTRY(0xbaa), TBL_ENTRY(0xbab),
	TBL_ENTRY(0xbac), TBL_ENTRY(0xbad), TBL_ENTRY(0xbae), TBL_ENTRY(0xbaf),
	TBL_ENTRY(0xbb0), TBL_ENTRY(0xbb1), TBL_ENTRY(0xbb2), TBL_ENTRY(0xbb3),
	TBL_ENTRY(0xbb4), TBL_ENTRY(0xbb5), TBL_ENTRY(0xbb6), TBL_ENTRY(0xbb7),
	TBL_ENTRY(0xbb8), TBL_ENTRY(0xbb9), TBL_ENTRY(0xbba), TBL_ENTRY(0xbbb),
	TBL_ENTRY(0xbbc), TBL_ENTRY(0xbbd), TBL_ENTRY(0xbbe), TBL_ENTRY(0xbbf),
	TBL_ENTRY(0xbc0), TBL_ENTRY(0xbc1), TBL_ENTRY(0xbc2), TBL_ENTRY(0xbc3),
	TBL_ENTRY(0xbc4), TBL_ENTRY(0xbc5), TBL_ENTRY(0xbc6), TBL_ENTRY(0xbc7),
	TBL_ENTRY(0xbc8), TBL_ENTRY(0xbc9), TBL_ENTRY(0xbca), TBL_ENTRY(0xbcb),
	TBL_ENTRY(0xbcc), TBL_ENTRY(0xbcd), TBL_ENTRY(0xbce), TBL_ENTRY(0xbcf),
	TBL_ENTRY(0xbd0), TBL_ENTRY(0xbd1), TBL_ENTRY(0xbd2), TBL_ENTRY(0xbd3),
	TBL_ENTRY(0xbd4), TBL_ENTRY(0xbd5), TBL_ENTRY(0xbd6), TBL_ENTRY(0xbd7),
	TBL_ENTRY(0xbd8), TBL_ENTRY(0xbd9), TBL_ENTRY(0xbda), TBL_ENTRY(0xbdb),
	TBL_ENTRY(0xbdc), TBL_ENTRY(0xbdd), TBL_ENTRY(0xbde), TBL_ENTRY(0xbdf),
	TBL_ENTRY(0xbe0), TBL_ENTRY(0xbe1), TBL_ENTRY(0xbe2), TBL_ENTRY(0xbe3),
	TBL_ENTRY(0xbe4), TBL_ENTRY(0xbe5), TBL_ENTRY(0xbe6), TBL_ENTRY(0xbe7),
	TBL_ENTRY(0xbe8), TBL_ENTRY(0xbe9), TBL_ENTRY(0xbea), TBL_ENTRY(0xbeb),
	TBL_ENTRY(0xbec), TBL_ENTRY(0xbed), TBL_ENTRY(0xbee), TBL_ENTRY(0xbef),
	TBL_ENTRY(0xbf0), TBL_ENTRY(0xbf1), TBL_ENTRY(0xbf2), TBL_ENTRY(0xbf3),
	TBL_ENTRY(0xbf4), TBL_ENTRY(0xbf5), TBL_ENTRY(0xbf6), TBL_ENTRY(0xbf7),
	TBL_ENTRY(0xbf8), TBL_ENTRY(0xbf9), TBL_ENTRY(0xbfa), TBL_ENTRY(0xbfb),
	TBL_ENTRY(0xbfc), TBL_ENTRY(0xbfd), TBL_ENTRY(0xbfe), TBL_ENTRY(0xbff),
	TBL_ENTRY(0xc00), TBL_ENTRY(0xc01), TBL_ENTRY(0xc02), TBL_ENTRY(0xc03),
	TBL_ENTRY(0xc04), TBL_ENTRY(0xc05), TBL_ENTRY(0xc06), TBL_ENTRY(0xc07),
	TBL_ENTRY(0xc08), TBL_ENTRY(0xc09), TBL_ENTRY(0xc0a), TBL_ENTRY(0xc0b),
	TBL_ENTRY(0xc0c), TBL_ENTRY(0xc0d), TBL_ENTRY(0xc0e), TBL_ENTRY(0xc0f),
	TBL_ENTRY(0xc10), TBL_ENTRY(0xc11), TBL_ENTRY(0xc12), TBL_ENTRY(0xc13),
	TBL_ENTRY(0xc14), TBL_ENTRY(0xc15), TBL_ENTRY(0xc16), TBL_ENTRY(0xc17),
	TBL_ENTRY(0xc18), TBL_ENTRY(0xc19), TBL_ENTRY(0xc1a), TBL_ENTRY(0xc1b),
	TBL_ENTRY(0xc1c), TBL_ENTRY(0xc1d), TBL_ENTRY(0xc1e), TBL_ENTRY(0xc1f),
	TBL_ENTRY(0xc20), TBL_ENTRY(0xc21), TBL_ENTRY(0xc22), TBL_ENTRY(0xc23),
	TBL_ENTRY(0xc24), TBL_ENTRY(0xc25), TBL_ENTRY(0xc26), TBL_ENTRY(0xc27),
	TBL_ENTRY(0xc28), TBL_ENTRY(0xc29), TBL_ENTRY(0xc2a), TBL_ENTRY(0xc2b),
	TBL_ENTRY(0xc2c), TBL_ENTRY(0xc2d), TBL_ENTRY(0xc2e), TBL_ENTRY(0xc2f),
	TBL_ENTRY(0xc30), TBL_ENTRY(0xc31), TBL_ENTRY(0xc32), TBL_ENTRY(0xc33),
	TBL_ENTRY(0xc34), TBL_ENTRY(0xc35), TBL_ENTRY(0xc36), TBL_ENTRY(0xc37),
	TBL_ENTRY(0xc38), TBL_ENTRY(0xc39), TBL_ENTRY(0xc3a), TBL_ENTRY(0xc3b),
	TBL_ENTRY(0xc3c), TBL_ENTRY(0xc3d), TBL_ENTRY(0xc3e), TBL_ENTRY(0xc3f),
	TBL_ENTRY(0xc40), TBL_ENTRY(0xc41), TBL_ENTRY(0xc42), TBL_ENTRY(0xc43),
	TBL_ENTRY(0xc44), TBL_ENTRY(0xc45), TBL_ENTRY(0xc46), TBL_ENTRY(0xc47),
	TBL_ENTRY(0xc48), TBL_ENTRY(0xc49), TBL_ENTRY(0xc4a), TBL_ENTRY(0xc4b),
	TBL_ENTRY(0xc4c), TBL_ENTRY(0xc4d), TBL_ENTRY(0xc4e), TBL_ENTRY(0xc4f),
	TBL_ENTRY(0xc50), TBL_ENTRY(0xc51), TBL_ENTRY(0xc52), TBL_ENTRY(0xc53),
	TBL_ENTRY(0xc54), TBL_ENTRY(0xc55), TBL_ENTRY(0xc56), TBL_ENTRY(0xc57),
	TBL_ENTRY(0xc58), TBL_ENTRY(0xc59), TBL_ENTRY(0xc5a), TBL_ENTRY(0xc5b),
	TBL_ENTRY(0xc5c), TBL_ENTRY(0xc5d), TBL_ENTRY(0xc5e), TBL_ENTRY(0xc5f),
	TBL_ENTRY(0xc60), TBL_ENTRY(0xc61), TBL_ENTRY(0xc62), TBL_ENTRY(0xc63),
	TBL_ENTRY(0xc64), TBL_ENTRY(0xc65), TBL_ENTRY(0xc66), TBL_ENTRY(0xc67),
	TBL_ENTRY(0xc68), TBL_ENTRY(0xc69), TBL_ENTRY(0xc6a), TBL_ENTRY(0xc6b),
	TBL_ENTRY(0xc6c), TBL_ENTRY(0xc6d), TBL_ENTRY(0xc6e), TBL_ENTRY(0xc6f),
	TBL_ENTRY(0xc70), TBL_ENTRY(0xc71), TBL_ENTRY(0xc72), TBL_ENTRY(0xc73),
	TBL_ENTRY(0xc74), TBL_ENTRY(0xc75), TBL_ENTRY(0xc76), TBL_ENTRY(0xc77),
	TBL_ENTRY(0xc78), TBL_ENTRY(0xc79), TBL_ENTRY(0xc7a), TBL_ENTRY(0xc7b),
	TBL_ENTRY(0xc7c), TBL_ENTRY(0xc7d), TBL_ENTRY(0xc7e), TBL_ENTRY(0xc7f),
	TBL_ENTRY(0xc80), TBL_ENTRY(0xc81), TBL_ENTRY(0xc82), TBL_ENTRY(0xc83),
	TBL_ENTRY(0xc84), TBL_ENTRY(0xc85), TBL_ENTRY(0xc86), TBL_ENTRY(0xc87),
	TBL_ENTRY(0xc88), TBL_ENTRY(0xc89), TBL_ENTRY(0xc8a), TBL_ENTRY(0xc8b),
	TBL_ENTRY(0xc8c), TBL_ENTRY(0xc8d), TBL_ENTRY(0xc8e), TBL_ENTRY(0xc8f),
	TBL_ENTRY(0xc90), TBL_ENTRY(0xc91), TBL_ENTRY(0xc92), TBL_ENTRY(0xc93),
	TBL_ENTRY(0xc94), TBL_ENTRY(0xc95), TBL_ENTRY(0xc96), TBL_ENTRY(0xc97),
	TBL_ENTRY(0xc98), TBL_ENTRY(0xc99), TBL_ENTRY(0xc9a), TBL_ENTRY(0xc9b),
	TBL_ENTRY(0xc9c), TBL_ENTRY(0xc9d), TBL_ENTRY(0xc9e), TBL_ENTRY(0xc9f),
	TBL_ENTRY(0xca0), TBL_ENTRY(0xca1), TBL_ENTRY(0xca2), TBL_ENTRY(0xca3),
	TBL_ENTRY(0xca4), TBL_ENTRY(0xca5), TBL_ENTRY(0xca6), TBL_ENTRY(0xca7),
	TBL_ENTRY(0xca8), TBL_ENTRY(0xca9), TBL_ENTRY(0xcaa), TBL_ENTRY(0xcab),
	TBL_ENTRY(0xcac), TBL_ENTRY(0xcad), TBL_ENTRY(0xcae), TBL_ENTRY(0xcaf),
	TBL_ENTRY(0xcb0), TBL_ENTRY(0xcb1), TBL_ENTRY(0xcb2), TBL_ENTRY(0xcb3),
	TBL_ENTRY(0xcb4), TBL_ENTRY(0xcb5), TBL_ENTRY(0xcb6), TBL_ENTRY(0xcb7),
	TBL_ENTRY(0xcb8), TBL_ENTRY(0xcb9), TBL_ENTRY(0xcba), TBL_ENTRY(0xcbb),
	TBL_ENTRY(0xcbc), TBL_ENTRY(0xcbd), TBL_ENTRY(0xcbe), TBL_ENTRY(0xcbf),
	TBL_ENTRY(0xcc0), TBL_ENTRY(0xcc1), TBL_ENTRY(0xcc2), TBL_ENTRY(0xcc3),
	TBL_ENTRY(0xcc4), TBL_ENTRY(0xcc5), TBL_ENTRY(0xcc6), TBL_ENTRY(0xcc7),
	TBL_ENTRY(0xcc8), TBL_ENTRY(0xcc9), TBL_ENTRY(0xcca), TBL_ENTRY(0xccb),
	TBL_ENTRY(0xccc), TBL_ENTRY(0xccd), TBL_ENTRY(0xcce), TBL_ENTRY(0xccf),
	TBL_ENTRY(0xcd0), TBL_ENTRY(0xcd1), TBL_ENTRY(0xcd2), TBL_ENTRY(0xcd3),
	TBL_ENTRY(0xcd4), TBL_ENTRY(0xcd5), TBL_ENTRY(0xcd6), TBL_ENTRY(0xcd7),
	TBL_ENTRY(0xcd8), TBL_ENTRY(0xcd9), TBL_ENTRY(0xcda), TBL_ENTRY(0xcdb),
	TBL_ENTRY(0xcdc), TBL_ENTRY(0xcdd), TBL_ENTRY(0xcde), TBL_ENTRY(0xcdf),
	TBL_ENTRY(0xce0), TBL_ENTRY(0xce1), TBL_ENTRY(0xce2), TBL_ENTRY(0xce3),
	TBL_ENTRY(0xce4), TBL_ENTRY(0xce5), TBL_ENTRY(0xce6), TBL_ENTRY(0xce7),
	TBL_ENTRY(0xce8), TBL_ENTRY(0xce9), TBL_ENTRY(0xcea), TBL_ENTRY(0xceb),
	TBL_ENTRY(0xcec), TBL_ENTRY(0xced), TBL_ENTRY(0xcee), TBL_ENTRY(0xcef),
	TBL_ENTRY(0xcf0), TBL_ENTRY(0xcf1), TBL_ENTRY(0xcf2), TBL_ENTRY(0xcf3),
	TBL_ENTRY(0xcf4), TBL_ENTRY(0xcf5), TBL_ENTRY(0xcf6), TBL_ENTRY(0xcf7),
	TBL_ENTRY(0xcf8), TBL_ENTRY(0xcf9), TBL_ENTRY(0xcfa), TBL_ENTRY(0xcfb),
	TBL_ENTRY(0xcfc), TBL_ENTRY(0xcfd), TBL_ENTRY(0xcfe), TBL_ENTRY(0xcff),
	TBL_ENTRY(0xd00), TBL_ENTRY(0xd01), TBL_ENTRY(0xd02), TBL_ENTRY(0xd03),
	TBL_ENTRY(0xd04), TBL_ENTRY(0xd05), TBL_ENTRY(0xd06), TBL_ENTRY(0xd07),
	TBL_ENTRY(0xd08), TBL_ENTRY(0xd09), TBL_ENTRY(0xd0a), TBL_ENTRY(0xd0b),
	TBL_ENTRY(0xd0c), TBL_ENTRY(0xd0d), TBL_ENTRY(0xd0e), TBL_ENTRY(0xd0f),
	TBL_ENTRY(0xd10), TBL_ENTRY(0xd11), TBL_ENTRY(0xd12), TBL_ENTRY(0xd13),
	TBL_ENTRY(0xd14), TBL_ENTRY(0xd15), TBL_ENTRY(0xd16), TBL_ENTRY(0xd17),
	TBL_ENTRY(0xd18), TBL_ENTRY(0xd19), TBL_ENTRY(0xd1a), TBL_ENTRY(0xd1b),
	TBL_ENTRY(0xd1c), TBL_ENTRY(0xd1d), TBL_ENTRY(0xd1e), TBL_ENTRY(0xd1f),
	TBL_ENTRY(0xd20), TBL_ENTRY(0xd21), TBL_ENTRY(0xd22), TBL_ENTRY(0xd23),
	TBL_ENTRY(0xd24), TBL_ENTRY(0xd25), TBL_ENTRY(0xd26), TBL_ENTRY(0xd27),
	TBL_ENTRY(0xd28), TBL_ENTRY(0xd29), TBL_ENTRY(0xd2a), TBL_ENTRY(0xd2b),
	TBL_ENTRY(0xd2c), TBL_ENTRY(0xd2d), TBL_ENTRY(0xd2e), TBL_ENTRY(0xd2f),
	TBL_ENTRY(0xd30), TBL_ENTRY(0xd31), TBL_ENTRY(0xd32), TBL_ENTRY(0xd33),
	TBL_ENTRY(0xd34), TBL_ENTRY(0xd35), TBL_ENTRY(0xd36), TBL_ENTRY(0xd37),
	TBL_ENTRY(0xd38), TBL_ENTRY(0xd39), TBL_ENTRY(0xd3a), TBL_ENTRY(0xd3b),
	TBL_ENTRY(0xd3c), TBL_ENTRY(0xd3d), TBL_ENTRY(0xd3e), TBL_ENTRY(0xd3f),
	TBL_ENTRY(0xd40), TBL_ENTRY(0xd41), TBL_ENTRY(0xd42), TBL_ENTRY(0xd43),
	TBL_ENTRY(0xd44), TBL_ENTRY(0xd45), TBL_ENTRY(0xd46), TBL_ENTRY(0xd47),
	TBL_ENTRY(0xd48), TBL_ENTRY(0xd49), TBL_ENTRY(0xd4a), TBL_ENTRY(0xd4b),
	TBL_ENTRY(0xd4c), TBL_ENTRY(0xd4d), TBL_ENTRY(0xd4e), TBL_ENTRY(0xd4f),
	TBL_ENTRY(0xd50), TBL_ENTRY(0xd51), TBL_ENTRY(0xd52), TBL_ENTRY(0xd53),
	TBL_ENTRY(0xd54), TBL_ENTRY(0xd55), TBL_ENTRY(0xd56), TBL_ENTRY(0xd57),
	TBL_ENTRY(0xd58), TBL_ENTRY(0xd59), TBL_ENTRY(0xd5a), TBL_ENTRY(0xd5b),
	TBL_ENTRY(0xd5c), TBL_ENTRY(0xd5d), TBL_ENTRY(0xd5e), TBL_ENTRY(0xd5f),
	TBL_ENTRY(0xd60), TBL_ENTRY(0xd61), TBL_ENTRY(0xd62), TBL_ENTRY(0xd63),
	TBL_ENTRY(0xd64), TBL_ENTRY(0xd65), TBL_ENTRY(0xd66), TBL_ENTRY(0xd67),
	TBL_ENTRY(0xd68), TBL_ENTRY(0xd69), TBL_ENTRY(0xd6a), TBL_ENTRY(0xd6b),
	TBL_ENTRY(0xd6c), TBL_ENTRY(0xd6d), TBL_ENTRY(0xd6e), TBL_ENTRY(0xd6f),
	TBL_ENTRY(0xd70), TBL_ENTRY(0xd71), TBL_ENTRY(0xd72), TBL_ENTRY(0xd73),
	TBL_ENTRY(0xd74), TBL_ENTRY(0xd75), TBL_ENTRY(0xd76), TBL_ENTRY(0xd77),
	TBL_ENTRY(0xd78), TBL_ENTRY(0xd79), TBL_ENTRY(0xd7a), TBL_ENTRY(0xd7b),
	TBL_ENTRY(0xd7c), TBL_ENTRY(0xd7d), TBL_ENTRY(0xd7e), TBL_ENTRY(0xd7f),
	TBL_ENTRY(0xd80), TBL_ENTRY(0xd81), TBL_ENTRY(0xd82), TBL_ENTRY(0xd83),
	TBL_ENTRY(0xd84), TBL_ENTRY(0xd85), TBL_ENTRY(0xd86), TBL_ENTRY(0xd87),
	TBL_ENTRY(0xd88), TBL_ENTRY(0xd89), TBL_ENTRY(0xd8a), TBL_ENTRY(0xd8b),
	TBL_ENTRY(0xd8c), TBL_ENTRY(0xd8d), TBL_ENTRY(0xd8e), TBL_ENTRY(0xd8f),
	TBL_ENTRY(0xd90), TBL_ENTRY(0xd91), TBL_ENTRY(0xd92), TBL_ENTRY(0xd93),
	TBL_ENTRY(0xd94), TBL_ENTRY(0xd95), TBL_ENTRY(0xd96), TBL_ENTRY(0xd97),
	TBL_ENTRY(0xd98), TBL_ENTRY(0xd99), TBL_ENTRY(0xd9a), TBL_ENTRY(0xd9b),
	TBL_ENTRY(0xd9c), TBL_ENTRY(0xd9d), TBL_ENTRY(0xd9e), TBL_ENTRY(0xd9f),
	TBL_ENTRY(0xda0), TBL_ENTRY(0xda1), TBL_ENTRY(0xda2), TBL_ENTRY(0xda3),
	TBL_ENTRY(0xda4), TBL_ENTRY(0xda5), TBL_ENTRY(0xda6), TBL_ENTRY(0xda7),
	TBL_ENTRY(0xda8), TBL_ENTRY(0xda9), TBL_ENTRY(0xdaa), TBL_ENTRY(0xdab),
	TBL_ENTRY(0xdac), TBL_ENTRY(0xdad), TBL_ENTRY(0xdae), TBL_ENTRY(0xdaf),
	TBL_ENTRY(0xdb0), TBL_ENTRY(0xdb1), TBL_ENTRY(0xdb2), TBL_ENTRY(0xdb3),
	TBL_ENTRY(0xdb4), TBL_ENTRY(0xdb5), TBL_ENTRY(0xdb6), TBL_ENTRY(0xdb7),
	TBL_ENTRY(0xdb8), TBL_ENTRY(0xdb9), TBL_ENTRY(0xdba), TBL_ENTRY(0xdbb),
	TBL_ENTRY(0xdbc), TBL_ENTRY(0xdbd), TBL_ENTRY(0xdbe), TBL_ENTRY(0xdbf),
	TBL_ENTRY(0xdc0), TBL_ENTRY(0xdc1), TBL_ENTRY(0xdc2), TBL_ENTRY(0xdc3),
	TBL_ENTRY(0xdc4), TBL_ENTRY(0xdc5), TBL_ENTRY(0xdc6), TBL_ENTRY(0xdc7),
	TBL_ENTRY(0xdc8), TBL_ENTRY(0xdc9), TBL_ENTRY(0xdca), TBL_ENTRY(0xdcb),
	TBL_ENTRY(0xdcc), TBL_ENTRY(0xdcd), TBL_ENTRY(0xdce), TBL_ENTRY(0xdcf),
	TBL_ENTRY(0xdd0), TBL_ENTRY(0xdd1), TBL_ENTRY(0xdd2), TBL_ENTRY(0xdd3),
	TBL_ENTRY(0xdd4), TBL_ENTRY(0xdd5), TBL_ENTRY(0xdd6), TBL_ENTRY(0xdd7),
	TBL_ENTRY(0xdd8), TBL_ENTRY(0xdd9), TBL_ENTRY(0xdda), TBL_ENTRY(0xddb),
	TBL_ENTRY(0xddc), TBL_ENTRY(0xddd), TBL_ENTRY(0xdde), TBL_ENTRY(0xddf),
	TBL_ENTRY(0xde0), TBL_ENTRY(0xde1), TBL_ENTRY(0xde2), TBL_ENTRY(0xde3),
	TBL_ENTRY(0xde4), TBL_ENTRY(0xde5), TBL_ENTRY(0xde6), TBL_ENTRY(0xde7),
	TBL_ENTRY(0xde8), TBL_ENTRY(0xde9), TBL_ENTRY(0xdea), TBL_ENTRY(0xdeb),
	TBL_ENTRY(0xdec), TBL_ENTRY(0xded), TBL_ENTRY(0xdee), TBL_ENTRY(0xdef),
	TBL_ENTRY(0xdf0), TBL_ENTRY(0xdf1), TBL_ENTRY(0xdf2), TBL_ENTRY(0xdf3),
	TBL_ENTRY(0xdf4), TBL_ENTRY(0xdf5), TBL_ENTRY(0xdf6), TBL_ENTRY(0xdf7),
	TBL_ENTRY(0xdf8), TBL_ENTRY(0xdf9), TBL_ENTRY(0xdfa), TBL_ENTRY(0xdfb),
	TBL_ENTRY(0xdfc), TBL_ENTRY(0xdfd), TBL_ENTRY(0xdfe), TBL_ENTRY(0xdff),
	TBL_ENTRY(0xe00), TBL_ENTRY(0xe01), TBL_ENTRY(0xe02), TBL_ENTRY(0xe03),
	TBL_ENTRY(0xe04), TBL_ENTRY(0xe05), TBL_ENTRY(0xe06), TBL_ENTRY(0xe07),
	TBL_ENTRY(0xe08), TBL_ENTRY(0xe09), TBL_ENTRY(0xe0a), TBL_ENTRY(0xe0b),
	TBL_ENTRY(0xe0c), TBL_ENTRY(0xe0d), TBL_ENTRY(0xe0e), TBL_ENTRY(0xe0f),
	TBL_ENTRY(0xe10), TBL_ENTRY(0xe11), TBL_ENTRY(0xe12), TBL_ENTRY(0xe13),
	TBL_ENTRY(0xe14), TBL_ENTRY(0xe15), TBL_ENTRY(0xe16), TBL_ENTRY(0xe17),
	TBL_ENTRY(0xe18), TBL_ENTRY(0xe19), TBL_ENTRY(0xe1a), TBL_ENTRY(0xe1b),
	TBL_ENTRY(0xe1c), TBL_ENTRY(0xe1d), TBL_ENTRY(0xe1e), TBL_ENTRY(0xe1f),
	TBL_ENTRY(0xe20), TBL_ENTRY(0xe21), TBL_ENTRY(0xe22), TBL_ENTRY(0xe23),
	TBL_ENTRY(0xe24), TBL_ENTRY(0xe25), TBL_ENTRY(0xe26), TBL_ENTRY(0xe27),
	TBL_ENTRY(0xe28), TBL_ENTRY(0xe29), TBL_ENTRY(0xe2a), TBL_ENTRY(0xe2b),
	TBL_ENTRY(0xe2c), TBL_ENTRY(0xe2d), TBL_ENTRY(0xe2e), TBL_ENTRY(0xe2f),
	TBL_ENTRY(0xe30), TBL_ENTRY(0xe31), TBL_ENTRY(0xe32), TBL_ENTRY(0xe33),
	TBL_ENTRY(0xe34), TBL_ENTRY(0xe35), TBL_ENTRY(0xe36), TBL_ENTRY(0xe37),
	TBL_ENTRY(0xe38), TBL_ENTRY(0xe39), TBL_ENTRY(0xe3a), TBL_ENTRY(0xe3b),
	TBL_ENTRY(0xe3c), TBL_ENTRY(0xe3d), TBL_ENTRY(0xe3e), TBL_ENTRY(0xe3f),
	TBL_ENTRY(0xe40), TBL_ENTRY(0xe41), TBL_ENTRY(0xe42), TBL_ENTRY(0xe43),
	TBL_ENTRY(0xe44), TBL_ENTRY(0xe45), TBL_ENTRY(0xe46), TBL_ENTRY(0xe47),
	TBL_ENTRY(0xe48), TBL_ENTRY(0xe49), TBL_ENTRY(0xe4a), TBL_ENTRY(0xe4b),
	TBL_ENTRY(0xe4c), TBL_ENTRY(0xe4d), TBL_ENTRY(0xe4e), TBL_ENTRY(0xe4f),
	TBL_ENTRY(0xe50), TBL_ENTRY(0xe51), TBL_ENTRY(0xe52), TBL_ENTRY(0xe53),
	TBL_ENTRY(0xe54), TBL_ENTRY(0xe55), TBL_ENTRY(0xe56), TBL_ENTRY(0xe57),
	TBL_ENTRY(0xe58), TBL_ENTRY(0xe59), TBL_ENTRY(0xe5a), TBL_ENTRY(0xe5b),
	TBL_ENTRY(0xe5c), TBL_ENTRY(0xe5d), TBL_ENTRY(0xe5e), TBL_ENTRY(0xe5f),
	TBL_ENTRY(0xe60), TBL_ENTRY(0xe61), TBL_ENTRY(0xe62), TBL_ENTRY(0xe63),
	TBL_ENTRY(0xe64), TBL_ENTRY(0xe65), TBL_ENTRY(0xe66), TBL_ENTRY(0xe67),
	TBL_ENTRY(0xe68), TBL_ENTRY(0xe69), TBL_ENTRY(0xe6a), TBL_ENTRY(0xe6b),
	TBL_ENTRY(0xe6c), TBL_ENTRY(0xe6d), TBL_ENTRY(0xe6e), TBL_ENTRY(0xe6f),
	TBL_ENTRY(0xe70), TBL_ENTRY(0xe71), TBL_ENTRY(0xe72), TBL_ENTRY(0xe73),
	TBL_ENTRY(0xe74), TBL_ENTRY(0xe75), TBL_ENTRY(0xe76), TBL_ENTRY(0xe77),
	TBL_ENTRY(0xe78), TBL_ENTRY(0xe79), TBL_ENTRY(0xe7a), TBL_ENTRY(0xe7b),
	TBL_ENTRY(0xe7c), TBL_ENTRY(0xe7d), TBL_ENTRY(0xe7e), TBL_ENTRY(0xe7f),
	TBL_ENTRY(0xe80), TBL_ENTRY(0xe81), TBL_ENTRY(0xe82), TBL_ENTRY(0xe83),
	TBL_ENTRY(0xe84), TBL_ENTRY(0xe85), TBL_ENTRY(0xe86), TBL_ENTRY(0xe87),
	TBL_ENTRY(0xe88), TBL_ENTRY(0xe89), TBL_ENTRY(0xe8a), TBL_ENTRY(0xe8b),
	TBL_ENTRY(0xe8c), TBL_ENTRY(0xe8d), TBL_ENTRY(0xe8e), TBL_ENTRY(0xe8f),
	TBL_ENTRY(0xe90), TBL_ENTRY(0xe91), TBL_ENTRY(0xe92), TBL_ENTRY(0xe93),
	TBL_ENTRY(0xe94), TBL_ENTRY(0xe95), TBL_ENTRY(0xe96), TBL_ENTRY(0xe97),
	TBL_ENTRY(0xe98), TBL_ENTRY(0xe99), TBL_ENTRY(0xe9a), TBL_ENTRY(0xe9b),
	TBL_ENTRY(0xe9c), TBL_ENTRY(0xe9d), TBL_ENTRY(0xe9e), TBL_ENTRY(0xe9f),
	TBL_ENTRY(0xea0), TBL_ENTRY(0xea1), TBL_ENTRY(0xea2), TBL_ENTRY(0xea3),
	TBL_ENTRY(0xea4), TBL_ENTRY(0xea5), TBL_ENTRY(0xea6), TBL_ENTRY(0xea7),
	TBL_ENTRY(0xea8), TBL_ENTRY(0xea9), TBL_ENTRY(0xeaa), TBL_ENTRY(0xeab),
	TBL_ENTRY(0xeac), TBL_ENTRY(0xead), TBL_ENTRY(0xeae), TBL_ENTRY(0xeaf),
	TBL_ENTRY(0xeb0), TBL_ENTRY(0xeb1), TBL_ENTRY(0xeb2), TBL_ENTRY(0xeb3),
	TBL_ENTRY(0xeb4), TBL_ENTRY(0xeb5), TBL_ENTRY(0xeb6), TBL_ENTRY(0xeb7),
	TBL_ENTRY(0xeb8), TBL_ENTRY(0xeb9), TBL_ENTRY(0xeba), TBL_ENTRY(0xebb),
	TBL_ENTRY(0xebc), TBL_ENTRY(0xebd), TBL_ENTRY(0xebe), TBL_ENTRY(0xebf),
	TBL_ENTRY(0xec0), TBL_ENTRY(0xec1), TBL_ENTRY(0xec2), TBL_ENTRY(0xec3),
	TBL_ENTRY(0xec4), TBL_ENTRY(0xec5), TBL_ENTRY(0xec6), TBL_ENTRY(0xec7),
	TBL_ENTRY(0xec8), TBL_ENTRY(0xec9), TBL_ENTRY(0xeca), TBL_ENTRY(0xecb),
	TBL_ENTRY(0xecc), TBL_ENTRY(0xecd), TBL_ENTRY(0xece), TBL_ENTRY(0xecf),
	TBL_ENTRY(0xed0), TBL_ENTRY(0xed1), TBL_ENTRY(0xed2), TBL_ENTRY(0xed3),
	TBL_ENTRY(0xed4), TBL_ENTRY(0xed5), TBL_ENTRY(0xed6), TBL_ENTRY(0xed7),
	TBL_ENTRY(0xed8), TBL_ENTRY(0xed9), TBL_ENTRY(0xeda), TBL_ENTRY(0xedb),
	TBL_ENTRY(0xedc), TBL_ENTRY(0xedd), TBL_ENTRY(0xede), TBL_ENTRY(0xedf),
	TBL_ENTRY(0xee0), TBL_ENTRY(0xee1), TBL_ENTRY(0xee2), TBL_ENTRY(0xee3),
	TBL_ENTRY(0xee4), TBL_ENTRY(0xee5), TBL_ENTRY(0xee6), TBL_ENTRY(0xee7),
	TBL_ENTRY(0xee8), TBL_ENTRY(0xee9), TBL_ENTRY(0xeea), TBL_ENTRY(0xeeb),
	TBL_ENTRY(0xeec), TBL_ENTRY(0xeed), TBL_ENTRY(0xeee), TBL_ENTRY(0xeef),
	TBL_ENTRY(0xef0), TBL_ENTRY(0xef1), TBL_ENTRY(0xef2), TBL_ENTRY(0xef3),
	TBL_ENTRY(0xef4), TBL_ENTRY(0xef5), TBL_ENTRY(0xef6), TBL_ENTRY(0xef7),
	TBL_ENTRY(0xef8), TBL_ENTRY(0xef9), TBL_ENTRY(0xefa), TBL_ENTRY(0xefb),
	TBL_ENTRY(0xefc), TBL_ENTRY(0xefd), TBL_ENTRY(0xefe), TBL_ENTRY(0xeff),
	TBL_ENTRY(0xf00), TBL_ENTRY(0xf01), TBL_ENTRY(0xf02), TBL_ENTRY(0xf03),
	TBL_ENTRY(0xf04), TBL_ENTRY(0xf05), TBL_ENTRY(0xf06), TBL_ENTRY(0xf07),
	TBL_ENTRY(0xf08), TBL_ENTRY(0xf09), TBL_ENTRY(0xf0a), TBL_ENTRY(0xf0b),
	TBL_ENTRY(0xf0c), TBL_ENTRY(0xf0d), TBL_ENTRY(0xf0e), TBL_ENTRY(0xf0f),
	TBL_ENTRY(0xf10), TBL_ENTRY(0xf11), TBL_ENTRY(0xf12), TBL_ENTRY(0xf13),
	TBL_ENTRY(0xf14), TBL_ENTRY(0xf15), TBL_ENTRY(0xf16), TBL_ENTRY(0xf17),
	TBL_ENTRY(0xf18), TBL_ENTRY(0xf19), TBL_ENTRY(0xf1a), TBL_ENTRY(0xf1b),
	TBL_ENTRY(0xf1c), TBL_ENTRY(0xf1d), TBL_ENTRY(0xf1e), TBL_ENTRY(0xf1f),
	TBL_ENTRY(0xf20), TBL_ENTRY(0xf21), TBL_ENTRY(0xf22), TBL_ENTRY(0xf23),
	TBL_ENTRY(0xf24), TBL_ENTRY(0xf25), TBL_ENTRY(0xf26), TBL_ENTRY(0xf27),
	TBL_ENTRY(0xf28), TBL_ENTRY(0xf29), TBL_ENTRY(0xf2a), TBL_ENTRY(0xf2b),
	TBL_ENTRY(0xf2c), TBL_ENTRY(0xf2d), TBL_ENTRY(0xf2e), TBL_ENTRY(0xf2f),
	TBL_ENTRY(0xf30), TBL_ENTRY(0xf31), TBL_ENTRY(0xf32), TBL_ENTRY(0xf33),
	TBL_ENTRY(0xf34), TBL_ENTRY(0xf35), TBL_ENTRY(0xf36), TBL_ENTRY(0xf37),
	TBL_ENTRY(0xf38), TBL_ENTRY(0xf39), TBL_ENTRY(0xf3a), TBL_ENTRY(0xf3b),
	TBL_ENTRY(0xf3c), TBL_ENTRY(0xf3d), TBL_ENTRY(0xf3e), TBL_ENTRY(0xf3f),
	TBL_ENTRY(0xf40), TBL_ENTRY(0xf41), TBL_ENTRY(0xf42), TBL_ENTRY(0xf43),
	TBL_ENTRY(0xf44), TBL_ENTRY(0xf45), TBL_ENTRY(0xf46), TBL_ENTRY(0xf47),
	TBL_ENTRY(0xf48), TBL_ENTRY(0xf49), TBL_ENTRY(0xf4a), TBL_ENTRY(0xf4b),
	TBL_ENTRY(0xf4c), TBL_ENTRY(0xf4d), TBL_ENTRY(0xf4e), TBL_ENTRY(0xf4f),
	TBL_ENTRY(0xf50), TBL_ENTRY(0xf51), TBL_ENTRY(0xf52), TBL_ENTRY(0xf53),
	TBL_ENTRY(0xf54), TBL_ENTRY(0xf55), TBL_ENTRY(0xf56), TBL_ENTRY(0xf57),
	TBL_ENTRY(0xf58), TBL_ENTRY(0xf59), TBL_ENTRY(0xf5a), TBL_ENTRY(0xf5b),
	TBL_ENTRY(0xf5c), TBL_ENTRY(0xf5d), TBL_ENTRY(0xf5e), TBL_ENTRY(0xf5f),
	TBL_ENTRY(0xf60), TBL_ENTRY(0xf61), TBL_ENTRY(0xf62), TBL_ENTRY(0xf63),
	TBL_ENTRY(0xf64), TBL_ENTRY(0xf65), TBL_ENTRY(0xf66), TBL_ENTRY(0xf67),
	TBL_ENTRY(0xf68), TBL_ENTRY(0xf69), TBL_ENTRY(0xf6a), TBL_ENTRY(0xf6b),
	TBL_ENTRY(0xf6c), TBL_ENTRY(0xf6d), TBL_ENTRY(0xf6e), TBL_ENTRY(0xf6f),
	TBL_ENTRY(0xf70), TBL_ENTRY(0xf71), TBL_ENTRY(0xf72), TBL_ENTRY(0xf73),
	TBL_ENTRY(0xf74), TBL_ENTRY(0xf75), TBL_ENTRY(0xf76), TBL_ENTRY(0xf77),
	TBL_ENTRY(0xf78), TBL_ENTRY(0xf79), TBL_ENTRY(0xf7a), TBL_ENTRY(0xf7b),
	TBL_ENTRY(0xf7c), TBL_ENTRY(0xf7d), TBL_ENTRY(0xf7e), TBL_ENTRY(0xf7f),
	TBL_ENTRY(0xf80), TBL_ENTRY(0xf81), TBL_ENTRY(0xf82), TBL_ENTRY(0xf83),
	TBL_ENTRY(0xf84), TBL_ENTRY(0xf85), TBL_ENTRY(0xf86), TBL_ENTRY(0xf87),
	TBL_ENTRY(0xf88), TBL_ENTRY(0xf89), TBL_ENTRY(0xf8a), TBL_ENTRY(0xf8b),
	TBL_ENTRY(0xf8c), TBL_ENTRY(0xf8d), TBL_ENTRY(0xf8e), TBL_ENTRY(0xf8f),
	TBL_ENTRY(0xf90), TBL_ENTRY(0xf91), TBL_ENTRY(0xf92), TBL_ENTRY(0xf93),
	TBL_ENTRY(0xf94), TBL_ENTRY(0xf95), TBL_ENTRY(0xf96), TBL_ENTRY(0xf97),
	TBL_ENTRY(0xf98), TBL_ENTRY(0xf99), TBL_ENTRY(0xf9a), TBL_ENTRY(0xf9b),
	TBL_ENTRY(0xf9c), TBL_ENTRY(0xf9d), TBL_ENTRY(0xf9e), TBL_ENTRY(0xf9f),
	TBL_ENTRY(0xfa0), TBL_ENTRY(0xfa1), TBL_ENTRY(0xfa2), TBL_ENTRY(0xfa3),
	TBL_ENTRY(0xfa4), TBL_ENTRY(0xfa5), TBL_ENTRY(0xfa6), TBL_ENTRY(0xfa7),
	TBL_ENTRY(0xfa8), TBL_ENTRY(0xfa9), TBL_ENTRY(0xfaa), TBL_ENTRY(0xfab),
	TBL_ENTRY(0xfac), TBL_ENTRY(0xfad), TBL_ENTRY(0xfae), TBL_ENTRY(0xfaf),
	TBL_ENTRY(0xfb0), TBL_ENTRY(0xfb1), TBL_ENTRY(0xfb2), TBL_ENTRY(0xfb3),
	TBL_ENTRY(0xfb4), TBL_ENTRY(0xfb5), TBL_ENTRY(0xfb6), TBL_ENTRY(0xfb7),
	TBL_ENTRY(0xfb8), TBL_ENTRY(0xfb9), TBL_ENTRY(0xfba), TBL_ENTRY(0xfbb),
	TBL_ENTRY(0xfbc), TBL_ENTRY(0xfbd), TBL_ENTRY(0xfbe), TBL_ENTRY(0xfbf),
	TBL_ENTRY(0xfc0), TBL_ENTRY(0xfc1), TBL_ENTRY(0xfc2), TBL_ENTRY(0xfc3),
	TBL_ENTRY(0xfc4), TBL_ENTRY(0xfc5), TBL_ENTRY(0xfc6), TBL_ENTRY(0xfc7),
	TBL_ENTRY(0xfc8), TBL_ENTRY(0xfc9), TBL_ENTRY(0xfca), TBL_ENTRY(0xfcb),
	TBL_ENTRY(0xfcc), TBL_ENTRY(0xfcd), TBL_ENTRY(0xfce), TBL_ENTRY(0xfcf),
	TBL_ENTRY(0xfd0), TBL_ENTRY(0xfd1), TBL_ENTRY(0xfd2), TBL_ENTRY(0xfd3),
	TBL_ENTRY(0xfd4), TBL_ENTRY(0xfd5), TBL_ENTRY(0xfd6), TBL_ENTRY(0xfd7),
	TBL_ENTRY(0xfd8), TBL_ENTRY(0xfd9), TBL_ENTRY(0xfda), TBL_ENTRY(0xfdb),
	TBL_ENTRY(0xfdc), TBL_ENTRY(0xfdd), TBL_ENTRY(0xfde), TBL_ENTRY(0xfdf),
	TBL_ENTRY(0xfe0), TBL_ENTRY(0xfe1), TBL_ENTRY(0xfe2), TBL_ENTRY(0xfe3),
	TBL_ENTRY(0xfe4), TBL_ENTRY(0xfe5), TBL_ENTRY(0xfe6), TBL_ENTRY(0xfe7),
	TBL_ENTRY(0xfe8), TBL_ENTRY(0xfe9), TBL_ENTRY(0xfea), TBL_ENTRY(0xfeb),
	TBL_ENTRY(0xfec), TBL_ENTRY(0xfed), TBL_ENTRY(0xfee), TBL_ENTRY(0xfef),
	TBL_ENTRY(0xff0), TBL_ENTRY(0xff1), TBL_ENTRY(0xff2), TBL_ENTRY(0xff3),
	TBL_ENTRY(0xff4), TBL_ENTRY(0xff5), TBL_ENTRY(0xff6), TBL_ENTRY(0xff7),
	TBL_ENTRY(0xff8), TBL_ENTRY(0xff9), TBL_ENTRY(0xffa), TBL_ENTRY(0xffb),
	TBL_ENTRY(0xffc), TBL_ENTRY(0xffd), TBL_ENTRY(0xffe), TBL_ENTRY(0xfff),
};
