/* EDIT WITH CARE.
 * Many sections of this file were automatically generated.
 */

/* packet-sysdig-event.c
 * Routines for Sysdig event dissection
 * http://www.sysdig.org/
 * Copyright 2015, Gerald Combs <gerald@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

/*
 * Sysdig is a tool that captures and analyzes system state.
 * This dissects pcap-ng Sysdig Event Blocks (0x00000204), which contains
 * a system call entry or exit along with its associated parameters.
 */

/*
 * To do:
 * - Event with flags (0x00000208).
 * - Enter/exit delay.
 * - Most of this could be automatically generated from the Sysdig sources.
 *   - Alternatively we could modify Sysdig to dump its internal tables and
 *     generate a dissector from that output.
 * - Generate the column info table.
 * - Pull metainformation (processes, users, etc) into hash tables.
 */

#include <config.h>

#include <epan/packet.h>
#include <epan/strutil.h>

#include <wiretap/wtap.h>
/* #include <epan/expert.h> */
/* #include <epan/prefs.h> */

/* Prototypes */
void proto_reg_handoff_sysdig_event(void);
void proto_register_sysdig_event(void);

/* Initialize the protocol and registered fields */
static int proto_sysdig_event = -1;
/* Add byte order? */
static int hf_se_cpu_id = -1;
static int hf_se_thread_id = -1;
static int hf_se_event_length = -1;
static int hf_se_event_type = -1;

static int hf_se_param_lens = -1;
static int hf_se_param_len = -1;

/* Name+type */
/* Header fields. Automatically generated by tools/generate-sysdig-event.py */
static int hf_param_ID_bytes = -1;
static int hf_param_action_uint32 = -1;
static int hf_param_addr_bytes = -1;
static int hf_param_addr_uint64 = -1;
static int hf_param_args_string = -1;
static int hf_param_argument_uint64 = -1;
static int hf_param_backlog_uint32 = -1;
static int hf_param_cgroups_bytes = -1;
static int hf_param_clockid_uint8 = -1;
static int hf_param_cmd_bytes = -1;
static int hf_param_comm_string = -1;
static int hf_param_cpu_sys_uint64 = -1;
static int hf_param_cpu_uint32 = -1;
static int hf_param_cpu_usr_uint64 = -1;
static int hf_param_cur_int64 = -1;
static int hf_param_cwd_string = -1;
static int hf_param_data_bytes = -1;
static int hf_param_dev_string = -1;
static int hf_param_dir_string = -1;
static int hf_param_dirfd_int64 = -1;
static int hf_param_domain_bytes = -1;
static int hf_param_dpid_bytes = -1;
static int hf_param_dqb_bhardlimit_uint64 = -1;
static int hf_param_dqb_bsoftlimit_uint64 = -1;
static int hf_param_dqb_btime_bytes = -1;
static int hf_param_dqb_curspace_uint64 = -1;
static int hf_param_dqb_ihardlimit_uint64 = -1;
static int hf_param_dqb_isoftlimit_uint64 = -1;
static int hf_param_dqb_itime_bytes = -1;
static int hf_param_dqi_bgrace_bytes = -1;
static int hf_param_dqi_flags_bytes = -1;
static int hf_param_dqi_igrace_bytes = -1;
static int hf_param_egid_bytes = -1;
static int hf_param_env_string = -1;
static int hf_param_euid_bytes = -1;
static int hf_param_event_data_uint64 = -1;
static int hf_param_event_type_uint32 = -1;
static int hf_param_exe_string = -1;
static int hf_param_fd1_int64 = -1;
static int hf_param_fd2_int64 = -1;
static int hf_param_fd_in_int64 = -1;
static int hf_param_fd_int64 = -1;
static int hf_param_fd_out_int64 = -1;
static int hf_param_fdlimit_int64 = -1;
static int hf_param_fdlimit_uint64 = -1;
static int hf_param_fds_bytes = -1;
static int hf_param_flags_bytes = -1;
static int hf_param_flags_uint32 = -1;
static int hf_param_gid_bytes = -1;
static int hf_param_gid_uint32 = -1;
static int hf_param_how_bytes = -1;
static int hf_param_id_string = -1;
static int hf_param_id_uint32 = -1;
static int hf_param_image_string = -1;
static int hf_param_in_fd_int64 = -1;
static int hf_param_initval_uint64 = -1;
static int hf_param_ino_uint64 = -1;
static int hf_param_interval_bytes = -1;
static int hf_param_length_uint64 = -1;
static int hf_param_linkdirfd_int64 = -1;
static int hf_param_linkpath_string = -1;
static int hf_param_mask_uint32 = -1;
static int hf_param_max_int64 = -1;
static int hf_param_maxevents_bytes = -1;
static int hf_param_mode_uint32 = -1;
static int hf_param_name_string = -1;
static int hf_param_nativeID_uint16 = -1;
static int hf_param_newcur_int64 = -1;
static int hf_param_newdir_int64 = -1;
static int hf_param_newdirfd_int64 = -1;
static int hf_param_newmax_int64 = -1;
static int hf_param_newpath_string = -1;
static int hf_param_next_bytes = -1;
static int hf_param_nsops_uint32 = -1;
static int hf_param_nstype_bytes = -1;
static int hf_param_offset_uint64 = -1;
static int hf_param_oldcur_int64 = -1;
static int hf_param_olddir_int64 = -1;
static int hf_param_olddirfd_int64 = -1;
static int hf_param_oldmax_int64 = -1;
static int hf_param_oldpath_string = -1;
static int hf_param_op_bytes = -1;
static int hf_param_operation_bytes = -1;
static int hf_param_out_fd_int64 = -1;
static int hf_param_path_string = -1;
static int hf_param_peer_uint64 = -1;
static int hf_param_pgft_maj_uint64 = -1;
static int hf_param_pgft_min_uint64 = -1;
static int hf_param_pgoffset_uint64 = -1;
static int hf_param_pid_bytes = -1;
static int hf_param_pos_uint64 = -1;
static int hf_param_prot_bytes = -1;
static int hf_param_proto_uint32 = -1;
static int hf_param_ptid_bytes = -1;
static int hf_param_queuelen_uint32 = -1;
static int hf_param_queuemax_uint32 = -1;
static int hf_param_queuepct_uint8 = -1;
static int hf_param_quota_fmt_bytes = -1;
static int hf_param_quota_fmt_out_bytes = -1;
static int hf_param_quotafilepath_string = -1;
static int hf_param_ratio_uint32 = -1;
static int hf_param_request_bytes = -1;
static int hf_param_request_uint64 = -1;
static int hf_param_res_bytes = -1;
static int hf_param_res_int64 = -1;
static int hf_param_res_uint64 = -1;
static int hf_param_resource_bytes = -1;
static int hf_param_rgid_bytes = -1;
static int hf_param_ruid_bytes = -1;
static int hf_param_sem_flg_0_bytes = -1;
static int hf_param_sem_flg_1_bytes = -1;
static int hf_param_sem_num_0_uint16 = -1;
static int hf_param_sem_num_1_uint16 = -1;
static int hf_param_sem_op_0_int16 = -1;
static int hf_param_sem_op_1_int16 = -1;
static int hf_param_semid_int32 = -1;
static int hf_param_semnum_int32 = -1;
static int hf_param_sgid_bytes = -1;
static int hf_param_sig_bytes = -1;
static int hf_param_sigmask_bytes = -1;
static int hf_param_size_uint32 = -1;
static int hf_param_size_uint64 = -1;
static int hf_param_source_uint64 = -1;
static int hf_param_special_string = -1;
static int hf_param_spid_bytes = -1;
static int hf_param_status_bytes = -1;
static int hf_param_suid_bytes = -1;
static int hf_param_target_string = -1;
static int hf_param_tid_bytes = -1;
static int hf_param_timeout_bytes = -1;
static int hf_param_timeout_int64 = -1;
static int hf_param_tuple_bytes = -1;
static int hf_param_type_bytes = -1;
static int hf_param_type_string = -1;
static int hf_param_type_uint32 = -1;
static int hf_param_uid_bytes = -1;
static int hf_param_uid_uint32 = -1;
static int hf_param_val_int32 = -1;
static int hf_param_val_uint64 = -1;
static int hf_param_vm_rss_uint32 = -1;
static int hf_param_vm_size_uint32 = -1;
static int hf_param_vm_swap_uint32 = -1;
static int hf_param_vpid_bytes = -1;
static int hf_param_vtid_bytes = -1;
static int hf_param_whence_bytes = -1;

/* Initialize the subtree pointers */
static gint ett_sysdig_event = -1;
static gint ett_sysdig_parm_lens = -1;
static gint ett_sysdig_syscall = -1;

#define SYSDIG_EVENT_MIN_LENGTH 8 /* XXX Fix */

/* Event names. Automatically generated by tools/generate-sysdig-event.py */
#define EVT_STR_NA1                      "NA1"
#define EVT_STR_NA2                      "NA2"
#define EVT_STR_ACCEPT                   "accept"
#define EVT_STR_BIND                     "bind"
#define EVT_STR_BRK                      "brk"
#define EVT_STR_CHDIR                    "chdir"
#define EVT_STR_CLONE                    "clone"
#define EVT_STR_CLOSE                    "close"
#define EVT_STR_CONNECT                  "connect"
#define EVT_STR_CONTAINER                "container"
#define EVT_STR_CPU_HOTPLUG              "cpu_hotplug"
#define EVT_STR_CREAT                    "creat"
#define EVT_STR_DROP                     "drop"
#define EVT_STR_DUP                      "dup"
#define EVT_STR_EPOLL_WAIT               "epoll_wait"
#define EVT_STR_EVENTFD                  "eventfd"
#define EVT_STR_EXECVE                   "execve"
#define EVT_STR_FCHDIR                   "fchdir"
#define EVT_STR_FCNTL                    "fcntl"
#define EVT_STR_FLOCK                    "flock"
#define EVT_STR_FORK                     "fork"
#define EVT_STR_FSTAT                    "fstat"
#define EVT_STR_FSTAT64                  "fstat64"
#define EVT_STR_FUTEX                    "futex"
#define EVT_STR_GETCWD                   "getcwd"
#define EVT_STR_GETDENTS                 "getdents"
#define EVT_STR_GETDENTS64               "getdents64"
#define EVT_STR_GETEGID                  "getegid"
#define EVT_STR_GETEUID                  "geteuid"
#define EVT_STR_GETGID                   "getgid"
#define EVT_STR_GETPEERNAME              "getpeername"
#define EVT_STR_GETRESGID                "getresgid"
#define EVT_STR_GETRESUID                "getresuid"
#define EVT_STR_GETRLIMIT                "getrlimit"
#define EVT_STR_GETSOCKNAME              "getsockname"
#define EVT_STR_GETSOCKOPT               "getsockopt"
#define EVT_STR_GETUID                   "getuid"
#define EVT_STR_INOTIFY_INIT             "inotify_init"
#define EVT_STR_IOCTL                    "ioctl"
#define EVT_STR_KILL                     "kill"
#define EVT_STR_LINK                     "link"
#define EVT_STR_LINKAT                   "linkat"
#define EVT_STR_LISTEN                   "listen"
#define EVT_STR_LLSEEK                   "llseek"
#define EVT_STR_LSEEK                    "lseek"
#define EVT_STR_LSTAT                    "lstat"
#define EVT_STR_LSTAT64                  "lstat64"
#define EVT_STR_MKDIR                    "mkdir"
#define EVT_STR_MMAP                     "mmap"
#define EVT_STR_MMAP2                    "mmap2"
#define EVT_STR_MOUNT                    "mount"
#define EVT_STR_MUNMAP                   "munmap"
#define EVT_STR_NANOSLEEP                "nanosleep"
#define EVT_STR_OPEN                     "open"
#define EVT_STR_OPENAT                   "openat"
#define EVT_STR_PIPE                     "pipe"
#define EVT_STR_POLL                     "poll"
#define EVT_STR_PPOLL                    "ppoll"
#define EVT_STR_PREAD                    "pread"
#define EVT_STR_PREADV                   "preadv"
#define EVT_STR_PRLIMIT                  "prlimit"
#define EVT_STR_PROCEXIT                 "procexit"
#define EVT_STR_PROCINFO                 "procinfo"
#define EVT_STR_PTRACE                   "ptrace"
#define EVT_STR_PWRITE                   "pwrite"
#define EVT_STR_PWRITEV                  "pwritev"
#define EVT_STR_QUOTACTL                 "quotactl"
#define EVT_STR_READ                     "read"
#define EVT_STR_READV                    "readv"
#define EVT_STR_RECV                     "recv"
#define EVT_STR_RECVFROM                 "recvfrom"
#define EVT_STR_RECVMMSG                 "recvmmsg"
#define EVT_STR_RECVMSG                  "recvmsg"
#define EVT_STR_RENAME                   "rename"
#define EVT_STR_RENAMEAT                 "renameat"
#define EVT_STR_RMDIR                    "rmdir"
#define EVT_STR_SELECT                   "select"
#define EVT_STR_SEMCTL                   "semctl"
#define EVT_STR_SEMOP                    "semop"
#define EVT_STR_SEND                     "send"
#define EVT_STR_SENDFILE                 "sendfile"
#define EVT_STR_SENDMMSG                 "sendmmsg"
#define EVT_STR_SENDMSG                  "sendmsg"
#define EVT_STR_SENDTO                   "sendto"
#define EVT_STR_SETGID                   "setgid"
#define EVT_STR_SETNS                    "setns"
#define EVT_STR_SETRESGID                "setresgid"
#define EVT_STR_SETRESUID                "setresuid"
#define EVT_STR_SETRLIMIT                "setrlimit"
#define EVT_STR_SETSOCKOPT               "setsockopt"
#define EVT_STR_SETUID                   "setuid"
#define EVT_STR_SHUTDOWN                 "shutdown"
#define EVT_STR_SIGNALDELIVER            "signaldeliver"
#define EVT_STR_SIGNALFD                 "signalfd"
#define EVT_STR_SOCKET                   "socket"
#define EVT_STR_SOCKETPAIR               "socketpair"
#define EVT_STR_SPLICE                   "splice"
#define EVT_STR_STAT                     "stat"
#define EVT_STR_STAT64                   "stat64"
#define EVT_STR_SWITCH                   "switch"
#define EVT_STR_SYMLINK                  "symlink"
#define EVT_STR_SYMLINKAT                "symlinkat"
#define EVT_STR_SYSCALL                  "syscall"
#define EVT_STR_SYSDIGEVENT              "sysdigevent"
#define EVT_STR_TGKILL                   "tgkill"
#define EVT_STR_TIMERFD_CREATE           "timerfd_create"
#define EVT_STR_TKILL                    "tkill"
#define EVT_STR_UMOUNT                   "umount"
#define EVT_STR_UNLINK                   "unlink"
#define EVT_STR_UNLINKAT                 "unlinkat"
#define EVT_STR_VFORK                    "vfork"
#define EVT_STR_WRITE                    "write"
#define EVT_STR_WRITEV                   "writev"

/* EVT_... = PPME_... */
/* Event definitions. Automatically generated by tools/generate-sysdig-event.py */
#define EVT_GENERIC_E                  0
#define EVT_GENERIC_X                  1
#define EVT_SYSCALL_OPEN_E             2
#define EVT_SYSCALL_OPEN_X             3
#define EVT_SYSCALL_CLOSE_E            4
#define EVT_SYSCALL_CLOSE_X            5
#define EVT_SYSCALL_READ_E             6
#define EVT_SYSCALL_READ_X             7
#define EVT_SYSCALL_WRITE_E            8
#define EVT_SYSCALL_WRITE_X            9
#define EVT_SYSCALL_BRK_1_E           10
#define EVT_SYSCALL_BRK_1_X           11
#define EVT_SYSCALL_EXECVE_8_E        12
#define EVT_SYSCALL_EXECVE_8_X        13
#define EVT_SYSCALL_CLONE_11_E        14
#define EVT_SYSCALL_CLONE_11_X        15
#define EVT_PROCEXIT_E                16
#define EVT_PROCEXIT_X                17
#define EVT_SOCKET_SOCKET_E           18
#define EVT_SOCKET_SOCKET_X           19
#define EVT_SOCKET_BIND_E             20
#define EVT_SOCKET_BIND_X             21
#define EVT_SOCKET_CONNECT_E          22
#define EVT_SOCKET_CONNECT_X          23
#define EVT_SOCKET_LISTEN_E           24
#define EVT_SOCKET_LISTEN_X           25
#define EVT_SOCKET_ACCEPT_E           26
#define EVT_SOCKET_ACCEPT_X           27
#define EVT_SOCKET_SEND_E             28
#define EVT_SOCKET_SEND_X             29
#define EVT_SOCKET_SENDTO_E           30
#define EVT_SOCKET_SENDTO_X           31
#define EVT_SOCKET_RECV_E             32
#define EVT_SOCKET_RECV_X             33
#define EVT_SOCKET_RECVFROM_E         34
#define EVT_SOCKET_RECVFROM_X         35
#define EVT_SOCKET_SHUTDOWN_E         36
#define EVT_SOCKET_SHUTDOWN_X         37
#define EVT_SOCKET_GETSOCKNAME_E      38
#define EVT_SOCKET_GETSOCKNAME_X      39
#define EVT_SOCKET_GETPEERNAME_E      40
#define EVT_SOCKET_GETPEERNAME_X      41
#define EVT_SOCKET_SOCKETPAIR_E       42
#define EVT_SOCKET_SOCKETPAIR_X       43
#define EVT_SOCKET_SETSOCKOPT_E       44
#define EVT_SOCKET_SETSOCKOPT_X       45
#define EVT_SOCKET_GETSOCKOPT_E       46
#define EVT_SOCKET_GETSOCKOPT_X       47
#define EVT_SOCKET_SENDMSG_E          48
#define EVT_SOCKET_SENDMSG_X          49
#define EVT_SOCKET_SENDMMSG_E         50
#define EVT_SOCKET_SENDMMSG_X         51
#define EVT_SOCKET_RECVMSG_E          52
#define EVT_SOCKET_RECVMSG_X          53
#define EVT_SOCKET_RECVMMSG_E         54
#define EVT_SOCKET_RECVMMSG_X         55
#define EVT_SOCKET_ACCEPT4_E          56
#define EVT_SOCKET_ACCEPT4_X          57
#define EVT_SYSCALL_CREAT_E           58
#define EVT_SYSCALL_CREAT_X           59
#define EVT_SYSCALL_PIPE_E            60
#define EVT_SYSCALL_PIPE_X            61
#define EVT_SYSCALL_EVENTFD_E         62
#define EVT_SYSCALL_EVENTFD_X         63
#define EVT_SYSCALL_FUTEX_E           64
#define EVT_SYSCALL_FUTEX_X           65
#define EVT_SYSCALL_STAT_E            66
#define EVT_SYSCALL_STAT_X            67
#define EVT_SYSCALL_LSTAT_E           68
#define EVT_SYSCALL_LSTAT_X           69
#define EVT_SYSCALL_FSTAT_E           70
#define EVT_SYSCALL_FSTAT_X           71
#define EVT_SYSCALL_STAT64_E          72
#define EVT_SYSCALL_STAT64_X          73
#define EVT_SYSCALL_LSTAT64_E         74
#define EVT_SYSCALL_LSTAT64_X         75
#define EVT_SYSCALL_FSTAT64_E         76
#define EVT_SYSCALL_FSTAT64_X         77
#define EVT_SYSCALL_EPOLLWAIT_E       78
#define EVT_SYSCALL_EPOLLWAIT_X       79
#define EVT_SYSCALL_POLL_E            80
#define EVT_SYSCALL_POLL_X            81
#define EVT_SYSCALL_SELECT_E          82
#define EVT_SYSCALL_SELECT_X          83
#define EVT_SYSCALL_NEWSELECT_E       84
#define EVT_SYSCALL_NEWSELECT_X       85
#define EVT_SYSCALL_LSEEK_E           86
#define EVT_SYSCALL_LSEEK_X           87
#define EVT_SYSCALL_LLSEEK_E          88
#define EVT_SYSCALL_LLSEEK_X          89
#define EVT_SYSCALL_IOCTL_2_E         90
#define EVT_SYSCALL_IOCTL_2_X         91
#define EVT_SYSCALL_GETCWD_E          92
#define EVT_SYSCALL_GETCWD_X          93
#define EVT_SYSCALL_CHDIR_E           94
#define EVT_SYSCALL_CHDIR_X           95
#define EVT_SYSCALL_FCHDIR_E          96
#define EVT_SYSCALL_FCHDIR_X          97
#define EVT_SYSCALL_MKDIR_E           98
#define EVT_SYSCALL_MKDIR_X           99
#define EVT_SYSCALL_RMDIR_E          100
#define EVT_SYSCALL_RMDIR_X          101
#define EVT_SYSCALL_OPENAT_E         102
#define EVT_SYSCALL_OPENAT_X         103
#define EVT_SYSCALL_LINK_E           104
#define EVT_SYSCALL_LINK_X           105
#define EVT_SYSCALL_LINKAT_E         106
#define EVT_SYSCALL_LINKAT_X         107
#define EVT_SYSCALL_UNLINK_E         108
#define EVT_SYSCALL_UNLINK_X         109
#define EVT_SYSCALL_UNLINKAT_E       110
#define EVT_SYSCALL_UNLINKAT_X       111
#define EVT_SYSCALL_PREAD_E          112
#define EVT_SYSCALL_PREAD_X          113
#define EVT_SYSCALL_PWRITE_E         114
#define EVT_SYSCALL_PWRITE_X         115
#define EVT_SYSCALL_READV_E          116
#define EVT_SYSCALL_READV_X          117
#define EVT_SYSCALL_WRITEV_E         118
#define EVT_SYSCALL_WRITEV_X         119
#define EVT_SYSCALL_PREADV_E         120
#define EVT_SYSCALL_PREADV_X         121
#define EVT_SYSCALL_PWRITEV_E        122
#define EVT_SYSCALL_PWRITEV_X        123
#define EVT_SYSCALL_DUP_E            124
#define EVT_SYSCALL_DUP_X            125
#define EVT_SYSCALL_SIGNALFD_E       126
#define EVT_SYSCALL_SIGNALFD_X       127
#define EVT_SYSCALL_KILL_E           128
#define EVT_SYSCALL_KILL_X           129
#define EVT_SYSCALL_TKILL_E          130
#define EVT_SYSCALL_TKILL_X          131
#define EVT_SYSCALL_TGKILL_E         132
#define EVT_SYSCALL_TGKILL_X         133
#define EVT_SYSCALL_NANOSLEEP_E      134
#define EVT_SYSCALL_NANOSLEEP_X      135
#define EVT_SYSCALL_TIMERFD_CREATE_E 136
#define EVT_SYSCALL_TIMERFD_CREATE_X 137
#define EVT_SYSCALL_INOTIFY_INIT_E   138
#define EVT_SYSCALL_INOTIFY_INIT_X   139
#define EVT_SYSCALL_GETRLIMIT_E      140
#define EVT_SYSCALL_GETRLIMIT_X      141
#define EVT_SYSCALL_SETRLIMIT_E      142
#define EVT_SYSCALL_SETRLIMIT_X      143
#define EVT_SYSCALL_PRLIMIT_E        144
#define EVT_SYSCALL_PRLIMIT_X        145
#define EVT_SCHEDSWITCH_1_E          146
#define EVT_SCHEDSWITCH_1_X          147
#define EVT_DROP_E                   148
#define EVT_DROP_X                   149
#define EVT_SYSCALL_FCNTL_E          150
#define EVT_SYSCALL_FCNTL_X          151
#define EVT_SCHEDSWITCH_6_E          152
#define EVT_SCHEDSWITCH_6_X          153
#define EVT_SYSCALL_EXECVE_13_E      154
#define EVT_SYSCALL_EXECVE_13_X      155
#define EVT_SYSCALL_CLONE_16_E       156
#define EVT_SYSCALL_CLONE_16_X       157
#define EVT_SYSCALL_BRK_4_E          158
#define EVT_SYSCALL_BRK_4_X          159
#define EVT_SYSCALL_MMAP_E           160
#define EVT_SYSCALL_MMAP_X           161
#define EVT_SYSCALL_MMAP2_E          162
#define EVT_SYSCALL_MMAP2_X          163
#define EVT_SYSCALL_MUNMAP_E         164
#define EVT_SYSCALL_MUNMAP_X         165
#define EVT_SYSCALL_SPLICE_E         166
#define EVT_SYSCALL_SPLICE_X         167
#define EVT_SYSCALL_PTRACE_E         168
#define EVT_SYSCALL_PTRACE_X         169
#define EVT_SYSCALL_IOCTL_3_E        170
#define EVT_SYSCALL_IOCTL_3_X        171
#define EVT_SYSCALL_EXECVE_14_E      172
#define EVT_SYSCALL_EXECVE_14_X      173
#define EVT_SYSCALL_RENAME_E         174
#define EVT_SYSCALL_RENAME_X         175
#define EVT_SYSCALL_RENAMEAT_E       176
#define EVT_SYSCALL_RENAMEAT_X       177
#define EVT_SYSCALL_SYMLINK_E        178
#define EVT_SYSCALL_SYMLINK_X        179
#define EVT_SYSCALL_SYMLINKAT_E      180
#define EVT_SYSCALL_SYMLINKAT_X      181
#define EVT_SYSCALL_FORK_E           182
#define EVT_SYSCALL_FORK_X           183
#define EVT_SYSCALL_VFORK_E          184
#define EVT_SYSCALL_VFORK_X          185
#define EVT_PROCEXIT_1_E             186
#define EVT_PROCEXIT_1_X             187
#define EVT_SYSCALL_SENDFILE_E       188
#define EVT_SYSCALL_SENDFILE_X       189
#define EVT_SYSCALL_QUOTACTL_E       190
#define EVT_SYSCALL_QUOTACTL_X       191
#define EVT_SYSCALL_SETRESUID_E      192
#define EVT_SYSCALL_SETRESUID_X      193
#define EVT_SYSCALL_SETRESGID_E      194
#define EVT_SYSCALL_SETRESGID_X      195
#define EVT_SYSDIGEVENT_E            196
#define EVT_SYSDIGEVENT_X            197
#define EVT_SYSCALL_SETUID_E         198
#define EVT_SYSCALL_SETUID_X         199
#define EVT_SYSCALL_SETGID_E         200
#define EVT_SYSCALL_SETGID_X         201
#define EVT_SYSCALL_GETUID_E         202
#define EVT_SYSCALL_GETUID_X         203
#define EVT_SYSCALL_GETEUID_E        204
#define EVT_SYSCALL_GETEUID_X        205
#define EVT_SYSCALL_GETGID_E         206
#define EVT_SYSCALL_GETGID_X         207
#define EVT_SYSCALL_GETEGID_E        208
#define EVT_SYSCALL_GETEGID_X        209
#define EVT_SYSCALL_GETRESUID_E      210
#define EVT_SYSCALL_GETRESUID_X      211
#define EVT_SYSCALL_GETRESGID_E      212
#define EVT_SYSCALL_GETRESGID_X      213
#define EVT_SYSCALL_EXECVE_15_E      214
#define EVT_SYSCALL_EXECVE_15_X      215
#define EVT_SYSCALL_CLONE_17_E       216
#define EVT_SYSCALL_CLONE_17_X       217
#define EVT_SYSCALL_FORK_17_E        218
#define EVT_SYSCALL_FORK_17_X        219
#define EVT_SYSCALL_VFORK_17_E       220
#define EVT_SYSCALL_VFORK_17_X       221
#define EVT_SYSCALL_CLONE_20_E       222
#define EVT_SYSCALL_CLONE_20_X       223
#define EVT_SYSCALL_FORK_20_E        224
#define EVT_SYSCALL_FORK_20_X        225
#define EVT_SYSCALL_VFORK_20_E       226
#define EVT_SYSCALL_VFORK_20_X       227
#define EVT_CONTAINER_E              228
#define EVT_CONTAINER_X              229
#define EVT_SYSCALL_EXECVE_16_E      230
#define EVT_SYSCALL_EXECVE_16_X      231
#define EVT_SIGNALDELIVER_E          232
#define EVT_SIGNALDELIVER_X          233
#define EVT_PROCINFO_E               234
#define EVT_PROCINFO_X               235
#define EVT_SYSCALL_GETDENTS_E       236
#define EVT_SYSCALL_GETDENTS_X       237
#define EVT_SYSCALL_GETDENTS64_E     238
#define EVT_SYSCALL_GETDENTS64_X     239
#define EVT_SYSCALL_SETNS_E          240
#define EVT_SYSCALL_SETNS_X          241
#define EVT_SYSCALL_FLOCK_E          242
#define EVT_SYSCALL_FLOCK_X          243
#define EVT_CPU_HOTPLUG_E            244
#define EVT_CPU_HOTPLUG_X            245
#define EVT_SOCKET_ACCEPT_5_E        246
#define EVT_SOCKET_ACCEPT_5_X        247
#define EVT_SOCKET_ACCEPT4_5_E       248
#define EVT_SOCKET_ACCEPT4_5_X       249
#define EVT_SYSCALL_SEMOP_E          250
#define EVT_SYSCALL_SEMOP_X          251
#define EVT_SYSCALL_SEMCTL_E         252
#define EVT_SYSCALL_SEMCTL_X         253
#define EVT_SYSCALL_PPOLL_E          254
#define EVT_SYSCALL_PPOLL_X          255
#define EVT_SYSCALL_MOUNT_E          256
#define EVT_SYSCALL_MOUNT_X          257
#define EVT_SYSCALL_UMOUNT_E         258
#define EVT_SYSCALL_UMOUNT_X         259

static const value_string event_type_vals[] = {
/* Value strings. Automatically generated by tools/generate-sysdig-event.py */
    { EVT_GENERIC_E,                   EVT_STR_SYSCALL },
    { EVT_GENERIC_X,                   EVT_STR_SYSCALL },
    { EVT_SYSCALL_OPEN_E,              EVT_STR_OPEN },
    { EVT_SYSCALL_OPEN_X,              EVT_STR_OPEN },
    { EVT_SYSCALL_CLOSE_E,             EVT_STR_CLOSE },
    { EVT_SYSCALL_CLOSE_X,             EVT_STR_CLOSE },
    { EVT_SYSCALL_READ_E,              EVT_STR_READ },
    { EVT_SYSCALL_READ_X,              EVT_STR_READ },
    { EVT_SYSCALL_WRITE_E,             EVT_STR_WRITE },
    { EVT_SYSCALL_WRITE_X,             EVT_STR_WRITE },
    { EVT_SYSCALL_BRK_1_E,             EVT_STR_BRK },
    { EVT_SYSCALL_BRK_1_X,             EVT_STR_BRK },
    { EVT_SYSCALL_EXECVE_8_E,          EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_8_X,          EVT_STR_EXECVE },
    { EVT_SYSCALL_CLONE_11_E,          EVT_STR_CLONE },
    { EVT_SYSCALL_CLONE_11_X,          EVT_STR_CLONE },
    { EVT_PROCEXIT_E,                  EVT_STR_PROCEXIT },
    { EVT_PROCEXIT_X,                  EVT_STR_NA1 },
    { EVT_SOCKET_SOCKET_E,             EVT_STR_SOCKET },
    { EVT_SOCKET_SOCKET_X,             EVT_STR_SOCKET },
    { EVT_SOCKET_BIND_E,               EVT_STR_BIND },
    { EVT_SOCKET_BIND_X,               EVT_STR_BIND },
    { EVT_SOCKET_CONNECT_E,            EVT_STR_CONNECT },
    { EVT_SOCKET_CONNECT_X,            EVT_STR_CONNECT },
    { EVT_SOCKET_LISTEN_E,             EVT_STR_LISTEN },
    { EVT_SOCKET_LISTEN_X,             EVT_STR_LISTEN },
    { EVT_SOCKET_ACCEPT_E,             EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT_X,             EVT_STR_ACCEPT },
    { EVT_SOCKET_SEND_E,               EVT_STR_SEND },
    { EVT_SOCKET_SEND_X,               EVT_STR_SEND },
    { EVT_SOCKET_SENDTO_E,             EVT_STR_SENDTO },
    { EVT_SOCKET_SENDTO_X,             EVT_STR_SENDTO },
    { EVT_SOCKET_RECV_E,               EVT_STR_RECV },
    { EVT_SOCKET_RECV_X,               EVT_STR_RECV },
    { EVT_SOCKET_RECVFROM_E,           EVT_STR_RECVFROM },
    { EVT_SOCKET_RECVFROM_X,           EVT_STR_RECVFROM },
    { EVT_SOCKET_SHUTDOWN_E,           EVT_STR_SHUTDOWN },
    { EVT_SOCKET_SHUTDOWN_X,           EVT_STR_SHUTDOWN },
    { EVT_SOCKET_GETSOCKNAME_E,        EVT_STR_GETSOCKNAME },
    { EVT_SOCKET_GETSOCKNAME_X,        EVT_STR_GETSOCKNAME },
    { EVT_SOCKET_GETPEERNAME_E,        EVT_STR_GETPEERNAME },
    { EVT_SOCKET_GETPEERNAME_X,        EVT_STR_GETPEERNAME },
    { EVT_SOCKET_SOCKETPAIR_E,         EVT_STR_SOCKETPAIR },
    { EVT_SOCKET_SOCKETPAIR_X,         EVT_STR_SOCKETPAIR },
    { EVT_SOCKET_SETSOCKOPT_E,         EVT_STR_SETSOCKOPT },
    { EVT_SOCKET_SETSOCKOPT_X,         EVT_STR_SETSOCKOPT },
    { EVT_SOCKET_GETSOCKOPT_E,         EVT_STR_GETSOCKOPT },
    { EVT_SOCKET_GETSOCKOPT_X,         EVT_STR_GETSOCKOPT },
    { EVT_SOCKET_SENDMSG_E,            EVT_STR_SENDMSG },
    { EVT_SOCKET_SENDMSG_X,            EVT_STR_SENDMSG },
    { EVT_SOCKET_SENDMMSG_E,           EVT_STR_SENDMMSG },
    { EVT_SOCKET_SENDMMSG_X,           EVT_STR_SENDMMSG },
    { EVT_SOCKET_RECVMSG_E,            EVT_STR_RECVMSG },
    { EVT_SOCKET_RECVMSG_X,            EVT_STR_RECVMSG },
    { EVT_SOCKET_RECVMMSG_E,           EVT_STR_RECVMMSG },
    { EVT_SOCKET_RECVMMSG_X,           EVT_STR_RECVMMSG },
    { EVT_SOCKET_ACCEPT4_E,            EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT4_X,            EVT_STR_ACCEPT },
    { EVT_SYSCALL_CREAT_E,             EVT_STR_CREAT },
    { EVT_SYSCALL_CREAT_X,             EVT_STR_CREAT },
    { EVT_SYSCALL_PIPE_E,              EVT_STR_PIPE },
    { EVT_SYSCALL_PIPE_X,              EVT_STR_PIPE },
    { EVT_SYSCALL_EVENTFD_E,           EVT_STR_EVENTFD },
    { EVT_SYSCALL_EVENTFD_X,           EVT_STR_EVENTFD },
    { EVT_SYSCALL_FUTEX_E,             EVT_STR_FUTEX },
    { EVT_SYSCALL_FUTEX_X,             EVT_STR_FUTEX },
    { EVT_SYSCALL_STAT_E,              EVT_STR_STAT },
    { EVT_SYSCALL_STAT_X,              EVT_STR_STAT },
    { EVT_SYSCALL_LSTAT_E,             EVT_STR_LSTAT },
    { EVT_SYSCALL_LSTAT_X,             EVT_STR_LSTAT },
    { EVT_SYSCALL_FSTAT_E,             EVT_STR_FSTAT },
    { EVT_SYSCALL_FSTAT_X,             EVT_STR_FSTAT },
    { EVT_SYSCALL_STAT64_E,            EVT_STR_STAT64 },
    { EVT_SYSCALL_STAT64_X,            EVT_STR_STAT64 },
    { EVT_SYSCALL_LSTAT64_E,           EVT_STR_LSTAT64 },
    { EVT_SYSCALL_LSTAT64_X,           EVT_STR_LSTAT64 },
    { EVT_SYSCALL_FSTAT64_E,           EVT_STR_FSTAT64 },
    { EVT_SYSCALL_FSTAT64_X,           EVT_STR_FSTAT64 },
    { EVT_SYSCALL_EPOLLWAIT_E,         EVT_STR_EPOLL_WAIT },
    { EVT_SYSCALL_EPOLLWAIT_X,         EVT_STR_EPOLL_WAIT },
    { EVT_SYSCALL_POLL_E,              EVT_STR_POLL },
    { EVT_SYSCALL_POLL_X,              EVT_STR_POLL },
    { EVT_SYSCALL_SELECT_E,            EVT_STR_SELECT },
    { EVT_SYSCALL_SELECT_X,            EVT_STR_SELECT },
    { EVT_SYSCALL_NEWSELECT_E,         EVT_STR_SELECT },
    { EVT_SYSCALL_NEWSELECT_X,         EVT_STR_SELECT },
    { EVT_SYSCALL_LSEEK_E,             EVT_STR_LSEEK },
    { EVT_SYSCALL_LSEEK_X,             EVT_STR_LSEEK },
    { EVT_SYSCALL_LLSEEK_E,            EVT_STR_LLSEEK },
    { EVT_SYSCALL_LLSEEK_X,            EVT_STR_LLSEEK },
    { EVT_SYSCALL_IOCTL_2_E,           EVT_STR_IOCTL },
    { EVT_SYSCALL_IOCTL_2_X,           EVT_STR_IOCTL },
    { EVT_SYSCALL_GETCWD_E,            EVT_STR_GETCWD },
    { EVT_SYSCALL_GETCWD_X,            EVT_STR_GETCWD },
    { EVT_SYSCALL_CHDIR_E,             EVT_STR_CHDIR },
    { EVT_SYSCALL_CHDIR_X,             EVT_STR_CHDIR },
    { EVT_SYSCALL_FCHDIR_E,            EVT_STR_FCHDIR },
    { EVT_SYSCALL_FCHDIR_X,            EVT_STR_FCHDIR },
    { EVT_SYSCALL_MKDIR_E,             EVT_STR_MKDIR },
    { EVT_SYSCALL_MKDIR_X,             EVT_STR_MKDIR },
    { EVT_SYSCALL_RMDIR_E,             EVT_STR_RMDIR },
    { EVT_SYSCALL_RMDIR_X,             EVT_STR_RMDIR },
    { EVT_SYSCALL_OPENAT_E,            EVT_STR_OPENAT },
    { EVT_SYSCALL_OPENAT_X,            EVT_STR_OPENAT },
    { EVT_SYSCALL_LINK_E,              EVT_STR_LINK },
    { EVT_SYSCALL_LINK_X,              EVT_STR_LINK },
    { EVT_SYSCALL_LINKAT_E,            EVT_STR_LINKAT },
    { EVT_SYSCALL_LINKAT_X,            EVT_STR_LINKAT },
    { EVT_SYSCALL_UNLINK_E,            EVT_STR_UNLINK },
    { EVT_SYSCALL_UNLINK_X,            EVT_STR_UNLINK },
    { EVT_SYSCALL_UNLINKAT_E,          EVT_STR_UNLINKAT },
    { EVT_SYSCALL_UNLINKAT_X,          EVT_STR_UNLINKAT },
    { EVT_SYSCALL_PREAD_E,             EVT_STR_PREAD },
    { EVT_SYSCALL_PREAD_X,             EVT_STR_PREAD },
    { EVT_SYSCALL_PWRITE_E,            EVT_STR_PWRITE },
    { EVT_SYSCALL_PWRITE_X,            EVT_STR_PWRITE },
    { EVT_SYSCALL_READV_E,             EVT_STR_READV },
    { EVT_SYSCALL_READV_X,             EVT_STR_READV },
    { EVT_SYSCALL_WRITEV_E,            EVT_STR_WRITEV },
    { EVT_SYSCALL_WRITEV_X,            EVT_STR_WRITEV },
    { EVT_SYSCALL_PREADV_E,            EVT_STR_PREADV },
    { EVT_SYSCALL_PREADV_X,            EVT_STR_PREADV },
    { EVT_SYSCALL_PWRITEV_E,           EVT_STR_PWRITEV },
    { EVT_SYSCALL_PWRITEV_X,           EVT_STR_PWRITEV },
    { EVT_SYSCALL_DUP_E,               EVT_STR_DUP },
    { EVT_SYSCALL_DUP_X,               EVT_STR_DUP },
    { EVT_SYSCALL_SIGNALFD_E,          EVT_STR_SIGNALFD },
    { EVT_SYSCALL_SIGNALFD_X,          EVT_STR_SIGNALFD },
    { EVT_SYSCALL_KILL_E,              EVT_STR_KILL },
    { EVT_SYSCALL_KILL_X,              EVT_STR_KILL },
    { EVT_SYSCALL_TKILL_E,             EVT_STR_TKILL },
    { EVT_SYSCALL_TKILL_X,             EVT_STR_TKILL },
    { EVT_SYSCALL_TGKILL_E,            EVT_STR_TGKILL },
    { EVT_SYSCALL_TGKILL_X,            EVT_STR_TGKILL },
    { EVT_SYSCALL_NANOSLEEP_E,         EVT_STR_NANOSLEEP },
    { EVT_SYSCALL_NANOSLEEP_X,         EVT_STR_NANOSLEEP },
    { EVT_SYSCALL_TIMERFD_CREATE_E,    EVT_STR_TIMERFD_CREATE },
    { EVT_SYSCALL_TIMERFD_CREATE_X,    EVT_STR_TIMERFD_CREATE },
    { EVT_SYSCALL_INOTIFY_INIT_E,      EVT_STR_INOTIFY_INIT },
    { EVT_SYSCALL_INOTIFY_INIT_X,      EVT_STR_INOTIFY_INIT },
    { EVT_SYSCALL_GETRLIMIT_E,         EVT_STR_GETRLIMIT },
    { EVT_SYSCALL_GETRLIMIT_X,         EVT_STR_GETRLIMIT },
    { EVT_SYSCALL_SETRLIMIT_E,         EVT_STR_SETRLIMIT },
    { EVT_SYSCALL_SETRLIMIT_X,         EVT_STR_SETRLIMIT },
    { EVT_SYSCALL_PRLIMIT_E,           EVT_STR_PRLIMIT },
    { EVT_SYSCALL_PRLIMIT_X,           EVT_STR_PRLIMIT },
    { EVT_SCHEDSWITCH_1_E,             EVT_STR_SWITCH },
    { EVT_SCHEDSWITCH_1_X,             EVT_STR_NA2 },
    { EVT_DROP_E,                      EVT_STR_DROP },
    { EVT_DROP_X,                      EVT_STR_DROP },
    { EVT_SYSCALL_FCNTL_E,             EVT_STR_FCNTL },
    { EVT_SYSCALL_FCNTL_X,             EVT_STR_FCNTL },
    { EVT_SCHEDSWITCH_6_E,             EVT_STR_SWITCH },
    { EVT_SCHEDSWITCH_6_X,             EVT_STR_NA2 },
    { EVT_SYSCALL_EXECVE_13_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_13_X,         EVT_STR_EXECVE },
    { EVT_SYSCALL_CLONE_16_E,          EVT_STR_CLONE },
    { EVT_SYSCALL_CLONE_16_X,          EVT_STR_CLONE },
    { EVT_SYSCALL_BRK_4_E,             EVT_STR_BRK },
    { EVT_SYSCALL_BRK_4_X,             EVT_STR_BRK },
    { EVT_SYSCALL_MMAP_E,              EVT_STR_MMAP },
    { EVT_SYSCALL_MMAP_X,              EVT_STR_MMAP },
    { EVT_SYSCALL_MMAP2_E,             EVT_STR_MMAP2 },
    { EVT_SYSCALL_MMAP2_X,             EVT_STR_MMAP2 },
    { EVT_SYSCALL_MUNMAP_E,            EVT_STR_MUNMAP },
    { EVT_SYSCALL_MUNMAP_X,            EVT_STR_MUNMAP },
    { EVT_SYSCALL_SPLICE_E,            EVT_STR_SPLICE },
    { EVT_SYSCALL_SPLICE_X,            EVT_STR_SPLICE },
    { EVT_SYSCALL_PTRACE_E,            EVT_STR_PTRACE },
    { EVT_SYSCALL_PTRACE_X,            EVT_STR_PTRACE },
    { EVT_SYSCALL_IOCTL_3_E,           EVT_STR_IOCTL },
    { EVT_SYSCALL_IOCTL_3_X,           EVT_STR_IOCTL },
    { EVT_SYSCALL_EXECVE_14_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_14_X,         EVT_STR_EXECVE },
    { EVT_SYSCALL_RENAME_E,            EVT_STR_RENAME },
    { EVT_SYSCALL_RENAME_X,            EVT_STR_RENAME },
    { EVT_SYSCALL_RENAMEAT_E,          EVT_STR_RENAMEAT },
    { EVT_SYSCALL_RENAMEAT_X,          EVT_STR_RENAMEAT },
    { EVT_SYSCALL_SYMLINK_E,           EVT_STR_SYMLINK },
    { EVT_SYSCALL_SYMLINK_X,           EVT_STR_SYMLINK },
    { EVT_SYSCALL_SYMLINKAT_E,         EVT_STR_SYMLINKAT },
    { EVT_SYSCALL_SYMLINKAT_X,         EVT_STR_SYMLINKAT },
    { EVT_SYSCALL_FORK_E,              EVT_STR_FORK },
    { EVT_SYSCALL_FORK_X,              EVT_STR_FORK },
    { EVT_SYSCALL_VFORK_E,             EVT_STR_VFORK },
    { EVT_SYSCALL_VFORK_X,             EVT_STR_VFORK },
    { EVT_PROCEXIT_1_E,                EVT_STR_PROCEXIT },
    { EVT_PROCEXIT_1_X,                EVT_STR_NA1 },
    { EVT_SYSCALL_SENDFILE_E,          EVT_STR_SENDFILE },
    { EVT_SYSCALL_SENDFILE_X,          EVT_STR_SENDFILE },
    { EVT_SYSCALL_QUOTACTL_E,          EVT_STR_QUOTACTL },
    { EVT_SYSCALL_QUOTACTL_X,          EVT_STR_QUOTACTL },
    { EVT_SYSCALL_SETRESUID_E,         EVT_STR_SETRESUID },
    { EVT_SYSCALL_SETRESUID_X,         EVT_STR_SETRESUID },
    { EVT_SYSCALL_SETRESGID_E,         EVT_STR_SETRESGID },
    { EVT_SYSCALL_SETRESGID_X,         EVT_STR_SETRESGID },
    { EVT_SYSDIGEVENT_E,               EVT_STR_SYSDIGEVENT },
    { EVT_SYSDIGEVENT_X,               EVT_STR_SYSDIGEVENT },
    { EVT_SYSCALL_SETUID_E,            EVT_STR_SETUID },
    { EVT_SYSCALL_SETUID_X,            EVT_STR_SETUID },
    { EVT_SYSCALL_SETGID_E,            EVT_STR_SETGID },
    { EVT_SYSCALL_SETGID_X,            EVT_STR_SETGID },
    { EVT_SYSCALL_GETUID_E,            EVT_STR_GETUID },
    { EVT_SYSCALL_GETUID_X,            EVT_STR_GETUID },
    { EVT_SYSCALL_GETEUID_E,           EVT_STR_GETEUID },
    { EVT_SYSCALL_GETEUID_X,           EVT_STR_GETEUID },
    { EVT_SYSCALL_GETGID_E,            EVT_STR_GETGID },
    { EVT_SYSCALL_GETGID_X,            EVT_STR_GETGID },
    { EVT_SYSCALL_GETEGID_E,           EVT_STR_GETEGID },
    { EVT_SYSCALL_GETEGID_X,           EVT_STR_GETEGID },
    { EVT_SYSCALL_GETRESUID_E,         EVT_STR_GETRESUID },
    { EVT_SYSCALL_GETRESUID_X,         EVT_STR_GETRESUID },
    { EVT_SYSCALL_GETRESGID_E,         EVT_STR_GETRESGID },
    { EVT_SYSCALL_GETRESGID_X,         EVT_STR_GETRESGID },
    { EVT_SYSCALL_EXECVE_15_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_15_X,         EVT_STR_EXECVE },
    { EVT_SYSCALL_CLONE_17_E,          EVT_STR_CLONE },
    { EVT_SYSCALL_CLONE_17_X,          EVT_STR_CLONE },
    { EVT_SYSCALL_FORK_17_E,           EVT_STR_FORK },
    { EVT_SYSCALL_FORK_17_X,           EVT_STR_FORK },
    { EVT_SYSCALL_VFORK_17_E,          EVT_STR_VFORK },
    { EVT_SYSCALL_VFORK_17_X,          EVT_STR_VFORK },
    { EVT_SYSCALL_CLONE_20_E,          EVT_STR_CLONE },
    { EVT_SYSCALL_CLONE_20_X,          EVT_STR_CLONE },
    { EVT_SYSCALL_FORK_20_E,           EVT_STR_FORK },
    { EVT_SYSCALL_FORK_20_X,           EVT_STR_FORK },
    { EVT_SYSCALL_VFORK_20_E,          EVT_STR_VFORK },
    { EVT_SYSCALL_VFORK_20_X,          EVT_STR_VFORK },
    { EVT_CONTAINER_E,                 EVT_STR_CONTAINER },
    { EVT_CONTAINER_X,                 EVT_STR_CONTAINER },
    { EVT_SYSCALL_EXECVE_16_E,         EVT_STR_EXECVE },
    { EVT_SYSCALL_EXECVE_16_X,         EVT_STR_EXECVE },
    { EVT_SIGNALDELIVER_E,             EVT_STR_SIGNALDELIVER },
    { EVT_SIGNALDELIVER_X,             EVT_STR_SIGNALDELIVER },
    { EVT_PROCINFO_E,                  EVT_STR_PROCINFO },
    { EVT_PROCINFO_X,                  EVT_STR_NA2 },
    { EVT_SYSCALL_GETDENTS_E,          EVT_STR_GETDENTS },
    { EVT_SYSCALL_GETDENTS_X,          EVT_STR_GETDENTS },
    { EVT_SYSCALL_GETDENTS64_E,        EVT_STR_GETDENTS64 },
    { EVT_SYSCALL_GETDENTS64_X,        EVT_STR_GETDENTS64 },
    { EVT_SYSCALL_SETNS_E,             EVT_STR_SETNS },
    { EVT_SYSCALL_SETNS_X,             EVT_STR_SETNS },
    { EVT_SYSCALL_FLOCK_E,             EVT_STR_FLOCK },
    { EVT_SYSCALL_FLOCK_X,             EVT_STR_FLOCK },
    { EVT_CPU_HOTPLUG_E,               EVT_STR_CPU_HOTPLUG },
    { EVT_CPU_HOTPLUG_X,               EVT_STR_NA2 },
    { EVT_SOCKET_ACCEPT_5_E,           EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT_5_X,           EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT4_5_E,          EVT_STR_ACCEPT },
    { EVT_SOCKET_ACCEPT4_5_X,          EVT_STR_ACCEPT },
    { EVT_SYSCALL_SEMOP_E,             EVT_STR_SEMOP },
    { EVT_SYSCALL_SEMOP_X,             EVT_STR_SEMOP },
    { EVT_SYSCALL_SEMCTL_E,            EVT_STR_SEMCTL },
    { EVT_SYSCALL_SEMCTL_X,            EVT_STR_SEMCTL },
    { EVT_SYSCALL_PPOLL_E,             EVT_STR_PPOLL },
    { EVT_SYSCALL_PPOLL_X,             EVT_STR_PPOLL },
    { EVT_SYSCALL_MOUNT_E,             EVT_STR_MOUNT },
    { EVT_SYSCALL_MOUNT_X,             EVT_STR_MOUNT },
    { EVT_SYSCALL_UMOUNT_E,            EVT_STR_UMOUNT },
    { EVT_SYSCALL_UMOUNT_X,            EVT_STR_UMOUNT },

    {0, NULL }
};

/*
 * "Interesting" parameters, which are appended to COL_INFO.
 * Manually generated for now.
 */
struct _event_col_info_param {
    const int param_num;
    const char *param_name;
    enum ftenum param_ftype;
};

static const struct _event_col_info_param open_x_params[] = {
    { 0, "fd", FT_UINT64 },
    { 1, "name", FT_STRING },
    { 0, NULL, FT_NONE }
};

static const struct _event_col_info_param close_e_params[] = {
    { 0, "fd", FT_UINT64 },
    { 0, NULL, FT_NONE }
};

static const struct _event_col_info_param read_e_params[] = {
    { 0, "fd", FT_UINT64 },
    { 0, NULL, FT_NONE }
};

static const struct _event_col_info_param write_e_params[] = {
    { 0, "fd", FT_UINT64 },
    { 0, NULL, FT_NONE }
};

static const struct _event_col_info_param execve_15_x_params[] = {
    { 1, "exe", FT_STRING },
    { 2, "args", FT_STRING },
    { 0, NULL, FT_NONE }
};

struct _event_col_info {
    const guint event_type;
    const int num_len_fields;
    const struct _event_col_info_param *params;
};

/* Info column parameters */
static const struct _event_col_info event_col_info[] = {
    { EVT_SYSCALL_OPEN_X, 4,  open_x_params },
    { EVT_SYSCALL_CLOSE_E, 1,  close_e_params },
    { EVT_SYSCALL_READ_E, 2,  read_e_params },
    { EVT_SYSCALL_WRITE_E, 2,  write_e_params },
    { EVT_SYSCALL_EXECVE_15_X, 15,  execve_15_x_params },
    { 0, 0, NULL }
};

struct _event_tree_info {
    const guint event_type;
    /* int num_params; */
    const int **hf_indexes;
};

static const int *no_indexes[] = { NULL };

/* Parameter indexes. Automatically generated by tools/generate-sysdig-event.py */
static const int *generic_e_indexes[] = { &hf_param_ID_bytes, &hf_param_nativeID_uint16, NULL };
static const int *generic_x_indexes[] = { &hf_param_ID_bytes, NULL };
#define syscall_open_e_indexes no_indexes
static const int *syscall_open_x_indexes[] = { &hf_param_fd_int64, &hf_param_name_string, &hf_param_flags_bytes, &hf_param_mode_uint32, NULL };
static const int *syscall_close_e_indexes[] = { &hf_param_fd_int64, NULL };
static const int *syscall_close_x_indexes[] = { &hf_param_res_bytes, NULL };
static const int *syscall_read_e_indexes[] = { &hf_param_fd_int64, &hf_param_size_uint32, NULL };
static const int *syscall_read_x_indexes[] = { &hf_param_res_bytes, &hf_param_data_bytes, NULL };
#define syscall_write_e_indexes syscall_read_e_indexes
#define syscall_write_x_indexes syscall_read_x_indexes
static const int *syscall_brk_1_e_indexes[] = { &hf_param_size_uint32, NULL };
static const int *syscall_brk_1_x_indexes[] = { &hf_param_res_uint64, NULL };
#define syscall_execve_8_e_indexes no_indexes
static const int *syscall_execve_8_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_uint64, NULL };
#define syscall_clone_11_e_indexes no_indexes
static const int *syscall_clone_11_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_int64, &hf_param_flags_bytes, &hf_param_uid_uint32, &hf_param_gid_uint32, NULL };
#define procexit_e_indexes no_indexes
#define procexit_x_indexes no_indexes
static const int *socket_socket_e_indexes[] = { &hf_param_domain_bytes, &hf_param_type_uint32, &hf_param_proto_uint32, NULL };
#define socket_socket_x_indexes syscall_close_e_indexes
#define socket_bind_e_indexes syscall_close_e_indexes
static const int *socket_bind_x_indexes[] = { &hf_param_res_bytes, &hf_param_addr_bytes, NULL };
#define socket_connect_e_indexes syscall_close_e_indexes
static const int *socket_connect_x_indexes[] = { &hf_param_res_bytes, &hf_param_tuple_bytes, NULL };
static const int *socket_listen_e_indexes[] = { &hf_param_fd_int64, &hf_param_backlog_uint32, NULL };
#define socket_listen_x_indexes syscall_close_x_indexes
#define socket_accept_e_indexes no_indexes
static const int *socket_accept_x_indexes[] = { &hf_param_fd_int64, &hf_param_tuple_bytes, &hf_param_queuepct_uint8, NULL };
#define socket_send_e_indexes syscall_read_e_indexes
#define socket_send_x_indexes syscall_read_x_indexes
static const int *socket_sendto_e_indexes[] = { &hf_param_fd_int64, &hf_param_size_uint32, &hf_param_tuple_bytes, NULL };
#define socket_sendto_x_indexes syscall_read_x_indexes
#define socket_recv_e_indexes syscall_read_e_indexes
#define socket_recv_x_indexes syscall_read_x_indexes
#define socket_recvfrom_e_indexes syscall_read_e_indexes
static const int *socket_recvfrom_x_indexes[] = { &hf_param_res_bytes, &hf_param_data_bytes, &hf_param_tuple_bytes, NULL };
static const int *socket_shutdown_e_indexes[] = { &hf_param_fd_int64, &hf_param_how_bytes, NULL };
#define socket_shutdown_x_indexes syscall_close_x_indexes
#define socket_getsockname_e_indexes no_indexes
#define socket_getsockname_x_indexes no_indexes
#define socket_getpeername_e_indexes no_indexes
#define socket_getpeername_x_indexes no_indexes
#define socket_socketpair_e_indexes socket_socket_e_indexes
static const int *socket_socketpair_x_indexes[] = { &hf_param_res_bytes, &hf_param_fd1_int64, &hf_param_fd2_int64, &hf_param_source_uint64, &hf_param_peer_uint64, NULL };
#define socket_setsockopt_e_indexes no_indexes
#define socket_setsockopt_x_indexes no_indexes
#define socket_getsockopt_e_indexes no_indexes
#define socket_getsockopt_x_indexes no_indexes
#define socket_sendmsg_e_indexes socket_sendto_e_indexes
#define socket_sendmsg_x_indexes syscall_read_x_indexes
#define socket_sendmmsg_e_indexes no_indexes
#define socket_sendmmsg_x_indexes no_indexes
#define socket_recvmsg_e_indexes syscall_close_e_indexes
static const int *socket_recvmsg_x_indexes[] = { &hf_param_res_bytes, &hf_param_size_uint32, &hf_param_data_bytes, &hf_param_tuple_bytes, NULL };
#define socket_recvmmsg_e_indexes no_indexes
#define socket_recvmmsg_x_indexes no_indexes
static const int *socket_accept4_e_indexes[] = { &hf_param_flags_uint32, NULL };
#define socket_accept4_x_indexes socket_accept_x_indexes
#define syscall_creat_e_indexes no_indexes
static const int *syscall_creat_x_indexes[] = { &hf_param_fd_int64, &hf_param_name_string, &hf_param_mode_uint32, NULL };
#define syscall_pipe_e_indexes no_indexes
static const int *syscall_pipe_x_indexes[] = { &hf_param_res_bytes, &hf_param_fd1_int64, &hf_param_fd2_int64, &hf_param_ino_uint64, NULL };
static const int *syscall_eventfd_e_indexes[] = { &hf_param_initval_uint64, &hf_param_flags_bytes, NULL };
static const int *syscall_eventfd_x_indexes[] = { &hf_param_res_int64, NULL };
static const int *syscall_futex_e_indexes[] = { &hf_param_addr_uint64, &hf_param_op_bytes, &hf_param_val_uint64, NULL };
#define syscall_futex_x_indexes syscall_close_x_indexes
#define syscall_stat_e_indexes no_indexes
static const int *syscall_stat_x_indexes[] = { &hf_param_res_bytes, &hf_param_path_string, NULL };
#define syscall_lstat_e_indexes no_indexes
#define syscall_lstat_x_indexes syscall_stat_x_indexes
#define syscall_fstat_e_indexes syscall_close_e_indexes
#define syscall_fstat_x_indexes syscall_close_x_indexes
#define syscall_stat64_e_indexes no_indexes
#define syscall_stat64_x_indexes syscall_stat_x_indexes
#define syscall_lstat64_e_indexes no_indexes
#define syscall_lstat64_x_indexes syscall_stat_x_indexes
#define syscall_fstat64_e_indexes syscall_close_e_indexes
#define syscall_fstat64_x_indexes syscall_close_x_indexes
static const int *syscall_epollwait_e_indexes[] = { &hf_param_maxevents_bytes, NULL };
#define syscall_epollwait_x_indexes syscall_close_x_indexes
static const int *syscall_poll_e_indexes[] = { &hf_param_fds_bytes, &hf_param_timeout_int64, NULL };
static const int *syscall_poll_x_indexes[] = { &hf_param_res_bytes, &hf_param_fds_bytes, NULL };
#define syscall_select_e_indexes no_indexes
#define syscall_select_x_indexes syscall_close_x_indexes
#define syscall_newselect_e_indexes no_indexes
#define syscall_newselect_x_indexes syscall_close_x_indexes
static const int *syscall_lseek_e_indexes[] = { &hf_param_fd_int64, &hf_param_offset_uint64, &hf_param_whence_bytes, NULL };
#define syscall_lseek_x_indexes syscall_close_x_indexes
#define syscall_llseek_e_indexes syscall_lseek_e_indexes
#define syscall_llseek_x_indexes syscall_close_x_indexes
static const int *syscall_ioctl_2_e_indexes[] = { &hf_param_fd_int64, &hf_param_request_uint64, NULL };
#define syscall_ioctl_2_x_indexes syscall_close_x_indexes
#define syscall_getcwd_e_indexes no_indexes
#define syscall_getcwd_x_indexes syscall_stat_x_indexes
#define syscall_chdir_e_indexes no_indexes
#define syscall_chdir_x_indexes syscall_stat_x_indexes
#define syscall_fchdir_e_indexes syscall_close_e_indexes
#define syscall_fchdir_x_indexes syscall_close_x_indexes
static const int *syscall_mkdir_e_indexes[] = { &hf_param_path_string, &hf_param_mode_uint32, NULL };
#define syscall_mkdir_x_indexes syscall_close_x_indexes
static const int *syscall_rmdir_e_indexes[] = { &hf_param_path_string, NULL };
#define syscall_rmdir_x_indexes syscall_close_x_indexes
static const int *syscall_openat_e_indexes[] = { &hf_param_dirfd_int64, &hf_param_name_string, &hf_param_flags_bytes, &hf_param_mode_uint32, NULL };
#define syscall_openat_x_indexes syscall_close_e_indexes
static const int *syscall_link_e_indexes[] = { &hf_param_oldpath_string, &hf_param_newpath_string, NULL };
#define syscall_link_x_indexes syscall_close_x_indexes
static const int *syscall_linkat_e_indexes[] = { &hf_param_olddir_int64, &hf_param_oldpath_string, &hf_param_newdir_int64, &hf_param_newpath_string, NULL };
#define syscall_linkat_x_indexes syscall_close_x_indexes
#define syscall_unlink_e_indexes syscall_rmdir_e_indexes
#define syscall_unlink_x_indexes syscall_close_x_indexes
static const int *syscall_unlinkat_e_indexes[] = { &hf_param_dirfd_int64, &hf_param_name_string, NULL };
#define syscall_unlinkat_x_indexes syscall_close_x_indexes
static const int *syscall_pread_e_indexes[] = { &hf_param_fd_int64, &hf_param_size_uint32, &hf_param_pos_uint64, NULL };
#define syscall_pread_x_indexes syscall_read_x_indexes
#define syscall_pwrite_e_indexes syscall_pread_e_indexes
#define syscall_pwrite_x_indexes syscall_read_x_indexes
#define syscall_readv_e_indexes syscall_close_e_indexes
static const int *syscall_readv_x_indexes[] = { &hf_param_res_bytes, &hf_param_size_uint32, &hf_param_data_bytes, NULL };
#define syscall_writev_e_indexes syscall_read_e_indexes
#define syscall_writev_x_indexes syscall_read_x_indexes
static const int *syscall_preadv_e_indexes[] = { &hf_param_fd_int64, &hf_param_pos_uint64, NULL };
#define syscall_preadv_x_indexes syscall_readv_x_indexes
#define syscall_pwritev_e_indexes syscall_pread_e_indexes
#define syscall_pwritev_x_indexes syscall_read_x_indexes
#define syscall_dup_e_indexes syscall_close_e_indexes
#define syscall_dup_x_indexes syscall_eventfd_x_indexes
static const int *syscall_signalfd_e_indexes[] = { &hf_param_fd_int64, &hf_param_mask_uint32, &hf_param_flags_bytes, NULL };
#define syscall_signalfd_x_indexes syscall_eventfd_x_indexes
static const int *syscall_kill_e_indexes[] = { &hf_param_pid_bytes, &hf_param_sig_bytes, NULL };
#define syscall_kill_x_indexes syscall_close_x_indexes
static const int *syscall_tkill_e_indexes[] = { &hf_param_tid_bytes, &hf_param_sig_bytes, NULL };
#define syscall_tkill_x_indexes syscall_close_x_indexes
static const int *syscall_tgkill_e_indexes[] = { &hf_param_pid_bytes, &hf_param_tid_bytes, &hf_param_sig_bytes, NULL };
#define syscall_tgkill_x_indexes syscall_close_x_indexes
static const int *syscall_nanosleep_e_indexes[] = { &hf_param_interval_bytes, NULL };
#define syscall_nanosleep_x_indexes syscall_close_x_indexes
static const int *syscall_timerfd_create_e_indexes[] = { &hf_param_clockid_uint8, &hf_param_flags_bytes, NULL };
#define syscall_timerfd_create_x_indexes syscall_eventfd_x_indexes
static const int *syscall_inotify_init_e_indexes[] = { &hf_param_flags_bytes, NULL };
#define syscall_inotify_init_x_indexes syscall_eventfd_x_indexes
static const int *syscall_getrlimit_e_indexes[] = { &hf_param_resource_bytes, NULL };
static const int *syscall_getrlimit_x_indexes[] = { &hf_param_res_bytes, &hf_param_cur_int64, &hf_param_max_int64, NULL };
#define syscall_setrlimit_e_indexes syscall_getrlimit_e_indexes
#define syscall_setrlimit_x_indexes syscall_getrlimit_x_indexes
static const int *syscall_prlimit_e_indexes[] = { &hf_param_pid_bytes, &hf_param_resource_bytes, NULL };
static const int *syscall_prlimit_x_indexes[] = { &hf_param_res_bytes, &hf_param_newcur_int64, &hf_param_newmax_int64, &hf_param_oldcur_int64, &hf_param_oldmax_int64, NULL };
static const int *schedswitch_1_e_indexes[] = { &hf_param_next_bytes, NULL };
#define schedswitch_1_x_indexes no_indexes
static const int *drop_e_indexes[] = { &hf_param_ratio_uint32, NULL };
#define drop_x_indexes drop_e_indexes
static const int *syscall_fcntl_e_indexes[] = { &hf_param_fd_int64, &hf_param_cmd_bytes, NULL };
#define syscall_fcntl_x_indexes syscall_eventfd_x_indexes
static const int *schedswitch_6_e_indexes[] = { &hf_param_next_bytes, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, NULL };
#define schedswitch_6_x_indexes no_indexes
#define syscall_execve_13_e_indexes no_indexes
static const int *syscall_execve_13_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, NULL };
#define syscall_clone_16_e_indexes no_indexes
static const int *syscall_clone_16_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_int64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_flags_bytes, &hf_param_uid_uint32, &hf_param_gid_uint32, NULL };
static const int *syscall_brk_4_e_indexes[] = { &hf_param_addr_uint64, NULL };
static const int *syscall_brk_4_x_indexes[] = { &hf_param_res_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, NULL };
static const int *syscall_mmap_e_indexes[] = { &hf_param_addr_uint64, &hf_param_length_uint64, &hf_param_prot_bytes, &hf_param_flags_bytes, &hf_param_fd_int64, &hf_param_offset_uint64, NULL };
#define syscall_mmap_x_indexes syscall_brk_4_x_indexes
static const int *syscall_mmap2_e_indexes[] = { &hf_param_addr_uint64, &hf_param_length_uint64, &hf_param_prot_bytes, &hf_param_flags_bytes, &hf_param_fd_int64, &hf_param_pgoffset_uint64, NULL };
#define syscall_mmap2_x_indexes syscall_brk_4_x_indexes
static const int *syscall_munmap_e_indexes[] = { &hf_param_addr_uint64, &hf_param_length_uint64, NULL };
static const int *syscall_munmap_x_indexes[] = { &hf_param_res_bytes, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, NULL };
static const int *syscall_splice_e_indexes[] = { &hf_param_fd_in_int64, &hf_param_fd_out_int64, &hf_param_size_uint64, &hf_param_flags_bytes, NULL };
#define syscall_splice_x_indexes syscall_close_x_indexes
static const int *syscall_ptrace_e_indexes[] = { &hf_param_request_bytes, &hf_param_pid_bytes, NULL };
static const int *syscall_ptrace_x_indexes[] = { &hf_param_res_bytes, &hf_param_addr_bytes, &hf_param_data_bytes, NULL };
static const int *syscall_ioctl_3_e_indexes[] = { &hf_param_fd_int64, &hf_param_request_uint64, &hf_param_argument_uint64, NULL };
#define syscall_ioctl_3_x_indexes syscall_close_x_indexes
#define syscall_execve_14_e_indexes no_indexes
static const int *syscall_execve_14_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_env_string, NULL };
#define syscall_rename_e_indexes no_indexes
static const int *syscall_rename_x_indexes[] = { &hf_param_res_bytes, &hf_param_oldpath_string, &hf_param_newpath_string, NULL };
#define syscall_renameat_e_indexes no_indexes
static const int *syscall_renameat_x_indexes[] = { &hf_param_res_bytes, &hf_param_olddirfd_int64, &hf_param_oldpath_string, &hf_param_newdirfd_int64, &hf_param_newpath_string, NULL };
#define syscall_symlink_e_indexes no_indexes
static const int *syscall_symlink_x_indexes[] = { &hf_param_res_bytes, &hf_param_target_string, &hf_param_linkpath_string, NULL };
#define syscall_symlinkat_e_indexes no_indexes
static const int *syscall_symlinkat_x_indexes[] = { &hf_param_res_bytes, &hf_param_target_string, &hf_param_linkdirfd_int64, &hf_param_linkpath_string, NULL };
#define syscall_fork_e_indexes no_indexes
#define syscall_fork_x_indexes syscall_clone_16_x_indexes
#define syscall_vfork_e_indexes no_indexes
#define syscall_vfork_x_indexes syscall_clone_16_x_indexes
static const int *procexit_1_e_indexes[] = { &hf_param_status_bytes, NULL };
#define procexit_1_x_indexes no_indexes
static const int *syscall_sendfile_e_indexes[] = { &hf_param_out_fd_int64, &hf_param_in_fd_int64, &hf_param_offset_uint64, &hf_param_size_uint64, NULL };
static const int *syscall_sendfile_x_indexes[] = { &hf_param_res_bytes, &hf_param_offset_uint64, NULL };
static const int *syscall_quotactl_e_indexes[] = { &hf_param_cmd_bytes, &hf_param_type_bytes, &hf_param_id_uint32, &hf_param_quota_fmt_bytes, NULL };
static const int *syscall_quotactl_x_indexes[] = { &hf_param_res_bytes, &hf_param_special_string, &hf_param_quotafilepath_string, &hf_param_dqb_bhardlimit_uint64, &hf_param_dqb_bsoftlimit_uint64, &hf_param_dqb_curspace_uint64, &hf_param_dqb_ihardlimit_uint64, &hf_param_dqb_isoftlimit_uint64, &hf_param_dqb_btime_bytes, &hf_param_dqb_itime_bytes, &hf_param_dqi_bgrace_bytes, &hf_param_dqi_igrace_bytes, &hf_param_dqi_flags_bytes, &hf_param_quota_fmt_out_bytes, NULL };
static const int *syscall_setresuid_e_indexes[] = { &hf_param_ruid_bytes, &hf_param_euid_bytes, &hf_param_suid_bytes, NULL };
#define syscall_setresuid_x_indexes syscall_close_x_indexes
static const int *syscall_setresgid_e_indexes[] = { &hf_param_rgid_bytes, &hf_param_egid_bytes, &hf_param_sgid_bytes, NULL };
#define syscall_setresgid_x_indexes syscall_close_x_indexes
static const int *sysdigevent_e_indexes[] = { &hf_param_event_type_uint32, &hf_param_event_data_uint64, NULL };
#define sysdigevent_x_indexes no_indexes
static const int *syscall_setuid_e_indexes[] = { &hf_param_uid_bytes, NULL };
#define syscall_setuid_x_indexes syscall_close_x_indexes
static const int *syscall_setgid_e_indexes[] = { &hf_param_gid_bytes, NULL };
#define syscall_setgid_x_indexes syscall_close_x_indexes
#define syscall_getuid_e_indexes no_indexes
#define syscall_getuid_x_indexes syscall_setuid_e_indexes
#define syscall_geteuid_e_indexes no_indexes
static const int *syscall_geteuid_x_indexes[] = { &hf_param_euid_bytes, NULL };
#define syscall_getgid_e_indexes no_indexes
#define syscall_getgid_x_indexes syscall_setgid_e_indexes
#define syscall_getegid_e_indexes no_indexes
static const int *syscall_getegid_x_indexes[] = { &hf_param_egid_bytes, NULL };
#define syscall_getresuid_e_indexes no_indexes
static const int *syscall_getresuid_x_indexes[] = { &hf_param_res_bytes, &hf_param_ruid_bytes, &hf_param_euid_bytes, &hf_param_suid_bytes, NULL };
#define syscall_getresgid_e_indexes no_indexes
static const int *syscall_getresgid_x_indexes[] = { &hf_param_res_bytes, &hf_param_rgid_bytes, &hf_param_egid_bytes, &hf_param_sgid_bytes, NULL };
#define syscall_execve_15_e_indexes no_indexes
static const int *syscall_execve_15_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_env_string, NULL };
#define syscall_clone_17_e_indexes no_indexes
static const int *syscall_clone_17_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_int64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_flags_bytes, &hf_param_uid_uint32, &hf_param_gid_uint32, NULL };
#define syscall_fork_17_e_indexes no_indexes
#define syscall_fork_17_x_indexes syscall_clone_17_x_indexes
#define syscall_vfork_17_e_indexes no_indexes
#define syscall_vfork_17_x_indexes syscall_clone_17_x_indexes
#define syscall_clone_20_e_indexes no_indexes
static const int *syscall_clone_20_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_int64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_cgroups_bytes, &hf_param_flags_bytes, &hf_param_uid_uint32, &hf_param_gid_uint32, &hf_param_vtid_bytes, &hf_param_vpid_bytes, NULL };
#define syscall_fork_20_e_indexes no_indexes
#define syscall_fork_20_x_indexes syscall_clone_20_x_indexes
#define syscall_vfork_20_e_indexes no_indexes
#define syscall_vfork_20_x_indexes syscall_clone_20_x_indexes
static const int *container_e_indexes[] = { &hf_param_id_string, &hf_param_type_uint32, &hf_param_name_string, &hf_param_image_string, NULL };
#define container_x_indexes no_indexes
#define syscall_execve_16_e_indexes no_indexes
static const int *syscall_execve_16_x_indexes[] = { &hf_param_res_bytes, &hf_param_exe_string, &hf_param_args_string, &hf_param_tid_bytes, &hf_param_pid_bytes, &hf_param_ptid_bytes, &hf_param_cwd_string, &hf_param_fdlimit_uint64, &hf_param_pgft_maj_uint64, &hf_param_pgft_min_uint64, &hf_param_vm_size_uint32, &hf_param_vm_rss_uint32, &hf_param_vm_swap_uint32, &hf_param_comm_string, &hf_param_cgroups_bytes, &hf_param_env_string, NULL };
static const int *signaldeliver_e_indexes[] = { &hf_param_spid_bytes, &hf_param_dpid_bytes, &hf_param_sig_bytes, NULL };
#define signaldeliver_x_indexes no_indexes
static const int *procinfo_e_indexes[] = { &hf_param_cpu_usr_uint64, &hf_param_cpu_sys_uint64, NULL };
#define procinfo_x_indexes no_indexes
#define syscall_getdents_e_indexes syscall_close_e_indexes
#define syscall_getdents_x_indexes syscall_close_x_indexes
#define syscall_getdents64_e_indexes syscall_close_e_indexes
#define syscall_getdents64_x_indexes syscall_close_x_indexes
static const int *syscall_setns_e_indexes[] = { &hf_param_fd_int64, &hf_param_nstype_bytes, NULL };
#define syscall_setns_x_indexes syscall_close_x_indexes
static const int *syscall_flock_e_indexes[] = { &hf_param_fd_int64, &hf_param_operation_bytes, NULL };
#define syscall_flock_x_indexes syscall_close_x_indexes
static const int *cpu_hotplug_e_indexes[] = { &hf_param_cpu_uint32, &hf_param_action_uint32, NULL };
#define cpu_hotplug_x_indexes no_indexes
#define socket_accept_5_e_indexes no_indexes
static const int *socket_accept_5_x_indexes[] = { &hf_param_fd_int64, &hf_param_tuple_bytes, &hf_param_queuepct_uint8, &hf_param_queuelen_uint32, &hf_param_queuemax_uint32, NULL };
#define socket_accept4_5_e_indexes socket_accept4_e_indexes
#define socket_accept4_5_x_indexes socket_accept_5_x_indexes
static const int *syscall_semop_e_indexes[] = { &hf_param_semid_int32, NULL };
static const int *syscall_semop_x_indexes[] = { &hf_param_res_bytes, &hf_param_nsops_uint32, &hf_param_sem_num_0_uint16, &hf_param_sem_op_0_int16, &hf_param_sem_flg_0_bytes, &hf_param_sem_num_1_uint16, &hf_param_sem_op_1_int16, &hf_param_sem_flg_1_bytes, NULL };
static const int *syscall_semctl_e_indexes[] = { &hf_param_semid_int32, &hf_param_semnum_int32, &hf_param_cmd_bytes, &hf_param_val_int32, NULL };
#define syscall_semctl_x_indexes syscall_close_x_indexes
static const int *syscall_ppoll_e_indexes[] = { &hf_param_fds_bytes, &hf_param_timeout_bytes, &hf_param_sigmask_bytes, NULL };
#define syscall_ppoll_x_indexes syscall_poll_x_indexes
#define syscall_mount_e_indexes syscall_inotify_init_e_indexes
static const int *syscall_mount_x_indexes[] = { &hf_param_res_bytes, &hf_param_dev_string, &hf_param_dir_string, &hf_param_type_string, NULL };
#define syscall_umount_e_indexes syscall_inotify_init_e_indexes
static const int *syscall_umount_x_indexes[] = { &hf_param_res_bytes, &hf_param_name_string, NULL };

static const struct _event_tree_info event_tree_info[] = {
/* Event tree. Automatically generated by tools/generate-sysdig-event.py */
    { EVT_GENERIC_E, generic_e_indexes },
    { EVT_GENERIC_X, generic_x_indexes },
    { EVT_SYSCALL_OPEN_E, syscall_open_e_indexes },
    { EVT_SYSCALL_OPEN_X, syscall_open_x_indexes },
    { EVT_SYSCALL_CLOSE_E, syscall_close_e_indexes },
    { EVT_SYSCALL_CLOSE_X, syscall_close_x_indexes },
    { EVT_SYSCALL_READ_E, syscall_read_e_indexes },
    { EVT_SYSCALL_READ_X, syscall_read_x_indexes },
    { EVT_SYSCALL_WRITE_E, syscall_write_e_indexes },
    { EVT_SYSCALL_WRITE_X, syscall_write_x_indexes },
    { EVT_SYSCALL_BRK_1_E, syscall_brk_1_e_indexes },
    { EVT_SYSCALL_BRK_1_X, syscall_brk_1_x_indexes },
    { EVT_SYSCALL_EXECVE_8_E, syscall_execve_8_e_indexes },
    { EVT_SYSCALL_EXECVE_8_X, syscall_execve_8_x_indexes },
    { EVT_SYSCALL_CLONE_11_E, syscall_clone_11_e_indexes },
    { EVT_SYSCALL_CLONE_11_X, syscall_clone_11_x_indexes },
    { EVT_PROCEXIT_E, procexit_e_indexes },
    { EVT_PROCEXIT_X, procexit_x_indexes },
    { EVT_SOCKET_SOCKET_E, socket_socket_e_indexes },
    { EVT_SOCKET_SOCKET_X, socket_socket_x_indexes },
    { EVT_SOCKET_BIND_E, socket_bind_e_indexes },
    { EVT_SOCKET_BIND_X, socket_bind_x_indexes },
    { EVT_SOCKET_CONNECT_E, socket_connect_e_indexes },
    { EVT_SOCKET_CONNECT_X, socket_connect_x_indexes },
    { EVT_SOCKET_LISTEN_E, socket_listen_e_indexes },
    { EVT_SOCKET_LISTEN_X, socket_listen_x_indexes },
    { EVT_SOCKET_ACCEPT_E, socket_accept_e_indexes },
    { EVT_SOCKET_ACCEPT_X, socket_accept_x_indexes },
    { EVT_SOCKET_SEND_E, socket_send_e_indexes },
    { EVT_SOCKET_SEND_X, socket_send_x_indexes },
    { EVT_SOCKET_SENDTO_E, socket_sendto_e_indexes },
    { EVT_SOCKET_SENDTO_X, socket_sendto_x_indexes },
    { EVT_SOCKET_RECV_E, socket_recv_e_indexes },
    { EVT_SOCKET_RECV_X, socket_recv_x_indexes },
    { EVT_SOCKET_RECVFROM_E, socket_recvfrom_e_indexes },
    { EVT_SOCKET_RECVFROM_X, socket_recvfrom_x_indexes },
    { EVT_SOCKET_SHUTDOWN_E, socket_shutdown_e_indexes },
    { EVT_SOCKET_SHUTDOWN_X, socket_shutdown_x_indexes },
    { EVT_SOCKET_GETSOCKNAME_E, socket_getsockname_e_indexes },
    { EVT_SOCKET_GETSOCKNAME_X, socket_getsockname_x_indexes },
    { EVT_SOCKET_GETPEERNAME_E, socket_getpeername_e_indexes },
    { EVT_SOCKET_GETPEERNAME_X, socket_getpeername_x_indexes },
    { EVT_SOCKET_SOCKETPAIR_E, socket_socketpair_e_indexes },
    { EVT_SOCKET_SOCKETPAIR_X, socket_socketpair_x_indexes },
    { EVT_SOCKET_SETSOCKOPT_E, socket_setsockopt_e_indexes },
    { EVT_SOCKET_SETSOCKOPT_X, socket_setsockopt_x_indexes },
    { EVT_SOCKET_GETSOCKOPT_E, socket_getsockopt_e_indexes },
    { EVT_SOCKET_GETSOCKOPT_X, socket_getsockopt_x_indexes },
    { EVT_SOCKET_SENDMSG_E, socket_sendmsg_e_indexes },
    { EVT_SOCKET_SENDMSG_X, socket_sendmsg_x_indexes },
    { EVT_SOCKET_SENDMMSG_E, socket_sendmmsg_e_indexes },
    { EVT_SOCKET_SENDMMSG_X, socket_sendmmsg_x_indexes },
    { EVT_SOCKET_RECVMSG_E, socket_recvmsg_e_indexes },
    { EVT_SOCKET_RECVMSG_X, socket_recvmsg_x_indexes },
    { EVT_SOCKET_RECVMMSG_E, socket_recvmmsg_e_indexes },
    { EVT_SOCKET_RECVMMSG_X, socket_recvmmsg_x_indexes },
    { EVT_SOCKET_ACCEPT4_E, socket_accept4_e_indexes },
    { EVT_SOCKET_ACCEPT4_X, socket_accept4_x_indexes },
    { EVT_SYSCALL_CREAT_E, syscall_creat_e_indexes },
    { EVT_SYSCALL_CREAT_X, syscall_creat_x_indexes },
    { EVT_SYSCALL_PIPE_E, syscall_pipe_e_indexes },
    { EVT_SYSCALL_PIPE_X, syscall_pipe_x_indexes },
    { EVT_SYSCALL_EVENTFD_E, syscall_eventfd_e_indexes },
    { EVT_SYSCALL_EVENTFD_X, syscall_eventfd_x_indexes },
    { EVT_SYSCALL_FUTEX_E, syscall_futex_e_indexes },
    { EVT_SYSCALL_FUTEX_X, syscall_futex_x_indexes },
    { EVT_SYSCALL_STAT_E, syscall_stat_e_indexes },
    { EVT_SYSCALL_STAT_X, syscall_stat_x_indexes },
    { EVT_SYSCALL_LSTAT_E, syscall_lstat_e_indexes },
    { EVT_SYSCALL_LSTAT_X, syscall_lstat_x_indexes },
    { EVT_SYSCALL_FSTAT_E, syscall_fstat_e_indexes },
    { EVT_SYSCALL_FSTAT_X, syscall_fstat_x_indexes },
    { EVT_SYSCALL_STAT64_E, syscall_stat64_e_indexes },
    { EVT_SYSCALL_STAT64_X, syscall_stat64_x_indexes },
    { EVT_SYSCALL_LSTAT64_E, syscall_lstat64_e_indexes },
    { EVT_SYSCALL_LSTAT64_X, syscall_lstat64_x_indexes },
    { EVT_SYSCALL_FSTAT64_E, syscall_fstat64_e_indexes },
    { EVT_SYSCALL_FSTAT64_X, syscall_fstat64_x_indexes },
    { EVT_SYSCALL_EPOLLWAIT_E, syscall_epollwait_e_indexes },
    { EVT_SYSCALL_EPOLLWAIT_X, syscall_epollwait_x_indexes },
    { EVT_SYSCALL_POLL_E, syscall_poll_e_indexes },
    { EVT_SYSCALL_POLL_X, syscall_poll_x_indexes },
    { EVT_SYSCALL_SELECT_E, syscall_select_e_indexes },
    { EVT_SYSCALL_SELECT_X, syscall_select_x_indexes },
    { EVT_SYSCALL_NEWSELECT_E, syscall_newselect_e_indexes },
    { EVT_SYSCALL_NEWSELECT_X, syscall_newselect_x_indexes },
    { EVT_SYSCALL_LSEEK_E, syscall_lseek_e_indexes },
    { EVT_SYSCALL_LSEEK_X, syscall_lseek_x_indexes },
    { EVT_SYSCALL_LLSEEK_E, syscall_llseek_e_indexes },
    { EVT_SYSCALL_LLSEEK_X, syscall_llseek_x_indexes },
    { EVT_SYSCALL_IOCTL_2_E, syscall_ioctl_2_e_indexes },
    { EVT_SYSCALL_IOCTL_2_X, syscall_ioctl_2_x_indexes },
    { EVT_SYSCALL_GETCWD_E, syscall_getcwd_e_indexes },
    { EVT_SYSCALL_GETCWD_X, syscall_getcwd_x_indexes },
    { EVT_SYSCALL_CHDIR_E, syscall_chdir_e_indexes },
    { EVT_SYSCALL_CHDIR_X, syscall_chdir_x_indexes },
    { EVT_SYSCALL_FCHDIR_E, syscall_fchdir_e_indexes },
    { EVT_SYSCALL_FCHDIR_X, syscall_fchdir_x_indexes },
    { EVT_SYSCALL_MKDIR_E, syscall_mkdir_e_indexes },
    { EVT_SYSCALL_MKDIR_X, syscall_mkdir_x_indexes },
    { EVT_SYSCALL_RMDIR_E, syscall_rmdir_e_indexes },
    { EVT_SYSCALL_RMDIR_X, syscall_rmdir_x_indexes },
    { EVT_SYSCALL_OPENAT_E, syscall_openat_e_indexes },
    { EVT_SYSCALL_OPENAT_X, syscall_openat_x_indexes },
    { EVT_SYSCALL_LINK_E, syscall_link_e_indexes },
    { EVT_SYSCALL_LINK_X, syscall_link_x_indexes },
    { EVT_SYSCALL_LINKAT_E, syscall_linkat_e_indexes },
    { EVT_SYSCALL_LINKAT_X, syscall_linkat_x_indexes },
    { EVT_SYSCALL_UNLINK_E, syscall_unlink_e_indexes },
    { EVT_SYSCALL_UNLINK_X, syscall_unlink_x_indexes },
    { EVT_SYSCALL_UNLINKAT_E, syscall_unlinkat_e_indexes },
    { EVT_SYSCALL_UNLINKAT_X, syscall_unlinkat_x_indexes },
    { EVT_SYSCALL_PREAD_E, syscall_pread_e_indexes },
    { EVT_SYSCALL_PREAD_X, syscall_pread_x_indexes },
    { EVT_SYSCALL_PWRITE_E, syscall_pwrite_e_indexes },
    { EVT_SYSCALL_PWRITE_X, syscall_pwrite_x_indexes },
    { EVT_SYSCALL_READV_E, syscall_readv_e_indexes },
    { EVT_SYSCALL_READV_X, syscall_readv_x_indexes },
    { EVT_SYSCALL_WRITEV_E, syscall_writev_e_indexes },
    { EVT_SYSCALL_WRITEV_X, syscall_writev_x_indexes },
    { EVT_SYSCALL_PREADV_E, syscall_preadv_e_indexes },
    { EVT_SYSCALL_PREADV_X, syscall_preadv_x_indexes },
    { EVT_SYSCALL_PWRITEV_E, syscall_pwritev_e_indexes },
    { EVT_SYSCALL_PWRITEV_X, syscall_pwritev_x_indexes },
    { EVT_SYSCALL_DUP_E, syscall_dup_e_indexes },
    { EVT_SYSCALL_DUP_X, syscall_dup_x_indexes },
    { EVT_SYSCALL_SIGNALFD_E, syscall_signalfd_e_indexes },
    { EVT_SYSCALL_SIGNALFD_X, syscall_signalfd_x_indexes },
    { EVT_SYSCALL_KILL_E, syscall_kill_e_indexes },
    { EVT_SYSCALL_KILL_X, syscall_kill_x_indexes },
    { EVT_SYSCALL_TKILL_E, syscall_tkill_e_indexes },
    { EVT_SYSCALL_TKILL_X, syscall_tkill_x_indexes },
    { EVT_SYSCALL_TGKILL_E, syscall_tgkill_e_indexes },
    { EVT_SYSCALL_TGKILL_X, syscall_tgkill_x_indexes },
    { EVT_SYSCALL_NANOSLEEP_E, syscall_nanosleep_e_indexes },
    { EVT_SYSCALL_NANOSLEEP_X, syscall_nanosleep_x_indexes },
    { EVT_SYSCALL_TIMERFD_CREATE_E, syscall_timerfd_create_e_indexes },
    { EVT_SYSCALL_TIMERFD_CREATE_X, syscall_timerfd_create_x_indexes },
    { EVT_SYSCALL_INOTIFY_INIT_E, syscall_inotify_init_e_indexes },
    { EVT_SYSCALL_INOTIFY_INIT_X, syscall_inotify_init_x_indexes },
    { EVT_SYSCALL_GETRLIMIT_E, syscall_getrlimit_e_indexes },
    { EVT_SYSCALL_GETRLIMIT_X, syscall_getrlimit_x_indexes },
    { EVT_SYSCALL_SETRLIMIT_E, syscall_setrlimit_e_indexes },
    { EVT_SYSCALL_SETRLIMIT_X, syscall_setrlimit_x_indexes },
    { EVT_SYSCALL_PRLIMIT_E, syscall_prlimit_e_indexes },
    { EVT_SYSCALL_PRLIMIT_X, syscall_prlimit_x_indexes },
    { EVT_SCHEDSWITCH_1_E, schedswitch_1_e_indexes },
    { EVT_SCHEDSWITCH_1_X, schedswitch_1_x_indexes },
    { EVT_DROP_E, drop_e_indexes },
    { EVT_DROP_X, drop_x_indexes },
    { EVT_SYSCALL_FCNTL_E, syscall_fcntl_e_indexes },
    { EVT_SYSCALL_FCNTL_X, syscall_fcntl_x_indexes },
    { EVT_SCHEDSWITCH_6_E, schedswitch_6_e_indexes },
    { EVT_SCHEDSWITCH_6_X, schedswitch_6_x_indexes },
    { EVT_SYSCALL_EXECVE_13_E, syscall_execve_13_e_indexes },
    { EVT_SYSCALL_EXECVE_13_X, syscall_execve_13_x_indexes },
    { EVT_SYSCALL_CLONE_16_E, syscall_clone_16_e_indexes },
    { EVT_SYSCALL_CLONE_16_X, syscall_clone_16_x_indexes },
    { EVT_SYSCALL_BRK_4_E, syscall_brk_4_e_indexes },
    { EVT_SYSCALL_BRK_4_X, syscall_brk_4_x_indexes },
    { EVT_SYSCALL_MMAP_E, syscall_mmap_e_indexes },
    { EVT_SYSCALL_MMAP_X, syscall_mmap_x_indexes },
    { EVT_SYSCALL_MMAP2_E, syscall_mmap2_e_indexes },
    { EVT_SYSCALL_MMAP2_X, syscall_mmap2_x_indexes },
    { EVT_SYSCALL_MUNMAP_E, syscall_munmap_e_indexes },
    { EVT_SYSCALL_MUNMAP_X, syscall_munmap_x_indexes },
    { EVT_SYSCALL_SPLICE_E, syscall_splice_e_indexes },
    { EVT_SYSCALL_SPLICE_X, syscall_splice_x_indexes },
    { EVT_SYSCALL_PTRACE_E, syscall_ptrace_e_indexes },
    { EVT_SYSCALL_PTRACE_X, syscall_ptrace_x_indexes },
    { EVT_SYSCALL_IOCTL_3_E, syscall_ioctl_3_e_indexes },
    { EVT_SYSCALL_IOCTL_3_X, syscall_ioctl_3_x_indexes },
    { EVT_SYSCALL_EXECVE_14_E, syscall_execve_14_e_indexes },
    { EVT_SYSCALL_EXECVE_14_X, syscall_execve_14_x_indexes },
    { EVT_SYSCALL_RENAME_E, syscall_rename_e_indexes },
    { EVT_SYSCALL_RENAME_X, syscall_rename_x_indexes },
    { EVT_SYSCALL_RENAMEAT_E, syscall_renameat_e_indexes },
    { EVT_SYSCALL_RENAMEAT_X, syscall_renameat_x_indexes },
    { EVT_SYSCALL_SYMLINK_E, syscall_symlink_e_indexes },
    { EVT_SYSCALL_SYMLINK_X, syscall_symlink_x_indexes },
    { EVT_SYSCALL_SYMLINKAT_E, syscall_symlinkat_e_indexes },
    { EVT_SYSCALL_SYMLINKAT_X, syscall_symlinkat_x_indexes },
    { EVT_SYSCALL_FORK_E, syscall_fork_e_indexes },
    { EVT_SYSCALL_FORK_X, syscall_fork_x_indexes },
    { EVT_SYSCALL_VFORK_E, syscall_vfork_e_indexes },
    { EVT_SYSCALL_VFORK_X, syscall_vfork_x_indexes },
    { EVT_PROCEXIT_1_E, procexit_1_e_indexes },
    { EVT_PROCEXIT_1_X, procexit_1_x_indexes },
    { EVT_SYSCALL_SENDFILE_E, syscall_sendfile_e_indexes },
    { EVT_SYSCALL_SENDFILE_X, syscall_sendfile_x_indexes },
    { EVT_SYSCALL_QUOTACTL_E, syscall_quotactl_e_indexes },
    { EVT_SYSCALL_QUOTACTL_X, syscall_quotactl_x_indexes },
    { EVT_SYSCALL_SETRESUID_E, syscall_setresuid_e_indexes },
    { EVT_SYSCALL_SETRESUID_X, syscall_setresuid_x_indexes },
    { EVT_SYSCALL_SETRESGID_E, syscall_setresgid_e_indexes },
    { EVT_SYSCALL_SETRESGID_X, syscall_setresgid_x_indexes },
    { EVT_SYSDIGEVENT_E, sysdigevent_e_indexes },
    { EVT_SYSDIGEVENT_X, sysdigevent_x_indexes },
    { EVT_SYSCALL_SETUID_E, syscall_setuid_e_indexes },
    { EVT_SYSCALL_SETUID_X, syscall_setuid_x_indexes },
    { EVT_SYSCALL_SETGID_E, syscall_setgid_e_indexes },
    { EVT_SYSCALL_SETGID_X, syscall_setgid_x_indexes },
    { EVT_SYSCALL_GETUID_E, syscall_getuid_e_indexes },
    { EVT_SYSCALL_GETUID_X, syscall_getuid_x_indexes },
    { EVT_SYSCALL_GETEUID_E, syscall_geteuid_e_indexes },
    { EVT_SYSCALL_GETEUID_X, syscall_geteuid_x_indexes },
    { EVT_SYSCALL_GETGID_E, syscall_getgid_e_indexes },
    { EVT_SYSCALL_GETGID_X, syscall_getgid_x_indexes },
    { EVT_SYSCALL_GETEGID_E, syscall_getegid_e_indexes },
    { EVT_SYSCALL_GETEGID_X, syscall_getegid_x_indexes },
    { EVT_SYSCALL_GETRESUID_E, syscall_getresuid_e_indexes },
    { EVT_SYSCALL_GETRESUID_X, syscall_getresuid_x_indexes },
    { EVT_SYSCALL_GETRESGID_E, syscall_getresgid_e_indexes },
    { EVT_SYSCALL_GETRESGID_X, syscall_getresgid_x_indexes },
    { EVT_SYSCALL_EXECVE_15_E, syscall_execve_15_e_indexes },
    { EVT_SYSCALL_EXECVE_15_X, syscall_execve_15_x_indexes },
    { EVT_SYSCALL_CLONE_17_E, syscall_clone_17_e_indexes },
    { EVT_SYSCALL_CLONE_17_X, syscall_clone_17_x_indexes },
    { EVT_SYSCALL_FORK_17_E, syscall_fork_17_e_indexes },
    { EVT_SYSCALL_FORK_17_X, syscall_fork_17_x_indexes },
    { EVT_SYSCALL_VFORK_17_E, syscall_vfork_17_e_indexes },
    { EVT_SYSCALL_VFORK_17_X, syscall_vfork_17_x_indexes },
    { EVT_SYSCALL_CLONE_20_E, syscall_clone_20_e_indexes },
    { EVT_SYSCALL_CLONE_20_X, syscall_clone_20_x_indexes },
    { EVT_SYSCALL_FORK_20_E, syscall_fork_20_e_indexes },
    { EVT_SYSCALL_FORK_20_X, syscall_fork_20_x_indexes },
    { EVT_SYSCALL_VFORK_20_E, syscall_vfork_20_e_indexes },
    { EVT_SYSCALL_VFORK_20_X, syscall_vfork_20_x_indexes },
    { EVT_CONTAINER_E, container_e_indexes },
    { EVT_CONTAINER_X, container_x_indexes },
    { EVT_SYSCALL_EXECVE_16_E, syscall_execve_16_e_indexes },
    { EVT_SYSCALL_EXECVE_16_X, syscall_execve_16_x_indexes },
    { EVT_SIGNALDELIVER_E, signaldeliver_e_indexes },
    { EVT_SIGNALDELIVER_X, signaldeliver_x_indexes },
    { EVT_PROCINFO_E, procinfo_e_indexes },
    { EVT_PROCINFO_X, procinfo_x_indexes },
    { EVT_SYSCALL_GETDENTS_E, syscall_getdents_e_indexes },
    { EVT_SYSCALL_GETDENTS_X, syscall_getdents_x_indexes },
    { EVT_SYSCALL_GETDENTS64_E, syscall_getdents64_e_indexes },
    { EVT_SYSCALL_GETDENTS64_X, syscall_getdents64_x_indexes },
    { EVT_SYSCALL_SETNS_E, syscall_setns_e_indexes },
    { EVT_SYSCALL_SETNS_X, syscall_setns_x_indexes },
    { EVT_SYSCALL_FLOCK_E, syscall_flock_e_indexes },
    { EVT_SYSCALL_FLOCK_X, syscall_flock_x_indexes },
    { EVT_CPU_HOTPLUG_E, cpu_hotplug_e_indexes },
    { EVT_CPU_HOTPLUG_X, cpu_hotplug_x_indexes },
    { EVT_SOCKET_ACCEPT_5_E, socket_accept_5_e_indexes },
    { EVT_SOCKET_ACCEPT_5_X, socket_accept_5_x_indexes },
    { EVT_SOCKET_ACCEPT4_5_E, socket_accept4_5_e_indexes },
    { EVT_SOCKET_ACCEPT4_5_X, socket_accept4_5_x_indexes },
    { EVT_SYSCALL_SEMOP_E, syscall_semop_e_indexes },
    { EVT_SYSCALL_SEMOP_X, syscall_semop_x_indexes },
    { EVT_SYSCALL_SEMCTL_E, syscall_semctl_e_indexes },
    { EVT_SYSCALL_SEMCTL_X, syscall_semctl_x_indexes },
    { EVT_SYSCALL_PPOLL_E, syscall_ppoll_e_indexes },
    { EVT_SYSCALL_PPOLL_X, syscall_ppoll_x_indexes },
    { EVT_SYSCALL_MOUNT_E, syscall_mount_e_indexes },
    { EVT_SYSCALL_MOUNT_X, syscall_mount_x_indexes },
    { EVT_SYSCALL_UMOUNT_E, syscall_umount_e_indexes },
    { EVT_SYSCALL_UMOUNT_X, syscall_umount_x_indexes },

    { 0, NULL }
};

/*
 * Value strings.
 * If the X_Y_vals has a matching hf_param_X_Y it will be added as a
 * VALS field conversion below.
 */

static const value_string nativeID_uint16_vals[] = {
    {   1, "restart_syscall" },
    {   2, "exit" },
    {   3, "read" },
    {   4, "write" },
    {   5, "open" },
    {   6, "close" },
    {   7, "creat" },
    {   8, "link" },
    {   9, "unlink" },
    {  10, "chdir" },
    {  11, "time" },
    {  12, "mknod" },
    {  13, "chmod" },
    {  14, "stat" },
    {  15, "lseek" },
    {  16, "getpid" },
    {  17, "mount" },
    {  18, "ptrace" },
    {  19, "alarm" },
    {  20, "fstat" },
    {  21, "pause" },
    {  22, "utime" },
    {  23, "access" },
    {  24, "sync" },
    {  25, "kill" },
    {  26, "rename" },
    {  27, "mkdir" },
    {  28, "rmdir" },
    {  29, "dup" },
    {  30, "pipe" },
    {  31, "times" },
    {  32, "brk" },
    {  33, "acct" },
    {  34, "ioctl" },
    {  35, "fcntl" },
    {  36, "setpgid" },
    {  37, "umask" },
    {  38, "chroot" },
    {  39, "ustat" },
    {  40, "dup2" },
    {  41, "getppid" },
    {  42, "getpgrp" },
    {  43, "setsid" },
    {  44, "sethostname" },
    {  45, "setrlimit" },
    {  46, "getrusage" },
    {  47, "gettimeofday" },
    {  48, "settimeofday" },
    {  49, "symlink" },
    {  50, "lstat" },
    {  51, "readlink" },
    {  52, "uselib" },
    {  53, "swapon" },
    {  54, "reboot" },
    {  55, "mmap" },
    {  56, "munmap" },
    {  57, "truncate" },
    {  58, "ftruncate" },
    {  59, "fchmod" },
    {  60, "getpriority" },
    {  61, "setpriority" },
    {  62, "statfs" },
    {  63, "fstatfs" },
    {  64, "syslog" },
    {  65, "setitimer" },
    {  66, "getitimer" },
    {  67, "uname" },
    {  68, "clean" },
    {  69, "wait4" },
    {  70, "swapoff" },
    {  71, "sysinfo" },
    {  72, "fsync" },
    {  73, "setdomainname" },
    {  74, "adjtimex" },
    {  75, "mprotect" },
    {  76, "init_module" },
    {  77, "delete_module" },
    {  78, "quotactl" },
    {  79, "getpgid" },
    {  80, "fchdir" },
    {  81, "sysfs" },
    {  82, "personality" },
    {  83, "getdents" },
    {  84, "select" },
    {  85, "flock" },
    {  86, "msync" },
    {  87, "readv" },
    {  88, "writev" },
    {  89, "getsid" },
    {  90, "fdatasync" },
    {  91, "mlock" },
    {  92, "munlock" },
    {  93, "mlockall" },
    {  94, "munlockall" },
    {  95, "sched_setparam" },
    {  96, "sched_getparam" },
    {  97, "sched_setscheduler" },
    {  98, "sched_getscheduler" },
    {  99, "sched_yield" },
    { 100, "sched_get_priority_max" },
    { 101, "sched_get_priority_min" },
    { 102, "sched_rr_get_interval" },
    { 103, "nanosleep" },
    { 104, "mremap" },
    { 105, "poll" },
    { 106, "prctl" },
    { 107, "rt_sigaction" },
    { 108, "rt_sigprocmask" },
    { 109, "rt_sigpending" },
    { 110, "rt_sigtimedwait" },
    { 111, "rt_sigqueueinfo" },
    { 112, "rt_sigsuspend" },
    { 113, "getcwd" },
    { 114, "capget" },
    { 115, "capset" },
    { 116, "sendfile" },
    { 117, "getrlimit" },
    { 118, "lchown" },
    { 119, "getuid" },
    { 120, "getgid" },
    { 121, "geteuid" },
    { 122, "getegid" },
    { 123, "setreuid" },
    { 124, "setregid" },
    { 125, "getgroups" },
    { 126, "setgroups" },
    { 127, "fchown" },
    { 128, "setresuid" },
    { 129, "getresuid" },
    { 130, "setresgid" },
    { 131, "getresgid" },
    { 132, "chown" },
    { 133, "setuid" },
    { 134, "setgid" },
    { 135, "setfsuid" },
    { 136, "setfsgid" },
    { 137, "pivot_root" },
    { 138, "mincore" },
    { 139, "madvise" },
    { 140, "gettid" },
    { 141, "setxattr" },
    { 142, "lsetxattr" },
    { 143, "fsetxattr" },
    { 144, "getxattr" },
    { 145, "lgetxattr" },
    { 146, "fgetxattr" },
    { 147, "listxattr" },
    { 148, "llistxattr" },
    { 149, "flistxattr" },
    { 150, "removexattr" },
    { 151, "lremovexattr" },
    { 152, "fremovexattr" },
    { 153, "tkill" },
    { 154, "futex" },
    { 155, "sched_setaffinity" },
    { 156, "sched_getaffinity" },
    { 157, "set_thread_area" },
    { 158, "get_thread_area" },
    { 159, "io_setup" },
    { 160, "io_destroy" },
    { 161, "io_getevents" },
    { 162, "io_submit" },
    { 163, "io_cancel" },
    { 164, "exit_group" },
    { 165, "epoll_create" },
    { 166, "epoll_ctl" },
    { 167, "epoll_wait" },
    { 168, "remap_file_pages" },
    { 169, "set_tid_address" },
    { 170, "timer_create" },
    { 171, "timer_settime" },
    { 172, "timer_gettime" },
    { 173, "timer_getoverrun" },
    { 174, "timer_delete" },
    { 175, "clock_settime" },
    { 176, "clock_gettime" },
    { 177, "clock_getres" },
    { 178, "clock_nanosleep" },
    { 179, "tgkill" },
    { 180, "utimes" },
    { 181, "mq_open" },
    { 182, "mq_unlink" },
    { 183, "mq_timedsend" },
    { 184, "mq_timedreceive" },
    { 185, "mq_notify" },
    { 186, "mq_getsetattr" },
    { 187, "kexec_load" },
    { 188, "waitid" },
    { 189, "add_key" },
    { 190, "request_key" },
    { 191, "keyctl" },
    { 192, "ioprio_set" },
    { 193, "ioprio_get" },
    { 194, "inotify_init" },
    { 195, "inotify_add_watch" },
    { 196, "inotify_rm_watch" },
    { 197, "openat" },
    { 198, "mkdirat" },
    { 199, "mknodat" },
    { 200, "fchownat" },
    { 201, "futimesat" },
    { 202, "unlinkat" },
    { 203, "renameat" },
    { 204, "linkat" },
    { 205, "symlinkat" },
    { 206, "readlinkat" },
    { 207, "fchmodat" },
    { 208, "faccessat" },
    { 209, "pselect6" },
    { 210, "ppoll" },
    { 211, "unshare" },
    { 212, "set_robust_list" },
    { 213, "get_robust_list" },
    { 214, "splice" },
    { 215, "tee" },
    { 216, "vmsplice" },
    { 217, "getcpu" },
    { 218, "epoll_pwait" },
    { 219, "utimensat" },
    { 220, "signalfd" },
    { 221, "timerfd_create" },
    { 222, "eventfd" },
    { 223, "timerfd_settime" },
    { 224, "timerfd_gettime" },
    { 225, "signalfd4" },
    { 226, "eventfd2" },
    { 227, "epoll_create1" },
    { 228, "dup3" },
    { 229, "pipe2" },
    { 230, "inotify_init1" },
    { 231, "preadv" },
    { 232, "pwritev" },
    { 233, "rt_tgsigqueueinfo" },
    { 234, "perf_event_open" },
    { 235, "fanotify_init" },
    { 236, "prlimit64" },
    { 237, "clock_adjtime" },
    { 238, "syncfs" },
    { 239, "setns" },
    { 240, "getdents64" },
    { 241, "socket" },
    { 242, "bind" },
    { 243, "connect" },
    { 244, "listen" },
    { 245, "accept" },
    { 246, "getsockname" },
    { 247, "getpeername" },
    { 248, "socketpair" },
    { 249, "sendto" },
    { 250, "recvfrom" },
    { 251, "shutdown" },
    { 252, "setsockopt" },
    { 253, "getsockopt" },
    { 254, "sendmsg" },
    { 255, "sendmmsg" },
    { 256, "recvmsg" },
    { 257, "recvmmsg" },
    { 258, "accept4" },
    { 259, "semop" },
    { 260, "semget" },
    { 261, "semctl" },
    { 262, "msgsnd" },
    { 263, "msgrcv" },
    { 264, "msgget" },
    { 265, "msgctl" },
    { 266, "shmdt" },
    { 267, "shmget" },
    { 268, "shmctl" },
    { 269, "statfs64" },
    { 270, "fstatfs64" },
    { 271, "fstatat64" },
    { 272, "sendfile64" },
    { 273, "ugetrlimit" },
    { 274, "bdflush" },
    { 275, "sigprocmask" },
    { 276, "ipc" },
    { 277, "socketcall" },
    { 278, "stat64" },
    { 279, "lstat64" },
    { 280, "fstat64" },
    { 281, "fcntl64" },
    { 282, "mmap2" },
    { 283, "newselect" },
    { 284, "sgetmask" },
    { 285, "ssetmask" },
    { 286, "sigpending" },
    { 287, "olduname" },
    { 288, "umount" },
    { 289, "signal" },
    { 290, "nice" },
    { 291, "stime" },
    { 292, "llseek" },
    { 293, "waitpid" },
    { 294, "pread64" },
    { 295, "pwrite64" },
    { 296, "arch_prctl" },
    { 297, "shmat" },
    { 298, "sigreturn" },
    { 299, "fallocate" },
    { 300, "newfstatat" },
    { 301, "process_vm_readv" },
    { 302, "process_vm_writev" },
    { 303, "fork" },
    { 304, "vfork" },
    { 305, "setuid" },
    { 306, "getuid" },
    { 307, "setgid" },
    { 308, "geteuid" },
    { 309, "getgid" },
    { 310, "setresuid" },
    { 311, "setresgid" },
    { 312, "getresuid" },
    { 313, "getresgid" },
    { 0, NULL }
};

/*
static const value_string param_category_vals[] = {
    {  1, "Other"},
    {  2, "File"},
    {  3, "Network operation"},
    {  4, "IPC operation"},
    {  5, "Memory operation"},
    {  6, "Process operation"},
    {  7, "Plain sleep"},
    {  8, "System operation"},
    {  9, "Signal operation"},
    { 10, "User operation"},
    { 11, "Time"},
    { 12, "User-level processing"},
    { 32, "I/O read"},
    { 33, "I/O write"},
    { 34, "I/O other"},
    { 64, "General wait"},
    {128, "Scheduler event"},
    {256, "Internal event"},
    {0, NULL}
};
*/

/*
static const value_string param_flag_vals[] = {
    {     0, "None"},
    {1 << 0, "Creates FD"},
    {1 << 1, "Destroys FD"},
    {1 << 2, "Uses FD"},
    {1 << 3, "Reads from FD"},
    {1 << 4, "Writes to FD"},
    {1 << 5, "Modifies state"},
    {1 << 6, "Unused"},
    {1 << 7, "Waits"},
    {1 << 8, "Skip parse reset"},
    {1 << 9, "Old version"},
    {0, NULL}
};
*/

/*
static const value_string param_subcategory_vals[] = {
    {  0, "Unknown"},
    {  1, "None"},
    {  2, "Other"},
    {  3, "File"},
    {  4, "Net"},
    {  5, "IPC"},
    {0, NULL}
};
*/

static inline const gchar *format_param_str(tvbuff_t *tvb, int offset, int len) {
    char *param_str;

    param_str = tvb_get_string_enc(wmem_packet_scope(), tvb, offset, len, ENC_UTF_8|ENC_NA);

    if (len < 2) {
        return param_str;
    }
    return format_text_chr(param_str, len - 1, ' '); /* Leave terminating NULLs alone. */
}

/* Code to actually dissect the packets */

static int
dissect_header_lens(tvbuff_t *tvb, int offset, proto_tree *tree, int encoding, const int **hf_indexes)
{
    int param_count;
    proto_item *ti;
    proto_tree *len_tree;

    for (param_count = 0; hf_indexes[param_count]; param_count++);

    ti = proto_tree_add_item(tree, hf_se_param_lens, tvb, offset, param_count * 2, ENC_NA);
    len_tree = proto_item_add_subtree(ti, ett_sysdig_parm_lens);

    for (param_count = 0; hf_indexes[param_count]; param_count++) {
        proto_tree_add_item(len_tree, hf_se_param_len, tvb, offset + (param_count * 2), 2, encoding);
    }

    proto_item_set_len(ti, param_count * 2);
    return param_count * 2;
}

/* Dissect events */

static int
dissect_event_params(tvbuff_t *tvb, int offset, proto_tree *tree, int encoding, const int **hf_indexes)
{
    int len_offset = offset;
    int param_offset;
    int cur_param;

    param_offset = offset + dissect_header_lens(tvb, offset, tree, encoding, hf_indexes);

    for (cur_param = 0; hf_indexes[cur_param]; cur_param++) {
        int param_len = tvb_get_guint16(tvb, len_offset, encoding);
        const int hf_index = *hf_indexes[cur_param];
        if (proto_registrar_get_ftype(hf_index) == FT_STRING) {
            proto_tree_add_string(tree, hf_index, tvb, param_offset, param_len,
                                  format_param_str(tvb, param_offset, param_len));
        } else {
            proto_tree_add_item(tree, hf_index, tvb, param_offset, param_len, encoding);
        }

        param_offset += param_len;
        len_offset += 2;
    }
    return param_offset - offset;
}


static int
dissect_sysdig_event(tvbuff_t *tvb, packet_info *pinfo, proto_tree *tree,
        void *data _U_)
{
    proto_item *ti;
    proto_tree *se_tree, *syscall_tree;
    guint       event_type = pinfo->phdr->pseudo_header.sysdig_event.event_type;
    int         encoding = pinfo->phdr->pseudo_header.sysdig_event.byte_order == G_BIG_ENDIAN ? ENC_BIG_ENDIAN : ENC_LITTLE_ENDIAN;
    const struct _event_col_info *cur_col_info;
    const struct _event_tree_info *cur_tree_info;

    /*** HEURISTICS ***/

    /* Check that the packet is long enough for it to belong to us. */
    if (tvb_reported_length(tvb) < SYSDIG_EVENT_MIN_LENGTH)
        return 0;

    /*** COLUMN DATA ***/

    /*
     * Sysdig uses the term "event" internally. So far every event has been
     * a syscall.
     */
    col_set_str(pinfo->cinfo, COL_PROTOCOL, "System Call");

    col_clear(pinfo->cinfo, COL_INFO);
    col_add_str(pinfo->cinfo, COL_INFO, val_to_str(event_type, event_type_vals, "Unknown syscall %u"));
    /*
     * XXX We can ditch this in favor of a simple index when event_col_info
     * is contiguous and in the correct order.
     */
    for (cur_col_info = event_col_info; cur_col_info->params; cur_col_info++) {
        if (cur_col_info->event_type == event_type) {
            const struct _event_col_info_param *cur_param = cur_col_info->params;
            int param_offset = cur_col_info->num_len_fields * 2;

            /* Find the data offset */
            int cur_len_field;
            for (cur_len_field = 0;
                 cur_len_field < cur_col_info->num_len_fields && cur_param->param_name;
                 cur_len_field++) {
                unsigned param_len = tvb_get_guint16(tvb, cur_len_field * 2, encoding);
                if (cur_param->param_num == cur_len_field) {
                    col_append_fstr(pinfo->cinfo, COL_INFO, ", %s=", cur_param->param_name);
                    switch (cur_param->param_ftype) {
                    case FT_STRING:
                        col_append_str(pinfo->cinfo, COL_INFO, format_param_str(tvb, param_offset, param_len));
                        break;
                    case FT_UINT64:
                        col_append_fstr(pinfo->cinfo, COL_INFO, "%" G_GUINT64_FORMAT, tvb_get_guint64(tvb, param_offset, encoding));
                    default:
                        break;
                    }
                    cur_param++;
                }
                param_offset += param_len;
            }
        }
    }

    /*** PROTOCOL TREE ***/

    /* create display subtree for the protocol */
    ti = proto_tree_add_item(tree, proto_sysdig_event, tvb, 0, -1, ENC_NA);

    se_tree = proto_item_add_subtree(ti, ett_sysdig_event);

    proto_tree_add_uint(se_tree, hf_se_cpu_id, tvb, 0, 0, pinfo->phdr->pseudo_header.sysdig_event.cpu_id);
    proto_tree_add_uint64(se_tree, hf_se_thread_id, tvb, 0, 0, pinfo->phdr->pseudo_header.sysdig_event.thread_id);
    proto_tree_add_uint(se_tree, hf_se_event_length, tvb, 0, 0, pinfo->phdr->pseudo_header.sysdig_event.event_len);
    ti = proto_tree_add_uint(se_tree, hf_se_event_type, tvb, 0, 0, event_type);

    syscall_tree = proto_item_add_subtree(ti, ett_sysdig_syscall);

    for (cur_tree_info = event_tree_info; cur_tree_info->hf_indexes; cur_tree_info++) {
        if (cur_tree_info->event_type == event_type) {
            dissect_event_params(tvb, 0, syscall_tree, encoding, cur_tree_info->hf_indexes);
            break;
        }
    }

    /* XXX */
    /* return offset; */
    return pinfo->phdr->pseudo_header.sysdig_event.event_len;
}

/* Register the protocol with Wireshark.
 *
 * This format is require because a script is used to build the C function that
 * calls all the protocol registration.
 */
void
proto_register_sysdig_event(void)
{
    /* XXX Match up with Sysdig's names. */
    static hf_register_info hf[] = {
        { &hf_se_cpu_id,
          { "CPU ID", "sysdig.cpu_id",
            FT_UINT16, BASE_DEC, NULL, 0, NULL, HFILL }
        },
        { &hf_se_thread_id,
          { "Thread ID", "sysdig.thread_id",
            FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL }
        },
        { &hf_se_event_length,
          { "Event length", "sysdig.event_len",
            FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL }
        },
        { &hf_se_event_type,
          { "Event type", "sysdig.event_type",
            FT_UINT16, BASE_DEC, VALS(event_type_vals), 0, NULL, HFILL }
        },
        { &hf_se_param_lens,
          { "Parameter lengths", "sysdig.param.lens",
            FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL }
        },
        { &hf_se_param_len,
          { "Parameter length", "sysdig.param.len",
            FT_UINT16, BASE_DEC, NULL, 0, NULL, HFILL }
        },

/* Header field registration. Automatically generated by tools/generate-sysdig-event.py */
        { &hf_param_ID_bytes, { "ID", "sysdig.param.syscall.ID", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_action_uint32, { "action", "sysdig.param.cpu_hotplug.action", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_addr_bytes, { "addr", "sysdig.param.ptrace.addr", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_addr_uint64, { "addr", "sysdig.param.munmap.addr", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_args_string, { "Program arguments", "sysdig.param.execve.args", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_argument_uint64, { "I/O control: argument", "sysdig.param.ioctl.argument", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_backlog_uint32, { "backlog", "sysdig.param.listen.backlog", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cgroups_bytes, { "cgroups", "sysdig.param.execve.cgroups", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_clockid_uint8, { "clockid", "sysdig.param.timerfd_create.clockid", FT_UINT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cmd_bytes, { "cmd", "sysdig.param.semctl.cmd", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_comm_string, { "Command", "sysdig.param.execve.comm", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_cpu_sys_uint64, { "cpu_sys", "sysdig.param.procinfo.cpu_sys", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cpu_uint32, { "cpu", "sysdig.param.cpu_hotplug.cpu", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cpu_usr_uint64, { "cpu_usr", "sysdig.param.procinfo.cpu_usr", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cur_int64, { "cur", "sysdig.param.setrlimit.cur", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_cwd_string, { "Current working directory", "sysdig.param.execve.cwd", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_data_bytes, { "data", "sysdig.param.ptrace.data", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dev_string, { "dev", "sysdig.param.mount.dev", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dir_string, { "dir", "sysdig.param.mount.dir", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dirfd_int64, { "dirfd", "sysdig.param.unlinkat.dirfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_domain_bytes, { "domain", "sysdig.param.socketpair.domain", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dpid_bytes, { "dpid", "sysdig.param.signaldeliver.dpid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_bhardlimit_uint64, { "dqb_bhardlimit", "sysdig.param.quotactl.dqb_bhardlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_bsoftlimit_uint64, { "dqb_bsoftlimit", "sysdig.param.quotactl.dqb_bsoftlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_btime_bytes, { "dqb_btime", "sysdig.param.quotactl.dqb_btime", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_curspace_uint64, { "dqb_curspace", "sysdig.param.quotactl.dqb_curspace", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_ihardlimit_uint64, { "dqb_ihardlimit", "sysdig.param.quotactl.dqb_ihardlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_isoftlimit_uint64, { "dqb_isoftlimit", "sysdig.param.quotactl.dqb_isoftlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_dqb_itime_bytes, { "dqb_itime", "sysdig.param.quotactl.dqb_itime", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dqi_bgrace_bytes, { "dqi_bgrace", "sysdig.param.quotactl.dqi_bgrace", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dqi_flags_bytes, { "dqi_flags", "sysdig.param.quotactl.dqi_flags", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_dqi_igrace_bytes, { "dqi_igrace", "sysdig.param.quotactl.dqi_igrace", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_egid_bytes, { "egid", "sysdig.param.getresgid.egid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_env_string, { "env", "sysdig.param.execve.env", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_euid_bytes, { "euid", "sysdig.param.getresuid.euid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_event_data_uint64, { "event_data", "sysdig.param.sysdigevent.event_data", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_event_type_uint32, { "event_type", "sysdig.param.sysdigevent.event_type", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_exe_string, { "exe", "sysdig.param.execve.exe", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_fd1_int64, { "fd1", "sysdig.param.pipe.fd1", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fd2_int64, { "fd2", "sysdig.param.pipe.fd2", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fd_in_int64, { "fd_in", "sysdig.param.splice.fd_in", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fd_int64, { "fd", "sysdig.param.accept.fd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fd_out_int64, { "fd_out", "sysdig.param.splice.fd_out", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fdlimit_int64, { "fdlimit", "sysdig.param.vfork.fdlimit", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fdlimit_uint64, { "fdlimit", "sysdig.param.execve.fdlimit", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_fds_bytes, { "fds", "sysdig.param.ppoll.fds", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_flags_bytes, { "flags", "sysdig.param.umount.flags", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_flags_uint32, { "flags", "sysdig.param.accept.flags", FT_UINT32, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_gid_bytes, { "gid", "sysdig.param.getgid.gid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_gid_uint32, { "gid", "sysdig.param.vfork.gid", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_how_bytes, { "how", "sysdig.param.shutdown.how", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_id_string, { "id", "sysdig.param.container.id", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_id_uint32, { "id", "sysdig.param.quotactl.id", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_image_string, { "image", "sysdig.param.container.image", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_in_fd_int64, { "in_fd", "sysdig.param.sendfile.in_fd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_initval_uint64, { "initval", "sysdig.param.eventfd.initval", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_ino_uint64, { "ino", "sysdig.param.pipe.ino", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_interval_bytes, { "interval", "sysdig.param.nanosleep.interval", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_length_uint64, { "length", "sysdig.param.munmap.length", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_linkdirfd_int64, { "linkdirfd", "sysdig.param.symlinkat.linkdirfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_linkpath_string, { "linkpath", "sysdig.param.symlinkat.linkpath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_mask_uint32, { "mask", "sysdig.param.signalfd.mask", FT_UINT32, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_max_int64, { "max", "sysdig.param.setrlimit.max", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_maxevents_bytes, { "maxevents", "sysdig.param.epoll_wait.maxevents", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_mode_uint32, { "mode", "sysdig.param.openat.mode", FT_UINT32, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_name_string, { "name", "sysdig.param.umount.name", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_nativeID_uint16, { "nativeID", "sysdig.param.syscall.nativeID", FT_UINT16, BASE_DEC, VALS(nativeID_uint16_vals), 0, NULL, HFILL } },
        { &hf_param_newcur_int64, { "newcur", "sysdig.param.prlimit.newcur", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newdir_int64, { "newdir", "sysdig.param.linkat.newdir", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newdirfd_int64, { "newdirfd", "sysdig.param.renameat.newdirfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newmax_int64, { "newmax", "sysdig.param.prlimit.newmax", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_newpath_string, { "newpath", "sysdig.param.renameat.newpath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_next_bytes, { "next", "sysdig.param.switch.next", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_nsops_uint32, { "nsops", "sysdig.param.semop.nsops", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_nstype_bytes, { "nstype", "sysdig.param.setns.nstype", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_offset_uint64, { "offset", "sysdig.param.sendfile.offset", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_oldcur_int64, { "oldcur", "sysdig.param.prlimit.oldcur", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_olddir_int64, { "olddir", "sysdig.param.linkat.olddir", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_olddirfd_int64, { "olddirfd", "sysdig.param.renameat.olddirfd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_oldmax_int64, { "oldmax", "sysdig.param.prlimit.oldmax", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_oldpath_string, { "oldpath", "sysdig.param.renameat.oldpath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_op_bytes, { "op", "sysdig.param.futex.op", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_operation_bytes, { "operation", "sysdig.param.flock.operation", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_out_fd_int64, { "out_fd", "sysdig.param.sendfile.out_fd", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_path_string, { "path", "sysdig.param.unlink.path", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_peer_uint64, { "peer", "sysdig.param.socketpair.peer", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_pgft_maj_uint64, { "pgft_maj", "sysdig.param.execve.pgft_maj", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pgft_min_uint64, { "pgft_min", "sysdig.param.execve.pgft_min", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pgoffset_uint64, { "pgoffset", "sysdig.param.mmap2.pgoffset", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_pid_bytes, { "pid", "sysdig.param.execve.pid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_pos_uint64, { "pos", "sysdig.param.pwritev.pos", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_prot_bytes, { "prot", "sysdig.param.mmap2.prot", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_proto_uint32, { "proto", "sysdig.param.socketpair.proto", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_ptid_bytes, { "ptid", "sysdig.param.execve.ptid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_queuelen_uint32, { "queuelen", "sysdig.param.accept.queuelen", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_queuemax_uint32, { "queuemax", "sysdig.param.accept.queuemax", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_queuepct_uint8, { "Accept queue per connection", "sysdig.param.accept.queuepct", FT_UINT8, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_quota_fmt_bytes, { "quota_fmt", "sysdig.param.quotactl.quota_fmt", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_quota_fmt_out_bytes, { "quota_fmt_out", "sysdig.param.quotactl.quota_fmt_out", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_quotafilepath_string, { "quotafilepath", "sysdig.param.quotactl.quotafilepath", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_ratio_uint32, { "ratio", "sysdig.param.drop.ratio", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_request_bytes, { "request", "sysdig.param.ptrace.request", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_request_uint64, { "I/O control: request", "sysdig.param.ioctl.request", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_res_bytes, { "res", "sysdig.param.umount.res", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_res_int64, { "res", "sysdig.param.fcntl.res", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_res_uint64, { "res", "sysdig.param.mmap2.res", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_resource_bytes, { "resource", "sysdig.param.prlimit.resource", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_rgid_bytes, { "rgid", "sysdig.param.getresgid.rgid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_ruid_bytes, { "ruid", "sysdig.param.getresuid.ruid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_flg_0_bytes, { "sem_flg_0", "sysdig.param.semop.sem_flg_0", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_flg_1_bytes, { "sem_flg_1", "sysdig.param.semop.sem_flg_1", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_num_0_uint16, { "sem_num_0", "sysdig.param.semop.sem_num_0", FT_UINT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_num_1_uint16, { "sem_num_1", "sysdig.param.semop.sem_num_1", FT_UINT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_op_0_int16, { "sem_op_0", "sysdig.param.semop.sem_op_0", FT_INT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sem_op_1_int16, { "sem_op_1", "sysdig.param.semop.sem_op_1", FT_INT16, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_semid_int32, { "semid", "sysdig.param.semctl.semid", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_semnum_int32, { "semnum", "sysdig.param.semctl.semnum", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_sgid_bytes, { "sgid", "sysdig.param.getresgid.sgid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_sig_bytes, { "sig", "sysdig.param.signaldeliver.sig", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_sigmask_bytes, { "sigmask", "sysdig.param.ppoll.sigmask", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_size_uint32, { "size", "sysdig.param.pwritev.size", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_size_uint64, { "size", "sysdig.param.sendfile.size", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_source_uint64, { "source", "sysdig.param.socketpair.source", FT_UINT64, BASE_HEX, NULL, 0, NULL, HFILL } },
        { &hf_param_special_string, { "special", "sysdig.param.quotactl.special", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_spid_bytes, { "spid", "sysdig.param.signaldeliver.spid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_status_bytes, { "status", "sysdig.param.procexit.status", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_suid_bytes, { "suid", "sysdig.param.getresuid.suid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_target_string, { "target", "sysdig.param.symlinkat.target", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_tid_bytes, { "tid", "sysdig.param.execve.tid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_timeout_bytes, { "timeout", "sysdig.param.ppoll.timeout", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_timeout_int64, { "timeout", "sysdig.param.poll.timeout", FT_INT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_tuple_bytes, { "tuple", "sysdig.param.accept.tuple", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_type_bytes, { "type", "sysdig.param.quotactl.type", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_type_string, { "type", "sysdig.param.mount.type", FT_STRING, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_type_uint32, { "type", "sysdig.param.container.type", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_uid_bytes, { "uid", "sysdig.param.getuid.uid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_uid_uint32, { "uid", "sysdig.param.vfork.uid", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_val_int32, { "val", "sysdig.param.semctl.val", FT_INT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_val_uint64, { "val", "sysdig.param.futex.val", FT_UINT64, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_vm_rss_uint32, { "vm_rss", "sysdig.param.execve.vm_rss", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_vm_size_uint32, { "vm_size", "sysdig.param.execve.vm_size", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_vm_swap_uint32, { "vm_swap", "sysdig.param.execve.vm_swap", FT_UINT32, BASE_DEC, NULL, 0, NULL, HFILL } },
        { &hf_param_vpid_bytes, { "vpid", "sysdig.param.vfork.vpid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_vtid_bytes, { "vtid", "sysdig.param.vfork.vtid", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },
        { &hf_param_whence_bytes, { "whence", "sysdig.param.llseek.whence", FT_BYTES, BASE_NONE, NULL, 0, NULL, HFILL } },

    };

    /* Setup protocol subtree array */
    static gint *ett[] = {
        &ett_sysdig_event,
        &ett_sysdig_parm_lens,
        &ett_sysdig_syscall
    };

    /* Register the protocol name and description */
    proto_sysdig_event = proto_register_protocol("Sysdig System Call",
            "Sysdig Event", "sysdig");

    /* Required function calls to register the header fields and subtrees */
    proto_register_field_array(proto_sysdig_event, hf, array_length(hf));
    proto_register_subtree_array(ett, array_length(ett));

    register_dissector("sysdig", dissect_sysdig_event, proto_sysdig_event);
}

#define BLOCK_TYPE_SYSDIG_EVENT 0x00000204
void
proto_reg_handoff_sysdig_event(void)
{
    dissector_handle_t sysdig_event_handle;

    /* Use create_dissector_handle() to indicate that dissect_sysdig_event()
     * returns the number of bytes it dissected (or 0 if it thinks the packet
     * does not belong to PROTONAME).
     */
    sysdig_event_handle = create_dissector_handle(dissect_sysdig_event,
            proto_sysdig_event);
    dissector_add_uint("pcapng.block_type", BLOCK_TYPE_SYSDIG_EVENT, sysdig_event_handle);
}

/*
 * Editor modelines  -  https://www.wireshark.org/tools/modelines.html
 *
 * Local variables:
 * c-basic-offset: 4
 * tab-width: 8
 * indent-tabs-mode: nil
 * End:
 *
 * vi: set shiftwidth=4 tabstop=8 expandtab:
 * :indentSize=4:tabSize=8:noTabs=true:
 */
