{
	"translatorID": "73be930f-5773-41b2-a7a1-37c0eeade92f",
	"label": "OZON.ru",
	"creator": "Mikhail Akimov",
	"target": "^https?://www\\.ozon\\.ru/context/detail/id/",
	"minVersion": "2.1.9",
	"maxVersion": "",
	"priority": 100,
	"inRepository": true,
	"translatorType": 4,
	"browserSupport": "gcsibv",
	"lastUpdated": "2015-10-07 13:03:19"
}

/*
	OZON.ru Translator
	Copyright (C) 2015 Mikhail Akimov

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU Affero General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Affero General Public License for more details.

	You should have received a copy of the GNU Affero General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

function detectWeb(doc, url) {
	var hasIsbn = ZU.xpathText(doc, '//*[@itemprop="isbn"]') !== null;
	var hasContent = ZU.xpath(doc, '//div[@class="bContentBlock"]').length > 0;

	if (hasContent && hasIsbn) return 'book';
}

function doWeb(doc, url) {
	var book = new Zotero.Item('book');

	var content = ZU.xpath(doc, '//div[@class="bContentBlock"]')[0];

	// basic info
	book.title = ZU.xpathText(content, './h1[@itemprop="name"]');

	book.publisher = ZU.xpathText(content, './/*[@itemprop="publisher"]/a');
	book.numPages = ZU.xpathText(content, './/*[@itemprop="numberOfPages"]');


	var isbnField = ZU.xpathText(content, './/*[@itemprop="isbn"]');
	var isbnRe = /[\d\-]{9,}/g;
	var isbn;
	book.ISBN = [];
	if (isbnField !== null) {
		while ((isbn = isbnRe.exec(isbnField)) !== null) {
			book.ISBN.push(ZU.cleanISBN(isbn[0]));
		}
		book.date = /\d{4}(?=\sг\.)/.exec(isbnField)[0];
	}
	book.ISBN = book.ISBN.join(' ');

	// volume (parsed from the title)
	var volume = /(т(\.|ом)|vol(\.|ume))\s+(\d+)/i.exec(book.title);
	if (volume !== null) book.volume = volume[4];

	// language
	var language = ZU.xpathText(content, './/*[@itemprop="inLanguage"]');
	if (language !== null) book.language = encodeLanguage(language);

	// description
	book.abstractNote = ZU.xpathText(doc, '//*[@itemprop="description"]//td[1]')
		.replace(/От производителя\s*/, '');

	// authors
	var authors = ZU.xpath(content, './/*[@itemprop="author"]/a/text()');
	book.creators = authors.map(function(d, i) {
		return ZU.cleanAuthor(d.textContent, 'author', false);
	});

	// translators, editors, etc.
	var additionalProperties = ZU.xpath(content, './/p[not(@itemprop)]').map(getAdditionalProperty);
	var techProperties = ZU.xpath(content, './/div[@class="bTechDescription"]/div[@class="bTechCover "]').map(getTechProperty);
	additionalProperties = additionalProperties.concat(techProperties);

	for (var i = 0; i < additionalProperties.length; i++) {
		var property = additionalProperties[i];
		if (typeof property === 'undefined') continue;
		if (/Переводчики?/.test(property.name)) {
			book.creators = book.creators.concat(getMultipleCreators(property.value, 'translator'));
		}
		if (/(Редакторы?|Составител[ьи])/.test(property.name)) {
			book.creators = book.creators.concat(getMultipleCreators(property.value, 'editor'));
		}
		if (property.name === 'Серия') book.series = property.value;
	}

	book.complete();
}

function getAdditionalProperty(element) {
	// cyrillic alphabet
	var matches = /[\u0410-\u044fёЁ]+(?=:)/.exec(element.textContent);
	if (matches === null) return undefined;
	var propertyName = matches[0];
	var propertyValue = ZU.xpathText(element, './a/@title');

	return {
		name: propertyName,
		value: propertyValue
	}
}

function getTechProperty(element) {
	return {
		name: ZU.xpathText(element, './div[@class="bTechName"]'),
		value: ZU.xpathText(element, './div[@class="bTechDescr"]')
	}
}

function getMultipleCreators(value, creatorType) {
	return value.split(',')
		.map(function (d) {
			return ZU.cleanAuthor(d, creatorType, false);
		});
}

function encodeLanguage(name) {
	var codes = {
		'русский': 'ru',
		'английский': 'en',
		'французский': 'fr',
		'немецкий': 'de',
		'итальянский': 'it',
		'испанский': 'es'
	}
	// return first matching code
	for (key in codes) {
		if (name.toLowerCase().indexOf(key) > -1) {
			return codes[key];
		}
	}
	// or null
	return null;
}


/** BEGIN TEST CASES **/
var testCases = [
	{
		"type": "web",
		"url": "http://www.ozon.ru/context/detail/id/87889/",
		"items": [
			{
				"itemType": "book",
				"title": "Язык программирования C++",
				"creators": [
					{
						"firstName": "Бьерн",
						"lastName": "Страуструп",
						"creatorType": "author"
					}
				],
				"date": "1999",
				"ISBN": "9785794000313 9785798901272 9780201889543",
				"abstractNote": "Книга Бьерна Страуструпа является каноническим изложением возможностей С++, написанным автором этого популярнейшего языка программирования. Помимо подробного описания самого языка, на страницах книги вы найдете множество доказавших свою эффективность подходов к решению разнообразных задач программирования и проектирования. Многочисленные примеры демонстрируют как хороший стиль программирования на С - совместимом ядре С++, так и современный объектно - ориентированный подход к созданию программных продуктов. Данное третье издание бестселлера было существенно переработано автором. С одной стороны, результатом этой переработки стала большая доступность книги для новичков. С другой стороны, текст обогатился сведениями и техниками программирования, которые могут оказаться полезными даже для многоопытных специалистов по С++. Разумеется, не обойдены вниманием и нововведения языка: стандартная библиотека шаблонов (STL), пространства имен (namespaces), механизм идентификации типов во время выполнения (RTTI), явныеприведения типов (cast - операторы) и другие. Книга адресована программистам, использующим в своей повседневной работе С++. Она также будет полезна преподавателям, студентам и всем, кто хочет ознакомиться с описанием языка `из первых рук`.",
				"language": "ru",
				"libraryCatalog": "OZON.ru",
				"numPages": "991",
				"publisher": "Бином, Невский Диалект",
				"attachments": [],
				"tags": [],
				"notes": [],
				"seeAlso": []
			}
		]
	},
	{
		"type": "web",
		"url": "http://www.ozon.ru/context/detail/id/87972/",
		"items": [
			{
				"itemType": "book",
				"title": "Объектно - ориентированный анализ и проектирование с примерами приложений на С++",
				"creators": [
					{
						"firstName": "Автор не",
						"lastName": "указан",
						"creatorType": "author"
					},
					{
						"firstName": "Грэди",
						"lastName": "Буч",
						"creatorType": "author"
					},
					{
						"firstName": "Грэди",
						"lastName": "Буч",
						"creatorType": "editor"
					}
				],
				"date": "1998",
				"ISBN": "9780805353402 9785798900671 9785794000177",
				"abstractNote": "Книга Гради Буча, признанного эксперта в области объекто - ориентированной методологии разработки программного обеспечения, содержит классическое изложение вопросов анализа и проектирования сложных систем. В первой части книги автор исследует суть фундаментальных понятий ООП (таких как `класс`, `объект`, `наследование`), анализирует концепции, лежащие в основе объектно - ориентированных языков и методик разработки. Вторая часть содержит подробное описание обозначений (известных как `нотация Буча`), давноуже ставших родными для тысяч разработчиков во всем мире. Здесь же автор делится своим богатым опытом организации процесса разработки программ, дает рекомендации по подбору команды и планированию промежуточных релизов. В третьей части изложенные ранее методы применяются для анализа и проектирования нескольких приложений. На глазах у читателя создается каркас соответствующих систем, принимаются принципиальные проектные решения. Книга будет полезна аналитикам и разработчикам программного обеспечения, преподавателям и студентам высших учебных заведений. По сравнению с первым изданием книга несколько дополнена (что отразилось и в названии), все примеры приведены на языке С++.",
				"language": "ru",
				"libraryCatalog": "OZON.ru",
				"numPages": "560",
				"publisher": "Бином, Невский Диалект",
				"attachments": [],
				"tags": [],
				"notes": [],
				"seeAlso": []
			}
		]
	},
	{
		"type": "web",
		"url": "http://www.ozon.ru/context/detail/id/117417/",
		"items": [
			{
				"itemType": "book",
				"title": "Применение UML и шаблонов проектирования. Введение в объектно-ориентированный анализ и проектирование",
				"creators": [
					{
						"firstName": "Крэг",
						"lastName": "Ларман",
						"creatorType": "author"
					}
				],
				"date": "2001",
				"ISBN": "9785845901255 9780137488803",
				"abstractNote": "Те, кто еще не знакомы с вопросами объектно-ориентированного анализа и проектирования, наверняка планируют освоить эту область знаний. Данная книга станет хорошим путеводителем и позволит шаг за шагом пройти путь от определения требований к системе до создания кода. В книге рассматривается унифицированный язык моделирования UML, который является признанным стандартом для описания моделей и обеспечивает возможность общения между разработчиками. Для иллюстрации всего процесса объектно-ориентированного анализа и проектирования в книге приводится исчерпывающее описание реального примера. В нем показано, как перейти от этапа объектно-ориентированного проектирования к созданию кода на языке Java. Книга рассчитана на читателей с различным уровнем подготовки, интересующихся вопросами объектно-ориентированного анализа и проектирования.",
				"language": "ru",
				"libraryCatalog": "OZON.ru",
				"numPages": "496",
				"publisher": "Вильямс",
				"attachments": [],
				"tags": [],
				"notes": [],
				"seeAlso": []
			}
		]
	},
	{
		"type": "web",
		"url": "http://www.ozon.ru/context/detail/id/1335648/",
		"items": [
			{
				"itemType": "book",
				"title": "Искусство программирования. Том 1. Основные алгоритмы",
				"creators": [
					{
						"firstName": "Дональд Эрвин",
						"lastName": "Кнут",
						"creatorType": "author"
					},
					{
						"firstName": "С.",
						"lastName": "Тригуб",
						"creatorType": "translator"
					},
					{
						"firstName": "Ю.",
						"lastName": "Гордиенко",
						"creatorType": "translator"
					},
					{
						"firstName": "И.",
						"lastName": "Красикова",
						"creatorType": "translator"
					},
					{
						"firstName": "Ю.",
						"lastName": "Козаченко",
						"creatorType": "editor"
					}
				],
				"date": "2015",
				"ISBN": "9785845919847 9785845900807 9780201896831",
				"abstractNote": "Первый том серии книг \"Искусство программирования\" начинается с описания основных понятий и методов программирования. Затем автор сосредоточивается на рассмотрении информационных структур - представлении информации внутри компьютера, структурных связях между элементами данных и способах эффективной работы с ними. Для методов имитации, символьных вычислений, числовых методов и методов разработки программного обеспечения даны примеры элементарных приложений. По сравнению с предыдущим изданием добавлены десятки простых, но в то же время очень важных алгоритмов. В соответствии с современными направлениями исследований был существенно переработан также раздел математического введения.",
				"language": "ru",
				"libraryCatalog": "OZON.ru",
				"numPages": "720",
				"publisher": "Вильямс",
				"series": "Искусство программирования",
				"volume": "1",
				"attachments": [],
				"tags": [],
				"notes": [],
				"seeAlso": []
			}
		]
	},
	{
		"type": "web",
		"url": "http://www.ozon.ru/context/detail/id/5531965/",
		"items": [
			{
				"itemType": "book",
				"title": "Алгоритмы на C++",
				"creators": [
					{
						"firstName": "Роберт",
						"lastName": "Седжвик",
						"creatorType": "author"
					},
					{
						"firstName": "А.",
						"lastName": "Моргунов",
						"creatorType": "translator"
					}
				],
				"date": "2011",
				"ISBN": "9785845916501 9780321606334",
				"abstractNote": "Роберт Седжвик тщательно переписал, существенно расширил и обновил свою популярную книгу, чтобы получилось современное и исчерпывающее описание важных алгоритмов и структур данных. Вместе с Кристофером Ван Виком он разработал новые реализации на C++, которые выражают эти методы в сжатом, но наглядном виде, а также предоставляют программистам практические средства для их проверки в реальных приложениях.  В книге представлено много новых алгоритмов, а их объяснения гораздо более подробны, чем в предыдущем издании. Новая структура текста и подробные иллюстрации к нему вместе с сопутствующими комментариями значительно улучшают представление материала. Третье издание также содержит удачное сочетание теории и практики, которые делают работу Седжвика бесценным источником сведений для более чем 250 000 программистов!  В частях 1–4 книги рассматриваются фундаментальные алгоритмы, структуры данных, сортировка и поиск. В ней приведено подробное описание фундаментальных структур данных и алгоритмов для сортировки, поиска и сопутствующих приложений. Хотя, по сути, материал книги применим к программированию на любом языке, реализации Ван Вика и Седжвика используют естественную связь между классами C++ и реализациями абстрактных типов данных (АТД). В части 5 книги рассматриваются алгоритмы на графах, которые играют все более важную роль во множестве приложений, таких как сетевая связность, конструирование электронных схем, составление графиков, обработка транзакций и выделение ресурсов. Каждая часть содержит новые алгоритмы и реализации, усовершенствованные описания и диаграммы, а также множество новых упражнений для лучшего усвоения материала. Акцент на АТД расширяет диапазон применения программ и лучше соотносится с современными средами объектно-ориентированного программирования.  В этой книге описаны следующие темы   Подробное описание массивов, связных списков, строк, деревьев и других базовых структур данных Акцентирование внимание на абстрактных типах данных (АТД), модульном программировании, объектно-ориентированном программировании и классах C++ Более 100 алгоритмов сортировки, выбора, реализаций АТД очереди с приоритетами и реализаций АТД таблицы символов (для поиска) Новые реализации биномиальных очередей, многопутевой поразрядной сортировки, рандомизированных BST-деревьев, скошенных деревьев, слоеных списков, многопутевых trie-деревьев, B-деревьев, расширяемого хеширования и многих других методов Больший объем численных характеристик алгоритмов, позволяющих сравнивать их Более 1000 новых упражнений, которые помогают разобраться в свойствах алгоритмов Полный обзор свойств и типов графов Орграфы и DAG-графы Минимальные остовные деревья Кратчайшие пути Сетевые потоки Диаграммы, примеры кода на C++ и подробные описания алгоритмов  Настоящее издание предоставляет программистам полный инструментальный набор для реализации, отладки и использования алгоритмов в широком диапазоне компьютерных приложений.",
				"language": "ru",
				"libraryCatalog": "OZON.ru",
				"numPages": "1056",
				"publisher": "Вильямс",
				"attachments": [],
				"tags": [],
				"notes": [],
				"seeAlso": []
			}
		]
	},
	{
		"type": "web",
		"url": "http://www.ozon.ru/context/detail/id/2527036/",
		"items": [
			{
				"itemType": "book",
				"title": "Искусство программирования. Том 3. Сортировка и поиск",
				"creators": [
					{
						"firstName": "Дональд Эрвин",
						"lastName": "Кнут",
						"creatorType": "author"
					},
					{
						"firstName": "В.",
						"lastName": "Тертышный",
						"creatorType": "translator"
					},
					{
						"firstName": "Игорь",
						"lastName": "Красиков",
						"creatorType": "translator"
					}
				],
				"date": "2012",
				"ISBN": "9785845900821 9780201896855",
				"abstractNote": "Во втором издании третьего тома содержится полный обзор классических алгоритмов сортировки и поиска. Представленная в нем информация дополняет приведенное в первом томе обсуждение структур данных. Автор рассматривает принципы построения больших и малых баз данных, а также внутренней и внешней памяти. В книге приведена подборка тщательно проверенных компьютерных алгоритмов и представлен анализ их эффективности. Кроме того, специальный раздел посвящен методам оптимальной сортировки и описанию новой теории перестановки и универсального хеширования.",
				"language": "ru",
				"libraryCatalog": "OZON.ru",
				"numPages": "824",
				"publisher": "Вильямс",
				"series": "Искусство программирования",
				"volume": "3",
				"attachments": [],
				"tags": [],
				"notes": [],
				"seeAlso": []
			}
		]
	},
	{
		"type": "web",
		"url": "http://www.ozon.ru/context/detail/id/23968713/",
		"items": [
			{
				"itemType": "book",
				"title": "Алгоритмические трюки для программистов",
				"creators": [
					{
						"firstName": "Генри С. Уоррен",
						"lastName": "мл",
						"creatorType": "author"
					},
					{
						"firstName": "Игорь",
						"lastName": "Красиков",
						"creatorType": "translator"
					}
				],
				"date": "2014",
				"ISBN": "9785845918383",
				"abstractNote": "Книга \"Алгоритмические трюки для программистов\" позволит повысить квалификацию профессиональному программисту, но при этом книга будет понятна и чрезвычайно полезна даже начинающему и даже студенту, тем более что в новом издании появилась масса упражнений, интересных как с теоретической, так и с практической точки зрений. Работа программиста всегда немного хакерство, а также смесь арифметики и логики, особенно это касается программиста, который создает элегантный и эффективно работающий код. В этой книге программист-ветеран IBM Генри Уоррен делится с читателями разнообразными приемами из своей коллекции, пополняемой в течение многих десятилетий работы в области разработки компиляторов и архитектуры компьютеров, прикладного и системного программирования. Большинство из них носят практический характер, хотя некоторые представляют в первую очередь теоретический интерес.  Автор книги много лет систематически собирал программные перлы, а затем свел их воедино, организовал и снабдил четким описанием. В этой книге слову \"хакер\" возвращено его первозданное значение - человека увлеченного, талантливого программиста, способного к созданию чрезвычайно эффективного и элегантного кода. В книге воплощен пятидесятилетний стаж ее автора в области разработки компиляторов и архитектуры компьютеров. Здесь вы найдете множество приемов для работы с отдельными битами, байтами, вычисления различных целочисленных функций; большей части материала сопутствует строгое математическое обоснование. Каким бы ни был ваш профессионализм - вы обязательно найдете в этой книге новое для себя; кроме того, книга заставит вас посмотреть на уже знакомые вещи с новой стороны.  В новом издании своей книги автор вновь сумел собрать неотразимую коллекцию программистских трюков, позволяющих программисту писать элегантные и эффективные программы, быстро создавать эффективно работающий код, становясь при этом настоящим, глубоко знающим свое дело профессионалом. Трюки автора в высшей степени практичны, но при этом чрезвычайно интересны, а иногда и просто неожиданны - как решение большой головоломки. Изложенный материал позволит повысить квалификацию даже бывалому программисту, но при этом книга будет понятна и полезна даже начинающему.  Добавления во второе издание включают:   Новую главу, посвященную циклическому избыточному коду (CRC), включая широко используемый код CRC-32.  Новую главу о кодах с коррекцией ошибок (ECC), включая подпрограммы для работы с кодом Хэмминга.   Большее количество материала, посвященного делению на константы, включая методы, использующие только сдвиги и сложения.   Вычисление остатков от деления без вычисления частного.   Более подробное изложение методов подсчета количества единичных битов и ведущих нулевых битов.   Подсчет единичных битов в массивах.   Новые алгоритмы сжатия и расширения.   Алгоритм LRU.   Преобразования между числами с плавающей точкой и целыми числами.   Программу приближенного вычисления обратного к квадратному корню.   Галерею графиков дискретных функций.   Появившиеся во втором издании упражнения и ответы к ним.   Об авторе Генри Уоррен, мл. имеет пятидесятилетний стаж работы в IBM, его деятельность простирается от IBM 704 до PowerPC и далее. Он работал над рядом военных командно-управляющих систем и над проектом SETL под руководством Джека Шварца (Jack Schwartz) из университета Нью-Йорка. С 1973 года Уоррен занимается компиляторами и архитектурой компьютеров в исследовательском подразделении IBM. В настоящее время он работает над проектами суперкомпьютеров, которые должны достичь быстродействия, измеряемого эксафлопсами (EFLOPS). Генри Уоррен получил докторскую степень в области информационных технологий в университете Нью-Йорка.  \"Это первая книга, в которой так глубоко раскрыты секреты компьютерной арифметики. В ней есть все известные мне трюки и множество ранее не известных. Эта книга - настоящая находка для разработчиков библиотек и компиляторов, для всех, кто обожает элегантность в программировании. Место этой книги на полке - рядом с книгами Кнута. Все десять лет, прошедших с выхода первого издания, книга была неоценимым помощником в моей работе в Sun и Google. Я просто дрожу от нетерпения познакомиться с новым материалом во втором издании\".  Джошуа Блох (Joshua Bloch)   \"Впервые увидев эту книгу, я решил, что это не то советы по взлому компьютеров, не то набор мелких программистских трюков. И только познакомившись с ней поближе, я понял, что под ее обложкой скрыта целая компьютерная энциклопедия. Второе издание охватывает две большие новые темы, и расширяет коллекцию десятками новых небольших трюков, включая те, которые я тут же применил на практике - например, вычисление среднего двух целых чисел без риска переполнения. Этот хакер действительно умеет принести удовольствие читателю!\"  Гай Стил (Guy Steele)",
				"language": "ru",
				"libraryCatalog": "OZON.ru",
				"numPages": "512",
				"publisher": "Вильямс",
				"attachments": [],
				"tags": [],
				"notes": [],
				"seeAlso": []
			}
		]
	},
	{
		"type": "web",
		"url": "http://www.ozon.ru/context/detail/id/6037655/",
		"items": [
			{
				"itemType": "book",
				"title": "Клетки",
				"creators": [
					{
						"firstName": "И.",
						"lastName": "Филиппович",
						"creatorType": "translator"
					},
					{
						"firstName": "Юрий",
						"lastName": "Ченцов",
						"creatorType": "translator"
					},
					{
						"firstName": "Бенджамин",
						"lastName": "Льюин",
						"creatorType": "editor"
					},
					{
						"firstName": "Линн",
						"lastName": "Кассимерис",
						"creatorType": "editor"
					},
					{
						"firstName": "Вишванат Р.",
						"lastName": "Лингаппа",
						"creatorType": "editor"
					},
					{
						"firstName": "Джордж",
						"lastName": "Плоппер",
						"creatorType": "editor"
					}
				],
				"date": "2011",
				"ISBN": "9785947747942",
				"abstractNote": "В книге описаны последние достижения в области клеточной биологии. Ее особенностями можно смело назвать наличие многочисленных богатых иллюстраций и хорошо выверенной современной терминологии, четкую структуру и удобное расположение материала.  Важное значение в книге придается обсуждению молекулярных основ заболеваний человека и перспективных направлений исследований в этой области науки.  Для студентов и аспирантов медико-биологических специальностей, начинающих и продолжающих изучение клеточной биологии, а также для исследователей, нуждающихся в современной информации по цитологии, и преподавателей.",
				"language": "ru",
				"libraryCatalog": "OZON.ru",
				"numPages": "952",
				"publisher": "Бином. Лаборатория знаний",
				"series": "Лучший зарубежный учебник",
				"attachments": [],
				"tags": [],
				"notes": [],
				"seeAlso": []
			}
		]
	}
]
/** END TEST CASES **/
