/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.nio.ByteBuffer;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.SessionAtts;

public class NIONSDataChannel
extends NIOPacket {
    int sessionIdSize;

    public NIONSDataChannel(SessionAtts sessionAtts) {
        super(sessionAtts);
        this.header.type = 6;
        this.sessionIdSize = sessionAtts.poolEnabled ? 16 : 0;
    }

    public void readDataFromSocketChannel() throws IOException {
        this.session.payloadDataBuffer.position(this.session.payloadDataBuffer.limit());
        this.readFromSocketChannel(true);
        this.session.payloadDataBuffer.clear();
        this.session.payloadDataBuffer.limit(this.session.payloadBuffer.limit() - 2);
    }

    public void writeDataToSocketChannel() throws IOException {
        this.writeDataToSocketChannel(0);
    }

    public void writeDataToSocketChannel(int n2) throws IOException {
        if (this.session.payloadDataBuffer.position() > 0) {
            this.session.payloadBuffer.clear();
            this.session.payloadBuffer.position(this.session.payloadDataBuffer.position() + 2);
            this.session.payloadBuffer.put(0, (byte)(n2 / 256));
            this.session.payloadBuffer.put(1, (byte)(n2 % 256));
            this.writeToSocketChannel();
        }
        this.session.payloadDataBuffer.clear();
    }

    public ByteBuffer getDataBuffer() {
        return this.session.payloadDataBuffer;
    }

    byte[] readPayloadDataFromSocketChannel(int n2) throws IOException {
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; i2 += n3) {
            this.readDataFromSocketChannel();
            n3 = this.session.payloadDataBuffer.limit();
            this.session.payloadDataBuffer.get(byArray, i2, n3);
        }
        return byArray;
    }

    void writeDataToSocketChannel(byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < byArray.length; i2 += n2) {
            n2 = this.session.payloadDataBuffer.limit() - this.session.payloadDataBuffer.position();
            if (n2 > byArray.length - i2) {
                n2 = byArray.length - i2;
            }
            n3 = byArray.length > n2 ? 32 : 0;
            this.session.payloadDataBuffer.put(byArray, i2, n2);
            this.writeDataToSocketChannel(n3);
        }
    }

    @Override
    void readPayloadBuffer() throws IOException {
        throw new UnsupportedOperationException("Data Byte buffers are not duplicated and accessed directly by the upper layer");
    }
}

