/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.io.File;
import java.util.List;
import picard.PicardException;
import picard.analysis.SinglePassSamProgram;
import picard.cmdline.Option;
import picard.cmdline.Usage;
import picard.util.RExecutor;

public class QualityScoreDistribution
extends SinglePassSamProgram {
    @Usage
    public final String USAGE = this.getStandardUsagePreamble() + "Program to chart " + "quality score distributions in a SAM or BAM file.";
    @Option(shortName="CHART", doc="A file (with .pdf extension) to write the chart to.")
    public File CHART_OUTPUT;
    @Option(doc="If set to true calculate mean quality over aligned reads only.")
    public boolean ALIGNED_READS_ONLY = false;
    @Option(shortName="PF", doc="If set to true calculate mean quality over PF reads only.")
    public boolean PF_READS_ONLY = false;
    @Option(doc="If set to true, include quality for no-call bases in the distribution.")
    public boolean INCLUDE_NO_CALLS = false;
    private final long[] qCounts = new long[128];
    private final long[] oqCounts = new long[128];
    private String plotSubtitle = "";
    private final Log log = Log.getInstance(QualityScoreDistribution.class);

    public static void main(String[] args) {
        System.exit(new QualityScoreDistribution().instanceMain(args));
    }

    @Override
    protected void setup(SAMFileHeader header, File samFile) {
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        IOUtil.assertFileIsWritable((File)this.CHART_OUTPUT);
        List readGroups = header.getReadGroups();
        if (readGroups.size() == 1) {
            this.plotSubtitle = ((SAMReadGroupRecord)readGroups.get(0)).getLibrary();
            if (null == this.plotSubtitle) {
                this.plotSubtitle = "";
            }
        }
    }

    @Override
    protected void acceptRead(SAMRecord rec, ReferenceSequence ref) {
        if (this.PF_READS_ONLY && rec.getReadFailsVendorQualityCheckFlag()) {
            return;
        }
        if (this.ALIGNED_READS_ONLY && rec.getReadUnmappedFlag()) {
            return;
        }
        if (rec.isSecondaryOrSupplementary()) {
            return;
        }
        byte[] bases = rec.getReadBases();
        byte[] quals = rec.getBaseQualities();
        byte[] oq = rec.getOriginalBaseQualities();
        int length = quals.length;
        for (int i = 0; i < length; ++i) {
            if (!this.INCLUDE_NO_CALLS && SequenceUtil.isNoCall((byte)bases[i])) continue;
            byte by = quals[i];
            this.qCounts[by] = this.qCounts[by] + 1L;
            if (oq == null) continue;
            byte by2 = oq[i];
            this.oqCounts[by2] = this.oqCounts[by2] + 1L;
        }
    }

    @Override
    protected void finish() {
        Histogram qHisto = new Histogram("QUALITY", "COUNT_OF_Q");
        Histogram oqHisto = new Histogram("QUALITY", "COUNT_OF_OQ");
        for (int i = 0; i < this.qCounts.length; ++i) {
            if (this.qCounts[i] > 0L) {
                qHisto.increment((Comparable)Byte.valueOf((byte)i), (double)this.qCounts[i]);
            }
            if (this.oqCounts[i] <= 0L) continue;
            oqHisto.increment((Comparable)Byte.valueOf((byte)i), (double)this.oqCounts[i]);
        }
        MetricsFile metrics = this.getMetricsFile();
        metrics.addHistogram(qHisto);
        if (!oqHisto.isEmpty()) {
            metrics.addHistogram(oqHisto);
        }
        metrics.write(this.OUTPUT);
        if (qHisto.isEmpty() && oqHisto.isEmpty()) {
            this.log.warn(new Object[]{"No valid bases found in input file. No plot will be produced."});
        } else {
            int rResult = RExecutor.executeFromClasspath("picard/analysis/qualityScoreDistribution.R", this.OUTPUT.getAbsolutePath(), this.CHART_OUTPUT.getAbsolutePath(), this.INPUT.getName(), this.plotSubtitle);
            if (rResult != 0) {
                throw new PicardException("R script qualityScoreDistribution.R failed with return code " + rResult);
            }
        }
    }
}

