/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.utils.SAMSequenceDictionaryExtractor;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.VcfOrBcf;

@CommandLineProgramProperties(usage="Takes a VCF and a second file that contains a sequence dictionary and updates the VCF with the new sequence dictionary.", usageShort="Takes a VCF and a second file that contains a sequence dictionary and updates the VCF with the new sequence dictionary.", programGroup=VcfOrBcf.class)
public class UpdateVcfSequenceDictionary
extends CommandLineProgram {
    @Option(shortName="I", doc="Input VCF")
    public File INPUT;
    @Option(shortName="O", doc="Output VCF to be written.")
    public File OUTPUT;
    @Option(shortName="SD", doc="A Sequence Dictionary (can be read from one of the following file types (SAM, BAM, VCF, BCF, Interval List, Fasta, or Dict)")
    public File SEQUENCE_DICTIONARY;
    private final Log log = Log.getInstance(UpdateVcfSequenceDictionary.class);

    public static void main(String[] args) {
        new UpdateVcfSequenceDictionary().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable((File)this.INPUT);
        IOUtil.assertFileIsReadable((File)this.SEQUENCE_DICTIONARY);
        IOUtil.assertFileIsWritable((File)this.OUTPUT);
        SAMSequenceDictionary samSequenceDictionary = SAMSequenceDictionaryExtractor.extractDictionary((File)this.SEQUENCE_DICTIONARY);
        VCFFileReader fileReader = new VCFFileReader(this.INPUT, false);
        VCFHeader fileHeader = fileReader.getFileHeader();
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setReferenceDictionary(samSequenceDictionary).clearOptions();
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter vcfWriter = builder.setOutputFile(this.OUTPUT).build();
        fileHeader.setSequenceDictionary(samSequenceDictionary);
        vcfWriter.writeHeader(fileHeader);
        ProgressLogger progress = new ProgressLogger(this.log, 10000);
        CloseableIterator iterator = fileReader.iterator();
        while (iterator.hasNext()) {
            VariantContext context = (VariantContext)iterator.next();
            vcfWriter.add(context);
            progress.record(context.getChr(), context.getStart());
        }
        CloserUtil.close((Object)iterator);
        CloserUtil.close((Object)fileReader);
        vcfWriter.close();
        return 0;
    }
}

