/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.listener;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.lang.ref.WeakReference;
import org.fest.util.VisibleForTesting;

public final class WeakEventListener
implements AWTEventListener {
    private final WeakReference<AWTEventListener> listenerReference;
    private final Toolkit toolkit;

    public static WeakEventListener attachAsWeakEventListener(Toolkit toolkit, AWTEventListener listener, long eventMask) {
        WeakEventListener l = new WeakEventListener(toolkit, listener);
        toolkit.addAWTEventListener(l, eventMask);
        return l;
    }

    private WeakEventListener(Toolkit toolkit, AWTEventListener listener) {
        this.listenerReference = new WeakReference<AWTEventListener>(listener);
        this.toolkit = toolkit;
    }

    public AWTEventListener underlyingListener() {
        return (AWTEventListener)this.listenerReference.get();
    }

    public void eventDispatched(AWTEvent e) {
        AWTEventListener listener = (AWTEventListener)this.listenerReference.get();
        if (listener == null) {
            this.dispose();
            return;
        }
        listener.eventDispatched(e);
    }

    public void dispose() {
        this.toolkit.removeAWTEventListener(this);
    }

    @VisibleForTesting
    void simulateUnderlyingListenerIsGarbageCollected() {
        this.listenerReference.clear();
    }
}

