/**
 * UGENE - Integrated Bioinformatics Tools.
 * Copyright (C) 2008-2013 UniPro <ugene@unipro.ru>
 * http://ugene.unipro.ru
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include "MuscleDialogFiller.h"
#include "api/GTComboBox.h"
#include "api/GTWidget.h"
#include "api/GTCheckBox.h"

#include <QtGui/QApplication>
#include <QtGui/QComboBox>
#include <QtGui/QPushButton>
#include <QtGui/QCheckBox>

namespace U2 {

#define GT_CLASS_NAME "GTUtilsDialog::MuscleDialogFiller"
#define GT_METHOD_NAME "run"

MuscleDialogFiller::MuscleDialogFiller(U2OpStatus &os, Mode _mode, bool _doNotReArr)
    : Filler(os, "MuscleAlignmentDialog"), mode(_mode), doNotReArr(_doNotReArr)
{

}

void MuscleDialogFiller::run(){
    QWidget *dialog = QApplication::activeModalWidget();
    GT_CHECK(dialog != NULL, "dialog not found");

    QComboBox *modeBox = dialog->findChild<QComboBox*>("confBox");
    GT_CHECK(modeBox != NULL, "combobox not found");
    GTComboBox::setCurrentIndex(os, modeBox, mode);

    QCheckBox *stableCB = dialog->findChild<QCheckBox*>("stableCB");
    GTCheckBox::setChecked(os, stableCB, doNotReArr);

    QPushButton *alignButton = dialog->findChild<QPushButton*>(QString::fromUtf8("alignButton"));
    GT_CHECK(alignButton != NULL, "export button not found");
    GTWidget::click(os, alignButton);
}


#undef GT_METHOD_NAME
#undef GT_CLASS_NAME

} //ns
