/*******************************************************************************
 *
 * MIT License
 *
 * Copyright (c) 2017 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 *******************************************************************************/
#ifndef GUARD_MIOPEN_MIOPENGEMM_HPP_
#define GUARD_MIOPEN_MIOPENGEMM_HPP_

#include <miopen/config.h>

#if MIOPEN_USE_MIOPENGEMM
#include <miopengemm/miogemm.hpp>

namespace miopen {

struct Handle;

void AddMiopengemmSolution(const Handle& handle,
                           const std::string& algorithm_name,
                           const std::string& network_config,
                           const MIOpenGEMM::Geometry& mgg,
                           ConstData_t A,
                           ConstData_t B,
                           Data_t C,
                           float time,
                           bool enforce_determinism);

void RunMiopengemmSolution(const Handle& handle,
                           const decltype(handle.GetKernels("_", "_"))& kernels,
                           float alpha,
                           ConstData_t A,
                           int a_offset,
                           ConstData_t B,
                           int b_offset,
                           float beta,
                           Data_t C,
                           int c_offset);

} // namespace miopen
#endif // MIOPEN_USE_MIOPENGEMM

#endif // GUARD_MIOPEN_MIOPENGEMM_HPP_
