# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_field

if TYPE_CHECKING:
    from .. import models as _models


class Capacity(_Model):
    """Capacity for a Resource.

    :ivar min: Minimum Capacity.
    :vartype min: str
    :ivar max: Maximum Capacity.
    :vartype max: str
    :ivar incremental: Units to be increased.
    :vartype incremental: str
    :ivar current: Current Capacity of the resource.
    :vartype current: str
    """

    min: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Minimum Capacity."""
    max: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum Capacity."""
    incremental: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Units to be increased."""
    current: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Current Capacity of the resource."""

    @overload
    def __init__(
        self,
        *,
        min: Optional[str] = None,  # pylint: disable=redefined-builtin
        max: Optional[str] = None,  # pylint: disable=redefined-builtin
        incremental: Optional[str] = None,
        current: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionIdentityProperties(_Model):
    """EncryptionIdentityProperties of Dell FileSystem resource.

    :ivar identity_type: Identity type - SystemAssigned/UserAssigned - Only UserAssigned is
     supported now. Known values are: "SystemAssigned" and "UserAssigned".
    :vartype identity_type: str or ~azure.mgmt.dellstorage.models.EncryptionIdentityType
    :ivar identity_resource_id: User-assigned identity resource id - Only when user opts for
     UserAssigned identity and hence optional.
    :vartype identity_resource_id: str
    """

    identity_type: Optional[Union[str, "_models.EncryptionIdentityType"]] = rest_field(
        name="identityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity type - SystemAssigned/UserAssigned - Only UserAssigned is supported now. Known values
     are: \"SystemAssigned\" and \"UserAssigned\"."""
    identity_resource_id: Optional[str] = rest_field(
        name="identityResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """User-assigned identity resource id - Only when user opts for UserAssigned identity and hence
     optional."""

    @overload
    def __init__(
        self,
        *,
        identity_type: Optional[Union[str, "_models.EncryptionIdentityType"]] = None,
        identity_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionIdentityUpdateProperties(_Model):
    """EncryptionIdentityUpdateProperties of Dell FileSystem resource.

    :ivar identity_type: Identity type - SystemAssigned/UserAssigned - Only UserAssigned is
     supported now. Known values are: "SystemAssigned" and "UserAssigned".
    :vartype identity_type: str or ~azure.mgmt.dellstorage.models.EncryptionIdentityType
    :ivar identity_resource_id: User-assigned identity resource id - Only when user opts for
     UserAssigned identity and hence optional.
    :vartype identity_resource_id: str
    """

    identity_type: Optional[Union[str, "_models.EncryptionIdentityType"]] = rest_field(
        name="identityType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity type - SystemAssigned/UserAssigned - Only UserAssigned is supported now. Known values
     are: \"SystemAssigned\" and \"UserAssigned\"."""
    identity_resource_id: Optional[str] = rest_field(
        name="identityResourceId", visibility=["read", "create", "update", "delete", "query"]
    )
    """User-assigned identity resource id - Only when user opts for UserAssigned identity and hence
     optional."""

    @overload
    def __init__(
        self,
        *,
        identity_type: Optional[Union[str, "_models.EncryptionIdentityType"]] = None,
        identity_resource_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionProperties(_Model):
    """EncryptionProperties of Dell FileSystem resource.

    :ivar encryption_type: Encryption Type - MMK/CMK. Required. Known values are:
     "Microsoft-managed keys (MMK)" and "Customer-managed keys (CMK)".
    :vartype encryption_type: str or ~azure.mgmt.dellstorage.models.ResourceEncryptionType
    :ivar key_url: Versioned Encryption Key Url - Only when user opts for CMK and hence optional.
    :vartype key_url: str
    :ivar encryption_identity_properties: Identity configuration for Customer-managed key settings
     defining which identity should be used to auth to Key Vault - Only when user opts for CMK and
     hence optional.
    :vartype encryption_identity_properties:
     ~azure.mgmt.dellstorage.models.EncryptionIdentityProperties
    """

    encryption_type: Union[str, "_models.ResourceEncryptionType"] = rest_field(
        name="encryptionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption Type - MMK/CMK. Required. Known values are: \"Microsoft-managed keys (MMK)\" and
     \"Customer-managed keys (CMK)\"."""
    key_url: Optional[str] = rest_field(name="keyUrl", visibility=["read", "create", "update", "delete", "query"])
    """Versioned Encryption Key Url - Only when user opts for CMK and hence optional."""
    encryption_identity_properties: Optional["_models.EncryptionIdentityProperties"] = rest_field(
        name="encryptionIdentityProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity configuration for Customer-managed key settings defining which identity should be used
     to auth to Key Vault - Only when user opts for CMK and hence optional."""

    @overload
    def __init__(
        self,
        *,
        encryption_type: Union[str, "_models.ResourceEncryptionType"],
        key_url: Optional[str] = None,
        encryption_identity_properties: Optional["_models.EncryptionIdentityProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EncryptionUpdateProperties(_Model):
    """EncryptionUpdateProperties of Dell FileSystem resource.

    :ivar encryption_type: Encryption Type - MMK/CMK. Known values are: "Microsoft-managed keys
     (MMK)" and "Customer-managed keys (CMK)".
    :vartype encryption_type: str or ~azure.mgmt.dellstorage.models.ResourceEncryptionType
    :ivar key_url: Versioned Encryption Key Url - Only when user opts for CMK and hence optional.
    :vartype key_url: str
    :ivar encryption_identity_properties: Identity configuration for Customer-managed key settings
     defining which identity should be used to auth to Key Vault - Only when user opts for CMK and
     hence optional.
    :vartype encryption_identity_properties:
     ~azure.mgmt.dellstorage.models.EncryptionIdentityUpdateProperties
    """

    encryption_type: Optional[Union[str, "_models.ResourceEncryptionType"]] = rest_field(
        name="encryptionType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption Type - MMK/CMK. Known values are: \"Microsoft-managed keys (MMK)\" and
     \"Customer-managed keys (CMK)\"."""
    key_url: Optional[str] = rest_field(name="keyUrl", visibility=["read", "create", "update", "delete", "query"])
    """Versioned Encryption Key Url - Only when user opts for CMK and hence optional."""
    encryption_identity_properties: Optional["_models.EncryptionIdentityUpdateProperties"] = rest_field(
        name="encryptionIdentityProperties", visibility=["read", "create", "update", "delete", "query"]
    )
    """Identity configuration for Customer-managed key settings defining which identity should be used
     to auth to Key Vault - Only when user opts for CMK and hence optional."""

    @overload
    def __init__(
        self,
        *,
        encryption_type: Optional[Union[str, "_models.ResourceEncryptionType"]] = None,
        key_url: Optional[str] = None,
        encryption_identity_properties: Optional["_models.EncryptionIdentityUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dellstorage.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dellstorage.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.dellstorage.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dellstorage.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dellstorage.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileSystemResource(TrackedResource):
    """Concrete tracked resource types can be created by aliasing this type using a specific property
    type.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.dellstorage.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.dellstorage.models.FileSystemResourceProperties
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.dellstorage.models.ManagedServiceIdentity
    """

    properties: Optional["_models.FileSystemResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    identity: Optional["_models.ManagedServiceIdentity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FileSystemResourceProperties"] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileSystemResourceProperties(_Model):
    """Properties specific to the Dell File System resource.

    :ivar capacity: Capacity for Dell Filesystem, Will be received as part of Job Status.
    :vartype capacity: ~azure.mgmt.dellstorage.models.Capacity
    :ivar marketplace: Marketplace details. Required.
    :vartype marketplace: ~azure.mgmt.dellstorage.models.MarketplaceDetails
    :ivar provisioning_state: Provisioning State of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.dellstorage.models.ProvisioningState
    :ivar delegated_subnet_id: Delegated subnet id for Vnet injection. Required.
    :vartype delegated_subnet_id: str
    :ivar delegated_subnet_cidr: Domain range for the delegated subnet. Required.
    :vartype delegated_subnet_cidr: str
    :ivar user: User Details. Required.
    :vartype user: ~azure.mgmt.dellstorage.models.UserDetails
    :ivar file_system_id: File system Id of the resource.
    :vartype file_system_id: str
    :ivar smart_connect_fqdn: Smart Connect FQDN of the resource.
    :vartype smart_connect_fqdn: str
    :ivar one_fs_url: OneFS url.
    :vartype one_fs_url: str
    :ivar dell_reference_number: DellReferenceNumber of the resource. Required.
    :vartype dell_reference_number: str
    :ivar encryption: EncryptionProperties of the resource. Required.
    :vartype encryption: ~azure.mgmt.dellstorage.models.EncryptionProperties
    """

    capacity: Optional["_models.Capacity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Capacity for Dell Filesystem, Will be received as part of Job Status."""
    marketplace: "_models.MarketplaceDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Marketplace details. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning State of the resource. Known values are: \"Accepted\", \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", \"Failed\", \"Canceled\", \"Deleted\", and \"NotSpecified\"."""
    delegated_subnet_id: str = rest_field(
        name="delegatedSubnetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Delegated subnet id for Vnet injection. Required."""
    delegated_subnet_cidr: str = rest_field(
        name="delegatedSubnetCidr", visibility=["read", "create", "update", "delete", "query"]
    )
    """Domain range for the delegated subnet. Required."""
    user: "_models.UserDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User Details. Required."""
    file_system_id: Optional[str] = rest_field(
        name="fileSystemId", visibility=["read", "create", "update", "delete", "query"]
    )
    """File system Id of the resource."""
    smart_connect_fqdn: Optional[str] = rest_field(
        name="smartConnectFqdn", visibility=["read", "create", "update", "delete", "query"]
    )
    """Smart Connect FQDN of the resource."""
    one_fs_url: Optional[str] = rest_field(name="oneFsUrl", visibility=["read", "create", "update", "delete", "query"])
    """OneFS url."""
    dell_reference_number: str = rest_field(
        name="dellReferenceNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """DellReferenceNumber of the resource. Required."""
    encryption: "_models.EncryptionProperties" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """EncryptionProperties of the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        marketplace: "_models.MarketplaceDetails",
        delegated_subnet_id: str,
        delegated_subnet_cidr: str,
        user: "_models.UserDetails",
        dell_reference_number: str,
        encryption: "_models.EncryptionProperties",
        capacity: Optional["_models.Capacity"] = None,
        file_system_id: Optional[str] = None,
        smart_connect_fqdn: Optional[str] = None,
        one_fs_url: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileSystemResourceUpdate(_Model):
    """The type used for update operations of the FileSystemResource.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity: ~azure.mgmt.dellstorage.models.ManagedServiceIdentityUpdate
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the FileSystemResource.
    :vartype properties: ~azure.mgmt.dellstorage.models.FileSystemResourceUpdateProperties
    """

    identity: Optional["_models.ManagedServiceIdentityUpdate"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The managed service identities assigned to this resource."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    properties: Optional["_models.FileSystemResourceUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The updatable properties of the FileSystemResource."""

    @overload
    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentityUpdate"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FileSystemResourceUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileSystemResourceUpdateProperties(_Model):
    """The updatable properties of the FileSystemResource.

    :ivar delegated_subnet_id: Delegated subnet id for Vnet injection.
    :vartype delegated_subnet_id: str
    :ivar capacity: Capacity for Dell Filesystem.
    :vartype capacity: ~azure.mgmt.dellstorage.models.Capacity
    :ivar encryption: Encryption Details of the resource.
    :vartype encryption: ~azure.mgmt.dellstorage.models.EncryptionUpdateProperties
    """

    delegated_subnet_id: Optional[str] = rest_field(
        name="delegatedSubnetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Delegated subnet id for Vnet injection."""
    capacity: Optional["_models.Capacity"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Capacity for Dell Filesystem."""
    encryption: Optional["_models.EncryptionUpdateProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Encryption Details of the resource."""

    @overload
    def __init__(
        self,
        *,
        delegated_subnet_id: Optional[str] = None,
        capacity: Optional["_models.Capacity"] = None,
        encryption: Optional["_models.EncryptionUpdateProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentity(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar principal_id: The service principal ID of the system assigned identity. This property
     will only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of the system assigned identity. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.dellstorage.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.dellstorage.models.UserAssignedIdentity]
    """

    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The service principal ID of the system assigned identity. This property will only be provided
     for a system assigned identity."""
    tenant_id: Optional[str] = rest_field(name="tenantId", visibility=["read"])
    """The tenant ID of the system assigned identity. This property will only be provided for a system
     assigned identity."""
    type: Union[str, "_models.ManagedServiceIdentityType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Required. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedServiceIdentityUpdate(_Model):
    """Managed service identity (system assigned and/or user assigned identities).

    :ivar type: The type of managed identity assigned to this resource. Known values are: "None",
     "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.dellstorage.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.dellstorage.models.UserAssignedIdentity]
    """

    type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of managed identity assigned to this resource. Known values are: \"None\",
     \"SystemAssigned\", \"UserAssigned\", and \"SystemAssigned,UserAssigned\"."""
    user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = rest_field(
        name="userAssignedIdentities", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identities assigned to this resource by the user."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedServiceIdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MarketplaceDetails(_Model):
    """MarketplaceDetails of Dell FileSystem resource.

    :ivar marketplace_subscription_id: Marketplace Subscription Id.
    :vartype marketplace_subscription_id: str
    :ivar plan_id: Plan Id. Required.
    :vartype plan_id: str
    :ivar offer_id: Offer Id. Required.
    :vartype offer_id: str
    :ivar publisher_id: Publisher Id.
    :vartype publisher_id: str
    :ivar private_offer_id: Private Offer Id.
    :vartype private_offer_id: str
    :ivar plan_name: Plan Name. Required.
    :vartype plan_name: str
    :ivar marketplace_subscription_status: Marketplace subscription status. Known values are:
     "PendingFulfillmentStart", "Subscribed", "Suspended", and "Unsubscribed".
    :vartype marketplace_subscription_status: str or
     ~azure.mgmt.dellstorage.models.MarketplaceSubscriptionStatus
    :ivar end_date: End Date of the subscription.
    :vartype end_date: str
    :ivar term_unit: Term Unit.
    :vartype term_unit: str
    """

    marketplace_subscription_id: Optional[str] = rest_field(
        name="marketplaceSubscriptionId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Marketplace Subscription Id."""
    plan_id: str = rest_field(name="planId", visibility=["read", "create", "update", "delete", "query"])
    """Plan Id. Required."""
    offer_id: str = rest_field(name="offerId", visibility=["read", "create", "update", "delete", "query"])
    """Offer Id. Required."""
    publisher_id: Optional[str] = rest_field(
        name="publisherId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Publisher Id."""
    private_offer_id: Optional[str] = rest_field(
        name="privateOfferId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Private Offer Id."""
    plan_name: str = rest_field(name="planName", visibility=["read", "create", "update", "delete", "query"])
    """Plan Name. Required."""
    marketplace_subscription_status: Optional[Union[str, "_models.MarketplaceSubscriptionStatus"]] = rest_field(
        name="marketplaceSubscriptionStatus", visibility=["read"]
    )
    """Marketplace subscription status. Known values are: \"PendingFulfillmentStart\", \"Subscribed\",
     \"Suspended\", and \"Unsubscribed\"."""
    end_date: Optional[str] = rest_field(name="endDate", visibility=["read", "create", "update", "delete", "query"])
    """End Date of the subscription."""
    term_unit: Optional[str] = rest_field(name="termUnit", visibility=["read", "create", "update", "delete", "query"])
    """Term Unit."""

    @overload
    def __init__(
        self,
        *,
        plan_id: str,
        offer_id: str,
        plan_name: str,
        marketplace_subscription_id: Optional[str] = None,
        publisher_id: Optional[str] = None,
        private_offer_id: Optional[str] = None,
        end_date: Optional[str] = None,
        term_unit: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.dellstorage.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.dellstorage.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.dellstorage.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.dellstorage.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.dellstorage.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserAssignedIdentity(_Model):
    """User assigned identity properties.

    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    """

    client_id: Optional[str] = rest_field(name="clientId", visibility=["read"])
    """The client ID of the assigned identity."""
    principal_id: Optional[str] = rest_field(name="principalId", visibility=["read"])
    """The principal ID of the assigned identity."""


class UserDetails(_Model):
    """User Details of Dell FileSystem resource.

    :ivar email: User Email. Required.
    :vartype email: str
    """

    email: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User Email. Required."""

    @overload
    def __init__(
        self,
        *,
        email: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
