# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AssetVersion(msrest.serialization.Model):
    """AssetVersion Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Fully qualified resource Id:
     azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the index.
    :vartype id: str
    :ivar stage: Update stage to 'Archive' to archive the asset. Default is Development, which
     means the asset is under development.
    :vartype stage: str
    :ivar description: Description information of the asset.
    :vartype description: str
    :ivar system_data: Metadata containing createdBy and modifiedBy information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Asset's tags. Unlike properties, tags are fully mutable.
    :vartype tags: dict[str, str]
    :ivar properties: Asset's properties. Unlike tags, properties are add-only. Once added, a
     property cannot be removed.
    :vartype properties: dict[str, str]
    """

    _validation = {
        'id': {'required': True, 'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        stage: Optional[str] = "Development",
        description: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword stage: Update stage to 'Archive' to archive the asset. Default is Development, which
         means the asset is under development.
        :paramtype stage: str
        :keyword description: Description information of the asset.
        :paramtype description: str
        :keyword tags: A set of tags. Asset's tags. Unlike properties, tags are fully mutable.
        :paramtype tags: dict[str, str]
        :keyword properties: Asset's properties. Unlike tags, properties are add-only. Once added, a
         property cannot be removed.
        :paramtype properties: dict[str, str]
        """
        super(AssetVersion, self).__init__(**kwargs)
        self.id = None
        self.stage = stage
        self.description = description
        self.system_data = None
        self.tags = tags
        self.properties = properties


class AzureCoreFoundationsError(msrest.serialization.Model):
    """The error object.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. One of a server-defined set of error codes.
    :vartype code: str
    :ivar message: Required. A human-readable representation of the error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.AzureCoreFoundationsError]
    :ivar innererror: An object containing more specific information than the current object about
     the error.
    :vartype innererror: ~azure.mgmt.machinelearningservices.models.AzureCoreFoundationsInnerError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[AzureCoreFoundationsError]'},
        'innererror': {'key': 'innererror', 'type': 'AzureCoreFoundationsInnerError'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        target: Optional[str] = None,
        details: Optional[List["AzureCoreFoundationsError"]] = None,
        innererror: Optional["AzureCoreFoundationsInnerError"] = None,
        **kwargs
    ):
        """
        :keyword code: Required. One of a server-defined set of error codes.
        :paramtype code: str
        :keyword message: Required. A human-readable representation of the error.
        :paramtype message: str
        :keyword target: The target of the error.
        :paramtype target: str
        :keyword details: An array of details about specific errors that led to this reported error.
        :paramtype details: list[~azure.mgmt.machinelearningservices.models.AzureCoreFoundationsError]
        :keyword innererror: An object containing more specific information than the current object
         about the error.
        :paramtype innererror:
         ~azure.mgmt.machinelearningservices.models.AzureCoreFoundationsInnerError
        """
        super(AzureCoreFoundationsError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.innererror = innererror


class AzureCoreFoundationsErrorResponse(msrest.serialization.Model):
    """A response containing error details.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required. The error object.
    :vartype error: ~azure.mgmt.machinelearningservices.models.AzureCoreFoundationsError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'AzureCoreFoundationsError'},
    }

    def __init__(
        self,
        *,
        error: "AzureCoreFoundationsError",
        **kwargs
    ):
        """
        :keyword error: Required. The error object.
        :paramtype error: ~azure.mgmt.machinelearningservices.models.AzureCoreFoundationsError
        """
        super(AzureCoreFoundationsErrorResponse, self).__init__(**kwargs)
        self.error = error


class AzureCoreFoundationsInnerError(msrest.serialization.Model):
    """An object containing more specific information about the error. As per Azure REST API guidelines - https://aka.ms/AzureRestApiGuidelines#handling-errors.

    :ivar code: One of a server-defined set of error codes.
    :vartype code: str
    :ivar innererror: Inner error.
    :vartype innererror: ~azure.mgmt.machinelearningservices.models.AzureCoreFoundationsInnerError
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'innererror': {'key': 'innererror', 'type': 'AzureCoreFoundationsInnerError'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        innererror: Optional["AzureCoreFoundationsInnerError"] = None,
        **kwargs
    ):
        """
        :keyword code: One of a server-defined set of error codes.
        :paramtype code: str
        :keyword innererror: Inner error.
        :paramtype innererror:
         ~azure.mgmt.machinelearningservices.models.AzureCoreFoundationsInnerError
        """
        super(AzureCoreFoundationsInnerError, self).__init__(**kwargs)
        self.code = code
        self.innererror = innererror


class DeploymentTemplate(msrest.serialization.Model):
    """DeploymentTemplate resource definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Fully qualified resource Id:
     azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the index.
    :vartype id: str
    :ivar stage: Update stage to 'Archive' to archive the asset. Default is Development, which
     means the asset is under development.
    :vartype stage: str
    :ivar description: Description information of the asset.
    :vartype description: str
    :ivar system_data: Metadata containing createdBy and modifiedBy information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Asset's tags. Unlike properties, tags are fully mutable.
    :vartype tags: dict[str, str]
    :ivar properties: Asset's properties. Unlike tags, properties are add-only. Once added, a
     property cannot be removed.
    :vartype properties: dict[str, str]
    :ivar deployment_template_type: Required. The type of deployment template.
    :vartype deployment_template_type: str
    :ivar environment_id: Required. The ID of the environment asset.
    :vartype environment_id: str
    :ivar environment_variables: Environment variables for the deployment.
    :vartype environment_variables: dict[str, str]
    :ivar allowed_environment_variable_overrides: List of environment variable names that can be
     overridden.
    :vartype allowed_environment_variable_overrides: list[str]
    :ivar model_mount_path: Path where the model will be mounted.
    :vartype model_mount_path: str
    :ivar request_settings: Request settings for online deployment.
    :vartype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
    :ivar liveness_probe: Liveness probe settings.
    :vartype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar readiness_probe: Readiness probe settings.
    :vartype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
    :ivar allowed_instance_type: Required. List of allowed instance types for the deployment.
    :vartype allowed_instance_type: list[str]
    :ivar default_instance_type: Required. Default instance type for the deployment.
    :vartype default_instance_type: str
    :ivar instance_count: Required. Number of instances for the deployment.
    :vartype instance_count: int
    :ivar scoring_path: Path for scoring requests.
    :vartype scoring_path: str
    :ivar scoring_port: Port for scoring requests.
    :vartype scoring_port: int
    """

    _validation = {
        'id': {'required': True, 'readonly': True},
        'system_data': {'readonly': True},
        'deployment_template_type': {'required': True},
        'environment_id': {'required': True},
        'allowed_instance_type': {'required': True},
        'default_instance_type': {'required': True},
        'instance_count': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'deployment_template_type': {'key': 'deploymentTemplateType', 'type': 'str'},
        'environment_id': {'key': 'environmentId', 'type': 'str'},
        'environment_variables': {'key': 'environmentVariables', 'type': '{str}'},
        'allowed_environment_variable_overrides': {'key': 'allowedEnvironmentVariableOverrides', 'type': '[str]'},
        'model_mount_path': {'key': 'modelMountPath', 'type': 'str'},
        'request_settings': {'key': 'requestSettings', 'type': 'OnlineRequestSettings'},
        'liveness_probe': {'key': 'livenessProbe', 'type': 'ProbeSettings'},
        'readiness_probe': {'key': 'readinessProbe', 'type': 'ProbeSettings'},
        'allowed_instance_type': {'key': 'allowedInstanceType', 'type': '[str]'},
        'default_instance_type': {'key': 'defaultInstanceType', 'type': 'str'},
        'instance_count': {'key': 'instanceCount', 'type': 'int'},
        'scoring_path': {'key': 'scoringPath', 'type': 'str'},
        'scoring_port': {'key': 'scoringPort', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        deployment_template_type: str,
        environment_id: str,
        allowed_instance_type: List[str],
        default_instance_type: str,
        instance_count: int,
        stage: Optional[str] = "Development",
        description: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        allowed_environment_variable_overrides: Optional[List[str]] = None,
        model_mount_path: Optional[str] = None,
        request_settings: Optional["OnlineRequestSettings"] = None,
        liveness_probe: Optional["ProbeSettings"] = None,
        readiness_probe: Optional["ProbeSettings"] = None,
        scoring_path: Optional[str] = None,
        scoring_port: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword stage: Update stage to 'Archive' to archive the asset. Default is Development, which
         means the asset is under development.
        :paramtype stage: str
        :keyword description: Description information of the asset.
        :paramtype description: str
        :keyword tags: A set of tags. Asset's tags. Unlike properties, tags are fully mutable.
        :paramtype tags: dict[str, str]
        :keyword properties: Asset's properties. Unlike tags, properties are add-only. Once added, a
         property cannot be removed.
        :paramtype properties: dict[str, str]
        :keyword deployment_template_type: Required. The type of deployment template.
        :paramtype deployment_template_type: str
        :keyword environment_id: Required. The ID of the environment asset.
        :paramtype environment_id: str
        :keyword environment_variables: Environment variables for the deployment.
        :paramtype environment_variables: dict[str, str]
        :keyword allowed_environment_variable_overrides: List of environment variable names that can be
         overridden.
        :paramtype allowed_environment_variable_overrides: list[str]
        :keyword model_mount_path: Path where the model will be mounted.
        :paramtype model_mount_path: str
        :keyword request_settings: Request settings for online deployment.
        :paramtype request_settings: ~azure.mgmt.machinelearningservices.models.OnlineRequestSettings
        :keyword liveness_probe: Liveness probe settings.
        :paramtype liveness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword readiness_probe: Readiness probe settings.
        :paramtype readiness_probe: ~azure.mgmt.machinelearningservices.models.ProbeSettings
        :keyword allowed_instance_type: Required. List of allowed instance types for the deployment.
        :paramtype allowed_instance_type: list[str]
        :keyword default_instance_type: Required. Default instance type for the deployment.
        :paramtype default_instance_type: str
        :keyword instance_count: Required. Number of instances for the deployment.
        :paramtype instance_count: int
        :keyword scoring_path: Path for scoring requests.
        :paramtype scoring_path: str
        :keyword scoring_port: Port for scoring requests.
        :paramtype scoring_port: int
        """
        super(DeploymentTemplate, self).__init__(**kwargs)
        self.id = None
        self.stage = stage
        self.description = description
        self.system_data = None
        self.tags = tags
        self.properties = properties
        self.deployment_template_type = deployment_template_type
        self.environment_id = environment_id
        self.environment_variables = environment_variables
        self.allowed_environment_variable_overrides = allowed_environment_variable_overrides
        self.model_mount_path = model_mount_path
        self.request_settings = request_settings
        self.liveness_probe = liveness_probe
        self.readiness_probe = readiness_probe
        self.allowed_instance_type = allowed_instance_type
        self.default_instance_type = default_instance_type
        self.instance_count = instance_count
        self.scoring_path = scoring_path
        self.scoring_port = scoring_port


class Index(msrest.serialization.Model):
    """Index resource Definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. Fully qualified resource Id:
     azureml://workspace/{workspaceName}/indexes/{name}/versions/{version} of the index.
    :vartype id: str
    :ivar stage: Update stage to 'Archive' to archive the asset. Default is Development, which
     means the asset is under development.
    :vartype stage: str
    :ivar description: Description information of the asset.
    :vartype description: str
    :ivar system_data: Metadata containing createdBy and modifiedBy information.
    :vartype system_data: ~azure.mgmt.machinelearningservices.models.SystemData
    :ivar tags: A set of tags. Asset's tags. Unlike properties, tags are fully mutable.
    :vartype tags: dict[str, str]
    :ivar properties: Asset's properties. Unlike tags, properties are add-only. Once added, a
     property cannot be removed.
    :vartype properties: dict[str, str]
    :ivar storage_uri: Required. Default workspace blob storage Uri. Should work across storage
     types and auth scenarios.
    :vartype storage_uri: str
    """

    _validation = {
        'id': {'required': True, 'readonly': True},
        'system_data': {'readonly': True},
        'storage_uri': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'stage': {'key': 'stage', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_uri: str,
        stage: Optional[str] = "Development",
        description: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword stage: Update stage to 'Archive' to archive the asset. Default is Development, which
         means the asset is under development.
        :paramtype stage: str
        :keyword description: Description information of the asset.
        :paramtype description: str
        :keyword tags: A set of tags. Asset's tags. Unlike properties, tags are fully mutable.
        :paramtype tags: dict[str, str]
        :keyword properties: Asset's properties. Unlike tags, properties are add-only. Once added, a
         property cannot be removed.
        :paramtype properties: dict[str, str]
        :keyword storage_uri: Required. Default workspace blob storage Uri. Should work across storage
         types and auth scenarios.
        :paramtype storage_uri: str
        """
        super(Index, self).__init__(**kwargs)
        self.id = None
        self.stage = stage
        self.description = description
        self.system_data = None
        self.tags = tags
        self.properties = properties
        self.storage_uri = storage_uri


class LongRunningNullResponse(msrest.serialization.Model):
    """LongRunningNullResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar location: Required. Polling Uri.
    :vartype location: str
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        **kwargs
    ):
        """
        :keyword location: Required. Polling Uri.
        :paramtype location: str
        """
        super(LongRunningNullResponse, self).__init__(**kwargs)
        self.location = location


class OnlineRequestSettings(msrest.serialization.Model):
    """Settings for online request configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar request_timeout: Required. The timeout duration for requests.
    :vartype request_timeout: ~datetime.timedelta
    :ivar max_concurrent_requests_per_instance: Required. The maximum number of concurrent requests
     per instance.
    :vartype max_concurrent_requests_per_instance: int
    """

    _validation = {
        'request_timeout': {'required': True},
        'max_concurrent_requests_per_instance': {'required': True},
    }

    _attribute_map = {
        'request_timeout': {'key': 'requestTimeout', 'type': 'duration'},
        'max_concurrent_requests_per_instance': {'key': 'maxConcurrentRequestsPerInstance', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        request_timeout: datetime.timedelta,
        max_concurrent_requests_per_instance: int,
        **kwargs
    ):
        """
        :keyword request_timeout: Required. The timeout duration for requests.
        :paramtype request_timeout: ~datetime.timedelta
        :keyword max_concurrent_requests_per_instance: Required. The maximum number of concurrent
         requests per instance.
        :paramtype max_concurrent_requests_per_instance: int
        """
        super(OnlineRequestSettings, self).__init__(**kwargs)
        self.request_timeout = request_timeout
        self.max_concurrent_requests_per_instance = max_concurrent_requests_per_instance


class PagedDeploymentTemplate(msrest.serialization.Model):
    """Paged collection of DeploymentTemplate items.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The list of Deployment Templates.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.DeploymentTemplate]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeploymentTemplate]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DeploymentTemplate"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. The list of Deployment Templates.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.DeploymentTemplate]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super(PagedDeploymentTemplate, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PagedIndex(msrest.serialization.Model):
    """Paged collection of IndexVersion items.

    All required parameters must be populated in order to send to Azure.

    :ivar value: Required. The list of Indexes.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Index]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Index]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Index"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Required. The list of Indexes.
        :paramtype value: list[~azure.mgmt.machinelearningservices.models.Index]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super(PagedIndex, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProbeSettings(msrest.serialization.Model):
    """Settings for probe configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar initial_delay: The initial delay before starting probes.
    :vartype initial_delay: ~datetime.timedelta
    :ivar period: Required. The period between probe executions.
    :vartype period: ~datetime.timedelta
    :ivar timeout: Required. The timeout duration for each probe.
    :vartype timeout: ~datetime.timedelta
    :ivar failure_threshold: Required. The number of consecutive failures required to consider the
     probe as failed.
    :vartype failure_threshold: int
    :ivar success_threshold: Required. The number of consecutive successes required to consider the
     probe as successful.
    :vartype success_threshold: int
    :ivar path: Required. The path for the probe request.
    :vartype path: str
    :ivar port: Required. The port number for the probe.
    :vartype port: int
    :ivar scheme: Required. The scheme for the probe (e.g., HTTP, HTTPS).
    :vartype scheme: str
    :ivar http_method: Required. The HTTP method for the probe request.
    :vartype http_method: str
    """

    _validation = {
        'period': {'required': True},
        'timeout': {'required': True},
        'failure_threshold': {'required': True},
        'success_threshold': {'required': True},
        'path': {'required': True},
        'port': {'required': True},
        'scheme': {'required': True},
        'http_method': {'required': True},
    }

    _attribute_map = {
        'initial_delay': {'key': 'initialDelay', 'type': 'duration'},
        'period': {'key': 'period', 'type': 'duration'},
        'timeout': {'key': 'timeout', 'type': 'duration'},
        'failure_threshold': {'key': 'failureThreshold', 'type': 'int'},
        'success_threshold': {'key': 'successThreshold', 'type': 'int'},
        'path': {'key': 'path', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'scheme': {'key': 'scheme', 'type': 'str'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        period: datetime.timedelta,
        timeout: datetime.timedelta,
        failure_threshold: int,
        success_threshold: int,
        path: str,
        port: int,
        scheme: str,
        http_method: str,
        initial_delay: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword initial_delay: The initial delay before starting probes.
        :paramtype initial_delay: ~datetime.timedelta
        :keyword period: Required. The period between probe executions.
        :paramtype period: ~datetime.timedelta
        :keyword timeout: Required. The timeout duration for each probe.
        :paramtype timeout: ~datetime.timedelta
        :keyword failure_threshold: Required. The number of consecutive failures required to consider
         the probe as failed.
        :paramtype failure_threshold: int
        :keyword success_threshold: Required. The number of consecutive successes required to consider
         the probe as successful.
        :paramtype success_threshold: int
        :keyword path: Required. The path for the probe request.
        :paramtype path: str
        :keyword port: Required. The port number for the probe.
        :paramtype port: int
        :keyword scheme: Required. The scheme for the probe (e.g., HTTP, HTTPS).
        :paramtype scheme: str
        :keyword http_method: Required. The HTTP method for the probe request.
        :paramtype http_method: str
        """
        super(ProbeSettings, self).__init__(**kwargs)
        self.initial_delay = initial_delay
        self.period = period
        self.timeout = timeout
        self.failure_threshold = failure_threshold
        self.success_threshold = success_threshold
        self.path = path
        self.port = port
        self.scheme = scheme
        self.http_method = http_method


class PutAssetLROResponse(msrest.serialization.Model):
    """PutAssetLROResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar asset_id: Required. Response of completed put asset lro.
    :vartype asset_id: str
    """

    _validation = {
        'asset_id': {'required': True},
    }

    _attribute_map = {
        'asset_id': {'key': 'assetId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        asset_id: str,
        **kwargs
    ):
        """
        :keyword asset_id: Required. Response of completed put asset lro.
        :paramtype asset_id: str
        """
        super(PutAssetLROResponse, self).__init__(**kwargs)
        self.asset_id = asset_id


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_at: The timestamp the resource was created at.
    :vartype created_at: ~datetime.datetime
    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The identity type that created the resource.
    :vartype created_by_type: str
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        'created_at': {'readonly': True},
        'created_by': {'readonly': True},
        'created_by_type': {'readonly': True},
        'last_modified_at': {'readonly': True},
    }

    _attribute_map = {
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_at = None
        self.created_by = None
        self.created_by_type = None
        self.last_modified_at = None


class VersionInfo(msrest.serialization.Model):
    """Next version definition.

    All required parameters must be populated in order to send to Azure.

    :ivar next_version: Next version as defined by the server. The server keeps track of all
     versions that are string-representations of integers. If one exists, the nextVersion will be a
     string representation of the highest integer value + 1. Otherwise, the nextVersion will default
     to '1'.
    :vartype next_version: long
    :ivar latest_version: Required. Current latest version of the resource.
    :vartype latest_version: str
    """

    _validation = {
        'latest_version': {'required': True},
    }

    _attribute_map = {
        'next_version': {'key': 'nextVersion', 'type': 'long'},
        'latest_version': {'key': 'latestVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        latest_version: str,
        next_version: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword next_version: Next version as defined by the server. The server keeps track of all
         versions that are string-representations of integers. If one exists, the nextVersion will be a
         string representation of the highest integer value + 1. Otherwise, the nextVersion will default
         to '1'.
        :paramtype next_version: long
        :keyword latest_version: Required. Current latest version of the resource.
        :paramtype latest_version: str
        """
        super(VersionInfo, self).__init__(**kwargs)
        self.next_version = next_version
        self.latest_version = latest_version
