use criterion::{Criterion, criterion_group, criterion_main};
use iri_s::iri;
use shex_compact::ShExParser;
use tracing::debug;

fn parse(str: &str) -> usize {
    let schema = ShExParser::parse(str, None, &iri!("http://default/")).unwrap();
    schema.shapes().unwrap().len()
}

fn shex_compact_simple(c: &mut Criterion) {
    let str = r#"
    prefix : <http://example.org/>
    <S> {
        :p @<T>;
    }
    
    <T> {
        :q @<S>
    }"#;

    // Parse once to ensure it parses correctly the first time
    let n = parse(str);
    debug!("Number of shapes: {:?}", n);
    c.bench_function("shex_compact_simple", |b| b.iter(|| parse(str)));
}

criterion_group!(benches, shex_compact_simple);
criterion_main!(benches);
