/*
    clsync - file tree sync utility based on inotify/kqueue

    Copyright (C) 2013-2014 Dmitry Yu Okunev <dyokunev@ut.mephi.ru> 0x8E30679C

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if 0

int fanotify_add_watch_dir ( int fanotify_d, struct ctx *ctx_p, const char *const accpath )
{
	return fanotify_mark ( fanotify_d, FAN_MARK_ADD | FAN_MARK_DONT_FOLLOW,
	                       FANOTIFY_MARKMASK, AT_FDCWD, accpath );
}

int fanotify_loop ( int fanotify_d, ctx_t *ctx_p, indexes_t *indexes_p )
{
	struct fanotify_event_metadata buf[BUFSIZ / sizeof ( struct fanotify_event_metadata ) + 1];
	int state = STATE_RUNNING;
	state_p = &state;

	while ( state != STATE_EXIT ) {
		struct fanotify_event_metadata *metadata;
		size_t len = read ( fanotify_d, ( void * ) buf, sizeof ( buf ) - sizeof ( *buf ) );
		metadata = buf;

		if ( len == -1 ) {
			error ( "cannot read(%i, &metadata, sizeof(metadata)).", fanotify_d );
			return errno;
		}

		while ( FAN_EVENT_OK ( metadata, len ) ) {
			debug ( 2, "metadata->pid: %i; metadata->fd: %i", metadata->pid, metadata->fd );

			if ( metadata->fd != FAN_NOFD ) {
				if ( metadata->fd >= 0 ) {
					char *fpath = fd2fpath_malloc ( metadata->fd );
					sync_queuesync ( fpath_rel, 0, ctx_p, indexes_p, QUEUE_AUTO );
					debug ( 2, "Event %i on \"%s\".", metadata->mask, fpath );
					free ( fpath );
				}
			}

			close ( metadata->fd );
			metadata = FAN_EVENT_NEXT ( metadata, len );
		}

		int ret;

		if ( ( ret = sync_idle ( fanotify_d, ctx_p, indexes_p ) ) ) {
			error ( "got error while sync_idle()." );
			return ret;
		}
	}

	return 0;
}
#endif

