/*
 * KiRouter - a push-and-(sometimes-)shove PCB router
 *
 * Copyright (C) 2014  CERN
 * Author: Maciej Suminski <maciej.suminski@cern.ch>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.or/licenses/>.
 */

/**
 * Push and Shove router track width and via size dialog.
 */

#include "dialog_track_via_size.h"
#include <base_units.h>
#include <confirm.h>
#include <widgets/text_ctrl_eval.h>
#include <core/optional.h>
#include <eda_draw_frame.h>

#include "board_design_settings.h"

const int minSize = (int)( 0.01 * IU_PER_MM );

DIALOG_TRACK_VIA_SIZE::DIALOG_TRACK_VIA_SIZE( EDA_DRAW_FRAME* aParent,
                                              BOARD_DESIGN_SETTINGS& aSettings ) :
    DIALOG_TRACK_VIA_SIZE_BASE( aParent ),
    m_trackWidth( aParent, m_trackWidthLabel, m_trackWidthText, m_trackWidthUnits, minSize ),
    m_viaDiameter( aParent, m_viaDiameterLabel, m_viaDiameterText, m_viaDiameterUnits, minSize ),
    m_viaDrill( aParent, m_viaDrillLabel, m_viaDrillText, m_viaDrillUnits, minSize ),
    m_settings( aSettings )
{
    m_stdButtonsOK->SetDefault();

    // Now all widgets have the size fixed, call FinishDialogSettings
    finishDialogSettings();
}


bool DIALOG_TRACK_VIA_SIZE::TransferDataFromWindow()
{
    if( !wxDialog::TransferDataFromWindow() )
        return false;

    if( m_viaDrill.GetValue() >= m_viaDiameter.GetValue() )
    {
        DisplayError( GetParent(), _( "Via drill size must be smaller than via diameter" ) );
        m_viaDrillText->SetFocus();
        return false;
    }

    // Store dialog values to the router settings
    m_settings.SetCustomTrackWidth( m_trackWidth.GetValue() );
    m_settings.SetCustomViaSize( m_viaDiameter.GetValue() );
    m_settings.SetCustomViaDrill( m_viaDrill.GetValue() );

    return true;
}


bool DIALOG_TRACK_VIA_SIZE::TransferDataToWindow()
{
    if( !wxDialog::TransferDataToWindow() )
        return false;

    // Load router settings to dialog fields
    m_trackWidth.SetValue( m_settings.GetCustomTrackWidth() );
    m_viaDiameter.SetValue( m_settings.GetCustomViaSize() );
    m_viaDrill.SetValue( m_settings.GetCustomViaDrill() );

    return true;
}

