// RUN: llgo -o %t %s
// RUN: %t 2>&1 | FileCheck %s

// CHECK: 4294967295
// CHECK-NEXT: 4294967295
// CHECK-NEXT: 2147483647
// CHECK-NEXT: 4294967294
// CHECK-NEXT: 1073741823
// CHECK-NEXT: 4294967292
// CHECK-NEXT: 536870911
// CHECK-NEXT: 4294967288
// CHECK-NEXT: 268435455
// CHECK-NEXT: 4294967280
// CHECK-NEXT: 134217727
// CHECK-NEXT: 4294967264
// CHECK-NEXT: 67108863
// CHECK-NEXT: 4294967232
// CHECK-NEXT: 33554431
// CHECK-NEXT: 4294967168
// CHECK-NEXT: 16777215
// CHECK-NEXT: 4294967040
// CHECK-NEXT: 8388607
// CHECK-NEXT: 4294966784
// CHECK-NEXT: 4194303
// CHECK-NEXT: 4294966272
// CHECK-NEXT: 2097151
// CHECK-NEXT: 4294965248
// CHECK-NEXT: 1048575
// CHECK-NEXT: 4294963200
// CHECK-NEXT: 524287
// CHECK-NEXT: 4294959104
// CHECK-NEXT: 262143
// CHECK-NEXT: 4294950912
// CHECK-NEXT: 131071
// CHECK-NEXT: 4294934528
// CHECK-NEXT: 65535
// CHECK-NEXT: 4294901760
// CHECK-NEXT: 32767
// CHECK-NEXT: 4294836224
// CHECK-NEXT: 16383
// CHECK-NEXT: 4294705152
// CHECK-NEXT: 8191
// CHECK-NEXT: 4294443008
// CHECK-NEXT: 4095
// CHECK-NEXT: 4293918720
// CHECK-NEXT: 2047
// CHECK-NEXT: 4292870144
// CHECK-NEXT: 1023
// CHECK-NEXT: 4290772992
// CHECK-NEXT: 511
// CHECK-NEXT: 4286578688
// CHECK-NEXT: 255
// CHECK-NEXT: 4278190080
// CHECK-NEXT: 127
// CHECK-NEXT: 4261412864
// CHECK-NEXT: 63
// CHECK-NEXT: 4227858432
// CHECK-NEXT: 31
// CHECK-NEXT: 4160749568
// CHECK-NEXT: 15
// CHECK-NEXT: 4026531840
// CHECK-NEXT: 7
// CHECK-NEXT: 3758096384
// CHECK-NEXT: 3
// CHECK-NEXT: 3221225472
// CHECK-NEXT: 1
// CHECK-NEXT: 2147483648
// CHECK-NEXT: 0
// CHECK-NEXT: 0
// CHECK-NEXT: 4026531839
// CHECK-NEXT: 4026531839
// CHECK-NEXT: 2013265919
// CHECK-NEXT: 3758096382
// CHECK-NEXT: 1006632959
// CHECK-NEXT: 3221225468
// CHECK-NEXT: 503316479
// CHECK-NEXT: 2147483640
// CHECK-NEXT: 251658239
// CHECK-NEXT: 4294967280
// CHECK-NEXT: 125829119
// CHECK-NEXT: 4294967264
// CHECK-NEXT: 62914559
// CHECK-NEXT: 4294967232
// CHECK-NEXT: 31457279
// CHECK-NEXT: 4294967168
// CHECK-NEXT: 15728639
// CHECK-NEXT: 4294967040
// CHECK-NEXT: 7864319
// CHECK-NEXT: 4294966784
// CHECK-NEXT: 3932159
// CHECK-NEXT: 4294966272
// CHECK-NEXT: 1966079
// CHECK-NEXT: 4294965248
// CHECK-NEXT: 983039
// CHECK-NEXT: 4294963200
// CHECK-NEXT: 491519
// CHECK-NEXT: 4294959104
// CHECK-NEXT: 245759
// CHECK-NEXT: 4294950912
// CHECK-NEXT: 122879
// CHECK-NEXT: 4294934528
// CHECK-NEXT: 61439
// CHECK-NEXT: 4294901760
// CHECK-NEXT: 30719
// CHECK-NEXT: 4294836224
// CHECK-NEXT: 15359
// CHECK-NEXT: 4294705152
// CHECK-NEXT: 7679
// CHECK-NEXT: 4294443008
// CHECK-NEXT: 3839
// CHECK-NEXT: 4293918720
// CHECK-NEXT: 1919
// CHECK-NEXT: 4292870144
// CHECK-NEXT: 959
// CHECK-NEXT: 4290772992
// CHECK-NEXT: 479
// CHECK-NEXT: 4286578688
// CHECK-NEXT: 239
// CHECK-NEXT: 4278190080
// CHECK-NEXT: 119
// CHECK-NEXT: 4261412864
// CHECK-NEXT: 59
// CHECK-NEXT: 4227858432
// CHECK-NEXT: 29
// CHECK-NEXT: 4160749568
// CHECK-NEXT: 14
// CHECK-NEXT: 4026531840
// CHECK-NEXT: 7
// CHECK-NEXT: 3758096384
// CHECK-NEXT: 3
// CHECK-NEXT: 3221225472
// CHECK-NEXT: 1
// CHECK-NEXT: 2147483648
// CHECK-NEXT: 0
// CHECK-NEXT: 0
// CHECK-NEXT: -1
// CHECK-NEXT: -1
// CHECK-NEXT: -1
// CHECK-NEXT: -2
// CHECK-NEXT: -1
// CHECK-NEXT: -4
// CHECK-NEXT: -1
// CHECK-NEXT: -8
// CHECK-NEXT: -1
// CHECK-NEXT: -16
// CHECK-NEXT: -1
// CHECK-NEXT: -32
// CHECK-NEXT: -1
// CHECK-NEXT: -64
// CHECK-NEXT: -1
// CHECK-NEXT: -128
// CHECK-NEXT: -1
// CHECK-NEXT: -256
// CHECK-NEXT: -1
// CHECK-NEXT: -512
// CHECK-NEXT: -1
// CHECK-NEXT: -1024
// CHECK-NEXT: -1
// CHECK-NEXT: -2048
// CHECK-NEXT: -1
// CHECK-NEXT: -4096
// CHECK-NEXT: -1
// CHECK-NEXT: -8192
// CHECK-NEXT: -1
// CHECK-NEXT: -16384
// CHECK-NEXT: -1
// CHECK-NEXT: -32768
// CHECK-NEXT: -1
// CHECK-NEXT: -65536
// CHECK-NEXT: -1
// CHECK-NEXT: -131072
// CHECK-NEXT: -1
// CHECK-NEXT: -262144
// CHECK-NEXT: -1
// CHECK-NEXT: -524288
// CHECK-NEXT: -1
// CHECK-NEXT: -1048576
// CHECK-NEXT: -1
// CHECK-NEXT: -2097152
// CHECK-NEXT: -1
// CHECK-NEXT: -4194304
// CHECK-NEXT: -1
// CHECK-NEXT: -8388608
// CHECK-NEXT: -1
// CHECK-NEXT: -16777216
// CHECK-NEXT: -1
// CHECK-NEXT: -33554432
// CHECK-NEXT: -1
// CHECK-NEXT: -67108864
// CHECK-NEXT: -1
// CHECK-NEXT: -134217728
// CHECK-NEXT: -1
// CHECK-NEXT: -268435456
// CHECK-NEXT: -1
// CHECK-NEXT: -536870912
// CHECK-NEXT: -1
// CHECK-NEXT: -1073741824
// CHECK-NEXT: -1
// CHECK-NEXT: -2147483648
// CHECK-NEXT: -1
// CHECK-NEXT: 0
// CHECK-NEXT: 1
// CHECK-NEXT: 1
// CHECK-NEXT: 0
// CHECK-NEXT: 2
// CHECK-NEXT: 0
// CHECK-NEXT: 4
// CHECK-NEXT: 0
// CHECK-NEXT: 8
// CHECK-NEXT: 0
// CHECK-NEXT: 16
// CHECK-NEXT: 0
// CHECK-NEXT: 32
// CHECK-NEXT: 0
// CHECK-NEXT: 64
// CHECK-NEXT: 0
// CHECK-NEXT: 128
// CHECK-NEXT: 0
// CHECK-NEXT: 256
// CHECK-NEXT: 0
// CHECK-NEXT: 512
// CHECK-NEXT: 0
// CHECK-NEXT: 1024
// CHECK-NEXT: 0
// CHECK-NEXT: 2048
// CHECK-NEXT: 0
// CHECK-NEXT: 4096
// CHECK-NEXT: 0
// CHECK-NEXT: 8192
// CHECK-NEXT: 0
// CHECK-NEXT: 16384
// CHECK-NEXT: 0
// CHECK-NEXT: 32768
// CHECK-NEXT: 0
// CHECK-NEXT: 65536
// CHECK-NEXT: 0
// CHECK-NEXT: 131072
// CHECK-NEXT: 0
// CHECK-NEXT: 262144
// CHECK-NEXT: 0
// CHECK-NEXT: 524288
// CHECK-NEXT: 0
// CHECK-NEXT: 1048576
// CHECK-NEXT: 0
// CHECK-NEXT: 2097152
// CHECK-NEXT: 0
// CHECK-NEXT: 4194304
// CHECK-NEXT: 0
// CHECK-NEXT: 8388608
// CHECK-NEXT: 0
// CHECK-NEXT: 16777216
// CHECK-NEXT: 0
// CHECK-NEXT: 33554432
// CHECK-NEXT: 0
// CHECK-NEXT: 67108864
// CHECK-NEXT: 0
// CHECK-NEXT: 134217728
// CHECK-NEXT: 0
// CHECK-NEXT: 268435456
// CHECK-NEXT: 0
// CHECK-NEXT: 536870912
// CHECK-NEXT: 0
// CHECK-NEXT: 1073741824
// CHECK-NEXT: 0
// CHECK-NEXT: -2147483648
// CHECK-NEXT: 0
// CHECK-NEXT: 0

package main

func testShrUint32(v uint32) {
	for i := uint(0); i <= 32; i++ {
		println(v >> i)
		println(v << i)
	}
}

func testShrInt32(v int32) {
	for i := uint(0); i <= 32; i++ {
		println(v >> i)
		println(v << i)
	}
}

func main() {
	testShrUint32(0xFFFFFFFF)
	testShrUint32(0xEFFFFFFF)
	testShrInt32(-1)
	testShrInt32(1)
}
