// license:CC0
// copyright-holders:SomeRandomGuyIdk

#include "netlist/devices/net_lib.h"

NETLIST_START(jpmsru)
{

	SOLVER(Solver, 48000)
	ANALOG_INPUT(V5, 5)
	ANALOG_INPUT(VM5, -5)

	TTL_INPUT(IN1, 0)
	TTL_INPUT(IN2, 0)
	TTL_INPUT(IN3, 0)
	TTL_INPUT(IN4, 0)
	TTL_INPUT(IN5, 0)
	TTL_INPUT(IN6, 0)
	NET_C(V5, IN1.VCC, IN2.VCC, IN3.VCC, IN4.VCC, IN5.VCC, IN6.VCC)
	NET_C(GND, IN1.GND, IN2.GND, IN3.GND, IN4.GND, IN5.GND, IN6.GND)

	RES(R1, RES_K(1.5))
	RES(R2, RES_K(1.5))
	RES(R3, RES_K(1.5))
	RES(R4, RES_K(1.5))
	RES(R5, RES_K(1.5))
	RES(R6, RES_K(1.5))
	RES(R7, 470)
	POT(R8, RES_K(4.7))
	NET_C(R8.3, GND)
	PARAM(R8.DIAL, 0.170441) // Stops tones cutting out and popping when idle
	RES(R9, RES_K(6.8))

	CAP(C1, CAP_P(1000))
	CAP(C2, CAP_U(0.22))

	NE566_DIP(IC14)

	NET_C(IN1.Q, R1.1)
	NET_C(IN2.Q, R2.1)
	NET_C(IN3.Q, R3.1)
	NET_C(IN4.Q, R4.1)
	NET_C(IN5.Q, R5.1)
	NET_C(IN6.Q, R6.1)
	NET_C(R1.2, R2.2, R3.2, R4.2, R5.2, R6.2, R7.1, C1.1, IC14.5)
	NET_C(R7.2, V5, R8.1)
	NET_C(R8.2, R9.1)
	NET_C(R9.2, C1.2, IC14.6)

	NET_C(VM5, IC14.1, C2.1)
	NET_C(C2.2, IC14.7)

	ALIAS(OUT, IC14.3)

	NET_C(V5, IC14.8)

	OPTIMIZE_FRONTIER(R1.1, RES_K(1.5), 50)
	OPTIMIZE_FRONTIER(R2.1, RES_K(1.5), 50)
	OPTIMIZE_FRONTIER(R3.1, RES_K(1.5), 50)
	OPTIMIZE_FRONTIER(R4.1, RES_K(1.5), 50)
	OPTIMIZE_FRONTIER(R5.1, RES_K(1.5), 50)
	OPTIMIZE_FRONTIER(R6.1, RES_K(1.5), 50)

}
