// license:BSD-3-Clause
// copyright-holders:Olivier Galibert, R. Belmont
#ifndef MAME_OSD_SDL_OSDSDL_H
#define MAME_OSD_SDL_OSDSDL_H

#pragma once

#include "modules/lib/osdobj_common.h"
#include "modules/osdmodule.h"
#include "modules/font/font_module.h"

//============================================================
//  Defines
//============================================================

#define SDLOPTION_INIPATH               "inipath"
#define SDLOPTION_SDLVIDEOFPS           "sdlvideofps"
#define SDLOPTION_USEALLHEADS           "useallheads"
#define SDLOPTION_ATTACH_WINDOW         "attach_window"
#define SDLOPTION_CENTERH               "centerh"
#define SDLOPTION_CENTERV               "centerv"

#define SDLOPTION_SCALEMODE             "scalemode"

#define SDLOPTION_WAITVSYNC             "waitvsync"
#define SDLOPTION_SYNCREFRESH           "syncrefresh"
#define SDLOPTION_KEYMAP                "keymap"
#define SDLOPTION_KEYMAP_FILE           "keymap_file"

#define SDLOPTION_SIXAXIS               "sixaxis"
#if (USE_XINPUT)
#define SDLOPTION_LIGHTGUNINDEX         "lightgun_index"
#endif

#define SDLOPTION_AUDIODRIVER           "audiodriver"
#define SDLOPTION_VIDEODRIVER           "videodriver"
#define SDLOPTION_RENDERDRIVER          "renderdriver"
#define SDLOPTION_GL_LIB                "gl_lib"

#define SDLOPTVAL_OPENGL                "opengl"
#define SDLOPTVAL_SOFT                  "soft"
#define SDLOPTVAL_SDL2ACCEL             "accel"
#define SDLOPTVAL_BGFX                  "bgfx"

#define SDLMAME_LED(x)                  "led" #x

// read by sdlmame

#define SDLENV_DESKTOPDIM               "SDLMAME_DESKTOPDIM"
#define SDLENV_VMWARE                   "SDLMAME_VMWARE"

// set by sdlmame

#define SDLENV_VISUALID                 "SDL_VIDEO_X11_VISUALID"
#define SDLENV_VIDEODRIVER              "SDL_VIDEODRIVER"
#define SDLENV_AUDIODRIVER              "SDL_AUDIODRIVER"
#define SDLENV_RENDERDRIVER             "SDL_VIDEO_RENDERER"

#define SDLMAME_SOUND_LOG               "sound.log"

#ifdef SDLMAME_MACOSX
/* Vas Crabb: Default GL-lib for MACOSX */
#define SDLOPTVAL_GLLIB                 "/System/Library/Frameworks/OpenGL.framework/Libraries/libGL.dylib"
#else
#define SDLOPTVAL_GLLIB                 OSDOPTVAL_AUTO
#endif


//============================================================
//  TYPE DEFINITIONS
//============================================================

class sdl_options : public osd_options
{
public:
	// construction/destruction
	sdl_options();

	// performance options
	bool video_fps() const { return bool_value(SDLOPTION_SDLVIDEOFPS); }

	// video options
	bool centerh() const { return bool_value(SDLOPTION_CENTERH); }
	bool centerv() const { return bool_value(SDLOPTION_CENTERV); }
	const char *scale_mode() const { return value(SDLOPTION_SCALEMODE); }

	// full screen options
#ifdef SDLMAME_X11
	bool use_all_heads() const { return bool_value(SDLOPTION_USEALLHEADS); }
	const char *attach_window() const { return value(SDLOPTION_ATTACH_WINDOW); }
#endif // SDLMAME_X11

	// keyboard mapping
	bool keymap() const { return bool_value(SDLOPTION_KEYMAP); }
	const char *keymap_file() const { return value(SDLOPTION_KEYMAP_FILE); }

	// joystick mapping
	bool sixaxis() const { return bool_value(SDLOPTION_SIXAXIS); }

	const char *video_driver() const { return value(SDLOPTION_VIDEODRIVER); }
	const char *render_driver() const { return value(SDLOPTION_RENDERDRIVER); }
	const char *audio_driver() const { return value(SDLOPTION_AUDIODRIVER); }
#if USE_OPENGL
	const char *gl_lib() const { return value(SDLOPTION_GL_LIB); }
#endif

private:
	static const options_entry s_option_entries[];
};


class sdl_osd_interface : public osd_common_t
{
public:
	// construction/destruction
	sdl_osd_interface(sdl_options &options);
	virtual ~sdl_osd_interface();

	// general overridables
	virtual void init(running_machine &machine) override;
	virtual void update(bool skip_redraw) override;
	virtual void input_update() override;

	// input overridables
	virtual void customize_input_type_list(std::vector<input_type_entry> &typelist) override;

	virtual void video_register() override;

	virtual bool video_init() override;
	virtual bool window_init() override;

	virtual void video_exit() override;
	virtual void window_exit() override;

	// sdl specific
	void poll_inputs(running_machine &machine);
	void release_keys();
	bool should_hide_mouse();
	void process_events_buf();

	virtual sdl_options &options() override { return m_options; }

protected:
	virtual void build_slider_list() override;
	virtual void update_slider_list() override;

private:
	virtual void osd_exit() override;

	void extract_video_config();
	void output_oslog(const char *buffer);

	sdl_options &m_options;
};

//============================================================
//  sdlwork.c
//============================================================

extern int osd_num_processors;

#endif // MAME_OSD_SDL_OSDSDL_H
