/* Autogenerated: ECCKiila https://gitlab.com/nisec/ecckiila */
/*-
 * MIT License
 * 
 * Copyright (c) 2020 Luis Rivera-Zamarripa, Jesús-Javier Chi-Domínguez, Billy Bob Brumley
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#if defined(__SIZEOF_INT128__) && !defined(PEDANTIC)

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 64
#define LIMB_CNT 6
/* Field elements */
typedef uint64_t fe_t[LIMB_CNT];
typedef uint64_t limb_t;

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: word_by_word_montgomery --static secp384r1 64 '2^384 - 2^128 - 2^96 + 2^32 - 1' */
/* curve description: secp384r1 */
/* machine_wordsize = 64 (from "64") */
/* requested operations: (all) */
/* m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from "2^384 - 2^128 - 2^96 + 2^32 - 1") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) */

#include <stdint.h>
typedef unsigned char fiat_secp384r1_uint1;
typedef signed char fiat_secp384r1_int1;
typedef signed __int128 fiat_secp384r1_int128;
typedef unsigned __int128 fiat_secp384r1_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

/*
 * The function fiat_secp384r1_addcarryx_u64 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^64
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void
fiat_secp384r1_addcarryx_u64(uint64_t *out1,
                             fiat_secp384r1_uint1 *out2,
                             fiat_secp384r1_uint1 arg1,
                             uint64_t arg2, uint64_t arg3)
{
    fiat_secp384r1_uint128 x1;
    uint64_t x2;
    fiat_secp384r1_uint1 x3;
    x1 = ((arg1 + (fiat_secp384r1_uint128)arg2) + arg3);
    x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    x3 = (fiat_secp384r1_uint1)(x1 >> 64);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_secp384r1_subborrowx_u64 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^64
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void
fiat_secp384r1_subborrowx_u64(uint64_t *out1,
                              fiat_secp384r1_uint1 *out2,
                              fiat_secp384r1_uint1 arg1,
                              uint64_t arg2, uint64_t arg3)
{
    fiat_secp384r1_int128 x1;
    fiat_secp384r1_int1 x2;
    uint64_t x3;
    x1 = ((arg2 - (fiat_secp384r1_int128)arg1) - arg3);
    x2 = (fiat_secp384r1_int1)(x1 >> 64);
    x3 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    *out1 = x3;
    *out2 = (fiat_secp384r1_uint1)(0x0 - x2);
}

/*
 * The function fiat_secp384r1_mulx_u64 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^64
 *   out2 = ⌊arg1 * arg2 / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffffffffffff]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0xffffffffffffffff]
 */
static void
fiat_secp384r1_mulx_u64(uint64_t *out1, uint64_t *out2,
                        uint64_t arg1, uint64_t arg2)
{
    fiat_secp384r1_uint128 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = ((fiat_secp384r1_uint128)arg1 * arg2);
    x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    x3 = (uint64_t)(x1 >> 64);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_secp384r1_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void
fiat_secp384r1_cmovznz_u64(uint64_t *out1,
                           fiat_secp384r1_uint1 arg1, uint64_t arg2,
                           uint64_t arg3)
{
    fiat_secp384r1_uint1 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_secp384r1_int1)(0x0 - x1) & UINT64_C(0xffffffffffffffff));
    x3 = ((x2 & arg3) | ((~x2) & arg2));
    *out1 = x3;
}

/*
 * The function fiat_secp384r1_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_mul(uint64_t out1[6], const uint64_t arg1[6],
                   const uint64_t arg2[6])
{
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    fiat_secp384r1_uint1 x20;
    uint64_t x21;
    fiat_secp384r1_uint1 x22;
    uint64_t x23;
    fiat_secp384r1_uint1 x24;
    uint64_t x25;
    fiat_secp384r1_uint1 x26;
    uint64_t x27;
    fiat_secp384r1_uint1 x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    fiat_secp384r1_uint1 x45;
    uint64_t x46;
    fiat_secp384r1_uint1 x47;
    uint64_t x48;
    fiat_secp384r1_uint1 x49;
    uint64_t x50;
    fiat_secp384r1_uint1 x51;
    uint64_t x52;
    fiat_secp384r1_uint1 x53;
    uint64_t x54;
    uint64_t x55;
    fiat_secp384r1_uint1 x56;
    uint64_t x57;
    fiat_secp384r1_uint1 x58;
    uint64_t x59;
    fiat_secp384r1_uint1 x60;
    uint64_t x61;
    fiat_secp384r1_uint1 x62;
    uint64_t x63;
    fiat_secp384r1_uint1 x64;
    uint64_t x65;
    fiat_secp384r1_uint1 x66;
    uint64_t x67;
    fiat_secp384r1_uint1 x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    fiat_secp384r1_uint1 x82;
    uint64_t x83;
    fiat_secp384r1_uint1 x84;
    uint64_t x85;
    fiat_secp384r1_uint1 x86;
    uint64_t x87;
    fiat_secp384r1_uint1 x88;
    uint64_t x89;
    fiat_secp384r1_uint1 x90;
    uint64_t x91;
    uint64_t x92;
    fiat_secp384r1_uint1 x93;
    uint64_t x94;
    fiat_secp384r1_uint1 x95;
    uint64_t x96;
    fiat_secp384r1_uint1 x97;
    uint64_t x98;
    fiat_secp384r1_uint1 x99;
    uint64_t x100;
    fiat_secp384r1_uint1 x101;
    uint64_t x102;
    fiat_secp384r1_uint1 x103;
    uint64_t x104;
    fiat_secp384r1_uint1 x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    uint64_t x110;
    uint64_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint64_t x118;
    uint64_t x119;
    uint64_t x120;
    fiat_secp384r1_uint1 x121;
    uint64_t x122;
    fiat_secp384r1_uint1 x123;
    uint64_t x124;
    fiat_secp384r1_uint1 x125;
    uint64_t x126;
    fiat_secp384r1_uint1 x127;
    uint64_t x128;
    fiat_secp384r1_uint1 x129;
    uint64_t x130;
    uint64_t x131;
    fiat_secp384r1_uint1 x132;
    uint64_t x133;
    fiat_secp384r1_uint1 x134;
    uint64_t x135;
    fiat_secp384r1_uint1 x136;
    uint64_t x137;
    fiat_secp384r1_uint1 x138;
    uint64_t x139;
    fiat_secp384r1_uint1 x140;
    uint64_t x141;
    fiat_secp384r1_uint1 x142;
    uint64_t x143;
    fiat_secp384r1_uint1 x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    fiat_secp384r1_uint1 x159;
    uint64_t x160;
    fiat_secp384r1_uint1 x161;
    uint64_t x162;
    fiat_secp384r1_uint1 x163;
    uint64_t x164;
    fiat_secp384r1_uint1 x165;
    uint64_t x166;
    fiat_secp384r1_uint1 x167;
    uint64_t x168;
    uint64_t x169;
    fiat_secp384r1_uint1 x170;
    uint64_t x171;
    fiat_secp384r1_uint1 x172;
    uint64_t x173;
    fiat_secp384r1_uint1 x174;
    uint64_t x175;
    fiat_secp384r1_uint1 x176;
    uint64_t x177;
    fiat_secp384r1_uint1 x178;
    uint64_t x179;
    fiat_secp384r1_uint1 x180;
    uint64_t x181;
    fiat_secp384r1_uint1 x182;
    uint64_t x183;
    uint64_t x184;
    uint64_t x185;
    uint64_t x186;
    uint64_t x187;
    uint64_t x188;
    uint64_t x189;
    uint64_t x190;
    uint64_t x191;
    uint64_t x192;
    uint64_t x193;
    uint64_t x194;
    uint64_t x195;
    uint64_t x196;
    uint64_t x197;
    fiat_secp384r1_uint1 x198;
    uint64_t x199;
    fiat_secp384r1_uint1 x200;
    uint64_t x201;
    fiat_secp384r1_uint1 x202;
    uint64_t x203;
    fiat_secp384r1_uint1 x204;
    uint64_t x205;
    fiat_secp384r1_uint1 x206;
    uint64_t x207;
    uint64_t x208;
    fiat_secp384r1_uint1 x209;
    uint64_t x210;
    fiat_secp384r1_uint1 x211;
    uint64_t x212;
    fiat_secp384r1_uint1 x213;
    uint64_t x214;
    fiat_secp384r1_uint1 x215;
    uint64_t x216;
    fiat_secp384r1_uint1 x217;
    uint64_t x218;
    fiat_secp384r1_uint1 x219;
    uint64_t x220;
    fiat_secp384r1_uint1 x221;
    uint64_t x222;
    uint64_t x223;
    uint64_t x224;
    uint64_t x225;
    uint64_t x226;
    uint64_t x227;
    uint64_t x228;
    uint64_t x229;
    uint64_t x230;
    uint64_t x231;
    uint64_t x232;
    uint64_t x233;
    uint64_t x234;
    uint64_t x235;
    fiat_secp384r1_uint1 x236;
    uint64_t x237;
    fiat_secp384r1_uint1 x238;
    uint64_t x239;
    fiat_secp384r1_uint1 x240;
    uint64_t x241;
    fiat_secp384r1_uint1 x242;
    uint64_t x243;
    fiat_secp384r1_uint1 x244;
    uint64_t x245;
    uint64_t x246;
    fiat_secp384r1_uint1 x247;
    uint64_t x248;
    fiat_secp384r1_uint1 x249;
    uint64_t x250;
    fiat_secp384r1_uint1 x251;
    uint64_t x252;
    fiat_secp384r1_uint1 x253;
    uint64_t x254;
    fiat_secp384r1_uint1 x255;
    uint64_t x256;
    fiat_secp384r1_uint1 x257;
    uint64_t x258;
    fiat_secp384r1_uint1 x259;
    uint64_t x260;
    uint64_t x261;
    uint64_t x262;
    uint64_t x263;
    uint64_t x264;
    uint64_t x265;
    uint64_t x266;
    uint64_t x267;
    uint64_t x268;
    uint64_t x269;
    uint64_t x270;
    uint64_t x271;
    uint64_t x272;
    uint64_t x273;
    uint64_t x274;
    fiat_secp384r1_uint1 x275;
    uint64_t x276;
    fiat_secp384r1_uint1 x277;
    uint64_t x278;
    fiat_secp384r1_uint1 x279;
    uint64_t x280;
    fiat_secp384r1_uint1 x281;
    uint64_t x282;
    fiat_secp384r1_uint1 x283;
    uint64_t x284;
    uint64_t x285;
    fiat_secp384r1_uint1 x286;
    uint64_t x287;
    fiat_secp384r1_uint1 x288;
    uint64_t x289;
    fiat_secp384r1_uint1 x290;
    uint64_t x291;
    fiat_secp384r1_uint1 x292;
    uint64_t x293;
    fiat_secp384r1_uint1 x294;
    uint64_t x295;
    fiat_secp384r1_uint1 x296;
    uint64_t x297;
    fiat_secp384r1_uint1 x298;
    uint64_t x299;
    uint64_t x300;
    uint64_t x301;
    uint64_t x302;
    uint64_t x303;
    uint64_t x304;
    uint64_t x305;
    uint64_t x306;
    uint64_t x307;
    uint64_t x308;
    uint64_t x309;
    uint64_t x310;
    uint64_t x311;
    uint64_t x312;
    fiat_secp384r1_uint1 x313;
    uint64_t x314;
    fiat_secp384r1_uint1 x315;
    uint64_t x316;
    fiat_secp384r1_uint1 x317;
    uint64_t x318;
    fiat_secp384r1_uint1 x319;
    uint64_t x320;
    fiat_secp384r1_uint1 x321;
    uint64_t x322;
    uint64_t x323;
    fiat_secp384r1_uint1 x324;
    uint64_t x325;
    fiat_secp384r1_uint1 x326;
    uint64_t x327;
    fiat_secp384r1_uint1 x328;
    uint64_t x329;
    fiat_secp384r1_uint1 x330;
    uint64_t x331;
    fiat_secp384r1_uint1 x332;
    uint64_t x333;
    fiat_secp384r1_uint1 x334;
    uint64_t x335;
    fiat_secp384r1_uint1 x336;
    uint64_t x337;
    uint64_t x338;
    uint64_t x339;
    uint64_t x340;
    uint64_t x341;
    uint64_t x342;
    uint64_t x343;
    uint64_t x344;
    uint64_t x345;
    uint64_t x346;
    uint64_t x347;
    uint64_t x348;
    uint64_t x349;
    uint64_t x350;
    uint64_t x351;
    fiat_secp384r1_uint1 x352;
    uint64_t x353;
    fiat_secp384r1_uint1 x354;
    uint64_t x355;
    fiat_secp384r1_uint1 x356;
    uint64_t x357;
    fiat_secp384r1_uint1 x358;
    uint64_t x359;
    fiat_secp384r1_uint1 x360;
    uint64_t x361;
    uint64_t x362;
    fiat_secp384r1_uint1 x363;
    uint64_t x364;
    fiat_secp384r1_uint1 x365;
    uint64_t x366;
    fiat_secp384r1_uint1 x367;
    uint64_t x368;
    fiat_secp384r1_uint1 x369;
    uint64_t x370;
    fiat_secp384r1_uint1 x371;
    uint64_t x372;
    fiat_secp384r1_uint1 x373;
    uint64_t x374;
    fiat_secp384r1_uint1 x375;
    uint64_t x376;
    uint64_t x377;
    uint64_t x378;
    uint64_t x379;
    uint64_t x380;
    uint64_t x381;
    uint64_t x382;
    uint64_t x383;
    uint64_t x384;
    uint64_t x385;
    uint64_t x386;
    uint64_t x387;
    uint64_t x388;
    uint64_t x389;
    fiat_secp384r1_uint1 x390;
    uint64_t x391;
    fiat_secp384r1_uint1 x392;
    uint64_t x393;
    fiat_secp384r1_uint1 x394;
    uint64_t x395;
    fiat_secp384r1_uint1 x396;
    uint64_t x397;
    fiat_secp384r1_uint1 x398;
    uint64_t x399;
    uint64_t x400;
    fiat_secp384r1_uint1 x401;
    uint64_t x402;
    fiat_secp384r1_uint1 x403;
    uint64_t x404;
    fiat_secp384r1_uint1 x405;
    uint64_t x406;
    fiat_secp384r1_uint1 x407;
    uint64_t x408;
    fiat_secp384r1_uint1 x409;
    uint64_t x410;
    fiat_secp384r1_uint1 x411;
    uint64_t x412;
    fiat_secp384r1_uint1 x413;
    uint64_t x414;
    uint64_t x415;
    uint64_t x416;
    uint64_t x417;
    uint64_t x418;
    uint64_t x419;
    uint64_t x420;
    uint64_t x421;
    uint64_t x422;
    uint64_t x423;
    uint64_t x424;
    uint64_t x425;
    uint64_t x426;
    uint64_t x427;
    uint64_t x428;
    fiat_secp384r1_uint1 x429;
    uint64_t x430;
    fiat_secp384r1_uint1 x431;
    uint64_t x432;
    fiat_secp384r1_uint1 x433;
    uint64_t x434;
    fiat_secp384r1_uint1 x435;
    uint64_t x436;
    fiat_secp384r1_uint1 x437;
    uint64_t x438;
    uint64_t x439;
    fiat_secp384r1_uint1 x440;
    uint64_t x441;
    fiat_secp384r1_uint1 x442;
    uint64_t x443;
    fiat_secp384r1_uint1 x444;
    uint64_t x445;
    fiat_secp384r1_uint1 x446;
    uint64_t x447;
    fiat_secp384r1_uint1 x448;
    uint64_t x449;
    fiat_secp384r1_uint1 x450;
    uint64_t x451;
    fiat_secp384r1_uint1 x452;
    uint64_t x453;
    uint64_t x454;
    fiat_secp384r1_uint1 x455;
    uint64_t x456;
    fiat_secp384r1_uint1 x457;
    uint64_t x458;
    fiat_secp384r1_uint1 x459;
    uint64_t x460;
    fiat_secp384r1_uint1 x461;
    uint64_t x462;
    fiat_secp384r1_uint1 x463;
    uint64_t x464;
    fiat_secp384r1_uint1 x465;
    uint64_t x466;
    fiat_secp384r1_uint1 x467;
    uint64_t x468;
    uint64_t x469;
    uint64_t x470;
    uint64_t x471;
    uint64_t x472;
    uint64_t x473;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[0]);
    fiat_secp384r1_mulx_u64(&x7, &x8, x6, (arg2[5]));
    fiat_secp384r1_mulx_u64(&x9, &x10, x6, (arg2[4]));
    fiat_secp384r1_mulx_u64(&x11, &x12, x6, (arg2[3]));
    fiat_secp384r1_mulx_u64(&x13, &x14, x6, (arg2[2]));
    fiat_secp384r1_mulx_u64(&x15, &x16, x6, (arg2[1]));
    fiat_secp384r1_mulx_u64(&x17, &x18, x6, (arg2[0]));
    fiat_secp384r1_addcarryx_u64(&x19, &x20, 0x0, x18, x15);
    fiat_secp384r1_addcarryx_u64(&x21, &x22, x20, x16, x13);
    fiat_secp384r1_addcarryx_u64(&x23, &x24, x22, x14, x11);
    fiat_secp384r1_addcarryx_u64(&x25, &x26, x24, x12, x9);
    fiat_secp384r1_addcarryx_u64(&x27, &x28, x26, x10, x7);
    x29 = (x28 + x8);
    fiat_secp384r1_mulx_u64(&x30, &x31, x17, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x32, &x33, x30, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x34, &x35, x30, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x36, &x37, x30, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x38, &x39, x30, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x40, &x41, x30, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x42, &x43, x30, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x44, &x45, 0x0, x43, x40);
    fiat_secp384r1_addcarryx_u64(&x46, &x47, x45, x41, x38);
    fiat_secp384r1_addcarryx_u64(&x48, &x49, x47, x39, x36);
    fiat_secp384r1_addcarryx_u64(&x50, &x51, x49, x37, x34);
    fiat_secp384r1_addcarryx_u64(&x52, &x53, x51, x35, x32);
    x54 = (x53 + x33);
    fiat_secp384r1_addcarryx_u64(&x55, &x56, 0x0, x17, x42);
    fiat_secp384r1_addcarryx_u64(&x57, &x58, x56, x19, x44);
    fiat_secp384r1_addcarryx_u64(&x59, &x60, x58, x21, x46);
    fiat_secp384r1_addcarryx_u64(&x61, &x62, x60, x23, x48);
    fiat_secp384r1_addcarryx_u64(&x63, &x64, x62, x25, x50);
    fiat_secp384r1_addcarryx_u64(&x65, &x66, x64, x27, x52);
    fiat_secp384r1_addcarryx_u64(&x67, &x68, x66, x29, x54);
    fiat_secp384r1_mulx_u64(&x69, &x70, x1, (arg2[5]));
    fiat_secp384r1_mulx_u64(&x71, &x72, x1, (arg2[4]));
    fiat_secp384r1_mulx_u64(&x73, &x74, x1, (arg2[3]));
    fiat_secp384r1_mulx_u64(&x75, &x76, x1, (arg2[2]));
    fiat_secp384r1_mulx_u64(&x77, &x78, x1, (arg2[1]));
    fiat_secp384r1_mulx_u64(&x79, &x80, x1, (arg2[0]));
    fiat_secp384r1_addcarryx_u64(&x81, &x82, 0x0, x80, x77);
    fiat_secp384r1_addcarryx_u64(&x83, &x84, x82, x78, x75);
    fiat_secp384r1_addcarryx_u64(&x85, &x86, x84, x76, x73);
    fiat_secp384r1_addcarryx_u64(&x87, &x88, x86, x74, x71);
    fiat_secp384r1_addcarryx_u64(&x89, &x90, x88, x72, x69);
    x91 = (x90 + x70);
    fiat_secp384r1_addcarryx_u64(&x92, &x93, 0x0, x57, x79);
    fiat_secp384r1_addcarryx_u64(&x94, &x95, x93, x59, x81);
    fiat_secp384r1_addcarryx_u64(&x96, &x97, x95, x61, x83);
    fiat_secp384r1_addcarryx_u64(&x98, &x99, x97, x63, x85);
    fiat_secp384r1_addcarryx_u64(&x100, &x101, x99, x65, x87);
    fiat_secp384r1_addcarryx_u64(&x102, &x103, x101, x67, x89);
    fiat_secp384r1_addcarryx_u64(&x104, &x105, x103, x68, x91);
    fiat_secp384r1_mulx_u64(&x106, &x107, x92, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x108, &x109, x106, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x110, &x111, x106, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x112, &x113, x106, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x114, &x115, x106, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x116, &x117, x106, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x118, &x119, x106, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x120, &x121, 0x0, x119, x116);
    fiat_secp384r1_addcarryx_u64(&x122, &x123, x121, x117, x114);
    fiat_secp384r1_addcarryx_u64(&x124, &x125, x123, x115, x112);
    fiat_secp384r1_addcarryx_u64(&x126, &x127, x125, x113, x110);
    fiat_secp384r1_addcarryx_u64(&x128, &x129, x127, x111, x108);
    x130 = (x129 + x109);
    fiat_secp384r1_addcarryx_u64(&x131, &x132, 0x0, x92, x118);
    fiat_secp384r1_addcarryx_u64(&x133, &x134, x132, x94, x120);
    fiat_secp384r1_addcarryx_u64(&x135, &x136, x134, x96, x122);
    fiat_secp384r1_addcarryx_u64(&x137, &x138, x136, x98, x124);
    fiat_secp384r1_addcarryx_u64(&x139, &x140, x138, x100, x126);
    fiat_secp384r1_addcarryx_u64(&x141, &x142, x140, x102, x128);
    fiat_secp384r1_addcarryx_u64(&x143, &x144, x142, x104, x130);
    x145 = ((uint64_t)x144 + x105);
    fiat_secp384r1_mulx_u64(&x146, &x147, x2, (arg2[5]));
    fiat_secp384r1_mulx_u64(&x148, &x149, x2, (arg2[4]));
    fiat_secp384r1_mulx_u64(&x150, &x151, x2, (arg2[3]));
    fiat_secp384r1_mulx_u64(&x152, &x153, x2, (arg2[2]));
    fiat_secp384r1_mulx_u64(&x154, &x155, x2, (arg2[1]));
    fiat_secp384r1_mulx_u64(&x156, &x157, x2, (arg2[0]));
    fiat_secp384r1_addcarryx_u64(&x158, &x159, 0x0, x157, x154);
    fiat_secp384r1_addcarryx_u64(&x160, &x161, x159, x155, x152);
    fiat_secp384r1_addcarryx_u64(&x162, &x163, x161, x153, x150);
    fiat_secp384r1_addcarryx_u64(&x164, &x165, x163, x151, x148);
    fiat_secp384r1_addcarryx_u64(&x166, &x167, x165, x149, x146);
    x168 = (x167 + x147);
    fiat_secp384r1_addcarryx_u64(&x169, &x170, 0x0, x133, x156);
    fiat_secp384r1_addcarryx_u64(&x171, &x172, x170, x135, x158);
    fiat_secp384r1_addcarryx_u64(&x173, &x174, x172, x137, x160);
    fiat_secp384r1_addcarryx_u64(&x175, &x176, x174, x139, x162);
    fiat_secp384r1_addcarryx_u64(&x177, &x178, x176, x141, x164);
    fiat_secp384r1_addcarryx_u64(&x179, &x180, x178, x143, x166);
    fiat_secp384r1_addcarryx_u64(&x181, &x182, x180, x145, x168);
    fiat_secp384r1_mulx_u64(&x183, &x184, x169, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x185, &x186, x183, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x187, &x188, x183, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x189, &x190, x183, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x191, &x192, x183, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x193, &x194, x183, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x195, &x196, x183, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x197, &x198, 0x0, x196, x193);
    fiat_secp384r1_addcarryx_u64(&x199, &x200, x198, x194, x191);
    fiat_secp384r1_addcarryx_u64(&x201, &x202, x200, x192, x189);
    fiat_secp384r1_addcarryx_u64(&x203, &x204, x202, x190, x187);
    fiat_secp384r1_addcarryx_u64(&x205, &x206, x204, x188, x185);
    x207 = (x206 + x186);
    fiat_secp384r1_addcarryx_u64(&x208, &x209, 0x0, x169, x195);
    fiat_secp384r1_addcarryx_u64(&x210, &x211, x209, x171, x197);
    fiat_secp384r1_addcarryx_u64(&x212, &x213, x211, x173, x199);
    fiat_secp384r1_addcarryx_u64(&x214, &x215, x213, x175, x201);
    fiat_secp384r1_addcarryx_u64(&x216, &x217, x215, x177, x203);
    fiat_secp384r1_addcarryx_u64(&x218, &x219, x217, x179, x205);
    fiat_secp384r1_addcarryx_u64(&x220, &x221, x219, x181, x207);
    x222 = ((uint64_t)x221 + x182);
    fiat_secp384r1_mulx_u64(&x223, &x224, x3, (arg2[5]));
    fiat_secp384r1_mulx_u64(&x225, &x226, x3, (arg2[4]));
    fiat_secp384r1_mulx_u64(&x227, &x228, x3, (arg2[3]));
    fiat_secp384r1_mulx_u64(&x229, &x230, x3, (arg2[2]));
    fiat_secp384r1_mulx_u64(&x231, &x232, x3, (arg2[1]));
    fiat_secp384r1_mulx_u64(&x233, &x234, x3, (arg2[0]));
    fiat_secp384r1_addcarryx_u64(&x235, &x236, 0x0, x234, x231);
    fiat_secp384r1_addcarryx_u64(&x237, &x238, x236, x232, x229);
    fiat_secp384r1_addcarryx_u64(&x239, &x240, x238, x230, x227);
    fiat_secp384r1_addcarryx_u64(&x241, &x242, x240, x228, x225);
    fiat_secp384r1_addcarryx_u64(&x243, &x244, x242, x226, x223);
    x245 = (x244 + x224);
    fiat_secp384r1_addcarryx_u64(&x246, &x247, 0x0, x210, x233);
    fiat_secp384r1_addcarryx_u64(&x248, &x249, x247, x212, x235);
    fiat_secp384r1_addcarryx_u64(&x250, &x251, x249, x214, x237);
    fiat_secp384r1_addcarryx_u64(&x252, &x253, x251, x216, x239);
    fiat_secp384r1_addcarryx_u64(&x254, &x255, x253, x218, x241);
    fiat_secp384r1_addcarryx_u64(&x256, &x257, x255, x220, x243);
    fiat_secp384r1_addcarryx_u64(&x258, &x259, x257, x222, x245);
    fiat_secp384r1_mulx_u64(&x260, &x261, x246, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x262, &x263, x260, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x264, &x265, x260, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x266, &x267, x260, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x268, &x269, x260, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x270, &x271, x260, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x272, &x273, x260, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x274, &x275, 0x0, x273, x270);
    fiat_secp384r1_addcarryx_u64(&x276, &x277, x275, x271, x268);
    fiat_secp384r1_addcarryx_u64(&x278, &x279, x277, x269, x266);
    fiat_secp384r1_addcarryx_u64(&x280, &x281, x279, x267, x264);
    fiat_secp384r1_addcarryx_u64(&x282, &x283, x281, x265, x262);
    x284 = (x283 + x263);
    fiat_secp384r1_addcarryx_u64(&x285, &x286, 0x0, x246, x272);
    fiat_secp384r1_addcarryx_u64(&x287, &x288, x286, x248, x274);
    fiat_secp384r1_addcarryx_u64(&x289, &x290, x288, x250, x276);
    fiat_secp384r1_addcarryx_u64(&x291, &x292, x290, x252, x278);
    fiat_secp384r1_addcarryx_u64(&x293, &x294, x292, x254, x280);
    fiat_secp384r1_addcarryx_u64(&x295, &x296, x294, x256, x282);
    fiat_secp384r1_addcarryx_u64(&x297, &x298, x296, x258, x284);
    x299 = ((uint64_t)x298 + x259);
    fiat_secp384r1_mulx_u64(&x300, &x301, x4, (arg2[5]));
    fiat_secp384r1_mulx_u64(&x302, &x303, x4, (arg2[4]));
    fiat_secp384r1_mulx_u64(&x304, &x305, x4, (arg2[3]));
    fiat_secp384r1_mulx_u64(&x306, &x307, x4, (arg2[2]));
    fiat_secp384r1_mulx_u64(&x308, &x309, x4, (arg2[1]));
    fiat_secp384r1_mulx_u64(&x310, &x311, x4, (arg2[0]));
    fiat_secp384r1_addcarryx_u64(&x312, &x313, 0x0, x311, x308);
    fiat_secp384r1_addcarryx_u64(&x314, &x315, x313, x309, x306);
    fiat_secp384r1_addcarryx_u64(&x316, &x317, x315, x307, x304);
    fiat_secp384r1_addcarryx_u64(&x318, &x319, x317, x305, x302);
    fiat_secp384r1_addcarryx_u64(&x320, &x321, x319, x303, x300);
    x322 = (x321 + x301);
    fiat_secp384r1_addcarryx_u64(&x323, &x324, 0x0, x287, x310);
    fiat_secp384r1_addcarryx_u64(&x325, &x326, x324, x289, x312);
    fiat_secp384r1_addcarryx_u64(&x327, &x328, x326, x291, x314);
    fiat_secp384r1_addcarryx_u64(&x329, &x330, x328, x293, x316);
    fiat_secp384r1_addcarryx_u64(&x331, &x332, x330, x295, x318);
    fiat_secp384r1_addcarryx_u64(&x333, &x334, x332, x297, x320);
    fiat_secp384r1_addcarryx_u64(&x335, &x336, x334, x299, x322);
    fiat_secp384r1_mulx_u64(&x337, &x338, x323, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x339, &x340, x337, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x341, &x342, x337, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x343, &x344, x337, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x345, &x346, x337, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x347, &x348, x337, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x349, &x350, x337, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x351, &x352, 0x0, x350, x347);
    fiat_secp384r1_addcarryx_u64(&x353, &x354, x352, x348, x345);
    fiat_secp384r1_addcarryx_u64(&x355, &x356, x354, x346, x343);
    fiat_secp384r1_addcarryx_u64(&x357, &x358, x356, x344, x341);
    fiat_secp384r1_addcarryx_u64(&x359, &x360, x358, x342, x339);
    x361 = (x360 + x340);
    fiat_secp384r1_addcarryx_u64(&x362, &x363, 0x0, x323, x349);
    fiat_secp384r1_addcarryx_u64(&x364, &x365, x363, x325, x351);
    fiat_secp384r1_addcarryx_u64(&x366, &x367, x365, x327, x353);
    fiat_secp384r1_addcarryx_u64(&x368, &x369, x367, x329, x355);
    fiat_secp384r1_addcarryx_u64(&x370, &x371, x369, x331, x357);
    fiat_secp384r1_addcarryx_u64(&x372, &x373, x371, x333, x359);
    fiat_secp384r1_addcarryx_u64(&x374, &x375, x373, x335, x361);
    x376 = ((uint64_t)x375 + x336);
    fiat_secp384r1_mulx_u64(&x377, &x378, x5, (arg2[5]));
    fiat_secp384r1_mulx_u64(&x379, &x380, x5, (arg2[4]));
    fiat_secp384r1_mulx_u64(&x381, &x382, x5, (arg2[3]));
    fiat_secp384r1_mulx_u64(&x383, &x384, x5, (arg2[2]));
    fiat_secp384r1_mulx_u64(&x385, &x386, x5, (arg2[1]));
    fiat_secp384r1_mulx_u64(&x387, &x388, x5, (arg2[0]));
    fiat_secp384r1_addcarryx_u64(&x389, &x390, 0x0, x388, x385);
    fiat_secp384r1_addcarryx_u64(&x391, &x392, x390, x386, x383);
    fiat_secp384r1_addcarryx_u64(&x393, &x394, x392, x384, x381);
    fiat_secp384r1_addcarryx_u64(&x395, &x396, x394, x382, x379);
    fiat_secp384r1_addcarryx_u64(&x397, &x398, x396, x380, x377);
    x399 = (x398 + x378);
    fiat_secp384r1_addcarryx_u64(&x400, &x401, 0x0, x364, x387);
    fiat_secp384r1_addcarryx_u64(&x402, &x403, x401, x366, x389);
    fiat_secp384r1_addcarryx_u64(&x404, &x405, x403, x368, x391);
    fiat_secp384r1_addcarryx_u64(&x406, &x407, x405, x370, x393);
    fiat_secp384r1_addcarryx_u64(&x408, &x409, x407, x372, x395);
    fiat_secp384r1_addcarryx_u64(&x410, &x411, x409, x374, x397);
    fiat_secp384r1_addcarryx_u64(&x412, &x413, x411, x376, x399);
    fiat_secp384r1_mulx_u64(&x414, &x415, x400, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x416, &x417, x414, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x418, &x419, x414, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x420, &x421, x414, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x422, &x423, x414, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x424, &x425, x414, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x426, &x427, x414, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x428, &x429, 0x0, x427, x424);
    fiat_secp384r1_addcarryx_u64(&x430, &x431, x429, x425, x422);
    fiat_secp384r1_addcarryx_u64(&x432, &x433, x431, x423, x420);
    fiat_secp384r1_addcarryx_u64(&x434, &x435, x433, x421, x418);
    fiat_secp384r1_addcarryx_u64(&x436, &x437, x435, x419, x416);
    x438 = (x437 + x417);
    fiat_secp384r1_addcarryx_u64(&x439, &x440, 0x0, x400, x426);
    fiat_secp384r1_addcarryx_u64(&x441, &x442, x440, x402, x428);
    fiat_secp384r1_addcarryx_u64(&x443, &x444, x442, x404, x430);
    fiat_secp384r1_addcarryx_u64(&x445, &x446, x444, x406, x432);
    fiat_secp384r1_addcarryx_u64(&x447, &x448, x446, x408, x434);
    fiat_secp384r1_addcarryx_u64(&x449, &x450, x448, x410, x436);
    fiat_secp384r1_addcarryx_u64(&x451, &x452, x450, x412, x438);
    x453 = ((uint64_t)x452 + x413);
    fiat_secp384r1_subborrowx_u64(&x454, &x455, 0x0, x441,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u64(&x456, &x457, x455, x443,
                                  UINT64_C(0xffffffff00000000));
    fiat_secp384r1_subborrowx_u64(&x458, &x459, x457, x445,
                                  UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_subborrowx_u64(&x460, &x461, x459, x447,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x462, &x463, x461, x449,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x464, &x465, x463, x451,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x466, &x467, x465, x453, 0x0);
    fiat_secp384r1_cmovznz_u64(&x468, x467, x454, x441);
    fiat_secp384r1_cmovznz_u64(&x469, x467, x456, x443);
    fiat_secp384r1_cmovznz_u64(&x470, x467, x458, x445);
    fiat_secp384r1_cmovznz_u64(&x471, x467, x460, x447);
    fiat_secp384r1_cmovznz_u64(&x472, x467, x462, x449);
    fiat_secp384r1_cmovznz_u64(&x473, x467, x464, x451);
    out1[0] = x468;
    out1[1] = x469;
    out1[2] = x470;
    out1[3] = x471;
    out1[4] = x472;
    out1[5] = x473;
}

/*
 * The function fiat_secp384r1_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_square(uint64_t out1[6], const uint64_t arg1[6])
{
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    fiat_secp384r1_uint1 x20;
    uint64_t x21;
    fiat_secp384r1_uint1 x22;
    uint64_t x23;
    fiat_secp384r1_uint1 x24;
    uint64_t x25;
    fiat_secp384r1_uint1 x26;
    uint64_t x27;
    fiat_secp384r1_uint1 x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    fiat_secp384r1_uint1 x45;
    uint64_t x46;
    fiat_secp384r1_uint1 x47;
    uint64_t x48;
    fiat_secp384r1_uint1 x49;
    uint64_t x50;
    fiat_secp384r1_uint1 x51;
    uint64_t x52;
    fiat_secp384r1_uint1 x53;
    uint64_t x54;
    uint64_t x55;
    fiat_secp384r1_uint1 x56;
    uint64_t x57;
    fiat_secp384r1_uint1 x58;
    uint64_t x59;
    fiat_secp384r1_uint1 x60;
    uint64_t x61;
    fiat_secp384r1_uint1 x62;
    uint64_t x63;
    fiat_secp384r1_uint1 x64;
    uint64_t x65;
    fiat_secp384r1_uint1 x66;
    uint64_t x67;
    fiat_secp384r1_uint1 x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    fiat_secp384r1_uint1 x82;
    uint64_t x83;
    fiat_secp384r1_uint1 x84;
    uint64_t x85;
    fiat_secp384r1_uint1 x86;
    uint64_t x87;
    fiat_secp384r1_uint1 x88;
    uint64_t x89;
    fiat_secp384r1_uint1 x90;
    uint64_t x91;
    uint64_t x92;
    fiat_secp384r1_uint1 x93;
    uint64_t x94;
    fiat_secp384r1_uint1 x95;
    uint64_t x96;
    fiat_secp384r1_uint1 x97;
    uint64_t x98;
    fiat_secp384r1_uint1 x99;
    uint64_t x100;
    fiat_secp384r1_uint1 x101;
    uint64_t x102;
    fiat_secp384r1_uint1 x103;
    uint64_t x104;
    fiat_secp384r1_uint1 x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    uint64_t x110;
    uint64_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint64_t x118;
    uint64_t x119;
    uint64_t x120;
    fiat_secp384r1_uint1 x121;
    uint64_t x122;
    fiat_secp384r1_uint1 x123;
    uint64_t x124;
    fiat_secp384r1_uint1 x125;
    uint64_t x126;
    fiat_secp384r1_uint1 x127;
    uint64_t x128;
    fiat_secp384r1_uint1 x129;
    uint64_t x130;
    uint64_t x131;
    fiat_secp384r1_uint1 x132;
    uint64_t x133;
    fiat_secp384r1_uint1 x134;
    uint64_t x135;
    fiat_secp384r1_uint1 x136;
    uint64_t x137;
    fiat_secp384r1_uint1 x138;
    uint64_t x139;
    fiat_secp384r1_uint1 x140;
    uint64_t x141;
    fiat_secp384r1_uint1 x142;
    uint64_t x143;
    fiat_secp384r1_uint1 x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    uint64_t x150;
    uint64_t x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    fiat_secp384r1_uint1 x159;
    uint64_t x160;
    fiat_secp384r1_uint1 x161;
    uint64_t x162;
    fiat_secp384r1_uint1 x163;
    uint64_t x164;
    fiat_secp384r1_uint1 x165;
    uint64_t x166;
    fiat_secp384r1_uint1 x167;
    uint64_t x168;
    uint64_t x169;
    fiat_secp384r1_uint1 x170;
    uint64_t x171;
    fiat_secp384r1_uint1 x172;
    uint64_t x173;
    fiat_secp384r1_uint1 x174;
    uint64_t x175;
    fiat_secp384r1_uint1 x176;
    uint64_t x177;
    fiat_secp384r1_uint1 x178;
    uint64_t x179;
    fiat_secp384r1_uint1 x180;
    uint64_t x181;
    fiat_secp384r1_uint1 x182;
    uint64_t x183;
    uint64_t x184;
    uint64_t x185;
    uint64_t x186;
    uint64_t x187;
    uint64_t x188;
    uint64_t x189;
    uint64_t x190;
    uint64_t x191;
    uint64_t x192;
    uint64_t x193;
    uint64_t x194;
    uint64_t x195;
    uint64_t x196;
    uint64_t x197;
    fiat_secp384r1_uint1 x198;
    uint64_t x199;
    fiat_secp384r1_uint1 x200;
    uint64_t x201;
    fiat_secp384r1_uint1 x202;
    uint64_t x203;
    fiat_secp384r1_uint1 x204;
    uint64_t x205;
    fiat_secp384r1_uint1 x206;
    uint64_t x207;
    uint64_t x208;
    fiat_secp384r1_uint1 x209;
    uint64_t x210;
    fiat_secp384r1_uint1 x211;
    uint64_t x212;
    fiat_secp384r1_uint1 x213;
    uint64_t x214;
    fiat_secp384r1_uint1 x215;
    uint64_t x216;
    fiat_secp384r1_uint1 x217;
    uint64_t x218;
    fiat_secp384r1_uint1 x219;
    uint64_t x220;
    fiat_secp384r1_uint1 x221;
    uint64_t x222;
    uint64_t x223;
    uint64_t x224;
    uint64_t x225;
    uint64_t x226;
    uint64_t x227;
    uint64_t x228;
    uint64_t x229;
    uint64_t x230;
    uint64_t x231;
    uint64_t x232;
    uint64_t x233;
    uint64_t x234;
    uint64_t x235;
    fiat_secp384r1_uint1 x236;
    uint64_t x237;
    fiat_secp384r1_uint1 x238;
    uint64_t x239;
    fiat_secp384r1_uint1 x240;
    uint64_t x241;
    fiat_secp384r1_uint1 x242;
    uint64_t x243;
    fiat_secp384r1_uint1 x244;
    uint64_t x245;
    uint64_t x246;
    fiat_secp384r1_uint1 x247;
    uint64_t x248;
    fiat_secp384r1_uint1 x249;
    uint64_t x250;
    fiat_secp384r1_uint1 x251;
    uint64_t x252;
    fiat_secp384r1_uint1 x253;
    uint64_t x254;
    fiat_secp384r1_uint1 x255;
    uint64_t x256;
    fiat_secp384r1_uint1 x257;
    uint64_t x258;
    fiat_secp384r1_uint1 x259;
    uint64_t x260;
    uint64_t x261;
    uint64_t x262;
    uint64_t x263;
    uint64_t x264;
    uint64_t x265;
    uint64_t x266;
    uint64_t x267;
    uint64_t x268;
    uint64_t x269;
    uint64_t x270;
    uint64_t x271;
    uint64_t x272;
    uint64_t x273;
    uint64_t x274;
    fiat_secp384r1_uint1 x275;
    uint64_t x276;
    fiat_secp384r1_uint1 x277;
    uint64_t x278;
    fiat_secp384r1_uint1 x279;
    uint64_t x280;
    fiat_secp384r1_uint1 x281;
    uint64_t x282;
    fiat_secp384r1_uint1 x283;
    uint64_t x284;
    uint64_t x285;
    fiat_secp384r1_uint1 x286;
    uint64_t x287;
    fiat_secp384r1_uint1 x288;
    uint64_t x289;
    fiat_secp384r1_uint1 x290;
    uint64_t x291;
    fiat_secp384r1_uint1 x292;
    uint64_t x293;
    fiat_secp384r1_uint1 x294;
    uint64_t x295;
    fiat_secp384r1_uint1 x296;
    uint64_t x297;
    fiat_secp384r1_uint1 x298;
    uint64_t x299;
    uint64_t x300;
    uint64_t x301;
    uint64_t x302;
    uint64_t x303;
    uint64_t x304;
    uint64_t x305;
    uint64_t x306;
    uint64_t x307;
    uint64_t x308;
    uint64_t x309;
    uint64_t x310;
    uint64_t x311;
    uint64_t x312;
    fiat_secp384r1_uint1 x313;
    uint64_t x314;
    fiat_secp384r1_uint1 x315;
    uint64_t x316;
    fiat_secp384r1_uint1 x317;
    uint64_t x318;
    fiat_secp384r1_uint1 x319;
    uint64_t x320;
    fiat_secp384r1_uint1 x321;
    uint64_t x322;
    uint64_t x323;
    fiat_secp384r1_uint1 x324;
    uint64_t x325;
    fiat_secp384r1_uint1 x326;
    uint64_t x327;
    fiat_secp384r1_uint1 x328;
    uint64_t x329;
    fiat_secp384r1_uint1 x330;
    uint64_t x331;
    fiat_secp384r1_uint1 x332;
    uint64_t x333;
    fiat_secp384r1_uint1 x334;
    uint64_t x335;
    fiat_secp384r1_uint1 x336;
    uint64_t x337;
    uint64_t x338;
    uint64_t x339;
    uint64_t x340;
    uint64_t x341;
    uint64_t x342;
    uint64_t x343;
    uint64_t x344;
    uint64_t x345;
    uint64_t x346;
    uint64_t x347;
    uint64_t x348;
    uint64_t x349;
    uint64_t x350;
    uint64_t x351;
    fiat_secp384r1_uint1 x352;
    uint64_t x353;
    fiat_secp384r1_uint1 x354;
    uint64_t x355;
    fiat_secp384r1_uint1 x356;
    uint64_t x357;
    fiat_secp384r1_uint1 x358;
    uint64_t x359;
    fiat_secp384r1_uint1 x360;
    uint64_t x361;
    uint64_t x362;
    fiat_secp384r1_uint1 x363;
    uint64_t x364;
    fiat_secp384r1_uint1 x365;
    uint64_t x366;
    fiat_secp384r1_uint1 x367;
    uint64_t x368;
    fiat_secp384r1_uint1 x369;
    uint64_t x370;
    fiat_secp384r1_uint1 x371;
    uint64_t x372;
    fiat_secp384r1_uint1 x373;
    uint64_t x374;
    fiat_secp384r1_uint1 x375;
    uint64_t x376;
    uint64_t x377;
    uint64_t x378;
    uint64_t x379;
    uint64_t x380;
    uint64_t x381;
    uint64_t x382;
    uint64_t x383;
    uint64_t x384;
    uint64_t x385;
    uint64_t x386;
    uint64_t x387;
    uint64_t x388;
    uint64_t x389;
    fiat_secp384r1_uint1 x390;
    uint64_t x391;
    fiat_secp384r1_uint1 x392;
    uint64_t x393;
    fiat_secp384r1_uint1 x394;
    uint64_t x395;
    fiat_secp384r1_uint1 x396;
    uint64_t x397;
    fiat_secp384r1_uint1 x398;
    uint64_t x399;
    uint64_t x400;
    fiat_secp384r1_uint1 x401;
    uint64_t x402;
    fiat_secp384r1_uint1 x403;
    uint64_t x404;
    fiat_secp384r1_uint1 x405;
    uint64_t x406;
    fiat_secp384r1_uint1 x407;
    uint64_t x408;
    fiat_secp384r1_uint1 x409;
    uint64_t x410;
    fiat_secp384r1_uint1 x411;
    uint64_t x412;
    fiat_secp384r1_uint1 x413;
    uint64_t x414;
    uint64_t x415;
    uint64_t x416;
    uint64_t x417;
    uint64_t x418;
    uint64_t x419;
    uint64_t x420;
    uint64_t x421;
    uint64_t x422;
    uint64_t x423;
    uint64_t x424;
    uint64_t x425;
    uint64_t x426;
    uint64_t x427;
    uint64_t x428;
    fiat_secp384r1_uint1 x429;
    uint64_t x430;
    fiat_secp384r1_uint1 x431;
    uint64_t x432;
    fiat_secp384r1_uint1 x433;
    uint64_t x434;
    fiat_secp384r1_uint1 x435;
    uint64_t x436;
    fiat_secp384r1_uint1 x437;
    uint64_t x438;
    uint64_t x439;
    fiat_secp384r1_uint1 x440;
    uint64_t x441;
    fiat_secp384r1_uint1 x442;
    uint64_t x443;
    fiat_secp384r1_uint1 x444;
    uint64_t x445;
    fiat_secp384r1_uint1 x446;
    uint64_t x447;
    fiat_secp384r1_uint1 x448;
    uint64_t x449;
    fiat_secp384r1_uint1 x450;
    uint64_t x451;
    fiat_secp384r1_uint1 x452;
    uint64_t x453;
    uint64_t x454;
    fiat_secp384r1_uint1 x455;
    uint64_t x456;
    fiat_secp384r1_uint1 x457;
    uint64_t x458;
    fiat_secp384r1_uint1 x459;
    uint64_t x460;
    fiat_secp384r1_uint1 x461;
    uint64_t x462;
    fiat_secp384r1_uint1 x463;
    uint64_t x464;
    fiat_secp384r1_uint1 x465;
    uint64_t x466;
    fiat_secp384r1_uint1 x467;
    uint64_t x468;
    uint64_t x469;
    uint64_t x470;
    uint64_t x471;
    uint64_t x472;
    uint64_t x473;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[0]);
    fiat_secp384r1_mulx_u64(&x7, &x8, x6, (arg1[5]));
    fiat_secp384r1_mulx_u64(&x9, &x10, x6, (arg1[4]));
    fiat_secp384r1_mulx_u64(&x11, &x12, x6, (arg1[3]));
    fiat_secp384r1_mulx_u64(&x13, &x14, x6, (arg1[2]));
    fiat_secp384r1_mulx_u64(&x15, &x16, x6, (arg1[1]));
    fiat_secp384r1_mulx_u64(&x17, &x18, x6, (arg1[0]));
    fiat_secp384r1_addcarryx_u64(&x19, &x20, 0x0, x18, x15);
    fiat_secp384r1_addcarryx_u64(&x21, &x22, x20, x16, x13);
    fiat_secp384r1_addcarryx_u64(&x23, &x24, x22, x14, x11);
    fiat_secp384r1_addcarryx_u64(&x25, &x26, x24, x12, x9);
    fiat_secp384r1_addcarryx_u64(&x27, &x28, x26, x10, x7);
    x29 = (x28 + x8);
    fiat_secp384r1_mulx_u64(&x30, &x31, x17, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x32, &x33, x30, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x34, &x35, x30, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x36, &x37, x30, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x38, &x39, x30, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x40, &x41, x30, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x42, &x43, x30, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x44, &x45, 0x0, x43, x40);
    fiat_secp384r1_addcarryx_u64(&x46, &x47, x45, x41, x38);
    fiat_secp384r1_addcarryx_u64(&x48, &x49, x47, x39, x36);
    fiat_secp384r1_addcarryx_u64(&x50, &x51, x49, x37, x34);
    fiat_secp384r1_addcarryx_u64(&x52, &x53, x51, x35, x32);
    x54 = (x53 + x33);
    fiat_secp384r1_addcarryx_u64(&x55, &x56, 0x0, x17, x42);
    fiat_secp384r1_addcarryx_u64(&x57, &x58, x56, x19, x44);
    fiat_secp384r1_addcarryx_u64(&x59, &x60, x58, x21, x46);
    fiat_secp384r1_addcarryx_u64(&x61, &x62, x60, x23, x48);
    fiat_secp384r1_addcarryx_u64(&x63, &x64, x62, x25, x50);
    fiat_secp384r1_addcarryx_u64(&x65, &x66, x64, x27, x52);
    fiat_secp384r1_addcarryx_u64(&x67, &x68, x66, x29, x54);
    fiat_secp384r1_mulx_u64(&x69, &x70, x1, (arg1[5]));
    fiat_secp384r1_mulx_u64(&x71, &x72, x1, (arg1[4]));
    fiat_secp384r1_mulx_u64(&x73, &x74, x1, (arg1[3]));
    fiat_secp384r1_mulx_u64(&x75, &x76, x1, (arg1[2]));
    fiat_secp384r1_mulx_u64(&x77, &x78, x1, (arg1[1]));
    fiat_secp384r1_mulx_u64(&x79, &x80, x1, (arg1[0]));
    fiat_secp384r1_addcarryx_u64(&x81, &x82, 0x0, x80, x77);
    fiat_secp384r1_addcarryx_u64(&x83, &x84, x82, x78, x75);
    fiat_secp384r1_addcarryx_u64(&x85, &x86, x84, x76, x73);
    fiat_secp384r1_addcarryx_u64(&x87, &x88, x86, x74, x71);
    fiat_secp384r1_addcarryx_u64(&x89, &x90, x88, x72, x69);
    x91 = (x90 + x70);
    fiat_secp384r1_addcarryx_u64(&x92, &x93, 0x0, x57, x79);
    fiat_secp384r1_addcarryx_u64(&x94, &x95, x93, x59, x81);
    fiat_secp384r1_addcarryx_u64(&x96, &x97, x95, x61, x83);
    fiat_secp384r1_addcarryx_u64(&x98, &x99, x97, x63, x85);
    fiat_secp384r1_addcarryx_u64(&x100, &x101, x99, x65, x87);
    fiat_secp384r1_addcarryx_u64(&x102, &x103, x101, x67, x89);
    fiat_secp384r1_addcarryx_u64(&x104, &x105, x103, x68, x91);
    fiat_secp384r1_mulx_u64(&x106, &x107, x92, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x108, &x109, x106, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x110, &x111, x106, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x112, &x113, x106, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x114, &x115, x106, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x116, &x117, x106, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x118, &x119, x106, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x120, &x121, 0x0, x119, x116);
    fiat_secp384r1_addcarryx_u64(&x122, &x123, x121, x117, x114);
    fiat_secp384r1_addcarryx_u64(&x124, &x125, x123, x115, x112);
    fiat_secp384r1_addcarryx_u64(&x126, &x127, x125, x113, x110);
    fiat_secp384r1_addcarryx_u64(&x128, &x129, x127, x111, x108);
    x130 = (x129 + x109);
    fiat_secp384r1_addcarryx_u64(&x131, &x132, 0x0, x92, x118);
    fiat_secp384r1_addcarryx_u64(&x133, &x134, x132, x94, x120);
    fiat_secp384r1_addcarryx_u64(&x135, &x136, x134, x96, x122);
    fiat_secp384r1_addcarryx_u64(&x137, &x138, x136, x98, x124);
    fiat_secp384r1_addcarryx_u64(&x139, &x140, x138, x100, x126);
    fiat_secp384r1_addcarryx_u64(&x141, &x142, x140, x102, x128);
    fiat_secp384r1_addcarryx_u64(&x143, &x144, x142, x104, x130);
    x145 = ((uint64_t)x144 + x105);
    fiat_secp384r1_mulx_u64(&x146, &x147, x2, (arg1[5]));
    fiat_secp384r1_mulx_u64(&x148, &x149, x2, (arg1[4]));
    fiat_secp384r1_mulx_u64(&x150, &x151, x2, (arg1[3]));
    fiat_secp384r1_mulx_u64(&x152, &x153, x2, (arg1[2]));
    fiat_secp384r1_mulx_u64(&x154, &x155, x2, (arg1[1]));
    fiat_secp384r1_mulx_u64(&x156, &x157, x2, (arg1[0]));
    fiat_secp384r1_addcarryx_u64(&x158, &x159, 0x0, x157, x154);
    fiat_secp384r1_addcarryx_u64(&x160, &x161, x159, x155, x152);
    fiat_secp384r1_addcarryx_u64(&x162, &x163, x161, x153, x150);
    fiat_secp384r1_addcarryx_u64(&x164, &x165, x163, x151, x148);
    fiat_secp384r1_addcarryx_u64(&x166, &x167, x165, x149, x146);
    x168 = (x167 + x147);
    fiat_secp384r1_addcarryx_u64(&x169, &x170, 0x0, x133, x156);
    fiat_secp384r1_addcarryx_u64(&x171, &x172, x170, x135, x158);
    fiat_secp384r1_addcarryx_u64(&x173, &x174, x172, x137, x160);
    fiat_secp384r1_addcarryx_u64(&x175, &x176, x174, x139, x162);
    fiat_secp384r1_addcarryx_u64(&x177, &x178, x176, x141, x164);
    fiat_secp384r1_addcarryx_u64(&x179, &x180, x178, x143, x166);
    fiat_secp384r1_addcarryx_u64(&x181, &x182, x180, x145, x168);
    fiat_secp384r1_mulx_u64(&x183, &x184, x169, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x185, &x186, x183, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x187, &x188, x183, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x189, &x190, x183, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x191, &x192, x183, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x193, &x194, x183, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x195, &x196, x183, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x197, &x198, 0x0, x196, x193);
    fiat_secp384r1_addcarryx_u64(&x199, &x200, x198, x194, x191);
    fiat_secp384r1_addcarryx_u64(&x201, &x202, x200, x192, x189);
    fiat_secp384r1_addcarryx_u64(&x203, &x204, x202, x190, x187);
    fiat_secp384r1_addcarryx_u64(&x205, &x206, x204, x188, x185);
    x207 = (x206 + x186);
    fiat_secp384r1_addcarryx_u64(&x208, &x209, 0x0, x169, x195);
    fiat_secp384r1_addcarryx_u64(&x210, &x211, x209, x171, x197);
    fiat_secp384r1_addcarryx_u64(&x212, &x213, x211, x173, x199);
    fiat_secp384r1_addcarryx_u64(&x214, &x215, x213, x175, x201);
    fiat_secp384r1_addcarryx_u64(&x216, &x217, x215, x177, x203);
    fiat_secp384r1_addcarryx_u64(&x218, &x219, x217, x179, x205);
    fiat_secp384r1_addcarryx_u64(&x220, &x221, x219, x181, x207);
    x222 = ((uint64_t)x221 + x182);
    fiat_secp384r1_mulx_u64(&x223, &x224, x3, (arg1[5]));
    fiat_secp384r1_mulx_u64(&x225, &x226, x3, (arg1[4]));
    fiat_secp384r1_mulx_u64(&x227, &x228, x3, (arg1[3]));
    fiat_secp384r1_mulx_u64(&x229, &x230, x3, (arg1[2]));
    fiat_secp384r1_mulx_u64(&x231, &x232, x3, (arg1[1]));
    fiat_secp384r1_mulx_u64(&x233, &x234, x3, (arg1[0]));
    fiat_secp384r1_addcarryx_u64(&x235, &x236, 0x0, x234, x231);
    fiat_secp384r1_addcarryx_u64(&x237, &x238, x236, x232, x229);
    fiat_secp384r1_addcarryx_u64(&x239, &x240, x238, x230, x227);
    fiat_secp384r1_addcarryx_u64(&x241, &x242, x240, x228, x225);
    fiat_secp384r1_addcarryx_u64(&x243, &x244, x242, x226, x223);
    x245 = (x244 + x224);
    fiat_secp384r1_addcarryx_u64(&x246, &x247, 0x0, x210, x233);
    fiat_secp384r1_addcarryx_u64(&x248, &x249, x247, x212, x235);
    fiat_secp384r1_addcarryx_u64(&x250, &x251, x249, x214, x237);
    fiat_secp384r1_addcarryx_u64(&x252, &x253, x251, x216, x239);
    fiat_secp384r1_addcarryx_u64(&x254, &x255, x253, x218, x241);
    fiat_secp384r1_addcarryx_u64(&x256, &x257, x255, x220, x243);
    fiat_secp384r1_addcarryx_u64(&x258, &x259, x257, x222, x245);
    fiat_secp384r1_mulx_u64(&x260, &x261, x246, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x262, &x263, x260, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x264, &x265, x260, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x266, &x267, x260, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x268, &x269, x260, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x270, &x271, x260, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x272, &x273, x260, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x274, &x275, 0x0, x273, x270);
    fiat_secp384r1_addcarryx_u64(&x276, &x277, x275, x271, x268);
    fiat_secp384r1_addcarryx_u64(&x278, &x279, x277, x269, x266);
    fiat_secp384r1_addcarryx_u64(&x280, &x281, x279, x267, x264);
    fiat_secp384r1_addcarryx_u64(&x282, &x283, x281, x265, x262);
    x284 = (x283 + x263);
    fiat_secp384r1_addcarryx_u64(&x285, &x286, 0x0, x246, x272);
    fiat_secp384r1_addcarryx_u64(&x287, &x288, x286, x248, x274);
    fiat_secp384r1_addcarryx_u64(&x289, &x290, x288, x250, x276);
    fiat_secp384r1_addcarryx_u64(&x291, &x292, x290, x252, x278);
    fiat_secp384r1_addcarryx_u64(&x293, &x294, x292, x254, x280);
    fiat_secp384r1_addcarryx_u64(&x295, &x296, x294, x256, x282);
    fiat_secp384r1_addcarryx_u64(&x297, &x298, x296, x258, x284);
    x299 = ((uint64_t)x298 + x259);
    fiat_secp384r1_mulx_u64(&x300, &x301, x4, (arg1[5]));
    fiat_secp384r1_mulx_u64(&x302, &x303, x4, (arg1[4]));
    fiat_secp384r1_mulx_u64(&x304, &x305, x4, (arg1[3]));
    fiat_secp384r1_mulx_u64(&x306, &x307, x4, (arg1[2]));
    fiat_secp384r1_mulx_u64(&x308, &x309, x4, (arg1[1]));
    fiat_secp384r1_mulx_u64(&x310, &x311, x4, (arg1[0]));
    fiat_secp384r1_addcarryx_u64(&x312, &x313, 0x0, x311, x308);
    fiat_secp384r1_addcarryx_u64(&x314, &x315, x313, x309, x306);
    fiat_secp384r1_addcarryx_u64(&x316, &x317, x315, x307, x304);
    fiat_secp384r1_addcarryx_u64(&x318, &x319, x317, x305, x302);
    fiat_secp384r1_addcarryx_u64(&x320, &x321, x319, x303, x300);
    x322 = (x321 + x301);
    fiat_secp384r1_addcarryx_u64(&x323, &x324, 0x0, x287, x310);
    fiat_secp384r1_addcarryx_u64(&x325, &x326, x324, x289, x312);
    fiat_secp384r1_addcarryx_u64(&x327, &x328, x326, x291, x314);
    fiat_secp384r1_addcarryx_u64(&x329, &x330, x328, x293, x316);
    fiat_secp384r1_addcarryx_u64(&x331, &x332, x330, x295, x318);
    fiat_secp384r1_addcarryx_u64(&x333, &x334, x332, x297, x320);
    fiat_secp384r1_addcarryx_u64(&x335, &x336, x334, x299, x322);
    fiat_secp384r1_mulx_u64(&x337, &x338, x323, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x339, &x340, x337, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x341, &x342, x337, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x343, &x344, x337, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x345, &x346, x337, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x347, &x348, x337, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x349, &x350, x337, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x351, &x352, 0x0, x350, x347);
    fiat_secp384r1_addcarryx_u64(&x353, &x354, x352, x348, x345);
    fiat_secp384r1_addcarryx_u64(&x355, &x356, x354, x346, x343);
    fiat_secp384r1_addcarryx_u64(&x357, &x358, x356, x344, x341);
    fiat_secp384r1_addcarryx_u64(&x359, &x360, x358, x342, x339);
    x361 = (x360 + x340);
    fiat_secp384r1_addcarryx_u64(&x362, &x363, 0x0, x323, x349);
    fiat_secp384r1_addcarryx_u64(&x364, &x365, x363, x325, x351);
    fiat_secp384r1_addcarryx_u64(&x366, &x367, x365, x327, x353);
    fiat_secp384r1_addcarryx_u64(&x368, &x369, x367, x329, x355);
    fiat_secp384r1_addcarryx_u64(&x370, &x371, x369, x331, x357);
    fiat_secp384r1_addcarryx_u64(&x372, &x373, x371, x333, x359);
    fiat_secp384r1_addcarryx_u64(&x374, &x375, x373, x335, x361);
    x376 = ((uint64_t)x375 + x336);
    fiat_secp384r1_mulx_u64(&x377, &x378, x5, (arg1[5]));
    fiat_secp384r1_mulx_u64(&x379, &x380, x5, (arg1[4]));
    fiat_secp384r1_mulx_u64(&x381, &x382, x5, (arg1[3]));
    fiat_secp384r1_mulx_u64(&x383, &x384, x5, (arg1[2]));
    fiat_secp384r1_mulx_u64(&x385, &x386, x5, (arg1[1]));
    fiat_secp384r1_mulx_u64(&x387, &x388, x5, (arg1[0]));
    fiat_secp384r1_addcarryx_u64(&x389, &x390, 0x0, x388, x385);
    fiat_secp384r1_addcarryx_u64(&x391, &x392, x390, x386, x383);
    fiat_secp384r1_addcarryx_u64(&x393, &x394, x392, x384, x381);
    fiat_secp384r1_addcarryx_u64(&x395, &x396, x394, x382, x379);
    fiat_secp384r1_addcarryx_u64(&x397, &x398, x396, x380, x377);
    x399 = (x398 + x378);
    fiat_secp384r1_addcarryx_u64(&x400, &x401, 0x0, x364, x387);
    fiat_secp384r1_addcarryx_u64(&x402, &x403, x401, x366, x389);
    fiat_secp384r1_addcarryx_u64(&x404, &x405, x403, x368, x391);
    fiat_secp384r1_addcarryx_u64(&x406, &x407, x405, x370, x393);
    fiat_secp384r1_addcarryx_u64(&x408, &x409, x407, x372, x395);
    fiat_secp384r1_addcarryx_u64(&x410, &x411, x409, x374, x397);
    fiat_secp384r1_addcarryx_u64(&x412, &x413, x411, x376, x399);
    fiat_secp384r1_mulx_u64(&x414, &x415, x400, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x416, &x417, x414, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x418, &x419, x414, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x420, &x421, x414, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x422, &x423, x414, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x424, &x425, x414, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x426, &x427, x414, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x428, &x429, 0x0, x427, x424);
    fiat_secp384r1_addcarryx_u64(&x430, &x431, x429, x425, x422);
    fiat_secp384r1_addcarryx_u64(&x432, &x433, x431, x423, x420);
    fiat_secp384r1_addcarryx_u64(&x434, &x435, x433, x421, x418);
    fiat_secp384r1_addcarryx_u64(&x436, &x437, x435, x419, x416);
    x438 = (x437 + x417);
    fiat_secp384r1_addcarryx_u64(&x439, &x440, 0x0, x400, x426);
    fiat_secp384r1_addcarryx_u64(&x441, &x442, x440, x402, x428);
    fiat_secp384r1_addcarryx_u64(&x443, &x444, x442, x404, x430);
    fiat_secp384r1_addcarryx_u64(&x445, &x446, x444, x406, x432);
    fiat_secp384r1_addcarryx_u64(&x447, &x448, x446, x408, x434);
    fiat_secp384r1_addcarryx_u64(&x449, &x450, x448, x410, x436);
    fiat_secp384r1_addcarryx_u64(&x451, &x452, x450, x412, x438);
    x453 = ((uint64_t)x452 + x413);
    fiat_secp384r1_subborrowx_u64(&x454, &x455, 0x0, x441,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u64(&x456, &x457, x455, x443,
                                  UINT64_C(0xffffffff00000000));
    fiat_secp384r1_subborrowx_u64(&x458, &x459, x457, x445,
                                  UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_subborrowx_u64(&x460, &x461, x459, x447,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x462, &x463, x461, x449,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x464, &x465, x463, x451,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x466, &x467, x465, x453, 0x0);
    fiat_secp384r1_cmovznz_u64(&x468, x467, x454, x441);
    fiat_secp384r1_cmovznz_u64(&x469, x467, x456, x443);
    fiat_secp384r1_cmovznz_u64(&x470, x467, x458, x445);
    fiat_secp384r1_cmovznz_u64(&x471, x467, x460, x447);
    fiat_secp384r1_cmovznz_u64(&x472, x467, x462, x449);
    fiat_secp384r1_cmovznz_u64(&x473, x467, x464, x451);
    out1[0] = x468;
    out1[1] = x469;
    out1[2] = x470;
    out1[3] = x471;
    out1[4] = x472;
    out1[5] = x473;
}

/*
 * The function fiat_secp384r1_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_add(uint64_t out1[6], const uint64_t arg1[6],
                   const uint64_t arg2[6])
{
    uint64_t x1;
    fiat_secp384r1_uint1 x2;
    uint64_t x3;
    fiat_secp384r1_uint1 x4;
    uint64_t x5;
    fiat_secp384r1_uint1 x6;
    uint64_t x7;
    fiat_secp384r1_uint1 x8;
    uint64_t x9;
    fiat_secp384r1_uint1 x10;
    uint64_t x11;
    fiat_secp384r1_uint1 x12;
    uint64_t x13;
    fiat_secp384r1_uint1 x14;
    uint64_t x15;
    fiat_secp384r1_uint1 x16;
    uint64_t x17;
    fiat_secp384r1_uint1 x18;
    uint64_t x19;
    fiat_secp384r1_uint1 x20;
    uint64_t x21;
    fiat_secp384r1_uint1 x22;
    uint64_t x23;
    fiat_secp384r1_uint1 x24;
    uint64_t x25;
    fiat_secp384r1_uint1 x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    fiat_secp384r1_addcarryx_u64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_secp384r1_addcarryx_u64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_secp384r1_addcarryx_u64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_secp384r1_addcarryx_u64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_secp384r1_addcarryx_u64(&x9, &x10, x8, (arg1[4]), (arg2[4]));
    fiat_secp384r1_addcarryx_u64(&x11, &x12, x10, (arg1[5]), (arg2[5]));
    fiat_secp384r1_subborrowx_u64(&x13, &x14, 0x0, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u64(&x15, &x16, x14, x3,
                                  UINT64_C(0xffffffff00000000));
    fiat_secp384r1_subborrowx_u64(&x17, &x18, x16, x5,
                                  UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_subborrowx_u64(&x19, &x20, x18, x7,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x21, &x22, x20, x9,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x23, &x24, x22, x11,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x25, &x26, x24, x12, 0x0);
    fiat_secp384r1_cmovznz_u64(&x27, x26, x13, x1);
    fiat_secp384r1_cmovznz_u64(&x28, x26, x15, x3);
    fiat_secp384r1_cmovznz_u64(&x29, x26, x17, x5);
    fiat_secp384r1_cmovznz_u64(&x30, x26, x19, x7);
    fiat_secp384r1_cmovznz_u64(&x31, x26, x21, x9);
    fiat_secp384r1_cmovznz_u64(&x32, x26, x23, x11);
    out1[0] = x27;
    out1[1] = x28;
    out1[2] = x29;
    out1[3] = x30;
    out1[4] = x31;
    out1[5] = x32;
}

/*
 * The function fiat_secp384r1_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_sub(uint64_t out1[6], const uint64_t arg1[6],
                   const uint64_t arg2[6])
{
    uint64_t x1;
    fiat_secp384r1_uint1 x2;
    uint64_t x3;
    fiat_secp384r1_uint1 x4;
    uint64_t x5;
    fiat_secp384r1_uint1 x6;
    uint64_t x7;
    fiat_secp384r1_uint1 x8;
    uint64_t x9;
    fiat_secp384r1_uint1 x10;
    uint64_t x11;
    fiat_secp384r1_uint1 x12;
    uint64_t x13;
    uint64_t x14;
    fiat_secp384r1_uint1 x15;
    uint64_t x16;
    fiat_secp384r1_uint1 x17;
    uint64_t x18;
    fiat_secp384r1_uint1 x19;
    uint64_t x20;
    fiat_secp384r1_uint1 x21;
    uint64_t x22;
    fiat_secp384r1_uint1 x23;
    uint64_t x24;
    fiat_secp384r1_uint1 x25;
    fiat_secp384r1_subborrowx_u64(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_secp384r1_subborrowx_u64(&x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_secp384r1_subborrowx_u64(&x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_secp384r1_subborrowx_u64(&x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_secp384r1_subborrowx_u64(&x9, &x10, x8, (arg1[4]), (arg2[4]));
    fiat_secp384r1_subborrowx_u64(&x11, &x12, x10, (arg1[5]), (arg2[5]));
    fiat_secp384r1_cmovznz_u64(&x13, x12, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_addcarryx_u64(&x14, &x15, 0x0, x1,
                                 (x13 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u64(&x16, &x17, x15, x3,
                                 (x13 & UINT64_C(0xffffffff00000000)));
    fiat_secp384r1_addcarryx_u64(&x18, &x19, x17, x5,
                                 (x13 & UINT64_C(0xfffffffffffffffe)));
    fiat_secp384r1_addcarryx_u64(&x20, &x21, x19, x7,
                                 (x13 & UINT64_C(0xffffffffffffffff)));
    fiat_secp384r1_addcarryx_u64(&x22, &x23, x21, x9,
                                 (x13 & UINT64_C(0xffffffffffffffff)));
    fiat_secp384r1_addcarryx_u64(&x24, &x25, x23, x11,
                                 (x13 & UINT64_C(0xffffffffffffffff)));
    out1[0] = x14;
    out1[1] = x16;
    out1[2] = x18;
    out1[3] = x20;
    out1[4] = x22;
    out1[5] = x24;
}

/*
 * The function fiat_secp384r1_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_opp(uint64_t out1[6], const uint64_t arg1[6])
{
    uint64_t x1;
    fiat_secp384r1_uint1 x2;
    uint64_t x3;
    fiat_secp384r1_uint1 x4;
    uint64_t x5;
    fiat_secp384r1_uint1 x6;
    uint64_t x7;
    fiat_secp384r1_uint1 x8;
    uint64_t x9;
    fiat_secp384r1_uint1 x10;
    uint64_t x11;
    fiat_secp384r1_uint1 x12;
    uint64_t x13;
    uint64_t x14;
    fiat_secp384r1_uint1 x15;
    uint64_t x16;
    fiat_secp384r1_uint1 x17;
    uint64_t x18;
    fiat_secp384r1_uint1 x19;
    uint64_t x20;
    fiat_secp384r1_uint1 x21;
    uint64_t x22;
    fiat_secp384r1_uint1 x23;
    uint64_t x24;
    fiat_secp384r1_uint1 x25;
    fiat_secp384r1_subborrowx_u64(&x1, &x2, 0x0, 0x0, (arg1[0]));
    fiat_secp384r1_subborrowx_u64(&x3, &x4, x2, 0x0, (arg1[1]));
    fiat_secp384r1_subborrowx_u64(&x5, &x6, x4, 0x0, (arg1[2]));
    fiat_secp384r1_subborrowx_u64(&x7, &x8, x6, 0x0, (arg1[3]));
    fiat_secp384r1_subborrowx_u64(&x9, &x10, x8, 0x0, (arg1[4]));
    fiat_secp384r1_subborrowx_u64(&x11, &x12, x10, 0x0, (arg1[5]));
    fiat_secp384r1_cmovznz_u64(&x13, x12, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_addcarryx_u64(&x14, &x15, 0x0, x1,
                                 (x13 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u64(&x16, &x17, x15, x3,
                                 (x13 & UINT64_C(0xffffffff00000000)));
    fiat_secp384r1_addcarryx_u64(&x18, &x19, x17, x5,
                                 (x13 & UINT64_C(0xfffffffffffffffe)));
    fiat_secp384r1_addcarryx_u64(&x20, &x21, x19, x7,
                                 (x13 & UINT64_C(0xffffffffffffffff)));
    fiat_secp384r1_addcarryx_u64(&x22, &x23, x21, x9,
                                 (x13 & UINT64_C(0xffffffffffffffff)));
    fiat_secp384r1_addcarryx_u64(&x24, &x25, x23, x11,
                                 (x13 & UINT64_C(0xffffffffffffffff)));
    out1[0] = x14;
    out1[1] = x16;
    out1[2] = x18;
    out1[3] = x20;
    out1[4] = x22;
    out1[5] = x24;
}

/*
 * The function fiat_secp384r1_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^6) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_from_montgomery(uint64_t out1[6],
                               const uint64_t arg1[6])
{
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint64_t x16;
    fiat_secp384r1_uint1 x17;
    uint64_t x18;
    fiat_secp384r1_uint1 x19;
    uint64_t x20;
    fiat_secp384r1_uint1 x21;
    uint64_t x22;
    fiat_secp384r1_uint1 x23;
    uint64_t x24;
    fiat_secp384r1_uint1 x25;
    uint64_t x26;
    fiat_secp384r1_uint1 x27;
    uint64_t x28;
    fiat_secp384r1_uint1 x29;
    uint64_t x30;
    fiat_secp384r1_uint1 x31;
    uint64_t x32;
    fiat_secp384r1_uint1 x33;
    uint64_t x34;
    fiat_secp384r1_uint1 x35;
    uint64_t x36;
    fiat_secp384r1_uint1 x37;
    uint64_t x38;
    fiat_secp384r1_uint1 x39;
    uint64_t x40;
    fiat_secp384r1_uint1 x41;
    uint64_t x42;
    fiat_secp384r1_uint1 x43;
    uint64_t x44;
    fiat_secp384r1_uint1 x45;
    uint64_t x46;
    fiat_secp384r1_uint1 x47;
    uint64_t x48;
    fiat_secp384r1_uint1 x49;
    uint64_t x50;
    fiat_secp384r1_uint1 x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    fiat_secp384r1_uint1 x67;
    uint64_t x68;
    fiat_secp384r1_uint1 x69;
    uint64_t x70;
    fiat_secp384r1_uint1 x71;
    uint64_t x72;
    fiat_secp384r1_uint1 x73;
    uint64_t x74;
    fiat_secp384r1_uint1 x75;
    uint64_t x76;
    fiat_secp384r1_uint1 x77;
    uint64_t x78;
    fiat_secp384r1_uint1 x79;
    uint64_t x80;
    fiat_secp384r1_uint1 x81;
    uint64_t x82;
    fiat_secp384r1_uint1 x83;
    uint64_t x84;
    fiat_secp384r1_uint1 x85;
    uint64_t x86;
    fiat_secp384r1_uint1 x87;
    uint64_t x88;
    fiat_secp384r1_uint1 x89;
    uint64_t x90;
    fiat_secp384r1_uint1 x91;
    uint64_t x92;
    fiat_secp384r1_uint1 x93;
    uint64_t x94;
    fiat_secp384r1_uint1 x95;
    uint64_t x96;
    fiat_secp384r1_uint1 x97;
    uint64_t x98;
    fiat_secp384r1_uint1 x99;
    uint64_t x100;
    fiat_secp384r1_uint1 x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    uint64_t x109;
    uint64_t x110;
    uint64_t x111;
    uint64_t x112;
    uint64_t x113;
    uint64_t x114;
    uint64_t x115;
    uint64_t x116;
    fiat_secp384r1_uint1 x117;
    uint64_t x118;
    fiat_secp384r1_uint1 x119;
    uint64_t x120;
    fiat_secp384r1_uint1 x121;
    uint64_t x122;
    fiat_secp384r1_uint1 x123;
    uint64_t x124;
    fiat_secp384r1_uint1 x125;
    uint64_t x126;
    fiat_secp384r1_uint1 x127;
    uint64_t x128;
    fiat_secp384r1_uint1 x129;
    uint64_t x130;
    fiat_secp384r1_uint1 x131;
    uint64_t x132;
    fiat_secp384r1_uint1 x133;
    uint64_t x134;
    fiat_secp384r1_uint1 x135;
    uint64_t x136;
    fiat_secp384r1_uint1 x137;
    uint64_t x138;
    fiat_secp384r1_uint1 x139;
    uint64_t x140;
    fiat_secp384r1_uint1 x141;
    uint64_t x142;
    fiat_secp384r1_uint1 x143;
    uint64_t x144;
    fiat_secp384r1_uint1 x145;
    uint64_t x146;
    fiat_secp384r1_uint1 x147;
    uint64_t x148;
    fiat_secp384r1_uint1 x149;
    uint64_t x150;
    fiat_secp384r1_uint1 x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    uint64_t x159;
    uint64_t x160;
    uint64_t x161;
    uint64_t x162;
    uint64_t x163;
    uint64_t x164;
    uint64_t x165;
    uint64_t x166;
    fiat_secp384r1_uint1 x167;
    uint64_t x168;
    fiat_secp384r1_uint1 x169;
    uint64_t x170;
    fiat_secp384r1_uint1 x171;
    uint64_t x172;
    fiat_secp384r1_uint1 x173;
    uint64_t x174;
    fiat_secp384r1_uint1 x175;
    uint64_t x176;
    fiat_secp384r1_uint1 x177;
    uint64_t x178;
    fiat_secp384r1_uint1 x179;
    uint64_t x180;
    fiat_secp384r1_uint1 x181;
    uint64_t x182;
    fiat_secp384r1_uint1 x183;
    uint64_t x184;
    fiat_secp384r1_uint1 x185;
    uint64_t x186;
    fiat_secp384r1_uint1 x187;
    uint64_t x188;
    fiat_secp384r1_uint1 x189;
    uint64_t x190;
    fiat_secp384r1_uint1 x191;
    uint64_t x192;
    fiat_secp384r1_uint1 x193;
    uint64_t x194;
    fiat_secp384r1_uint1 x195;
    uint64_t x196;
    fiat_secp384r1_uint1 x197;
    uint64_t x198;
    fiat_secp384r1_uint1 x199;
    uint64_t x200;
    fiat_secp384r1_uint1 x201;
    uint64_t x202;
    uint64_t x203;
    uint64_t x204;
    uint64_t x205;
    uint64_t x206;
    uint64_t x207;
    uint64_t x208;
    uint64_t x209;
    uint64_t x210;
    uint64_t x211;
    uint64_t x212;
    uint64_t x213;
    uint64_t x214;
    uint64_t x215;
    uint64_t x216;
    fiat_secp384r1_uint1 x217;
    uint64_t x218;
    fiat_secp384r1_uint1 x219;
    uint64_t x220;
    fiat_secp384r1_uint1 x221;
    uint64_t x222;
    fiat_secp384r1_uint1 x223;
    uint64_t x224;
    fiat_secp384r1_uint1 x225;
    uint64_t x226;
    fiat_secp384r1_uint1 x227;
    uint64_t x228;
    fiat_secp384r1_uint1 x229;
    uint64_t x230;
    fiat_secp384r1_uint1 x231;
    uint64_t x232;
    fiat_secp384r1_uint1 x233;
    uint64_t x234;
    fiat_secp384r1_uint1 x235;
    uint64_t x236;
    fiat_secp384r1_uint1 x237;
    uint64_t x238;
    fiat_secp384r1_uint1 x239;
    uint64_t x240;
    fiat_secp384r1_uint1 x241;
    uint64_t x242;
    fiat_secp384r1_uint1 x243;
    uint64_t x244;
    fiat_secp384r1_uint1 x245;
    uint64_t x246;
    fiat_secp384r1_uint1 x247;
    uint64_t x248;
    fiat_secp384r1_uint1 x249;
    uint64_t x250;
    fiat_secp384r1_uint1 x251;
    uint64_t x252;
    uint64_t x253;
    uint64_t x254;
    uint64_t x255;
    uint64_t x256;
    uint64_t x257;
    uint64_t x258;
    uint64_t x259;
    uint64_t x260;
    uint64_t x261;
    uint64_t x262;
    uint64_t x263;
    uint64_t x264;
    uint64_t x265;
    uint64_t x266;
    fiat_secp384r1_uint1 x267;
    uint64_t x268;
    fiat_secp384r1_uint1 x269;
    uint64_t x270;
    fiat_secp384r1_uint1 x271;
    uint64_t x272;
    fiat_secp384r1_uint1 x273;
    uint64_t x274;
    fiat_secp384r1_uint1 x275;
    uint64_t x276;
    fiat_secp384r1_uint1 x277;
    uint64_t x278;
    fiat_secp384r1_uint1 x279;
    uint64_t x280;
    fiat_secp384r1_uint1 x281;
    uint64_t x282;
    fiat_secp384r1_uint1 x283;
    uint64_t x284;
    fiat_secp384r1_uint1 x285;
    uint64_t x286;
    fiat_secp384r1_uint1 x287;
    uint64_t x288;
    fiat_secp384r1_uint1 x289;
    uint64_t x290;
    fiat_secp384r1_uint1 x291;
    uint64_t x292;
    fiat_secp384r1_uint1 x293;
    uint64_t x294;
    fiat_secp384r1_uint1 x295;
    uint64_t x296;
    fiat_secp384r1_uint1 x297;
    uint64_t x298;
    fiat_secp384r1_uint1 x299;
    uint64_t x300;
    fiat_secp384r1_uint1 x301;
    uint64_t x302;
    fiat_secp384r1_uint1 x303;
    uint64_t x304;
    uint64_t x305;
    uint64_t x306;
    uint64_t x307;
    uint64_t x308;
    uint64_t x309;
    x1 = (arg1[0]);
    fiat_secp384r1_mulx_u64(&x2, &x3, x1, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x4, &x5, x2, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x6, &x7, x2, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x8, &x9, x2, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x10, &x11, x2, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x12, &x13, x2, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x14, &x15, x2, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x16, &x17, 0x0, x15, x12);
    fiat_secp384r1_addcarryx_u64(&x18, &x19, x17, x13, x10);
    fiat_secp384r1_addcarryx_u64(&x20, &x21, x19, x11, x8);
    fiat_secp384r1_addcarryx_u64(&x22, &x23, x21, x9, x6);
    fiat_secp384r1_addcarryx_u64(&x24, &x25, x23, x7, x4);
    fiat_secp384r1_addcarryx_u64(&x26, &x27, 0x0, x1, x14);
    fiat_secp384r1_addcarryx_u64(&x28, &x29, x27, 0x0, x16);
    fiat_secp384r1_addcarryx_u64(&x30, &x31, x29, 0x0, x18);
    fiat_secp384r1_addcarryx_u64(&x32, &x33, x31, 0x0, x20);
    fiat_secp384r1_addcarryx_u64(&x34, &x35, x33, 0x0, x22);
    fiat_secp384r1_addcarryx_u64(&x36, &x37, x35, 0x0, x24);
    fiat_secp384r1_addcarryx_u64(&x38, &x39, x37, 0x0, (x25 + x5));
    fiat_secp384r1_addcarryx_u64(&x40, &x41, 0x0, x28, (arg1[1]));
    fiat_secp384r1_addcarryx_u64(&x42, &x43, x41, x30, 0x0);
    fiat_secp384r1_addcarryx_u64(&x44, &x45, x43, x32, 0x0);
    fiat_secp384r1_addcarryx_u64(&x46, &x47, x45, x34, 0x0);
    fiat_secp384r1_addcarryx_u64(&x48, &x49, x47, x36, 0x0);
    fiat_secp384r1_addcarryx_u64(&x50, &x51, x49, x38, 0x0);
    fiat_secp384r1_mulx_u64(&x52, &x53, x40, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x54, &x55, x52, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x56, &x57, x52, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x58, &x59, x52, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x60, &x61, x52, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x62, &x63, x52, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x64, &x65, x52, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x66, &x67, 0x0, x65, x62);
    fiat_secp384r1_addcarryx_u64(&x68, &x69, x67, x63, x60);
    fiat_secp384r1_addcarryx_u64(&x70, &x71, x69, x61, x58);
    fiat_secp384r1_addcarryx_u64(&x72, &x73, x71, x59, x56);
    fiat_secp384r1_addcarryx_u64(&x74, &x75, x73, x57, x54);
    fiat_secp384r1_addcarryx_u64(&x76, &x77, 0x0, x40, x64);
    fiat_secp384r1_addcarryx_u64(&x78, &x79, x77, x42, x66);
    fiat_secp384r1_addcarryx_u64(&x80, &x81, x79, x44, x68);
    fiat_secp384r1_addcarryx_u64(&x82, &x83, x81, x46, x70);
    fiat_secp384r1_addcarryx_u64(&x84, &x85, x83, x48, x72);
    fiat_secp384r1_addcarryx_u64(&x86, &x87, x85, x50, x74);
    fiat_secp384r1_addcarryx_u64(&x88, &x89, x87, ((uint64_t)x51 + x39),
                                 (x75 + x55));
    fiat_secp384r1_addcarryx_u64(&x90, &x91, 0x0, x78, (arg1[2]));
    fiat_secp384r1_addcarryx_u64(&x92, &x93, x91, x80, 0x0);
    fiat_secp384r1_addcarryx_u64(&x94, &x95, x93, x82, 0x0);
    fiat_secp384r1_addcarryx_u64(&x96, &x97, x95, x84, 0x0);
    fiat_secp384r1_addcarryx_u64(&x98, &x99, x97, x86, 0x0);
    fiat_secp384r1_addcarryx_u64(&x100, &x101, x99, x88, 0x0);
    fiat_secp384r1_mulx_u64(&x102, &x103, x90, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x104, &x105, x102, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x106, &x107, x102, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x108, &x109, x102, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x110, &x111, x102, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x112, &x113, x102, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x114, &x115, x102, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x116, &x117, 0x0, x115, x112);
    fiat_secp384r1_addcarryx_u64(&x118, &x119, x117, x113, x110);
    fiat_secp384r1_addcarryx_u64(&x120, &x121, x119, x111, x108);
    fiat_secp384r1_addcarryx_u64(&x122, &x123, x121, x109, x106);
    fiat_secp384r1_addcarryx_u64(&x124, &x125, x123, x107, x104);
    fiat_secp384r1_addcarryx_u64(&x126, &x127, 0x0, x90, x114);
    fiat_secp384r1_addcarryx_u64(&x128, &x129, x127, x92, x116);
    fiat_secp384r1_addcarryx_u64(&x130, &x131, x129, x94, x118);
    fiat_secp384r1_addcarryx_u64(&x132, &x133, x131, x96, x120);
    fiat_secp384r1_addcarryx_u64(&x134, &x135, x133, x98, x122);
    fiat_secp384r1_addcarryx_u64(&x136, &x137, x135, x100, x124);
    fiat_secp384r1_addcarryx_u64(&x138, &x139, x137, ((uint64_t)x101 + x89),
                                 (x125 + x105));
    fiat_secp384r1_addcarryx_u64(&x140, &x141, 0x0, x128, (arg1[3]));
    fiat_secp384r1_addcarryx_u64(&x142, &x143, x141, x130, 0x0);
    fiat_secp384r1_addcarryx_u64(&x144, &x145, x143, x132, 0x0);
    fiat_secp384r1_addcarryx_u64(&x146, &x147, x145, x134, 0x0);
    fiat_secp384r1_addcarryx_u64(&x148, &x149, x147, x136, 0x0);
    fiat_secp384r1_addcarryx_u64(&x150, &x151, x149, x138, 0x0);
    fiat_secp384r1_mulx_u64(&x152, &x153, x140, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x154, &x155, x152, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x156, &x157, x152, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x158, &x159, x152, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x160, &x161, x152, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x162, &x163, x152, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x164, &x165, x152, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x166, &x167, 0x0, x165, x162);
    fiat_secp384r1_addcarryx_u64(&x168, &x169, x167, x163, x160);
    fiat_secp384r1_addcarryx_u64(&x170, &x171, x169, x161, x158);
    fiat_secp384r1_addcarryx_u64(&x172, &x173, x171, x159, x156);
    fiat_secp384r1_addcarryx_u64(&x174, &x175, x173, x157, x154);
    fiat_secp384r1_addcarryx_u64(&x176, &x177, 0x0, x140, x164);
    fiat_secp384r1_addcarryx_u64(&x178, &x179, x177, x142, x166);
    fiat_secp384r1_addcarryx_u64(&x180, &x181, x179, x144, x168);
    fiat_secp384r1_addcarryx_u64(&x182, &x183, x181, x146, x170);
    fiat_secp384r1_addcarryx_u64(&x184, &x185, x183, x148, x172);
    fiat_secp384r1_addcarryx_u64(&x186, &x187, x185, x150, x174);
    fiat_secp384r1_addcarryx_u64(&x188, &x189, x187, ((uint64_t)x151 + x139),
                                 (x175 + x155));
    fiat_secp384r1_addcarryx_u64(&x190, &x191, 0x0, x178, (arg1[4]));
    fiat_secp384r1_addcarryx_u64(&x192, &x193, x191, x180, 0x0);
    fiat_secp384r1_addcarryx_u64(&x194, &x195, x193, x182, 0x0);
    fiat_secp384r1_addcarryx_u64(&x196, &x197, x195, x184, 0x0);
    fiat_secp384r1_addcarryx_u64(&x198, &x199, x197, x186, 0x0);
    fiat_secp384r1_addcarryx_u64(&x200, &x201, x199, x188, 0x0);
    fiat_secp384r1_mulx_u64(&x202, &x203, x190, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x204, &x205, x202, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x206, &x207, x202, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x208, &x209, x202, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x210, &x211, x202, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x212, &x213, x202, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x214, &x215, x202, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x216, &x217, 0x0, x215, x212);
    fiat_secp384r1_addcarryx_u64(&x218, &x219, x217, x213, x210);
    fiat_secp384r1_addcarryx_u64(&x220, &x221, x219, x211, x208);
    fiat_secp384r1_addcarryx_u64(&x222, &x223, x221, x209, x206);
    fiat_secp384r1_addcarryx_u64(&x224, &x225, x223, x207, x204);
    fiat_secp384r1_addcarryx_u64(&x226, &x227, 0x0, x190, x214);
    fiat_secp384r1_addcarryx_u64(&x228, &x229, x227, x192, x216);
    fiat_secp384r1_addcarryx_u64(&x230, &x231, x229, x194, x218);
    fiat_secp384r1_addcarryx_u64(&x232, &x233, x231, x196, x220);
    fiat_secp384r1_addcarryx_u64(&x234, &x235, x233, x198, x222);
    fiat_secp384r1_addcarryx_u64(&x236, &x237, x235, x200, x224);
    fiat_secp384r1_addcarryx_u64(&x238, &x239, x237, ((uint64_t)x201 + x189),
                                 (x225 + x205));
    fiat_secp384r1_addcarryx_u64(&x240, &x241, 0x0, x228, (arg1[5]));
    fiat_secp384r1_addcarryx_u64(&x242, &x243, x241, x230, 0x0);
    fiat_secp384r1_addcarryx_u64(&x244, &x245, x243, x232, 0x0);
    fiat_secp384r1_addcarryx_u64(&x246, &x247, x245, x234, 0x0);
    fiat_secp384r1_addcarryx_u64(&x248, &x249, x247, x236, 0x0);
    fiat_secp384r1_addcarryx_u64(&x250, &x251, x249, x238, 0x0);
    fiat_secp384r1_mulx_u64(&x252, &x253, x240, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x254, &x255, x252, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x256, &x257, x252, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x258, &x259, x252, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x260, &x261, x252, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x262, &x263, x252, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x264, &x265, x252, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x266, &x267, 0x0, x265, x262);
    fiat_secp384r1_addcarryx_u64(&x268, &x269, x267, x263, x260);
    fiat_secp384r1_addcarryx_u64(&x270, &x271, x269, x261, x258);
    fiat_secp384r1_addcarryx_u64(&x272, &x273, x271, x259, x256);
    fiat_secp384r1_addcarryx_u64(&x274, &x275, x273, x257, x254);
    fiat_secp384r1_addcarryx_u64(&x276, &x277, 0x0, x240, x264);
    fiat_secp384r1_addcarryx_u64(&x278, &x279, x277, x242, x266);
    fiat_secp384r1_addcarryx_u64(&x280, &x281, x279, x244, x268);
    fiat_secp384r1_addcarryx_u64(&x282, &x283, x281, x246, x270);
    fiat_secp384r1_addcarryx_u64(&x284, &x285, x283, x248, x272);
    fiat_secp384r1_addcarryx_u64(&x286, &x287, x285, x250, x274);
    fiat_secp384r1_addcarryx_u64(&x288, &x289, x287, ((uint64_t)x251 + x239),
                                 (x275 + x255));
    fiat_secp384r1_subborrowx_u64(&x290, &x291, 0x0, x278,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u64(&x292, &x293, x291, x280,
                                  UINT64_C(0xffffffff00000000));
    fiat_secp384r1_subborrowx_u64(&x294, &x295, x293, x282,
                                  UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_subborrowx_u64(&x296, &x297, x295, x284,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x298, &x299, x297, x286,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x300, &x301, x299, x288,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x302, &x303, x301, x289, 0x0);
    fiat_secp384r1_cmovznz_u64(&x304, x303, x290, x278);
    fiat_secp384r1_cmovznz_u64(&x305, x303, x292, x280);
    fiat_secp384r1_cmovznz_u64(&x306, x303, x294, x282);
    fiat_secp384r1_cmovznz_u64(&x307, x303, x296, x284);
    fiat_secp384r1_cmovznz_u64(&x308, x303, x298, x286);
    fiat_secp384r1_cmovznz_u64(&x309, x303, x300, x288);
    out1[0] = x304;
    out1[1] = x305;
    out1[2] = x306;
    out1[3] = x307;
    out1[4] = x308;
    out1[5] = x309;
}

/*
 * The function fiat_secp384r1_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_to_montgomery(uint64_t out1[6],
                             const uint64_t arg1[6])
{
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    fiat_secp384r1_uint1 x16;
    uint64_t x17;
    fiat_secp384r1_uint1 x18;
    uint64_t x19;
    fiat_secp384r1_uint1 x20;
    uint64_t x21;
    fiat_secp384r1_uint1 x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    fiat_secp384r1_uint1 x38;
    uint64_t x39;
    fiat_secp384r1_uint1 x40;
    uint64_t x41;
    fiat_secp384r1_uint1 x42;
    uint64_t x43;
    fiat_secp384r1_uint1 x44;
    uint64_t x45;
    fiat_secp384r1_uint1 x46;
    uint64_t x47;
    fiat_secp384r1_uint1 x48;
    uint64_t x49;
    fiat_secp384r1_uint1 x50;
    uint64_t x51;
    fiat_secp384r1_uint1 x52;
    uint64_t x53;
    fiat_secp384r1_uint1 x54;
    uint64_t x55;
    fiat_secp384r1_uint1 x56;
    uint64_t x57;
    fiat_secp384r1_uint1 x58;
    uint64_t x59;
    fiat_secp384r1_uint1 x60;
    uint64_t x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    fiat_secp384r1_uint1 x70;
    uint64_t x71;
    fiat_secp384r1_uint1 x72;
    uint64_t x73;
    fiat_secp384r1_uint1 x74;
    uint64_t x75;
    fiat_secp384r1_uint1 x76;
    uint64_t x77;
    fiat_secp384r1_uint1 x78;
    uint64_t x79;
    fiat_secp384r1_uint1 x80;
    uint64_t x81;
    fiat_secp384r1_uint1 x82;
    uint64_t x83;
    fiat_secp384r1_uint1 x84;
    uint64_t x85;
    fiat_secp384r1_uint1 x86;
    uint64_t x87;
    fiat_secp384r1_uint1 x88;
    uint64_t x89;
    uint64_t x90;
    uint64_t x91;
    uint64_t x92;
    uint64_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint64_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    fiat_secp384r1_uint1 x104;
    uint64_t x105;
    fiat_secp384r1_uint1 x106;
    uint64_t x107;
    fiat_secp384r1_uint1 x108;
    uint64_t x109;
    fiat_secp384r1_uint1 x110;
    uint64_t x111;
    fiat_secp384r1_uint1 x112;
    uint64_t x113;
    fiat_secp384r1_uint1 x114;
    uint64_t x115;
    fiat_secp384r1_uint1 x116;
    uint64_t x117;
    fiat_secp384r1_uint1 x118;
    uint64_t x119;
    fiat_secp384r1_uint1 x120;
    uint64_t x121;
    fiat_secp384r1_uint1 x122;
    uint64_t x123;
    fiat_secp384r1_uint1 x124;
    uint64_t x125;
    fiat_secp384r1_uint1 x126;
    uint64_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    fiat_secp384r1_uint1 x136;
    uint64_t x137;
    fiat_secp384r1_uint1 x138;
    uint64_t x139;
    fiat_secp384r1_uint1 x140;
    uint64_t x141;
    fiat_secp384r1_uint1 x142;
    uint64_t x143;
    fiat_secp384r1_uint1 x144;
    uint64_t x145;
    fiat_secp384r1_uint1 x146;
    uint64_t x147;
    fiat_secp384r1_uint1 x148;
    uint64_t x149;
    fiat_secp384r1_uint1 x150;
    uint64_t x151;
    fiat_secp384r1_uint1 x152;
    uint64_t x153;
    fiat_secp384r1_uint1 x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    uint64_t x159;
    uint64_t x160;
    uint64_t x161;
    uint64_t x162;
    uint64_t x163;
    uint64_t x164;
    uint64_t x165;
    uint64_t x166;
    uint64_t x167;
    uint64_t x168;
    uint64_t x169;
    fiat_secp384r1_uint1 x170;
    uint64_t x171;
    fiat_secp384r1_uint1 x172;
    uint64_t x173;
    fiat_secp384r1_uint1 x174;
    uint64_t x175;
    fiat_secp384r1_uint1 x176;
    uint64_t x177;
    fiat_secp384r1_uint1 x178;
    uint64_t x179;
    fiat_secp384r1_uint1 x180;
    uint64_t x181;
    fiat_secp384r1_uint1 x182;
    uint64_t x183;
    fiat_secp384r1_uint1 x184;
    uint64_t x185;
    fiat_secp384r1_uint1 x186;
    uint64_t x187;
    fiat_secp384r1_uint1 x188;
    uint64_t x189;
    fiat_secp384r1_uint1 x190;
    uint64_t x191;
    fiat_secp384r1_uint1 x192;
    uint64_t x193;
    uint64_t x194;
    uint64_t x195;
    uint64_t x196;
    uint64_t x197;
    uint64_t x198;
    uint64_t x199;
    uint64_t x200;
    uint64_t x201;
    fiat_secp384r1_uint1 x202;
    uint64_t x203;
    fiat_secp384r1_uint1 x204;
    uint64_t x205;
    fiat_secp384r1_uint1 x206;
    uint64_t x207;
    fiat_secp384r1_uint1 x208;
    uint64_t x209;
    fiat_secp384r1_uint1 x210;
    uint64_t x211;
    fiat_secp384r1_uint1 x212;
    uint64_t x213;
    fiat_secp384r1_uint1 x214;
    uint64_t x215;
    fiat_secp384r1_uint1 x216;
    uint64_t x217;
    fiat_secp384r1_uint1 x218;
    uint64_t x219;
    fiat_secp384r1_uint1 x220;
    uint64_t x221;
    uint64_t x222;
    uint64_t x223;
    uint64_t x224;
    uint64_t x225;
    uint64_t x226;
    uint64_t x227;
    uint64_t x228;
    uint64_t x229;
    uint64_t x230;
    uint64_t x231;
    uint64_t x232;
    uint64_t x233;
    uint64_t x234;
    uint64_t x235;
    fiat_secp384r1_uint1 x236;
    uint64_t x237;
    fiat_secp384r1_uint1 x238;
    uint64_t x239;
    fiat_secp384r1_uint1 x240;
    uint64_t x241;
    fiat_secp384r1_uint1 x242;
    uint64_t x243;
    fiat_secp384r1_uint1 x244;
    uint64_t x245;
    fiat_secp384r1_uint1 x246;
    uint64_t x247;
    fiat_secp384r1_uint1 x248;
    uint64_t x249;
    fiat_secp384r1_uint1 x250;
    uint64_t x251;
    fiat_secp384r1_uint1 x252;
    uint64_t x253;
    fiat_secp384r1_uint1 x254;
    uint64_t x255;
    fiat_secp384r1_uint1 x256;
    uint64_t x257;
    fiat_secp384r1_uint1 x258;
    uint64_t x259;
    uint64_t x260;
    uint64_t x261;
    uint64_t x262;
    uint64_t x263;
    uint64_t x264;
    uint64_t x265;
    uint64_t x266;
    uint64_t x267;
    fiat_secp384r1_uint1 x268;
    uint64_t x269;
    fiat_secp384r1_uint1 x270;
    uint64_t x271;
    fiat_secp384r1_uint1 x272;
    uint64_t x273;
    fiat_secp384r1_uint1 x274;
    uint64_t x275;
    fiat_secp384r1_uint1 x276;
    uint64_t x277;
    fiat_secp384r1_uint1 x278;
    uint64_t x279;
    fiat_secp384r1_uint1 x280;
    uint64_t x281;
    fiat_secp384r1_uint1 x282;
    uint64_t x283;
    fiat_secp384r1_uint1 x284;
    uint64_t x285;
    fiat_secp384r1_uint1 x286;
    uint64_t x287;
    uint64_t x288;
    uint64_t x289;
    uint64_t x290;
    uint64_t x291;
    uint64_t x292;
    uint64_t x293;
    uint64_t x294;
    uint64_t x295;
    uint64_t x296;
    uint64_t x297;
    uint64_t x298;
    uint64_t x299;
    uint64_t x300;
    uint64_t x301;
    fiat_secp384r1_uint1 x302;
    uint64_t x303;
    fiat_secp384r1_uint1 x304;
    uint64_t x305;
    fiat_secp384r1_uint1 x306;
    uint64_t x307;
    fiat_secp384r1_uint1 x308;
    uint64_t x309;
    fiat_secp384r1_uint1 x310;
    uint64_t x311;
    fiat_secp384r1_uint1 x312;
    uint64_t x313;
    fiat_secp384r1_uint1 x314;
    uint64_t x315;
    fiat_secp384r1_uint1 x316;
    uint64_t x317;
    fiat_secp384r1_uint1 x318;
    uint64_t x319;
    fiat_secp384r1_uint1 x320;
    uint64_t x321;
    fiat_secp384r1_uint1 x322;
    uint64_t x323;
    fiat_secp384r1_uint1 x324;
    uint64_t x325;
    uint64_t x326;
    uint64_t x327;
    uint64_t x328;
    uint64_t x329;
    uint64_t x330;
    uint64_t x331;
    uint64_t x332;
    uint64_t x333;
    fiat_secp384r1_uint1 x334;
    uint64_t x335;
    fiat_secp384r1_uint1 x336;
    uint64_t x337;
    fiat_secp384r1_uint1 x338;
    uint64_t x339;
    fiat_secp384r1_uint1 x340;
    uint64_t x341;
    fiat_secp384r1_uint1 x342;
    uint64_t x343;
    fiat_secp384r1_uint1 x344;
    uint64_t x345;
    fiat_secp384r1_uint1 x346;
    uint64_t x347;
    fiat_secp384r1_uint1 x348;
    uint64_t x349;
    fiat_secp384r1_uint1 x350;
    uint64_t x351;
    fiat_secp384r1_uint1 x352;
    uint64_t x353;
    uint64_t x354;
    uint64_t x355;
    uint64_t x356;
    uint64_t x357;
    uint64_t x358;
    uint64_t x359;
    uint64_t x360;
    uint64_t x361;
    uint64_t x362;
    uint64_t x363;
    uint64_t x364;
    uint64_t x365;
    uint64_t x366;
    uint64_t x367;
    fiat_secp384r1_uint1 x368;
    uint64_t x369;
    fiat_secp384r1_uint1 x370;
    uint64_t x371;
    fiat_secp384r1_uint1 x372;
    uint64_t x373;
    fiat_secp384r1_uint1 x374;
    uint64_t x375;
    fiat_secp384r1_uint1 x376;
    uint64_t x377;
    fiat_secp384r1_uint1 x378;
    uint64_t x379;
    fiat_secp384r1_uint1 x380;
    uint64_t x381;
    fiat_secp384r1_uint1 x382;
    uint64_t x383;
    fiat_secp384r1_uint1 x384;
    uint64_t x385;
    fiat_secp384r1_uint1 x386;
    uint64_t x387;
    fiat_secp384r1_uint1 x388;
    uint64_t x389;
    fiat_secp384r1_uint1 x390;
    uint64_t x391;
    fiat_secp384r1_uint1 x392;
    uint64_t x393;
    fiat_secp384r1_uint1 x394;
    uint64_t x395;
    fiat_secp384r1_uint1 x396;
    uint64_t x397;
    fiat_secp384r1_uint1 x398;
    uint64_t x399;
    fiat_secp384r1_uint1 x400;
    uint64_t x401;
    fiat_secp384r1_uint1 x402;
    uint64_t x403;
    fiat_secp384r1_uint1 x404;
    uint64_t x405;
    uint64_t x406;
    uint64_t x407;
    uint64_t x408;
    uint64_t x409;
    uint64_t x410;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[0]);
    fiat_secp384r1_mulx_u64(&x7, &x8, x6, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x9, &x10, x6, UINT64_C(0xfffffffe00000000));
    fiat_secp384r1_mulx_u64(&x11, &x12, x6, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x13, &x14, x6, UINT64_C(0xfffffffe00000001));
    fiat_secp384r1_addcarryx_u64(&x15, &x16, 0x0, x14, x11);
    fiat_secp384r1_addcarryx_u64(&x17, &x18, x16, x12, x9);
    fiat_secp384r1_addcarryx_u64(&x19, &x20, x18, x10, x7);
    fiat_secp384r1_addcarryx_u64(&x21, &x22, x20, x8, x6);
    fiat_secp384r1_mulx_u64(&x23, &x24, x13, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x25, &x26, x23, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x27, &x28, x23, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x29, &x30, x23, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x31, &x32, x23, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x33, &x34, x23, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x35, &x36, x23, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x37, &x38, 0x0, x36, x33);
    fiat_secp384r1_addcarryx_u64(&x39, &x40, x38, x34, x31);
    fiat_secp384r1_addcarryx_u64(&x41, &x42, x40, x32, x29);
    fiat_secp384r1_addcarryx_u64(&x43, &x44, x42, x30, x27);
    fiat_secp384r1_addcarryx_u64(&x45, &x46, x44, x28, x25);
    fiat_secp384r1_addcarryx_u64(&x47, &x48, 0x0, x13, x35);
    fiat_secp384r1_addcarryx_u64(&x49, &x50, x48, x15, x37);
    fiat_secp384r1_addcarryx_u64(&x51, &x52, x50, x17, x39);
    fiat_secp384r1_addcarryx_u64(&x53, &x54, x52, x19, x41);
    fiat_secp384r1_addcarryx_u64(&x55, &x56, x54, x21, x43);
    fiat_secp384r1_addcarryx_u64(&x57, &x58, x56, x22, x45);
    fiat_secp384r1_addcarryx_u64(&x59, &x60, x58, 0x0, (x46 + x26));
    fiat_secp384r1_mulx_u64(&x61, &x62, x1, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x63, &x64, x1, UINT64_C(0xfffffffe00000000));
    fiat_secp384r1_mulx_u64(&x65, &x66, x1, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x67, &x68, x1, UINT64_C(0xfffffffe00000001));
    fiat_secp384r1_addcarryx_u64(&x69, &x70, 0x0, x68, x65);
    fiat_secp384r1_addcarryx_u64(&x71, &x72, x70, x66, x63);
    fiat_secp384r1_addcarryx_u64(&x73, &x74, x72, x64, x61);
    fiat_secp384r1_addcarryx_u64(&x75, &x76, x74, x62, x1);
    fiat_secp384r1_addcarryx_u64(&x77, &x78, 0x0, x49, x67);
    fiat_secp384r1_addcarryx_u64(&x79, &x80, x78, x51, x69);
    fiat_secp384r1_addcarryx_u64(&x81, &x82, x80, x53, x71);
    fiat_secp384r1_addcarryx_u64(&x83, &x84, x82, x55, x73);
    fiat_secp384r1_addcarryx_u64(&x85, &x86, x84, x57, x75);
    fiat_secp384r1_addcarryx_u64(&x87, &x88, x86, x59, x76);
    fiat_secp384r1_mulx_u64(&x89, &x90, x77, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x91, &x92, x89, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x93, &x94, x89, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x95, &x96, x89, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x97, &x98, x89, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x99, &x100, x89, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x101, &x102, x89, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x103, &x104, 0x0, x102, x99);
    fiat_secp384r1_addcarryx_u64(&x105, &x106, x104, x100, x97);
    fiat_secp384r1_addcarryx_u64(&x107, &x108, x106, x98, x95);
    fiat_secp384r1_addcarryx_u64(&x109, &x110, x108, x96, x93);
    fiat_secp384r1_addcarryx_u64(&x111, &x112, x110, x94, x91);
    fiat_secp384r1_addcarryx_u64(&x113, &x114, 0x0, x77, x101);
    fiat_secp384r1_addcarryx_u64(&x115, &x116, x114, x79, x103);
    fiat_secp384r1_addcarryx_u64(&x117, &x118, x116, x81, x105);
    fiat_secp384r1_addcarryx_u64(&x119, &x120, x118, x83, x107);
    fiat_secp384r1_addcarryx_u64(&x121, &x122, x120, x85, x109);
    fiat_secp384r1_addcarryx_u64(&x123, &x124, x122, x87, x111);
    fiat_secp384r1_addcarryx_u64(&x125, &x126, x124, ((uint64_t)x88 + x60),
                                 (x112 + x92));
    fiat_secp384r1_mulx_u64(&x127, &x128, x2, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x129, &x130, x2, UINT64_C(0xfffffffe00000000));
    fiat_secp384r1_mulx_u64(&x131, &x132, x2, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x133, &x134, x2, UINT64_C(0xfffffffe00000001));
    fiat_secp384r1_addcarryx_u64(&x135, &x136, 0x0, x134, x131);
    fiat_secp384r1_addcarryx_u64(&x137, &x138, x136, x132, x129);
    fiat_secp384r1_addcarryx_u64(&x139, &x140, x138, x130, x127);
    fiat_secp384r1_addcarryx_u64(&x141, &x142, x140, x128, x2);
    fiat_secp384r1_addcarryx_u64(&x143, &x144, 0x0, x115, x133);
    fiat_secp384r1_addcarryx_u64(&x145, &x146, x144, x117, x135);
    fiat_secp384r1_addcarryx_u64(&x147, &x148, x146, x119, x137);
    fiat_secp384r1_addcarryx_u64(&x149, &x150, x148, x121, x139);
    fiat_secp384r1_addcarryx_u64(&x151, &x152, x150, x123, x141);
    fiat_secp384r1_addcarryx_u64(&x153, &x154, x152, x125, x142);
    fiat_secp384r1_mulx_u64(&x155, &x156, x143, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x157, &x158, x155, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x159, &x160, x155, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x161, &x162, x155, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x163, &x164, x155, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x165, &x166, x155, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x167, &x168, x155, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x169, &x170, 0x0, x168, x165);
    fiat_secp384r1_addcarryx_u64(&x171, &x172, x170, x166, x163);
    fiat_secp384r1_addcarryx_u64(&x173, &x174, x172, x164, x161);
    fiat_secp384r1_addcarryx_u64(&x175, &x176, x174, x162, x159);
    fiat_secp384r1_addcarryx_u64(&x177, &x178, x176, x160, x157);
    fiat_secp384r1_addcarryx_u64(&x179, &x180, 0x0, x143, x167);
    fiat_secp384r1_addcarryx_u64(&x181, &x182, x180, x145, x169);
    fiat_secp384r1_addcarryx_u64(&x183, &x184, x182, x147, x171);
    fiat_secp384r1_addcarryx_u64(&x185, &x186, x184, x149, x173);
    fiat_secp384r1_addcarryx_u64(&x187, &x188, x186, x151, x175);
    fiat_secp384r1_addcarryx_u64(&x189, &x190, x188, x153, x177);
    fiat_secp384r1_addcarryx_u64(&x191, &x192, x190, ((uint64_t)x154 + x126),
                                 (x178 + x158));
    fiat_secp384r1_mulx_u64(&x193, &x194, x3, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x195, &x196, x3, UINT64_C(0xfffffffe00000000));
    fiat_secp384r1_mulx_u64(&x197, &x198, x3, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x199, &x200, x3, UINT64_C(0xfffffffe00000001));
    fiat_secp384r1_addcarryx_u64(&x201, &x202, 0x0, x200, x197);
    fiat_secp384r1_addcarryx_u64(&x203, &x204, x202, x198, x195);
    fiat_secp384r1_addcarryx_u64(&x205, &x206, x204, x196, x193);
    fiat_secp384r1_addcarryx_u64(&x207, &x208, x206, x194, x3);
    fiat_secp384r1_addcarryx_u64(&x209, &x210, 0x0, x181, x199);
    fiat_secp384r1_addcarryx_u64(&x211, &x212, x210, x183, x201);
    fiat_secp384r1_addcarryx_u64(&x213, &x214, x212, x185, x203);
    fiat_secp384r1_addcarryx_u64(&x215, &x216, x214, x187, x205);
    fiat_secp384r1_addcarryx_u64(&x217, &x218, x216, x189, x207);
    fiat_secp384r1_addcarryx_u64(&x219, &x220, x218, x191, x208);
    fiat_secp384r1_mulx_u64(&x221, &x222, x209, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x223, &x224, x221, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x225, &x226, x221, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x227, &x228, x221, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x229, &x230, x221, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x231, &x232, x221, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x233, &x234, x221, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x235, &x236, 0x0, x234, x231);
    fiat_secp384r1_addcarryx_u64(&x237, &x238, x236, x232, x229);
    fiat_secp384r1_addcarryx_u64(&x239, &x240, x238, x230, x227);
    fiat_secp384r1_addcarryx_u64(&x241, &x242, x240, x228, x225);
    fiat_secp384r1_addcarryx_u64(&x243, &x244, x242, x226, x223);
    fiat_secp384r1_addcarryx_u64(&x245, &x246, 0x0, x209, x233);
    fiat_secp384r1_addcarryx_u64(&x247, &x248, x246, x211, x235);
    fiat_secp384r1_addcarryx_u64(&x249, &x250, x248, x213, x237);
    fiat_secp384r1_addcarryx_u64(&x251, &x252, x250, x215, x239);
    fiat_secp384r1_addcarryx_u64(&x253, &x254, x252, x217, x241);
    fiat_secp384r1_addcarryx_u64(&x255, &x256, x254, x219, x243);
    fiat_secp384r1_addcarryx_u64(&x257, &x258, x256, ((uint64_t)x220 + x192),
                                 (x244 + x224));
    fiat_secp384r1_mulx_u64(&x259, &x260, x4, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x261, &x262, x4, UINT64_C(0xfffffffe00000000));
    fiat_secp384r1_mulx_u64(&x263, &x264, x4, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x265, &x266, x4, UINT64_C(0xfffffffe00000001));
    fiat_secp384r1_addcarryx_u64(&x267, &x268, 0x0, x266, x263);
    fiat_secp384r1_addcarryx_u64(&x269, &x270, x268, x264, x261);
    fiat_secp384r1_addcarryx_u64(&x271, &x272, x270, x262, x259);
    fiat_secp384r1_addcarryx_u64(&x273, &x274, x272, x260, x4);
    fiat_secp384r1_addcarryx_u64(&x275, &x276, 0x0, x247, x265);
    fiat_secp384r1_addcarryx_u64(&x277, &x278, x276, x249, x267);
    fiat_secp384r1_addcarryx_u64(&x279, &x280, x278, x251, x269);
    fiat_secp384r1_addcarryx_u64(&x281, &x282, x280, x253, x271);
    fiat_secp384r1_addcarryx_u64(&x283, &x284, x282, x255, x273);
    fiat_secp384r1_addcarryx_u64(&x285, &x286, x284, x257, x274);
    fiat_secp384r1_mulx_u64(&x287, &x288, x275, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x289, &x290, x287, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x291, &x292, x287, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x293, &x294, x287, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x295, &x296, x287, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x297, &x298, x287, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x299, &x300, x287, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x301, &x302, 0x0, x300, x297);
    fiat_secp384r1_addcarryx_u64(&x303, &x304, x302, x298, x295);
    fiat_secp384r1_addcarryx_u64(&x305, &x306, x304, x296, x293);
    fiat_secp384r1_addcarryx_u64(&x307, &x308, x306, x294, x291);
    fiat_secp384r1_addcarryx_u64(&x309, &x310, x308, x292, x289);
    fiat_secp384r1_addcarryx_u64(&x311, &x312, 0x0, x275, x299);
    fiat_secp384r1_addcarryx_u64(&x313, &x314, x312, x277, x301);
    fiat_secp384r1_addcarryx_u64(&x315, &x316, x314, x279, x303);
    fiat_secp384r1_addcarryx_u64(&x317, &x318, x316, x281, x305);
    fiat_secp384r1_addcarryx_u64(&x319, &x320, x318, x283, x307);
    fiat_secp384r1_addcarryx_u64(&x321, &x322, x320, x285, x309);
    fiat_secp384r1_addcarryx_u64(&x323, &x324, x322, ((uint64_t)x286 + x258),
                                 (x310 + x290));
    fiat_secp384r1_mulx_u64(&x325, &x326, x5, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x327, &x328, x5, UINT64_C(0xfffffffe00000000));
    fiat_secp384r1_mulx_u64(&x329, &x330, x5, UINT64_C(0x200000000));
    fiat_secp384r1_mulx_u64(&x331, &x332, x5, UINT64_C(0xfffffffe00000001));
    fiat_secp384r1_addcarryx_u64(&x333, &x334, 0x0, x332, x329);
    fiat_secp384r1_addcarryx_u64(&x335, &x336, x334, x330, x327);
    fiat_secp384r1_addcarryx_u64(&x337, &x338, x336, x328, x325);
    fiat_secp384r1_addcarryx_u64(&x339, &x340, x338, x326, x5);
    fiat_secp384r1_addcarryx_u64(&x341, &x342, 0x0, x313, x331);
    fiat_secp384r1_addcarryx_u64(&x343, &x344, x342, x315, x333);
    fiat_secp384r1_addcarryx_u64(&x345, &x346, x344, x317, x335);
    fiat_secp384r1_addcarryx_u64(&x347, &x348, x346, x319, x337);
    fiat_secp384r1_addcarryx_u64(&x349, &x350, x348, x321, x339);
    fiat_secp384r1_addcarryx_u64(&x351, &x352, x350, x323, x340);
    fiat_secp384r1_mulx_u64(&x353, &x354, x341, UINT64_C(0x100000001));
    fiat_secp384r1_mulx_u64(&x355, &x356, x353, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x357, &x358, x353, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x359, &x360, x353, UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_mulx_u64(&x361, &x362, x353, UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_mulx_u64(&x363, &x364, x353, UINT64_C(0xffffffff00000000));
    fiat_secp384r1_mulx_u64(&x365, &x366, x353, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u64(&x367, &x368, 0x0, x366, x363);
    fiat_secp384r1_addcarryx_u64(&x369, &x370, x368, x364, x361);
    fiat_secp384r1_addcarryx_u64(&x371, &x372, x370, x362, x359);
    fiat_secp384r1_addcarryx_u64(&x373, &x374, x372, x360, x357);
    fiat_secp384r1_addcarryx_u64(&x375, &x376, x374, x358, x355);
    fiat_secp384r1_addcarryx_u64(&x377, &x378, 0x0, x341, x365);
    fiat_secp384r1_addcarryx_u64(&x379, &x380, x378, x343, x367);
    fiat_secp384r1_addcarryx_u64(&x381, &x382, x380, x345, x369);
    fiat_secp384r1_addcarryx_u64(&x383, &x384, x382, x347, x371);
    fiat_secp384r1_addcarryx_u64(&x385, &x386, x384, x349, x373);
    fiat_secp384r1_addcarryx_u64(&x387, &x388, x386, x351, x375);
    fiat_secp384r1_addcarryx_u64(&x389, &x390, x388, ((uint64_t)x352 + x324),
                                 (x376 + x356));
    fiat_secp384r1_subborrowx_u64(&x391, &x392, 0x0, x379,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u64(&x393, &x394, x392, x381,
                                  UINT64_C(0xffffffff00000000));
    fiat_secp384r1_subborrowx_u64(&x395, &x396, x394, x383,
                                  UINT64_C(0xfffffffffffffffe));
    fiat_secp384r1_subborrowx_u64(&x397, &x398, x396, x385,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x399, &x400, x398, x387,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x401, &x402, x400, x389,
                                  UINT64_C(0xffffffffffffffff));
    fiat_secp384r1_subborrowx_u64(&x403, &x404, x402, x390, 0x0);
    fiat_secp384r1_cmovznz_u64(&x405, x404, x391, x379);
    fiat_secp384r1_cmovznz_u64(&x406, x404, x393, x381);
    fiat_secp384r1_cmovznz_u64(&x407, x404, x395, x383);
    fiat_secp384r1_cmovznz_u64(&x408, x404, x397, x385);
    fiat_secp384r1_cmovznz_u64(&x409, x404, x399, x387);
    fiat_secp384r1_cmovznz_u64(&x410, x404, x401, x389);
    out1[0] = x405;
    out1[1] = x406;
    out1[2] = x407;
    out1[3] = x408;
    out1[4] = x409;
    out1[5] = x410;
}

/*
 * The function fiat_secp384r1_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void
fiat_secp384r1_nonzero(uint64_t *out1, const uint64_t arg1[6])
{
    uint64_t x1;
    x1 = ((arg1[0]) |
          ((arg1[1]) |
           ((arg1[2]) |
            ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | (uint64_t)0x0))))));
    *out1 = x1;
}

/*
 * The function fiat_secp384r1_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_selectznz(uint64_t out1[6],
                         fiat_secp384r1_uint1 arg1,
                         const uint64_t arg2[6],
                         const uint64_t arg3[6])
{
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    fiat_secp384r1_cmovznz_u64(&x1, arg1, (arg2[0]), (arg3[0]));
    fiat_secp384r1_cmovznz_u64(&x2, arg1, (arg2[1]), (arg3[1]));
    fiat_secp384r1_cmovznz_u64(&x3, arg1, (arg2[2]), (arg3[2]));
    fiat_secp384r1_cmovznz_u64(&x4, arg1, (arg2[3]), (arg3[3]));
    fiat_secp384r1_cmovznz_u64(&x5, arg1, (arg2[4]), (arg3[4]));
    fiat_secp384r1_cmovznz_u64(&x6, arg1, (arg2[5]), (arg3[5]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
}

/*
 * The function fiat_secp384r1_to_bytes serializes a field element in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void
fiat_secp384r1_to_bytes(uint8_t out1[48], const uint64_t arg1[6])
{
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint8_t x8;
    uint64_t x9;
    uint8_t x10;
    uint64_t x11;
    uint8_t x12;
    uint64_t x13;
    uint8_t x14;
    uint64_t x15;
    uint8_t x16;
    uint64_t x17;
    uint8_t x18;
    uint8_t x19;
    uint8_t x20;
    uint8_t x21;
    uint64_t x22;
    uint8_t x23;
    uint64_t x24;
    uint8_t x25;
    uint64_t x26;
    uint8_t x27;
    uint64_t x28;
    uint8_t x29;
    uint64_t x30;
    uint8_t x31;
    uint64_t x32;
    uint8_t x33;
    uint8_t x34;
    uint8_t x35;
    uint8_t x36;
    uint64_t x37;
    uint8_t x38;
    uint64_t x39;
    uint8_t x40;
    uint64_t x41;
    uint8_t x42;
    uint64_t x43;
    uint8_t x44;
    uint64_t x45;
    uint8_t x46;
    uint64_t x47;
    uint8_t x48;
    uint8_t x49;
    uint8_t x50;
    uint8_t x51;
    uint64_t x52;
    uint8_t x53;
    uint64_t x54;
    uint8_t x55;
    uint64_t x56;
    uint8_t x57;
    uint64_t x58;
    uint8_t x59;
    uint64_t x60;
    uint8_t x61;
    uint64_t x62;
    uint8_t x63;
    uint8_t x64;
    uint8_t x65;
    uint8_t x66;
    uint64_t x67;
    uint8_t x68;
    uint64_t x69;
    uint8_t x70;
    uint64_t x71;
    uint8_t x72;
    uint64_t x73;
    uint8_t x74;
    uint64_t x75;
    uint8_t x76;
    uint64_t x77;
    uint8_t x78;
    uint8_t x79;
    uint8_t x80;
    uint8_t x81;
    uint64_t x82;
    uint8_t x83;
    uint64_t x84;
    uint8_t x85;
    uint64_t x86;
    uint8_t x87;
    uint64_t x88;
    uint8_t x89;
    uint64_t x90;
    uint8_t x91;
    uint64_t x92;
    uint8_t x93;
    uint8_t x94;
    uint8_t x95;
    x1 = (arg1[5]);
    x2 = (arg1[4]);
    x3 = (arg1[3]);
    x4 = (arg1[2]);
    x5 = (arg1[1]);
    x6 = (arg1[0]);
    x7 = (x6 >> 8);
    x8 = (uint8_t)(x6 & UINT8_C(0xff));
    x9 = (x7 >> 8);
    x10 = (uint8_t)(x7 & UINT8_C(0xff));
    x11 = (x9 >> 8);
    x12 = (uint8_t)(x9 & UINT8_C(0xff));
    x13 = (x11 >> 8);
    x14 = (uint8_t)(x11 & UINT8_C(0xff));
    x15 = (x13 >> 8);
    x16 = (uint8_t)(x13 & UINT8_C(0xff));
    x17 = (x15 >> 8);
    x18 = (uint8_t)(x15 & UINT8_C(0xff));
    x19 = (uint8_t)(x17 >> 8);
    x20 = (uint8_t)(x17 & UINT8_C(0xff));
    x21 = (uint8_t)(x19 & UINT8_C(0xff));
    x22 = (x5 >> 8);
    x23 = (uint8_t)(x5 & UINT8_C(0xff));
    x24 = (x22 >> 8);
    x25 = (uint8_t)(x22 & UINT8_C(0xff));
    x26 = (x24 >> 8);
    x27 = (uint8_t)(x24 & UINT8_C(0xff));
    x28 = (x26 >> 8);
    x29 = (uint8_t)(x26 & UINT8_C(0xff));
    x30 = (x28 >> 8);
    x31 = (uint8_t)(x28 & UINT8_C(0xff));
    x32 = (x30 >> 8);
    x33 = (uint8_t)(x30 & UINT8_C(0xff));
    x34 = (uint8_t)(x32 >> 8);
    x35 = (uint8_t)(x32 & UINT8_C(0xff));
    x36 = (uint8_t)(x34 & UINT8_C(0xff));
    x37 = (x4 >> 8);
    x38 = (uint8_t)(x4 & UINT8_C(0xff));
    x39 = (x37 >> 8);
    x40 = (uint8_t)(x37 & UINT8_C(0xff));
    x41 = (x39 >> 8);
    x42 = (uint8_t)(x39 & UINT8_C(0xff));
    x43 = (x41 >> 8);
    x44 = (uint8_t)(x41 & UINT8_C(0xff));
    x45 = (x43 >> 8);
    x46 = (uint8_t)(x43 & UINT8_C(0xff));
    x47 = (x45 >> 8);
    x48 = (uint8_t)(x45 & UINT8_C(0xff));
    x49 = (uint8_t)(x47 >> 8);
    x50 = (uint8_t)(x47 & UINT8_C(0xff));
    x51 = (uint8_t)(x49 & UINT8_C(0xff));
    x52 = (x3 >> 8);
    x53 = (uint8_t)(x3 & UINT8_C(0xff));
    x54 = (x52 >> 8);
    x55 = (uint8_t)(x52 & UINT8_C(0xff));
    x56 = (x54 >> 8);
    x57 = (uint8_t)(x54 & UINT8_C(0xff));
    x58 = (x56 >> 8);
    x59 = (uint8_t)(x56 & UINT8_C(0xff));
    x60 = (x58 >> 8);
    x61 = (uint8_t)(x58 & UINT8_C(0xff));
    x62 = (x60 >> 8);
    x63 = (uint8_t)(x60 & UINT8_C(0xff));
    x64 = (uint8_t)(x62 >> 8);
    x65 = (uint8_t)(x62 & UINT8_C(0xff));
    x66 = (uint8_t)(x64 & UINT8_C(0xff));
    x67 = (x2 >> 8);
    x68 = (uint8_t)(x2 & UINT8_C(0xff));
    x69 = (x67 >> 8);
    x70 = (uint8_t)(x67 & UINT8_C(0xff));
    x71 = (x69 >> 8);
    x72 = (uint8_t)(x69 & UINT8_C(0xff));
    x73 = (x71 >> 8);
    x74 = (uint8_t)(x71 & UINT8_C(0xff));
    x75 = (x73 >> 8);
    x76 = (uint8_t)(x73 & UINT8_C(0xff));
    x77 = (x75 >> 8);
    x78 = (uint8_t)(x75 & UINT8_C(0xff));
    x79 = (uint8_t)(x77 >> 8);
    x80 = (uint8_t)(x77 & UINT8_C(0xff));
    x81 = (uint8_t)(x79 & UINT8_C(0xff));
    x82 = (x1 >> 8);
    x83 = (uint8_t)(x1 & UINT8_C(0xff));
    x84 = (x82 >> 8);
    x85 = (uint8_t)(x82 & UINT8_C(0xff));
    x86 = (x84 >> 8);
    x87 = (uint8_t)(x84 & UINT8_C(0xff));
    x88 = (x86 >> 8);
    x89 = (uint8_t)(x86 & UINT8_C(0xff));
    x90 = (x88 >> 8);
    x91 = (uint8_t)(x88 & UINT8_C(0xff));
    x92 = (x90 >> 8);
    x93 = (uint8_t)(x90 & UINT8_C(0xff));
    x94 = (uint8_t)(x92 >> 8);
    x95 = (uint8_t)(x92 & UINT8_C(0xff));
    out1[0] = x8;
    out1[1] = x10;
    out1[2] = x12;
    out1[3] = x14;
    out1[4] = x16;
    out1[5] = x18;
    out1[6] = x20;
    out1[7] = x21;
    out1[8] = x23;
    out1[9] = x25;
    out1[10] = x27;
    out1[11] = x29;
    out1[12] = x31;
    out1[13] = x33;
    out1[14] = x35;
    out1[15] = x36;
    out1[16] = x38;
    out1[17] = x40;
    out1[18] = x42;
    out1[19] = x44;
    out1[20] = x46;
    out1[21] = x48;
    out1[22] = x50;
    out1[23] = x51;
    out1[24] = x53;
    out1[25] = x55;
    out1[26] = x57;
    out1[27] = x59;
    out1[28] = x61;
    out1[29] = x63;
    out1[30] = x65;
    out1[31] = x66;
    out1[32] = x68;
    out1[33] = x70;
    out1[34] = x72;
    out1[35] = x74;
    out1[36] = x76;
    out1[37] = x78;
    out1[38] = x80;
    out1[39] = x81;
    out1[40] = x83;
    out1[41] = x85;
    out1[42] = x87;
    out1[43] = x89;
    out1[44] = x91;
    out1[45] = x93;
    out1[46] = x95;
    out1[47] = x94;
}

/*
 * The function fiat_secp384r1_from_bytes deserializes a field element in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void
fiat_secp384r1_from_bytes(uint64_t out1[6],
                          const uint8_t arg1[48])
{
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint8_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint8_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint8_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint8_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint8_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint8_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    x1 = ((uint64_t)(arg1[47]) << 56);
    x2 = ((uint64_t)(arg1[46]) << 48);
    x3 = ((uint64_t)(arg1[45]) << 40);
    x4 = ((uint64_t)(arg1[44]) << 32);
    x5 = ((uint64_t)(arg1[43]) << 24);
    x6 = ((uint64_t)(arg1[42]) << 16);
    x7 = ((uint64_t)(arg1[41]) << 8);
    x8 = (arg1[40]);
    x9 = ((uint64_t)(arg1[39]) << 56);
    x10 = ((uint64_t)(arg1[38]) << 48);
    x11 = ((uint64_t)(arg1[37]) << 40);
    x12 = ((uint64_t)(arg1[36]) << 32);
    x13 = ((uint64_t)(arg1[35]) << 24);
    x14 = ((uint64_t)(arg1[34]) << 16);
    x15 = ((uint64_t)(arg1[33]) << 8);
    x16 = (arg1[32]);
    x17 = ((uint64_t)(arg1[31]) << 56);
    x18 = ((uint64_t)(arg1[30]) << 48);
    x19 = ((uint64_t)(arg1[29]) << 40);
    x20 = ((uint64_t)(arg1[28]) << 32);
    x21 = ((uint64_t)(arg1[27]) << 24);
    x22 = ((uint64_t)(arg1[26]) << 16);
    x23 = ((uint64_t)(arg1[25]) << 8);
    x24 = (arg1[24]);
    x25 = ((uint64_t)(arg1[23]) << 56);
    x26 = ((uint64_t)(arg1[22]) << 48);
    x27 = ((uint64_t)(arg1[21]) << 40);
    x28 = ((uint64_t)(arg1[20]) << 32);
    x29 = ((uint64_t)(arg1[19]) << 24);
    x30 = ((uint64_t)(arg1[18]) << 16);
    x31 = ((uint64_t)(arg1[17]) << 8);
    x32 = (arg1[16]);
    x33 = ((uint64_t)(arg1[15]) << 56);
    x34 = ((uint64_t)(arg1[14]) << 48);
    x35 = ((uint64_t)(arg1[13]) << 40);
    x36 = ((uint64_t)(arg1[12]) << 32);
    x37 = ((uint64_t)(arg1[11]) << 24);
    x38 = ((uint64_t)(arg1[10]) << 16);
    x39 = ((uint64_t)(arg1[9]) << 8);
    x40 = (arg1[8]);
    x41 = ((uint64_t)(arg1[7]) << 56);
    x42 = ((uint64_t)(arg1[6]) << 48);
    x43 = ((uint64_t)(arg1[5]) << 40);
    x44 = ((uint64_t)(arg1[4]) << 32);
    x45 = ((uint64_t)(arg1[3]) << 24);
    x46 = ((uint64_t)(arg1[2]) << 16);
    x47 = ((uint64_t)(arg1[1]) << 8);
    x48 = (arg1[0]);
    x49 = (x48 + (x47 + (x46 + (x45 + (x44 + (x43 + (x42 + x41)))))));
    x50 = (x49 & UINT64_C(0xffffffffffffffff));
    x51 = (x8 + (x7 + (x6 + (x5 + (x4 + (x3 + (x2 + x1)))))));
    x52 = (x16 + (x15 + (x14 + (x13 + (x12 + (x11 + (x10 + x9)))))));
    x53 = (x24 + (x23 + (x22 + (x21 + (x20 + (x19 + (x18 + x17)))))));
    x54 = (x32 + (x31 + (x30 + (x29 + (x28 + (x27 + (x26 + x25)))))));
    x55 = (x40 + (x39 + (x38 + (x37 + (x36 + (x35 + (x34 + x33)))))));
    x56 = (x55 & UINT64_C(0xffffffffffffffff));
    x57 = (x54 & UINT64_C(0xffffffffffffffff));
    x58 = (x53 & UINT64_C(0xffffffffffffffff));
    x59 = (x52 & UINT64_C(0xffffffffffffffff));
    out1[0] = x50;
    out1[1] = x56;
    out1[2] = x57;
    out1[3] = x58;
    out1[4] = x59;
    out1[5] = x51;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/secp384r1/fe_inv.op3
 * custom repunit addition chain
 */
static void
fiat_secp384r1_inv(fe_t output, const fe_t t1)
{
    int i;
    /* temporary variables */
    fe_t acc, t10, t170, t2, t20, t255, t30, t32, t4, t64, t8, t84, t85;

    fiat_secp384r1_square(acc, t1);
    fiat_secp384r1_mul(t2, acc, t1);
    fiat_secp384r1_square(acc, t2);
    fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t4, acc, t2);
    fiat_secp384r1_square(acc, t4);
    for (i = 0; i < 3; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t8, acc, t4);
    fiat_secp384r1_square(acc, t8);
    fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t10, acc, t2);
    fiat_secp384r1_square(acc, t10);
    for (i = 0; i < 9; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t20, acc, t10);
    fiat_secp384r1_square(acc, t20);
    for (i = 0; i < 9; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t30, acc, t10);
    fiat_secp384r1_square(acc, t30);
    fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t32, acc, t2);
    fiat_secp384r1_square(acc, t32);
    for (i = 0; i < 31; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t64, acc, t32);
    fiat_secp384r1_square(acc, t64);
    for (i = 0; i < 19; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t84, acc, t20);
    fiat_secp384r1_square(acc, t84);
    fiat_secp384r1_mul(t85, acc, t1);
    fiat_secp384r1_square(acc, t85);
    for (i = 0; i < 84; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t170, acc, t85);
    fiat_secp384r1_square(acc, t170);
    for (i = 0; i < 84; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t255, acc, t85);
    fiat_secp384r1_square(acc, t255);
    for (i = 0; i < 32; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(acc, acc, t32);
    for (i = 0; i < 94; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(acc, acc, t30);
    for (i = 0; i < 2; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(output, acc, t1);
}

/* curve coefficient constants */

static const limb_t const_one[6] = {
    UINT64_C(0xFFFFFFFF00000001), UINT64_C(0x00000000FFFFFFFF),
    UINT64_C(0x0000000000000001), UINT64_C(0x0000000000000000),
    UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)
};

static const limb_t const_b[6] = {
    UINT64_C(0x081188719D412DCC), UINT64_C(0xF729ADD87A4C32EC),
    UINT64_C(0x77F2209B1920022E), UINT64_C(0xE3374BEE94938AE2),
    UINT64_C(0xB62B21F41F022094), UINT64_C(0xCD08114B604FBFF9)
};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[21][16] = {
    {
        { { UINT64_C(0x3DD0756649C0B528), UINT64_C(0x20E378E2A0D6CE38),
            UINT64_C(0x879C3AFC541B4D6E), UINT64_C(0x6454868459A30EFF),
            UINT64_C(0x812FF723614EDE2B), UINT64_C(0x4D3AADC2299E1513) },
          { UINT64_C(0x23043DAD4B03A4FE), UINT64_C(0xA1BFA8BF7BB4A9AC),
            UINT64_C(0x8BADE7562E83B050), UINT64_C(0xC6C3521968F4FFD9),
            UINT64_C(0xDD8002263969A840), UINT64_C(0x2B78ABC25A15C5E9) } },
        { { UINT64_C(0x05E4DBE6C1DC4073), UINT64_C(0xC54EA9FFF04F779C),
            UINT64_C(0x6B2034E9A170CCF0), UINT64_C(0x3A48D732D51C6C3E),
            UINT64_C(0xE36F7E2D263AA470), UINT64_C(0xD283FE68E7C1C3AC) },
          { UINT64_C(0x7E284821C04EE157), UINT64_C(0x92D789A77AE0E36D),
            UINT64_C(0x132663C04EF67446), UINT64_C(0x68012D5AD2E1D0B4),
            UINT64_C(0xF6DB68B15102B339), UINT64_C(0x465465FC983292AF) } },
        { { UINT64_C(0xBB595EBA68F1F0DF), UINT64_C(0xC185C0CBCC873466),
            UINT64_C(0x7F1EB1B5293C703B), UINT64_C(0x60DB2CF5AACC05E6),
            UINT64_C(0xC676B987E2E8E4C6), UINT64_C(0xE1BB26B11D178FFB) },
          { UINT64_C(0x2B694BA07073FA21), UINT64_C(0x22C16E2E72F34566),
            UINT64_C(0x80B61B3101C35B99), UINT64_C(0x4B237FAF982C0411),
            UINT64_C(0xE6C5944024DE236D), UINT64_C(0x4DB1C9D6E209E4A3) } },
        { { UINT64_C(0xDF13B9D17D69222B), UINT64_C(0x4CE6415F874774B1),
            UINT64_C(0x731EDCF8211FAA95), UINT64_C(0x5F4215D1659753ED),
            UINT64_C(0xF893DB589DB2DF55), UINT64_C(0x932C9F811C89025B) },
          { UINT64_C(0x0996B2207706A61E), UINT64_C(0x135349D5A8641C79),
            UINT64_C(0x65AAD76F50130844), UINT64_C(0x0FF37C0401FFF780),
            UINT64_C(0xF57F238E693B0706), UINT64_C(0xD90A16B6AF6C9B3E) } },
        { { UINT64_C(0x2F5D200E2353B92F), UINT64_C(0xE35D87293FD7E4F9),
            UINT64_C(0x26094833A96D745D), UINT64_C(0xDC351DC13CBFFF3F),
            UINT64_C(0x26D464C6DAD54D6A), UINT64_C(0x5CAB1D1D53636C6A) },
          { UINT64_C(0xF2813072B18EC0B0), UINT64_C(0x3777E270D742AA2F),
            UINT64_C(0x27F061C7033CA7C2), UINT64_C(0xA6ECACCC68EAD0D8),
            UINT64_C(0x7D9429F4EE69A754), UINT64_C(0xE770633431E8F5C6) } },
        { { UINT64_C(0xC7708B19B68B8C7D), UINT64_C(0x4532077C44377ABA),
            UINT64_C(0x0DCC67706CDAD64F), UINT64_C(0x01B8BF56147B6602),
            UINT64_C(0xF8D89885F0561D79), UINT64_C(0x9C19E9FC7BA9C437) },
          { UINT64_C(0x764EB146BDC4BA25), UINT64_C(0x604FE46BAC144B83),
            UINT64_C(0x3CE813298A77E780), UINT64_C(0x2E070F36FE9E682E),
            UINT64_C(0x41821D0C3A53287A), UINT64_C(0x9AA62F9F3533F918) } },
        { { UINT64_C(0x9B7AEB7E75CCBDFB), UINT64_C(0xB25E28C5F6749A95),
            UINT64_C(0x8A7A8E4633B7D4AE), UINT64_C(0xDB5203A8D9C1BD56),
            UINT64_C(0xD2657265ED22DF97), UINT64_C(0xB51C56E18CF23C94) },
          { UINT64_C(0xF4D394596C3D812D), UINT64_C(0xD8E88F1A87CAE0C2),
            UINT64_C(0x789A2A48CF4D0FE3), UINT64_C(0xB7FEAC2DFEC38D60),
            UINT64_C(0x81FDBD1C3B490EC3), UINT64_C(0x4617ADB7CC6979E1) } },
        { { UINT64_C(0x446AD8884709F4A9), UINT64_C(0x2B7210E2EC3DABD8),
            UINT64_C(0x83CCF19550E07B34), UINT64_C(0x59500917789B3075),
            UINT64_C(0x0FC01FD4EB085993), UINT64_C(0xFB62D26F4903026B) },
          { UINT64_C(0x2309CC9D6FE989BB), UINT64_C(0x61609CBD144BD586),
            UINT64_C(0x4B23D3A0DE06610C), UINT64_C(0xDDDC2866D898F470),
            UINT64_C(0x8733FC41400C5797), UINT64_C(0x5A68C6FED0BC2716) } },
        { { UINT64_C(0x8903E1304B4A3CD0), UINT64_C(0x3EA4EA4C8FF1F43E),
            UINT64_C(0xE6FC3F2AF655A10D), UINT64_C(0x7BE3737D524FFEFC),
            UINT64_C(0x9F6928555330455E), UINT64_C(0x524F166EE475CE70) },
          { UINT64_C(0x3FCC69CD6C12F055), UINT64_C(0x4E23B6FFD5B9C0DA),
            UINT64_C(0x49CE6993336BF183), UINT64_C(0xF87D6D854A54504A),
            UINT64_C(0x25EB5DF1B3C2677A), UINT64_C(0xAC37986F55B164C9) } },
        { { UINT64_C(0x82A2ED4ABAA84C08), UINT64_C(0x22C4CC5F41A8C912),
            UINT64_C(0xCA109C3B154AAD5E), UINT64_C(0x23891298FC38538E),
            UINT64_C(0xB3B6639C539802AE), UINT64_C(0xFA0F1F450390D706) },
          { UINT64_C(0x46B78E5DB0DC21D0), UINT64_C(0xA8C72D3CC3DA2EAC),
            UINT64_C(0x9170B3786FF2F643), UINT64_C(0x3F5A799BB67F30C3),
            UINT64_C(0x15D1DC778264B672), UINT64_C(0xA1D47B23E9577764) } },
        { { UINT64_C(0x08265E510422CE2F), UINT64_C(0x88E0D496DD2F9E21),
            UINT64_C(0x30128AA06177F75D), UINT64_C(0x2E59AB62BD9EBE69),
            UINT64_C(0x1B1A0F6C5DF0E537), UINT64_C(0xAB16C626DAC012B5) },
          { UINT64_C(0x8014214B008C5DE7), UINT64_C(0xAA740A9E38F17BEA),
            UINT64_C(0x262EBB498A149098), UINT64_C(0xB454111E8527CD59),
            UINT64_C(0x266AD15AACEA5817), UINT64_C(0x21824F411353CCBA) } },
        { { UINT64_C(0xD1B4E74D12E3683B), UINT64_C(0x990ED20B569B8EF6),
            UINT64_C(0xB9D3DD25429C0A18), UINT64_C(0x1C75B8AB2A351783),
            UINT64_C(0x61E4CA2B905432F0), UINT64_C(0x80826A69EEA8F224) },
          { UINT64_C(0x7FC33A6BEC52ABAD), UINT64_C(0x0BCCA3F0A65E4813),
            UINT64_C(0x7AD8A132A527CEBE), UINT64_C(0xF0138950EAF22C7E),
            UINT64_C(0x282D2437566718C1), UINT64_C(0x9DFCCB0DE2212559) } },
        { { UINT64_C(0x1E93722758CE3B83), UINT64_C(0xBB280DFA3CB3FB36),
            UINT64_C(0x57D0F3D2E2BE174A), UINT64_C(0x9BD51B99208ABE1E),
            UINT64_C(0x3809AB50DE248024), UINT64_C(0xC29C6E2CA5BB7331) },
          { UINT64_C(0x9944FD2E61124F05), UINT64_C(0x83CCBC4E9009E391),
            UINT64_C(0x01628F059424A3CC), UINT64_C(0xD6A2F51DEA8E4344),
            UINT64_C(0xDA3E1A3D4CEBC96E), UINT64_C(0x1FE6FB42E97809DC) } },
        { { UINT64_C(0xA04482D2467D66E4), UINT64_C(0xCF1912934D78291D),
            UINT64_C(0x8E0D4168482396F9), UINT64_C(0x7228E2D5D18F14D0),
            UINT64_C(0x2F7E8D509C6A58FE), UINT64_C(0xE8CA780E373E5AEC) },
          { UINT64_C(0x42AAD1D61B68E9F8), UINT64_C(0x58A6D7F569E2F8F4),
            UINT64_C(0xD779ADFE31DA1BEA), UINT64_C(0x7D26540638C85A85),
            UINT64_C(0x67E67195D44D3CDF), UINT64_C(0x17820A0BC5134ED7) } },
        { { UINT64_C(0x019D6AC5D3021470), UINT64_C(0x25846B66780443D6),
            UINT64_C(0xCE3C15ED55C97647), UINT64_C(0x3DC22D490E3FEB0F),
            UINT64_C(0x2065B7CBA7DF26E4), UINT64_C(0xC8B00AE8187CEA1F) },
          { UINT64_C(0x1A5284A0865DDED3), UINT64_C(0x293C164920C83DE2),
            UINT64_C(0xAB178D26CCE851B3), UINT64_C(0x8E6DB10B404505FB),
            UINT64_C(0xF6F57E7190C82033), UINT64_C(0x1D2A1C015977F16C) } },
        { { UINT64_C(0xA39C89317C8906A4), UINT64_C(0xB6E7ECDD9E821EE6),
            UINT64_C(0x2ECF8340F0DF4FE6), UINT64_C(0xD42F7DC953C14965),
            UINT64_C(0x1AFB51A3E3BA8285), UINT64_C(0x6C07C4040A3305D1) },
          { UINT64_C(0xDAB83288127FC1DA), UINT64_C(0xBC0A699B374C4B08),
            UINT64_C(0x402A9BAB42EB20DD), UINT64_C(0xD7DD464F045A7A1C),
            UINT64_C(0x5B3D0D6D36BEECC4), UINT64_C(0x475A3E756398A19D) } },
    },
    {
        { { UINT64_C(0x31BDB48372876AE8), UINT64_C(0xE3325D98961ED1BF),
            UINT64_C(0x18C042469B6FC64D), UINT64_C(0x0DCC15FA15786B8C),
            UINT64_C(0x81ACDB068E63DA4A), UINT64_C(0xD3A4B643DADA70FB) },
          { UINT64_C(0x46361AFEDEA424EB), UINT64_C(0xDC2D2CAE89B92970),
            UINT64_C(0xF389B61B615694E6), UINT64_C(0x7036DEF1872951D2),
            UINT64_C(0x40FD3BDAD93BADC7), UINT64_C(0x45AB6321380A68D3) } },
        { { UINT64_C(0x23C1F74481A2703A), UINT64_C(0x1A5D075CB9859136),
            UINT64_C(0xA4F82C9D5AFD1BFD), UINT64_C(0xA3D1E9A4F89D76FE),
            UINT64_C(0x964F705075702F80), UINT64_C(0x182BF349F56C089D) },
          { UINT64_C(0xE205FA8FBE0DA6E1), UINT64_C(0x32905EB90A40F8F3),
            UINT64_C(0x331A1004356D4395), UINT64_C(0x58B78901FDBBDFDE),
            UINT64_C(0xA52A15979BA00E71), UINT64_C(0xE0092E1F55497A30) } },
        { { UINT64_C(0x5562A85670EE8F39), UINT64_C(0x86B0C11764E52A9C),
            UINT64_C(0xC19F317409C75B8C), UINT64_C(0x21C7CC3124923F80),
            UINT64_C(0xE63FE47F8F5B291E), UINT64_C(0x3D6D3C050DC08B05) },
          { UINT64_C(0x58AE455EEE0C39A1), UINT64_C(0x78BEA4310AD97942),
            UINT64_C(0x42C7C97F3EE3989C), UINT64_C(0xC1B03AF5F38759AE),
            UINT64_C(0x1A673C75BCF46899), UINT64_C(0x4831B7D38D508C7D) } },
        { { UINT64_C(0x76512D1BC552E354), UINT64_C(0x2B7EB6DF273020FD),
            UINT64_C(0xD1C73AA8025A5F25), UINT64_C(0x2ABA19295CBD2A40),
            UINT64_C(0xB53CADC3C88D61C6), UINT64_C(0x7E66A95E098290F3) },
          { UINT64_C(0x72800ECBAF4C5073), UINT64_C(0x81F2725E9DC63FAF),
            UINT64_C(0x14BF92A7282BA9D1), UINT64_C(0x90629672BD5F1BB2),
            UINT64_C(0x362F68EBA97C6C96), UINT64_C(0xB1D3BB8B7EA9D601) } },
        { { UINT64_C(0x73878F7FA9C94429), UINT64_C(0xB35C3BC8456CA6D8),
            UINT64_C(0xD96F0B3CF721923A), UINT64_C(0x28D8F06CE6D44FA1),
            UINT64_C(0x94EFDCDCD5CD671A), UINT64_C(0x0299AB933F97D481) },
          { UINT64_C(0xB7CED6EA2FD1D324), UINT64_C(0xBD6832087E932EC2),
            UINT64_C(0x24ED31FBCB755A6E), UINT64_C(0xA636098EE48781D2),
            UINT64_C(0x8687C63CF0A4F297), UINT64_C(0xBB52344007478526) } },
        { { UINT64_C(0x2E5F741934124B56), UINT64_C(0x1F223AE14B3F02CA),
            UINT64_C(0x6345B427E8336C7E), UINT64_C(0x92123E16F5D0E3D0),
            UINT64_C(0xDAF0D14D45E79F3A), UINT64_C(0x6ACA67656F3BD0C6) },
          { UINT64_C(0xF6169FAB403813F4), UINT64_C(0x31DC39C0334A4C59),
            UINT64_C(0x74C46753D589866D), UINT64_C(0x5741511D984C6A5D),
            UINT64_C(0xF263128797FED2D3), UINT64_C(0x5687CA1B11614886) } },
        { { UINT64_C(0x076D902A33836D4B), UINT64_C(0xEC6C5C4324AFB557),
            UINT64_C(0xA0FE2D1CA0516A0F), UINT64_C(0x6FB8D73700D22ECC),
            UINT64_C(0xF1DE9077DAF1D7B3), UINT64_C(0xE4695F77D4C0C1EB) },
          { UINT64_C(0x5F0FD8A8B4375573), UINT64_C(0x762383595E50944F),
            UINT64_C(0x65EA2F28635CD76F), UINT64_C(0x0854776925FDE7B0),
            UINT64_C(0xB2345A2E51944304), UINT64_C(0x86EFA2F7A16C980D) } },
        { { UINT64_C(0x4CCBE2D0BF4D1D63), UINT64_C(0x32E33401397366D5),
            UINT64_C(0xC83AFDDE71BDA2CE), UINT64_C(0x8DACE2AC478ED9E6),
            UINT64_C(0x3AC6A559763FDD9E), UINT64_C(0x0FFDB04CB398558F) },
          { UINT64_C(0x6C1B99B2AFB9D6B8), UINT64_C(0x572BA39C27F815DD),
            UINT64_C(0x9DE73EE70DBCF842), UINT64_C(0x2A3ED58929267B88),
            UINT64_C(0xD46A7FD315EBBBB3), UINT64_C(0xD1D01863E29400C7) } },
        { { UINT64_C(0x8FB101D1E1F89EC5), UINT64_C(0xB87A1F53F8508042),
            UINT64_C(0x28C8DB240ED7BEEF), UINT64_C(0x3940F845ACE8660A),
            UINT64_C(0x4EACB619C6D453FD), UINT64_C(0x2E044C982BAD6160) },
          { UINT64_C(0x8792854880B16C02), UINT64_C(0xF0D4BEB3C0A9EB64),
            UINT64_C(0xD785B4AFC183C195), UINT64_C(0x23AAB0E65E6C46EA),
            UINT64_C(0x30F7E104A930FECA), UINT64_C(0x6A1A7B8BD55C10FB) } },
        { { UINT64_C(0xDA74EAEBDBFED1AA), UINT64_C(0xC8A59223DF0B025C),
            UINT64_C(0x7EF7DC85D5B627F7), UINT64_C(0x02A13AE1197D7624),
            UINT64_C(0x119E9BE12F785A9B), UINT64_C(0xC0B7572F00D6B219) },
          { UINT64_C(0x9B1E51266D4CAF30), UINT64_C(0xA16A51170A840BD1),
            UINT64_C(0x5BE17B910E9CCF43), UINT64_C(0x5BDBEDDD69CF2C9C),
            UINT64_C(0x9FFBFBCF4CF4F289), UINT64_C(0xE1A621836C355CE9) } },
        { { UINT64_C(0x056199D9A7B2FCCF), UINT64_C(0x51F2E7B6CE1D784E),
            UINT64_C(0xA1D09C47339E2FF0), UINT64_C(0xC8E64890B836D0A9),
            UINT64_C(0x2F781DCBC0D07EBE), UINT64_C(0x5CF3C2AD3ACF934C) },
          { UINT64_C(0xE55DB190A17E26AE), UINT64_C(0xC9C61E1F91245513),
            UINT64_C(0x83D7E6CF61998C15), UINT64_C(0x4DB33C85E41D38E3),
            UINT64_C(0x74D5F91DC2FEE43D), UINT64_C(0x7EBBDB4536BBC826) } },
        { { UINT64_C(0xE20EC7E9CB655A9D), UINT64_C(0x4977EB925C47D421),
            UINT64_C(0xA237E12C3B9D72FA), UINT64_C(0xCAAEDBC1CBF7B145),
            UINT64_C(0x5200F5B23B77AAA3), UINT64_C(0x32EDED55BDBE5380) },
          { UINT64_C(0x74E38A40E7C9B80A), UINT64_C(0x3A3F0CF8AB6DE911),
            UINT64_C(0x56DCDD7AAD16AAF0), UINT64_C(0x3D2924498E861D5E),
            UINT64_C(0xD6C61878985733E2), UINT64_C(0x2401FE7D6AA6CD5B) } },
        { { UINT64_C(0xABB3DC75B42E3686), UINT64_C(0xAE712419B4C57E61),
            UINT64_C(0x2C565F72B21B009B), UINT64_C(0xA5F1DA2E710C3699),
            UINT64_C(0x771099A0A5EBA59A), UINT64_C(0x4DA88F4AC10017A0) },
          { UINT64_C(0x987FFFD31927B56D), UINT64_C(0xB98CB8ECC4E33478),
            UINT64_C(0xB224A971C2248166), UINT64_C(0x5470F554DE1DC794),
            UINT64_C(0xD747CC24E31FF983), UINT64_C(0xB91745E9B5B22DAE) } },
        { { UINT64_C(0x6CCBFED072F34420), UINT64_C(0x95045E4DA53039D2),
            UINT64_C(0x3B6C11545A793944), UINT64_C(0xAA114145DDB6B799),
            UINT64_C(0xABC15CA4252B7637), UINT64_C(0x5745A35BA5744634) },
          { UINT64_C(0x05DC6BDEDA596FC0), UINT64_C(0xCD52C18CA8020881),
            UINT64_C(0x03FA9F47D296BAD0), UINT64_C(0xD8E2C1297268E139),
            UINT64_C(0x58C1A98D9EC450B0), UINT64_C(0x909638DADE48B20D) } },
        { { UINT64_C(0x7AFC30D49B7F8311), UINT64_C(0x82A0042242368EA3),
            UINT64_C(0xBFF951986F5F9865), UINT64_C(0x9B24F612FC0A070F),
            UINT64_C(0x22C06CF2620F489D), UINT64_C(0x3C7ED052780F7DBB) },
          { UINT64_C(0xDB87AB1834DAFE9B), UINT64_C(0x20C03B409C4BBCA1),
            UINT64_C(0x5D718CF059A42341), UINT64_C(0x9863170669E84538),
            UINT64_C(0x5557192BD27D64E1), UINT64_C(0x08B4EC52DA822766) } },
        { { UINT64_C(0xB2D986F6D66C1A59), UINT64_C(0x927DEB1678E0E423),
            UINT64_C(0x9E673CDE49C3DEDC), UINT64_C(0xFA362D84F7ECB6CF),
            UINT64_C(0x078E5F401BA17340), UINT64_C(0x934CA5D11F4E489C) },
          { UINT64_C(0xC03C073164EEF493), UINT64_C(0x631A353BD7931A7E),
            UINT64_C(0x8E7CC3BB65DD74F1), UINT64_C(0xD55864C5702676A5),
            UINT64_C(0x6D306AC4439F04BD), UINT64_C(0x58544F672BAFED57) } },
    },
    {
        { { UINT64_C(0xB083BA6AEC074AEA), UINT64_C(0x46FAC5EF7F0B505B),
            UINT64_C(0x95367A21FC82DC03), UINT64_C(0x227BE26A9D3679D8),
            UINT64_C(0xC70F6D6C7E9724C0), UINT64_C(0xCD68C757F9EBEC0F) },
          { UINT64_C(0x29DDE03E8FF321B2), UINT64_C(0xF84AD7BB031939DC),
            UINT64_C(0xDAF590C90F602F4B), UINT64_C(0x17C5288849722BC4),
            UINT64_C(0xA8DF99F0089B22B6), UINT64_C(0xC21BC5D4E59B9B90) } },
        { { UINT64_C(0x4936C6A08A31973F), UINT64_C(0x54D442FA83B8C205),
            UINT64_C(0x03AEE8B45714F2C6), UINT64_C(0x139BD6923F5AC25A),
            UINT64_C(0x6A2E42BAB5B33794), UINT64_C(0x50FA11643FF7BBA9) },
          { UINT64_C(0xB61D8643F7E2C099), UINT64_C(0x2366C993BD5C6637),
            UINT64_C(0x62110E1472EB77FA), UINT64_C(0x3D5B96F13B99C635),
            UINT64_C(0x956ECF64F674C9F2), UINT64_C(0xC56F7E51EF2BA250) } },
        { { UINT64_C(0x246FFCB6FF602C1B), UINT64_C(0x1E1A1D746E1258E0),
            UINT64_C(0xB4B43AE2250E6676), UINT64_C(0x95C1B5F0924CE5FA),
            UINT64_C(0x2555795BEBD8C776), UINT64_C(0x4C1E03DCACD9D9D0) },
          { UINT64_C(0xE1D74AA69CE90C61), UINT64_C(0xA88C0769A9C4B9F9),
            UINT64_C(0xDF74DF2795AF56DE), UINT64_C(0x24B10C5FB331B6F4),
            UINT64_C(0xB0A6DF9A6559E137), UINT64_C(0x6ACC1B8FC06637F2) } },
        { { UINT64_C(0xBD8C086834B4E381), UINT64_C(0x278CACC730DFF271),
            UINT64_C(0x87ED12DE02459389), UINT64_C(0x3F7D98FFDEF840B6),
            UINT64_C(0x71EEE0CB5F0B56E1), UINT64_C(0x462B5C9BD8D9BE87) },
          { UINT64_C(0xE6B50B5A98094C0F), UINT64_C(0x26F3B274508C67CE),
            UINT64_C(0x418B1BD17CB1F992), UINT64_C(0x607818ED4FF11827),
            UINT64_C(0xE630D93A9B042C63), UINT64_C(0x38B9EFF38C779AE3) } },
        { { UINT64_C(0xE8767D36729C5431), UINT64_C(0xA8BD07C0BB94642C),
            UINT64_C(0x0C11FC8E58F2E5B2), UINT64_C(0xD8912D48547533FE),
            UINT64_C(0xAAE14F5E230D91FB), UINT64_C(0xC122051A676DFBA0) },
          { UINT64_C(0x9ED4501F5EA93078), UINT64_C(0x2758515CBD4BEE0A),
            UINT64_C(0x97733C6C94D21F52), UINT64_C(0x139BCD6D4AD306A2),
            UINT64_C(0x0AAECBDC298123CC), UINT64_C(0x102B8A311CB7C7C9) } },
        { { UINT64_C(0x22A28E59FAF46675), UINT64_C(0x1075730810A31E7D),
            UINT64_C(0xC7EEAC842B4C2F4F), UINT64_C(0xBA370148B5EF5184),
            UINT64_C(0x4A5A28668732E055), UINT64_C(0x14B8DCDCB887C36F) },
          { UINT64_C(0xDBA8C85C433F093D), UINT64_C(0x73DF549D1C9A201C),
            UINT64_C(0x69AA0D7B70F927D8), UINT64_C(0xFA3A8685D7D2493A),
            UINT64_C(0x6F48A2550A7F4013), UINT64_C(0xD20C8BF9DD393067) } },
        { { UINT64_C(0x4EC874EA81625E78), UINT64_C(0x8B8D8B5A3FBE9267),
            UINT64_C(0xA3D9D1649421EC2F), UINT64_C(0x490E92D9880EA295),
            UINT64_C(0x745D1EDCD8F3B6DA), UINT64_C(0x0116628B8F18BA03) },
          { UINT64_C(0x0FF6BCE0834EADCE), UINT64_C(0x464697F2000827F7),
            UINT64_C(0x08DCCF84498D724E), UINT64_C(0x7896D3651E88304C),
            UINT64_C(0xE63EBCCE135E3622), UINT64_C(0xFB942E8EDC007521) } },
        { { UINT64_C(0xBB155A66A3688621), UINT64_C(0xED2FD7CDF91B52A3),
            UINT64_C(0x52798F5DEA20CB88), UINT64_C(0x069CE105373F7DD8),
            UINT64_C(0xF9392EC78CA78F6B), UINT64_C(0xB3013E256B335169) },
          { UINT64_C(0x1D92F8006B11715C), UINT64_C(0xADD4050EFF9DC464),
            UINT64_C(0x2AC226598465B84A), UINT64_C(0x2729D646465B2BD6),
            UINT64_C(0x6202344AE4EFF9DD), UINT64_C(0x51F3198FCD9B90B9) } },
        { { UINT64_C(0x17CE54EFE5F0AE1D), UINT64_C(0x984E8204B09852AF),
            UINT64_C(0x3365B37AC4B27A71), UINT64_C(0x720E3152A00E0A9C),
            UINT64_C(0x3692F70D925BD606), UINT64_C(0xBE6E699D7BC7E9AB) },
          { UINT64_C(0xD75C041F4C89A3C0), UINT64_C(0x8B9F592D8DC100C0),
            UINT64_C(0x30750F3AAD228F71), UINT64_C(0x1B9ECF84E8B17A11),
            UINT64_C(0xDF2025620FBFA8A2), UINT64_C(0x45C811FCAA1B6D67) } },
        { { UINT64_C(0xEC5B84B71A5151F8), UINT64_C(0x118E59E8550AB2D2),
            UINT64_C(0x2CCDEDA4049BD735), UINT64_C(0xC99CBA719CD62F0F),
            UINT64_C(0x69B8040A62C9E4F8), UINT64_C(0x16F1A31A110B8283) },
          { UINT64_C(0x53F6380298E908A3), UINT64_C(0x308CB6EFD862F9DE),
            UINT64_C(0xE185DAD8A521A95A), UINT64_C(0x4D8FE9A4097F75CA),
            UINT64_C(0xD1ECCEC71CA07D53), UINT64_C(0x13DFA1DC0DB07E83) } },
        { { UINT64_C(0xDDAF9DC60F591A76), UINT64_C(0xE1A6D7CC1685F412),
            UINT64_C(0x153DE557002B6E8D), UINT64_C(0x730C38BCC6DA37D9),
            UINT64_C(0xAE1806220914B597), UINT64_C(0x84F98103DD8C3A0A) },
          { UINT64_C(0x369C53988DA205B0), UINT64_C(0xA3D95B813888A720),
            UINT64_C(0x1F3F8BBFE10E2806), UINT64_C(0x48663DF54530D1F3),
            UINT64_C(0x320523B43E377713), UINT64_C(0xE8B1A575C7894814) } },
        { { UINT64_C(0x330668712EE8EA07), UINT64_C(0xC6FB4EC560DA199D),
            UINT64_C(0x33231860F4370A05), UINT64_C(0x7ABECE72C6DE4E26),
            UINT64_C(0xDE8D4BD8EBDECE7A), UINT64_C(0xC90EE6571CBE93C7) },
          { UINT64_C(0x0246751B85AC2509), UINT64_C(0xD0EF142C30380245),
            UINT64_C(0x086DF9C47C76E39C), UINT64_C(0x68F1304FB789FB56),
            UINT64_C(0x23E4CB98A5E4BD56), UINT64_C(0x69A4C63C64663DCA) } },
        { { UINT64_C(0x6C72B6AF7CB34E63), UINT64_C(0x073C40CD6DFC23FE),
            UINT64_C(0xBDEEE7A1C936693A), UINT64_C(0xBC858E806EFAD378),
            UINT64_C(0xEAD719FFF5BE55D4), UINT64_C(0xC8C3238F04552F5F) },
          { UINT64_C(0x0952C068928D5784), UINT64_C(0x89DFDF2294C58F2B),
            UINT64_C(0x332DEDF367502C50), UINT64_C(0x3ED2FA3AAC0BE258),
            UINT64_C(0xAEDC9B8A7C5C8244), UINT64_C(0x43A761B9DC0EA34F) } },
        { { UINT64_C(0x8FD683A2CC5E21A5), UINT64_C(0x5F444C6EFBA2BB68),
            UINT64_C(0x709ACD0EAF05586D), UINT64_C(0x8EFA54D2DE8FB348),
            UINT64_C(0x35276B7134CFE29E), UINT64_C(0x77A06FCD941EAC8C) },
          { UINT64_C(0x5815792D928322DD), UINT64_C(0x82FF356B67F7CB59),
            UINT64_C(0x71E40A78304980F4), UINT64_C(0xC8645C273667D021),
            UINT64_C(0xE785741CAEBAE28F), UINT64_C(0xB2C1BC7553ECAC37) } },
        { { UINT64_C(0x633EB24F1D0A74DB), UINT64_C(0xF1F55E56FA752512),
            UINT64_C(0x75FECA688EFE11DE), UINT64_C(0xC80FD91CE6BF19EC),
            UINT64_C(0xAD0BAFEC2A14C908), UINT64_C(0x4E1C4ACAADE4031F) },
          { UINT64_C(0x463A815B1EB1549A), UINT64_C(0x5AD4253C668F1298),
            UINT64_C(0x5CB3866238A37151), UINT64_C(0x34BB1CCFAFF16B96),
            UINT64_C(0xDCA93B13EE731AB0), UINT64_C(0x9F3CE5CC9BE01A0B) } },
        { { UINT64_C(0x75DB5723A110D331), UINT64_C(0x67C66F6A7123D89F),
            UINT64_C(0x27ABBD4B4009D570), UINT64_C(0xACDA6F84C73451BC),
            UINT64_C(0xE4B9A23905575ACF), UINT64_C(0x3C2DB7EFAB2D3D6C) },
          { UINT64_C(0x01CCDD0829115145), UINT64_C(0x9E0602FE57B5814A),
            UINT64_C(0x679B35C287862838), UINT64_C(0x0277DC4C38AD598D),
            UINT64_C(0xEF80A2136D896DD4), UINT64_C(0xC8812213E7B9047B) } },
    },
    {
        { { UINT64_C(0xAC6DBDF6EDC9CE62), UINT64_C(0xA58F5B440F9C006E),
            UINT64_C(0x16694DE3DC28E1B0), UINT64_C(0x2D039CF2A6647711),
            UINT64_C(0xA13BBE6FC5B08B4B), UINT64_C(0xE44DA93010EBD8CE) },
          { UINT64_C(0xCD47208719649A16), UINT64_C(0xE18F4E44683E5DF1),
            UINT64_C(0xB3F66303929BFA28), UINT64_C(0x7C378E43818249BF),
            UINT64_C(0x76068C80847F7CD9), UINT64_C(0xEE3DB6D1987EBA16) } },
        { { UINT64_C(0xCBBD8576C42A2F52), UINT64_C(0x9ACC6F709D2B06BB),
            UINT64_C(0xE5CB56202E6B72A4), UINT64_C(0x5738EA0E7C024443),
            UINT64_C(0x8ED06170B55368F3), UINT64_C(0xE54C99BB1AEED44F) },
          { UINT64_C(0x3D90A6B2E2E0D8B2), UINT64_C(0x21718977CF7B2856),
            UINT64_C(0x089093DCC5612AEC), UINT64_C(0xC272EF6F99C1BACC),
            UINT64_C(0x47DB3B43DC43EAAD), UINT64_C(0x730F30E40832D891) } },
        { { UINT64_C(0x9FFE55630C7FECDB), UINT64_C(0x55CC67B6F88101E5),
            UINT64_C(0x3039F981CBEFA3C7), UINT64_C(0x2AB06883667BFD64),
            UINT64_C(0x9007A2574340E3DF), UINT64_C(0x1AC3F3FA5A3A49CA) },
          { UINT64_C(0x9C7BE629C97E20FD), UINT64_C(0xF61823D3A3DAE003),
            UINT64_C(0xFFE7FF39E7380DBA), UINT64_C(0x620BB9B59FACC3B8),
            UINT64_C(0x2DDCB8CD31AE422C), UINT64_C(0x1DE3BCFAD12C3C43) } },
        { { UINT64_C(0x8C074946D6E0F9A9), UINT64_C(0x662FA99551C3B05B),
            UINT64_C(0x6CDAE96904BB2048), UINT64_C(0x6DEC9594D6DC8B60),
            UINT64_C(0x8D26586954438BBC), UINT64_C(0x88E983E31B0E95A5) },
          { UINT64_C(0x8189F11460CBF838), UINT64_C(0x77190697771DC46B),
            UINT64_C(0x775775A227F8EC1A), UINT64_C(0x7A125240607E3739),
            UINT64_C(0xAFAE84E74F793E4E), UINT64_C(0x44FA17F35BF5BAF4) } },
        { { UINT64_C(0xA21E69A5D03AC439), UINT64_C(0x2069C5FC88AA8094),
            UINT64_C(0xB041EEA78C08F206), UINT64_C(0x55B9D4613D65B8ED),
            UINT64_C(0x951EA25CD392C7C4), UINT64_C(0x4B9A1CEC9D166232) },
          { UINT64_C(0xC184FCD8FCF931A4), UINT64_C(0xBA59AD44063AD374),
            UINT64_C(0x1868AD2A1AA9796F), UINT64_C(0x38A34018DFF29832),
            UINT64_C(0x01FC880103DF8070), UINT64_C(0x1282CCE048DD334A) } },
        { { UINT64_C(0x76AA955726D8503C), UINT64_C(0xBE962B636BC3E3D0),
            UINT64_C(0xF5CA93E597DE8841), UINT64_C(0x1561B05EAF3F2C16),
            UINT64_C(0x34BE00AAD34BFF98), UINT64_C(0xEA21E6E9D23D2925) },
          { UINT64_C(0x55713230394C3AFB), UINT64_C(0xEAF0529BD6C8BECA),
            UINT64_C(0xFF38A743202B9A11), UINT64_C(0xA13E39FC6D3A398B),
            UINT64_C(0x8CBD644B86E2615A), UINT64_C(0x92063988191057EC) } },
        { { UINT64_C(0x787835CE13F89146), UINT64_C(0x7FCD42CC69446C3F),
            UINT64_C(0x0DA2AA98840E679D), UINT64_C(0x44F2052318779A1B),
            UINT64_C(0xE3A3B34FEFBF5935), UINT64_C(0xA5D2CFD0B9947B70) },
          { UINT64_C(0xAE2AF4EF27F4E16F), UINT64_C(0xA7FA70D2B9D21322),
            UINT64_C(0x68084919B3FD566B), UINT64_C(0xF04D71C8D7AAD6AB),
            UINT64_C(0xDBEA21E410BC4260), UINT64_C(0xAA7DC6658D949B42) } },
        { { UINT64_C(0xD8E958A06CCB8213), UINT64_C(0x118D9DB991900B54),
            UINT64_C(0x09BB9D4985E8CED6), UINT64_C(0x410E9FB524019281),
            UINT64_C(0x3B31B4E16D74C86E), UINT64_C(0x52BC0252020BB77D) },
          { UINT64_C(0x5616A26F27092CE4), UINT64_C(0x67774DBCA08F65CD),
            UINT64_C(0x560AD494C08BD569), UINT64_C(0xBE26DA36AD498783),
            UINT64_C(0x0276C8AB7F019C91), UINT64_C(0x09843ADA5248266E) } },
        { { UINT64_C(0xA0AE88A77D963CF2), UINT64_C(0x91EF8986D0E84920),
            UINT64_C(0xC7EFE344F8C58104), UINT64_C(0x0A25D9FDECA20773),
            UINT64_C(0x9D989FAA00D8F1D5), UINT64_C(0x4204C8CEC8B06264) },
          { UINT64_C(0x717C12E0BE1A2796), UINT64_C(0x1FA4BA8CC190C728),
            UINT64_C(0xA245CA8D8C8A59BA), UINT64_C(0xE3C374757672B935),
            UINT64_C(0x083D5E402E4D6375), UINT64_C(0x0B8D5AB35455E16E) } },
        { { UINT64_C(0x1DB17DBFEED765D4), UINT64_C(0xBBC9B1BEA5DDB965),
            UINT64_C(0x1948F76DDFC12ABC), UINT64_C(0x2C2714E5134EF489),
            UINT64_C(0x60CE2EE8741C600F), UINT64_C(0x32396F22F80E6E63) },
          { UINT64_C(0x421DAC7522537F59), UINT64_C(0x58FB73C649475DF5),
            UINT64_C(0x0ABF28856F18F1C7), UINT64_C(0x364744689A398D16),
            UINT64_C(0x87A661A7BF673B87), UINT64_C(0x3E80698F73819E17) } },
        { { UINT64_C(0xDFE4979353784CC4), UINT64_C(0x4280EAB0486D508F),
            UINT64_C(0x119593FFE534F5A4), UINT64_C(0x98AEFADD9F63242F),
            UINT64_C(0x9AE6A24AC4829CAE), UINT64_C(0xF2373CA558E8BA80) },
          { UINT64_C(0x4017AF7E51765FB3), UINT64_C(0xD1E40F7CAF4AEC4B),
            UINT64_C(0x87372C7A0898E3BC), UINT64_C(0x688982B285452CA9),
            UINT64_C(0x71E0B4BFB1E50BCA), UINT64_C(0x21FD2DBFF70E714A) } },
        { { UINT64_C(0xEE6E8820FB78DDAC), UINT64_C(0x0BAED29C063892CD),
            UINT64_C(0x5F33049C28C0588D), UINT64_C(0x90C2515E18DBC432),
            UINT64_C(0xB8A1B1433B4CB0BD), UINT64_C(0x0AB5C0C968103043) },
          { UINT64_C(0xF3788FA04005EC40), UINT64_C(0x82571C99039EE115),
            UINT64_C(0xEE8FCED593260BED), UINT64_C(0x5A9BAF7910836D18),
            UINT64_C(0x7C258B09C46AA4F6), UINT64_C(0x46ECC5E837F53D31) } },
        { { UINT64_C(0xFA32C0DCBFE0DD98), UINT64_C(0x66EFAFC4962B1066),
            UINT64_C(0xBA81D33E64BDF5EB), UINT64_C(0x36C28536FC7FC512),
            UINT64_C(0x0C95176BE0B4FA97), UINT64_C(0x47DDE29B3B9BC64A) },
          { UINT64_C(0x08D986FD5C173B36), UINT64_C(0x46D84B526CF3F28C),
            UINT64_C(0x6F6ED6C3F026BDB9), UINT64_C(0xAC90668B68206DC5),
            UINT64_C(0xE8ED5D98ECBE4E70), UINT64_C(0xCFFF61DDDC1A6974) } },
        { { UINT64_C(0xFF5C3A2977B1A5C1), UINT64_C(0x10C27E4A0DDF995D),
            UINT64_C(0xCB745F77E23363E3), UINT64_C(0xD765DF6F32F399A3),
            UINT64_C(0xF0CA0C2F8A99E109), UINT64_C(0xC3A6BFB71E025CA0) },
          { UINT64_C(0x830B2C0A4F9D9FA5), UINT64_C(0xAE914CACBD1A84E5),
            UINT64_C(0x30B35ED8A4FEBCC1), UINT64_C(0xCB902B4684CFBF2E),
            UINT64_C(0x0BD4762825FC6375), UINT64_C(0xA858A53C85509D04) } },
        { { UINT64_C(0x8B995D0C552E0A3F), UINT64_C(0xEDBD4E9417BE9FF7),
            UINT64_C(0x3432E83995085178), UINT64_C(0x0FE5C18180C256F5),
            UINT64_C(0x05A64EA8EBF9597C), UINT64_C(0x6ED44BB13F80371F) },
          { UINT64_C(0x6A29A05EFE4C12EE), UINT64_C(0x3E436A43E0BB83B3),
            UINT64_C(0x38365D9A74D72921), UINT64_C(0x3F5EE823C38E1ED7),
            UINT64_C(0x09A53213E8FA063F), UINT64_C(0x1E7FE47AB435E713) } },
        { { UINT64_C(0xE4D9BC94FDDD17F3), UINT64_C(0xC74B8FEDC1016C20),
            UINT64_C(0x095DE39BB49C060E), UINT64_C(0xDBCC67958AC0DF00),
            UINT64_C(0x4CF6BAEB1C34F4DF), UINT64_C(0x72C55C21E8390170) },
          { UINT64_C(0x4F17BFD2F6C48E79), UINT64_C(0x18BF4DA0017A80BA),
            UINT64_C(0xCF51D829BCF4B138), UINT64_C(0x598AEE5FF48F8B0D),
            UINT64_C(0x83FAEE5620F10809), UINT64_C(0x4615D4DC779F0850) } },
    },
    {
        { { UINT64_C(0x22313DEE5852B59B), UINT64_C(0x6F56C8E8B6A0B37F),
            UINT64_C(0x43D6EEAEA76EC380), UINT64_C(0xA16551360275AD36),
            UINT64_C(0xE5C1B65ADF095BDA), UINT64_C(0xBD1FFA8D367C44B0) },
          { UINT64_C(0xE2B419C26B48AF2B), UINT64_C(0x57BBBD973DA194C8),
            UINT64_C(0xB5FBE51FA2BAFF05), UINT64_C(0xA0594D706269B5D0),
            UINT64_C(0x0B07B70523E8D667), UINT64_C(0xAE1976B563E016E7) } },
        { { UINT64_C(0x2FDE4893FBECAAAE), UINT64_C(0x444346DE30332229),
            UINT64_C(0x157B8A5B09456ED5), UINT64_C(0x73606A7925797C6C),
            UINT64_C(0xA9D0F47C33C14C06), UINT64_C(0x7BC8962CFAF971CA) },
          { UINT64_C(0x6E763C5165909DFD), UINT64_C(0x1BBBE41B14A9BF42),
            UINT64_C(0xD95B7ECBC49E9EFC), UINT64_C(0x0C317927B38F2B59),
            UINT64_C(0x97912B53B3C397DB), UINT64_C(0xCB3879AA45C7ABC7) } },
        { { UINT64_C(0xCD81BDCF24359B81), UINT64_C(0x6FD326E2DB4C321C),
            UINT64_C(0x4CB0228BF8EBE39C), UINT64_C(0x496A9DCEB2CDD852),
            UINT64_C(0x0F115A1AD0E9B3AF), UINT64_C(0xAA08BF36D8EEEF8A) },
          { UINT64_C(0x5232A51506E5E739), UINT64_C(0x21FAE9D58407A551),
            UINT64_C(0x289D18B08994B4E8), UINT64_C(0xB4E346A809097A52),
            UINT64_C(0xC641510F324621D0), UINT64_C(0xC567FD4A95A41AB8) } },
        { { UINT64_C(0x261578C7D57C8DE9), UINT64_C(0xB9BC491F3836C5C8),
            UINT64_C(0x993266B414C8038F), UINT64_C(0xBACAD755FAA7CC39),
            UINT64_C(0x418C4DEFD69B7E27), UINT64_C(0x53FDC5CDAE751533) },
          { UINT64_C(0x6F3BD329C3EEA63A), UINT64_C(0xA7A22091E53DD29E),
            UINT64_C(0xB7164F73DC4C54EC), UINT64_C(0xCA66290D44D3D74E),
            UINT64_C(0xF77C62424C9EA511), UINT64_C(0x34337F551F714C49) } },
        { { UINT64_C(0x5ED2B216A64B6C4B), UINT64_C(0x1C38794F3AAE640D),
            UINT64_C(0x30BBAEE08905794F), UINT64_C(0x0D9EE41EC8699CFB),
            UINT64_C(0xAF38DAF2CF7B7C29), UINT64_C(0x0D6A05CA43E53513) },
          { UINT64_C(0xBE96C6442606AB56), UINT64_C(0x13E7A072E9EB9734),
            UINT64_C(0xF96694455FF50CD7), UINT64_C(0x68EF26B547DA6F1D),
            UINT64_C(0xF002873823687CB7), UINT64_C(0x5ED9C8766217C1CE) } },
        { { UINT64_C(0x423BA5130A3A9691), UINT64_C(0xF421B1E7B3179296),
            UINT64_C(0x6B51BCDB1A871E1B), UINT64_C(0x6E3BB5B5464E4300),
            UINT64_C(0x24171E2EFC6C54CC), UINT64_C(0xA9DFA947D3E58DC2) },
          { UINT64_C(0x175B33099DE9CFA7), UINT64_C(0x707B25292D1015DA),
            UINT64_C(0xCBB95F17993EA65A), UINT64_C(0x935150630447450D),
            UINT64_C(0x0F47B2051B2753C9), UINT64_C(0x4A0BAB14E7D427CF) } },
        { { UINT64_C(0xA39DEF39B5AA7CA1), UINT64_C(0x591CB173C47C33DF),
            UINT64_C(0xA09DAC796BBAB872), UINT64_C(0x3EF9D7CF7208BA2F),
            UINT64_C(0x3CC189317A0A34FC), UINT64_C(0xAE31C62BBCC3380F) },
          { UINT64_C(0xD72A67940287C0B4), UINT64_C(0x3373382C68E334F1),
            UINT64_C(0xD0310CA8BD20C6A6), UINT64_C(0xA2734B8742C033FD),
            UINT64_C(0xA5D390F18DCE4509), UINT64_C(0xFC84E74B3E1AFCB5) } },
        { { UINT64_C(0xB028334DF2CD8A9C), UINT64_C(0xB8719291570F76F6),
            UINT64_C(0x662A386E01065A2D), UINT64_C(0xDF1634CB53D940AE),
            UINT64_C(0x625A7B838F5B41F9), UINT64_C(0xA033E4FEEE6AA1B4) },
          { UINT64_C(0x51E9D4631E42BABB), UINT64_C(0x660BC2E40D388468),
            UINT64_C(0x3F702189FCBB114A), UINT64_C(0x6B46FE35B414CA78),
            UINT64_C(0x328F6CF24A57316B), UINT64_C(0x917423B5381AD156) } },
        { { UINT64_C(0xAC19306E5373A607), UINT64_C(0x471DF8E3191D0969),
            UINT64_C(0x380ADE35B9720D83), UINT64_C(0x7423FDF548F1FD5C),
            UINT64_C(0x8B090C9F49CABC95), UINT64_C(0xB768E8CDC9842F2F) },
          { UINT64_C(0x399F456DE56162D6), UINT64_C(0xBB6BA2404F326791),
            UINT64_C(0x8F4FBA3B342590BE), UINT64_C(0x053986B93DFB6B3E),
            UINT64_C(0xBB6739F1190C7425), UINT64_C(0x32D4A55332F7E95F) } },
        { { UINT64_C(0x0205A0EC0DDBFB21), UINT64_C(0x3010327D33AC3407),
            UINT64_C(0xCF2F4DB33348999B), UINT64_C(0x660DB9F41551604A),
            UINT64_C(0xC346C69A5D38D335), UINT64_C(0x64AAB3D338882479) },
          { UINT64_C(0xA096B5E76AE44403), UINT64_C(0x6B4C9571645F76CD),
            UINT64_C(0x72E1CD5F4711120F), UINT64_C(0x93EC42ACF27CC3E1),
            UINT64_C(0x2D18D004A72ABB12), UINT64_C(0x232E9568C9841A04) } },
        { { UINT64_C(0xFF01DB223CC7F908), UINT64_C(0x9F214F8FD13CDD3B),
            UINT64_C(0x38DADBB7E0B014B5), UINT64_C(0x2C548CCC94245C95),
            UINT64_C(0x714BE331809AFCE3), UINT64_C(0xBCC644109BFE957E) },
          { UINT64_C(0xC21C2D215B957F80), UINT64_C(0xBA2D4FDCBB8A4C42),
            UINT64_C(0xFA6CD4AF74817CEC), UINT64_C(0x9E7FB523C528EAD6),
            UINT64_C(0xAED781FF7714B10E), UINT64_C(0xB52BB59294F04455) } },
        { { UINT64_C(0xA578BD69868CC68B), UINT64_C(0xA40FDC8D603F2C08),
            UINT64_C(0x53D79BD12D81B042), UINT64_C(0x1B136AF3A7587EAB),
            UINT64_C(0x1ED4F939868A16DB), UINT64_C(0x775A61FBD0B98273) },
          { UINT64_C(0xBA5C12A6E56BEF8C), UINT64_C(0xF926CE52DDDC8595),
            UINT64_C(0xA13F5C8F586FE1F8), UINT64_C(0xEAC9F7F2060DBB54),
            UINT64_C(0x70C0AC3A51AF4342), UINT64_C(0xC16E303C79CDA450) } },
        { { UINT64_C(0xD0DADD6C8113F4EA), UINT64_C(0xF14E392207BDF09F),
            UINT64_C(0x3FE5E9C2AA7D877C), UINT64_C(0x9EA95C1948779264),
            UINT64_C(0xE93F65A74FCB8344), UINT64_C(0x9F40837E76D925A4) },
          { UINT64_C(0x0EA6DA3F8271FFC7), UINT64_C(0x557FA529CC8F9B19),
            UINT64_C(0x2613DBF178E6DDFD), UINT64_C(0x7A7523B836B1E954),
            UINT64_C(0x20EB3168406A87FB), UINT64_C(0x64C21C1403ABA56A) } },
        { { UINT64_C(0xE86C9C2DC032DD5F), UINT64_C(0x158CEB8E86F16A21),
            UINT64_C(0x0279FF5368326AF1), UINT64_C(0x1FFE2E2B59F12BA5),
            UINT64_C(0xD75A46DB86826D45), UINT64_C(0xE19B48411E33E6AC) },
          { UINT64_C(0x5F0CC5240E52991C), UINT64_C(0x645871F98B116286),
            UINT64_C(0xAB3B4B1EFCAEC5D3), UINT64_C(0x994C8DF051D0F698),
            UINT64_C(0x06F890AFE5D13040), UINT64_C(0x72D9DC235F96C7C2) } },
        { { UINT64_C(0x7C018DEEE7886A80), UINT64_C(0xFA2093308786E4A3),
            UINT64_C(0xCEC8E2A3A4415CA1), UINT64_C(0x5C736FC1CC83CC60),
            UINT64_C(0xFEF9788CF00C259F), UINT64_C(0xED5C01CBDD29A6AD) },
          { UINT64_C(0x87834A033E20825B), UINT64_C(0x13B1239D123F9358),
            UINT64_C(0x7E8869D0FBC286C1), UINT64_C(0xC4AB5AA324CE8609),
            UINT64_C(0x38716BEEB6349208), UINT64_C(0x0BDF4F99B322AE21) } },
        { { UINT64_C(0x6B97A2BF53E3494B), UINT64_C(0xA8AA05C570F7A13E),
            UINT64_C(0x209709C2F1305B51), UINT64_C(0x57B31888DAB76F2C),
            UINT64_C(0x75B2ECD7AA2A406A), UINT64_C(0x88801A00A35374A4) },
          { UINT64_C(0xE1458D1C45C0471B), UINT64_C(0x5760E306322C1AB0),
            UINT64_C(0x789A0AF1AD6AB0A6), UINT64_C(0x74398DE1F458B9CE),
            UINT64_C(0x1652FF9F32E0C65F), UINT64_C(0xFAF1F9D5FFFB3A52) } },
    },
    {
        { { UINT64_C(0xA05C751CD1D1B007), UINT64_C(0x016C213B0213E478),
            UINT64_C(0x9C56E26CF4C98FEE), UINT64_C(0x6084F8B9E7B3A7C7),
            UINT64_C(0xA0B042F6DECC1646), UINT64_C(0x4A6F3C1AFBF3A0BC) },
          { UINT64_C(0x94524C2C51C9F909), UINT64_C(0xF3B3AD403A6D3748),
            UINT64_C(0x18792D6E7CE1F9F5), UINT64_C(0x8EBC2FD7FC0C34FA),
            UINT64_C(0x032A9F41780A1693), UINT64_C(0x34F9801E56A60019) } },
        { { UINT64_C(0xB398290CF0DB3751), UINT64_C(0x01170580BA42C976),
            UINT64_C(0x3E71AA2956560B89), UINT64_C(0x80817AAC50E6647B),
            UINT64_C(0x35C833ADA0BE42DA), UINT64_C(0xFA3C6148F1BABA4E) },
          { UINT64_C(0xC57BE645CD8F6253), UINT64_C(0x77CEE46BC657AD0D),
            UINT64_C(0x830077310DEFD908), UINT64_C(0x92FE9BCE899CBA56),
            UINT64_C(0x48450EC4BCEFFB5A), UINT64_C(0xE615148DF2F5F4BF) } },
        { { UINT64_C(0xF55EDABB90B86166), UINT64_C(0x27F7D784075430A2),
            UINT64_C(0xF53E822B9BF17161), UINT64_C(0x4A5B3B93AFE808DC),
            UINT64_C(0x590BBBDED7272F55), UINT64_C(0x233D63FAEAEA79A1) },
          { UINT64_C(0xD7042BEAFE1EBA07), UINT64_C(0xD2B9AEA010750D7E),
            UINT64_C(0xD8D1E69031078AA5), UINT64_C(0x9E837F187E37BC8B),
            UINT64_C(0x9558FF4F85008975), UINT64_C(0x93EDB837421FE867) } },
        { { UINT64_C(0xAA6489DF83D55B5A), UINT64_C(0xEA092E4986BF27F7),
            UINT64_C(0x4D8943A95FA2EFEC), UINT64_C(0xC9BAAE53720E1A8C),
            UINT64_C(0xC055444B95A4F8A3), UINT64_C(0x93BD01E8A7C1206B) },
          { UINT64_C(0xD97765B6714A27DF), UINT64_C(0xD622D954193F1B16),
            UINT64_C(0x115CC35AF1503B15), UINT64_C(0x1DD5359FA9FA21F8),
            UINT64_C(0x197C32996DFED1F1), UINT64_C(0xDEE8B7C9F77F2679) } },
        { { UINT64_C(0x5405179F394FD855), UINT64_C(0xC9D6E24449FDFB33),
            UINT64_C(0x70EBCAB4BD903393), UINT64_C(0x0D3A3899A2C56780),
            UINT64_C(0x012C7256683D1A0A), UINT64_C(0xC688FC8880A48F3B) },
          { UINT64_C(0x180957546F7DF527), UINT64_C(0x9E339B4B71315D16),
            UINT64_C(0x90560C28A956BB12), UINT64_C(0x2BECEA60D42EEE8D),
            UINT64_C(0x82AEB9A750632653), UINT64_C(0xED34353EDFA5CD6A) } },
        { { UINT64_C(0x82154D2C91AECCE4), UINT64_C(0x312C60705041887F),
            UINT64_C(0xECF589F3FB9FBD71), UINT64_C(0x67660A7DB524BDE4),
            UINT64_C(0xE99B029D724ACF23), UINT64_C(0xDF06E4AF6D1CD891) },
          { UINT64_C(0x07806CB580EE304D), UINT64_C(0x0C70BB9F7443A8F8),
            UINT64_C(0x01EC341408B0830A), UINT64_C(0xFD7B63C35A81510B),
            UINT64_C(0xE90A0A39453B5F93), UINT64_C(0xAB700F8F9BC71725) } },
        { { UINT64_C(0x9401AEC2B9F00793), UINT64_C(0x064EC4F4B997F0BF),
            UINT64_C(0xDC0CC1FD849240C8), UINT64_C(0x39A75F37B6E92D72),
            UINT64_C(0xAA43CA5D0224A4AB), UINT64_C(0x9C4D632554614C47) },
          { UINT64_C(0x1767366FC6709DA3), UINT64_C(0xA6B482D123479232),
            UINT64_C(0x54DC6DDC84D63E85), UINT64_C(0x0ACCB5ADC99D3B9E),
            UINT64_C(0x211716BBE8AA3ABF), UINT64_C(0xD0FE25AD69EC6406) } },
        { { UINT64_C(0x0D5C1769DF85C705), UINT64_C(0x7086C93DA409DCD1),
            UINT64_C(0x9710839D0E8D75D8), UINT64_C(0x17B7DB75EBDD4177),
            UINT64_C(0xAF69EB58F649A809), UINT64_C(0x6EF19EA28A84E220) },
          { UINT64_C(0x36EB5C6665C278B2), UINT64_C(0xD2A1512881EA9D65),
            UINT64_C(0x4FCBA840769300AD), UINT64_C(0xC2052CCDC8E536E5),
            UINT64_C(0x9CAEE014AC263B8F), UINT64_C(0x56F7ED7AF9239663) } },
        { { UINT64_C(0xF6FA251FAC9E09E1), UINT64_C(0xA3775605955A2853),
            UINT64_C(0x977B8D21F2A4BD78), UINT64_C(0xF68AA7FF3E096410),
            UINT64_C(0x01AB055265F88419), UINT64_C(0xC4C8D77EBB93F64E) },
          { UINT64_C(0x718251113451FE64), UINT64_C(0xFA0F905B46F9BAF0),
            UINT64_C(0x79BE3BF3CA49EF1A), UINT64_C(0x831109B26CB02071),
            UINT64_C(0x765F935FC4DDBFE5), UINT64_C(0x6F99CD1480E5A3BA) } },
        { { UINT64_C(0xD2E8DA04234F91FF), UINT64_C(0x4DED4D6D813867AA),
            UINT64_C(0x3B50175DE0A0D945), UINT64_C(0x55AC74064EB78137),
            UINT64_C(0xE9FA7F6EE1D47730), UINT64_C(0x2C1715315CBF2176) },
          { UINT64_C(0xA521788F2BE7A47D), UINT64_C(0x95B15A273FCF1AB3),
            UINT64_C(0xAADA6401F28A946A), UINT64_C(0x628B2EF48B4E898B),
            UINT64_C(0x0E6F46296D6592CC), UINT64_C(0x997C7094A723CADD) } },
        { { UINT64_C(0x878BCE116AFE80C6), UINT64_C(0xA89ABC9D007BBA38),
            UINT64_C(0xB0C1F87BA7CC267F), UINT64_C(0x86D33B9D5104FF04),
            UINT64_C(0xB0504B1B2EF1BA42), UINT64_C(0x21693048B2827E88) },
          { UINT64_C(0x11F1CCD579CFCD14), UINT64_C(0x59C09FFA94AD227E),
            UINT64_C(0x95A4ADCB3EA91ACF), UINT64_C(0x1346238BB4370BAA),
            UINT64_C(0xB099D2023E1367B0), UINT64_C(0xCF5BBDE690F23CEA) } },
        { { UINT64_C(0x453299BBBCB3BE5E), UINT64_C(0x123C588E38E9FF97),
            UINT64_C(0x8C115DD9F6A2E521), UINT64_C(0x6E333C11FF7D4B98),
            UINT64_C(0x9DD061E5DA73E736), UINT64_C(0xC6AB7B3A5CA53056) },
          { UINT64_C(0xF1EF3EE35B30A76B), UINT64_C(0xADD6B44A961BA11F),
            UINT64_C(0x7BB00B752CA6E030), UINT64_C(0x270272E82FE270AD),
            UINT64_C(0x23BC6F4F241A9239), UINT64_C(0x88581E130BB94A94) } },
        { { UINT64_C(0xBD225A6924EEF67F), UINT64_C(0x7CFD96140412CEB7),
            UINT64_C(0xF6DE167999AC298E), UINT64_C(0xB20FD895ED6C3571),
            UINT64_C(0x03C73B7861836C56), UINT64_C(0xEE3C3A16ABA6CB34) },
          { UINT64_C(0x9E8C56674138408A), UINT64_C(0xEC25FCB12DD6EBDF),
            UINT64_C(0xC54C33FDDBBDF6E3), UINT64_C(0x93E0913B4A3C9DD4),
            UINT64_C(0x66D7D13535EDEED4), UINT64_C(0xD29A36C4453FB66E) } },
        { { UINT64_C(0x7F192F039F1943AF), UINT64_C(0x6488163F4E0B5FB0),
            UINT64_C(0x66A45C6953599226), UINT64_C(0x924E2E439AD15A73),
            UINT64_C(0x8B553DB742A99D76), UINT64_C(0x4BC6B53B0451F521) },
          { UINT64_C(0xC029B5EF101F8AD6), UINT64_C(0x6A4DA71CC507EED9),
            UINT64_C(0x3ADFAEC030BB22F3), UINT64_C(0x81BCAF7AB514F85B),
            UINT64_C(0x2E1E6EFF5A7E60D3), UINT64_C(0x5270ABC0AE39D42F) } },
        { { UINT64_C(0x86D56DEB3901F0F8), UINT64_C(0x1D0BC792EED5F650),
            UINT64_C(0x1A2DDFD8CA1114A3), UINT64_C(0x94ABF4B1F1DD316D),
            UINT64_C(0xF72179E43D9F18EF), UINT64_C(0x52A0921E9AA2CABF) },
          { UINT64_C(0xECDA9E27A7452883), UINT64_C(0x7E90850AAFD771B4),
            UINT64_C(0xD40F87EA9CC0465C), UINT64_C(0x8CFCB60A865CDA36),
            UINT64_C(0x3DBEC2CC7C650942), UINT64_C(0x071A4EE7E718CA9D) } },
        { { UINT64_C(0x73C0E4FF276AC5F3), UINT64_C(0xE7BA5A6ABDB97EA1),
            UINT64_C(0x638CA54EC5808398), UINT64_C(0x8258DC82413855E5),
            UINT64_C(0x35DDD2E957F07614), UINT64_C(0xF98DD6921DC13BF9) },
          { UINT64_C(0x3A4C0088F16DCD84), UINT64_C(0xF192EADD833D83F9),
            UINT64_C(0x3C26C931A6D61D29), UINT64_C(0x589FDD52DE0AD7A1),
            UINT64_C(0x7CD83DD20442D37F), UINT64_C(0x1E47E777403ECBFC) } },
    },
    {
        { { UINT64_C(0x2AF8ED8170D4D7BC), UINT64_C(0xABC3E15FB632435C),
            UINT64_C(0x4C0E726F78219356), UINT64_C(0x8C1962A1B87254C4),
            UINT64_C(0x30796A71C9E7691A), UINT64_C(0xD453EF19A75A12EE) },
          { UINT64_C(0x535F42C213AE4964), UINT64_C(0x86831C3C0DA9586A),
            UINT64_C(0xB7F1EF35E39A7A58), UINT64_C(0xA2789AE2D459B91A),
            UINT64_C(0xEADBCA7F02FD429D), UINT64_C(0x94F215D465290F57) } },
        { { UINT64_C(0x37ED2BE51CFB79AC), UINT64_C(0x801946F3E7AF84C3),
            UINT64_C(0xB061AD8AE77C2F00), UINT64_C(0xE87E1A9A44DE16A8),
            UINT64_C(0xDF4F57C87EE490FF), UINT64_C(0x4E793B49005993ED) },
          { UINT64_C(0xE1036387BCCB593F), UINT64_C(0xF174941195E09B80),
            UINT64_C(0x59CB20D15AB42F91), UINT64_C(0xA738A18DAC0FF033),
            UINT64_C(0xDA501A2E2AC1E7F4), UINT64_C(0x1B67EDA084D8A6E0) } },
        { { UINT64_C(0x1D27EFCE1080E90B), UINT64_C(0xA28152463FD01DC6),
            UINT64_C(0x99A3FB83CAA26D18), UINT64_C(0xD27E6133B82BABBE),
            UINT64_C(0x61030DFDD783DD60), UINT64_C(0x295A291373C78CB8) },
          { UINT64_C(0x8707A2CF68BE6A92), UINT64_C(0xC9C2FB98EEB3474A),
            UINT64_C(0x7C3FD412A2B176B8), UINT64_C(0xD5B52E2FC7202101),
            UINT64_C(0x24A63030F0A6D536), UINT64_C(0x05842DE304648EC0) } },
        { { UINT64_C(0x67477CDC30577AC9), UINT64_C(0x51DD9775244F92A8),
            UINT64_C(0x31FD60B9917EEC66), UINT64_C(0xACD95BD4D66C5C1D),
            UINT64_C(0x2E0551F3BF9508BA), UINT64_C(0x121168E1688CB243) },
          { UINT64_C(0x8C0397404540D230), UINT64_C(0xC4ED3CF6009ECDF9),
            UINT64_C(0x191825E144DB62AF), UINT64_C(0x3EE8ACABC4A030DA),
            UINT64_C(0x8AB154A894081504), UINT64_C(0x1FE09E4B486C9CD0) } },
        { { UINT64_C(0x512F82F9D113450B), UINT64_C(0x5878C9012DBC9197),
            UINT64_C(0xDB87412BE13F355B), UINT64_C(0x0A0A4A9B935B8A5E),
            UINT64_C(0x818587BDF25A5351), UINT64_C(0xE807931031E3D9C7) },
          { UINT64_C(0x8B1D47C7611BC1B1), UINT64_C(0x51722B5872A823F2),
            UINT64_C(0x6F97EE8A53B36B3E), UINT64_C(0x6E085AAC946DD453),
            UINT64_C(0x2EC5057DE65E6533), UINT64_C(0xF82D9D714BB18801) } },
        { { UINT64_C(0xAD81FA938BA5AA8E), UINT64_C(0x723E628E8F7AA69E),
            UINT64_C(0x0BA7C2DEEF35937C), UINT64_C(0x83A43EC56DECFB40),
            UINT64_C(0xF520F849E60C4F2D), UINT64_C(0x8260E8AE457E3B5E) },
          { UINT64_C(0x7CE874F0BF1D9ED7), UINT64_C(0x5FDE35537F1A5466),
            UINT64_C(0x5A63777C0C162DBB), UINT64_C(0x0FD04F8CDAD87289),
            UINT64_C(0xCA2D9E0E640761D5), UINT64_C(0x4615CFF838501ADB) } },
        { { UINT64_C(0x9422789B110B4A25), UINT64_C(0x5C26779F70AD8CC1),
            UINT64_C(0x4EE6A748EC4F1E14), UINT64_C(0xFB584A0D5C7AB5E0),
            UINT64_C(0xED1DCB0BFB21EE66), UINT64_C(0xDBED1F0011C6863C) },
          { UINT64_C(0xD2969269B1B1D187), UINT64_C(0xF7D0C3F2AFE964E6),
            UINT64_C(0xE05EE93F12BB865E), UINT64_C(0x1AFB7BEEED79118E),
            UINT64_C(0x220AF1380F0FE453), UINT64_C(0x1463AA1A52782AB9) } },
        { { UINT64_C(0x7C139D56D7DBE5F9), UINT64_C(0xFC16E6110B83685B),
            UINT64_C(0xFA723C029018463C), UINT64_C(0xC472458C840BF5D7),
            UINT64_C(0x4D8093590AF07591), UINT64_C(0x418D88303308DFD9) },
          { UINT64_C(0x9B381E040C365AE3), UINT64_C(0x3780BF33F8190FD1),
            UINT64_C(0x45397418DD03E854), UINT64_C(0xA95D030F4E51E491),
            UINT64_C(0x87C8C686E3286CEA), UINT64_C(0x01C773BF900B5F83) } },
        { { UINT64_C(0xDABE347578673B02), UINT64_C(0x4F0F25CEF6E7395E),
            UINT64_C(0x3117ABB9D181AD45), UINT64_C(0x4B559F88AA13DE0B),
            UINT64_C(0xFD8EFE78EA7C9745), UINT64_C(0x080600475DD21682) },
          { UINT64_C(0xC0F5DE4BD4C86FFC), UINT64_C(0x4BB14B1EF21AB6A2),
            UINT64_C(0xACB53A6CF50C1D12), UINT64_C(0x46AAC4505CC9162E),
            UINT64_C(0x049C51E02DE240B6), UINT64_C(0xBB2DC016E383C3B0) } },
        { { UINT64_C(0xA3C56AD28E438C92), UINT64_C(0x7C43F98FB2CEAF1A),
            UINT64_C(0x397C44F7E2150778), UINT64_C(0x48D17AB771A24131),
            UINT64_C(0xCC5138631E2ACDA9), UINT64_C(0x2C76A55EF0C9BAC9) },
          { UINT64_C(0x4D74CDCE7EA4BB7B), UINT64_C(0x834BD5BFB1B3C2BA),
            UINT64_C(0x46E2911ECCC310A4), UINT64_C(0xD3DE84AA0FC1BF13),
            UINT64_C(0x27F2892F80A03AD3), UINT64_C(0x85B476203BD2F08B) } },
        { { UINT64_C(0xAB1CB818567AF533), UINT64_C(0x273B4537BAC2705A),
            UINT64_C(0x133066C422C84AB6), UINT64_C(0xC3590DE64830BFC1),
            UINT64_C(0xEA2978695E4742D0), UINT64_C(0xF6D8C6944F3164C0) },
          { UINT64_C(0x09E85F3DC1249588), UINT64_C(0x6C2BB05D4EC64DF7),
            UINT64_C(0xD267115E8B78000F), UINT64_C(0x07C5D7AEC7E4A316),
            UINT64_C(0xCB1187BA4619E5BD), UINT64_C(0x57B1D4EFA43F7EEE) } },
        { { UINT64_C(0x3618891FC8176A96), UINT64_C(0x62C4B084E5808B97),
            UINT64_C(0xDE5585464DD95D6E), UINT64_C(0x27A8133E730B2EA4),
            UINT64_C(0xE07CEEC36AF318A0), UINT64_C(0x0ACC1286CE24FD2C) },
          { UINT64_C(0x8A48FE4ADD4D307C), UINT64_C(0x71A9BA9C18CDE0DA),
            UINT64_C(0x655E2B66D5D79747), UINT64_C(0x409FE856A79AEDC7),
            UINT64_C(0xC5A9F244D287E5CF), UINT64_C(0xCCE103844E82EC39) } },
        { { UINT64_C(0x00675BA7F25D364C), UINT64_C(0x7A7F162968D36BDF),
            UINT64_C(0x35EC468AA9E23F29), UINT64_C(0xF797AC502D926E6C),
            UINT64_C(0x639BA4534B4F4376), UINT64_C(0xD71B430F51FF9519) },
          { UINT64_C(0xB8C439EC2CF5635C), UINT64_C(0x0CE4C8D181980393),
            UINT64_C(0x4C5362A964123B15), UINT64_C(0x6E0421E0FFDCF096),
            UINT64_C(0x624A855F10D1F914), UINT64_C(0x7D8F3AB7614DCD29) } },
        { { UINT64_C(0xD9219ADAB3493CE0), UINT64_C(0x971B243A52F09AE5),
            UINT64_C(0xC16C9BF8E24E3674), UINT64_C(0x026D408DCE68C7CD),
            UINT64_C(0xF9B33DD9358209E3), UINT64_C(0x02D0595DF3B2A206) },
          { UINT64_C(0xBF99427160D15640), UINT64_C(0x6DA7A04E15B5466A),
            UINT64_C(0x03AA4ED81CADB50D), UINT64_C(0x1548F029129A4253),
            UINT64_C(0x41741F7EB842865A), UINT64_C(0x859FE0A4A3F88C98) } },
        { { UINT64_C(0x80DE085A05FD7553), UINT64_C(0x4A4AB91EB897566B),
            UINT64_C(0x33BCD4752F1C173F), UINT64_C(0x4E238896C100C013),
            UINT64_C(0x1C88500DD614B34B), UINT64_C(0x0401C5F6C3BA9E23) },
          { UINT64_C(0x8E8003C4D0AF0DE5), UINT64_C(0x19B1DFB59D0DCBB9),
            UINT64_C(0x4A3640A9EBEF7AB6), UINT64_C(0xEDAFD65B959B15F6),
            UINT64_C(0x8092EF7F7FB95821), UINT64_C(0xAB8DD52ECE2E45D1) } },
        { { UINT64_C(0xD1F2D6B8B9CFE6BF), UINT64_C(0x6358810B00073F6F),
            UINT64_C(0x5FCE5993D712106E), UINT64_C(0x5EE6B2711C024C91),
            UINT64_C(0xD0248FF5453DB663), UINT64_C(0xD6D81CB2ADB835E8) },
          { UINT64_C(0x8696CFECFDFCB4C7), UINT64_C(0x696B7FCB53BC9045),
            UINT64_C(0xAB4D3807DDA56981), UINT64_C(0x2F9980521E4B943B),
            UINT64_C(0x8AA76ADB166B7F18), UINT64_C(0x6393430152A2D7ED) } },
    },
    {
        { { UINT64_C(0xBBCCCE39A368EFF6), UINT64_C(0xD8CAABDF8CEB5C43),
            UINT64_C(0x9EAE35A5D2252FDA), UINT64_C(0xA8F4F20954E7DD49),
            UINT64_C(0xA56D72A6295100FD), UINT64_C(0x20FC1FE856767727) },
          { UINT64_C(0xBF60B2480BBAA5AB), UINT64_C(0xA4F3CE5A313911F2),
            UINT64_C(0xC2A67AD4B93DAB9C), UINT64_C(0x18CD0ED022D71F39),
            UINT64_C(0x04380C425F304DB2), UINT64_C(0x26420CBB6729C821) } },
        { { UINT64_C(0x26BD07D6BDFBCAE8), UINT64_C(0x10B5173FDF01A80A),
            UINT64_C(0xD831C5466798B96C), UINT64_C(0x1D6B41081D3F3859),
            UINT64_C(0x501D38EC991B9EC7), UINT64_C(0x26319283D78431A9) },
          { UINT64_C(0x8B85BAF7118B343C), UINT64_C(0x4696CDDD58DEF7D0),
            UINT64_C(0xEFC7C1107ACDCF58), UINT64_C(0xD9AF415C848D5842),
            UINT64_C(0x6B5A06BC0AC7FDAC), UINT64_C(0x7D623E0DA344319B) } },
        { { UINT64_C(0x4C0D78060C9D3547), UINT64_C(0x993F048DCF2AED47),
            UINT64_C(0x5217C453E4B57E22), UINT64_C(0xB4669E35F4172B28),
            UINT64_C(0x509A3CD049F999F8), UINT64_C(0xD19F863287C69D41) },
          { UINT64_C(0xE14D01E84C8FDED0), UINT64_C(0x342880FDEAFD9E1C),
            UINT64_C(0x0E17BFF270DC2BF0), UINT64_C(0x46560B7BC0186400),
            UINT64_C(0xE28C7B9C49A4DD34), UINT64_C(0x182119160F325D06) } },
        { { UINT64_C(0x46D70888D7E02E18), UINT64_C(0x7C806954D9F11FD9),
            UINT64_C(0xE4948FCA4FBEA271), UINT64_C(0x7D6C7765BD80A9DF),
            UINT64_C(0x1B470EA6F3871C71), UINT64_C(0xD62DE2448330A570) },
          { UINT64_C(0xDAECDDC1C659C3A7), UINT64_C(0x8621E513077F7AFC),
            UINT64_C(0x56C7CD84CAEEEF13), UINT64_C(0xC60C910FC685A356),
            UINT64_C(0xE68BC5C59DD93DDC), UINT64_C(0xD904E89FFEB64895) } },
        { { UINT64_C(0x75D874FB8BA7917A), UINT64_C(0x18FA7F53FD043BD4),
            UINT64_C(0x212A0AD71FC3979E), UINT64_C(0x5703A7D95D6EAC0E),
            UINT64_C(0x222F7188017DEAD5), UINT64_C(0x1EC687B70F6C1817) },
          { UINT64_C(0x23412FC3238BACB6), UINT64_C(0xB85D70E954CED154),
            UINT64_C(0xD4E06722BDA674D0), UINT64_C(0x3EA5F17836F5A0C2),
            UINT64_C(0x7E7D79CFF5C6D2CA), UINT64_C(0x1FFF94643DBB3C73) } },
        { { UINT64_C(0x916E19D0F163E4A8), UINT64_C(0x1E6740E71489DF17),
            UINT64_C(0x1EAF9723339F3A47), UINT64_C(0x22F0ED1A124B8DAD),
            UINT64_C(0x39C9166C49C3DD04), UINT64_C(0x628E7FD4CE1E9ACC) },
          { UINT64_C(0x124DDF2740031676), UINT64_C(0x002569391EDDB9BE),
            UINT64_C(0xD39E25E7D360B0DA), UINT64_C(0x6E3015A84AA6C4C9),
            UINT64_C(0xC6A2F643623EDA09), UINT64_C(0xBEFF2D1250AA99FB) } },
        { { UINT64_C(0x1FEEF7CE93EE8089), UINT64_C(0xC6B180BC252DD7BD),
            UINT64_C(0xA16FB20B1788F051), UINT64_C(0xD86FD392E046ED39),
            UINT64_C(0xDA0A36119378CE1D), UINT64_C(0x121EF3E7A5F7A61D) },
          { UINT64_C(0x94D2206192D13CAE), UINT64_C(0x5076046A77C72E08),
            UINT64_C(0xF18BC2337D2308B9), UINT64_C(0x004DB3C517F977B1),
            UINT64_C(0xD05AE3990471C11D), UINT64_C(0x86A2A55785CD1726) } },
        { { UINT64_C(0xB8D9B28672107804), UINT64_C(0xB5A7C4133303B79B),
            UINT64_C(0x927EEF785FA37DED), UINT64_C(0xA1C5CF1EAD67DABA),
            UINT64_C(0xAA5E3FB27360E7C7), UINT64_C(0x8354E61A0A0C0993) },
          { UINT64_C(0x2EC73AF97F5458CC), UINT64_C(0xDE4CB48848474325),
            UINT64_C(0x2DD134C77209BC69), UINT64_C(0xB70C5567451A2ABE),
            UINT64_C(0x2CD1B2008E293018), UINT64_C(0x15F8DA7AD33C0D72) } },
        { { UINT64_C(0x5DC386D0A8790657), UINT64_C(0xA4FDF676BC4D88BB),
            UINT64_C(0x1B21F38F48BC6C49), UINT64_C(0xCDCC7FAA543A7003),
            UINT64_C(0xEA97E7AA8C9CF72C), UINT64_C(0xA6B883F450D938A8) },
          { UINT64_C(0x51936F3AA3A10F27), UINT64_C(0x0170785FDECC76BF),
            UINT64_C(0x7539ECE1908C578A), UINT64_C(0x5D9C8A8E0F3E8C25),
            UINT64_C(0x8681B43B9E4717A7), UINT64_C(0x94F42507A9D83E39) } },
        { { UINT64_C(0xBBE11CA8A55ADDE7), UINT64_C(0x39E6F5CF3BC0896B),
            UINT64_C(0x1447314E1D2D8D94), UINT64_C(0x45B481255B012F8A),
            UINT64_C(0x41AD23FA08AD5283), UINT64_C(0x837243E241D13774) },
          { UINT64_C(0x1FC0BD9DBADCAA46), UINT64_C(0x8DF164ED26E84CAE),
            UINT64_C(0x8FF70EC041017176), UINT64_C(0x23AD4BCE5C848BA7),
            UINT64_C(0x89246FDE97A19CBB), UINT64_C(0xA5EF987B78397991) } },
        { { UINT64_C(0x111AF1B74757964D), UINT64_C(0x1D25D351DDBBF258),
            UINT64_C(0x4161E7767D2B06D6), UINT64_C(0x6EFD26911CAC0C5B),
            UINT64_C(0x633B95DB211BFAEB), UINT64_C(0x9BEDFA5AE2BDF701) },
          { UINT64_C(0xADAC2B0B73E099C8), UINT64_C(0x436F0023BFB16BFF),
            UINT64_C(0xB91B100230F55854), UINT64_C(0xAF6A2097F4C6C8B7),
            UINT64_C(0x3FF65CED3AD7B3D9), UINT64_C(0x6FA2626F330E56DF) } },
        { { UINT64_C(0x3D28BF2DFFCCFD07), UINT64_C(0x0514F6FFD989603B),
            UINT64_C(0xB95196295514787A), UINT64_C(0xA1848121C3DB4E9C),
            UINT64_C(0x47FE2E392A3D4595), UINT64_C(0x506F5D8211B73ED4) },
          { UINT64_C(0xA2257AE7A600D8BB), UINT64_C(0xD659DBD10F9F122C),
            UINT64_C(0xDB0FDC6764DF160F), UINT64_C(0xFF3793397CB19690),
            UINT64_C(0xDF4366B898E72EC1), UINT64_C(0x97E72BECDF437EB8) } },
        { { UINT64_C(0x81DCEA271C81E5D9), UINT64_C(0x7E1B6CDA6717FC49),
            UINT64_C(0xAA36B3B511EAE80D), UINT64_C(0x1306687C3CD7CBB3),
            UINT64_C(0xED670235C4E89064), UINT64_C(0x9D3B000958A94760) },
          { UINT64_C(0x5A64E158E6A6333C), UINT64_C(0x1A8B4A3649453203),
            UINT64_C(0xF1CAD7241F77CC21), UINT64_C(0x693EBB4B70518EF7),
            UINT64_C(0xFB47BD810F39C91A), UINT64_C(0xCFE63DA2FA4BC64B) } },
        { { UINT64_C(0x82C1C684EAA66108), UINT64_C(0xE32262184CFE79FC),
            UINT64_C(0x3F28B72B849C720E), UINT64_C(0x137FB3558FEE1CA8),
            UINT64_C(0x4D18A9CDE4F90C4E), UINT64_C(0xC0344227CC3E46FA) },
          { UINT64_C(0x4FD5C08E79CDA392), UINT64_C(0x65DB20DB8ADC87B5),
            UINT64_C(0x86F95D5B916C1B84), UINT64_C(0x7EDA387117BB2B7C),
            UINT64_C(0x18CCF7E7669A533B), UINT64_C(0x5E92421CECAD0E06) } },
        { { UINT64_C(0x26063E124174B08B), UINT64_C(0xE621D9BE70DE8E4D),
            UINT64_C(0xAEA0FD0F5ECDF350), UINT64_C(0x0D9F69E49C20E5C9),
            UINT64_C(0xD3DADEB90BBE2918), UINT64_C(0xD7B9B5DB58AA2F71) },
          { UINT64_C(0x7A971DD73364CAF8), UINT64_C(0x702616A3C25D4BE4),
            UINT64_C(0xA30F0FA1A9E30071), UINT64_C(0x98AB24385573BC69),
            UINT64_C(0xCBC63CDF6FEC2E22), UINT64_C(0x965F90EDCC901B9B) } },
        { { UINT64_C(0xD53B592D71E15BB3), UINT64_C(0x1F03C0E98820E0D0),
            UINT64_C(0xCE93947D3CCCB726), UINT64_C(0x2790FEE01D547590),
            UINT64_C(0x4401D847C59CDD7A), UINT64_C(0x72D69120A926DD9D) },
          { UINT64_C(0x38B8F21D4229F289), UINT64_C(0x9F412E407FE978AF),
            UINT64_C(0xAE07901BCDB59AF1), UINT64_C(0x1E6BE5EBD1D4715E),
            UINT64_C(0x3715BD8B18C96BEF), UINT64_C(0x4B71F6E6E11B3798) } },
    },
    {
        { { UINT64_C(0x11A8FDE5F0CE2DF4), UINT64_C(0xBC70CA3EFA8D26DF),
            UINT64_C(0x6818C275C74DFE82), UINT64_C(0x2B0294AC38373A50),
            UINT64_C(0x584C4061E8E5F88F), UINT64_C(0x1C05C1CA7342383A) },
          { UINT64_C(0x263895B3911430EC), UINT64_C(0xEF9B0032A5171453),
            UINT64_C(0x144359DA84DA7F0C), UINT64_C(0x76E3095A924A09F2),
            UINT64_C(0x612986E3D69AD835), UINT64_C(0x70E03ADA392122AF) } },
        { { UINT64_C(0xFEB707EE67AAD17B), UINT64_C(0xBB21B28783042995),
            UINT64_C(0x26DE16459A0D32BA), UINT64_C(0x9A2FF38A1FFB9266),
            UINT64_C(0x4E5AD96D8F578B4A), UINT64_C(0x26CC0655883E7443) },
          { UINT64_C(0x1D8EECAB2EE9367A), UINT64_C(0x42B84337881DE2F8),
            UINT64_C(0xE49B2FAED758AE41), UINT64_C(0x6A9A22904A85D867),
            UINT64_C(0x2FB89DCEE68CBA86), UINT64_C(0xBC2526357F09A982) } },
        { { UINT64_C(0xADC794368C61AAAC), UINT64_C(0x24C7FD135E926563),
            UINT64_C(0xEF9FAAA40406C129), UINT64_C(0xF4E6388C8B658D3C),
            UINT64_C(0x7262BEB41E435BAF), UINT64_C(0x3BF622CCFDAEAC99) },
          { UINT64_C(0xD359F7D84E1AEDDC), UINT64_C(0x05DC4F8CD78C17B7),
            UINT64_C(0xB18CF03229498BA5), UINT64_C(0xC67388CA85BF35AD),
            UINT64_C(0x8A7A6AA262AA4BC8), UINT64_C(0x0B8F458E72F4627A) } },
        { { UINT64_C(0x3FB812EEC68E4488), UINT64_C(0x53C5EAA460EF7281),
            UINT64_C(0xE57241838FBEFBE4), UINT64_C(0x2B7D49F4A4B24A05),
            UINT64_C(0x23B138D0710C0A43), UINT64_C(0x16A5B4C1A85EC1DB) },
          { UINT64_C(0x7CC1F3D7305FEB02), UINT64_C(0x52F7947D5B6C1B54),
            UINT64_C(0x1BDA23128F56981C), UINT64_C(0x68663EAEB4080A01),
            UINT64_C(0x8DD7BA7E9F999B7F), UINT64_C(0xD8768D19B686580C) } },
        { { UINT64_C(0xBCD0E0AD7AFDDA94), UINT64_C(0x95A0DBBE34A30687),
            UINT64_C(0xBBE3C3DF8C5E2665), UINT64_C(0x742BECD8EBF2BC16),
            UINT64_C(0x300CEB483FA163A6), UINT64_C(0x0C5D02EE4663354B) },
          { UINT64_C(0xE4FB9AD6B5E606A4), UINT64_C(0x93F507B8CF49FF95),
            UINT64_C(0x9406A90C585C193B), UINT64_C(0xAD1440C14ECF9517),
            UINT64_C(0x184CB4759CEA53F1), UINT64_C(0x6855C4748EF11302) } },
        { { UINT64_C(0x00ECB523EDCAFA52), UINT64_C(0x0DA0AE0E086F69D3),
            UINT64_C(0xC384DE15C242F347), UINT64_C(0xFB050E6E848C12B7),
            UINT64_C(0x22F6765464E015CE), UINT64_C(0xCBDC2A487CA122F2) },
          { UINT64_C(0xA940D973445FB02C), UINT64_C(0x00F31E783767D89D),
            UINT64_C(0x2B65A237613DABDD), UINT64_C(0x2BE0AB05C875AE09),
            UINT64_C(0xB22E54FDBA204F8E), UINT64_C(0x65E2029D0F7687B9) } },
        { { UINT64_C(0xFFD825381855A71C), UINT64_C(0x26A330B3438BD8D8),
            UINT64_C(0x89628311F9D8C5F9), UINT64_C(0x8D5FB9CF953738A0),
            UINT64_C(0xCB7159C9EDFCD4E5), UINT64_C(0xD64E52302064C7C2) },
          { UINT64_C(0xF858ED80689F3CFE), UINT64_C(0x4830E30956128B67),
            UINT64_C(0x2E1692DAE0E90688), UINT64_C(0xAB818913CA9CC232),
            UINT64_C(0xE2E30C23A5D229A6), UINT64_C(0xA544E8B10E740E23) } },
        { { UINT64_C(0x1C15E569DC61E6CC), UINT64_C(0x8FD7296758FC7800),
            UINT64_C(0xE61E7DB737A9DFC5), UINT64_C(0x3F34A9C65AFD7822),
            UINT64_C(0x0A11274219E80773), UINT64_C(0xA353460C4760FC58) },
          { UINT64_C(0x2FB7DEEBB3124C71), UINT64_C(0x484636272D4009CC),
            UINT64_C(0x399D1933C3A10370), UINT64_C(0x7EB1945054388DBD),
            UINT64_C(0x8ECCE6397C2A006A), UINT64_C(0x3D565DAF55C932A0) } },
        { { UINT64_C(0xCEF57A9FD9ADAE53), UINT64_C(0xE2EB27D7F83FD8CD),
            UINT64_C(0x4AC8F7199BBD2DDE), UINT64_C(0x604283AAE91ABFB7),
            UINT64_C(0xB6A4E11534799F87), UINT64_C(0x2B253224E4C2A8F3) },
          { UINT64_C(0xC34F8B92C8782294), UINT64_C(0xC74D697DFCC2CB6B),
            UINT64_C(0xD990411BC2C84C46), UINT64_C(0x2807B5C631EA4955),
            UINT64_C(0x14AE2B93B9EB27F5), UINT64_C(0xF0AE96A76163EDFA) } },
        { { UINT64_C(0xA7BDCBB442DB7180), UINT64_C(0xC9FAA41FEDCA752F),
            UINT64_C(0x147F91B4E820F401), UINT64_C(0x1E6CEF86F5F2645F),
            UINT64_C(0xB4AB4D7F31FE711D), UINT64_C(0xCE68FB3C743EF882) },
          { UINT64_C(0xB9D7D6823EF2FCFF), UINT64_C(0xF6893811020DCAFD),
            UINT64_C(0x30D9A50CBF81E760), UINT64_C(0x7F247D06B9B87228),
            UINT64_C(0x143D4FEC5F40CFC0), UINT64_C(0x21D78D73329B2A88) } },
        { { UINT64_C(0x06B3FF8AED3F2055), UINT64_C(0x50482C77522BE214),
            UINT64_C(0x8DF69CD8DDF54620), UINT64_C(0x6D1DB204F78A1165),
            UINT64_C(0x459AE4A29AFE6BF2), UINT64_C(0xC23A9FFD24AC871E) },
          { UINT64_C(0xB7FD22E389E85D81), UINT64_C(0x297F1F6B122E9978),
            UINT64_C(0xAB283D66144BE1CE), UINT64_C(0xC1F90AC2C00C614E),
            UINT64_C(0x5465576E3224CD09), UINT64_C(0x8E8D910D441B6059) } },
        { { UINT64_C(0xF73A060AAAA228BC), UINT64_C(0xCF1B078356EFF87D),
            UINT64_C(0x11EF17C0A54C9133), UINT64_C(0x9E476B1576A4DAA5),
            UINT64_C(0x5624FEAC8018FB92), UINT64_C(0x9826A0FCCFEEC1B9) },
          { UINT64_C(0xB732F7FE2DFE2046), UINT64_C(0x9260BD9F3B40DA6A),
            UINT64_C(0xCC9F908F4F231773), UINT64_C(0x4827FEB9DAFC0D55),
            UINT64_C(0x07D32E85538ACE95), UINT64_C(0xAD9F897CB8EDAF37) } },
        { { UINT64_C(0x2F75B82FE3415498), UINT64_C(0xF99CAC5FF1015F30),
            UINT64_C(0x766408247D7F25DE), UINT64_C(0x714BC9CDEE74C047),
            UINT64_C(0x70F847BF07448879), UINT64_C(0xA14481DE072165C0) },
          { UINT64_C(0x9BFA59E3DB1140A8), UINT64_C(0x7B9C7FF0FCD13502),
            UINT64_C(0xF4D7538E68459ABF), UINT64_C(0xED93A791C8FC6AD2),
            UINT64_C(0xA8BBE2A8B51BD9B2), UINT64_C(0x084B5A279FB34008) } },
        { { UINT64_C(0xB3BB9545EB138C84), UINT64_C(0x59C3489C3FC88BFD),
            UINT64_C(0x3A97FF6385F53EC7), UINT64_C(0x40FDF5A60AA69C3D),
            UINT64_C(0x0E8CCEC753D19668), UINT64_C(0x0AA72EF933FAA661) },
          { UINT64_C(0xF5C5A6CF9B1E684B), UINT64_C(0x630F937131A22EA1),
            UINT64_C(0x06B2AAC2AC60F7EA), UINT64_C(0xB181CAE25BC37D80),
            UINT64_C(0x4601A929247B13EA), UINT64_C(0x8A71C3865F739797) } },
        { { UINT64_C(0x545387B3AB134786), UINT64_C(0x3179BB061599B64A),
            UINT64_C(0xB0A6198607593574), UINT64_C(0xC7E39B2163FA7C3B),
            UINT64_C(0xA1173F8691585D13), UINT64_C(0x09D5CC8ECB9525CD) },
          { UINT64_C(0xAAD44FFD8F3A3451), UINT64_C(0x702B04F225820CC5),
            UINT64_C(0xE90CAC491CB66C17), UINT64_C(0x40F6B547EE161DC4),
            UINT64_C(0xC08BB8B41BA4AC4E), UINT64_C(0x7DC064FBAE5A6BC1) } },
        { { UINT64_C(0x90A5E8719D76DDC7), UINT64_C(0x39DC8FAEEDFC8E2E),
            UINT64_C(0x98467A235B079C62), UINT64_C(0xE25E378505450C98),
            UINT64_C(0x2FE23A4D96140083), UINT64_C(0x65CE3B9AE9900312) },
          { UINT64_C(0x1D87D0886B72B5D9), UINT64_C(0x72F53220FD9AFC82),
            UINT64_C(0xC63C7C159E1F71FA), UINT64_C(0x90DF26EA8D449637),
            UINT64_C(0x97089F40C1C2B215), UINT64_C(0x83AF266442317FAA) } },
    },
    {
        { { UINT64_C(0xFA2DB51A8D688E31), UINT64_C(0x225B696CA09C88D4),
            UINT64_C(0x9F88AF1D6059171F), UINT64_C(0x1C5FEA5E782A0993),
            UINT64_C(0xE0FB15884EC710D3), UINT64_C(0xFAF372E5D32CE365) },
          { UINT64_C(0xD9F896AB26506F45), UINT64_C(0x8D3503388373C724),
            UINT64_C(0x1B76992DCA6E7342), UINT64_C(0x76338FCA6FD0C08B),
            UINT64_C(0xC3EA4C65A00F5C23), UINT64_C(0xDFAB29B3B316B35B) } },
        { { UINT64_C(0x84E5541F483AEBF9), UINT64_C(0x8ADFF7DC49165772),
            UINT64_C(0xE0A43AD69BEAAD3C), UINT64_C(0x97DD1820F51C2714),
            UINT64_C(0xAC2B4CB457EA5B0C), UINT64_C(0x87DBD011D11767CA) },
          { UINT64_C(0x18CCF36CBFC7957A), UINT64_C(0xD4A088411BC79227),
            UINT64_C(0x9811CE43D8D292A8), UINT64_C(0x72C5FC68D58C4EE7),
            UINT64_C(0x5BC0F0BED35C65A7), UINT64_C(0x0B446DBCCBBF9669) } },
        { { UINT64_C(0x7EBA3DA69CEE9BCE), UINT64_C(0x3E2C1248D5377750),
            UINT64_C(0x8C917D982B93D8B2), UINT64_C(0xCA8FC6AC7CAD1F75),
            UINT64_C(0x5F581F19A0FF150A), UINT64_C(0x872CC14AE08327FA) },
          { UINT64_C(0xC774F187E9333188), UINT64_C(0x528ED4AC497AF7E8),
            UINT64_C(0xCE036E9B8AD72B10), UINT64_C(0x463F9EBB917986CF),
            UINT64_C(0xBE5163281325CF9B), UINT64_C(0xD28D5C50DD7E5FEA) } },
        { { UINT64_C(0x714C1D1BDD58BBE3), UINT64_C(0x85BA01AE039AFD0F),
            UINT64_C(0x7F23EA3A6951AC80), UINT64_C(0x5C599290AC00C837),
            UINT64_C(0xF6EFA2B3BF24CC1B), UINT64_C(0x393D8E421E84462B) },
          { UINT64_C(0x9BDA627DF8B89453), UINT64_C(0xE66FFF2EB23E0D1B),
            UINT64_C(0xD1EE7089C3B94EC2), UINT64_C(0xF75DBA6E3031699A),
            UINT64_C(0x8FF75F79242B2453), UINT64_C(0xE721EDEB289BFED4) } },
        { { UINT64_C(0x083215A1C1390FA8), UINT64_C(0x901D686A6DCE8CE0),
            UINT64_C(0x4AB1BA62837073FF), UINT64_C(0x10C287AA34BEABA5),
            UINT64_C(0xB4931AF446985239), UINT64_C(0x07639899B053C4DC) },
          { UINT64_C(0x29E7F44DE721EECD), UINT64_C(0x6581718257B3FF48),
            UINT64_C(0x198542E25054E2E0), UINT64_C(0x923C9E1584616DE8),
            UINT64_C(0x2A9C15E1AD465BB9), UINT64_C(0xD8D4EFC716319245) } },
        { { UINT64_C(0x72DC79439961A674), UINT64_C(0x839A0A52A0E13668),
            UINT64_C(0xD7A53FA9334945EA), UINT64_C(0xDB21DB77E7AA25DB),
            UINT64_C(0xB6675A7D66E96DA3), UINT64_C(0x2C31C406E66F33C0) },
          { UINT64_C(0x45020B626EC7B9CB), UINT64_C(0xFF46E9CD0391F267),
            UINT64_C(0x7DABD7440FA2F221), UINT64_C(0x9A32364B9D4A2A3E),
            UINT64_C(0xF0F84AE852D2E47A), UINT64_C(0xD0B872BB888F488A) } },
        { { UINT64_C(0x531E4CEFC9790EEF), UINT64_C(0xF7B5735E2B8D1A58),
            UINT64_C(0xB8882F1EEF568511), UINT64_C(0xAFB08D1C86A86DB3),
            UINT64_C(0x88CB9DF2F54DE8C7), UINT64_C(0xA44234F19A683282) },
          { UINT64_C(0xBC1B3D3AA6E9AB2E), UINT64_C(0xEFA071FB87FC99EE),
            UINT64_C(0xFA3C737DA102DC0F), UINT64_C(0xDF3248A6D6A0CBD2),
            UINT64_C(0x6E62A4FF1ECC1BF4), UINT64_C(0xF718F940C8F1BC17) } },
        { { UINT64_C(0x2C8B0AAD4F63F026), UINT64_C(0x2AFF623850B253CC),
            UINT64_C(0xCAB3E94210C4D122), UINT64_C(0x52B59F0407CD2816),
            UINT64_C(0x22322803982C41FC), UINT64_C(0x38844E668CF50B19) },
          { UINT64_C(0x42A959F7BE3264CD), UINT64_C(0xBDDC24BD6C983524),
            UINT64_C(0xA489EB0C462B8640), UINT64_C(0xB7C0509298029BE7),
            UINT64_C(0xD5546B5FA1ADDC64), UINT64_C(0xE7CAC1FCA0C655AF) } },
        { { UINT64_C(0x1454719847636F97), UINT64_C(0x6FA67481EBCDCCFF),
            UINT64_C(0xC164872F395D3258), UINT64_C(0xB8CECAFEEE6ACDBC),
            UINT64_C(0x3FBFE5F3A933F180), UINT64_C(0xEC20CAC2898C3B1E) },
          { UINT64_C(0x6A031BEE87DA73F9), UINT64_C(0xD1E667D15C5AF46E),
            UINT64_C(0xCB3DC1681DC6EEF9), UINT64_C(0x2DD1BD9433D310C0),
            UINT64_C(0x0F78D4939207E438), UINT64_C(0xC233D544A99C0E75) } },
        { { UINT64_C(0x228F19F19E2A0113), UINT64_C(0x58495BE50E1A5D37),
            UINT64_C(0x97E08F6938D7F364), UINT64_C(0x1EC3BA3E510759B0),
            UINT64_C(0x3682F19AE03CD40D), UINT64_C(0xC87745D8F9E16D68) },
          { UINT64_C(0xFD527AB509A642EA), UINT64_C(0x6308EEBDF9C81F27),
            UINT64_C(0xFA9F666C550C5D68), UINT64_C(0xDEBA436F584AB153),
            UINT64_C(0x1D4861D35B63E939), UINT64_C(0x073BED9BC9850221) } },
        { { UINT64_C(0x802BCCF08B171246), UINT64_C(0xFFF7D15A733B072F),
            UINT64_C(0xEA3862664CBFA4EF), UINT64_C(0x9E5B5073D635946B),
            UINT64_C(0x16E9A979FA81BE95), UINT64_C(0x41E8716EB14F701F) },
          { UINT64_C(0x25782E0F101A6719), UINT64_C(0x442C4875C9D66959),
            UINT64_C(0x52D845D92B85D153), UINT64_C(0xFF9251382E831117),
            UINT64_C(0x01B700CC8E02434B), UINT64_C(0xD2DB7F8EEC0BAE3E) } },
        { { UINT64_C(0x1B225300966A4872), UINT64_C(0x40C149BE566F537B),
            UINT64_C(0x3335F4D2CB680021), UINT64_C(0x773D0263778E5F5F),
            UINT64_C(0x1D9B7602666FA9ED), UINT64_C(0x52490A102E6200CF) },
          { UINT64_C(0x8434C7DD961F290B), UINT64_C(0x773AC15664456446),
            UINT64_C(0x5E2BB78947B712BB), UINT64_C(0xFD3BCBFDBE0974AD),
            UINT64_C(0x71AE9351791AD5D8), UINT64_C(0x1EE738BA6F4E1400) } },
        { { UINT64_C(0x2FA428AB0BE8E26E), UINT64_C(0xFEFF0600BB4CF9FC),
            UINT64_C(0x76F25CA9B2EA5FB0), UINT64_C(0xAB7FECF06835C5F4),
            UINT64_C(0x649D077219D5F328), UINT64_C(0xABE7B895ACBCB12E) },
          { UINT64_C(0xF2D1031AD69B1EA8), UINT64_C(0x46065D5DC60B0BBB),
            UINT64_C(0xB0908DC185D798FF), UINT64_C(0x4E2420F0D2C9B18A),
            UINT64_C(0x6B3A9BDDD30432A2), UINT64_C(0x501C3383C9B134AD) } },
        { { UINT64_C(0x608F096798A21284), UINT64_C(0x5361BE86059CCEDE),
            UINT64_C(0x3A40655CAFD87EF7), UINT64_C(0x03CF311759083AA2),
            UINT64_C(0x57DB5F61B6C366D9), UINT64_C(0x29DC275B6DD0D232) },
          { UINT64_C(0xBDAB24DD8FA67501), UINT64_C(0x5928F77565D08C37),
            UINT64_C(0x9448A856645D466A), UINT64_C(0x6E6B5E2EC0E927A5),
            UINT64_C(0xE884D546E80C6871), UINT64_C(0x10C881C953A9A851) } },
        { { UINT64_C(0x355053749B627AA5), UINT64_C(0xE7CA1B577976677B),
            UINT64_C(0x812397124976CE17), UINT64_C(0x96E9080B96DA31B9),
            UINT64_C(0x458254ABCC64AA1F), UINT64_C(0xFEFF682148E674C9) },
          { UINT64_C(0x8772F37A021F1488), UINT64_C(0x2E274E18AB56345C),
            UINT64_C(0x7C7BE61C29823B76), UINT64_C(0x275DB7B29EEFB39E),
            UINT64_C(0x83B10ED4BF5CBCEF), UINT64_C(0x40D7F5B4518E5183) } },
        { { UINT64_C(0x315CCC01F960B41B), UINT64_C(0x90B417C91D99E722),
            UINT64_C(0x84AFAA0D013463E0), UINT64_C(0xF133C5D813E6D9E1),
            UINT64_C(0xD95C6ADC525B7430), UINT64_C(0x082C61AD7A25106A) },
          { UINT64_C(0xABC1966DBA1CE179), UINT64_C(0xE0578B77A5DB529A),
            UINT64_C(0x10988C05EC84107D), UINT64_C(0xFCADE5D71B207F83),
            UINT64_C(0x0BEB6FDBC5BA83DB), UINT64_C(0x1C39B86D57537E34) } },
    },
    {
        { { UINT64_C(0x5B0B5D692A7AECED), UINT64_C(0x4C03450C01DC545F),
            UINT64_C(0x72AD0A4A404A3458), UINT64_C(0x1DE8E2559F467B60),
            UINT64_C(0xA4B3570590634809), UINT64_C(0x76F30205706F0178) },
          { UINT64_C(0x588D21AB4454F0E5), UINT64_C(0xD22DF54964134928),
            UINT64_C(0xF4E7E73D241BCD90), UINT64_C(0xB8D8A1D22FACC7CC),
            UINT64_C(0x483C35A71D25D2A0), UINT64_C(0x7F8D25451EF9F608) } },
        { { UINT64_C(0xCB51F03954EBC926), UINT64_C(0xE235D356B8D4A7BB),
            UINT64_C(0x93C8FAFAB41FE1A6), UINT64_C(0x6297701DA719F254),
            UINT64_C(0x6E9165BC644F5CDE), UINT64_C(0x6506329D0C11C542) },
          { UINT64_C(0xA2564809A92B4250), UINT64_C(0x0E9AC173889C2E3E),
            UINT64_C(0x286A592622B1D1BE), UINT64_C(0x86A3D7526ECDD041),
            UINT64_C(0x4B867E0A649F9524), UINT64_C(0x1FE7D95A0629CB0F) } },
        { { UINT64_C(0xF4F66843CA5BAF54), UINT64_C(0x298DB357EFE7DB78),
            UINT64_C(0xF607E86E7365712F), UINT64_C(0xD58822988A822BC0),
            UINT64_C(0x2CFBD63AC61299B3), UINT64_C(0x6F713D9B67167B1A) },
          { UINT64_C(0x750F673FDE0B077A), UINT64_C(0x07482708EE2178DA),
            UINT64_C(0x5E6D5BD169123C75), UINT64_C(0x6A93D1B6EAB99B37),
            UINT64_C(0x6EF4F7E68CAEC6A3), UINT64_C(0x7BE411D6CF3ED818) } },
        { { UINT64_C(0xF92B307363A0A7D2), UINT64_C(0x32DA431C881DC8CF),
            UINT64_C(0xE51BD5EDC578E3A3), UINT64_C(0xEFDA70D29587FA22),
            UINT64_C(0xCFEC17089B2EBA85), UINT64_C(0x6AB51A4BAF7BA530) },
          { UINT64_C(0x5AC155AE98174812), UINT64_C(0xCAF07A71CCB076E3),
            UINT64_C(0x280E86C2C38718A7), UINT64_C(0x9D12DE73D63745B7),
            UINT64_C(0x0E8EA855BF8A79AA), UINT64_C(0x5EB2BED8BD705BF7) } },
        { { UINT64_C(0x33FE9578AE16DE53), UINT64_C(0x3AE85EB510BEC902),
            UINT64_C(0xC4F4965844AF850E), UINT64_C(0x6EA222B3087DD658),
            UINT64_C(0xB255E6FDA51F1447), UINT64_C(0xB35E4997117E3F48) },
          { UINT64_C(0x562E813B05616CA1), UINT64_C(0xDF5925D68A61E156),
            UINT64_C(0xB2FA8125571C728B), UINT64_C(0x00864805A2F2D1CF),
            UINT64_C(0x2DC26F411BCCB6FF), UINT64_C(0xEBD5E09363AE37DD) } },
        { { UINT64_C(0xD2D68BB30A285611), UINT64_C(0x3EAE7596DC8378F2),
            UINT64_C(0x2DC6CCC66CC688A3), UINT64_C(0xC45E5713011F5DFB),
            UINT64_C(0x6B9C4F6C62D34487), UINT64_C(0xFAD6F0771FC65551) },
          { UINT64_C(0x5E3266E062B23B52), UINT64_C(0xF1DAF319E98F4715),
            UINT64_C(0x064D12EA3ED0AE83), UINT64_C(0x5CCF9326564125CB),
            UINT64_C(0x09057022C63C1E9F), UINT64_C(0x7171972CDC9B5D2E) } },
        { { UINT64_C(0x2364FD9AEABD21B2), UINT64_C(0x3CE5F4BB9174AD6D),
            UINT64_C(0xA4D6D5D0B38688C0), UINT64_C(0x2292A2D26D87FD7D),
            UINT64_C(0x2A7D1B534CA02E54), UINT64_C(0x7BEE6E7EB4185715) },
          { UINT64_C(0x73E546098FC63ACD), UINT64_C(0xF4D93A124064E09D),
            UINT64_C(0xD20E157A2B92DAA5), UINT64_C(0x90D125DBC4B81A00),
            UINT64_C(0xCB951C9E7682DE13), UINT64_C(0x1ABE58F427987545) } },
        { { UINT64_C(0x6D35164030C70C8D), UINT64_C(0x8047D811CE2361B8),
            UINT64_C(0x3F8B3D4FDF8E2C81), UINT64_C(0x5D59547733FA1F6C),
            UINT64_C(0xF769FE5AE29B8A91), UINT64_C(0x26F0E606D737B2A2) },
          { UINT64_C(0x70CBFA5DB8B31C6A), UINT64_C(0x0F883B4A863D3AEA),
            UINT64_C(0x156A4479E386AE2F), UINT64_C(0xA17A2FCDADE8A684),
            UINT64_C(0x78BDF958E2A7E335), UINT64_C(0xD1B4E6733B9E3041) } },
        { { UINT64_C(0x1EAF48EC449A6D11), UINT64_C(0x6B94B8E46D2FA7B9),
            UINT64_C(0x1D75D269728E4C1B), UINT64_C(0x91123819DD304E2C),
            UINT64_C(0x0B34CAE388804F4B), UINT64_C(0x2BA192FBC5495E9A) },
          { UINT64_C(0xC93FF6EFFF4D24BF), UINT64_C(0xF8C2C0B00342BA78),
            UINT64_C(0x8041F769831EB94C), UINT64_C(0x353100747782985E),
            UINT64_C(0xC755320B3AF84E83), UINT64_C(0x384B6D266F497E7F) } },
        { { UINT64_C(0xEF92CD5917E6BD17), UINT64_C(0xA087305BA426965C),
            UINT64_C(0x13895CE7AC47F773), UINT64_C(0xB85F2A9FE0BB2867),
            UINT64_C(0x2926E6AA7CD7C58E), UINT64_C(0xE544EDA6450459C5) },
          { UINT64_C(0x73DBC351B90A9849), UINT64_C(0x961183F6848EBE86),
            UINT64_C(0xC45BB21080534712), UINT64_C(0x379D08D7A654D9A3),
            UINT64_C(0x5B97CEF2BD3FFA9C), UINT64_C(0x0F469F34DDC2FCE5) } },
        { { UINT64_C(0x6D1461080642F38D), UINT64_C(0x055171A0D21EB887),
            UINT64_C(0x28DFFAB4D0DCEB28), UINT64_C(0x0D0E631298DE9CCD),
            UINT64_C(0x750A9156118C3C3F), UINT64_C(0x8C1F1390B049D799) },
          { UINT64_C(0xE4823858439607C5), UINT64_C(0x947E9BA05C111EAB),
            UINT64_C(0x39C95616A355DF2E), UINT64_C(0xF5F6B98E10E54BDA),
            UINT64_C(0xB0E0B33D142B876A), UINT64_C(0x71197D73EA18C90C) } },
        { { UINT64_C(0x36A5139DF52BE819), UINT64_C(0xF60DDF3429A45D2B),
            UINT64_C(0x0727EFECE9220E34), UINT64_C(0x431D33864EF7F446),
            UINT64_C(0xC3165A64FCC4962C), UINT64_C(0xB7D926E1D64362BB) },
          { UINT64_C(0x216BC61FD45F9350), UINT64_C(0xA974CB2FBBAED815),
            UINT64_C(0x31DF342D86FB2F76), UINT64_C(0x3AB67E0501D78314),
            UINT64_C(0x7AA951E0DEE33ED2), UINT64_C(0x318FBBBDCEC78D94) } },
        { { UINT64_C(0xAD7EFB65B8FE0204), UINT64_C(0x0432E1C5230AB7F7),
            UINT64_C(0x7563A62D9C967400), UINT64_C(0xD88B9C743524D4FF),
            UINT64_C(0x16A1991CF1A823E3), UINT64_C(0xCF2F9BFEFA6F0FFB) },
          { UINT64_C(0x55AAA946A50CA61F), UINT64_C(0x8CBBD3C8FED4CAB3),
            UINT64_C(0x03A0FAB87651365A), UINT64_C(0x46B5234B62DC3913),
            UINT64_C(0xFD875B28B558CBBD), UINT64_C(0xA48EC3AE11CEB361) } },
        { { UINT64_C(0x5DD131A1B3ADBD8B), UINT64_C(0xF9FBCA3A29B45EF8),
            UINT64_C(0x022048669341EE18), UINT64_C(0x8D13B89583BF9618),
            UINT64_C(0x0E395BAEE807459C), UINT64_C(0xB9C110CCB190E7DB) },
          { UINT64_C(0xA0DC345225D25063), UINT64_C(0x2FB78EC802371462),
            UINT64_C(0xC3A9E7BB8975C2D5), UINT64_C(0x9466687285A78264),
            UINT64_C(0x480D2CC28029AA92), UINT64_C(0x237086C75655726D) } },
        { { UINT64_C(0x197F14BB65EB9EEE), UINT64_C(0xFC93125C9F12E5FD),
            UINT64_C(0x9C20BC538BFBAE5E), UINT64_C(0xB35E21544BC053BA),
            UINT64_C(0xE5FA9CC721C3898E), UINT64_C(0x502D72FFD42F950F) },
          { UINT64_C(0x6812D38AD1EB8C31), UINT64_C(0x1F77F3F1080D30BB),
            UINT64_C(0x18D128335A8B1E98), UINT64_C(0x7FD39FA9299196CE),
            UINT64_C(0xFB8C9F11CF4ED6D6), UINT64_C(0x4C00F604D6363194) } },
        { { UINT64_C(0x5C8AFCF9FA2A21C2), UINT64_C(0x71CBF2821928D133),
            UINT64_C(0x56BEF28E42B29506), UINT64_C(0xAFBA250C70323DE2),
            UINT64_C(0x3FE208D17DED2C30), UINT64_C(0xBD2CD213CE9AA598) },
          { UINT64_C(0x52C5EC52CFEED070), UINT64_C(0x0A7223E7D3DA336B),
            UINT64_C(0x7156A4EDCE156B46), UINT64_C(0x9AF6C499ED7E6159),
            UINT64_C(0x9D7A679713C029AD), UINT64_C(0xE5B5C9249018DC77) } },
    },
    {
        { { UINT64_C(0x3F2EFF53DE1E4E55), UINT64_C(0x6B749943E4D3ECC4),
            UINT64_C(0xAF10B18A0DDE190D), UINT64_C(0xF491B98DA26B0409),
            UINT64_C(0x66080782A2B1D944), UINT64_C(0x59277DC697E8C541) },
          { UINT64_C(0xFDBFC5F6006F18AA), UINT64_C(0x435D165BFADD8BE1),
            UINT64_C(0x8E5D263857645EF4), UINT64_C(0x31BCFDA6A0258363),
            UINT64_C(0xF5330AB8D35D2503), UINT64_C(0xB71369F0C7CAB285) } },
        { { UINT64_C(0xE6A19DCC40ACC5A8), UINT64_C(0x1C3A1FF1DBC6DBF8),
            UINT64_C(0xB4D89B9FC6455613), UINT64_C(0x6CB0FE44A7390D0E),
            UINT64_C(0xADE197A459EA135A), UINT64_C(0xDA6AA86520680982) },
          { UINT64_C(0x03DB9BE95A442C1B), UINT64_C(0x221A2D732BFB93F2),
            UINT64_C(0x44DEE8D4753C196C), UINT64_C(0x59ADCC700B7C6FF5),
            UINT64_C(0xC6260EC24CA1B142), UINT64_C(0x4C3CB5C646CBD4F2) } },
        { { UINT64_C(0x8A15D6FEA417111F), UINT64_C(0xFE4A16BD71D93FCC),
            UINT64_C(0x7A7EE38C55BBE732), UINT64_C(0xEFF146A51FF94A9D),
            UINT64_C(0xE572D13EDD585AB5), UINT64_C(0xD879790E06491A5D) },
          { UINT64_C(0x9C84E1C52A58CB2E), UINT64_C(0xD79D13746C938630),
            UINT64_C(0xDB12CD9B385F06C7), UINT64_C(0x0C93EB977A7759C3),
            UINT64_C(0xF1F5B0FE683BD706), UINT64_C(0x541E4F7285EC3D50) } },
        { { UINT64_C(0x9A0E153581833608), UINT64_C(0x5CCE871E6E2833AC),
            UINT64_C(0xC17059EAFB29777C), UINT64_C(0x7E40E5FAE354CAFD),
            UINT64_C(0x9CF594054D07C371), UINT64_C(0x64CE36B2A71C3945) },
          { UINT64_C(0x69309E9656CAF487), UINT64_C(0x3D719E9F1AE3454B),
            UINT64_C(0xF2164070E25823B6), UINT64_C(0xEAD851BD0BC27359),
            UINT64_C(0x3D21BFE8B0925094), UINT64_C(0xA783B1E934A97F4E) } },
        { { UINT64_C(0x406B0C269546491A), UINT64_C(0x9E5E15E2F293C4E5),
            UINT64_C(0xC60D641315B164DB), UINT64_C(0x0DA46F530C75A78E),
            UINT64_C(0x7C599BB7EA0C656B), UINT64_C(0x0F07A5121B1A8122) },
          { UINT64_C(0x14C7204A15172686), UINT64_C(0x8FAEDFF85165625D),
            UINT64_C(0x20F260CE37AEDE40), UINT64_C(0xC81F771E8F357FFE),
            UINT64_C(0x25499197B0912557), UINT64_C(0x736197DC4C739C74) } },
        { { UINT64_C(0x6151BAB1381B3462), UINT64_C(0x27E5A07843DBD344),
            UINT64_C(0x2CB05BD6A1C3E9FB), UINT64_C(0x2A75976027CF2A11),
            UINT64_C(0x0ADCF9DBFF43E702), UINT64_C(0x4BBF03E21F484146) },
          { UINT64_C(0x0E74997F55B6521A), UINT64_C(0x15629231ADE17086),
            UINT64_C(0x7F143E867493FC58), UINT64_C(0x60869095AF8B9670),
            UINT64_C(0x482CFCD77E524869), UINT64_C(0x9E8060C31D454756) } },
        { { UINT64_C(0xE495747AC88B4D3B), UINT64_C(0xB7559835AE8A948F),
            UINT64_C(0x67EEF3A9DEB56853), UINT64_C(0x0E20E2699DEE5ADF),
            UINT64_C(0x9031AF6761F0A1AA), UINT64_C(0x76669D32683402BC) },
          { UINT64_C(0x90BD231306718B16), UINT64_C(0xE1B22A21864EFDAC),
            UINT64_C(0xE4FFE9096620089F), UINT64_C(0xB84C842E3428E2D9),
            UINT64_C(0x0E28C880FE3871FC), UINT64_C(0x8932F6983F21C200) } },
        { { UINT64_C(0x603F00CE6C90EA5D), UINT64_C(0x6473930740A2F693),
            UINT64_C(0xAF65148B2174E517), UINT64_C(0x162FC2CAF784AE74),
            UINT64_C(0x0D9A88254D5F6458), UINT64_C(0x0C2D586143AACE93) },
          { UINT64_C(0xBF1EADDE9F73CBFC), UINT64_C(0xDE9C34C09C68BBCA),
            UINT64_C(0x6D95602D67EF8A1A), UINT64_C(0x0AF2581BA791B241),
            UINT64_C(0x14F7736112CAD604), UINT64_C(0x19F2354DE2ACD1AD) } },
        { { UINT64_C(0x272F78F60D60F263), UINT64_C(0xE7A8F4AF208FD785),
            UINT64_C(0x10E191C636554F2C), UINT64_C(0x06D88551FD5CD0B3),
            UINT64_C(0x29BF856857069C27), UINT64_C(0x3CE7ECD828AA6FAD) },
          { UINT64_C(0x7D8A92D0E9F1A1D8), UINT64_C(0xD40C7FF8D30B5725),
            UINT64_C(0x16BE6CB2F54CAEB8), UINT64_C(0x14CA471A14CB0A91),
            UINT64_C(0xD5FF15B802733CAE), UINT64_C(0xCAF88D87DAA76580) } },
        { { UINT64_C(0x39430E222C046592), UINT64_C(0x6CDAE81F1AD26706),
            UINT64_C(0x8C102159A25D9106), UINT64_C(0x9A44057227CA9F30),
            UINT64_C(0x8D34C43070287FBC), UINT64_C(0x9003A45529DB8AFA) },
          { UINT64_C(0x91364CC37FD971AD), UINT64_C(0x7B3AA0489C60EDB7),
            UINT64_C(0x58B0E008526F4DD8), UINT64_C(0xB7674454D86D98AE),
            UINT64_C(0xC25F4051B2B45747), UINT64_C(0x8243BF9CCC043E8F) } },
        { { UINT64_C(0xA89641C643A0C387), UINT64_C(0x6D92205C87B9AB17),
            UINT64_C(0x37D691F4DAA0E102), UINT64_C(0xEB3E52D7CDE5312E),
            UINT64_C(0x60D3C09916F518A2), UINT64_C(0x7854C0518A378EEB) },
          { UINT64_C(0x7359DB514BBCAAC5), UINT64_C(0xF5B1B68C1713F102),
            UINT64_C(0xDAEAE645E4398DE5), UINT64_C(0x8C8ACB6CD1ABFB82),
            UINT64_C(0x2E8B76C3136423E2), UINT64_C(0x509DCB2DA8BA015E) } },
        { { UINT64_C(0x2FF368159AD9C59C), UINT64_C(0xB189A4E8658E65B9),
            UINT64_C(0x7D33DDBBEA786AD2), UINT64_C(0x96D0D648C0D2DC05),
            UINT64_C(0x05E49256BFA03BE9), UINT64_C(0x0EA4E7A68BAF5A1C) },
          { UINT64_C(0x3DDCE0B09F9AD5A8), UINT64_C(0xF78091959E49C2CB),
            UINT64_C(0xBFCEF29D21782C2F), UINT64_C(0xE57AD39FC41BFD97),
            UINT64_C(0xC04B93E81355AD19), UINT64_C(0xAABC9E6E59440F9F) } },
        { { UINT64_C(0x7AA481035B6459DA), UINT64_C(0x83EF74770166E880),
            UINT64_C(0x536182B1511CCE80), UINT64_C(0xAFDD2EEE73CA55AA),
            UINT64_C(0xAB910D0DA8716143), UINT64_C(0x8BEAA42B83707250) },
          { UINT64_C(0x4BCCFD898DA2AB3D), UINT64_C(0x1DBF68A9EC6AA105),
            UINT64_C(0x32CE610868EB42DA), UINT64_C(0x5C2C2C858EA62E37),
            UINT64_C(0x1ED2791FCD3088A7), UINT64_C(0x496B4FEBFF05070C) } },
        { { UINT64_C(0x9FA9121A0AA629C5), UINT64_C(0xE286CFF157558BEC),
            UINT64_C(0x4D9D657E59813A4D), UINT64_C(0xC4676A1626103519),
            UINT64_C(0x616160B32BD4DF80), UINT64_C(0x26FB78CC30FBAE87) },
          { UINT64_C(0x096070138F0F66BD), UINT64_C(0xDD4E2D0C03D9B90D),
            UINT64_C(0x5D3A8912600D1B12), UINT64_C(0xF76DD52F4308E126),
            UINT64_C(0x97CC04099E4FCCA6), UINT64_C(0x0CFBE31104C4DF7B) } },
        { { UINT64_C(0x6CA62C1228437A23), UINT64_C(0x0DAF335340E7A003),
            UINT64_C(0x1FD07DF0D20F8079), UINT64_C(0xEAE7969C3BBC9749),
            UINT64_C(0x55861AFA9ECAD022), UINT64_C(0xEC41DAD91FBC3D4C) },
          { UINT64_C(0x1FE4CB40DA8B261B), UINT64_C(0xC2671AB6427C5C9D),
            UINT64_C(0xDFCDA7B8261D4939), UINT64_C(0x9E7B802B2072C0B9),
            UINT64_C(0x3AFEE900C7828CC2), UINT64_C(0x3488BF28F6DE987F) } },
        { { UINT64_C(0x33B9F2DE7BE1F89E), UINT64_C(0xD4E80821299B15C9),
            UINT64_C(0x87A3067A0E13F37F), UINT64_C(0x6D4C09ED55FD239F),
            UINT64_C(0x48B1042D92EF014F), UINT64_C(0xA382B2E0B385A759) },
          { UINT64_C(0xBF571BB07F6F84F8), UINT64_C(0x25AFFA370CE87F50),
            UINT64_C(0x826906D3FE54F1BC), UINT64_C(0x6B0421F4C53AE76A),
            UINT64_C(0x44F85A3A4855EB3C), UINT64_C(0xF49E21518D1F2B27) } },
    },
    {
        { { UINT64_C(0xC0426B775E3C647B), UINT64_C(0xBFCBD9398CF05348),
            UINT64_C(0x31D312E3172C0D3D), UINT64_C(0x5F49FDE6EE754737),
            UINT64_C(0x895530F06DA7EE61), UINT64_C(0xCF281B0AE8B3A5FB) },
          { UINT64_C(0xFD14973541B8A543), UINT64_C(0x41A625A73080DD30),
            UINT64_C(0xE2BAAE07653908CF), UINT64_C(0xC3D01436BA02A278),
            UINT64_C(0xA0D0222E7B21B8F8), UINT64_C(0xFDC270E9D7EC1297) } },
        { { UINT64_C(0x06A67BD29F101E64), UINT64_C(0xCB6E0AC7E1733A4A),
            UINT64_C(0xEE0B5D5197BC62D2), UINT64_C(0x52B1703924C51874),
            UINT64_C(0xFED1F42382A1A0D5), UINT64_C(0x55D90569DB6270AC) },
          { UINT64_C(0x36BE4A9C5D73D533), UINT64_C(0xBE9266D6976ED4D5),
            UINT64_C(0xC17436D3B8F8074B), UINT64_C(0x3BB4D399718545C6),
            UINT64_C(0x8E1EA3555C757D21), UINT64_C(0xF7EDBC978C474366) } },
        { { UINT64_C(0xEC72C6506EA83242), UINT64_C(0xF7DE7BE51B2D237F),
            UINT64_C(0x3C5E22001819EFB0), UINT64_C(0xDF5AB6D68CDDE870),
            UINT64_C(0x75A44E9D92A87AEE), UINT64_C(0xBDDC46F4BCF77F19) },
          { UINT64_C(0x8191EFBD669B674D), UINT64_C(0x52884DF9ED71768F),
            UINT64_C(0xE62BE58265CF242C), UINT64_C(0xAE99A3B180B1D17B),
            UINT64_C(0x48CBB44692DE59A9), UINT64_C(0xD3C226CF2DCB3CE2) } },
        { { UINT64_C(0x9580CDFB9FD94EC4), UINT64_C(0xED273A6C28631AD9),
            UINT64_C(0x5D3D5F77C327F3E7), UINT64_C(0x05D5339C35353C5F),
            UINT64_C(0xC56FB5FE5C258EB1), UINT64_C(0xEFF8425EEDCE1F79) },
          { UINT64_C(0xAB7AA141CF83CF9C), UINT64_C(0xBD2A690A207D6D4F),
            UINT64_C(0xE1241491458D9E52), UINT64_C(0xDD2448CCAA7F0F31),
            UINT64_C(0xEC58D3C7F0FDA7AB), UINT64_C(0x7B6E122DC91BBA4D) } },
        { { UINT64_C(0x2A2DEDAFB1B48156), UINT64_C(0xA0A2C63ABB93DB87),
            UINT64_C(0xC655907808ACD99E), UINT64_C(0x03EA42AFFE4AC331),
            UINT64_C(0x43D2C14AEB180ED6), UINT64_C(0xC2F293DDB1156A1A) },
          { UINT64_C(0x1FAFABF5A9D81249), UINT64_C(0x39ADDEAD9A8EEE87),
            UINT64_C(0x21E206F2119E2E92), UINT64_C(0xBC5DCC2ED74DCEB6),
            UINT64_C(0x86647FA30A73A358), UINT64_C(0xEAD8BEA42F53F642) } },
        { { UINT64_C(0x636225F591C09091), UINT64_C(0xCCF5070A71BDCFDF),
            UINT64_C(0x0EF8D625B9668EE2), UINT64_C(0x57BDF6CDB5E04E4F),
            UINT64_C(0xFC6AB0A67C75EA43), UINT64_C(0xEB6B8AFBF7FD6EF3) },
          { UINT64_C(0x5B2AEEF02A3DF404), UINT64_C(0x31FD3B48B9823197),
            UINT64_C(0x56226DB683A7EB23), UINT64_C(0x3772C21E5BB1ED2F),
            UINT64_C(0x3E833624CD1ABA6A), UINT64_C(0xBAE58FFAAC672DAD) } },
        { { UINT64_C(0xCE92224D31BA1705), UINT64_C(0x022C6ED2F0197F63),
            UINT64_C(0x21F18D99A4DC1113), UINT64_C(0x5CD04DE803616BF1),
            UINT64_C(0x6F9006799FF12E08), UINT64_C(0xF59A331548E61DDF) },
          { UINT64_C(0x9474D42CB51BD024), UINT64_C(0x11A0A4139051E49D),
            UINT64_C(0x79C92705DCE70EDB), UINT64_C(0x113CE27834198426),
            UINT64_C(0x8978396FEA8616D2), UINT64_C(0x9A2A14D0EA894C36) } },
        { { UINT64_C(0x4F1E1254604F6E4A), UINT64_C(0x4513B0880187D585),
            UINT64_C(0x9022F25719E0F482), UINT64_C(0x51FB2A80E2239DBF),
            UINT64_C(0x49940D9E998ED9D5), UINT64_C(0x0583D2416C932C5D) },
          { UINT64_C(0x1188CEC8F25B73F7), UINT64_C(0xA28788CB3B3D06CD),
            UINT64_C(0xDEA194ECA083DB5A), UINT64_C(0xD93A4F7E22DF4272),
            UINT64_C(0x8D84E4BF6A009C49), UINT64_C(0x893D8DD93E3E4A9E) } },
        { { UINT64_C(0x35E909EA33D31160), UINT64_C(0x5020316857172F1E),
            UINT64_C(0x2707FC4451F3D866), UINT64_C(0xEB9D2018D2442A5D),
            UINT64_C(0x904D72095DBFE378), UINT64_C(0x6DB132A35F13CF77) },
          { UINT64_C(0x9D842BA67A3AF54B), UINT64_C(0x4E16EA195AA5B4F9),
            UINT64_C(0x2BBA457CAF24228E), UINT64_C(0xCC04B3BB16F3C5FE),
            UINT64_C(0xBAFAC51677E64944), UINT64_C(0x31580A34F08BCEE0) } },
        { { UINT64_C(0xC6808DEE20C30ACA), UINT64_C(0xDADD216FA3EA2056),
            UINT64_C(0xD331394E7A4A9F9D), UINT64_C(0x9E0441AD424C4026),
            UINT64_C(0xAEED102F0AEB5350), UINT64_C(0xC6697FBBD45B09DA) },
          { UINT64_C(0x52A2590EDEAC1496), UINT64_C(0x7142B831250B87AF),
            UINT64_C(0xBEF2E68B6D0784A8), UINT64_C(0x5F62593AA5F71CEF),
            UINT64_C(0x3B8F7616B5DA51A3), UINT64_C(0xC7A6FA0DB680F5FE) } },
        { { UINT64_C(0x36C21DE699C8227C), UINT64_C(0xBEE3E867C26813B1),
            UINT64_C(0x9B05F2E6BDD91549), UINT64_C(0x34FF2B1FA7D1110F),
            UINT64_C(0x8E6953B937F67FD0), UINT64_C(0x56C7F18BC3183E20) },
          { UINT64_C(0x48AF46DE9E2019ED), UINT64_C(0xDEAF972EF551BBBF),
            UINT64_C(0x88EE38F8CC5E3EEF), UINT64_C(0xFB8D7A44392D6BAF),
            UINT64_C(0x32293BFC0127187D), UINT64_C(0x7689E767E58647CC) } },
        { { UINT64_C(0x00CE901B52168013), UINT64_C(0xC6BF8E38837AAE71),
            UINT64_C(0xD6F11EFA167677D8), UINT64_C(0xE53BB48586C8E5CF),
            UINT64_C(0x671167CEC48E74AB), UINT64_C(0x8A40218C8AD720A7) },
          { UINT64_C(0x81E827A6E7C1191A), UINT64_C(0x54058F8DADDB153D),
            UINT64_C(0x0BAF29250D950FA2), UINT64_C(0xC244674D576DDA13),
            UINT64_C(0x8C4630AE41BCD13B), UINT64_C(0x6C2127BF5A077419) } },
        { { UINT64_C(0xCF977FD5A83C501F), UINT64_C(0xD7C6DF36B6AB176F),
            UINT64_C(0x117F6331397BC6B5), UINT64_C(0x72A6078BF7A2D491),
            UINT64_C(0xE5A2AAED5242FE2E), UINT64_C(0x88ECFFDCFEBDC212) },
          { UINT64_C(0xF2DBBF50CE33BA21), UINT64_C(0xE1343B76CEB19F07),
            UINT64_C(0x1F32D4C9D2C28F71), UINT64_C(0x93FC64B418587685),
            UINT64_C(0x39CEEF9BBA1F8BD1), UINT64_C(0x99C36A788D6D6BB0) } },
        { { UINT64_C(0x0D0638173E9561CF), UINT64_C(0x1D8646AA3D33704D),
            UINT64_C(0x8C4513847A08BA33), UINT64_C(0x96446BD3E02D6624),
            UINT64_C(0x749849F02D6F4166), UINT64_C(0xE364DA0114268BF0) },
          { UINT64_C(0x7CE4587E9AEBFCFD), UINT64_C(0xD468606456234393),
            UINT64_C(0x00231D5116DF73B2), UINT64_C(0xF6A969B77279C78C),
            UINT64_C(0x1FF1F6B66CB4117C), UINT64_C(0x30AEBC39D3EAB680) } },
        { { UINT64_C(0x5CC97E6493EF00B9), UINT64_C(0xDAE13841972345AE),
            UINT64_C(0x858391844788F43C), UINT64_C(0xD0FF521EE2E6CF3E),
            UINT64_C(0xAED14A5B4B707C86), UINT64_C(0x7EAAE4A6D2523CF7) },
          { UINT64_C(0x266472C5024C8AC6), UINT64_C(0xE47E1522C0170051),
            UINT64_C(0x7B83DA6173826BAE), UINT64_C(0xE97E19F5CF543F0D),
            UINT64_C(0x5D5248FA20BF38E2), UINT64_C(0x8A7C2F7DDF56A037) } },
        { { UINT64_C(0xB04659DD87B0526C), UINT64_C(0x593C604A2307565E),
            UINT64_C(0x49E522257C630AB8), UINT64_C(0x24C1D0C6DCE9CD23),
            UINT64_C(0x6FDB241C85177079), UINT64_C(0x5F521D19F250C351) },
          { UINT64_C(0xFB56134BA6FB61DF), UINT64_C(0xA4E70D69D75C07ED),
            UINT64_C(0xB7A824487D8825A8), UINT64_C(0xA3AEA7D4DD64BBCC),
            UINT64_C(0xD53E6E6C8692F539), UINT64_C(0x8DDDA83BF7AA4BC0) } },
    },
    {
        { { UINT64_C(0x140A0F9FDD93D50A), UINT64_C(0x4799FFDE83B7ABAC),
            UINT64_C(0x78FF7C2304A1F742), UINT64_C(0xC0568F51195BA34E),
            UINT64_C(0xE97183603B7F78B4), UINT64_C(0x9CFD1FF1F9EFAA53) },
          { UINT64_C(0xE924D2C5BB06022E), UINT64_C(0x9987FA86FAA2AF6D),
            UINT64_C(0x4B12E73F6EE37E0F), UINT64_C(0x1836FDFA5E5A1DDE),
            UINT64_C(0x7F1B92259DCD6416), UINT64_C(0xCB2C1B4D677544D8) } },
        { { UINT64_C(0x0254486D9C213D95), UINT64_C(0x68A9DB56CB2F6E94),
            UINT64_C(0xFB5858BA000F5491), UINT64_C(0x1315BDD934009FB6),
            UINT64_C(0xB18A8E0AC42BDE30), UINT64_C(0xFDCF93D1F1070358) },
          { UINT64_C(0xBEB1DB753022937E), UINT64_C(0x9B9ECA7ACAC20DB4),
            UINT64_C(0x152214D4E4122B20), UINT64_C(0xD3E673F2AABCCC7B),
            UINT64_C(0x94C50F64AED07571), UINT64_C(0xD767059AE66B4F17) } },
        { { UINT64_C(0x40336B12DCD6D14B), UINT64_C(0xF6BCFF5DE3B4919C),
            UINT64_C(0xC337048D9C841F0C), UINT64_C(0x4CE6D0251D617F50),
            UINT64_C(0x00FEF2198117D379), UINT64_C(0x18B7C4E9F95BE243) },
          { UINT64_C(0x98DE119E38DF08FF), UINT64_C(0xDFD803BD8D772D20),
            UINT64_C(0x94125B720F9678BD), UINT64_C(0xFC5B57CD334ACE30),
            UINT64_C(0x09486527B7E86E04), UINT64_C(0xFE9F8BCC6E552039) } },
        { { UINT64_C(0x3B75C45BD6F5A10E), UINT64_C(0xFD4680F4C1C35F38),
            UINT64_C(0x5450227DF8E0A113), UINT64_C(0x5E69F1AE73DDBA24),
            UINT64_C(0x2007B80E57F24645), UINT64_C(0xC63695DC3D159741) },
          { UINT64_C(0xCBE54D294530F623), UINT64_C(0x986AD5732869586B),
            UINT64_C(0xE19F70594CC39F73), UINT64_C(0x80F00AB32B1B8DA9),
            UINT64_C(0xB765AAF973F68D26), UINT64_C(0xBC79A394E993F829) } },
        { { UINT64_C(0x9C441043F310D2A0), UINT64_C(0x2865EE58DC5EB106),
            UINT64_C(0x71A959229CB8065C), UINT64_C(0x8EB3A733A052AF0F),
            UINT64_C(0x56009F42B09D716E), UINT64_C(0xA7F923C5ABCBE6AD) },
          { UINT64_C(0x263B7669FA375C01), UINT64_C(0x641C47E521EF27A2),
            UINT64_C(0xA89B474EB08FFD25), UINT64_C(0x5BE8EC3FF0A239F3),
            UINT64_C(0x0E79957A242A6C5A), UINT64_C(0x1DFB26D00C6C75F5) } },
        { { UINT64_C(0x2FD97B9B9DFBF22A), UINT64_C(0xDEC16CC85643532D),
            UINT64_C(0xDF0E6E3960FEE7C3), UINT64_C(0xD09AD7B6545860C8),
            UINT64_C(0xCC16E98473FC3B7C), UINT64_C(0x6CE734C10D4E1555) },
          { UINT64_C(0xC6EFE68B4B5F6032), UINT64_C(0x3A64F34C14F54073),
            UINT64_C(0x25DA689CAC44DC95), UINT64_C(0x990C477E5358AD8A),
            UINT64_C(0x00E958A5F36DA7DE), UINT64_C(0x902B7360C9B6F161) } },
        { { UINT64_C(0x454AB42C9347B90A), UINT64_C(0xCAEBE64AA698B02B),
            UINT64_C(0x119CDC69FB86FA40), UINT64_C(0x2E5CB7ADC3109281),
            UINT64_C(0x67BB1EC5CD0C3D00), UINT64_C(0x5D430BC783F25BBF) },
          { UINT64_C(0x69FD84A85CDE0ABB), UINT64_C(0x69DA263E9816B688),
            UINT64_C(0xE52D93DF0E53CBB8), UINT64_C(0x42CF6F25ADD2D5A7),
            UINT64_C(0x227BA59DC87CA88F), UINT64_C(0x7A1CA876DA738554) } },
        { { UINT64_C(0x3FA5C1051CAC82C4), UINT64_C(0x23C760878A78C9BE),
            UINT64_C(0xE98CDAD61C5CFA42), UINT64_C(0x09C302520A6C0421),
            UINT64_C(0x149BAC7C42FC61B9), UINT64_C(0x3A1C22AC3004A3E2) },
          { UINT64_C(0xDE6B0D6E202C7FED), UINT64_C(0xB2457377E7E63052),
            UINT64_C(0x31725FD43706B3EF), UINT64_C(0xE16A347D2B1AFDBF),
            UINT64_C(0xBE4850C48C29CF66), UINT64_C(0x8F51CC4D2939F23C) } },
        { { UINT64_C(0x169E025B219AE6C1), UINT64_C(0x55FF526F116E1CA1),
            UINT64_C(0x01B810A3B191F55D), UINT64_C(0x2D98127229588A69),
            UINT64_C(0x53C9377048B92199), UINT64_C(0x8C7DD84E8A85236F) },
          { UINT64_C(0x293D48B6CAACF958), UINT64_C(0x1F084ACB43572B30),
            UINT64_C(0x628BFA2DFAD91F28), UINT64_C(0x8D627B11829386AF),
            UINT64_C(0x3EC1DD00D44A77BE), UINT64_C(0x8D3B0D08649AC7F0) } },
        { { UINT64_C(0x00A93DAA177513BF), UINT64_C(0x2EF0B96F42AD79E1),
            UINT64_C(0x81F5AAF1A07129D9), UINT64_C(0xFC04B7EF923F2449),
            UINT64_C(0x855DA79560CDB1B7), UINT64_C(0xB1EB5DABAD5D61D4) },
          { UINT64_C(0xD2CEF1AE353FD028), UINT64_C(0xC21D54399EE94847),
            UINT64_C(0x9ED552BB0380C1A8), UINT64_C(0xB156FE7A2BAC328F),
            UINT64_C(0xBB7E01967213C6A4), UINT64_C(0x36002A331701ED5B) } },
        { { UINT64_C(0x20B1632ADDC9EF4D), UINT64_C(0x2A35FF4C272D082B),
            UINT64_C(0x30D39923F6CC9BD3), UINT64_C(0x6D879BC2E65C9D08),
            UINT64_C(0xCE8274E16FA9983C), UINT64_C(0x652371E80EB7424F) },
          { UINT64_C(0x32B77503C5C35282), UINT64_C(0xD7306333C885A931),
            UINT64_C(0x8A16D71972955AA8), UINT64_C(0x5548F1637D51F882),
            UINT64_C(0xB311DC66BABA59EF), UINT64_C(0x773D54480DB8F627) } },
        { { UINT64_C(0x59B1B1347A62EB3B), UINT64_C(0x0F8CE157CCEEFB34),
            UINT64_C(0x3FE842A8A798CB2B), UINT64_C(0xD01BC6260BF4161D),
            UINT64_C(0x55EF6E554D016FDB), UINT64_C(0xCB561503B242B201) },
          { UINT64_C(0x076EBC73AF4199C1), UINT64_C(0x39DEDCBB697244F7),
            UINT64_C(0x9D184733040162BC), UINT64_C(0x902992C17F6B5FA6),
            UINT64_C(0xAD1DE754BB4952B5), UINT64_C(0x7ACF1B93A121F6C8) } },
        { { UINT64_C(0x7A56867C325C9B9A), UINT64_C(0x1A143999F3DC3D6A),
            UINT64_C(0xCE10959003F5BCB8), UINT64_C(0x034E9035D6EEE5B7),
            UINT64_C(0x2AFA81C8495DF1BC), UINT64_C(0x5EAB52DC08924D02) },
          { UINT64_C(0xEE6AA014AA181904), UINT64_C(0xE62DEF09310AD621),
            UINT64_C(0x6C9792FCC7538A03), UINT64_C(0xA89D3E883E41D789),
            UINT64_C(0xD60FA11C9F94AE83), UINT64_C(0x5E16A8C2E0D6234A) } },
        { { UINT64_C(0x87EC053DA9242F3B), UINT64_C(0x99544637F0E03545),
            UINT64_C(0xEA0633FF6B7019E9), UINT64_C(0x8CB8AE0768DDDB5B),
            UINT64_C(0x892E7C841A811AC7), UINT64_C(0xC7EF19EB73664249) },
          { UINT64_C(0xD1B5819ACD1489E3), UINT64_C(0xF9C80FB0DE45D24A),
            UINT64_C(0x045C21A683BB7491), UINT64_C(0xA65325BE73F7A47D),
            UINT64_C(0x08D09F0E9C394F0C), UINT64_C(0xE7FB21C6268D4F08) } },
        { { UINT64_C(0xC4CCAB956CA95C18), UINT64_C(0x563FFD56BC42E040),
            UINT64_C(0xFA3C64D8E701C604), UINT64_C(0xC88D4426B0ABAFEE),
            UINT64_C(0x1A353E5E8542E4C3), UINT64_C(0x9A2D8B7CED726186) },
          { UINT64_C(0xD61CE19042D097FA), UINT64_C(0x6A63E280799A748B),
            UINT64_C(0x0F48D0633225486B), UINT64_C(0x848F8FE142A3C443),
            UINT64_C(0x2CCDE2508493CEF4), UINT64_C(0x5450A50845E77E7C) } },
        { { UINT64_C(0xD0F4E24803112816), UINT64_C(0xFCAD9DDBCCBE9E16),
            UINT64_C(0x177999BF5AE01EA0), UINT64_C(0xD20C78B9CE832DCE),
            UINT64_C(0x3CC694FB50C8C646), UINT64_C(0x24D75968C93D4887) },
          { UINT64_C(0x9F06366A87BC08AF), UINT64_C(0x59FAB50E7FD0DF2A),
            UINT64_C(0x5FFCC7F76C4CC234), UINT64_C(0x87198DD765F52D86),
            UINT64_C(0x5B9C94B0A855DF04), UINT64_C(0xD8BA6C738A067AD7) } },
    },
    {
        { { UINT64_C(0x9E9AF3151C4C9D90), UINT64_C(0x8665C5A9D12E0A89),
            UINT64_C(0x204ABD9258286493), UINT64_C(0x79959889B2E09205),
            UINT64_C(0x0C727A3DFE56B101), UINT64_C(0xF366244C8B657F26) },
          { UINT64_C(0xDE35D954CCA65BE2), UINT64_C(0x52EE1230B0FD41CE),
            UINT64_C(0xFA03261F36019FEE), UINT64_C(0xAFDA42D966511D8F),
            UINT64_C(0xF63211DD821148B9), UINT64_C(0x7B56AF7E6F13A3E1) } },
        { { UINT64_C(0x47FE47995913E184), UINT64_C(0x5BBE584C82145900),
            UINT64_C(0xB76CFA8B9A867173), UINT64_C(0x9BC87BF0514BF471),
            UINT64_C(0x37392DCE71DCF1FC), UINT64_C(0xEC3EFAE03AD1EFA8) },
          { UINT64_C(0xBBEA5A3414876451), UINT64_C(0x96E5F5436217090F),
            UINT64_C(0x5B3D4ECD9B1665A9), UINT64_C(0xE7B0DF26E329DF22),
            UINT64_C(0x18FB438E0BAA808D), UINT64_C(0x90757EBFDD516FAF) } },
        { { UINT64_C(0x1E6F9A95D5A98D68), UINT64_C(0x759EA7DF849DA828),
            UINT64_C(0x365D56256E8B4198), UINT64_C(0xE1B9C53B7A4A53F9),
            UINT64_C(0x55DC1D50E32B9B16), UINT64_C(0xA4657EBBBB6D5701) },
          { UINT64_C(0x4C270249EACC76E2), UINT64_C(0xBE49EC75162B1CC7),
            UINT64_C(0x19A95B610689902B), UINT64_C(0xDD5706BFA4CFC5A8),
            UINT64_C(0xD33BDB7314E5B424), UINT64_C(0x21311BD1E69EBA87) } },
        { { UINT64_C(0x75BA2F9B72A21ACC), UINT64_C(0x356688D4A28EDB4C),
            UINT64_C(0x3C339E0B610D080F), UINT64_C(0x614AC29333A99C2F),
            UINT64_C(0xA5E23AF2AA580AFF), UINT64_C(0xA6BCB860E1FDBA3A) },
          { UINT64_C(0xAA603365B43F9425), UINT64_C(0xAE8D7126F7EE4635),
            UINT64_C(0xA2B2524456330A32), UINT64_C(0xC396B5BB9E025AA3),
            UINT64_C(0xABBF77FAF8A0D5CF), UINT64_C(0xB322EE30EA31C83B) } },
        { { UINT64_C(0x048813847890E234), UINT64_C(0x387F1159672E70C6),
            UINT64_C(0x1468A6147B307F75), UINT64_C(0x56335B52ED85EC96),
            UINT64_C(0xDA1BB60FD45BCAE9), UINT64_C(0x4D94F3F0F9FAEADD) },
          { UINT64_C(0x6C6A7183FC78D86B), UINT64_C(0xA425B5C73018DEC6),
            UINT64_C(0xB1549C332D877399), UINT64_C(0x6C41C50C92B2BC37),
            UINT64_C(0x3A9F380C83EE0DDB), UINT64_C(0xDED5FEB6C4599E73) } },
        { { UINT64_C(0x14D34C210B7F8354), UINT64_C(0x1475A1CD9177CE45),
            UINT64_C(0x9F5F764A9B926E4B), UINT64_C(0x77260D1E05DD21FE),
            UINT64_C(0x3C882480C4B937F7), UINT64_C(0xC92DCD39722372F2) },
          { UINT64_C(0xF636A1BEEC6F657E), UINT64_C(0xB0E6C3121D30DD35),
            UINT64_C(0xFE4B0528E4654EFE), UINT64_C(0x1C4A682021D230D2),
            UINT64_C(0x615D2E4898FA45AB), UINT64_C(0x1F35D6D801FDBABF) } },
        { { UINT64_C(0xA636EEB83A7B10D1), UINT64_C(0x4E1AE352F4A29E73),
            UINT64_C(0x01704F5FE6BB1EC7), UINT64_C(0x75C04F720EF020AE),
            UINT64_C(0x448D8CEE5A31E6A6), UINT64_C(0xE40A9C29208F994B) },
          { UINT64_C(0x69E09A30FD8F9D5D), UINT64_C(0xE6A5F7EB449BAB7E),
            UINT64_C(0xF25BC18A2AA1768B), UINT64_C(0x9449E4043C841234),
            UINT64_C(0x7A3BF43E016A7BEF), UINT64_C(0xF25803E82A150B60) } },
        { { UINT64_C(0xE44A2A57B215F9E0), UINT64_C(0x38B34DCE19066F0A),
            UINT64_C(0x8BB91DAD40BB1BFB), UINT64_C(0x64C9F775E67735FC),
            UINT64_C(0xDE14241788D613CD), UINT64_C(0xC5014FF51901D88D) },
          { UINT64_C(0xA250341DF38116B0), UINT64_C(0xF96B9DD49D6CBCB2),
            UINT64_C(0x15EC6C7276B3FAC2), UINT64_C(0x88F1952F8124C1E9),
            UINT64_C(0x6B72F8EA975BE4F5), UINT64_C(0x23D288FF061F7530) } },
        { { UINT64_C(0xEBFE3E5FAFB96CE3), UINT64_C(0x2275EDFBB1979537),
            UINT64_C(0xC37AB9E8C97BA741), UINT64_C(0x446E4B1063D7C626),
            UINT64_C(0xB73E2DCED025EB02), UINT64_C(0x1F952B517669EEA7) },
          { UINT64_C(0xABDD00F66069A424), UINT64_C(0x1C0F9D9BDC298BFB),
            UINT64_C(0x831B1FD3EB757B33), UINT64_C(0xD7DBE18359D60B32),
            UINT64_C(0x663D1F369EF094B3), UINT64_C(0x1BD5732E67F7F11A) } },
        { { UINT64_C(0x3C7FB3F5C75D8892), UINT64_C(0x2CFF9A0CBA68DA69),
            UINT64_C(0x76455E8B60EC740B), UINT64_C(0x4B8D67FF167B88F0),
            UINT64_C(0xEDEC0C025A4186B1), UINT64_C(0x127C462DBEBF35AB) },
          { UINT64_C(0x9159C67E049430FC), UINT64_C(0x86B21DD2E7747320),
            UINT64_C(0x0E0E01520CF27B89), UINT64_C(0x705F28F5CD1316B6),
            UINT64_C(0x76751691BEAEA8A8), UINT64_C(0x4C73E282360C5B69) } },
        { { UINT64_C(0x46BCC0D5FD7B3D74), UINT64_C(0x6F13C20E0DC4F410),
            UINT64_C(0x98A1AF7D72F11CDF), UINT64_C(0x6099FD837928881C),
            UINT64_C(0x66976356371BB94B), UINT64_C(0x673FBA7219B945AB) },
          { UINT64_C(0xE4D8FA6EAED00700), UINT64_C(0xEA2313EC5C71A9F7),
            UINT64_C(0xF9ED8268F99D4AEA), UINT64_C(0xADD8916442AB59C7),
            UINT64_C(0xB37EB26F3F3A2D45), UINT64_C(0x0B39BD7AA924841E) } },
        { { UINT64_C(0xD811EB32E03CDBBB), UINT64_C(0x12055F1D7CC3610E),
            UINT64_C(0x6B23A1A0A9046E3F), UINT64_C(0x4D7121229DD4A749),
            UINT64_C(0xB0C2ACA1B1BF0AC3), UINT64_C(0x71EFF575C1B0432F) },
          { UINT64_C(0x6CD814922B44E285), UINT64_C(0x3088BD9CD87E8D20),
            UINT64_C(0xACE218E5F567E8FA), UINT64_C(0xB3FA0424CF90CBBB),
            UINT64_C(0xADBDA751770734D3), UINT64_C(0xBCD78BAD5AD6569A) } },
        { { UINT64_C(0xCADB31FA7F39641F), UINT64_C(0x3EF3E295825E5562),
            UINT64_C(0x4893C633F4094C64), UINT64_C(0x52F685F18ADDF432),
            UINT64_C(0x9FD887AB7FDC9373), UINT64_C(0x47A9ADA0E8680E8B) },
          { UINT64_C(0x579313B7F0CD44F6), UINT64_C(0xAC4B8668E188AE2E),
            UINT64_C(0x648F43698FB145BD), UINT64_C(0xE0460AB374629E31),
            UINT64_C(0xC25F28758FF2B05F), UINT64_C(0x4720C2B62D31EAEA) } },
        { { UINT64_C(0x4603CDF413D48F80), UINT64_C(0x9ADB50E2A49725DA),
            UINT64_C(0x8CD3305065DF63F0), UINT64_C(0x58D8B3BBCD643003),
            UINT64_C(0x170A4F4AB739826B), UINT64_C(0x857772B51EAD0E17) },
          { UINT64_C(0x01B78152E65320F1), UINT64_C(0xA6B4D845B7503FC0),
            UINT64_C(0x0F5089B93DD50798), UINT64_C(0x488F200F5690B6BE),
            UINT64_C(0x220B4ADF9E096F36), UINT64_C(0x474D7C9F8CE5BC7C) } },
        { { UINT64_C(0xFED8C058C745F8C9), UINT64_C(0xB683179E291262D1),
            UINT64_C(0x26ABD367D15EE88C), UINT64_C(0x29E8EED3F60A6249),
            UINT64_C(0xED6008BB1E02D6E1), UINT64_C(0xD82ECF4CA6B12B8D) },
          { UINT64_C(0x9929D021AAE4FA22), UINT64_C(0xBE4DEF14336A1AB3),
            UINT64_C(0x529B7E098C80A312), UINT64_C(0xB059188DEE0EB0CE),
            UINT64_C(0x1E42979A16DEAB7F), UINT64_C(0x2411034984EE9477) } },
        { { UINT64_C(0xD65246852BE579CC), UINT64_C(0x849316F1C456FDED),
            UINT64_C(0xC51B7DA42D1B67DA), UINT64_C(0xC25B539E41BC6D6A),
            UINT64_C(0xE3B7CCA3A9BF8BED), UINT64_C(0x813EF18C045C15E4) },
          { UINT64_C(0x5F3789A1697982C4), UINT64_C(0x4C1253698C435566),
            UINT64_C(0x00A7AE6EDC0A92C6), UINT64_C(0x1ABC929B2F64A053),
            UINT64_C(0xF4925C4C38666B44), UINT64_C(0xA81044B00F3DE7F6) } },
    },
    {
        { { UINT64_C(0xBCC88422C2EC3731), UINT64_C(0x78A3E4D410DC4EC2),
            UINT64_C(0x745DA1EF2571D6B1), UINT64_C(0xF01C2921739A956E),
            UINT64_C(0xEFFD8065E4BFFC16), UINT64_C(0x6EFE62A1F36FE72C) },
          { UINT64_C(0xF49E90D20F4629A4), UINT64_C(0xADD1DCC78CE646F4),
            UINT64_C(0xCB78B583B7240D91), UINT64_C(0x2E1A7C3C03F8387F),
            UINT64_C(0x16566C223200F2D9), UINT64_C(0x2361B14BAAF80A84) } },
        { { UINT64_C(0xDB1CFFD2B5733309), UINT64_C(0x24BC250B0F9DD939),
            UINT64_C(0xA4181E5AA3C1DB85), UINT64_C(0xE5183E51AC55D391),
            UINT64_C(0x2793D5EFEFD270D0), UINT64_C(0x7D56F63DC0631546) },
          { UINT64_C(0xECB40A590C1EE59D), UINT64_C(0xE613A9E4BB5BFA2C),
            UINT64_C(0xA89B14AB6C5830F9), UINT64_C(0x4DC477DCA03F201E),
            UINT64_C(0x5604F5DAC88C54F6), UINT64_C(0xD49264DC2ACFC66E) } },
        { { UINT64_C(0x283DD7F01C4DFA95), UINT64_C(0xB898CC2C62C0B160),
            UINT64_C(0xBA08C095870282AA), UINT64_C(0xB02B00D8F4E36324),
            UINT64_C(0x53AADDC0604CECF2), UINT64_C(0xF1F927D384DDD24E) },
          { UINT64_C(0x34BC00A0E2ABC9E1), UINT64_C(0x2DA1227D60289F88),
            UINT64_C(0x5228EAAACEF68F74), UINT64_C(0x40A790D23C029351),
            UINT64_C(0xE0E9AF5C8442E3B7), UINT64_C(0xA3214142A9F141E0) } },
        { { UINT64_C(0x72F4949EF9A58E3D), UINT64_C(0x738C700BA48660A6),
            UINT64_C(0x71B04726092A5805), UINT64_C(0xAD5C3C110F5CDB72),
            UINT64_C(0xD4951F9E554BFC49), UINT64_C(0xEE594EE56131EBE7) },
          { UINT64_C(0x37DA59F33C1AF0A9), UINT64_C(0xD7AFC73BCB040A63),
            UINT64_C(0xD020962A4D89FA65), UINT64_C(0x2610C61E71D824F5),
            UINT64_C(0x9C917DA73C050E31), UINT64_C(0x3840F92FE6E7EBFB) } },
        { { UINT64_C(0x50FBD7FE8D8B8CED), UINT64_C(0xC7282F7547D240AE),
            UINT64_C(0x79646A471930FF73), UINT64_C(0x2E0BAC4E2F7F5A77),
            UINT64_C(0x0EE44FA526127E0B), UINT64_C(0x678881B782BC2AA7) },
          { UINT64_C(0xB9E5D38467F5F497), UINT64_C(0x8F94A7D4A9B7106B),
            UINT64_C(0xBF7E0B079D329F68), UINT64_C(0x169B93EA45D192FB),
            UINT64_C(0xCCAA946720DBE8C0), UINT64_C(0xD4513A50938F9574) } },
        { { UINT64_C(0x841C96B4054CB874), UINT64_C(0xD75B1AF1A3C26834),
            UINT64_C(0x7237169DEE6575F0), UINT64_C(0xD71FC7E50322AADC),
            UINT64_C(0xD7A23F1E949E3A8E), UINT64_C(0x77E2D102DD31D8C7) },
          { UINT64_C(0x5AD69D09D10F5A1F), UINT64_C(0x526C9CB4B99D9A0B),
            UINT64_C(0x521BB10B972B237D), UINT64_C(0x1E4CD42FA326F342),
            UINT64_C(0x5BB6DB27F0F126CA), UINT64_C(0x587AF22CA4A515AD) } },
        { { UINT64_C(0x1123A531B12E542F), UINT64_C(0x1D01A64DB9EB2811),
            UINT64_C(0xA4A3515BF2D70F87), UINT64_C(0xFA205234B4BD0270),
            UINT64_C(0x74B818305EDA26B9), UINT64_C(0x9305D6E656578E75) },
          { UINT64_C(0xF38E69DE9F11BE19), UINT64_C(0x1E2A5C2344DBE89F),
            UINT64_C(0x1077E7BCFD286654), UINT64_C(0xD36698940FCA4741),
            UINT64_C(0x893BF904278F8497), UINT64_C(0xD6AC5F83EB3E14F4) } },
        { { UINT64_C(0x327B9DAB488F5F74), UINT64_C(0x2B44F4B8CAB7364F),
            UINT64_C(0xB4A6D22D19B6C6BD), UINT64_C(0xA087E613FC77CD3E),
            UINT64_C(0x4558E327B0B49BC7), UINT64_C(0x188805BECD835D35) },
          { UINT64_C(0x592F293CC1DC1007), UINT64_C(0xFAEE660F6AF02B44),
            UINT64_C(0x5BFBB3BF904035F2), UINT64_C(0xD7C9AE6079C07E70),
            UINT64_C(0xC5287DD4234896C2), UINT64_C(0xC4CE4523CB0E4121) } },
        { { UINT64_C(0x3626B40658344831), UINT64_C(0xABCCE3568E55C984),
            UINT64_C(0x495CC81C77241602), UINT64_C(0x4FB796766D70DF8F),
            UINT64_C(0x6354B37C5B071DCA), UINT64_C(0x2CAD80A48C0FC0AD) },
          { UINT64_C(0x18AADD51F68739B4), UINT64_C(0x1BFBB17747F09C6C),
            UINT64_C(0x9355EA19A8FD51C4), UINT64_C(0x3D512A84EE58DB7B),
            UINT64_C(0x70842AFDE9237640), UINT64_C(0x36F515CAACAF858D) } },
        { { UINT64_C(0x3DDEC7C47E768B23), UINT64_C(0x97E13C53036D43ED),
            UINT64_C(0x871E59253A39AB5F), UINT64_C(0x9AF292DE07E68E2B),
            UINT64_C(0x411583494A40112E), UINT64_C(0xCDBB46AF3D4D97E6) },
          { UINT64_C(0x2F8912933C0EBE40), UINT64_C(0x696C7EEE3EBAD1E5),
            UINT64_C(0x8A5F3B6933B50D99), UINT64_C(0xB7BC48407ED47DDE),
            UINT64_C(0x3A6F8E6C1E6706D8), UINT64_C(0x6A1479433D84BB8F) } },
        { { UINT64_C(0xEC3A9C78603AE8D1), UINT64_C(0xBFE07E37228C29E5),
            UINT64_C(0xB0385C5B396DBC2B), UINT64_C(0x7C14FE83DF85F41F),
            UINT64_C(0xE2E64676ADFD463E), UINT64_C(0x5BEF10AA8BF9F23D) },
          { UINT64_C(0xFA83EA0DF6BAB6DA), UINT64_C(0xCD0C8BA5966BF7E3),
            UINT64_C(0xD62216B498501C2E), UINT64_C(0xB7F298A4C3E69F2D),
            UINT64_C(0x42CEF13B9C8740F4), UINT64_C(0xBB317E520DD64307) } },
        { { UINT64_C(0x22B6245C3FFEE775), UINT64_C(0x5C3F60BEB37CE7AA),
            UINT64_C(0xDE195D40E1FEC0DF), UINT64_C(0x3BFAFBC5A0A82074),
            UINT64_C(0xC36EC86AC72CA86A), UINT64_C(0x5606285113FD43EA) },
          { UINT64_C(0x8686BE808E0B03A4), UINT64_C(0xC3BD1F93D540D440),
            UINT64_C(0x13E4EBC0BF96CEC5), UINT64_C(0xE8E239849190C844),
            UINT64_C(0x183593A600844802), UINT64_C(0x467168794D206878) } },
        { { UINT64_C(0x358F394DB6F63D19), UINT64_C(0xA75D48496B052194),
            UINT64_C(0x584035905C8D7975), UINT64_C(0x86DC9B6B6CBFBD77),
            UINT64_C(0x2DB04D77647A51E5), UINT64_C(0x5E9A5B02F8950D88) },
          { UINT64_C(0xCE69A7E5017168B0), UINT64_C(0x94630FACC4843AD3),
            UINT64_C(0xB3B9D7361EFC44FF), UINT64_C(0xE729E9B6B14D7F93),
            UINT64_C(0xA071FC60E0ED0ABC), UINT64_C(0xFC1A99718C8D9B83) } },
        { { UINT64_C(0x49686031D138E975), UINT64_C(0x648640385A8EF0D1),
            UINT64_C(0x32679713E7F7DE49), UINT64_C(0x5913234929D1CD1D),
            UINT64_C(0x849AA23A20BE9ED2), UINT64_C(0x15D303E1284B3F33) },
          { UINT64_C(0x37309475B63F9FE9), UINT64_C(0x327BAC8B45B7256A),
            UINT64_C(0x291CD227D17FC5D3), UINT64_C(0x8291D8CDA973EDF1),
            UINT64_C(0xF3843562437ABA09), UINT64_C(0x33FFB704271D0785) } },
        { { UINT64_C(0x5248D6E447E11E5E), UINT64_C(0x0F66FC3C269C7ED3),
            UINT64_C(0x18C0D2B9903E346E), UINT64_C(0xD81D9D974BEAE1B8),
            UINT64_C(0x610326B0FC30FDF3), UINT64_C(0x2B13687019A7DFCD) },
          { UINT64_C(0xEC75F70AB9527676), UINT64_C(0x90829F5129A3D897),
            UINT64_C(0x92FE180997980302), UINT64_C(0xA3F2498E68474991),
            UINT64_C(0x6A66307B0F22BBAD), UINT64_C(0x32014B9120378557) } },
        { { UINT64_C(0x72CD7D553CD98610), UINT64_C(0xC3D560B074504ADF),
            UINT64_C(0x23F0A982CEBB5D5D), UINT64_C(0x1431C15BB839DDB8),
            UINT64_C(0x7E207CD8CEB72207), UINT64_C(0x28E0A848E7EFB28D) },
          { UINT64_C(0xD22561FE1BD96F6E), UINT64_C(0x04812C1862A8236B),
            UINT64_C(0xA0BF2334975491FA), UINT64_C(0x294F42A6435DF87F),
            UINT64_C(0x2772B783A5D6F4F6), UINT64_C(0x348F92ED2724F853) } },
    },
    {
        { { UINT64_C(0xC20FB9111A42E5E7), UINT64_C(0x075A678B81D12863),
            UINT64_C(0x12BCBC6A5CC0AA89), UINT64_C(0x5279C6AB4FB9F01E),
            UINT64_C(0xBC8E178911AE1B89), UINT64_C(0xAE74A706C290003C) },
          { UINT64_C(0x9949D6EC79DF3F45), UINT64_C(0xBA18E26296C8D37F),
            UINT64_C(0x68DE6EE2DD2275BF), UINT64_C(0xA9E4FFF8C419F1D5),
            UINT64_C(0xBC759CA4A52B5A40), UINT64_C(0xFF18CBD863B0996D) } },
        { { UINT64_C(0x73C57FDED7DD47E5), UINT64_C(0xB0FE5479D49A7F5D),
            UINT64_C(0xD25C71F1CFB9821E), UINT64_C(0x9427E209CF6A1D68),
            UINT64_C(0xBF3C3916ACD24E64), UINT64_C(0x7E9F5583BDA7B8B5) },
          { UINT64_C(0xE7C5F7C8CF971E11), UINT64_C(0xEC16D5D73C7F035E),
            UINT64_C(0x818DC472E66B277C), UINT64_C(0x4413FD47B2816F1E),
            UINT64_C(0x40F262AF48383C6D), UINT64_C(0xFB0575844F190537) } },
        { { UINT64_C(0x487EDC0708962F6B), UINT64_C(0x6002F1E7190A7E55),
            UINT64_C(0x7FC62BEA10FDBA0C), UINT64_C(0xC836BBC52C3DBF33),
            UINT64_C(0x4FDFB5C34F7D2A46), UINT64_C(0x824654DEDCA0DF71) },
          { UINT64_C(0x30A076760C23902B), UINT64_C(0x7F1EBB9377FBBF37),
            UINT64_C(0xD307D49DFACC13DB), UINT64_C(0x148D673AAE1A261A),
            UINT64_C(0xE008F95B52D98650), UINT64_C(0xC76144409F558FDE) } },
        { { UINT64_C(0x17CD6AF69CB16650), UINT64_C(0x86CC27C169F4EEBE),
            UINT64_C(0x7E495B1D78822432), UINT64_C(0xFED338E31B974525),
            UINT64_C(0x527743D386F3CE21), UINT64_C(0x87948AD3B515C896) },
          { UINT64_C(0x9FDE7039B17F2FB8), UINT64_C(0xA2FA9A5FD9B89D96),
            UINT64_C(0x5D46600B36FF74DC), UINT64_C(0x8EA74B048302C3C9),
            UINT64_C(0xD560F570F744B5EB), UINT64_C(0xC921023BFE762402) } },
        { { UINT64_C(0xA35AB657FFF4C8ED), UINT64_C(0x017C61248A5FABD7),
            UINT64_C(0x5646302509ACDA28), UINT64_C(0x6038D36114CF238A),
            UINT64_C(0x1428B1B6AF1B9F07), UINT64_C(0x5827FF447482E95C) },
          { UINT64_C(0xCB997E18780FF362), UINT64_C(0x2B89D702E0BCAC1E),
            UINT64_C(0xC632A0B5A837DDC8), UINT64_C(0xF3EFCF1F59762647),
            UINT64_C(0xE9BA309A38B0D60A), UINT64_C(0x05DEABDD20B5FB37) } },
        { { UINT64_C(0xD44E5DBACB8AF047), UINT64_C(0x15400CB4943CFE82),
            UINT64_C(0xDBD695759DF88B67), UINT64_C(0x8299DB2BB2405A7D),
            UINT64_C(0x46E3BF770B1D80CD), UINT64_C(0xC50CF66CE82BA3D9) },
          { UINT64_C(0xB2910A07F2F747A9), UINT64_C(0xF6B669DB5ADC89C1),
            UINT64_C(0x3B5EF1A09052B081), UINT64_C(0x0F5D5ED3B594ACE2),
            UINT64_C(0xDA30B8D5D5F01320), UINT64_C(0x0D688C5EAAFCD58F) } },
        { { UINT64_C(0x5EEE3A312A161074), UINT64_C(0x6BAAAE56EFE2BE37),
            UINT64_C(0xF9787F61E3D78698), UINT64_C(0xC6836B2650630A30),
            UINT64_C(0x7445B85D1445DEF1), UINT64_C(0xD72016A2D568A6A5) },
          { UINT64_C(0x9DD6F533E355614F), UINT64_C(0x637E7E5F91E04588),
            UINT64_C(0x42E142F3B9FB1391), UINT64_C(0x0D07C05C41AFE5DA),
            UINT64_C(0xD7CD25C81394EDF1), UINT64_C(0xEBE6A0FCB99288EE) } },
        { { UINT64_C(0xB8E63B7BBABBAD86), UINT64_C(0x63226A9F90D66766),
            UINT64_C(0x263818365CF26666), UINT64_C(0xCCBD142D4CADD0BF),
            UINT64_C(0xA070965E9AC29470), UINT64_C(0x6BDCA26025FF23ED) },
          { UINT64_C(0xD4E00FD487DCA7B3), UINT64_C(0xA50978339E0E8734),
            UINT64_C(0xF73F162E048173A4), UINT64_C(0xD23F91969C3C2FA2),
            UINT64_C(0x9AB98B45E4AC397A), UINT64_C(0x2BAA0300543F2D4B) } },
        { { UINT64_C(0xBBBE15E7C658C445), UINT64_C(0xB8CBCB20C28941D1),
            UINT64_C(0x65549BE2027D6540), UINT64_C(0xEBBCA8021E8EF4F4),
            UINT64_C(0x18214B4BD2ACA397), UINT64_C(0xCBEC7DE2E31784A3) },
          { UINT64_C(0x96F0533F0116FDF3), UINT64_C(0x68911C905C8F5EE1),
            UINT64_C(0x7DE9A3AED568603A), UINT64_C(0x3F56C52C6A3AD7B7),
            UINT64_C(0x5BE9AFCA670B4D0E), UINT64_C(0x628BFEEE375DFE2F) } },
        { { UINT64_C(0x97DAE81BDD4ADDB3), UINT64_C(0x12D2CF4E8704761B),
            UINT64_C(0x5E820B403247788D), UINT64_C(0x82234B620051CA80),
            UINT64_C(0x0C62704D6CB5EA74), UINT64_C(0xDE56042023941593) },
          { UINT64_C(0xB3912A3CF1B04145), UINT64_C(0xE3967CD7AF93688D),
            UINT64_C(0x2E2DCD2F58DABB4B), UINT64_C(0x6564836F0E303911),
            UINT64_C(0x1F10F19BECE07C5C), UINT64_C(0xB47F07EED8919126) } },
        { { UINT64_C(0xE3545085E9A2EEC9), UINT64_C(0x81866A972C8E51FE),
            UINT64_C(0xD2BA7DB550027243), UINT64_C(0x29DAEAB54AE87DE4),
            UINT64_C(0x5EF3D4B8684F9497), UINT64_C(0xE2DACE3B9D5D6873) },
          { UINT64_C(0xF012C951FFD29C9C), UINT64_C(0x48289445ADBADA14),
            UINT64_C(0x8751F50D89558C49), UINT64_C(0x75511A4F99E35BEE),
            UINT64_C(0xEF802D6E7D59AA5F), UINT64_C(0x14FCAD65A2A795E2) } },
        { { UINT64_C(0xC8EB00E808CB8F2C), UINT64_C(0x686075322B45BD86),
            UINT64_C(0x7A29B45959969713), UINT64_C(0x5FA15B9BD684201B),
            UINT64_C(0x1A853190B9E538EE), UINT64_C(0x4150605CD573D043) },
          { UINT64_C(0xEF011D3BEB9FBB68), UINT64_C(0x6727998266AE32B6),
            UINT64_C(0x861B86EA445DE5EC), UINT64_C(0x62837D18A34A50E1),
            UINT64_C(0x228C006ABF5F0663), UINT64_C(0xE007FDE7396DB36A) } },
        { { UINT64_C(0xDEE4F8815A916A55), UINT64_C(0x20DC0370F39C82CB),
            UINT64_C(0xD9A7161540F09821), UINT64_C(0xD50AD8BFF7273492),
            UINT64_C(0xA06F7D1232E7C4BF), UINT64_C(0xFA0F61544C5CEA36) },
          { UINT64_C(0xF4FD9BED5FC49CFE), UINT64_C(0xD8CB45D1C9291678),
            UINT64_C(0x94DB86CC7B92C9F2), UINT64_C(0x09CA5F3873C81169),
            UINT64_C(0x109F40B0AEED06F0), UINT64_C(0x9F0360B214DCAA0A) } },
        { { UINT64_C(0x4189B70DE12AD3E7), UINT64_C(0x5208ADB210B06607),
            UINT64_C(0xEBD8E2A2EE8497FA), UINT64_C(0x61B1BD67E04F2ECB),
            UINT64_C(0x0E2DDA724F3F5F99), UINT64_C(0xD5D96740F747B16D) },
          { UINT64_C(0x308A48F6A6BF397F), UINT64_C(0x7021C3E523A93595),
            UINT64_C(0xF10B022936470AA0), UINT64_C(0x7761E8EC4E03295B),
            UINT64_C(0x16EFEF5807339770), UINT64_C(0x0D55D2DD5DA5DAA2) } },
        { { UINT64_C(0x915EA6A38A22F87A), UINT64_C(0x191151C12E5A088E),
            UINT64_C(0x190252F17F1D5CBE), UINT64_C(0xE43F59C33B0EC99B),
            UINT64_C(0xBE8588D4FF2A6135), UINT64_C(0x103877CC2ECB4B9F) },
          { UINT64_C(0x8F4147E5023CF92B), UINT64_C(0xC24384CC0CC2085B),
            UINT64_C(0x6A2DB4A2D082D311), UINT64_C(0x06283811ED7BA9AE),
            UINT64_C(0xE9A3F5322A8E1592), UINT64_C(0xAC20F0F45A59E894) } },
        { { UINT64_C(0x788CAA5274AAB4B1), UINT64_C(0xEB84ABA12FEAFC7E),
            UINT64_C(0x31DA71DAAC04FF77), UINT64_C(0x39D12EB924E4D0BF),
            UINT64_C(0x4F2F292F87A34EF8), UINT64_C(0x9B324372A237A8ED) },
          { UINT64_C(0xBB2D04B12EE3A82D), UINT64_C(0xED4FF367D18D36B2),
            UINT64_C(0x99D231EEA6EA0138), UINT64_C(0x7C2D4F064F92E04A),
            UINT64_C(0x78A82AB2CA272FD0), UINT64_C(0x7EC41340AB8CDC32) } },
    },
    {
        { { UINT64_C(0xD23658C8D2E15A8C), UINT64_C(0x23F93DF716BA28CA),
            UINT64_C(0x6DAB10EC082210F1), UINT64_C(0xFB1ADD91BFC36490),
            UINT64_C(0xEDA8B02F9A4F2D14), UINT64_C(0x9060318C56560443) },
          { UINT64_C(0x6C01479E64711AB2), UINT64_C(0x41446FC7E337EB85),
            UINT64_C(0x4DCF3C1D71888397), UINT64_C(0x87A9C04E13C34FD2),
            UINT64_C(0xFE0E08EC510C15AC), UINT64_C(0xFC0D0413C0F495D2) } },
        { { UINT64_C(0xEB05C516156636C2), UINT64_C(0x2F613ABA090E93FC),
            UINT64_C(0xCFD573CD489576F5), UINT64_C(0xE6535380535A8D57),
            UINT64_C(0x13947314671436C4), UINT64_C(0x1172FB0C5F0A122D) },
          { UINT64_C(0xAECC7EC1C12F58F6), UINT64_C(0xFE42F9578E41AFD2),
            UINT64_C(0xDF96F6523D4221AA), UINT64_C(0xFEF5649F2851996B),
            UINT64_C(0x46FB9F26D5CFB67E), UINT64_C(0xB047BFC7EF5C4052) } },
        { { UINT64_C(0x5CBDC442F4484374), UINT64_C(0x6B156957F92452EF),
            UINT64_C(0x58A26886C118D02A), UINT64_C(0x87FF74E675AAF276),
            UINT64_C(0xB133BE95F65F6EC1), UINT64_C(0xA89B62844B1B8D32) },
          { UINT64_C(0xDD8A8EF309C81004), UINT64_C(0x7F8225DB0CF21991),
            UINT64_C(0xD525A6DB26623FAF), UINT64_C(0xF2368D40BAE15453),
            UINT64_C(0x55D6A84D84F89FC9), UINT64_C(0xAF38358A86021A3E) } },
        { { UINT64_C(0xBD048BDCFF52E280), UINT64_C(0x8A51D0B2526A1795),
            UINT64_C(0x40AAA758A985AC0F), UINT64_C(0x6039BCDCF2C7ACE9),
            UINT64_C(0x712092CC6AEC347D), UINT64_C(0x7976D0906B5ACAB7) },
          { UINT64_C(0x1EBCF80D6EED9617), UINT64_C(0xB3A63149B0F404A4),
            UINT64_C(0x3FDD3D1AD0B610EF), UINT64_C(0xDD3F6F9498C28AC7),
            UINT64_C(0x650B77943A59750F), UINT64_C(0xEC59BAB12D3991AC) } },
        { { UINT64_C(0x01F40E882E552766), UINT64_C(0x1FE3D50966F5354F),
            UINT64_C(0x0E46D006B3A8EA7F), UINT64_C(0xF75AB629F831CD6A),
            UINT64_C(0xDAD808D791465119), UINT64_C(0x442405AF17EF9B10) },
          { UINT64_C(0xD5FE0A96672BDFCB), UINT64_C(0xA9DFA422355DBDEC),
            UINT64_C(0xFDB79AA179B25636), UINT64_C(0xE7F26FFDEECE8AEC),
            UINT64_C(0xB59255507EDD5AA2), UINT64_C(0x2C8F6FF08EB3A6C2) } },
        { { UINT64_C(0x88887756757D6136), UINT64_C(0xAD9AC18388B92E72),
            UINT64_C(0x92CB2FC48785D3EB), UINT64_C(0xD1A542FE9319764B),
            UINT64_C(0xAF4CC78F626A62F8), UINT64_C(0x7F3F5FC926BFFAAE) },
          { UINT64_C(0x0A203D4340AE2231), UINT64_C(0xA8BFD9E0387898E8),
            UINT64_C(0x1A0C379C474B7DDD), UINT64_C(0x03855E0A34FD49EA),
            UINT64_C(0x02B26223B3EF4AE1), UINT64_C(0x804BD8CFE399E0A3) } },
        { { UINT64_C(0x11A9F3D0DE865713), UINT64_C(0x81E36B6BBDE98821),
            UINT64_C(0x324996C86AA891D0), UINT64_C(0x7B95BDC1395682B5),
            UINT64_C(0x47BF2219C1600563), UINT64_C(0x7A473F50643E38B4) },
          { UINT64_C(0x0911F50AF5738288), UINT64_C(0xDF947A706F9C415B),
            UINT64_C(0xBDB994F267A067F6), UINT64_C(0x3F4BEC1B88BE96CD),
            UINT64_C(0x9820E931E56DD6D9), UINT64_C(0xB138F14F0A80F419) } },
        { { UINT64_C(0xA11A1A8F0429077A), UINT64_C(0x2BB1E33D10351C68),
            UINT64_C(0x3C25ABFE89459A27), UINT64_C(0x2D0091B86B8AC774),
            UINT64_C(0xDAFC78533B2415D9), UINT64_C(0xDE713CF19201680D) },
          { UINT64_C(0x8E5F445D68889D57), UINT64_C(0x608B209C60EABF5B),
            UINT64_C(0x10EC0ACCF9CFA408), UINT64_C(0xD5256B9D4D1EE754),
            UINT64_C(0xFF866BAB0AA6C18D), UINT64_C(0x9D196DB8ACB90A45) } },
        { { UINT64_C(0xA46D76A9B9B081B2), UINT64_C(0xFC743A1062163C25),
            UINT64_C(0xCD2A5C8D7761C392), UINT64_C(0x39BDDE0BBE808583),
            UINT64_C(0x7C416021B98E4DFE), UINT64_C(0xF930E56365913A44) },
          { UINT64_C(0xC3555F7E7585CF3C), UINT64_C(0xC737E3833D6333D5),
            UINT64_C(0x5B60DBA4B430B03D), UINT64_C(0x42B715EBE7555404),
            UINT64_C(0x571BDF5B7C7796E3), UINT64_C(0x33DC62C66DB6331F) } },
        { { UINT64_C(0x3FB9CCB0E61DEE59), UINT64_C(0xC5185F2318B14DB9),
            UINT64_C(0x1B2ADC4F845EF36C), UINT64_C(0x195D5B505C1A33AB),
            UINT64_C(0x8CEA528E421F59D2), UINT64_C(0x7DFCCECFD2931CEA) },
          { UINT64_C(0x51FFA1D58CF7E3F7), UINT64_C(0xF01B7886BDC9FB43),
            UINT64_C(0xD65AB610261A0D35), UINT64_C(0x84BCBAFD7574A554),
            UINT64_C(0x4B119956FAD70208), UINT64_C(0xDDC329C24FAB5243) } },
        { { UINT64_C(0x1A08AA579CE92177), UINT64_C(0x3395E557DC2B5C36),
            UINT64_C(0xFDFE7041394ED04E), UINT64_C(0xB797EB24C6DFCDDE),
            UINT64_C(0x284A6B2ACB9DE5D6), UINT64_C(0xE0BD95C807222765) },
          { UINT64_C(0x114A951B9FE678A7), UINT64_C(0xE7ECD0BD9E4954EC),
            UINT64_C(0x7D4096FE79F0B8A9), UINT64_C(0xBDB26E9A09724FE2),
            UINT64_C(0x08741AD8F787AF95), UINT64_C(0x2BF9727224045AD8) } },
        { { UINT64_C(0xAB1FEDD9A9451D57), UINT64_C(0xDF4D91DF483E38C9),
            UINT64_C(0x2D54D31124E9CF8E), UINT64_C(0x9C2A5AF87A22EEB6),
            UINT64_C(0xBD9861EF0A43F123), UINT64_C(0x581EA6A238A18B7B) },
          { UINT64_C(0xAF339C85296470A3), UINT64_C(0xF9603FCDAFD8203E),
            UINT64_C(0x95D0535096763C28), UINT64_C(0x15445C16860EC831),
            UINT64_C(0x2AFB87286867A323), UINT64_C(0x4B152D6D0C4838BF) } },
        { { UINT64_C(0x45BA0E4F837CACBA), UINT64_C(0x7ADB38AEC0725275),
            UINT64_C(0x19C82831942D3C28), UINT64_C(0x94F4731D6D0FE7DD),
            UINT64_C(0xC3C07E134898F1E6), UINT64_C(0x76350EACED410B51) },
          { UINT64_C(0x0FA8BECAF99AACFC), UINT64_C(0x2834D86F65FAF9CF),
            UINT64_C(0x8E62846A6F3866AF), UINT64_C(0xDAA9BD4F3DFD6A2B),
            UINT64_C(0xC27115BBA6132655), UINT64_C(0x83972DF7BD5A32C2) } },
        { { UINT64_C(0xA330CB5BD513B825), UINT64_C(0xAE18B2D3EE37BEC3),
            UINT64_C(0xFC3AB80AF780A902), UINT64_C(0xD7835BE2D607DDF1),
            UINT64_C(0x8120F7675B6E4C2B), UINT64_C(0xAA8C385967E78CCB) },
          { UINT64_C(0xA8DA8CE2AA0ED321), UINT64_C(0xCB8846FDD766341A),
            UINT64_C(0xF2A342EE33DC9D9A), UINT64_C(0xA519E0BED0A18A80),
            UINT64_C(0x9CDAA39CAF48DF4C), UINT64_C(0xA4B500CA7E0C19EE) } },
        { { UINT64_C(0x83A7FD2F8217001B), UINT64_C(0x4F6FCF064296A8BA),
            UINT64_C(0x7D74864391619927), UINT64_C(0x174C1075941E4D41),
            UINT64_C(0x037EDEBDA64F5A6C), UINT64_C(0xCF64DB3A6E29DC56) },
          { UINT64_C(0x150B3ACE37C0B9F4), UINT64_C(0x1323234A7168178B),
            UINT64_C(0x1CE47014EF4D1879), UINT64_C(0xA22E374217FB4D5C),
            UINT64_C(0x69B81822D985F794), UINT64_C(0x199C21C4081D7214) } },
        { { UINT64_C(0x160BC7A18F04B4D2), UINT64_C(0x79CA81DDB10DE174),
            UINT64_C(0xE2A280B02DA1E9C7), UINT64_C(0xB4F6BD991D6A0A29),
            UINT64_C(0x57CF3EDD1C5B8F27), UINT64_C(0x7E34FC57158C2FD4) },
          { UINT64_C(0x828CFD89CAC93459), UINT64_C(0x9E631B6FB7AF499F),
            UINT64_C(0xF4DC8BC0DA26C135), UINT64_C(0x6128ED3937186735),
            UINT64_C(0xBB45538B67BF0BA5), UINT64_C(0x1ADDD4C10064A3AB) } },
    },
    {
        { { UINT64_C(0xC32730E8DD14D47E), UINT64_C(0xCDC1FD42C0F01E0F),
            UINT64_C(0x2BACFDBF3F5CD846), UINT64_C(0x45F364167272D4DD),
            UINT64_C(0xDD813A795EB75776), UINT64_C(0xB57885E450997BE2) },
          { UINT64_C(0xDA054E2BDB8C9829), UINT64_C(0x4161D820AAB5A594),
            UINT64_C(0x4C428F31026116A3), UINT64_C(0x372AF9A0DCD85E91),
            UINT64_C(0xFDA6E903673ADC2D), UINT64_C(0x4526B8ACA8DB59E6) } },
        { { UINT64_C(0x68FE359DE23A8472), UINT64_C(0x43EB12BD4CE3C101),
            UINT64_C(0x0EC652C3FC704935), UINT64_C(0x1EEFF1F952E4E22D),
            UINT64_C(0xBA6777CB083E3ADA), UINT64_C(0xAB52D7DC8BEFC871) },
          { UINT64_C(0x4EDE689F497CBD59), UINT64_C(0xC8AE42B927577DD9),
            UINT64_C(0xE0F080517AB83C27), UINT64_C(0x1F3D5F252C8C1F48),
            UINT64_C(0x57991607AF241AAC), UINT64_C(0xC4458B0AB8A337E0) } },
        { { UINT64_C(0x3DBB3FA651DD1BA9), UINT64_C(0xE53C1C4D545E960B),
            UINT64_C(0x35AC6574793CE803), UINT64_C(0xB2697DC783DBCE4F),
            UINT64_C(0xE35C5BF2E13CF6B0), UINT64_C(0x35034280B0C4A164) },
          { UINT64_C(0xAA490908D9C0D3C1), UINT64_C(0x2CCE614DCB4D2E90),
            UINT64_C(0xF646E96C54D504E4), UINT64_C(0xD74E7541B73310A3),
            UINT64_C(0xEAD7159618BDE5DA), UINT64_C(0x96E7F4A8AA09AEF7) } },
        { { UINT64_C(0xA8393A245D6E5F48), UINT64_C(0x2C8D7EA2F9175CE8),
            UINT64_C(0xD8824E0255A20268), UINT64_C(0x9DD9A272A446BCC6),
            UINT64_C(0xC929CDED5351499B), UINT64_C(0xEA5AD9ECCFE76535) },
          { UINT64_C(0x26F3D7D9DC32D001), UINT64_C(0x51C3BE8343EB9689),
            UINT64_C(0x91FDCC06759E6DDB), UINT64_C(0xAC2E1904E302B891),
            UINT64_C(0xAD25C645C207E1F7), UINT64_C(0x28A70F0DAB3DEB4A) } },
        { { UINT64_C(0x922D7F9703BEA8F1), UINT64_C(0x3AD820D4584570BE),
            UINT64_C(0x0CE0A8503CD46B43), UINT64_C(0x4C07911FAE66743D),
            UINT64_C(0x66519EB9FDA60023), UINT64_C(0x7F83004BEC2ACD9C) },
          { UINT64_C(0x001E0B80C3117EAD), UINT64_C(0xBB72D5410722BA25),
            UINT64_C(0x3AF7DB966E9A5078), UINT64_C(0x86C5774E701B6B4C),
            UINT64_C(0xBD2C0E8E37824DB5), UINT64_C(0x3AE3028CBFAC286D) } },
        { { UINT64_C(0x83D4D4A8A33E071B), UINT64_C(0x881C0A9261444BB5),
            UINT64_C(0xEEA1E292520E3BC3), UINT64_C(0x5A5F4C3C2AAAB729),
            UINT64_C(0x0B766C5EE63C7C94), UINT64_C(0x62BB8A9FBB2CC79C) },
          { UINT64_C(0x97ADC7D2AA5DC49D), UINT64_C(0x30CC26B331718681),
            UINT64_C(0xAC86E6FF56E86EDE), UINT64_C(0x37BCA7A2CD52F7F2),
            UINT64_C(0x734D2C949CE6D87F), UINT64_C(0x06A71D71C2F7E0CA) } },
        { { UINT64_C(0x559DCF75C6357D33), UINT64_C(0x4616D940652517DE),
            UINT64_C(0x3D576B981CCF207B), UINT64_C(0x51E2D1EF1979F631),
            UINT64_C(0x57517DDD06AE8296), UINT64_C(0x309A3D7FD6E7151F) },
          { UINT64_C(0xBA2A23E60E3A6FE5), UINT64_C(0x76CF674AD28B22C3),
            UINT64_C(0xD235AD07F8B808C3), UINT64_C(0x7BBF4C586B71213A),
            UINT64_C(0x0676792E93271EBB), UINT64_C(0x2CFD2C7605B1FC31) } },
        { { UINT64_C(0x4258E5C037A450F5), UINT64_C(0xC3245F1B52D2B118),
            UINT64_C(0x6DF7B48482BC5963), UINT64_C(0xE520DA4D9C273D1E),
            UINT64_C(0xED78E0122C3010E5), UINT64_C(0x112229483C1D4C05) },
          { UINT64_C(0xE3DAE5AFC692B490), UINT64_C(0x3272BD10C197F793),
            UINT64_C(0xF7EAE411E709ACAA), UINT64_C(0x00B0C95F778270A6),
            UINT64_C(0x4DA76EE1220D4350), UINT64_C(0x521E1461AB71E308) } },
        { { UINT64_C(0x7B654323343196A3), UINT64_C(0x35D442ADB0C95250),
            UINT64_C(0x38AF50E6E264FF17), UINT64_C(0x28397A412030D2EA),
            UINT64_C(0x8F1D84E9F74EEDA1), UINT64_C(0xD521F92DE6FB3C52) },
          { UINT64_C(0xAF358D7795733811), UINT64_C(0xEBFDDD0193ABFE94),
            UINT64_C(0x05D8A028D18D99DE), UINT64_C(0x5A664019B5D5BDD9),
            UINT64_C(0x3DF172822AA12FE8), UINT64_C(0xB42E006FB889A28E) } },
        { { UINT64_C(0xCF10E97DBC35CB1A), UINT64_C(0xC70A7BBD994DEDC5),
            UINT64_C(0x76A5327C37D04FB9), UINT64_C(0x87539F76A76E0CDA),
            UINT64_C(0xE9FE493FCD60A6B1), UINT64_C(0xA4574796132F01C0) },
          { UINT64_C(0xC43B85EBDB70B167), UINT64_C(0x81D5039A98551DFA),
            UINT64_C(0x6B56FBE91D979FA4), UINT64_C(0x49714FD78615098F),
            UINT64_C(0xB10E1CEA94DECAB5), UINT64_C(0x8342EBA3480EF6E3) } },
        { { UINT64_C(0xE1E030B0B3677288), UINT64_C(0x2978174C8D5CE3AF),
            UINT64_C(0xAFC0271CF7B2DE98), UINT64_C(0x745BC6F3B99C20B5),
            UINT64_C(0x9F6EDCED1E3BB4E5), UINT64_C(0x58D3EE4E73C8C1FC) },
          { UINT64_C(0x1F3535F47FD30124), UINT64_C(0xF366AC705FA62502),
            UINT64_C(0x4C4C1FDD965363FE), UINT64_C(0x8B2C77771DE2CA2B),
            UINT64_C(0x0CB54743882F1173), UINT64_C(0x94B6B8C071343331) } },
        { { UINT64_C(0x75AF014165B8B35B), UINT64_C(0x6D7B84854670A1F5),
            UINT64_C(0x6EAA3A47A3B6D376), UINT64_C(0xD7E673D2CB3E5B66),
            UINT64_C(0xC0338E6C9589AB38), UINT64_C(0x4BE26CB309440FAA) },
          { UINT64_C(0x82CB05E7394F9AA3), UINT64_C(0xC45C8A8A7F7792EA),
            UINT64_C(0x37E5E33BB687DC70), UINT64_C(0x63853219DFE48E49),
            UINT64_C(0x087951C16D0E5C8C), UINT64_C(0x7696A8C72BC27310) } },
        { { UINT64_C(0xA05736D5B67E834A), UINT64_C(0xDD2AA0F29098D42A),
            UINT64_C(0x09F0C1D849C69DDC), UINT64_C(0x81F8BC1C8FF0F0F3),
            UINT64_C(0x36FD3A4F03037775), UINT64_C(0x8286717D4B06DF5C) },
          { UINT64_C(0xB878F496A9079EA2), UINT64_C(0xA5642426D7DC796D),
            UINT64_C(0x29B9351A67FDAC2B), UINT64_C(0x93774C0E1D543CDE),
            UINT64_C(0x4F8793BA1A8E31C4), UINT64_C(0x7C9F3F3A6C94798A) } },
        { { UINT64_C(0x23C5AD11CB8ECDB8), UINT64_C(0x1E88D25E485A6A02),
            UINT64_C(0xB27CBE84F1E268AE), UINT64_C(0xDDA80238F4CD0475),
            UINT64_C(0x4F88857B49F8EB1B), UINT64_C(0x91B1221F52FB07F9) },
          { UINT64_C(0x7CE974608637FA67), UINT64_C(0x528B3CF4632198D8),
            UINT64_C(0x33365AB3F6623769), UINT64_C(0x6FEBCFFF3A83A30F),
            UINT64_C(0x398F4C999BD341EB), UINT64_C(0x180712BBB33A333C) } },
        { { UINT64_C(0x2B8655A2D93429E7), UINT64_C(0x99D600BB75C8B9EE),
            UINT64_C(0x9FC1AF8B88FCA6CD), UINT64_C(0x2FB533867C311F80),
            UINT64_C(0x20743ECBE8A71EEE), UINT64_C(0xEC3713C4E848B49E) },
          { UINT64_C(0x5B2037B5BB886817), UINT64_C(0x40EF5AC2307DBAF4),
            UINT64_C(0xC2888AF21B3F643D), UINT64_C(0x0D8252E19D5A4190),
            UINT64_C(0x06CC0BEC2DB52A8A), UINT64_C(0xB84B98EAAB94E969) } },
        { { UINT64_C(0x2E7AC078A0321E0E), UINT64_C(0x5C5A1168EF3DAAB6),
            UINT64_C(0xD2D573CBADDD454A), UINT64_C(0x27E149E236259CC7),
            UINT64_C(0x1EDFD469A63F47F1), UINT64_C(0x039AD674F1BD2CFD) },
          { UINT64_C(0xBFA633FC3077D3CC), UINT64_C(0x14A7C82F2FD64E9F),
            UINT64_C(0xAAA650149D824999), UINT64_C(0x41AB113B21760F2E),
            UINT64_C(0x23E646C51CAE260A), UINT64_C(0x08062C8F68DC5159) } },
    },
    {
        { { UINT64_C(0x2E7D0A16204BE028), UINT64_C(0x4F1D082ED0E41851),
            UINT64_C(0x15F1DDC63EB317F9), UINT64_C(0xF02750715ADF71D7),
            UINT64_C(0x2CE33C2EEE858BC3), UINT64_C(0xA24C76D1DA73B71A) },
          { UINT64_C(0x9EF6A70A6C70C483), UINT64_C(0xEFCF170505CF9612),
            UINT64_C(0x9F5BF5A67502DE64), UINT64_C(0xD11122A1A4701973),
            UINT64_C(0x82CFAAC2A2EA7B24), UINT64_C(0x6CAD67CC0A4582E1) } },
        { { UINT64_C(0x597A26FFB4DC8600), UINT64_C(0x264A09F3F9288555),
            UINT64_C(0x0B06AFF65C27F5F6), UINT64_C(0xCE5AB665D8D544E6),
            UINT64_C(0x92F031BE99275C32), UINT64_C(0xAF51C5BBF42E0E7C) },
          { UINT64_C(0x5BB28B061E37B36D), UINT64_C(0x583FBA6A8473543A),
            UINT64_C(0xE73FD299F93FB7DC), UINT64_C(0xFCD999A86E2CCAD9),
            UINT64_C(0xB8C8A6DF334D4F57), UINT64_C(0x5ADB28DD9A2ACC9B) } },
        { { UINT64_C(0x5ADF3D9A111792B9), UINT64_C(0x1C77A3054F1E0D09),
            UINT64_C(0xF9FBCE33A82D3736), UINT64_C(0xF307823E718C8AA3),
            UINT64_C(0x860578CF416CCF69), UINT64_C(0xB942ADD81EF8465B) },
          { UINT64_C(0x9EE0CF97CD9472E1), UINT64_C(0xE6792EEFB01528A8),
            UINT64_C(0xF99B9A8DC09DA90B), UINT64_C(0x1F521C2DCBF3CCB8),
            UINT64_C(0x6BF6694891A62632), UINT64_C(0xCC7A9CEB854FE9DA) } },
        { { UINT64_C(0x46303171491CCB92), UINT64_C(0xA80A8C0D2771235B),
            UINT64_C(0xD8E497FFF172C7CF), UINT64_C(0x7F7009D735B193CF),
            UINT64_C(0x6B9FD3F7F19DF4BC), UINT64_C(0xADA548C3B46F1E37) },
          { UINT64_C(0x87C6EAA9C7A20270), UINT64_C(0xEF2245D6AE78EF99),
            UINT64_C(0x2A121042539EAB95), UINT64_C(0x29A6D5D779B8F5CC),
            UINT64_C(0x33803A10B77840DC), UINT64_C(0xFEDD3A7011A6A30F) } },
        { { UINT64_C(0xFA070E22142403D1), UINT64_C(0x68FF316015C6F7F5),
            UINT64_C(0xE09F04E6223A0CE8), UINT64_C(0x22BBD01853E14183),
            UINT64_C(0x35D9FAFCCF45B75B), UINT64_C(0x3A34819D7ECEEC88) },
          { UINT64_C(0xD9CF7568D33262D2), UINT64_C(0x431036D5841D1505),
            UINT64_C(0x0C8005659EB2A79A), UINT64_C(0x8E77D9F05F7EDC6A),
            UINT64_C(0x19E12D0565E800AA), UINT64_C(0x335C8D36B7784E7C) } },
        { { UINT64_C(0x8B2FC4E96484FD40), UINT64_C(0xEE702764A35D24EA),
            UINT64_C(0x15B28AC7B871C3F3), UINT64_C(0x805B4048E097047F),
            UINT64_C(0xD6F1B8DF647CAD2F), UINT64_C(0xF1D5B458DC7DD67F) },
          { UINT64_C(0x324C529C25148803), UINT64_C(0xF6185EBE21274FAF),
            UINT64_C(0xAF14751E95148B55), UINT64_C(0x283ED89D28F284F4),
            UINT64_C(0x93AD20E74CBEBF1A), UINT64_C(0x5F6EC65D882935E1) } },
        { { UINT64_C(0xE222EBA4A4DCEFE9), UINT64_C(0x63AD235FEC1CEB74),
            UINT64_C(0x2E0BF749E05B18E7), UINT64_C(0x547BD050B48BDD87),
            UINT64_C(0x0490C970F5AA2FC4), UINT64_C(0xCED5E4CF2B431390) },
          { UINT64_C(0x07D8270451D2898E), UINT64_C(0x44B72442083B57D4),
            UINT64_C(0xA4ADA2305037FCE8), UINT64_C(0x55F7905E50510DA6),
            UINT64_C(0xD8EE724F8D890A98), UINT64_C(0x925A8E7C11B85640) } },
        { { UINT64_C(0x5BFA10CD1CA459ED), UINT64_C(0x593F085A6DCF56BF),
            UINT64_C(0xE6F0AD9BC0579C3E), UINT64_C(0xC11C95A22527C1AD),
            UINT64_C(0x7CFA71E1CF1CB8B3), UINT64_C(0xEDCFF8331D6DC79D) },
          { UINT64_C(0x581C4BBE432521C9), UINT64_C(0xBF620096144E11A0),
            UINT64_C(0x54C38B71BE3A107B), UINT64_C(0xED555E37E2606EC0),
            UINT64_C(0x3FB148B8D721D034), UINT64_C(0x79D53DAD0091BC90) } },
        { { UINT64_C(0xE32068C5B7082C80), UINT64_C(0x4140FFD27A144E22),
            UINT64_C(0x5811D2F09EDD9E86), UINT64_C(0xCDD79B5FC572C465),
            UINT64_C(0x3563FED1C97BF450), UINT64_C(0x985C1444F2CE5C9C) },
          { UINT64_C(0x260AE79799950F1C), UINT64_C(0x659F4F40765E9DED),
            UINT64_C(0x2A412D662E3BC286), UINT64_C(0xE865E62CF87E0C82),
            UINT64_C(0xD63D3A9A6C05E7D7), UINT64_C(0x96725D678686F89A) } },
        { { UINT64_C(0xC99A5E4CAB7EA0F5), UINT64_C(0xC9860A1AC5393FA9),
            UINT64_C(0x9ED83CEE8FDEEFC0), UINT64_C(0xE3EA8B4C5ED6869A),
            UINT64_C(0x89A85463D2EED3A9), UINT64_C(0x2CD91B6DE421A622) },
          { UINT64_C(0x6FEC1EF32C91C41D), UINT64_C(0xB1540D1F8171037D),
            UINT64_C(0x4FE4991A1C010E5B), UINT64_C(0x28A3469FFC1C7368),
            UINT64_C(0xE1EEECD1AF118781), UINT64_C(0x1BCCB97799EF3531) } },
        { { UINT64_C(0x63D3B638C4DAB7B8), UINT64_C(0xD92133B63F7F5BAB),
            UINT64_C(0x2573EE2009FB6069), UINT64_C(0x771FABDF890A1686),
            UINT64_C(0x1D0BA21FA77AFFF5), UINT64_C(0x83145FCCBA3DD2C0) },
          { UINT64_C(0xFA073A812D115C20), UINT64_C(0x6AB7A9D319176F27),
            UINT64_C(0xAF62CF939AC639EE), UINT64_C(0xF73848B92CCD1319),
            UINT64_C(0x3B6132343C71659D), UINT64_C(0xF8E0011C10AB3826) } },
        { { UINT64_C(0x0501F0360282FFA5), UINT64_C(0xC39A5CF4D9E0F15A),
            UINT64_C(0x48D8C7299A3D1F3C), UINT64_C(0xB5FC136B64E18EDA),
            UINT64_C(0xE81B53D97E58FEF0), UINT64_C(0x0D534055F7B0F28D) },
          { UINT64_C(0x47B8DE127A80619B), UINT64_C(0x60E2A2B381F9E55D),
            UINT64_C(0x6E9624D7CF564CC5), UINT64_C(0xFDF18A216BDEDFFF),
            UINT64_C(0x3787DE38C0D5FC82), UINT64_C(0xCBCAA347497A6B11) } },
        { { UINT64_C(0x6E7EF35EB226465A), UINT64_C(0x4B4699195F8A2BAF),
            UINT64_C(0x44B3A3CF1120D93F), UINT64_C(0xB052C8B668F34AD1),
            UINT64_C(0x27EC574BEF7632DD), UINT64_C(0xAEBEA108685DE26F) },
          { UINT64_C(0xDA33236BE39424B6), UINT64_C(0xB1BD94A9EBCC22AD),
            UINT64_C(0x6DDEE6CC2CDFB5D5), UINT64_C(0xBDAED9276F14069A),
            UINT64_C(0x2ADE427C2A247CB7), UINT64_C(0xCE96B436ED156A40) } },
        { { UINT64_C(0xDDDCA36081F3F819), UINT64_C(0x4AF4A49FD419B96A),
            UINT64_C(0x746C65257CB966B9), UINT64_C(0x01E390886F610023),
            UINT64_C(0x05ECB38D98DD33FC), UINT64_C(0x962B971B8F84EDF4) },
          { UINT64_C(0xEB32C0A56A6F2602), UINT64_C(0xF026AF71562D60F2),
            UINT64_C(0xA9E246BF84615FAB), UINT64_C(0xAD96709275DBAE01),
            UINT64_C(0xBF97C79B3ECE5D07), UINT64_C(0xE06266C774EAA3D3) } },
        { { UINT64_C(0x161A01572E6DBB6E), UINT64_C(0xB8AF490460FA8F47),
            UINT64_C(0xE4336C4400197F22), UINT64_C(0xF811AFFA9CEDCE0E),
            UINT64_C(0xB1DD7685F94C2EF1), UINT64_C(0xEEDC0F4BCA957BB0) },
          { UINT64_C(0xD319FD574AA76BB1), UINT64_C(0xB3525D7C16CD7CCB),
            UINT64_C(0x7B22DA9CA97DD072), UINT64_C(0x99DB84BD38A83E71),
            UINT64_C(0x4939BC8DC0EDD8BE), UINT64_C(0x06D524EA903A932C) } },
        { { UINT64_C(0x4BC950EC0E31F639), UINT64_C(0xB7ABD3DC6016BE30),
            UINT64_C(0x3B0F44736703DAD0), UINT64_C(0xCC405F8B0AC1C4EA),
            UINT64_C(0x9BED5E57176C3FEE), UINT64_C(0xF452481036AE36C2) },
          { UINT64_C(0xC1EDBB8315D7B503), UINT64_C(0x943B1156E30F3657),
            UINT64_C(0x984E9EEF98377805), UINT64_C(0x291AE7AC36CF1DEB),
            UINT64_C(0xFED8748CA9F66DF3), UINT64_C(0xECA758BBFEA8FA5D) } },
    },
    {
        { { UINT64_C(0xACC787EF2DD1B249), UINT64_C(0x736E1030D82976F1),
            UINT64_C(0x0A6940FAA01B3649), UINT64_C(0xE00B926BC42341E7),
            UINT64_C(0x911508D0DE8FFD6C), UINT64_C(0x4DCF8D465276B0CB) },
          { UINT64_C(0x23AD0A90CC3CAD8D), UINT64_C(0x2A92E54CADED962A),
            UINT64_C(0x93FBEC4DF231BFAF), UINT64_C(0x9544BC774798987A),
            UINT64_C(0x48084E2508E29F60), UINT64_C(0x0C0D2F4332DE5869) } },
        { { UINT64_C(0x6778F9703A9ABC13), UINT64_C(0xFD014FAC3D2B166B),
            UINT64_C(0x1FE4FC783C6FED60), UINT64_C(0x04295FA8AA7C69C5),
            UINT64_C(0xA01DE56D7C123175), UINT64_C(0x0FA0D3A83D9A713A) },
          { UINT64_C(0xA7A6E5E3E3E08ADD), UINT64_C(0xBD77E94B1AC58F85),
            UINT64_C(0x078F6FD2B7321A9C), UINT64_C(0x9564601E911EF6D9),
            UINT64_C(0x31C5C1B2415C6BEF), UINT64_C(0xE6C0C91ED3212C62) } },
        { { UINT64_C(0xBA7BD23C0D16022F), UINT64_C(0xE9CF4750198BE288),
            UINT64_C(0x304E316947DEEC65), UINT64_C(0xCF65B41F96EEB288),
            UINT64_C(0x17E99C17927E9E3B), UINT64_C(0x82225546F6630A80) },
          { UINT64_C(0x15122B8ACA067BD9), UINT64_C(0xE2673205B77B4E98),
            UINT64_C(0x130375659407CA63), UINT64_C(0x53624F548B621602),
            UINT64_C(0x96AF2CB1EAE4BD06), UINT64_C(0x576ECD1C8FA20829) } },
        { { UINT64_C(0xA551CE107E02D2D0), UINT64_C(0x1584ED249D13DBC7),
            UINT64_C(0x082017AD4DA7B6D8), UINT64_C(0x81918A8FE054BC48),
            UINT64_C(0x677DB48E572DC384), UINT64_C(0x2EF822966155484C) },
          { UINT64_C(0xC3DB14C641B9C231), UINT64_C(0x910A87D14A766192),
            UINT64_C(0x93D5CC8610AB8E0F), UINT64_C(0x4194D548AE57CA1B),
            UINT64_C(0xFAF3A1D6267FC37A), UINT64_C(0x70EC236413B87C97) } },
        { { UINT64_C(0x064B565B5E12756A), UINT64_C(0x953B7BD1AE49C98E),
            UINT64_C(0xE0CE8284F7001D91), UINT64_C(0x1546060BF31108D0),
            UINT64_C(0xDBC2C3F46779B6E2), UINT64_C(0x157AA47DE0DD07CF) },
          { UINT64_C(0xBF4A1C6FF23B261E), UINT64_C(0x5B8EED30654F4BE5),
            UINT64_C(0xDF5896D36B20CCD8), UINT64_C(0x56920E2C559ED23D),
            UINT64_C(0x901F342EFA6E3E27), UINT64_C(0x745C747C896CA082) } },
        { { UINT64_C(0xDBCCD5752944EC84), UINT64_C(0x54A2A935A5FF65FE),
            UINT64_C(0x88C92A5E1A1319B6), UINT64_C(0x9537C28F82DA96C1),
            UINT64_C(0xB683647435F93C46), UINT64_C(0xEC526A1D65B0846C) },
          { UINT64_C(0x6F12AFBDF382C412), UINT64_C(0x5EBC81D89E99FA06),
            UINT64_C(0x97B5D672869B93BD), UINT64_C(0x2983C310377E12AA),
            UINT64_C(0x4875968124D681EA), UINT64_C(0x1E0BD106287FD767) } },
        { { UINT64_C(0x0AC75A3E7231247F), UINT64_C(0x65C20DE6EF27AD3A),
            UINT64_C(0x87EB6CF1BD02EEE5), UINT64_C(0x264ACA7A00147E03),
            UINT64_C(0xEBC78581AE2A9437), UINT64_C(0x9929964E6316BFA5) },
          { UINT64_C(0xDC09E0409AF207EF), UINT64_C(0x3ECFFE2D0C9D8658),
            UINT64_C(0x547EA735DFB43D38), UINT64_C(0x5485247BD04B1B20),
            UINT64_C(0xB18D3F02BFD8B609), UINT64_C(0xEEB3E805CCE73705) } },
        { { UINT64_C(0xDAB1A525DB93850F), UINT64_C(0x18ADAA238365B7D5),
            UINT64_C(0x58485C90113FC8C7), UINT64_C(0x80C3DBB9348AD323),
            UINT64_C(0xAF892FB5E16ADCA1), UINT64_C(0x2183C879979F005A) },
          { UINT64_C(0x20FA1A940643A99E), UINT64_C(0x2741221C1A1609CB),
            UINT64_C(0x1C1687E53C2FBDDC), UINT64_C(0xDCCF329ED420D6CF),
            UINT64_C(0x75D5577D2B7197D1), UINT64_C(0x4C3C3875C8729D9C) } },
        { { UINT64_C(0x5E79F995E5CBDCB9), UINT64_C(0x03139824A742FCC7),
            UINT64_C(0x6D0C214A239EF4A1), UINT64_C(0x53A27952401A2944),
            UINT64_C(0xF42A1B34C10BCDF0), UINT64_C(0x426BAA437CF38061) },
          { UINT64_C(0x16A53139A96AD0C8), UINT64_C(0x627F1D316BAD5301),
            UINT64_C(0x5AF748774ACCD627), UINT64_C(0x3C58A1C5B55B0FB8),
            UINT64_C(0xFAA57B91F4399A6A), UINT64_C(0xBAD283FBC28094B8) } },
        { { UINT64_C(0xBA32AC6183E10A93), UINT64_C(0x1C91F6B4EC06BDB0),
            UINT64_C(0x42E6CFBC65F60C93), UINT64_C(0xEFE33BC82C0CDCBE),
            UINT64_C(0xE0FE1D094D6414F2), UINT64_C(0x4C11231676FA5C5B) },
          { UINT64_C(0x812C1DC62E26200A), UINT64_C(0xD6C413C5EE879D25),
            UINT64_C(0xBEADE255BCA8BAFE), UINT64_C(0x0EAF4AE2CE2BA0E7),
            UINT64_C(0x66E9FFB0C4F4408A), UINT64_C(0xB36A86D79782C7AD) } },
        { { UINT64_C(0x10FCD1F4BAD8D1C7), UINT64_C(0xC903816A4502F645),
            UINT64_C(0x7FAC1CC1A503B895), UINT64_C(0x8BCD60410778900C),
            UINT64_C(0x5A5F22025BCF2784), UINT64_C(0x9B157E8710EDB896) },
          { UINT64_C(0x4C58DA69F602A8B1), UINT64_C(0xD55132F859EC9D7E),
            UINT64_C(0x155B719AA26D4870), UINT64_C(0x25AAFCA336441746),
            UINT64_C(0x01F83338DD3B6B30), UINT64_C(0xD52BB5C1551917CC) } },
        { { UINT64_C(0xA0B6207B6135066A), UINT64_C(0xB3409F842AEC8CBD),
            UINT64_C(0x5EBFD43619D87DF0), UINT64_C(0xCB4C209BE8526DE2),
            UINT64_C(0xD764085B21E1A230), UINT64_C(0x96F915540899964A) },
          { UINT64_C(0xB0BEC8EFA57D122A), UINT64_C(0xC572EC565D9D0B33),
            UINT64_C(0xEBE2A780CFA7C72C), UINT64_C(0x52D40CDB9EF3295C),
            UINT64_C(0x640045840DE74DFE), UINT64_C(0xA6846432C0809716) } },
        { { UINT64_C(0x0D09E8CD02C979BC), UINT64_C(0xEC4B21F6409F4F2A),
            UINT64_C(0x68125C7013FB07CA), UINT64_C(0x1C4CFC176FDFA72A),
            UINT64_C(0xC9E71B9E04539FCD), UINT64_C(0x94B7103D8BA70797) },
          { UINT64_C(0x6B81E82FB33FDE83), UINT64_C(0x7CA9A8CAEABAFD4B),
            UINT64_C(0xADD85A67EAB819CE), UINT64_C(0xAEC2548398E99FFC),
            UINT64_C(0x938D6440274A07B6), UINT64_C(0x0A5C7097564A6AA0) } },
        { { UINT64_C(0x7284FF502F4FCEB6), UINT64_C(0x0A28715A78D0D5CB),
            UINT64_C(0xE70B7014BFCE187C), UINT64_C(0xA6B538F57A17148D),
            UINT64_C(0x1DAB07C9DD427166), UINT64_C(0x5C5578B0149D23CA) },
          { UINT64_C(0x875E2056875B5EDE), UINT64_C(0xCBF44B6D02C893B9),
            UINT64_C(0x5715A77E5C2993FB), UINT64_C(0xAF3281463410597E),
            UINT64_C(0x65DF418F42DC49DF), UINT64_C(0x7AC9C720A9EE52F6) } },
        { { UINT64_C(0xB1C9AA0762955486), UINT64_C(0xCBF35BE3245061D7),
            UINT64_C(0x811E1BD38CF4DDC0), UINT64_C(0xD9D4589C948F7C84),
            UINT64_C(0x30D09A0FCB0F996D), UINT64_C(0x1A1B3B7A590E7704) },
          { UINT64_C(0xA848E3492082768D), UINT64_C(0x9FEBD4929A249DF4),
            UINT64_C(0x503420AF5F20439A), UINT64_C(0x0CBE52B68E2BFCD4),
            UINT64_C(0xB1D5E261118C91B2), UINT64_C(0x93CFF6DA71D8F2BC) } },
        { { UINT64_C(0x5F5BC06B8AB58944), UINT64_C(0xE4BED5384979882D),
            UINT64_C(0x57C30362D79B0EB1), UINT64_C(0x391AE2C1EF7C56D8),
            UINT64_C(0x28BC2E97ADD98625), UINT64_C(0xFA8E86B81B257107) },
          { UINT64_C(0x5E4859F86118C715), UINT64_C(0x91C83324524C71DD),
            UINT64_C(0xFB2092436D2F5E6D), UINT64_C(0x6B4FE21F2A900A43),
            UINT64_C(0x241F75D632A73C1F), UINT64_C(0xF5BC46295AE89613) } },
    }
};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 6
 * ASSERT: a = -3
 */
static void
point_double(pt_prj_t *Q, const pt_prj_t *P)
{
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_secp384r1_square(t0, X);
    fiat_secp384r1_square(t1, Y);
    fiat_secp384r1_square(t2, Z);
    fiat_secp384r1_mul(t3, X, Y);
    fiat_secp384r1_add(t3, t3, t3);
    fiat_secp384r1_mul(t4, Y, Z);
    fiat_secp384r1_mul(Z3, X, Z);
    fiat_secp384r1_add(Z3, Z3, Z3);
    fiat_secp384r1_mul(Y3, b, t2);
    fiat_secp384r1_sub(Y3, Y3, Z3);
    fiat_secp384r1_add(X3, Y3, Y3);
    fiat_secp384r1_add(Y3, X3, Y3);
    fiat_secp384r1_sub(X3, t1, Y3);
    fiat_secp384r1_add(Y3, t1, Y3);
    fiat_secp384r1_mul(Y3, X3, Y3);
    fiat_secp384r1_mul(X3, X3, t3);
    fiat_secp384r1_add(t3, t2, t2);
    fiat_secp384r1_add(t2, t2, t3);
    fiat_secp384r1_mul(Z3, b, Z3);
    fiat_secp384r1_sub(Z3, Z3, t2);
    fiat_secp384r1_sub(Z3, Z3, t0);
    fiat_secp384r1_add(t3, Z3, Z3);
    fiat_secp384r1_add(Z3, Z3, t3);
    fiat_secp384r1_add(t3, t0, t0);
    fiat_secp384r1_add(t0, t3, t0);
    fiat_secp384r1_sub(t0, t0, t2);
    fiat_secp384r1_mul(t0, t0, Z3);
    fiat_secp384r1_add(Y3, Y3, t0);
    fiat_secp384r1_add(t0, t4, t4);
    fiat_secp384r1_mul(Z3, t0, Z3);
    fiat_secp384r1_sub(X3, X3, Z3);
    fiat_secp384r1_mul(Z3, t0, t1);
    fiat_secp384r1_add(Z3, Z3, Z3);
    fiat_secp384r1_add(Z3, Z3, Z3);
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed.op3
 * https://eprint.iacr.org/2015/1060 Alg 5
 * ASSERT: a = -3
 */
static void
point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P)
{
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_secp384r1_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_secp384r1_mul(t0, X1, X2);
    fiat_secp384r1_mul(t1, Y1, Y2);
    fiat_secp384r1_add(t3, X2, Y2);
    fiat_secp384r1_add(t4, X1, Y1);
    fiat_secp384r1_mul(t3, t3, t4);
    fiat_secp384r1_add(t4, t0, t1);
    fiat_secp384r1_sub(t3, t3, t4);
    fiat_secp384r1_mul(t4, Y2, Z1);
    fiat_secp384r1_add(t4, t4, Y1);
    fiat_secp384r1_mul(Y3, X2, Z1);
    fiat_secp384r1_add(Y3, Y3, X1);
    fiat_secp384r1_mul(Z3, b, Z1);
    fiat_secp384r1_sub(X3, Y3, Z3);
    fiat_secp384r1_add(Z3, X3, X3);
    fiat_secp384r1_add(X3, X3, Z3);
    fiat_secp384r1_sub(Z3, t1, X3);
    fiat_secp384r1_add(X3, t1, X3);
    fiat_secp384r1_mul(Y3, b, Y3);
    fiat_secp384r1_add(t1, Z1, Z1);
    fiat_secp384r1_add(t2, t1, Z1);
    fiat_secp384r1_sub(Y3, Y3, t2);
    fiat_secp384r1_sub(Y3, Y3, t0);
    fiat_secp384r1_add(t1, Y3, Y3);
    fiat_secp384r1_add(Y3, t1, Y3);
    fiat_secp384r1_add(t1, t0, t0);
    fiat_secp384r1_add(t0, t1, t0);
    fiat_secp384r1_sub(t0, t0, t2);
    fiat_secp384r1_mul(t1, t4, Y3);
    fiat_secp384r1_mul(t2, t0, Y3);
    fiat_secp384r1_mul(Y3, X3, Z3);
    fiat_secp384r1_add(Y3, Y3, t2);
    fiat_secp384r1_mul(X3, t3, X3);
    fiat_secp384r1_sub(X3, X3, t1);
    fiat_secp384r1_mul(Z3, t4, Z3);
    fiat_secp384r1_mul(t1, t3, t0);
    fiat_secp384r1_add(Z3, Z3, t1);

    /* if P is inf, throw all that away and take Q */
    fiat_secp384r1_selectznz(R->X, nz, Q->X, X3);
    fiat_secp384r1_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_secp384r1_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 4
 * ASSERT: a = -3
 */
static void
point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P)
{
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_secp384r1_mul(t0, X1, X2);
    fiat_secp384r1_mul(t1, Y1, Y2);
    fiat_secp384r1_mul(t2, Z1, Z2);
    fiat_secp384r1_add(t3, X1, Y1);
    fiat_secp384r1_add(t4, X2, Y2);
    fiat_secp384r1_mul(t3, t3, t4);
    fiat_secp384r1_add(t4, t0, t1);
    fiat_secp384r1_sub(t3, t3, t4);
    fiat_secp384r1_add(t4, Y1, Z1);
    fiat_secp384r1_add(t5, Y2, Z2);
    fiat_secp384r1_mul(t4, t4, t5);
    fiat_secp384r1_add(t5, t1, t2);
    fiat_secp384r1_sub(t4, t4, t5);
    fiat_secp384r1_add(X3, X1, Z1);
    fiat_secp384r1_add(Y3, X2, Z2);
    fiat_secp384r1_mul(X3, X3, Y3);
    fiat_secp384r1_add(Y3, t0, t2);
    fiat_secp384r1_sub(Y3, X3, Y3);
    fiat_secp384r1_mul(Z3, b, t2);
    fiat_secp384r1_sub(X3, Y3, Z3);
    fiat_secp384r1_add(Z3, X3, X3);
    fiat_secp384r1_add(X3, X3, Z3);
    fiat_secp384r1_sub(Z3, t1, X3);
    fiat_secp384r1_add(X3, t1, X3);
    fiat_secp384r1_mul(Y3, b, Y3);
    fiat_secp384r1_add(t1, t2, t2);
    fiat_secp384r1_add(t2, t1, t2);
    fiat_secp384r1_sub(Y3, Y3, t2);
    fiat_secp384r1_sub(Y3, Y3, t0);
    fiat_secp384r1_add(t1, Y3, Y3);
    fiat_secp384r1_add(Y3, t1, Y3);
    fiat_secp384r1_add(t1, t0, t0);
    fiat_secp384r1_add(t0, t1, t0);
    fiat_secp384r1_sub(t0, t0, t2);
    fiat_secp384r1_mul(t1, t4, Y3);
    fiat_secp384r1_mul(t2, t0, Y3);
    fiat_secp384r1_mul(Y3, X3, Z3);
    fiat_secp384r1_add(Y3, Y3, t2);
    fiat_secp384r1_mul(X3, t3, X3);
    fiat_secp384r1_sub(X3, X3, t1);
    fiat_secp384r1_mul(Z3, t4, Z3);
    fiat_secp384r1_mul(t1, t3, t0);
    fiat_secp384r1_add(Z3, Z3, t1);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void
precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P)
{
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int
scalar_get_bit(const unsigned char in[48], int idx)
{
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 48)
        return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void
scalar_rwnaf(int8_t out[77], const unsigned char in[48])
{
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 76; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void
scalar_wnaf(int8_t out[385], const unsigned char in[48])
{
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 385; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simulateous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void
var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[48],
                  const unsigned char b[48], const pt_aff_t *P)
{
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[385] = { 0 };
    int8_t bnaf[385] = { 0 };
    pt_prj_t Q;
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 384; i >= 0; i--) {
        if (!is_inf)
            point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_secp384r1_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_secp384r1_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_secp384r1_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_secp384r1_inv(Q.Z, Q.Z);
    fiat_secp384r1_mul(out->X, Q.X, Q.Z);
    fiat_secp384r1_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void
var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[48],
               const pt_aff_t *P)
{
    int i, j, d, diff, is_neg;
    int8_t rnaf[77] = { 0 };
    pt_prj_t Q, lut;
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
/* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[76] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_secp384r1_selectznz(Q.X, diff, Q.X, precomp[j].X);
        fiat_secp384r1_selectznz(Q.Y, diff, Q.Y, precomp[j].Y);
        fiat_secp384r1_selectznz(Q.Z, diff, Q.Z, precomp[j].Z);
    }

    for (i = 75; i >= 0; i--) {
        for (j = 0; j < RADIX; j++)
            point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_secp384r1_selectznz(lut.X, diff, lut.X, precomp[j].X);
            fiat_secp384r1_selectznz(lut.Y, diff, lut.Y, precomp[j].Y);
            fiat_secp384r1_selectznz(lut.Z, diff, lut.Z, precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_secp384r1_opp(out->Y, lut.Y);
        fiat_secp384r1_selectznz(lut.Y, is_neg, lut.Y, out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_secp384r1_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_secp384r1_selectznz(Q.X, scalar[0] & 1, lut.X, Q.X);
    fiat_secp384r1_selectznz(Q.Y, scalar[0] & 1, lut.Y, Q.Y);
    fiat_secp384r1_selectznz(Q.Z, scalar[0] & 1, lut.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_secp384r1_inv(Q.Z, Q.Z);
    fiat_secp384r1_mul(out->X, Q.X, Q.Z);
    fiat_secp384r1_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void
fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[48])
{
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[77] = { 0 };
    pt_prj_t Q, R;
    pt_aff_t lut;

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
/* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 3; i >= 0; i--) {
        for (j = 0; i != 3 && j < RADIX; j++)
            point_double(&Q, &Q);
        for (j = 0; j < 21; j++) {
            if (j * 4 + i > 76)
                continue;
            d = rnaf[j * 4 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_secp384r1_selectznz(lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_secp384r1_selectznz(lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_secp384r1_opp(out->Y, lut.Y);
            fiat_secp384r1_selectznz(lut.Y, is_neg, lut.Y, out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_secp384r1_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_secp384r1_selectznz(Q.X, scalar[0] & 1, R.X, Q.X);
    fiat_secp384r1_selectznz(Q.Y, scalar[0] & 1, R.Y, Q.Y);
    fiat_secp384r1_selectznz(Q.Z, scalar[0] & 1, R.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_secp384r1_inv(Q.Z, Q.Z);
    fiat_secp384r1_mul(out->X, Q.X, Q.Z);
    fiat_secp384r1_mul(out->Y, Q.Y, Q.Z);
}

static void
point_mul_two(unsigned char outx[48], unsigned char outy[48],
              const unsigned char a[48], const unsigned char b[48],
              const unsigned char inx[48],
              const unsigned char iny[48])
{
    pt_aff_t P;

    fiat_secp384r1_from_bytes(P.X, inx);
    fiat_secp384r1_from_bytes(P.Y, iny);
    fiat_secp384r1_to_montgomery(P.X, P.X);
    fiat_secp384r1_to_montgomery(P.Y, P.Y);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_secp384r1_from_montgomery(P.X, P.X);
    fiat_secp384r1_from_montgomery(P.Y, P.Y);
    fiat_secp384r1_to_bytes(outx, P.X);
    fiat_secp384r1_to_bytes(outy, P.Y);
}

static void
point_mul_g(unsigned char outx[48], unsigned char outy[48],
            const unsigned char scalar[48])
{
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_secp384r1_from_montgomery(P.X, P.X);
    fiat_secp384r1_from_montgomery(P.Y, P.Y);
    fiat_secp384r1_to_bytes(outx, P.X);
    fiat_secp384r1_to_bytes(outy, P.Y);
}

static void
point_mul(unsigned char outx[48], unsigned char outy[48],
          const unsigned char scalar[48],
          const unsigned char inx[48],
          const unsigned char iny[48])
{
    pt_aff_t P;

    fiat_secp384r1_from_bytes(P.X, inx);
    fiat_secp384r1_from_bytes(P.Y, iny);
    fiat_secp384r1_to_montgomery(P.X, P.X);
    fiat_secp384r1_to_montgomery(P.Y, P.Y);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_secp384r1_from_montgomery(P.X, P.X);
    fiat_secp384r1_from_montgomery(P.Y, P.Y);
    fiat_secp384r1_to_bytes(outx, P.X);
    fiat_secp384r1_to_bytes(outy, P.Y);
}

#undef RADIX
#include "ecp.h"
#include "mplogic.h"

/*-
 * reverse bytes -- total hack
 */
#define MP_BE2LE(a)            \
    do {                       \
        unsigned char z_bswap; \
        z_bswap = a[0];        \
        a[0] = a[47];          \
        a[47] = z_bswap;       \
        z_bswap = a[1];        \
        a[1] = a[46];          \
        a[46] = z_bswap;       \
        z_bswap = a[2];        \
        a[2] = a[45];          \
        a[45] = z_bswap;       \
        z_bswap = a[3];        \
        a[3] = a[44];          \
        a[44] = z_bswap;       \
        z_bswap = a[4];        \
        a[4] = a[43];          \
        a[43] = z_bswap;       \
        z_bswap = a[5];        \
        a[5] = a[42];          \
        a[42] = z_bswap;       \
        z_bswap = a[6];        \
        a[6] = a[41];          \
        a[41] = z_bswap;       \
        z_bswap = a[7];        \
        a[7] = a[40];          \
        a[40] = z_bswap;       \
        z_bswap = a[8];        \
        a[8] = a[39];          \
        a[39] = z_bswap;       \
        z_bswap = a[9];        \
        a[9] = a[38];          \
        a[38] = z_bswap;       \
        z_bswap = a[10];       \
        a[10] = a[37];         \
        a[37] = z_bswap;       \
        z_bswap = a[11];       \
        a[11] = a[36];         \
        a[36] = z_bswap;       \
        z_bswap = a[12];       \
        a[12] = a[35];         \
        a[35] = z_bswap;       \
        z_bswap = a[13];       \
        a[13] = a[34];         \
        a[34] = z_bswap;       \
        z_bswap = a[14];       \
        a[14] = a[33];         \
        a[33] = z_bswap;       \
        z_bswap = a[15];       \
        a[15] = a[32];         \
        a[32] = z_bswap;       \
        z_bswap = a[16];       \
        a[16] = a[31];         \
        a[31] = z_bswap;       \
        z_bswap = a[17];       \
        a[17] = a[30];         \
        a[30] = z_bswap;       \
        z_bswap = a[18];       \
        a[18] = a[29];         \
        a[29] = z_bswap;       \
        z_bswap = a[19];       \
        a[19] = a[28];         \
        a[28] = z_bswap;       \
        z_bswap = a[20];       \
        a[20] = a[27];         \
        a[27] = z_bswap;       \
        z_bswap = a[21];       \
        a[21] = a[26];         \
        a[26] = z_bswap;       \
        z_bswap = a[22];       \
        a[22] = a[25];         \
        a[25] = z_bswap;       \
        z_bswap = a[23];       \
        a[23] = a[24];         \
        a[24] = z_bswap;       \
    } while (0)

static mp_err
point_mul_g_secp384r1(const mp_int *n, mp_int *out_x,
                      mp_int *out_y, const ECGroup *group)
{
    unsigned char b_x[48];
    unsigned char b_y[48];
    unsigned char b_n[48];
    mp_err res;

    ARGCHK(n != NULL && out_x != NULL && out_y != NULL, MP_BADARG);

    /* fail on out of range scalars */
    if (mpl_significant_bits(n) > 384 || mp_cmp_z(n) != 1)
        return MP_RANGE;

    MP_CHECKOK(mp_to_fixlen_octets(n, b_n, 48));
    MP_BE2LE(b_n);
    point_mul_g(b_x, b_y, b_n);
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_CHECKOK(mp_read_unsigned_octets(out_x, b_x, 48));
    MP_CHECKOK(mp_read_unsigned_octets(out_y, b_y, 48));

CLEANUP:
    return res;
}

static mp_err
point_mul_secp384r1(const mp_int *n, const mp_int *in_x,
                    const mp_int *in_y, mp_int *out_x,
                    mp_int *out_y, const ECGroup *group)
{
    unsigned char b_x[48];
    unsigned char b_y[48];
    unsigned char b_n[48];
    mp_err res;

    ARGCHK(n != NULL && in_x != NULL && in_y != NULL && out_x != NULL &&
               out_y != NULL,
           MP_BADARG);

    /* fail on out of range scalars */
    if (mpl_significant_bits(n) > 384 || mp_cmp_z(n) != 1)
        return MP_RANGE;

    MP_CHECKOK(mp_to_fixlen_octets(n, b_n, 48));
    MP_CHECKOK(mp_to_fixlen_octets(in_x, b_x, 48));
    MP_CHECKOK(mp_to_fixlen_octets(in_y, b_y, 48));
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_BE2LE(b_n);
    point_mul(b_x, b_y, b_n, b_x, b_y);
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_CHECKOK(mp_read_unsigned_octets(out_x, b_x, 48));
    MP_CHECKOK(mp_read_unsigned_octets(out_y, b_y, 48));

CLEANUP:
    return res;
}

static mp_err
point_mul_two_secp384r1(const mp_int *n1, const mp_int *n2,
                        const mp_int *in_x, const mp_int *in_y,
                        mp_int *out_x, mp_int *out_y,
                        const ECGroup *group)
{
    unsigned char b_x[48];
    unsigned char b_y[48];
    unsigned char b_n1[48];
    unsigned char b_n2[48];
    mp_err res;

    /* If n2 == NULL, this is just a base-point multiplication. */
    if (n2 == NULL)
        return point_mul_g_secp384r1(n1, out_x, out_y, group);

    /* If n1 == NULL, this is just an arbitary-point multiplication. */
    if (n1 == NULL)
        return point_mul_secp384r1(n2, in_x, in_y, out_x, out_y, group);

    ARGCHK(in_x != NULL && in_y != NULL && out_x != NULL && out_y != NULL,
           MP_BADARG);

    /* fail on out of range scalars */
    if (mpl_significant_bits(n1) > 384 || mp_cmp_z(n1) != 1 ||
        mpl_significant_bits(n2) > 384 || mp_cmp_z(n2) != 1)
        return MP_RANGE;

    MP_CHECKOK(mp_to_fixlen_octets(n1, b_n1, 48));
    MP_CHECKOK(mp_to_fixlen_octets(n2, b_n2, 48));
    MP_CHECKOK(mp_to_fixlen_octets(in_x, b_x, 48));
    MP_CHECKOK(mp_to_fixlen_octets(in_y, b_y, 48));
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_BE2LE(b_n1);
    MP_BE2LE(b_n2);
    point_mul_two(b_x, b_y, b_n1, b_n2, b_x, b_y);
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_CHECKOK(mp_read_unsigned_octets(out_x, b_x, 48));
    MP_CHECKOK(mp_read_unsigned_octets(out_y, b_y, 48));

CLEANUP:
    return res;
}

mp_err
ec_group_set_secp384r1(ECGroup *group, ECCurveName name)
{
    if (name == ECCurve_NIST_P384) {
        group->base_point_mul = &point_mul_g_secp384r1;
        group->point_mul = &point_mul_secp384r1;
        group->points_mul = &point_mul_two_secp384r1;
    }
    return MP_OKAY;
}

#else /* __SIZEOF_INT128__ */

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 32
#define LIMB_CNT 12
/* Field elements */
typedef uint32_t fe_t[LIMB_CNT];
typedef uint32_t limb_t;

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: word_by_word_montgomery --static secp384r1 32 '2^384 - 2^128 - 2^96 + 2^32 - 1' */
/* curve description: secp384r1 */
/* machine_wordsize = 32 (from "32") */
/* requested operations: (all) */
/* m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from "2^384 - 2^128 - 2^96 + 2^32 - 1") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) + (z[8] << 256) + (z[9] << 0x120) + (z[10] << 0x140) + (z[11] << 0x160) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178) */

#include <stdint.h>
typedef unsigned char fiat_secp384r1_uint1;
typedef signed char fiat_secp384r1_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

/*
 * The function fiat_secp384r1_addcarryx_u32 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void
fiat_secp384r1_addcarryx_u32(uint32_t *out1,
                             fiat_secp384r1_uint1 *out2,
                             fiat_secp384r1_uint1 arg1,
                             uint32_t arg2, uint32_t arg3)
{
    uint64_t x1;
    uint32_t x2;
    fiat_secp384r1_uint1 x3;
    x1 = ((arg1 + (uint64_t)arg2) + arg3);
    x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    x3 = (fiat_secp384r1_uint1)(x1 >> 32);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_secp384r1_subborrowx_u32 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void
fiat_secp384r1_subborrowx_u32(uint32_t *out1,
                              fiat_secp384r1_uint1 *out2,
                              fiat_secp384r1_uint1 arg1,
                              uint32_t arg2, uint32_t arg3)
{
    int64_t x1;
    fiat_secp384r1_int1 x2;
    uint32_t x3;
    x1 = ((arg2 - (int64_t)arg1) - arg3);
    x2 = (fiat_secp384r1_int1)(x1 >> 32);
    x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    *out1 = x3;
    *out2 = (fiat_secp384r1_uint1)(0x0 - x2);
}

/*
 * The function fiat_secp384r1_mulx_u32 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static void
fiat_secp384r1_mulx_u32(uint32_t *out1, uint32_t *out2,
                        uint32_t arg1, uint32_t arg2)
{
    uint64_t x1;
    uint32_t x2;
    uint32_t x3;
    x1 = ((uint64_t)arg1 * arg2);
    x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    x3 = (uint32_t)(x1 >> 32);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_secp384r1_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void
fiat_secp384r1_cmovznz_u32(uint32_t *out1,
                           fiat_secp384r1_uint1 arg1, uint32_t arg2,
                           uint32_t arg3)
{
    fiat_secp384r1_uint1 x1;
    uint32_t x2;
    uint32_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_secp384r1_int1)(0x0 - x1) & UINT32_C(0xffffffff));
    x3 = ((x2 & arg3) | ((~x2) & arg2));
    *out1 = x3;
}

/*
 * The function fiat_secp384r1_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_mul(uint32_t out1[12], const uint32_t arg1[12],
                   const uint32_t arg2[12])
{
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    fiat_secp384r1_uint1 x38;
    uint32_t x39;
    fiat_secp384r1_uint1 x40;
    uint32_t x41;
    fiat_secp384r1_uint1 x42;
    uint32_t x43;
    fiat_secp384r1_uint1 x44;
    uint32_t x45;
    fiat_secp384r1_uint1 x46;
    uint32_t x47;
    fiat_secp384r1_uint1 x48;
    uint32_t x49;
    fiat_secp384r1_uint1 x50;
    uint32_t x51;
    fiat_secp384r1_uint1 x52;
    uint32_t x53;
    fiat_secp384r1_uint1 x54;
    uint32_t x55;
    fiat_secp384r1_uint1 x56;
    uint32_t x57;
    fiat_secp384r1_uint1 x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    uint32_t x78;
    uint32_t x79;
    uint32_t x80;
    fiat_secp384r1_uint1 x81;
    uint32_t x82;
    fiat_secp384r1_uint1 x83;
    uint32_t x84;
    fiat_secp384r1_uint1 x85;
    uint32_t x86;
    fiat_secp384r1_uint1 x87;
    uint32_t x88;
    fiat_secp384r1_uint1 x89;
    uint32_t x90;
    fiat_secp384r1_uint1 x91;
    uint32_t x92;
    fiat_secp384r1_uint1 x93;
    uint32_t x94;
    fiat_secp384r1_uint1 x95;
    uint32_t x96;
    uint32_t x97;
    fiat_secp384r1_uint1 x98;
    uint32_t x99;
    fiat_secp384r1_uint1 x100;
    uint32_t x101;
    fiat_secp384r1_uint1 x102;
    uint32_t x103;
    fiat_secp384r1_uint1 x104;
    uint32_t x105;
    fiat_secp384r1_uint1 x106;
    uint32_t x107;
    fiat_secp384r1_uint1 x108;
    uint32_t x109;
    fiat_secp384r1_uint1 x110;
    uint32_t x111;
    fiat_secp384r1_uint1 x112;
    uint32_t x113;
    fiat_secp384r1_uint1 x114;
    uint32_t x115;
    fiat_secp384r1_uint1 x116;
    uint32_t x117;
    fiat_secp384r1_uint1 x118;
    uint32_t x119;
    fiat_secp384r1_uint1 x120;
    uint32_t x121;
    fiat_secp384r1_uint1 x122;
    uint32_t x123;
    uint32_t x124;
    uint32_t x125;
    uint32_t x126;
    uint32_t x127;
    uint32_t x128;
    uint32_t x129;
    uint32_t x130;
    uint32_t x131;
    uint32_t x132;
    uint32_t x133;
    uint32_t x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    fiat_secp384r1_uint1 x148;
    uint32_t x149;
    fiat_secp384r1_uint1 x150;
    uint32_t x151;
    fiat_secp384r1_uint1 x152;
    uint32_t x153;
    fiat_secp384r1_uint1 x154;
    uint32_t x155;
    fiat_secp384r1_uint1 x156;
    uint32_t x157;
    fiat_secp384r1_uint1 x158;
    uint32_t x159;
    fiat_secp384r1_uint1 x160;
    uint32_t x161;
    fiat_secp384r1_uint1 x162;
    uint32_t x163;
    fiat_secp384r1_uint1 x164;
    uint32_t x165;
    fiat_secp384r1_uint1 x166;
    uint32_t x167;
    fiat_secp384r1_uint1 x168;
    uint32_t x169;
    uint32_t x170;
    fiat_secp384r1_uint1 x171;
    uint32_t x172;
    fiat_secp384r1_uint1 x173;
    uint32_t x174;
    fiat_secp384r1_uint1 x175;
    uint32_t x176;
    fiat_secp384r1_uint1 x177;
    uint32_t x178;
    fiat_secp384r1_uint1 x179;
    uint32_t x180;
    fiat_secp384r1_uint1 x181;
    uint32_t x182;
    fiat_secp384r1_uint1 x183;
    uint32_t x184;
    fiat_secp384r1_uint1 x185;
    uint32_t x186;
    fiat_secp384r1_uint1 x187;
    uint32_t x188;
    fiat_secp384r1_uint1 x189;
    uint32_t x190;
    fiat_secp384r1_uint1 x191;
    uint32_t x192;
    fiat_secp384r1_uint1 x193;
    uint32_t x194;
    fiat_secp384r1_uint1 x195;
    uint32_t x196;
    uint32_t x197;
    uint32_t x198;
    uint32_t x199;
    uint32_t x200;
    uint32_t x201;
    uint32_t x202;
    uint32_t x203;
    uint32_t x204;
    uint32_t x205;
    uint32_t x206;
    uint32_t x207;
    uint32_t x208;
    uint32_t x209;
    uint32_t x210;
    uint32_t x211;
    uint32_t x212;
    uint32_t x213;
    uint32_t x214;
    uint32_t x215;
    uint32_t x216;
    fiat_secp384r1_uint1 x217;
    uint32_t x218;
    fiat_secp384r1_uint1 x219;
    uint32_t x220;
    fiat_secp384r1_uint1 x221;
    uint32_t x222;
    fiat_secp384r1_uint1 x223;
    uint32_t x224;
    fiat_secp384r1_uint1 x225;
    uint32_t x226;
    fiat_secp384r1_uint1 x227;
    uint32_t x228;
    fiat_secp384r1_uint1 x229;
    uint32_t x230;
    fiat_secp384r1_uint1 x231;
    uint32_t x232;
    uint32_t x233;
    fiat_secp384r1_uint1 x234;
    uint32_t x235;
    fiat_secp384r1_uint1 x236;
    uint32_t x237;
    fiat_secp384r1_uint1 x238;
    uint32_t x239;
    fiat_secp384r1_uint1 x240;
    uint32_t x241;
    fiat_secp384r1_uint1 x242;
    uint32_t x243;
    fiat_secp384r1_uint1 x244;
    uint32_t x245;
    fiat_secp384r1_uint1 x246;
    uint32_t x247;
    fiat_secp384r1_uint1 x248;
    uint32_t x249;
    fiat_secp384r1_uint1 x250;
    uint32_t x251;
    fiat_secp384r1_uint1 x252;
    uint32_t x253;
    fiat_secp384r1_uint1 x254;
    uint32_t x255;
    fiat_secp384r1_uint1 x256;
    uint32_t x257;
    fiat_secp384r1_uint1 x258;
    uint32_t x259;
    uint32_t x260;
    uint32_t x261;
    uint32_t x262;
    uint32_t x263;
    uint32_t x264;
    uint32_t x265;
    uint32_t x266;
    uint32_t x267;
    uint32_t x268;
    uint32_t x269;
    uint32_t x270;
    uint32_t x271;
    uint32_t x272;
    uint32_t x273;
    uint32_t x274;
    uint32_t x275;
    uint32_t x276;
    uint32_t x277;
    uint32_t x278;
    uint32_t x279;
    uint32_t x280;
    uint32_t x281;
    uint32_t x282;
    uint32_t x283;
    uint32_t x284;
    fiat_secp384r1_uint1 x285;
    uint32_t x286;
    fiat_secp384r1_uint1 x287;
    uint32_t x288;
    fiat_secp384r1_uint1 x289;
    uint32_t x290;
    fiat_secp384r1_uint1 x291;
    uint32_t x292;
    fiat_secp384r1_uint1 x293;
    uint32_t x294;
    fiat_secp384r1_uint1 x295;
    uint32_t x296;
    fiat_secp384r1_uint1 x297;
    uint32_t x298;
    fiat_secp384r1_uint1 x299;
    uint32_t x300;
    fiat_secp384r1_uint1 x301;
    uint32_t x302;
    fiat_secp384r1_uint1 x303;
    uint32_t x304;
    fiat_secp384r1_uint1 x305;
    uint32_t x306;
    uint32_t x307;
    fiat_secp384r1_uint1 x308;
    uint32_t x309;
    fiat_secp384r1_uint1 x310;
    uint32_t x311;
    fiat_secp384r1_uint1 x312;
    uint32_t x313;
    fiat_secp384r1_uint1 x314;
    uint32_t x315;
    fiat_secp384r1_uint1 x316;
    uint32_t x317;
    fiat_secp384r1_uint1 x318;
    uint32_t x319;
    fiat_secp384r1_uint1 x320;
    uint32_t x321;
    fiat_secp384r1_uint1 x322;
    uint32_t x323;
    fiat_secp384r1_uint1 x324;
    uint32_t x325;
    fiat_secp384r1_uint1 x326;
    uint32_t x327;
    fiat_secp384r1_uint1 x328;
    uint32_t x329;
    fiat_secp384r1_uint1 x330;
    uint32_t x331;
    fiat_secp384r1_uint1 x332;
    uint32_t x333;
    uint32_t x334;
    uint32_t x335;
    uint32_t x336;
    uint32_t x337;
    uint32_t x338;
    uint32_t x339;
    uint32_t x340;
    uint32_t x341;
    uint32_t x342;
    uint32_t x343;
    uint32_t x344;
    uint32_t x345;
    uint32_t x346;
    uint32_t x347;
    uint32_t x348;
    uint32_t x349;
    uint32_t x350;
    uint32_t x351;
    uint32_t x352;
    uint32_t x353;
    fiat_secp384r1_uint1 x354;
    uint32_t x355;
    fiat_secp384r1_uint1 x356;
    uint32_t x357;
    fiat_secp384r1_uint1 x358;
    uint32_t x359;
    fiat_secp384r1_uint1 x360;
    uint32_t x361;
    fiat_secp384r1_uint1 x362;
    uint32_t x363;
    fiat_secp384r1_uint1 x364;
    uint32_t x365;
    fiat_secp384r1_uint1 x366;
    uint32_t x367;
    fiat_secp384r1_uint1 x368;
    uint32_t x369;
    uint32_t x370;
    fiat_secp384r1_uint1 x371;
    uint32_t x372;
    fiat_secp384r1_uint1 x373;
    uint32_t x374;
    fiat_secp384r1_uint1 x375;
    uint32_t x376;
    fiat_secp384r1_uint1 x377;
    uint32_t x378;
    fiat_secp384r1_uint1 x379;
    uint32_t x380;
    fiat_secp384r1_uint1 x381;
    uint32_t x382;
    fiat_secp384r1_uint1 x383;
    uint32_t x384;
    fiat_secp384r1_uint1 x385;
    uint32_t x386;
    fiat_secp384r1_uint1 x387;
    uint32_t x388;
    fiat_secp384r1_uint1 x389;
    uint32_t x390;
    fiat_secp384r1_uint1 x391;
    uint32_t x392;
    fiat_secp384r1_uint1 x393;
    uint32_t x394;
    fiat_secp384r1_uint1 x395;
    uint32_t x396;
    uint32_t x397;
    uint32_t x398;
    uint32_t x399;
    uint32_t x400;
    uint32_t x401;
    uint32_t x402;
    uint32_t x403;
    uint32_t x404;
    uint32_t x405;
    uint32_t x406;
    uint32_t x407;
    uint32_t x408;
    uint32_t x409;
    uint32_t x410;
    uint32_t x411;
    uint32_t x412;
    uint32_t x413;
    uint32_t x414;
    uint32_t x415;
    uint32_t x416;
    uint32_t x417;
    uint32_t x418;
    uint32_t x419;
    uint32_t x420;
    uint32_t x421;
    fiat_secp384r1_uint1 x422;
    uint32_t x423;
    fiat_secp384r1_uint1 x424;
    uint32_t x425;
    fiat_secp384r1_uint1 x426;
    uint32_t x427;
    fiat_secp384r1_uint1 x428;
    uint32_t x429;
    fiat_secp384r1_uint1 x430;
    uint32_t x431;
    fiat_secp384r1_uint1 x432;
    uint32_t x433;
    fiat_secp384r1_uint1 x434;
    uint32_t x435;
    fiat_secp384r1_uint1 x436;
    uint32_t x437;
    fiat_secp384r1_uint1 x438;
    uint32_t x439;
    fiat_secp384r1_uint1 x440;
    uint32_t x441;
    fiat_secp384r1_uint1 x442;
    uint32_t x443;
    uint32_t x444;
    fiat_secp384r1_uint1 x445;
    uint32_t x446;
    fiat_secp384r1_uint1 x447;
    uint32_t x448;
    fiat_secp384r1_uint1 x449;
    uint32_t x450;
    fiat_secp384r1_uint1 x451;
    uint32_t x452;
    fiat_secp384r1_uint1 x453;
    uint32_t x454;
    fiat_secp384r1_uint1 x455;
    uint32_t x456;
    fiat_secp384r1_uint1 x457;
    uint32_t x458;
    fiat_secp384r1_uint1 x459;
    uint32_t x460;
    fiat_secp384r1_uint1 x461;
    uint32_t x462;
    fiat_secp384r1_uint1 x463;
    uint32_t x464;
    fiat_secp384r1_uint1 x465;
    uint32_t x466;
    fiat_secp384r1_uint1 x467;
    uint32_t x468;
    fiat_secp384r1_uint1 x469;
    uint32_t x470;
    uint32_t x471;
    uint32_t x472;
    uint32_t x473;
    uint32_t x474;
    uint32_t x475;
    uint32_t x476;
    uint32_t x477;
    uint32_t x478;
    uint32_t x479;
    uint32_t x480;
    uint32_t x481;
    uint32_t x482;
    uint32_t x483;
    uint32_t x484;
    uint32_t x485;
    uint32_t x486;
    uint32_t x487;
    uint32_t x488;
    uint32_t x489;
    uint32_t x490;
    fiat_secp384r1_uint1 x491;
    uint32_t x492;
    fiat_secp384r1_uint1 x493;
    uint32_t x494;
    fiat_secp384r1_uint1 x495;
    uint32_t x496;
    fiat_secp384r1_uint1 x497;
    uint32_t x498;
    fiat_secp384r1_uint1 x499;
    uint32_t x500;
    fiat_secp384r1_uint1 x501;
    uint32_t x502;
    fiat_secp384r1_uint1 x503;
    uint32_t x504;
    fiat_secp384r1_uint1 x505;
    uint32_t x506;
    uint32_t x507;
    fiat_secp384r1_uint1 x508;
    uint32_t x509;
    fiat_secp384r1_uint1 x510;
    uint32_t x511;
    fiat_secp384r1_uint1 x512;
    uint32_t x513;
    fiat_secp384r1_uint1 x514;
    uint32_t x515;
    fiat_secp384r1_uint1 x516;
    uint32_t x517;
    fiat_secp384r1_uint1 x518;
    uint32_t x519;
    fiat_secp384r1_uint1 x520;
    uint32_t x521;
    fiat_secp384r1_uint1 x522;
    uint32_t x523;
    fiat_secp384r1_uint1 x524;
    uint32_t x525;
    fiat_secp384r1_uint1 x526;
    uint32_t x527;
    fiat_secp384r1_uint1 x528;
    uint32_t x529;
    fiat_secp384r1_uint1 x530;
    uint32_t x531;
    fiat_secp384r1_uint1 x532;
    uint32_t x533;
    uint32_t x534;
    uint32_t x535;
    uint32_t x536;
    uint32_t x537;
    uint32_t x538;
    uint32_t x539;
    uint32_t x540;
    uint32_t x541;
    uint32_t x542;
    uint32_t x543;
    uint32_t x544;
    uint32_t x545;
    uint32_t x546;
    uint32_t x547;
    uint32_t x548;
    uint32_t x549;
    uint32_t x550;
    uint32_t x551;
    uint32_t x552;
    uint32_t x553;
    uint32_t x554;
    uint32_t x555;
    uint32_t x556;
    uint32_t x557;
    uint32_t x558;
    fiat_secp384r1_uint1 x559;
    uint32_t x560;
    fiat_secp384r1_uint1 x561;
    uint32_t x562;
    fiat_secp384r1_uint1 x563;
    uint32_t x564;
    fiat_secp384r1_uint1 x565;
    uint32_t x566;
    fiat_secp384r1_uint1 x567;
    uint32_t x568;
    fiat_secp384r1_uint1 x569;
    uint32_t x570;
    fiat_secp384r1_uint1 x571;
    uint32_t x572;
    fiat_secp384r1_uint1 x573;
    uint32_t x574;
    fiat_secp384r1_uint1 x575;
    uint32_t x576;
    fiat_secp384r1_uint1 x577;
    uint32_t x578;
    fiat_secp384r1_uint1 x579;
    uint32_t x580;
    uint32_t x581;
    fiat_secp384r1_uint1 x582;
    uint32_t x583;
    fiat_secp384r1_uint1 x584;
    uint32_t x585;
    fiat_secp384r1_uint1 x586;
    uint32_t x587;
    fiat_secp384r1_uint1 x588;
    uint32_t x589;
    fiat_secp384r1_uint1 x590;
    uint32_t x591;
    fiat_secp384r1_uint1 x592;
    uint32_t x593;
    fiat_secp384r1_uint1 x594;
    uint32_t x595;
    fiat_secp384r1_uint1 x596;
    uint32_t x597;
    fiat_secp384r1_uint1 x598;
    uint32_t x599;
    fiat_secp384r1_uint1 x600;
    uint32_t x601;
    fiat_secp384r1_uint1 x602;
    uint32_t x603;
    fiat_secp384r1_uint1 x604;
    uint32_t x605;
    fiat_secp384r1_uint1 x606;
    uint32_t x607;
    uint32_t x608;
    uint32_t x609;
    uint32_t x610;
    uint32_t x611;
    uint32_t x612;
    uint32_t x613;
    uint32_t x614;
    uint32_t x615;
    uint32_t x616;
    uint32_t x617;
    uint32_t x618;
    uint32_t x619;
    uint32_t x620;
    uint32_t x621;
    uint32_t x622;
    uint32_t x623;
    uint32_t x624;
    uint32_t x625;
    uint32_t x626;
    uint32_t x627;
    fiat_secp384r1_uint1 x628;
    uint32_t x629;
    fiat_secp384r1_uint1 x630;
    uint32_t x631;
    fiat_secp384r1_uint1 x632;
    uint32_t x633;
    fiat_secp384r1_uint1 x634;
    uint32_t x635;
    fiat_secp384r1_uint1 x636;
    uint32_t x637;
    fiat_secp384r1_uint1 x638;
    uint32_t x639;
    fiat_secp384r1_uint1 x640;
    uint32_t x641;
    fiat_secp384r1_uint1 x642;
    uint32_t x643;
    uint32_t x644;
    fiat_secp384r1_uint1 x645;
    uint32_t x646;
    fiat_secp384r1_uint1 x647;
    uint32_t x648;
    fiat_secp384r1_uint1 x649;
    uint32_t x650;
    fiat_secp384r1_uint1 x651;
    uint32_t x652;
    fiat_secp384r1_uint1 x653;
    uint32_t x654;
    fiat_secp384r1_uint1 x655;
    uint32_t x656;
    fiat_secp384r1_uint1 x657;
    uint32_t x658;
    fiat_secp384r1_uint1 x659;
    uint32_t x660;
    fiat_secp384r1_uint1 x661;
    uint32_t x662;
    fiat_secp384r1_uint1 x663;
    uint32_t x664;
    fiat_secp384r1_uint1 x665;
    uint32_t x666;
    fiat_secp384r1_uint1 x667;
    uint32_t x668;
    fiat_secp384r1_uint1 x669;
    uint32_t x670;
    uint32_t x671;
    uint32_t x672;
    uint32_t x673;
    uint32_t x674;
    uint32_t x675;
    uint32_t x676;
    uint32_t x677;
    uint32_t x678;
    uint32_t x679;
    uint32_t x680;
    uint32_t x681;
    uint32_t x682;
    uint32_t x683;
    uint32_t x684;
    uint32_t x685;
    uint32_t x686;
    uint32_t x687;
    uint32_t x688;
    uint32_t x689;
    uint32_t x690;
    uint32_t x691;
    uint32_t x692;
    uint32_t x693;
    uint32_t x694;
    uint32_t x695;
    fiat_secp384r1_uint1 x696;
    uint32_t x697;
    fiat_secp384r1_uint1 x698;
    uint32_t x699;
    fiat_secp384r1_uint1 x700;
    uint32_t x701;
    fiat_secp384r1_uint1 x702;
    uint32_t x703;
    fiat_secp384r1_uint1 x704;
    uint32_t x705;
    fiat_secp384r1_uint1 x706;
    uint32_t x707;
    fiat_secp384r1_uint1 x708;
    uint32_t x709;
    fiat_secp384r1_uint1 x710;
    uint32_t x711;
    fiat_secp384r1_uint1 x712;
    uint32_t x713;
    fiat_secp384r1_uint1 x714;
    uint32_t x715;
    fiat_secp384r1_uint1 x716;
    uint32_t x717;
    uint32_t x718;
    fiat_secp384r1_uint1 x719;
    uint32_t x720;
    fiat_secp384r1_uint1 x721;
    uint32_t x722;
    fiat_secp384r1_uint1 x723;
    uint32_t x724;
    fiat_secp384r1_uint1 x725;
    uint32_t x726;
    fiat_secp384r1_uint1 x727;
    uint32_t x728;
    fiat_secp384r1_uint1 x729;
    uint32_t x730;
    fiat_secp384r1_uint1 x731;
    uint32_t x732;
    fiat_secp384r1_uint1 x733;
    uint32_t x734;
    fiat_secp384r1_uint1 x735;
    uint32_t x736;
    fiat_secp384r1_uint1 x737;
    uint32_t x738;
    fiat_secp384r1_uint1 x739;
    uint32_t x740;
    fiat_secp384r1_uint1 x741;
    uint32_t x742;
    fiat_secp384r1_uint1 x743;
    uint32_t x744;
    uint32_t x745;
    uint32_t x746;
    uint32_t x747;
    uint32_t x748;
    uint32_t x749;
    uint32_t x750;
    uint32_t x751;
    uint32_t x752;
    uint32_t x753;
    uint32_t x754;
    uint32_t x755;
    uint32_t x756;
    uint32_t x757;
    uint32_t x758;
    uint32_t x759;
    uint32_t x760;
    uint32_t x761;
    uint32_t x762;
    uint32_t x763;
    uint32_t x764;
    fiat_secp384r1_uint1 x765;
    uint32_t x766;
    fiat_secp384r1_uint1 x767;
    uint32_t x768;
    fiat_secp384r1_uint1 x769;
    uint32_t x770;
    fiat_secp384r1_uint1 x771;
    uint32_t x772;
    fiat_secp384r1_uint1 x773;
    uint32_t x774;
    fiat_secp384r1_uint1 x775;
    uint32_t x776;
    fiat_secp384r1_uint1 x777;
    uint32_t x778;
    fiat_secp384r1_uint1 x779;
    uint32_t x780;
    uint32_t x781;
    fiat_secp384r1_uint1 x782;
    uint32_t x783;
    fiat_secp384r1_uint1 x784;
    uint32_t x785;
    fiat_secp384r1_uint1 x786;
    uint32_t x787;
    fiat_secp384r1_uint1 x788;
    uint32_t x789;
    fiat_secp384r1_uint1 x790;
    uint32_t x791;
    fiat_secp384r1_uint1 x792;
    uint32_t x793;
    fiat_secp384r1_uint1 x794;
    uint32_t x795;
    fiat_secp384r1_uint1 x796;
    uint32_t x797;
    fiat_secp384r1_uint1 x798;
    uint32_t x799;
    fiat_secp384r1_uint1 x800;
    uint32_t x801;
    fiat_secp384r1_uint1 x802;
    uint32_t x803;
    fiat_secp384r1_uint1 x804;
    uint32_t x805;
    fiat_secp384r1_uint1 x806;
    uint32_t x807;
    uint32_t x808;
    uint32_t x809;
    uint32_t x810;
    uint32_t x811;
    uint32_t x812;
    uint32_t x813;
    uint32_t x814;
    uint32_t x815;
    uint32_t x816;
    uint32_t x817;
    uint32_t x818;
    uint32_t x819;
    uint32_t x820;
    uint32_t x821;
    uint32_t x822;
    uint32_t x823;
    uint32_t x824;
    uint32_t x825;
    uint32_t x826;
    uint32_t x827;
    uint32_t x828;
    uint32_t x829;
    uint32_t x830;
    uint32_t x831;
    uint32_t x832;
    fiat_secp384r1_uint1 x833;
    uint32_t x834;
    fiat_secp384r1_uint1 x835;
    uint32_t x836;
    fiat_secp384r1_uint1 x837;
    uint32_t x838;
    fiat_secp384r1_uint1 x839;
    uint32_t x840;
    fiat_secp384r1_uint1 x841;
    uint32_t x842;
    fiat_secp384r1_uint1 x843;
    uint32_t x844;
    fiat_secp384r1_uint1 x845;
    uint32_t x846;
    fiat_secp384r1_uint1 x847;
    uint32_t x848;
    fiat_secp384r1_uint1 x849;
    uint32_t x850;
    fiat_secp384r1_uint1 x851;
    uint32_t x852;
    fiat_secp384r1_uint1 x853;
    uint32_t x854;
    uint32_t x855;
    fiat_secp384r1_uint1 x856;
    uint32_t x857;
    fiat_secp384r1_uint1 x858;
    uint32_t x859;
    fiat_secp384r1_uint1 x860;
    uint32_t x861;
    fiat_secp384r1_uint1 x862;
    uint32_t x863;
    fiat_secp384r1_uint1 x864;
    uint32_t x865;
    fiat_secp384r1_uint1 x866;
    uint32_t x867;
    fiat_secp384r1_uint1 x868;
    uint32_t x869;
    fiat_secp384r1_uint1 x870;
    uint32_t x871;
    fiat_secp384r1_uint1 x872;
    uint32_t x873;
    fiat_secp384r1_uint1 x874;
    uint32_t x875;
    fiat_secp384r1_uint1 x876;
    uint32_t x877;
    fiat_secp384r1_uint1 x878;
    uint32_t x879;
    fiat_secp384r1_uint1 x880;
    uint32_t x881;
    uint32_t x882;
    uint32_t x883;
    uint32_t x884;
    uint32_t x885;
    uint32_t x886;
    uint32_t x887;
    uint32_t x888;
    uint32_t x889;
    uint32_t x890;
    uint32_t x891;
    uint32_t x892;
    uint32_t x893;
    uint32_t x894;
    uint32_t x895;
    uint32_t x896;
    uint32_t x897;
    uint32_t x898;
    uint32_t x899;
    uint32_t x900;
    uint32_t x901;
    fiat_secp384r1_uint1 x902;
    uint32_t x903;
    fiat_secp384r1_uint1 x904;
    uint32_t x905;
    fiat_secp384r1_uint1 x906;
    uint32_t x907;
    fiat_secp384r1_uint1 x908;
    uint32_t x909;
    fiat_secp384r1_uint1 x910;
    uint32_t x911;
    fiat_secp384r1_uint1 x912;
    uint32_t x913;
    fiat_secp384r1_uint1 x914;
    uint32_t x915;
    fiat_secp384r1_uint1 x916;
    uint32_t x917;
    uint32_t x918;
    fiat_secp384r1_uint1 x919;
    uint32_t x920;
    fiat_secp384r1_uint1 x921;
    uint32_t x922;
    fiat_secp384r1_uint1 x923;
    uint32_t x924;
    fiat_secp384r1_uint1 x925;
    uint32_t x926;
    fiat_secp384r1_uint1 x927;
    uint32_t x928;
    fiat_secp384r1_uint1 x929;
    uint32_t x930;
    fiat_secp384r1_uint1 x931;
    uint32_t x932;
    fiat_secp384r1_uint1 x933;
    uint32_t x934;
    fiat_secp384r1_uint1 x935;
    uint32_t x936;
    fiat_secp384r1_uint1 x937;
    uint32_t x938;
    fiat_secp384r1_uint1 x939;
    uint32_t x940;
    fiat_secp384r1_uint1 x941;
    uint32_t x942;
    fiat_secp384r1_uint1 x943;
    uint32_t x944;
    uint32_t x945;
    uint32_t x946;
    uint32_t x947;
    uint32_t x948;
    uint32_t x949;
    uint32_t x950;
    uint32_t x951;
    uint32_t x952;
    uint32_t x953;
    uint32_t x954;
    uint32_t x955;
    uint32_t x956;
    uint32_t x957;
    uint32_t x958;
    uint32_t x959;
    uint32_t x960;
    uint32_t x961;
    uint32_t x962;
    uint32_t x963;
    uint32_t x964;
    uint32_t x965;
    uint32_t x966;
    uint32_t x967;
    uint32_t x968;
    uint32_t x969;
    fiat_secp384r1_uint1 x970;
    uint32_t x971;
    fiat_secp384r1_uint1 x972;
    uint32_t x973;
    fiat_secp384r1_uint1 x974;
    uint32_t x975;
    fiat_secp384r1_uint1 x976;
    uint32_t x977;
    fiat_secp384r1_uint1 x978;
    uint32_t x979;
    fiat_secp384r1_uint1 x980;
    uint32_t x981;
    fiat_secp384r1_uint1 x982;
    uint32_t x983;
    fiat_secp384r1_uint1 x984;
    uint32_t x985;
    fiat_secp384r1_uint1 x986;
    uint32_t x987;
    fiat_secp384r1_uint1 x988;
    uint32_t x989;
    fiat_secp384r1_uint1 x990;
    uint32_t x991;
    uint32_t x992;
    fiat_secp384r1_uint1 x993;
    uint32_t x994;
    fiat_secp384r1_uint1 x995;
    uint32_t x996;
    fiat_secp384r1_uint1 x997;
    uint32_t x998;
    fiat_secp384r1_uint1 x999;
    uint32_t x1000;
    fiat_secp384r1_uint1 x1001;
    uint32_t x1002;
    fiat_secp384r1_uint1 x1003;
    uint32_t x1004;
    fiat_secp384r1_uint1 x1005;
    uint32_t x1006;
    fiat_secp384r1_uint1 x1007;
    uint32_t x1008;
    fiat_secp384r1_uint1 x1009;
    uint32_t x1010;
    fiat_secp384r1_uint1 x1011;
    uint32_t x1012;
    fiat_secp384r1_uint1 x1013;
    uint32_t x1014;
    fiat_secp384r1_uint1 x1015;
    uint32_t x1016;
    fiat_secp384r1_uint1 x1017;
    uint32_t x1018;
    uint32_t x1019;
    uint32_t x1020;
    uint32_t x1021;
    uint32_t x1022;
    uint32_t x1023;
    uint32_t x1024;
    uint32_t x1025;
    uint32_t x1026;
    uint32_t x1027;
    uint32_t x1028;
    uint32_t x1029;
    uint32_t x1030;
    uint32_t x1031;
    uint32_t x1032;
    uint32_t x1033;
    uint32_t x1034;
    uint32_t x1035;
    uint32_t x1036;
    uint32_t x1037;
    uint32_t x1038;
    fiat_secp384r1_uint1 x1039;
    uint32_t x1040;
    fiat_secp384r1_uint1 x1041;
    uint32_t x1042;
    fiat_secp384r1_uint1 x1043;
    uint32_t x1044;
    fiat_secp384r1_uint1 x1045;
    uint32_t x1046;
    fiat_secp384r1_uint1 x1047;
    uint32_t x1048;
    fiat_secp384r1_uint1 x1049;
    uint32_t x1050;
    fiat_secp384r1_uint1 x1051;
    uint32_t x1052;
    fiat_secp384r1_uint1 x1053;
    uint32_t x1054;
    uint32_t x1055;
    fiat_secp384r1_uint1 x1056;
    uint32_t x1057;
    fiat_secp384r1_uint1 x1058;
    uint32_t x1059;
    fiat_secp384r1_uint1 x1060;
    uint32_t x1061;
    fiat_secp384r1_uint1 x1062;
    uint32_t x1063;
    fiat_secp384r1_uint1 x1064;
    uint32_t x1065;
    fiat_secp384r1_uint1 x1066;
    uint32_t x1067;
    fiat_secp384r1_uint1 x1068;
    uint32_t x1069;
    fiat_secp384r1_uint1 x1070;
    uint32_t x1071;
    fiat_secp384r1_uint1 x1072;
    uint32_t x1073;
    fiat_secp384r1_uint1 x1074;
    uint32_t x1075;
    fiat_secp384r1_uint1 x1076;
    uint32_t x1077;
    fiat_secp384r1_uint1 x1078;
    uint32_t x1079;
    fiat_secp384r1_uint1 x1080;
    uint32_t x1081;
    uint32_t x1082;
    uint32_t x1083;
    uint32_t x1084;
    uint32_t x1085;
    uint32_t x1086;
    uint32_t x1087;
    uint32_t x1088;
    uint32_t x1089;
    uint32_t x1090;
    uint32_t x1091;
    uint32_t x1092;
    uint32_t x1093;
    uint32_t x1094;
    uint32_t x1095;
    uint32_t x1096;
    uint32_t x1097;
    uint32_t x1098;
    uint32_t x1099;
    uint32_t x1100;
    uint32_t x1101;
    uint32_t x1102;
    uint32_t x1103;
    uint32_t x1104;
    uint32_t x1105;
    uint32_t x1106;
    fiat_secp384r1_uint1 x1107;
    uint32_t x1108;
    fiat_secp384r1_uint1 x1109;
    uint32_t x1110;
    fiat_secp384r1_uint1 x1111;
    uint32_t x1112;
    fiat_secp384r1_uint1 x1113;
    uint32_t x1114;
    fiat_secp384r1_uint1 x1115;
    uint32_t x1116;
    fiat_secp384r1_uint1 x1117;
    uint32_t x1118;
    fiat_secp384r1_uint1 x1119;
    uint32_t x1120;
    fiat_secp384r1_uint1 x1121;
    uint32_t x1122;
    fiat_secp384r1_uint1 x1123;
    uint32_t x1124;
    fiat_secp384r1_uint1 x1125;
    uint32_t x1126;
    fiat_secp384r1_uint1 x1127;
    uint32_t x1128;
    uint32_t x1129;
    fiat_secp384r1_uint1 x1130;
    uint32_t x1131;
    fiat_secp384r1_uint1 x1132;
    uint32_t x1133;
    fiat_secp384r1_uint1 x1134;
    uint32_t x1135;
    fiat_secp384r1_uint1 x1136;
    uint32_t x1137;
    fiat_secp384r1_uint1 x1138;
    uint32_t x1139;
    fiat_secp384r1_uint1 x1140;
    uint32_t x1141;
    fiat_secp384r1_uint1 x1142;
    uint32_t x1143;
    fiat_secp384r1_uint1 x1144;
    uint32_t x1145;
    fiat_secp384r1_uint1 x1146;
    uint32_t x1147;
    fiat_secp384r1_uint1 x1148;
    uint32_t x1149;
    fiat_secp384r1_uint1 x1150;
    uint32_t x1151;
    fiat_secp384r1_uint1 x1152;
    uint32_t x1153;
    fiat_secp384r1_uint1 x1154;
    uint32_t x1155;
    uint32_t x1156;
    uint32_t x1157;
    uint32_t x1158;
    uint32_t x1159;
    uint32_t x1160;
    uint32_t x1161;
    uint32_t x1162;
    uint32_t x1163;
    uint32_t x1164;
    uint32_t x1165;
    uint32_t x1166;
    uint32_t x1167;
    uint32_t x1168;
    uint32_t x1169;
    uint32_t x1170;
    uint32_t x1171;
    uint32_t x1172;
    uint32_t x1173;
    uint32_t x1174;
    uint32_t x1175;
    fiat_secp384r1_uint1 x1176;
    uint32_t x1177;
    fiat_secp384r1_uint1 x1178;
    uint32_t x1179;
    fiat_secp384r1_uint1 x1180;
    uint32_t x1181;
    fiat_secp384r1_uint1 x1182;
    uint32_t x1183;
    fiat_secp384r1_uint1 x1184;
    uint32_t x1185;
    fiat_secp384r1_uint1 x1186;
    uint32_t x1187;
    fiat_secp384r1_uint1 x1188;
    uint32_t x1189;
    fiat_secp384r1_uint1 x1190;
    uint32_t x1191;
    uint32_t x1192;
    fiat_secp384r1_uint1 x1193;
    uint32_t x1194;
    fiat_secp384r1_uint1 x1195;
    uint32_t x1196;
    fiat_secp384r1_uint1 x1197;
    uint32_t x1198;
    fiat_secp384r1_uint1 x1199;
    uint32_t x1200;
    fiat_secp384r1_uint1 x1201;
    uint32_t x1202;
    fiat_secp384r1_uint1 x1203;
    uint32_t x1204;
    fiat_secp384r1_uint1 x1205;
    uint32_t x1206;
    fiat_secp384r1_uint1 x1207;
    uint32_t x1208;
    fiat_secp384r1_uint1 x1209;
    uint32_t x1210;
    fiat_secp384r1_uint1 x1211;
    uint32_t x1212;
    fiat_secp384r1_uint1 x1213;
    uint32_t x1214;
    fiat_secp384r1_uint1 x1215;
    uint32_t x1216;
    fiat_secp384r1_uint1 x1217;
    uint32_t x1218;
    uint32_t x1219;
    uint32_t x1220;
    uint32_t x1221;
    uint32_t x1222;
    uint32_t x1223;
    uint32_t x1224;
    uint32_t x1225;
    uint32_t x1226;
    uint32_t x1227;
    uint32_t x1228;
    uint32_t x1229;
    uint32_t x1230;
    uint32_t x1231;
    uint32_t x1232;
    uint32_t x1233;
    uint32_t x1234;
    uint32_t x1235;
    uint32_t x1236;
    uint32_t x1237;
    uint32_t x1238;
    uint32_t x1239;
    uint32_t x1240;
    uint32_t x1241;
    uint32_t x1242;
    uint32_t x1243;
    fiat_secp384r1_uint1 x1244;
    uint32_t x1245;
    fiat_secp384r1_uint1 x1246;
    uint32_t x1247;
    fiat_secp384r1_uint1 x1248;
    uint32_t x1249;
    fiat_secp384r1_uint1 x1250;
    uint32_t x1251;
    fiat_secp384r1_uint1 x1252;
    uint32_t x1253;
    fiat_secp384r1_uint1 x1254;
    uint32_t x1255;
    fiat_secp384r1_uint1 x1256;
    uint32_t x1257;
    fiat_secp384r1_uint1 x1258;
    uint32_t x1259;
    fiat_secp384r1_uint1 x1260;
    uint32_t x1261;
    fiat_secp384r1_uint1 x1262;
    uint32_t x1263;
    fiat_secp384r1_uint1 x1264;
    uint32_t x1265;
    uint32_t x1266;
    fiat_secp384r1_uint1 x1267;
    uint32_t x1268;
    fiat_secp384r1_uint1 x1269;
    uint32_t x1270;
    fiat_secp384r1_uint1 x1271;
    uint32_t x1272;
    fiat_secp384r1_uint1 x1273;
    uint32_t x1274;
    fiat_secp384r1_uint1 x1275;
    uint32_t x1276;
    fiat_secp384r1_uint1 x1277;
    uint32_t x1278;
    fiat_secp384r1_uint1 x1279;
    uint32_t x1280;
    fiat_secp384r1_uint1 x1281;
    uint32_t x1282;
    fiat_secp384r1_uint1 x1283;
    uint32_t x1284;
    fiat_secp384r1_uint1 x1285;
    uint32_t x1286;
    fiat_secp384r1_uint1 x1287;
    uint32_t x1288;
    fiat_secp384r1_uint1 x1289;
    uint32_t x1290;
    fiat_secp384r1_uint1 x1291;
    uint32_t x1292;
    uint32_t x1293;
    uint32_t x1294;
    uint32_t x1295;
    uint32_t x1296;
    uint32_t x1297;
    uint32_t x1298;
    uint32_t x1299;
    uint32_t x1300;
    uint32_t x1301;
    uint32_t x1302;
    uint32_t x1303;
    uint32_t x1304;
    uint32_t x1305;
    uint32_t x1306;
    uint32_t x1307;
    uint32_t x1308;
    uint32_t x1309;
    uint32_t x1310;
    uint32_t x1311;
    uint32_t x1312;
    fiat_secp384r1_uint1 x1313;
    uint32_t x1314;
    fiat_secp384r1_uint1 x1315;
    uint32_t x1316;
    fiat_secp384r1_uint1 x1317;
    uint32_t x1318;
    fiat_secp384r1_uint1 x1319;
    uint32_t x1320;
    fiat_secp384r1_uint1 x1321;
    uint32_t x1322;
    fiat_secp384r1_uint1 x1323;
    uint32_t x1324;
    fiat_secp384r1_uint1 x1325;
    uint32_t x1326;
    fiat_secp384r1_uint1 x1327;
    uint32_t x1328;
    uint32_t x1329;
    fiat_secp384r1_uint1 x1330;
    uint32_t x1331;
    fiat_secp384r1_uint1 x1332;
    uint32_t x1333;
    fiat_secp384r1_uint1 x1334;
    uint32_t x1335;
    fiat_secp384r1_uint1 x1336;
    uint32_t x1337;
    fiat_secp384r1_uint1 x1338;
    uint32_t x1339;
    fiat_secp384r1_uint1 x1340;
    uint32_t x1341;
    fiat_secp384r1_uint1 x1342;
    uint32_t x1343;
    fiat_secp384r1_uint1 x1344;
    uint32_t x1345;
    fiat_secp384r1_uint1 x1346;
    uint32_t x1347;
    fiat_secp384r1_uint1 x1348;
    uint32_t x1349;
    fiat_secp384r1_uint1 x1350;
    uint32_t x1351;
    fiat_secp384r1_uint1 x1352;
    uint32_t x1353;
    fiat_secp384r1_uint1 x1354;
    uint32_t x1355;
    uint32_t x1356;
    uint32_t x1357;
    uint32_t x1358;
    uint32_t x1359;
    uint32_t x1360;
    uint32_t x1361;
    uint32_t x1362;
    uint32_t x1363;
    uint32_t x1364;
    uint32_t x1365;
    uint32_t x1366;
    uint32_t x1367;
    uint32_t x1368;
    uint32_t x1369;
    uint32_t x1370;
    uint32_t x1371;
    uint32_t x1372;
    uint32_t x1373;
    uint32_t x1374;
    uint32_t x1375;
    uint32_t x1376;
    uint32_t x1377;
    uint32_t x1378;
    uint32_t x1379;
    uint32_t x1380;
    fiat_secp384r1_uint1 x1381;
    uint32_t x1382;
    fiat_secp384r1_uint1 x1383;
    uint32_t x1384;
    fiat_secp384r1_uint1 x1385;
    uint32_t x1386;
    fiat_secp384r1_uint1 x1387;
    uint32_t x1388;
    fiat_secp384r1_uint1 x1389;
    uint32_t x1390;
    fiat_secp384r1_uint1 x1391;
    uint32_t x1392;
    fiat_secp384r1_uint1 x1393;
    uint32_t x1394;
    fiat_secp384r1_uint1 x1395;
    uint32_t x1396;
    fiat_secp384r1_uint1 x1397;
    uint32_t x1398;
    fiat_secp384r1_uint1 x1399;
    uint32_t x1400;
    fiat_secp384r1_uint1 x1401;
    uint32_t x1402;
    uint32_t x1403;
    fiat_secp384r1_uint1 x1404;
    uint32_t x1405;
    fiat_secp384r1_uint1 x1406;
    uint32_t x1407;
    fiat_secp384r1_uint1 x1408;
    uint32_t x1409;
    fiat_secp384r1_uint1 x1410;
    uint32_t x1411;
    fiat_secp384r1_uint1 x1412;
    uint32_t x1413;
    fiat_secp384r1_uint1 x1414;
    uint32_t x1415;
    fiat_secp384r1_uint1 x1416;
    uint32_t x1417;
    fiat_secp384r1_uint1 x1418;
    uint32_t x1419;
    fiat_secp384r1_uint1 x1420;
    uint32_t x1421;
    fiat_secp384r1_uint1 x1422;
    uint32_t x1423;
    fiat_secp384r1_uint1 x1424;
    uint32_t x1425;
    fiat_secp384r1_uint1 x1426;
    uint32_t x1427;
    fiat_secp384r1_uint1 x1428;
    uint32_t x1429;
    uint32_t x1430;
    uint32_t x1431;
    uint32_t x1432;
    uint32_t x1433;
    uint32_t x1434;
    uint32_t x1435;
    uint32_t x1436;
    uint32_t x1437;
    uint32_t x1438;
    uint32_t x1439;
    uint32_t x1440;
    uint32_t x1441;
    uint32_t x1442;
    uint32_t x1443;
    uint32_t x1444;
    uint32_t x1445;
    uint32_t x1446;
    uint32_t x1447;
    uint32_t x1448;
    uint32_t x1449;
    fiat_secp384r1_uint1 x1450;
    uint32_t x1451;
    fiat_secp384r1_uint1 x1452;
    uint32_t x1453;
    fiat_secp384r1_uint1 x1454;
    uint32_t x1455;
    fiat_secp384r1_uint1 x1456;
    uint32_t x1457;
    fiat_secp384r1_uint1 x1458;
    uint32_t x1459;
    fiat_secp384r1_uint1 x1460;
    uint32_t x1461;
    fiat_secp384r1_uint1 x1462;
    uint32_t x1463;
    fiat_secp384r1_uint1 x1464;
    uint32_t x1465;
    uint32_t x1466;
    fiat_secp384r1_uint1 x1467;
    uint32_t x1468;
    fiat_secp384r1_uint1 x1469;
    uint32_t x1470;
    fiat_secp384r1_uint1 x1471;
    uint32_t x1472;
    fiat_secp384r1_uint1 x1473;
    uint32_t x1474;
    fiat_secp384r1_uint1 x1475;
    uint32_t x1476;
    fiat_secp384r1_uint1 x1477;
    uint32_t x1478;
    fiat_secp384r1_uint1 x1479;
    uint32_t x1480;
    fiat_secp384r1_uint1 x1481;
    uint32_t x1482;
    fiat_secp384r1_uint1 x1483;
    uint32_t x1484;
    fiat_secp384r1_uint1 x1485;
    uint32_t x1486;
    fiat_secp384r1_uint1 x1487;
    uint32_t x1488;
    fiat_secp384r1_uint1 x1489;
    uint32_t x1490;
    fiat_secp384r1_uint1 x1491;
    uint32_t x1492;
    uint32_t x1493;
    uint32_t x1494;
    uint32_t x1495;
    uint32_t x1496;
    uint32_t x1497;
    uint32_t x1498;
    uint32_t x1499;
    uint32_t x1500;
    uint32_t x1501;
    uint32_t x1502;
    uint32_t x1503;
    uint32_t x1504;
    uint32_t x1505;
    uint32_t x1506;
    uint32_t x1507;
    uint32_t x1508;
    uint32_t x1509;
    uint32_t x1510;
    uint32_t x1511;
    uint32_t x1512;
    uint32_t x1513;
    uint32_t x1514;
    uint32_t x1515;
    uint32_t x1516;
    uint32_t x1517;
    fiat_secp384r1_uint1 x1518;
    uint32_t x1519;
    fiat_secp384r1_uint1 x1520;
    uint32_t x1521;
    fiat_secp384r1_uint1 x1522;
    uint32_t x1523;
    fiat_secp384r1_uint1 x1524;
    uint32_t x1525;
    fiat_secp384r1_uint1 x1526;
    uint32_t x1527;
    fiat_secp384r1_uint1 x1528;
    uint32_t x1529;
    fiat_secp384r1_uint1 x1530;
    uint32_t x1531;
    fiat_secp384r1_uint1 x1532;
    uint32_t x1533;
    fiat_secp384r1_uint1 x1534;
    uint32_t x1535;
    fiat_secp384r1_uint1 x1536;
    uint32_t x1537;
    fiat_secp384r1_uint1 x1538;
    uint32_t x1539;
    uint32_t x1540;
    fiat_secp384r1_uint1 x1541;
    uint32_t x1542;
    fiat_secp384r1_uint1 x1543;
    uint32_t x1544;
    fiat_secp384r1_uint1 x1545;
    uint32_t x1546;
    fiat_secp384r1_uint1 x1547;
    uint32_t x1548;
    fiat_secp384r1_uint1 x1549;
    uint32_t x1550;
    fiat_secp384r1_uint1 x1551;
    uint32_t x1552;
    fiat_secp384r1_uint1 x1553;
    uint32_t x1554;
    fiat_secp384r1_uint1 x1555;
    uint32_t x1556;
    fiat_secp384r1_uint1 x1557;
    uint32_t x1558;
    fiat_secp384r1_uint1 x1559;
    uint32_t x1560;
    fiat_secp384r1_uint1 x1561;
    uint32_t x1562;
    fiat_secp384r1_uint1 x1563;
    uint32_t x1564;
    fiat_secp384r1_uint1 x1565;
    uint32_t x1566;
    uint32_t x1567;
    uint32_t x1568;
    uint32_t x1569;
    uint32_t x1570;
    uint32_t x1571;
    uint32_t x1572;
    uint32_t x1573;
    uint32_t x1574;
    uint32_t x1575;
    uint32_t x1576;
    uint32_t x1577;
    uint32_t x1578;
    uint32_t x1579;
    uint32_t x1580;
    uint32_t x1581;
    uint32_t x1582;
    uint32_t x1583;
    uint32_t x1584;
    uint32_t x1585;
    uint32_t x1586;
    fiat_secp384r1_uint1 x1587;
    uint32_t x1588;
    fiat_secp384r1_uint1 x1589;
    uint32_t x1590;
    fiat_secp384r1_uint1 x1591;
    uint32_t x1592;
    fiat_secp384r1_uint1 x1593;
    uint32_t x1594;
    fiat_secp384r1_uint1 x1595;
    uint32_t x1596;
    fiat_secp384r1_uint1 x1597;
    uint32_t x1598;
    fiat_secp384r1_uint1 x1599;
    uint32_t x1600;
    fiat_secp384r1_uint1 x1601;
    uint32_t x1602;
    uint32_t x1603;
    fiat_secp384r1_uint1 x1604;
    uint32_t x1605;
    fiat_secp384r1_uint1 x1606;
    uint32_t x1607;
    fiat_secp384r1_uint1 x1608;
    uint32_t x1609;
    fiat_secp384r1_uint1 x1610;
    uint32_t x1611;
    fiat_secp384r1_uint1 x1612;
    uint32_t x1613;
    fiat_secp384r1_uint1 x1614;
    uint32_t x1615;
    fiat_secp384r1_uint1 x1616;
    uint32_t x1617;
    fiat_secp384r1_uint1 x1618;
    uint32_t x1619;
    fiat_secp384r1_uint1 x1620;
    uint32_t x1621;
    fiat_secp384r1_uint1 x1622;
    uint32_t x1623;
    fiat_secp384r1_uint1 x1624;
    uint32_t x1625;
    fiat_secp384r1_uint1 x1626;
    uint32_t x1627;
    fiat_secp384r1_uint1 x1628;
    uint32_t x1629;
    uint32_t x1630;
    fiat_secp384r1_uint1 x1631;
    uint32_t x1632;
    fiat_secp384r1_uint1 x1633;
    uint32_t x1634;
    fiat_secp384r1_uint1 x1635;
    uint32_t x1636;
    fiat_secp384r1_uint1 x1637;
    uint32_t x1638;
    fiat_secp384r1_uint1 x1639;
    uint32_t x1640;
    fiat_secp384r1_uint1 x1641;
    uint32_t x1642;
    fiat_secp384r1_uint1 x1643;
    uint32_t x1644;
    fiat_secp384r1_uint1 x1645;
    uint32_t x1646;
    fiat_secp384r1_uint1 x1647;
    uint32_t x1648;
    fiat_secp384r1_uint1 x1649;
    uint32_t x1650;
    fiat_secp384r1_uint1 x1651;
    uint32_t x1652;
    fiat_secp384r1_uint1 x1653;
    uint32_t x1654;
    fiat_secp384r1_uint1 x1655;
    uint32_t x1656;
    uint32_t x1657;
    uint32_t x1658;
    uint32_t x1659;
    uint32_t x1660;
    uint32_t x1661;
    uint32_t x1662;
    uint32_t x1663;
    uint32_t x1664;
    uint32_t x1665;
    uint32_t x1666;
    uint32_t x1667;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[8]);
    x9 = (arg1[9]);
    x10 = (arg1[10]);
    x11 = (arg1[11]);
    x12 = (arg1[0]);
    fiat_secp384r1_mulx_u32(&x13, &x14, x12, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x15, &x16, x12, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x17, &x18, x12, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x19, &x20, x12, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x21, &x22, x12, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x23, &x24, x12, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x25, &x26, x12, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x27, &x28, x12, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x29, &x30, x12, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x31, &x32, x12, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x33, &x34, x12, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x35, &x36, x12, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x37, &x38, 0x0, x36, x33);
    fiat_secp384r1_addcarryx_u32(&x39, &x40, x38, x34, x31);
    fiat_secp384r1_addcarryx_u32(&x41, &x42, x40, x32, x29);
    fiat_secp384r1_addcarryx_u32(&x43, &x44, x42, x30, x27);
    fiat_secp384r1_addcarryx_u32(&x45, &x46, x44, x28, x25);
    fiat_secp384r1_addcarryx_u32(&x47, &x48, x46, x26, x23);
    fiat_secp384r1_addcarryx_u32(&x49, &x50, x48, x24, x21);
    fiat_secp384r1_addcarryx_u32(&x51, &x52, x50, x22, x19);
    fiat_secp384r1_addcarryx_u32(&x53, &x54, x52, x20, x17);
    fiat_secp384r1_addcarryx_u32(&x55, &x56, x54, x18, x15);
    fiat_secp384r1_addcarryx_u32(&x57, &x58, x56, x16, x13);
    x59 = (x58 + x14);
    fiat_secp384r1_mulx_u32(&x60, &x61, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x62, &x63, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x64, &x65, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x66, &x67, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x68, &x69, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x70, &x71, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x72, &x73, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x74, &x75, x35, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x76, &x77, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x78, &x79, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x80, &x81, 0x0, x77, x74);
    fiat_secp384r1_addcarryx_u32(&x82, &x83, x81, x75, x72);
    fiat_secp384r1_addcarryx_u32(&x84, &x85, x83, x73, x70);
    fiat_secp384r1_addcarryx_u32(&x86, &x87, x85, x71, x68);
    fiat_secp384r1_addcarryx_u32(&x88, &x89, x87, x69, x66);
    fiat_secp384r1_addcarryx_u32(&x90, &x91, x89, x67, x64);
    fiat_secp384r1_addcarryx_u32(&x92, &x93, x91, x65, x62);
    fiat_secp384r1_addcarryx_u32(&x94, &x95, x93, x63, x60);
    x96 = (x95 + x61);
    fiat_secp384r1_addcarryx_u32(&x97, &x98, 0x0, x35, x78);
    fiat_secp384r1_addcarryx_u32(&x99, &x100, x98, x37, x79);
    fiat_secp384r1_addcarryx_u32(&x101, &x102, x100, x39, 0x0);
    fiat_secp384r1_addcarryx_u32(&x103, &x104, x102, x41, x76);
    fiat_secp384r1_addcarryx_u32(&x105, &x106, x104, x43, x80);
    fiat_secp384r1_addcarryx_u32(&x107, &x108, x106, x45, x82);
    fiat_secp384r1_addcarryx_u32(&x109, &x110, x108, x47, x84);
    fiat_secp384r1_addcarryx_u32(&x111, &x112, x110, x49, x86);
    fiat_secp384r1_addcarryx_u32(&x113, &x114, x112, x51, x88);
    fiat_secp384r1_addcarryx_u32(&x115, &x116, x114, x53, x90);
    fiat_secp384r1_addcarryx_u32(&x117, &x118, x116, x55, x92);
    fiat_secp384r1_addcarryx_u32(&x119, &x120, x118, x57, x94);
    fiat_secp384r1_addcarryx_u32(&x121, &x122, x120, x59, x96);
    fiat_secp384r1_mulx_u32(&x123, &x124, x1, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x125, &x126, x1, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x127, &x128, x1, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x129, &x130, x1, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x131, &x132, x1, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x133, &x134, x1, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x135, &x136, x1, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x137, &x138, x1, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x139, &x140, x1, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x141, &x142, x1, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x143, &x144, x1, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x145, &x146, x1, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x147, &x148, 0x0, x146, x143);
    fiat_secp384r1_addcarryx_u32(&x149, &x150, x148, x144, x141);
    fiat_secp384r1_addcarryx_u32(&x151, &x152, x150, x142, x139);
    fiat_secp384r1_addcarryx_u32(&x153, &x154, x152, x140, x137);
    fiat_secp384r1_addcarryx_u32(&x155, &x156, x154, x138, x135);
    fiat_secp384r1_addcarryx_u32(&x157, &x158, x156, x136, x133);
    fiat_secp384r1_addcarryx_u32(&x159, &x160, x158, x134, x131);
    fiat_secp384r1_addcarryx_u32(&x161, &x162, x160, x132, x129);
    fiat_secp384r1_addcarryx_u32(&x163, &x164, x162, x130, x127);
    fiat_secp384r1_addcarryx_u32(&x165, &x166, x164, x128, x125);
    fiat_secp384r1_addcarryx_u32(&x167, &x168, x166, x126, x123);
    x169 = (x168 + x124);
    fiat_secp384r1_addcarryx_u32(&x170, &x171, 0x0, x99, x145);
    fiat_secp384r1_addcarryx_u32(&x172, &x173, x171, x101, x147);
    fiat_secp384r1_addcarryx_u32(&x174, &x175, x173, x103, x149);
    fiat_secp384r1_addcarryx_u32(&x176, &x177, x175, x105, x151);
    fiat_secp384r1_addcarryx_u32(&x178, &x179, x177, x107, x153);
    fiat_secp384r1_addcarryx_u32(&x180, &x181, x179, x109, x155);
    fiat_secp384r1_addcarryx_u32(&x182, &x183, x181, x111, x157);
    fiat_secp384r1_addcarryx_u32(&x184, &x185, x183, x113, x159);
    fiat_secp384r1_addcarryx_u32(&x186, &x187, x185, x115, x161);
    fiat_secp384r1_addcarryx_u32(&x188, &x189, x187, x117, x163);
    fiat_secp384r1_addcarryx_u32(&x190, &x191, x189, x119, x165);
    fiat_secp384r1_addcarryx_u32(&x192, &x193, x191, x121, x167);
    fiat_secp384r1_addcarryx_u32(&x194, &x195, x193, x122, x169);
    fiat_secp384r1_mulx_u32(&x196, &x197, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x198, &x199, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x200, &x201, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x202, &x203, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x204, &x205, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x206, &x207, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x208, &x209, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x210, &x211, x170, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x212, &x213, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x214, &x215, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x216, &x217, 0x0, x213, x210);
    fiat_secp384r1_addcarryx_u32(&x218, &x219, x217, x211, x208);
    fiat_secp384r1_addcarryx_u32(&x220, &x221, x219, x209, x206);
    fiat_secp384r1_addcarryx_u32(&x222, &x223, x221, x207, x204);
    fiat_secp384r1_addcarryx_u32(&x224, &x225, x223, x205, x202);
    fiat_secp384r1_addcarryx_u32(&x226, &x227, x225, x203, x200);
    fiat_secp384r1_addcarryx_u32(&x228, &x229, x227, x201, x198);
    fiat_secp384r1_addcarryx_u32(&x230, &x231, x229, x199, x196);
    x232 = (x231 + x197);
    fiat_secp384r1_addcarryx_u32(&x233, &x234, 0x0, x170, x214);
    fiat_secp384r1_addcarryx_u32(&x235, &x236, x234, x172, x215);
    fiat_secp384r1_addcarryx_u32(&x237, &x238, x236, x174, 0x0);
    fiat_secp384r1_addcarryx_u32(&x239, &x240, x238, x176, x212);
    fiat_secp384r1_addcarryx_u32(&x241, &x242, x240, x178, x216);
    fiat_secp384r1_addcarryx_u32(&x243, &x244, x242, x180, x218);
    fiat_secp384r1_addcarryx_u32(&x245, &x246, x244, x182, x220);
    fiat_secp384r1_addcarryx_u32(&x247, &x248, x246, x184, x222);
    fiat_secp384r1_addcarryx_u32(&x249, &x250, x248, x186, x224);
    fiat_secp384r1_addcarryx_u32(&x251, &x252, x250, x188, x226);
    fiat_secp384r1_addcarryx_u32(&x253, &x254, x252, x190, x228);
    fiat_secp384r1_addcarryx_u32(&x255, &x256, x254, x192, x230);
    fiat_secp384r1_addcarryx_u32(&x257, &x258, x256, x194, x232);
    x259 = ((uint32_t)x258 + x195);
    fiat_secp384r1_mulx_u32(&x260, &x261, x2, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x262, &x263, x2, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x264, &x265, x2, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x266, &x267, x2, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x268, &x269, x2, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x270, &x271, x2, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x272, &x273, x2, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x274, &x275, x2, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x276, &x277, x2, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x278, &x279, x2, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x280, &x281, x2, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x282, &x283, x2, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x284, &x285, 0x0, x283, x280);
    fiat_secp384r1_addcarryx_u32(&x286, &x287, x285, x281, x278);
    fiat_secp384r1_addcarryx_u32(&x288, &x289, x287, x279, x276);
    fiat_secp384r1_addcarryx_u32(&x290, &x291, x289, x277, x274);
    fiat_secp384r1_addcarryx_u32(&x292, &x293, x291, x275, x272);
    fiat_secp384r1_addcarryx_u32(&x294, &x295, x293, x273, x270);
    fiat_secp384r1_addcarryx_u32(&x296, &x297, x295, x271, x268);
    fiat_secp384r1_addcarryx_u32(&x298, &x299, x297, x269, x266);
    fiat_secp384r1_addcarryx_u32(&x300, &x301, x299, x267, x264);
    fiat_secp384r1_addcarryx_u32(&x302, &x303, x301, x265, x262);
    fiat_secp384r1_addcarryx_u32(&x304, &x305, x303, x263, x260);
    x306 = (x305 + x261);
    fiat_secp384r1_addcarryx_u32(&x307, &x308, 0x0, x235, x282);
    fiat_secp384r1_addcarryx_u32(&x309, &x310, x308, x237, x284);
    fiat_secp384r1_addcarryx_u32(&x311, &x312, x310, x239, x286);
    fiat_secp384r1_addcarryx_u32(&x313, &x314, x312, x241, x288);
    fiat_secp384r1_addcarryx_u32(&x315, &x316, x314, x243, x290);
    fiat_secp384r1_addcarryx_u32(&x317, &x318, x316, x245, x292);
    fiat_secp384r1_addcarryx_u32(&x319, &x320, x318, x247, x294);
    fiat_secp384r1_addcarryx_u32(&x321, &x322, x320, x249, x296);
    fiat_secp384r1_addcarryx_u32(&x323, &x324, x322, x251, x298);
    fiat_secp384r1_addcarryx_u32(&x325, &x326, x324, x253, x300);
    fiat_secp384r1_addcarryx_u32(&x327, &x328, x326, x255, x302);
    fiat_secp384r1_addcarryx_u32(&x329, &x330, x328, x257, x304);
    fiat_secp384r1_addcarryx_u32(&x331, &x332, x330, x259, x306);
    fiat_secp384r1_mulx_u32(&x333, &x334, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x335, &x336, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x337, &x338, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x339, &x340, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x341, &x342, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x343, &x344, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x345, &x346, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x347, &x348, x307, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x349, &x350, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x351, &x352, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x353, &x354, 0x0, x350, x347);
    fiat_secp384r1_addcarryx_u32(&x355, &x356, x354, x348, x345);
    fiat_secp384r1_addcarryx_u32(&x357, &x358, x356, x346, x343);
    fiat_secp384r1_addcarryx_u32(&x359, &x360, x358, x344, x341);
    fiat_secp384r1_addcarryx_u32(&x361, &x362, x360, x342, x339);
    fiat_secp384r1_addcarryx_u32(&x363, &x364, x362, x340, x337);
    fiat_secp384r1_addcarryx_u32(&x365, &x366, x364, x338, x335);
    fiat_secp384r1_addcarryx_u32(&x367, &x368, x366, x336, x333);
    x369 = (x368 + x334);
    fiat_secp384r1_addcarryx_u32(&x370, &x371, 0x0, x307, x351);
    fiat_secp384r1_addcarryx_u32(&x372, &x373, x371, x309, x352);
    fiat_secp384r1_addcarryx_u32(&x374, &x375, x373, x311, 0x0);
    fiat_secp384r1_addcarryx_u32(&x376, &x377, x375, x313, x349);
    fiat_secp384r1_addcarryx_u32(&x378, &x379, x377, x315, x353);
    fiat_secp384r1_addcarryx_u32(&x380, &x381, x379, x317, x355);
    fiat_secp384r1_addcarryx_u32(&x382, &x383, x381, x319, x357);
    fiat_secp384r1_addcarryx_u32(&x384, &x385, x383, x321, x359);
    fiat_secp384r1_addcarryx_u32(&x386, &x387, x385, x323, x361);
    fiat_secp384r1_addcarryx_u32(&x388, &x389, x387, x325, x363);
    fiat_secp384r1_addcarryx_u32(&x390, &x391, x389, x327, x365);
    fiat_secp384r1_addcarryx_u32(&x392, &x393, x391, x329, x367);
    fiat_secp384r1_addcarryx_u32(&x394, &x395, x393, x331, x369);
    x396 = ((uint32_t)x395 + x332);
    fiat_secp384r1_mulx_u32(&x397, &x398, x3, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x399, &x400, x3, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x401, &x402, x3, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x403, &x404, x3, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x405, &x406, x3, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x407, &x408, x3, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x409, &x410, x3, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x411, &x412, x3, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x413, &x414, x3, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x415, &x416, x3, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x417, &x418, x3, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x419, &x420, x3, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x421, &x422, 0x0, x420, x417);
    fiat_secp384r1_addcarryx_u32(&x423, &x424, x422, x418, x415);
    fiat_secp384r1_addcarryx_u32(&x425, &x426, x424, x416, x413);
    fiat_secp384r1_addcarryx_u32(&x427, &x428, x426, x414, x411);
    fiat_secp384r1_addcarryx_u32(&x429, &x430, x428, x412, x409);
    fiat_secp384r1_addcarryx_u32(&x431, &x432, x430, x410, x407);
    fiat_secp384r1_addcarryx_u32(&x433, &x434, x432, x408, x405);
    fiat_secp384r1_addcarryx_u32(&x435, &x436, x434, x406, x403);
    fiat_secp384r1_addcarryx_u32(&x437, &x438, x436, x404, x401);
    fiat_secp384r1_addcarryx_u32(&x439, &x440, x438, x402, x399);
    fiat_secp384r1_addcarryx_u32(&x441, &x442, x440, x400, x397);
    x443 = (x442 + x398);
    fiat_secp384r1_addcarryx_u32(&x444, &x445, 0x0, x372, x419);
    fiat_secp384r1_addcarryx_u32(&x446, &x447, x445, x374, x421);
    fiat_secp384r1_addcarryx_u32(&x448, &x449, x447, x376, x423);
    fiat_secp384r1_addcarryx_u32(&x450, &x451, x449, x378, x425);
    fiat_secp384r1_addcarryx_u32(&x452, &x453, x451, x380, x427);
    fiat_secp384r1_addcarryx_u32(&x454, &x455, x453, x382, x429);
    fiat_secp384r1_addcarryx_u32(&x456, &x457, x455, x384, x431);
    fiat_secp384r1_addcarryx_u32(&x458, &x459, x457, x386, x433);
    fiat_secp384r1_addcarryx_u32(&x460, &x461, x459, x388, x435);
    fiat_secp384r1_addcarryx_u32(&x462, &x463, x461, x390, x437);
    fiat_secp384r1_addcarryx_u32(&x464, &x465, x463, x392, x439);
    fiat_secp384r1_addcarryx_u32(&x466, &x467, x465, x394, x441);
    fiat_secp384r1_addcarryx_u32(&x468, &x469, x467, x396, x443);
    fiat_secp384r1_mulx_u32(&x470, &x471, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x472, &x473, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x474, &x475, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x476, &x477, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x478, &x479, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x480, &x481, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x482, &x483, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x484, &x485, x444, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x486, &x487, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x488, &x489, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x490, &x491, 0x0, x487, x484);
    fiat_secp384r1_addcarryx_u32(&x492, &x493, x491, x485, x482);
    fiat_secp384r1_addcarryx_u32(&x494, &x495, x493, x483, x480);
    fiat_secp384r1_addcarryx_u32(&x496, &x497, x495, x481, x478);
    fiat_secp384r1_addcarryx_u32(&x498, &x499, x497, x479, x476);
    fiat_secp384r1_addcarryx_u32(&x500, &x501, x499, x477, x474);
    fiat_secp384r1_addcarryx_u32(&x502, &x503, x501, x475, x472);
    fiat_secp384r1_addcarryx_u32(&x504, &x505, x503, x473, x470);
    x506 = (x505 + x471);
    fiat_secp384r1_addcarryx_u32(&x507, &x508, 0x0, x444, x488);
    fiat_secp384r1_addcarryx_u32(&x509, &x510, x508, x446, x489);
    fiat_secp384r1_addcarryx_u32(&x511, &x512, x510, x448, 0x0);
    fiat_secp384r1_addcarryx_u32(&x513, &x514, x512, x450, x486);
    fiat_secp384r1_addcarryx_u32(&x515, &x516, x514, x452, x490);
    fiat_secp384r1_addcarryx_u32(&x517, &x518, x516, x454, x492);
    fiat_secp384r1_addcarryx_u32(&x519, &x520, x518, x456, x494);
    fiat_secp384r1_addcarryx_u32(&x521, &x522, x520, x458, x496);
    fiat_secp384r1_addcarryx_u32(&x523, &x524, x522, x460, x498);
    fiat_secp384r1_addcarryx_u32(&x525, &x526, x524, x462, x500);
    fiat_secp384r1_addcarryx_u32(&x527, &x528, x526, x464, x502);
    fiat_secp384r1_addcarryx_u32(&x529, &x530, x528, x466, x504);
    fiat_secp384r1_addcarryx_u32(&x531, &x532, x530, x468, x506);
    x533 = ((uint32_t)x532 + x469);
    fiat_secp384r1_mulx_u32(&x534, &x535, x4, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x536, &x537, x4, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x538, &x539, x4, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x540, &x541, x4, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x542, &x543, x4, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x544, &x545, x4, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x546, &x547, x4, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x548, &x549, x4, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x550, &x551, x4, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x552, &x553, x4, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x554, &x555, x4, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x556, &x557, x4, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x558, &x559, 0x0, x557, x554);
    fiat_secp384r1_addcarryx_u32(&x560, &x561, x559, x555, x552);
    fiat_secp384r1_addcarryx_u32(&x562, &x563, x561, x553, x550);
    fiat_secp384r1_addcarryx_u32(&x564, &x565, x563, x551, x548);
    fiat_secp384r1_addcarryx_u32(&x566, &x567, x565, x549, x546);
    fiat_secp384r1_addcarryx_u32(&x568, &x569, x567, x547, x544);
    fiat_secp384r1_addcarryx_u32(&x570, &x571, x569, x545, x542);
    fiat_secp384r1_addcarryx_u32(&x572, &x573, x571, x543, x540);
    fiat_secp384r1_addcarryx_u32(&x574, &x575, x573, x541, x538);
    fiat_secp384r1_addcarryx_u32(&x576, &x577, x575, x539, x536);
    fiat_secp384r1_addcarryx_u32(&x578, &x579, x577, x537, x534);
    x580 = (x579 + x535);
    fiat_secp384r1_addcarryx_u32(&x581, &x582, 0x0, x509, x556);
    fiat_secp384r1_addcarryx_u32(&x583, &x584, x582, x511, x558);
    fiat_secp384r1_addcarryx_u32(&x585, &x586, x584, x513, x560);
    fiat_secp384r1_addcarryx_u32(&x587, &x588, x586, x515, x562);
    fiat_secp384r1_addcarryx_u32(&x589, &x590, x588, x517, x564);
    fiat_secp384r1_addcarryx_u32(&x591, &x592, x590, x519, x566);
    fiat_secp384r1_addcarryx_u32(&x593, &x594, x592, x521, x568);
    fiat_secp384r1_addcarryx_u32(&x595, &x596, x594, x523, x570);
    fiat_secp384r1_addcarryx_u32(&x597, &x598, x596, x525, x572);
    fiat_secp384r1_addcarryx_u32(&x599, &x600, x598, x527, x574);
    fiat_secp384r1_addcarryx_u32(&x601, &x602, x600, x529, x576);
    fiat_secp384r1_addcarryx_u32(&x603, &x604, x602, x531, x578);
    fiat_secp384r1_addcarryx_u32(&x605, &x606, x604, x533, x580);
    fiat_secp384r1_mulx_u32(&x607, &x608, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x609, &x610, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x611, &x612, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x613, &x614, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x615, &x616, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x617, &x618, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x619, &x620, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x621, &x622, x581, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x623, &x624, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x625, &x626, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x627, &x628, 0x0, x624, x621);
    fiat_secp384r1_addcarryx_u32(&x629, &x630, x628, x622, x619);
    fiat_secp384r1_addcarryx_u32(&x631, &x632, x630, x620, x617);
    fiat_secp384r1_addcarryx_u32(&x633, &x634, x632, x618, x615);
    fiat_secp384r1_addcarryx_u32(&x635, &x636, x634, x616, x613);
    fiat_secp384r1_addcarryx_u32(&x637, &x638, x636, x614, x611);
    fiat_secp384r1_addcarryx_u32(&x639, &x640, x638, x612, x609);
    fiat_secp384r1_addcarryx_u32(&x641, &x642, x640, x610, x607);
    x643 = (x642 + x608);
    fiat_secp384r1_addcarryx_u32(&x644, &x645, 0x0, x581, x625);
    fiat_secp384r1_addcarryx_u32(&x646, &x647, x645, x583, x626);
    fiat_secp384r1_addcarryx_u32(&x648, &x649, x647, x585, 0x0);
    fiat_secp384r1_addcarryx_u32(&x650, &x651, x649, x587, x623);
    fiat_secp384r1_addcarryx_u32(&x652, &x653, x651, x589, x627);
    fiat_secp384r1_addcarryx_u32(&x654, &x655, x653, x591, x629);
    fiat_secp384r1_addcarryx_u32(&x656, &x657, x655, x593, x631);
    fiat_secp384r1_addcarryx_u32(&x658, &x659, x657, x595, x633);
    fiat_secp384r1_addcarryx_u32(&x660, &x661, x659, x597, x635);
    fiat_secp384r1_addcarryx_u32(&x662, &x663, x661, x599, x637);
    fiat_secp384r1_addcarryx_u32(&x664, &x665, x663, x601, x639);
    fiat_secp384r1_addcarryx_u32(&x666, &x667, x665, x603, x641);
    fiat_secp384r1_addcarryx_u32(&x668, &x669, x667, x605, x643);
    x670 = ((uint32_t)x669 + x606);
    fiat_secp384r1_mulx_u32(&x671, &x672, x5, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x673, &x674, x5, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x675, &x676, x5, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x677, &x678, x5, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x679, &x680, x5, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x681, &x682, x5, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x683, &x684, x5, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x685, &x686, x5, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x687, &x688, x5, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x689, &x690, x5, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x691, &x692, x5, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x693, &x694, x5, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x695, &x696, 0x0, x694, x691);
    fiat_secp384r1_addcarryx_u32(&x697, &x698, x696, x692, x689);
    fiat_secp384r1_addcarryx_u32(&x699, &x700, x698, x690, x687);
    fiat_secp384r1_addcarryx_u32(&x701, &x702, x700, x688, x685);
    fiat_secp384r1_addcarryx_u32(&x703, &x704, x702, x686, x683);
    fiat_secp384r1_addcarryx_u32(&x705, &x706, x704, x684, x681);
    fiat_secp384r1_addcarryx_u32(&x707, &x708, x706, x682, x679);
    fiat_secp384r1_addcarryx_u32(&x709, &x710, x708, x680, x677);
    fiat_secp384r1_addcarryx_u32(&x711, &x712, x710, x678, x675);
    fiat_secp384r1_addcarryx_u32(&x713, &x714, x712, x676, x673);
    fiat_secp384r1_addcarryx_u32(&x715, &x716, x714, x674, x671);
    x717 = (x716 + x672);
    fiat_secp384r1_addcarryx_u32(&x718, &x719, 0x0, x646, x693);
    fiat_secp384r1_addcarryx_u32(&x720, &x721, x719, x648, x695);
    fiat_secp384r1_addcarryx_u32(&x722, &x723, x721, x650, x697);
    fiat_secp384r1_addcarryx_u32(&x724, &x725, x723, x652, x699);
    fiat_secp384r1_addcarryx_u32(&x726, &x727, x725, x654, x701);
    fiat_secp384r1_addcarryx_u32(&x728, &x729, x727, x656, x703);
    fiat_secp384r1_addcarryx_u32(&x730, &x731, x729, x658, x705);
    fiat_secp384r1_addcarryx_u32(&x732, &x733, x731, x660, x707);
    fiat_secp384r1_addcarryx_u32(&x734, &x735, x733, x662, x709);
    fiat_secp384r1_addcarryx_u32(&x736, &x737, x735, x664, x711);
    fiat_secp384r1_addcarryx_u32(&x738, &x739, x737, x666, x713);
    fiat_secp384r1_addcarryx_u32(&x740, &x741, x739, x668, x715);
    fiat_secp384r1_addcarryx_u32(&x742, &x743, x741, x670, x717);
    fiat_secp384r1_mulx_u32(&x744, &x745, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x746, &x747, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x748, &x749, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x750, &x751, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x752, &x753, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x754, &x755, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x756, &x757, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x758, &x759, x718, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x760, &x761, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x762, &x763, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x764, &x765, 0x0, x761, x758);
    fiat_secp384r1_addcarryx_u32(&x766, &x767, x765, x759, x756);
    fiat_secp384r1_addcarryx_u32(&x768, &x769, x767, x757, x754);
    fiat_secp384r1_addcarryx_u32(&x770, &x771, x769, x755, x752);
    fiat_secp384r1_addcarryx_u32(&x772, &x773, x771, x753, x750);
    fiat_secp384r1_addcarryx_u32(&x774, &x775, x773, x751, x748);
    fiat_secp384r1_addcarryx_u32(&x776, &x777, x775, x749, x746);
    fiat_secp384r1_addcarryx_u32(&x778, &x779, x777, x747, x744);
    x780 = (x779 + x745);
    fiat_secp384r1_addcarryx_u32(&x781, &x782, 0x0, x718, x762);
    fiat_secp384r1_addcarryx_u32(&x783, &x784, x782, x720, x763);
    fiat_secp384r1_addcarryx_u32(&x785, &x786, x784, x722, 0x0);
    fiat_secp384r1_addcarryx_u32(&x787, &x788, x786, x724, x760);
    fiat_secp384r1_addcarryx_u32(&x789, &x790, x788, x726, x764);
    fiat_secp384r1_addcarryx_u32(&x791, &x792, x790, x728, x766);
    fiat_secp384r1_addcarryx_u32(&x793, &x794, x792, x730, x768);
    fiat_secp384r1_addcarryx_u32(&x795, &x796, x794, x732, x770);
    fiat_secp384r1_addcarryx_u32(&x797, &x798, x796, x734, x772);
    fiat_secp384r1_addcarryx_u32(&x799, &x800, x798, x736, x774);
    fiat_secp384r1_addcarryx_u32(&x801, &x802, x800, x738, x776);
    fiat_secp384r1_addcarryx_u32(&x803, &x804, x802, x740, x778);
    fiat_secp384r1_addcarryx_u32(&x805, &x806, x804, x742, x780);
    x807 = ((uint32_t)x806 + x743);
    fiat_secp384r1_mulx_u32(&x808, &x809, x6, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x810, &x811, x6, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x812, &x813, x6, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x814, &x815, x6, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x816, &x817, x6, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x818, &x819, x6, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x820, &x821, x6, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x822, &x823, x6, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x824, &x825, x6, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x826, &x827, x6, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x828, &x829, x6, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x830, &x831, x6, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x832, &x833, 0x0, x831, x828);
    fiat_secp384r1_addcarryx_u32(&x834, &x835, x833, x829, x826);
    fiat_secp384r1_addcarryx_u32(&x836, &x837, x835, x827, x824);
    fiat_secp384r1_addcarryx_u32(&x838, &x839, x837, x825, x822);
    fiat_secp384r1_addcarryx_u32(&x840, &x841, x839, x823, x820);
    fiat_secp384r1_addcarryx_u32(&x842, &x843, x841, x821, x818);
    fiat_secp384r1_addcarryx_u32(&x844, &x845, x843, x819, x816);
    fiat_secp384r1_addcarryx_u32(&x846, &x847, x845, x817, x814);
    fiat_secp384r1_addcarryx_u32(&x848, &x849, x847, x815, x812);
    fiat_secp384r1_addcarryx_u32(&x850, &x851, x849, x813, x810);
    fiat_secp384r1_addcarryx_u32(&x852, &x853, x851, x811, x808);
    x854 = (x853 + x809);
    fiat_secp384r1_addcarryx_u32(&x855, &x856, 0x0, x783, x830);
    fiat_secp384r1_addcarryx_u32(&x857, &x858, x856, x785, x832);
    fiat_secp384r1_addcarryx_u32(&x859, &x860, x858, x787, x834);
    fiat_secp384r1_addcarryx_u32(&x861, &x862, x860, x789, x836);
    fiat_secp384r1_addcarryx_u32(&x863, &x864, x862, x791, x838);
    fiat_secp384r1_addcarryx_u32(&x865, &x866, x864, x793, x840);
    fiat_secp384r1_addcarryx_u32(&x867, &x868, x866, x795, x842);
    fiat_secp384r1_addcarryx_u32(&x869, &x870, x868, x797, x844);
    fiat_secp384r1_addcarryx_u32(&x871, &x872, x870, x799, x846);
    fiat_secp384r1_addcarryx_u32(&x873, &x874, x872, x801, x848);
    fiat_secp384r1_addcarryx_u32(&x875, &x876, x874, x803, x850);
    fiat_secp384r1_addcarryx_u32(&x877, &x878, x876, x805, x852);
    fiat_secp384r1_addcarryx_u32(&x879, &x880, x878, x807, x854);
    fiat_secp384r1_mulx_u32(&x881, &x882, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x883, &x884, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x885, &x886, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x887, &x888, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x889, &x890, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x891, &x892, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x893, &x894, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x895, &x896, x855, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x897, &x898, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x899, &x900, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x901, &x902, 0x0, x898, x895);
    fiat_secp384r1_addcarryx_u32(&x903, &x904, x902, x896, x893);
    fiat_secp384r1_addcarryx_u32(&x905, &x906, x904, x894, x891);
    fiat_secp384r1_addcarryx_u32(&x907, &x908, x906, x892, x889);
    fiat_secp384r1_addcarryx_u32(&x909, &x910, x908, x890, x887);
    fiat_secp384r1_addcarryx_u32(&x911, &x912, x910, x888, x885);
    fiat_secp384r1_addcarryx_u32(&x913, &x914, x912, x886, x883);
    fiat_secp384r1_addcarryx_u32(&x915, &x916, x914, x884, x881);
    x917 = (x916 + x882);
    fiat_secp384r1_addcarryx_u32(&x918, &x919, 0x0, x855, x899);
    fiat_secp384r1_addcarryx_u32(&x920, &x921, x919, x857, x900);
    fiat_secp384r1_addcarryx_u32(&x922, &x923, x921, x859, 0x0);
    fiat_secp384r1_addcarryx_u32(&x924, &x925, x923, x861, x897);
    fiat_secp384r1_addcarryx_u32(&x926, &x927, x925, x863, x901);
    fiat_secp384r1_addcarryx_u32(&x928, &x929, x927, x865, x903);
    fiat_secp384r1_addcarryx_u32(&x930, &x931, x929, x867, x905);
    fiat_secp384r1_addcarryx_u32(&x932, &x933, x931, x869, x907);
    fiat_secp384r1_addcarryx_u32(&x934, &x935, x933, x871, x909);
    fiat_secp384r1_addcarryx_u32(&x936, &x937, x935, x873, x911);
    fiat_secp384r1_addcarryx_u32(&x938, &x939, x937, x875, x913);
    fiat_secp384r1_addcarryx_u32(&x940, &x941, x939, x877, x915);
    fiat_secp384r1_addcarryx_u32(&x942, &x943, x941, x879, x917);
    x944 = ((uint32_t)x943 + x880);
    fiat_secp384r1_mulx_u32(&x945, &x946, x7, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x947, &x948, x7, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x949, &x950, x7, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x951, &x952, x7, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x953, &x954, x7, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x955, &x956, x7, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x957, &x958, x7, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x959, &x960, x7, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x961, &x962, x7, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x963, &x964, x7, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x965, &x966, x7, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x967, &x968, x7, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x969, &x970, 0x0, x968, x965);
    fiat_secp384r1_addcarryx_u32(&x971, &x972, x970, x966, x963);
    fiat_secp384r1_addcarryx_u32(&x973, &x974, x972, x964, x961);
    fiat_secp384r1_addcarryx_u32(&x975, &x976, x974, x962, x959);
    fiat_secp384r1_addcarryx_u32(&x977, &x978, x976, x960, x957);
    fiat_secp384r1_addcarryx_u32(&x979, &x980, x978, x958, x955);
    fiat_secp384r1_addcarryx_u32(&x981, &x982, x980, x956, x953);
    fiat_secp384r1_addcarryx_u32(&x983, &x984, x982, x954, x951);
    fiat_secp384r1_addcarryx_u32(&x985, &x986, x984, x952, x949);
    fiat_secp384r1_addcarryx_u32(&x987, &x988, x986, x950, x947);
    fiat_secp384r1_addcarryx_u32(&x989, &x990, x988, x948, x945);
    x991 = (x990 + x946);
    fiat_secp384r1_addcarryx_u32(&x992, &x993, 0x0, x920, x967);
    fiat_secp384r1_addcarryx_u32(&x994, &x995, x993, x922, x969);
    fiat_secp384r1_addcarryx_u32(&x996, &x997, x995, x924, x971);
    fiat_secp384r1_addcarryx_u32(&x998, &x999, x997, x926, x973);
    fiat_secp384r1_addcarryx_u32(&x1000, &x1001, x999, x928, x975);
    fiat_secp384r1_addcarryx_u32(&x1002, &x1003, x1001, x930, x977);
    fiat_secp384r1_addcarryx_u32(&x1004, &x1005, x1003, x932, x979);
    fiat_secp384r1_addcarryx_u32(&x1006, &x1007, x1005, x934, x981);
    fiat_secp384r1_addcarryx_u32(&x1008, &x1009, x1007, x936, x983);
    fiat_secp384r1_addcarryx_u32(&x1010, &x1011, x1009, x938, x985);
    fiat_secp384r1_addcarryx_u32(&x1012, &x1013, x1011, x940, x987);
    fiat_secp384r1_addcarryx_u32(&x1014, &x1015, x1013, x942, x989);
    fiat_secp384r1_addcarryx_u32(&x1016, &x1017, x1015, x944, x991);
    fiat_secp384r1_mulx_u32(&x1018, &x1019, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1020, &x1021, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1022, &x1023, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1024, &x1025, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1026, &x1027, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1028, &x1029, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1030, &x1031, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1032, &x1033, x992, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1034, &x1035, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1036, &x1037, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1038, &x1039, 0x0, x1035, x1032);
    fiat_secp384r1_addcarryx_u32(&x1040, &x1041, x1039, x1033, x1030);
    fiat_secp384r1_addcarryx_u32(&x1042, &x1043, x1041, x1031, x1028);
    fiat_secp384r1_addcarryx_u32(&x1044, &x1045, x1043, x1029, x1026);
    fiat_secp384r1_addcarryx_u32(&x1046, &x1047, x1045, x1027, x1024);
    fiat_secp384r1_addcarryx_u32(&x1048, &x1049, x1047, x1025, x1022);
    fiat_secp384r1_addcarryx_u32(&x1050, &x1051, x1049, x1023, x1020);
    fiat_secp384r1_addcarryx_u32(&x1052, &x1053, x1051, x1021, x1018);
    x1054 = (x1053 + x1019);
    fiat_secp384r1_addcarryx_u32(&x1055, &x1056, 0x0, x992, x1036);
    fiat_secp384r1_addcarryx_u32(&x1057, &x1058, x1056, x994, x1037);
    fiat_secp384r1_addcarryx_u32(&x1059, &x1060, x1058, x996, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1061, &x1062, x1060, x998, x1034);
    fiat_secp384r1_addcarryx_u32(&x1063, &x1064, x1062, x1000, x1038);
    fiat_secp384r1_addcarryx_u32(&x1065, &x1066, x1064, x1002, x1040);
    fiat_secp384r1_addcarryx_u32(&x1067, &x1068, x1066, x1004, x1042);
    fiat_secp384r1_addcarryx_u32(&x1069, &x1070, x1068, x1006, x1044);
    fiat_secp384r1_addcarryx_u32(&x1071, &x1072, x1070, x1008, x1046);
    fiat_secp384r1_addcarryx_u32(&x1073, &x1074, x1072, x1010, x1048);
    fiat_secp384r1_addcarryx_u32(&x1075, &x1076, x1074, x1012, x1050);
    fiat_secp384r1_addcarryx_u32(&x1077, &x1078, x1076, x1014, x1052);
    fiat_secp384r1_addcarryx_u32(&x1079, &x1080, x1078, x1016, x1054);
    x1081 = ((uint32_t)x1080 + x1017);
    fiat_secp384r1_mulx_u32(&x1082, &x1083, x8, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x1084, &x1085, x8, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x1086, &x1087, x8, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x1088, &x1089, x8, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x1090, &x1091, x8, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x1092, &x1093, x8, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x1094, &x1095, x8, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x1096, &x1097, x8, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x1098, &x1099, x8, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x1100, &x1101, x8, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x1102, &x1103, x8, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x1104, &x1105, x8, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x1106, &x1107, 0x0, x1105, x1102);
    fiat_secp384r1_addcarryx_u32(&x1108, &x1109, x1107, x1103, x1100);
    fiat_secp384r1_addcarryx_u32(&x1110, &x1111, x1109, x1101, x1098);
    fiat_secp384r1_addcarryx_u32(&x1112, &x1113, x1111, x1099, x1096);
    fiat_secp384r1_addcarryx_u32(&x1114, &x1115, x1113, x1097, x1094);
    fiat_secp384r1_addcarryx_u32(&x1116, &x1117, x1115, x1095, x1092);
    fiat_secp384r1_addcarryx_u32(&x1118, &x1119, x1117, x1093, x1090);
    fiat_secp384r1_addcarryx_u32(&x1120, &x1121, x1119, x1091, x1088);
    fiat_secp384r1_addcarryx_u32(&x1122, &x1123, x1121, x1089, x1086);
    fiat_secp384r1_addcarryx_u32(&x1124, &x1125, x1123, x1087, x1084);
    fiat_secp384r1_addcarryx_u32(&x1126, &x1127, x1125, x1085, x1082);
    x1128 = (x1127 + x1083);
    fiat_secp384r1_addcarryx_u32(&x1129, &x1130, 0x0, x1057, x1104);
    fiat_secp384r1_addcarryx_u32(&x1131, &x1132, x1130, x1059, x1106);
    fiat_secp384r1_addcarryx_u32(&x1133, &x1134, x1132, x1061, x1108);
    fiat_secp384r1_addcarryx_u32(&x1135, &x1136, x1134, x1063, x1110);
    fiat_secp384r1_addcarryx_u32(&x1137, &x1138, x1136, x1065, x1112);
    fiat_secp384r1_addcarryx_u32(&x1139, &x1140, x1138, x1067, x1114);
    fiat_secp384r1_addcarryx_u32(&x1141, &x1142, x1140, x1069, x1116);
    fiat_secp384r1_addcarryx_u32(&x1143, &x1144, x1142, x1071, x1118);
    fiat_secp384r1_addcarryx_u32(&x1145, &x1146, x1144, x1073, x1120);
    fiat_secp384r1_addcarryx_u32(&x1147, &x1148, x1146, x1075, x1122);
    fiat_secp384r1_addcarryx_u32(&x1149, &x1150, x1148, x1077, x1124);
    fiat_secp384r1_addcarryx_u32(&x1151, &x1152, x1150, x1079, x1126);
    fiat_secp384r1_addcarryx_u32(&x1153, &x1154, x1152, x1081, x1128);
    fiat_secp384r1_mulx_u32(&x1155, &x1156, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1157, &x1158, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1159, &x1160, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1161, &x1162, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1163, &x1164, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1165, &x1166, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1167, &x1168, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1169, &x1170, x1129, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1171, &x1172, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1173, &x1174, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1175, &x1176, 0x0, x1172, x1169);
    fiat_secp384r1_addcarryx_u32(&x1177, &x1178, x1176, x1170, x1167);
    fiat_secp384r1_addcarryx_u32(&x1179, &x1180, x1178, x1168, x1165);
    fiat_secp384r1_addcarryx_u32(&x1181, &x1182, x1180, x1166, x1163);
    fiat_secp384r1_addcarryx_u32(&x1183, &x1184, x1182, x1164, x1161);
    fiat_secp384r1_addcarryx_u32(&x1185, &x1186, x1184, x1162, x1159);
    fiat_secp384r1_addcarryx_u32(&x1187, &x1188, x1186, x1160, x1157);
    fiat_secp384r1_addcarryx_u32(&x1189, &x1190, x1188, x1158, x1155);
    x1191 = (x1190 + x1156);
    fiat_secp384r1_addcarryx_u32(&x1192, &x1193, 0x0, x1129, x1173);
    fiat_secp384r1_addcarryx_u32(&x1194, &x1195, x1193, x1131, x1174);
    fiat_secp384r1_addcarryx_u32(&x1196, &x1197, x1195, x1133, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1198, &x1199, x1197, x1135, x1171);
    fiat_secp384r1_addcarryx_u32(&x1200, &x1201, x1199, x1137, x1175);
    fiat_secp384r1_addcarryx_u32(&x1202, &x1203, x1201, x1139, x1177);
    fiat_secp384r1_addcarryx_u32(&x1204, &x1205, x1203, x1141, x1179);
    fiat_secp384r1_addcarryx_u32(&x1206, &x1207, x1205, x1143, x1181);
    fiat_secp384r1_addcarryx_u32(&x1208, &x1209, x1207, x1145, x1183);
    fiat_secp384r1_addcarryx_u32(&x1210, &x1211, x1209, x1147, x1185);
    fiat_secp384r1_addcarryx_u32(&x1212, &x1213, x1211, x1149, x1187);
    fiat_secp384r1_addcarryx_u32(&x1214, &x1215, x1213, x1151, x1189);
    fiat_secp384r1_addcarryx_u32(&x1216, &x1217, x1215, x1153, x1191);
    x1218 = ((uint32_t)x1217 + x1154);
    fiat_secp384r1_mulx_u32(&x1219, &x1220, x9, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x1221, &x1222, x9, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x1223, &x1224, x9, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x1225, &x1226, x9, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x1227, &x1228, x9, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x1229, &x1230, x9, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x1231, &x1232, x9, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x1233, &x1234, x9, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x1235, &x1236, x9, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x1237, &x1238, x9, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x1239, &x1240, x9, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x1241, &x1242, x9, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x1243, &x1244, 0x0, x1242, x1239);
    fiat_secp384r1_addcarryx_u32(&x1245, &x1246, x1244, x1240, x1237);
    fiat_secp384r1_addcarryx_u32(&x1247, &x1248, x1246, x1238, x1235);
    fiat_secp384r1_addcarryx_u32(&x1249, &x1250, x1248, x1236, x1233);
    fiat_secp384r1_addcarryx_u32(&x1251, &x1252, x1250, x1234, x1231);
    fiat_secp384r1_addcarryx_u32(&x1253, &x1254, x1252, x1232, x1229);
    fiat_secp384r1_addcarryx_u32(&x1255, &x1256, x1254, x1230, x1227);
    fiat_secp384r1_addcarryx_u32(&x1257, &x1258, x1256, x1228, x1225);
    fiat_secp384r1_addcarryx_u32(&x1259, &x1260, x1258, x1226, x1223);
    fiat_secp384r1_addcarryx_u32(&x1261, &x1262, x1260, x1224, x1221);
    fiat_secp384r1_addcarryx_u32(&x1263, &x1264, x1262, x1222, x1219);
    x1265 = (x1264 + x1220);
    fiat_secp384r1_addcarryx_u32(&x1266, &x1267, 0x0, x1194, x1241);
    fiat_secp384r1_addcarryx_u32(&x1268, &x1269, x1267, x1196, x1243);
    fiat_secp384r1_addcarryx_u32(&x1270, &x1271, x1269, x1198, x1245);
    fiat_secp384r1_addcarryx_u32(&x1272, &x1273, x1271, x1200, x1247);
    fiat_secp384r1_addcarryx_u32(&x1274, &x1275, x1273, x1202, x1249);
    fiat_secp384r1_addcarryx_u32(&x1276, &x1277, x1275, x1204, x1251);
    fiat_secp384r1_addcarryx_u32(&x1278, &x1279, x1277, x1206, x1253);
    fiat_secp384r1_addcarryx_u32(&x1280, &x1281, x1279, x1208, x1255);
    fiat_secp384r1_addcarryx_u32(&x1282, &x1283, x1281, x1210, x1257);
    fiat_secp384r1_addcarryx_u32(&x1284, &x1285, x1283, x1212, x1259);
    fiat_secp384r1_addcarryx_u32(&x1286, &x1287, x1285, x1214, x1261);
    fiat_secp384r1_addcarryx_u32(&x1288, &x1289, x1287, x1216, x1263);
    fiat_secp384r1_addcarryx_u32(&x1290, &x1291, x1289, x1218, x1265);
    fiat_secp384r1_mulx_u32(&x1292, &x1293, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1294, &x1295, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1296, &x1297, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1298, &x1299, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1300, &x1301, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1302, &x1303, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1304, &x1305, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1306, &x1307, x1266, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1308, &x1309, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1310, &x1311, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1312, &x1313, 0x0, x1309, x1306);
    fiat_secp384r1_addcarryx_u32(&x1314, &x1315, x1313, x1307, x1304);
    fiat_secp384r1_addcarryx_u32(&x1316, &x1317, x1315, x1305, x1302);
    fiat_secp384r1_addcarryx_u32(&x1318, &x1319, x1317, x1303, x1300);
    fiat_secp384r1_addcarryx_u32(&x1320, &x1321, x1319, x1301, x1298);
    fiat_secp384r1_addcarryx_u32(&x1322, &x1323, x1321, x1299, x1296);
    fiat_secp384r1_addcarryx_u32(&x1324, &x1325, x1323, x1297, x1294);
    fiat_secp384r1_addcarryx_u32(&x1326, &x1327, x1325, x1295, x1292);
    x1328 = (x1327 + x1293);
    fiat_secp384r1_addcarryx_u32(&x1329, &x1330, 0x0, x1266, x1310);
    fiat_secp384r1_addcarryx_u32(&x1331, &x1332, x1330, x1268, x1311);
    fiat_secp384r1_addcarryx_u32(&x1333, &x1334, x1332, x1270, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1335, &x1336, x1334, x1272, x1308);
    fiat_secp384r1_addcarryx_u32(&x1337, &x1338, x1336, x1274, x1312);
    fiat_secp384r1_addcarryx_u32(&x1339, &x1340, x1338, x1276, x1314);
    fiat_secp384r1_addcarryx_u32(&x1341, &x1342, x1340, x1278, x1316);
    fiat_secp384r1_addcarryx_u32(&x1343, &x1344, x1342, x1280, x1318);
    fiat_secp384r1_addcarryx_u32(&x1345, &x1346, x1344, x1282, x1320);
    fiat_secp384r1_addcarryx_u32(&x1347, &x1348, x1346, x1284, x1322);
    fiat_secp384r1_addcarryx_u32(&x1349, &x1350, x1348, x1286, x1324);
    fiat_secp384r1_addcarryx_u32(&x1351, &x1352, x1350, x1288, x1326);
    fiat_secp384r1_addcarryx_u32(&x1353, &x1354, x1352, x1290, x1328);
    x1355 = ((uint32_t)x1354 + x1291);
    fiat_secp384r1_mulx_u32(&x1356, &x1357, x10, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x1358, &x1359, x10, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x1360, &x1361, x10, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x1362, &x1363, x10, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x1364, &x1365, x10, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x1366, &x1367, x10, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x1368, &x1369, x10, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x1370, &x1371, x10, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x1372, &x1373, x10, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x1374, &x1375, x10, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x1376, &x1377, x10, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x1378, &x1379, x10, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x1380, &x1381, 0x0, x1379, x1376);
    fiat_secp384r1_addcarryx_u32(&x1382, &x1383, x1381, x1377, x1374);
    fiat_secp384r1_addcarryx_u32(&x1384, &x1385, x1383, x1375, x1372);
    fiat_secp384r1_addcarryx_u32(&x1386, &x1387, x1385, x1373, x1370);
    fiat_secp384r1_addcarryx_u32(&x1388, &x1389, x1387, x1371, x1368);
    fiat_secp384r1_addcarryx_u32(&x1390, &x1391, x1389, x1369, x1366);
    fiat_secp384r1_addcarryx_u32(&x1392, &x1393, x1391, x1367, x1364);
    fiat_secp384r1_addcarryx_u32(&x1394, &x1395, x1393, x1365, x1362);
    fiat_secp384r1_addcarryx_u32(&x1396, &x1397, x1395, x1363, x1360);
    fiat_secp384r1_addcarryx_u32(&x1398, &x1399, x1397, x1361, x1358);
    fiat_secp384r1_addcarryx_u32(&x1400, &x1401, x1399, x1359, x1356);
    x1402 = (x1401 + x1357);
    fiat_secp384r1_addcarryx_u32(&x1403, &x1404, 0x0, x1331, x1378);
    fiat_secp384r1_addcarryx_u32(&x1405, &x1406, x1404, x1333, x1380);
    fiat_secp384r1_addcarryx_u32(&x1407, &x1408, x1406, x1335, x1382);
    fiat_secp384r1_addcarryx_u32(&x1409, &x1410, x1408, x1337, x1384);
    fiat_secp384r1_addcarryx_u32(&x1411, &x1412, x1410, x1339, x1386);
    fiat_secp384r1_addcarryx_u32(&x1413, &x1414, x1412, x1341, x1388);
    fiat_secp384r1_addcarryx_u32(&x1415, &x1416, x1414, x1343, x1390);
    fiat_secp384r1_addcarryx_u32(&x1417, &x1418, x1416, x1345, x1392);
    fiat_secp384r1_addcarryx_u32(&x1419, &x1420, x1418, x1347, x1394);
    fiat_secp384r1_addcarryx_u32(&x1421, &x1422, x1420, x1349, x1396);
    fiat_secp384r1_addcarryx_u32(&x1423, &x1424, x1422, x1351, x1398);
    fiat_secp384r1_addcarryx_u32(&x1425, &x1426, x1424, x1353, x1400);
    fiat_secp384r1_addcarryx_u32(&x1427, &x1428, x1426, x1355, x1402);
    fiat_secp384r1_mulx_u32(&x1429, &x1430, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1431, &x1432, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1433, &x1434, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1435, &x1436, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1437, &x1438, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1439, &x1440, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1441, &x1442, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1443, &x1444, x1403, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1445, &x1446, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1447, &x1448, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1449, &x1450, 0x0, x1446, x1443);
    fiat_secp384r1_addcarryx_u32(&x1451, &x1452, x1450, x1444, x1441);
    fiat_secp384r1_addcarryx_u32(&x1453, &x1454, x1452, x1442, x1439);
    fiat_secp384r1_addcarryx_u32(&x1455, &x1456, x1454, x1440, x1437);
    fiat_secp384r1_addcarryx_u32(&x1457, &x1458, x1456, x1438, x1435);
    fiat_secp384r1_addcarryx_u32(&x1459, &x1460, x1458, x1436, x1433);
    fiat_secp384r1_addcarryx_u32(&x1461, &x1462, x1460, x1434, x1431);
    fiat_secp384r1_addcarryx_u32(&x1463, &x1464, x1462, x1432, x1429);
    x1465 = (x1464 + x1430);
    fiat_secp384r1_addcarryx_u32(&x1466, &x1467, 0x0, x1403, x1447);
    fiat_secp384r1_addcarryx_u32(&x1468, &x1469, x1467, x1405, x1448);
    fiat_secp384r1_addcarryx_u32(&x1470, &x1471, x1469, x1407, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1472, &x1473, x1471, x1409, x1445);
    fiat_secp384r1_addcarryx_u32(&x1474, &x1475, x1473, x1411, x1449);
    fiat_secp384r1_addcarryx_u32(&x1476, &x1477, x1475, x1413, x1451);
    fiat_secp384r1_addcarryx_u32(&x1478, &x1479, x1477, x1415, x1453);
    fiat_secp384r1_addcarryx_u32(&x1480, &x1481, x1479, x1417, x1455);
    fiat_secp384r1_addcarryx_u32(&x1482, &x1483, x1481, x1419, x1457);
    fiat_secp384r1_addcarryx_u32(&x1484, &x1485, x1483, x1421, x1459);
    fiat_secp384r1_addcarryx_u32(&x1486, &x1487, x1485, x1423, x1461);
    fiat_secp384r1_addcarryx_u32(&x1488, &x1489, x1487, x1425, x1463);
    fiat_secp384r1_addcarryx_u32(&x1490, &x1491, x1489, x1427, x1465);
    x1492 = ((uint32_t)x1491 + x1428);
    fiat_secp384r1_mulx_u32(&x1493, &x1494, x11, (arg2[11]));
    fiat_secp384r1_mulx_u32(&x1495, &x1496, x11, (arg2[10]));
    fiat_secp384r1_mulx_u32(&x1497, &x1498, x11, (arg2[9]));
    fiat_secp384r1_mulx_u32(&x1499, &x1500, x11, (arg2[8]));
    fiat_secp384r1_mulx_u32(&x1501, &x1502, x11, (arg2[7]));
    fiat_secp384r1_mulx_u32(&x1503, &x1504, x11, (arg2[6]));
    fiat_secp384r1_mulx_u32(&x1505, &x1506, x11, (arg2[5]));
    fiat_secp384r1_mulx_u32(&x1507, &x1508, x11, (arg2[4]));
    fiat_secp384r1_mulx_u32(&x1509, &x1510, x11, (arg2[3]));
    fiat_secp384r1_mulx_u32(&x1511, &x1512, x11, (arg2[2]));
    fiat_secp384r1_mulx_u32(&x1513, &x1514, x11, (arg2[1]));
    fiat_secp384r1_mulx_u32(&x1515, &x1516, x11, (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x1517, &x1518, 0x0, x1516, x1513);
    fiat_secp384r1_addcarryx_u32(&x1519, &x1520, x1518, x1514, x1511);
    fiat_secp384r1_addcarryx_u32(&x1521, &x1522, x1520, x1512, x1509);
    fiat_secp384r1_addcarryx_u32(&x1523, &x1524, x1522, x1510, x1507);
    fiat_secp384r1_addcarryx_u32(&x1525, &x1526, x1524, x1508, x1505);
    fiat_secp384r1_addcarryx_u32(&x1527, &x1528, x1526, x1506, x1503);
    fiat_secp384r1_addcarryx_u32(&x1529, &x1530, x1528, x1504, x1501);
    fiat_secp384r1_addcarryx_u32(&x1531, &x1532, x1530, x1502, x1499);
    fiat_secp384r1_addcarryx_u32(&x1533, &x1534, x1532, x1500, x1497);
    fiat_secp384r1_addcarryx_u32(&x1535, &x1536, x1534, x1498, x1495);
    fiat_secp384r1_addcarryx_u32(&x1537, &x1538, x1536, x1496, x1493);
    x1539 = (x1538 + x1494);
    fiat_secp384r1_addcarryx_u32(&x1540, &x1541, 0x0, x1468, x1515);
    fiat_secp384r1_addcarryx_u32(&x1542, &x1543, x1541, x1470, x1517);
    fiat_secp384r1_addcarryx_u32(&x1544, &x1545, x1543, x1472, x1519);
    fiat_secp384r1_addcarryx_u32(&x1546, &x1547, x1545, x1474, x1521);
    fiat_secp384r1_addcarryx_u32(&x1548, &x1549, x1547, x1476, x1523);
    fiat_secp384r1_addcarryx_u32(&x1550, &x1551, x1549, x1478, x1525);
    fiat_secp384r1_addcarryx_u32(&x1552, &x1553, x1551, x1480, x1527);
    fiat_secp384r1_addcarryx_u32(&x1554, &x1555, x1553, x1482, x1529);
    fiat_secp384r1_addcarryx_u32(&x1556, &x1557, x1555, x1484, x1531);
    fiat_secp384r1_addcarryx_u32(&x1558, &x1559, x1557, x1486, x1533);
    fiat_secp384r1_addcarryx_u32(&x1560, &x1561, x1559, x1488, x1535);
    fiat_secp384r1_addcarryx_u32(&x1562, &x1563, x1561, x1490, x1537);
    fiat_secp384r1_addcarryx_u32(&x1564, &x1565, x1563, x1492, x1539);
    fiat_secp384r1_mulx_u32(&x1566, &x1567, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1568, &x1569, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1570, &x1571, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1572, &x1573, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1574, &x1575, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1576, &x1577, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1578, &x1579, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1580, &x1581, x1540, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1582, &x1583, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1584, &x1585, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1586, &x1587, 0x0, x1583, x1580);
    fiat_secp384r1_addcarryx_u32(&x1588, &x1589, x1587, x1581, x1578);
    fiat_secp384r1_addcarryx_u32(&x1590, &x1591, x1589, x1579, x1576);
    fiat_secp384r1_addcarryx_u32(&x1592, &x1593, x1591, x1577, x1574);
    fiat_secp384r1_addcarryx_u32(&x1594, &x1595, x1593, x1575, x1572);
    fiat_secp384r1_addcarryx_u32(&x1596, &x1597, x1595, x1573, x1570);
    fiat_secp384r1_addcarryx_u32(&x1598, &x1599, x1597, x1571, x1568);
    fiat_secp384r1_addcarryx_u32(&x1600, &x1601, x1599, x1569, x1566);
    x1602 = (x1601 + x1567);
    fiat_secp384r1_addcarryx_u32(&x1603, &x1604, 0x0, x1540, x1584);
    fiat_secp384r1_addcarryx_u32(&x1605, &x1606, x1604, x1542, x1585);
    fiat_secp384r1_addcarryx_u32(&x1607, &x1608, x1606, x1544, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1609, &x1610, x1608, x1546, x1582);
    fiat_secp384r1_addcarryx_u32(&x1611, &x1612, x1610, x1548, x1586);
    fiat_secp384r1_addcarryx_u32(&x1613, &x1614, x1612, x1550, x1588);
    fiat_secp384r1_addcarryx_u32(&x1615, &x1616, x1614, x1552, x1590);
    fiat_secp384r1_addcarryx_u32(&x1617, &x1618, x1616, x1554, x1592);
    fiat_secp384r1_addcarryx_u32(&x1619, &x1620, x1618, x1556, x1594);
    fiat_secp384r1_addcarryx_u32(&x1621, &x1622, x1620, x1558, x1596);
    fiat_secp384r1_addcarryx_u32(&x1623, &x1624, x1622, x1560, x1598);
    fiat_secp384r1_addcarryx_u32(&x1625, &x1626, x1624, x1562, x1600);
    fiat_secp384r1_addcarryx_u32(&x1627, &x1628, x1626, x1564, x1602);
    x1629 = ((uint32_t)x1628 + x1565);
    fiat_secp384r1_subborrowx_u32(&x1630, &x1631, 0x0, x1605,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1632, &x1633, x1631, x1607, 0x0);
    fiat_secp384r1_subborrowx_u32(&x1634, &x1635, x1633, x1609, 0x0);
    fiat_secp384r1_subborrowx_u32(&x1636, &x1637, x1635, x1611,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1638, &x1639, x1637, x1613,
                                  UINT32_C(0xfffffffe));
    fiat_secp384r1_subborrowx_u32(&x1640, &x1641, x1639, x1615,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1642, &x1643, x1641, x1617,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1644, &x1645, x1643, x1619,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1646, &x1647, x1645, x1621,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1648, &x1649, x1647, x1623,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1650, &x1651, x1649, x1625,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1652, &x1653, x1651, x1627,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1654, &x1655, x1653, x1629, 0x0);
    fiat_secp384r1_cmovznz_u32(&x1656, x1655, x1630, x1605);
    fiat_secp384r1_cmovznz_u32(&x1657, x1655, x1632, x1607);
    fiat_secp384r1_cmovznz_u32(&x1658, x1655, x1634, x1609);
    fiat_secp384r1_cmovznz_u32(&x1659, x1655, x1636, x1611);
    fiat_secp384r1_cmovznz_u32(&x1660, x1655, x1638, x1613);
    fiat_secp384r1_cmovznz_u32(&x1661, x1655, x1640, x1615);
    fiat_secp384r1_cmovznz_u32(&x1662, x1655, x1642, x1617);
    fiat_secp384r1_cmovznz_u32(&x1663, x1655, x1644, x1619);
    fiat_secp384r1_cmovznz_u32(&x1664, x1655, x1646, x1621);
    fiat_secp384r1_cmovznz_u32(&x1665, x1655, x1648, x1623);
    fiat_secp384r1_cmovznz_u32(&x1666, x1655, x1650, x1625);
    fiat_secp384r1_cmovznz_u32(&x1667, x1655, x1652, x1627);
    out1[0] = x1656;
    out1[1] = x1657;
    out1[2] = x1658;
    out1[3] = x1659;
    out1[4] = x1660;
    out1[5] = x1661;
    out1[6] = x1662;
    out1[7] = x1663;
    out1[8] = x1664;
    out1[9] = x1665;
    out1[10] = x1666;
    out1[11] = x1667;
}

/*
 * The function fiat_secp384r1_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_square(uint32_t out1[12], const uint32_t arg1[12])
{
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    fiat_secp384r1_uint1 x38;
    uint32_t x39;
    fiat_secp384r1_uint1 x40;
    uint32_t x41;
    fiat_secp384r1_uint1 x42;
    uint32_t x43;
    fiat_secp384r1_uint1 x44;
    uint32_t x45;
    fiat_secp384r1_uint1 x46;
    uint32_t x47;
    fiat_secp384r1_uint1 x48;
    uint32_t x49;
    fiat_secp384r1_uint1 x50;
    uint32_t x51;
    fiat_secp384r1_uint1 x52;
    uint32_t x53;
    fiat_secp384r1_uint1 x54;
    uint32_t x55;
    fiat_secp384r1_uint1 x56;
    uint32_t x57;
    fiat_secp384r1_uint1 x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    uint32_t x78;
    uint32_t x79;
    uint32_t x80;
    fiat_secp384r1_uint1 x81;
    uint32_t x82;
    fiat_secp384r1_uint1 x83;
    uint32_t x84;
    fiat_secp384r1_uint1 x85;
    uint32_t x86;
    fiat_secp384r1_uint1 x87;
    uint32_t x88;
    fiat_secp384r1_uint1 x89;
    uint32_t x90;
    fiat_secp384r1_uint1 x91;
    uint32_t x92;
    fiat_secp384r1_uint1 x93;
    uint32_t x94;
    fiat_secp384r1_uint1 x95;
    uint32_t x96;
    uint32_t x97;
    fiat_secp384r1_uint1 x98;
    uint32_t x99;
    fiat_secp384r1_uint1 x100;
    uint32_t x101;
    fiat_secp384r1_uint1 x102;
    uint32_t x103;
    fiat_secp384r1_uint1 x104;
    uint32_t x105;
    fiat_secp384r1_uint1 x106;
    uint32_t x107;
    fiat_secp384r1_uint1 x108;
    uint32_t x109;
    fiat_secp384r1_uint1 x110;
    uint32_t x111;
    fiat_secp384r1_uint1 x112;
    uint32_t x113;
    fiat_secp384r1_uint1 x114;
    uint32_t x115;
    fiat_secp384r1_uint1 x116;
    uint32_t x117;
    fiat_secp384r1_uint1 x118;
    uint32_t x119;
    fiat_secp384r1_uint1 x120;
    uint32_t x121;
    fiat_secp384r1_uint1 x122;
    uint32_t x123;
    uint32_t x124;
    uint32_t x125;
    uint32_t x126;
    uint32_t x127;
    uint32_t x128;
    uint32_t x129;
    uint32_t x130;
    uint32_t x131;
    uint32_t x132;
    uint32_t x133;
    uint32_t x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    fiat_secp384r1_uint1 x148;
    uint32_t x149;
    fiat_secp384r1_uint1 x150;
    uint32_t x151;
    fiat_secp384r1_uint1 x152;
    uint32_t x153;
    fiat_secp384r1_uint1 x154;
    uint32_t x155;
    fiat_secp384r1_uint1 x156;
    uint32_t x157;
    fiat_secp384r1_uint1 x158;
    uint32_t x159;
    fiat_secp384r1_uint1 x160;
    uint32_t x161;
    fiat_secp384r1_uint1 x162;
    uint32_t x163;
    fiat_secp384r1_uint1 x164;
    uint32_t x165;
    fiat_secp384r1_uint1 x166;
    uint32_t x167;
    fiat_secp384r1_uint1 x168;
    uint32_t x169;
    uint32_t x170;
    fiat_secp384r1_uint1 x171;
    uint32_t x172;
    fiat_secp384r1_uint1 x173;
    uint32_t x174;
    fiat_secp384r1_uint1 x175;
    uint32_t x176;
    fiat_secp384r1_uint1 x177;
    uint32_t x178;
    fiat_secp384r1_uint1 x179;
    uint32_t x180;
    fiat_secp384r1_uint1 x181;
    uint32_t x182;
    fiat_secp384r1_uint1 x183;
    uint32_t x184;
    fiat_secp384r1_uint1 x185;
    uint32_t x186;
    fiat_secp384r1_uint1 x187;
    uint32_t x188;
    fiat_secp384r1_uint1 x189;
    uint32_t x190;
    fiat_secp384r1_uint1 x191;
    uint32_t x192;
    fiat_secp384r1_uint1 x193;
    uint32_t x194;
    fiat_secp384r1_uint1 x195;
    uint32_t x196;
    uint32_t x197;
    uint32_t x198;
    uint32_t x199;
    uint32_t x200;
    uint32_t x201;
    uint32_t x202;
    uint32_t x203;
    uint32_t x204;
    uint32_t x205;
    uint32_t x206;
    uint32_t x207;
    uint32_t x208;
    uint32_t x209;
    uint32_t x210;
    uint32_t x211;
    uint32_t x212;
    uint32_t x213;
    uint32_t x214;
    uint32_t x215;
    uint32_t x216;
    fiat_secp384r1_uint1 x217;
    uint32_t x218;
    fiat_secp384r1_uint1 x219;
    uint32_t x220;
    fiat_secp384r1_uint1 x221;
    uint32_t x222;
    fiat_secp384r1_uint1 x223;
    uint32_t x224;
    fiat_secp384r1_uint1 x225;
    uint32_t x226;
    fiat_secp384r1_uint1 x227;
    uint32_t x228;
    fiat_secp384r1_uint1 x229;
    uint32_t x230;
    fiat_secp384r1_uint1 x231;
    uint32_t x232;
    uint32_t x233;
    fiat_secp384r1_uint1 x234;
    uint32_t x235;
    fiat_secp384r1_uint1 x236;
    uint32_t x237;
    fiat_secp384r1_uint1 x238;
    uint32_t x239;
    fiat_secp384r1_uint1 x240;
    uint32_t x241;
    fiat_secp384r1_uint1 x242;
    uint32_t x243;
    fiat_secp384r1_uint1 x244;
    uint32_t x245;
    fiat_secp384r1_uint1 x246;
    uint32_t x247;
    fiat_secp384r1_uint1 x248;
    uint32_t x249;
    fiat_secp384r1_uint1 x250;
    uint32_t x251;
    fiat_secp384r1_uint1 x252;
    uint32_t x253;
    fiat_secp384r1_uint1 x254;
    uint32_t x255;
    fiat_secp384r1_uint1 x256;
    uint32_t x257;
    fiat_secp384r1_uint1 x258;
    uint32_t x259;
    uint32_t x260;
    uint32_t x261;
    uint32_t x262;
    uint32_t x263;
    uint32_t x264;
    uint32_t x265;
    uint32_t x266;
    uint32_t x267;
    uint32_t x268;
    uint32_t x269;
    uint32_t x270;
    uint32_t x271;
    uint32_t x272;
    uint32_t x273;
    uint32_t x274;
    uint32_t x275;
    uint32_t x276;
    uint32_t x277;
    uint32_t x278;
    uint32_t x279;
    uint32_t x280;
    uint32_t x281;
    uint32_t x282;
    uint32_t x283;
    uint32_t x284;
    fiat_secp384r1_uint1 x285;
    uint32_t x286;
    fiat_secp384r1_uint1 x287;
    uint32_t x288;
    fiat_secp384r1_uint1 x289;
    uint32_t x290;
    fiat_secp384r1_uint1 x291;
    uint32_t x292;
    fiat_secp384r1_uint1 x293;
    uint32_t x294;
    fiat_secp384r1_uint1 x295;
    uint32_t x296;
    fiat_secp384r1_uint1 x297;
    uint32_t x298;
    fiat_secp384r1_uint1 x299;
    uint32_t x300;
    fiat_secp384r1_uint1 x301;
    uint32_t x302;
    fiat_secp384r1_uint1 x303;
    uint32_t x304;
    fiat_secp384r1_uint1 x305;
    uint32_t x306;
    uint32_t x307;
    fiat_secp384r1_uint1 x308;
    uint32_t x309;
    fiat_secp384r1_uint1 x310;
    uint32_t x311;
    fiat_secp384r1_uint1 x312;
    uint32_t x313;
    fiat_secp384r1_uint1 x314;
    uint32_t x315;
    fiat_secp384r1_uint1 x316;
    uint32_t x317;
    fiat_secp384r1_uint1 x318;
    uint32_t x319;
    fiat_secp384r1_uint1 x320;
    uint32_t x321;
    fiat_secp384r1_uint1 x322;
    uint32_t x323;
    fiat_secp384r1_uint1 x324;
    uint32_t x325;
    fiat_secp384r1_uint1 x326;
    uint32_t x327;
    fiat_secp384r1_uint1 x328;
    uint32_t x329;
    fiat_secp384r1_uint1 x330;
    uint32_t x331;
    fiat_secp384r1_uint1 x332;
    uint32_t x333;
    uint32_t x334;
    uint32_t x335;
    uint32_t x336;
    uint32_t x337;
    uint32_t x338;
    uint32_t x339;
    uint32_t x340;
    uint32_t x341;
    uint32_t x342;
    uint32_t x343;
    uint32_t x344;
    uint32_t x345;
    uint32_t x346;
    uint32_t x347;
    uint32_t x348;
    uint32_t x349;
    uint32_t x350;
    uint32_t x351;
    uint32_t x352;
    uint32_t x353;
    fiat_secp384r1_uint1 x354;
    uint32_t x355;
    fiat_secp384r1_uint1 x356;
    uint32_t x357;
    fiat_secp384r1_uint1 x358;
    uint32_t x359;
    fiat_secp384r1_uint1 x360;
    uint32_t x361;
    fiat_secp384r1_uint1 x362;
    uint32_t x363;
    fiat_secp384r1_uint1 x364;
    uint32_t x365;
    fiat_secp384r1_uint1 x366;
    uint32_t x367;
    fiat_secp384r1_uint1 x368;
    uint32_t x369;
    uint32_t x370;
    fiat_secp384r1_uint1 x371;
    uint32_t x372;
    fiat_secp384r1_uint1 x373;
    uint32_t x374;
    fiat_secp384r1_uint1 x375;
    uint32_t x376;
    fiat_secp384r1_uint1 x377;
    uint32_t x378;
    fiat_secp384r1_uint1 x379;
    uint32_t x380;
    fiat_secp384r1_uint1 x381;
    uint32_t x382;
    fiat_secp384r1_uint1 x383;
    uint32_t x384;
    fiat_secp384r1_uint1 x385;
    uint32_t x386;
    fiat_secp384r1_uint1 x387;
    uint32_t x388;
    fiat_secp384r1_uint1 x389;
    uint32_t x390;
    fiat_secp384r1_uint1 x391;
    uint32_t x392;
    fiat_secp384r1_uint1 x393;
    uint32_t x394;
    fiat_secp384r1_uint1 x395;
    uint32_t x396;
    uint32_t x397;
    uint32_t x398;
    uint32_t x399;
    uint32_t x400;
    uint32_t x401;
    uint32_t x402;
    uint32_t x403;
    uint32_t x404;
    uint32_t x405;
    uint32_t x406;
    uint32_t x407;
    uint32_t x408;
    uint32_t x409;
    uint32_t x410;
    uint32_t x411;
    uint32_t x412;
    uint32_t x413;
    uint32_t x414;
    uint32_t x415;
    uint32_t x416;
    uint32_t x417;
    uint32_t x418;
    uint32_t x419;
    uint32_t x420;
    uint32_t x421;
    fiat_secp384r1_uint1 x422;
    uint32_t x423;
    fiat_secp384r1_uint1 x424;
    uint32_t x425;
    fiat_secp384r1_uint1 x426;
    uint32_t x427;
    fiat_secp384r1_uint1 x428;
    uint32_t x429;
    fiat_secp384r1_uint1 x430;
    uint32_t x431;
    fiat_secp384r1_uint1 x432;
    uint32_t x433;
    fiat_secp384r1_uint1 x434;
    uint32_t x435;
    fiat_secp384r1_uint1 x436;
    uint32_t x437;
    fiat_secp384r1_uint1 x438;
    uint32_t x439;
    fiat_secp384r1_uint1 x440;
    uint32_t x441;
    fiat_secp384r1_uint1 x442;
    uint32_t x443;
    uint32_t x444;
    fiat_secp384r1_uint1 x445;
    uint32_t x446;
    fiat_secp384r1_uint1 x447;
    uint32_t x448;
    fiat_secp384r1_uint1 x449;
    uint32_t x450;
    fiat_secp384r1_uint1 x451;
    uint32_t x452;
    fiat_secp384r1_uint1 x453;
    uint32_t x454;
    fiat_secp384r1_uint1 x455;
    uint32_t x456;
    fiat_secp384r1_uint1 x457;
    uint32_t x458;
    fiat_secp384r1_uint1 x459;
    uint32_t x460;
    fiat_secp384r1_uint1 x461;
    uint32_t x462;
    fiat_secp384r1_uint1 x463;
    uint32_t x464;
    fiat_secp384r1_uint1 x465;
    uint32_t x466;
    fiat_secp384r1_uint1 x467;
    uint32_t x468;
    fiat_secp384r1_uint1 x469;
    uint32_t x470;
    uint32_t x471;
    uint32_t x472;
    uint32_t x473;
    uint32_t x474;
    uint32_t x475;
    uint32_t x476;
    uint32_t x477;
    uint32_t x478;
    uint32_t x479;
    uint32_t x480;
    uint32_t x481;
    uint32_t x482;
    uint32_t x483;
    uint32_t x484;
    uint32_t x485;
    uint32_t x486;
    uint32_t x487;
    uint32_t x488;
    uint32_t x489;
    uint32_t x490;
    fiat_secp384r1_uint1 x491;
    uint32_t x492;
    fiat_secp384r1_uint1 x493;
    uint32_t x494;
    fiat_secp384r1_uint1 x495;
    uint32_t x496;
    fiat_secp384r1_uint1 x497;
    uint32_t x498;
    fiat_secp384r1_uint1 x499;
    uint32_t x500;
    fiat_secp384r1_uint1 x501;
    uint32_t x502;
    fiat_secp384r1_uint1 x503;
    uint32_t x504;
    fiat_secp384r1_uint1 x505;
    uint32_t x506;
    uint32_t x507;
    fiat_secp384r1_uint1 x508;
    uint32_t x509;
    fiat_secp384r1_uint1 x510;
    uint32_t x511;
    fiat_secp384r1_uint1 x512;
    uint32_t x513;
    fiat_secp384r1_uint1 x514;
    uint32_t x515;
    fiat_secp384r1_uint1 x516;
    uint32_t x517;
    fiat_secp384r1_uint1 x518;
    uint32_t x519;
    fiat_secp384r1_uint1 x520;
    uint32_t x521;
    fiat_secp384r1_uint1 x522;
    uint32_t x523;
    fiat_secp384r1_uint1 x524;
    uint32_t x525;
    fiat_secp384r1_uint1 x526;
    uint32_t x527;
    fiat_secp384r1_uint1 x528;
    uint32_t x529;
    fiat_secp384r1_uint1 x530;
    uint32_t x531;
    fiat_secp384r1_uint1 x532;
    uint32_t x533;
    uint32_t x534;
    uint32_t x535;
    uint32_t x536;
    uint32_t x537;
    uint32_t x538;
    uint32_t x539;
    uint32_t x540;
    uint32_t x541;
    uint32_t x542;
    uint32_t x543;
    uint32_t x544;
    uint32_t x545;
    uint32_t x546;
    uint32_t x547;
    uint32_t x548;
    uint32_t x549;
    uint32_t x550;
    uint32_t x551;
    uint32_t x552;
    uint32_t x553;
    uint32_t x554;
    uint32_t x555;
    uint32_t x556;
    uint32_t x557;
    uint32_t x558;
    fiat_secp384r1_uint1 x559;
    uint32_t x560;
    fiat_secp384r1_uint1 x561;
    uint32_t x562;
    fiat_secp384r1_uint1 x563;
    uint32_t x564;
    fiat_secp384r1_uint1 x565;
    uint32_t x566;
    fiat_secp384r1_uint1 x567;
    uint32_t x568;
    fiat_secp384r1_uint1 x569;
    uint32_t x570;
    fiat_secp384r1_uint1 x571;
    uint32_t x572;
    fiat_secp384r1_uint1 x573;
    uint32_t x574;
    fiat_secp384r1_uint1 x575;
    uint32_t x576;
    fiat_secp384r1_uint1 x577;
    uint32_t x578;
    fiat_secp384r1_uint1 x579;
    uint32_t x580;
    uint32_t x581;
    fiat_secp384r1_uint1 x582;
    uint32_t x583;
    fiat_secp384r1_uint1 x584;
    uint32_t x585;
    fiat_secp384r1_uint1 x586;
    uint32_t x587;
    fiat_secp384r1_uint1 x588;
    uint32_t x589;
    fiat_secp384r1_uint1 x590;
    uint32_t x591;
    fiat_secp384r1_uint1 x592;
    uint32_t x593;
    fiat_secp384r1_uint1 x594;
    uint32_t x595;
    fiat_secp384r1_uint1 x596;
    uint32_t x597;
    fiat_secp384r1_uint1 x598;
    uint32_t x599;
    fiat_secp384r1_uint1 x600;
    uint32_t x601;
    fiat_secp384r1_uint1 x602;
    uint32_t x603;
    fiat_secp384r1_uint1 x604;
    uint32_t x605;
    fiat_secp384r1_uint1 x606;
    uint32_t x607;
    uint32_t x608;
    uint32_t x609;
    uint32_t x610;
    uint32_t x611;
    uint32_t x612;
    uint32_t x613;
    uint32_t x614;
    uint32_t x615;
    uint32_t x616;
    uint32_t x617;
    uint32_t x618;
    uint32_t x619;
    uint32_t x620;
    uint32_t x621;
    uint32_t x622;
    uint32_t x623;
    uint32_t x624;
    uint32_t x625;
    uint32_t x626;
    uint32_t x627;
    fiat_secp384r1_uint1 x628;
    uint32_t x629;
    fiat_secp384r1_uint1 x630;
    uint32_t x631;
    fiat_secp384r1_uint1 x632;
    uint32_t x633;
    fiat_secp384r1_uint1 x634;
    uint32_t x635;
    fiat_secp384r1_uint1 x636;
    uint32_t x637;
    fiat_secp384r1_uint1 x638;
    uint32_t x639;
    fiat_secp384r1_uint1 x640;
    uint32_t x641;
    fiat_secp384r1_uint1 x642;
    uint32_t x643;
    uint32_t x644;
    fiat_secp384r1_uint1 x645;
    uint32_t x646;
    fiat_secp384r1_uint1 x647;
    uint32_t x648;
    fiat_secp384r1_uint1 x649;
    uint32_t x650;
    fiat_secp384r1_uint1 x651;
    uint32_t x652;
    fiat_secp384r1_uint1 x653;
    uint32_t x654;
    fiat_secp384r1_uint1 x655;
    uint32_t x656;
    fiat_secp384r1_uint1 x657;
    uint32_t x658;
    fiat_secp384r1_uint1 x659;
    uint32_t x660;
    fiat_secp384r1_uint1 x661;
    uint32_t x662;
    fiat_secp384r1_uint1 x663;
    uint32_t x664;
    fiat_secp384r1_uint1 x665;
    uint32_t x666;
    fiat_secp384r1_uint1 x667;
    uint32_t x668;
    fiat_secp384r1_uint1 x669;
    uint32_t x670;
    uint32_t x671;
    uint32_t x672;
    uint32_t x673;
    uint32_t x674;
    uint32_t x675;
    uint32_t x676;
    uint32_t x677;
    uint32_t x678;
    uint32_t x679;
    uint32_t x680;
    uint32_t x681;
    uint32_t x682;
    uint32_t x683;
    uint32_t x684;
    uint32_t x685;
    uint32_t x686;
    uint32_t x687;
    uint32_t x688;
    uint32_t x689;
    uint32_t x690;
    uint32_t x691;
    uint32_t x692;
    uint32_t x693;
    uint32_t x694;
    uint32_t x695;
    fiat_secp384r1_uint1 x696;
    uint32_t x697;
    fiat_secp384r1_uint1 x698;
    uint32_t x699;
    fiat_secp384r1_uint1 x700;
    uint32_t x701;
    fiat_secp384r1_uint1 x702;
    uint32_t x703;
    fiat_secp384r1_uint1 x704;
    uint32_t x705;
    fiat_secp384r1_uint1 x706;
    uint32_t x707;
    fiat_secp384r1_uint1 x708;
    uint32_t x709;
    fiat_secp384r1_uint1 x710;
    uint32_t x711;
    fiat_secp384r1_uint1 x712;
    uint32_t x713;
    fiat_secp384r1_uint1 x714;
    uint32_t x715;
    fiat_secp384r1_uint1 x716;
    uint32_t x717;
    uint32_t x718;
    fiat_secp384r1_uint1 x719;
    uint32_t x720;
    fiat_secp384r1_uint1 x721;
    uint32_t x722;
    fiat_secp384r1_uint1 x723;
    uint32_t x724;
    fiat_secp384r1_uint1 x725;
    uint32_t x726;
    fiat_secp384r1_uint1 x727;
    uint32_t x728;
    fiat_secp384r1_uint1 x729;
    uint32_t x730;
    fiat_secp384r1_uint1 x731;
    uint32_t x732;
    fiat_secp384r1_uint1 x733;
    uint32_t x734;
    fiat_secp384r1_uint1 x735;
    uint32_t x736;
    fiat_secp384r1_uint1 x737;
    uint32_t x738;
    fiat_secp384r1_uint1 x739;
    uint32_t x740;
    fiat_secp384r1_uint1 x741;
    uint32_t x742;
    fiat_secp384r1_uint1 x743;
    uint32_t x744;
    uint32_t x745;
    uint32_t x746;
    uint32_t x747;
    uint32_t x748;
    uint32_t x749;
    uint32_t x750;
    uint32_t x751;
    uint32_t x752;
    uint32_t x753;
    uint32_t x754;
    uint32_t x755;
    uint32_t x756;
    uint32_t x757;
    uint32_t x758;
    uint32_t x759;
    uint32_t x760;
    uint32_t x761;
    uint32_t x762;
    uint32_t x763;
    uint32_t x764;
    fiat_secp384r1_uint1 x765;
    uint32_t x766;
    fiat_secp384r1_uint1 x767;
    uint32_t x768;
    fiat_secp384r1_uint1 x769;
    uint32_t x770;
    fiat_secp384r1_uint1 x771;
    uint32_t x772;
    fiat_secp384r1_uint1 x773;
    uint32_t x774;
    fiat_secp384r1_uint1 x775;
    uint32_t x776;
    fiat_secp384r1_uint1 x777;
    uint32_t x778;
    fiat_secp384r1_uint1 x779;
    uint32_t x780;
    uint32_t x781;
    fiat_secp384r1_uint1 x782;
    uint32_t x783;
    fiat_secp384r1_uint1 x784;
    uint32_t x785;
    fiat_secp384r1_uint1 x786;
    uint32_t x787;
    fiat_secp384r1_uint1 x788;
    uint32_t x789;
    fiat_secp384r1_uint1 x790;
    uint32_t x791;
    fiat_secp384r1_uint1 x792;
    uint32_t x793;
    fiat_secp384r1_uint1 x794;
    uint32_t x795;
    fiat_secp384r1_uint1 x796;
    uint32_t x797;
    fiat_secp384r1_uint1 x798;
    uint32_t x799;
    fiat_secp384r1_uint1 x800;
    uint32_t x801;
    fiat_secp384r1_uint1 x802;
    uint32_t x803;
    fiat_secp384r1_uint1 x804;
    uint32_t x805;
    fiat_secp384r1_uint1 x806;
    uint32_t x807;
    uint32_t x808;
    uint32_t x809;
    uint32_t x810;
    uint32_t x811;
    uint32_t x812;
    uint32_t x813;
    uint32_t x814;
    uint32_t x815;
    uint32_t x816;
    uint32_t x817;
    uint32_t x818;
    uint32_t x819;
    uint32_t x820;
    uint32_t x821;
    uint32_t x822;
    uint32_t x823;
    uint32_t x824;
    uint32_t x825;
    uint32_t x826;
    uint32_t x827;
    uint32_t x828;
    uint32_t x829;
    uint32_t x830;
    uint32_t x831;
    uint32_t x832;
    fiat_secp384r1_uint1 x833;
    uint32_t x834;
    fiat_secp384r1_uint1 x835;
    uint32_t x836;
    fiat_secp384r1_uint1 x837;
    uint32_t x838;
    fiat_secp384r1_uint1 x839;
    uint32_t x840;
    fiat_secp384r1_uint1 x841;
    uint32_t x842;
    fiat_secp384r1_uint1 x843;
    uint32_t x844;
    fiat_secp384r1_uint1 x845;
    uint32_t x846;
    fiat_secp384r1_uint1 x847;
    uint32_t x848;
    fiat_secp384r1_uint1 x849;
    uint32_t x850;
    fiat_secp384r1_uint1 x851;
    uint32_t x852;
    fiat_secp384r1_uint1 x853;
    uint32_t x854;
    uint32_t x855;
    fiat_secp384r1_uint1 x856;
    uint32_t x857;
    fiat_secp384r1_uint1 x858;
    uint32_t x859;
    fiat_secp384r1_uint1 x860;
    uint32_t x861;
    fiat_secp384r1_uint1 x862;
    uint32_t x863;
    fiat_secp384r1_uint1 x864;
    uint32_t x865;
    fiat_secp384r1_uint1 x866;
    uint32_t x867;
    fiat_secp384r1_uint1 x868;
    uint32_t x869;
    fiat_secp384r1_uint1 x870;
    uint32_t x871;
    fiat_secp384r1_uint1 x872;
    uint32_t x873;
    fiat_secp384r1_uint1 x874;
    uint32_t x875;
    fiat_secp384r1_uint1 x876;
    uint32_t x877;
    fiat_secp384r1_uint1 x878;
    uint32_t x879;
    fiat_secp384r1_uint1 x880;
    uint32_t x881;
    uint32_t x882;
    uint32_t x883;
    uint32_t x884;
    uint32_t x885;
    uint32_t x886;
    uint32_t x887;
    uint32_t x888;
    uint32_t x889;
    uint32_t x890;
    uint32_t x891;
    uint32_t x892;
    uint32_t x893;
    uint32_t x894;
    uint32_t x895;
    uint32_t x896;
    uint32_t x897;
    uint32_t x898;
    uint32_t x899;
    uint32_t x900;
    uint32_t x901;
    fiat_secp384r1_uint1 x902;
    uint32_t x903;
    fiat_secp384r1_uint1 x904;
    uint32_t x905;
    fiat_secp384r1_uint1 x906;
    uint32_t x907;
    fiat_secp384r1_uint1 x908;
    uint32_t x909;
    fiat_secp384r1_uint1 x910;
    uint32_t x911;
    fiat_secp384r1_uint1 x912;
    uint32_t x913;
    fiat_secp384r1_uint1 x914;
    uint32_t x915;
    fiat_secp384r1_uint1 x916;
    uint32_t x917;
    uint32_t x918;
    fiat_secp384r1_uint1 x919;
    uint32_t x920;
    fiat_secp384r1_uint1 x921;
    uint32_t x922;
    fiat_secp384r1_uint1 x923;
    uint32_t x924;
    fiat_secp384r1_uint1 x925;
    uint32_t x926;
    fiat_secp384r1_uint1 x927;
    uint32_t x928;
    fiat_secp384r1_uint1 x929;
    uint32_t x930;
    fiat_secp384r1_uint1 x931;
    uint32_t x932;
    fiat_secp384r1_uint1 x933;
    uint32_t x934;
    fiat_secp384r1_uint1 x935;
    uint32_t x936;
    fiat_secp384r1_uint1 x937;
    uint32_t x938;
    fiat_secp384r1_uint1 x939;
    uint32_t x940;
    fiat_secp384r1_uint1 x941;
    uint32_t x942;
    fiat_secp384r1_uint1 x943;
    uint32_t x944;
    uint32_t x945;
    uint32_t x946;
    uint32_t x947;
    uint32_t x948;
    uint32_t x949;
    uint32_t x950;
    uint32_t x951;
    uint32_t x952;
    uint32_t x953;
    uint32_t x954;
    uint32_t x955;
    uint32_t x956;
    uint32_t x957;
    uint32_t x958;
    uint32_t x959;
    uint32_t x960;
    uint32_t x961;
    uint32_t x962;
    uint32_t x963;
    uint32_t x964;
    uint32_t x965;
    uint32_t x966;
    uint32_t x967;
    uint32_t x968;
    uint32_t x969;
    fiat_secp384r1_uint1 x970;
    uint32_t x971;
    fiat_secp384r1_uint1 x972;
    uint32_t x973;
    fiat_secp384r1_uint1 x974;
    uint32_t x975;
    fiat_secp384r1_uint1 x976;
    uint32_t x977;
    fiat_secp384r1_uint1 x978;
    uint32_t x979;
    fiat_secp384r1_uint1 x980;
    uint32_t x981;
    fiat_secp384r1_uint1 x982;
    uint32_t x983;
    fiat_secp384r1_uint1 x984;
    uint32_t x985;
    fiat_secp384r1_uint1 x986;
    uint32_t x987;
    fiat_secp384r1_uint1 x988;
    uint32_t x989;
    fiat_secp384r1_uint1 x990;
    uint32_t x991;
    uint32_t x992;
    fiat_secp384r1_uint1 x993;
    uint32_t x994;
    fiat_secp384r1_uint1 x995;
    uint32_t x996;
    fiat_secp384r1_uint1 x997;
    uint32_t x998;
    fiat_secp384r1_uint1 x999;
    uint32_t x1000;
    fiat_secp384r1_uint1 x1001;
    uint32_t x1002;
    fiat_secp384r1_uint1 x1003;
    uint32_t x1004;
    fiat_secp384r1_uint1 x1005;
    uint32_t x1006;
    fiat_secp384r1_uint1 x1007;
    uint32_t x1008;
    fiat_secp384r1_uint1 x1009;
    uint32_t x1010;
    fiat_secp384r1_uint1 x1011;
    uint32_t x1012;
    fiat_secp384r1_uint1 x1013;
    uint32_t x1014;
    fiat_secp384r1_uint1 x1015;
    uint32_t x1016;
    fiat_secp384r1_uint1 x1017;
    uint32_t x1018;
    uint32_t x1019;
    uint32_t x1020;
    uint32_t x1021;
    uint32_t x1022;
    uint32_t x1023;
    uint32_t x1024;
    uint32_t x1025;
    uint32_t x1026;
    uint32_t x1027;
    uint32_t x1028;
    uint32_t x1029;
    uint32_t x1030;
    uint32_t x1031;
    uint32_t x1032;
    uint32_t x1033;
    uint32_t x1034;
    uint32_t x1035;
    uint32_t x1036;
    uint32_t x1037;
    uint32_t x1038;
    fiat_secp384r1_uint1 x1039;
    uint32_t x1040;
    fiat_secp384r1_uint1 x1041;
    uint32_t x1042;
    fiat_secp384r1_uint1 x1043;
    uint32_t x1044;
    fiat_secp384r1_uint1 x1045;
    uint32_t x1046;
    fiat_secp384r1_uint1 x1047;
    uint32_t x1048;
    fiat_secp384r1_uint1 x1049;
    uint32_t x1050;
    fiat_secp384r1_uint1 x1051;
    uint32_t x1052;
    fiat_secp384r1_uint1 x1053;
    uint32_t x1054;
    uint32_t x1055;
    fiat_secp384r1_uint1 x1056;
    uint32_t x1057;
    fiat_secp384r1_uint1 x1058;
    uint32_t x1059;
    fiat_secp384r1_uint1 x1060;
    uint32_t x1061;
    fiat_secp384r1_uint1 x1062;
    uint32_t x1063;
    fiat_secp384r1_uint1 x1064;
    uint32_t x1065;
    fiat_secp384r1_uint1 x1066;
    uint32_t x1067;
    fiat_secp384r1_uint1 x1068;
    uint32_t x1069;
    fiat_secp384r1_uint1 x1070;
    uint32_t x1071;
    fiat_secp384r1_uint1 x1072;
    uint32_t x1073;
    fiat_secp384r1_uint1 x1074;
    uint32_t x1075;
    fiat_secp384r1_uint1 x1076;
    uint32_t x1077;
    fiat_secp384r1_uint1 x1078;
    uint32_t x1079;
    fiat_secp384r1_uint1 x1080;
    uint32_t x1081;
    uint32_t x1082;
    uint32_t x1083;
    uint32_t x1084;
    uint32_t x1085;
    uint32_t x1086;
    uint32_t x1087;
    uint32_t x1088;
    uint32_t x1089;
    uint32_t x1090;
    uint32_t x1091;
    uint32_t x1092;
    uint32_t x1093;
    uint32_t x1094;
    uint32_t x1095;
    uint32_t x1096;
    uint32_t x1097;
    uint32_t x1098;
    uint32_t x1099;
    uint32_t x1100;
    uint32_t x1101;
    uint32_t x1102;
    uint32_t x1103;
    uint32_t x1104;
    uint32_t x1105;
    uint32_t x1106;
    fiat_secp384r1_uint1 x1107;
    uint32_t x1108;
    fiat_secp384r1_uint1 x1109;
    uint32_t x1110;
    fiat_secp384r1_uint1 x1111;
    uint32_t x1112;
    fiat_secp384r1_uint1 x1113;
    uint32_t x1114;
    fiat_secp384r1_uint1 x1115;
    uint32_t x1116;
    fiat_secp384r1_uint1 x1117;
    uint32_t x1118;
    fiat_secp384r1_uint1 x1119;
    uint32_t x1120;
    fiat_secp384r1_uint1 x1121;
    uint32_t x1122;
    fiat_secp384r1_uint1 x1123;
    uint32_t x1124;
    fiat_secp384r1_uint1 x1125;
    uint32_t x1126;
    fiat_secp384r1_uint1 x1127;
    uint32_t x1128;
    uint32_t x1129;
    fiat_secp384r1_uint1 x1130;
    uint32_t x1131;
    fiat_secp384r1_uint1 x1132;
    uint32_t x1133;
    fiat_secp384r1_uint1 x1134;
    uint32_t x1135;
    fiat_secp384r1_uint1 x1136;
    uint32_t x1137;
    fiat_secp384r1_uint1 x1138;
    uint32_t x1139;
    fiat_secp384r1_uint1 x1140;
    uint32_t x1141;
    fiat_secp384r1_uint1 x1142;
    uint32_t x1143;
    fiat_secp384r1_uint1 x1144;
    uint32_t x1145;
    fiat_secp384r1_uint1 x1146;
    uint32_t x1147;
    fiat_secp384r1_uint1 x1148;
    uint32_t x1149;
    fiat_secp384r1_uint1 x1150;
    uint32_t x1151;
    fiat_secp384r1_uint1 x1152;
    uint32_t x1153;
    fiat_secp384r1_uint1 x1154;
    uint32_t x1155;
    uint32_t x1156;
    uint32_t x1157;
    uint32_t x1158;
    uint32_t x1159;
    uint32_t x1160;
    uint32_t x1161;
    uint32_t x1162;
    uint32_t x1163;
    uint32_t x1164;
    uint32_t x1165;
    uint32_t x1166;
    uint32_t x1167;
    uint32_t x1168;
    uint32_t x1169;
    uint32_t x1170;
    uint32_t x1171;
    uint32_t x1172;
    uint32_t x1173;
    uint32_t x1174;
    uint32_t x1175;
    fiat_secp384r1_uint1 x1176;
    uint32_t x1177;
    fiat_secp384r1_uint1 x1178;
    uint32_t x1179;
    fiat_secp384r1_uint1 x1180;
    uint32_t x1181;
    fiat_secp384r1_uint1 x1182;
    uint32_t x1183;
    fiat_secp384r1_uint1 x1184;
    uint32_t x1185;
    fiat_secp384r1_uint1 x1186;
    uint32_t x1187;
    fiat_secp384r1_uint1 x1188;
    uint32_t x1189;
    fiat_secp384r1_uint1 x1190;
    uint32_t x1191;
    uint32_t x1192;
    fiat_secp384r1_uint1 x1193;
    uint32_t x1194;
    fiat_secp384r1_uint1 x1195;
    uint32_t x1196;
    fiat_secp384r1_uint1 x1197;
    uint32_t x1198;
    fiat_secp384r1_uint1 x1199;
    uint32_t x1200;
    fiat_secp384r1_uint1 x1201;
    uint32_t x1202;
    fiat_secp384r1_uint1 x1203;
    uint32_t x1204;
    fiat_secp384r1_uint1 x1205;
    uint32_t x1206;
    fiat_secp384r1_uint1 x1207;
    uint32_t x1208;
    fiat_secp384r1_uint1 x1209;
    uint32_t x1210;
    fiat_secp384r1_uint1 x1211;
    uint32_t x1212;
    fiat_secp384r1_uint1 x1213;
    uint32_t x1214;
    fiat_secp384r1_uint1 x1215;
    uint32_t x1216;
    fiat_secp384r1_uint1 x1217;
    uint32_t x1218;
    uint32_t x1219;
    uint32_t x1220;
    uint32_t x1221;
    uint32_t x1222;
    uint32_t x1223;
    uint32_t x1224;
    uint32_t x1225;
    uint32_t x1226;
    uint32_t x1227;
    uint32_t x1228;
    uint32_t x1229;
    uint32_t x1230;
    uint32_t x1231;
    uint32_t x1232;
    uint32_t x1233;
    uint32_t x1234;
    uint32_t x1235;
    uint32_t x1236;
    uint32_t x1237;
    uint32_t x1238;
    uint32_t x1239;
    uint32_t x1240;
    uint32_t x1241;
    uint32_t x1242;
    uint32_t x1243;
    fiat_secp384r1_uint1 x1244;
    uint32_t x1245;
    fiat_secp384r1_uint1 x1246;
    uint32_t x1247;
    fiat_secp384r1_uint1 x1248;
    uint32_t x1249;
    fiat_secp384r1_uint1 x1250;
    uint32_t x1251;
    fiat_secp384r1_uint1 x1252;
    uint32_t x1253;
    fiat_secp384r1_uint1 x1254;
    uint32_t x1255;
    fiat_secp384r1_uint1 x1256;
    uint32_t x1257;
    fiat_secp384r1_uint1 x1258;
    uint32_t x1259;
    fiat_secp384r1_uint1 x1260;
    uint32_t x1261;
    fiat_secp384r1_uint1 x1262;
    uint32_t x1263;
    fiat_secp384r1_uint1 x1264;
    uint32_t x1265;
    uint32_t x1266;
    fiat_secp384r1_uint1 x1267;
    uint32_t x1268;
    fiat_secp384r1_uint1 x1269;
    uint32_t x1270;
    fiat_secp384r1_uint1 x1271;
    uint32_t x1272;
    fiat_secp384r1_uint1 x1273;
    uint32_t x1274;
    fiat_secp384r1_uint1 x1275;
    uint32_t x1276;
    fiat_secp384r1_uint1 x1277;
    uint32_t x1278;
    fiat_secp384r1_uint1 x1279;
    uint32_t x1280;
    fiat_secp384r1_uint1 x1281;
    uint32_t x1282;
    fiat_secp384r1_uint1 x1283;
    uint32_t x1284;
    fiat_secp384r1_uint1 x1285;
    uint32_t x1286;
    fiat_secp384r1_uint1 x1287;
    uint32_t x1288;
    fiat_secp384r1_uint1 x1289;
    uint32_t x1290;
    fiat_secp384r1_uint1 x1291;
    uint32_t x1292;
    uint32_t x1293;
    uint32_t x1294;
    uint32_t x1295;
    uint32_t x1296;
    uint32_t x1297;
    uint32_t x1298;
    uint32_t x1299;
    uint32_t x1300;
    uint32_t x1301;
    uint32_t x1302;
    uint32_t x1303;
    uint32_t x1304;
    uint32_t x1305;
    uint32_t x1306;
    uint32_t x1307;
    uint32_t x1308;
    uint32_t x1309;
    uint32_t x1310;
    uint32_t x1311;
    uint32_t x1312;
    fiat_secp384r1_uint1 x1313;
    uint32_t x1314;
    fiat_secp384r1_uint1 x1315;
    uint32_t x1316;
    fiat_secp384r1_uint1 x1317;
    uint32_t x1318;
    fiat_secp384r1_uint1 x1319;
    uint32_t x1320;
    fiat_secp384r1_uint1 x1321;
    uint32_t x1322;
    fiat_secp384r1_uint1 x1323;
    uint32_t x1324;
    fiat_secp384r1_uint1 x1325;
    uint32_t x1326;
    fiat_secp384r1_uint1 x1327;
    uint32_t x1328;
    uint32_t x1329;
    fiat_secp384r1_uint1 x1330;
    uint32_t x1331;
    fiat_secp384r1_uint1 x1332;
    uint32_t x1333;
    fiat_secp384r1_uint1 x1334;
    uint32_t x1335;
    fiat_secp384r1_uint1 x1336;
    uint32_t x1337;
    fiat_secp384r1_uint1 x1338;
    uint32_t x1339;
    fiat_secp384r1_uint1 x1340;
    uint32_t x1341;
    fiat_secp384r1_uint1 x1342;
    uint32_t x1343;
    fiat_secp384r1_uint1 x1344;
    uint32_t x1345;
    fiat_secp384r1_uint1 x1346;
    uint32_t x1347;
    fiat_secp384r1_uint1 x1348;
    uint32_t x1349;
    fiat_secp384r1_uint1 x1350;
    uint32_t x1351;
    fiat_secp384r1_uint1 x1352;
    uint32_t x1353;
    fiat_secp384r1_uint1 x1354;
    uint32_t x1355;
    uint32_t x1356;
    uint32_t x1357;
    uint32_t x1358;
    uint32_t x1359;
    uint32_t x1360;
    uint32_t x1361;
    uint32_t x1362;
    uint32_t x1363;
    uint32_t x1364;
    uint32_t x1365;
    uint32_t x1366;
    uint32_t x1367;
    uint32_t x1368;
    uint32_t x1369;
    uint32_t x1370;
    uint32_t x1371;
    uint32_t x1372;
    uint32_t x1373;
    uint32_t x1374;
    uint32_t x1375;
    uint32_t x1376;
    uint32_t x1377;
    uint32_t x1378;
    uint32_t x1379;
    uint32_t x1380;
    fiat_secp384r1_uint1 x1381;
    uint32_t x1382;
    fiat_secp384r1_uint1 x1383;
    uint32_t x1384;
    fiat_secp384r1_uint1 x1385;
    uint32_t x1386;
    fiat_secp384r1_uint1 x1387;
    uint32_t x1388;
    fiat_secp384r1_uint1 x1389;
    uint32_t x1390;
    fiat_secp384r1_uint1 x1391;
    uint32_t x1392;
    fiat_secp384r1_uint1 x1393;
    uint32_t x1394;
    fiat_secp384r1_uint1 x1395;
    uint32_t x1396;
    fiat_secp384r1_uint1 x1397;
    uint32_t x1398;
    fiat_secp384r1_uint1 x1399;
    uint32_t x1400;
    fiat_secp384r1_uint1 x1401;
    uint32_t x1402;
    uint32_t x1403;
    fiat_secp384r1_uint1 x1404;
    uint32_t x1405;
    fiat_secp384r1_uint1 x1406;
    uint32_t x1407;
    fiat_secp384r1_uint1 x1408;
    uint32_t x1409;
    fiat_secp384r1_uint1 x1410;
    uint32_t x1411;
    fiat_secp384r1_uint1 x1412;
    uint32_t x1413;
    fiat_secp384r1_uint1 x1414;
    uint32_t x1415;
    fiat_secp384r1_uint1 x1416;
    uint32_t x1417;
    fiat_secp384r1_uint1 x1418;
    uint32_t x1419;
    fiat_secp384r1_uint1 x1420;
    uint32_t x1421;
    fiat_secp384r1_uint1 x1422;
    uint32_t x1423;
    fiat_secp384r1_uint1 x1424;
    uint32_t x1425;
    fiat_secp384r1_uint1 x1426;
    uint32_t x1427;
    fiat_secp384r1_uint1 x1428;
    uint32_t x1429;
    uint32_t x1430;
    uint32_t x1431;
    uint32_t x1432;
    uint32_t x1433;
    uint32_t x1434;
    uint32_t x1435;
    uint32_t x1436;
    uint32_t x1437;
    uint32_t x1438;
    uint32_t x1439;
    uint32_t x1440;
    uint32_t x1441;
    uint32_t x1442;
    uint32_t x1443;
    uint32_t x1444;
    uint32_t x1445;
    uint32_t x1446;
    uint32_t x1447;
    uint32_t x1448;
    uint32_t x1449;
    fiat_secp384r1_uint1 x1450;
    uint32_t x1451;
    fiat_secp384r1_uint1 x1452;
    uint32_t x1453;
    fiat_secp384r1_uint1 x1454;
    uint32_t x1455;
    fiat_secp384r1_uint1 x1456;
    uint32_t x1457;
    fiat_secp384r1_uint1 x1458;
    uint32_t x1459;
    fiat_secp384r1_uint1 x1460;
    uint32_t x1461;
    fiat_secp384r1_uint1 x1462;
    uint32_t x1463;
    fiat_secp384r1_uint1 x1464;
    uint32_t x1465;
    uint32_t x1466;
    fiat_secp384r1_uint1 x1467;
    uint32_t x1468;
    fiat_secp384r1_uint1 x1469;
    uint32_t x1470;
    fiat_secp384r1_uint1 x1471;
    uint32_t x1472;
    fiat_secp384r1_uint1 x1473;
    uint32_t x1474;
    fiat_secp384r1_uint1 x1475;
    uint32_t x1476;
    fiat_secp384r1_uint1 x1477;
    uint32_t x1478;
    fiat_secp384r1_uint1 x1479;
    uint32_t x1480;
    fiat_secp384r1_uint1 x1481;
    uint32_t x1482;
    fiat_secp384r1_uint1 x1483;
    uint32_t x1484;
    fiat_secp384r1_uint1 x1485;
    uint32_t x1486;
    fiat_secp384r1_uint1 x1487;
    uint32_t x1488;
    fiat_secp384r1_uint1 x1489;
    uint32_t x1490;
    fiat_secp384r1_uint1 x1491;
    uint32_t x1492;
    uint32_t x1493;
    uint32_t x1494;
    uint32_t x1495;
    uint32_t x1496;
    uint32_t x1497;
    uint32_t x1498;
    uint32_t x1499;
    uint32_t x1500;
    uint32_t x1501;
    uint32_t x1502;
    uint32_t x1503;
    uint32_t x1504;
    uint32_t x1505;
    uint32_t x1506;
    uint32_t x1507;
    uint32_t x1508;
    uint32_t x1509;
    uint32_t x1510;
    uint32_t x1511;
    uint32_t x1512;
    uint32_t x1513;
    uint32_t x1514;
    uint32_t x1515;
    uint32_t x1516;
    uint32_t x1517;
    fiat_secp384r1_uint1 x1518;
    uint32_t x1519;
    fiat_secp384r1_uint1 x1520;
    uint32_t x1521;
    fiat_secp384r1_uint1 x1522;
    uint32_t x1523;
    fiat_secp384r1_uint1 x1524;
    uint32_t x1525;
    fiat_secp384r1_uint1 x1526;
    uint32_t x1527;
    fiat_secp384r1_uint1 x1528;
    uint32_t x1529;
    fiat_secp384r1_uint1 x1530;
    uint32_t x1531;
    fiat_secp384r1_uint1 x1532;
    uint32_t x1533;
    fiat_secp384r1_uint1 x1534;
    uint32_t x1535;
    fiat_secp384r1_uint1 x1536;
    uint32_t x1537;
    fiat_secp384r1_uint1 x1538;
    uint32_t x1539;
    uint32_t x1540;
    fiat_secp384r1_uint1 x1541;
    uint32_t x1542;
    fiat_secp384r1_uint1 x1543;
    uint32_t x1544;
    fiat_secp384r1_uint1 x1545;
    uint32_t x1546;
    fiat_secp384r1_uint1 x1547;
    uint32_t x1548;
    fiat_secp384r1_uint1 x1549;
    uint32_t x1550;
    fiat_secp384r1_uint1 x1551;
    uint32_t x1552;
    fiat_secp384r1_uint1 x1553;
    uint32_t x1554;
    fiat_secp384r1_uint1 x1555;
    uint32_t x1556;
    fiat_secp384r1_uint1 x1557;
    uint32_t x1558;
    fiat_secp384r1_uint1 x1559;
    uint32_t x1560;
    fiat_secp384r1_uint1 x1561;
    uint32_t x1562;
    fiat_secp384r1_uint1 x1563;
    uint32_t x1564;
    fiat_secp384r1_uint1 x1565;
    uint32_t x1566;
    uint32_t x1567;
    uint32_t x1568;
    uint32_t x1569;
    uint32_t x1570;
    uint32_t x1571;
    uint32_t x1572;
    uint32_t x1573;
    uint32_t x1574;
    uint32_t x1575;
    uint32_t x1576;
    uint32_t x1577;
    uint32_t x1578;
    uint32_t x1579;
    uint32_t x1580;
    uint32_t x1581;
    uint32_t x1582;
    uint32_t x1583;
    uint32_t x1584;
    uint32_t x1585;
    uint32_t x1586;
    fiat_secp384r1_uint1 x1587;
    uint32_t x1588;
    fiat_secp384r1_uint1 x1589;
    uint32_t x1590;
    fiat_secp384r1_uint1 x1591;
    uint32_t x1592;
    fiat_secp384r1_uint1 x1593;
    uint32_t x1594;
    fiat_secp384r1_uint1 x1595;
    uint32_t x1596;
    fiat_secp384r1_uint1 x1597;
    uint32_t x1598;
    fiat_secp384r1_uint1 x1599;
    uint32_t x1600;
    fiat_secp384r1_uint1 x1601;
    uint32_t x1602;
    uint32_t x1603;
    fiat_secp384r1_uint1 x1604;
    uint32_t x1605;
    fiat_secp384r1_uint1 x1606;
    uint32_t x1607;
    fiat_secp384r1_uint1 x1608;
    uint32_t x1609;
    fiat_secp384r1_uint1 x1610;
    uint32_t x1611;
    fiat_secp384r1_uint1 x1612;
    uint32_t x1613;
    fiat_secp384r1_uint1 x1614;
    uint32_t x1615;
    fiat_secp384r1_uint1 x1616;
    uint32_t x1617;
    fiat_secp384r1_uint1 x1618;
    uint32_t x1619;
    fiat_secp384r1_uint1 x1620;
    uint32_t x1621;
    fiat_secp384r1_uint1 x1622;
    uint32_t x1623;
    fiat_secp384r1_uint1 x1624;
    uint32_t x1625;
    fiat_secp384r1_uint1 x1626;
    uint32_t x1627;
    fiat_secp384r1_uint1 x1628;
    uint32_t x1629;
    uint32_t x1630;
    fiat_secp384r1_uint1 x1631;
    uint32_t x1632;
    fiat_secp384r1_uint1 x1633;
    uint32_t x1634;
    fiat_secp384r1_uint1 x1635;
    uint32_t x1636;
    fiat_secp384r1_uint1 x1637;
    uint32_t x1638;
    fiat_secp384r1_uint1 x1639;
    uint32_t x1640;
    fiat_secp384r1_uint1 x1641;
    uint32_t x1642;
    fiat_secp384r1_uint1 x1643;
    uint32_t x1644;
    fiat_secp384r1_uint1 x1645;
    uint32_t x1646;
    fiat_secp384r1_uint1 x1647;
    uint32_t x1648;
    fiat_secp384r1_uint1 x1649;
    uint32_t x1650;
    fiat_secp384r1_uint1 x1651;
    uint32_t x1652;
    fiat_secp384r1_uint1 x1653;
    uint32_t x1654;
    fiat_secp384r1_uint1 x1655;
    uint32_t x1656;
    uint32_t x1657;
    uint32_t x1658;
    uint32_t x1659;
    uint32_t x1660;
    uint32_t x1661;
    uint32_t x1662;
    uint32_t x1663;
    uint32_t x1664;
    uint32_t x1665;
    uint32_t x1666;
    uint32_t x1667;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[8]);
    x9 = (arg1[9]);
    x10 = (arg1[10]);
    x11 = (arg1[11]);
    x12 = (arg1[0]);
    fiat_secp384r1_mulx_u32(&x13, &x14, x12, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x15, &x16, x12, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x17, &x18, x12, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x19, &x20, x12, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x21, &x22, x12, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x23, &x24, x12, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x25, &x26, x12, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x27, &x28, x12, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x29, &x30, x12, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x31, &x32, x12, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x33, &x34, x12, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x35, &x36, x12, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x37, &x38, 0x0, x36, x33);
    fiat_secp384r1_addcarryx_u32(&x39, &x40, x38, x34, x31);
    fiat_secp384r1_addcarryx_u32(&x41, &x42, x40, x32, x29);
    fiat_secp384r1_addcarryx_u32(&x43, &x44, x42, x30, x27);
    fiat_secp384r1_addcarryx_u32(&x45, &x46, x44, x28, x25);
    fiat_secp384r1_addcarryx_u32(&x47, &x48, x46, x26, x23);
    fiat_secp384r1_addcarryx_u32(&x49, &x50, x48, x24, x21);
    fiat_secp384r1_addcarryx_u32(&x51, &x52, x50, x22, x19);
    fiat_secp384r1_addcarryx_u32(&x53, &x54, x52, x20, x17);
    fiat_secp384r1_addcarryx_u32(&x55, &x56, x54, x18, x15);
    fiat_secp384r1_addcarryx_u32(&x57, &x58, x56, x16, x13);
    x59 = (x58 + x14);
    fiat_secp384r1_mulx_u32(&x60, &x61, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x62, &x63, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x64, &x65, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x66, &x67, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x68, &x69, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x70, &x71, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x72, &x73, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x74, &x75, x35, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x76, &x77, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x78, &x79, x35, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x80, &x81, 0x0, x77, x74);
    fiat_secp384r1_addcarryx_u32(&x82, &x83, x81, x75, x72);
    fiat_secp384r1_addcarryx_u32(&x84, &x85, x83, x73, x70);
    fiat_secp384r1_addcarryx_u32(&x86, &x87, x85, x71, x68);
    fiat_secp384r1_addcarryx_u32(&x88, &x89, x87, x69, x66);
    fiat_secp384r1_addcarryx_u32(&x90, &x91, x89, x67, x64);
    fiat_secp384r1_addcarryx_u32(&x92, &x93, x91, x65, x62);
    fiat_secp384r1_addcarryx_u32(&x94, &x95, x93, x63, x60);
    x96 = (x95 + x61);
    fiat_secp384r1_addcarryx_u32(&x97, &x98, 0x0, x35, x78);
    fiat_secp384r1_addcarryx_u32(&x99, &x100, x98, x37, x79);
    fiat_secp384r1_addcarryx_u32(&x101, &x102, x100, x39, 0x0);
    fiat_secp384r1_addcarryx_u32(&x103, &x104, x102, x41, x76);
    fiat_secp384r1_addcarryx_u32(&x105, &x106, x104, x43, x80);
    fiat_secp384r1_addcarryx_u32(&x107, &x108, x106, x45, x82);
    fiat_secp384r1_addcarryx_u32(&x109, &x110, x108, x47, x84);
    fiat_secp384r1_addcarryx_u32(&x111, &x112, x110, x49, x86);
    fiat_secp384r1_addcarryx_u32(&x113, &x114, x112, x51, x88);
    fiat_secp384r1_addcarryx_u32(&x115, &x116, x114, x53, x90);
    fiat_secp384r1_addcarryx_u32(&x117, &x118, x116, x55, x92);
    fiat_secp384r1_addcarryx_u32(&x119, &x120, x118, x57, x94);
    fiat_secp384r1_addcarryx_u32(&x121, &x122, x120, x59, x96);
    fiat_secp384r1_mulx_u32(&x123, &x124, x1, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x125, &x126, x1, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x127, &x128, x1, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x129, &x130, x1, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x131, &x132, x1, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x133, &x134, x1, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x135, &x136, x1, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x137, &x138, x1, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x139, &x140, x1, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x141, &x142, x1, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x143, &x144, x1, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x145, &x146, x1, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x147, &x148, 0x0, x146, x143);
    fiat_secp384r1_addcarryx_u32(&x149, &x150, x148, x144, x141);
    fiat_secp384r1_addcarryx_u32(&x151, &x152, x150, x142, x139);
    fiat_secp384r1_addcarryx_u32(&x153, &x154, x152, x140, x137);
    fiat_secp384r1_addcarryx_u32(&x155, &x156, x154, x138, x135);
    fiat_secp384r1_addcarryx_u32(&x157, &x158, x156, x136, x133);
    fiat_secp384r1_addcarryx_u32(&x159, &x160, x158, x134, x131);
    fiat_secp384r1_addcarryx_u32(&x161, &x162, x160, x132, x129);
    fiat_secp384r1_addcarryx_u32(&x163, &x164, x162, x130, x127);
    fiat_secp384r1_addcarryx_u32(&x165, &x166, x164, x128, x125);
    fiat_secp384r1_addcarryx_u32(&x167, &x168, x166, x126, x123);
    x169 = (x168 + x124);
    fiat_secp384r1_addcarryx_u32(&x170, &x171, 0x0, x99, x145);
    fiat_secp384r1_addcarryx_u32(&x172, &x173, x171, x101, x147);
    fiat_secp384r1_addcarryx_u32(&x174, &x175, x173, x103, x149);
    fiat_secp384r1_addcarryx_u32(&x176, &x177, x175, x105, x151);
    fiat_secp384r1_addcarryx_u32(&x178, &x179, x177, x107, x153);
    fiat_secp384r1_addcarryx_u32(&x180, &x181, x179, x109, x155);
    fiat_secp384r1_addcarryx_u32(&x182, &x183, x181, x111, x157);
    fiat_secp384r1_addcarryx_u32(&x184, &x185, x183, x113, x159);
    fiat_secp384r1_addcarryx_u32(&x186, &x187, x185, x115, x161);
    fiat_secp384r1_addcarryx_u32(&x188, &x189, x187, x117, x163);
    fiat_secp384r1_addcarryx_u32(&x190, &x191, x189, x119, x165);
    fiat_secp384r1_addcarryx_u32(&x192, &x193, x191, x121, x167);
    fiat_secp384r1_addcarryx_u32(&x194, &x195, x193, x122, x169);
    fiat_secp384r1_mulx_u32(&x196, &x197, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x198, &x199, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x200, &x201, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x202, &x203, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x204, &x205, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x206, &x207, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x208, &x209, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x210, &x211, x170, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x212, &x213, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x214, &x215, x170, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x216, &x217, 0x0, x213, x210);
    fiat_secp384r1_addcarryx_u32(&x218, &x219, x217, x211, x208);
    fiat_secp384r1_addcarryx_u32(&x220, &x221, x219, x209, x206);
    fiat_secp384r1_addcarryx_u32(&x222, &x223, x221, x207, x204);
    fiat_secp384r1_addcarryx_u32(&x224, &x225, x223, x205, x202);
    fiat_secp384r1_addcarryx_u32(&x226, &x227, x225, x203, x200);
    fiat_secp384r1_addcarryx_u32(&x228, &x229, x227, x201, x198);
    fiat_secp384r1_addcarryx_u32(&x230, &x231, x229, x199, x196);
    x232 = (x231 + x197);
    fiat_secp384r1_addcarryx_u32(&x233, &x234, 0x0, x170, x214);
    fiat_secp384r1_addcarryx_u32(&x235, &x236, x234, x172, x215);
    fiat_secp384r1_addcarryx_u32(&x237, &x238, x236, x174, 0x0);
    fiat_secp384r1_addcarryx_u32(&x239, &x240, x238, x176, x212);
    fiat_secp384r1_addcarryx_u32(&x241, &x242, x240, x178, x216);
    fiat_secp384r1_addcarryx_u32(&x243, &x244, x242, x180, x218);
    fiat_secp384r1_addcarryx_u32(&x245, &x246, x244, x182, x220);
    fiat_secp384r1_addcarryx_u32(&x247, &x248, x246, x184, x222);
    fiat_secp384r1_addcarryx_u32(&x249, &x250, x248, x186, x224);
    fiat_secp384r1_addcarryx_u32(&x251, &x252, x250, x188, x226);
    fiat_secp384r1_addcarryx_u32(&x253, &x254, x252, x190, x228);
    fiat_secp384r1_addcarryx_u32(&x255, &x256, x254, x192, x230);
    fiat_secp384r1_addcarryx_u32(&x257, &x258, x256, x194, x232);
    x259 = ((uint32_t)x258 + x195);
    fiat_secp384r1_mulx_u32(&x260, &x261, x2, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x262, &x263, x2, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x264, &x265, x2, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x266, &x267, x2, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x268, &x269, x2, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x270, &x271, x2, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x272, &x273, x2, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x274, &x275, x2, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x276, &x277, x2, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x278, &x279, x2, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x280, &x281, x2, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x282, &x283, x2, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x284, &x285, 0x0, x283, x280);
    fiat_secp384r1_addcarryx_u32(&x286, &x287, x285, x281, x278);
    fiat_secp384r1_addcarryx_u32(&x288, &x289, x287, x279, x276);
    fiat_secp384r1_addcarryx_u32(&x290, &x291, x289, x277, x274);
    fiat_secp384r1_addcarryx_u32(&x292, &x293, x291, x275, x272);
    fiat_secp384r1_addcarryx_u32(&x294, &x295, x293, x273, x270);
    fiat_secp384r1_addcarryx_u32(&x296, &x297, x295, x271, x268);
    fiat_secp384r1_addcarryx_u32(&x298, &x299, x297, x269, x266);
    fiat_secp384r1_addcarryx_u32(&x300, &x301, x299, x267, x264);
    fiat_secp384r1_addcarryx_u32(&x302, &x303, x301, x265, x262);
    fiat_secp384r1_addcarryx_u32(&x304, &x305, x303, x263, x260);
    x306 = (x305 + x261);
    fiat_secp384r1_addcarryx_u32(&x307, &x308, 0x0, x235, x282);
    fiat_secp384r1_addcarryx_u32(&x309, &x310, x308, x237, x284);
    fiat_secp384r1_addcarryx_u32(&x311, &x312, x310, x239, x286);
    fiat_secp384r1_addcarryx_u32(&x313, &x314, x312, x241, x288);
    fiat_secp384r1_addcarryx_u32(&x315, &x316, x314, x243, x290);
    fiat_secp384r1_addcarryx_u32(&x317, &x318, x316, x245, x292);
    fiat_secp384r1_addcarryx_u32(&x319, &x320, x318, x247, x294);
    fiat_secp384r1_addcarryx_u32(&x321, &x322, x320, x249, x296);
    fiat_secp384r1_addcarryx_u32(&x323, &x324, x322, x251, x298);
    fiat_secp384r1_addcarryx_u32(&x325, &x326, x324, x253, x300);
    fiat_secp384r1_addcarryx_u32(&x327, &x328, x326, x255, x302);
    fiat_secp384r1_addcarryx_u32(&x329, &x330, x328, x257, x304);
    fiat_secp384r1_addcarryx_u32(&x331, &x332, x330, x259, x306);
    fiat_secp384r1_mulx_u32(&x333, &x334, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x335, &x336, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x337, &x338, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x339, &x340, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x341, &x342, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x343, &x344, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x345, &x346, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x347, &x348, x307, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x349, &x350, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x351, &x352, x307, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x353, &x354, 0x0, x350, x347);
    fiat_secp384r1_addcarryx_u32(&x355, &x356, x354, x348, x345);
    fiat_secp384r1_addcarryx_u32(&x357, &x358, x356, x346, x343);
    fiat_secp384r1_addcarryx_u32(&x359, &x360, x358, x344, x341);
    fiat_secp384r1_addcarryx_u32(&x361, &x362, x360, x342, x339);
    fiat_secp384r1_addcarryx_u32(&x363, &x364, x362, x340, x337);
    fiat_secp384r1_addcarryx_u32(&x365, &x366, x364, x338, x335);
    fiat_secp384r1_addcarryx_u32(&x367, &x368, x366, x336, x333);
    x369 = (x368 + x334);
    fiat_secp384r1_addcarryx_u32(&x370, &x371, 0x0, x307, x351);
    fiat_secp384r1_addcarryx_u32(&x372, &x373, x371, x309, x352);
    fiat_secp384r1_addcarryx_u32(&x374, &x375, x373, x311, 0x0);
    fiat_secp384r1_addcarryx_u32(&x376, &x377, x375, x313, x349);
    fiat_secp384r1_addcarryx_u32(&x378, &x379, x377, x315, x353);
    fiat_secp384r1_addcarryx_u32(&x380, &x381, x379, x317, x355);
    fiat_secp384r1_addcarryx_u32(&x382, &x383, x381, x319, x357);
    fiat_secp384r1_addcarryx_u32(&x384, &x385, x383, x321, x359);
    fiat_secp384r1_addcarryx_u32(&x386, &x387, x385, x323, x361);
    fiat_secp384r1_addcarryx_u32(&x388, &x389, x387, x325, x363);
    fiat_secp384r1_addcarryx_u32(&x390, &x391, x389, x327, x365);
    fiat_secp384r1_addcarryx_u32(&x392, &x393, x391, x329, x367);
    fiat_secp384r1_addcarryx_u32(&x394, &x395, x393, x331, x369);
    x396 = ((uint32_t)x395 + x332);
    fiat_secp384r1_mulx_u32(&x397, &x398, x3, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x399, &x400, x3, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x401, &x402, x3, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x403, &x404, x3, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x405, &x406, x3, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x407, &x408, x3, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x409, &x410, x3, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x411, &x412, x3, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x413, &x414, x3, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x415, &x416, x3, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x417, &x418, x3, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x419, &x420, x3, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x421, &x422, 0x0, x420, x417);
    fiat_secp384r1_addcarryx_u32(&x423, &x424, x422, x418, x415);
    fiat_secp384r1_addcarryx_u32(&x425, &x426, x424, x416, x413);
    fiat_secp384r1_addcarryx_u32(&x427, &x428, x426, x414, x411);
    fiat_secp384r1_addcarryx_u32(&x429, &x430, x428, x412, x409);
    fiat_secp384r1_addcarryx_u32(&x431, &x432, x430, x410, x407);
    fiat_secp384r1_addcarryx_u32(&x433, &x434, x432, x408, x405);
    fiat_secp384r1_addcarryx_u32(&x435, &x436, x434, x406, x403);
    fiat_secp384r1_addcarryx_u32(&x437, &x438, x436, x404, x401);
    fiat_secp384r1_addcarryx_u32(&x439, &x440, x438, x402, x399);
    fiat_secp384r1_addcarryx_u32(&x441, &x442, x440, x400, x397);
    x443 = (x442 + x398);
    fiat_secp384r1_addcarryx_u32(&x444, &x445, 0x0, x372, x419);
    fiat_secp384r1_addcarryx_u32(&x446, &x447, x445, x374, x421);
    fiat_secp384r1_addcarryx_u32(&x448, &x449, x447, x376, x423);
    fiat_secp384r1_addcarryx_u32(&x450, &x451, x449, x378, x425);
    fiat_secp384r1_addcarryx_u32(&x452, &x453, x451, x380, x427);
    fiat_secp384r1_addcarryx_u32(&x454, &x455, x453, x382, x429);
    fiat_secp384r1_addcarryx_u32(&x456, &x457, x455, x384, x431);
    fiat_secp384r1_addcarryx_u32(&x458, &x459, x457, x386, x433);
    fiat_secp384r1_addcarryx_u32(&x460, &x461, x459, x388, x435);
    fiat_secp384r1_addcarryx_u32(&x462, &x463, x461, x390, x437);
    fiat_secp384r1_addcarryx_u32(&x464, &x465, x463, x392, x439);
    fiat_secp384r1_addcarryx_u32(&x466, &x467, x465, x394, x441);
    fiat_secp384r1_addcarryx_u32(&x468, &x469, x467, x396, x443);
    fiat_secp384r1_mulx_u32(&x470, &x471, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x472, &x473, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x474, &x475, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x476, &x477, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x478, &x479, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x480, &x481, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x482, &x483, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x484, &x485, x444, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x486, &x487, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x488, &x489, x444, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x490, &x491, 0x0, x487, x484);
    fiat_secp384r1_addcarryx_u32(&x492, &x493, x491, x485, x482);
    fiat_secp384r1_addcarryx_u32(&x494, &x495, x493, x483, x480);
    fiat_secp384r1_addcarryx_u32(&x496, &x497, x495, x481, x478);
    fiat_secp384r1_addcarryx_u32(&x498, &x499, x497, x479, x476);
    fiat_secp384r1_addcarryx_u32(&x500, &x501, x499, x477, x474);
    fiat_secp384r1_addcarryx_u32(&x502, &x503, x501, x475, x472);
    fiat_secp384r1_addcarryx_u32(&x504, &x505, x503, x473, x470);
    x506 = (x505 + x471);
    fiat_secp384r1_addcarryx_u32(&x507, &x508, 0x0, x444, x488);
    fiat_secp384r1_addcarryx_u32(&x509, &x510, x508, x446, x489);
    fiat_secp384r1_addcarryx_u32(&x511, &x512, x510, x448, 0x0);
    fiat_secp384r1_addcarryx_u32(&x513, &x514, x512, x450, x486);
    fiat_secp384r1_addcarryx_u32(&x515, &x516, x514, x452, x490);
    fiat_secp384r1_addcarryx_u32(&x517, &x518, x516, x454, x492);
    fiat_secp384r1_addcarryx_u32(&x519, &x520, x518, x456, x494);
    fiat_secp384r1_addcarryx_u32(&x521, &x522, x520, x458, x496);
    fiat_secp384r1_addcarryx_u32(&x523, &x524, x522, x460, x498);
    fiat_secp384r1_addcarryx_u32(&x525, &x526, x524, x462, x500);
    fiat_secp384r1_addcarryx_u32(&x527, &x528, x526, x464, x502);
    fiat_secp384r1_addcarryx_u32(&x529, &x530, x528, x466, x504);
    fiat_secp384r1_addcarryx_u32(&x531, &x532, x530, x468, x506);
    x533 = ((uint32_t)x532 + x469);
    fiat_secp384r1_mulx_u32(&x534, &x535, x4, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x536, &x537, x4, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x538, &x539, x4, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x540, &x541, x4, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x542, &x543, x4, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x544, &x545, x4, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x546, &x547, x4, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x548, &x549, x4, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x550, &x551, x4, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x552, &x553, x4, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x554, &x555, x4, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x556, &x557, x4, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x558, &x559, 0x0, x557, x554);
    fiat_secp384r1_addcarryx_u32(&x560, &x561, x559, x555, x552);
    fiat_secp384r1_addcarryx_u32(&x562, &x563, x561, x553, x550);
    fiat_secp384r1_addcarryx_u32(&x564, &x565, x563, x551, x548);
    fiat_secp384r1_addcarryx_u32(&x566, &x567, x565, x549, x546);
    fiat_secp384r1_addcarryx_u32(&x568, &x569, x567, x547, x544);
    fiat_secp384r1_addcarryx_u32(&x570, &x571, x569, x545, x542);
    fiat_secp384r1_addcarryx_u32(&x572, &x573, x571, x543, x540);
    fiat_secp384r1_addcarryx_u32(&x574, &x575, x573, x541, x538);
    fiat_secp384r1_addcarryx_u32(&x576, &x577, x575, x539, x536);
    fiat_secp384r1_addcarryx_u32(&x578, &x579, x577, x537, x534);
    x580 = (x579 + x535);
    fiat_secp384r1_addcarryx_u32(&x581, &x582, 0x0, x509, x556);
    fiat_secp384r1_addcarryx_u32(&x583, &x584, x582, x511, x558);
    fiat_secp384r1_addcarryx_u32(&x585, &x586, x584, x513, x560);
    fiat_secp384r1_addcarryx_u32(&x587, &x588, x586, x515, x562);
    fiat_secp384r1_addcarryx_u32(&x589, &x590, x588, x517, x564);
    fiat_secp384r1_addcarryx_u32(&x591, &x592, x590, x519, x566);
    fiat_secp384r1_addcarryx_u32(&x593, &x594, x592, x521, x568);
    fiat_secp384r1_addcarryx_u32(&x595, &x596, x594, x523, x570);
    fiat_secp384r1_addcarryx_u32(&x597, &x598, x596, x525, x572);
    fiat_secp384r1_addcarryx_u32(&x599, &x600, x598, x527, x574);
    fiat_secp384r1_addcarryx_u32(&x601, &x602, x600, x529, x576);
    fiat_secp384r1_addcarryx_u32(&x603, &x604, x602, x531, x578);
    fiat_secp384r1_addcarryx_u32(&x605, &x606, x604, x533, x580);
    fiat_secp384r1_mulx_u32(&x607, &x608, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x609, &x610, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x611, &x612, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x613, &x614, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x615, &x616, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x617, &x618, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x619, &x620, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x621, &x622, x581, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x623, &x624, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x625, &x626, x581, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x627, &x628, 0x0, x624, x621);
    fiat_secp384r1_addcarryx_u32(&x629, &x630, x628, x622, x619);
    fiat_secp384r1_addcarryx_u32(&x631, &x632, x630, x620, x617);
    fiat_secp384r1_addcarryx_u32(&x633, &x634, x632, x618, x615);
    fiat_secp384r1_addcarryx_u32(&x635, &x636, x634, x616, x613);
    fiat_secp384r1_addcarryx_u32(&x637, &x638, x636, x614, x611);
    fiat_secp384r1_addcarryx_u32(&x639, &x640, x638, x612, x609);
    fiat_secp384r1_addcarryx_u32(&x641, &x642, x640, x610, x607);
    x643 = (x642 + x608);
    fiat_secp384r1_addcarryx_u32(&x644, &x645, 0x0, x581, x625);
    fiat_secp384r1_addcarryx_u32(&x646, &x647, x645, x583, x626);
    fiat_secp384r1_addcarryx_u32(&x648, &x649, x647, x585, 0x0);
    fiat_secp384r1_addcarryx_u32(&x650, &x651, x649, x587, x623);
    fiat_secp384r1_addcarryx_u32(&x652, &x653, x651, x589, x627);
    fiat_secp384r1_addcarryx_u32(&x654, &x655, x653, x591, x629);
    fiat_secp384r1_addcarryx_u32(&x656, &x657, x655, x593, x631);
    fiat_secp384r1_addcarryx_u32(&x658, &x659, x657, x595, x633);
    fiat_secp384r1_addcarryx_u32(&x660, &x661, x659, x597, x635);
    fiat_secp384r1_addcarryx_u32(&x662, &x663, x661, x599, x637);
    fiat_secp384r1_addcarryx_u32(&x664, &x665, x663, x601, x639);
    fiat_secp384r1_addcarryx_u32(&x666, &x667, x665, x603, x641);
    fiat_secp384r1_addcarryx_u32(&x668, &x669, x667, x605, x643);
    x670 = ((uint32_t)x669 + x606);
    fiat_secp384r1_mulx_u32(&x671, &x672, x5, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x673, &x674, x5, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x675, &x676, x5, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x677, &x678, x5, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x679, &x680, x5, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x681, &x682, x5, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x683, &x684, x5, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x685, &x686, x5, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x687, &x688, x5, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x689, &x690, x5, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x691, &x692, x5, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x693, &x694, x5, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x695, &x696, 0x0, x694, x691);
    fiat_secp384r1_addcarryx_u32(&x697, &x698, x696, x692, x689);
    fiat_secp384r1_addcarryx_u32(&x699, &x700, x698, x690, x687);
    fiat_secp384r1_addcarryx_u32(&x701, &x702, x700, x688, x685);
    fiat_secp384r1_addcarryx_u32(&x703, &x704, x702, x686, x683);
    fiat_secp384r1_addcarryx_u32(&x705, &x706, x704, x684, x681);
    fiat_secp384r1_addcarryx_u32(&x707, &x708, x706, x682, x679);
    fiat_secp384r1_addcarryx_u32(&x709, &x710, x708, x680, x677);
    fiat_secp384r1_addcarryx_u32(&x711, &x712, x710, x678, x675);
    fiat_secp384r1_addcarryx_u32(&x713, &x714, x712, x676, x673);
    fiat_secp384r1_addcarryx_u32(&x715, &x716, x714, x674, x671);
    x717 = (x716 + x672);
    fiat_secp384r1_addcarryx_u32(&x718, &x719, 0x0, x646, x693);
    fiat_secp384r1_addcarryx_u32(&x720, &x721, x719, x648, x695);
    fiat_secp384r1_addcarryx_u32(&x722, &x723, x721, x650, x697);
    fiat_secp384r1_addcarryx_u32(&x724, &x725, x723, x652, x699);
    fiat_secp384r1_addcarryx_u32(&x726, &x727, x725, x654, x701);
    fiat_secp384r1_addcarryx_u32(&x728, &x729, x727, x656, x703);
    fiat_secp384r1_addcarryx_u32(&x730, &x731, x729, x658, x705);
    fiat_secp384r1_addcarryx_u32(&x732, &x733, x731, x660, x707);
    fiat_secp384r1_addcarryx_u32(&x734, &x735, x733, x662, x709);
    fiat_secp384r1_addcarryx_u32(&x736, &x737, x735, x664, x711);
    fiat_secp384r1_addcarryx_u32(&x738, &x739, x737, x666, x713);
    fiat_secp384r1_addcarryx_u32(&x740, &x741, x739, x668, x715);
    fiat_secp384r1_addcarryx_u32(&x742, &x743, x741, x670, x717);
    fiat_secp384r1_mulx_u32(&x744, &x745, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x746, &x747, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x748, &x749, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x750, &x751, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x752, &x753, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x754, &x755, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x756, &x757, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x758, &x759, x718, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x760, &x761, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x762, &x763, x718, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x764, &x765, 0x0, x761, x758);
    fiat_secp384r1_addcarryx_u32(&x766, &x767, x765, x759, x756);
    fiat_secp384r1_addcarryx_u32(&x768, &x769, x767, x757, x754);
    fiat_secp384r1_addcarryx_u32(&x770, &x771, x769, x755, x752);
    fiat_secp384r1_addcarryx_u32(&x772, &x773, x771, x753, x750);
    fiat_secp384r1_addcarryx_u32(&x774, &x775, x773, x751, x748);
    fiat_secp384r1_addcarryx_u32(&x776, &x777, x775, x749, x746);
    fiat_secp384r1_addcarryx_u32(&x778, &x779, x777, x747, x744);
    x780 = (x779 + x745);
    fiat_secp384r1_addcarryx_u32(&x781, &x782, 0x0, x718, x762);
    fiat_secp384r1_addcarryx_u32(&x783, &x784, x782, x720, x763);
    fiat_secp384r1_addcarryx_u32(&x785, &x786, x784, x722, 0x0);
    fiat_secp384r1_addcarryx_u32(&x787, &x788, x786, x724, x760);
    fiat_secp384r1_addcarryx_u32(&x789, &x790, x788, x726, x764);
    fiat_secp384r1_addcarryx_u32(&x791, &x792, x790, x728, x766);
    fiat_secp384r1_addcarryx_u32(&x793, &x794, x792, x730, x768);
    fiat_secp384r1_addcarryx_u32(&x795, &x796, x794, x732, x770);
    fiat_secp384r1_addcarryx_u32(&x797, &x798, x796, x734, x772);
    fiat_secp384r1_addcarryx_u32(&x799, &x800, x798, x736, x774);
    fiat_secp384r1_addcarryx_u32(&x801, &x802, x800, x738, x776);
    fiat_secp384r1_addcarryx_u32(&x803, &x804, x802, x740, x778);
    fiat_secp384r1_addcarryx_u32(&x805, &x806, x804, x742, x780);
    x807 = ((uint32_t)x806 + x743);
    fiat_secp384r1_mulx_u32(&x808, &x809, x6, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x810, &x811, x6, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x812, &x813, x6, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x814, &x815, x6, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x816, &x817, x6, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x818, &x819, x6, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x820, &x821, x6, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x822, &x823, x6, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x824, &x825, x6, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x826, &x827, x6, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x828, &x829, x6, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x830, &x831, x6, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x832, &x833, 0x0, x831, x828);
    fiat_secp384r1_addcarryx_u32(&x834, &x835, x833, x829, x826);
    fiat_secp384r1_addcarryx_u32(&x836, &x837, x835, x827, x824);
    fiat_secp384r1_addcarryx_u32(&x838, &x839, x837, x825, x822);
    fiat_secp384r1_addcarryx_u32(&x840, &x841, x839, x823, x820);
    fiat_secp384r1_addcarryx_u32(&x842, &x843, x841, x821, x818);
    fiat_secp384r1_addcarryx_u32(&x844, &x845, x843, x819, x816);
    fiat_secp384r1_addcarryx_u32(&x846, &x847, x845, x817, x814);
    fiat_secp384r1_addcarryx_u32(&x848, &x849, x847, x815, x812);
    fiat_secp384r1_addcarryx_u32(&x850, &x851, x849, x813, x810);
    fiat_secp384r1_addcarryx_u32(&x852, &x853, x851, x811, x808);
    x854 = (x853 + x809);
    fiat_secp384r1_addcarryx_u32(&x855, &x856, 0x0, x783, x830);
    fiat_secp384r1_addcarryx_u32(&x857, &x858, x856, x785, x832);
    fiat_secp384r1_addcarryx_u32(&x859, &x860, x858, x787, x834);
    fiat_secp384r1_addcarryx_u32(&x861, &x862, x860, x789, x836);
    fiat_secp384r1_addcarryx_u32(&x863, &x864, x862, x791, x838);
    fiat_secp384r1_addcarryx_u32(&x865, &x866, x864, x793, x840);
    fiat_secp384r1_addcarryx_u32(&x867, &x868, x866, x795, x842);
    fiat_secp384r1_addcarryx_u32(&x869, &x870, x868, x797, x844);
    fiat_secp384r1_addcarryx_u32(&x871, &x872, x870, x799, x846);
    fiat_secp384r1_addcarryx_u32(&x873, &x874, x872, x801, x848);
    fiat_secp384r1_addcarryx_u32(&x875, &x876, x874, x803, x850);
    fiat_secp384r1_addcarryx_u32(&x877, &x878, x876, x805, x852);
    fiat_secp384r1_addcarryx_u32(&x879, &x880, x878, x807, x854);
    fiat_secp384r1_mulx_u32(&x881, &x882, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x883, &x884, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x885, &x886, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x887, &x888, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x889, &x890, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x891, &x892, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x893, &x894, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x895, &x896, x855, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x897, &x898, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x899, &x900, x855, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x901, &x902, 0x0, x898, x895);
    fiat_secp384r1_addcarryx_u32(&x903, &x904, x902, x896, x893);
    fiat_secp384r1_addcarryx_u32(&x905, &x906, x904, x894, x891);
    fiat_secp384r1_addcarryx_u32(&x907, &x908, x906, x892, x889);
    fiat_secp384r1_addcarryx_u32(&x909, &x910, x908, x890, x887);
    fiat_secp384r1_addcarryx_u32(&x911, &x912, x910, x888, x885);
    fiat_secp384r1_addcarryx_u32(&x913, &x914, x912, x886, x883);
    fiat_secp384r1_addcarryx_u32(&x915, &x916, x914, x884, x881);
    x917 = (x916 + x882);
    fiat_secp384r1_addcarryx_u32(&x918, &x919, 0x0, x855, x899);
    fiat_secp384r1_addcarryx_u32(&x920, &x921, x919, x857, x900);
    fiat_secp384r1_addcarryx_u32(&x922, &x923, x921, x859, 0x0);
    fiat_secp384r1_addcarryx_u32(&x924, &x925, x923, x861, x897);
    fiat_secp384r1_addcarryx_u32(&x926, &x927, x925, x863, x901);
    fiat_secp384r1_addcarryx_u32(&x928, &x929, x927, x865, x903);
    fiat_secp384r1_addcarryx_u32(&x930, &x931, x929, x867, x905);
    fiat_secp384r1_addcarryx_u32(&x932, &x933, x931, x869, x907);
    fiat_secp384r1_addcarryx_u32(&x934, &x935, x933, x871, x909);
    fiat_secp384r1_addcarryx_u32(&x936, &x937, x935, x873, x911);
    fiat_secp384r1_addcarryx_u32(&x938, &x939, x937, x875, x913);
    fiat_secp384r1_addcarryx_u32(&x940, &x941, x939, x877, x915);
    fiat_secp384r1_addcarryx_u32(&x942, &x943, x941, x879, x917);
    x944 = ((uint32_t)x943 + x880);
    fiat_secp384r1_mulx_u32(&x945, &x946, x7, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x947, &x948, x7, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x949, &x950, x7, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x951, &x952, x7, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x953, &x954, x7, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x955, &x956, x7, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x957, &x958, x7, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x959, &x960, x7, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x961, &x962, x7, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x963, &x964, x7, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x965, &x966, x7, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x967, &x968, x7, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x969, &x970, 0x0, x968, x965);
    fiat_secp384r1_addcarryx_u32(&x971, &x972, x970, x966, x963);
    fiat_secp384r1_addcarryx_u32(&x973, &x974, x972, x964, x961);
    fiat_secp384r1_addcarryx_u32(&x975, &x976, x974, x962, x959);
    fiat_secp384r1_addcarryx_u32(&x977, &x978, x976, x960, x957);
    fiat_secp384r1_addcarryx_u32(&x979, &x980, x978, x958, x955);
    fiat_secp384r1_addcarryx_u32(&x981, &x982, x980, x956, x953);
    fiat_secp384r1_addcarryx_u32(&x983, &x984, x982, x954, x951);
    fiat_secp384r1_addcarryx_u32(&x985, &x986, x984, x952, x949);
    fiat_secp384r1_addcarryx_u32(&x987, &x988, x986, x950, x947);
    fiat_secp384r1_addcarryx_u32(&x989, &x990, x988, x948, x945);
    x991 = (x990 + x946);
    fiat_secp384r1_addcarryx_u32(&x992, &x993, 0x0, x920, x967);
    fiat_secp384r1_addcarryx_u32(&x994, &x995, x993, x922, x969);
    fiat_secp384r1_addcarryx_u32(&x996, &x997, x995, x924, x971);
    fiat_secp384r1_addcarryx_u32(&x998, &x999, x997, x926, x973);
    fiat_secp384r1_addcarryx_u32(&x1000, &x1001, x999, x928, x975);
    fiat_secp384r1_addcarryx_u32(&x1002, &x1003, x1001, x930, x977);
    fiat_secp384r1_addcarryx_u32(&x1004, &x1005, x1003, x932, x979);
    fiat_secp384r1_addcarryx_u32(&x1006, &x1007, x1005, x934, x981);
    fiat_secp384r1_addcarryx_u32(&x1008, &x1009, x1007, x936, x983);
    fiat_secp384r1_addcarryx_u32(&x1010, &x1011, x1009, x938, x985);
    fiat_secp384r1_addcarryx_u32(&x1012, &x1013, x1011, x940, x987);
    fiat_secp384r1_addcarryx_u32(&x1014, &x1015, x1013, x942, x989);
    fiat_secp384r1_addcarryx_u32(&x1016, &x1017, x1015, x944, x991);
    fiat_secp384r1_mulx_u32(&x1018, &x1019, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1020, &x1021, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1022, &x1023, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1024, &x1025, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1026, &x1027, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1028, &x1029, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1030, &x1031, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1032, &x1033, x992, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1034, &x1035, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1036, &x1037, x992, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1038, &x1039, 0x0, x1035, x1032);
    fiat_secp384r1_addcarryx_u32(&x1040, &x1041, x1039, x1033, x1030);
    fiat_secp384r1_addcarryx_u32(&x1042, &x1043, x1041, x1031, x1028);
    fiat_secp384r1_addcarryx_u32(&x1044, &x1045, x1043, x1029, x1026);
    fiat_secp384r1_addcarryx_u32(&x1046, &x1047, x1045, x1027, x1024);
    fiat_secp384r1_addcarryx_u32(&x1048, &x1049, x1047, x1025, x1022);
    fiat_secp384r1_addcarryx_u32(&x1050, &x1051, x1049, x1023, x1020);
    fiat_secp384r1_addcarryx_u32(&x1052, &x1053, x1051, x1021, x1018);
    x1054 = (x1053 + x1019);
    fiat_secp384r1_addcarryx_u32(&x1055, &x1056, 0x0, x992, x1036);
    fiat_secp384r1_addcarryx_u32(&x1057, &x1058, x1056, x994, x1037);
    fiat_secp384r1_addcarryx_u32(&x1059, &x1060, x1058, x996, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1061, &x1062, x1060, x998, x1034);
    fiat_secp384r1_addcarryx_u32(&x1063, &x1064, x1062, x1000, x1038);
    fiat_secp384r1_addcarryx_u32(&x1065, &x1066, x1064, x1002, x1040);
    fiat_secp384r1_addcarryx_u32(&x1067, &x1068, x1066, x1004, x1042);
    fiat_secp384r1_addcarryx_u32(&x1069, &x1070, x1068, x1006, x1044);
    fiat_secp384r1_addcarryx_u32(&x1071, &x1072, x1070, x1008, x1046);
    fiat_secp384r1_addcarryx_u32(&x1073, &x1074, x1072, x1010, x1048);
    fiat_secp384r1_addcarryx_u32(&x1075, &x1076, x1074, x1012, x1050);
    fiat_secp384r1_addcarryx_u32(&x1077, &x1078, x1076, x1014, x1052);
    fiat_secp384r1_addcarryx_u32(&x1079, &x1080, x1078, x1016, x1054);
    x1081 = ((uint32_t)x1080 + x1017);
    fiat_secp384r1_mulx_u32(&x1082, &x1083, x8, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x1084, &x1085, x8, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x1086, &x1087, x8, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x1088, &x1089, x8, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x1090, &x1091, x8, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x1092, &x1093, x8, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x1094, &x1095, x8, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x1096, &x1097, x8, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x1098, &x1099, x8, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x1100, &x1101, x8, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x1102, &x1103, x8, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x1104, &x1105, x8, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x1106, &x1107, 0x0, x1105, x1102);
    fiat_secp384r1_addcarryx_u32(&x1108, &x1109, x1107, x1103, x1100);
    fiat_secp384r1_addcarryx_u32(&x1110, &x1111, x1109, x1101, x1098);
    fiat_secp384r1_addcarryx_u32(&x1112, &x1113, x1111, x1099, x1096);
    fiat_secp384r1_addcarryx_u32(&x1114, &x1115, x1113, x1097, x1094);
    fiat_secp384r1_addcarryx_u32(&x1116, &x1117, x1115, x1095, x1092);
    fiat_secp384r1_addcarryx_u32(&x1118, &x1119, x1117, x1093, x1090);
    fiat_secp384r1_addcarryx_u32(&x1120, &x1121, x1119, x1091, x1088);
    fiat_secp384r1_addcarryx_u32(&x1122, &x1123, x1121, x1089, x1086);
    fiat_secp384r1_addcarryx_u32(&x1124, &x1125, x1123, x1087, x1084);
    fiat_secp384r1_addcarryx_u32(&x1126, &x1127, x1125, x1085, x1082);
    x1128 = (x1127 + x1083);
    fiat_secp384r1_addcarryx_u32(&x1129, &x1130, 0x0, x1057, x1104);
    fiat_secp384r1_addcarryx_u32(&x1131, &x1132, x1130, x1059, x1106);
    fiat_secp384r1_addcarryx_u32(&x1133, &x1134, x1132, x1061, x1108);
    fiat_secp384r1_addcarryx_u32(&x1135, &x1136, x1134, x1063, x1110);
    fiat_secp384r1_addcarryx_u32(&x1137, &x1138, x1136, x1065, x1112);
    fiat_secp384r1_addcarryx_u32(&x1139, &x1140, x1138, x1067, x1114);
    fiat_secp384r1_addcarryx_u32(&x1141, &x1142, x1140, x1069, x1116);
    fiat_secp384r1_addcarryx_u32(&x1143, &x1144, x1142, x1071, x1118);
    fiat_secp384r1_addcarryx_u32(&x1145, &x1146, x1144, x1073, x1120);
    fiat_secp384r1_addcarryx_u32(&x1147, &x1148, x1146, x1075, x1122);
    fiat_secp384r1_addcarryx_u32(&x1149, &x1150, x1148, x1077, x1124);
    fiat_secp384r1_addcarryx_u32(&x1151, &x1152, x1150, x1079, x1126);
    fiat_secp384r1_addcarryx_u32(&x1153, &x1154, x1152, x1081, x1128);
    fiat_secp384r1_mulx_u32(&x1155, &x1156, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1157, &x1158, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1159, &x1160, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1161, &x1162, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1163, &x1164, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1165, &x1166, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1167, &x1168, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1169, &x1170, x1129, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1171, &x1172, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1173, &x1174, x1129, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1175, &x1176, 0x0, x1172, x1169);
    fiat_secp384r1_addcarryx_u32(&x1177, &x1178, x1176, x1170, x1167);
    fiat_secp384r1_addcarryx_u32(&x1179, &x1180, x1178, x1168, x1165);
    fiat_secp384r1_addcarryx_u32(&x1181, &x1182, x1180, x1166, x1163);
    fiat_secp384r1_addcarryx_u32(&x1183, &x1184, x1182, x1164, x1161);
    fiat_secp384r1_addcarryx_u32(&x1185, &x1186, x1184, x1162, x1159);
    fiat_secp384r1_addcarryx_u32(&x1187, &x1188, x1186, x1160, x1157);
    fiat_secp384r1_addcarryx_u32(&x1189, &x1190, x1188, x1158, x1155);
    x1191 = (x1190 + x1156);
    fiat_secp384r1_addcarryx_u32(&x1192, &x1193, 0x0, x1129, x1173);
    fiat_secp384r1_addcarryx_u32(&x1194, &x1195, x1193, x1131, x1174);
    fiat_secp384r1_addcarryx_u32(&x1196, &x1197, x1195, x1133, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1198, &x1199, x1197, x1135, x1171);
    fiat_secp384r1_addcarryx_u32(&x1200, &x1201, x1199, x1137, x1175);
    fiat_secp384r1_addcarryx_u32(&x1202, &x1203, x1201, x1139, x1177);
    fiat_secp384r1_addcarryx_u32(&x1204, &x1205, x1203, x1141, x1179);
    fiat_secp384r1_addcarryx_u32(&x1206, &x1207, x1205, x1143, x1181);
    fiat_secp384r1_addcarryx_u32(&x1208, &x1209, x1207, x1145, x1183);
    fiat_secp384r1_addcarryx_u32(&x1210, &x1211, x1209, x1147, x1185);
    fiat_secp384r1_addcarryx_u32(&x1212, &x1213, x1211, x1149, x1187);
    fiat_secp384r1_addcarryx_u32(&x1214, &x1215, x1213, x1151, x1189);
    fiat_secp384r1_addcarryx_u32(&x1216, &x1217, x1215, x1153, x1191);
    x1218 = ((uint32_t)x1217 + x1154);
    fiat_secp384r1_mulx_u32(&x1219, &x1220, x9, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x1221, &x1222, x9, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x1223, &x1224, x9, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x1225, &x1226, x9, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x1227, &x1228, x9, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x1229, &x1230, x9, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x1231, &x1232, x9, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x1233, &x1234, x9, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x1235, &x1236, x9, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x1237, &x1238, x9, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x1239, &x1240, x9, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x1241, &x1242, x9, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x1243, &x1244, 0x0, x1242, x1239);
    fiat_secp384r1_addcarryx_u32(&x1245, &x1246, x1244, x1240, x1237);
    fiat_secp384r1_addcarryx_u32(&x1247, &x1248, x1246, x1238, x1235);
    fiat_secp384r1_addcarryx_u32(&x1249, &x1250, x1248, x1236, x1233);
    fiat_secp384r1_addcarryx_u32(&x1251, &x1252, x1250, x1234, x1231);
    fiat_secp384r1_addcarryx_u32(&x1253, &x1254, x1252, x1232, x1229);
    fiat_secp384r1_addcarryx_u32(&x1255, &x1256, x1254, x1230, x1227);
    fiat_secp384r1_addcarryx_u32(&x1257, &x1258, x1256, x1228, x1225);
    fiat_secp384r1_addcarryx_u32(&x1259, &x1260, x1258, x1226, x1223);
    fiat_secp384r1_addcarryx_u32(&x1261, &x1262, x1260, x1224, x1221);
    fiat_secp384r1_addcarryx_u32(&x1263, &x1264, x1262, x1222, x1219);
    x1265 = (x1264 + x1220);
    fiat_secp384r1_addcarryx_u32(&x1266, &x1267, 0x0, x1194, x1241);
    fiat_secp384r1_addcarryx_u32(&x1268, &x1269, x1267, x1196, x1243);
    fiat_secp384r1_addcarryx_u32(&x1270, &x1271, x1269, x1198, x1245);
    fiat_secp384r1_addcarryx_u32(&x1272, &x1273, x1271, x1200, x1247);
    fiat_secp384r1_addcarryx_u32(&x1274, &x1275, x1273, x1202, x1249);
    fiat_secp384r1_addcarryx_u32(&x1276, &x1277, x1275, x1204, x1251);
    fiat_secp384r1_addcarryx_u32(&x1278, &x1279, x1277, x1206, x1253);
    fiat_secp384r1_addcarryx_u32(&x1280, &x1281, x1279, x1208, x1255);
    fiat_secp384r1_addcarryx_u32(&x1282, &x1283, x1281, x1210, x1257);
    fiat_secp384r1_addcarryx_u32(&x1284, &x1285, x1283, x1212, x1259);
    fiat_secp384r1_addcarryx_u32(&x1286, &x1287, x1285, x1214, x1261);
    fiat_secp384r1_addcarryx_u32(&x1288, &x1289, x1287, x1216, x1263);
    fiat_secp384r1_addcarryx_u32(&x1290, &x1291, x1289, x1218, x1265);
    fiat_secp384r1_mulx_u32(&x1292, &x1293, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1294, &x1295, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1296, &x1297, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1298, &x1299, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1300, &x1301, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1302, &x1303, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1304, &x1305, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1306, &x1307, x1266, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1308, &x1309, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1310, &x1311, x1266, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1312, &x1313, 0x0, x1309, x1306);
    fiat_secp384r1_addcarryx_u32(&x1314, &x1315, x1313, x1307, x1304);
    fiat_secp384r1_addcarryx_u32(&x1316, &x1317, x1315, x1305, x1302);
    fiat_secp384r1_addcarryx_u32(&x1318, &x1319, x1317, x1303, x1300);
    fiat_secp384r1_addcarryx_u32(&x1320, &x1321, x1319, x1301, x1298);
    fiat_secp384r1_addcarryx_u32(&x1322, &x1323, x1321, x1299, x1296);
    fiat_secp384r1_addcarryx_u32(&x1324, &x1325, x1323, x1297, x1294);
    fiat_secp384r1_addcarryx_u32(&x1326, &x1327, x1325, x1295, x1292);
    x1328 = (x1327 + x1293);
    fiat_secp384r1_addcarryx_u32(&x1329, &x1330, 0x0, x1266, x1310);
    fiat_secp384r1_addcarryx_u32(&x1331, &x1332, x1330, x1268, x1311);
    fiat_secp384r1_addcarryx_u32(&x1333, &x1334, x1332, x1270, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1335, &x1336, x1334, x1272, x1308);
    fiat_secp384r1_addcarryx_u32(&x1337, &x1338, x1336, x1274, x1312);
    fiat_secp384r1_addcarryx_u32(&x1339, &x1340, x1338, x1276, x1314);
    fiat_secp384r1_addcarryx_u32(&x1341, &x1342, x1340, x1278, x1316);
    fiat_secp384r1_addcarryx_u32(&x1343, &x1344, x1342, x1280, x1318);
    fiat_secp384r1_addcarryx_u32(&x1345, &x1346, x1344, x1282, x1320);
    fiat_secp384r1_addcarryx_u32(&x1347, &x1348, x1346, x1284, x1322);
    fiat_secp384r1_addcarryx_u32(&x1349, &x1350, x1348, x1286, x1324);
    fiat_secp384r1_addcarryx_u32(&x1351, &x1352, x1350, x1288, x1326);
    fiat_secp384r1_addcarryx_u32(&x1353, &x1354, x1352, x1290, x1328);
    x1355 = ((uint32_t)x1354 + x1291);
    fiat_secp384r1_mulx_u32(&x1356, &x1357, x10, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x1358, &x1359, x10, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x1360, &x1361, x10, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x1362, &x1363, x10, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x1364, &x1365, x10, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x1366, &x1367, x10, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x1368, &x1369, x10, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x1370, &x1371, x10, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x1372, &x1373, x10, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x1374, &x1375, x10, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x1376, &x1377, x10, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x1378, &x1379, x10, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x1380, &x1381, 0x0, x1379, x1376);
    fiat_secp384r1_addcarryx_u32(&x1382, &x1383, x1381, x1377, x1374);
    fiat_secp384r1_addcarryx_u32(&x1384, &x1385, x1383, x1375, x1372);
    fiat_secp384r1_addcarryx_u32(&x1386, &x1387, x1385, x1373, x1370);
    fiat_secp384r1_addcarryx_u32(&x1388, &x1389, x1387, x1371, x1368);
    fiat_secp384r1_addcarryx_u32(&x1390, &x1391, x1389, x1369, x1366);
    fiat_secp384r1_addcarryx_u32(&x1392, &x1393, x1391, x1367, x1364);
    fiat_secp384r1_addcarryx_u32(&x1394, &x1395, x1393, x1365, x1362);
    fiat_secp384r1_addcarryx_u32(&x1396, &x1397, x1395, x1363, x1360);
    fiat_secp384r1_addcarryx_u32(&x1398, &x1399, x1397, x1361, x1358);
    fiat_secp384r1_addcarryx_u32(&x1400, &x1401, x1399, x1359, x1356);
    x1402 = (x1401 + x1357);
    fiat_secp384r1_addcarryx_u32(&x1403, &x1404, 0x0, x1331, x1378);
    fiat_secp384r1_addcarryx_u32(&x1405, &x1406, x1404, x1333, x1380);
    fiat_secp384r1_addcarryx_u32(&x1407, &x1408, x1406, x1335, x1382);
    fiat_secp384r1_addcarryx_u32(&x1409, &x1410, x1408, x1337, x1384);
    fiat_secp384r1_addcarryx_u32(&x1411, &x1412, x1410, x1339, x1386);
    fiat_secp384r1_addcarryx_u32(&x1413, &x1414, x1412, x1341, x1388);
    fiat_secp384r1_addcarryx_u32(&x1415, &x1416, x1414, x1343, x1390);
    fiat_secp384r1_addcarryx_u32(&x1417, &x1418, x1416, x1345, x1392);
    fiat_secp384r1_addcarryx_u32(&x1419, &x1420, x1418, x1347, x1394);
    fiat_secp384r1_addcarryx_u32(&x1421, &x1422, x1420, x1349, x1396);
    fiat_secp384r1_addcarryx_u32(&x1423, &x1424, x1422, x1351, x1398);
    fiat_secp384r1_addcarryx_u32(&x1425, &x1426, x1424, x1353, x1400);
    fiat_secp384r1_addcarryx_u32(&x1427, &x1428, x1426, x1355, x1402);
    fiat_secp384r1_mulx_u32(&x1429, &x1430, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1431, &x1432, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1433, &x1434, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1435, &x1436, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1437, &x1438, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1439, &x1440, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1441, &x1442, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1443, &x1444, x1403, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1445, &x1446, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1447, &x1448, x1403, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1449, &x1450, 0x0, x1446, x1443);
    fiat_secp384r1_addcarryx_u32(&x1451, &x1452, x1450, x1444, x1441);
    fiat_secp384r1_addcarryx_u32(&x1453, &x1454, x1452, x1442, x1439);
    fiat_secp384r1_addcarryx_u32(&x1455, &x1456, x1454, x1440, x1437);
    fiat_secp384r1_addcarryx_u32(&x1457, &x1458, x1456, x1438, x1435);
    fiat_secp384r1_addcarryx_u32(&x1459, &x1460, x1458, x1436, x1433);
    fiat_secp384r1_addcarryx_u32(&x1461, &x1462, x1460, x1434, x1431);
    fiat_secp384r1_addcarryx_u32(&x1463, &x1464, x1462, x1432, x1429);
    x1465 = (x1464 + x1430);
    fiat_secp384r1_addcarryx_u32(&x1466, &x1467, 0x0, x1403, x1447);
    fiat_secp384r1_addcarryx_u32(&x1468, &x1469, x1467, x1405, x1448);
    fiat_secp384r1_addcarryx_u32(&x1470, &x1471, x1469, x1407, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1472, &x1473, x1471, x1409, x1445);
    fiat_secp384r1_addcarryx_u32(&x1474, &x1475, x1473, x1411, x1449);
    fiat_secp384r1_addcarryx_u32(&x1476, &x1477, x1475, x1413, x1451);
    fiat_secp384r1_addcarryx_u32(&x1478, &x1479, x1477, x1415, x1453);
    fiat_secp384r1_addcarryx_u32(&x1480, &x1481, x1479, x1417, x1455);
    fiat_secp384r1_addcarryx_u32(&x1482, &x1483, x1481, x1419, x1457);
    fiat_secp384r1_addcarryx_u32(&x1484, &x1485, x1483, x1421, x1459);
    fiat_secp384r1_addcarryx_u32(&x1486, &x1487, x1485, x1423, x1461);
    fiat_secp384r1_addcarryx_u32(&x1488, &x1489, x1487, x1425, x1463);
    fiat_secp384r1_addcarryx_u32(&x1490, &x1491, x1489, x1427, x1465);
    x1492 = ((uint32_t)x1491 + x1428);
    fiat_secp384r1_mulx_u32(&x1493, &x1494, x11, (arg1[11]));
    fiat_secp384r1_mulx_u32(&x1495, &x1496, x11, (arg1[10]));
    fiat_secp384r1_mulx_u32(&x1497, &x1498, x11, (arg1[9]));
    fiat_secp384r1_mulx_u32(&x1499, &x1500, x11, (arg1[8]));
    fiat_secp384r1_mulx_u32(&x1501, &x1502, x11, (arg1[7]));
    fiat_secp384r1_mulx_u32(&x1503, &x1504, x11, (arg1[6]));
    fiat_secp384r1_mulx_u32(&x1505, &x1506, x11, (arg1[5]));
    fiat_secp384r1_mulx_u32(&x1507, &x1508, x11, (arg1[4]));
    fiat_secp384r1_mulx_u32(&x1509, &x1510, x11, (arg1[3]));
    fiat_secp384r1_mulx_u32(&x1511, &x1512, x11, (arg1[2]));
    fiat_secp384r1_mulx_u32(&x1513, &x1514, x11, (arg1[1]));
    fiat_secp384r1_mulx_u32(&x1515, &x1516, x11, (arg1[0]));
    fiat_secp384r1_addcarryx_u32(&x1517, &x1518, 0x0, x1516, x1513);
    fiat_secp384r1_addcarryx_u32(&x1519, &x1520, x1518, x1514, x1511);
    fiat_secp384r1_addcarryx_u32(&x1521, &x1522, x1520, x1512, x1509);
    fiat_secp384r1_addcarryx_u32(&x1523, &x1524, x1522, x1510, x1507);
    fiat_secp384r1_addcarryx_u32(&x1525, &x1526, x1524, x1508, x1505);
    fiat_secp384r1_addcarryx_u32(&x1527, &x1528, x1526, x1506, x1503);
    fiat_secp384r1_addcarryx_u32(&x1529, &x1530, x1528, x1504, x1501);
    fiat_secp384r1_addcarryx_u32(&x1531, &x1532, x1530, x1502, x1499);
    fiat_secp384r1_addcarryx_u32(&x1533, &x1534, x1532, x1500, x1497);
    fiat_secp384r1_addcarryx_u32(&x1535, &x1536, x1534, x1498, x1495);
    fiat_secp384r1_addcarryx_u32(&x1537, &x1538, x1536, x1496, x1493);
    x1539 = (x1538 + x1494);
    fiat_secp384r1_addcarryx_u32(&x1540, &x1541, 0x0, x1468, x1515);
    fiat_secp384r1_addcarryx_u32(&x1542, &x1543, x1541, x1470, x1517);
    fiat_secp384r1_addcarryx_u32(&x1544, &x1545, x1543, x1472, x1519);
    fiat_secp384r1_addcarryx_u32(&x1546, &x1547, x1545, x1474, x1521);
    fiat_secp384r1_addcarryx_u32(&x1548, &x1549, x1547, x1476, x1523);
    fiat_secp384r1_addcarryx_u32(&x1550, &x1551, x1549, x1478, x1525);
    fiat_secp384r1_addcarryx_u32(&x1552, &x1553, x1551, x1480, x1527);
    fiat_secp384r1_addcarryx_u32(&x1554, &x1555, x1553, x1482, x1529);
    fiat_secp384r1_addcarryx_u32(&x1556, &x1557, x1555, x1484, x1531);
    fiat_secp384r1_addcarryx_u32(&x1558, &x1559, x1557, x1486, x1533);
    fiat_secp384r1_addcarryx_u32(&x1560, &x1561, x1559, x1488, x1535);
    fiat_secp384r1_addcarryx_u32(&x1562, &x1563, x1561, x1490, x1537);
    fiat_secp384r1_addcarryx_u32(&x1564, &x1565, x1563, x1492, x1539);
    fiat_secp384r1_mulx_u32(&x1566, &x1567, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1568, &x1569, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1570, &x1571, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1572, &x1573, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1574, &x1575, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1576, &x1577, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1578, &x1579, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1580, &x1581, x1540, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1582, &x1583, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1584, &x1585, x1540, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1586, &x1587, 0x0, x1583, x1580);
    fiat_secp384r1_addcarryx_u32(&x1588, &x1589, x1587, x1581, x1578);
    fiat_secp384r1_addcarryx_u32(&x1590, &x1591, x1589, x1579, x1576);
    fiat_secp384r1_addcarryx_u32(&x1592, &x1593, x1591, x1577, x1574);
    fiat_secp384r1_addcarryx_u32(&x1594, &x1595, x1593, x1575, x1572);
    fiat_secp384r1_addcarryx_u32(&x1596, &x1597, x1595, x1573, x1570);
    fiat_secp384r1_addcarryx_u32(&x1598, &x1599, x1597, x1571, x1568);
    fiat_secp384r1_addcarryx_u32(&x1600, &x1601, x1599, x1569, x1566);
    x1602 = (x1601 + x1567);
    fiat_secp384r1_addcarryx_u32(&x1603, &x1604, 0x0, x1540, x1584);
    fiat_secp384r1_addcarryx_u32(&x1605, &x1606, x1604, x1542, x1585);
    fiat_secp384r1_addcarryx_u32(&x1607, &x1608, x1606, x1544, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1609, &x1610, x1608, x1546, x1582);
    fiat_secp384r1_addcarryx_u32(&x1611, &x1612, x1610, x1548, x1586);
    fiat_secp384r1_addcarryx_u32(&x1613, &x1614, x1612, x1550, x1588);
    fiat_secp384r1_addcarryx_u32(&x1615, &x1616, x1614, x1552, x1590);
    fiat_secp384r1_addcarryx_u32(&x1617, &x1618, x1616, x1554, x1592);
    fiat_secp384r1_addcarryx_u32(&x1619, &x1620, x1618, x1556, x1594);
    fiat_secp384r1_addcarryx_u32(&x1621, &x1622, x1620, x1558, x1596);
    fiat_secp384r1_addcarryx_u32(&x1623, &x1624, x1622, x1560, x1598);
    fiat_secp384r1_addcarryx_u32(&x1625, &x1626, x1624, x1562, x1600);
    fiat_secp384r1_addcarryx_u32(&x1627, &x1628, x1626, x1564, x1602);
    x1629 = ((uint32_t)x1628 + x1565);
    fiat_secp384r1_subborrowx_u32(&x1630, &x1631, 0x0, x1605,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1632, &x1633, x1631, x1607, 0x0);
    fiat_secp384r1_subborrowx_u32(&x1634, &x1635, x1633, x1609, 0x0);
    fiat_secp384r1_subborrowx_u32(&x1636, &x1637, x1635, x1611,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1638, &x1639, x1637, x1613,
                                  UINT32_C(0xfffffffe));
    fiat_secp384r1_subborrowx_u32(&x1640, &x1641, x1639, x1615,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1642, &x1643, x1641, x1617,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1644, &x1645, x1643, x1619,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1646, &x1647, x1645, x1621,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1648, &x1649, x1647, x1623,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1650, &x1651, x1649, x1625,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1652, &x1653, x1651, x1627,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1654, &x1655, x1653, x1629, 0x0);
    fiat_secp384r1_cmovznz_u32(&x1656, x1655, x1630, x1605);
    fiat_secp384r1_cmovznz_u32(&x1657, x1655, x1632, x1607);
    fiat_secp384r1_cmovznz_u32(&x1658, x1655, x1634, x1609);
    fiat_secp384r1_cmovznz_u32(&x1659, x1655, x1636, x1611);
    fiat_secp384r1_cmovznz_u32(&x1660, x1655, x1638, x1613);
    fiat_secp384r1_cmovznz_u32(&x1661, x1655, x1640, x1615);
    fiat_secp384r1_cmovznz_u32(&x1662, x1655, x1642, x1617);
    fiat_secp384r1_cmovznz_u32(&x1663, x1655, x1644, x1619);
    fiat_secp384r1_cmovznz_u32(&x1664, x1655, x1646, x1621);
    fiat_secp384r1_cmovznz_u32(&x1665, x1655, x1648, x1623);
    fiat_secp384r1_cmovznz_u32(&x1666, x1655, x1650, x1625);
    fiat_secp384r1_cmovznz_u32(&x1667, x1655, x1652, x1627);
    out1[0] = x1656;
    out1[1] = x1657;
    out1[2] = x1658;
    out1[3] = x1659;
    out1[4] = x1660;
    out1[5] = x1661;
    out1[6] = x1662;
    out1[7] = x1663;
    out1[8] = x1664;
    out1[9] = x1665;
    out1[10] = x1666;
    out1[11] = x1667;
}

/*
 * The function fiat_secp384r1_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_add(uint32_t out1[12], const uint32_t arg1[12],
                   const uint32_t arg2[12])
{
    uint32_t x1;
    fiat_secp384r1_uint1 x2;
    uint32_t x3;
    fiat_secp384r1_uint1 x4;
    uint32_t x5;
    fiat_secp384r1_uint1 x6;
    uint32_t x7;
    fiat_secp384r1_uint1 x8;
    uint32_t x9;
    fiat_secp384r1_uint1 x10;
    uint32_t x11;
    fiat_secp384r1_uint1 x12;
    uint32_t x13;
    fiat_secp384r1_uint1 x14;
    uint32_t x15;
    fiat_secp384r1_uint1 x16;
    uint32_t x17;
    fiat_secp384r1_uint1 x18;
    uint32_t x19;
    fiat_secp384r1_uint1 x20;
    uint32_t x21;
    fiat_secp384r1_uint1 x22;
    uint32_t x23;
    fiat_secp384r1_uint1 x24;
    uint32_t x25;
    fiat_secp384r1_uint1 x26;
    uint32_t x27;
    fiat_secp384r1_uint1 x28;
    uint32_t x29;
    fiat_secp384r1_uint1 x30;
    uint32_t x31;
    fiat_secp384r1_uint1 x32;
    uint32_t x33;
    fiat_secp384r1_uint1 x34;
    uint32_t x35;
    fiat_secp384r1_uint1 x36;
    uint32_t x37;
    fiat_secp384r1_uint1 x38;
    uint32_t x39;
    fiat_secp384r1_uint1 x40;
    uint32_t x41;
    fiat_secp384r1_uint1 x42;
    uint32_t x43;
    fiat_secp384r1_uint1 x44;
    uint32_t x45;
    fiat_secp384r1_uint1 x46;
    uint32_t x47;
    fiat_secp384r1_uint1 x48;
    uint32_t x49;
    fiat_secp384r1_uint1 x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    uint32_t x57;
    uint32_t x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    fiat_secp384r1_addcarryx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_secp384r1_addcarryx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_secp384r1_addcarryx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_secp384r1_addcarryx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_secp384r1_addcarryx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
    fiat_secp384r1_addcarryx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
    fiat_secp384r1_addcarryx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
    fiat_secp384r1_addcarryx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
    fiat_secp384r1_addcarryx_u32(&x17, &x18, x16, (arg1[8]), (arg2[8]));
    fiat_secp384r1_addcarryx_u32(&x19, &x20, x18, (arg1[9]), (arg2[9]));
    fiat_secp384r1_addcarryx_u32(&x21, &x22, x20, (arg1[10]), (arg2[10]));
    fiat_secp384r1_addcarryx_u32(&x23, &x24, x22, (arg1[11]), (arg2[11]));
    fiat_secp384r1_subborrowx_u32(&x25, &x26, 0x0, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x27, &x28, x26, x3, 0x0);
    fiat_secp384r1_subborrowx_u32(&x29, &x30, x28, x5, 0x0);
    fiat_secp384r1_subborrowx_u32(&x31, &x32, x30, x7, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x33, &x34, x32, x9, UINT32_C(0xfffffffe));
    fiat_secp384r1_subborrowx_u32(&x35, &x36, x34, x11, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x37, &x38, x36, x13, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x39, &x40, x38, x15, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x41, &x42, x40, x17, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x43, &x44, x42, x19, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x45, &x46, x44, x21, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x47, &x48, x46, x23, UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x49, &x50, x48, x24, 0x0);
    fiat_secp384r1_cmovznz_u32(&x51, x50, x25, x1);
    fiat_secp384r1_cmovznz_u32(&x52, x50, x27, x3);
    fiat_secp384r1_cmovznz_u32(&x53, x50, x29, x5);
    fiat_secp384r1_cmovznz_u32(&x54, x50, x31, x7);
    fiat_secp384r1_cmovznz_u32(&x55, x50, x33, x9);
    fiat_secp384r1_cmovznz_u32(&x56, x50, x35, x11);
    fiat_secp384r1_cmovznz_u32(&x57, x50, x37, x13);
    fiat_secp384r1_cmovznz_u32(&x58, x50, x39, x15);
    fiat_secp384r1_cmovznz_u32(&x59, x50, x41, x17);
    fiat_secp384r1_cmovznz_u32(&x60, x50, x43, x19);
    fiat_secp384r1_cmovznz_u32(&x61, x50, x45, x21);
    fiat_secp384r1_cmovznz_u32(&x62, x50, x47, x23);
    out1[0] = x51;
    out1[1] = x52;
    out1[2] = x53;
    out1[3] = x54;
    out1[4] = x55;
    out1[5] = x56;
    out1[6] = x57;
    out1[7] = x58;
    out1[8] = x59;
    out1[9] = x60;
    out1[10] = x61;
    out1[11] = x62;
}

/*
 * The function fiat_secp384r1_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_sub(uint32_t out1[12], const uint32_t arg1[12],
                   const uint32_t arg2[12])
{
    uint32_t x1;
    fiat_secp384r1_uint1 x2;
    uint32_t x3;
    fiat_secp384r1_uint1 x4;
    uint32_t x5;
    fiat_secp384r1_uint1 x6;
    uint32_t x7;
    fiat_secp384r1_uint1 x8;
    uint32_t x9;
    fiat_secp384r1_uint1 x10;
    uint32_t x11;
    fiat_secp384r1_uint1 x12;
    uint32_t x13;
    fiat_secp384r1_uint1 x14;
    uint32_t x15;
    fiat_secp384r1_uint1 x16;
    uint32_t x17;
    fiat_secp384r1_uint1 x18;
    uint32_t x19;
    fiat_secp384r1_uint1 x20;
    uint32_t x21;
    fiat_secp384r1_uint1 x22;
    uint32_t x23;
    fiat_secp384r1_uint1 x24;
    uint32_t x25;
    uint32_t x26;
    fiat_secp384r1_uint1 x27;
    uint32_t x28;
    fiat_secp384r1_uint1 x29;
    uint32_t x30;
    fiat_secp384r1_uint1 x31;
    uint32_t x32;
    fiat_secp384r1_uint1 x33;
    uint32_t x34;
    fiat_secp384r1_uint1 x35;
    uint32_t x36;
    fiat_secp384r1_uint1 x37;
    uint32_t x38;
    fiat_secp384r1_uint1 x39;
    uint32_t x40;
    fiat_secp384r1_uint1 x41;
    uint32_t x42;
    fiat_secp384r1_uint1 x43;
    uint32_t x44;
    fiat_secp384r1_uint1 x45;
    uint32_t x46;
    fiat_secp384r1_uint1 x47;
    uint32_t x48;
    fiat_secp384r1_uint1 x49;
    fiat_secp384r1_subborrowx_u32(&x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_secp384r1_subborrowx_u32(&x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_secp384r1_subborrowx_u32(&x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_secp384r1_subborrowx_u32(&x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_secp384r1_subborrowx_u32(&x9, &x10, x8, (arg1[4]), (arg2[4]));
    fiat_secp384r1_subborrowx_u32(&x11, &x12, x10, (arg1[5]), (arg2[5]));
    fiat_secp384r1_subborrowx_u32(&x13, &x14, x12, (arg1[6]), (arg2[6]));
    fiat_secp384r1_subborrowx_u32(&x15, &x16, x14, (arg1[7]), (arg2[7]));
    fiat_secp384r1_subborrowx_u32(&x17, &x18, x16, (arg1[8]), (arg2[8]));
    fiat_secp384r1_subborrowx_u32(&x19, &x20, x18, (arg1[9]), (arg2[9]));
    fiat_secp384r1_subborrowx_u32(&x21, &x22, x20, (arg1[10]), (arg2[10]));
    fiat_secp384r1_subborrowx_u32(&x23, &x24, x22, (arg1[11]), (arg2[11]));
    fiat_secp384r1_cmovznz_u32(&x25, x24, 0x0, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x26, &x27, 0x0, x1,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x28, &x29, x27, x3, 0x0);
    fiat_secp384r1_addcarryx_u32(&x30, &x31, x29, x5, 0x0);
    fiat_secp384r1_addcarryx_u32(&x32, &x33, x31, x7,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x34, &x35, x33, x9,
                                 (x25 & UINT32_C(0xfffffffe)));
    fiat_secp384r1_addcarryx_u32(&x36, &x37, x35, x11,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x38, &x39, x37, x13,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x40, &x41, x39, x15,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x42, &x43, x41, x17,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x44, &x45, x43, x19,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x46, &x47, x45, x21,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x48, &x49, x47, x23,
                                 (x25 & UINT32_C(0xffffffff)));
    out1[0] = x26;
    out1[1] = x28;
    out1[2] = x30;
    out1[3] = x32;
    out1[4] = x34;
    out1[5] = x36;
    out1[6] = x38;
    out1[7] = x40;
    out1[8] = x42;
    out1[9] = x44;
    out1[10] = x46;
    out1[11] = x48;
}

/*
 * The function fiat_secp384r1_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_opp(uint32_t out1[12], const uint32_t arg1[12])
{
    uint32_t x1;
    fiat_secp384r1_uint1 x2;
    uint32_t x3;
    fiat_secp384r1_uint1 x4;
    uint32_t x5;
    fiat_secp384r1_uint1 x6;
    uint32_t x7;
    fiat_secp384r1_uint1 x8;
    uint32_t x9;
    fiat_secp384r1_uint1 x10;
    uint32_t x11;
    fiat_secp384r1_uint1 x12;
    uint32_t x13;
    fiat_secp384r1_uint1 x14;
    uint32_t x15;
    fiat_secp384r1_uint1 x16;
    uint32_t x17;
    fiat_secp384r1_uint1 x18;
    uint32_t x19;
    fiat_secp384r1_uint1 x20;
    uint32_t x21;
    fiat_secp384r1_uint1 x22;
    uint32_t x23;
    fiat_secp384r1_uint1 x24;
    uint32_t x25;
    uint32_t x26;
    fiat_secp384r1_uint1 x27;
    uint32_t x28;
    fiat_secp384r1_uint1 x29;
    uint32_t x30;
    fiat_secp384r1_uint1 x31;
    uint32_t x32;
    fiat_secp384r1_uint1 x33;
    uint32_t x34;
    fiat_secp384r1_uint1 x35;
    uint32_t x36;
    fiat_secp384r1_uint1 x37;
    uint32_t x38;
    fiat_secp384r1_uint1 x39;
    uint32_t x40;
    fiat_secp384r1_uint1 x41;
    uint32_t x42;
    fiat_secp384r1_uint1 x43;
    uint32_t x44;
    fiat_secp384r1_uint1 x45;
    uint32_t x46;
    fiat_secp384r1_uint1 x47;
    uint32_t x48;
    fiat_secp384r1_uint1 x49;
    fiat_secp384r1_subborrowx_u32(&x1, &x2, 0x0, 0x0, (arg1[0]));
    fiat_secp384r1_subborrowx_u32(&x3, &x4, x2, 0x0, (arg1[1]));
    fiat_secp384r1_subborrowx_u32(&x5, &x6, x4, 0x0, (arg1[2]));
    fiat_secp384r1_subborrowx_u32(&x7, &x8, x6, 0x0, (arg1[3]));
    fiat_secp384r1_subborrowx_u32(&x9, &x10, x8, 0x0, (arg1[4]));
    fiat_secp384r1_subborrowx_u32(&x11, &x12, x10, 0x0, (arg1[5]));
    fiat_secp384r1_subborrowx_u32(&x13, &x14, x12, 0x0, (arg1[6]));
    fiat_secp384r1_subborrowx_u32(&x15, &x16, x14, 0x0, (arg1[7]));
    fiat_secp384r1_subborrowx_u32(&x17, &x18, x16, 0x0, (arg1[8]));
    fiat_secp384r1_subborrowx_u32(&x19, &x20, x18, 0x0, (arg1[9]));
    fiat_secp384r1_subborrowx_u32(&x21, &x22, x20, 0x0, (arg1[10]));
    fiat_secp384r1_subborrowx_u32(&x23, &x24, x22, 0x0, (arg1[11]));
    fiat_secp384r1_cmovznz_u32(&x25, x24, 0x0, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x26, &x27, 0x0, x1,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x28, &x29, x27, x3, 0x0);
    fiat_secp384r1_addcarryx_u32(&x30, &x31, x29, x5, 0x0);
    fiat_secp384r1_addcarryx_u32(&x32, &x33, x31, x7,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x34, &x35, x33, x9,
                                 (x25 & UINT32_C(0xfffffffe)));
    fiat_secp384r1_addcarryx_u32(&x36, &x37, x35, x11,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x38, &x39, x37, x13,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x40, &x41, x39, x15,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x42, &x43, x41, x17,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x44, &x45, x43, x19,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x46, &x47, x45, x21,
                                 (x25 & UINT32_C(0xffffffff)));
    fiat_secp384r1_addcarryx_u32(&x48, &x49, x47, x23,
                                 (x25 & UINT32_C(0xffffffff)));
    out1[0] = x26;
    out1[1] = x28;
    out1[2] = x30;
    out1[3] = x32;
    out1[4] = x34;
    out1[5] = x36;
    out1[6] = x38;
    out1[7] = x40;
    out1[8] = x42;
    out1[9] = x44;
    out1[10] = x46;
    out1[11] = x48;
}

/*
 * The function fiat_secp384r1_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^12) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_from_montgomery(uint32_t out1[12],
                               const uint32_t arg1[12])
{
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    fiat_secp384r1_uint1 x23;
    uint32_t x24;
    fiat_secp384r1_uint1 x25;
    uint32_t x26;
    fiat_secp384r1_uint1 x27;
    uint32_t x28;
    fiat_secp384r1_uint1 x29;
    uint32_t x30;
    fiat_secp384r1_uint1 x31;
    uint32_t x32;
    fiat_secp384r1_uint1 x33;
    uint32_t x34;
    fiat_secp384r1_uint1 x35;
    uint32_t x36;
    fiat_secp384r1_uint1 x37;
    uint32_t x38;
    fiat_secp384r1_uint1 x39;
    uint32_t x40;
    fiat_secp384r1_uint1 x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    uint32_t x57;
    uint32_t x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    fiat_secp384r1_uint1 x63;
    uint32_t x64;
    fiat_secp384r1_uint1 x65;
    uint32_t x66;
    fiat_secp384r1_uint1 x67;
    uint32_t x68;
    fiat_secp384r1_uint1 x69;
    uint32_t x70;
    fiat_secp384r1_uint1 x71;
    uint32_t x72;
    fiat_secp384r1_uint1 x73;
    uint32_t x74;
    fiat_secp384r1_uint1 x75;
    uint32_t x76;
    fiat_secp384r1_uint1 x77;
    uint32_t x78;
    fiat_secp384r1_uint1 x79;
    uint32_t x80;
    fiat_secp384r1_uint1 x81;
    uint32_t x82;
    fiat_secp384r1_uint1 x83;
    uint32_t x84;
    fiat_secp384r1_uint1 x85;
    uint32_t x86;
    fiat_secp384r1_uint1 x87;
    uint32_t x88;
    fiat_secp384r1_uint1 x89;
    uint32_t x90;
    fiat_secp384r1_uint1 x91;
    uint32_t x92;
    fiat_secp384r1_uint1 x93;
    uint32_t x94;
    fiat_secp384r1_uint1 x95;
    uint32_t x96;
    fiat_secp384r1_uint1 x97;
    uint32_t x98;
    fiat_secp384r1_uint1 x99;
    uint32_t x100;
    fiat_secp384r1_uint1 x101;
    uint32_t x102;
    fiat_secp384r1_uint1 x103;
    uint32_t x104;
    fiat_secp384r1_uint1 x105;
    uint32_t x106;
    fiat_secp384r1_uint1 x107;
    uint32_t x108;
    fiat_secp384r1_uint1 x109;
    uint32_t x110;
    fiat_secp384r1_uint1 x111;
    uint32_t x112;
    fiat_secp384r1_uint1 x113;
    uint32_t x114;
    fiat_secp384r1_uint1 x115;
    uint32_t x116;
    fiat_secp384r1_uint1 x117;
    uint32_t x118;
    fiat_secp384r1_uint1 x119;
    uint32_t x120;
    fiat_secp384r1_uint1 x121;
    uint32_t x122;
    fiat_secp384r1_uint1 x123;
    uint32_t x124;
    fiat_secp384r1_uint1 x125;
    uint32_t x126;
    fiat_secp384r1_uint1 x127;
    uint32_t x128;
    uint32_t x129;
    uint32_t x130;
    uint32_t x131;
    uint32_t x132;
    uint32_t x133;
    uint32_t x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    uint32_t x148;
    fiat_secp384r1_uint1 x149;
    uint32_t x150;
    fiat_secp384r1_uint1 x151;
    uint32_t x152;
    fiat_secp384r1_uint1 x153;
    uint32_t x154;
    fiat_secp384r1_uint1 x155;
    uint32_t x156;
    fiat_secp384r1_uint1 x157;
    uint32_t x158;
    fiat_secp384r1_uint1 x159;
    uint32_t x160;
    fiat_secp384r1_uint1 x161;
    uint32_t x162;
    fiat_secp384r1_uint1 x163;
    uint32_t x164;
    fiat_secp384r1_uint1 x165;
    uint32_t x166;
    fiat_secp384r1_uint1 x167;
    uint32_t x168;
    fiat_secp384r1_uint1 x169;
    uint32_t x170;
    fiat_secp384r1_uint1 x171;
    uint32_t x172;
    fiat_secp384r1_uint1 x173;
    uint32_t x174;
    fiat_secp384r1_uint1 x175;
    uint32_t x176;
    fiat_secp384r1_uint1 x177;
    uint32_t x178;
    fiat_secp384r1_uint1 x179;
    uint32_t x180;
    fiat_secp384r1_uint1 x181;
    uint32_t x182;
    fiat_secp384r1_uint1 x183;
    uint32_t x184;
    fiat_secp384r1_uint1 x185;
    uint32_t x186;
    fiat_secp384r1_uint1 x187;
    uint32_t x188;
    fiat_secp384r1_uint1 x189;
    uint32_t x190;
    fiat_secp384r1_uint1 x191;
    uint32_t x192;
    fiat_secp384r1_uint1 x193;
    uint32_t x194;
    fiat_secp384r1_uint1 x195;
    uint32_t x196;
    fiat_secp384r1_uint1 x197;
    uint32_t x198;
    fiat_secp384r1_uint1 x199;
    uint32_t x200;
    fiat_secp384r1_uint1 x201;
    uint32_t x202;
    fiat_secp384r1_uint1 x203;
    uint32_t x204;
    fiat_secp384r1_uint1 x205;
    uint32_t x206;
    fiat_secp384r1_uint1 x207;
    uint32_t x208;
    fiat_secp384r1_uint1 x209;
    uint32_t x210;
    fiat_secp384r1_uint1 x211;
    uint32_t x212;
    fiat_secp384r1_uint1 x213;
    uint32_t x214;
    uint32_t x215;
    uint32_t x216;
    uint32_t x217;
    uint32_t x218;
    uint32_t x219;
    uint32_t x220;
    uint32_t x221;
    uint32_t x222;
    uint32_t x223;
    uint32_t x224;
    uint32_t x225;
    uint32_t x226;
    uint32_t x227;
    uint32_t x228;
    uint32_t x229;
    uint32_t x230;
    uint32_t x231;
    uint32_t x232;
    uint32_t x233;
    uint32_t x234;
    fiat_secp384r1_uint1 x235;
    uint32_t x236;
    fiat_secp384r1_uint1 x237;
    uint32_t x238;
    fiat_secp384r1_uint1 x239;
    uint32_t x240;
    fiat_secp384r1_uint1 x241;
    uint32_t x242;
    fiat_secp384r1_uint1 x243;
    uint32_t x244;
    fiat_secp384r1_uint1 x245;
    uint32_t x246;
    fiat_secp384r1_uint1 x247;
    uint32_t x248;
    fiat_secp384r1_uint1 x249;
    uint32_t x250;
    fiat_secp384r1_uint1 x251;
    uint32_t x252;
    fiat_secp384r1_uint1 x253;
    uint32_t x254;
    fiat_secp384r1_uint1 x255;
    uint32_t x256;
    fiat_secp384r1_uint1 x257;
    uint32_t x258;
    fiat_secp384r1_uint1 x259;
    uint32_t x260;
    fiat_secp384r1_uint1 x261;
    uint32_t x262;
    fiat_secp384r1_uint1 x263;
    uint32_t x264;
    fiat_secp384r1_uint1 x265;
    uint32_t x266;
    fiat_secp384r1_uint1 x267;
    uint32_t x268;
    fiat_secp384r1_uint1 x269;
    uint32_t x270;
    fiat_secp384r1_uint1 x271;
    uint32_t x272;
    fiat_secp384r1_uint1 x273;
    uint32_t x274;
    fiat_secp384r1_uint1 x275;
    uint32_t x276;
    fiat_secp384r1_uint1 x277;
    uint32_t x278;
    fiat_secp384r1_uint1 x279;
    uint32_t x280;
    fiat_secp384r1_uint1 x281;
    uint32_t x282;
    fiat_secp384r1_uint1 x283;
    uint32_t x284;
    fiat_secp384r1_uint1 x285;
    uint32_t x286;
    fiat_secp384r1_uint1 x287;
    uint32_t x288;
    fiat_secp384r1_uint1 x289;
    uint32_t x290;
    fiat_secp384r1_uint1 x291;
    uint32_t x292;
    fiat_secp384r1_uint1 x293;
    uint32_t x294;
    fiat_secp384r1_uint1 x295;
    uint32_t x296;
    fiat_secp384r1_uint1 x297;
    uint32_t x298;
    fiat_secp384r1_uint1 x299;
    uint32_t x300;
    uint32_t x301;
    uint32_t x302;
    uint32_t x303;
    uint32_t x304;
    uint32_t x305;
    uint32_t x306;
    uint32_t x307;
    uint32_t x308;
    uint32_t x309;
    uint32_t x310;
    uint32_t x311;
    uint32_t x312;
    uint32_t x313;
    uint32_t x314;
    uint32_t x315;
    uint32_t x316;
    uint32_t x317;
    uint32_t x318;
    uint32_t x319;
    uint32_t x320;
    fiat_secp384r1_uint1 x321;
    uint32_t x322;
    fiat_secp384r1_uint1 x323;
    uint32_t x324;
    fiat_secp384r1_uint1 x325;
    uint32_t x326;
    fiat_secp384r1_uint1 x327;
    uint32_t x328;
    fiat_secp384r1_uint1 x329;
    uint32_t x330;
    fiat_secp384r1_uint1 x331;
    uint32_t x332;
    fiat_secp384r1_uint1 x333;
    uint32_t x334;
    fiat_secp384r1_uint1 x335;
    uint32_t x336;
    fiat_secp384r1_uint1 x337;
    uint32_t x338;
    fiat_secp384r1_uint1 x339;
    uint32_t x340;
    fiat_secp384r1_uint1 x341;
    uint32_t x342;
    fiat_secp384r1_uint1 x343;
    uint32_t x344;
    fiat_secp384r1_uint1 x345;
    uint32_t x346;
    fiat_secp384r1_uint1 x347;
    uint32_t x348;
    fiat_secp384r1_uint1 x349;
    uint32_t x350;
    fiat_secp384r1_uint1 x351;
    uint32_t x352;
    fiat_secp384r1_uint1 x353;
    uint32_t x354;
    fiat_secp384r1_uint1 x355;
    uint32_t x356;
    fiat_secp384r1_uint1 x357;
    uint32_t x358;
    fiat_secp384r1_uint1 x359;
    uint32_t x360;
    fiat_secp384r1_uint1 x361;
    uint32_t x362;
    fiat_secp384r1_uint1 x363;
    uint32_t x364;
    fiat_secp384r1_uint1 x365;
    uint32_t x366;
    fiat_secp384r1_uint1 x367;
    uint32_t x368;
    fiat_secp384r1_uint1 x369;
    uint32_t x370;
    fiat_secp384r1_uint1 x371;
    uint32_t x372;
    fiat_secp384r1_uint1 x373;
    uint32_t x374;
    fiat_secp384r1_uint1 x375;
    uint32_t x376;
    fiat_secp384r1_uint1 x377;
    uint32_t x378;
    fiat_secp384r1_uint1 x379;
    uint32_t x380;
    fiat_secp384r1_uint1 x381;
    uint32_t x382;
    fiat_secp384r1_uint1 x383;
    uint32_t x384;
    fiat_secp384r1_uint1 x385;
    uint32_t x386;
    uint32_t x387;
    uint32_t x388;
    uint32_t x389;
    uint32_t x390;
    uint32_t x391;
    uint32_t x392;
    uint32_t x393;
    uint32_t x394;
    uint32_t x395;
    uint32_t x396;
    uint32_t x397;
    uint32_t x398;
    uint32_t x399;
    uint32_t x400;
    uint32_t x401;
    uint32_t x402;
    uint32_t x403;
    uint32_t x404;
    uint32_t x405;
    uint32_t x406;
    fiat_secp384r1_uint1 x407;
    uint32_t x408;
    fiat_secp384r1_uint1 x409;
    uint32_t x410;
    fiat_secp384r1_uint1 x411;
    uint32_t x412;
    fiat_secp384r1_uint1 x413;
    uint32_t x414;
    fiat_secp384r1_uint1 x415;
    uint32_t x416;
    fiat_secp384r1_uint1 x417;
    uint32_t x418;
    fiat_secp384r1_uint1 x419;
    uint32_t x420;
    fiat_secp384r1_uint1 x421;
    uint32_t x422;
    fiat_secp384r1_uint1 x423;
    uint32_t x424;
    fiat_secp384r1_uint1 x425;
    uint32_t x426;
    fiat_secp384r1_uint1 x427;
    uint32_t x428;
    fiat_secp384r1_uint1 x429;
    uint32_t x430;
    fiat_secp384r1_uint1 x431;
    uint32_t x432;
    fiat_secp384r1_uint1 x433;
    uint32_t x434;
    fiat_secp384r1_uint1 x435;
    uint32_t x436;
    fiat_secp384r1_uint1 x437;
    uint32_t x438;
    fiat_secp384r1_uint1 x439;
    uint32_t x440;
    fiat_secp384r1_uint1 x441;
    uint32_t x442;
    fiat_secp384r1_uint1 x443;
    uint32_t x444;
    fiat_secp384r1_uint1 x445;
    uint32_t x446;
    fiat_secp384r1_uint1 x447;
    uint32_t x448;
    fiat_secp384r1_uint1 x449;
    uint32_t x450;
    fiat_secp384r1_uint1 x451;
    uint32_t x452;
    fiat_secp384r1_uint1 x453;
    uint32_t x454;
    fiat_secp384r1_uint1 x455;
    uint32_t x456;
    fiat_secp384r1_uint1 x457;
    uint32_t x458;
    fiat_secp384r1_uint1 x459;
    uint32_t x460;
    fiat_secp384r1_uint1 x461;
    uint32_t x462;
    fiat_secp384r1_uint1 x463;
    uint32_t x464;
    fiat_secp384r1_uint1 x465;
    uint32_t x466;
    fiat_secp384r1_uint1 x467;
    uint32_t x468;
    fiat_secp384r1_uint1 x469;
    uint32_t x470;
    fiat_secp384r1_uint1 x471;
    uint32_t x472;
    uint32_t x473;
    uint32_t x474;
    uint32_t x475;
    uint32_t x476;
    uint32_t x477;
    uint32_t x478;
    uint32_t x479;
    uint32_t x480;
    uint32_t x481;
    uint32_t x482;
    uint32_t x483;
    uint32_t x484;
    uint32_t x485;
    uint32_t x486;
    uint32_t x487;
    uint32_t x488;
    uint32_t x489;
    uint32_t x490;
    uint32_t x491;
    uint32_t x492;
    fiat_secp384r1_uint1 x493;
    uint32_t x494;
    fiat_secp384r1_uint1 x495;
    uint32_t x496;
    fiat_secp384r1_uint1 x497;
    uint32_t x498;
    fiat_secp384r1_uint1 x499;
    uint32_t x500;
    fiat_secp384r1_uint1 x501;
    uint32_t x502;
    fiat_secp384r1_uint1 x503;
    uint32_t x504;
    fiat_secp384r1_uint1 x505;
    uint32_t x506;
    fiat_secp384r1_uint1 x507;
    uint32_t x508;
    fiat_secp384r1_uint1 x509;
    uint32_t x510;
    fiat_secp384r1_uint1 x511;
    uint32_t x512;
    fiat_secp384r1_uint1 x513;
    uint32_t x514;
    fiat_secp384r1_uint1 x515;
    uint32_t x516;
    fiat_secp384r1_uint1 x517;
    uint32_t x518;
    fiat_secp384r1_uint1 x519;
    uint32_t x520;
    fiat_secp384r1_uint1 x521;
    uint32_t x522;
    fiat_secp384r1_uint1 x523;
    uint32_t x524;
    fiat_secp384r1_uint1 x525;
    uint32_t x526;
    fiat_secp384r1_uint1 x527;
    uint32_t x528;
    fiat_secp384r1_uint1 x529;
    uint32_t x530;
    fiat_secp384r1_uint1 x531;
    uint32_t x532;
    fiat_secp384r1_uint1 x533;
    uint32_t x534;
    fiat_secp384r1_uint1 x535;
    uint32_t x536;
    fiat_secp384r1_uint1 x537;
    uint32_t x538;
    fiat_secp384r1_uint1 x539;
    uint32_t x540;
    fiat_secp384r1_uint1 x541;
    uint32_t x542;
    fiat_secp384r1_uint1 x543;
    uint32_t x544;
    fiat_secp384r1_uint1 x545;
    uint32_t x546;
    fiat_secp384r1_uint1 x547;
    uint32_t x548;
    fiat_secp384r1_uint1 x549;
    uint32_t x550;
    fiat_secp384r1_uint1 x551;
    uint32_t x552;
    fiat_secp384r1_uint1 x553;
    uint32_t x554;
    fiat_secp384r1_uint1 x555;
    uint32_t x556;
    fiat_secp384r1_uint1 x557;
    uint32_t x558;
    uint32_t x559;
    uint32_t x560;
    uint32_t x561;
    uint32_t x562;
    uint32_t x563;
    uint32_t x564;
    uint32_t x565;
    uint32_t x566;
    uint32_t x567;
    uint32_t x568;
    uint32_t x569;
    uint32_t x570;
    uint32_t x571;
    uint32_t x572;
    uint32_t x573;
    uint32_t x574;
    uint32_t x575;
    uint32_t x576;
    uint32_t x577;
    uint32_t x578;
    fiat_secp384r1_uint1 x579;
    uint32_t x580;
    fiat_secp384r1_uint1 x581;
    uint32_t x582;
    fiat_secp384r1_uint1 x583;
    uint32_t x584;
    fiat_secp384r1_uint1 x585;
    uint32_t x586;
    fiat_secp384r1_uint1 x587;
    uint32_t x588;
    fiat_secp384r1_uint1 x589;
    uint32_t x590;
    fiat_secp384r1_uint1 x591;
    uint32_t x592;
    fiat_secp384r1_uint1 x593;
    uint32_t x594;
    fiat_secp384r1_uint1 x595;
    uint32_t x596;
    fiat_secp384r1_uint1 x597;
    uint32_t x598;
    fiat_secp384r1_uint1 x599;
    uint32_t x600;
    fiat_secp384r1_uint1 x601;
    uint32_t x602;
    fiat_secp384r1_uint1 x603;
    uint32_t x604;
    fiat_secp384r1_uint1 x605;
    uint32_t x606;
    fiat_secp384r1_uint1 x607;
    uint32_t x608;
    fiat_secp384r1_uint1 x609;
    uint32_t x610;
    fiat_secp384r1_uint1 x611;
    uint32_t x612;
    fiat_secp384r1_uint1 x613;
    uint32_t x614;
    fiat_secp384r1_uint1 x615;
    uint32_t x616;
    fiat_secp384r1_uint1 x617;
    uint32_t x618;
    fiat_secp384r1_uint1 x619;
    uint32_t x620;
    fiat_secp384r1_uint1 x621;
    uint32_t x622;
    fiat_secp384r1_uint1 x623;
    uint32_t x624;
    fiat_secp384r1_uint1 x625;
    uint32_t x626;
    fiat_secp384r1_uint1 x627;
    uint32_t x628;
    fiat_secp384r1_uint1 x629;
    uint32_t x630;
    fiat_secp384r1_uint1 x631;
    uint32_t x632;
    fiat_secp384r1_uint1 x633;
    uint32_t x634;
    fiat_secp384r1_uint1 x635;
    uint32_t x636;
    fiat_secp384r1_uint1 x637;
    uint32_t x638;
    fiat_secp384r1_uint1 x639;
    uint32_t x640;
    fiat_secp384r1_uint1 x641;
    uint32_t x642;
    fiat_secp384r1_uint1 x643;
    uint32_t x644;
    uint32_t x645;
    uint32_t x646;
    uint32_t x647;
    uint32_t x648;
    uint32_t x649;
    uint32_t x650;
    uint32_t x651;
    uint32_t x652;
    uint32_t x653;
    uint32_t x654;
    uint32_t x655;
    uint32_t x656;
    uint32_t x657;
    uint32_t x658;
    uint32_t x659;
    uint32_t x660;
    uint32_t x661;
    uint32_t x662;
    uint32_t x663;
    uint32_t x664;
    fiat_secp384r1_uint1 x665;
    uint32_t x666;
    fiat_secp384r1_uint1 x667;
    uint32_t x668;
    fiat_secp384r1_uint1 x669;
    uint32_t x670;
    fiat_secp384r1_uint1 x671;
    uint32_t x672;
    fiat_secp384r1_uint1 x673;
    uint32_t x674;
    fiat_secp384r1_uint1 x675;
    uint32_t x676;
    fiat_secp384r1_uint1 x677;
    uint32_t x678;
    fiat_secp384r1_uint1 x679;
    uint32_t x680;
    fiat_secp384r1_uint1 x681;
    uint32_t x682;
    fiat_secp384r1_uint1 x683;
    uint32_t x684;
    fiat_secp384r1_uint1 x685;
    uint32_t x686;
    fiat_secp384r1_uint1 x687;
    uint32_t x688;
    fiat_secp384r1_uint1 x689;
    uint32_t x690;
    fiat_secp384r1_uint1 x691;
    uint32_t x692;
    fiat_secp384r1_uint1 x693;
    uint32_t x694;
    fiat_secp384r1_uint1 x695;
    uint32_t x696;
    fiat_secp384r1_uint1 x697;
    uint32_t x698;
    fiat_secp384r1_uint1 x699;
    uint32_t x700;
    fiat_secp384r1_uint1 x701;
    uint32_t x702;
    fiat_secp384r1_uint1 x703;
    uint32_t x704;
    fiat_secp384r1_uint1 x705;
    uint32_t x706;
    fiat_secp384r1_uint1 x707;
    uint32_t x708;
    fiat_secp384r1_uint1 x709;
    uint32_t x710;
    fiat_secp384r1_uint1 x711;
    uint32_t x712;
    fiat_secp384r1_uint1 x713;
    uint32_t x714;
    fiat_secp384r1_uint1 x715;
    uint32_t x716;
    fiat_secp384r1_uint1 x717;
    uint32_t x718;
    fiat_secp384r1_uint1 x719;
    uint32_t x720;
    fiat_secp384r1_uint1 x721;
    uint32_t x722;
    fiat_secp384r1_uint1 x723;
    uint32_t x724;
    fiat_secp384r1_uint1 x725;
    uint32_t x726;
    fiat_secp384r1_uint1 x727;
    uint32_t x728;
    fiat_secp384r1_uint1 x729;
    uint32_t x730;
    uint32_t x731;
    uint32_t x732;
    uint32_t x733;
    uint32_t x734;
    uint32_t x735;
    uint32_t x736;
    uint32_t x737;
    uint32_t x738;
    uint32_t x739;
    uint32_t x740;
    uint32_t x741;
    uint32_t x742;
    uint32_t x743;
    uint32_t x744;
    uint32_t x745;
    uint32_t x746;
    uint32_t x747;
    uint32_t x748;
    uint32_t x749;
    uint32_t x750;
    fiat_secp384r1_uint1 x751;
    uint32_t x752;
    fiat_secp384r1_uint1 x753;
    uint32_t x754;
    fiat_secp384r1_uint1 x755;
    uint32_t x756;
    fiat_secp384r1_uint1 x757;
    uint32_t x758;
    fiat_secp384r1_uint1 x759;
    uint32_t x760;
    fiat_secp384r1_uint1 x761;
    uint32_t x762;
    fiat_secp384r1_uint1 x763;
    uint32_t x764;
    fiat_secp384r1_uint1 x765;
    uint32_t x766;
    fiat_secp384r1_uint1 x767;
    uint32_t x768;
    fiat_secp384r1_uint1 x769;
    uint32_t x770;
    fiat_secp384r1_uint1 x771;
    uint32_t x772;
    fiat_secp384r1_uint1 x773;
    uint32_t x774;
    fiat_secp384r1_uint1 x775;
    uint32_t x776;
    fiat_secp384r1_uint1 x777;
    uint32_t x778;
    fiat_secp384r1_uint1 x779;
    uint32_t x780;
    fiat_secp384r1_uint1 x781;
    uint32_t x782;
    fiat_secp384r1_uint1 x783;
    uint32_t x784;
    fiat_secp384r1_uint1 x785;
    uint32_t x786;
    fiat_secp384r1_uint1 x787;
    uint32_t x788;
    fiat_secp384r1_uint1 x789;
    uint32_t x790;
    fiat_secp384r1_uint1 x791;
    uint32_t x792;
    fiat_secp384r1_uint1 x793;
    uint32_t x794;
    fiat_secp384r1_uint1 x795;
    uint32_t x796;
    fiat_secp384r1_uint1 x797;
    uint32_t x798;
    fiat_secp384r1_uint1 x799;
    uint32_t x800;
    fiat_secp384r1_uint1 x801;
    uint32_t x802;
    fiat_secp384r1_uint1 x803;
    uint32_t x804;
    fiat_secp384r1_uint1 x805;
    uint32_t x806;
    fiat_secp384r1_uint1 x807;
    uint32_t x808;
    fiat_secp384r1_uint1 x809;
    uint32_t x810;
    fiat_secp384r1_uint1 x811;
    uint32_t x812;
    fiat_secp384r1_uint1 x813;
    uint32_t x814;
    fiat_secp384r1_uint1 x815;
    uint32_t x816;
    uint32_t x817;
    uint32_t x818;
    uint32_t x819;
    uint32_t x820;
    uint32_t x821;
    uint32_t x822;
    uint32_t x823;
    uint32_t x824;
    uint32_t x825;
    uint32_t x826;
    uint32_t x827;
    uint32_t x828;
    uint32_t x829;
    uint32_t x830;
    uint32_t x831;
    uint32_t x832;
    uint32_t x833;
    uint32_t x834;
    uint32_t x835;
    uint32_t x836;
    fiat_secp384r1_uint1 x837;
    uint32_t x838;
    fiat_secp384r1_uint1 x839;
    uint32_t x840;
    fiat_secp384r1_uint1 x841;
    uint32_t x842;
    fiat_secp384r1_uint1 x843;
    uint32_t x844;
    fiat_secp384r1_uint1 x845;
    uint32_t x846;
    fiat_secp384r1_uint1 x847;
    uint32_t x848;
    fiat_secp384r1_uint1 x849;
    uint32_t x850;
    fiat_secp384r1_uint1 x851;
    uint32_t x852;
    fiat_secp384r1_uint1 x853;
    uint32_t x854;
    fiat_secp384r1_uint1 x855;
    uint32_t x856;
    fiat_secp384r1_uint1 x857;
    uint32_t x858;
    fiat_secp384r1_uint1 x859;
    uint32_t x860;
    fiat_secp384r1_uint1 x861;
    uint32_t x862;
    fiat_secp384r1_uint1 x863;
    uint32_t x864;
    fiat_secp384r1_uint1 x865;
    uint32_t x866;
    fiat_secp384r1_uint1 x867;
    uint32_t x868;
    fiat_secp384r1_uint1 x869;
    uint32_t x870;
    fiat_secp384r1_uint1 x871;
    uint32_t x872;
    fiat_secp384r1_uint1 x873;
    uint32_t x874;
    fiat_secp384r1_uint1 x875;
    uint32_t x876;
    fiat_secp384r1_uint1 x877;
    uint32_t x878;
    fiat_secp384r1_uint1 x879;
    uint32_t x880;
    fiat_secp384r1_uint1 x881;
    uint32_t x882;
    fiat_secp384r1_uint1 x883;
    uint32_t x884;
    fiat_secp384r1_uint1 x885;
    uint32_t x886;
    fiat_secp384r1_uint1 x887;
    uint32_t x888;
    fiat_secp384r1_uint1 x889;
    uint32_t x890;
    fiat_secp384r1_uint1 x891;
    uint32_t x892;
    fiat_secp384r1_uint1 x893;
    uint32_t x894;
    fiat_secp384r1_uint1 x895;
    uint32_t x896;
    fiat_secp384r1_uint1 x897;
    uint32_t x898;
    fiat_secp384r1_uint1 x899;
    uint32_t x900;
    fiat_secp384r1_uint1 x901;
    uint32_t x902;
    uint32_t x903;
    uint32_t x904;
    uint32_t x905;
    uint32_t x906;
    uint32_t x907;
    uint32_t x908;
    uint32_t x909;
    uint32_t x910;
    uint32_t x911;
    uint32_t x912;
    uint32_t x913;
    uint32_t x914;
    uint32_t x915;
    uint32_t x916;
    uint32_t x917;
    uint32_t x918;
    uint32_t x919;
    uint32_t x920;
    uint32_t x921;
    uint32_t x922;
    fiat_secp384r1_uint1 x923;
    uint32_t x924;
    fiat_secp384r1_uint1 x925;
    uint32_t x926;
    fiat_secp384r1_uint1 x927;
    uint32_t x928;
    fiat_secp384r1_uint1 x929;
    uint32_t x930;
    fiat_secp384r1_uint1 x931;
    uint32_t x932;
    fiat_secp384r1_uint1 x933;
    uint32_t x934;
    fiat_secp384r1_uint1 x935;
    uint32_t x936;
    fiat_secp384r1_uint1 x937;
    uint32_t x938;
    fiat_secp384r1_uint1 x939;
    uint32_t x940;
    fiat_secp384r1_uint1 x941;
    uint32_t x942;
    fiat_secp384r1_uint1 x943;
    uint32_t x944;
    fiat_secp384r1_uint1 x945;
    uint32_t x946;
    fiat_secp384r1_uint1 x947;
    uint32_t x948;
    fiat_secp384r1_uint1 x949;
    uint32_t x950;
    fiat_secp384r1_uint1 x951;
    uint32_t x952;
    fiat_secp384r1_uint1 x953;
    uint32_t x954;
    fiat_secp384r1_uint1 x955;
    uint32_t x956;
    fiat_secp384r1_uint1 x957;
    uint32_t x958;
    fiat_secp384r1_uint1 x959;
    uint32_t x960;
    fiat_secp384r1_uint1 x961;
    uint32_t x962;
    fiat_secp384r1_uint1 x963;
    uint32_t x964;
    fiat_secp384r1_uint1 x965;
    uint32_t x966;
    fiat_secp384r1_uint1 x967;
    uint32_t x968;
    fiat_secp384r1_uint1 x969;
    uint32_t x970;
    fiat_secp384r1_uint1 x971;
    uint32_t x972;
    fiat_secp384r1_uint1 x973;
    uint32_t x974;
    fiat_secp384r1_uint1 x975;
    uint32_t x976;
    fiat_secp384r1_uint1 x977;
    uint32_t x978;
    fiat_secp384r1_uint1 x979;
    uint32_t x980;
    fiat_secp384r1_uint1 x981;
    uint32_t x982;
    fiat_secp384r1_uint1 x983;
    uint32_t x984;
    fiat_secp384r1_uint1 x985;
    uint32_t x986;
    fiat_secp384r1_uint1 x987;
    uint32_t x988;
    fiat_secp384r1_uint1 x989;
    uint32_t x990;
    uint32_t x991;
    uint32_t x992;
    uint32_t x993;
    uint32_t x994;
    uint32_t x995;
    uint32_t x996;
    uint32_t x997;
    uint32_t x998;
    uint32_t x999;
    uint32_t x1000;
    uint32_t x1001;
    x1 = (arg1[0]);
    fiat_secp384r1_mulx_u32(&x2, &x3, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x4, &x5, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x6, &x7, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x8, &x9, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x10, &x11, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x12, &x13, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x14, &x15, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x16, &x17, x1, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x18, &x19, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x20, &x21, x1, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x22, &x23, 0x0, x19, x16);
    fiat_secp384r1_addcarryx_u32(&x24, &x25, x23, x17, x14);
    fiat_secp384r1_addcarryx_u32(&x26, &x27, x25, x15, x12);
    fiat_secp384r1_addcarryx_u32(&x28, &x29, x27, x13, x10);
    fiat_secp384r1_addcarryx_u32(&x30, &x31, x29, x11, x8);
    fiat_secp384r1_addcarryx_u32(&x32, &x33, x31, x9, x6);
    fiat_secp384r1_addcarryx_u32(&x34, &x35, x33, x7, x4);
    fiat_secp384r1_addcarryx_u32(&x36, &x37, x35, x5, x2);
    fiat_secp384r1_addcarryx_u32(&x38, &x39, 0x0, x1, x20);
    fiat_secp384r1_addcarryx_u32(&x40, &x41, 0x0, (x39 + x21), (arg1[1]));
    fiat_secp384r1_mulx_u32(&x42, &x43, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x44, &x45, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x46, &x47, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x48, &x49, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x50, &x51, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x52, &x53, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x54, &x55, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x56, &x57, x40, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x58, &x59, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x60, &x61, x40, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x62, &x63, 0x0, x59, x56);
    fiat_secp384r1_addcarryx_u32(&x64, &x65, x63, x57, x54);
    fiat_secp384r1_addcarryx_u32(&x66, &x67, x65, x55, x52);
    fiat_secp384r1_addcarryx_u32(&x68, &x69, x67, x53, x50);
    fiat_secp384r1_addcarryx_u32(&x70, &x71, x69, x51, x48);
    fiat_secp384r1_addcarryx_u32(&x72, &x73, x71, x49, x46);
    fiat_secp384r1_addcarryx_u32(&x74, &x75, x73, x47, x44);
    fiat_secp384r1_addcarryx_u32(&x76, &x77, x75, x45, x42);
    fiat_secp384r1_addcarryx_u32(&x78, &x79, 0x0, x40, x60);
    fiat_secp384r1_addcarryx_u32(&x80, &x81, x79, x41, x61);
    fiat_secp384r1_addcarryx_u32(&x82, &x83, x81, x18, 0x0);
    fiat_secp384r1_addcarryx_u32(&x84, &x85, x83, x22, x58);
    fiat_secp384r1_addcarryx_u32(&x86, &x87, x85, x24, x62);
    fiat_secp384r1_addcarryx_u32(&x88, &x89, x87, x26, x64);
    fiat_secp384r1_addcarryx_u32(&x90, &x91, x89, x28, x66);
    fiat_secp384r1_addcarryx_u32(&x92, &x93, x91, x30, x68);
    fiat_secp384r1_addcarryx_u32(&x94, &x95, x93, x32, x70);
    fiat_secp384r1_addcarryx_u32(&x96, &x97, x95, x34, x72);
    fiat_secp384r1_addcarryx_u32(&x98, &x99, x97, x36, x74);
    fiat_secp384r1_addcarryx_u32(&x100, &x101, x99, (x37 + x3), x76);
    fiat_secp384r1_addcarryx_u32(&x102, &x103, x101, 0x0, (x77 + x43));
    fiat_secp384r1_addcarryx_u32(&x104, &x105, 0x0, x80, (arg1[2]));
    fiat_secp384r1_addcarryx_u32(&x106, &x107, x105, x82, 0x0);
    fiat_secp384r1_addcarryx_u32(&x108, &x109, x107, x84, 0x0);
    fiat_secp384r1_addcarryx_u32(&x110, &x111, x109, x86, 0x0);
    fiat_secp384r1_addcarryx_u32(&x112, &x113, x111, x88, 0x0);
    fiat_secp384r1_addcarryx_u32(&x114, &x115, x113, x90, 0x0);
    fiat_secp384r1_addcarryx_u32(&x116, &x117, x115, x92, 0x0);
    fiat_secp384r1_addcarryx_u32(&x118, &x119, x117, x94, 0x0);
    fiat_secp384r1_addcarryx_u32(&x120, &x121, x119, x96, 0x0);
    fiat_secp384r1_addcarryx_u32(&x122, &x123, x121, x98, 0x0);
    fiat_secp384r1_addcarryx_u32(&x124, &x125, x123, x100, 0x0);
    fiat_secp384r1_addcarryx_u32(&x126, &x127, x125, x102, 0x0);
    fiat_secp384r1_mulx_u32(&x128, &x129, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x130, &x131, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x132, &x133, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x134, &x135, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x136, &x137, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x138, &x139, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x140, &x141, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x142, &x143, x104, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x144, &x145, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x146, &x147, x104, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x148, &x149, 0x0, x145, x142);
    fiat_secp384r1_addcarryx_u32(&x150, &x151, x149, x143, x140);
    fiat_secp384r1_addcarryx_u32(&x152, &x153, x151, x141, x138);
    fiat_secp384r1_addcarryx_u32(&x154, &x155, x153, x139, x136);
    fiat_secp384r1_addcarryx_u32(&x156, &x157, x155, x137, x134);
    fiat_secp384r1_addcarryx_u32(&x158, &x159, x157, x135, x132);
    fiat_secp384r1_addcarryx_u32(&x160, &x161, x159, x133, x130);
    fiat_secp384r1_addcarryx_u32(&x162, &x163, x161, x131, x128);
    fiat_secp384r1_addcarryx_u32(&x164, &x165, 0x0, x104, x146);
    fiat_secp384r1_addcarryx_u32(&x166, &x167, x165, x106, x147);
    fiat_secp384r1_addcarryx_u32(&x168, &x169, x167, x108, 0x0);
    fiat_secp384r1_addcarryx_u32(&x170, &x171, x169, x110, x144);
    fiat_secp384r1_addcarryx_u32(&x172, &x173, x171, x112, x148);
    fiat_secp384r1_addcarryx_u32(&x174, &x175, x173, x114, x150);
    fiat_secp384r1_addcarryx_u32(&x176, &x177, x175, x116, x152);
    fiat_secp384r1_addcarryx_u32(&x178, &x179, x177, x118, x154);
    fiat_secp384r1_addcarryx_u32(&x180, &x181, x179, x120, x156);
    fiat_secp384r1_addcarryx_u32(&x182, &x183, x181, x122, x158);
    fiat_secp384r1_addcarryx_u32(&x184, &x185, x183, x124, x160);
    fiat_secp384r1_addcarryx_u32(&x186, &x187, x185, x126, x162);
    fiat_secp384r1_addcarryx_u32(&x188, &x189, x187, ((uint32_t)x127 + x103),
                                 (x163 + x129));
    fiat_secp384r1_addcarryx_u32(&x190, &x191, 0x0, x166, (arg1[3]));
    fiat_secp384r1_addcarryx_u32(&x192, &x193, x191, x168, 0x0);
    fiat_secp384r1_addcarryx_u32(&x194, &x195, x193, x170, 0x0);
    fiat_secp384r1_addcarryx_u32(&x196, &x197, x195, x172, 0x0);
    fiat_secp384r1_addcarryx_u32(&x198, &x199, x197, x174, 0x0);
    fiat_secp384r1_addcarryx_u32(&x200, &x201, x199, x176, 0x0);
    fiat_secp384r1_addcarryx_u32(&x202, &x203, x201, x178, 0x0);
    fiat_secp384r1_addcarryx_u32(&x204, &x205, x203, x180, 0x0);
    fiat_secp384r1_addcarryx_u32(&x206, &x207, x205, x182, 0x0);
    fiat_secp384r1_addcarryx_u32(&x208, &x209, x207, x184, 0x0);
    fiat_secp384r1_addcarryx_u32(&x210, &x211, x209, x186, 0x0);
    fiat_secp384r1_addcarryx_u32(&x212, &x213, x211, x188, 0x0);
    fiat_secp384r1_mulx_u32(&x214, &x215, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x216, &x217, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x218, &x219, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x220, &x221, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x222, &x223, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x224, &x225, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x226, &x227, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x228, &x229, x190, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x230, &x231, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x232, &x233, x190, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x234, &x235, 0x0, x231, x228);
    fiat_secp384r1_addcarryx_u32(&x236, &x237, x235, x229, x226);
    fiat_secp384r1_addcarryx_u32(&x238, &x239, x237, x227, x224);
    fiat_secp384r1_addcarryx_u32(&x240, &x241, x239, x225, x222);
    fiat_secp384r1_addcarryx_u32(&x242, &x243, x241, x223, x220);
    fiat_secp384r1_addcarryx_u32(&x244, &x245, x243, x221, x218);
    fiat_secp384r1_addcarryx_u32(&x246, &x247, x245, x219, x216);
    fiat_secp384r1_addcarryx_u32(&x248, &x249, x247, x217, x214);
    fiat_secp384r1_addcarryx_u32(&x250, &x251, 0x0, x190, x232);
    fiat_secp384r1_addcarryx_u32(&x252, &x253, x251, x192, x233);
    fiat_secp384r1_addcarryx_u32(&x254, &x255, x253, x194, 0x0);
    fiat_secp384r1_addcarryx_u32(&x256, &x257, x255, x196, x230);
    fiat_secp384r1_addcarryx_u32(&x258, &x259, x257, x198, x234);
    fiat_secp384r1_addcarryx_u32(&x260, &x261, x259, x200, x236);
    fiat_secp384r1_addcarryx_u32(&x262, &x263, x261, x202, x238);
    fiat_secp384r1_addcarryx_u32(&x264, &x265, x263, x204, x240);
    fiat_secp384r1_addcarryx_u32(&x266, &x267, x265, x206, x242);
    fiat_secp384r1_addcarryx_u32(&x268, &x269, x267, x208, x244);
    fiat_secp384r1_addcarryx_u32(&x270, &x271, x269, x210, x246);
    fiat_secp384r1_addcarryx_u32(&x272, &x273, x271, x212, x248);
    fiat_secp384r1_addcarryx_u32(&x274, &x275, x273, ((uint32_t)x213 + x189),
                                 (x249 + x215));
    fiat_secp384r1_addcarryx_u32(&x276, &x277, 0x0, x252, (arg1[4]));
    fiat_secp384r1_addcarryx_u32(&x278, &x279, x277, x254, 0x0);
    fiat_secp384r1_addcarryx_u32(&x280, &x281, x279, x256, 0x0);
    fiat_secp384r1_addcarryx_u32(&x282, &x283, x281, x258, 0x0);
    fiat_secp384r1_addcarryx_u32(&x284, &x285, x283, x260, 0x0);
    fiat_secp384r1_addcarryx_u32(&x286, &x287, x285, x262, 0x0);
    fiat_secp384r1_addcarryx_u32(&x288, &x289, x287, x264, 0x0);
    fiat_secp384r1_addcarryx_u32(&x290, &x291, x289, x266, 0x0);
    fiat_secp384r1_addcarryx_u32(&x292, &x293, x291, x268, 0x0);
    fiat_secp384r1_addcarryx_u32(&x294, &x295, x293, x270, 0x0);
    fiat_secp384r1_addcarryx_u32(&x296, &x297, x295, x272, 0x0);
    fiat_secp384r1_addcarryx_u32(&x298, &x299, x297, x274, 0x0);
    fiat_secp384r1_mulx_u32(&x300, &x301, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x302, &x303, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x304, &x305, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x306, &x307, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x308, &x309, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x310, &x311, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x312, &x313, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x314, &x315, x276, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x316, &x317, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x318, &x319, x276, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x320, &x321, 0x0, x317, x314);
    fiat_secp384r1_addcarryx_u32(&x322, &x323, x321, x315, x312);
    fiat_secp384r1_addcarryx_u32(&x324, &x325, x323, x313, x310);
    fiat_secp384r1_addcarryx_u32(&x326, &x327, x325, x311, x308);
    fiat_secp384r1_addcarryx_u32(&x328, &x329, x327, x309, x306);
    fiat_secp384r1_addcarryx_u32(&x330, &x331, x329, x307, x304);
    fiat_secp384r1_addcarryx_u32(&x332, &x333, x331, x305, x302);
    fiat_secp384r1_addcarryx_u32(&x334, &x335, x333, x303, x300);
    fiat_secp384r1_addcarryx_u32(&x336, &x337, 0x0, x276, x318);
    fiat_secp384r1_addcarryx_u32(&x338, &x339, x337, x278, x319);
    fiat_secp384r1_addcarryx_u32(&x340, &x341, x339, x280, 0x0);
    fiat_secp384r1_addcarryx_u32(&x342, &x343, x341, x282, x316);
    fiat_secp384r1_addcarryx_u32(&x344, &x345, x343, x284, x320);
    fiat_secp384r1_addcarryx_u32(&x346, &x347, x345, x286, x322);
    fiat_secp384r1_addcarryx_u32(&x348, &x349, x347, x288, x324);
    fiat_secp384r1_addcarryx_u32(&x350, &x351, x349, x290, x326);
    fiat_secp384r1_addcarryx_u32(&x352, &x353, x351, x292, x328);
    fiat_secp384r1_addcarryx_u32(&x354, &x355, x353, x294, x330);
    fiat_secp384r1_addcarryx_u32(&x356, &x357, x355, x296, x332);
    fiat_secp384r1_addcarryx_u32(&x358, &x359, x357, x298, x334);
    fiat_secp384r1_addcarryx_u32(&x360, &x361, x359, ((uint32_t)x299 + x275),
                                 (x335 + x301));
    fiat_secp384r1_addcarryx_u32(&x362, &x363, 0x0, x338, (arg1[5]));
    fiat_secp384r1_addcarryx_u32(&x364, &x365, x363, x340, 0x0);
    fiat_secp384r1_addcarryx_u32(&x366, &x367, x365, x342, 0x0);
    fiat_secp384r1_addcarryx_u32(&x368, &x369, x367, x344, 0x0);
    fiat_secp384r1_addcarryx_u32(&x370, &x371, x369, x346, 0x0);
    fiat_secp384r1_addcarryx_u32(&x372, &x373, x371, x348, 0x0);
    fiat_secp384r1_addcarryx_u32(&x374, &x375, x373, x350, 0x0);
    fiat_secp384r1_addcarryx_u32(&x376, &x377, x375, x352, 0x0);
    fiat_secp384r1_addcarryx_u32(&x378, &x379, x377, x354, 0x0);
    fiat_secp384r1_addcarryx_u32(&x380, &x381, x379, x356, 0x0);
    fiat_secp384r1_addcarryx_u32(&x382, &x383, x381, x358, 0x0);
    fiat_secp384r1_addcarryx_u32(&x384, &x385, x383, x360, 0x0);
    fiat_secp384r1_mulx_u32(&x386, &x387, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x388, &x389, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x390, &x391, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x392, &x393, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x394, &x395, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x396, &x397, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x398, &x399, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x400, &x401, x362, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x402, &x403, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x404, &x405, x362, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x406, &x407, 0x0, x403, x400);
    fiat_secp384r1_addcarryx_u32(&x408, &x409, x407, x401, x398);
    fiat_secp384r1_addcarryx_u32(&x410, &x411, x409, x399, x396);
    fiat_secp384r1_addcarryx_u32(&x412, &x413, x411, x397, x394);
    fiat_secp384r1_addcarryx_u32(&x414, &x415, x413, x395, x392);
    fiat_secp384r1_addcarryx_u32(&x416, &x417, x415, x393, x390);
    fiat_secp384r1_addcarryx_u32(&x418, &x419, x417, x391, x388);
    fiat_secp384r1_addcarryx_u32(&x420, &x421, x419, x389, x386);
    fiat_secp384r1_addcarryx_u32(&x422, &x423, 0x0, x362, x404);
    fiat_secp384r1_addcarryx_u32(&x424, &x425, x423, x364, x405);
    fiat_secp384r1_addcarryx_u32(&x426, &x427, x425, x366, 0x0);
    fiat_secp384r1_addcarryx_u32(&x428, &x429, x427, x368, x402);
    fiat_secp384r1_addcarryx_u32(&x430, &x431, x429, x370, x406);
    fiat_secp384r1_addcarryx_u32(&x432, &x433, x431, x372, x408);
    fiat_secp384r1_addcarryx_u32(&x434, &x435, x433, x374, x410);
    fiat_secp384r1_addcarryx_u32(&x436, &x437, x435, x376, x412);
    fiat_secp384r1_addcarryx_u32(&x438, &x439, x437, x378, x414);
    fiat_secp384r1_addcarryx_u32(&x440, &x441, x439, x380, x416);
    fiat_secp384r1_addcarryx_u32(&x442, &x443, x441, x382, x418);
    fiat_secp384r1_addcarryx_u32(&x444, &x445, x443, x384, x420);
    fiat_secp384r1_addcarryx_u32(&x446, &x447, x445, ((uint32_t)x385 + x361),
                                 (x421 + x387));
    fiat_secp384r1_addcarryx_u32(&x448, &x449, 0x0, x424, (arg1[6]));
    fiat_secp384r1_addcarryx_u32(&x450, &x451, x449, x426, 0x0);
    fiat_secp384r1_addcarryx_u32(&x452, &x453, x451, x428, 0x0);
    fiat_secp384r1_addcarryx_u32(&x454, &x455, x453, x430, 0x0);
    fiat_secp384r1_addcarryx_u32(&x456, &x457, x455, x432, 0x0);
    fiat_secp384r1_addcarryx_u32(&x458, &x459, x457, x434, 0x0);
    fiat_secp384r1_addcarryx_u32(&x460, &x461, x459, x436, 0x0);
    fiat_secp384r1_addcarryx_u32(&x462, &x463, x461, x438, 0x0);
    fiat_secp384r1_addcarryx_u32(&x464, &x465, x463, x440, 0x0);
    fiat_secp384r1_addcarryx_u32(&x466, &x467, x465, x442, 0x0);
    fiat_secp384r1_addcarryx_u32(&x468, &x469, x467, x444, 0x0);
    fiat_secp384r1_addcarryx_u32(&x470, &x471, x469, x446, 0x0);
    fiat_secp384r1_mulx_u32(&x472, &x473, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x474, &x475, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x476, &x477, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x478, &x479, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x480, &x481, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x482, &x483, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x484, &x485, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x486, &x487, x448, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x488, &x489, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x490, &x491, x448, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x492, &x493, 0x0, x489, x486);
    fiat_secp384r1_addcarryx_u32(&x494, &x495, x493, x487, x484);
    fiat_secp384r1_addcarryx_u32(&x496, &x497, x495, x485, x482);
    fiat_secp384r1_addcarryx_u32(&x498, &x499, x497, x483, x480);
    fiat_secp384r1_addcarryx_u32(&x500, &x501, x499, x481, x478);
    fiat_secp384r1_addcarryx_u32(&x502, &x503, x501, x479, x476);
    fiat_secp384r1_addcarryx_u32(&x504, &x505, x503, x477, x474);
    fiat_secp384r1_addcarryx_u32(&x506, &x507, x505, x475, x472);
    fiat_secp384r1_addcarryx_u32(&x508, &x509, 0x0, x448, x490);
    fiat_secp384r1_addcarryx_u32(&x510, &x511, x509, x450, x491);
    fiat_secp384r1_addcarryx_u32(&x512, &x513, x511, x452, 0x0);
    fiat_secp384r1_addcarryx_u32(&x514, &x515, x513, x454, x488);
    fiat_secp384r1_addcarryx_u32(&x516, &x517, x515, x456, x492);
    fiat_secp384r1_addcarryx_u32(&x518, &x519, x517, x458, x494);
    fiat_secp384r1_addcarryx_u32(&x520, &x521, x519, x460, x496);
    fiat_secp384r1_addcarryx_u32(&x522, &x523, x521, x462, x498);
    fiat_secp384r1_addcarryx_u32(&x524, &x525, x523, x464, x500);
    fiat_secp384r1_addcarryx_u32(&x526, &x527, x525, x466, x502);
    fiat_secp384r1_addcarryx_u32(&x528, &x529, x527, x468, x504);
    fiat_secp384r1_addcarryx_u32(&x530, &x531, x529, x470, x506);
    fiat_secp384r1_addcarryx_u32(&x532, &x533, x531, ((uint32_t)x471 + x447),
                                 (x507 + x473));
    fiat_secp384r1_addcarryx_u32(&x534, &x535, 0x0, x510, (arg1[7]));
    fiat_secp384r1_addcarryx_u32(&x536, &x537, x535, x512, 0x0);
    fiat_secp384r1_addcarryx_u32(&x538, &x539, x537, x514, 0x0);
    fiat_secp384r1_addcarryx_u32(&x540, &x541, x539, x516, 0x0);
    fiat_secp384r1_addcarryx_u32(&x542, &x543, x541, x518, 0x0);
    fiat_secp384r1_addcarryx_u32(&x544, &x545, x543, x520, 0x0);
    fiat_secp384r1_addcarryx_u32(&x546, &x547, x545, x522, 0x0);
    fiat_secp384r1_addcarryx_u32(&x548, &x549, x547, x524, 0x0);
    fiat_secp384r1_addcarryx_u32(&x550, &x551, x549, x526, 0x0);
    fiat_secp384r1_addcarryx_u32(&x552, &x553, x551, x528, 0x0);
    fiat_secp384r1_addcarryx_u32(&x554, &x555, x553, x530, 0x0);
    fiat_secp384r1_addcarryx_u32(&x556, &x557, x555, x532, 0x0);
    fiat_secp384r1_mulx_u32(&x558, &x559, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x560, &x561, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x562, &x563, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x564, &x565, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x566, &x567, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x568, &x569, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x570, &x571, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x572, &x573, x534, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x574, &x575, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x576, &x577, x534, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x578, &x579, 0x0, x575, x572);
    fiat_secp384r1_addcarryx_u32(&x580, &x581, x579, x573, x570);
    fiat_secp384r1_addcarryx_u32(&x582, &x583, x581, x571, x568);
    fiat_secp384r1_addcarryx_u32(&x584, &x585, x583, x569, x566);
    fiat_secp384r1_addcarryx_u32(&x586, &x587, x585, x567, x564);
    fiat_secp384r1_addcarryx_u32(&x588, &x589, x587, x565, x562);
    fiat_secp384r1_addcarryx_u32(&x590, &x591, x589, x563, x560);
    fiat_secp384r1_addcarryx_u32(&x592, &x593, x591, x561, x558);
    fiat_secp384r1_addcarryx_u32(&x594, &x595, 0x0, x534, x576);
    fiat_secp384r1_addcarryx_u32(&x596, &x597, x595, x536, x577);
    fiat_secp384r1_addcarryx_u32(&x598, &x599, x597, x538, 0x0);
    fiat_secp384r1_addcarryx_u32(&x600, &x601, x599, x540, x574);
    fiat_secp384r1_addcarryx_u32(&x602, &x603, x601, x542, x578);
    fiat_secp384r1_addcarryx_u32(&x604, &x605, x603, x544, x580);
    fiat_secp384r1_addcarryx_u32(&x606, &x607, x605, x546, x582);
    fiat_secp384r1_addcarryx_u32(&x608, &x609, x607, x548, x584);
    fiat_secp384r1_addcarryx_u32(&x610, &x611, x609, x550, x586);
    fiat_secp384r1_addcarryx_u32(&x612, &x613, x611, x552, x588);
    fiat_secp384r1_addcarryx_u32(&x614, &x615, x613, x554, x590);
    fiat_secp384r1_addcarryx_u32(&x616, &x617, x615, x556, x592);
    fiat_secp384r1_addcarryx_u32(&x618, &x619, x617, ((uint32_t)x557 + x533),
                                 (x593 + x559));
    fiat_secp384r1_addcarryx_u32(&x620, &x621, 0x0, x596, (arg1[8]));
    fiat_secp384r1_addcarryx_u32(&x622, &x623, x621, x598, 0x0);
    fiat_secp384r1_addcarryx_u32(&x624, &x625, x623, x600, 0x0);
    fiat_secp384r1_addcarryx_u32(&x626, &x627, x625, x602, 0x0);
    fiat_secp384r1_addcarryx_u32(&x628, &x629, x627, x604, 0x0);
    fiat_secp384r1_addcarryx_u32(&x630, &x631, x629, x606, 0x0);
    fiat_secp384r1_addcarryx_u32(&x632, &x633, x631, x608, 0x0);
    fiat_secp384r1_addcarryx_u32(&x634, &x635, x633, x610, 0x0);
    fiat_secp384r1_addcarryx_u32(&x636, &x637, x635, x612, 0x0);
    fiat_secp384r1_addcarryx_u32(&x638, &x639, x637, x614, 0x0);
    fiat_secp384r1_addcarryx_u32(&x640, &x641, x639, x616, 0x0);
    fiat_secp384r1_addcarryx_u32(&x642, &x643, x641, x618, 0x0);
    fiat_secp384r1_mulx_u32(&x644, &x645, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x646, &x647, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x648, &x649, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x650, &x651, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x652, &x653, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x654, &x655, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x656, &x657, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x658, &x659, x620, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x660, &x661, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x662, &x663, x620, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x664, &x665, 0x0, x661, x658);
    fiat_secp384r1_addcarryx_u32(&x666, &x667, x665, x659, x656);
    fiat_secp384r1_addcarryx_u32(&x668, &x669, x667, x657, x654);
    fiat_secp384r1_addcarryx_u32(&x670, &x671, x669, x655, x652);
    fiat_secp384r1_addcarryx_u32(&x672, &x673, x671, x653, x650);
    fiat_secp384r1_addcarryx_u32(&x674, &x675, x673, x651, x648);
    fiat_secp384r1_addcarryx_u32(&x676, &x677, x675, x649, x646);
    fiat_secp384r1_addcarryx_u32(&x678, &x679, x677, x647, x644);
    fiat_secp384r1_addcarryx_u32(&x680, &x681, 0x0, x620, x662);
    fiat_secp384r1_addcarryx_u32(&x682, &x683, x681, x622, x663);
    fiat_secp384r1_addcarryx_u32(&x684, &x685, x683, x624, 0x0);
    fiat_secp384r1_addcarryx_u32(&x686, &x687, x685, x626, x660);
    fiat_secp384r1_addcarryx_u32(&x688, &x689, x687, x628, x664);
    fiat_secp384r1_addcarryx_u32(&x690, &x691, x689, x630, x666);
    fiat_secp384r1_addcarryx_u32(&x692, &x693, x691, x632, x668);
    fiat_secp384r1_addcarryx_u32(&x694, &x695, x693, x634, x670);
    fiat_secp384r1_addcarryx_u32(&x696, &x697, x695, x636, x672);
    fiat_secp384r1_addcarryx_u32(&x698, &x699, x697, x638, x674);
    fiat_secp384r1_addcarryx_u32(&x700, &x701, x699, x640, x676);
    fiat_secp384r1_addcarryx_u32(&x702, &x703, x701, x642, x678);
    fiat_secp384r1_addcarryx_u32(&x704, &x705, x703, ((uint32_t)x643 + x619),
                                 (x679 + x645));
    fiat_secp384r1_addcarryx_u32(&x706, &x707, 0x0, x682, (arg1[9]));
    fiat_secp384r1_addcarryx_u32(&x708, &x709, x707, x684, 0x0);
    fiat_secp384r1_addcarryx_u32(&x710, &x711, x709, x686, 0x0);
    fiat_secp384r1_addcarryx_u32(&x712, &x713, x711, x688, 0x0);
    fiat_secp384r1_addcarryx_u32(&x714, &x715, x713, x690, 0x0);
    fiat_secp384r1_addcarryx_u32(&x716, &x717, x715, x692, 0x0);
    fiat_secp384r1_addcarryx_u32(&x718, &x719, x717, x694, 0x0);
    fiat_secp384r1_addcarryx_u32(&x720, &x721, x719, x696, 0x0);
    fiat_secp384r1_addcarryx_u32(&x722, &x723, x721, x698, 0x0);
    fiat_secp384r1_addcarryx_u32(&x724, &x725, x723, x700, 0x0);
    fiat_secp384r1_addcarryx_u32(&x726, &x727, x725, x702, 0x0);
    fiat_secp384r1_addcarryx_u32(&x728, &x729, x727, x704, 0x0);
    fiat_secp384r1_mulx_u32(&x730, &x731, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x732, &x733, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x734, &x735, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x736, &x737, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x738, &x739, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x740, &x741, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x742, &x743, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x744, &x745, x706, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x746, &x747, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x748, &x749, x706, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x750, &x751, 0x0, x747, x744);
    fiat_secp384r1_addcarryx_u32(&x752, &x753, x751, x745, x742);
    fiat_secp384r1_addcarryx_u32(&x754, &x755, x753, x743, x740);
    fiat_secp384r1_addcarryx_u32(&x756, &x757, x755, x741, x738);
    fiat_secp384r1_addcarryx_u32(&x758, &x759, x757, x739, x736);
    fiat_secp384r1_addcarryx_u32(&x760, &x761, x759, x737, x734);
    fiat_secp384r1_addcarryx_u32(&x762, &x763, x761, x735, x732);
    fiat_secp384r1_addcarryx_u32(&x764, &x765, x763, x733, x730);
    fiat_secp384r1_addcarryx_u32(&x766, &x767, 0x0, x706, x748);
    fiat_secp384r1_addcarryx_u32(&x768, &x769, x767, x708, x749);
    fiat_secp384r1_addcarryx_u32(&x770, &x771, x769, x710, 0x0);
    fiat_secp384r1_addcarryx_u32(&x772, &x773, x771, x712, x746);
    fiat_secp384r1_addcarryx_u32(&x774, &x775, x773, x714, x750);
    fiat_secp384r1_addcarryx_u32(&x776, &x777, x775, x716, x752);
    fiat_secp384r1_addcarryx_u32(&x778, &x779, x777, x718, x754);
    fiat_secp384r1_addcarryx_u32(&x780, &x781, x779, x720, x756);
    fiat_secp384r1_addcarryx_u32(&x782, &x783, x781, x722, x758);
    fiat_secp384r1_addcarryx_u32(&x784, &x785, x783, x724, x760);
    fiat_secp384r1_addcarryx_u32(&x786, &x787, x785, x726, x762);
    fiat_secp384r1_addcarryx_u32(&x788, &x789, x787, x728, x764);
    fiat_secp384r1_addcarryx_u32(&x790, &x791, x789, ((uint32_t)x729 + x705),
                                 (x765 + x731));
    fiat_secp384r1_addcarryx_u32(&x792, &x793, 0x0, x768, (arg1[10]));
    fiat_secp384r1_addcarryx_u32(&x794, &x795, x793, x770, 0x0);
    fiat_secp384r1_addcarryx_u32(&x796, &x797, x795, x772, 0x0);
    fiat_secp384r1_addcarryx_u32(&x798, &x799, x797, x774, 0x0);
    fiat_secp384r1_addcarryx_u32(&x800, &x801, x799, x776, 0x0);
    fiat_secp384r1_addcarryx_u32(&x802, &x803, x801, x778, 0x0);
    fiat_secp384r1_addcarryx_u32(&x804, &x805, x803, x780, 0x0);
    fiat_secp384r1_addcarryx_u32(&x806, &x807, x805, x782, 0x0);
    fiat_secp384r1_addcarryx_u32(&x808, &x809, x807, x784, 0x0);
    fiat_secp384r1_addcarryx_u32(&x810, &x811, x809, x786, 0x0);
    fiat_secp384r1_addcarryx_u32(&x812, &x813, x811, x788, 0x0);
    fiat_secp384r1_addcarryx_u32(&x814, &x815, x813, x790, 0x0);
    fiat_secp384r1_mulx_u32(&x816, &x817, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x818, &x819, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x820, &x821, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x822, &x823, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x824, &x825, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x826, &x827, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x828, &x829, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x830, &x831, x792, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x832, &x833, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x834, &x835, x792, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x836, &x837, 0x0, x833, x830);
    fiat_secp384r1_addcarryx_u32(&x838, &x839, x837, x831, x828);
    fiat_secp384r1_addcarryx_u32(&x840, &x841, x839, x829, x826);
    fiat_secp384r1_addcarryx_u32(&x842, &x843, x841, x827, x824);
    fiat_secp384r1_addcarryx_u32(&x844, &x845, x843, x825, x822);
    fiat_secp384r1_addcarryx_u32(&x846, &x847, x845, x823, x820);
    fiat_secp384r1_addcarryx_u32(&x848, &x849, x847, x821, x818);
    fiat_secp384r1_addcarryx_u32(&x850, &x851, x849, x819, x816);
    fiat_secp384r1_addcarryx_u32(&x852, &x853, 0x0, x792, x834);
    fiat_secp384r1_addcarryx_u32(&x854, &x855, x853, x794, x835);
    fiat_secp384r1_addcarryx_u32(&x856, &x857, x855, x796, 0x0);
    fiat_secp384r1_addcarryx_u32(&x858, &x859, x857, x798, x832);
    fiat_secp384r1_addcarryx_u32(&x860, &x861, x859, x800, x836);
    fiat_secp384r1_addcarryx_u32(&x862, &x863, x861, x802, x838);
    fiat_secp384r1_addcarryx_u32(&x864, &x865, x863, x804, x840);
    fiat_secp384r1_addcarryx_u32(&x866, &x867, x865, x806, x842);
    fiat_secp384r1_addcarryx_u32(&x868, &x869, x867, x808, x844);
    fiat_secp384r1_addcarryx_u32(&x870, &x871, x869, x810, x846);
    fiat_secp384r1_addcarryx_u32(&x872, &x873, x871, x812, x848);
    fiat_secp384r1_addcarryx_u32(&x874, &x875, x873, x814, x850);
    fiat_secp384r1_addcarryx_u32(&x876, &x877, x875, ((uint32_t)x815 + x791),
                                 (x851 + x817));
    fiat_secp384r1_addcarryx_u32(&x878, &x879, 0x0, x854, (arg1[11]));
    fiat_secp384r1_addcarryx_u32(&x880, &x881, x879, x856, 0x0);
    fiat_secp384r1_addcarryx_u32(&x882, &x883, x881, x858, 0x0);
    fiat_secp384r1_addcarryx_u32(&x884, &x885, x883, x860, 0x0);
    fiat_secp384r1_addcarryx_u32(&x886, &x887, x885, x862, 0x0);
    fiat_secp384r1_addcarryx_u32(&x888, &x889, x887, x864, 0x0);
    fiat_secp384r1_addcarryx_u32(&x890, &x891, x889, x866, 0x0);
    fiat_secp384r1_addcarryx_u32(&x892, &x893, x891, x868, 0x0);
    fiat_secp384r1_addcarryx_u32(&x894, &x895, x893, x870, 0x0);
    fiat_secp384r1_addcarryx_u32(&x896, &x897, x895, x872, 0x0);
    fiat_secp384r1_addcarryx_u32(&x898, &x899, x897, x874, 0x0);
    fiat_secp384r1_addcarryx_u32(&x900, &x901, x899, x876, 0x0);
    fiat_secp384r1_mulx_u32(&x902, &x903, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x904, &x905, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x906, &x907, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x908, &x909, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x910, &x911, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x912, &x913, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x914, &x915, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x916, &x917, x878, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x918, &x919, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x920, &x921, x878, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x922, &x923, 0x0, x919, x916);
    fiat_secp384r1_addcarryx_u32(&x924, &x925, x923, x917, x914);
    fiat_secp384r1_addcarryx_u32(&x926, &x927, x925, x915, x912);
    fiat_secp384r1_addcarryx_u32(&x928, &x929, x927, x913, x910);
    fiat_secp384r1_addcarryx_u32(&x930, &x931, x929, x911, x908);
    fiat_secp384r1_addcarryx_u32(&x932, &x933, x931, x909, x906);
    fiat_secp384r1_addcarryx_u32(&x934, &x935, x933, x907, x904);
    fiat_secp384r1_addcarryx_u32(&x936, &x937, x935, x905, x902);
    fiat_secp384r1_addcarryx_u32(&x938, &x939, 0x0, x878, x920);
    fiat_secp384r1_addcarryx_u32(&x940, &x941, x939, x880, x921);
    fiat_secp384r1_addcarryx_u32(&x942, &x943, x941, x882, 0x0);
    fiat_secp384r1_addcarryx_u32(&x944, &x945, x943, x884, x918);
    fiat_secp384r1_addcarryx_u32(&x946, &x947, x945, x886, x922);
    fiat_secp384r1_addcarryx_u32(&x948, &x949, x947, x888, x924);
    fiat_secp384r1_addcarryx_u32(&x950, &x951, x949, x890, x926);
    fiat_secp384r1_addcarryx_u32(&x952, &x953, x951, x892, x928);
    fiat_secp384r1_addcarryx_u32(&x954, &x955, x953, x894, x930);
    fiat_secp384r1_addcarryx_u32(&x956, &x957, x955, x896, x932);
    fiat_secp384r1_addcarryx_u32(&x958, &x959, x957, x898, x934);
    fiat_secp384r1_addcarryx_u32(&x960, &x961, x959, x900, x936);
    fiat_secp384r1_addcarryx_u32(&x962, &x963, x961, ((uint32_t)x901 + x877),
                                 (x937 + x903));
    fiat_secp384r1_subborrowx_u32(&x964, &x965, 0x0, x940,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x966, &x967, x965, x942, 0x0);
    fiat_secp384r1_subborrowx_u32(&x968, &x969, x967, x944, 0x0);
    fiat_secp384r1_subborrowx_u32(&x970, &x971, x969, x946,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x972, &x973, x971, x948,
                                  UINT32_C(0xfffffffe));
    fiat_secp384r1_subborrowx_u32(&x974, &x975, x973, x950,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x976, &x977, x975, x952,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x978, &x979, x977, x954,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x980, &x981, x979, x956,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x982, &x983, x981, x958,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x984, &x985, x983, x960,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x986, &x987, x985, x962,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x988, &x989, x987, x963, 0x0);
    fiat_secp384r1_cmovznz_u32(&x990, x989, x964, x940);
    fiat_secp384r1_cmovznz_u32(&x991, x989, x966, x942);
    fiat_secp384r1_cmovznz_u32(&x992, x989, x968, x944);
    fiat_secp384r1_cmovznz_u32(&x993, x989, x970, x946);
    fiat_secp384r1_cmovznz_u32(&x994, x989, x972, x948);
    fiat_secp384r1_cmovznz_u32(&x995, x989, x974, x950);
    fiat_secp384r1_cmovznz_u32(&x996, x989, x976, x952);
    fiat_secp384r1_cmovznz_u32(&x997, x989, x978, x954);
    fiat_secp384r1_cmovznz_u32(&x998, x989, x980, x956);
    fiat_secp384r1_cmovznz_u32(&x999, x989, x982, x958);
    fiat_secp384r1_cmovznz_u32(&x1000, x989, x984, x960);
    fiat_secp384r1_cmovznz_u32(&x1001, x989, x986, x962);
    out1[0] = x990;
    out1[1] = x991;
    out1[2] = x992;
    out1[3] = x993;
    out1[4] = x994;
    out1[5] = x995;
    out1[6] = x996;
    out1[7] = x997;
    out1[8] = x998;
    out1[9] = x999;
    out1[10] = x1000;
    out1[11] = x1001;
}

/*
 * The function fiat_secp384r1_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_to_montgomery(uint32_t out1[12],
                             const uint32_t arg1[12])
{
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    fiat_secp384r1_uint1 x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint32_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint32_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    fiat_secp384r1_uint1 x44;
    uint32_t x45;
    fiat_secp384r1_uint1 x46;
    uint32_t x47;
    fiat_secp384r1_uint1 x48;
    uint32_t x49;
    fiat_secp384r1_uint1 x50;
    uint32_t x51;
    fiat_secp384r1_uint1 x52;
    uint32_t x53;
    fiat_secp384r1_uint1 x54;
    uint32_t x55;
    fiat_secp384r1_uint1 x56;
    uint32_t x57;
    fiat_secp384r1_uint1 x58;
    uint32_t x59;
    fiat_secp384r1_uint1 x60;
    uint32_t x61;
    fiat_secp384r1_uint1 x62;
    uint32_t x63;
    fiat_secp384r1_uint1 x64;
    uint32_t x65;
    fiat_secp384r1_uint1 x66;
    uint32_t x67;
    fiat_secp384r1_uint1 x68;
    uint32_t x69;
    fiat_secp384r1_uint1 x70;
    uint32_t x71;
    fiat_secp384r1_uint1 x72;
    uint32_t x73;
    fiat_secp384r1_uint1 x74;
    uint32_t x75;
    fiat_secp384r1_uint1 x76;
    uint32_t x77;
    fiat_secp384r1_uint1 x78;
    uint32_t x79;
    fiat_secp384r1_uint1 x80;
    uint32_t x81;
    fiat_secp384r1_uint1 x82;
    uint32_t x83;
    uint32_t x84;
    uint32_t x85;
    uint32_t x86;
    uint32_t x87;
    uint32_t x88;
    uint32_t x89;
    uint32_t x90;
    uint32_t x91;
    fiat_secp384r1_uint1 x92;
    uint32_t x93;
    fiat_secp384r1_uint1 x94;
    uint32_t x95;
    fiat_secp384r1_uint1 x96;
    uint32_t x97;
    fiat_secp384r1_uint1 x98;
    uint32_t x99;
    fiat_secp384r1_uint1 x100;
    uint32_t x101;
    fiat_secp384r1_uint1 x102;
    uint32_t x103;
    fiat_secp384r1_uint1 x104;
    uint32_t x105;
    fiat_secp384r1_uint1 x106;
    uint32_t x107;
    fiat_secp384r1_uint1 x108;
    uint32_t x109;
    fiat_secp384r1_uint1 x110;
    uint32_t x111;
    fiat_secp384r1_uint1 x112;
    uint32_t x113;
    fiat_secp384r1_uint1 x114;
    uint32_t x115;
    fiat_secp384r1_uint1 x116;
    uint32_t x117;
    uint32_t x118;
    uint32_t x119;
    uint32_t x120;
    uint32_t x121;
    uint32_t x122;
    uint32_t x123;
    uint32_t x124;
    uint32_t x125;
    uint32_t x126;
    uint32_t x127;
    uint32_t x128;
    uint32_t x129;
    uint32_t x130;
    uint32_t x131;
    uint32_t x132;
    uint32_t x133;
    uint32_t x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    fiat_secp384r1_uint1 x138;
    uint32_t x139;
    fiat_secp384r1_uint1 x140;
    uint32_t x141;
    fiat_secp384r1_uint1 x142;
    uint32_t x143;
    fiat_secp384r1_uint1 x144;
    uint32_t x145;
    fiat_secp384r1_uint1 x146;
    uint32_t x147;
    fiat_secp384r1_uint1 x148;
    uint32_t x149;
    fiat_secp384r1_uint1 x150;
    uint32_t x151;
    fiat_secp384r1_uint1 x152;
    uint32_t x153;
    fiat_secp384r1_uint1 x154;
    uint32_t x155;
    fiat_secp384r1_uint1 x156;
    uint32_t x157;
    fiat_secp384r1_uint1 x158;
    uint32_t x159;
    fiat_secp384r1_uint1 x160;
    uint32_t x161;
    fiat_secp384r1_uint1 x162;
    uint32_t x163;
    fiat_secp384r1_uint1 x164;
    uint32_t x165;
    fiat_secp384r1_uint1 x166;
    uint32_t x167;
    fiat_secp384r1_uint1 x168;
    uint32_t x169;
    fiat_secp384r1_uint1 x170;
    uint32_t x171;
    fiat_secp384r1_uint1 x172;
    uint32_t x173;
    fiat_secp384r1_uint1 x174;
    uint32_t x175;
    fiat_secp384r1_uint1 x176;
    uint32_t x177;
    fiat_secp384r1_uint1 x178;
    uint32_t x179;
    uint32_t x180;
    uint32_t x181;
    uint32_t x182;
    uint32_t x183;
    uint32_t x184;
    uint32_t x185;
    uint32_t x186;
    uint32_t x187;
    fiat_secp384r1_uint1 x188;
    uint32_t x189;
    fiat_secp384r1_uint1 x190;
    uint32_t x191;
    fiat_secp384r1_uint1 x192;
    uint32_t x193;
    fiat_secp384r1_uint1 x194;
    uint32_t x195;
    fiat_secp384r1_uint1 x196;
    uint32_t x197;
    fiat_secp384r1_uint1 x198;
    uint32_t x199;
    fiat_secp384r1_uint1 x200;
    uint32_t x201;
    fiat_secp384r1_uint1 x202;
    uint32_t x203;
    fiat_secp384r1_uint1 x204;
    uint32_t x205;
    fiat_secp384r1_uint1 x206;
    uint32_t x207;
    fiat_secp384r1_uint1 x208;
    uint32_t x209;
    fiat_secp384r1_uint1 x210;
    uint32_t x211;
    fiat_secp384r1_uint1 x212;
    uint32_t x213;
    uint32_t x214;
    uint32_t x215;
    uint32_t x216;
    uint32_t x217;
    uint32_t x218;
    uint32_t x219;
    uint32_t x220;
    uint32_t x221;
    uint32_t x222;
    uint32_t x223;
    uint32_t x224;
    uint32_t x225;
    uint32_t x226;
    uint32_t x227;
    uint32_t x228;
    uint32_t x229;
    uint32_t x230;
    uint32_t x231;
    uint32_t x232;
    uint32_t x233;
    fiat_secp384r1_uint1 x234;
    uint32_t x235;
    fiat_secp384r1_uint1 x236;
    uint32_t x237;
    fiat_secp384r1_uint1 x238;
    uint32_t x239;
    fiat_secp384r1_uint1 x240;
    uint32_t x241;
    fiat_secp384r1_uint1 x242;
    uint32_t x243;
    fiat_secp384r1_uint1 x244;
    uint32_t x245;
    fiat_secp384r1_uint1 x246;
    uint32_t x247;
    fiat_secp384r1_uint1 x248;
    uint32_t x249;
    fiat_secp384r1_uint1 x250;
    uint32_t x251;
    fiat_secp384r1_uint1 x252;
    uint32_t x253;
    fiat_secp384r1_uint1 x254;
    uint32_t x255;
    fiat_secp384r1_uint1 x256;
    uint32_t x257;
    fiat_secp384r1_uint1 x258;
    uint32_t x259;
    fiat_secp384r1_uint1 x260;
    uint32_t x261;
    fiat_secp384r1_uint1 x262;
    uint32_t x263;
    fiat_secp384r1_uint1 x264;
    uint32_t x265;
    fiat_secp384r1_uint1 x266;
    uint32_t x267;
    fiat_secp384r1_uint1 x268;
    uint32_t x269;
    fiat_secp384r1_uint1 x270;
    uint32_t x271;
    fiat_secp384r1_uint1 x272;
    uint32_t x273;
    fiat_secp384r1_uint1 x274;
    uint32_t x275;
    uint32_t x276;
    uint32_t x277;
    uint32_t x278;
    uint32_t x279;
    uint32_t x280;
    uint32_t x281;
    uint32_t x282;
    uint32_t x283;
    fiat_secp384r1_uint1 x284;
    uint32_t x285;
    fiat_secp384r1_uint1 x286;
    uint32_t x287;
    fiat_secp384r1_uint1 x288;
    uint32_t x289;
    fiat_secp384r1_uint1 x290;
    uint32_t x291;
    fiat_secp384r1_uint1 x292;
    uint32_t x293;
    fiat_secp384r1_uint1 x294;
    uint32_t x295;
    fiat_secp384r1_uint1 x296;
    uint32_t x297;
    fiat_secp384r1_uint1 x298;
    uint32_t x299;
    fiat_secp384r1_uint1 x300;
    uint32_t x301;
    fiat_secp384r1_uint1 x302;
    uint32_t x303;
    fiat_secp384r1_uint1 x304;
    uint32_t x305;
    fiat_secp384r1_uint1 x306;
    uint32_t x307;
    fiat_secp384r1_uint1 x308;
    uint32_t x309;
    uint32_t x310;
    uint32_t x311;
    uint32_t x312;
    uint32_t x313;
    uint32_t x314;
    uint32_t x315;
    uint32_t x316;
    uint32_t x317;
    uint32_t x318;
    uint32_t x319;
    uint32_t x320;
    uint32_t x321;
    uint32_t x322;
    uint32_t x323;
    uint32_t x324;
    uint32_t x325;
    uint32_t x326;
    uint32_t x327;
    uint32_t x328;
    uint32_t x329;
    fiat_secp384r1_uint1 x330;
    uint32_t x331;
    fiat_secp384r1_uint1 x332;
    uint32_t x333;
    fiat_secp384r1_uint1 x334;
    uint32_t x335;
    fiat_secp384r1_uint1 x336;
    uint32_t x337;
    fiat_secp384r1_uint1 x338;
    uint32_t x339;
    fiat_secp384r1_uint1 x340;
    uint32_t x341;
    fiat_secp384r1_uint1 x342;
    uint32_t x343;
    fiat_secp384r1_uint1 x344;
    uint32_t x345;
    fiat_secp384r1_uint1 x346;
    uint32_t x347;
    fiat_secp384r1_uint1 x348;
    uint32_t x349;
    fiat_secp384r1_uint1 x350;
    uint32_t x351;
    fiat_secp384r1_uint1 x352;
    uint32_t x353;
    fiat_secp384r1_uint1 x354;
    uint32_t x355;
    fiat_secp384r1_uint1 x356;
    uint32_t x357;
    fiat_secp384r1_uint1 x358;
    uint32_t x359;
    fiat_secp384r1_uint1 x360;
    uint32_t x361;
    fiat_secp384r1_uint1 x362;
    uint32_t x363;
    fiat_secp384r1_uint1 x364;
    uint32_t x365;
    fiat_secp384r1_uint1 x366;
    uint32_t x367;
    fiat_secp384r1_uint1 x368;
    uint32_t x369;
    fiat_secp384r1_uint1 x370;
    uint32_t x371;
    uint32_t x372;
    uint32_t x373;
    uint32_t x374;
    uint32_t x375;
    uint32_t x376;
    uint32_t x377;
    uint32_t x378;
    uint32_t x379;
    fiat_secp384r1_uint1 x380;
    uint32_t x381;
    fiat_secp384r1_uint1 x382;
    uint32_t x383;
    fiat_secp384r1_uint1 x384;
    uint32_t x385;
    fiat_secp384r1_uint1 x386;
    uint32_t x387;
    fiat_secp384r1_uint1 x388;
    uint32_t x389;
    fiat_secp384r1_uint1 x390;
    uint32_t x391;
    fiat_secp384r1_uint1 x392;
    uint32_t x393;
    fiat_secp384r1_uint1 x394;
    uint32_t x395;
    fiat_secp384r1_uint1 x396;
    uint32_t x397;
    fiat_secp384r1_uint1 x398;
    uint32_t x399;
    fiat_secp384r1_uint1 x400;
    uint32_t x401;
    fiat_secp384r1_uint1 x402;
    uint32_t x403;
    fiat_secp384r1_uint1 x404;
    uint32_t x405;
    uint32_t x406;
    uint32_t x407;
    uint32_t x408;
    uint32_t x409;
    uint32_t x410;
    uint32_t x411;
    uint32_t x412;
    uint32_t x413;
    uint32_t x414;
    uint32_t x415;
    uint32_t x416;
    uint32_t x417;
    uint32_t x418;
    uint32_t x419;
    uint32_t x420;
    uint32_t x421;
    uint32_t x422;
    uint32_t x423;
    uint32_t x424;
    uint32_t x425;
    fiat_secp384r1_uint1 x426;
    uint32_t x427;
    fiat_secp384r1_uint1 x428;
    uint32_t x429;
    fiat_secp384r1_uint1 x430;
    uint32_t x431;
    fiat_secp384r1_uint1 x432;
    uint32_t x433;
    fiat_secp384r1_uint1 x434;
    uint32_t x435;
    fiat_secp384r1_uint1 x436;
    uint32_t x437;
    fiat_secp384r1_uint1 x438;
    uint32_t x439;
    fiat_secp384r1_uint1 x440;
    uint32_t x441;
    fiat_secp384r1_uint1 x442;
    uint32_t x443;
    fiat_secp384r1_uint1 x444;
    uint32_t x445;
    fiat_secp384r1_uint1 x446;
    uint32_t x447;
    fiat_secp384r1_uint1 x448;
    uint32_t x449;
    fiat_secp384r1_uint1 x450;
    uint32_t x451;
    fiat_secp384r1_uint1 x452;
    uint32_t x453;
    fiat_secp384r1_uint1 x454;
    uint32_t x455;
    fiat_secp384r1_uint1 x456;
    uint32_t x457;
    fiat_secp384r1_uint1 x458;
    uint32_t x459;
    fiat_secp384r1_uint1 x460;
    uint32_t x461;
    fiat_secp384r1_uint1 x462;
    uint32_t x463;
    fiat_secp384r1_uint1 x464;
    uint32_t x465;
    fiat_secp384r1_uint1 x466;
    uint32_t x467;
    uint32_t x468;
    uint32_t x469;
    uint32_t x470;
    uint32_t x471;
    uint32_t x472;
    uint32_t x473;
    uint32_t x474;
    uint32_t x475;
    fiat_secp384r1_uint1 x476;
    uint32_t x477;
    fiat_secp384r1_uint1 x478;
    uint32_t x479;
    fiat_secp384r1_uint1 x480;
    uint32_t x481;
    fiat_secp384r1_uint1 x482;
    uint32_t x483;
    fiat_secp384r1_uint1 x484;
    uint32_t x485;
    fiat_secp384r1_uint1 x486;
    uint32_t x487;
    fiat_secp384r1_uint1 x488;
    uint32_t x489;
    fiat_secp384r1_uint1 x490;
    uint32_t x491;
    fiat_secp384r1_uint1 x492;
    uint32_t x493;
    fiat_secp384r1_uint1 x494;
    uint32_t x495;
    fiat_secp384r1_uint1 x496;
    uint32_t x497;
    fiat_secp384r1_uint1 x498;
    uint32_t x499;
    fiat_secp384r1_uint1 x500;
    uint32_t x501;
    uint32_t x502;
    uint32_t x503;
    uint32_t x504;
    uint32_t x505;
    uint32_t x506;
    uint32_t x507;
    uint32_t x508;
    uint32_t x509;
    uint32_t x510;
    uint32_t x511;
    uint32_t x512;
    uint32_t x513;
    uint32_t x514;
    uint32_t x515;
    uint32_t x516;
    uint32_t x517;
    uint32_t x518;
    uint32_t x519;
    uint32_t x520;
    uint32_t x521;
    fiat_secp384r1_uint1 x522;
    uint32_t x523;
    fiat_secp384r1_uint1 x524;
    uint32_t x525;
    fiat_secp384r1_uint1 x526;
    uint32_t x527;
    fiat_secp384r1_uint1 x528;
    uint32_t x529;
    fiat_secp384r1_uint1 x530;
    uint32_t x531;
    fiat_secp384r1_uint1 x532;
    uint32_t x533;
    fiat_secp384r1_uint1 x534;
    uint32_t x535;
    fiat_secp384r1_uint1 x536;
    uint32_t x537;
    fiat_secp384r1_uint1 x538;
    uint32_t x539;
    fiat_secp384r1_uint1 x540;
    uint32_t x541;
    fiat_secp384r1_uint1 x542;
    uint32_t x543;
    fiat_secp384r1_uint1 x544;
    uint32_t x545;
    fiat_secp384r1_uint1 x546;
    uint32_t x547;
    fiat_secp384r1_uint1 x548;
    uint32_t x549;
    fiat_secp384r1_uint1 x550;
    uint32_t x551;
    fiat_secp384r1_uint1 x552;
    uint32_t x553;
    fiat_secp384r1_uint1 x554;
    uint32_t x555;
    fiat_secp384r1_uint1 x556;
    uint32_t x557;
    fiat_secp384r1_uint1 x558;
    uint32_t x559;
    fiat_secp384r1_uint1 x560;
    uint32_t x561;
    fiat_secp384r1_uint1 x562;
    uint32_t x563;
    uint32_t x564;
    uint32_t x565;
    uint32_t x566;
    uint32_t x567;
    uint32_t x568;
    uint32_t x569;
    uint32_t x570;
    uint32_t x571;
    fiat_secp384r1_uint1 x572;
    uint32_t x573;
    fiat_secp384r1_uint1 x574;
    uint32_t x575;
    fiat_secp384r1_uint1 x576;
    uint32_t x577;
    fiat_secp384r1_uint1 x578;
    uint32_t x579;
    fiat_secp384r1_uint1 x580;
    uint32_t x581;
    fiat_secp384r1_uint1 x582;
    uint32_t x583;
    fiat_secp384r1_uint1 x584;
    uint32_t x585;
    fiat_secp384r1_uint1 x586;
    uint32_t x587;
    fiat_secp384r1_uint1 x588;
    uint32_t x589;
    fiat_secp384r1_uint1 x590;
    uint32_t x591;
    fiat_secp384r1_uint1 x592;
    uint32_t x593;
    fiat_secp384r1_uint1 x594;
    uint32_t x595;
    fiat_secp384r1_uint1 x596;
    uint32_t x597;
    uint32_t x598;
    uint32_t x599;
    uint32_t x600;
    uint32_t x601;
    uint32_t x602;
    uint32_t x603;
    uint32_t x604;
    uint32_t x605;
    uint32_t x606;
    uint32_t x607;
    uint32_t x608;
    uint32_t x609;
    uint32_t x610;
    uint32_t x611;
    uint32_t x612;
    uint32_t x613;
    uint32_t x614;
    uint32_t x615;
    uint32_t x616;
    uint32_t x617;
    fiat_secp384r1_uint1 x618;
    uint32_t x619;
    fiat_secp384r1_uint1 x620;
    uint32_t x621;
    fiat_secp384r1_uint1 x622;
    uint32_t x623;
    fiat_secp384r1_uint1 x624;
    uint32_t x625;
    fiat_secp384r1_uint1 x626;
    uint32_t x627;
    fiat_secp384r1_uint1 x628;
    uint32_t x629;
    fiat_secp384r1_uint1 x630;
    uint32_t x631;
    fiat_secp384r1_uint1 x632;
    uint32_t x633;
    fiat_secp384r1_uint1 x634;
    uint32_t x635;
    fiat_secp384r1_uint1 x636;
    uint32_t x637;
    fiat_secp384r1_uint1 x638;
    uint32_t x639;
    fiat_secp384r1_uint1 x640;
    uint32_t x641;
    fiat_secp384r1_uint1 x642;
    uint32_t x643;
    fiat_secp384r1_uint1 x644;
    uint32_t x645;
    fiat_secp384r1_uint1 x646;
    uint32_t x647;
    fiat_secp384r1_uint1 x648;
    uint32_t x649;
    fiat_secp384r1_uint1 x650;
    uint32_t x651;
    fiat_secp384r1_uint1 x652;
    uint32_t x653;
    fiat_secp384r1_uint1 x654;
    uint32_t x655;
    fiat_secp384r1_uint1 x656;
    uint32_t x657;
    fiat_secp384r1_uint1 x658;
    uint32_t x659;
    uint32_t x660;
    uint32_t x661;
    uint32_t x662;
    uint32_t x663;
    uint32_t x664;
    uint32_t x665;
    uint32_t x666;
    uint32_t x667;
    fiat_secp384r1_uint1 x668;
    uint32_t x669;
    fiat_secp384r1_uint1 x670;
    uint32_t x671;
    fiat_secp384r1_uint1 x672;
    uint32_t x673;
    fiat_secp384r1_uint1 x674;
    uint32_t x675;
    fiat_secp384r1_uint1 x676;
    uint32_t x677;
    fiat_secp384r1_uint1 x678;
    uint32_t x679;
    fiat_secp384r1_uint1 x680;
    uint32_t x681;
    fiat_secp384r1_uint1 x682;
    uint32_t x683;
    fiat_secp384r1_uint1 x684;
    uint32_t x685;
    fiat_secp384r1_uint1 x686;
    uint32_t x687;
    fiat_secp384r1_uint1 x688;
    uint32_t x689;
    fiat_secp384r1_uint1 x690;
    uint32_t x691;
    fiat_secp384r1_uint1 x692;
    uint32_t x693;
    uint32_t x694;
    uint32_t x695;
    uint32_t x696;
    uint32_t x697;
    uint32_t x698;
    uint32_t x699;
    uint32_t x700;
    uint32_t x701;
    uint32_t x702;
    uint32_t x703;
    uint32_t x704;
    uint32_t x705;
    uint32_t x706;
    uint32_t x707;
    uint32_t x708;
    uint32_t x709;
    uint32_t x710;
    uint32_t x711;
    uint32_t x712;
    uint32_t x713;
    fiat_secp384r1_uint1 x714;
    uint32_t x715;
    fiat_secp384r1_uint1 x716;
    uint32_t x717;
    fiat_secp384r1_uint1 x718;
    uint32_t x719;
    fiat_secp384r1_uint1 x720;
    uint32_t x721;
    fiat_secp384r1_uint1 x722;
    uint32_t x723;
    fiat_secp384r1_uint1 x724;
    uint32_t x725;
    fiat_secp384r1_uint1 x726;
    uint32_t x727;
    fiat_secp384r1_uint1 x728;
    uint32_t x729;
    fiat_secp384r1_uint1 x730;
    uint32_t x731;
    fiat_secp384r1_uint1 x732;
    uint32_t x733;
    fiat_secp384r1_uint1 x734;
    uint32_t x735;
    fiat_secp384r1_uint1 x736;
    uint32_t x737;
    fiat_secp384r1_uint1 x738;
    uint32_t x739;
    fiat_secp384r1_uint1 x740;
    uint32_t x741;
    fiat_secp384r1_uint1 x742;
    uint32_t x743;
    fiat_secp384r1_uint1 x744;
    uint32_t x745;
    fiat_secp384r1_uint1 x746;
    uint32_t x747;
    fiat_secp384r1_uint1 x748;
    uint32_t x749;
    fiat_secp384r1_uint1 x750;
    uint32_t x751;
    fiat_secp384r1_uint1 x752;
    uint32_t x753;
    fiat_secp384r1_uint1 x754;
    uint32_t x755;
    uint32_t x756;
    uint32_t x757;
    uint32_t x758;
    uint32_t x759;
    uint32_t x760;
    uint32_t x761;
    uint32_t x762;
    uint32_t x763;
    fiat_secp384r1_uint1 x764;
    uint32_t x765;
    fiat_secp384r1_uint1 x766;
    uint32_t x767;
    fiat_secp384r1_uint1 x768;
    uint32_t x769;
    fiat_secp384r1_uint1 x770;
    uint32_t x771;
    fiat_secp384r1_uint1 x772;
    uint32_t x773;
    fiat_secp384r1_uint1 x774;
    uint32_t x775;
    fiat_secp384r1_uint1 x776;
    uint32_t x777;
    fiat_secp384r1_uint1 x778;
    uint32_t x779;
    fiat_secp384r1_uint1 x780;
    uint32_t x781;
    fiat_secp384r1_uint1 x782;
    uint32_t x783;
    fiat_secp384r1_uint1 x784;
    uint32_t x785;
    fiat_secp384r1_uint1 x786;
    uint32_t x787;
    fiat_secp384r1_uint1 x788;
    uint32_t x789;
    uint32_t x790;
    uint32_t x791;
    uint32_t x792;
    uint32_t x793;
    uint32_t x794;
    uint32_t x795;
    uint32_t x796;
    uint32_t x797;
    uint32_t x798;
    uint32_t x799;
    uint32_t x800;
    uint32_t x801;
    uint32_t x802;
    uint32_t x803;
    uint32_t x804;
    uint32_t x805;
    uint32_t x806;
    uint32_t x807;
    uint32_t x808;
    uint32_t x809;
    fiat_secp384r1_uint1 x810;
    uint32_t x811;
    fiat_secp384r1_uint1 x812;
    uint32_t x813;
    fiat_secp384r1_uint1 x814;
    uint32_t x815;
    fiat_secp384r1_uint1 x816;
    uint32_t x817;
    fiat_secp384r1_uint1 x818;
    uint32_t x819;
    fiat_secp384r1_uint1 x820;
    uint32_t x821;
    fiat_secp384r1_uint1 x822;
    uint32_t x823;
    fiat_secp384r1_uint1 x824;
    uint32_t x825;
    fiat_secp384r1_uint1 x826;
    uint32_t x827;
    fiat_secp384r1_uint1 x828;
    uint32_t x829;
    fiat_secp384r1_uint1 x830;
    uint32_t x831;
    fiat_secp384r1_uint1 x832;
    uint32_t x833;
    fiat_secp384r1_uint1 x834;
    uint32_t x835;
    fiat_secp384r1_uint1 x836;
    uint32_t x837;
    fiat_secp384r1_uint1 x838;
    uint32_t x839;
    fiat_secp384r1_uint1 x840;
    uint32_t x841;
    fiat_secp384r1_uint1 x842;
    uint32_t x843;
    fiat_secp384r1_uint1 x844;
    uint32_t x845;
    fiat_secp384r1_uint1 x846;
    uint32_t x847;
    fiat_secp384r1_uint1 x848;
    uint32_t x849;
    fiat_secp384r1_uint1 x850;
    uint32_t x851;
    uint32_t x852;
    uint32_t x853;
    uint32_t x854;
    uint32_t x855;
    uint32_t x856;
    uint32_t x857;
    uint32_t x858;
    uint32_t x859;
    fiat_secp384r1_uint1 x860;
    uint32_t x861;
    fiat_secp384r1_uint1 x862;
    uint32_t x863;
    fiat_secp384r1_uint1 x864;
    uint32_t x865;
    fiat_secp384r1_uint1 x866;
    uint32_t x867;
    fiat_secp384r1_uint1 x868;
    uint32_t x869;
    fiat_secp384r1_uint1 x870;
    uint32_t x871;
    fiat_secp384r1_uint1 x872;
    uint32_t x873;
    fiat_secp384r1_uint1 x874;
    uint32_t x875;
    fiat_secp384r1_uint1 x876;
    uint32_t x877;
    fiat_secp384r1_uint1 x878;
    uint32_t x879;
    fiat_secp384r1_uint1 x880;
    uint32_t x881;
    fiat_secp384r1_uint1 x882;
    uint32_t x883;
    fiat_secp384r1_uint1 x884;
    uint32_t x885;
    uint32_t x886;
    uint32_t x887;
    uint32_t x888;
    uint32_t x889;
    uint32_t x890;
    uint32_t x891;
    uint32_t x892;
    uint32_t x893;
    uint32_t x894;
    uint32_t x895;
    uint32_t x896;
    uint32_t x897;
    uint32_t x898;
    uint32_t x899;
    uint32_t x900;
    uint32_t x901;
    uint32_t x902;
    uint32_t x903;
    uint32_t x904;
    uint32_t x905;
    fiat_secp384r1_uint1 x906;
    uint32_t x907;
    fiat_secp384r1_uint1 x908;
    uint32_t x909;
    fiat_secp384r1_uint1 x910;
    uint32_t x911;
    fiat_secp384r1_uint1 x912;
    uint32_t x913;
    fiat_secp384r1_uint1 x914;
    uint32_t x915;
    fiat_secp384r1_uint1 x916;
    uint32_t x917;
    fiat_secp384r1_uint1 x918;
    uint32_t x919;
    fiat_secp384r1_uint1 x920;
    uint32_t x921;
    fiat_secp384r1_uint1 x922;
    uint32_t x923;
    fiat_secp384r1_uint1 x924;
    uint32_t x925;
    fiat_secp384r1_uint1 x926;
    uint32_t x927;
    fiat_secp384r1_uint1 x928;
    uint32_t x929;
    fiat_secp384r1_uint1 x930;
    uint32_t x931;
    fiat_secp384r1_uint1 x932;
    uint32_t x933;
    fiat_secp384r1_uint1 x934;
    uint32_t x935;
    fiat_secp384r1_uint1 x936;
    uint32_t x937;
    fiat_secp384r1_uint1 x938;
    uint32_t x939;
    fiat_secp384r1_uint1 x940;
    uint32_t x941;
    fiat_secp384r1_uint1 x942;
    uint32_t x943;
    fiat_secp384r1_uint1 x944;
    uint32_t x945;
    fiat_secp384r1_uint1 x946;
    uint32_t x947;
    uint32_t x948;
    uint32_t x949;
    uint32_t x950;
    uint32_t x951;
    uint32_t x952;
    uint32_t x953;
    uint32_t x954;
    uint32_t x955;
    fiat_secp384r1_uint1 x956;
    uint32_t x957;
    fiat_secp384r1_uint1 x958;
    uint32_t x959;
    fiat_secp384r1_uint1 x960;
    uint32_t x961;
    fiat_secp384r1_uint1 x962;
    uint32_t x963;
    fiat_secp384r1_uint1 x964;
    uint32_t x965;
    fiat_secp384r1_uint1 x966;
    uint32_t x967;
    fiat_secp384r1_uint1 x968;
    uint32_t x969;
    fiat_secp384r1_uint1 x970;
    uint32_t x971;
    fiat_secp384r1_uint1 x972;
    uint32_t x973;
    fiat_secp384r1_uint1 x974;
    uint32_t x975;
    fiat_secp384r1_uint1 x976;
    uint32_t x977;
    fiat_secp384r1_uint1 x978;
    uint32_t x979;
    fiat_secp384r1_uint1 x980;
    uint32_t x981;
    uint32_t x982;
    uint32_t x983;
    uint32_t x984;
    uint32_t x985;
    uint32_t x986;
    uint32_t x987;
    uint32_t x988;
    uint32_t x989;
    uint32_t x990;
    uint32_t x991;
    uint32_t x992;
    uint32_t x993;
    uint32_t x994;
    uint32_t x995;
    uint32_t x996;
    uint32_t x997;
    uint32_t x998;
    uint32_t x999;
    uint32_t x1000;
    uint32_t x1001;
    fiat_secp384r1_uint1 x1002;
    uint32_t x1003;
    fiat_secp384r1_uint1 x1004;
    uint32_t x1005;
    fiat_secp384r1_uint1 x1006;
    uint32_t x1007;
    fiat_secp384r1_uint1 x1008;
    uint32_t x1009;
    fiat_secp384r1_uint1 x1010;
    uint32_t x1011;
    fiat_secp384r1_uint1 x1012;
    uint32_t x1013;
    fiat_secp384r1_uint1 x1014;
    uint32_t x1015;
    fiat_secp384r1_uint1 x1016;
    uint32_t x1017;
    fiat_secp384r1_uint1 x1018;
    uint32_t x1019;
    fiat_secp384r1_uint1 x1020;
    uint32_t x1021;
    fiat_secp384r1_uint1 x1022;
    uint32_t x1023;
    fiat_secp384r1_uint1 x1024;
    uint32_t x1025;
    fiat_secp384r1_uint1 x1026;
    uint32_t x1027;
    fiat_secp384r1_uint1 x1028;
    uint32_t x1029;
    fiat_secp384r1_uint1 x1030;
    uint32_t x1031;
    fiat_secp384r1_uint1 x1032;
    uint32_t x1033;
    fiat_secp384r1_uint1 x1034;
    uint32_t x1035;
    fiat_secp384r1_uint1 x1036;
    uint32_t x1037;
    fiat_secp384r1_uint1 x1038;
    uint32_t x1039;
    fiat_secp384r1_uint1 x1040;
    uint32_t x1041;
    fiat_secp384r1_uint1 x1042;
    uint32_t x1043;
    uint32_t x1044;
    uint32_t x1045;
    uint32_t x1046;
    uint32_t x1047;
    uint32_t x1048;
    uint32_t x1049;
    uint32_t x1050;
    uint32_t x1051;
    fiat_secp384r1_uint1 x1052;
    uint32_t x1053;
    fiat_secp384r1_uint1 x1054;
    uint32_t x1055;
    fiat_secp384r1_uint1 x1056;
    uint32_t x1057;
    fiat_secp384r1_uint1 x1058;
    uint32_t x1059;
    fiat_secp384r1_uint1 x1060;
    uint32_t x1061;
    fiat_secp384r1_uint1 x1062;
    uint32_t x1063;
    fiat_secp384r1_uint1 x1064;
    uint32_t x1065;
    fiat_secp384r1_uint1 x1066;
    uint32_t x1067;
    fiat_secp384r1_uint1 x1068;
    uint32_t x1069;
    fiat_secp384r1_uint1 x1070;
    uint32_t x1071;
    fiat_secp384r1_uint1 x1072;
    uint32_t x1073;
    fiat_secp384r1_uint1 x1074;
    uint32_t x1075;
    fiat_secp384r1_uint1 x1076;
    uint32_t x1077;
    uint32_t x1078;
    uint32_t x1079;
    uint32_t x1080;
    uint32_t x1081;
    uint32_t x1082;
    uint32_t x1083;
    uint32_t x1084;
    uint32_t x1085;
    uint32_t x1086;
    uint32_t x1087;
    uint32_t x1088;
    uint32_t x1089;
    uint32_t x1090;
    uint32_t x1091;
    uint32_t x1092;
    uint32_t x1093;
    uint32_t x1094;
    uint32_t x1095;
    uint32_t x1096;
    uint32_t x1097;
    fiat_secp384r1_uint1 x1098;
    uint32_t x1099;
    fiat_secp384r1_uint1 x1100;
    uint32_t x1101;
    fiat_secp384r1_uint1 x1102;
    uint32_t x1103;
    fiat_secp384r1_uint1 x1104;
    uint32_t x1105;
    fiat_secp384r1_uint1 x1106;
    uint32_t x1107;
    fiat_secp384r1_uint1 x1108;
    uint32_t x1109;
    fiat_secp384r1_uint1 x1110;
    uint32_t x1111;
    fiat_secp384r1_uint1 x1112;
    uint32_t x1113;
    fiat_secp384r1_uint1 x1114;
    uint32_t x1115;
    fiat_secp384r1_uint1 x1116;
    uint32_t x1117;
    fiat_secp384r1_uint1 x1118;
    uint32_t x1119;
    fiat_secp384r1_uint1 x1120;
    uint32_t x1121;
    fiat_secp384r1_uint1 x1122;
    uint32_t x1123;
    fiat_secp384r1_uint1 x1124;
    uint32_t x1125;
    fiat_secp384r1_uint1 x1126;
    uint32_t x1127;
    fiat_secp384r1_uint1 x1128;
    uint32_t x1129;
    fiat_secp384r1_uint1 x1130;
    uint32_t x1131;
    fiat_secp384r1_uint1 x1132;
    uint32_t x1133;
    fiat_secp384r1_uint1 x1134;
    uint32_t x1135;
    fiat_secp384r1_uint1 x1136;
    uint32_t x1137;
    fiat_secp384r1_uint1 x1138;
    uint32_t x1139;
    fiat_secp384r1_uint1 x1140;
    uint32_t x1141;
    fiat_secp384r1_uint1 x1142;
    uint32_t x1143;
    fiat_secp384r1_uint1 x1144;
    uint32_t x1145;
    fiat_secp384r1_uint1 x1146;
    uint32_t x1147;
    fiat_secp384r1_uint1 x1148;
    uint32_t x1149;
    fiat_secp384r1_uint1 x1150;
    uint32_t x1151;
    fiat_secp384r1_uint1 x1152;
    uint32_t x1153;
    fiat_secp384r1_uint1 x1154;
    uint32_t x1155;
    fiat_secp384r1_uint1 x1156;
    uint32_t x1157;
    fiat_secp384r1_uint1 x1158;
    uint32_t x1159;
    fiat_secp384r1_uint1 x1160;
    uint32_t x1161;
    fiat_secp384r1_uint1 x1162;
    uint32_t x1163;
    fiat_secp384r1_uint1 x1164;
    uint32_t x1165;
    uint32_t x1166;
    uint32_t x1167;
    uint32_t x1168;
    uint32_t x1169;
    uint32_t x1170;
    uint32_t x1171;
    uint32_t x1172;
    uint32_t x1173;
    uint32_t x1174;
    uint32_t x1175;
    uint32_t x1176;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[8]);
    x9 = (arg1[9]);
    x10 = (arg1[10]);
    x11 = (arg1[11]);
    x12 = (arg1[0]);
    fiat_secp384r1_mulx_u32(&x13, &x14, x12, 0x2);
    fiat_secp384r1_mulx_u32(&x15, &x16, x12, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x17, &x18, x12, 0x2);
    fiat_secp384r1_mulx_u32(&x19, &x20, x12, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x21, &x22, 0x0, (fiat_secp384r1_uint1)x14,
                                 x12);
    fiat_secp384r1_mulx_u32(&x23, &x24, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x25, &x26, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x27, &x28, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x29, &x30, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x31, &x32, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x33, &x34, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x35, &x36, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x37, &x38, x12, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x39, &x40, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x41, &x42, x12, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x43, &x44, 0x0, x40, x37);
    fiat_secp384r1_addcarryx_u32(&x45, &x46, x44, x38, x35);
    fiat_secp384r1_addcarryx_u32(&x47, &x48, x46, x36, x33);
    fiat_secp384r1_addcarryx_u32(&x49, &x50, x48, x34, x31);
    fiat_secp384r1_addcarryx_u32(&x51, &x52, x50, x32, x29);
    fiat_secp384r1_addcarryx_u32(&x53, &x54, x52, x30, x27);
    fiat_secp384r1_addcarryx_u32(&x55, &x56, x54, x28, x25);
    fiat_secp384r1_addcarryx_u32(&x57, &x58, x56, x26, x23);
    fiat_secp384r1_addcarryx_u32(&x59, &x60, 0x0, x12, x41);
    fiat_secp384r1_addcarryx_u32(&x61, &x62, x60, x19, x42);
    fiat_secp384r1_addcarryx_u32(&x63, &x64, 0x0, x17, x39);
    fiat_secp384r1_addcarryx_u32(&x65, &x66, x64, (fiat_secp384r1_uint1)x18,
                                 x43);
    fiat_secp384r1_addcarryx_u32(&x67, &x68, x66, x15, x45);
    fiat_secp384r1_addcarryx_u32(&x69, &x70, x68, x16, x47);
    fiat_secp384r1_addcarryx_u32(&x71, &x72, x70, x13, x49);
    fiat_secp384r1_addcarryx_u32(&x73, &x74, x72, x21, x51);
    fiat_secp384r1_addcarryx_u32(&x75, &x76, x74, x22, x53);
    fiat_secp384r1_addcarryx_u32(&x77, &x78, x76, 0x0, x55);
    fiat_secp384r1_addcarryx_u32(&x79, &x80, x78, 0x0, x57);
    fiat_secp384r1_addcarryx_u32(&x81, &x82, x80, 0x0, (x58 + x24));
    fiat_secp384r1_mulx_u32(&x83, &x84, x1, 0x2);
    fiat_secp384r1_mulx_u32(&x85, &x86, x1, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x87, &x88, x1, 0x2);
    fiat_secp384r1_mulx_u32(&x89, &x90, x1, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x91, &x92, 0x0, (fiat_secp384r1_uint1)x84,
                                 x1);
    fiat_secp384r1_addcarryx_u32(&x93, &x94, 0x0, x61, x1);
    fiat_secp384r1_addcarryx_u32(&x95, &x96, x94, (x62 + x20), x89);
    fiat_secp384r1_addcarryx_u32(&x97, &x98, x96, x63, x90);
    fiat_secp384r1_addcarryx_u32(&x99, &x100, x98, x65, x87);
    fiat_secp384r1_addcarryx_u32(&x101, &x102, x100, x67,
                                 (fiat_secp384r1_uint1)x88);
    fiat_secp384r1_addcarryx_u32(&x103, &x104, x102, x69, x85);
    fiat_secp384r1_addcarryx_u32(&x105, &x106, x104, x71, x86);
    fiat_secp384r1_addcarryx_u32(&x107, &x108, x106, x73, x83);
    fiat_secp384r1_addcarryx_u32(&x109, &x110, x108, x75, x91);
    fiat_secp384r1_addcarryx_u32(&x111, &x112, x110, x77, x92);
    fiat_secp384r1_addcarryx_u32(&x113, &x114, x112, x79, 0x0);
    fiat_secp384r1_addcarryx_u32(&x115, &x116, x114, x81, 0x0);
    fiat_secp384r1_mulx_u32(&x117, &x118, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x119, &x120, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x121, &x122, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x123, &x124, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x125, &x126, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x127, &x128, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x129, &x130, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x131, &x132, x93, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x133, &x134, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x135, &x136, x93, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x137, &x138, 0x0, x134, x131);
    fiat_secp384r1_addcarryx_u32(&x139, &x140, x138, x132, x129);
    fiat_secp384r1_addcarryx_u32(&x141, &x142, x140, x130, x127);
    fiat_secp384r1_addcarryx_u32(&x143, &x144, x142, x128, x125);
    fiat_secp384r1_addcarryx_u32(&x145, &x146, x144, x126, x123);
    fiat_secp384r1_addcarryx_u32(&x147, &x148, x146, x124, x121);
    fiat_secp384r1_addcarryx_u32(&x149, &x150, x148, x122, x119);
    fiat_secp384r1_addcarryx_u32(&x151, &x152, x150, x120, x117);
    fiat_secp384r1_addcarryx_u32(&x153, &x154, 0x0, x93, x135);
    fiat_secp384r1_addcarryx_u32(&x155, &x156, x154, x95, x136);
    fiat_secp384r1_addcarryx_u32(&x157, &x158, x156, x97, 0x0);
    fiat_secp384r1_addcarryx_u32(&x159, &x160, x158, x99, x133);
    fiat_secp384r1_addcarryx_u32(&x161, &x162, x160, x101, x137);
    fiat_secp384r1_addcarryx_u32(&x163, &x164, x162, x103, x139);
    fiat_secp384r1_addcarryx_u32(&x165, &x166, x164, x105, x141);
    fiat_secp384r1_addcarryx_u32(&x167, &x168, x166, x107, x143);
    fiat_secp384r1_addcarryx_u32(&x169, &x170, x168, x109, x145);
    fiat_secp384r1_addcarryx_u32(&x171, &x172, x170, x111, x147);
    fiat_secp384r1_addcarryx_u32(&x173, &x174, x172, x113, x149);
    fiat_secp384r1_addcarryx_u32(&x175, &x176, x174, x115, x151);
    fiat_secp384r1_addcarryx_u32(&x177, &x178, x176, ((uint32_t)x116 + x82),
                                 (x152 + x118));
    fiat_secp384r1_mulx_u32(&x179, &x180, x2, 0x2);
    fiat_secp384r1_mulx_u32(&x181, &x182, x2, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x183, &x184, x2, 0x2);
    fiat_secp384r1_mulx_u32(&x185, &x186, x2, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x187, &x188, 0x0, (fiat_secp384r1_uint1)x180,
                                 x2);
    fiat_secp384r1_addcarryx_u32(&x189, &x190, 0x0, x155, x2);
    fiat_secp384r1_addcarryx_u32(&x191, &x192, x190, x157, x185);
    fiat_secp384r1_addcarryx_u32(&x193, &x194, x192, x159, x186);
    fiat_secp384r1_addcarryx_u32(&x195, &x196, x194, x161, x183);
    fiat_secp384r1_addcarryx_u32(&x197, &x198, x196, x163,
                                 (fiat_secp384r1_uint1)x184);
    fiat_secp384r1_addcarryx_u32(&x199, &x200, x198, x165, x181);
    fiat_secp384r1_addcarryx_u32(&x201, &x202, x200, x167, x182);
    fiat_secp384r1_addcarryx_u32(&x203, &x204, x202, x169, x179);
    fiat_secp384r1_addcarryx_u32(&x205, &x206, x204, x171, x187);
    fiat_secp384r1_addcarryx_u32(&x207, &x208, x206, x173, x188);
    fiat_secp384r1_addcarryx_u32(&x209, &x210, x208, x175, 0x0);
    fiat_secp384r1_addcarryx_u32(&x211, &x212, x210, x177, 0x0);
    fiat_secp384r1_mulx_u32(&x213, &x214, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x215, &x216, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x217, &x218, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x219, &x220, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x221, &x222, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x223, &x224, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x225, &x226, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x227, &x228, x189, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x229, &x230, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x231, &x232, x189, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x233, &x234, 0x0, x230, x227);
    fiat_secp384r1_addcarryx_u32(&x235, &x236, x234, x228, x225);
    fiat_secp384r1_addcarryx_u32(&x237, &x238, x236, x226, x223);
    fiat_secp384r1_addcarryx_u32(&x239, &x240, x238, x224, x221);
    fiat_secp384r1_addcarryx_u32(&x241, &x242, x240, x222, x219);
    fiat_secp384r1_addcarryx_u32(&x243, &x244, x242, x220, x217);
    fiat_secp384r1_addcarryx_u32(&x245, &x246, x244, x218, x215);
    fiat_secp384r1_addcarryx_u32(&x247, &x248, x246, x216, x213);
    fiat_secp384r1_addcarryx_u32(&x249, &x250, 0x0, x189, x231);
    fiat_secp384r1_addcarryx_u32(&x251, &x252, x250, x191, x232);
    fiat_secp384r1_addcarryx_u32(&x253, &x254, x252, x193, 0x0);
    fiat_secp384r1_addcarryx_u32(&x255, &x256, x254, x195, x229);
    fiat_secp384r1_addcarryx_u32(&x257, &x258, x256, x197, x233);
    fiat_secp384r1_addcarryx_u32(&x259, &x260, x258, x199, x235);
    fiat_secp384r1_addcarryx_u32(&x261, &x262, x260, x201, x237);
    fiat_secp384r1_addcarryx_u32(&x263, &x264, x262, x203, x239);
    fiat_secp384r1_addcarryx_u32(&x265, &x266, x264, x205, x241);
    fiat_secp384r1_addcarryx_u32(&x267, &x268, x266, x207, x243);
    fiat_secp384r1_addcarryx_u32(&x269, &x270, x268, x209, x245);
    fiat_secp384r1_addcarryx_u32(&x271, &x272, x270, x211, x247);
    fiat_secp384r1_addcarryx_u32(&x273, &x274, x272, ((uint32_t)x212 + x178),
                                 (x248 + x214));
    fiat_secp384r1_mulx_u32(&x275, &x276, x3, 0x2);
    fiat_secp384r1_mulx_u32(&x277, &x278, x3, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x279, &x280, x3, 0x2);
    fiat_secp384r1_mulx_u32(&x281, &x282, x3, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x283, &x284, 0x0, (fiat_secp384r1_uint1)x276,
                                 x3);
    fiat_secp384r1_addcarryx_u32(&x285, &x286, 0x0, x251, x3);
    fiat_secp384r1_addcarryx_u32(&x287, &x288, x286, x253, x281);
    fiat_secp384r1_addcarryx_u32(&x289, &x290, x288, x255, x282);
    fiat_secp384r1_addcarryx_u32(&x291, &x292, x290, x257, x279);
    fiat_secp384r1_addcarryx_u32(&x293, &x294, x292, x259,
                                 (fiat_secp384r1_uint1)x280);
    fiat_secp384r1_addcarryx_u32(&x295, &x296, x294, x261, x277);
    fiat_secp384r1_addcarryx_u32(&x297, &x298, x296, x263, x278);
    fiat_secp384r1_addcarryx_u32(&x299, &x300, x298, x265, x275);
    fiat_secp384r1_addcarryx_u32(&x301, &x302, x300, x267, x283);
    fiat_secp384r1_addcarryx_u32(&x303, &x304, x302, x269, x284);
    fiat_secp384r1_addcarryx_u32(&x305, &x306, x304, x271, 0x0);
    fiat_secp384r1_addcarryx_u32(&x307, &x308, x306, x273, 0x0);
    fiat_secp384r1_mulx_u32(&x309, &x310, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x311, &x312, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x313, &x314, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x315, &x316, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x317, &x318, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x319, &x320, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x321, &x322, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x323, &x324, x285, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x325, &x326, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x327, &x328, x285, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x329, &x330, 0x0, x326, x323);
    fiat_secp384r1_addcarryx_u32(&x331, &x332, x330, x324, x321);
    fiat_secp384r1_addcarryx_u32(&x333, &x334, x332, x322, x319);
    fiat_secp384r1_addcarryx_u32(&x335, &x336, x334, x320, x317);
    fiat_secp384r1_addcarryx_u32(&x337, &x338, x336, x318, x315);
    fiat_secp384r1_addcarryx_u32(&x339, &x340, x338, x316, x313);
    fiat_secp384r1_addcarryx_u32(&x341, &x342, x340, x314, x311);
    fiat_secp384r1_addcarryx_u32(&x343, &x344, x342, x312, x309);
    fiat_secp384r1_addcarryx_u32(&x345, &x346, 0x0, x285, x327);
    fiat_secp384r1_addcarryx_u32(&x347, &x348, x346, x287, x328);
    fiat_secp384r1_addcarryx_u32(&x349, &x350, x348, x289, 0x0);
    fiat_secp384r1_addcarryx_u32(&x351, &x352, x350, x291, x325);
    fiat_secp384r1_addcarryx_u32(&x353, &x354, x352, x293, x329);
    fiat_secp384r1_addcarryx_u32(&x355, &x356, x354, x295, x331);
    fiat_secp384r1_addcarryx_u32(&x357, &x358, x356, x297, x333);
    fiat_secp384r1_addcarryx_u32(&x359, &x360, x358, x299, x335);
    fiat_secp384r1_addcarryx_u32(&x361, &x362, x360, x301, x337);
    fiat_secp384r1_addcarryx_u32(&x363, &x364, x362, x303, x339);
    fiat_secp384r1_addcarryx_u32(&x365, &x366, x364, x305, x341);
    fiat_secp384r1_addcarryx_u32(&x367, &x368, x366, x307, x343);
    fiat_secp384r1_addcarryx_u32(&x369, &x370, x368, ((uint32_t)x308 + x274),
                                 (x344 + x310));
    fiat_secp384r1_mulx_u32(&x371, &x372, x4, 0x2);
    fiat_secp384r1_mulx_u32(&x373, &x374, x4, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x375, &x376, x4, 0x2);
    fiat_secp384r1_mulx_u32(&x377, &x378, x4, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x379, &x380, 0x0, (fiat_secp384r1_uint1)x372,
                                 x4);
    fiat_secp384r1_addcarryx_u32(&x381, &x382, 0x0, x347, x4);
    fiat_secp384r1_addcarryx_u32(&x383, &x384, x382, x349, x377);
    fiat_secp384r1_addcarryx_u32(&x385, &x386, x384, x351, x378);
    fiat_secp384r1_addcarryx_u32(&x387, &x388, x386, x353, x375);
    fiat_secp384r1_addcarryx_u32(&x389, &x390, x388, x355,
                                 (fiat_secp384r1_uint1)x376);
    fiat_secp384r1_addcarryx_u32(&x391, &x392, x390, x357, x373);
    fiat_secp384r1_addcarryx_u32(&x393, &x394, x392, x359, x374);
    fiat_secp384r1_addcarryx_u32(&x395, &x396, x394, x361, x371);
    fiat_secp384r1_addcarryx_u32(&x397, &x398, x396, x363, x379);
    fiat_secp384r1_addcarryx_u32(&x399, &x400, x398, x365, x380);
    fiat_secp384r1_addcarryx_u32(&x401, &x402, x400, x367, 0x0);
    fiat_secp384r1_addcarryx_u32(&x403, &x404, x402, x369, 0x0);
    fiat_secp384r1_mulx_u32(&x405, &x406, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x407, &x408, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x409, &x410, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x411, &x412, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x413, &x414, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x415, &x416, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x417, &x418, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x419, &x420, x381, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x421, &x422, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x423, &x424, x381, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x425, &x426, 0x0, x422, x419);
    fiat_secp384r1_addcarryx_u32(&x427, &x428, x426, x420, x417);
    fiat_secp384r1_addcarryx_u32(&x429, &x430, x428, x418, x415);
    fiat_secp384r1_addcarryx_u32(&x431, &x432, x430, x416, x413);
    fiat_secp384r1_addcarryx_u32(&x433, &x434, x432, x414, x411);
    fiat_secp384r1_addcarryx_u32(&x435, &x436, x434, x412, x409);
    fiat_secp384r1_addcarryx_u32(&x437, &x438, x436, x410, x407);
    fiat_secp384r1_addcarryx_u32(&x439, &x440, x438, x408, x405);
    fiat_secp384r1_addcarryx_u32(&x441, &x442, 0x0, x381, x423);
    fiat_secp384r1_addcarryx_u32(&x443, &x444, x442, x383, x424);
    fiat_secp384r1_addcarryx_u32(&x445, &x446, x444, x385, 0x0);
    fiat_secp384r1_addcarryx_u32(&x447, &x448, x446, x387, x421);
    fiat_secp384r1_addcarryx_u32(&x449, &x450, x448, x389, x425);
    fiat_secp384r1_addcarryx_u32(&x451, &x452, x450, x391, x427);
    fiat_secp384r1_addcarryx_u32(&x453, &x454, x452, x393, x429);
    fiat_secp384r1_addcarryx_u32(&x455, &x456, x454, x395, x431);
    fiat_secp384r1_addcarryx_u32(&x457, &x458, x456, x397, x433);
    fiat_secp384r1_addcarryx_u32(&x459, &x460, x458, x399, x435);
    fiat_secp384r1_addcarryx_u32(&x461, &x462, x460, x401, x437);
    fiat_secp384r1_addcarryx_u32(&x463, &x464, x462, x403, x439);
    fiat_secp384r1_addcarryx_u32(&x465, &x466, x464, ((uint32_t)x404 + x370),
                                 (x440 + x406));
    fiat_secp384r1_mulx_u32(&x467, &x468, x5, 0x2);
    fiat_secp384r1_mulx_u32(&x469, &x470, x5, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x471, &x472, x5, 0x2);
    fiat_secp384r1_mulx_u32(&x473, &x474, x5, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x475, &x476, 0x0, (fiat_secp384r1_uint1)x468,
                                 x5);
    fiat_secp384r1_addcarryx_u32(&x477, &x478, 0x0, x443, x5);
    fiat_secp384r1_addcarryx_u32(&x479, &x480, x478, x445, x473);
    fiat_secp384r1_addcarryx_u32(&x481, &x482, x480, x447, x474);
    fiat_secp384r1_addcarryx_u32(&x483, &x484, x482, x449, x471);
    fiat_secp384r1_addcarryx_u32(&x485, &x486, x484, x451,
                                 (fiat_secp384r1_uint1)x472);
    fiat_secp384r1_addcarryx_u32(&x487, &x488, x486, x453, x469);
    fiat_secp384r1_addcarryx_u32(&x489, &x490, x488, x455, x470);
    fiat_secp384r1_addcarryx_u32(&x491, &x492, x490, x457, x467);
    fiat_secp384r1_addcarryx_u32(&x493, &x494, x492, x459, x475);
    fiat_secp384r1_addcarryx_u32(&x495, &x496, x494, x461, x476);
    fiat_secp384r1_addcarryx_u32(&x497, &x498, x496, x463, 0x0);
    fiat_secp384r1_addcarryx_u32(&x499, &x500, x498, x465, 0x0);
    fiat_secp384r1_mulx_u32(&x501, &x502, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x503, &x504, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x505, &x506, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x507, &x508, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x509, &x510, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x511, &x512, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x513, &x514, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x515, &x516, x477, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x517, &x518, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x519, &x520, x477, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x521, &x522, 0x0, x518, x515);
    fiat_secp384r1_addcarryx_u32(&x523, &x524, x522, x516, x513);
    fiat_secp384r1_addcarryx_u32(&x525, &x526, x524, x514, x511);
    fiat_secp384r1_addcarryx_u32(&x527, &x528, x526, x512, x509);
    fiat_secp384r1_addcarryx_u32(&x529, &x530, x528, x510, x507);
    fiat_secp384r1_addcarryx_u32(&x531, &x532, x530, x508, x505);
    fiat_secp384r1_addcarryx_u32(&x533, &x534, x532, x506, x503);
    fiat_secp384r1_addcarryx_u32(&x535, &x536, x534, x504, x501);
    fiat_secp384r1_addcarryx_u32(&x537, &x538, 0x0, x477, x519);
    fiat_secp384r1_addcarryx_u32(&x539, &x540, x538, x479, x520);
    fiat_secp384r1_addcarryx_u32(&x541, &x542, x540, x481, 0x0);
    fiat_secp384r1_addcarryx_u32(&x543, &x544, x542, x483, x517);
    fiat_secp384r1_addcarryx_u32(&x545, &x546, x544, x485, x521);
    fiat_secp384r1_addcarryx_u32(&x547, &x548, x546, x487, x523);
    fiat_secp384r1_addcarryx_u32(&x549, &x550, x548, x489, x525);
    fiat_secp384r1_addcarryx_u32(&x551, &x552, x550, x491, x527);
    fiat_secp384r1_addcarryx_u32(&x553, &x554, x552, x493, x529);
    fiat_secp384r1_addcarryx_u32(&x555, &x556, x554, x495, x531);
    fiat_secp384r1_addcarryx_u32(&x557, &x558, x556, x497, x533);
    fiat_secp384r1_addcarryx_u32(&x559, &x560, x558, x499, x535);
    fiat_secp384r1_addcarryx_u32(&x561, &x562, x560, ((uint32_t)x500 + x466),
                                 (x536 + x502));
    fiat_secp384r1_mulx_u32(&x563, &x564, x6, 0x2);
    fiat_secp384r1_mulx_u32(&x565, &x566, x6, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x567, &x568, x6, 0x2);
    fiat_secp384r1_mulx_u32(&x569, &x570, x6, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x571, &x572, 0x0, (fiat_secp384r1_uint1)x564,
                                 x6);
    fiat_secp384r1_addcarryx_u32(&x573, &x574, 0x0, x539, x6);
    fiat_secp384r1_addcarryx_u32(&x575, &x576, x574, x541, x569);
    fiat_secp384r1_addcarryx_u32(&x577, &x578, x576, x543, x570);
    fiat_secp384r1_addcarryx_u32(&x579, &x580, x578, x545, x567);
    fiat_secp384r1_addcarryx_u32(&x581, &x582, x580, x547,
                                 (fiat_secp384r1_uint1)x568);
    fiat_secp384r1_addcarryx_u32(&x583, &x584, x582, x549, x565);
    fiat_secp384r1_addcarryx_u32(&x585, &x586, x584, x551, x566);
    fiat_secp384r1_addcarryx_u32(&x587, &x588, x586, x553, x563);
    fiat_secp384r1_addcarryx_u32(&x589, &x590, x588, x555, x571);
    fiat_secp384r1_addcarryx_u32(&x591, &x592, x590, x557, x572);
    fiat_secp384r1_addcarryx_u32(&x593, &x594, x592, x559, 0x0);
    fiat_secp384r1_addcarryx_u32(&x595, &x596, x594, x561, 0x0);
    fiat_secp384r1_mulx_u32(&x597, &x598, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x599, &x600, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x601, &x602, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x603, &x604, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x605, &x606, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x607, &x608, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x609, &x610, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x611, &x612, x573, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x613, &x614, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x615, &x616, x573, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x617, &x618, 0x0, x614, x611);
    fiat_secp384r1_addcarryx_u32(&x619, &x620, x618, x612, x609);
    fiat_secp384r1_addcarryx_u32(&x621, &x622, x620, x610, x607);
    fiat_secp384r1_addcarryx_u32(&x623, &x624, x622, x608, x605);
    fiat_secp384r1_addcarryx_u32(&x625, &x626, x624, x606, x603);
    fiat_secp384r1_addcarryx_u32(&x627, &x628, x626, x604, x601);
    fiat_secp384r1_addcarryx_u32(&x629, &x630, x628, x602, x599);
    fiat_secp384r1_addcarryx_u32(&x631, &x632, x630, x600, x597);
    fiat_secp384r1_addcarryx_u32(&x633, &x634, 0x0, x573, x615);
    fiat_secp384r1_addcarryx_u32(&x635, &x636, x634, x575, x616);
    fiat_secp384r1_addcarryx_u32(&x637, &x638, x636, x577, 0x0);
    fiat_secp384r1_addcarryx_u32(&x639, &x640, x638, x579, x613);
    fiat_secp384r1_addcarryx_u32(&x641, &x642, x640, x581, x617);
    fiat_secp384r1_addcarryx_u32(&x643, &x644, x642, x583, x619);
    fiat_secp384r1_addcarryx_u32(&x645, &x646, x644, x585, x621);
    fiat_secp384r1_addcarryx_u32(&x647, &x648, x646, x587, x623);
    fiat_secp384r1_addcarryx_u32(&x649, &x650, x648, x589, x625);
    fiat_secp384r1_addcarryx_u32(&x651, &x652, x650, x591, x627);
    fiat_secp384r1_addcarryx_u32(&x653, &x654, x652, x593, x629);
    fiat_secp384r1_addcarryx_u32(&x655, &x656, x654, x595, x631);
    fiat_secp384r1_addcarryx_u32(&x657, &x658, x656, ((uint32_t)x596 + x562),
                                 (x632 + x598));
    fiat_secp384r1_mulx_u32(&x659, &x660, x7, 0x2);
    fiat_secp384r1_mulx_u32(&x661, &x662, x7, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x663, &x664, x7, 0x2);
    fiat_secp384r1_mulx_u32(&x665, &x666, x7, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x667, &x668, 0x0, (fiat_secp384r1_uint1)x660,
                                 x7);
    fiat_secp384r1_addcarryx_u32(&x669, &x670, 0x0, x635, x7);
    fiat_secp384r1_addcarryx_u32(&x671, &x672, x670, x637, x665);
    fiat_secp384r1_addcarryx_u32(&x673, &x674, x672, x639, x666);
    fiat_secp384r1_addcarryx_u32(&x675, &x676, x674, x641, x663);
    fiat_secp384r1_addcarryx_u32(&x677, &x678, x676, x643,
                                 (fiat_secp384r1_uint1)x664);
    fiat_secp384r1_addcarryx_u32(&x679, &x680, x678, x645, x661);
    fiat_secp384r1_addcarryx_u32(&x681, &x682, x680, x647, x662);
    fiat_secp384r1_addcarryx_u32(&x683, &x684, x682, x649, x659);
    fiat_secp384r1_addcarryx_u32(&x685, &x686, x684, x651, x667);
    fiat_secp384r1_addcarryx_u32(&x687, &x688, x686, x653, x668);
    fiat_secp384r1_addcarryx_u32(&x689, &x690, x688, x655, 0x0);
    fiat_secp384r1_addcarryx_u32(&x691, &x692, x690, x657, 0x0);
    fiat_secp384r1_mulx_u32(&x693, &x694, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x695, &x696, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x697, &x698, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x699, &x700, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x701, &x702, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x703, &x704, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x705, &x706, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x707, &x708, x669, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x709, &x710, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x711, &x712, x669, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x713, &x714, 0x0, x710, x707);
    fiat_secp384r1_addcarryx_u32(&x715, &x716, x714, x708, x705);
    fiat_secp384r1_addcarryx_u32(&x717, &x718, x716, x706, x703);
    fiat_secp384r1_addcarryx_u32(&x719, &x720, x718, x704, x701);
    fiat_secp384r1_addcarryx_u32(&x721, &x722, x720, x702, x699);
    fiat_secp384r1_addcarryx_u32(&x723, &x724, x722, x700, x697);
    fiat_secp384r1_addcarryx_u32(&x725, &x726, x724, x698, x695);
    fiat_secp384r1_addcarryx_u32(&x727, &x728, x726, x696, x693);
    fiat_secp384r1_addcarryx_u32(&x729, &x730, 0x0, x669, x711);
    fiat_secp384r1_addcarryx_u32(&x731, &x732, x730, x671, x712);
    fiat_secp384r1_addcarryx_u32(&x733, &x734, x732, x673, 0x0);
    fiat_secp384r1_addcarryx_u32(&x735, &x736, x734, x675, x709);
    fiat_secp384r1_addcarryx_u32(&x737, &x738, x736, x677, x713);
    fiat_secp384r1_addcarryx_u32(&x739, &x740, x738, x679, x715);
    fiat_secp384r1_addcarryx_u32(&x741, &x742, x740, x681, x717);
    fiat_secp384r1_addcarryx_u32(&x743, &x744, x742, x683, x719);
    fiat_secp384r1_addcarryx_u32(&x745, &x746, x744, x685, x721);
    fiat_secp384r1_addcarryx_u32(&x747, &x748, x746, x687, x723);
    fiat_secp384r1_addcarryx_u32(&x749, &x750, x748, x689, x725);
    fiat_secp384r1_addcarryx_u32(&x751, &x752, x750, x691, x727);
    fiat_secp384r1_addcarryx_u32(&x753, &x754, x752, ((uint32_t)x692 + x658),
                                 (x728 + x694));
    fiat_secp384r1_mulx_u32(&x755, &x756, x8, 0x2);
    fiat_secp384r1_mulx_u32(&x757, &x758, x8, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x759, &x760, x8, 0x2);
    fiat_secp384r1_mulx_u32(&x761, &x762, x8, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x763, &x764, 0x0, (fiat_secp384r1_uint1)x756,
                                 x8);
    fiat_secp384r1_addcarryx_u32(&x765, &x766, 0x0, x731, x8);
    fiat_secp384r1_addcarryx_u32(&x767, &x768, x766, x733, x761);
    fiat_secp384r1_addcarryx_u32(&x769, &x770, x768, x735, x762);
    fiat_secp384r1_addcarryx_u32(&x771, &x772, x770, x737, x759);
    fiat_secp384r1_addcarryx_u32(&x773, &x774, x772, x739,
                                 (fiat_secp384r1_uint1)x760);
    fiat_secp384r1_addcarryx_u32(&x775, &x776, x774, x741, x757);
    fiat_secp384r1_addcarryx_u32(&x777, &x778, x776, x743, x758);
    fiat_secp384r1_addcarryx_u32(&x779, &x780, x778, x745, x755);
    fiat_secp384r1_addcarryx_u32(&x781, &x782, x780, x747, x763);
    fiat_secp384r1_addcarryx_u32(&x783, &x784, x782, x749, x764);
    fiat_secp384r1_addcarryx_u32(&x785, &x786, x784, x751, 0x0);
    fiat_secp384r1_addcarryx_u32(&x787, &x788, x786, x753, 0x0);
    fiat_secp384r1_mulx_u32(&x789, &x790, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x791, &x792, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x793, &x794, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x795, &x796, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x797, &x798, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x799, &x800, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x801, &x802, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x803, &x804, x765, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x805, &x806, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x807, &x808, x765, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x809, &x810, 0x0, x806, x803);
    fiat_secp384r1_addcarryx_u32(&x811, &x812, x810, x804, x801);
    fiat_secp384r1_addcarryx_u32(&x813, &x814, x812, x802, x799);
    fiat_secp384r1_addcarryx_u32(&x815, &x816, x814, x800, x797);
    fiat_secp384r1_addcarryx_u32(&x817, &x818, x816, x798, x795);
    fiat_secp384r1_addcarryx_u32(&x819, &x820, x818, x796, x793);
    fiat_secp384r1_addcarryx_u32(&x821, &x822, x820, x794, x791);
    fiat_secp384r1_addcarryx_u32(&x823, &x824, x822, x792, x789);
    fiat_secp384r1_addcarryx_u32(&x825, &x826, 0x0, x765, x807);
    fiat_secp384r1_addcarryx_u32(&x827, &x828, x826, x767, x808);
    fiat_secp384r1_addcarryx_u32(&x829, &x830, x828, x769, 0x0);
    fiat_secp384r1_addcarryx_u32(&x831, &x832, x830, x771, x805);
    fiat_secp384r1_addcarryx_u32(&x833, &x834, x832, x773, x809);
    fiat_secp384r1_addcarryx_u32(&x835, &x836, x834, x775, x811);
    fiat_secp384r1_addcarryx_u32(&x837, &x838, x836, x777, x813);
    fiat_secp384r1_addcarryx_u32(&x839, &x840, x838, x779, x815);
    fiat_secp384r1_addcarryx_u32(&x841, &x842, x840, x781, x817);
    fiat_secp384r1_addcarryx_u32(&x843, &x844, x842, x783, x819);
    fiat_secp384r1_addcarryx_u32(&x845, &x846, x844, x785, x821);
    fiat_secp384r1_addcarryx_u32(&x847, &x848, x846, x787, x823);
    fiat_secp384r1_addcarryx_u32(&x849, &x850, x848, ((uint32_t)x788 + x754),
                                 (x824 + x790));
    fiat_secp384r1_mulx_u32(&x851, &x852, x9, 0x2);
    fiat_secp384r1_mulx_u32(&x853, &x854, x9, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x855, &x856, x9, 0x2);
    fiat_secp384r1_mulx_u32(&x857, &x858, x9, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x859, &x860, 0x0, (fiat_secp384r1_uint1)x852,
                                 x9);
    fiat_secp384r1_addcarryx_u32(&x861, &x862, 0x0, x827, x9);
    fiat_secp384r1_addcarryx_u32(&x863, &x864, x862, x829, x857);
    fiat_secp384r1_addcarryx_u32(&x865, &x866, x864, x831, x858);
    fiat_secp384r1_addcarryx_u32(&x867, &x868, x866, x833, x855);
    fiat_secp384r1_addcarryx_u32(&x869, &x870, x868, x835,
                                 (fiat_secp384r1_uint1)x856);
    fiat_secp384r1_addcarryx_u32(&x871, &x872, x870, x837, x853);
    fiat_secp384r1_addcarryx_u32(&x873, &x874, x872, x839, x854);
    fiat_secp384r1_addcarryx_u32(&x875, &x876, x874, x841, x851);
    fiat_secp384r1_addcarryx_u32(&x877, &x878, x876, x843, x859);
    fiat_secp384r1_addcarryx_u32(&x879, &x880, x878, x845, x860);
    fiat_secp384r1_addcarryx_u32(&x881, &x882, x880, x847, 0x0);
    fiat_secp384r1_addcarryx_u32(&x883, &x884, x882, x849, 0x0);
    fiat_secp384r1_mulx_u32(&x885, &x886, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x887, &x888, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x889, &x890, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x891, &x892, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x893, &x894, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x895, &x896, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x897, &x898, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x899, &x900, x861, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x901, &x902, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x903, &x904, x861, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x905, &x906, 0x0, x902, x899);
    fiat_secp384r1_addcarryx_u32(&x907, &x908, x906, x900, x897);
    fiat_secp384r1_addcarryx_u32(&x909, &x910, x908, x898, x895);
    fiat_secp384r1_addcarryx_u32(&x911, &x912, x910, x896, x893);
    fiat_secp384r1_addcarryx_u32(&x913, &x914, x912, x894, x891);
    fiat_secp384r1_addcarryx_u32(&x915, &x916, x914, x892, x889);
    fiat_secp384r1_addcarryx_u32(&x917, &x918, x916, x890, x887);
    fiat_secp384r1_addcarryx_u32(&x919, &x920, x918, x888, x885);
    fiat_secp384r1_addcarryx_u32(&x921, &x922, 0x0, x861, x903);
    fiat_secp384r1_addcarryx_u32(&x923, &x924, x922, x863, x904);
    fiat_secp384r1_addcarryx_u32(&x925, &x926, x924, x865, 0x0);
    fiat_secp384r1_addcarryx_u32(&x927, &x928, x926, x867, x901);
    fiat_secp384r1_addcarryx_u32(&x929, &x930, x928, x869, x905);
    fiat_secp384r1_addcarryx_u32(&x931, &x932, x930, x871, x907);
    fiat_secp384r1_addcarryx_u32(&x933, &x934, x932, x873, x909);
    fiat_secp384r1_addcarryx_u32(&x935, &x936, x934, x875, x911);
    fiat_secp384r1_addcarryx_u32(&x937, &x938, x936, x877, x913);
    fiat_secp384r1_addcarryx_u32(&x939, &x940, x938, x879, x915);
    fiat_secp384r1_addcarryx_u32(&x941, &x942, x940, x881, x917);
    fiat_secp384r1_addcarryx_u32(&x943, &x944, x942, x883, x919);
    fiat_secp384r1_addcarryx_u32(&x945, &x946, x944, ((uint32_t)x884 + x850),
                                 (x920 + x886));
    fiat_secp384r1_mulx_u32(&x947, &x948, x10, 0x2);
    fiat_secp384r1_mulx_u32(&x949, &x950, x10, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x951, &x952, x10, 0x2);
    fiat_secp384r1_mulx_u32(&x953, &x954, x10, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x955, &x956, 0x0, (fiat_secp384r1_uint1)x948,
                                 x10);
    fiat_secp384r1_addcarryx_u32(&x957, &x958, 0x0, x923, x10);
    fiat_secp384r1_addcarryx_u32(&x959, &x960, x958, x925, x953);
    fiat_secp384r1_addcarryx_u32(&x961, &x962, x960, x927, x954);
    fiat_secp384r1_addcarryx_u32(&x963, &x964, x962, x929, x951);
    fiat_secp384r1_addcarryx_u32(&x965, &x966, x964, x931,
                                 (fiat_secp384r1_uint1)x952);
    fiat_secp384r1_addcarryx_u32(&x967, &x968, x966, x933, x949);
    fiat_secp384r1_addcarryx_u32(&x969, &x970, x968, x935, x950);
    fiat_secp384r1_addcarryx_u32(&x971, &x972, x970, x937, x947);
    fiat_secp384r1_addcarryx_u32(&x973, &x974, x972, x939, x955);
    fiat_secp384r1_addcarryx_u32(&x975, &x976, x974, x941, x956);
    fiat_secp384r1_addcarryx_u32(&x977, &x978, x976, x943, 0x0);
    fiat_secp384r1_addcarryx_u32(&x979, &x980, x978, x945, 0x0);
    fiat_secp384r1_mulx_u32(&x981, &x982, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x983, &x984, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x985, &x986, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x987, &x988, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x989, &x990, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x991, &x992, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x993, &x994, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x995, &x996, x957, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x997, &x998, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x999, &x1000, x957, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1001, &x1002, 0x0, x998, x995);
    fiat_secp384r1_addcarryx_u32(&x1003, &x1004, x1002, x996, x993);
    fiat_secp384r1_addcarryx_u32(&x1005, &x1006, x1004, x994, x991);
    fiat_secp384r1_addcarryx_u32(&x1007, &x1008, x1006, x992, x989);
    fiat_secp384r1_addcarryx_u32(&x1009, &x1010, x1008, x990, x987);
    fiat_secp384r1_addcarryx_u32(&x1011, &x1012, x1010, x988, x985);
    fiat_secp384r1_addcarryx_u32(&x1013, &x1014, x1012, x986, x983);
    fiat_secp384r1_addcarryx_u32(&x1015, &x1016, x1014, x984, x981);
    fiat_secp384r1_addcarryx_u32(&x1017, &x1018, 0x0, x957, x999);
    fiat_secp384r1_addcarryx_u32(&x1019, &x1020, x1018, x959, x1000);
    fiat_secp384r1_addcarryx_u32(&x1021, &x1022, x1020, x961, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1023, &x1024, x1022, x963, x997);
    fiat_secp384r1_addcarryx_u32(&x1025, &x1026, x1024, x965, x1001);
    fiat_secp384r1_addcarryx_u32(&x1027, &x1028, x1026, x967, x1003);
    fiat_secp384r1_addcarryx_u32(&x1029, &x1030, x1028, x969, x1005);
    fiat_secp384r1_addcarryx_u32(&x1031, &x1032, x1030, x971, x1007);
    fiat_secp384r1_addcarryx_u32(&x1033, &x1034, x1032, x973, x1009);
    fiat_secp384r1_addcarryx_u32(&x1035, &x1036, x1034, x975, x1011);
    fiat_secp384r1_addcarryx_u32(&x1037, &x1038, x1036, x977, x1013);
    fiat_secp384r1_addcarryx_u32(&x1039, &x1040, x1038, x979, x1015);
    fiat_secp384r1_addcarryx_u32(&x1041, &x1042, x1040, ((uint32_t)x980 + x946),
                                 (x1016 + x982));
    fiat_secp384r1_mulx_u32(&x1043, &x1044, x11, 0x2);
    fiat_secp384r1_mulx_u32(&x1045, &x1046, x11, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1047, &x1048, x11, 0x2);
    fiat_secp384r1_mulx_u32(&x1049, &x1050, x11, UINT32_C(0xfffffffe));
    fiat_secp384r1_addcarryx_u32(&x1051, &x1052, 0x0,
                                 (fiat_secp384r1_uint1)x1044, x11);
    fiat_secp384r1_addcarryx_u32(&x1053, &x1054, 0x0, x1019, x11);
    fiat_secp384r1_addcarryx_u32(&x1055, &x1056, x1054, x1021, x1049);
    fiat_secp384r1_addcarryx_u32(&x1057, &x1058, x1056, x1023, x1050);
    fiat_secp384r1_addcarryx_u32(&x1059, &x1060, x1058, x1025, x1047);
    fiat_secp384r1_addcarryx_u32(&x1061, &x1062, x1060, x1027,
                                 (fiat_secp384r1_uint1)x1048);
    fiat_secp384r1_addcarryx_u32(&x1063, &x1064, x1062, x1029, x1045);
    fiat_secp384r1_addcarryx_u32(&x1065, &x1066, x1064, x1031, x1046);
    fiat_secp384r1_addcarryx_u32(&x1067, &x1068, x1066, x1033, x1043);
    fiat_secp384r1_addcarryx_u32(&x1069, &x1070, x1068, x1035, x1051);
    fiat_secp384r1_addcarryx_u32(&x1071, &x1072, x1070, x1037, x1052);
    fiat_secp384r1_addcarryx_u32(&x1073, &x1074, x1072, x1039, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1075, &x1076, x1074, x1041, 0x0);
    fiat_secp384r1_mulx_u32(&x1077, &x1078, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1079, &x1080, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1081, &x1082, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1083, &x1084, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1085, &x1086, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1087, &x1088, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1089, &x1090, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1091, &x1092, x1053, UINT32_C(0xfffffffe));
    fiat_secp384r1_mulx_u32(&x1093, &x1094, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_mulx_u32(&x1095, &x1096, x1053, UINT32_C(0xffffffff));
    fiat_secp384r1_addcarryx_u32(&x1097, &x1098, 0x0, x1094, x1091);
    fiat_secp384r1_addcarryx_u32(&x1099, &x1100, x1098, x1092, x1089);
    fiat_secp384r1_addcarryx_u32(&x1101, &x1102, x1100, x1090, x1087);
    fiat_secp384r1_addcarryx_u32(&x1103, &x1104, x1102, x1088, x1085);
    fiat_secp384r1_addcarryx_u32(&x1105, &x1106, x1104, x1086, x1083);
    fiat_secp384r1_addcarryx_u32(&x1107, &x1108, x1106, x1084, x1081);
    fiat_secp384r1_addcarryx_u32(&x1109, &x1110, x1108, x1082, x1079);
    fiat_secp384r1_addcarryx_u32(&x1111, &x1112, x1110, x1080, x1077);
    fiat_secp384r1_addcarryx_u32(&x1113, &x1114, 0x0, x1053, x1095);
    fiat_secp384r1_addcarryx_u32(&x1115, &x1116, x1114, x1055, x1096);
    fiat_secp384r1_addcarryx_u32(&x1117, &x1118, x1116, x1057, 0x0);
    fiat_secp384r1_addcarryx_u32(&x1119, &x1120, x1118, x1059, x1093);
    fiat_secp384r1_addcarryx_u32(&x1121, &x1122, x1120, x1061, x1097);
    fiat_secp384r1_addcarryx_u32(&x1123, &x1124, x1122, x1063, x1099);
    fiat_secp384r1_addcarryx_u32(&x1125, &x1126, x1124, x1065, x1101);
    fiat_secp384r1_addcarryx_u32(&x1127, &x1128, x1126, x1067, x1103);
    fiat_secp384r1_addcarryx_u32(&x1129, &x1130, x1128, x1069, x1105);
    fiat_secp384r1_addcarryx_u32(&x1131, &x1132, x1130, x1071, x1107);
    fiat_secp384r1_addcarryx_u32(&x1133, &x1134, x1132, x1073, x1109);
    fiat_secp384r1_addcarryx_u32(&x1135, &x1136, x1134, x1075, x1111);
    fiat_secp384r1_addcarryx_u32(&x1137, &x1138, x1136,
                                 ((uint32_t)x1076 + x1042), (x1112 + x1078));
    fiat_secp384r1_subborrowx_u32(&x1139, &x1140, 0x0, x1115,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1141, &x1142, x1140, x1117, 0x0);
    fiat_secp384r1_subborrowx_u32(&x1143, &x1144, x1142, x1119, 0x0);
    fiat_secp384r1_subborrowx_u32(&x1145, &x1146, x1144, x1121,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1147, &x1148, x1146, x1123,
                                  UINT32_C(0xfffffffe));
    fiat_secp384r1_subborrowx_u32(&x1149, &x1150, x1148, x1125,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1151, &x1152, x1150, x1127,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1153, &x1154, x1152, x1129,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1155, &x1156, x1154, x1131,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1157, &x1158, x1156, x1133,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1159, &x1160, x1158, x1135,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1161, &x1162, x1160, x1137,
                                  UINT32_C(0xffffffff));
    fiat_secp384r1_subborrowx_u32(&x1163, &x1164, x1162, x1138, 0x0);
    fiat_secp384r1_cmovznz_u32(&x1165, x1164, x1139, x1115);
    fiat_secp384r1_cmovznz_u32(&x1166, x1164, x1141, x1117);
    fiat_secp384r1_cmovznz_u32(&x1167, x1164, x1143, x1119);
    fiat_secp384r1_cmovznz_u32(&x1168, x1164, x1145, x1121);
    fiat_secp384r1_cmovznz_u32(&x1169, x1164, x1147, x1123);
    fiat_secp384r1_cmovznz_u32(&x1170, x1164, x1149, x1125);
    fiat_secp384r1_cmovznz_u32(&x1171, x1164, x1151, x1127);
    fiat_secp384r1_cmovznz_u32(&x1172, x1164, x1153, x1129);
    fiat_secp384r1_cmovznz_u32(&x1173, x1164, x1155, x1131);
    fiat_secp384r1_cmovznz_u32(&x1174, x1164, x1157, x1133);
    fiat_secp384r1_cmovznz_u32(&x1175, x1164, x1159, x1135);
    fiat_secp384r1_cmovznz_u32(&x1176, x1164, x1161, x1137);
    out1[0] = x1165;
    out1[1] = x1166;
    out1[2] = x1167;
    out1[3] = x1168;
    out1[4] = x1169;
    out1[5] = x1170;
    out1[6] = x1171;
    out1[7] = x1172;
    out1[8] = x1173;
    out1[9] = x1174;
    out1[10] = x1175;
    out1[11] = x1176;
}

/*
 * The function fiat_secp384r1_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void
fiat_secp384r1_nonzero(uint32_t *out1, const uint32_t arg1[12])
{
    uint32_t x1;
    x1 = ((arg1[0]) |
          ((arg1[1]) |
           ((arg1[2]) |
            ((arg1[3]) |
             ((arg1[4]) |
              ((arg1[5]) |
               ((arg1[6]) |
                ((arg1[7]) |
                 ((arg1[8]) |
                  ((arg1[9]) |
                   ((arg1[10]) | ((arg1[11]) | (uint32_t)0x0))))))))))));
    *out1 = x1;
}

/*
 * The function fiat_secp384r1_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_selectznz(uint32_t out1[12],
                         fiat_secp384r1_uint1 arg1,
                         const uint32_t arg2[12],
                         const uint32_t arg3[12])
{
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    fiat_secp384r1_cmovznz_u32(&x1, arg1, (arg2[0]), (arg3[0]));
    fiat_secp384r1_cmovznz_u32(&x2, arg1, (arg2[1]), (arg3[1]));
    fiat_secp384r1_cmovznz_u32(&x3, arg1, (arg2[2]), (arg3[2]));
    fiat_secp384r1_cmovznz_u32(&x4, arg1, (arg2[3]), (arg3[3]));
    fiat_secp384r1_cmovznz_u32(&x5, arg1, (arg2[4]), (arg3[4]));
    fiat_secp384r1_cmovznz_u32(&x6, arg1, (arg2[5]), (arg3[5]));
    fiat_secp384r1_cmovznz_u32(&x7, arg1, (arg2[6]), (arg3[6]));
    fiat_secp384r1_cmovznz_u32(&x8, arg1, (arg2[7]), (arg3[7]));
    fiat_secp384r1_cmovznz_u32(&x9, arg1, (arg2[8]), (arg3[8]));
    fiat_secp384r1_cmovznz_u32(&x10, arg1, (arg2[9]), (arg3[9]));
    fiat_secp384r1_cmovznz_u32(&x11, arg1, (arg2[10]), (arg3[10]));
    fiat_secp384r1_cmovznz_u32(&x12, arg1, (arg2[11]), (arg3[11]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
    out1[8] = x9;
    out1[9] = x10;
    out1[10] = x11;
    out1[11] = x12;
}

/*
 * The function fiat_secp384r1_to_bytes serializes a field element in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void
fiat_secp384r1_to_bytes(uint8_t out1[48], const uint32_t arg1[12])
{
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint8_t x14;
    uint32_t x15;
    uint8_t x16;
    uint8_t x17;
    uint8_t x18;
    uint8_t x19;
    uint32_t x20;
    uint8_t x21;
    uint32_t x22;
    uint8_t x23;
    uint8_t x24;
    uint8_t x25;
    uint8_t x26;
    uint32_t x27;
    uint8_t x28;
    uint32_t x29;
    uint8_t x30;
    uint8_t x31;
    uint8_t x32;
    uint8_t x33;
    uint32_t x34;
    uint8_t x35;
    uint32_t x36;
    uint8_t x37;
    uint8_t x38;
    uint8_t x39;
    uint8_t x40;
    uint32_t x41;
    uint8_t x42;
    uint32_t x43;
    uint8_t x44;
    uint8_t x45;
    uint8_t x46;
    uint8_t x47;
    uint32_t x48;
    uint8_t x49;
    uint32_t x50;
    uint8_t x51;
    uint8_t x52;
    uint8_t x53;
    uint8_t x54;
    uint32_t x55;
    uint8_t x56;
    uint32_t x57;
    uint8_t x58;
    uint8_t x59;
    uint8_t x60;
    uint8_t x61;
    uint32_t x62;
    uint8_t x63;
    uint32_t x64;
    uint8_t x65;
    uint8_t x66;
    uint8_t x67;
    uint8_t x68;
    uint32_t x69;
    uint8_t x70;
    uint32_t x71;
    uint8_t x72;
    uint8_t x73;
    uint8_t x74;
    uint8_t x75;
    uint32_t x76;
    uint8_t x77;
    uint32_t x78;
    uint8_t x79;
    uint8_t x80;
    uint8_t x81;
    uint8_t x82;
    uint32_t x83;
    uint8_t x84;
    uint32_t x85;
    uint8_t x86;
    uint8_t x87;
    uint8_t x88;
    uint8_t x89;
    uint32_t x90;
    uint8_t x91;
    uint32_t x92;
    uint8_t x93;
    uint8_t x94;
    uint8_t x95;
    x1 = (arg1[11]);
    x2 = (arg1[10]);
    x3 = (arg1[9]);
    x4 = (arg1[8]);
    x5 = (arg1[7]);
    x6 = (arg1[6]);
    x7 = (arg1[5]);
    x8 = (arg1[4]);
    x9 = (arg1[3]);
    x10 = (arg1[2]);
    x11 = (arg1[1]);
    x12 = (arg1[0]);
    x13 = (x12 >> 8);
    x14 = (uint8_t)(x12 & UINT8_C(0xff));
    x15 = (x13 >> 8);
    x16 = (uint8_t)(x13 & UINT8_C(0xff));
    x17 = (uint8_t)(x15 >> 8);
    x18 = (uint8_t)(x15 & UINT8_C(0xff));
    x19 = (uint8_t)(x17 & UINT8_C(0xff));
    x20 = (x11 >> 8);
    x21 = (uint8_t)(x11 & UINT8_C(0xff));
    x22 = (x20 >> 8);
    x23 = (uint8_t)(x20 & UINT8_C(0xff));
    x24 = (uint8_t)(x22 >> 8);
    x25 = (uint8_t)(x22 & UINT8_C(0xff));
    x26 = (uint8_t)(x24 & UINT8_C(0xff));
    x27 = (x10 >> 8);
    x28 = (uint8_t)(x10 & UINT8_C(0xff));
    x29 = (x27 >> 8);
    x30 = (uint8_t)(x27 & UINT8_C(0xff));
    x31 = (uint8_t)(x29 >> 8);
    x32 = (uint8_t)(x29 & UINT8_C(0xff));
    x33 = (uint8_t)(x31 & UINT8_C(0xff));
    x34 = (x9 >> 8);
    x35 = (uint8_t)(x9 & UINT8_C(0xff));
    x36 = (x34 >> 8);
    x37 = (uint8_t)(x34 & UINT8_C(0xff));
    x38 = (uint8_t)(x36 >> 8);
    x39 = (uint8_t)(x36 & UINT8_C(0xff));
    x40 = (uint8_t)(x38 & UINT8_C(0xff));
    x41 = (x8 >> 8);
    x42 = (uint8_t)(x8 & UINT8_C(0xff));
    x43 = (x41 >> 8);
    x44 = (uint8_t)(x41 & UINT8_C(0xff));
    x45 = (uint8_t)(x43 >> 8);
    x46 = (uint8_t)(x43 & UINT8_C(0xff));
    x47 = (uint8_t)(x45 & UINT8_C(0xff));
    x48 = (x7 >> 8);
    x49 = (uint8_t)(x7 & UINT8_C(0xff));
    x50 = (x48 >> 8);
    x51 = (uint8_t)(x48 & UINT8_C(0xff));
    x52 = (uint8_t)(x50 >> 8);
    x53 = (uint8_t)(x50 & UINT8_C(0xff));
    x54 = (uint8_t)(x52 & UINT8_C(0xff));
    x55 = (x6 >> 8);
    x56 = (uint8_t)(x6 & UINT8_C(0xff));
    x57 = (x55 >> 8);
    x58 = (uint8_t)(x55 & UINT8_C(0xff));
    x59 = (uint8_t)(x57 >> 8);
    x60 = (uint8_t)(x57 & UINT8_C(0xff));
    x61 = (uint8_t)(x59 & UINT8_C(0xff));
    x62 = (x5 >> 8);
    x63 = (uint8_t)(x5 & UINT8_C(0xff));
    x64 = (x62 >> 8);
    x65 = (uint8_t)(x62 & UINT8_C(0xff));
    x66 = (uint8_t)(x64 >> 8);
    x67 = (uint8_t)(x64 & UINT8_C(0xff));
    x68 = (uint8_t)(x66 & UINT8_C(0xff));
    x69 = (x4 >> 8);
    x70 = (uint8_t)(x4 & UINT8_C(0xff));
    x71 = (x69 >> 8);
    x72 = (uint8_t)(x69 & UINT8_C(0xff));
    x73 = (uint8_t)(x71 >> 8);
    x74 = (uint8_t)(x71 & UINT8_C(0xff));
    x75 = (uint8_t)(x73 & UINT8_C(0xff));
    x76 = (x3 >> 8);
    x77 = (uint8_t)(x3 & UINT8_C(0xff));
    x78 = (x76 >> 8);
    x79 = (uint8_t)(x76 & UINT8_C(0xff));
    x80 = (uint8_t)(x78 >> 8);
    x81 = (uint8_t)(x78 & UINT8_C(0xff));
    x82 = (uint8_t)(x80 & UINT8_C(0xff));
    x83 = (x2 >> 8);
    x84 = (uint8_t)(x2 & UINT8_C(0xff));
    x85 = (x83 >> 8);
    x86 = (uint8_t)(x83 & UINT8_C(0xff));
    x87 = (uint8_t)(x85 >> 8);
    x88 = (uint8_t)(x85 & UINT8_C(0xff));
    x89 = (uint8_t)(x87 & UINT8_C(0xff));
    x90 = (x1 >> 8);
    x91 = (uint8_t)(x1 & UINT8_C(0xff));
    x92 = (x90 >> 8);
    x93 = (uint8_t)(x90 & UINT8_C(0xff));
    x94 = (uint8_t)(x92 >> 8);
    x95 = (uint8_t)(x92 & UINT8_C(0xff));
    out1[0] = x14;
    out1[1] = x16;
    out1[2] = x18;
    out1[3] = x19;
    out1[4] = x21;
    out1[5] = x23;
    out1[6] = x25;
    out1[7] = x26;
    out1[8] = x28;
    out1[9] = x30;
    out1[10] = x32;
    out1[11] = x33;
    out1[12] = x35;
    out1[13] = x37;
    out1[14] = x39;
    out1[15] = x40;
    out1[16] = x42;
    out1[17] = x44;
    out1[18] = x46;
    out1[19] = x47;
    out1[20] = x49;
    out1[21] = x51;
    out1[22] = x53;
    out1[23] = x54;
    out1[24] = x56;
    out1[25] = x58;
    out1[26] = x60;
    out1[27] = x61;
    out1[28] = x63;
    out1[29] = x65;
    out1[30] = x67;
    out1[31] = x68;
    out1[32] = x70;
    out1[33] = x72;
    out1[34] = x74;
    out1[35] = x75;
    out1[36] = x77;
    out1[37] = x79;
    out1[38] = x81;
    out1[39] = x82;
    out1[40] = x84;
    out1[41] = x86;
    out1[42] = x88;
    out1[43] = x89;
    out1[44] = x91;
    out1[45] = x93;
    out1[46] = x95;
    out1[47] = x94;
}

/*
 * The function fiat_secp384r1_from_bytes deserializes a field element in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void
fiat_secp384r1_from_bytes(uint32_t out1[12],
                          const uint8_t arg1[48])
{
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint8_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint8_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint8_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint8_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint8_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint8_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint8_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint8_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint8_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint8_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint8_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint8_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    uint32_t x57;
    uint32_t x58;
    uint32_t x59;
    uint32_t x60;
    uint32_t x61;
    uint32_t x62;
    uint32_t x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    x1 = ((uint32_t)(arg1[47]) << 24);
    x2 = ((uint32_t)(arg1[46]) << 16);
    x3 = ((uint32_t)(arg1[45]) << 8);
    x4 = (arg1[44]);
    x5 = ((uint32_t)(arg1[43]) << 24);
    x6 = ((uint32_t)(arg1[42]) << 16);
    x7 = ((uint32_t)(arg1[41]) << 8);
    x8 = (arg1[40]);
    x9 = ((uint32_t)(arg1[39]) << 24);
    x10 = ((uint32_t)(arg1[38]) << 16);
    x11 = ((uint32_t)(arg1[37]) << 8);
    x12 = (arg1[36]);
    x13 = ((uint32_t)(arg1[35]) << 24);
    x14 = ((uint32_t)(arg1[34]) << 16);
    x15 = ((uint32_t)(arg1[33]) << 8);
    x16 = (arg1[32]);
    x17 = ((uint32_t)(arg1[31]) << 24);
    x18 = ((uint32_t)(arg1[30]) << 16);
    x19 = ((uint32_t)(arg1[29]) << 8);
    x20 = (arg1[28]);
    x21 = ((uint32_t)(arg1[27]) << 24);
    x22 = ((uint32_t)(arg1[26]) << 16);
    x23 = ((uint32_t)(arg1[25]) << 8);
    x24 = (arg1[24]);
    x25 = ((uint32_t)(arg1[23]) << 24);
    x26 = ((uint32_t)(arg1[22]) << 16);
    x27 = ((uint32_t)(arg1[21]) << 8);
    x28 = (arg1[20]);
    x29 = ((uint32_t)(arg1[19]) << 24);
    x30 = ((uint32_t)(arg1[18]) << 16);
    x31 = ((uint32_t)(arg1[17]) << 8);
    x32 = (arg1[16]);
    x33 = ((uint32_t)(arg1[15]) << 24);
    x34 = ((uint32_t)(arg1[14]) << 16);
    x35 = ((uint32_t)(arg1[13]) << 8);
    x36 = (arg1[12]);
    x37 = ((uint32_t)(arg1[11]) << 24);
    x38 = ((uint32_t)(arg1[10]) << 16);
    x39 = ((uint32_t)(arg1[9]) << 8);
    x40 = (arg1[8]);
    x41 = ((uint32_t)(arg1[7]) << 24);
    x42 = ((uint32_t)(arg1[6]) << 16);
    x43 = ((uint32_t)(arg1[5]) << 8);
    x44 = (arg1[4]);
    x45 = ((uint32_t)(arg1[3]) << 24);
    x46 = ((uint32_t)(arg1[2]) << 16);
    x47 = ((uint32_t)(arg1[1]) << 8);
    x48 = (arg1[0]);
    x49 = (x48 + (x47 + (x46 + x45)));
    x50 = (x49 & UINT32_C(0xffffffff));
    x51 = (x4 + (x3 + (x2 + x1)));
    x52 = (x8 + (x7 + (x6 + x5)));
    x53 = (x12 + (x11 + (x10 + x9)));
    x54 = (x16 + (x15 + (x14 + x13)));
    x55 = (x20 + (x19 + (x18 + x17)));
    x56 = (x24 + (x23 + (x22 + x21)));
    x57 = (x28 + (x27 + (x26 + x25)));
    x58 = (x32 + (x31 + (x30 + x29)));
    x59 = (x36 + (x35 + (x34 + x33)));
    x60 = (x40 + (x39 + (x38 + x37)));
    x61 = (x44 + (x43 + (x42 + x41)));
    x62 = (x61 & UINT32_C(0xffffffff));
    x63 = (x60 & UINT32_C(0xffffffff));
    x64 = (x59 & UINT32_C(0xffffffff));
    x65 = (x58 & UINT32_C(0xffffffff));
    x66 = (x57 & UINT32_C(0xffffffff));
    x67 = (x56 & UINT32_C(0xffffffff));
    x68 = (x55 & UINT32_C(0xffffffff));
    x69 = (x54 & UINT32_C(0xffffffff));
    x70 = (x53 & UINT32_C(0xffffffff));
    x71 = (x52 & UINT32_C(0xffffffff));
    out1[0] = x50;
    out1[1] = x62;
    out1[2] = x63;
    out1[3] = x64;
    out1[4] = x65;
    out1[5] = x66;
    out1[6] = x67;
    out1[7] = x68;
    out1[8] = x69;
    out1[9] = x70;
    out1[10] = x71;
    out1[11] = x51;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/secp384r1/fe_inv.op3
 * custom repunit addition chain
 */
static void
fiat_secp384r1_inv(fe_t output, const fe_t t1)
{
    int i;
    /* temporary variables */
    fe_t acc, t10, t170, t2, t20, t255, t30, t32, t4, t64, t8, t84, t85;

    fiat_secp384r1_square(acc, t1);
    fiat_secp384r1_mul(t2, acc, t1);
    fiat_secp384r1_square(acc, t2);
    fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t4, acc, t2);
    fiat_secp384r1_square(acc, t4);
    for (i = 0; i < 3; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t8, acc, t4);
    fiat_secp384r1_square(acc, t8);
    fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t10, acc, t2);
    fiat_secp384r1_square(acc, t10);
    for (i = 0; i < 9; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t20, acc, t10);
    fiat_secp384r1_square(acc, t20);
    for (i = 0; i < 9; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t30, acc, t10);
    fiat_secp384r1_square(acc, t30);
    fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t32, acc, t2);
    fiat_secp384r1_square(acc, t32);
    for (i = 0; i < 31; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t64, acc, t32);
    fiat_secp384r1_square(acc, t64);
    for (i = 0; i < 19; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t84, acc, t20);
    fiat_secp384r1_square(acc, t84);
    fiat_secp384r1_mul(t85, acc, t1);
    fiat_secp384r1_square(acc, t85);
    for (i = 0; i < 84; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t170, acc, t85);
    fiat_secp384r1_square(acc, t170);
    for (i = 0; i < 84; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(t255, acc, t85);
    fiat_secp384r1_square(acc, t255);
    for (i = 0; i < 32; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(acc, acc, t32);
    for (i = 0; i < 94; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(acc, acc, t30);
    for (i = 0; i < 2; i++)
        fiat_secp384r1_square(acc, acc);
    fiat_secp384r1_mul(output, acc, t1);
}

/* curve coefficient constants */

static const limb_t const_one[12] = {
    UINT32_C(0x00000001), UINT32_C(0xFFFFFFFF), UINT32_C(0xFFFFFFFF),
    UINT32_C(0x00000000), UINT32_C(0x00000001), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
    UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000)
};

static const limb_t const_b[12] = {
    UINT32_C(0x9D412DCC), UINT32_C(0x08118871), UINT32_C(0x7A4C32EC),
    UINT32_C(0xF729ADD8), UINT32_C(0x1920022E), UINT32_C(0x77F2209B),
    UINT32_C(0x94938AE2), UINT32_C(0xE3374BEE), UINT32_C(0x1F022094),
    UINT32_C(0xB62B21F4), UINT32_C(0x604FBFF9), UINT32_C(0xCD08114B)
};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[21][16] = {
    {
        { { UINT32_C(0x49C0B528), UINT32_C(0x3DD07566), UINT32_C(0xA0D6CE38),
            UINT32_C(0x20E378E2), UINT32_C(0x541B4D6E), UINT32_C(0x879C3AFC),
            UINT32_C(0x59A30EFF), UINT32_C(0x64548684), UINT32_C(0x614EDE2B),
            UINT32_C(0x812FF723), UINT32_C(0x299E1513), UINT32_C(0x4D3AADC2) },
          { UINT32_C(0x4B03A4FE), UINT32_C(0x23043DAD), UINT32_C(0x7BB4A9AC),
            UINT32_C(0xA1BFA8BF), UINT32_C(0x2E83B050), UINT32_C(0x8BADE756),
            UINT32_C(0x68F4FFD9), UINT32_C(0xC6C35219), UINT32_C(0x3969A840),
            UINT32_C(0xDD800226), UINT32_C(0x5A15C5E9), UINT32_C(0x2B78ABC2) } },
        { { UINT32_C(0xC1DC4073), UINT32_C(0x05E4DBE6), UINT32_C(0xF04F779C),
            UINT32_C(0xC54EA9FF), UINT32_C(0xA170CCF0), UINT32_C(0x6B2034E9),
            UINT32_C(0xD51C6C3E), UINT32_C(0x3A48D732), UINT32_C(0x263AA470),
            UINT32_C(0xE36F7E2D), UINT32_C(0xE7C1C3AC), UINT32_C(0xD283FE68) },
          { UINT32_C(0xC04EE157), UINT32_C(0x7E284821), UINT32_C(0x7AE0E36D),
            UINT32_C(0x92D789A7), UINT32_C(0x4EF67446), UINT32_C(0x132663C0),
            UINT32_C(0xD2E1D0B4), UINT32_C(0x68012D5A), UINT32_C(0x5102B339),
            UINT32_C(0xF6DB68B1), UINT32_C(0x983292AF), UINT32_C(0x465465FC) } },
        { { UINT32_C(0x68F1F0DF), UINT32_C(0xBB595EBA), UINT32_C(0xCC873466),
            UINT32_C(0xC185C0CB), UINT32_C(0x293C703B), UINT32_C(0x7F1EB1B5),
            UINT32_C(0xAACC05E6), UINT32_C(0x60DB2CF5), UINT32_C(0xE2E8E4C6),
            UINT32_C(0xC676B987), UINT32_C(0x1D178FFB), UINT32_C(0xE1BB26B1) },
          { UINT32_C(0x7073FA21), UINT32_C(0x2B694BA0), UINT32_C(0x72F34566),
            UINT32_C(0x22C16E2E), UINT32_C(0x01C35B99), UINT32_C(0x80B61B31),
            UINT32_C(0x982C0411), UINT32_C(0x4B237FAF), UINT32_C(0x24DE236D),
            UINT32_C(0xE6C59440), UINT32_C(0xE209E4A3), UINT32_C(0x4DB1C9D6) } },
        { { UINT32_C(0x7D69222B), UINT32_C(0xDF13B9D1), UINT32_C(0x874774B1),
            UINT32_C(0x4CE6415F), UINT32_C(0x211FAA95), UINT32_C(0x731EDCF8),
            UINT32_C(0x659753ED), UINT32_C(0x5F4215D1), UINT32_C(0x9DB2DF55),
            UINT32_C(0xF893DB58), UINT32_C(0x1C89025B), UINT32_C(0x932C9F81) },
          { UINT32_C(0x7706A61E), UINT32_C(0x0996B220), UINT32_C(0xA8641C79),
            UINT32_C(0x135349D5), UINT32_C(0x50130844), UINT32_C(0x65AAD76F),
            UINT32_C(0x01FFF780), UINT32_C(0x0FF37C04), UINT32_C(0x693B0706),
            UINT32_C(0xF57F238E), UINT32_C(0xAF6C9B3E), UINT32_C(0xD90A16B6) } },
        { { UINT32_C(0x2353B92F), UINT32_C(0x2F5D200E), UINT32_C(0x3FD7E4F9),
            UINT32_C(0xE35D8729), UINT32_C(0xA96D745D), UINT32_C(0x26094833),
            UINT32_C(0x3CBFFF3F), UINT32_C(0xDC351DC1), UINT32_C(0xDAD54D6A),
            UINT32_C(0x26D464C6), UINT32_C(0x53636C6A), UINT32_C(0x5CAB1D1D) },
          { UINT32_C(0xB18EC0B0), UINT32_C(0xF2813072), UINT32_C(0xD742AA2F),
            UINT32_C(0x3777E270), UINT32_C(0x033CA7C2), UINT32_C(0x27F061C7),
            UINT32_C(0x68EAD0D8), UINT32_C(0xA6ECACCC), UINT32_C(0xEE69A754),
            UINT32_C(0x7D9429F4), UINT32_C(0x31E8F5C6), UINT32_C(0xE7706334) } },
        { { UINT32_C(0xB68B8C7D), UINT32_C(0xC7708B19), UINT32_C(0x44377ABA),
            UINT32_C(0x4532077C), UINT32_C(0x6CDAD64F), UINT32_C(0x0DCC6770),
            UINT32_C(0x147B6602), UINT32_C(0x01B8BF56), UINT32_C(0xF0561D79),
            UINT32_C(0xF8D89885), UINT32_C(0x7BA9C437), UINT32_C(0x9C19E9FC) },
          { UINT32_C(0xBDC4BA25), UINT32_C(0x764EB146), UINT32_C(0xAC144B83),
            UINT32_C(0x604FE46B), UINT32_C(0x8A77E780), UINT32_C(0x3CE81329),
            UINT32_C(0xFE9E682E), UINT32_C(0x2E070F36), UINT32_C(0x3A53287A),
            UINT32_C(0x41821D0C), UINT32_C(0x3533F918), UINT32_C(0x9AA62F9F) } },
        { { UINT32_C(0x75CCBDFB), UINT32_C(0x9B7AEB7E), UINT32_C(0xF6749A95),
            UINT32_C(0xB25E28C5), UINT32_C(0x33B7D4AE), UINT32_C(0x8A7A8E46),
            UINT32_C(0xD9C1BD56), UINT32_C(0xDB5203A8), UINT32_C(0xED22DF97),
            UINT32_C(0xD2657265), UINT32_C(0x8CF23C94), UINT32_C(0xB51C56E1) },
          { UINT32_C(0x6C3D812D), UINT32_C(0xF4D39459), UINT32_C(0x87CAE0C2),
            UINT32_C(0xD8E88F1A), UINT32_C(0xCF4D0FE3), UINT32_C(0x789A2A48),
            UINT32_C(0xFEC38D60), UINT32_C(0xB7FEAC2D), UINT32_C(0x3B490EC3),
            UINT32_C(0x81FDBD1C), UINT32_C(0xCC6979E1), UINT32_C(0x4617ADB7) } },
        { { UINT32_C(0x4709F4A9), UINT32_C(0x446AD888), UINT32_C(0xEC3DABD8),
            UINT32_C(0x2B7210E2), UINT32_C(0x50E07B34), UINT32_C(0x83CCF195),
            UINT32_C(0x789B3075), UINT32_C(0x59500917), UINT32_C(0xEB085993),
            UINT32_C(0x0FC01FD4), UINT32_C(0x4903026B), UINT32_C(0xFB62D26F) },
          { UINT32_C(0x6FE989BB), UINT32_C(0x2309CC9D), UINT32_C(0x144BD586),
            UINT32_C(0x61609CBD), UINT32_C(0xDE06610C), UINT32_C(0x4B23D3A0),
            UINT32_C(0xD898F470), UINT32_C(0xDDDC2866), UINT32_C(0x400C5797),
            UINT32_C(0x8733FC41), UINT32_C(0xD0BC2716), UINT32_C(0x5A68C6FE) } },
        { { UINT32_C(0x4B4A3CD0), UINT32_C(0x8903E130), UINT32_C(0x8FF1F43E),
            UINT32_C(0x3EA4EA4C), UINT32_C(0xF655A10D), UINT32_C(0xE6FC3F2A),
            UINT32_C(0x524FFEFC), UINT32_C(0x7BE3737D), UINT32_C(0x5330455E),
            UINT32_C(0x9F692855), UINT32_C(0xE475CE70), UINT32_C(0x524F166E) },
          { UINT32_C(0x6C12F055), UINT32_C(0x3FCC69CD), UINT32_C(0xD5B9C0DA),
            UINT32_C(0x4E23B6FF), UINT32_C(0x336BF183), UINT32_C(0x49CE6993),
            UINT32_C(0x4A54504A), UINT32_C(0xF87D6D85), UINT32_C(0xB3C2677A),
            UINT32_C(0x25EB5DF1), UINT32_C(0x55B164C9), UINT32_C(0xAC37986F) } },
        { { UINT32_C(0xBAA84C08), UINT32_C(0x82A2ED4A), UINT32_C(0x41A8C912),
            UINT32_C(0x22C4CC5F), UINT32_C(0x154AAD5E), UINT32_C(0xCA109C3B),
            UINT32_C(0xFC38538E), UINT32_C(0x23891298), UINT32_C(0x539802AE),
            UINT32_C(0xB3B6639C), UINT32_C(0x0390D706), UINT32_C(0xFA0F1F45) },
          { UINT32_C(0xB0DC21D0), UINT32_C(0x46B78E5D), UINT32_C(0xC3DA2EAC),
            UINT32_C(0xA8C72D3C), UINT32_C(0x6FF2F643), UINT32_C(0x9170B378),
            UINT32_C(0xB67F30C3), UINT32_C(0x3F5A799B), UINT32_C(0x8264B672),
            UINT32_C(0x15D1DC77), UINT32_C(0xE9577764), UINT32_C(0xA1D47B23) } },
        { { UINT32_C(0x0422CE2F), UINT32_C(0x08265E51), UINT32_C(0xDD2F9E21),
            UINT32_C(0x88E0D496), UINT32_C(0x6177F75D), UINT32_C(0x30128AA0),
            UINT32_C(0xBD9EBE69), UINT32_C(0x2E59AB62), UINT32_C(0x5DF0E537),
            UINT32_C(0x1B1A0F6C), UINT32_C(0xDAC012B5), UINT32_C(0xAB16C626) },
          { UINT32_C(0x008C5DE7), UINT32_C(0x8014214B), UINT32_C(0x38F17BEA),
            UINT32_C(0xAA740A9E), UINT32_C(0x8A149098), UINT32_C(0x262EBB49),
            UINT32_C(0x8527CD59), UINT32_C(0xB454111E), UINT32_C(0xACEA5817),
            UINT32_C(0x266AD15A), UINT32_C(0x1353CCBA), UINT32_C(0x21824F41) } },
        { { UINT32_C(0x12E3683B), UINT32_C(0xD1B4E74D), UINT32_C(0x569B8EF6),
            UINT32_C(0x990ED20B), UINT32_C(0x429C0A18), UINT32_C(0xB9D3DD25),
            UINT32_C(0x2A351783), UINT32_C(0x1C75B8AB), UINT32_C(0x905432F0),
            UINT32_C(0x61E4CA2B), UINT32_C(0xEEA8F224), UINT32_C(0x80826A69) },
          { UINT32_C(0xEC52ABAD), UINT32_C(0x7FC33A6B), UINT32_C(0xA65E4813),
            UINT32_C(0x0BCCA3F0), UINT32_C(0xA527CEBE), UINT32_C(0x7AD8A132),
            UINT32_C(0xEAF22C7E), UINT32_C(0xF0138950), UINT32_C(0x566718C1),
            UINT32_C(0x282D2437), UINT32_C(0xE2212559), UINT32_C(0x9DFCCB0D) } },
        { { UINT32_C(0x58CE3B83), UINT32_C(0x1E937227), UINT32_C(0x3CB3FB36),
            UINT32_C(0xBB280DFA), UINT32_C(0xE2BE174A), UINT32_C(0x57D0F3D2),
            UINT32_C(0x208ABE1E), UINT32_C(0x9BD51B99), UINT32_C(0xDE248024),
            UINT32_C(0x3809AB50), UINT32_C(0xA5BB7331), UINT32_C(0xC29C6E2C) },
          { UINT32_C(0x61124F05), UINT32_C(0x9944FD2E), UINT32_C(0x9009E391),
            UINT32_C(0x83CCBC4E), UINT32_C(0x9424A3CC), UINT32_C(0x01628F05),
            UINT32_C(0xEA8E4344), UINT32_C(0xD6A2F51D), UINT32_C(0x4CEBC96E),
            UINT32_C(0xDA3E1A3D), UINT32_C(0xE97809DC), UINT32_C(0x1FE6FB42) } },
        { { UINT32_C(0x467D66E4), UINT32_C(0xA04482D2), UINT32_C(0x4D78291D),
            UINT32_C(0xCF191293), UINT32_C(0x482396F9), UINT32_C(0x8E0D4168),
            UINT32_C(0xD18F14D0), UINT32_C(0x7228E2D5), UINT32_C(0x9C6A58FE),
            UINT32_C(0x2F7E8D50), UINT32_C(0x373E5AEC), UINT32_C(0xE8CA780E) },
          { UINT32_C(0x1B68E9F8), UINT32_C(0x42AAD1D6), UINT32_C(0x69E2F8F4),
            UINT32_C(0x58A6D7F5), UINT32_C(0x31DA1BEA), UINT32_C(0xD779ADFE),
            UINT32_C(0x38C85A85), UINT32_C(0x7D265406), UINT32_C(0xD44D3CDF),
            UINT32_C(0x67E67195), UINT32_C(0xC5134ED7), UINT32_C(0x17820A0B) } },
        { { UINT32_C(0xD3021470), UINT32_C(0x019D6AC5), UINT32_C(0x780443D6),
            UINT32_C(0x25846B66), UINT32_C(0x55C97647), UINT32_C(0xCE3C15ED),
            UINT32_C(0x0E3FEB0F), UINT32_C(0x3DC22D49), UINT32_C(0xA7DF26E4),
            UINT32_C(0x2065B7CB), UINT32_C(0x187CEA1F), UINT32_C(0xC8B00AE8) },
          { UINT32_C(0x865DDED3), UINT32_C(0x1A5284A0), UINT32_C(0x20C83DE2),
            UINT32_C(0x293C1649), UINT32_C(0xCCE851B3), UINT32_C(0xAB178D26),
            UINT32_C(0x404505FB), UINT32_C(0x8E6DB10B), UINT32_C(0x90C82033),
            UINT32_C(0xF6F57E71), UINT32_C(0x5977F16C), UINT32_C(0x1D2A1C01) } },
        { { UINT32_C(0x7C8906A4), UINT32_C(0xA39C8931), UINT32_C(0x9E821EE6),
            UINT32_C(0xB6E7ECDD), UINT32_C(0xF0DF4FE6), UINT32_C(0x2ECF8340),
            UINT32_C(0x53C14965), UINT32_C(0xD42F7DC9), UINT32_C(0xE3BA8285),
            UINT32_C(0x1AFB51A3), UINT32_C(0x0A3305D1), UINT32_C(0x6C07C404) },
          { UINT32_C(0x127FC1DA), UINT32_C(0xDAB83288), UINT32_C(0x374C4B08),
            UINT32_C(0xBC0A699B), UINT32_C(0x42EB20DD), UINT32_C(0x402A9BAB),
            UINT32_C(0x045A7A1C), UINT32_C(0xD7DD464F), UINT32_C(0x36BEECC4),
            UINT32_C(0x5B3D0D6D), UINT32_C(0x6398A19D), UINT32_C(0x475A3E75) } },
    },
    {
        { { UINT32_C(0x72876AE8), UINT32_C(0x31BDB483), UINT32_C(0x961ED1BF),
            UINT32_C(0xE3325D98), UINT32_C(0x9B6FC64D), UINT32_C(0x18C04246),
            UINT32_C(0x15786B8C), UINT32_C(0x0DCC15FA), UINT32_C(0x8E63DA4A),
            UINT32_C(0x81ACDB06), UINT32_C(0xDADA70FB), UINT32_C(0xD3A4B643) },
          { UINT32_C(0xDEA424EB), UINT32_C(0x46361AFE), UINT32_C(0x89B92970),
            UINT32_C(0xDC2D2CAE), UINT32_C(0x615694E6), UINT32_C(0xF389B61B),
            UINT32_C(0x872951D2), UINT32_C(0x7036DEF1), UINT32_C(0xD93BADC7),
            UINT32_C(0x40FD3BDA), UINT32_C(0x380A68D3), UINT32_C(0x45AB6321) } },
        { { UINT32_C(0x81A2703A), UINT32_C(0x23C1F744), UINT32_C(0xB9859136),
            UINT32_C(0x1A5D075C), UINT32_C(0x5AFD1BFD), UINT32_C(0xA4F82C9D),
            UINT32_C(0xF89D76FE), UINT32_C(0xA3D1E9A4), UINT32_C(0x75702F80),
            UINT32_C(0x964F7050), UINT32_C(0xF56C089D), UINT32_C(0x182BF349) },
          { UINT32_C(0xBE0DA6E1), UINT32_C(0xE205FA8F), UINT32_C(0x0A40F8F3),
            UINT32_C(0x32905EB9), UINT32_C(0x356D4395), UINT32_C(0x331A1004),
            UINT32_C(0xFDBBDFDE), UINT32_C(0x58B78901), UINT32_C(0x9BA00E71),
            UINT32_C(0xA52A1597), UINT32_C(0x55497A30), UINT32_C(0xE0092E1F) } },
        { { UINT32_C(0x70EE8F39), UINT32_C(0x5562A856), UINT32_C(0x64E52A9C),
            UINT32_C(0x86B0C117), UINT32_C(0x09C75B8C), UINT32_C(0xC19F3174),
            UINT32_C(0x24923F80), UINT32_C(0x21C7CC31), UINT32_C(0x8F5B291E),
            UINT32_C(0xE63FE47F), UINT32_C(0x0DC08B05), UINT32_C(0x3D6D3C05) },
          { UINT32_C(0xEE0C39A1), UINT32_C(0x58AE455E), UINT32_C(0x0AD97942),
            UINT32_C(0x78BEA431), UINT32_C(0x3EE3989C), UINT32_C(0x42C7C97F),
            UINT32_C(0xF38759AE), UINT32_C(0xC1B03AF5), UINT32_C(0xBCF46899),
            UINT32_C(0x1A673C75), UINT32_C(0x8D508C7D), UINT32_C(0x4831B7D3) } },
        { { UINT32_C(0xC552E354), UINT32_C(0x76512D1B), UINT32_C(0x273020FD),
            UINT32_C(0x2B7EB6DF), UINT32_C(0x025A5F25), UINT32_C(0xD1C73AA8),
            UINT32_C(0x5CBD2A40), UINT32_C(0x2ABA1929), UINT32_C(0xC88D61C6),
            UINT32_C(0xB53CADC3), UINT32_C(0x098290F3), UINT32_C(0x7E66A95E) },
          { UINT32_C(0xAF4C5073), UINT32_C(0x72800ECB), UINT32_C(0x9DC63FAF),
            UINT32_C(0x81F2725E), UINT32_C(0x282BA9D1), UINT32_C(0x14BF92A7),
            UINT32_C(0xBD5F1BB2), UINT32_C(0x90629672), UINT32_C(0xA97C6C96),
            UINT32_C(0x362F68EB), UINT32_C(0x7EA9D601), UINT32_C(0xB1D3BB8B) } },
        { { UINT32_C(0xA9C94429), UINT32_C(0x73878F7F), UINT32_C(0x456CA6D8),
            UINT32_C(0xB35C3BC8), UINT32_C(0xF721923A), UINT32_C(0xD96F0B3C),
            UINT32_C(0xE6D44FA1), UINT32_C(0x28D8F06C), UINT32_C(0xD5CD671A),
            UINT32_C(0x94EFDCDC), UINT32_C(0x3F97D481), UINT32_C(0x0299AB93) },
          { UINT32_C(0x2FD1D324), UINT32_C(0xB7CED6EA), UINT32_C(0x7E932EC2),
            UINT32_C(0xBD683208), UINT32_C(0xCB755A6E), UINT32_C(0x24ED31FB),
            UINT32_C(0xE48781D2), UINT32_C(0xA636098E), UINT32_C(0xF0A4F297),
            UINT32_C(0x8687C63C), UINT32_C(0x07478526), UINT32_C(0xBB523440) } },
        { { UINT32_C(0x34124B56), UINT32_C(0x2E5F7419), UINT32_C(0x4B3F02CA),
            UINT32_C(0x1F223AE1), UINT32_C(0xE8336C7E), UINT32_C(0x6345B427),
            UINT32_C(0xF5D0E3D0), UINT32_C(0x92123E16), UINT32_C(0x45E79F3A),
            UINT32_C(0xDAF0D14D), UINT32_C(0x6F3BD0C6), UINT32_C(0x6ACA6765) },
          { UINT32_C(0x403813F4), UINT32_C(0xF6169FAB), UINT32_C(0x334A4C59),
            UINT32_C(0x31DC39C0), UINT32_C(0xD589866D), UINT32_C(0x74C46753),
            UINT32_C(0x984C6A5D), UINT32_C(0x5741511D), UINT32_C(0x97FED2D3),
            UINT32_C(0xF2631287), UINT32_C(0x11614886), UINT32_C(0x5687CA1B) } },
        { { UINT32_C(0x33836D4B), UINT32_C(0x076D902A), UINT32_C(0x24AFB557),
            UINT32_C(0xEC6C5C43), UINT32_C(0xA0516A0F), UINT32_C(0xA0FE2D1C),
            UINT32_C(0x00D22ECC), UINT32_C(0x6FB8D737), UINT32_C(0xDAF1D7B3),
            UINT32_C(0xF1DE9077), UINT32_C(0xD4C0C1EB), UINT32_C(0xE4695F77) },
          { UINT32_C(0xB4375573), UINT32_C(0x5F0FD8A8), UINT32_C(0x5E50944F),
            UINT32_C(0x76238359), UINT32_C(0x635CD76F), UINT32_C(0x65EA2F28),
            UINT32_C(0x25FDE7B0), UINT32_C(0x08547769), UINT32_C(0x51944304),
            UINT32_C(0xB2345A2E), UINT32_C(0xA16C980D), UINT32_C(0x86EFA2F7) } },
        { { UINT32_C(0xBF4D1D63), UINT32_C(0x4CCBE2D0), UINT32_C(0x397366D5),
            UINT32_C(0x32E33401), UINT32_C(0x71BDA2CE), UINT32_C(0xC83AFDDE),
            UINT32_C(0x478ED9E6), UINT32_C(0x8DACE2AC), UINT32_C(0x763FDD9E),
            UINT32_C(0x3AC6A559), UINT32_C(0xB398558F), UINT32_C(0x0FFDB04C) },
          { UINT32_C(0xAFB9D6B8), UINT32_C(0x6C1B99B2), UINT32_C(0x27F815DD),
            UINT32_C(0x572BA39C), UINT32_C(0x0DBCF842), UINT32_C(0x9DE73EE7),
            UINT32_C(0x29267B88), UINT32_C(0x2A3ED589), UINT32_C(0x15EBBBB3),
            UINT32_C(0xD46A7FD3), UINT32_C(0xE29400C7), UINT32_C(0xD1D01863) } },
        { { UINT32_C(0xE1F89EC5), UINT32_C(0x8FB101D1), UINT32_C(0xF8508042),
            UINT32_C(0xB87A1F53), UINT32_C(0x0ED7BEEF), UINT32_C(0x28C8DB24),
            UINT32_C(0xACE8660A), UINT32_C(0x3940F845), UINT32_C(0xC6D453FD),
            UINT32_C(0x4EACB619), UINT32_C(0x2BAD6160), UINT32_C(0x2E044C98) },
          { UINT32_C(0x80B16C02), UINT32_C(0x87928548), UINT32_C(0xC0A9EB64),
            UINT32_C(0xF0D4BEB3), UINT32_C(0xC183C195), UINT32_C(0xD785B4AF),
            UINT32_C(0x5E6C46EA), UINT32_C(0x23AAB0E6), UINT32_C(0xA930FECA),
            UINT32_C(0x30F7E104), UINT32_C(0xD55C10FB), UINT32_C(0x6A1A7B8B) } },
        { { UINT32_C(0xDBFED1AA), UINT32_C(0xDA74EAEB), UINT32_C(0xDF0B025C),
            UINT32_C(0xC8A59223), UINT32_C(0xD5B627F7), UINT32_C(0x7EF7DC85),
            UINT32_C(0x197D7624), UINT32_C(0x02A13AE1), UINT32_C(0x2F785A9B),
            UINT32_C(0x119E9BE1), UINT32_C(0x00D6B219), UINT32_C(0xC0B7572F) },
          { UINT32_C(0x6D4CAF30), UINT32_C(0x9B1E5126), UINT32_C(0x0A840BD1),
            UINT32_C(0xA16A5117), UINT32_C(0x0E9CCF43), UINT32_C(0x5BE17B91),
            UINT32_C(0x69CF2C9C), UINT32_C(0x5BDBEDDD), UINT32_C(0x4CF4F289),
            UINT32_C(0x9FFBFBCF), UINT32_C(0x6C355CE9), UINT32_C(0xE1A62183) } },
        { { UINT32_C(0xA7B2FCCF), UINT32_C(0x056199D9), UINT32_C(0xCE1D784E),
            UINT32_C(0x51F2E7B6), UINT32_C(0x339E2FF0), UINT32_C(0xA1D09C47),
            UINT32_C(0xB836D0A9), UINT32_C(0xC8E64890), UINT32_C(0xC0D07EBE),
            UINT32_C(0x2F781DCB), UINT32_C(0x3ACF934C), UINT32_C(0x5CF3C2AD) },
          { UINT32_C(0xA17E26AE), UINT32_C(0xE55DB190), UINT32_C(0x91245513),
            UINT32_C(0xC9C61E1F), UINT32_C(0x61998C15), UINT32_C(0x83D7E6CF),
            UINT32_C(0xE41D38E3), UINT32_C(0x4DB33C85), UINT32_C(0xC2FEE43D),
            UINT32_C(0x74D5F91D), UINT32_C(0x36BBC826), UINT32_C(0x7EBBDB45) } },
        { { UINT32_C(0xCB655A9D), UINT32_C(0xE20EC7E9), UINT32_C(0x5C47D421),
            UINT32_C(0x4977EB92), UINT32_C(0x3B9D72FA), UINT32_C(0xA237E12C),
            UINT32_C(0xCBF7B145), UINT32_C(0xCAAEDBC1), UINT32_C(0x3B77AAA3),
            UINT32_C(0x5200F5B2), UINT32_C(0xBDBE5380), UINT32_C(0x32EDED55) },
          { UINT32_C(0xE7C9B80A), UINT32_C(0x74E38A40), UINT32_C(0xAB6DE911),
            UINT32_C(0x3A3F0CF8), UINT32_C(0xAD16AAF0), UINT32_C(0x56DCDD7A),
            UINT32_C(0x8E861D5E), UINT32_C(0x3D292449), UINT32_C(0x985733E2),
            UINT32_C(0xD6C61878), UINT32_C(0x6AA6CD5B), UINT32_C(0x2401FE7D) } },
        { { UINT32_C(0xB42E3686), UINT32_C(0xABB3DC75), UINT32_C(0xB4C57E61),
            UINT32_C(0xAE712419), UINT32_C(0xB21B009B), UINT32_C(0x2C565F72),
            UINT32_C(0x710C3699), UINT32_C(0xA5F1DA2E), UINT32_C(0xA5EBA59A),
            UINT32_C(0x771099A0), UINT32_C(0xC10017A0), UINT32_C(0x4DA88F4A) },
          { UINT32_C(0x1927B56D), UINT32_C(0x987FFFD3), UINT32_C(0xC4E33478),
            UINT32_C(0xB98CB8EC), UINT32_C(0xC2248166), UINT32_C(0xB224A971),
            UINT32_C(0xDE1DC794), UINT32_C(0x5470F554), UINT32_C(0xE31FF983),
            UINT32_C(0xD747CC24), UINT32_C(0xB5B22DAE), UINT32_C(0xB91745E9) } },
        { { UINT32_C(0x72F34420), UINT32_C(0x6CCBFED0), UINT32_C(0xA53039D2),
            UINT32_C(0x95045E4D), UINT32_C(0x5A793944), UINT32_C(0x3B6C1154),
            UINT32_C(0xDDB6B799), UINT32_C(0xAA114145), UINT32_C(0x252B7637),
            UINT32_C(0xABC15CA4), UINT32_C(0xA5744634), UINT32_C(0x5745A35B) },
          { UINT32_C(0xDA596FC0), UINT32_C(0x05DC6BDE), UINT32_C(0xA8020881),
            UINT32_C(0xCD52C18C), UINT32_C(0xD296BAD0), UINT32_C(0x03FA9F47),
            UINT32_C(0x7268E139), UINT32_C(0xD8E2C129), UINT32_C(0x9EC450B0),
            UINT32_C(0x58C1A98D), UINT32_C(0xDE48B20D), UINT32_C(0x909638DA) } },
        { { UINT32_C(0x9B7F8311), UINT32_C(0x7AFC30D4), UINT32_C(0x42368EA3),
            UINT32_C(0x82A00422), UINT32_C(0x6F5F9865), UINT32_C(0xBFF95198),
            UINT32_C(0xFC0A070F), UINT32_C(0x9B24F612), UINT32_C(0x620F489D),
            UINT32_C(0x22C06CF2), UINT32_C(0x780F7DBB), UINT32_C(0x3C7ED052) },
          { UINT32_C(0x34DAFE9B), UINT32_C(0xDB87AB18), UINT32_C(0x9C4BBCA1),
            UINT32_C(0x20C03B40), UINT32_C(0x59A42341), UINT32_C(0x5D718CF0),
            UINT32_C(0x69E84538), UINT32_C(0x98631706), UINT32_C(0xD27D64E1),
            UINT32_C(0x5557192B), UINT32_C(0xDA822766), UINT32_C(0x08B4EC52) } },
        { { UINT32_C(0xD66C1A59), UINT32_C(0xB2D986F6), UINT32_C(0x78E0E423),
            UINT32_C(0x927DEB16), UINT32_C(0x49C3DEDC), UINT32_C(0x9E673CDE),
            UINT32_C(0xF7ECB6CF), UINT32_C(0xFA362D84), UINT32_C(0x1BA17340),
            UINT32_C(0x078E5F40), UINT32_C(0x1F4E489C), UINT32_C(0x934CA5D1) },
          { UINT32_C(0x64EEF493), UINT32_C(0xC03C0731), UINT32_C(0xD7931A7E),
            UINT32_C(0x631A353B), UINT32_C(0x65DD74F1), UINT32_C(0x8E7CC3BB),
            UINT32_C(0x702676A5), UINT32_C(0xD55864C5), UINT32_C(0x439F04BD),
            UINT32_C(0x6D306AC4), UINT32_C(0x2BAFED57), UINT32_C(0x58544F67) } },
    },
    {
        { { UINT32_C(0xEC074AEA), UINT32_C(0xB083BA6A), UINT32_C(0x7F0B505B),
            UINT32_C(0x46FAC5EF), UINT32_C(0xFC82DC03), UINT32_C(0x95367A21),
            UINT32_C(0x9D3679D8), UINT32_C(0x227BE26A), UINT32_C(0x7E9724C0),
            UINT32_C(0xC70F6D6C), UINT32_C(0xF9EBEC0F), UINT32_C(0xCD68C757) },
          { UINT32_C(0x8FF321B2), UINT32_C(0x29DDE03E), UINT32_C(0x031939DC),
            UINT32_C(0xF84AD7BB), UINT32_C(0x0F602F4B), UINT32_C(0xDAF590C9),
            UINT32_C(0x49722BC4), UINT32_C(0x17C52888), UINT32_C(0x089B22B6),
            UINT32_C(0xA8DF99F0), UINT32_C(0xE59B9B90), UINT32_C(0xC21BC5D4) } },
        { { UINT32_C(0x8A31973F), UINT32_C(0x4936C6A0), UINT32_C(0x83B8C205),
            UINT32_C(0x54D442FA), UINT32_C(0x5714F2C6), UINT32_C(0x03AEE8B4),
            UINT32_C(0x3F5AC25A), UINT32_C(0x139BD692), UINT32_C(0xB5B33794),
            UINT32_C(0x6A2E42BA), UINT32_C(0x3FF7BBA9), UINT32_C(0x50FA1164) },
          { UINT32_C(0xF7E2C099), UINT32_C(0xB61D8643), UINT32_C(0xBD5C6637),
            UINT32_C(0x2366C993), UINT32_C(0x72EB77FA), UINT32_C(0x62110E14),
            UINT32_C(0x3B99C635), UINT32_C(0x3D5B96F1), UINT32_C(0xF674C9F2),
            UINT32_C(0x956ECF64), UINT32_C(0xEF2BA250), UINT32_C(0xC56F7E51) } },
        { { UINT32_C(0xFF602C1B), UINT32_C(0x246FFCB6), UINT32_C(0x6E1258E0),
            UINT32_C(0x1E1A1D74), UINT32_C(0x250E6676), UINT32_C(0xB4B43AE2),
            UINT32_C(0x924CE5FA), UINT32_C(0x95C1B5F0), UINT32_C(0xEBD8C776),
            UINT32_C(0x2555795B), UINT32_C(0xACD9D9D0), UINT32_C(0x4C1E03DC) },
          { UINT32_C(0x9CE90C61), UINT32_C(0xE1D74AA6), UINT32_C(0xA9C4B9F9),
            UINT32_C(0xA88C0769), UINT32_C(0x95AF56DE), UINT32_C(0xDF74DF27),
            UINT32_C(0xB331B6F4), UINT32_C(0x24B10C5F), UINT32_C(0x6559E137),
            UINT32_C(0xB0A6DF9A), UINT32_C(0xC06637F2), UINT32_C(0x6ACC1B8F) } },
        { { UINT32_C(0x34B4E381), UINT32_C(0xBD8C0868), UINT32_C(0x30DFF271),
            UINT32_C(0x278CACC7), UINT32_C(0x02459389), UINT32_C(0x87ED12DE),
            UINT32_C(0xDEF840B6), UINT32_C(0x3F7D98FF), UINT32_C(0x5F0B56E1),
            UINT32_C(0x71EEE0CB), UINT32_C(0xD8D9BE87), UINT32_C(0x462B5C9B) },
          { UINT32_C(0x98094C0F), UINT32_C(0xE6B50B5A), UINT32_C(0x508C67CE),
            UINT32_C(0x26F3B274), UINT32_C(0x7CB1F992), UINT32_C(0x418B1BD1),
            UINT32_C(0x4FF11827), UINT32_C(0x607818ED), UINT32_C(0x9B042C63),
            UINT32_C(0xE630D93A), UINT32_C(0x8C779AE3), UINT32_C(0x38B9EFF3) } },
        { { UINT32_C(0x729C5431), UINT32_C(0xE8767D36), UINT32_C(0xBB94642C),
            UINT32_C(0xA8BD07C0), UINT32_C(0x58F2E5B2), UINT32_C(0x0C11FC8E),
            UINT32_C(0x547533FE), UINT32_C(0xD8912D48), UINT32_C(0x230D91FB),
            UINT32_C(0xAAE14F5E), UINT32_C(0x676DFBA0), UINT32_C(0xC122051A) },
          { UINT32_C(0x5EA93078), UINT32_C(0x9ED4501F), UINT32_C(0xBD4BEE0A),
            UINT32_C(0x2758515C), UINT32_C(0x94D21F52), UINT32_C(0x97733C6C),
            UINT32_C(0x4AD306A2), UINT32_C(0x139BCD6D), UINT32_C(0x298123CC),
            UINT32_C(0x0AAECBDC), UINT32_C(0x1CB7C7C9), UINT32_C(0x102B8A31) } },
        { { UINT32_C(0xFAF46675), UINT32_C(0x22A28E59), UINT32_C(0x10A31E7D),
            UINT32_C(0x10757308), UINT32_C(0x2B4C2F4F), UINT32_C(0xC7EEAC84),
            UINT32_C(0xB5EF5184), UINT32_C(0xBA370148), UINT32_C(0x8732E055),
            UINT32_C(0x4A5A2866), UINT32_C(0xB887C36F), UINT32_C(0x14B8DCDC) },
          { UINT32_C(0x433F093D), UINT32_C(0xDBA8C85C), UINT32_C(0x1C9A201C),
            UINT32_C(0x73DF549D), UINT32_C(0x70F927D8), UINT32_C(0x69AA0D7B),
            UINT32_C(0xD7D2493A), UINT32_C(0xFA3A8685), UINT32_C(0x0A7F4013),
            UINT32_C(0x6F48A255), UINT32_C(0xDD393067), UINT32_C(0xD20C8BF9) } },
        { { UINT32_C(0x81625E78), UINT32_C(0x4EC874EA), UINT32_C(0x3FBE9267),
            UINT32_C(0x8B8D8B5A), UINT32_C(0x9421EC2F), UINT32_C(0xA3D9D164),
            UINT32_C(0x880EA295), UINT32_C(0x490E92D9), UINT32_C(0xD8F3B6DA),
            UINT32_C(0x745D1EDC), UINT32_C(0x8F18BA03), UINT32_C(0x0116628B) },
          { UINT32_C(0x834EADCE), UINT32_C(0x0FF6BCE0), UINT32_C(0x000827F7),
            UINT32_C(0x464697F2), UINT32_C(0x498D724E), UINT32_C(0x08DCCF84),
            UINT32_C(0x1E88304C), UINT32_C(0x7896D365), UINT32_C(0x135E3622),
            UINT32_C(0xE63EBCCE), UINT32_C(0xDC007521), UINT32_C(0xFB942E8E) } },
        { { UINT32_C(0xA3688621), UINT32_C(0xBB155A66), UINT32_C(0xF91B52A3),
            UINT32_C(0xED2FD7CD), UINT32_C(0xEA20CB88), UINT32_C(0x52798F5D),
            UINT32_C(0x373F7DD8), UINT32_C(0x069CE105), UINT32_C(0x8CA78F6B),
            UINT32_C(0xF9392EC7), UINT32_C(0x6B335169), UINT32_C(0xB3013E25) },
          { UINT32_C(0x6B11715C), UINT32_C(0x1D92F800), UINT32_C(0xFF9DC464),
            UINT32_C(0xADD4050E), UINT32_C(0x8465B84A), UINT32_C(0x2AC22659),
            UINT32_C(0x465B2BD6), UINT32_C(0x2729D646), UINT32_C(0xE4EFF9DD),
            UINT32_C(0x6202344A), UINT32_C(0xCD9B90B9), UINT32_C(0x51F3198F) } },
        { { UINT32_C(0xE5F0AE1D), UINT32_C(0x17CE54EF), UINT32_C(0xB09852AF),
            UINT32_C(0x984E8204), UINT32_C(0xC4B27A71), UINT32_C(0x3365B37A),
            UINT32_C(0xA00E0A9C), UINT32_C(0x720E3152), UINT32_C(0x925BD606),
            UINT32_C(0x3692F70D), UINT32_C(0x7BC7E9AB), UINT32_C(0xBE6E699D) },
          { UINT32_C(0x4C89A3C0), UINT32_C(0xD75C041F), UINT32_C(0x8DC100C0),
            UINT32_C(0x8B9F592D), UINT32_C(0xAD228F71), UINT32_C(0x30750F3A),
            UINT32_C(0xE8B17A11), UINT32_C(0x1B9ECF84), UINT32_C(0x0FBFA8A2),
            UINT32_C(0xDF202562), UINT32_C(0xAA1B6D67), UINT32_C(0x45C811FC) } },
        { { UINT32_C(0x1A5151F8), UINT32_C(0xEC5B84B7), UINT32_C(0x550AB2D2),
            UINT32_C(0x118E59E8), UINT32_C(0x049BD735), UINT32_C(0x2CCDEDA4),
            UINT32_C(0x9CD62F0F), UINT32_C(0xC99CBA71), UINT32_C(0x62C9E4F8),
            UINT32_C(0x69B8040A), UINT32_C(0x110B8283), UINT32_C(0x16F1A31A) },
          { UINT32_C(0x98E908A3), UINT32_C(0x53F63802), UINT32_C(0xD862F9DE),
            UINT32_C(0x308CB6EF), UINT32_C(0xA521A95A), UINT32_C(0xE185DAD8),
            UINT32_C(0x097F75CA), UINT32_C(0x4D8FE9A4), UINT32_C(0x1CA07D53),
            UINT32_C(0xD1ECCEC7), UINT32_C(0x0DB07E83), UINT32_C(0x13DFA1DC) } },
        { { UINT32_C(0x0F591A76), UINT32_C(0xDDAF9DC6), UINT32_C(0x1685F412),
            UINT32_C(0xE1A6D7CC), UINT32_C(0x002B6E8D), UINT32_C(0x153DE557),
            UINT32_C(0xC6DA37D9), UINT32_C(0x730C38BC), UINT32_C(0x0914B597),
            UINT32_C(0xAE180622), UINT32_C(0xDD8C3A0A), UINT32_C(0x84F98103) },
          { UINT32_C(0x8DA205B0), UINT32_C(0x369C5398), UINT32_C(0x3888A720),
            UINT32_C(0xA3D95B81), UINT32_C(0xE10E2806), UINT32_C(0x1F3F8BBF),
            UINT32_C(0x4530D1F3), UINT32_C(0x48663DF5), UINT32_C(0x3E377713),
            UINT32_C(0x320523B4), UINT32_C(0xC7894814), UINT32_C(0xE8B1A575) } },
        { { UINT32_C(0x2EE8EA07), UINT32_C(0x33066871), UINT32_C(0x60DA199D),
            UINT32_C(0xC6FB4EC5), UINT32_C(0xF4370A05), UINT32_C(0x33231860),
            UINT32_C(0xC6DE4E26), UINT32_C(0x7ABECE72), UINT32_C(0xEBDECE7A),
            UINT32_C(0xDE8D4BD8), UINT32_C(0x1CBE93C7), UINT32_C(0xC90EE657) },
          { UINT32_C(0x85AC2509), UINT32_C(0x0246751B), UINT32_C(0x30380245),
            UINT32_C(0xD0EF142C), UINT32_C(0x7C76E39C), UINT32_C(0x086DF9C4),
            UINT32_C(0xB789FB56), UINT32_C(0x68F1304F), UINT32_C(0xA5E4BD56),
            UINT32_C(0x23E4CB98), UINT32_C(0x64663DCA), UINT32_C(0x69A4C63C) } },
        { { UINT32_C(0x7CB34E63), UINT32_C(0x6C72B6AF), UINT32_C(0x6DFC23FE),
            UINT32_C(0x073C40CD), UINT32_C(0xC936693A), UINT32_C(0xBDEEE7A1),
            UINT32_C(0x6EFAD378), UINT32_C(0xBC858E80), UINT32_C(0xF5BE55D4),
            UINT32_C(0xEAD719FF), UINT32_C(0x04552F5F), UINT32_C(0xC8C3238F) },
          { UINT32_C(0x928D5784), UINT32_C(0x0952C068), UINT32_C(0x94C58F2B),
            UINT32_C(0x89DFDF22), UINT32_C(0x67502C50), UINT32_C(0x332DEDF3),
            UINT32_C(0xAC0BE258), UINT32_C(0x3ED2FA3A), UINT32_C(0x7C5C8244),
            UINT32_C(0xAEDC9B8A), UINT32_C(0xDC0EA34F), UINT32_C(0x43A761B9) } },
        { { UINT32_C(0xCC5E21A5), UINT32_C(0x8FD683A2), UINT32_C(0xFBA2BB68),
            UINT32_C(0x5F444C6E), UINT32_C(0xAF05586D), UINT32_C(0x709ACD0E),
            UINT32_C(0xDE8FB348), UINT32_C(0x8EFA54D2), UINT32_C(0x34CFE29E),
            UINT32_C(0x35276B71), UINT32_C(0x941EAC8C), UINT32_C(0x77A06FCD) },
          { UINT32_C(0x928322DD), UINT32_C(0x5815792D), UINT32_C(0x67F7CB59),
            UINT32_C(0x82FF356B), UINT32_C(0x304980F4), UINT32_C(0x71E40A78),
            UINT32_C(0x3667D021), UINT32_C(0xC8645C27), UINT32_C(0xAEBAE28F),
            UINT32_C(0xE785741C), UINT32_C(0x53ECAC37), UINT32_C(0xB2C1BC75) } },
        { { UINT32_C(0x1D0A74DB), UINT32_C(0x633EB24F), UINT32_C(0xFA752512),
            UINT32_C(0xF1F55E56), UINT32_C(0x8EFE11DE), UINT32_C(0x75FECA68),
            UINT32_C(0xE6BF19EC), UINT32_C(0xC80FD91C), UINT32_C(0x2A14C908),
            UINT32_C(0xAD0BAFEC), UINT32_C(0xADE4031F), UINT32_C(0x4E1C4ACA) },
          { UINT32_C(0x1EB1549A), UINT32_C(0x463A815B), UINT32_C(0x668F1298),
            UINT32_C(0x5AD4253C), UINT32_C(0x38A37151), UINT32_C(0x5CB38662),
            UINT32_C(0xAFF16B96), UINT32_C(0x34BB1CCF), UINT32_C(0xEE731AB0),
            UINT32_C(0xDCA93B13), UINT32_C(0x9BE01A0B), UINT32_C(0x9F3CE5CC) } },
        { { UINT32_C(0xA110D331), UINT32_C(0x75DB5723), UINT32_C(0x7123D89F),
            UINT32_C(0x67C66F6A), UINT32_C(0x4009D570), UINT32_C(0x27ABBD4B),
            UINT32_C(0xC73451BC), UINT32_C(0xACDA6F84), UINT32_C(0x05575ACF),
            UINT32_C(0xE4B9A239), UINT32_C(0xAB2D3D6C), UINT32_C(0x3C2DB7EF) },
          { UINT32_C(0x29115145), UINT32_C(0x01CCDD08), UINT32_C(0x57B5814A),
            UINT32_C(0x9E0602FE), UINT32_C(0x87862838), UINT32_C(0x679B35C2),
            UINT32_C(0x38AD598D), UINT32_C(0x0277DC4C), UINT32_C(0x6D896DD4),
            UINT32_C(0xEF80A213), UINT32_C(0xE7B9047B), UINT32_C(0xC8812213) } },
    },
    {
        { { UINT32_C(0xEDC9CE62), UINT32_C(0xAC6DBDF6), UINT32_C(0x0F9C006E),
            UINT32_C(0xA58F5B44), UINT32_C(0xDC28E1B0), UINT32_C(0x16694DE3),
            UINT32_C(0xA6647711), UINT32_C(0x2D039CF2), UINT32_C(0xC5B08B4B),
            UINT32_C(0xA13BBE6F), UINT32_C(0x10EBD8CE), UINT32_C(0xE44DA930) },
          { UINT32_C(0x19649A16), UINT32_C(0xCD472087), UINT32_C(0x683E5DF1),
            UINT32_C(0xE18F4E44), UINT32_C(0x929BFA28), UINT32_C(0xB3F66303),
            UINT32_C(0x818249BF), UINT32_C(0x7C378E43), UINT32_C(0x847F7CD9),
            UINT32_C(0x76068C80), UINT32_C(0x987EBA16), UINT32_C(0xEE3DB6D1) } },
        { { UINT32_C(0xC42A2F52), UINT32_C(0xCBBD8576), UINT32_C(0x9D2B06BB),
            UINT32_C(0x9ACC6F70), UINT32_C(0x2E6B72A4), UINT32_C(0xE5CB5620),
            UINT32_C(0x7C024443), UINT32_C(0x5738EA0E), UINT32_C(0xB55368F3),
            UINT32_C(0x8ED06170), UINT32_C(0x1AEED44F), UINT32_C(0xE54C99BB) },
          { UINT32_C(0xE2E0D8B2), UINT32_C(0x3D90A6B2), UINT32_C(0xCF7B2856),
            UINT32_C(0x21718977), UINT32_C(0xC5612AEC), UINT32_C(0x089093DC),
            UINT32_C(0x99C1BACC), UINT32_C(0xC272EF6F), UINT32_C(0xDC43EAAD),
            UINT32_C(0x47DB3B43), UINT32_C(0x0832D891), UINT32_C(0x730F30E4) } },
        { { UINT32_C(0x0C7FECDB), UINT32_C(0x9FFE5563), UINT32_C(0xF88101E5),
            UINT32_C(0x55CC67B6), UINT32_C(0xCBEFA3C7), UINT32_C(0x3039F981),
            UINT32_C(0x667BFD64), UINT32_C(0x2AB06883), UINT32_C(0x4340E3DF),
            UINT32_C(0x9007A257), UINT32_C(0x5A3A49CA), UINT32_C(0x1AC3F3FA) },
          { UINT32_C(0xC97E20FD), UINT32_C(0x9C7BE629), UINT32_C(0xA3DAE003),
            UINT32_C(0xF61823D3), UINT32_C(0xE7380DBA), UINT32_C(0xFFE7FF39),
            UINT32_C(0x9FACC3B8), UINT32_C(0x620BB9B5), UINT32_C(0x31AE422C),
            UINT32_C(0x2DDCB8CD), UINT32_C(0xD12C3C43), UINT32_C(0x1DE3BCFA) } },
        { { UINT32_C(0xD6E0F9A9), UINT32_C(0x8C074946), UINT32_C(0x51C3B05B),
            UINT32_C(0x662FA995), UINT32_C(0x04BB2048), UINT32_C(0x6CDAE969),
            UINT32_C(0xD6DC8B60), UINT32_C(0x6DEC9594), UINT32_C(0x54438BBC),
            UINT32_C(0x8D265869), UINT32_C(0x1B0E95A5), UINT32_C(0x88E983E3) },
          { UINT32_C(0x60CBF838), UINT32_C(0x8189F114), UINT32_C(0x771DC46B),
            UINT32_C(0x77190697), UINT32_C(0x27F8EC1A), UINT32_C(0x775775A2),
            UINT32_C(0x607E3739), UINT32_C(0x7A125240), UINT32_C(0x4F793E4E),
            UINT32_C(0xAFAE84E7), UINT32_C(0x5BF5BAF4), UINT32_C(0x44FA17F3) } },
        { { UINT32_C(0xD03AC439), UINT32_C(0xA21E69A5), UINT32_C(0x88AA8094),
            UINT32_C(0x2069C5FC), UINT32_C(0x8C08F206), UINT32_C(0xB041EEA7),
            UINT32_C(0x3D65B8ED), UINT32_C(0x55B9D461), UINT32_C(0xD392C7C4),
            UINT32_C(0x951EA25C), UINT32_C(0x9D166232), UINT32_C(0x4B9A1CEC) },
          { UINT32_C(0xFCF931A4), UINT32_C(0xC184FCD8), UINT32_C(0x063AD374),
            UINT32_C(0xBA59AD44), UINT32_C(0x1AA9796F), UINT32_C(0x1868AD2A),
            UINT32_C(0xDFF29832), UINT32_C(0x38A34018), UINT32_C(0x03DF8070),
            UINT32_C(0x01FC8801), UINT32_C(0x48DD334A), UINT32_C(0x1282CCE0) } },
        { { UINT32_C(0x26D8503C), UINT32_C(0x76AA9557), UINT32_C(0x6BC3E3D0),
            UINT32_C(0xBE962B63), UINT32_C(0x97DE8841), UINT32_C(0xF5CA93E5),
            UINT32_C(0xAF3F2C16), UINT32_C(0x1561B05E), UINT32_C(0xD34BFF98),
            UINT32_C(0x34BE00AA), UINT32_C(0xD23D2925), UINT32_C(0xEA21E6E9) },
          { UINT32_C(0x394C3AFB), UINT32_C(0x55713230), UINT32_C(0xD6C8BECA),
            UINT32_C(0xEAF0529B), UINT32_C(0x202B9A11), UINT32_C(0xFF38A743),
            UINT32_C(0x6D3A398B), UINT32_C(0xA13E39FC), UINT32_C(0x86E2615A),
            UINT32_C(0x8CBD644B), UINT32_C(0x191057EC), UINT32_C(0x92063988) } },
        { { UINT32_C(0x13F89146), UINT32_C(0x787835CE), UINT32_C(0x69446C3F),
            UINT32_C(0x7FCD42CC), UINT32_C(0x840E679D), UINT32_C(0x0DA2AA98),
            UINT32_C(0x18779A1B), UINT32_C(0x44F20523), UINT32_C(0xEFBF5935),
            UINT32_C(0xE3A3B34F), UINT32_C(0xB9947B70), UINT32_C(0xA5D2CFD0) },
          { UINT32_C(0x27F4E16F), UINT32_C(0xAE2AF4EF), UINT32_C(0xB9D21322),
            UINT32_C(0xA7FA70D2), UINT32_C(0xB3FD566B), UINT32_C(0x68084919),
            UINT32_C(0xD7AAD6AB), UINT32_C(0xF04D71C8), UINT32_C(0x10BC4260),
            UINT32_C(0xDBEA21E4), UINT32_C(0x8D949B42), UINT32_C(0xAA7DC665) } },
        { { UINT32_C(0x6CCB8213), UINT32_C(0xD8E958A0), UINT32_C(0x91900B54),
            UINT32_C(0x118D9DB9), UINT32_C(0x85E8CED6), UINT32_C(0x09BB9D49),
            UINT32_C(0x24019281), UINT32_C(0x410E9FB5), UINT32_C(0x6D74C86E),
            UINT32_C(0x3B31B4E1), UINT32_C(0x020BB77D), UINT32_C(0x52BC0252) },
          { UINT32_C(0x27092CE4), UINT32_C(0x5616A26F), UINT32_C(0xA08F65CD),
            UINT32_C(0x67774DBC), UINT32_C(0xC08BD569), UINT32_C(0x560AD494),
            UINT32_C(0xAD498783), UINT32_C(0xBE26DA36), UINT32_C(0x7F019C91),
            UINT32_C(0x0276C8AB), UINT32_C(0x5248266E), UINT32_C(0x09843ADA) } },
        { { UINT32_C(0x7D963CF2), UINT32_C(0xA0AE88A7), UINT32_C(0xD0E84920),
            UINT32_C(0x91EF8986), UINT32_C(0xF8C58104), UINT32_C(0xC7EFE344),
            UINT32_C(0xECA20773), UINT32_C(0x0A25D9FD), UINT32_C(0x00D8F1D5),
            UINT32_C(0x9D989FAA), UINT32_C(0xC8B06264), UINT32_C(0x4204C8CE) },
          { UINT32_C(0xBE1A2796), UINT32_C(0x717C12E0), UINT32_C(0xC190C728),
            UINT32_C(0x1FA4BA8C), UINT32_C(0x8C8A59BA), UINT32_C(0xA245CA8D),
            UINT32_C(0x7672B935), UINT32_C(0xE3C37475), UINT32_C(0x2E4D6375),
            UINT32_C(0x083D5E40), UINT32_C(0x5455E16E), UINT32_C(0x0B8D5AB3) } },
        { { UINT32_C(0xEED765D4), UINT32_C(0x1DB17DBF), UINT32_C(0xA5DDB965),
            UINT32_C(0xBBC9B1BE), UINT32_C(0xDFC12ABC), UINT32_C(0x1948F76D),
            UINT32_C(0x134EF489), UINT32_C(0x2C2714E5), UINT32_C(0x741C600F),
            UINT32_C(0x60CE2EE8), UINT32_C(0xF80E6E63), UINT32_C(0x32396F22) },
          { UINT32_C(0x22537F59), UINT32_C(0x421DAC75), UINT32_C(0x49475DF5),
            UINT32_C(0x58FB73C6), UINT32_C(0x6F18F1C7), UINT32_C(0x0ABF2885),
            UINT32_C(0x9A398D16), UINT32_C(0x36474468), UINT32_C(0xBF673B87),
            UINT32_C(0x87A661A7), UINT32_C(0x73819E17), UINT32_C(0x3E80698F) } },
        { { UINT32_C(0x53784CC4), UINT32_C(0xDFE49793), UINT32_C(0x486D508F),
            UINT32_C(0x4280EAB0), UINT32_C(0xE534F5A4), UINT32_C(0x119593FF),
            UINT32_C(0x9F63242F), UINT32_C(0x98AEFADD), UINT32_C(0xC4829CAE),
            UINT32_C(0x9AE6A24A), UINT32_C(0x58E8BA80), UINT32_C(0xF2373CA5) },
          { UINT32_C(0x51765FB3), UINT32_C(0x4017AF7E), UINT32_C(0xAF4AEC4B),
            UINT32_C(0xD1E40F7C), UINT32_C(0x0898E3BC), UINT32_C(0x87372C7A),
            UINT32_C(0x85452CA9), UINT32_C(0x688982B2), UINT32_C(0xB1E50BCA),
            UINT32_C(0x71E0B4BF), UINT32_C(0xF70E714A), UINT32_C(0x21FD2DBF) } },
        { { UINT32_C(0xFB78DDAC), UINT32_C(0xEE6E8820), UINT32_C(0x063892CD),
            UINT32_C(0x0BAED29C), UINT32_C(0x28C0588D), UINT32_C(0x5F33049C),
            UINT32_C(0x18DBC432), UINT32_C(0x90C2515E), UINT32_C(0x3B4CB0BD),
            UINT32_C(0xB8A1B143), UINT32_C(0x68103043), UINT32_C(0x0AB5C0C9) },
          { UINT32_C(0x4005EC40), UINT32_C(0xF3788FA0), UINT32_C(0x039EE115),
            UINT32_C(0x82571C99), UINT32_C(0x93260BED), UINT32_C(0xEE8FCED5),
            UINT32_C(0x10836D18), UINT32_C(0x5A9BAF79), UINT32_C(0xC46AA4F6),
            UINT32_C(0x7C258B09), UINT32_C(0x37F53D31), UINT32_C(0x46ECC5E8) } },
        { { UINT32_C(0xBFE0DD98), UINT32_C(0xFA32C0DC), UINT32_C(0x962B1066),
            UINT32_C(0x66EFAFC4), UINT32_C(0x64BDF5EB), UINT32_C(0xBA81D33E),
            UINT32_C(0xFC7FC512), UINT32_C(0x36C28536), UINT32_C(0xE0B4FA97),
            UINT32_C(0x0C95176B), UINT32_C(0x3B9BC64A), UINT32_C(0x47DDE29B) },
          { UINT32_C(0x5C173B36), UINT32_C(0x08D986FD), UINT32_C(0x6CF3F28C),
            UINT32_C(0x46D84B52), UINT32_C(0xF026BDB9), UINT32_C(0x6F6ED6C3),
            UINT32_C(0x68206DC5), UINT32_C(0xAC90668B), UINT32_C(0xECBE4E70),
            UINT32_C(0xE8ED5D98), UINT32_C(0xDC1A6974), UINT32_C(0xCFFF61DD) } },
        { { UINT32_C(0x77B1A5C1), UINT32_C(0xFF5C3A29), UINT32_C(0x0DDF995D),
            UINT32_C(0x10C27E4A), UINT32_C(0xE23363E3), UINT32_C(0xCB745F77),
            UINT32_C(0x32F399A3), UINT32_C(0xD765DF6F), UINT32_C(0x8A99E109),
            UINT32_C(0xF0CA0C2F), UINT32_C(0x1E025CA0), UINT32_C(0xC3A6BFB7) },
          { UINT32_C(0x4F9D9FA5), UINT32_C(0x830B2C0A), UINT32_C(0xBD1A84E5),
            UINT32_C(0xAE914CAC), UINT32_C(0xA4FEBCC1), UINT32_C(0x30B35ED8),
            UINT32_C(0x84CFBF2E), UINT32_C(0xCB902B46), UINT32_C(0x25FC6375),
            UINT32_C(0x0BD47628), UINT32_C(0x85509D04), UINT32_C(0xA858A53C) } },
        { { UINT32_C(0x552E0A3F), UINT32_C(0x8B995D0C), UINT32_C(0x17BE9FF7),
            UINT32_C(0xEDBD4E94), UINT32_C(0x95085178), UINT32_C(0x3432E839),
            UINT32_C(0x80C256F5), UINT32_C(0x0FE5C181), UINT32_C(0xEBF9597C),
            UINT32_C(0x05A64EA8), UINT32_C(0x3F80371F), UINT32_C(0x6ED44BB1) },
          { UINT32_C(0xFE4C12EE), UINT32_C(0x6A29A05E), UINT32_C(0xE0BB83B3),
            UINT32_C(0x3E436A43), UINT32_C(0x74D72921), UINT32_C(0x38365D9A),
            UINT32_C(0xC38E1ED7), UINT32_C(0x3F5EE823), UINT32_C(0xE8FA063F),
            UINT32_C(0x09A53213), UINT32_C(0xB435E713), UINT32_C(0x1E7FE47A) } },
        { { UINT32_C(0xFDDD17F3), UINT32_C(0xE4D9BC94), UINT32_C(0xC1016C20),
            UINT32_C(0xC74B8FED), UINT32_C(0xB49C060E), UINT32_C(0x095DE39B),
            UINT32_C(0x8AC0DF00), UINT32_C(0xDBCC6795), UINT32_C(0x1C34F4DF),
            UINT32_C(0x4CF6BAEB), UINT32_C(0xE8390170), UINT32_C(0x72C55C21) },
          { UINT32_C(0xF6C48E79), UINT32_C(0x4F17BFD2), UINT32_C(0x017A80BA),
            UINT32_C(0x18BF4DA0), UINT32_C(0xBCF4B138), UINT32_C(0xCF51D829),
            UINT32_C(0xF48F8B0D), UINT32_C(0x598AEE5F), UINT32_C(0x20F10809),
            UINT32_C(0x83FAEE56), UINT32_C(0x779F0850), UINT32_C(0x4615D4DC) } },
    },
    {
        { { UINT32_C(0x5852B59B), UINT32_C(0x22313DEE), UINT32_C(0xB6A0B37F),
            UINT32_C(0x6F56C8E8), UINT32_C(0xA76EC380), UINT32_C(0x43D6EEAE),
            UINT32_C(0x0275AD36), UINT32_C(0xA1655136), UINT32_C(0xDF095BDA),
            UINT32_C(0xE5C1B65A), UINT32_C(0x367C44B0), UINT32_C(0xBD1FFA8D) },
          { UINT32_C(0x6B48AF2B), UINT32_C(0xE2B419C2), UINT32_C(0x3DA194C8),
            UINT32_C(0x57BBBD97), UINT32_C(0xA2BAFF05), UINT32_C(0xB5FBE51F),
            UINT32_C(0x6269B5D0), UINT32_C(0xA0594D70), UINT32_C(0x23E8D667),
            UINT32_C(0x0B07B705), UINT32_C(0x63E016E7), UINT32_C(0xAE1976B5) } },
        { { UINT32_C(0xFBECAAAE), UINT32_C(0x2FDE4893), UINT32_C(0x30332229),
            UINT32_C(0x444346DE), UINT32_C(0x09456ED5), UINT32_C(0x157B8A5B),
            UINT32_C(0x25797C6C), UINT32_C(0x73606A79), UINT32_C(0x33C14C06),
            UINT32_C(0xA9D0F47C), UINT32_C(0xFAF971CA), UINT32_C(0x7BC8962C) },
          { UINT32_C(0x65909DFD), UINT32_C(0x6E763C51), UINT32_C(0x14A9BF42),
            UINT32_C(0x1BBBE41B), UINT32_C(0xC49E9EFC), UINT32_C(0xD95B7ECB),
            UINT32_C(0xB38F2B59), UINT32_C(0x0C317927), UINT32_C(0xB3C397DB),
            UINT32_C(0x97912B53), UINT32_C(0x45C7ABC7), UINT32_C(0xCB3879AA) } },
        { { UINT32_C(0x24359B81), UINT32_C(0xCD81BDCF), UINT32_C(0xDB4C321C),
            UINT32_C(0x6FD326E2), UINT32_C(0xF8EBE39C), UINT32_C(0x4CB0228B),
            UINT32_C(0xB2CDD852), UINT32_C(0x496A9DCE), UINT32_C(0xD0E9B3AF),
            UINT32_C(0x0F115A1A), UINT32_C(0xD8EEEF8A), UINT32_C(0xAA08BF36) },
          { UINT32_C(0x06E5E739), UINT32_C(0x5232A515), UINT32_C(0x8407A551),
            UINT32_C(0x21FAE9D5), UINT32_C(0x8994B4E8), UINT32_C(0x289D18B0),
            UINT32_C(0x09097A52), UINT32_C(0xB4E346A8), UINT32_C(0x324621D0),
            UINT32_C(0xC641510F), UINT32_C(0x95A41AB8), UINT32_C(0xC567FD4A) } },
        { { UINT32_C(0xD57C8DE9), UINT32_C(0x261578C7), UINT32_C(0x3836C5C8),
            UINT32_C(0xB9BC491F), UINT32_C(0x14C8038F), UINT32_C(0x993266B4),
            UINT32_C(0xFAA7CC39), UINT32_C(0xBACAD755), UINT32_C(0xD69B7E27),
            UINT32_C(0x418C4DEF), UINT32_C(0xAE751533), UINT32_C(0x53FDC5CD) },
          { UINT32_C(0xC3EEA63A), UINT32_C(0x6F3BD329), UINT32_C(0xE53DD29E),
            UINT32_C(0xA7A22091), UINT32_C(0xDC4C54EC), UINT32_C(0xB7164F73),
            UINT32_C(0x44D3D74E), UINT32_C(0xCA66290D), UINT32_C(0x4C9EA511),
            UINT32_C(0xF77C6242), UINT32_C(0x1F714C49), UINT32_C(0x34337F55) } },
        { { UINT32_C(0xA64B6C4B), UINT32_C(0x5ED2B216), UINT32_C(0x3AAE640D),
            UINT32_C(0x1C38794F), UINT32_C(0x8905794F), UINT32_C(0x30BBAEE0),
            UINT32_C(0xC8699CFB), UINT32_C(0x0D9EE41E), UINT32_C(0xCF7B7C29),
            UINT32_C(0xAF38DAF2), UINT32_C(0x43E53513), UINT32_C(0x0D6A05CA) },
          { UINT32_C(0x2606AB56), UINT32_C(0xBE96C644), UINT32_C(0xE9EB9734),
            UINT32_C(0x13E7A072), UINT32_C(0x5FF50CD7), UINT32_C(0xF9669445),
            UINT32_C(0x47DA6F1D), UINT32_C(0x68EF26B5), UINT32_C(0x23687CB7),
            UINT32_C(0xF0028738), UINT32_C(0x6217C1CE), UINT32_C(0x5ED9C876) } },
        { { UINT32_C(0x0A3A9691), UINT32_C(0x423BA513), UINT32_C(0xB3179296),
            UINT32_C(0xF421B1E7), UINT32_C(0x1A871E1B), UINT32_C(0x6B51BCDB),
            UINT32_C(0x464E4300), UINT32_C(0x6E3BB5B5), UINT32_C(0xFC6C54CC),
            UINT32_C(0x24171E2E), UINT32_C(0xD3E58DC2), UINT32_C(0xA9DFA947) },
          { UINT32_C(0x9DE9CFA7), UINT32_C(0x175B3309), UINT32_C(0x2D1015DA),
            UINT32_C(0x707B2529), UINT32_C(0x993EA65A), UINT32_C(0xCBB95F17),
            UINT32_C(0x0447450D), UINT32_C(0x93515063), UINT32_C(0x1B2753C9),
            UINT32_C(0x0F47B205), UINT32_C(0xE7D427CF), UINT32_C(0x4A0BAB14) } },
        { { UINT32_C(0xB5AA7CA1), UINT32_C(0xA39DEF39), UINT32_C(0xC47C33DF),
            UINT32_C(0x591CB173), UINT32_C(0x6BBAB872), UINT32_C(0xA09DAC79),
            UINT32_C(0x7208BA2F), UINT32_C(0x3EF9D7CF), UINT32_C(0x7A0A34FC),
            UINT32_C(0x3CC18931), UINT32_C(0xBCC3380F), UINT32_C(0xAE31C62B) },
          { UINT32_C(0x0287C0B4), UINT32_C(0xD72A6794), UINT32_C(0x68E334F1),
            UINT32_C(0x3373382C), UINT32_C(0xBD20C6A6), UINT32_C(0xD0310CA8),
            UINT32_C(0x42C033FD), UINT32_C(0xA2734B87), UINT32_C(0x8DCE4509),
            UINT32_C(0xA5D390F1), UINT32_C(0x3E1AFCB5), UINT32_C(0xFC84E74B) } },
        { { UINT32_C(0xF2CD8A9C), UINT32_C(0xB028334D), UINT32_C(0x570F76F6),
            UINT32_C(0xB8719291), UINT32_C(0x01065A2D), UINT32_C(0x662A386E),
            UINT32_C(0x53D940AE), UINT32_C(0xDF1634CB), UINT32_C(0x8F5B41F9),
            UINT32_C(0x625A7B83), UINT32_C(0xEE6AA1B4), UINT32_C(0xA033E4FE) },
          { UINT32_C(0x1E42BABB), UINT32_C(0x51E9D463), UINT32_C(0x0D388468),
            UINT32_C(0x660BC2E4), UINT32_C(0xFCBB114A), UINT32_C(0x3F702189),
            UINT32_C(0xB414CA78), UINT32_C(0x6B46FE35), UINT32_C(0x4A57316B),
            UINT32_C(0x328F6CF2), UINT32_C(0x381AD156), UINT32_C(0x917423B5) } },
        { { UINT32_C(0x5373A607), UINT32_C(0xAC19306E), UINT32_C(0x191D0969),
            UINT32_C(0x471DF8E3), UINT32_C(0xB9720D83), UINT32_C(0x380ADE35),
            UINT32_C(0x48F1FD5C), UINT32_C(0x7423FDF5), UINT32_C(0x49CABC95),
            UINT32_C(0x8B090C9F), UINT32_C(0xC9842F2F), UINT32_C(0xB768E8CD) },
          { UINT32_C(0xE56162D6), UINT32_C(0x399F456D), UINT32_C(0x4F326791),
            UINT32_C(0xBB6BA240), UINT32_C(0x342590BE), UINT32_C(0x8F4FBA3B),
            UINT32_C(0x3DFB6B3E), UINT32_C(0x053986B9), UINT32_C(0x190C7425),
            UINT32_C(0xBB6739F1), UINT32_C(0x32F7E95F), UINT32_C(0x32D4A553) } },
        { { UINT32_C(0x0DDBFB21), UINT32_C(0x0205A0EC), UINT32_C(0x33AC3407),
            UINT32_C(0x3010327D), UINT32_C(0x3348999B), UINT32_C(0xCF2F4DB3),
            UINT32_C(0x1551604A), UINT32_C(0x660DB9F4), UINT32_C(0x5D38D335),
            UINT32_C(0xC346C69A), UINT32_C(0x38882479), UINT32_C(0x64AAB3D3) },
          { UINT32_C(0x6AE44403), UINT32_C(0xA096B5E7), UINT32_C(0x645F76CD),
            UINT32_C(0x6B4C9571), UINT32_C(0x4711120F), UINT32_C(0x72E1CD5F),
            UINT32_C(0xF27CC3E1), UINT32_C(0x93EC42AC), UINT32_C(0xA72ABB12),
            UINT32_C(0x2D18D004), UINT32_C(0xC9841A04), UINT32_C(0x232E9568) } },
        { { UINT32_C(0x3CC7F908), UINT32_C(0xFF01DB22), UINT32_C(0xD13CDD3B),
            UINT32_C(0x9F214F8F), UINT32_C(0xE0B014B5), UINT32_C(0x38DADBB7),
            UINT32_C(0x94245C95), UINT32_C(0x2C548CCC), UINT32_C(0x809AFCE3),
            UINT32_C(0x714BE331), UINT32_C(0x9BFE957E), UINT32_C(0xBCC64410) },
          { UINT32_C(0x5B957F80), UINT32_C(0xC21C2D21), UINT32_C(0xBB8A4C42),
            UINT32_C(0xBA2D4FDC), UINT32_C(0x74817CEC), UINT32_C(0xFA6CD4AF),
            UINT32_C(0xC528EAD6), UINT32_C(0x9E7FB523), UINT32_C(0x7714B10E),
            UINT32_C(0xAED781FF), UINT32_C(0x94F04455), UINT32_C(0xB52BB592) } },
        { { UINT32_C(0x868CC68B), UINT32_C(0xA578BD69), UINT32_C(0x603F2C08),
            UINT32_C(0xA40FDC8D), UINT32_C(0x2D81B042), UINT32_C(0x53D79BD1),
            UINT32_C(0xA7587EAB), UINT32_C(0x1B136AF3), UINT32_C(0x868A16DB),
            UINT32_C(0x1ED4F939), UINT32_C(0xD0B98273), UINT32_C(0x775A61FB) },
          { UINT32_C(0xE56BEF8C), UINT32_C(0xBA5C12A6), UINT32_C(0xDDDC8595),
            UINT32_C(0xF926CE52), UINT32_C(0x586FE1F8), UINT32_C(0xA13F5C8F),
            UINT32_C(0x060DBB54), UINT32_C(0xEAC9F7F2), UINT32_C(0x51AF4342),
            UINT32_C(0x70C0AC3A), UINT32_C(0x79CDA450), UINT32_C(0xC16E303C) } },
        { { UINT32_C(0x8113F4EA), UINT32_C(0xD0DADD6C), UINT32_C(0x07BDF09F),
            UINT32_C(0xF14E3922), UINT32_C(0xAA7D877C), UINT32_C(0x3FE5E9C2),
            UINT32_C(0x48779264), UINT32_C(0x9EA95C19), UINT32_C(0x4FCB8344),
            UINT32_C(0xE93F65A7), UINT32_C(0x76D925A4), UINT32_C(0x9F40837E) },
          { UINT32_C(0x8271FFC7), UINT32_C(0x0EA6DA3F), UINT32_C(0xCC8F9B19),
            UINT32_C(0x557FA529), UINT32_C(0x78E6DDFD), UINT32_C(0x2613DBF1),
            UINT32_C(0x36B1E954), UINT32_C(0x7A7523B8), UINT32_C(0x406A87FB),
            UINT32_C(0x20EB3168), UINT32_C(0x03ABA56A), UINT32_C(0x64C21C14) } },
        { { UINT32_C(0xC032DD5F), UINT32_C(0xE86C9C2D), UINT32_C(0x86F16A21),
            UINT32_C(0x158CEB8E), UINT32_C(0x68326AF1), UINT32_C(0x0279FF53),
            UINT32_C(0x59F12BA5), UINT32_C(0x1FFE2E2B), UINT32_C(0x86826D45),
            UINT32_C(0xD75A46DB), UINT32_C(0x1E33E6AC), UINT32_C(0xE19B4841) },
          { UINT32_C(0x0E52991C), UINT32_C(0x5F0CC524), UINT32_C(0x8B116286),
            UINT32_C(0x645871F9), UINT32_C(0xFCAEC5D3), UINT32_C(0xAB3B4B1E),
            UINT32_C(0x51D0F698), UINT32_C(0x994C8DF0), UINT32_C(0xE5D13040),
            UINT32_C(0x06F890AF), UINT32_C(0x5F96C7C2), UINT32_C(0x72D9DC23) } },
        { { UINT32_C(0xE7886A80), UINT32_C(0x7C018DEE), UINT32_C(0x8786E4A3),
            UINT32_C(0xFA209330), UINT32_C(0xA4415CA1), UINT32_C(0xCEC8E2A3),
            UINT32_C(0xCC83CC60), UINT32_C(0x5C736FC1), UINT32_C(0xF00C259F),
            UINT32_C(0xFEF9788C), UINT32_C(0xDD29A6AD), UINT32_C(0xED5C01CB) },
          { UINT32_C(0x3E20825B), UINT32_C(0x87834A03), UINT32_C(0x123F9358),
            UINT32_C(0x13B1239D), UINT32_C(0xFBC286C1), UINT32_C(0x7E8869D0),
            UINT32_C(0x24CE8609), UINT32_C(0xC4AB5AA3), UINT32_C(0xB6349208),
            UINT32_C(0x38716BEE), UINT32_C(0xB322AE21), UINT32_C(0x0BDF4F99) } },
        { { UINT32_C(0x53E3494B), UINT32_C(0x6B97A2BF), UINT32_C(0x70F7A13E),
            UINT32_C(0xA8AA05C5), UINT32_C(0xF1305B51), UINT32_C(0x209709C2),
            UINT32_C(0xDAB76F2C), UINT32_C(0x57B31888), UINT32_C(0xAA2A406A),
            UINT32_C(0x75B2ECD7), UINT32_C(0xA35374A4), UINT32_C(0x88801A00) },
          { UINT32_C(0x45C0471B), UINT32_C(0xE1458D1C), UINT32_C(0x322C1AB0),
            UINT32_C(0x5760E306), UINT32_C(0xAD6AB0A6), UINT32_C(0x789A0AF1),
            UINT32_C(0xF458B9CE), UINT32_C(0x74398DE1), UINT32_C(0x32E0C65F),
            UINT32_C(0x1652FF9F), UINT32_C(0xFFFB3A52), UINT32_C(0xFAF1F9D5) } },
    },
    {
        { { UINT32_C(0xD1D1B007), UINT32_C(0xA05C751C), UINT32_C(0x0213E478),
            UINT32_C(0x016C213B), UINT32_C(0xF4C98FEE), UINT32_C(0x9C56E26C),
            UINT32_C(0xE7B3A7C7), UINT32_C(0x6084F8B9), UINT32_C(0xDECC1646),
            UINT32_C(0xA0B042F6), UINT32_C(0xFBF3A0BC), UINT32_C(0x4A6F3C1A) },
          { UINT32_C(0x51C9F909), UINT32_C(0x94524C2C), UINT32_C(0x3A6D3748),
            UINT32_C(0xF3B3AD40), UINT32_C(0x7CE1F9F5), UINT32_C(0x18792D6E),
            UINT32_C(0xFC0C34FA), UINT32_C(0x8EBC2FD7), UINT32_C(0x780A1693),
            UINT32_C(0x032A9F41), UINT32_C(0x56A60019), UINT32_C(0x34F9801E) } },
        { { UINT32_C(0xF0DB3751), UINT32_C(0xB398290C), UINT32_C(0xBA42C976),
            UINT32_C(0x01170580), UINT32_C(0x56560B89), UINT32_C(0x3E71AA29),
            UINT32_C(0x50E6647B), UINT32_C(0x80817AAC), UINT32_C(0xA0BE42DA),
            UINT32_C(0x35C833AD), UINT32_C(0xF1BABA4E), UINT32_C(0xFA3C6148) },
          { UINT32_C(0xCD8F6253), UINT32_C(0xC57BE645), UINT32_C(0xC657AD0D),
            UINT32_C(0x77CEE46B), UINT32_C(0x0DEFD908), UINT32_C(0x83007731),
            UINT32_C(0x899CBA56), UINT32_C(0x92FE9BCE), UINT32_C(0xBCEFFB5A),
            UINT32_C(0x48450EC4), UINT32_C(0xF2F5F4BF), UINT32_C(0xE615148D) } },
        { { UINT32_C(0x90B86166), UINT32_C(0xF55EDABB), UINT32_C(0x075430A2),
            UINT32_C(0x27F7D784), UINT32_C(0x9BF17161), UINT32_C(0xF53E822B),
            UINT32_C(0xAFE808DC), UINT32_C(0x4A5B3B93), UINT32_C(0xD7272F55),
            UINT32_C(0x590BBBDE), UINT32_C(0xEAEA79A1), UINT32_C(0x233D63FA) },
          { UINT32_C(0xFE1EBA07), UINT32_C(0xD7042BEA), UINT32_C(0x10750D7E),
            UINT32_C(0xD2B9AEA0), UINT32_C(0x31078AA5), UINT32_C(0xD8D1E690),
            UINT32_C(0x7E37BC8B), UINT32_C(0x9E837F18), UINT32_C(0x85008975),
            UINT32_C(0x9558FF4F), UINT32_C(0x421FE867), UINT32_C(0x93EDB837) } },
        { { UINT32_C(0x83D55B5A), UINT32_C(0xAA6489DF), UINT32_C(0x86BF27F7),
            UINT32_C(0xEA092E49), UINT32_C(0x5FA2EFEC), UINT32_C(0x4D8943A9),
            UINT32_C(0x720E1A8C), UINT32_C(0xC9BAAE53), UINT32_C(0x95A4F8A3),
            UINT32_C(0xC055444B), UINT32_C(0xA7C1206B), UINT32_C(0x93BD01E8) },
          { UINT32_C(0x714A27DF), UINT32_C(0xD97765B6), UINT32_C(0x193F1B16),
            UINT32_C(0xD622D954), UINT32_C(0xF1503B15), UINT32_C(0x115CC35A),
            UINT32_C(0xA9FA21F8), UINT32_C(0x1DD5359F), UINT32_C(0x6DFED1F1),
            UINT32_C(0x197C3299), UINT32_C(0xF77F2679), UINT32_C(0xDEE8B7C9) } },
        { { UINT32_C(0x394FD855), UINT32_C(0x5405179F), UINT32_C(0x49FDFB33),
            UINT32_C(0xC9D6E244), UINT32_C(0xBD903393), UINT32_C(0x70EBCAB4),
            UINT32_C(0xA2C56780), UINT32_C(0x0D3A3899), UINT32_C(0x683D1A0A),
            UINT32_C(0x012C7256), UINT32_C(0x80A48F3B), UINT32_C(0xC688FC88) },
          { UINT32_C(0x6F7DF527), UINT32_C(0x18095754), UINT32_C(0x71315D16),
            UINT32_C(0x9E339B4B), UINT32_C(0xA956BB12), UINT32_C(0x90560C28),
            UINT32_C(0xD42EEE8D), UINT32_C(0x2BECEA60), UINT32_C(0x50632653),
            UINT32_C(0x82AEB9A7), UINT32_C(0xDFA5CD6A), UINT32_C(0xED34353E) } },
        { { UINT32_C(0x91AECCE4), UINT32_C(0x82154D2C), UINT32_C(0x5041887F),
            UINT32_C(0x312C6070), UINT32_C(0xFB9FBD71), UINT32_C(0xECF589F3),
            UINT32_C(0xB524BDE4), UINT32_C(0x67660A7D), UINT32_C(0x724ACF23),
            UINT32_C(0xE99B029D), UINT32_C(0x6D1CD891), UINT32_C(0xDF06E4AF) },
          { UINT32_C(0x80EE304D), UINT32_C(0x07806CB5), UINT32_C(0x7443A8F8),
            UINT32_C(0x0C70BB9F), UINT32_C(0x08B0830A), UINT32_C(0x01EC3414),
            UINT32_C(0x5A81510B), UINT32_C(0xFD7B63C3), UINT32_C(0x453B5F93),
            UINT32_C(0xE90A0A39), UINT32_C(0x9BC71725), UINT32_C(0xAB700F8F) } },
        { { UINT32_C(0xB9F00793), UINT32_C(0x9401AEC2), UINT32_C(0xB997F0BF),
            UINT32_C(0x064EC4F4), UINT32_C(0x849240C8), UINT32_C(0xDC0CC1FD),
            UINT32_C(0xB6E92D72), UINT32_C(0x39A75F37), UINT32_C(0x0224A4AB),
            UINT32_C(0xAA43CA5D), UINT32_C(0x54614C47), UINT32_C(0x9C4D6325) },
          { UINT32_C(0xC6709DA3), UINT32_C(0x1767366F), UINT32_C(0x23479232),
            UINT32_C(0xA6B482D1), UINT32_C(0x84D63E85), UINT32_C(0x54DC6DDC),
            UINT32_C(0xC99D3B9E), UINT32_C(0x0ACCB5AD), UINT32_C(0xE8AA3ABF),
            UINT32_C(0x211716BB), UINT32_C(0x69EC6406), UINT32_C(0xD0FE25AD) } },
        { { UINT32_C(0xDF85C705), UINT32_C(0x0D5C1769), UINT32_C(0xA409DCD1),
            UINT32_C(0x7086C93D), UINT32_C(0x0E8D75D8), UINT32_C(0x9710839D),
            UINT32_C(0xEBDD4177), UINT32_C(0x17B7DB75), UINT32_C(0xF649A809),
            UINT32_C(0xAF69EB58), UINT32_C(0x8A84E220), UINT32_C(0x6EF19EA2) },
          { UINT32_C(0x65C278B2), UINT32_C(0x36EB5C66), UINT32_C(0x81EA9D65),
            UINT32_C(0xD2A15128), UINT32_C(0x769300AD), UINT32_C(0x4FCBA840),
            UINT32_C(0xC8E536E5), UINT32_C(0xC2052CCD), UINT32_C(0xAC263B8F),
            UINT32_C(0x9CAEE014), UINT32_C(0xF9239663), UINT32_C(0x56F7ED7A) } },
        { { UINT32_C(0xAC9E09E1), UINT32_C(0xF6FA251F), UINT32_C(0x955A2853),
            UINT32_C(0xA3775605), UINT32_C(0xF2A4BD78), UINT32_C(0x977B8D21),
            UINT32_C(0x3E096410), UINT32_C(0xF68AA7FF), UINT32_C(0x65F88419),
            UINT32_C(0x01AB0552), UINT32_C(0xBB93F64E), UINT32_C(0xC4C8D77E) },
          { UINT32_C(0x3451FE64), UINT32_C(0x71825111), UINT32_C(0x46F9BAF0),
            UINT32_C(0xFA0F905B), UINT32_C(0xCA49EF1A), UINT32_C(0x79BE3BF3),
            UINT32_C(0x6CB02071), UINT32_C(0x831109B2), UINT32_C(0xC4DDBFE5),
            UINT32_C(0x765F935F), UINT32_C(0x80E5A3BA), UINT32_C(0x6F99CD14) } },
        { { UINT32_C(0x234F91FF), UINT32_C(0xD2E8DA04), UINT32_C(0x813867AA),
            UINT32_C(0x4DED4D6D), UINT32_C(0xE0A0D945), UINT32_C(0x3B50175D),
            UINT32_C(0x4EB78137), UINT32_C(0x55AC7406), UINT32_C(0xE1D47730),
            UINT32_C(0xE9FA7F6E), UINT32_C(0x5CBF2176), UINT32_C(0x2C171531) },
          { UINT32_C(0x2BE7A47D), UINT32_C(0xA521788F), UINT32_C(0x3FCF1AB3),
            UINT32_C(0x95B15A27), UINT32_C(0xF28A946A), UINT32_C(0xAADA6401),
            UINT32_C(0x8B4E898B), UINT32_C(0x628B2EF4), UINT32_C(0x6D6592CC),
            UINT32_C(0x0E6F4629), UINT32_C(0xA723CADD), UINT32_C(0x997C7094) } },
        { { UINT32_C(0x6AFE80C6), UINT32_C(0x878BCE11), UINT32_C(0x007BBA38),
            UINT32_C(0xA89ABC9D), UINT32_C(0xA7CC267F), UINT32_C(0xB0C1F87B),
            UINT32_C(0x5104FF04), UINT32_C(0x86D33B9D), UINT32_C(0x2EF1BA42),
            UINT32_C(0xB0504B1B), UINT32_C(0xB2827E88), UINT32_C(0x21693048) },
          { UINT32_C(0x79CFCD14), UINT32_C(0x11F1CCD5), UINT32_C(0x94AD227E),
            UINT32_C(0x59C09FFA), UINT32_C(0x3EA91ACF), UINT32_C(0x95A4ADCB),
            UINT32_C(0xB4370BAA), UINT32_C(0x1346238B), UINT32_C(0x3E1367B0),
            UINT32_C(0xB099D202), UINT32_C(0x90F23CEA), UINT32_C(0xCF5BBDE6) } },
        { { UINT32_C(0xBCB3BE5E), UINT32_C(0x453299BB), UINT32_C(0x38E9FF97),
            UINT32_C(0x123C588E), UINT32_C(0xF6A2E521), UINT32_C(0x8C115DD9),
            UINT32_C(0xFF7D4B98), UINT32_C(0x6E333C11), UINT32_C(0xDA73E736),
            UINT32_C(0x9DD061E5), UINT32_C(0x5CA53056), UINT32_C(0xC6AB7B3A) },
          { UINT32_C(0x5B30A76B), UINT32_C(0xF1EF3EE3), UINT32_C(0x961BA11F),
            UINT32_C(0xADD6B44A), UINT32_C(0x2CA6E030), UINT32_C(0x7BB00B75),
            UINT32_C(0x2FE270AD), UINT32_C(0x270272E8), UINT32_C(0x241A9239),
            UINT32_C(0x23BC6F4F), UINT32_C(0x0BB94A94), UINT32_C(0x88581E13) } },
        { { UINT32_C(0x24EEF67F), UINT32_C(0xBD225A69), UINT32_C(0x0412CEB7),
            UINT32_C(0x7CFD9614), UINT32_C(0x99AC298E), UINT32_C(0xF6DE1679),
            UINT32_C(0xED6C3571), UINT32_C(0xB20FD895), UINT32_C(0x61836C56),
            UINT32_C(0x03C73B78), UINT32_C(0xABA6CB34), UINT32_C(0xEE3C3A16) },
          { UINT32_C(0x4138408A), UINT32_C(0x9E8C5667), UINT32_C(0x2DD6EBDF),
            UINT32_C(0xEC25FCB1), UINT32_C(0xDBBDF6E3), UINT32_C(0xC54C33FD),
            UINT32_C(0x4A3C9DD4), UINT32_C(0x93E0913B), UINT32_C(0x35EDEED4),
            UINT32_C(0x66D7D135), UINT32_C(0x453FB66E), UINT32_C(0xD29A36C4) } },
        { { UINT32_C(0x9F1943AF), UINT32_C(0x7F192F03), UINT32_C(0x4E0B5FB0),
            UINT32_C(0x6488163F), UINT32_C(0x53599226), UINT32_C(0x66A45C69),
            UINT32_C(0x9AD15A73), UINT32_C(0x924E2E43), UINT32_C(0x42A99D76),
            UINT32_C(0x8B553DB7), UINT32_C(0x0451F521), UINT32_C(0x4BC6B53B) },
          { UINT32_C(0x101F8AD6), UINT32_C(0xC029B5EF), UINT32_C(0xC507EED9),
            UINT32_C(0x6A4DA71C), UINT32_C(0x30BB22F3), UINT32_C(0x3ADFAEC0),
            UINT32_C(0xB514F85B), UINT32_C(0x81BCAF7A), UINT32_C(0x5A7E60D3),
            UINT32_C(0x2E1E6EFF), UINT32_C(0xAE39D42F), UINT32_C(0x5270ABC0) } },
        { { UINT32_C(0x3901F0F8), UINT32_C(0x86D56DEB), UINT32_C(0xEED5F650),
            UINT32_C(0x1D0BC792), UINT32_C(0xCA1114A3), UINT32_C(0x1A2DDFD8),
            UINT32_C(0xF1DD316D), UINT32_C(0x94ABF4B1), UINT32_C(0x3D9F18EF),
            UINT32_C(0xF72179E4), UINT32_C(0x9AA2CABF), UINT32_C(0x52A0921E) },
          { UINT32_C(0xA7452883), UINT32_C(0xECDA9E27), UINT32_C(0xAFD771B4),
            UINT32_C(0x7E90850A), UINT32_C(0x9CC0465C), UINT32_C(0xD40F87EA),
            UINT32_C(0x865CDA36), UINT32_C(0x8CFCB60A), UINT32_C(0x7C650942),
            UINT32_C(0x3DBEC2CC), UINT32_C(0xE718CA9D), UINT32_C(0x071A4EE7) } },
        { { UINT32_C(0x276AC5F3), UINT32_C(0x73C0E4FF), UINT32_C(0xBDB97EA1),
            UINT32_C(0xE7BA5A6A), UINT32_C(0xC5808398), UINT32_C(0x638CA54E),
            UINT32_C(0x413855E5), UINT32_C(0x8258DC82), UINT32_C(0x57F07614),
            UINT32_C(0x35DDD2E9), UINT32_C(0x1DC13BF9), UINT32_C(0xF98DD692) },
          { UINT32_C(0xF16DCD84), UINT32_C(0x3A4C0088), UINT32_C(0x833D83F9),
            UINT32_C(0xF192EADD), UINT32_C(0xA6D61D29), UINT32_C(0x3C26C931),
            UINT32_C(0xDE0AD7A1), UINT32_C(0x589FDD52), UINT32_C(0x0442D37F),
            UINT32_C(0x7CD83DD2), UINT32_C(0x403ECBFC), UINT32_C(0x1E47E777) } },
    },
    {
        { { UINT32_C(0x70D4D7BC), UINT32_C(0x2AF8ED81), UINT32_C(0xB632435C),
            UINT32_C(0xABC3E15F), UINT32_C(0x78219356), UINT32_C(0x4C0E726F),
            UINT32_C(0xB87254C4), UINT32_C(0x8C1962A1), UINT32_C(0xC9E7691A),
            UINT32_C(0x30796A71), UINT32_C(0xA75A12EE), UINT32_C(0xD453EF19) },
          { UINT32_C(0x13AE4964), UINT32_C(0x535F42C2), UINT32_C(0x0DA9586A),
            UINT32_C(0x86831C3C), UINT32_C(0xE39A7A58), UINT32_C(0xB7F1EF35),
            UINT32_C(0xD459B91A), UINT32_C(0xA2789AE2), UINT32_C(0x02FD429D),
            UINT32_C(0xEADBCA7F), UINT32_C(0x65290F57), UINT32_C(0x94F215D4) } },
        { { UINT32_C(0x1CFB79AC), UINT32_C(0x37ED2BE5), UINT32_C(0xE7AF84C3),
            UINT32_C(0x801946F3), UINT32_C(0xE77C2F00), UINT32_C(0xB061AD8A),
            UINT32_C(0x44DE16A8), UINT32_C(0xE87E1A9A), UINT32_C(0x7EE490FF),
            UINT32_C(0xDF4F57C8), UINT32_C(0x005993ED), UINT32_C(0x4E793B49) },
          { UINT32_C(0xBCCB593F), UINT32_C(0xE1036387), UINT32_C(0x95E09B80),
            UINT32_C(0xF1749411), UINT32_C(0x5AB42F91), UINT32_C(0x59CB20D1),
            UINT32_C(0xAC0FF033), UINT32_C(0xA738A18D), UINT32_C(0x2AC1E7F4),
            UINT32_C(0xDA501A2E), UINT32_C(0x84D8A6E0), UINT32_C(0x1B67EDA0) } },
        { { UINT32_C(0x1080E90B), UINT32_C(0x1D27EFCE), UINT32_C(0x3FD01DC6),
            UINT32_C(0xA2815246), UINT32_C(0xCAA26D18), UINT32_C(0x99A3FB83),
            UINT32_C(0xB82BABBE), UINT32_C(0xD27E6133), UINT32_C(0xD783DD60),
            UINT32_C(0x61030DFD), UINT32_C(0x73C78CB8), UINT32_C(0x295A2913) },
          { UINT32_C(0x68BE6A92), UINT32_C(0x8707A2CF), UINT32_C(0xEEB3474A),
            UINT32_C(0xC9C2FB98), UINT32_C(0xA2B176B8), UINT32_C(0x7C3FD412),
            UINT32_C(0xC7202101), UINT32_C(0xD5B52E2F), UINT32_C(0xF0A6D536),
            UINT32_C(0x24A63030), UINT32_C(0x04648EC0), UINT32_C(0x05842DE3) } },
        { { UINT32_C(0x30577AC9), UINT32_C(0x67477CDC), UINT32_C(0x244F92A8),
            UINT32_C(0x51DD9775), UINT32_C(0x917EEC66), UINT32_C(0x31FD60B9),
            UINT32_C(0xD66C5C1D), UINT32_C(0xACD95BD4), UINT32_C(0xBF9508BA),
            UINT32_C(0x2E0551F3), UINT32_C(0x688CB243), UINT32_C(0x121168E1) },
          { UINT32_C(0x4540D230), UINT32_C(0x8C039740), UINT32_C(0x009ECDF9),
            UINT32_C(0xC4ED3CF6), UINT32_C(0x44DB62AF), UINT32_C(0x191825E1),
            UINT32_C(0xC4A030DA), UINT32_C(0x3EE8ACAB), UINT32_C(0x94081504),
            UINT32_C(0x8AB154A8), UINT32_C(0x486C9CD0), UINT32_C(0x1FE09E4B) } },
        { { UINT32_C(0xD113450B), UINT32_C(0x512F82F9), UINT32_C(0x2DBC9197),
            UINT32_C(0x5878C901), UINT32_C(0xE13F355B), UINT32_C(0xDB87412B),
            UINT32_C(0x935B8A5E), UINT32_C(0x0A0A4A9B), UINT32_C(0xF25A5351),
            UINT32_C(0x818587BD), UINT32_C(0x31E3D9C7), UINT32_C(0xE8079310) },
          { UINT32_C(0x611BC1B1), UINT32_C(0x8B1D47C7), UINT32_C(0x72A823F2),
            UINT32_C(0x51722B58), UINT32_C(0x53B36B3E), UINT32_C(0x6F97EE8A),
            UINT32_C(0x946DD453), UINT32_C(0x6E085AAC), UINT32_C(0xE65E6533),
            UINT32_C(0x2EC5057D), UINT32_C(0x4BB18801), UINT32_C(0xF82D9D71) } },
        { { UINT32_C(0x8BA5AA8E), UINT32_C(0xAD81FA93), UINT32_C(0x8F7AA69E),
            UINT32_C(0x723E628E), UINT32_C(0xEF35937C), UINT32_C(0x0BA7C2DE),
            UINT32_C(0x6DECFB40), UINT32_C(0x83A43EC5), UINT32_C(0xE60C4F2D),
            UINT32_C(0xF520F849), UINT32_C(0x457E3B5E), UINT32_C(0x8260E8AE) },
          { UINT32_C(0xBF1D9ED7), UINT32_C(0x7CE874F0), UINT32_C(0x7F1A5466),
            UINT32_C(0x5FDE3553), UINT32_C(0x0C162DBB), UINT32_C(0x5A63777C),
            UINT32_C(0xDAD87289), UINT32_C(0x0FD04F8C), UINT32_C(0x640761D5),
            UINT32_C(0xCA2D9E0E), UINT32_C(0x38501ADB), UINT32_C(0x4615CFF8) } },
        { { UINT32_C(0x110B4A25), UINT32_C(0x9422789B), UINT32_C(0x70AD8CC1),
            UINT32_C(0x5C26779F), UINT32_C(0xEC4F1E14), UINT32_C(0x4EE6A748),
            UINT32_C(0x5C7AB5E0), UINT32_C(0xFB584A0D), UINT32_C(0xFB21EE66),
            UINT32_C(0xED1DCB0B), UINT32_C(0x11C6863C), UINT32_C(0xDBED1F00) },
          { UINT32_C(0xB1B1D187), UINT32_C(0xD2969269), UINT32_C(0xAFE964E6),
            UINT32_C(0xF7D0C3F2), UINT32_C(0x12BB865E), UINT32_C(0xE05EE93F),
            UINT32_C(0xED79118E), UINT32_C(0x1AFB7BEE), UINT32_C(0x0F0FE453),
            UINT32_C(0x220AF138), UINT32_C(0x52782AB9), UINT32_C(0x1463AA1A) } },
        { { UINT32_C(0xD7DBE5F9), UINT32_C(0x7C139D56), UINT32_C(0x0B83685B),
            UINT32_C(0xFC16E611), UINT32_C(0x9018463C), UINT32_C(0xFA723C02),
            UINT32_C(0x840BF5D7), UINT32_C(0xC472458C), UINT32_C(0x0AF07591),
            UINT32_C(0x4D809359), UINT32_C(0x3308DFD9), UINT32_C(0x418D8830) },
          { UINT32_C(0x0C365AE3), UINT32_C(0x9B381E04), UINT32_C(0xF8190FD1),
            UINT32_C(0x3780BF33), UINT32_C(0xDD03E854), UINT32_C(0x45397418),
            UINT32_C(0x4E51E491), UINT32_C(0xA95D030F), UINT32_C(0xE3286CEA),
            UINT32_C(0x87C8C686), UINT32_C(0x900B5F83), UINT32_C(0x01C773BF) } },
        { { UINT32_C(0x78673B02), UINT32_C(0xDABE3475), UINT32_C(0xF6E7395E),
            UINT32_C(0x4F0F25CE), UINT32_C(0xD181AD45), UINT32_C(0x3117ABB9),
            UINT32_C(0xAA13DE0B), UINT32_C(0x4B559F88), UINT32_C(0xEA7C9745),
            UINT32_C(0xFD8EFE78), UINT32_C(0x5DD21682), UINT32_C(0x08060047) },
          { UINT32_C(0xD4C86FFC), UINT32_C(0xC0F5DE4B), UINT32_C(0xF21AB6A2),
            UINT32_C(0x4BB14B1E), UINT32_C(0xF50C1D12), UINT32_C(0xACB53A6C),
            UINT32_C(0x5CC9162E), UINT32_C(0x46AAC450), UINT32_C(0x2DE240B6),
            UINT32_C(0x049C51E0), UINT32_C(0xE383C3B0), UINT32_C(0xBB2DC016) } },
        { { UINT32_C(0x8E438C92), UINT32_C(0xA3C56AD2), UINT32_C(0xB2CEAF1A),
            UINT32_C(0x7C43F98F), UINT32_C(0xE2150778), UINT32_C(0x397C44F7),
            UINT32_C(0x71A24131), UINT32_C(0x48D17AB7), UINT32_C(0x1E2ACDA9),
            UINT32_C(0xCC513863), UINT32_C(0xF0C9BAC9), UINT32_C(0x2C76A55E) },
          { UINT32_C(0x7EA4BB7B), UINT32_C(0x4D74CDCE), UINT32_C(0xB1B3C2BA),
            UINT32_C(0x834BD5BF), UINT32_C(0xCCC310A4), UINT32_C(0x46E2911E),
            UINT32_C(0x0FC1BF13), UINT32_C(0xD3DE84AA), UINT32_C(0x80A03AD3),
            UINT32_C(0x27F2892F), UINT32_C(0x3BD2F08B), UINT32_C(0x85B47620) } },
        { { UINT32_C(0x567AF533), UINT32_C(0xAB1CB818), UINT32_C(0xBAC2705A),
            UINT32_C(0x273B4537), UINT32_C(0x22C84AB6), UINT32_C(0x133066C4),
            UINT32_C(0x4830BFC1), UINT32_C(0xC3590DE6), UINT32_C(0x5E4742D0),
            UINT32_C(0xEA297869), UINT32_C(0x4F3164C0), UINT32_C(0xF6D8C694) },
          { UINT32_C(0xC1249588), UINT32_C(0x09E85F3D), UINT32_C(0x4EC64DF7),
            UINT32_C(0x6C2BB05D), UINT32_C(0x8B78000F), UINT32_C(0xD267115E),
            UINT32_C(0xC7E4A316), UINT32_C(0x07C5D7AE), UINT32_C(0x4619E5BD),
            UINT32_C(0xCB1187BA), UINT32_C(0xA43F7EEE), UINT32_C(0x57B1D4EF) } },
        { { UINT32_C(0xC8176A96), UINT32_C(0x3618891F), UINT32_C(0xE5808B97),
            UINT32_C(0x62C4B084), UINT32_C(0x4DD95D6E), UINT32_C(0xDE558546),
            UINT32_C(0x730B2EA4), UINT32_C(0x27A8133E), UINT32_C(0x6AF318A0),
            UINT32_C(0xE07CEEC3), UINT32_C(0xCE24FD2C), UINT32_C(0x0ACC1286) },
          { UINT32_C(0xDD4D307C), UINT32_C(0x8A48FE4A), UINT32_C(0x18CDE0DA),
            UINT32_C(0x71A9BA9C), UINT32_C(0xD5D79747), UINT32_C(0x655E2B66),
            UINT32_C(0xA79AEDC7), UINT32_C(0x409FE856), UINT32_C(0xD287E5CF),
            UINT32_C(0xC5A9F244), UINT32_C(0x4E82EC39), UINT32_C(0xCCE10384) } },
        { { UINT32_C(0xF25D364C), UINT32_C(0x00675BA7), UINT32_C(0x68D36BDF),
            UINT32_C(0x7A7F1629), UINT32_C(0xA9E23F29), UINT32_C(0x35EC468A),
            UINT32_C(0x2D926E6C), UINT32_C(0xF797AC50), UINT32_C(0x4B4F4376),
            UINT32_C(0x639BA453), UINT32_C(0x51FF9519), UINT32_C(0xD71B430F) },
          { UINT32_C(0x2CF5635C), UINT32_C(0xB8C439EC), UINT32_C(0x81980393),
            UINT32_C(0x0CE4C8D1), UINT32_C(0x64123B15), UINT32_C(0x4C5362A9),
            UINT32_C(0xFFDCF096), UINT32_C(0x6E0421E0), UINT32_C(0x10D1F914),
            UINT32_C(0x624A855F), UINT32_C(0x614DCD29), UINT32_C(0x7D8F3AB7) } },
        { { UINT32_C(0xB3493CE0), UINT32_C(0xD9219ADA), UINT32_C(0x52F09AE5),
            UINT32_C(0x971B243A), UINT32_C(0xE24E3674), UINT32_C(0xC16C9BF8),
            UINT32_C(0xCE68C7CD), UINT32_C(0x026D408D), UINT32_C(0x358209E3),
            UINT32_C(0xF9B33DD9), UINT32_C(0xF3B2A206), UINT32_C(0x02D0595D) },
          { UINT32_C(0x60D15640), UINT32_C(0xBF994271), UINT32_C(0x15B5466A),
            UINT32_C(0x6DA7A04E), UINT32_C(0x1CADB50D), UINT32_C(0x03AA4ED8),
            UINT32_C(0x129A4253), UINT32_C(0x1548F029), UINT32_C(0xB842865A),
            UINT32_C(0x41741F7E), UINT32_C(0xA3F88C98), UINT32_C(0x859FE0A4) } },
        { { UINT32_C(0x05FD7553), UINT32_C(0x80DE085A), UINT32_C(0xB897566B),
            UINT32_C(0x4A4AB91E), UINT32_C(0x2F1C173F), UINT32_C(0x33BCD475),
            UINT32_C(0xC100C013), UINT32_C(0x4E238896), UINT32_C(0xD614B34B),
            UINT32_C(0x1C88500D), UINT32_C(0xC3BA9E23), UINT32_C(0x0401C5F6) },
          { UINT32_C(0xD0AF0DE5), UINT32_C(0x8E8003C4), UINT32_C(0x9D0DCBB9),
            UINT32_C(0x19B1DFB5), UINT32_C(0xEBEF7AB6), UINT32_C(0x4A3640A9),
            UINT32_C(0x959B15F6), UINT32_C(0xEDAFD65B), UINT32_C(0x7FB95821),
            UINT32_C(0x8092EF7F), UINT32_C(0xCE2E45D1), UINT32_C(0xAB8DD52E) } },
        { { UINT32_C(0xB9CFE6BF), UINT32_C(0xD1F2D6B8), UINT32_C(0x00073F6F),
            UINT32_C(0x6358810B), UINT32_C(0xD712106E), UINT32_C(0x5FCE5993),
            UINT32_C(0x1C024C91), UINT32_C(0x5EE6B271), UINT32_C(0x453DB663),
            UINT32_C(0xD0248FF5), UINT32_C(0xADB835E8), UINT32_C(0xD6D81CB2) },
          { UINT32_C(0xFDFCB4C7), UINT32_C(0x8696CFEC), UINT32_C(0x53BC9045),
            UINT32_C(0x696B7FCB), UINT32_C(0xDDA56981), UINT32_C(0xAB4D3807),
            UINT32_C(0x1E4B943B), UINT32_C(0x2F998052), UINT32_C(0x166B7F18),
            UINT32_C(0x8AA76ADB), UINT32_C(0x52A2D7ED), UINT32_C(0x63934301) } },
    },
    {
        { { UINT32_C(0xA368EFF6), UINT32_C(0xBBCCCE39), UINT32_C(0x8CEB5C43),
            UINT32_C(0xD8CAABDF), UINT32_C(0xD2252FDA), UINT32_C(0x9EAE35A5),
            UINT32_C(0x54E7DD49), UINT32_C(0xA8F4F209), UINT32_C(0x295100FD),
            UINT32_C(0xA56D72A6), UINT32_C(0x56767727), UINT32_C(0x20FC1FE8) },
          { UINT32_C(0x0BBAA5AB), UINT32_C(0xBF60B248), UINT32_C(0x313911F2),
            UINT32_C(0xA4F3CE5A), UINT32_C(0xB93DAB9C), UINT32_C(0xC2A67AD4),
            UINT32_C(0x22D71F39), UINT32_C(0x18CD0ED0), UINT32_C(0x5F304DB2),
            UINT32_C(0x04380C42), UINT32_C(0x6729C821), UINT32_C(0x26420CBB) } },
        { { UINT32_C(0xBDFBCAE8), UINT32_C(0x26BD07D6), UINT32_C(0xDF01A80A),
            UINT32_C(0x10B5173F), UINT32_C(0x6798B96C), UINT32_C(0xD831C546),
            UINT32_C(0x1D3F3859), UINT32_C(0x1D6B4108), UINT32_C(0x991B9EC7),
            UINT32_C(0x501D38EC), UINT32_C(0xD78431A9), UINT32_C(0x26319283) },
          { UINT32_C(0x118B343C), UINT32_C(0x8B85BAF7), UINT32_C(0x58DEF7D0),
            UINT32_C(0x4696CDDD), UINT32_C(0x7ACDCF58), UINT32_C(0xEFC7C110),
            UINT32_C(0x848D5842), UINT32_C(0xD9AF415C), UINT32_C(0x0AC7FDAC),
            UINT32_C(0x6B5A06BC), UINT32_C(0xA344319B), UINT32_C(0x7D623E0D) } },
        { { UINT32_C(0x0C9D3547), UINT32_C(0x4C0D7806), UINT32_C(0xCF2AED47),
            UINT32_C(0x993F048D), UINT32_C(0xE4B57E22), UINT32_C(0x5217C453),
            UINT32_C(0xF4172B28), UINT32_C(0xB4669E35), UINT32_C(0x49F999F8),
            UINT32_C(0x509A3CD0), UINT32_C(0x87C69D41), UINT32_C(0xD19F8632) },
          { UINT32_C(0x4C8FDED0), UINT32_C(0xE14D01E8), UINT32_C(0xEAFD9E1C),
            UINT32_C(0x342880FD), UINT32_C(0x70DC2BF0), UINT32_C(0x0E17BFF2),
            UINT32_C(0xC0186400), UINT32_C(0x46560B7B), UINT32_C(0x49A4DD34),
            UINT32_C(0xE28C7B9C), UINT32_C(0x0F325D06), UINT32_C(0x18211916) } },
        { { UINT32_C(0xD7E02E18), UINT32_C(0x46D70888), UINT32_C(0xD9F11FD9),
            UINT32_C(0x7C806954), UINT32_C(0x4FBEA271), UINT32_C(0xE4948FCA),
            UINT32_C(0xBD80A9DF), UINT32_C(0x7D6C7765), UINT32_C(0xF3871C71),
            UINT32_C(0x1B470EA6), UINT32_C(0x8330A570), UINT32_C(0xD62DE244) },
          { UINT32_C(0xC659C3A7), UINT32_C(0xDAECDDC1), UINT32_C(0x077F7AFC),
            UINT32_C(0x8621E513), UINT32_C(0xCAEEEF13), UINT32_C(0x56C7CD84),
            UINT32_C(0xC685A356), UINT32_C(0xC60C910F), UINT32_C(0x9DD93DDC),
            UINT32_C(0xE68BC5C5), UINT32_C(0xFEB64895), UINT32_C(0xD904E89F) } },
        { { UINT32_C(0x8BA7917A), UINT32_C(0x75D874FB), UINT32_C(0xFD043BD4),
            UINT32_C(0x18FA7F53), UINT32_C(0x1FC3979E), UINT32_C(0x212A0AD7),
            UINT32_C(0x5D6EAC0E), UINT32_C(0x5703A7D9), UINT32_C(0x017DEAD5),
            UINT32_C(0x222F7188), UINT32_C(0x0F6C1817), UINT32_C(0x1EC687B7) },
          { UINT32_C(0x238BACB6), UINT32_C(0x23412FC3), UINT32_C(0x54CED154),
            UINT32_C(0xB85D70E9), UINT32_C(0xBDA674D0), UINT32_C(0xD4E06722),
            UINT32_C(0x36F5A0C2), UINT32_C(0x3EA5F178), UINT32_C(0xF5C6D2CA),
            UINT32_C(0x7E7D79CF), UINT32_C(0x3DBB3C73), UINT32_C(0x1FFF9464) } },
        { { UINT32_C(0xF163E4A8), UINT32_C(0x916E19D0), UINT32_C(0x1489DF17),
            UINT32_C(0x1E6740E7), UINT32_C(0x339F3A47), UINT32_C(0x1EAF9723),
            UINT32_C(0x124B8DAD), UINT32_C(0x22F0ED1A), UINT32_C(0x49C3DD04),
            UINT32_C(0x39C9166C), UINT32_C(0xCE1E9ACC), UINT32_C(0x628E7FD4) },
          { UINT32_C(0x40031676), UINT32_C(0x124DDF27), UINT32_C(0x1EDDB9BE),
            UINT32_C(0x00256939), UINT32_C(0xD360B0DA), UINT32_C(0xD39E25E7),
            UINT32_C(0x4AA6C4C9), UINT32_C(0x6E3015A8), UINT32_C(0x623EDA09),
            UINT32_C(0xC6A2F643), UINT32_C(0x50AA99FB), UINT32_C(0xBEFF2D12) } },
        { { UINT32_C(0x93EE8089), UINT32_C(0x1FEEF7CE), UINT32_C(0x252DD7BD),
            UINT32_C(0xC6B180BC), UINT32_C(0x1788F051), UINT32_C(0xA16FB20B),
            UINT32_C(0xE046ED39), UINT32_C(0xD86FD392), UINT32_C(0x9378CE1D),
            UINT32_C(0xDA0A3611), UINT32_C(0xA5F7A61D), UINT32_C(0x121EF3E7) },
          { UINT32_C(0x92D13CAE), UINT32_C(0x94D22061), UINT32_C(0x77C72E08),
            UINT32_C(0x5076046A), UINT32_C(0x7D2308B9), UINT32_C(0xF18BC233),
            UINT32_C(0x17F977B1), UINT32_C(0x004DB3C5), UINT32_C(0x0471C11D),
            UINT32_C(0xD05AE399), UINT32_C(0x85CD1726), UINT32_C(0x86A2A557) } },
        { { UINT32_C(0x72107804), UINT32_C(0xB8D9B286), UINT32_C(0x3303B79B),
            UINT32_C(0xB5A7C413), UINT32_C(0x5FA37DED), UINT32_C(0x927EEF78),
            UINT32_C(0xAD67DABA), UINT32_C(0xA1C5CF1E), UINT32_C(0x7360E7C7),
            UINT32_C(0xAA5E3FB2), UINT32_C(0x0A0C0993), UINT32_C(0x8354E61A) },
          { UINT32_C(0x7F5458CC), UINT32_C(0x2EC73AF9), UINT32_C(0x48474325),
            UINT32_C(0xDE4CB488), UINT32_C(0x7209BC69), UINT32_C(0x2DD134C7),
            UINT32_C(0x451A2ABE), UINT32_C(0xB70C5567), UINT32_C(0x8E293018),
            UINT32_C(0x2CD1B200), UINT32_C(0xD33C0D72), UINT32_C(0x15F8DA7A) } },
        { { UINT32_C(0xA8790657), UINT32_C(0x5DC386D0), UINT32_C(0xBC4D88BB),
            UINT32_C(0xA4FDF676), UINT32_C(0x48BC6C49), UINT32_C(0x1B21F38F),
            UINT32_C(0x543A7003), UINT32_C(0xCDCC7FAA), UINT32_C(0x8C9CF72C),
            UINT32_C(0xEA97E7AA), UINT32_C(0x50D938A8), UINT32_C(0xA6B883F4) },
          { UINT32_C(0xA3A10F27), UINT32_C(0x51936F3A), UINT32_C(0xDECC76BF),
            UINT32_C(0x0170785F), UINT32_C(0x908C578A), UINT32_C(0x7539ECE1),
            UINT32_C(0x0F3E8C25), UINT32_C(0x5D9C8A8E), UINT32_C(0x9E4717A7),
            UINT32_C(0x8681B43B), UINT32_C(0xA9D83E39), UINT32_C(0x94F42507) } },
        { { UINT32_C(0xA55ADDE7), UINT32_C(0xBBE11CA8), UINT32_C(0x3BC0896B),
            UINT32_C(0x39E6F5CF), UINT32_C(0x1D2D8D94), UINT32_C(0x1447314E),
            UINT32_C(0x5B012F8A), UINT32_C(0x45B48125), UINT32_C(0x08AD5283),
            UINT32_C(0x41AD23FA), UINT32_C(0x41D13774), UINT32_C(0x837243E2) },
          { UINT32_C(0xBADCAA46), UINT32_C(0x1FC0BD9D), UINT32_C(0x26E84CAE),
            UINT32_C(0x8DF164ED), UINT32_C(0x41017176), UINT32_C(0x8FF70EC0),
            UINT32_C(0x5C848BA7), UINT32_C(0x23AD4BCE), UINT32_C(0x97A19CBB),
            UINT32_C(0x89246FDE), UINT32_C(0x78397991), UINT32_C(0xA5EF987B) } },
        { { UINT32_C(0x4757964D), UINT32_C(0x111AF1B7), UINT32_C(0xDDBBF258),
            UINT32_C(0x1D25D351), UINT32_C(0x7D2B06D6), UINT32_C(0x4161E776),
            UINT32_C(0x1CAC0C5B), UINT32_C(0x6EFD2691), UINT32_C(0x211BFAEB),
            UINT32_C(0x633B95DB), UINT32_C(0xE2BDF701), UINT32_C(0x9BEDFA5A) },
          { UINT32_C(0x73E099C8), UINT32_C(0xADAC2B0B), UINT32_C(0xBFB16BFF),
            UINT32_C(0x436F0023), UINT32_C(0x30F55854), UINT32_C(0xB91B1002),
            UINT32_C(0xF4C6C8B7), UINT32_C(0xAF6A2097), UINT32_C(0x3AD7B3D9),
            UINT32_C(0x3FF65CED), UINT32_C(0x330E56DF), UINT32_C(0x6FA2626F) } },
        { { UINT32_C(0xFFCCFD07), UINT32_C(0x3D28BF2D), UINT32_C(0xD989603B),
            UINT32_C(0x0514F6FF), UINT32_C(0x5514787A), UINT32_C(0xB9519629),
            UINT32_C(0xC3DB4E9C), UINT32_C(0xA1848121), UINT32_C(0x2A3D4595),
            UINT32_C(0x47FE2E39), UINT32_C(0x11B73ED4), UINT32_C(0x506F5D82) },
          { UINT32_C(0xA600D8BB), UINT32_C(0xA2257AE7), UINT32_C(0x0F9F122C),
            UINT32_C(0xD659DBD1), UINT32_C(0x64DF160F), UINT32_C(0xDB0FDC67),
            UINT32_C(0x7CB19690), UINT32_C(0xFF379339), UINT32_C(0x98E72EC1),
            UINT32_C(0xDF4366B8), UINT32_C(0xDF437EB8), UINT32_C(0x97E72BEC) } },
        { { UINT32_C(0x1C81E5D9), UINT32_C(0x81DCEA27), UINT32_C(0x6717FC49),
            UINT32_C(0x7E1B6CDA), UINT32_C(0x11EAE80D), UINT32_C(0xAA36B3B5),
            UINT32_C(0x3CD7CBB3), UINT32_C(0x1306687C), UINT32_C(0xC4E89064),
            UINT32_C(0xED670235), UINT32_C(0x58A94760), UINT32_C(0x9D3B0009) },
          { UINT32_C(0xE6A6333C), UINT32_C(0x5A64E158), UINT32_C(0x49453203),
            UINT32_C(0x1A8B4A36), UINT32_C(0x1F77CC21), UINT32_C(0xF1CAD724),
            UINT32_C(0x70518EF7), UINT32_C(0x693EBB4B), UINT32_C(0x0F39C91A),
            UINT32_C(0xFB47BD81), UINT32_C(0xFA4BC64B), UINT32_C(0xCFE63DA2) } },
        { { UINT32_C(0xEAA66108), UINT32_C(0x82C1C684), UINT32_C(0x4CFE79FC),
            UINT32_C(0xE3226218), UINT32_C(0x849C720E), UINT32_C(0x3F28B72B),
            UINT32_C(0x8FEE1CA8), UINT32_C(0x137FB355), UINT32_C(0xE4F90C4E),
            UINT32_C(0x4D18A9CD), UINT32_C(0xCC3E46FA), UINT32_C(0xC0344227) },
          { UINT32_C(0x79CDA392), UINT32_C(0x4FD5C08E), UINT32_C(0x8ADC87B5),
            UINT32_C(0x65DB20DB), UINT32_C(0x916C1B84), UINT32_C(0x86F95D5B),
            UINT32_C(0x17BB2B7C), UINT32_C(0x7EDA3871), UINT32_C(0x669A533B),
            UINT32_C(0x18CCF7E7), UINT32_C(0xECAD0E06), UINT32_C(0x5E92421C) } },
        { { UINT32_C(0x4174B08B), UINT32_C(0x26063E12), UINT32_C(0x70DE8E4D),
            UINT32_C(0xE621D9BE), UINT32_C(0x5ECDF350), UINT32_C(0xAEA0FD0F),
            UINT32_C(0x9C20E5C9), UINT32_C(0x0D9F69E4), UINT32_C(0x0BBE2918),
            UINT32_C(0xD3DADEB9), UINT32_C(0x58AA2F71), UINT32_C(0xD7B9B5DB) },
          { UINT32_C(0x3364CAF8), UINT32_C(0x7A971DD7), UINT32_C(0xC25D4BE4),
            UINT32_C(0x702616A3), UINT32_C(0xA9E30071), UINT32_C(0xA30F0FA1),
            UINT32_C(0x5573BC69), UINT32_C(0x98AB2438), UINT32_C(0x6FEC2E22),
            UINT32_C(0xCBC63CDF), UINT32_C(0xCC901B9B), UINT32_C(0x965F90ED) } },
        { { UINT32_C(0x71E15BB3), UINT32_C(0xD53B592D), UINT32_C(0x8820E0D0),
            UINT32_C(0x1F03C0E9), UINT32_C(0x3CCCB726), UINT32_C(0xCE93947D),
            UINT32_C(0x1D547590), UINT32_C(0x2790FEE0), UINT32_C(0xC59CDD7A),
            UINT32_C(0x4401D847), UINT32_C(0xA926DD9D), UINT32_C(0x72D69120) },
          { UINT32_C(0x4229F289), UINT32_C(0x38B8F21D), UINT32_C(0x7FE978AF),
            UINT32_C(0x9F412E40), UINT32_C(0xCDB59AF1), UINT32_C(0xAE07901B),
            UINT32_C(0xD1D4715E), UINT32_C(0x1E6BE5EB), UINT32_C(0x18C96BEF),
            UINT32_C(0x3715BD8B), UINT32_C(0xE11B3798), UINT32_C(0x4B71F6E6) } },
    },
    {
        { { UINT32_C(0xF0CE2DF4), UINT32_C(0x11A8FDE5), UINT32_C(0xFA8D26DF),
            UINT32_C(0xBC70CA3E), UINT32_C(0xC74DFE82), UINT32_C(0x6818C275),
            UINT32_C(0x38373A50), UINT32_C(0x2B0294AC), UINT32_C(0xE8E5F88F),
            UINT32_C(0x584C4061), UINT32_C(0x7342383A), UINT32_C(0x1C05C1CA) },
          { UINT32_C(0x911430EC), UINT32_C(0x263895B3), UINT32_C(0xA5171453),
            UINT32_C(0xEF9B0032), UINT32_C(0x84DA7F0C), UINT32_C(0x144359DA),
            UINT32_C(0x924A09F2), UINT32_C(0x76E3095A), UINT32_C(0xD69AD835),
            UINT32_C(0x612986E3), UINT32_C(0x392122AF), UINT32_C(0x70E03ADA) } },
        { { UINT32_C(0x67AAD17B), UINT32_C(0xFEB707EE), UINT32_C(0x83042995),
            UINT32_C(0xBB21B287), UINT32_C(0x9A0D32BA), UINT32_C(0x26DE1645),
            UINT32_C(0x1FFB9266), UINT32_C(0x9A2FF38A), UINT32_C(0x8F578B4A),
            UINT32_C(0x4E5AD96D), UINT32_C(0x883E7443), UINT32_C(0x26CC0655) },
          { UINT32_C(0x2EE9367A), UINT32_C(0x1D8EECAB), UINT32_C(0x881DE2F8),
            UINT32_C(0x42B84337), UINT32_C(0xD758AE41), UINT32_C(0xE49B2FAE),
            UINT32_C(0x4A85D867), UINT32_C(0x6A9A2290), UINT32_C(0xE68CBA86),
            UINT32_C(0x2FB89DCE), UINT32_C(0x7F09A982), UINT32_C(0xBC252635) } },
        { { UINT32_C(0x8C61AAAC), UINT32_C(0xADC79436), UINT32_C(0x5E926563),
            UINT32_C(0x24C7FD13), UINT32_C(0x0406C129), UINT32_C(0xEF9FAAA4),
            UINT32_C(0x8B658D3C), UINT32_C(0xF4E6388C), UINT32_C(0x1E435BAF),
            UINT32_C(0x7262BEB4), UINT32_C(0xFDAEAC99), UINT32_C(0x3BF622CC) },
          { UINT32_C(0x4E1AEDDC), UINT32_C(0xD359F7D8), UINT32_C(0xD78C17B7),
            UINT32_C(0x05DC4F8C), UINT32_C(0x29498BA5), UINT32_C(0xB18CF032),
            UINT32_C(0x85BF35AD), UINT32_C(0xC67388CA), UINT32_C(0x62AA4BC8),
            UINT32_C(0x8A7A6AA2), UINT32_C(0x72F4627A), UINT32_C(0x0B8F458E) } },
        { { UINT32_C(0xC68E4488), UINT32_C(0x3FB812EE), UINT32_C(0x60EF7281),
            UINT32_C(0x53C5EAA4), UINT32_C(0x8FBEFBE4), UINT32_C(0xE5724183),
            UINT32_C(0xA4B24A05), UINT32_C(0x2B7D49F4), UINT32_C(0x710C0A43),
            UINT32_C(0x23B138D0), UINT32_C(0xA85EC1DB), UINT32_C(0x16A5B4C1) },
          { UINT32_C(0x305FEB02), UINT32_C(0x7CC1F3D7), UINT32_C(0x5B6C1B54),
            UINT32_C(0x52F7947D), UINT32_C(0x8F56981C), UINT32_C(0x1BDA2312),
            UINT32_C(0xB4080A01), UINT32_C(0x68663EAE), UINT32_C(0x9F999B7F),
            UINT32_C(0x8DD7BA7E), UINT32_C(0xB686580C), UINT32_C(0xD8768D19) } },
        { { UINT32_C(0x7AFDDA94), UINT32_C(0xBCD0E0AD), UINT32_C(0x34A30687),
            UINT32_C(0x95A0DBBE), UINT32_C(0x8C5E2665), UINT32_C(0xBBE3C3DF),
            UINT32_C(0xEBF2BC16), UINT32_C(0x742BECD8), UINT32_C(0x3FA163A6),
            UINT32_C(0x300CEB48), UINT32_C(0x4663354B), UINT32_C(0x0C5D02EE) },
          { UINT32_C(0xB5E606A4), UINT32_C(0xE4FB9AD6), UINT32_C(0xCF49FF95),
            UINT32_C(0x93F507B8), UINT32_C(0x585C193B), UINT32_C(0x9406A90C),
            UINT32_C(0x4ECF9517), UINT32_C(0xAD1440C1), UINT32_C(0x9CEA53F1),
            UINT32_C(0x184CB475), UINT32_C(0x8EF11302), UINT32_C(0x6855C474) } },
        { { UINT32_C(0xEDCAFA52), UINT32_C(0x00ECB523), UINT32_C(0x086F69D3),
            UINT32_C(0x0DA0AE0E), UINT32_C(0xC242F347), UINT32_C(0xC384DE15),
            UINT32_C(0x848C12B7), UINT32_C(0xFB050E6E), UINT32_C(0x64E015CE),
            UINT32_C(0x22F67654), UINT32_C(0x7CA122F2), UINT32_C(0xCBDC2A48) },
          { UINT32_C(0x445FB02C), UINT32_C(0xA940D973), UINT32_C(0x3767D89D),
            UINT32_C(0x00F31E78), UINT32_C(0x613DABDD), UINT32_C(0x2B65A237),
            UINT32_C(0xC875AE09), UINT32_C(0x2BE0AB05), UINT32_C(0xBA204F8E),
            UINT32_C(0xB22E54FD), UINT32_C(0x0F7687B9), UINT32_C(0x65E2029D) } },
        { { UINT32_C(0x1855A71C), UINT32_C(0xFFD82538), UINT32_C(0x438BD8D8),
            UINT32_C(0x26A330B3), UINT32_C(0xF9D8C5F9), UINT32_C(0x89628311),
            UINT32_C(0x953738A0), UINT32_C(0x8D5FB9CF), UINT32_C(0xEDFCD4E5),
            UINT32_C(0xCB7159C9), UINT32_C(0x2064C7C2), UINT32_C(0xD64E5230) },
          { UINT32_C(0x689F3CFE), UINT32_C(0xF858ED80), UINT32_C(0x56128B67),
            UINT32_C(0x4830E309), UINT32_C(0xE0E90688), UINT32_C(0x2E1692DA),
            UINT32_C(0xCA9CC232), UINT32_C(0xAB818913), UINT32_C(0xA5D229A6),
            UINT32_C(0xE2E30C23), UINT32_C(0x0E740E23), UINT32_C(0xA544E8B1) } },
        { { UINT32_C(0xDC61E6CC), UINT32_C(0x1C15E569), UINT32_C(0x58FC7800),
            UINT32_C(0x8FD72967), UINT32_C(0x37A9DFC5), UINT32_C(0xE61E7DB7),
            UINT32_C(0x5AFD7822), UINT32_C(0x3F34A9C6), UINT32_C(0x19E80773),
            UINT32_C(0x0A112742), UINT32_C(0x4760FC58), UINT32_C(0xA353460C) },
          { UINT32_C(0xB3124C71), UINT32_C(0x2FB7DEEB), UINT32_C(0x2D4009CC),
            UINT32_C(0x48463627), UINT32_C(0xC3A10370), UINT32_C(0x399D1933),
            UINT32_C(0x54388DBD), UINT32_C(0x7EB19450), UINT32_C(0x7C2A006A),
            UINT32_C(0x8ECCE639), UINT32_C(0x55C932A0), UINT32_C(0x3D565DAF) } },
        { { UINT32_C(0xD9ADAE53), UINT32_C(0xCEF57A9F), UINT32_C(0xF83FD8CD),
            UINT32_C(0xE2EB27D7), UINT32_C(0x9BBD2DDE), UINT32_C(0x4AC8F719),
            UINT32_C(0xE91ABFB7), UINT32_C(0x604283AA), UINT32_C(0x34799F87),
            UINT32_C(0xB6A4E115), UINT32_C(0xE4C2A8F3), UINT32_C(0x2B253224) },
          { UINT32_C(0xC8782294), UINT32_C(0xC34F8B92), UINT32_C(0xFCC2CB6B),
            UINT32_C(0xC74D697D), UINT32_C(0xC2C84C46), UINT32_C(0xD990411B),
            UINT32_C(0x31EA4955), UINT32_C(0x2807B5C6), UINT32_C(0xB9EB27F5),
            UINT32_C(0x14AE2B93), UINT32_C(0x6163EDFA), UINT32_C(0xF0AE96A7) } },
        { { UINT32_C(0x42DB7180), UINT32_C(0xA7BDCBB4), UINT32_C(0xEDCA752F),
            UINT32_C(0xC9FAA41F), UINT32_C(0xE820F401), UINT32_C(0x147F91B4),
            UINT32_C(0xF5F2645F), UINT32_C(0x1E6CEF86), UINT32_C(0x31FE711D),
            UINT32_C(0xB4AB4D7F), UINT32_C(0x743EF882), UINT32_C(0xCE68FB3C) },
          { UINT32_C(0x3EF2FCFF), UINT32_C(0xB9D7D682), UINT32_C(0x020DCAFD),
            UINT32_C(0xF6893811), UINT32_C(0xBF81E760), UINT32_C(0x30D9A50C),
            UINT32_C(0xB9B87228), UINT32_C(0x7F247D06), UINT32_C(0x5F40CFC0),
            UINT32_C(0x143D4FEC), UINT32_C(0x329B2A88), UINT32_C(0x21D78D73) } },
        { { UINT32_C(0xED3F2055), UINT32_C(0x06B3FF8A), UINT32_C(0x522BE214),
            UINT32_C(0x50482C77), UINT32_C(0xDDF54620), UINT32_C(0x8DF69CD8),
            UINT32_C(0xF78A1165), UINT32_C(0x6D1DB204), UINT32_C(0x9AFE6BF2),
            UINT32_C(0x459AE4A2), UINT32_C(0x24AC871E), UINT32_C(0xC23A9FFD) },
          { UINT32_C(0x89E85D81), UINT32_C(0xB7FD22E3), UINT32_C(0x122E9978),
            UINT32_C(0x297F1F6B), UINT32_C(0x144BE1CE), UINT32_C(0xAB283D66),
            UINT32_C(0xC00C614E), UINT32_C(0xC1F90AC2), UINT32_C(0x3224CD09),
            UINT32_C(0x5465576E), UINT32_C(0x441B6059), UINT32_C(0x8E8D910D) } },
        { { UINT32_C(0xAAA228BC), UINT32_C(0xF73A060A), UINT32_C(0x56EFF87D),
            UINT32_C(0xCF1B0783), UINT32_C(0xA54C9133), UINT32_C(0x11EF17C0),
            UINT32_C(0x76A4DAA5), UINT32_C(0x9E476B15), UINT32_C(0x8018FB92),
            UINT32_C(0x5624FEAC), UINT32_C(0xCFEEC1B9), UINT32_C(0x9826A0FC) },
          { UINT32_C(0x2DFE2046), UINT32_C(0xB732F7FE), UINT32_C(0x3B40DA6A),
            UINT32_C(0x9260BD9F), UINT32_C(0x4F231773), UINT32_C(0xCC9F908F),
            UINT32_C(0xDAFC0D55), UINT32_C(0x4827FEB9), UINT32_C(0x538ACE95),
            UINT32_C(0x07D32E85), UINT32_C(0xB8EDAF37), UINT32_C(0xAD9F897C) } },
        { { UINT32_C(0xE3415498), UINT32_C(0x2F75B82F), UINT32_C(0xF1015F30),
            UINT32_C(0xF99CAC5F), UINT32_C(0x7D7F25DE), UINT32_C(0x76640824),
            UINT32_C(0xEE74C047), UINT32_C(0x714BC9CD), UINT32_C(0x07448879),
            UINT32_C(0x70F847BF), UINT32_C(0x072165C0), UINT32_C(0xA14481DE) },
          { UINT32_C(0xDB1140A8), UINT32_C(0x9BFA59E3), UINT32_C(0xFCD13502),
            UINT32_C(0x7B9C7FF0), UINT32_C(0x68459ABF), UINT32_C(0xF4D7538E),
            UINT32_C(0xC8FC6AD2), UINT32_C(0xED93A791), UINT32_C(0xB51BD9B2),
            UINT32_C(0xA8BBE2A8), UINT32_C(0x9FB34008), UINT32_C(0x084B5A27) } },
        { { UINT32_C(0xEB138C84), UINT32_C(0xB3BB9545), UINT32_C(0x3FC88BFD),
            UINT32_C(0x59C3489C), UINT32_C(0x85F53EC7), UINT32_C(0x3A97FF63),
            UINT32_C(0x0AA69C3D), UINT32_C(0x40FDF5A6), UINT32_C(0x53D19668),
            UINT32_C(0x0E8CCEC7), UINT32_C(0x33FAA661), UINT32_C(0x0AA72EF9) },
          { UINT32_C(0x9B1E684B), UINT32_C(0xF5C5A6CF), UINT32_C(0x31A22EA1),
            UINT32_C(0x630F9371), UINT32_C(0xAC60F7EA), UINT32_C(0x06B2AAC2),
            UINT32_C(0x5BC37D80), UINT32_C(0xB181CAE2), UINT32_C(0x247B13EA),
            UINT32_C(0x4601A929), UINT32_C(0x5F739797), UINT32_C(0x8A71C386) } },
        { { UINT32_C(0xAB134786), UINT32_C(0x545387B3), UINT32_C(0x1599B64A),
            UINT32_C(0x3179BB06), UINT32_C(0x07593574), UINT32_C(0xB0A61986),
            UINT32_C(0x63FA7C3B), UINT32_C(0xC7E39B21), UINT32_C(0x91585D13),
            UINT32_C(0xA1173F86), UINT32_C(0xCB9525CD), UINT32_C(0x09D5CC8E) },
          { UINT32_C(0x8F3A3451), UINT32_C(0xAAD44FFD), UINT32_C(0x25820CC5),
            UINT32_C(0x702B04F2), UINT32_C(0x1CB66C17), UINT32_C(0xE90CAC49),
            UINT32_C(0xEE161DC4), UINT32_C(0x40F6B547), UINT32_C(0x1BA4AC4E),
            UINT32_C(0xC08BB8B4), UINT32_C(0xAE5A6BC1), UINT32_C(0x7DC064FB) } },
        { { UINT32_C(0x9D76DDC7), UINT32_C(0x90A5E871), UINT32_C(0xEDFC8E2E),
            UINT32_C(0x39DC8FAE), UINT32_C(0x5B079C62), UINT32_C(0x98467A23),
            UINT32_C(0x05450C98), UINT32_C(0xE25E3785), UINT32_C(0x96140083),
            UINT32_C(0x2FE23A4D), UINT32_C(0xE9900312), UINT32_C(0x65CE3B9A) },
          { UINT32_C(0x6B72B5D9), UINT32_C(0x1D87D088), UINT32_C(0xFD9AFC82),
            UINT32_C(0x72F53220), UINT32_C(0x9E1F71FA), UINT32_C(0xC63C7C15),
            UINT32_C(0x8D449637), UINT32_C(0x90DF26EA), UINT32_C(0xC1C2B215),
            UINT32_C(0x97089F40), UINT32_C(0x42317FAA), UINT32_C(0x83AF2664) } },
    },
    {
        { { UINT32_C(0x8D688E31), UINT32_C(0xFA2DB51A), UINT32_C(0xA09C88D4),
            UINT32_C(0x225B696C), UINT32_C(0x6059171F), UINT32_C(0x9F88AF1D),
            UINT32_C(0x782A0993), UINT32_C(0x1C5FEA5E), UINT32_C(0x4EC710D3),
            UINT32_C(0xE0FB1588), UINT32_C(0xD32CE365), UINT32_C(0xFAF372E5) },
          { UINT32_C(0x26506F45), UINT32_C(0xD9F896AB), UINT32_C(0x8373C724),
            UINT32_C(0x8D350338), UINT32_C(0xCA6E7342), UINT32_C(0x1B76992D),
            UINT32_C(0x6FD0C08B), UINT32_C(0x76338FCA), UINT32_C(0xA00F5C23),
            UINT32_C(0xC3EA4C65), UINT32_C(0xB316B35B), UINT32_C(0xDFAB29B3) } },
        { { UINT32_C(0x483AEBF9), UINT32_C(0x84E5541F), UINT32_C(0x49165772),
            UINT32_C(0x8ADFF7DC), UINT32_C(0x9BEAAD3C), UINT32_C(0xE0A43AD6),
            UINT32_C(0xF51C2714), UINT32_C(0x97DD1820), UINT32_C(0x57EA5B0C),
            UINT32_C(0xAC2B4CB4), UINT32_C(0xD11767CA), UINT32_C(0x87DBD011) },
          { UINT32_C(0xBFC7957A), UINT32_C(0x18CCF36C), UINT32_C(0x1BC79227),
            UINT32_C(0xD4A08841), UINT32_C(0xD8D292A8), UINT32_C(0x9811CE43),
            UINT32_C(0xD58C4EE7), UINT32_C(0x72C5FC68), UINT32_C(0xD35C65A7),
            UINT32_C(0x5BC0F0BE), UINT32_C(0xCBBF9669), UINT32_C(0x0B446DBC) } },
        { { UINT32_C(0x9CEE9BCE), UINT32_C(0x7EBA3DA6), UINT32_C(0xD5377750),
            UINT32_C(0x3E2C1248), UINT32_C(0x2B93D8B2), UINT32_C(0x8C917D98),
            UINT32_C(0x7CAD1F75), UINT32_C(0xCA8FC6AC), UINT32_C(0xA0FF150A),
            UINT32_C(0x5F581F19), UINT32_C(0xE08327FA), UINT32_C(0x872CC14A) },
          { UINT32_C(0xE9333188), UINT32_C(0xC774F187), UINT32_C(0x497AF7E8),
            UINT32_C(0x528ED4AC), UINT32_C(0x8AD72B10), UINT32_C(0xCE036E9B),
            UINT32_C(0x917986CF), UINT32_C(0x463F9EBB), UINT32_C(0x1325CF9B),
            UINT32_C(0xBE516328), UINT32_C(0xDD7E5FEA), UINT32_C(0xD28D5C50) } },
        { { UINT32_C(0xDD58BBE3), UINT32_C(0x714C1D1B), UINT32_C(0x039AFD0F),
            UINT32_C(0x85BA01AE), UINT32_C(0x6951AC80), UINT32_C(0x7F23EA3A),
            UINT32_C(0xAC00C837), UINT32_C(0x5C599290), UINT32_C(0xBF24CC1B),
            UINT32_C(0xF6EFA2B3), UINT32_C(0x1E84462B), UINT32_C(0x393D8E42) },
          { UINT32_C(0xF8B89453), UINT32_C(0x9BDA627D), UINT32_C(0xB23E0D1B),
            UINT32_C(0xE66FFF2E), UINT32_C(0xC3B94EC2), UINT32_C(0xD1EE7089),
            UINT32_C(0x3031699A), UINT32_C(0xF75DBA6E), UINT32_C(0x242B2453),
            UINT32_C(0x8FF75F79), UINT32_C(0x289BFED4), UINT32_C(0xE721EDEB) } },
        { { UINT32_C(0xC1390FA8), UINT32_C(0x083215A1), UINT32_C(0x6DCE8CE0),
            UINT32_C(0x901D686A), UINT32_C(0x837073FF), UINT32_C(0x4AB1BA62),
            UINT32_C(0x34BEABA5), UINT32_C(0x10C287AA), UINT32_C(0x46985239),
            UINT32_C(0xB4931AF4), UINT32_C(0xB053C4DC), UINT32_C(0x07639899) },
          { UINT32_C(0xE721EECD), UINT32_C(0x29E7F44D), UINT32_C(0x57B3FF48),
            UINT32_C(0x65817182), UINT32_C(0x5054E2E0), UINT32_C(0x198542E2),
            UINT32_C(0x84616DE8), UINT32_C(0x923C9E15), UINT32_C(0xAD465BB9),
            UINT32_C(0x2A9C15E1), UINT32_C(0x16319245), UINT32_C(0xD8D4EFC7) } },
        { { UINT32_C(0x9961A674), UINT32_C(0x72DC7943), UINT32_C(0xA0E13668),
            UINT32_C(0x839A0A52), UINT32_C(0x334945EA), UINT32_C(0xD7A53FA9),
            UINT32_C(0xE7AA25DB), UINT32_C(0xDB21DB77), UINT32_C(0x66E96DA3),
            UINT32_C(0xB6675A7D), UINT32_C(0xE66F33C0), UINT32_C(0x2C31C406) },
          { UINT32_C(0x6EC7B9CB), UINT32_C(0x45020B62), UINT32_C(0x0391F267),
            UINT32_C(0xFF46E9CD), UINT32_C(0x0FA2F221), UINT32_C(0x7DABD744),
            UINT32_C(0x9D4A2A3E), UINT32_C(0x9A32364B), UINT32_C(0x52D2E47A),
            UINT32_C(0xF0F84AE8), UINT32_C(0x888F488A), UINT32_C(0xD0B872BB) } },
        { { UINT32_C(0xC9790EEF), UINT32_C(0x531E4CEF), UINT32_C(0x2B8D1A58),
            UINT32_C(0xF7B5735E), UINT32_C(0xEF568511), UINT32_C(0xB8882F1E),
            UINT32_C(0x86A86DB3), UINT32_C(0xAFB08D1C), UINT32_C(0xF54DE8C7),
            UINT32_C(0x88CB9DF2), UINT32_C(0x9A683282), UINT32_C(0xA44234F1) },
          { UINT32_C(0xA6E9AB2E), UINT32_C(0xBC1B3D3A), UINT32_C(0x87FC99EE),
            UINT32_C(0xEFA071FB), UINT32_C(0xA102DC0F), UINT32_C(0xFA3C737D),
            UINT32_C(0xD6A0CBD2), UINT32_C(0xDF3248A6), UINT32_C(0x1ECC1BF4),
            UINT32_C(0x6E62A4FF), UINT32_C(0xC8F1BC17), UINT32_C(0xF718F940) } },
        { { UINT32_C(0x4F63F026), UINT32_C(0x2C8B0AAD), UINT32_C(0x50B253CC),
            UINT32_C(0x2AFF6238), UINT32_C(0x10C4D122), UINT32_C(0xCAB3E942),
            UINT32_C(0x07CD2816), UINT32_C(0x52B59F04), UINT32_C(0x982C41FC),
            UINT32_C(0x22322803), UINT32_C(0x8CF50B19), UINT32_C(0x38844E66) },
          { UINT32_C(0xBE3264CD), UINT32_C(0x42A959F7), UINT32_C(0x6C983524),
            UINT32_C(0xBDDC24BD), UINT32_C(0x462B8640), UINT32_C(0xA489EB0C),
            UINT32_C(0x98029BE7), UINT32_C(0xB7C05092), UINT32_C(0xA1ADDC64),
            UINT32_C(0xD5546B5F), UINT32_C(0xA0C655AF), UINT32_C(0xE7CAC1FC) } },
        { { UINT32_C(0x47636F97), UINT32_C(0x14547198), UINT32_C(0xEBCDCCFF),
            UINT32_C(0x6FA67481), UINT32_C(0x395D3258), UINT32_C(0xC164872F),
            UINT32_C(0xEE6ACDBC), UINT32_C(0xB8CECAFE), UINT32_C(0xA933F180),
            UINT32_C(0x3FBFE5F3), UINT32_C(0x898C3B1E), UINT32_C(0xEC20CAC2) },
          { UINT32_C(0x87DA73F9), UINT32_C(0x6A031BEE), UINT32_C(0x5C5AF46E),
            UINT32_C(0xD1E667D1), UINT32_C(0x1DC6EEF9), UINT32_C(0xCB3DC168),
            UINT32_C(0x33D310C0), UINT32_C(0x2DD1BD94), UINT32_C(0x9207E438),
            UINT32_C(0x0F78D493), UINT32_C(0xA99C0E75), UINT32_C(0xC233D544) } },
        { { UINT32_C(0x9E2A0113), UINT32_C(0x228F19F1), UINT32_C(0x0E1A5D37),
            UINT32_C(0x58495BE5), UINT32_C(0x38D7F364), UINT32_C(0x97E08F69),
            UINT32_C(0x510759B0), UINT32_C(0x1EC3BA3E), UINT32_C(0xE03CD40D),
            UINT32_C(0x3682F19A), UINT32_C(0xF9E16D68), UINT32_C(0xC87745D8) },
          { UINT32_C(0x09A642EA), UINT32_C(0xFD527AB5), UINT32_C(0xF9C81F27),
            UINT32_C(0x6308EEBD), UINT32_C(0x550C5D68), UINT32_C(0xFA9F666C),
            UINT32_C(0x584AB153), UINT32_C(0xDEBA436F), UINT32_C(0x5B63E939),
            UINT32_C(0x1D4861D3), UINT32_C(0xC9850221), UINT32_C(0x073BED9B) } },
        { { UINT32_C(0x8B171246), UINT32_C(0x802BCCF0), UINT32_C(0x733B072F),
            UINT32_C(0xFFF7D15A), UINT32_C(0x4CBFA4EF), UINT32_C(0xEA386266),
            UINT32_C(0xD635946B), UINT32_C(0x9E5B5073), UINT32_C(0xFA81BE95),
            UINT32_C(0x16E9A979), UINT32_C(0xB14F701F), UINT32_C(0x41E8716E) },
          { UINT32_C(0x101A6719), UINT32_C(0x25782E0F), UINT32_C(0xC9D66959),
            UINT32_C(0x442C4875), UINT32_C(0x2B85D153), UINT32_C(0x52D845D9),
            UINT32_C(0x2E831117), UINT32_C(0xFF925138), UINT32_C(0x8E02434B),
            UINT32_C(0x01B700CC), UINT32_C(0xEC0BAE3E), UINT32_C(0xD2DB7F8E) } },
        { { UINT32_C(0x966A4872), UINT32_C(0x1B225300), UINT32_C(0x566F537B),
            UINT32_C(0x40C149BE), UINT32_C(0xCB680021), UINT32_C(0x3335F4D2),
            UINT32_C(0x778E5F5F), UINT32_C(0x773D0263), UINT32_C(0x666FA9ED),
            UINT32_C(0x1D9B7602), UINT32_C(0x2E6200CF), UINT32_C(0x52490A10) },
          { UINT32_C(0x961F290B), UINT32_C(0x8434C7DD), UINT32_C(0x64456446),
            UINT32_C(0x773AC156), UINT32_C(0x47B712BB), UINT32_C(0x5E2BB789),
            UINT32_C(0xBE0974AD), UINT32_C(0xFD3BCBFD), UINT32_C(0x791AD5D8),
            UINT32_C(0x71AE9351), UINT32_C(0x6F4E1400), UINT32_C(0x1EE738BA) } },
        { { UINT32_C(0x0BE8E26E), UINT32_C(0x2FA428AB), UINT32_C(0xBB4CF9FC),
            UINT32_C(0xFEFF0600), UINT32_C(0xB2EA5FB0), UINT32_C(0x76F25CA9),
            UINT32_C(0x6835C5F4), UINT32_C(0xAB7FECF0), UINT32_C(0x19D5F328),
            UINT32_C(0x649D0772), UINT32_C(0xACBCB12E), UINT32_C(0xABE7B895) },
          { UINT32_C(0xD69B1EA8), UINT32_C(0xF2D1031A), UINT32_C(0xC60B0BBB),
            UINT32_C(0x46065D5D), UINT32_C(0x85D798FF), UINT32_C(0xB0908DC1),
            UINT32_C(0xD2C9B18A), UINT32_C(0x4E2420F0), UINT32_C(0xD30432A2),
            UINT32_C(0x6B3A9BDD), UINT32_C(0xC9B134AD), UINT32_C(0x501C3383) } },
        { { UINT32_C(0x98A21284), UINT32_C(0x608F0967), UINT32_C(0x059CCEDE),
            UINT32_C(0x5361BE86), UINT32_C(0xAFD87EF7), UINT32_C(0x3A40655C),
            UINT32_C(0x59083AA2), UINT32_C(0x03CF3117), UINT32_C(0xB6C366D9),
            UINT32_C(0x57DB5F61), UINT32_C(0x6DD0D232), UINT32_C(0x29DC275B) },
          { UINT32_C(0x8FA67501), UINT32_C(0xBDAB24DD), UINT32_C(0x65D08C37),
            UINT32_C(0x5928F775), UINT32_C(0x645D466A), UINT32_C(0x9448A856),
            UINT32_C(0xC0E927A5), UINT32_C(0x6E6B5E2E), UINT32_C(0xE80C6871),
            UINT32_C(0xE884D546), UINT32_C(0x53A9A851), UINT32_C(0x10C881C9) } },
        { { UINT32_C(0x9B627AA5), UINT32_C(0x35505374), UINT32_C(0x7976677B),
            UINT32_C(0xE7CA1B57), UINT32_C(0x4976CE17), UINT32_C(0x81239712),
            UINT32_C(0x96DA31B9), UINT32_C(0x96E9080B), UINT32_C(0xCC64AA1F),
            UINT32_C(0x458254AB), UINT32_C(0x48E674C9), UINT32_C(0xFEFF6821) },
          { UINT32_C(0x021F1488), UINT32_C(0x8772F37A), UINT32_C(0xAB56345C),
            UINT32_C(0x2E274E18), UINT32_C(0x29823B76), UINT32_C(0x7C7BE61C),
            UINT32_C(0x9EEFB39E), UINT32_C(0x275DB7B2), UINT32_C(0xBF5CBCEF),
            UINT32_C(0x83B10ED4), UINT32_C(0x518E5183), UINT32_C(0x40D7F5B4) } },
        { { UINT32_C(0xF960B41B), UINT32_C(0x315CCC01), UINT32_C(0x1D99E722),
            UINT32_C(0x90B417C9), UINT32_C(0x013463E0), UINT32_C(0x84AFAA0D),
            UINT32_C(0x13E6D9E1), UINT32_C(0xF133C5D8), UINT32_C(0x525B7430),
            UINT32_C(0xD95C6ADC), UINT32_C(0x7A25106A), UINT32_C(0x082C61AD) },
          { UINT32_C(0xBA1CE179), UINT32_C(0xABC1966D), UINT32_C(0xA5DB529A),
            UINT32_C(0xE0578B77), UINT32_C(0xEC84107D), UINT32_C(0x10988C05),
            UINT32_C(0x1B207F83), UINT32_C(0xFCADE5D7), UINT32_C(0xC5BA83DB),
            UINT32_C(0x0BEB6FDB), UINT32_C(0x57537E34), UINT32_C(0x1C39B86D) } },
    },
    {
        { { UINT32_C(0x2A7AECED), UINT32_C(0x5B0B5D69), UINT32_C(0x01DC545F),
            UINT32_C(0x4C03450C), UINT32_C(0x404A3458), UINT32_C(0x72AD0A4A),
            UINT32_C(0x9F467B60), UINT32_C(0x1DE8E255), UINT32_C(0x90634809),
            UINT32_C(0xA4B35705), UINT32_C(0x706F0178), UINT32_C(0x76F30205) },
          { UINT32_C(0x4454F0E5), UINT32_C(0x588D21AB), UINT32_C(0x64134928),
            UINT32_C(0xD22DF549), UINT32_C(0x241BCD90), UINT32_C(0xF4E7E73D),
            UINT32_C(0x2FACC7CC), UINT32_C(0xB8D8A1D2), UINT32_C(0x1D25D2A0),
            UINT32_C(0x483C35A7), UINT32_C(0x1EF9F608), UINT32_C(0x7F8D2545) } },
        { { UINT32_C(0x54EBC926), UINT32_C(0xCB51F039), UINT32_C(0xB8D4A7BB),
            UINT32_C(0xE235D356), UINT32_C(0xB41FE1A6), UINT32_C(0x93C8FAFA),
            UINT32_C(0xA719F254), UINT32_C(0x6297701D), UINT32_C(0x644F5CDE),
            UINT32_C(0x6E9165BC), UINT32_C(0x0C11C542), UINT32_C(0x6506329D) },
          { UINT32_C(0xA92B4250), UINT32_C(0xA2564809), UINT32_C(0x889C2E3E),
            UINT32_C(0x0E9AC173), UINT32_C(0x22B1D1BE), UINT32_C(0x286A5926),
            UINT32_C(0x6ECDD041), UINT32_C(0x86A3D752), UINT32_C(0x649F9524),
            UINT32_C(0x4B867E0A), UINT32_C(0x0629CB0F), UINT32_C(0x1FE7D95A) } },
        { { UINT32_C(0xCA5BAF54), UINT32_C(0xF4F66843), UINT32_C(0xEFE7DB78),
            UINT32_C(0x298DB357), UINT32_C(0x7365712F), UINT32_C(0xF607E86E),
            UINT32_C(0x8A822BC0), UINT32_C(0xD5882298), UINT32_C(0xC61299B3),
            UINT32_C(0x2CFBD63A), UINT32_C(0x67167B1A), UINT32_C(0x6F713D9B) },
          { UINT32_C(0xDE0B077A), UINT32_C(0x750F673F), UINT32_C(0xEE2178DA),
            UINT32_C(0x07482708), UINT32_C(0x69123C75), UINT32_C(0x5E6D5BD1),
            UINT32_C(0xEAB99B37), UINT32_C(0x6A93D1B6), UINT32_C(0x8CAEC6A3),
            UINT32_C(0x6EF4F7E6), UINT32_C(0xCF3ED818), UINT32_C(0x7BE411D6) } },
        { { UINT32_C(0x63A0A7D2), UINT32_C(0xF92B3073), UINT32_C(0x881DC8CF),
            UINT32_C(0x32DA431C), UINT32_C(0xC578E3A3), UINT32_C(0xE51BD5ED),
            UINT32_C(0x9587FA22), UINT32_C(0xEFDA70D2), UINT32_C(0x9B2EBA85),
            UINT32_C(0xCFEC1708), UINT32_C(0xAF7BA530), UINT32_C(0x6AB51A4B) },
          { UINT32_C(0x98174812), UINT32_C(0x5AC155AE), UINT32_C(0xCCB076E3),
            UINT32_C(0xCAF07A71), UINT32_C(0xC38718A7), UINT32_C(0x280E86C2),
            UINT32_C(0xD63745B7), UINT32_C(0x9D12DE73), UINT32_C(0xBF8A79AA),
            UINT32_C(0x0E8EA855), UINT32_C(0xBD705BF7), UINT32_C(0x5EB2BED8) } },
        { { UINT32_C(0xAE16DE53), UINT32_C(0x33FE9578), UINT32_C(0x10BEC902),
            UINT32_C(0x3AE85EB5), UINT32_C(0x44AF850E), UINT32_C(0xC4F49658),
            UINT32_C(0x087DD658), UINT32_C(0x6EA222B3), UINT32_C(0xA51F1447),
            UINT32_C(0xB255E6FD), UINT32_C(0x117E3F48), UINT32_C(0xB35E4997) },
          { UINT32_C(0x05616CA1), UINT32_C(0x562E813B), UINT32_C(0x8A61E156),
            UINT32_C(0xDF5925D6), UINT32_C(0x571C728B), UINT32_C(0xB2FA8125),
            UINT32_C(0xA2F2D1CF), UINT32_C(0x00864805), UINT32_C(0x1BCCB6FF),
            UINT32_C(0x2DC26F41), UINT32_C(0x63AE37DD), UINT32_C(0xEBD5E093) } },
        { { UINT32_C(0x0A285611), UINT32_C(0xD2D68BB3), UINT32_C(0xDC8378F2),
            UINT32_C(0x3EAE7596), UINT32_C(0x6CC688A3), UINT32_C(0x2DC6CCC6),
            UINT32_C(0x011F5DFB), UINT32_C(0xC45E5713), UINT32_C(0x62D34487),
            UINT32_C(0x6B9C4F6C), UINT32_C(0x1FC65551), UINT32_C(0xFAD6F077) },
          { UINT32_C(0x62B23B52), UINT32_C(0x5E3266E0), UINT32_C(0xE98F4715),
            UINT32_C(0xF1DAF319), UINT32_C(0x3ED0AE83), UINT32_C(0x064D12EA),
            UINT32_C(0x564125CB), UINT32_C(0x5CCF9326), UINT32_C(0xC63C1E9F),
            UINT32_C(0x09057022), UINT32_C(0xDC9B5D2E), UINT32_C(0x7171972C) } },
        { { UINT32_C(0xEABD21B2), UINT32_C(0x2364FD9A), UINT32_C(0x9174AD6D),
            UINT32_C(0x3CE5F4BB), UINT32_C(0xB38688C0), UINT32_C(0xA4D6D5D0),
            UINT32_C(0x6D87FD7D), UINT32_C(0x2292A2D2), UINT32_C(0x4CA02E54),
            UINT32_C(0x2A7D1B53), UINT32_C(0xB4185715), UINT32_C(0x7BEE6E7E) },
          { UINT32_C(0x8FC63ACD), UINT32_C(0x73E54609), UINT32_C(0x4064E09D),
            UINT32_C(0xF4D93A12), UINT32_C(0x2B92DAA5), UINT32_C(0xD20E157A),
            UINT32_C(0xC4B81A00), UINT32_C(0x90D125DB), UINT32_C(0x7682DE13),
            UINT32_C(0xCB951C9E), UINT32_C(0x27987545), UINT32_C(0x1ABE58F4) } },
        { { UINT32_C(0x30C70C8D), UINT32_C(0x6D351640), UINT32_C(0xCE2361B8),
            UINT32_C(0x8047D811), UINT32_C(0xDF8E2C81), UINT32_C(0x3F8B3D4F),
            UINT32_C(0x33FA1F6C), UINT32_C(0x5D595477), UINT32_C(0xE29B8A91),
            UINT32_C(0xF769FE5A), UINT32_C(0xD737B2A2), UINT32_C(0x26F0E606) },
          { UINT32_C(0xB8B31C6A), UINT32_C(0x70CBFA5D), UINT32_C(0x863D3AEA),
            UINT32_C(0x0F883B4A), UINT32_C(0xE386AE2F), UINT32_C(0x156A4479),
            UINT32_C(0xADE8A684), UINT32_C(0xA17A2FCD), UINT32_C(0xE2A7E335),
            UINT32_C(0x78BDF958), UINT32_C(0x3B9E3041), UINT32_C(0xD1B4E673) } },
        { { UINT32_C(0x449A6D11), UINT32_C(0x1EAF48EC), UINT32_C(0x6D2FA7B9),
            UINT32_C(0x6B94B8E4), UINT32_C(0x728E4C1B), UINT32_C(0x1D75D269),
            UINT32_C(0xDD304E2C), UINT32_C(0x91123819), UINT32_C(0x88804F4B),
            UINT32_C(0x0B34CAE3), UINT32_C(0xC5495E9A), UINT32_C(0x2BA192FB) },
          { UINT32_C(0xFF4D24BF), UINT32_C(0xC93FF6EF), UINT32_C(0x0342BA78),
            UINT32_C(0xF8C2C0B0), UINT32_C(0x831EB94C), UINT32_C(0x8041F769),
            UINT32_C(0x7782985E), UINT32_C(0x35310074), UINT32_C(0x3AF84E83),
            UINT32_C(0xC755320B), UINT32_C(0x6F497E7F), UINT32_C(0x384B6D26) } },
        { { UINT32_C(0x17E6BD17), UINT32_C(0xEF92CD59), UINT32_C(0xA426965C),
            UINT32_C(0xA087305B), UINT32_C(0xAC47F773), UINT32_C(0x13895CE7),
            UINT32_C(0xE0BB2867), UINT32_C(0xB85F2A9F), UINT32_C(0x7CD7C58E),
            UINT32_C(0x2926E6AA), UINT32_C(0x450459C5), UINT32_C(0xE544EDA6) },
          { UINT32_C(0xB90A9849), UINT32_C(0x73DBC351), UINT32_C(0x848EBE86),
            UINT32_C(0x961183F6), UINT32_C(0x80534712), UINT32_C(0xC45BB210),
            UINT32_C(0xA654D9A3), UINT32_C(0x379D08D7), UINT32_C(0xBD3FFA9C),
            UINT32_C(0x5B97CEF2), UINT32_C(0xDDC2FCE5), UINT32_C(0x0F469F34) } },
        { { UINT32_C(0x0642F38D), UINT32_C(0x6D146108), UINT32_C(0xD21EB887),
            UINT32_C(0x055171A0), UINT32_C(0xD0DCEB28), UINT32_C(0x28DFFAB4),
            UINT32_C(0x98DE9CCD), UINT32_C(0x0D0E6312), UINT32_C(0x118C3C3F),
            UINT32_C(0x750A9156), UINT32_C(0xB049D799), UINT32_C(0x8C1F1390) },
          { UINT32_C(0x439607C5), UINT32_C(0xE4823858), UINT32_C(0x5C111EAB),
            UINT32_C(0x947E9BA0), UINT32_C(0xA355DF2E), UINT32_C(0x39C95616),
            UINT32_C(0x10E54BDA), UINT32_C(0xF5F6B98E), UINT32_C(0x142B876A),
            UINT32_C(0xB0E0B33D), UINT32_C(0xEA18C90C), UINT32_C(0x71197D73) } },
        { { UINT32_C(0xF52BE819), UINT32_C(0x36A5139D), UINT32_C(0x29A45D2B),
            UINT32_C(0xF60DDF34), UINT32_C(0xE9220E34), UINT32_C(0x0727EFEC),
            UINT32_C(0x4EF7F446), UINT32_C(0x431D3386), UINT32_C(0xFCC4962C),
            UINT32_C(0xC3165A64), UINT32_C(0xD64362BB), UINT32_C(0xB7D926E1) },
          { UINT32_C(0xD45F9350), UINT32_C(0x216BC61F), UINT32_C(0xBBAED815),
            UINT32_C(0xA974CB2F), UINT32_C(0x86FB2F76), UINT32_C(0x31DF342D),
            UINT32_C(0x01D78314), UINT32_C(0x3AB67E05), UINT32_C(0xDEE33ED2),
            UINT32_C(0x7AA951E0), UINT32_C(0xCEC78D94), UINT32_C(0x318FBBBD) } },
        { { UINT32_C(0xB8FE0204), UINT32_C(0xAD7EFB65), UINT32_C(0x230AB7F7),
            UINT32_C(0x0432E1C5), UINT32_C(0x9C967400), UINT32_C(0x7563A62D),
            UINT32_C(0x3524D4FF), UINT32_C(0xD88B9C74), UINT32_C(0xF1A823E3),
            UINT32_C(0x16A1991C), UINT32_C(0xFA6F0FFB), UINT32_C(0xCF2F9BFE) },
          { UINT32_C(0xA50CA61F), UINT32_C(0x55AAA946), UINT32_C(0xFED4CAB3),
            UINT32_C(0x8CBBD3C8), UINT32_C(0x7651365A), UINT32_C(0x03A0FAB8),
            UINT32_C(0x62DC3913), UINT32_C(0x46B5234B), UINT32_C(0xB558CBBD),
            UINT32_C(0xFD875B28), UINT32_C(0x11CEB361), UINT32_C(0xA48EC3AE) } },
        { { UINT32_C(0xB3ADBD8B), UINT32_C(0x5DD131A1), UINT32_C(0x29B45EF8),
            UINT32_C(0xF9FBCA3A), UINT32_C(0x9341EE18), UINT32_C(0x02204866),
            UINT32_C(0x83BF9618), UINT32_C(0x8D13B895), UINT32_C(0xE807459C),
            UINT32_C(0x0E395BAE), UINT32_C(0xB190E7DB), UINT32_C(0xB9C110CC) },
          { UINT32_C(0x25D25063), UINT32_C(0xA0DC3452), UINT32_C(0x02371462),
            UINT32_C(0x2FB78EC8), UINT32_C(0x8975C2D5), UINT32_C(0xC3A9E7BB),
            UINT32_C(0x85A78264), UINT32_C(0x94666872), UINT32_C(0x8029AA92),
            UINT32_C(0x480D2CC2), UINT32_C(0x5655726D), UINT32_C(0x237086C7) } },
        { { UINT32_C(0x65EB9EEE), UINT32_C(0x197F14BB), UINT32_C(0x9F12E5FD),
            UINT32_C(0xFC93125C), UINT32_C(0x8BFBAE5E), UINT32_C(0x9C20BC53),
            UINT32_C(0x4BC053BA), UINT32_C(0xB35E2154), UINT32_C(0x21C3898E),
            UINT32_C(0xE5FA9CC7), UINT32_C(0xD42F950F), UINT32_C(0x502D72FF) },
          { UINT32_C(0xD1EB8C31), UINT32_C(0x6812D38A), UINT32_C(0x080D30BB),
            UINT32_C(0x1F77F3F1), UINT32_C(0x5A8B1E98), UINT32_C(0x18D12833),
            UINT32_C(0x299196CE), UINT32_C(0x7FD39FA9), UINT32_C(0xCF4ED6D6),
            UINT32_C(0xFB8C9F11), UINT32_C(0xD6363194), UINT32_C(0x4C00F604) } },
        { { UINT32_C(0xFA2A21C2), UINT32_C(0x5C8AFCF9), UINT32_C(0x1928D133),
            UINT32_C(0x71CBF282), UINT32_C(0x42B29506), UINT32_C(0x56BEF28E),
            UINT32_C(0x70323DE2), UINT32_C(0xAFBA250C), UINT32_C(0x7DED2C30),
            UINT32_C(0x3FE208D1), UINT32_C(0xCE9AA598), UINT32_C(0xBD2CD213) },
          { UINT32_C(0xCFEED070), UINT32_C(0x52C5EC52), UINT32_C(0xD3DA336B),
            UINT32_C(0x0A7223E7), UINT32_C(0xCE156B46), UINT32_C(0x7156A4ED),
            UINT32_C(0xED7E6159), UINT32_C(0x9AF6C499), UINT32_C(0x13C029AD),
            UINT32_C(0x9D7A6797), UINT32_C(0x9018DC77), UINT32_C(0xE5B5C924) } },
    },
    {
        { { UINT32_C(0xDE1E4E55), UINT32_C(0x3F2EFF53), UINT32_C(0xE4D3ECC4),
            UINT32_C(0x6B749943), UINT32_C(0x0DDE190D), UINT32_C(0xAF10B18A),
            UINT32_C(0xA26B0409), UINT32_C(0xF491B98D), UINT32_C(0xA2B1D944),
            UINT32_C(0x66080782), UINT32_C(0x97E8C541), UINT32_C(0x59277DC6) },
          { UINT32_C(0x006F18AA), UINT32_C(0xFDBFC5F6), UINT32_C(0xFADD8BE1),
            UINT32_C(0x435D165B), UINT32_C(0x57645EF4), UINT32_C(0x8E5D2638),
            UINT32_C(0xA0258363), UINT32_C(0x31BCFDA6), UINT32_C(0xD35D2503),
            UINT32_C(0xF5330AB8), UINT32_C(0xC7CAB285), UINT32_C(0xB71369F0) } },
        { { UINT32_C(0x40ACC5A8), UINT32_C(0xE6A19DCC), UINT32_C(0xDBC6DBF8),
            UINT32_C(0x1C3A1FF1), UINT32_C(0xC6455613), UINT32_C(0xB4D89B9F),
            UINT32_C(0xA7390D0E), UINT32_C(0x6CB0FE44), UINT32_C(0x59EA135A),
            UINT32_C(0xADE197A4), UINT32_C(0x20680982), UINT32_C(0xDA6AA865) },
          { UINT32_C(0x5A442C1B), UINT32_C(0x03DB9BE9), UINT32_C(0x2BFB93F2),
            UINT32_C(0x221A2D73), UINT32_C(0x753C196C), UINT32_C(0x44DEE8D4),
            UINT32_C(0x0B7C6FF5), UINT32_C(0x59ADCC70), UINT32_C(0x4CA1B142),
            UINT32_C(0xC6260EC2), UINT32_C(0x46CBD4F2), UINT32_C(0x4C3CB5C6) } },
        { { UINT32_C(0xA417111F), UINT32_C(0x8A15D6FE), UINT32_C(0x71D93FCC),
            UINT32_C(0xFE4A16BD), UINT32_C(0x55BBE732), UINT32_C(0x7A7EE38C),
            UINT32_C(0x1FF94A9D), UINT32_C(0xEFF146A5), UINT32_C(0xDD585AB5),
            UINT32_C(0xE572D13E), UINT32_C(0x06491A5D), UINT32_C(0xD879790E) },
          { UINT32_C(0x2A58CB2E), UINT32_C(0x9C84E1C5), UINT32_C(0x6C938630),
            UINT32_C(0xD79D1374), UINT32_C(0x385F06C7), UINT32_C(0xDB12CD9B),
            UINT32_C(0x7A7759C3), UINT32_C(0x0C93EB97), UINT32_C(0x683BD706),
            UINT32_C(0xF1F5B0FE), UINT32_C(0x85EC3D50), UINT32_C(0x541E4F72) } },
        { { UINT32_C(0x81833608), UINT32_C(0x9A0E1535), UINT32_C(0x6E2833AC),
            UINT32_C(0x5CCE871E), UINT32_C(0xFB29777C), UINT32_C(0xC17059EA),
            UINT32_C(0xE354CAFD), UINT32_C(0x7E40E5FA), UINT32_C(0x4D07C371),
            UINT32_C(0x9CF59405), UINT32_C(0xA71C3945), UINT32_C(0x64CE36B2) },
          { UINT32_C(0x56CAF487), UINT32_C(0x69309E96), UINT32_C(0x1AE3454B),
            UINT32_C(0x3D719E9F), UINT32_C(0xE25823B6), UINT32_C(0xF2164070),
            UINT32_C(0x0BC27359), UINT32_C(0xEAD851BD), UINT32_C(0xB0925094),
            UINT32_C(0x3D21BFE8), UINT32_C(0x34A97F4E), UINT32_C(0xA783B1E9) } },
        { { UINT32_C(0x9546491A), UINT32_C(0x406B0C26), UINT32_C(0xF293C4E5),
            UINT32_C(0x9E5E15E2), UINT32_C(0x15B164DB), UINT32_C(0xC60D6413),
            UINT32_C(0x0C75A78E), UINT32_C(0x0DA46F53), UINT32_C(0xEA0C656B),
            UINT32_C(0x7C599BB7), UINT32_C(0x1B1A8122), UINT32_C(0x0F07A512) },
          { UINT32_C(0x15172686), UINT32_C(0x14C7204A), UINT32_C(0x5165625D),
            UINT32_C(0x8FAEDFF8), UINT32_C(0x37AEDE40), UINT32_C(0x20F260CE),
            UINT32_C(0x8F357FFE), UINT32_C(0xC81F771E), UINT32_C(0xB0912557),
            UINT32_C(0x25499197), UINT32_C(0x4C739C74), UINT32_C(0x736197DC) } },
        { { UINT32_C(0x381B3462), UINT32_C(0x6151BAB1), UINT32_C(0x43DBD344),
            UINT32_C(0x27E5A078), UINT32_C(0xA1C3E9FB), UINT32_C(0x2CB05BD6),
            UINT32_C(0x27CF2A11), UINT32_C(0x2A759760), UINT32_C(0xFF43E702),
            UINT32_C(0x0ADCF9DB), UINT32_C(0x1F484146), UINT32_C(0x4BBF03E2) },
          { UINT32_C(0x55B6521A), UINT32_C(0x0E74997F), UINT32_C(0xADE17086),
            UINT32_C(0x15629231), UINT32_C(0x7493FC58), UINT32_C(0x7F143E86),
            UINT32_C(0xAF8B9670), UINT32_C(0x60869095), UINT32_C(0x7E524869),
            UINT32_C(0x482CFCD7), UINT32_C(0x1D454756), UINT32_C(0x9E8060C3) } },
        { { UINT32_C(0xC88B4D3B), UINT32_C(0xE495747A), UINT32_C(0xAE8A948F),
            UINT32_C(0xB7559835), UINT32_C(0xDEB56853), UINT32_C(0x67EEF3A9),
            UINT32_C(0x9DEE5ADF), UINT32_C(0x0E20E269), UINT32_C(0x61F0A1AA),
            UINT32_C(0x9031AF67), UINT32_C(0x683402BC), UINT32_C(0x76669D32) },
          { UINT32_C(0x06718B16), UINT32_C(0x90BD2313), UINT32_C(0x864EFDAC),
            UINT32_C(0xE1B22A21), UINT32_C(0x6620089F), UINT32_C(0xE4FFE909),
            UINT32_C(0x3428E2D9), UINT32_C(0xB84C842E), UINT32_C(0xFE3871FC),
            UINT32_C(0x0E28C880), UINT32_C(0x3F21C200), UINT32_C(0x8932F698) } },
        { { UINT32_C(0x6C90EA5D), UINT32_C(0x603F00CE), UINT32_C(0x40A2F693),
            UINT32_C(0x64739307), UINT32_C(0x2174E517), UINT32_C(0xAF65148B),
            UINT32_C(0xF784AE74), UINT32_C(0x162FC2CA), UINT32_C(0x4D5F6458),
            UINT32_C(0x0D9A8825), UINT32_C(0x43AACE93), UINT32_C(0x0C2D5861) },
          { UINT32_C(0x9F73CBFC), UINT32_C(0xBF1EADDE), UINT32_C(0x9C68BBCA),
            UINT32_C(0xDE9C34C0), UINT32_C(0x67EF8A1A), UINT32_C(0x6D95602D),
            UINT32_C(0xA791B241), UINT32_C(0x0AF2581B), UINT32_C(0x12CAD604),
            UINT32_C(0x14F77361), UINT32_C(0xE2ACD1AD), UINT32_C(0x19F2354D) } },
        { { UINT32_C(0x0D60F263), UINT32_C(0x272F78F6), UINT32_C(0x208FD785),
            UINT32_C(0xE7A8F4AF), UINT32_C(0x36554F2C), UINT32_C(0x10E191C6),
            UINT32_C(0xFD5CD0B3), UINT32_C(0x06D88551), UINT32_C(0x57069C27),
            UINT32_C(0x29BF8568), UINT32_C(0x28AA6FAD), UINT32_C(0x3CE7ECD8) },
          { UINT32_C(0xE9F1A1D8), UINT32_C(0x7D8A92D0), UINT32_C(0xD30B5725),
            UINT32_C(0xD40C7FF8), UINT32_C(0xF54CAEB8), UINT32_C(0x16BE6CB2),
            UINT32_C(0x14CB0A91), UINT32_C(0x14CA471A), UINT32_C(0x02733CAE),
            UINT32_C(0xD5FF15B8), UINT32_C(0xDAA76580), UINT32_C(0xCAF88D87) } },
        { { UINT32_C(0x2C046592), UINT32_C(0x39430E22), UINT32_C(0x1AD26706),
            UINT32_C(0x6CDAE81F), UINT32_C(0xA25D9106), UINT32_C(0x8C102159),
            UINT32_C(0x27CA9F30), UINT32_C(0x9A440572), UINT32_C(0x70287FBC),
            UINT32_C(0x8D34C430), UINT32_C(0x29DB8AFA), UINT32_C(0x9003A455) },
          { UINT32_C(0x7FD971AD), UINT32_C(0x91364CC3), UINT32_C(0x9C60EDB7),
            UINT32_C(0x7B3AA048), UINT32_C(0x526F4DD8), UINT32_C(0x58B0E008),
            UINT32_C(0xD86D98AE), UINT32_C(0xB7674454), UINT32_C(0xB2B45747),
            UINT32_C(0xC25F4051), UINT32_C(0xCC043E8F), UINT32_C(0x8243BF9C) } },
        { { UINT32_C(0x43A0C387), UINT32_C(0xA89641C6), UINT32_C(0x87B9AB17),
            UINT32_C(0x6D92205C), UINT32_C(0xDAA0E102), UINT32_C(0x37D691F4),
            UINT32_C(0xCDE5312E), UINT32_C(0xEB3E52D7), UINT32_C(0x16F518A2),
            UINT32_C(0x60D3C099), UINT32_C(0x8A378EEB), UINT32_C(0x7854C051) },
          { UINT32_C(0x4BBCAAC5), UINT32_C(0x7359DB51), UINT32_C(0x1713F102),
            UINT32_C(0xF5B1B68C), UINT32_C(0xE4398DE5), UINT32_C(0xDAEAE645),
            UINT32_C(0xD1ABFB82), UINT32_C(0x8C8ACB6C), UINT32_C(0x136423E2),
            UINT32_C(0x2E8B76C3), UINT32_C(0xA8BA015E), UINT32_C(0x509DCB2D) } },
        { { UINT32_C(0x9AD9C59C), UINT32_C(0x2FF36815), UINT32_C(0x658E65B9),
            UINT32_C(0xB189A4E8), UINT32_C(0xEA786AD2), UINT32_C(0x7D33DDBB),
            UINT32_C(0xC0D2DC05), UINT32_C(0x96D0D648), UINT32_C(0xBFA03BE9),
            UINT32_C(0x05E49256), UINT32_C(0x8BAF5A1C), UINT32_C(0x0EA4E7A6) },
          { UINT32_C(0x9F9AD5A8), UINT32_C(0x3DDCE0B0), UINT32_C(0x9E49C2CB),
            UINT32_C(0xF7809195), UINT32_C(0x21782C2F), UINT32_C(0xBFCEF29D),
            UINT32_C(0xC41BFD97), UINT32_C(0xE57AD39F), UINT32_C(0x1355AD19),
            UINT32_C(0xC04B93E8), UINT32_C(0x59440F9F), UINT32_C(0xAABC9E6E) } },
        { { UINT32_C(0x5B6459DA), UINT32_C(0x7AA48103), UINT32_C(0x0166E880),
            UINT32_C(0x83EF7477), UINT32_C(0x511CCE80), UINT32_C(0x536182B1),
            UINT32_C(0x73CA55AA), UINT32_C(0xAFDD2EEE), UINT32_C(0xA8716143),
            UINT32_C(0xAB910D0D), UINT32_C(0x83707250), UINT32_C(0x8BEAA42B) },
          { UINT32_C(0x8DA2AB3D), UINT32_C(0x4BCCFD89), UINT32_C(0xEC6AA105),
            UINT32_C(0x1DBF68A9), UINT32_C(0x68EB42DA), UINT32_C(0x32CE6108),
            UINT32_C(0x8EA62E37), UINT32_C(0x5C2C2C85), UINT32_C(0xCD3088A7),
            UINT32_C(0x1ED2791F), UINT32_C(0xFF05070C), UINT32_C(0x496B4FEB) } },
        { { UINT32_C(0x0AA629C5), UINT32_C(0x9FA9121A), UINT32_C(0x57558BEC),
            UINT32_C(0xE286CFF1), UINT32_C(0x59813A4D), UINT32_C(0x4D9D657E),
            UINT32_C(0x26103519), UINT32_C(0xC4676A16), UINT32_C(0x2BD4DF80),
            UINT32_C(0x616160B3), UINT32_C(0x30FBAE87), UINT32_C(0x26FB78CC) },
          { UINT32_C(0x8F0F66BD), UINT32_C(0x09607013), UINT32_C(0x03D9B90D),
            UINT32_C(0xDD4E2D0C), UINT32_C(0x600D1B12), UINT32_C(0x5D3A8912),
            UINT32_C(0x4308E126), UINT32_C(0xF76DD52F), UINT32_C(0x9E4FCCA6),
            UINT32_C(0x97CC0409), UINT32_C(0x04C4DF7B), UINT32_C(0x0CFBE311) } },
        { { UINT32_C(0x28437A23), UINT32_C(0x6CA62C12), UINT32_C(0x40E7A003),
            UINT32_C(0x0DAF3353), UINT32_C(0xD20F8079), UINT32_C(0x1FD07DF0),
            UINT32_C(0x3BBC9749), UINT32_C(0xEAE7969C), UINT32_C(0x9ECAD022),
            UINT32_C(0x55861AFA), UINT32_C(0x1FBC3D4C), UINT32_C(0xEC41DAD9) },
          { UINT32_C(0xDA8B261B), UINT32_C(0x1FE4CB40), UINT32_C(0x427C5C9D),
            UINT32_C(0xC2671AB6), UINT32_C(0x261D4939), UINT32_C(0xDFCDA7B8),
            UINT32_C(0x2072C0B9), UINT32_C(0x9E7B802B), UINT32_C(0xC7828CC2),
            UINT32_C(0x3AFEE900), UINT32_C(0xF6DE987F), UINT32_C(0x3488BF28) } },
        { { UINT32_C(0x7BE1F89E), UINT32_C(0x33B9F2DE), UINT32_C(0x299B15C9),
            UINT32_C(0xD4E80821), UINT32_C(0x0E13F37F), UINT32_C(0x87A3067A),
            UINT32_C(0x55FD239F), UINT32_C(0x6D4C09ED), UINT32_C(0x92EF014F),
            UINT32_C(0x48B1042D), UINT32_C(0xB385A759), UINT32_C(0xA382B2E0) },
          { UINT32_C(0x7F6F84F8), UINT32_C(0xBF571BB0), UINT32_C(0x0CE87F50),
            UINT32_C(0x25AFFA37), UINT32_C(0xFE54F1BC), UINT32_C(0x826906D3),
            UINT32_C(0xC53AE76A), UINT32_C(0x6B0421F4), UINT32_C(0x4855EB3C),
            UINT32_C(0x44F85A3A), UINT32_C(0x8D1F2B27), UINT32_C(0xF49E2151) } },
    },
    {
        { { UINT32_C(0x5E3C647B), UINT32_C(0xC0426B77), UINT32_C(0x8CF05348),
            UINT32_C(0xBFCBD939), UINT32_C(0x172C0D3D), UINT32_C(0x31D312E3),
            UINT32_C(0xEE754737), UINT32_C(0x5F49FDE6), UINT32_C(0x6DA7EE61),
            UINT32_C(0x895530F0), UINT32_C(0xE8B3A5FB), UINT32_C(0xCF281B0A) },
          { UINT32_C(0x41B8A543), UINT32_C(0xFD149735), UINT32_C(0x3080DD30),
            UINT32_C(0x41A625A7), UINT32_C(0x653908CF), UINT32_C(0xE2BAAE07),
            UINT32_C(0xBA02A278), UINT32_C(0xC3D01436), UINT32_C(0x7B21B8F8),
            UINT32_C(0xA0D0222E), UINT32_C(0xD7EC1297), UINT32_C(0xFDC270E9) } },
        { { UINT32_C(0x9F101E64), UINT32_C(0x06A67BD2), UINT32_C(0xE1733A4A),
            UINT32_C(0xCB6E0AC7), UINT32_C(0x97BC62D2), UINT32_C(0xEE0B5D51),
            UINT32_C(0x24C51874), UINT32_C(0x52B17039), UINT32_C(0x82A1A0D5),
            UINT32_C(0xFED1F423), UINT32_C(0xDB6270AC), UINT32_C(0x55D90569) },
          { UINT32_C(0x5D73D533), UINT32_C(0x36BE4A9C), UINT32_C(0x976ED4D5),
            UINT32_C(0xBE9266D6), UINT32_C(0xB8F8074B), UINT32_C(0xC17436D3),
            UINT32_C(0x718545C6), UINT32_C(0x3BB4D399), UINT32_C(0x5C757D21),
            UINT32_C(0x8E1EA355), UINT32_C(0x8C474366), UINT32_C(0xF7EDBC97) } },
        { { UINT32_C(0x6EA83242), UINT32_C(0xEC72C650), UINT32_C(0x1B2D237F),
            UINT32_C(0xF7DE7BE5), UINT32_C(0x1819EFB0), UINT32_C(0x3C5E2200),
            UINT32_C(0x8CDDE870), UINT32_C(0xDF5AB6D6), UINT32_C(0x92A87AEE),
            UINT32_C(0x75A44E9D), UINT32_C(0xBCF77F19), UINT32_C(0xBDDC46F4) },
          { UINT32_C(0x669B674D), UINT32_C(0x8191EFBD), UINT32_C(0xED71768F),
            UINT32_C(0x52884DF9), UINT32_C(0x65CF242C), UINT32_C(0xE62BE582),
            UINT32_C(0x80B1D17B), UINT32_C(0xAE99A3B1), UINT32_C(0x92DE59A9),
            UINT32_C(0x48CBB446), UINT32_C(0x2DCB3CE2), UINT32_C(0xD3C226CF) } },
        { { UINT32_C(0x9FD94EC4), UINT32_C(0x9580CDFB), UINT32_C(0x28631AD9),
            UINT32_C(0xED273A6C), UINT32_C(0xC327F3E7), UINT32_C(0x5D3D5F77),
            UINT32_C(0x35353C5F), UINT32_C(0x05D5339C), UINT32_C(0x5C258EB1),
            UINT32_C(0xC56FB5FE), UINT32_C(0xEDCE1F79), UINT32_C(0xEFF8425E) },
          { UINT32_C(0xCF83CF9C), UINT32_C(0xAB7AA141), UINT32_C(0x207D6D4F),
            UINT32_C(0xBD2A690A), UINT32_C(0x458D9E52), UINT32_C(0xE1241491),
            UINT32_C(0xAA7F0F31), UINT32_C(0xDD2448CC), UINT32_C(0xF0FDA7AB),
            UINT32_C(0xEC58D3C7), UINT32_C(0xC91BBA4D), UINT32_C(0x7B6E122D) } },
        { { UINT32_C(0xB1B48156), UINT32_C(0x2A2DEDAF), UINT32_C(0xBB93DB87),
            UINT32_C(0xA0A2C63A), UINT32_C(0x08ACD99E), UINT32_C(0xC6559078),
            UINT32_C(0xFE4AC331), UINT32_C(0x03EA42AF), UINT32_C(0xEB180ED6),
            UINT32_C(0x43D2C14A), UINT32_C(0xB1156A1A), UINT32_C(0xC2F293DD) },
          { UINT32_C(0xA9D81249), UINT32_C(0x1FAFABF5), UINT32_C(0x9A8EEE87),
            UINT32_C(0x39ADDEAD), UINT32_C(0x119E2E92), UINT32_C(0x21E206F2),
            UINT32_C(0xD74DCEB6), UINT32_C(0xBC5DCC2E), UINT32_C(0x0A73A358),
            UINT32_C(0x86647FA3), UINT32_C(0x2F53F642), UINT32_C(0xEAD8BEA4) } },
        { { UINT32_C(0x91C09091), UINT32_C(0x636225F5), UINT32_C(0x71BDCFDF),
            UINT32_C(0xCCF5070A), UINT32_C(0xB9668EE2), UINT32_C(0x0EF8D625),
            UINT32_C(0xB5E04E4F), UINT32_C(0x57BDF6CD), UINT32_C(0x7C75EA43),
            UINT32_C(0xFC6AB0A6), UINT32_C(0xF7FD6EF3), UINT32_C(0xEB6B8AFB) },
          { UINT32_C(0x2A3DF404), UINT32_C(0x5B2AEEF0), UINT32_C(0xB9823197),
            UINT32_C(0x31FD3B48), UINT32_C(0x83A7EB23), UINT32_C(0x56226DB6),
            UINT32_C(0x5BB1ED2F), UINT32_C(0x3772C21E), UINT32_C(0xCD1ABA6A),
            UINT32_C(0x3E833624), UINT32_C(0xAC672DAD), UINT32_C(0xBAE58FFA) } },
        { { UINT32_C(0x31BA1705), UINT32_C(0xCE92224D), UINT32_C(0xF0197F63),
            UINT32_C(0x022C6ED2), UINT32_C(0xA4DC1113), UINT32_C(0x21F18D99),
            UINT32_C(0x03616BF1), UINT32_C(0x5CD04DE8), UINT32_C(0x9FF12E08),
            UINT32_C(0x6F900679), UINT32_C(0x48E61DDF), UINT32_C(0xF59A3315) },
          { UINT32_C(0xB51BD024), UINT32_C(0x9474D42C), UINT32_C(0x9051E49D),
            UINT32_C(0x11A0A413), UINT32_C(0xDCE70EDB), UINT32_C(0x79C92705),
            UINT32_C(0x34198426), UINT32_C(0x113CE278), UINT32_C(0xEA8616D2),
            UINT32_C(0x8978396F), UINT32_C(0xEA894C36), UINT32_C(0x9A2A14D0) } },
        { { UINT32_C(0x604F6E4A), UINT32_C(0x4F1E1254), UINT32_C(0x0187D585),
            UINT32_C(0x4513B088), UINT32_C(0x19E0F482), UINT32_C(0x9022F257),
            UINT32_C(0xE2239DBF), UINT32_C(0x51FB2A80), UINT32_C(0x998ED9D5),
            UINT32_C(0x49940D9E), UINT32_C(0x6C932C5D), UINT32_C(0x0583D241) },
          { UINT32_C(0xF25B73F7), UINT32_C(0x1188CEC8), UINT32_C(0x3B3D06CD),
            UINT32_C(0xA28788CB), UINT32_C(0xA083DB5A), UINT32_C(0xDEA194EC),
            UINT32_C(0x22DF4272), UINT32_C(0xD93A4F7E), UINT32_C(0x6A009C49),
            UINT32_C(0x8D84E4BF), UINT32_C(0x3E3E4A9E), UINT32_C(0x893D8DD9) } },
        { { UINT32_C(0x33D31160), UINT32_C(0x35E909EA), UINT32_C(0x57172F1E),
            UINT32_C(0x50203168), UINT32_C(0x51F3D866), UINT32_C(0x2707FC44),
            UINT32_C(0xD2442A5D), UINT32_C(0xEB9D2018), UINT32_C(0x5DBFE378),
            UINT32_C(0x904D7209), UINT32_C(0x5F13CF77), UINT32_C(0x6DB132A3) },
          { UINT32_C(0x7A3AF54B), UINT32_C(0x9D842BA6), UINT32_C(0x5AA5B4F9),
            UINT32_C(0x4E16EA19), UINT32_C(0xAF24228E), UINT32_C(0x2BBA457C),
            UINT32_C(0x16F3C5FE), UINT32_C(0xCC04B3BB), UINT32_C(0x77E64944),
            UINT32_C(0xBAFAC516), UINT32_C(0xF08BCEE0), UINT32_C(0x31580A34) } },
        { { UINT32_C(0x20C30ACA), UINT32_C(0xC6808DEE), UINT32_C(0xA3EA2056),
            UINT32_C(0xDADD216F), UINT32_C(0x7A4A9F9D), UINT32_C(0xD331394E),
            UINT32_C(0x424C4026), UINT32_C(0x9E0441AD), UINT32_C(0x0AEB5350),
            UINT32_C(0xAEED102F), UINT32_C(0xD45B09DA), UINT32_C(0xC6697FBB) },
          { UINT32_C(0xDEAC1496), UINT32_C(0x52A2590E), UINT32_C(0x250B87AF),
            UINT32_C(0x7142B831), UINT32_C(0x6D0784A8), UINT32_C(0xBEF2E68B),
            UINT32_C(0xA5F71CEF), UINT32_C(0x5F62593A), UINT32_C(0xB5DA51A3),
            UINT32_C(0x3B8F7616), UINT32_C(0xB680F5FE), UINT32_C(0xC7A6FA0D) } },
        { { UINT32_C(0x99C8227C), UINT32_C(0x36C21DE6), UINT32_C(0xC26813B1),
            UINT32_C(0xBEE3E867), UINT32_C(0xBDD91549), UINT32_C(0x9B05F2E6),
            UINT32_C(0xA7D1110F), UINT32_C(0x34FF2B1F), UINT32_C(0x37F67FD0),
            UINT32_C(0x8E6953B9), UINT32_C(0xC3183E20), UINT32_C(0x56C7F18B) },
          { UINT32_C(0x9E2019ED), UINT32_C(0x48AF46DE), UINT32_C(0xF551BBBF),
            UINT32_C(0xDEAF972E), UINT32_C(0xCC5E3EEF), UINT32_C(0x88EE38F8),
            UINT32_C(0x392D6BAF), UINT32_C(0xFB8D7A44), UINT32_C(0x0127187D),
            UINT32_C(0x32293BFC), UINT32_C(0xE58647CC), UINT32_C(0x7689E767) } },
        { { UINT32_C(0x52168013), UINT32_C(0x00CE901B), UINT32_C(0x837AAE71),
            UINT32_C(0xC6BF8E38), UINT32_C(0x167677D8), UINT32_C(0xD6F11EFA),
            UINT32_C(0x86C8E5CF), UINT32_C(0xE53BB485), UINT32_C(0xC48E74AB),
            UINT32_C(0x671167CE), UINT32_C(0x8AD720A7), UINT32_C(0x8A40218C) },
          { UINT32_C(0xE7C1191A), UINT32_C(0x81E827A6), UINT32_C(0xADDB153D),
            UINT32_C(0x54058F8D), UINT32_C(0x0D950FA2), UINT32_C(0x0BAF2925),
            UINT32_C(0x576DDA13), UINT32_C(0xC244674D), UINT32_C(0x41BCD13B),
            UINT32_C(0x8C4630AE), UINT32_C(0x5A077419), UINT32_C(0x6C2127BF) } },
        { { UINT32_C(0xA83C501F), UINT32_C(0xCF977FD5), UINT32_C(0xB6AB176F),
            UINT32_C(0xD7C6DF36), UINT32_C(0x397BC6B5), UINT32_C(0x117F6331),
            UINT32_C(0xF7A2D491), UINT32_C(0x72A6078B), UINT32_C(0x5242FE2E),
            UINT32_C(0xE5A2AAED), UINT32_C(0xFEBDC212), UINT32_C(0x88ECFFDC) },
          { UINT32_C(0xCE33BA21), UINT32_C(0xF2DBBF50), UINT32_C(0xCEB19F07),
            UINT32_C(0xE1343B76), UINT32_C(0xD2C28F71), UINT32_C(0x1F32D4C9),
            UINT32_C(0x18587685), UINT32_C(0x93FC64B4), UINT32_C(0xBA1F8BD1),
            UINT32_C(0x39CEEF9B), UINT32_C(0x8D6D6BB0), UINT32_C(0x99C36A78) } },
        { { UINT32_C(0x3E9561CF), UINT32_C(0x0D063817), UINT32_C(0x3D33704D),
            UINT32_C(0x1D8646AA), UINT32_C(0x7A08BA33), UINT32_C(0x8C451384),
            UINT32_C(0xE02D6624), UINT32_C(0x96446BD3), UINT32_C(0x2D6F4166),
            UINT32_C(0x749849F0), UINT32_C(0x14268BF0), UINT32_C(0xE364DA01) },
          { UINT32_C(0x9AEBFCFD), UINT32_C(0x7CE4587E), UINT32_C(0x56234393),
            UINT32_C(0xD4686064), UINT32_C(0x16DF73B2), UINT32_C(0x00231D51),
            UINT32_C(0x7279C78C), UINT32_C(0xF6A969B7), UINT32_C(0x6CB4117C),
            UINT32_C(0x1FF1F6B6), UINT32_C(0xD3EAB680), UINT32_C(0x30AEBC39) } },
        { { UINT32_C(0x93EF00B9), UINT32_C(0x5CC97E64), UINT32_C(0x972345AE),
            UINT32_C(0xDAE13841), UINT32_C(0x4788F43C), UINT32_C(0x85839184),
            UINT32_C(0xE2E6CF3E), UINT32_C(0xD0FF521E), UINT32_C(0x4B707C86),
            UINT32_C(0xAED14A5B), UINT32_C(0xD2523CF7), UINT32_C(0x7EAAE4A6) },
          { UINT32_C(0x024C8AC6), UINT32_C(0x266472C5), UINT32_C(0xC0170051),
            UINT32_C(0xE47E1522), UINT32_C(0x73826BAE), UINT32_C(0x7B83DA61),
            UINT32_C(0xCF543F0D), UINT32_C(0xE97E19F5), UINT32_C(0x20BF38E2),
            UINT32_C(0x5D5248FA), UINT32_C(0xDF56A037), UINT32_C(0x8A7C2F7D) } },
        { { UINT32_C(0x87B0526C), UINT32_C(0xB04659DD), UINT32_C(0x2307565E),
            UINT32_C(0x593C604A), UINT32_C(0x7C630AB8), UINT32_C(0x49E52225),
            UINT32_C(0xDCE9CD23), UINT32_C(0x24C1D0C6), UINT32_C(0x85177079),
            UINT32_C(0x6FDB241C), UINT32_C(0xF250C351), UINT32_C(0x5F521D19) },
          { UINT32_C(0xA6FB61DF), UINT32_C(0xFB56134B), UINT32_C(0xD75C07ED),
            UINT32_C(0xA4E70D69), UINT32_C(0x7D8825A8), UINT32_C(0xB7A82448),
            UINT32_C(0xDD64BBCC), UINT32_C(0xA3AEA7D4), UINT32_C(0x8692F539),
            UINT32_C(0xD53E6E6C), UINT32_C(0xF7AA4BC0), UINT32_C(0x8DDDA83B) } },
    },
    {
        { { UINT32_C(0xDD93D50A), UINT32_C(0x140A0F9F), UINT32_C(0x83B7ABAC),
            UINT32_C(0x4799FFDE), UINT32_C(0x04A1F742), UINT32_C(0x78FF7C23),
            UINT32_C(0x195BA34E), UINT32_C(0xC0568F51), UINT32_C(0x3B7F78B4),
            UINT32_C(0xE9718360), UINT32_C(0xF9EFAA53), UINT32_C(0x9CFD1FF1) },
          { UINT32_C(0xBB06022E), UINT32_C(0xE924D2C5), UINT32_C(0xFAA2AF6D),
            UINT32_C(0x9987FA86), UINT32_C(0x6EE37E0F), UINT32_C(0x4B12E73F),
            UINT32_C(0x5E5A1DDE), UINT32_C(0x1836FDFA), UINT32_C(0x9DCD6416),
            UINT32_C(0x7F1B9225), UINT32_C(0x677544D8), UINT32_C(0xCB2C1B4D) } },
        { { UINT32_C(0x9C213D95), UINT32_C(0x0254486D), UINT32_C(0xCB2F6E94),
            UINT32_C(0x68A9DB56), UINT32_C(0x000F5491), UINT32_C(0xFB5858BA),
            UINT32_C(0x34009FB6), UINT32_C(0x1315BDD9), UINT32_C(0xC42BDE30),
            UINT32_C(0xB18A8E0A), UINT32_C(0xF1070358), UINT32_C(0xFDCF93D1) },
          { UINT32_C(0x3022937E), UINT32_C(0xBEB1DB75), UINT32_C(0xCAC20DB4),
            UINT32_C(0x9B9ECA7A), UINT32_C(0xE4122B20), UINT32_C(0x152214D4),
            UINT32_C(0xAABCCC7B), UINT32_C(0xD3E673F2), UINT32_C(0xAED07571),
            UINT32_C(0x94C50F64), UINT32_C(0xE66B4F17), UINT32_C(0xD767059A) } },
        { { UINT32_C(0xDCD6D14B), UINT32_C(0x40336B12), UINT32_C(0xE3B4919C),
            UINT32_C(0xF6BCFF5D), UINT32_C(0x9C841F0C), UINT32_C(0xC337048D),
            UINT32_C(0x1D617F50), UINT32_C(0x4CE6D025), UINT32_C(0x8117D379),
            UINT32_C(0x00FEF219), UINT32_C(0xF95BE243), UINT32_C(0x18B7C4E9) },
          { UINT32_C(0x38DF08FF), UINT32_C(0x98DE119E), UINT32_C(0x8D772D20),
            UINT32_C(0xDFD803BD), UINT32_C(0x0F9678BD), UINT32_C(0x94125B72),
            UINT32_C(0x334ACE30), UINT32_C(0xFC5B57CD), UINT32_C(0xB7E86E04),
            UINT32_C(0x09486527), UINT32_C(0x6E552039), UINT32_C(0xFE9F8BCC) } },
        { { UINT32_C(0xD6F5A10E), UINT32_C(0x3B75C45B), UINT32_C(0xC1C35F38),
            UINT32_C(0xFD4680F4), UINT32_C(0xF8E0A113), UINT32_C(0x5450227D),
            UINT32_C(0x73DDBA24), UINT32_C(0x5E69F1AE), UINT32_C(0x57F24645),
            UINT32_C(0x2007B80E), UINT32_C(0x3D159741), UINT32_C(0xC63695DC) },
          { UINT32_C(0x4530F623), UINT32_C(0xCBE54D29), UINT32_C(0x2869586B),
            UINT32_C(0x986AD573), UINT32_C(0x4CC39F73), UINT32_C(0xE19F7059),
            UINT32_C(0x2B1B8DA9), UINT32_C(0x80F00AB3), UINT32_C(0x73F68D26),
            UINT32_C(0xB765AAF9), UINT32_C(0xE993F829), UINT32_C(0xBC79A394) } },
        { { UINT32_C(0xF310D2A0), UINT32_C(0x9C441043), UINT32_C(0xDC5EB106),
            UINT32_C(0x2865EE58), UINT32_C(0x9CB8065C), UINT32_C(0x71A95922),
            UINT32_C(0xA052AF0F), UINT32_C(0x8EB3A733), UINT32_C(0xB09D716E),
            UINT32_C(0x56009F42), UINT32_C(0xABCBE6AD), UINT32_C(0xA7F923C5) },
          { UINT32_C(0xFA375C01), UINT32_C(0x263B7669), UINT32_C(0x21EF27A2),
            UINT32_C(0x641C47E5), UINT32_C(0xB08FFD25), UINT32_C(0xA89B474E),
            UINT32_C(0xF0A239F3), UINT32_C(0x5BE8EC3F), UINT32_C(0x242A6C5A),
            UINT32_C(0x0E79957A), UINT32_C(0x0C6C75F5), UINT32_C(0x1DFB26D0) } },
        { { UINT32_C(0x9DFBF22A), UINT32_C(0x2FD97B9B), UINT32_C(0x5643532D),
            UINT32_C(0xDEC16CC8), UINT32_C(0x60FEE7C3), UINT32_C(0xDF0E6E39),
            UINT32_C(0x545860C8), UINT32_C(0xD09AD7B6), UINT32_C(0x73FC3B7C),
            UINT32_C(0xCC16E984), UINT32_C(0x0D4E1555), UINT32_C(0x6CE734C1) },
          { UINT32_C(0x4B5F6032), UINT32_C(0xC6EFE68B), UINT32_C(0x14F54073),
            UINT32_C(0x3A64F34C), UINT32_C(0xAC44DC95), UINT32_C(0x25DA689C),
            UINT32_C(0x5358AD8A), UINT32_C(0x990C477E), UINT32_C(0xF36DA7DE),
            UINT32_C(0x00E958A5), UINT32_C(0xC9B6F161), UINT32_C(0x902B7360) } },
        { { UINT32_C(0x9347B90A), UINT32_C(0x454AB42C), UINT32_C(0xA698B02B),
            UINT32_C(0xCAEBE64A), UINT32_C(0xFB86FA40), UINT32_C(0x119CDC69),
            UINT32_C(0xC3109281), UINT32_C(0x2E5CB7AD), UINT32_C(0xCD0C3D00),
            UINT32_C(0x67BB1EC5), UINT32_C(0x83F25BBF), UINT32_C(0x5D430BC7) },
          { UINT32_C(0x5CDE0ABB), UINT32_C(0x69FD84A8), UINT32_C(0x9816B688),
            UINT32_C(0x69DA263E), UINT32_C(0x0E53CBB8), UINT32_C(0xE52D93DF),
            UINT32_C(0xADD2D5A7), UINT32_C(0x42CF6F25), UINT32_C(0xC87CA88F),
            UINT32_C(0x227BA59D), UINT32_C(0xDA738554), UINT32_C(0x7A1CA876) } },
        { { UINT32_C(0x1CAC82C4), UINT32_C(0x3FA5C105), UINT32_C(0x8A78C9BE),
            UINT32_C(0x23C76087), UINT32_C(0x1C5CFA42), UINT32_C(0xE98CDAD6),
            UINT32_C(0x0A6C0421), UINT32_C(0x09C30252), UINT32_C(0x42FC61B9),
            UINT32_C(0x149BAC7C), UINT32_C(0x3004A3E2), UINT32_C(0x3A1C22AC) },
          { UINT32_C(0x202C7FED), UINT32_C(0xDE6B0D6E), UINT32_C(0xE7E63052),
            UINT32_C(0xB2457377), UINT32_C(0x3706B3EF), UINT32_C(0x31725FD4),
            UINT32_C(0x2B1AFDBF), UINT32_C(0xE16A347D), UINT32_C(0x8C29CF66),
            UINT32_C(0xBE4850C4), UINT32_C(0x2939F23C), UINT32_C(0x8F51CC4D) } },
        { { UINT32_C(0x219AE6C1), UINT32_C(0x169E025B), UINT32_C(0x116E1CA1),
            UINT32_C(0x55FF526F), UINT32_C(0xB191F55D), UINT32_C(0x01B810A3),
            UINT32_C(0x29588A69), UINT32_C(0x2D981272), UINT32_C(0x48B92199),
            UINT32_C(0x53C93770), UINT32_C(0x8A85236F), UINT32_C(0x8C7DD84E) },
          { UINT32_C(0xCAACF958), UINT32_C(0x293D48B6), UINT32_C(0x43572B30),
            UINT32_C(0x1F084ACB), UINT32_C(0xFAD91F28), UINT32_C(0x628BFA2D),
            UINT32_C(0x829386AF), UINT32_C(0x8D627B11), UINT32_C(0xD44A77BE),
            UINT32_C(0x3EC1DD00), UINT32_C(0x649AC7F0), UINT32_C(0x8D3B0D08) } },
        { { UINT32_C(0x177513BF), UINT32_C(0x00A93DAA), UINT32_C(0x42AD79E1),
            UINT32_C(0x2EF0B96F), UINT32_C(0xA07129D9), UINT32_C(0x81F5AAF1),
            UINT32_C(0x923F2449), UINT32_C(0xFC04B7EF), UINT32_C(0x60CDB1B7),
            UINT32_C(0x855DA795), UINT32_C(0xAD5D61D4), UINT32_C(0xB1EB5DAB) },
          { UINT32_C(0x353FD028), UINT32_C(0xD2CEF1AE), UINT32_C(0x9EE94847),
            UINT32_C(0xC21D5439), UINT32_C(0x0380C1A8), UINT32_C(0x9ED552BB),
            UINT32_C(0x2BAC328F), UINT32_C(0xB156FE7A), UINT32_C(0x7213C6A4),
            UINT32_C(0xBB7E0196), UINT32_C(0x1701ED5B), UINT32_C(0x36002A33) } },
        { { UINT32_C(0xDDC9EF4D), UINT32_C(0x20B1632A), UINT32_C(0x272D082B),
            UINT32_C(0x2A35FF4C), UINT32_C(0xF6CC9BD3), UINT32_C(0x30D39923),
            UINT32_C(0xE65C9D08), UINT32_C(0x6D879BC2), UINT32_C(0x6FA9983C),
            UINT32_C(0xCE8274E1), UINT32_C(0x0EB7424F), UINT32_C(0x652371E8) },
          { UINT32_C(0xC5C35282), UINT32_C(0x32B77503), UINT32_C(0xC885A931),
            UINT32_C(0xD7306333), UINT32_C(0x72955AA8), UINT32_C(0x8A16D719),
            UINT32_C(0x7D51F882), UINT32_C(0x5548F163), UINT32_C(0xBABA59EF),
            UINT32_C(0xB311DC66), UINT32_C(0x0DB8F627), UINT32_C(0x773D5448) } },
        { { UINT32_C(0x7A62EB3B), UINT32_C(0x59B1B134), UINT32_C(0xCCEEFB34),
            UINT32_C(0x0F8CE157), UINT32_C(0xA798CB2B), UINT32_C(0x3FE842A8),
            UINT32_C(0x0BF4161D), UINT32_C(0xD01BC626), UINT32_C(0x4D016FDB),
            UINT32_C(0x55EF6E55), UINT32_C(0xB242B201), UINT32_C(0xCB561503) },
          { UINT32_C(0xAF4199C1), UINT32_C(0x076EBC73), UINT32_C(0x697244F7),
            UINT32_C(0x39DEDCBB), UINT32_C(0x040162BC), UINT32_C(0x9D184733),
            UINT32_C(0x7F6B5FA6), UINT32_C(0x902992C1), UINT32_C(0xBB4952B5),
            UINT32_C(0xAD1DE754), UINT32_C(0xA121F6C8), UINT32_C(0x7ACF1B93) } },
        { { UINT32_C(0x325C9B9A), UINT32_C(0x7A56867C), UINT32_C(0xF3DC3D6A),
            UINT32_C(0x1A143999), UINT32_C(0x03F5BCB8), UINT32_C(0xCE109590),
            UINT32_C(0xD6EEE5B7), UINT32_C(0x034E9035), UINT32_C(0x495DF1BC),
            UINT32_C(0x2AFA81C8), UINT32_C(0x08924D02), UINT32_C(0x5EAB52DC) },
          { UINT32_C(0xAA181904), UINT32_C(0xEE6AA014), UINT32_C(0x310AD621),
            UINT32_C(0xE62DEF09), UINT32_C(0xC7538A03), UINT32_C(0x6C9792FC),
            UINT32_C(0x3E41D789), UINT32_C(0xA89D3E88), UINT32_C(0x9F94AE83),
            UINT32_C(0xD60FA11C), UINT32_C(0xE0D6234A), UINT32_C(0x5E16A8C2) } },
        { { UINT32_C(0xA9242F3B), UINT32_C(0x87EC053D), UINT32_C(0xF0E03545),
            UINT32_C(0x99544637), UINT32_C(0x6B7019E9), UINT32_C(0xEA0633FF),
            UINT32_C(0x68DDDB5B), UINT32_C(0x8CB8AE07), UINT32_C(0x1A811AC7),
            UINT32_C(0x892E7C84), UINT32_C(0x73664249), UINT32_C(0xC7EF19EB) },
          { UINT32_C(0xCD1489E3), UINT32_C(0xD1B5819A), UINT32_C(0xDE45D24A),
            UINT32_C(0xF9C80FB0), UINT32_C(0x83BB7491), UINT32_C(0x045C21A6),
            UINT32_C(0x73F7A47D), UINT32_C(0xA65325BE), UINT32_C(0x9C394F0C),
            UINT32_C(0x08D09F0E), UINT32_C(0x268D4F08), UINT32_C(0xE7FB21C6) } },
        { { UINT32_C(0x6CA95C18), UINT32_C(0xC4CCAB95), UINT32_C(0xBC42E040),
            UINT32_C(0x563FFD56), UINT32_C(0xE701C604), UINT32_C(0xFA3C64D8),
            UINT32_C(0xB0ABAFEE), UINT32_C(0xC88D4426), UINT32_C(0x8542E4C3),
            UINT32_C(0x1A353E5E), UINT32_C(0xED726186), UINT32_C(0x9A2D8B7C) },
          { UINT32_C(0x42D097FA), UINT32_C(0xD61CE190), UINT32_C(0x799A748B),
            UINT32_C(0x6A63E280), UINT32_C(0x3225486B), UINT32_C(0x0F48D063),
            UINT32_C(0x42A3C443), UINT32_C(0x848F8FE1), UINT32_C(0x8493CEF4),
            UINT32_C(0x2CCDE250), UINT32_C(0x45E77E7C), UINT32_C(0x5450A508) } },
        { { UINT32_C(0x03112816), UINT32_C(0xD0F4E248), UINT32_C(0xCCBE9E16),
            UINT32_C(0xFCAD9DDB), UINT32_C(0x5AE01EA0), UINT32_C(0x177999BF),
            UINT32_C(0xCE832DCE), UINT32_C(0xD20C78B9), UINT32_C(0x50C8C646),
            UINT32_C(0x3CC694FB), UINT32_C(0xC93D4887), UINT32_C(0x24D75968) },
          { UINT32_C(0x87BC08AF), UINT32_C(0x9F06366A), UINT32_C(0x7FD0DF2A),
            UINT32_C(0x59FAB50E), UINT32_C(0x6C4CC234), UINT32_C(0x5FFCC7F7),
            UINT32_C(0x65F52D86), UINT32_C(0x87198DD7), UINT32_C(0xA855DF04),
            UINT32_C(0x5B9C94B0), UINT32_C(0x8A067AD7), UINT32_C(0xD8BA6C73) } },
    },
    {
        { { UINT32_C(0x1C4C9D90), UINT32_C(0x9E9AF315), UINT32_C(0xD12E0A89),
            UINT32_C(0x8665C5A9), UINT32_C(0x58286493), UINT32_C(0x204ABD92),
            UINT32_C(0xB2E09205), UINT32_C(0x79959889), UINT32_C(0xFE56B101),
            UINT32_C(0x0C727A3D), UINT32_C(0x8B657F26), UINT32_C(0xF366244C) },
          { UINT32_C(0xCCA65BE2), UINT32_C(0xDE35D954), UINT32_C(0xB0FD41CE),
            UINT32_C(0x52EE1230), UINT32_C(0x36019FEE), UINT32_C(0xFA03261F),
            UINT32_C(0x66511D8F), UINT32_C(0xAFDA42D9), UINT32_C(0x821148B9),
            UINT32_C(0xF63211DD), UINT32_C(0x6F13A3E1), UINT32_C(0x7B56AF7E) } },
        { { UINT32_C(0x5913E184), UINT32_C(0x47FE4799), UINT32_C(0x82145900),
            UINT32_C(0x5BBE584C), UINT32_C(0x9A867173), UINT32_C(0xB76CFA8B),
            UINT32_C(0x514BF471), UINT32_C(0x9BC87BF0), UINT32_C(0x71DCF1FC),
            UINT32_C(0x37392DCE), UINT32_C(0x3AD1EFA8), UINT32_C(0xEC3EFAE0) },
          { UINT32_C(0x14876451), UINT32_C(0xBBEA5A34), UINT32_C(0x6217090F),
            UINT32_C(0x96E5F543), UINT32_C(0x9B1665A9), UINT32_C(0x5B3D4ECD),
            UINT32_C(0xE329DF22), UINT32_C(0xE7B0DF26), UINT32_C(0x0BAA808D),
            UINT32_C(0x18FB438E), UINT32_C(0xDD516FAF), UINT32_C(0x90757EBF) } },
        { { UINT32_C(0xD5A98D68), UINT32_C(0x1E6F9A95), UINT32_C(0x849DA828),
            UINT32_C(0x759EA7DF), UINT32_C(0x6E8B4198), UINT32_C(0x365D5625),
            UINT32_C(0x7A4A53F9), UINT32_C(0xE1B9C53B), UINT32_C(0xE32B9B16),
            UINT32_C(0x55DC1D50), UINT32_C(0xBB6D5701), UINT32_C(0xA4657EBB) },
          { UINT32_C(0xEACC76E2), UINT32_C(0x4C270249), UINT32_C(0x162B1CC7),
            UINT32_C(0xBE49EC75), UINT32_C(0x0689902B), UINT32_C(0x19A95B61),
            UINT32_C(0xA4CFC5A8), UINT32_C(0xDD5706BF), UINT32_C(0x14E5B424),
            UINT32_C(0xD33BDB73), UINT32_C(0xE69EBA87), UINT32_C(0x21311BD1) } },
        { { UINT32_C(0x72A21ACC), UINT32_C(0x75BA2F9B), UINT32_C(0xA28EDB4C),
            UINT32_C(0x356688D4), UINT32_C(0x610D080F), UINT32_C(0x3C339E0B),
            UINT32_C(0x33A99C2F), UINT32_C(0x614AC293), UINT32_C(0xAA580AFF),
            UINT32_C(0xA5E23AF2), UINT32_C(0xE1FDBA3A), UINT32_C(0xA6BCB860) },
          { UINT32_C(0xB43F9425), UINT32_C(0xAA603365), UINT32_C(0xF7EE4635),
            UINT32_C(0xAE8D7126), UINT32_C(0x56330A32), UINT32_C(0xA2B25244),
            UINT32_C(0x9E025AA3), UINT32_C(0xC396B5BB), UINT32_C(0xF8A0D5CF),
            UINT32_C(0xABBF77FA), UINT32_C(0xEA31C83B), UINT32_C(0xB322EE30) } },
        { { UINT32_C(0x7890E234), UINT32_C(0x04881384), UINT32_C(0x672E70C6),
            UINT32_C(0x387F1159), UINT32_C(0x7B307F75), UINT32_C(0x1468A614),
            UINT32_C(0xED85EC96), UINT32_C(0x56335B52), UINT32_C(0xD45BCAE9),
            UINT32_C(0xDA1BB60F), UINT32_C(0xF9FAEADD), UINT32_C(0x4D94F3F0) },
          { UINT32_C(0xFC78D86B), UINT32_C(0x6C6A7183), UINT32_C(0x3018DEC6),
            UINT32_C(0xA425B5C7), UINT32_C(0x2D877399), UINT32_C(0xB1549C33),
            UINT32_C(0x92B2BC37), UINT32_C(0x6C41C50C), UINT32_C(0x83EE0DDB),
            UINT32_C(0x3A9F380C), UINT32_C(0xC4599E73), UINT32_C(0xDED5FEB6) } },
        { { UINT32_C(0x0B7F8354), UINT32_C(0x14D34C21), UINT32_C(0x9177CE45),
            UINT32_C(0x1475A1CD), UINT32_C(0x9B926E4B), UINT32_C(0x9F5F764A),
            UINT32_C(0x05DD21FE), UINT32_C(0x77260D1E), UINT32_C(0xC4B937F7),
            UINT32_C(0x3C882480), UINT32_C(0x722372F2), UINT32_C(0xC92DCD39) },
          { UINT32_C(0xEC6F657E), UINT32_C(0xF636A1BE), UINT32_C(0x1D30DD35),
            UINT32_C(0xB0E6C312), UINT32_C(0xE4654EFE), UINT32_C(0xFE4B0528),
            UINT32_C(0x21D230D2), UINT32_C(0x1C4A6820), UINT32_C(0x98FA45AB),
            UINT32_C(0x615D2E48), UINT32_C(0x01FDBABF), UINT32_C(0x1F35D6D8) } },
        { { UINT32_C(0x3A7B10D1), UINT32_C(0xA636EEB8), UINT32_C(0xF4A29E73),
            UINT32_C(0x4E1AE352), UINT32_C(0xE6BB1EC7), UINT32_C(0x01704F5F),
            UINT32_C(0x0EF020AE), UINT32_C(0x75C04F72), UINT32_C(0x5A31E6A6),
            UINT32_C(0x448D8CEE), UINT32_C(0x208F994B), UINT32_C(0xE40A9C29) },
          { UINT32_C(0xFD8F9D5D), UINT32_C(0x69E09A30), UINT32_C(0x449BAB7E),
            UINT32_C(0xE6A5F7EB), UINT32_C(0x2AA1768B), UINT32_C(0xF25BC18A),
            UINT32_C(0x3C841234), UINT32_C(0x9449E404), UINT32_C(0x016A7BEF),
            UINT32_C(0x7A3BF43E), UINT32_C(0x2A150B60), UINT32_C(0xF25803E8) } },
        { { UINT32_C(0xB215F9E0), UINT32_C(0xE44A2A57), UINT32_C(0x19066F0A),
            UINT32_C(0x38B34DCE), UINT32_C(0x40BB1BFB), UINT32_C(0x8BB91DAD),
            UINT32_C(0xE67735FC), UINT32_C(0x64C9F775), UINT32_C(0x88D613CD),
            UINT32_C(0xDE142417), UINT32_C(0x1901D88D), UINT32_C(0xC5014FF5) },
          { UINT32_C(0xF38116B0), UINT32_C(0xA250341D), UINT32_C(0x9D6CBCB2),
            UINT32_C(0xF96B9DD4), UINT32_C(0x76B3FAC2), UINT32_C(0x15EC6C72),
            UINT32_C(0x8124C1E9), UINT32_C(0x88F1952F), UINT32_C(0x975BE4F5),
            UINT32_C(0x6B72F8EA), UINT32_C(0x061F7530), UINT32_C(0x23D288FF) } },
        { { UINT32_C(0xAFB96CE3), UINT32_C(0xEBFE3E5F), UINT32_C(0xB1979537),
            UINT32_C(0x2275EDFB), UINT32_C(0xC97BA741), UINT32_C(0xC37AB9E8),
            UINT32_C(0x63D7C626), UINT32_C(0x446E4B10), UINT32_C(0xD025EB02),
            UINT32_C(0xB73E2DCE), UINT32_C(0x7669EEA7), UINT32_C(0x1F952B51) },
          { UINT32_C(0x6069A424), UINT32_C(0xABDD00F6), UINT32_C(0xDC298BFB),
            UINT32_C(0x1C0F9D9B), UINT32_C(0xEB757B33), UINT32_C(0x831B1FD3),
            UINT32_C(0x59D60B32), UINT32_C(0xD7DBE183), UINT32_C(0x9EF094B3),
            UINT32_C(0x663D1F36), UINT32_C(0x67F7F11A), UINT32_C(0x1BD5732E) } },
        { { UINT32_C(0xC75D8892), UINT32_C(0x3C7FB3F5), UINT32_C(0xBA68DA69),
            UINT32_C(0x2CFF9A0C), UINT32_C(0x60EC740B), UINT32_C(0x76455E8B),
            UINT32_C(0x167B88F0), UINT32_C(0x4B8D67FF), UINT32_C(0x5A4186B1),
            UINT32_C(0xEDEC0C02), UINT32_C(0xBEBF35AB), UINT32_C(0x127C462D) },
          { UINT32_C(0x049430FC), UINT32_C(0x9159C67E), UINT32_C(0xE7747320),
            UINT32_C(0x86B21DD2), UINT32_C(0x0CF27B89), UINT32_C(0x0E0E0152),
            UINT32_C(0xCD1316B6), UINT32_C(0x705F28F5), UINT32_C(0xBEAEA8A8),
            UINT32_C(0x76751691), UINT32_C(0x360C5B69), UINT32_C(0x4C73E282) } },
        { { UINT32_C(0xFD7B3D74), UINT32_C(0x46BCC0D5), UINT32_C(0x0DC4F410),
            UINT32_C(0x6F13C20E), UINT32_C(0x72F11CDF), UINT32_C(0x98A1AF7D),
            UINT32_C(0x7928881C), UINT32_C(0x6099FD83), UINT32_C(0x371BB94B),
            UINT32_C(0x66976356), UINT32_C(0x19B945AB), UINT32_C(0x673FBA72) },
          { UINT32_C(0xAED00700), UINT32_C(0xE4D8FA6E), UINT32_C(0x5C71A9F7),
            UINT32_C(0xEA2313EC), UINT32_C(0xF99D4AEA), UINT32_C(0xF9ED8268),
            UINT32_C(0x42AB59C7), UINT32_C(0xADD89164), UINT32_C(0x3F3A2D45),
            UINT32_C(0xB37EB26F), UINT32_C(0xA924841E), UINT32_C(0x0B39BD7A) } },
        { { UINT32_C(0xE03CDBBB), UINT32_C(0xD811EB32), UINT32_C(0x7CC3610E),
            UINT32_C(0x12055F1D), UINT32_C(0xA9046E3F), UINT32_C(0x6B23A1A0),
            UINT32_C(0x9DD4A749), UINT32_C(0x4D712122), UINT32_C(0xB1BF0AC3),
            UINT32_C(0xB0C2ACA1), UINT32_C(0xC1B0432F), UINT32_C(0x71EFF575) },
          { UINT32_C(0x2B44E285), UINT32_C(0x6CD81492), UINT32_C(0xD87E8D20),
            UINT32_C(0x3088BD9C), UINT32_C(0xF567E8FA), UINT32_C(0xACE218E5),
            UINT32_C(0xCF90CBBB), UINT32_C(0xB3FA0424), UINT32_C(0x770734D3),
            UINT32_C(0xADBDA751), UINT32_C(0x5AD6569A), UINT32_C(0xBCD78BAD) } },
        { { UINT32_C(0x7F39641F), UINT32_C(0xCADB31FA), UINT32_C(0x825E5562),
            UINT32_C(0x3EF3E295), UINT32_C(0xF4094C64), UINT32_C(0x4893C633),
            UINT32_C(0x8ADDF432), UINT32_C(0x52F685F1), UINT32_C(0x7FDC9373),
            UINT32_C(0x9FD887AB), UINT32_C(0xE8680E8B), UINT32_C(0x47A9ADA0) },
          { UINT32_C(0xF0CD44F6), UINT32_C(0x579313B7), UINT32_C(0xE188AE2E),
            UINT32_C(0xAC4B8668), UINT32_C(0x8FB145BD), UINT32_C(0x648F4369),
            UINT32_C(0x74629E31), UINT32_C(0xE0460AB3), UINT32_C(0x8FF2B05F),
            UINT32_C(0xC25F2875), UINT32_C(0x2D31EAEA), UINT32_C(0x4720C2B6) } },
        { { UINT32_C(0x13D48F80), UINT32_C(0x4603CDF4), UINT32_C(0xA49725DA),
            UINT32_C(0x9ADB50E2), UINT32_C(0x65DF63F0), UINT32_C(0x8CD33050),
            UINT32_C(0xCD643003), UINT32_C(0x58D8B3BB), UINT32_C(0xB739826B),
            UINT32_C(0x170A4F4A), UINT32_C(0x1EAD0E17), UINT32_C(0x857772B5) },
          { UINT32_C(0xE65320F1), UINT32_C(0x01B78152), UINT32_C(0xB7503FC0),
            UINT32_C(0xA6B4D845), UINT32_C(0x3DD50798), UINT32_C(0x0F5089B9),
            UINT32_C(0x5690B6BE), UINT32_C(0x488F200F), UINT32_C(0x9E096F36),
            UINT32_C(0x220B4ADF), UINT32_C(0x8CE5BC7C), UINT32_C(0x474D7C9F) } },
        { { UINT32_C(0xC745F8C9), UINT32_C(0xFED8C058), UINT32_C(0x291262D1),
            UINT32_C(0xB683179E), UINT32_C(0xD15EE88C), UINT32_C(0x26ABD367),
            UINT32_C(0xF60A6249), UINT32_C(0x29E8EED3), UINT32_C(0x1E02D6E1),
            UINT32_C(0xED6008BB), UINT32_C(0xA6B12B8D), UINT32_C(0xD82ECF4C) },
          { UINT32_C(0xAAE4FA22), UINT32_C(0x9929D021), UINT32_C(0x336A1AB3),
            UINT32_C(0xBE4DEF14), UINT32_C(0x8C80A312), UINT32_C(0x529B7E09),
            UINT32_C(0xEE0EB0CE), UINT32_C(0xB059188D), UINT32_C(0x16DEAB7F),
            UINT32_C(0x1E42979A), UINT32_C(0x84EE9477), UINT32_C(0x24110349) } },
        { { UINT32_C(0x2BE579CC), UINT32_C(0xD6524685), UINT32_C(0xC456FDED),
            UINT32_C(0x849316F1), UINT32_C(0x2D1B67DA), UINT32_C(0xC51B7DA4),
            UINT32_C(0x41BC6D6A), UINT32_C(0xC25B539E), UINT32_C(0xA9BF8BED),
            UINT32_C(0xE3B7CCA3), UINT32_C(0x045C15E4), UINT32_C(0x813EF18C) },
          { UINT32_C(0x697982C4), UINT32_C(0x5F3789A1), UINT32_C(0x8C435566),
            UINT32_C(0x4C125369), UINT32_C(0xDC0A92C6), UINT32_C(0x00A7AE6E),
            UINT32_C(0x2F64A053), UINT32_C(0x1ABC929B), UINT32_C(0x38666B44),
            UINT32_C(0xF4925C4C), UINT32_C(0x0F3DE7F6), UINT32_C(0xA81044B0) } },
    },
    {
        { { UINT32_C(0xC2EC3731), UINT32_C(0xBCC88422), UINT32_C(0x10DC4EC2),
            UINT32_C(0x78A3E4D4), UINT32_C(0x2571D6B1), UINT32_C(0x745DA1EF),
            UINT32_C(0x739A956E), UINT32_C(0xF01C2921), UINT32_C(0xE4BFFC16),
            UINT32_C(0xEFFD8065), UINT32_C(0xF36FE72C), UINT32_C(0x6EFE62A1) },
          { UINT32_C(0x0F4629A4), UINT32_C(0xF49E90D2), UINT32_C(0x8CE646F4),
            UINT32_C(0xADD1DCC7), UINT32_C(0xB7240D91), UINT32_C(0xCB78B583),
            UINT32_C(0x03F8387F), UINT32_C(0x2E1A7C3C), UINT32_C(0x3200F2D9),
            UINT32_C(0x16566C22), UINT32_C(0xAAF80A84), UINT32_C(0x2361B14B) } },
        { { UINT32_C(0xB5733309), UINT32_C(0xDB1CFFD2), UINT32_C(0x0F9DD939),
            UINT32_C(0x24BC250B), UINT32_C(0xA3C1DB85), UINT32_C(0xA4181E5A),
            UINT32_C(0xAC55D391), UINT32_C(0xE5183E51), UINT32_C(0xEFD270D0),
            UINT32_C(0x2793D5EF), UINT32_C(0xC0631546), UINT32_C(0x7D56F63D) },
          { UINT32_C(0x0C1EE59D), UINT32_C(0xECB40A59), UINT32_C(0xBB5BFA2C),
            UINT32_C(0xE613A9E4), UINT32_C(0x6C5830F9), UINT32_C(0xA89B14AB),
            UINT32_C(0xA03F201E), UINT32_C(0x4DC477DC), UINT32_C(0xC88C54F6),
            UINT32_C(0x5604F5DA), UINT32_C(0x2ACFC66E), UINT32_C(0xD49264DC) } },
        { { UINT32_C(0x1C4DFA95), UINT32_C(0x283DD7F0), UINT32_C(0x62C0B160),
            UINT32_C(0xB898CC2C), UINT32_C(0x870282AA), UINT32_C(0xBA08C095),
            UINT32_C(0xF4E36324), UINT32_C(0xB02B00D8), UINT32_C(0x604CECF2),
            UINT32_C(0x53AADDC0), UINT32_C(0x84DDD24E), UINT32_C(0xF1F927D3) },
          { UINT32_C(0xE2ABC9E1), UINT32_C(0x34BC00A0), UINT32_C(0x60289F88),
            UINT32_C(0x2DA1227D), UINT32_C(0xCEF68F74), UINT32_C(0x5228EAAA),
            UINT32_C(0x3C029351), UINT32_C(0x40A790D2), UINT32_C(0x8442E3B7),
            UINT32_C(0xE0E9AF5C), UINT32_C(0xA9F141E0), UINT32_C(0xA3214142) } },
        { { UINT32_C(0xF9A58E3D), UINT32_C(0x72F4949E), UINT32_C(0xA48660A6),
            UINT32_C(0x738C700B), UINT32_C(0x092A5805), UINT32_C(0x71B04726),
            UINT32_C(0x0F5CDB72), UINT32_C(0xAD5C3C11), UINT32_C(0x554BFC49),
            UINT32_C(0xD4951F9E), UINT32_C(0x6131EBE7), UINT32_C(0xEE594EE5) },
          { UINT32_C(0x3C1AF0A9), UINT32_C(0x37DA59F3), UINT32_C(0xCB040A63),
            UINT32_C(0xD7AFC73B), UINT32_C(0x4D89FA65), UINT32_C(0xD020962A),
            UINT32_C(0x71D824F5), UINT32_C(0x2610C61E), UINT32_C(0x3C050E31),
            UINT32_C(0x9C917DA7), UINT32_C(0xE6E7EBFB), UINT32_C(0x3840F92F) } },
        { { UINT32_C(0x8D8B8CED), UINT32_C(0x50FBD7FE), UINT32_C(0x47D240AE),
            UINT32_C(0xC7282F75), UINT32_C(0x1930FF73), UINT32_C(0x79646A47),
            UINT32_C(0x2F7F5A77), UINT32_C(0x2E0BAC4E), UINT32_C(0x26127E0B),
            UINT32_C(0x0EE44FA5), UINT32_C(0x82BC2AA7), UINT32_C(0x678881B7) },
          { UINT32_C(0x67F5F497), UINT32_C(0xB9E5D384), UINT32_C(0xA9B7106B),
            UINT32_C(0x8F94A7D4), UINT32_C(0x9D329F68), UINT32_C(0xBF7E0B07),
            UINT32_C(0x45D192FB), UINT32_C(0x169B93EA), UINT32_C(0x20DBE8C0),
            UINT32_C(0xCCAA9467), UINT32_C(0x938F9574), UINT32_C(0xD4513A50) } },
        { { UINT32_C(0x054CB874), UINT32_C(0x841C96B4), UINT32_C(0xA3C26834),
            UINT32_C(0xD75B1AF1), UINT32_C(0xEE6575F0), UINT32_C(0x7237169D),
            UINT32_C(0x0322AADC), UINT32_C(0xD71FC7E5), UINT32_C(0x949E3A8E),
            UINT32_C(0xD7A23F1E), UINT32_C(0xDD31D8C7), UINT32_C(0x77E2D102) },
          { UINT32_C(0xD10F5A1F), UINT32_C(0x5AD69D09), UINT32_C(0xB99D9A0B),
            UINT32_C(0x526C9CB4), UINT32_C(0x972B237D), UINT32_C(0x521BB10B),
            UINT32_C(0xA326F342), UINT32_C(0x1E4CD42F), UINT32_C(0xF0F126CA),
            UINT32_C(0x5BB6DB27), UINT32_C(0xA4A515AD), UINT32_C(0x587AF22C) } },
        { { UINT32_C(0xB12E542F), UINT32_C(0x1123A531), UINT32_C(0xB9EB2811),
            UINT32_C(0x1D01A64D), UINT32_C(0xF2D70F87), UINT32_C(0xA4A3515B),
            UINT32_C(0xB4BD0270), UINT32_C(0xFA205234), UINT32_C(0x5EDA26B9),
            UINT32_C(0x74B81830), UINT32_C(0x56578E75), UINT32_C(0x9305D6E6) },
          { UINT32_C(0x9F11BE19), UINT32_C(0xF38E69DE), UINT32_C(0x44DBE89F),
            UINT32_C(0x1E2A5C23), UINT32_C(0xFD286654), UINT32_C(0x1077E7BC),
            UINT32_C(0x0FCA4741), UINT32_C(0xD3669894), UINT32_C(0x278F8497),
            UINT32_C(0x893BF904), UINT32_C(0xEB3E14F4), UINT32_C(0xD6AC5F83) } },
        { { UINT32_C(0x488F5F74), UINT32_C(0x327B9DAB), UINT32_C(0xCAB7364F),
            UINT32_C(0x2B44F4B8), UINT32_C(0x19B6C6BD), UINT32_C(0xB4A6D22D),
            UINT32_C(0xFC77CD3E), UINT32_C(0xA087E613), UINT32_C(0xB0B49BC7),
            UINT32_C(0x4558E327), UINT32_C(0xCD835D35), UINT32_C(0x188805BE) },
          { UINT32_C(0xC1DC1007), UINT32_C(0x592F293C), UINT32_C(0x6AF02B44),
            UINT32_C(0xFAEE660F), UINT32_C(0x904035F2), UINT32_C(0x5BFBB3BF),
            UINT32_C(0x79C07E70), UINT32_C(0xD7C9AE60), UINT32_C(0x234896C2),
            UINT32_C(0xC5287DD4), UINT32_C(0xCB0E4121), UINT32_C(0xC4CE4523) } },
        { { UINT32_C(0x58344831), UINT32_C(0x3626B406), UINT32_C(0x8E55C984),
            UINT32_C(0xABCCE356), UINT32_C(0x77241602), UINT32_C(0x495CC81C),
            UINT32_C(0x6D70DF8F), UINT32_C(0x4FB79676), UINT32_C(0x5B071DCA),
            UINT32_C(0x6354B37C), UINT32_C(0x8C0FC0AD), UINT32_C(0x2CAD80A4) },
          { UINT32_C(0xF68739B4), UINT32_C(0x18AADD51), UINT32_C(0x47F09C6C),
            UINT32_C(0x1BFBB177), UINT32_C(0xA8FD51C4), UINT32_C(0x9355EA19),
            UINT32_C(0xEE58DB7B), UINT32_C(0x3D512A84), UINT32_C(0xE9237640),
            UINT32_C(0x70842AFD), UINT32_C(0xACAF858D), UINT32_C(0x36F515CA) } },
        { { UINT32_C(0x7E768B23), UINT32_C(0x3DDEC7C4), UINT32_C(0x036D43ED),
            UINT32_C(0x97E13C53), UINT32_C(0x3A39AB5F), UINT32_C(0x871E5925),
            UINT32_C(0x07E68E2B), UINT32_C(0x9AF292DE), UINT32_C(0x4A40112E),
            UINT32_C(0x41158349), UINT32_C(0x3D4D97E6), UINT32_C(0xCDBB46AF) },
          { UINT32_C(0x3C0EBE40), UINT32_C(0x2F891293), UINT32_C(0x3EBAD1E5),
            UINT32_C(0x696C7EEE), UINT32_C(0x33B50D99), UINT32_C(0x8A5F3B69),
            UINT32_C(0x7ED47DDE), UINT32_C(0xB7BC4840), UINT32_C(0x1E6706D8),
            UINT32_C(0x3A6F8E6C), UINT32_C(0x3D84BB8F), UINT32_C(0x6A147943) } },
        { { UINT32_C(0x603AE8D1), UINT32_C(0xEC3A9C78), UINT32_C(0x228C29E5),
            UINT32_C(0xBFE07E37), UINT32_C(0x396DBC2B), UINT32_C(0xB0385C5B),
            UINT32_C(0xDF85F41F), UINT32_C(0x7C14FE83), UINT32_C(0xADFD463E),
            UINT32_C(0xE2E64676), UINT32_C(0x8BF9F23D), UINT32_C(0x5BEF10AA) },
          { UINT32_C(0xF6BAB6DA), UINT32_C(0xFA83EA0D), UINT32_C(0x966BF7E3),
            UINT32_C(0xCD0C8BA5), UINT32_C(0x98501C2E), UINT32_C(0xD62216B4),
            UINT32_C(0xC3E69F2D), UINT32_C(0xB7F298A4), UINT32_C(0x9C8740F4),
            UINT32_C(0x42CEF13B), UINT32_C(0x0DD64307), UINT32_C(0xBB317E52) } },
        { { UINT32_C(0x3FFEE775), UINT32_C(0x22B6245C), UINT32_C(0xB37CE7AA),
            UINT32_C(0x5C3F60BE), UINT32_C(0xE1FEC0DF), UINT32_C(0xDE195D40),
            UINT32_C(0xA0A82074), UINT32_C(0x3BFAFBC5), UINT32_C(0xC72CA86A),
            UINT32_C(0xC36EC86A), UINT32_C(0x13FD43EA), UINT32_C(0x56062851) },
          { UINT32_C(0x8E0B03A4), UINT32_C(0x8686BE80), UINT32_C(0xD540D440),
            UINT32_C(0xC3BD1F93), UINT32_C(0xBF96CEC5), UINT32_C(0x13E4EBC0),
            UINT32_C(0x9190C844), UINT32_C(0xE8E23984), UINT32_C(0x00844802),
            UINT32_C(0x183593A6), UINT32_C(0x4D206878), UINT32_C(0x46716879) } },
        { { UINT32_C(0xB6F63D19), UINT32_C(0x358F394D), UINT32_C(0x6B052194),
            UINT32_C(0xA75D4849), UINT32_C(0x5C8D7975), UINT32_C(0x58403590),
            UINT32_C(0x6CBFBD77), UINT32_C(0x86DC9B6B), UINT32_C(0x647A51E5),
            UINT32_C(0x2DB04D77), UINT32_C(0xF8950D88), UINT32_C(0x5E9A5B02) },
          { UINT32_C(0x017168B0), UINT32_C(0xCE69A7E5), UINT32_C(0xC4843AD3),
            UINT32_C(0x94630FAC), UINT32_C(0x1EFC44FF), UINT32_C(0xB3B9D736),
            UINT32_C(0xB14D7F93), UINT32_C(0xE729E9B6), UINT32_C(0xE0ED0ABC),
            UINT32_C(0xA071FC60), UINT32_C(0x8C8D9B83), UINT32_C(0xFC1A9971) } },
        { { UINT32_C(0xD138E975), UINT32_C(0x49686031), UINT32_C(0x5A8EF0D1),
            UINT32_C(0x64864038), UINT32_C(0xE7F7DE49), UINT32_C(0x32679713),
            UINT32_C(0x29D1CD1D), UINT32_C(0x59132349), UINT32_C(0x20BE9ED2),
            UINT32_C(0x849AA23A), UINT32_C(0x284B3F33), UINT32_C(0x15D303E1) },
          { UINT32_C(0xB63F9FE9), UINT32_C(0x37309475), UINT32_C(0x45B7256A),
            UINT32_C(0x327BAC8B), UINT32_C(0xD17FC5D3), UINT32_C(0x291CD227),
            UINT32_C(0xA973EDF1), UINT32_C(0x8291D8CD), UINT32_C(0x437ABA09),
            UINT32_C(0xF3843562), UINT32_C(0x271D0785), UINT32_C(0x33FFB704) } },
        { { UINT32_C(0x47E11E5E), UINT32_C(0x5248D6E4), UINT32_C(0x269C7ED3),
            UINT32_C(0x0F66FC3C), UINT32_C(0x903E346E), UINT32_C(0x18C0D2B9),
            UINT32_C(0x4BEAE1B8), UINT32_C(0xD81D9D97), UINT32_C(0xFC30FDF3),
            UINT32_C(0x610326B0), UINT32_C(0x19A7DFCD), UINT32_C(0x2B136870) },
          { UINT32_C(0xB9527676), UINT32_C(0xEC75F70A), UINT32_C(0x29A3D897),
            UINT32_C(0x90829F51), UINT32_C(0x97980302), UINT32_C(0x92FE1809),
            UINT32_C(0x68474991), UINT32_C(0xA3F2498E), UINT32_C(0x0F22BBAD),
            UINT32_C(0x6A66307B), UINT32_C(0x20378557), UINT32_C(0x32014B91) } },
        { { UINT32_C(0x3CD98610), UINT32_C(0x72CD7D55), UINT32_C(0x74504ADF),
            UINT32_C(0xC3D560B0), UINT32_C(0xCEBB5D5D), UINT32_C(0x23F0A982),
            UINT32_C(0xB839DDB8), UINT32_C(0x1431C15B), UINT32_C(0xCEB72207),
            UINT32_C(0x7E207CD8), UINT32_C(0xE7EFB28D), UINT32_C(0x28E0A848) },
          { UINT32_C(0x1BD96F6E), UINT32_C(0xD22561FE), UINT32_C(0x62A8236B),
            UINT32_C(0x04812C18), UINT32_C(0x975491FA), UINT32_C(0xA0BF2334),
            UINT32_C(0x435DF87F), UINT32_C(0x294F42A6), UINT32_C(0xA5D6F4F6),
            UINT32_C(0x2772B783), UINT32_C(0x2724F853), UINT32_C(0x348F92ED) } },
    },
    {
        { { UINT32_C(0x1A42E5E7), UINT32_C(0xC20FB911), UINT32_C(0x81D12863),
            UINT32_C(0x075A678B), UINT32_C(0x5CC0AA89), UINT32_C(0x12BCBC6A),
            UINT32_C(0x4FB9F01E), UINT32_C(0x5279C6AB), UINT32_C(0x11AE1B89),
            UINT32_C(0xBC8E1789), UINT32_C(0xC290003C), UINT32_C(0xAE74A706) },
          { UINT32_C(0x79DF3F45), UINT32_C(0x9949D6EC), UINT32_C(0x96C8D37F),
            UINT32_C(0xBA18E262), UINT32_C(0xDD2275BF), UINT32_C(0x68DE6EE2),
            UINT32_C(0xC419F1D5), UINT32_C(0xA9E4FFF8), UINT32_C(0xA52B5A40),
            UINT32_C(0xBC759CA4), UINT32_C(0x63B0996D), UINT32_C(0xFF18CBD8) } },
        { { UINT32_C(0xD7DD47E5), UINT32_C(0x73C57FDE), UINT32_C(0xD49A7F5D),
            UINT32_C(0xB0FE5479), UINT32_C(0xCFB9821E), UINT32_C(0xD25C71F1),
            UINT32_C(0xCF6A1D68), UINT32_C(0x9427E209), UINT32_C(0xACD24E64),
            UINT32_C(0xBF3C3916), UINT32_C(0xBDA7B8B5), UINT32_C(0x7E9F5583) },
          { UINT32_C(0xCF971E11), UINT32_C(0xE7C5F7C8), UINT32_C(0x3C7F035E),
            UINT32_C(0xEC16D5D7), UINT32_C(0xE66B277C), UINT32_C(0x818DC472),
            UINT32_C(0xB2816F1E), UINT32_C(0x4413FD47), UINT32_C(0x48383C6D),
            UINT32_C(0x40F262AF), UINT32_C(0x4F190537), UINT32_C(0xFB057584) } },
        { { UINT32_C(0x08962F6B), UINT32_C(0x487EDC07), UINT32_C(0x190A7E55),
            UINT32_C(0x6002F1E7), UINT32_C(0x10FDBA0C), UINT32_C(0x7FC62BEA),
            UINT32_C(0x2C3DBF33), UINT32_C(0xC836BBC5), UINT32_C(0x4F7D2A46),
            UINT32_C(0x4FDFB5C3), UINT32_C(0xDCA0DF71), UINT32_C(0x824654DE) },
          { UINT32_C(0x0C23902B), UINT32_C(0x30A07676), UINT32_C(0x77FBBF37),
            UINT32_C(0x7F1EBB93), UINT32_C(0xFACC13DB), UINT32_C(0xD307D49D),
            UINT32_C(0xAE1A261A), UINT32_C(0x148D673A), UINT32_C(0x52D98650),
            UINT32_C(0xE008F95B), UINT32_C(0x9F558FDE), UINT32_C(0xC7614440) } },
        { { UINT32_C(0x9CB16650), UINT32_C(0x17CD6AF6), UINT32_C(0x69F4EEBE),
            UINT32_C(0x86CC27C1), UINT32_C(0x78822432), UINT32_C(0x7E495B1D),
            UINT32_C(0x1B974525), UINT32_C(0xFED338E3), UINT32_C(0x86F3CE21),
            UINT32_C(0x527743D3), UINT32_C(0xB515C896), UINT32_C(0x87948AD3) },
          { UINT32_C(0xB17F2FB8), UINT32_C(0x9FDE7039), UINT32_C(0xD9B89D96),
            UINT32_C(0xA2FA9A5F), UINT32_C(0x36FF74DC), UINT32_C(0x5D46600B),
            UINT32_C(0x8302C3C9), UINT32_C(0x8EA74B04), UINT32_C(0xF744B5EB),
            UINT32_C(0xD560F570), UINT32_C(0xFE762402), UINT32_C(0xC921023B) } },
        { { UINT32_C(0xFFF4C8ED), UINT32_C(0xA35AB657), UINT32_C(0x8A5FABD7),
            UINT32_C(0x017C6124), UINT32_C(0x09ACDA28), UINT32_C(0x56463025),
            UINT32_C(0x14CF238A), UINT32_C(0x6038D361), UINT32_C(0xAF1B9F07),
            UINT32_C(0x1428B1B6), UINT32_C(0x7482E95C), UINT32_C(0x5827FF44) },
          { UINT32_C(0x780FF362), UINT32_C(0xCB997E18), UINT32_C(0xE0BCAC1E),
            UINT32_C(0x2B89D702), UINT32_C(0xA837DDC8), UINT32_C(0xC632A0B5),
            UINT32_C(0x59762647), UINT32_C(0xF3EFCF1F), UINT32_C(0x38B0D60A),
            UINT32_C(0xE9BA309A), UINT32_C(0x20B5FB37), UINT32_C(0x05DEABDD) } },
        { { UINT32_C(0xCB8AF047), UINT32_C(0xD44E5DBA), UINT32_C(0x943CFE82),
            UINT32_C(0x15400CB4), UINT32_C(0x9DF88B67), UINT32_C(0xDBD69575),
            UINT32_C(0xB2405A7D), UINT32_C(0x8299DB2B), UINT32_C(0x0B1D80CD),
            UINT32_C(0x46E3BF77), UINT32_C(0xE82BA3D9), UINT32_C(0xC50CF66C) },
          { UINT32_C(0xF2F747A9), UINT32_C(0xB2910A07), UINT32_C(0x5ADC89C1),
            UINT32_C(0xF6B669DB), UINT32_C(0x9052B081), UINT32_C(0x3B5EF1A0),
            UINT32_C(0xB594ACE2), UINT32_C(0x0F5D5ED3), UINT32_C(0xD5F01320),
            UINT32_C(0xDA30B8D5), UINT32_C(0xAAFCD58F), UINT32_C(0x0D688C5E) } },
        { { UINT32_C(0x2A161074), UINT32_C(0x5EEE3A31), UINT32_C(0xEFE2BE37),
            UINT32_C(0x6BAAAE56), UINT32_C(0xE3D78698), UINT32_C(0xF9787F61),
            UINT32_C(0x50630A30), UINT32_C(0xC6836B26), UINT32_C(0x1445DEF1),
            UINT32_C(0x7445B85D), UINT32_C(0xD568A6A5), UINT32_C(0xD72016A2) },
          { UINT32_C(0xE355614F), UINT32_C(0x9DD6F533), UINT32_C(0x91E04588),
            UINT32_C(0x637E7E5F), UINT32_C(0xB9FB1391), UINT32_C(0x42E142F3),
            UINT32_C(0x41AFE5DA), UINT32_C(0x0D07C05C), UINT32_C(0x1394EDF1),
            UINT32_C(0xD7CD25C8), UINT32_C(0xB99288EE), UINT32_C(0xEBE6A0FC) } },
        { { UINT32_C(0xBABBAD86), UINT32_C(0xB8E63B7B), UINT32_C(0x90D66766),
            UINT32_C(0x63226A9F), UINT32_C(0x5CF26666), UINT32_C(0x26381836),
            UINT32_C(0x4CADD0BF), UINT32_C(0xCCBD142D), UINT32_C(0x9AC29470),
            UINT32_C(0xA070965E), UINT32_C(0x25FF23ED), UINT32_C(0x6BDCA260) },
          { UINT32_C(0x87DCA7B3), UINT32_C(0xD4E00FD4), UINT32_C(0x9E0E8734),
            UINT32_C(0xA5097833), UINT32_C(0x048173A4), UINT32_C(0xF73F162E),
            UINT32_C(0x9C3C2FA2), UINT32_C(0xD23F9196), UINT32_C(0xE4AC397A),
            UINT32_C(0x9AB98B45), UINT32_C(0x543F2D4B), UINT32_C(0x2BAA0300) } },
        { { UINT32_C(0xC658C445), UINT32_C(0xBBBE15E7), UINT32_C(0xC28941D1),
            UINT32_C(0xB8CBCB20), UINT32_C(0x027D6540), UINT32_C(0x65549BE2),
            UINT32_C(0x1E8EF4F4), UINT32_C(0xEBBCA802), UINT32_C(0xD2ACA397),
            UINT32_C(0x18214B4B), UINT32_C(0xE31784A3), UINT32_C(0xCBEC7DE2) },
          { UINT32_C(0x0116FDF3), UINT32_C(0x96F0533F), UINT32_C(0x5C8F5EE1),
            UINT32_C(0x68911C90), UINT32_C(0xD568603A), UINT32_C(0x7DE9A3AE),
            UINT32_C(0x6A3AD7B7), UINT32_C(0x3F56C52C), UINT32_C(0x670B4D0E),
            UINT32_C(0x5BE9AFCA), UINT32_C(0x375DFE2F), UINT32_C(0x628BFEEE) } },
        { { UINT32_C(0xDD4ADDB3), UINT32_C(0x97DAE81B), UINT32_C(0x8704761B),
            UINT32_C(0x12D2CF4E), UINT32_C(0x3247788D), UINT32_C(0x5E820B40),
            UINT32_C(0x0051CA80), UINT32_C(0x82234B62), UINT32_C(0x6CB5EA74),
            UINT32_C(0x0C62704D), UINT32_C(0x23941593), UINT32_C(0xDE560420) },
          { UINT32_C(0xF1B04145), UINT32_C(0xB3912A3C), UINT32_C(0xAF93688D),
            UINT32_C(0xE3967CD7), UINT32_C(0x58DABB4B), UINT32_C(0x2E2DCD2F),
            UINT32_C(0x0E303911), UINT32_C(0x6564836F), UINT32_C(0xECE07C5C),
            UINT32_C(0x1F10F19B), UINT32_C(0xD8919126), UINT32_C(0xB47F07EE) } },
        { { UINT32_C(0xE9A2EEC9), UINT32_C(0xE3545085), UINT32_C(0x2C8E51FE),
            UINT32_C(0x81866A97), UINT32_C(0x50027243), UINT32_C(0xD2BA7DB5),
            UINT32_C(0x4AE87DE4), UINT32_C(0x29DAEAB5), UINT32_C(0x684F9497),
            UINT32_C(0x5EF3D4B8), UINT32_C(0x9D5D6873), UINT32_C(0xE2DACE3B) },
          { UINT32_C(0xFFD29C9C), UINT32_C(0xF012C951), UINT32_C(0xADBADA14),
            UINT32_C(0x48289445), UINT32_C(0x89558C49), UINT32_C(0x8751F50D),
            UINT32_C(0x99E35BEE), UINT32_C(0x75511A4F), UINT32_C(0x7D59AA5F),
            UINT32_C(0xEF802D6E), UINT32_C(0xA2A795E2), UINT32_C(0x14FCAD65) } },
        { { UINT32_C(0x08CB8F2C), UINT32_C(0xC8EB00E8), UINT32_C(0x2B45BD86),
            UINT32_C(0x68607532), UINT32_C(0x59969713), UINT32_C(0x7A29B459),
            UINT32_C(0xD684201B), UINT32_C(0x5FA15B9B), UINT32_C(0xB9E538EE),
            UINT32_C(0x1A853190), UINT32_C(0xD573D043), UINT32_C(0x4150605C) },
          { UINT32_C(0xEB9FBB68), UINT32_C(0xEF011D3B), UINT32_C(0x66AE32B6),
            UINT32_C(0x67279982), UINT32_C(0x445DE5EC), UINT32_C(0x861B86EA),
            UINT32_C(0xA34A50E1), UINT32_C(0x62837D18), UINT32_C(0xBF5F0663),
            UINT32_C(0x228C006A), UINT32_C(0x396DB36A), UINT32_C(0xE007FDE7) } },
        { { UINT32_C(0x5A916A55), UINT32_C(0xDEE4F881), UINT32_C(0xF39C82CB),
            UINT32_C(0x20DC0370), UINT32_C(0x40F09821), UINT32_C(0xD9A71615),
            UINT32_C(0xF7273492), UINT32_C(0xD50AD8BF), UINT32_C(0x32E7C4BF),
            UINT32_C(0xA06F7D12), UINT32_C(0x4C5CEA36), UINT32_C(0xFA0F6154) },
          { UINT32_C(0x5FC49CFE), UINT32_C(0xF4FD9BED), UINT32_C(0xC9291678),
            UINT32_C(0xD8CB45D1), UINT32_C(0x7B92C9F2), UINT32_C(0x94DB86CC),
            UINT32_C(0x73C81169), UINT32_C(0x09CA5F38), UINT32_C(0xAEED06F0),
            UINT32_C(0x109F40B0), UINT32_C(0x14DCAA0A), UINT32_C(0x9F0360B2) } },
        { { UINT32_C(0xE12AD3E7), UINT32_C(0x4189B70D), UINT32_C(0x10B06607),
            UINT32_C(0x5208ADB2), UINT32_C(0xEE8497FA), UINT32_C(0xEBD8E2A2),
            UINT32_C(0xE04F2ECB), UINT32_C(0x61B1BD67), UINT32_C(0x4F3F5F99),
            UINT32_C(0x0E2DDA72), UINT32_C(0xF747B16D), UINT32_C(0xD5D96740) },
          { UINT32_C(0xA6BF397F), UINT32_C(0x308A48F6), UINT32_C(0x23A93595),
            UINT32_C(0x7021C3E5), UINT32_C(0x36470AA0), UINT32_C(0xF10B0229),
            UINT32_C(0x4E03295B), UINT32_C(0x7761E8EC), UINT32_C(0x07339770),
            UINT32_C(0x16EFEF58), UINT32_C(0x5DA5DAA2), UINT32_C(0x0D55D2DD) } },
        { { UINT32_C(0x8A22F87A), UINT32_C(0x915EA6A3), UINT32_C(0x2E5A088E),
            UINT32_C(0x191151C1), UINT32_C(0x7F1D5CBE), UINT32_C(0x190252F1),
            UINT32_C(0x3B0EC99B), UINT32_C(0xE43F59C3), UINT32_C(0xFF2A6135),
            UINT32_C(0xBE8588D4), UINT32_C(0x2ECB4B9F), UINT32_C(0x103877CC) },
          { UINT32_C(0x023CF92B), UINT32_C(0x8F4147E5), UINT32_C(0x0CC2085B),
            UINT32_C(0xC24384CC), UINT32_C(0xD082D311), UINT32_C(0x6A2DB4A2),
            UINT32_C(0xED7BA9AE), UINT32_C(0x06283811), UINT32_C(0x2A8E1592),
            UINT32_C(0xE9A3F532), UINT32_C(0x5A59E894), UINT32_C(0xAC20F0F4) } },
        { { UINT32_C(0x74AAB4B1), UINT32_C(0x788CAA52), UINT32_C(0x2FEAFC7E),
            UINT32_C(0xEB84ABA1), UINT32_C(0xAC04FF77), UINT32_C(0x31DA71DA),
            UINT32_C(0x24E4D0BF), UINT32_C(0x39D12EB9), UINT32_C(0x87A34EF8),
            UINT32_C(0x4F2F292F), UINT32_C(0xA237A8ED), UINT32_C(0x9B324372) },
          { UINT32_C(0x2EE3A82D), UINT32_C(0xBB2D04B1), UINT32_C(0xD18D36B2),
            UINT32_C(0xED4FF367), UINT32_C(0xA6EA0138), UINT32_C(0x99D231EE),
            UINT32_C(0x4F92E04A), UINT32_C(0x7C2D4F06), UINT32_C(0xCA272FD0),
            UINT32_C(0x78A82AB2), UINT32_C(0xAB8CDC32), UINT32_C(0x7EC41340) } },
    },
    {
        { { UINT32_C(0xD2E15A8C), UINT32_C(0xD23658C8), UINT32_C(0x16BA28CA),
            UINT32_C(0x23F93DF7), UINT32_C(0x082210F1), UINT32_C(0x6DAB10EC),
            UINT32_C(0xBFC36490), UINT32_C(0xFB1ADD91), UINT32_C(0x9A4F2D14),
            UINT32_C(0xEDA8B02F), UINT32_C(0x56560443), UINT32_C(0x9060318C) },
          { UINT32_C(0x64711AB2), UINT32_C(0x6C01479E), UINT32_C(0xE337EB85),
            UINT32_C(0x41446FC7), UINT32_C(0x71888397), UINT32_C(0x4DCF3C1D),
            UINT32_C(0x13C34FD2), UINT32_C(0x87A9C04E), UINT32_C(0x510C15AC),
            UINT32_C(0xFE0E08EC), UINT32_C(0xC0F495D2), UINT32_C(0xFC0D0413) } },
        { { UINT32_C(0x156636C2), UINT32_C(0xEB05C516), UINT32_C(0x090E93FC),
            UINT32_C(0x2F613ABA), UINT32_C(0x489576F5), UINT32_C(0xCFD573CD),
            UINT32_C(0x535A8D57), UINT32_C(0xE6535380), UINT32_C(0x671436C4),
            UINT32_C(0x13947314), UINT32_C(0x5F0A122D), UINT32_C(0x1172FB0C) },
          { UINT32_C(0xC12F58F6), UINT32_C(0xAECC7EC1), UINT32_C(0x8E41AFD2),
            UINT32_C(0xFE42F957), UINT32_C(0x3D4221AA), UINT32_C(0xDF96F652),
            UINT32_C(0x2851996B), UINT32_C(0xFEF5649F), UINT32_C(0xD5CFB67E),
            UINT32_C(0x46FB9F26), UINT32_C(0xEF5C4052), UINT32_C(0xB047BFC7) } },
        { { UINT32_C(0xF4484374), UINT32_C(0x5CBDC442), UINT32_C(0xF92452EF),
            UINT32_C(0x6B156957), UINT32_C(0xC118D02A), UINT32_C(0x58A26886),
            UINT32_C(0x75AAF276), UINT32_C(0x87FF74E6), UINT32_C(0xF65F6EC1),
            UINT32_C(0xB133BE95), UINT32_C(0x4B1B8D32), UINT32_C(0xA89B6284) },
          { UINT32_C(0x09C81004), UINT32_C(0xDD8A8EF3), UINT32_C(0x0CF21991),
            UINT32_C(0x7F8225DB), UINT32_C(0x26623FAF), UINT32_C(0xD525A6DB),
            UINT32_C(0xBAE15453), UINT32_C(0xF2368D40), UINT32_C(0x84F89FC9),
            UINT32_C(0x55D6A84D), UINT32_C(0x86021A3E), UINT32_C(0xAF38358A) } },
        { { UINT32_C(0xFF52E280), UINT32_C(0xBD048BDC), UINT32_C(0x526A1795),
            UINT32_C(0x8A51D0B2), UINT32_C(0xA985AC0F), UINT32_C(0x40AAA758),
            UINT32_C(0xF2C7ACE9), UINT32_C(0x6039BCDC), UINT32_C(0x6AEC347D),
            UINT32_C(0x712092CC), UINT32_C(0x6B5ACAB7), UINT32_C(0x7976D090) },
          { UINT32_C(0x6EED9617), UINT32_C(0x1EBCF80D), UINT32_C(0xB0F404A4),
            UINT32_C(0xB3A63149), UINT32_C(0xD0B610EF), UINT32_C(0x3FDD3D1A),
            UINT32_C(0x98C28AC7), UINT32_C(0xDD3F6F94), UINT32_C(0x3A59750F),
            UINT32_C(0x650B7794), UINT32_C(0x2D3991AC), UINT32_C(0xEC59BAB1) } },
        { { UINT32_C(0x2E552766), UINT32_C(0x01F40E88), UINT32_C(0x66F5354F),
            UINT32_C(0x1FE3D509), UINT32_C(0xB3A8EA7F), UINT32_C(0x0E46D006),
            UINT32_C(0xF831CD6A), UINT32_C(0xF75AB629), UINT32_C(0x91465119),
            UINT32_C(0xDAD808D7), UINT32_C(0x17EF9B10), UINT32_C(0x442405AF) },
          { UINT32_C(0x672BDFCB), UINT32_C(0xD5FE0A96), UINT32_C(0x355DBDEC),
            UINT32_C(0xA9DFA422), UINT32_C(0x79B25636), UINT32_C(0xFDB79AA1),
            UINT32_C(0xEECE8AEC), UINT32_C(0xE7F26FFD), UINT32_C(0x7EDD5AA2),
            UINT32_C(0xB5925550), UINT32_C(0x8EB3A6C2), UINT32_C(0x2C8F6FF0) } },
        { { UINT32_C(0x757D6136), UINT32_C(0x88887756), UINT32_C(0x88B92E72),
            UINT32_C(0xAD9AC183), UINT32_C(0x8785D3EB), UINT32_C(0x92CB2FC4),
            UINT32_C(0x9319764B), UINT32_C(0xD1A542FE), UINT32_C(0x626A62F8),
            UINT32_C(0xAF4CC78F), UINT32_C(0x26BFFAAE), UINT32_C(0x7F3F5FC9) },
          { UINT32_C(0x40AE2231), UINT32_C(0x0A203D43), UINT32_C(0x387898E8),
            UINT32_C(0xA8BFD9E0), UINT32_C(0x474B7DDD), UINT32_C(0x1A0C379C),
            UINT32_C(0x34FD49EA), UINT32_C(0x03855E0A), UINT32_C(0xB3EF4AE1),
            UINT32_C(0x02B26223), UINT32_C(0xE399E0A3), UINT32_C(0x804BD8CF) } },
        { { UINT32_C(0xDE865713), UINT32_C(0x11A9F3D0), UINT32_C(0xBDE98821),
            UINT32_C(0x81E36B6B), UINT32_C(0x6AA891D0), UINT32_C(0x324996C8),
            UINT32_C(0x395682B5), UINT32_C(0x7B95BDC1), UINT32_C(0xC1600563),
            UINT32_C(0x47BF2219), UINT32_C(0x643E38B4), UINT32_C(0x7A473F50) },
          { UINT32_C(0xF5738288), UINT32_C(0x0911F50A), UINT32_C(0x6F9C415B),
            UINT32_C(0xDF947A70), UINT32_C(0x67A067F6), UINT32_C(0xBDB994F2),
            UINT32_C(0x88BE96CD), UINT32_C(0x3F4BEC1B), UINT32_C(0xE56DD6D9),
            UINT32_C(0x9820E931), UINT32_C(0x0A80F419), UINT32_C(0xB138F14F) } },
        { { UINT32_C(0x0429077A), UINT32_C(0xA11A1A8F), UINT32_C(0x10351C68),
            UINT32_C(0x2BB1E33D), UINT32_C(0x89459A27), UINT32_C(0x3C25ABFE),
            UINT32_C(0x6B8AC774), UINT32_C(0x2D0091B8), UINT32_C(0x3B2415D9),
            UINT32_C(0xDAFC7853), UINT32_C(0x9201680D), UINT32_C(0xDE713CF1) },
          { UINT32_C(0x68889D57), UINT32_C(0x8E5F445D), UINT32_C(0x60EABF5B),
            UINT32_C(0x608B209C), UINT32_C(0xF9CFA408), UINT32_C(0x10EC0ACC),
            UINT32_C(0x4D1EE754), UINT32_C(0xD5256B9D), UINT32_C(0x0AA6C18D),
            UINT32_C(0xFF866BAB), UINT32_C(0xACB90A45), UINT32_C(0x9D196DB8) } },
        { { UINT32_C(0xB9B081B2), UINT32_C(0xA46D76A9), UINT32_C(0x62163C25),
            UINT32_C(0xFC743A10), UINT32_C(0x7761C392), UINT32_C(0xCD2A5C8D),
            UINT32_C(0xBE808583), UINT32_C(0x39BDDE0B), UINT32_C(0xB98E4DFE),
            UINT32_C(0x7C416021), UINT32_C(0x65913A44), UINT32_C(0xF930E563) },
          { UINT32_C(0x7585CF3C), UINT32_C(0xC3555F7E), UINT32_C(0x3D6333D5),
            UINT32_C(0xC737E383), UINT32_C(0xB430B03D), UINT32_C(0x5B60DBA4),
            UINT32_C(0xE7555404), UINT32_C(0x42B715EB), UINT32_C(0x7C7796E3),
            UINT32_C(0x571BDF5B), UINT32_C(0x6DB6331F), UINT32_C(0x33DC62C6) } },
        { { UINT32_C(0xE61DEE59), UINT32_C(0x3FB9CCB0), UINT32_C(0x18B14DB9),
            UINT32_C(0xC5185F23), UINT32_C(0x845EF36C), UINT32_C(0x1B2ADC4F),
            UINT32_C(0x5C1A33AB), UINT32_C(0x195D5B50), UINT32_C(0x421F59D2),
            UINT32_C(0x8CEA528E), UINT32_C(0xD2931CEA), UINT32_C(0x7DFCCECF) },
          { UINT32_C(0x8CF7E3F7), UINT32_C(0x51FFA1D5), UINT32_C(0xBDC9FB43),
            UINT32_C(0xF01B7886), UINT32_C(0x261A0D35), UINT32_C(0xD65AB610),
            UINT32_C(0x7574A554), UINT32_C(0x84BCBAFD), UINT32_C(0xFAD70208),
            UINT32_C(0x4B119956), UINT32_C(0x4FAB5243), UINT32_C(0xDDC329C2) } },
        { { UINT32_C(0x9CE92177), UINT32_C(0x1A08AA57), UINT32_C(0xDC2B5C36),
            UINT32_C(0x3395E557), UINT32_C(0x394ED04E), UINT32_C(0xFDFE7041),
            UINT32_C(0xC6DFCDDE), UINT32_C(0xB797EB24), UINT32_C(0xCB9DE5D6),
            UINT32_C(0x284A6B2A), UINT32_C(0x07222765), UINT32_C(0xE0BD95C8) },
          { UINT32_C(0x9FE678A7), UINT32_C(0x114A951B), UINT32_C(0x9E4954EC),
            UINT32_C(0xE7ECD0BD), UINT32_C(0x79F0B8A9), UINT32_C(0x7D4096FE),
            UINT32_C(0x09724FE2), UINT32_C(0xBDB26E9A), UINT32_C(0xF787AF95),
            UINT32_C(0x08741AD8), UINT32_C(0x24045AD8), UINT32_C(0x2BF97272) } },
        { { UINT32_C(0xA9451D57), UINT32_C(0xAB1FEDD9), UINT32_C(0x483E38C9),
            UINT32_C(0xDF4D91DF), UINT32_C(0x24E9CF8E), UINT32_C(0x2D54D311),
            UINT32_C(0x7A22EEB6), UINT32_C(0x9C2A5AF8), UINT32_C(0x0A43F123),
            UINT32_C(0xBD9861EF), UINT32_C(0x38A18B7B), UINT32_C(0x581EA6A2) },
          { UINT32_C(0x296470A3), UINT32_C(0xAF339C85), UINT32_C(0xAFD8203E),
            UINT32_C(0xF9603FCD), UINT32_C(0x96763C28), UINT32_C(0x95D05350),
            UINT32_C(0x860EC831), UINT32_C(0x15445C16), UINT32_C(0x6867A323),
            UINT32_C(0x2AFB8728), UINT32_C(0x0C4838BF), UINT32_C(0x4B152D6D) } },
        { { UINT32_C(0x837CACBA), UINT32_C(0x45BA0E4F), UINT32_C(0xC0725275),
            UINT32_C(0x7ADB38AE), UINT32_C(0x942D3C28), UINT32_C(0x19C82831),
            UINT32_C(0x6D0FE7DD), UINT32_C(0x94F4731D), UINT32_C(0x4898F1E6),
            UINT32_C(0xC3C07E13), UINT32_C(0xED410B51), UINT32_C(0x76350EAC) },
          { UINT32_C(0xF99AACFC), UINT32_C(0x0FA8BECA), UINT32_C(0x65FAF9CF),
            UINT32_C(0x2834D86F), UINT32_C(0x6F3866AF), UINT32_C(0x8E62846A),
            UINT32_C(0x3DFD6A2B), UINT32_C(0xDAA9BD4F), UINT32_C(0xA6132655),
            UINT32_C(0xC27115BB), UINT32_C(0xBD5A32C2), UINT32_C(0x83972DF7) } },
        { { UINT32_C(0xD513B825), UINT32_C(0xA330CB5B), UINT32_C(0xEE37BEC3),
            UINT32_C(0xAE18B2D3), UINT32_C(0xF780A902), UINT32_C(0xFC3AB80A),
            UINT32_C(0xD607DDF1), UINT32_C(0xD7835BE2), UINT32_C(0x5B6E4C2B),
            UINT32_C(0x8120F767), UINT32_C(0x67E78CCB), UINT32_C(0xAA8C3859) },
          { UINT32_C(0xAA0ED321), UINT32_C(0xA8DA8CE2), UINT32_C(0xD766341A),
            UINT32_C(0xCB8846FD), UINT32_C(0x33DC9D9A), UINT32_C(0xF2A342EE),
            UINT32_C(0xD0A18A80), UINT32_C(0xA519E0BE), UINT32_C(0xAF48DF4C),
            UINT32_C(0x9CDAA39C), UINT32_C(0x7E0C19EE), UINT32_C(0xA4B500CA) } },
        { { UINT32_C(0x8217001B), UINT32_C(0x83A7FD2F), UINT32_C(0x4296A8BA),
            UINT32_C(0x4F6FCF06), UINT32_C(0x91619927), UINT32_C(0x7D748643),
            UINT32_C(0x941E4D41), UINT32_C(0x174C1075), UINT32_C(0xA64F5A6C),
            UINT32_C(0x037EDEBD), UINT32_C(0x6E29DC56), UINT32_C(0xCF64DB3A) },
          { UINT32_C(0x37C0B9F4), UINT32_C(0x150B3ACE), UINT32_C(0x7168178B),
            UINT32_C(0x1323234A), UINT32_C(0xEF4D1879), UINT32_C(0x1CE47014),
            UINT32_C(0x17FB4D5C), UINT32_C(0xA22E3742), UINT32_C(0xD985F794),
            UINT32_C(0x69B81822), UINT32_C(0x081D7214), UINT32_C(0x199C21C4) } },
        { { UINT32_C(0x8F04B4D2), UINT32_C(0x160BC7A1), UINT32_C(0xB10DE174),
            UINT32_C(0x79CA81DD), UINT32_C(0x2DA1E9C7), UINT32_C(0xE2A280B0),
            UINT32_C(0x1D6A0A29), UINT32_C(0xB4F6BD99), UINT32_C(0x1C5B8F27),
            UINT32_C(0x57CF3EDD), UINT32_C(0x158C2FD4), UINT32_C(0x7E34FC57) },
          { UINT32_C(0xCAC93459), UINT32_C(0x828CFD89), UINT32_C(0xB7AF499F),
            UINT32_C(0x9E631B6F), UINT32_C(0xDA26C135), UINT32_C(0xF4DC8BC0),
            UINT32_C(0x37186735), UINT32_C(0x6128ED39), UINT32_C(0x67BF0BA5),
            UINT32_C(0xBB45538B), UINT32_C(0x0064A3AB), UINT32_C(0x1ADDD4C1) } },
    },
    {
        { { UINT32_C(0xDD14D47E), UINT32_C(0xC32730E8), UINT32_C(0xC0F01E0F),
            UINT32_C(0xCDC1FD42), UINT32_C(0x3F5CD846), UINT32_C(0x2BACFDBF),
            UINT32_C(0x7272D4DD), UINT32_C(0x45F36416), UINT32_C(0x5EB75776),
            UINT32_C(0xDD813A79), UINT32_C(0x50997BE2), UINT32_C(0xB57885E4) },
          { UINT32_C(0xDB8C9829), UINT32_C(0xDA054E2B), UINT32_C(0xAAB5A594),
            UINT32_C(0x4161D820), UINT32_C(0x026116A3), UINT32_C(0x4C428F31),
            UINT32_C(0xDCD85E91), UINT32_C(0x372AF9A0), UINT32_C(0x673ADC2D),
            UINT32_C(0xFDA6E903), UINT32_C(0xA8DB59E6), UINT32_C(0x4526B8AC) } },
        { { UINT32_C(0xE23A8472), UINT32_C(0x68FE359D), UINT32_C(0x4CE3C101),
            UINT32_C(0x43EB12BD), UINT32_C(0xFC704935), UINT32_C(0x0EC652C3),
            UINT32_C(0x52E4E22D), UINT32_C(0x1EEFF1F9), UINT32_C(0x083E3ADA),
            UINT32_C(0xBA6777CB), UINT32_C(0x8BEFC871), UINT32_C(0xAB52D7DC) },
          { UINT32_C(0x497CBD59), UINT32_C(0x4EDE689F), UINT32_C(0x27577DD9),
            UINT32_C(0xC8AE42B9), UINT32_C(0x7AB83C27), UINT32_C(0xE0F08051),
            UINT32_C(0x2C8C1F48), UINT32_C(0x1F3D5F25), UINT32_C(0xAF241AAC),
            UINT32_C(0x57991607), UINT32_C(0xB8A337E0), UINT32_C(0xC4458B0A) } },
        { { UINT32_C(0x51DD1BA9), UINT32_C(0x3DBB3FA6), UINT32_C(0x545E960B),
            UINT32_C(0xE53C1C4D), UINT32_C(0x793CE803), UINT32_C(0x35AC6574),
            UINT32_C(0x83DBCE4F), UINT32_C(0xB2697DC7), UINT32_C(0xE13CF6B0),
            UINT32_C(0xE35C5BF2), UINT32_C(0xB0C4A164), UINT32_C(0x35034280) },
          { UINT32_C(0xD9C0D3C1), UINT32_C(0xAA490908), UINT32_C(0xCB4D2E90),
            UINT32_C(0x2CCE614D), UINT32_C(0x54D504E4), UINT32_C(0xF646E96C),
            UINT32_C(0xB73310A3), UINT32_C(0xD74E7541), UINT32_C(0x18BDE5DA),
            UINT32_C(0xEAD71596), UINT32_C(0xAA09AEF7), UINT32_C(0x96E7F4A8) } },
        { { UINT32_C(0x5D6E5F48), UINT32_C(0xA8393A24), UINT32_C(0xF9175CE8),
            UINT32_C(0x2C8D7EA2), UINT32_C(0x55A20268), UINT32_C(0xD8824E02),
            UINT32_C(0xA446BCC6), UINT32_C(0x9DD9A272), UINT32_C(0x5351499B),
            UINT32_C(0xC929CDED), UINT32_C(0xCFE76535), UINT32_C(0xEA5AD9EC) },
          { UINT32_C(0xDC32D001), UINT32_C(0x26F3D7D9), UINT32_C(0x43EB9689),
            UINT32_C(0x51C3BE83), UINT32_C(0x759E6DDB), UINT32_C(0x91FDCC06),
            UINT32_C(0xE302B891), UINT32_C(0xAC2E1904), UINT32_C(0xC207E1F7),
            UINT32_C(0xAD25C645), UINT32_C(0xAB3DEB4A), UINT32_C(0x28A70F0D) } },
        { { UINT32_C(0x03BEA8F1), UINT32_C(0x922D7F97), UINT32_C(0x584570BE),
            UINT32_C(0x3AD820D4), UINT32_C(0x3CD46B43), UINT32_C(0x0CE0A850),
            UINT32_C(0xAE66743D), UINT32_C(0x4C07911F), UINT32_C(0xFDA60023),
            UINT32_C(0x66519EB9), UINT32_C(0xEC2ACD9C), UINT32_C(0x7F83004B) },
          { UINT32_C(0xC3117EAD), UINT32_C(0x001E0B80), UINT32_C(0x0722BA25),
            UINT32_C(0xBB72D541), UINT32_C(0x6E9A5078), UINT32_C(0x3AF7DB96),
            UINT32_C(0x701B6B4C), UINT32_C(0x86C5774E), UINT32_C(0x37824DB5),
            UINT32_C(0xBD2C0E8E), UINT32_C(0xBFAC286D), UINT32_C(0x3AE3028C) } },
        { { UINT32_C(0xA33E071B), UINT32_C(0x83D4D4A8), UINT32_C(0x61444BB5),
            UINT32_C(0x881C0A92), UINT32_C(0x520E3BC3), UINT32_C(0xEEA1E292),
            UINT32_C(0x2AAAB729), UINT32_C(0x5A5F4C3C), UINT32_C(0xE63C7C94),
            UINT32_C(0x0B766C5E), UINT32_C(0xBB2CC79C), UINT32_C(0x62BB8A9F) },
          { UINT32_C(0xAA5DC49D), UINT32_C(0x97ADC7D2), UINT32_C(0x31718681),
            UINT32_C(0x30CC26B3), UINT32_C(0x56E86EDE), UINT32_C(0xAC86E6FF),
            UINT32_C(0xCD52F7F2), UINT32_C(0x37BCA7A2), UINT32_C(0x9CE6D87F),
            UINT32_C(0x734D2C94), UINT32_C(0xC2F7E0CA), UINT32_C(0x06A71D71) } },
        { { UINT32_C(0xC6357D33), UINT32_C(0x559DCF75), UINT32_C(0x652517DE),
            UINT32_C(0x4616D940), UINT32_C(0x1CCF207B), UINT32_C(0x3D576B98),
            UINT32_C(0x1979F631), UINT32_C(0x51E2D1EF), UINT32_C(0x06AE8296),
            UINT32_C(0x57517DDD), UINT32_C(0xD6E7151F), UINT32_C(0x309A3D7F) },
          { UINT32_C(0x0E3A6FE5), UINT32_C(0xBA2A23E6), UINT32_C(0xD28B22C3),
            UINT32_C(0x76CF674A), UINT32_C(0xF8B808C3), UINT32_C(0xD235AD07),
            UINT32_C(0x6B71213A), UINT32_C(0x7BBF4C58), UINT32_C(0x93271EBB),
            UINT32_C(0x0676792E), UINT32_C(0x05B1FC31), UINT32_C(0x2CFD2C76) } },
        { { UINT32_C(0x37A450F5), UINT32_C(0x4258E5C0), UINT32_C(0x52D2B118),
            UINT32_C(0xC3245F1B), UINT32_C(0x82BC5963), UINT32_C(0x6DF7B484),
            UINT32_C(0x9C273D1E), UINT32_C(0xE520DA4D), UINT32_C(0x2C3010E5),
            UINT32_C(0xED78E012), UINT32_C(0x3C1D4C05), UINT32_C(0x11222948) },
          { UINT32_C(0xC692B490), UINT32_C(0xE3DAE5AF), UINT32_C(0xC197F793),
            UINT32_C(0x3272BD10), UINT32_C(0xE709ACAA), UINT32_C(0xF7EAE411),
            UINT32_C(0x778270A6), UINT32_C(0x00B0C95F), UINT32_C(0x220D4350),
            UINT32_C(0x4DA76EE1), UINT32_C(0xAB71E308), UINT32_C(0x521E1461) } },
        { { UINT32_C(0x343196A3), UINT32_C(0x7B654323), UINT32_C(0xB0C95250),
            UINT32_C(0x35D442AD), UINT32_C(0xE264FF17), UINT32_C(0x38AF50E6),
            UINT32_C(0x2030D2EA), UINT32_C(0x28397A41), UINT32_C(0xF74EEDA1),
            UINT32_C(0x8F1D84E9), UINT32_C(0xE6FB3C52), UINT32_C(0xD521F92D) },
          { UINT32_C(0x95733811), UINT32_C(0xAF358D77), UINT32_C(0x93ABFE94),
            UINT32_C(0xEBFDDD01), UINT32_C(0xD18D99DE), UINT32_C(0x05D8A028),
            UINT32_C(0xB5D5BDD9), UINT32_C(0x5A664019), UINT32_C(0x2AA12FE8),
            UINT32_C(0x3DF17282), UINT32_C(0xB889A28E), UINT32_C(0xB42E006F) } },
        { { UINT32_C(0xBC35CB1A), UINT32_C(0xCF10E97D), UINT32_C(0x994DEDC5),
            UINT32_C(0xC70A7BBD), UINT32_C(0x37D04FB9), UINT32_C(0x76A5327C),
            UINT32_C(0xA76E0CDA), UINT32_C(0x87539F76), UINT32_C(0xCD60A6B1),
            UINT32_C(0xE9FE493F), UINT32_C(0x132F01C0), UINT32_C(0xA4574796) },
          { UINT32_C(0xDB70B167), UINT32_C(0xC43B85EB), UINT32_C(0x98551DFA),
            UINT32_C(0x81D5039A), UINT32_C(0x1D979FA4), UINT32_C(0x6B56FBE9),
            UINT32_C(0x8615098F), UINT32_C(0x49714FD7), UINT32_C(0x94DECAB5),
            UINT32_C(0xB10E1CEA), UINT32_C(0x480EF6E3), UINT32_C(0x8342EBA3) } },
        { { UINT32_C(0xB3677288), UINT32_C(0xE1E030B0), UINT32_C(0x8D5CE3AF),
            UINT32_C(0x2978174C), UINT32_C(0xF7B2DE98), UINT32_C(0xAFC0271C),
            UINT32_C(0xB99C20B5), UINT32_C(0x745BC6F3), UINT32_C(0x1E3BB4E5),
            UINT32_C(0x9F6EDCED), UINT32_C(0x73C8C1FC), UINT32_C(0x58D3EE4E) },
          { UINT32_C(0x7FD30124), UINT32_C(0x1F3535F4), UINT32_C(0x5FA62502),
            UINT32_C(0xF366AC70), UINT32_C(0x965363FE), UINT32_C(0x4C4C1FDD),
            UINT32_C(0x1DE2CA2B), UINT32_C(0x8B2C7777), UINT32_C(0x882F1173),
            UINT32_C(0x0CB54743), UINT32_C(0x71343331), UINT32_C(0x94B6B8C0) } },
        { { UINT32_C(0x65B8B35B), UINT32_C(0x75AF0141), UINT32_C(0x4670A1F5),
            UINT32_C(0x6D7B8485), UINT32_C(0xA3B6D376), UINT32_C(0x6EAA3A47),
            UINT32_C(0xCB3E5B66), UINT32_C(0xD7E673D2), UINT32_C(0x9589AB38),
            UINT32_C(0xC0338E6C), UINT32_C(0x09440FAA), UINT32_C(0x4BE26CB3) },
          { UINT32_C(0x394F9AA3), UINT32_C(0x82CB05E7), UINT32_C(0x7F7792EA),
            UINT32_C(0xC45C8A8A), UINT32_C(0xB687DC70), UINT32_C(0x37E5E33B),
            UINT32_C(0xDFE48E49), UINT32_C(0x63853219), UINT32_C(0x6D0E5C8C),
            UINT32_C(0x087951C1), UINT32_C(0x2BC27310), UINT32_C(0x7696A8C7) } },
        { { UINT32_C(0xB67E834A), UINT32_C(0xA05736D5), UINT32_C(0x9098D42A),
            UINT32_C(0xDD2AA0F2), UINT32_C(0x49C69DDC), UINT32_C(0x09F0C1D8),
            UINT32_C(0x8FF0F0F3), UINT32_C(0x81F8BC1C), UINT32_C(0x03037775),
            UINT32_C(0x36FD3A4F), UINT32_C(0x4B06DF5C), UINT32_C(0x8286717D) },
          { UINT32_C(0xA9079EA2), UINT32_C(0xB878F496), UINT32_C(0xD7DC796D),
            UINT32_C(0xA5642426), UINT32_C(0x67FDAC2B), UINT32_C(0x29B9351A),
            UINT32_C(0x1D543CDE), UINT32_C(0x93774C0E), UINT32_C(0x1A8E31C4),
            UINT32_C(0x4F8793BA), UINT32_C(0x6C94798A), UINT32_C(0x7C9F3F3A) } },
        { { UINT32_C(0xCB8ECDB8), UINT32_C(0x23C5AD11), UINT32_C(0x485A6A02),
            UINT32_C(0x1E88D25E), UINT32_C(0xF1E268AE), UINT32_C(0xB27CBE84),
            UINT32_C(0xF4CD0475), UINT32_C(0xDDA80238), UINT32_C(0x49F8EB1B),
            UINT32_C(0x4F88857B), UINT32_C(0x52FB07F9), UINT32_C(0x91B1221F) },
          { UINT32_C(0x8637FA67), UINT32_C(0x7CE97460), UINT32_C(0x632198D8),
            UINT32_C(0x528B3CF4), UINT32_C(0xF6623769), UINT32_C(0x33365AB3),
            UINT32_C(0x3A83A30F), UINT32_C(0x6FEBCFFF), UINT32_C(0x9BD341EB),
            UINT32_C(0x398F4C99), UINT32_C(0xB33A333C), UINT32_C(0x180712BB) } },
        { { UINT32_C(0xD93429E7), UINT32_C(0x2B8655A2), UINT32_C(0x75C8B9EE),
            UINT32_C(0x99D600BB), UINT32_C(0x88FCA6CD), UINT32_C(0x9FC1AF8B),
            UINT32_C(0x7C311F80), UINT32_C(0x2FB53386), UINT32_C(0xE8A71EEE),
            UINT32_C(0x20743ECB), UINT32_C(0xE848B49E), UINT32_C(0xEC3713C4) },
          { UINT32_C(0xBB886817), UINT32_C(0x5B2037B5), UINT32_C(0x307DBAF4),
            UINT32_C(0x40EF5AC2), UINT32_C(0x1B3F643D), UINT32_C(0xC2888AF2),
            UINT32_C(0x9D5A4190), UINT32_C(0x0D8252E1), UINT32_C(0x2DB52A8A),
            UINT32_C(0x06CC0BEC), UINT32_C(0xAB94E969), UINT32_C(0xB84B98EA) } },
        { { UINT32_C(0xA0321E0E), UINT32_C(0x2E7AC078), UINT32_C(0xEF3DAAB6),
            UINT32_C(0x5C5A1168), UINT32_C(0xADDD454A), UINT32_C(0xD2D573CB),
            UINT32_C(0x36259CC7), UINT32_C(0x27E149E2), UINT32_C(0xA63F47F1),
            UINT32_C(0x1EDFD469), UINT32_C(0xF1BD2CFD), UINT32_C(0x039AD674) },
          { UINT32_C(0x3077D3CC), UINT32_C(0xBFA633FC), UINT32_C(0x2FD64E9F),
            UINT32_C(0x14A7C82F), UINT32_C(0x9D824999), UINT32_C(0xAAA65014),
            UINT32_C(0x21760F2E), UINT32_C(0x41AB113B), UINT32_C(0x1CAE260A),
            UINT32_C(0x23E646C5), UINT32_C(0x68DC5159), UINT32_C(0x08062C8F) } },
    },
    {
        { { UINT32_C(0x204BE028), UINT32_C(0x2E7D0A16), UINT32_C(0xD0E41851),
            UINT32_C(0x4F1D082E), UINT32_C(0x3EB317F9), UINT32_C(0x15F1DDC6),
            UINT32_C(0x5ADF71D7), UINT32_C(0xF0275071), UINT32_C(0xEE858BC3),
            UINT32_C(0x2CE33C2E), UINT32_C(0xDA73B71A), UINT32_C(0xA24C76D1) },
          { UINT32_C(0x6C70C483), UINT32_C(0x9EF6A70A), UINT32_C(0x05CF9612),
            UINT32_C(0xEFCF1705), UINT32_C(0x7502DE64), UINT32_C(0x9F5BF5A6),
            UINT32_C(0xA4701973), UINT32_C(0xD11122A1), UINT32_C(0xA2EA7B24),
            UINT32_C(0x82CFAAC2), UINT32_C(0x0A4582E1), UINT32_C(0x6CAD67CC) } },
        { { UINT32_C(0xB4DC8600), UINT32_C(0x597A26FF), UINT32_C(0xF9288555),
            UINT32_C(0x264A09F3), UINT32_C(0x5C27F5F6), UINT32_C(0x0B06AFF6),
            UINT32_C(0xD8D544E6), UINT32_C(0xCE5AB665), UINT32_C(0x99275C32),
            UINT32_C(0x92F031BE), UINT32_C(0xF42E0E7C), UINT32_C(0xAF51C5BB) },
          { UINT32_C(0x1E37B36D), UINT32_C(0x5BB28B06), UINT32_C(0x8473543A),
            UINT32_C(0x583FBA6A), UINT32_C(0xF93FB7DC), UINT32_C(0xE73FD299),
            UINT32_C(0x6E2CCAD9), UINT32_C(0xFCD999A8), UINT32_C(0x334D4F57),
            UINT32_C(0xB8C8A6DF), UINT32_C(0x9A2ACC9B), UINT32_C(0x5ADB28DD) } },
        { { UINT32_C(0x111792B9), UINT32_C(0x5ADF3D9A), UINT32_C(0x4F1E0D09),
            UINT32_C(0x1C77A305), UINT32_C(0xA82D3736), UINT32_C(0xF9FBCE33),
            UINT32_C(0x718C8AA3), UINT32_C(0xF307823E), UINT32_C(0x416CCF69),
            UINT32_C(0x860578CF), UINT32_C(0x1EF8465B), UINT32_C(0xB942ADD8) },
          { UINT32_C(0xCD9472E1), UINT32_C(0x9EE0CF97), UINT32_C(0xB01528A8),
            UINT32_C(0xE6792EEF), UINT32_C(0xC09DA90B), UINT32_C(0xF99B9A8D),
            UINT32_C(0xCBF3CCB8), UINT32_C(0x1F521C2D), UINT32_C(0x91A62632),
            UINT32_C(0x6BF66948), UINT32_C(0x854FE9DA), UINT32_C(0xCC7A9CEB) } },
        { { UINT32_C(0x491CCB92), UINT32_C(0x46303171), UINT32_C(0x2771235B),
            UINT32_C(0xA80A8C0D), UINT32_C(0xF172C7CF), UINT32_C(0xD8E497FF),
            UINT32_C(0x35B193CF), UINT32_C(0x7F7009D7), UINT32_C(0xF19DF4BC),
            UINT32_C(0x6B9FD3F7), UINT32_C(0xB46F1E37), UINT32_C(0xADA548C3) },
          { UINT32_C(0xC7A20270), UINT32_C(0x87C6EAA9), UINT32_C(0xAE78EF99),
            UINT32_C(0xEF2245D6), UINT32_C(0x539EAB95), UINT32_C(0x2A121042),
            UINT32_C(0x79B8F5CC), UINT32_C(0x29A6D5D7), UINT32_C(0xB77840DC),
            UINT32_C(0x33803A10), UINT32_C(0x11A6A30F), UINT32_C(0xFEDD3A70) } },
        { { UINT32_C(0x142403D1), UINT32_C(0xFA070E22), UINT32_C(0x15C6F7F5),
            UINT32_C(0x68FF3160), UINT32_C(0x223A0CE8), UINT32_C(0xE09F04E6),
            UINT32_C(0x53E14183), UINT32_C(0x22BBD018), UINT32_C(0xCF45B75B),
            UINT32_C(0x35D9FAFC), UINT32_C(0x7ECEEC88), UINT32_C(0x3A34819D) },
          { UINT32_C(0xD33262D2), UINT32_C(0xD9CF7568), UINT32_C(0x841D1505),
            UINT32_C(0x431036D5), UINT32_C(0x9EB2A79A), UINT32_C(0x0C800565),
            UINT32_C(0x5F7EDC6A), UINT32_C(0x8E77D9F0), UINT32_C(0x65E800AA),
            UINT32_C(0x19E12D05), UINT32_C(0xB7784E7C), UINT32_C(0x335C8D36) } },
        { { UINT32_C(0x6484FD40), UINT32_C(0x8B2FC4E9), UINT32_C(0xA35D24EA),
            UINT32_C(0xEE702764), UINT32_C(0xB871C3F3), UINT32_C(0x15B28AC7),
            UINT32_C(0xE097047F), UINT32_C(0x805B4048), UINT32_C(0x647CAD2F),
            UINT32_C(0xD6F1B8DF), UINT32_C(0xDC7DD67F), UINT32_C(0xF1D5B458) },
          { UINT32_C(0x25148803), UINT32_C(0x324C529C), UINT32_C(0x21274FAF),
            UINT32_C(0xF6185EBE), UINT32_C(0x95148B55), UINT32_C(0xAF14751E),
            UINT32_C(0x28F284F4), UINT32_C(0x283ED89D), UINT32_C(0x4CBEBF1A),
            UINT32_C(0x93AD20E7), UINT32_C(0x882935E1), UINT32_C(0x5F6EC65D) } },
        { { UINT32_C(0xA4DCEFE9), UINT32_C(0xE222EBA4), UINT32_C(0xEC1CEB74),
            UINT32_C(0x63AD235F), UINT32_C(0xE05B18E7), UINT32_C(0x2E0BF749),
            UINT32_C(0xB48BDD87), UINT32_C(0x547BD050), UINT32_C(0xF5AA2FC4),
            UINT32_C(0x0490C970), UINT32_C(0x2B431390), UINT32_C(0xCED5E4CF) },
          { UINT32_C(0x51D2898E), UINT32_C(0x07D82704), UINT32_C(0x083B57D4),
            UINT32_C(0x44B72442), UINT32_C(0x5037FCE8), UINT32_C(0xA4ADA230),
            UINT32_C(0x50510DA6), UINT32_C(0x55F7905E), UINT32_C(0x8D890A98),
            UINT32_C(0xD8EE724F), UINT32_C(0x11B85640), UINT32_C(0x925A8E7C) } },
        { { UINT32_C(0x1CA459ED), UINT32_C(0x5BFA10CD), UINT32_C(0x6DCF56BF),
            UINT32_C(0x593F085A), UINT32_C(0xC0579C3E), UINT32_C(0xE6F0AD9B),
            UINT32_C(0x2527C1AD), UINT32_C(0xC11C95A2), UINT32_C(0xCF1CB8B3),
            UINT32_C(0x7CFA71E1), UINT32_C(0x1D6DC79D), UINT32_C(0xEDCFF833) },
          { UINT32_C(0x432521C9), UINT32_C(0x581C4BBE), UINT32_C(0x144E11A0),
            UINT32_C(0xBF620096), UINT32_C(0xBE3A107B), UINT32_C(0x54C38B71),
            UINT32_C(0xE2606EC0), UINT32_C(0xED555E37), UINT32_C(0xD721D034),
            UINT32_C(0x3FB148B8), UINT32_C(0x0091BC90), UINT32_C(0x79D53DAD) } },
        { { UINT32_C(0xB7082C80), UINT32_C(0xE32068C5), UINT32_C(0x7A144E22),
            UINT32_C(0x4140FFD2), UINT32_C(0x9EDD9E86), UINT32_C(0x5811D2F0),
            UINT32_C(0xC572C465), UINT32_C(0xCDD79B5F), UINT32_C(0xC97BF450),
            UINT32_C(0x3563FED1), UINT32_C(0xF2CE5C9C), UINT32_C(0x985C1444) },
          { UINT32_C(0x99950F1C), UINT32_C(0x260AE797), UINT32_C(0x765E9DED),
            UINT32_C(0x659F4F40), UINT32_C(0x2E3BC286), UINT32_C(0x2A412D66),
            UINT32_C(0xF87E0C82), UINT32_C(0xE865E62C), UINT32_C(0x6C05E7D7),
            UINT32_C(0xD63D3A9A), UINT32_C(0x8686F89A), UINT32_C(0x96725D67) } },
        { { UINT32_C(0xAB7EA0F5), UINT32_C(0xC99A5E4C), UINT32_C(0xC5393FA9),
            UINT32_C(0xC9860A1A), UINT32_C(0x8FDEEFC0), UINT32_C(0x9ED83CEE),
            UINT32_C(0x5ED6869A), UINT32_C(0xE3EA8B4C), UINT32_C(0xD2EED3A9),
            UINT32_C(0x89A85463), UINT32_C(0xE421A622), UINT32_C(0x2CD91B6D) },
          { UINT32_C(0x2C91C41D), UINT32_C(0x6FEC1EF3), UINT32_C(0x8171037D),
            UINT32_C(0xB1540D1F), UINT32_C(0x1C010E5B), UINT32_C(0x4FE4991A),
            UINT32_C(0xFC1C7368), UINT32_C(0x28A3469F), UINT32_C(0xAF118781),
            UINT32_C(0xE1EEECD1), UINT32_C(0x99EF3531), UINT32_C(0x1BCCB977) } },
        { { UINT32_C(0xC4DAB7B8), UINT32_C(0x63D3B638), UINT32_C(0x3F7F5BAB),
            UINT32_C(0xD92133B6), UINT32_C(0x09FB6069), UINT32_C(0x2573EE20),
            UINT32_C(0x890A1686), UINT32_C(0x771FABDF), UINT32_C(0xA77AFFF5),
            UINT32_C(0x1D0BA21F), UINT32_C(0xBA3DD2C0), UINT32_C(0x83145FCC) },
          { UINT32_C(0x2D115C20), UINT32_C(0xFA073A81), UINT32_C(0x19176F27),
            UINT32_C(0x6AB7A9D3), UINT32_C(0x9AC639EE), UINT32_C(0xAF62CF93),
            UINT32_C(0x2CCD1319), UINT32_C(0xF73848B9), UINT32_C(0x3C71659D),
            UINT32_C(0x3B613234), UINT32_C(0x10AB3826), UINT32_C(0xF8E0011C) } },
        { { UINT32_C(0x0282FFA5), UINT32_C(0x0501F036), UINT32_C(0xD9E0F15A),
            UINT32_C(0xC39A5CF4), UINT32_C(0x9A3D1F3C), UINT32_C(0x48D8C729),
            UINT32_C(0x64E18EDA), UINT32_C(0xB5FC136B), UINT32_C(0x7E58FEF0),
            UINT32_C(0xE81B53D9), UINT32_C(0xF7B0F28D), UINT32_C(0x0D534055) },
          { UINT32_C(0x7A80619B), UINT32_C(0x47B8DE12), UINT32_C(0x81F9E55D),
            UINT32_C(0x60E2A2B3), UINT32_C(0xCF564CC5), UINT32_C(0x6E9624D7),
            UINT32_C(0x6BDEDFFF), UINT32_C(0xFDF18A21), UINT32_C(0xC0D5FC82),
            UINT32_C(0x3787DE38), UINT32_C(0x497A6B11), UINT32_C(0xCBCAA347) } },
        { { UINT32_C(0xB226465A), UINT32_C(0x6E7EF35E), UINT32_C(0x5F8A2BAF),
            UINT32_C(0x4B469919), UINT32_C(0x1120D93F), UINT32_C(0x44B3A3CF),
            UINT32_C(0x68F34AD1), UINT32_C(0xB052C8B6), UINT32_C(0xEF7632DD),
            UINT32_C(0x27EC574B), UINT32_C(0x685DE26F), UINT32_C(0xAEBEA108) },
          { UINT32_C(0xE39424B6), UINT32_C(0xDA33236B), UINT32_C(0xEBCC22AD),
            UINT32_C(0xB1BD94A9), UINT32_C(0x2CDFB5D5), UINT32_C(0x6DDEE6CC),
            UINT32_C(0x6F14069A), UINT32_C(0xBDAED927), UINT32_C(0x2A247CB7),
            UINT32_C(0x2ADE427C), UINT32_C(0xED156A40), UINT32_C(0xCE96B436) } },
        { { UINT32_C(0x81F3F819), UINT32_C(0xDDDCA360), UINT32_C(0xD419B96A),
            UINT32_C(0x4AF4A49F), UINT32_C(0x7CB966B9), UINT32_C(0x746C6525),
            UINT32_C(0x6F610023), UINT32_C(0x01E39088), UINT32_C(0x98DD33FC),
            UINT32_C(0x05ECB38D), UINT32_C(0x8F84EDF4), UINT32_C(0x962B971B) },
          { UINT32_C(0x6A6F2602), UINT32_C(0xEB32C0A5), UINT32_C(0x562D60F2),
            UINT32_C(0xF026AF71), UINT32_C(0x84615FAB), UINT32_C(0xA9E246BF),
            UINT32_C(0x75DBAE01), UINT32_C(0xAD967092), UINT32_C(0x3ECE5D07),
            UINT32_C(0xBF97C79B), UINT32_C(0x74EAA3D3), UINT32_C(0xE06266C7) } },
        { { UINT32_C(0x2E6DBB6E), UINT32_C(0x161A0157), UINT32_C(0x60FA8F47),
            UINT32_C(0xB8AF4904), UINT32_C(0x00197F22), UINT32_C(0xE4336C44),
            UINT32_C(0x9CEDCE0E), UINT32_C(0xF811AFFA), UINT32_C(0xF94C2EF1),
            UINT32_C(0xB1DD7685), UINT32_C(0xCA957BB0), UINT32_C(0xEEDC0F4B) },
          { UINT32_C(0x4AA76BB1), UINT32_C(0xD319FD57), UINT32_C(0x16CD7CCB),
            UINT32_C(0xB3525D7C), UINT32_C(0xA97DD072), UINT32_C(0x7B22DA9C),
            UINT32_C(0x38A83E71), UINT32_C(0x99DB84BD), UINT32_C(0xC0EDD8BE),
            UINT32_C(0x4939BC8D), UINT32_C(0x903A932C), UINT32_C(0x06D524EA) } },
        { { UINT32_C(0x0E31F639), UINT32_C(0x4BC950EC), UINT32_C(0x6016BE30),
            UINT32_C(0xB7ABD3DC), UINT32_C(0x6703DAD0), UINT32_C(0x3B0F4473),
            UINT32_C(0x0AC1C4EA), UINT32_C(0xCC405F8B), UINT32_C(0x176C3FEE),
            UINT32_C(0x9BED5E57), UINT32_C(0x36AE36C2), UINT32_C(0xF4524810) },
          { UINT32_C(0x15D7B503), UINT32_C(0xC1EDBB83), UINT32_C(0xE30F3657),
            UINT32_C(0x943B1156), UINT32_C(0x98377805), UINT32_C(0x984E9EEF),
            UINT32_C(0x36CF1DEB), UINT32_C(0x291AE7AC), UINT32_C(0xA9F66DF3),
            UINT32_C(0xFED8748C), UINT32_C(0xFEA8FA5D), UINT32_C(0xECA758BB) } },
    },
    {
        { { UINT32_C(0x2DD1B249), UINT32_C(0xACC787EF), UINT32_C(0xD82976F1),
            UINT32_C(0x736E1030), UINT32_C(0xA01B3649), UINT32_C(0x0A6940FA),
            UINT32_C(0xC42341E7), UINT32_C(0xE00B926B), UINT32_C(0xDE8FFD6C),
            UINT32_C(0x911508D0), UINT32_C(0x5276B0CB), UINT32_C(0x4DCF8D46) },
          { UINT32_C(0xCC3CAD8D), UINT32_C(0x23AD0A90), UINT32_C(0xADED962A),
            UINT32_C(0x2A92E54C), UINT32_C(0xF231BFAF), UINT32_C(0x93FBEC4D),
            UINT32_C(0x4798987A), UINT32_C(0x9544BC77), UINT32_C(0x08E29F60),
            UINT32_C(0x48084E25), UINT32_C(0x32DE5869), UINT32_C(0x0C0D2F43) } },
        { { UINT32_C(0x3A9ABC13), UINT32_C(0x6778F970), UINT32_C(0x3D2B166B),
            UINT32_C(0xFD014FAC), UINT32_C(0x3C6FED60), UINT32_C(0x1FE4FC78),
            UINT32_C(0xAA7C69C5), UINT32_C(0x04295FA8), UINT32_C(0x7C123175),
            UINT32_C(0xA01DE56D), UINT32_C(0x3D9A713A), UINT32_C(0x0FA0D3A8) },
          { UINT32_C(0xE3E08ADD), UINT32_C(0xA7A6E5E3), UINT32_C(0x1AC58F85),
            UINT32_C(0xBD77E94B), UINT32_C(0xB7321A9C), UINT32_C(0x078F6FD2),
            UINT32_C(0x911EF6D9), UINT32_C(0x9564601E), UINT32_C(0x415C6BEF),
            UINT32_C(0x31C5C1B2), UINT32_C(0xD3212C62), UINT32_C(0xE6C0C91E) } },
        { { UINT32_C(0x0D16022F), UINT32_C(0xBA7BD23C), UINT32_C(0x198BE288),
            UINT32_C(0xE9CF4750), UINT32_C(0x47DEEC65), UINT32_C(0x304E3169),
            UINT32_C(0x96EEB288), UINT32_C(0xCF65B41F), UINT32_C(0x927E9E3B),
            UINT32_C(0x17E99C17), UINT32_C(0xF6630A80), UINT32_C(0x82225546) },
          { UINT32_C(0xCA067BD9), UINT32_C(0x15122B8A), UINT32_C(0xB77B4E98),
            UINT32_C(0xE2673205), UINT32_C(0x9407CA63), UINT32_C(0x13037565),
            UINT32_C(0x8B621602), UINT32_C(0x53624F54), UINT32_C(0xEAE4BD06),
            UINT32_C(0x96AF2CB1), UINT32_C(0x8FA20829), UINT32_C(0x576ECD1C) } },
        { { UINT32_C(0x7E02D2D0), UINT32_C(0xA551CE10), UINT32_C(0x9D13DBC7),
            UINT32_C(0x1584ED24), UINT32_C(0x4DA7B6D8), UINT32_C(0x082017AD),
            UINT32_C(0xE054BC48), UINT32_C(0x81918A8F), UINT32_C(0x572DC384),
            UINT32_C(0x677DB48E), UINT32_C(0x6155484C), UINT32_C(0x2EF82296) },
          { UINT32_C(0x41B9C231), UINT32_C(0xC3DB14C6), UINT32_C(0x4A766192),
            UINT32_C(0x910A87D1), UINT32_C(0x10AB8E0F), UINT32_C(0x93D5CC86),
            UINT32_C(0xAE57CA1B), UINT32_C(0x4194D548), UINT32_C(0x267FC37A),
            UINT32_C(0xFAF3A1D6), UINT32_C(0x13B87C97), UINT32_C(0x70EC2364) } },
        { { UINT32_C(0x5E12756A), UINT32_C(0x064B565B), UINT32_C(0xAE49C98E),
            UINT32_C(0x953B7BD1), UINT32_C(0xF7001D91), UINT32_C(0xE0CE8284),
            UINT32_C(0xF31108D0), UINT32_C(0x1546060B), UINT32_C(0x6779B6E2),
            UINT32_C(0xDBC2C3F4), UINT32_C(0xE0DD07CF), UINT32_C(0x157AA47D) },
          { UINT32_C(0xF23B261E), UINT32_C(0xBF4A1C6F), UINT32_C(0x654F4BE5),
            UINT32_C(0x5B8EED30), UINT32_C(0x6B20CCD8), UINT32_C(0xDF5896D3),
            UINT32_C(0x559ED23D), UINT32_C(0x56920E2C), UINT32_C(0xFA6E3E27),
            UINT32_C(0x901F342E), UINT32_C(0x896CA082), UINT32_C(0x745C747C) } },
        { { UINT32_C(0x2944EC84), UINT32_C(0xDBCCD575), UINT32_C(0xA5FF65FE),
            UINT32_C(0x54A2A935), UINT32_C(0x1A1319B6), UINT32_C(0x88C92A5E),
            UINT32_C(0x82DA96C1), UINT32_C(0x9537C28F), UINT32_C(0x35F93C46),
            UINT32_C(0xB6836474), UINT32_C(0x65B0846C), UINT32_C(0xEC526A1D) },
          { UINT32_C(0xF382C412), UINT32_C(0x6F12AFBD), UINT32_C(0x9E99FA06),
            UINT32_C(0x5EBC81D8), UINT32_C(0x869B93BD), UINT32_C(0x97B5D672),
            UINT32_C(0x377E12AA), UINT32_C(0x2983C310), UINT32_C(0x24D681EA),
            UINT32_C(0x48759681), UINT32_C(0x287FD767), UINT32_C(0x1E0BD106) } },
        { { UINT32_C(0x7231247F), UINT32_C(0x0AC75A3E), UINT32_C(0xEF27AD3A),
            UINT32_C(0x65C20DE6), UINT32_C(0xBD02EEE5), UINT32_C(0x87EB6CF1),
            UINT32_C(0x00147E03), UINT32_C(0x264ACA7A), UINT32_C(0xAE2A9437),
            UINT32_C(0xEBC78581), UINT32_C(0x6316BFA5), UINT32_C(0x9929964E) },
          { UINT32_C(0x9AF207EF), UINT32_C(0xDC09E040), UINT32_C(0x0C9D8658),
            UINT32_C(0x3ECFFE2D), UINT32_C(0xDFB43D38), UINT32_C(0x547EA735),
            UINT32_C(0xD04B1B20), UINT32_C(0x5485247B), UINT32_C(0xBFD8B609),
            UINT32_C(0xB18D3F02), UINT32_C(0xCCE73705), UINT32_C(0xEEB3E805) } },
        { { UINT32_C(0xDB93850F), UINT32_C(0xDAB1A525), UINT32_C(0x8365B7D5),
            UINT32_C(0x18ADAA23), UINT32_C(0x113FC8C7), UINT32_C(0x58485C90),
            UINT32_C(0x348AD323), UINT32_C(0x80C3DBB9), UINT32_C(0xE16ADCA1),
            UINT32_C(0xAF892FB5), UINT32_C(0x979F005A), UINT32_C(0x2183C879) },
          { UINT32_C(0x0643A99E), UINT32_C(0x20FA1A94), UINT32_C(0x1A1609CB),
            UINT32_C(0x2741221C), UINT32_C(0x3C2FBDDC), UINT32_C(0x1C1687E5),
            UINT32_C(0xD420D6CF), UINT32_C(0xDCCF329E), UINT32_C(0x2B7197D1),
            UINT32_C(0x75D5577D), UINT32_C(0xC8729D9C), UINT32_C(0x4C3C3875) } },
        { { UINT32_C(0xE5CBDCB9), UINT32_C(0x5E79F995), UINT32_C(0xA742FCC7),
            UINT32_C(0x03139824), UINT32_C(0x239EF4A1), UINT32_C(0x6D0C214A),
            UINT32_C(0x401A2944), UINT32_C(0x53A27952), UINT32_C(0xC10BCDF0),
            UINT32_C(0xF42A1B34), UINT32_C(0x7CF38061), UINT32_C(0x426BAA43) },
          { UINT32_C(0xA96AD0C8), UINT32_C(0x16A53139), UINT32_C(0x6BAD5301),
            UINT32_C(0x627F1D31), UINT32_C(0x4ACCD627), UINT32_C(0x5AF74877),
            UINT32_C(0xB55B0FB8), UINT32_C(0x3C58A1C5), UINT32_C(0xF4399A6A),
            UINT32_C(0xFAA57B91), UINT32_C(0xC28094B8), UINT32_C(0xBAD283FB) } },
        { { UINT32_C(0x83E10A93), UINT32_C(0xBA32AC61), UINT32_C(0xEC06BDB0),
            UINT32_C(0x1C91F6B4), UINT32_C(0x65F60C93), UINT32_C(0x42E6CFBC),
            UINT32_C(0x2C0CDCBE), UINT32_C(0xEFE33BC8), UINT32_C(0x4D6414F2),
            UINT32_C(0xE0FE1D09), UINT32_C(0x76FA5C5B), UINT32_C(0x4C112316) },
          { UINT32_C(0x2E26200A), UINT32_C(0x812C1DC6), UINT32_C(0xEE879D25),
            UINT32_C(0xD6C413C5), UINT32_C(0xBCA8BAFE), UINT32_C(0xBEADE255),
            UINT32_C(0xCE2BA0E7), UINT32_C(0x0EAF4AE2), UINT32_C(0xC4F4408A),
            UINT32_C(0x66E9FFB0), UINT32_C(0x9782C7AD), UINT32_C(0xB36A86D7) } },
        { { UINT32_C(0xBAD8D1C7), UINT32_C(0x10FCD1F4), UINT32_C(0x4502F645),
            UINT32_C(0xC903816A), UINT32_C(0xA503B895), UINT32_C(0x7FAC1CC1),
            UINT32_C(0x0778900C), UINT32_C(0x8BCD6041), UINT32_C(0x5BCF2784),
            UINT32_C(0x5A5F2202), UINT32_C(0x10EDB896), UINT32_C(0x9B157E87) },
          { UINT32_C(0xF602A8B1), UINT32_C(0x4C58DA69), UINT32_C(0x59EC9D7E),
            UINT32_C(0xD55132F8), UINT32_C(0xA26D4870), UINT32_C(0x155B719A),
            UINT32_C(0x36441746), UINT32_C(0x25AAFCA3), UINT32_C(0xDD3B6B30),
            UINT32_C(0x01F83338), UINT32_C(0x551917CC), UINT32_C(0xD52BB5C1) } },
        { { UINT32_C(0x6135066A), UINT32_C(0xA0B6207B), UINT32_C(0x2AEC8CBD),
            UINT32_C(0xB3409F84), UINT32_C(0x19D87DF0), UINT32_C(0x5EBFD436),
            UINT32_C(0xE8526DE2), UINT32_C(0xCB4C209B), UINT32_C(0x21E1A230),
            UINT32_C(0xD764085B), UINT32_C(0x0899964A), UINT32_C(0x96F91554) },
          { UINT32_C(0xA57D122A), UINT32_C(0xB0BEC8EF), UINT32_C(0x5D9D0B33),
            UINT32_C(0xC572EC56), UINT32_C(0xCFA7C72C), UINT32_C(0xEBE2A780),
            UINT32_C(0x9EF3295C), UINT32_C(0x52D40CDB), UINT32_C(0x0DE74DFE),
            UINT32_C(0x64004584), UINT32_C(0xC0809716), UINT32_C(0xA6846432) } },
        { { UINT32_C(0x02C979BC), UINT32_C(0x0D09E8CD), UINT32_C(0x409F4F2A),
            UINT32_C(0xEC4B21F6), UINT32_C(0x13FB07CA), UINT32_C(0x68125C70),
            UINT32_C(0x6FDFA72A), UINT32_C(0x1C4CFC17), UINT32_C(0x04539FCD),
            UINT32_C(0xC9E71B9E), UINT32_C(0x8BA70797), UINT32_C(0x94B7103D) },
          { UINT32_C(0xB33FDE83), UINT32_C(0x6B81E82F), UINT32_C(0xEABAFD4B),
            UINT32_C(0x7CA9A8CA), UINT32_C(0xEAB819CE), UINT32_C(0xADD85A67),
            UINT32_C(0x98E99FFC), UINT32_C(0xAEC25483), UINT32_C(0x274A07B6),
            UINT32_C(0x938D6440), UINT32_C(0x564A6AA0), UINT32_C(0x0A5C7097) } },
        { { UINT32_C(0x2F4FCEB6), UINT32_C(0x7284FF50), UINT32_C(0x78D0D5CB),
            UINT32_C(0x0A28715A), UINT32_C(0xBFCE187C), UINT32_C(0xE70B7014),
            UINT32_C(0x7A17148D), UINT32_C(0xA6B538F5), UINT32_C(0xDD427166),
            UINT32_C(0x1DAB07C9), UINT32_C(0x149D23CA), UINT32_C(0x5C5578B0) },
          { UINT32_C(0x875B5EDE), UINT32_C(0x875E2056), UINT32_C(0x02C893B9),
            UINT32_C(0xCBF44B6D), UINT32_C(0x5C2993FB), UINT32_C(0x5715A77E),
            UINT32_C(0x3410597E), UINT32_C(0xAF328146), UINT32_C(0x42DC49DF),
            UINT32_C(0x65DF418F), UINT32_C(0xA9EE52F6), UINT32_C(0x7AC9C720) } },
        { { UINT32_C(0x62955486), UINT32_C(0xB1C9AA07), UINT32_C(0x245061D7),
            UINT32_C(0xCBF35BE3), UINT32_C(0x8CF4DDC0), UINT32_C(0x811E1BD3),
            UINT32_C(0x948F7C84), UINT32_C(0xD9D4589C), UINT32_C(0xCB0F996D),
            UINT32_C(0x30D09A0F), UINT32_C(0x590E7704), UINT32_C(0x1A1B3B7A) },
          { UINT32_C(0x2082768D), UINT32_C(0xA848E349), UINT32_C(0x9A249DF4),
            UINT32_C(0x9FEBD492), UINT32_C(0x5F20439A), UINT32_C(0x503420AF),
            UINT32_C(0x8E2BFCD4), UINT32_C(0x0CBE52B6), UINT32_C(0x118C91B2),
            UINT32_C(0xB1D5E261), UINT32_C(0x71D8F2BC), UINT32_C(0x93CFF6DA) } },
        { { UINT32_C(0x8AB58944), UINT32_C(0x5F5BC06B), UINT32_C(0x4979882D),
            UINT32_C(0xE4BED538), UINT32_C(0xD79B0EB1), UINT32_C(0x57C30362),
            UINT32_C(0xEF7C56D8), UINT32_C(0x391AE2C1), UINT32_C(0xADD98625),
            UINT32_C(0x28BC2E97), UINT32_C(0x1B257107), UINT32_C(0xFA8E86B8) },
          { UINT32_C(0x6118C715), UINT32_C(0x5E4859F8), UINT32_C(0x524C71DD),
            UINT32_C(0x91C83324), UINT32_C(0x6D2F5E6D), UINT32_C(0xFB209243),
            UINT32_C(0x2A900A43), UINT32_C(0x6B4FE21F), UINT32_C(0x32A73C1F),
            UINT32_C(0x241F75D6), UINT32_C(0x5AE89613), UINT32_C(0xF5BC4629) } },
    }
};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 6
 * ASSERT: a = -3
 */
static void
point_double(pt_prj_t *Q, const pt_prj_t *P)
{
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_secp384r1_square(t0, X);
    fiat_secp384r1_square(t1, Y);
    fiat_secp384r1_square(t2, Z);
    fiat_secp384r1_mul(t3, X, Y);
    fiat_secp384r1_add(t3, t3, t3);
    fiat_secp384r1_mul(t4, Y, Z);
    fiat_secp384r1_mul(Z3, X, Z);
    fiat_secp384r1_add(Z3, Z3, Z3);
    fiat_secp384r1_mul(Y3, b, t2);
    fiat_secp384r1_sub(Y3, Y3, Z3);
    fiat_secp384r1_add(X3, Y3, Y3);
    fiat_secp384r1_add(Y3, X3, Y3);
    fiat_secp384r1_sub(X3, t1, Y3);
    fiat_secp384r1_add(Y3, t1, Y3);
    fiat_secp384r1_mul(Y3, X3, Y3);
    fiat_secp384r1_mul(X3, X3, t3);
    fiat_secp384r1_add(t3, t2, t2);
    fiat_secp384r1_add(t2, t2, t3);
    fiat_secp384r1_mul(Z3, b, Z3);
    fiat_secp384r1_sub(Z3, Z3, t2);
    fiat_secp384r1_sub(Z3, Z3, t0);
    fiat_secp384r1_add(t3, Z3, Z3);
    fiat_secp384r1_add(Z3, Z3, t3);
    fiat_secp384r1_add(t3, t0, t0);
    fiat_secp384r1_add(t0, t3, t0);
    fiat_secp384r1_sub(t0, t0, t2);
    fiat_secp384r1_mul(t0, t0, Z3);
    fiat_secp384r1_add(Y3, Y3, t0);
    fiat_secp384r1_add(t0, t4, t4);
    fiat_secp384r1_mul(Z3, t0, Z3);
    fiat_secp384r1_sub(X3, X3, Z3);
    fiat_secp384r1_mul(Z3, t0, t1);
    fiat_secp384r1_add(Z3, Z3, Z3);
    fiat_secp384r1_add(Z3, Z3, Z3);
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed.op3
 * https://eprint.iacr.org/2015/1060 Alg 5
 * ASSERT: a = -3
 */
static void
point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P)
{
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_secp384r1_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_secp384r1_mul(t0, X1, X2);
    fiat_secp384r1_mul(t1, Y1, Y2);
    fiat_secp384r1_add(t3, X2, Y2);
    fiat_secp384r1_add(t4, X1, Y1);
    fiat_secp384r1_mul(t3, t3, t4);
    fiat_secp384r1_add(t4, t0, t1);
    fiat_secp384r1_sub(t3, t3, t4);
    fiat_secp384r1_mul(t4, Y2, Z1);
    fiat_secp384r1_add(t4, t4, Y1);
    fiat_secp384r1_mul(Y3, X2, Z1);
    fiat_secp384r1_add(Y3, Y3, X1);
    fiat_secp384r1_mul(Z3, b, Z1);
    fiat_secp384r1_sub(X3, Y3, Z3);
    fiat_secp384r1_add(Z3, X3, X3);
    fiat_secp384r1_add(X3, X3, Z3);
    fiat_secp384r1_sub(Z3, t1, X3);
    fiat_secp384r1_add(X3, t1, X3);
    fiat_secp384r1_mul(Y3, b, Y3);
    fiat_secp384r1_add(t1, Z1, Z1);
    fiat_secp384r1_add(t2, t1, Z1);
    fiat_secp384r1_sub(Y3, Y3, t2);
    fiat_secp384r1_sub(Y3, Y3, t0);
    fiat_secp384r1_add(t1, Y3, Y3);
    fiat_secp384r1_add(Y3, t1, Y3);
    fiat_secp384r1_add(t1, t0, t0);
    fiat_secp384r1_add(t0, t1, t0);
    fiat_secp384r1_sub(t0, t0, t2);
    fiat_secp384r1_mul(t1, t4, Y3);
    fiat_secp384r1_mul(t2, t0, Y3);
    fiat_secp384r1_mul(Y3, X3, Z3);
    fiat_secp384r1_add(Y3, Y3, t2);
    fiat_secp384r1_mul(X3, t3, X3);
    fiat_secp384r1_sub(X3, X3, t1);
    fiat_secp384r1_mul(Z3, t4, Z3);
    fiat_secp384r1_mul(t1, t3, t0);
    fiat_secp384r1_add(Z3, Z3, t1);

    /* if P is inf, throw all that away and take Q */
    fiat_secp384r1_selectznz(R->X, nz, Q->X, X3);
    fiat_secp384r1_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_secp384r1_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 4
 * ASSERT: a = -3
 */
static void
point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P)
{
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_secp384r1_mul(t0, X1, X2);
    fiat_secp384r1_mul(t1, Y1, Y2);
    fiat_secp384r1_mul(t2, Z1, Z2);
    fiat_secp384r1_add(t3, X1, Y1);
    fiat_secp384r1_add(t4, X2, Y2);
    fiat_secp384r1_mul(t3, t3, t4);
    fiat_secp384r1_add(t4, t0, t1);
    fiat_secp384r1_sub(t3, t3, t4);
    fiat_secp384r1_add(t4, Y1, Z1);
    fiat_secp384r1_add(t5, Y2, Z2);
    fiat_secp384r1_mul(t4, t4, t5);
    fiat_secp384r1_add(t5, t1, t2);
    fiat_secp384r1_sub(t4, t4, t5);
    fiat_secp384r1_add(X3, X1, Z1);
    fiat_secp384r1_add(Y3, X2, Z2);
    fiat_secp384r1_mul(X3, X3, Y3);
    fiat_secp384r1_add(Y3, t0, t2);
    fiat_secp384r1_sub(Y3, X3, Y3);
    fiat_secp384r1_mul(Z3, b, t2);
    fiat_secp384r1_sub(X3, Y3, Z3);
    fiat_secp384r1_add(Z3, X3, X3);
    fiat_secp384r1_add(X3, X3, Z3);
    fiat_secp384r1_sub(Z3, t1, X3);
    fiat_secp384r1_add(X3, t1, X3);
    fiat_secp384r1_mul(Y3, b, Y3);
    fiat_secp384r1_add(t1, t2, t2);
    fiat_secp384r1_add(t2, t1, t2);
    fiat_secp384r1_sub(Y3, Y3, t2);
    fiat_secp384r1_sub(Y3, Y3, t0);
    fiat_secp384r1_add(t1, Y3, Y3);
    fiat_secp384r1_add(Y3, t1, Y3);
    fiat_secp384r1_add(t1, t0, t0);
    fiat_secp384r1_add(t0, t1, t0);
    fiat_secp384r1_sub(t0, t0, t2);
    fiat_secp384r1_mul(t1, t4, Y3);
    fiat_secp384r1_mul(t2, t0, Y3);
    fiat_secp384r1_mul(Y3, X3, Z3);
    fiat_secp384r1_add(Y3, Y3, t2);
    fiat_secp384r1_mul(X3, t3, X3);
    fiat_secp384r1_sub(X3, X3, t1);
    fiat_secp384r1_mul(Z3, t4, Z3);
    fiat_secp384r1_mul(t1, t3, t0);
    fiat_secp384r1_add(Z3, Z3, t1);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void
precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P)
{
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int
scalar_get_bit(const unsigned char in[48], int idx)
{
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 48)
        return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void
scalar_rwnaf(int8_t out[77], const unsigned char in[48])
{
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 76; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void
scalar_wnaf(int8_t out[385], const unsigned char in[48])
{
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 385; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simulateous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void
var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[48],
                  const unsigned char b[48], const pt_aff_t *P)
{
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[385] = { 0 };
    int8_t bnaf[385] = { 0 };
    pt_prj_t Q;
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 384; i >= 0; i--) {
        if (!is_inf)
            point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_secp384r1_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_secp384r1_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_secp384r1_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_secp384r1_inv(Q.Z, Q.Z);
    fiat_secp384r1_mul(out->X, Q.X, Q.Z);
    fiat_secp384r1_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void
var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[48],
               const pt_aff_t *P)
{
    int i, j, d, diff, is_neg;
    int8_t rnaf[77] = { 0 };
    pt_prj_t Q, lut;
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
/* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[76] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_secp384r1_selectznz(Q.X, diff, Q.X, precomp[j].X);
        fiat_secp384r1_selectznz(Q.Y, diff, Q.Y, precomp[j].Y);
        fiat_secp384r1_selectznz(Q.Z, diff, Q.Z, precomp[j].Z);
    }

    for (i = 75; i >= 0; i--) {
        for (j = 0; j < RADIX; j++)
            point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_secp384r1_selectznz(lut.X, diff, lut.X, precomp[j].X);
            fiat_secp384r1_selectznz(lut.Y, diff, lut.Y, precomp[j].Y);
            fiat_secp384r1_selectznz(lut.Z, diff, lut.Z, precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_secp384r1_opp(out->Y, lut.Y);
        fiat_secp384r1_selectznz(lut.Y, is_neg, lut.Y, out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_secp384r1_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_secp384r1_selectznz(Q.X, scalar[0] & 1, lut.X, Q.X);
    fiat_secp384r1_selectznz(Q.Y, scalar[0] & 1, lut.Y, Q.Y);
    fiat_secp384r1_selectznz(Q.Z, scalar[0] & 1, lut.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_secp384r1_inv(Q.Z, Q.Z);
    fiat_secp384r1_mul(out->X, Q.X, Q.Z);
    fiat_secp384r1_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void
fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[48])
{
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[77] = { 0 };
    pt_prj_t Q, R;
    pt_aff_t lut;

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
/* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 3; i >= 0; i--) {
        for (j = 0; i != 3 && j < RADIX; j++)
            point_double(&Q, &Q);
        for (j = 0; j < 21; j++) {
            if (j * 4 + i > 76)
                continue;
            d = rnaf[j * 4 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_secp384r1_selectznz(lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_secp384r1_selectznz(lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_secp384r1_opp(out->Y, lut.Y);
            fiat_secp384r1_selectznz(lut.Y, is_neg, lut.Y, out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_secp384r1_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_secp384r1_selectznz(Q.X, scalar[0] & 1, R.X, Q.X);
    fiat_secp384r1_selectznz(Q.Y, scalar[0] & 1, R.Y, Q.Y);
    fiat_secp384r1_selectznz(Q.Z, scalar[0] & 1, R.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_secp384r1_inv(Q.Z, Q.Z);
    fiat_secp384r1_mul(out->X, Q.X, Q.Z);
    fiat_secp384r1_mul(out->Y, Q.Y, Q.Z);
}

static void
point_mul_two(unsigned char outx[48], unsigned char outy[48],
              const unsigned char a[48], const unsigned char b[48],
              const unsigned char inx[48],
              const unsigned char iny[48])
{
    pt_aff_t P;

    fiat_secp384r1_from_bytes(P.X, inx);
    fiat_secp384r1_from_bytes(P.Y, iny);
    fiat_secp384r1_to_montgomery(P.X, P.X);
    fiat_secp384r1_to_montgomery(P.Y, P.Y);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_secp384r1_from_montgomery(P.X, P.X);
    fiat_secp384r1_from_montgomery(P.Y, P.Y);
    fiat_secp384r1_to_bytes(outx, P.X);
    fiat_secp384r1_to_bytes(outy, P.Y);
}

static void
point_mul_g(unsigned char outx[48], unsigned char outy[48],
            const unsigned char scalar[48])
{
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_secp384r1_from_montgomery(P.X, P.X);
    fiat_secp384r1_from_montgomery(P.Y, P.Y);
    fiat_secp384r1_to_bytes(outx, P.X);
    fiat_secp384r1_to_bytes(outy, P.Y);
}

static void
point_mul(unsigned char outx[48], unsigned char outy[48],
          const unsigned char scalar[48],
          const unsigned char inx[48],
          const unsigned char iny[48])
{
    pt_aff_t P;

    fiat_secp384r1_from_bytes(P.X, inx);
    fiat_secp384r1_from_bytes(P.Y, iny);
    fiat_secp384r1_to_montgomery(P.X, P.X);
    fiat_secp384r1_to_montgomery(P.Y, P.Y);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_secp384r1_from_montgomery(P.X, P.X);
    fiat_secp384r1_from_montgomery(P.Y, P.Y);
    fiat_secp384r1_to_bytes(outx, P.X);
    fiat_secp384r1_to_bytes(outy, P.Y);
}

#undef RADIX
#include "ecp.h"
#include "mplogic.h"

/*-
 * reverse bytes -- total hack
 */
#define MP_BE2LE(a)            \
    do {                       \
        unsigned char z_bswap; \
        z_bswap = a[0];        \
        a[0] = a[47];          \
        a[47] = z_bswap;       \
        z_bswap = a[1];        \
        a[1] = a[46];          \
        a[46] = z_bswap;       \
        z_bswap = a[2];        \
        a[2] = a[45];          \
        a[45] = z_bswap;       \
        z_bswap = a[3];        \
        a[3] = a[44];          \
        a[44] = z_bswap;       \
        z_bswap = a[4];        \
        a[4] = a[43];          \
        a[43] = z_bswap;       \
        z_bswap = a[5];        \
        a[5] = a[42];          \
        a[42] = z_bswap;       \
        z_bswap = a[6];        \
        a[6] = a[41];          \
        a[41] = z_bswap;       \
        z_bswap = a[7];        \
        a[7] = a[40];          \
        a[40] = z_bswap;       \
        z_bswap = a[8];        \
        a[8] = a[39];          \
        a[39] = z_bswap;       \
        z_bswap = a[9];        \
        a[9] = a[38];          \
        a[38] = z_bswap;       \
        z_bswap = a[10];       \
        a[10] = a[37];         \
        a[37] = z_bswap;       \
        z_bswap = a[11];       \
        a[11] = a[36];         \
        a[36] = z_bswap;       \
        z_bswap = a[12];       \
        a[12] = a[35];         \
        a[35] = z_bswap;       \
        z_bswap = a[13];       \
        a[13] = a[34];         \
        a[34] = z_bswap;       \
        z_bswap = a[14];       \
        a[14] = a[33];         \
        a[33] = z_bswap;       \
        z_bswap = a[15];       \
        a[15] = a[32];         \
        a[32] = z_bswap;       \
        z_bswap = a[16];       \
        a[16] = a[31];         \
        a[31] = z_bswap;       \
        z_bswap = a[17];       \
        a[17] = a[30];         \
        a[30] = z_bswap;       \
        z_bswap = a[18];       \
        a[18] = a[29];         \
        a[29] = z_bswap;       \
        z_bswap = a[19];       \
        a[19] = a[28];         \
        a[28] = z_bswap;       \
        z_bswap = a[20];       \
        a[20] = a[27];         \
        a[27] = z_bswap;       \
        z_bswap = a[21];       \
        a[21] = a[26];         \
        a[26] = z_bswap;       \
        z_bswap = a[22];       \
        a[22] = a[25];         \
        a[25] = z_bswap;       \
        z_bswap = a[23];       \
        a[23] = a[24];         \
        a[24] = z_bswap;       \
    } while (0)

static mp_err
point_mul_g_secp384r1(const mp_int *n, mp_int *out_x,
                      mp_int *out_y, const ECGroup *group)
{
    unsigned char b_x[48];
    unsigned char b_y[48];
    unsigned char b_n[48];
    mp_err res;

    ARGCHK(n != NULL && out_x != NULL && out_y != NULL, MP_BADARG);

    /* fail on out of range scalars */
    if (mpl_significant_bits(n) > 384 || mp_cmp_z(n) != 1)
        return MP_RANGE;

    MP_CHECKOK(mp_to_fixlen_octets(n, b_n, 48));
    MP_BE2LE(b_n);
    point_mul_g(b_x, b_y, b_n);
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_CHECKOK(mp_read_unsigned_octets(out_x, b_x, 48));
    MP_CHECKOK(mp_read_unsigned_octets(out_y, b_y, 48));

CLEANUP:
    return res;
}

static mp_err
point_mul_secp384r1(const mp_int *n, const mp_int *in_x,
                    const mp_int *in_y, mp_int *out_x,
                    mp_int *out_y, const ECGroup *group)
{
    unsigned char b_x[48];
    unsigned char b_y[48];
    unsigned char b_n[48];
    mp_err res;

    ARGCHK(n != NULL && in_x != NULL && in_y != NULL && out_x != NULL &&
               out_y != NULL,
           MP_BADARG);

    /* fail on out of range scalars */
    if (mpl_significant_bits(n) > 384 || mp_cmp_z(n) != 1)
        return MP_RANGE;

    MP_CHECKOK(mp_to_fixlen_octets(n, b_n, 48));
    MP_CHECKOK(mp_to_fixlen_octets(in_x, b_x, 48));
    MP_CHECKOK(mp_to_fixlen_octets(in_y, b_y, 48));
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_BE2LE(b_n);
    point_mul(b_x, b_y, b_n, b_x, b_y);
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_CHECKOK(mp_read_unsigned_octets(out_x, b_x, 48));
    MP_CHECKOK(mp_read_unsigned_octets(out_y, b_y, 48));

CLEANUP:
    return res;
}

static mp_err
point_mul_two_secp384r1(const mp_int *n1, const mp_int *n2,
                        const mp_int *in_x, const mp_int *in_y,
                        mp_int *out_x, mp_int *out_y,
                        const ECGroup *group)
{
    unsigned char b_x[48];
    unsigned char b_y[48];
    unsigned char b_n1[48];
    unsigned char b_n2[48];
    mp_err res;

    /* If n2 == NULL, this is just a base-point multiplication. */
    if (n2 == NULL)
        return point_mul_g_secp384r1(n1, out_x, out_y, group);

    /* If n1 == NULL, this is just an arbitary-point multiplication. */
    if (n1 == NULL)
        return point_mul_secp384r1(n2, in_x, in_y, out_x, out_y, group);

    ARGCHK(in_x != NULL && in_y != NULL && out_x != NULL && out_y != NULL,
           MP_BADARG);

    /* fail on out of range scalars */
    if (mpl_significant_bits(n1) > 384 || mp_cmp_z(n1) != 1 ||
        mpl_significant_bits(n2) > 384 || mp_cmp_z(n2) != 1)
        return MP_RANGE;

    MP_CHECKOK(mp_to_fixlen_octets(n1, b_n1, 48));
    MP_CHECKOK(mp_to_fixlen_octets(n2, b_n2, 48));
    MP_CHECKOK(mp_to_fixlen_octets(in_x, b_x, 48));
    MP_CHECKOK(mp_to_fixlen_octets(in_y, b_y, 48));
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_BE2LE(b_n1);
    MP_BE2LE(b_n2);
    point_mul_two(b_x, b_y, b_n1, b_n2, b_x, b_y);
    MP_BE2LE(b_x);
    MP_BE2LE(b_y);
    MP_CHECKOK(mp_read_unsigned_octets(out_x, b_x, 48));
    MP_CHECKOK(mp_read_unsigned_octets(out_y, b_y, 48));

CLEANUP:
    return res;
}

mp_err
ec_group_set_secp384r1(ECGroup *group, ECCurveName name)
{
    if (name == ECCurve_NIST_P384) {
        group->base_point_mul = &point_mul_g_secp384r1;
        group->point_mul = &point_mul_secp384r1;
        group->points_mul = &point_mul_two_secp384r1;
    }
    return MP_OKAY;
}

#endif /* __SIZEOF_INT128__ */
