% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readLogRatioFile.R
\name{readLogRatioFile}
\alias{readLogRatioFile}
\title{Read file containing interval-level log2 tumor/normal ratios}
\usage{
readLogRatioFile(file, format, zero = NULL)
}
\arguments{
\item{file}{Log2 coverage file.}

\item{format}{File format. If missing, derived from the file 
extension. Currently GATK4 DenoiseReadCounts format supported.
A simple GATK3-style format, two columns with coordinates
as string in format chr:start-stop in first and log2-ratio
in second is also supported.}

\item{zero}{Start position is 0-based. Default is \code{FALSE}
for GATK, \code{TRUE} for BED file based intervals.}
}
\value{
A \code{GRange} with the log2 ratio.
}
\description{
Read log2 ratio file produced by external tools like The Genome Analysis 
Toolkit version 4.
}
\examples{

logratio.file <- system.file("extdata", "example_gatk4_denoised_cr.tsv.gz",
    package = "PureCN")
logratio <- readLogRatioFile(logratio.file)

}
\author{
Markus Riester
}
