% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_references}
\alias{find_references}
\alias{assert_no_references}
\title{Get first or all references of an \R object}
\usage{
find_references(x, first_only = FALSE)

assert_no_references(x, action = c("error", "warning", "message", "string"))
}
\arguments{
\item{x}{The \R object to be checked.}

\item{first_only}{If \code{TRUE}, only the first reference is returned,
otherwise all references.}

\item{action}{Type of action to take if a reference is found.}
}
\value{
\code{find_references()} returns a list of one or more references
identified.

If a reference is detected, an informative error, warning, message,
or a character string is produced, otherwise \code{NULL} is returned
invisibly.
}
\description{
Get first or all references of an \R object

Assert that there are no references among the identified globals
}
\keyword{internal}
