.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
unknownpleasures \- a waterfall graph of the signal from pulsar PSR B1919+21.
.SH SYNOPSIS
.B unknownpleasures
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-count \fInumber\fP]
[\-speed \fInumber\fP]
[\-resolution \fInumber\fP]
[\-amplitude \fInumber\fP]
[\-noise \fInumber\fP]
[\-mask \fIfile\fP]
[\-no-ortho]
[\-buzz]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
PSR B1919+21 (AKA CP 1919) was the first pulsar ever discovered: a spinning
neutron star emitting a periodic lighthouse-like beacon. An illustration of
the signal received from it was published in Scientific American in 1971,
and later in The Cambridge Encyclopedia of Astronomy in 1977, where it was
seen by Stephen Morris, the drummer of Joy Division, and was consequently
appropriated by Peter Saville for the cover of the band's album "Unknown
Pleasures".
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 30000 (0.03 seconds).
.TP 8
.B \-speed \fInumber\fP
Animation speed. 2 for twice as fast, 0.5 for half as fast.
.TP 8
.B \-count \fInumber\fP
Scanlines (vertical resolution).  Default: 80.
.TP 8
.B \-resolution \fInumber\fP
Horizontal Resolution, Default: 100.
.TP 8
.B \-amplitude \fInumber\fP
Height of the waves, 0 - 1.0.  Default: 0.13.
.TP 8
.B \-noise \fInumber\fP
How noisy the signal is. 2 for twice as noisy, 0.5 for half as noisy.
.TP 8
.B \-mask \fIfile\fP
Use the given image file as a clipping mask against the data.
A high contrast image of around 256x256 works best.
Signal peaks appear in the dark areas.
.TP 8
.B \-ortho | \-no-ortho
Whether to use an orthographic projection.
.TP 8
.B \-buzz | \-no-buzz
Whether each line should seethe with noise.
.TP 8
.B \-wireframe | \-no-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps | \-no-fps
Whether to show a frames-per-second display at the bottom of the screen.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2013-2018 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Jamie Zawinski.
