import numpy
from numpy import array, nan, inf

version = '1.7.0'
cuda    = '7.0'
device  = 'Kepler K40c'
cpu     = '2x8 core Sandy Bridge E5-2670'

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/cgeev.txt
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# numactl --interleave=all ../testing/testing_cgeev -RN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_cgeev -RN -N 123 -N 1234 --range 12000:20000:2000
cgeev_RN = array([
	[    10,    0.00,   0.00,  0.00e+00,  nan ],
	[    20,    0.00,   0.00,  0.00e+00,  nan ],
	[    30,    0.00,   0.00,  0.00e+00,  nan ],
	[    40,    0.00,   0.00,  5.78e-07,  nan ],
	[    50,    0.00,   0.00,  6.13e-07,  nan ],
	[    60,    0.00,   0.00,  5.56e-07,  nan ],
	[    70,    0.00,   0.01,  8.93e-07,  nan ],
	[    80,    0.00,   0.01,  7.82e-07,  nan ],
	[    90,    0.01,   0.01,  8.22e-07,  nan ],
	[   100,    0.01,   0.01,  8.21e-07,  nan ],
	[   200,    0.04,   0.04,  1.24e-06,  nan ],
	[   300,    0.08,   0.09,  1.50e-06,  nan ],
	[   400,    0.15,   0.14,  1.22e-06,  nan ],
	[   500,    0.20,   0.20,  1.28e-06,  nan ],
	[   600,    0.38,   0.37,  1.53e-06,  nan ],
	[   700,    0.52,   0.46,  1.65e-06,  nan ],
	[   800,    0.63,   0.58,  1.72e-06,  nan ],
	[   900,    0.74,   0.69,  1.73e-06,  nan ],
	[  1000,    0.87,   0.76,  1.60e-06,  nan ],
	[  2000,    2.83,   2.44,  1.82e-06,  nan ],
	[  3000,    8.89,   7.09,  2.26e-06,  nan ],
	[  4000,   16.12,  11.30,  2.45e-06,  nan ],
	[  5000,   25.76,  16.63,  2.59e-06,  nan ],
	[  6000,   48.45,  31.16,  2.91e-06,  nan ],
	[  7000,   63.08,  40.99,  2.86e-06,  nan ],
	[  8000,   89.21,  54.00,  3.11e-06,  nan ],
	[  9000,  110.29,  66.67,  3.30e-06,  nan ],
	[ 10000,  141.30,  82.52,  3.18e-06,  nan ],
	[ 12000, nan, 178.60, nan, nan ],
	[ 14000, nan, 236.39, nan, nan ],
	[ 16000, nan, 329.59, nan, nan ],
	[ 18000, nan, 404.67, nan, nan ],
	[ 20000, nan, 497.89, nan, nan ],
])

# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# numactl --interleave=all ../testing/testing_cgeev -RV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_cgeev -RV -N 123 -N 1234 --range 12000:20000:2000
cgeev_RV = array([
	[    10,    0.00,    0.00,  0.00e+00,  nan ],
	[    20,    0.00,    0.00,  0.00e+00,  nan ],
	[    30,    0.00,    0.00,  0.00e+00,  nan ],
	[    40,    0.00,    0.00,  5.78e-07,  nan ],
	[    50,    0.00,    0.01,  6.13e-07,  nan ],
	[    60,    0.00,    0.01,  5.56e-07,  nan ],
	[    70,    0.00,    0.01,  8.93e-07,  nan ],
	[    80,    0.01,    0.01,  6.70e-07,  nan ],
	[    90,    0.01,    0.02,  7.91e-07,  nan ],
	[   100,    0.01,    0.02,  8.55e-07,  nan ],
	[   200,    0.06,    0.07,  1.22e-06,  nan ],
	[   300,    0.13,    0.12,  1.44e-06,  nan ],
	[   400,    0.22,    0.19,  1.20e-06,  nan ],
	[   500,    0.45,    0.27,  1.34e-06,  nan ],
	[   600,    0.76,    0.61,  1.61e-06,  nan ],
	[   700,    0.76,    0.80,  1.68e-06,  nan ],
	[   800,    1.33,    0.73,  1.64e-06,  nan ],
	[   900,    1.68,    1.21,  1.73e-06,  nan ],
	[  1000,    2.02,    1.37,  1.59e-06,  nan ],
	[  2000,    7.98,    4.23,  1.77e-06,  nan ],
	[  3000,   26.42,   10.02,  2.23e-06,  nan ],
	[  4000,   54.37,   21.05,  2.47e-06,  nan ],
	[  5000,   93.92,   27.64,  2.58e-06,  nan ],
	[  6000,  172.01,   47.63,  2.84e-06,  nan ],
	[  7000,  257.61,   65.37,  2.80e-06,  nan ],
	[  8000,  342.46,   89.87,  3.03e-06,  nan ],
	[  9000,  468.40,  118.07,  3.32e-06,  nan ],
	[ 10000,  634.63,  150.80,  3.20e-06,  nan ],
	[ 12000, nan, 353.88, nan, nan ],
	[ 14000, nan, 447.28, nan, nan ],
	[ 16000, nan, 537.04, nan, nan ],
	[ 18000, nan, 618.99, nan, nan ],
	[ 20000, nan, 788.43, nan, nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/cgeqrf.txt
# numactl --interleave=all ../testing/testing_cgeqrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
cgeqrf = array([
	[    10,     10,    0.95,   0.00,     0.10,   0.00,  nan ],
	[    20,     20,    2.25,   0.00,     0.70,   0.00,  nan ],
	[    30,     30,    3.34,   0.00,     2.00,   0.00,  nan ],
	[    40,     40,    5.43,   0.00,     3.55,   0.00,  nan ],
	[    50,     50,    7.21,   0.00,     4.98,   0.00,  nan ],
	[    60,     60,    8.80,   0.00,     6.84,   0.00,  nan ],
	[    70,     70,    8.70,   0.00,     2.15,   0.00,  nan ],
	[    80,     80,    9.96,   0.00,     3.25,   0.00,  nan ],
	[    90,     90,   10.16,   0.00,     4.23,   0.00,  nan ],
	[   100,    100,   11.76,   0.00,     5.62,   0.00,  nan ],
	[   200,    200,   32.58,   0.00,    18.37,   0.00,  nan ],
	[   300,    300,   64.83,   0.00,    40.23,   0.00,  nan ],
	[   400,    400,   80.22,   0.00,    62.59,   0.01,  nan ],
	[   500,    500,  117.03,   0.01,    91.59,   0.01,  nan ],
	[   600,    600,  126.75,   0.01,   119.47,   0.01,  nan ],
	[   700,    700,  154.40,   0.01,   152.13,   0.01,  nan ],
	[   800,    800,  174.95,   0.02,   181.93,   0.02,  nan ],
	[   900,    900,  154.50,   0.03,   212.27,   0.02,  nan ],
	[  1000,   1000,  169.70,   0.03,   248.40,   0.02,  nan ],
	[  2000,   2000,  242.98,   0.18,   628.27,   0.07,  nan ],
	[  3000,   3000,  283.53,   0.51,  1022.33,   0.14,  nan ],
	[  4000,   4000,  307.90,   1.11,  1393.10,   0.25,  nan ],
	[  5000,   5000,  325.67,   2.05,  1463.93,   0.46,  nan ],
	[  6000,   6000,  337.92,   3.41,  1682.37,   0.68,  nan ],
	[  7000,   7000,  350.79,   5.22,  1898.26,   0.96,  nan ],
	[  8000,   8000,  339.28,   8.05,  2060.55,   1.33,  nan ],
	[  9000,   9000,  346.87,  11.21,  2157.99,   1.80,  nan ],
	[ 10000,  10000,  380.91,  14.00,  2197.03,   2.43,  nan ],
	[ 12000,  12000,  461.53,  19.97,  2304.19,   4.00,  nan ],
	[ 14000,  14000,  487.87,  30.00,  2377.16,   6.16,  nan ],
	[ 16000,  16000,  561.71,  38.90,  2406.06,   9.08,  nan ],
	[ 18000,  18000,  571.94,  54.39,  2422.45,  12.84,  nan ],
	[ 20000,  20000,  572.84,  74.49,  2463.86,  17.32,  nan ],
])

# numactl --interleave=all ../testing/testing_cgeqrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.17,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.34,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.63,   0.00,  nan ],
	[    60,     60,  nan,  nan,     1.05,   0.00,  nan ],
	[    70,     70,  nan,  nan,     1.19,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.77,   0.00,  nan ],
	[    90,     90,  nan,  nan,     2.57,   0.00,  nan ],
	[   100,    100,  nan,  nan,     7.09,   0.00,  nan ],
	[   200,    200,  nan,  nan,    14.56,   0.00,  nan ],
	[   300,    300,  nan,  nan,    32.63,   0.00,  nan ],
	[   400,    400,  nan,  nan,    54.37,   0.01,  nan ],
	[   500,    500,  nan,  nan,    80.11,   0.01,  nan ],
	[   600,    600,  nan,  nan,   107.18,   0.01,  nan ],
	[   700,    700,  nan,  nan,   139.69,   0.01,  nan ],
	[   800,    800,  nan,  nan,   169.53,   0.02,  nan ],
	[   900,    900,  nan,  nan,   196.62,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,   230.18,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   576.92,   0.07,  nan ],
	[  3000,   3000,  nan,  nan,  1006.21,   0.14,  nan ],
	[  4000,   4000,  nan,  nan,  1384.99,   0.25,  nan ],
	[  5000,   5000,  nan,  nan,  1437.97,   0.46,  nan ],
	[  6000,   6000,  nan,  nan,  1712.34,   0.67,  nan ],
	[  7000,   7000,  nan,  nan,  1721.08,   1.06,  nan ],
	[  8000,   8000,  nan,  nan,  1894.57,   1.44,  nan ],
	[  9000,   9000,  nan,  nan,  2009.84,   1.93,  nan ],
	[ 10000,  10000,  nan,  nan,  2189.48,   2.44,  nan ],
	[ 12000,  12000,  nan,  nan,  2301.97,   4.00,  nan ],
	[ 14000,  14000,  nan,  nan,  2364.92,   6.19,  nan ],
	[ 16000,  16000,  nan,  nan,  2395.41,   9.12,  nan ],
	[ 18000,  18000,  nan,  nan,  2417.13,  12.87,  nan ],
	[ 20000,  20000,  nan,  nan,  2462.36,  17.33,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/cgesvd.txt
# numactl --interleave=all ../testing/testing_cgesvd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_cgesvd -UN -VN -N 123 -N 1234 --range 12000:20000:2000
cgesvd_UN = array([
	[ nan,      10,      10,    0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,    0.00,  0.00e+00 ],
	[ nan,     100,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     200,    0.01,    0.02,  1.30e-07 ],
	[ nan,     300,     300,    0.02,    0.04,  1.50e-07 ],
	[ nan,     400,     400,    0.03,    0.07,  1.24e-07 ],
	[ nan,     500,     500,    0.04,    0.10,  1.75e-07 ],
	[ nan,     600,     600,    0.06,    0.14,  1.56e-07 ],
	[ nan,     700,     700,    0.08,    0.18,  2.27e-07 ],
	[ nan,     800,     800,    0.10,    0.22,  2.72e-07 ],
	[ nan,     900,     900,    0.12,    0.25,  1.91e-07 ],
	[ nan,    1000,    1000,    0.15,    0.32,  2.00e-07 ],
	[ nan,    2000,    2000,    0.67,    1.16,  3.61e-07 ],
	[ nan,    3000,    3000,    1.55,    2.98,  1.52e-06 ],
	[ nan,    4000,    4000,    5.87,    5.89,  4.07e-07 ],
	[ nan,    5000,    5000,   12.28,   10.18,  3.51e-07 ],
	[ nan,    6000,    6000,   21.82,   16.15,  5.54e-07 ],
	[ nan,    7000,    7000,   35.05,   23.97,  3.36e-07 ],
	[ nan,    8000,    8000,   52.61,   34.24,  3.42e-07 ],
	[ nan,    9000,    9000,   75.19,   46.96,  7.40e-07 ],
	[ nan,   10000,   10000,  102.26,   62.79,  5.43e-07 ],
	[ nan,     300,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     600,     200,    0.01,    0.02,  7.48e-08 ],
	[ nan,     900,     300,    0.02,    0.04,  7.87e-08 ],
	[ nan,    1200,     400,    0.04,    0.07,  1.47e-07 ],
	[ nan,    1500,     500,    0.06,    0.10,  2.15e-07 ],
	[ nan,    1800,     600,    0.08,    0.15,  1.80e-07 ],
	[ nan,    2100,     700,    0.11,    0.19,  1.34e-07 ],
	[ nan,    2400,     800,    0.14,    0.25,  1.87e-07 ],
	[ nan,    2700,     900,    0.19,    0.33,  2.13e-07 ],
	[ nan,    3000,    1000,    0.24,    0.40,  1.79e-07 ],
	[ nan,    6000,    2000,    1.71,    2.04,  1.61e-07 ],
	[ nan,    9000,    3000,   11.19,    5.15,  3.22e-07 ],
	[ nan,   12000,    4000,   26.94,    9.62,  1.17e-06 ],
	[ nan,   15000,    5000,   54.70,   17.14,  5.65e-07 ],
	[ nan,   18000,    6000,   93.48,   28.11,  7.27e-07 ],
	[ nan,   21000,    7000,  143.16,   41.82,  1.01e-06 ],
	[ nan,   24000,    8000,  209.86,   60.45,  8.53e-07 ],
	[ nan,   27000,    9000,  295.12,   83.58,  2.19e-06 ],
	[ nan,     100,     300,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     600,    0.02,    0.02,  1.03e-07 ],
	[ nan,     300,     900,    0.03,    0.04,  1.10e-07 ],
	[ nan,     400,    1200,    0.05,    0.07,  1.27e-07 ],
	[ nan,     500,    1500,    0.07,    0.11,  1.57e-07 ],
	[ nan,     600,    1800,    0.09,    0.16,  1.83e-07 ],
	[ nan,     700,    2100,    0.13,    0.21,  1.07e-07 ],
	[ nan,     800,    2400,    0.16,    0.27,  1.57e-07 ],
	[ nan,     900,    2700,    0.21,    0.34,  1.83e-07 ],
	[ nan,    1000,    3000,    0.25,    0.41,  1.50e-07 ],
	[ nan,    2000,    6000,    1.80,    1.76,  2.30e-07 ],
	[ nan,    3000,    9000,    3.99,    4.73,  3.80e-07 ],
	[ nan,    4000,   12000,    9.60,    9.72,  2.63e-07 ],
	[ nan,    5000,   15000,   19.30,   17.36,  2.18e-07 ],
	[ nan,    6000,   18000,   33.43,   28.11,  2.46e-07 ],
	[ nan,    7000,   21000,   52.98,   42.42,  4.49e-07 ],
	[ nan,    8000,   24000,   79.01,   61.22,  5.35e-07 ],
	[ nan,    9000,   27000,  112.25,   84.95,  4.14e-07 ],
	[ nan,   10000,     100,    0.02,    0.02,  0.00e+00 ],
	[ nan,   20000,     200,    0.07,    0.08,  8.46e-08 ],
	[ nan,   30000,     300,    0.17,    0.19,  5.86e-08 ],
	[ nan,   40000,     400,    0.47,    0.51,  7.05e-08 ],
	[ nan,   50000,     500,    0.74,    0.80,  1.08e-07 ],
	[ nan,   60000,     600,    1.08,    1.17,  4.72e-08 ],
	[ nan,   70000,     700,    1.51,    1.62,  1.06e-07 ],
	[ nan,   80000,     800,    2.05,    2.23,  1.21e-07 ],
	[ nan,   90000,     900,    3.12,    3.36,  1.54e-07 ],
	[ nan,  100000,    1000,    3.95,    4.21,  1.29e-07 ],
	[ nan,  200000,    2000,   23.28,   24.35,  1.29e-07 ],
	[ nan,     100,   10000,    0.02,    0.02,  0.00e+00 ],
	[ nan,     200,   20000,    0.08,    0.09,  5.71e-08 ],
	[ nan,     300,   30000,    0.19,    0.23,  4.61e-08 ],
	[ nan,     400,   40000,    0.36,    0.44,  1.47e-07 ],
	[ nan,     500,   50000,    0.62,    0.77,  8.09e-08 ],
	[ nan,     600,   60000,    1.01,    1.24,  1.54e-07 ],
	[ nan,     700,   70000,    1.53,    1.88,  1.49e-07 ],
	[ nan,     800,   80000,    2.30,    2.79,  1.48e-07 ],
	[ nan,     900,   90000,    3.65,    3.64,  9.39e-08 ],
	[ nan,    1000,  100000,    5.20,    5.27,  1.54e-07 ],
	[ nan,    2000,  200000,   25.39,   28.38,  1.21e-07 ],
	[ nan,   12000,   12000,     nan,  106.73,       nan ],
	[ nan,   14000,   14000,     nan,  163.70,       nan ],
	[ nan,   16000,   16000,     nan,  248.92,       nan ],
	[ nan,   18000,   18000,     nan,  350.25,       nan ],
	[ nan,   20000,   20000,     nan,  491.48,       nan ],
])

# numactl --interleave=all ../testing/testing_cgesvd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_cgesvd -US -VS -N 123 -N 1234 --range 12000:20000:2000
cgesvd_US = array([
	[ nan,     10,     10,     0.00,     0.00,  0.00e+00 ],
	[ nan,     20,     20,     0.00,     0.00,  0.00e+00 ],
	[ nan,     30,     30,     0.00,     0.00,  0.00e+00 ],
	[ nan,     40,     40,     0.00,     0.00,  0.00e+00 ],
	[ nan,     50,     50,     0.00,     0.00,  0.00e+00 ],
	[ nan,     60,     60,     0.00,     0.00,  0.00e+00 ],
	[ nan,     70,     70,     0.01,     0.01,  0.00e+00 ],
	[ nan,     80,     80,     0.01,     0.01,  0.00e+00 ],
	[ nan,     90,     90,     0.01,     0.01,  0.00e+00 ],
	[ nan,    100,    100,     0.01,     0.02,  0.00e+00 ],
	[ nan,    200,    200,     0.02,     0.02,  4.78e-07 ],
	[ nan,    300,    300,     0.04,     0.06,  5.00e-07 ],
	[ nan,    400,    400,     0.07,     0.10,  5.89e-07 ],
	[ nan,    500,    500,     0.11,     0.16,  5.53e-07 ],
	[ nan,    600,    600,     0.18,     0.23,  6.40e-07 ],
	[ nan,    700,    700,     0.24,     0.31,  7.11e-07 ],
	[ nan,    800,    800,     0.31,     0.40,  6.35e-07 ],
	[ nan,    900,    900,     0.41,     0.51,  7.64e-07 ],
	[ nan,   1000,   1000,     0.50,     0.62,  6.49e-07 ],
	[ nan,   2000,   2000,     2.85,     3.09,  9.92e-07 ],
	[ nan,   3000,   3000,     9.03,     9.15,  9.12e-07 ],
	[ nan,   4000,   4000,    21.36,    19.58,  9.64e-07 ],
	[ nan,   5000,   5000,    45.25,    38.66,  1.06e-06 ],
	[ nan,   6000,   6000,    80.37,    65.48,  1.02e-06 ],
	[ nan,   7000,   7000,   133.55,   109.28,  1.51e-06 ],
	[ nan,   8000,   8000,   187.79,   151.50,  1.81e-06 ],
	[ nan,   9000,   9000,   208.35,   194.46,  2.48e-06 ],
	[ nan,  10000,  10000,   288.63,   248.74,  2.54e-06 ],
	[ nan,    300,    100,     0.02,     0.02,  0.00e+00 ],
	[ nan,    600,    200,     0.03,     0.03,  5.20e-07 ],
	[ nan,    900,    300,     0.06,     0.07,  6.26e-07 ],
	[ nan,   1200,    400,     0.11,     0.14,  7.15e-07 ],
	[ nan,   1500,    500,     0.17,     0.20,  6.32e-07 ],
	[ nan,   1800,    600,     0.31,     0.33,  8.34e-07 ],
	[ nan,   2100,    700,     0.44,     0.49,  8.13e-07 ],
	[ nan,   2400,    800,     0.52,     0.65,  7.50e-07 ],
	[ nan,   2700,    900,     0.66,     0.73,  9.15e-07 ],
	[ nan,   3000,   1000,     0.87,     0.99,  9.86e-07 ],
	[ nan,   6000,   2000,     4.50,     4.85,  1.04e-06 ],
	[ nan,   9000,   3000,    13.96,    13.78,  1.07e-06 ],
	[ nan,  12000,   4000,    31.76,    28.74,  1.30e-06 ],
	[ nan,  15000,   5000,    60.74,    54.77,  1.69e-06 ],
	[ nan,  18000,   6000,   106.04,    93.45,  2.06e-06 ],
	[ nan,  21000,   7000,   177.63,   159.08,  1.91e-06 ],
	[ nan,  24000,   8000,   234.05,   199.00,  2.03e-06 ],
	[ nan,  27000,   9000,   355.26,   291.47,  2.09e-06 ],
	[ nan,    100,    300,     0.03,     0.02,  4.20e-07 ],
	[ nan,    200,    600,     0.07,     0.07,  5.36e-07 ],
	[ nan,    300,    900,     0.19,     0.20,  5.65e-07 ],
	[ nan,    400,   1200,     0.41,     0.42,  7.34e-07 ],
	[ nan,    500,   1500,     0.72,     0.78,  6.67e-07 ],
	[ nan,    600,   1800,     1.22,     1.26,  8.00e-07 ],
	[ nan,    700,   2100,     1.90,     1.98,  7.68e-07 ],
	[ nan,    800,   2400,     2.78,     2.82,  7.37e-07 ],
	[ nan,    900,   2700,     3.81,     3.92,  8.79e-07 ],
	[ nan,   1000,   3000,     5.72,     5.84,  8.38e-07 ],
	[ nan,   2000,   6000,    44.86,    46.25,  1.07e-06 ],
	[ nan,   3000,   9000,   150.61,   150.71,  1.10e-06 ],
	[ nan,   4000,  12000,   342.03,   344.50,  1.65e-06 ],
	[ nan,   5000,  15000,   662.14,   662.29,  1.66e-06 ],
	[ nan,   6000,  18000,  1147.16,  1133.33,  1.67e-06 ],
	[ nan,  12000,  12000,      nan,   423.90,       nan ],
	[ nan,  14000,  14000,      nan,   760.65,       nan ],
	[ nan,  16000,  16000,      nan,  1015.78,       nan ],
	[ nan,  18000,  18000,      nan,  1581.79,       nan ],
	[ nan,  20000,  20000,      nan,  2366.03,       nan ],
])

# numactl --interleave=all ../testing/testing_cgesdd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_cgesdd -UN -VN -N 123 -N 1234 --range 12000:20000:2000
cgesdd_UN = array([
	[ nan,      10,      10,    0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,    0.00,  0.00e+00 ],
	[ nan,     100,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     200,    0.01,    0.02,  1.30e-07 ],
	[ nan,     300,     300,    0.02,    0.03,  1.50e-07 ],
	[ nan,     400,     400,    0.03,    0.06,  1.24e-07 ],
	[ nan,     500,     500,    0.04,    0.08,  1.75e-07 ],
	[ nan,     600,     600,    0.06,    0.12,  1.56e-07 ],
	[ nan,     700,     700,    0.08,    0.15,  2.27e-07 ],
	[ nan,     800,     800,    0.10,    0.20,  2.72e-07 ],
	[ nan,     900,     900,    0.13,    0.24,  1.91e-07 ],
	[ nan,    1000,    1000,    0.16,    0.30,  2.00e-07 ],
	[ nan,    2000,    2000,    0.89,    1.17,  3.61e-07 ],
	[ nan,    3000,    3000,    1.95,    3.00,  1.52e-06 ],
	[ nan,    4000,    4000,    7.57,    5.96,  4.07e-07 ],
	[ nan,    5000,    5000,   15.43,   10.30,  3.51e-07 ],
	[ nan,    6000,    6000,   27.38,   16.29,  5.54e-07 ],
	[ nan,    7000,    7000,   35.62,   24.17,  3.36e-07 ],
	[ nan,    8000,    8000,   53.06,   34.29,  3.42e-07 ],
	[ nan,    9000,    9000,   75.78,   47.02,  7.40e-07 ],
	[ nan,   10000,   10000,  101.69,   62.93,  5.43e-07 ],
	[ nan,     300,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     600,     200,    0.01,    0.02,  7.48e-08 ],
	[ nan,     900,     300,    0.02,    0.04,  7.87e-08 ],
	[ nan,    1200,     400,    0.04,    0.07,  1.47e-07 ],
	[ nan,    1500,     500,    0.06,    0.10,  2.15e-07 ],
	[ nan,    1800,     600,    0.09,    0.16,  1.80e-07 ],
	[ nan,    2100,     700,    0.11,    0.21,  1.34e-07 ],
	[ nan,    2400,     800,    0.14,    0.25,  1.87e-07 ],
	[ nan,    2700,     900,    0.19,    0.33,  2.13e-07 ],
	[ nan,    3000,    1000,    0.24,    0.40,  1.79e-07 ],
	[ nan,    6000,    2000,    1.23,    1.76,  1.61e-07 ],
	[ nan,    9000,    3000,   11.18,    4.70,  3.22e-07 ],
	[ nan,   12000,    4000,   27.02,    9.66,  1.17e-06 ],
	[ nan,   15000,    5000,   54.95,   17.13,  5.49e-07 ],
	[ nan,   18000,    6000,   94.16,   27.53,  6.23e-07 ],
	[ nan,   21000,    7000,  143.80,   41.62,  9.90e-07 ],
	[ nan,   24000,    8000,  217.82,   61.81,  7.25e-07 ],
	[ nan,   27000,    9000,  314.13,   85.02,  2.24e-06 ],
	[ nan,     100,     300,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     600,    0.02,    0.02,  1.03e-07 ],
	[ nan,     300,     900,    0.03,    0.05,  1.10e-07 ],
	[ nan,     400,    1200,    0.05,    0.08,  1.27e-07 ],
	[ nan,     500,    1500,    0.07,    0.11,  1.57e-07 ],
	[ nan,     600,    1800,    0.09,    0.16,  1.83e-07 ],
	[ nan,     700,    2100,    0.13,    0.21,  1.07e-07 ],
	[ nan,     800,    2400,    0.16,    0.27,  1.57e-07 ],
	[ nan,     900,    2700,    0.21,    0.34,  1.83e-07 ],
	[ nan,    1000,    3000,    0.28,    0.42,  1.50e-07 ],
	[ nan,    2000,    6000,    1.77,    2.11,  2.30e-07 ],
	[ nan,    3000,    9000,    4.00,    5.45,  3.80e-07 ],
	[ nan,    4000,   12000,    9.63,    9.77,  2.63e-07 ],
	[ nan,    5000,   15000,   19.23,   17.51,  2.18e-07 ],
	[ nan,    6000,   18000,   33.39,   28.20,  2.46e-07 ],
	[ nan,    7000,   21000,   52.71,   42.55,  4.49e-07 ],
	[ nan,    8000,   24000,   80.01,   62.07,  5.35e-07 ],
	[ nan,    9000,   27000,  111.77,   85.34,  4.14e-07 ],
	[ nan,   10000,     100,    0.02,    0.02,  0.00e+00 ],
	[ nan,   20000,     200,    0.08,    0.08,  8.46e-08 ],
	[ nan,   30000,     300,    0.19,    0.20,  5.86e-08 ],
	[ nan,   40000,     400,    0.47,    0.51,  7.05e-08 ],
	[ nan,   50000,     500,    0.74,    0.80,  1.08e-07 ],
	[ nan,   60000,     600,    1.09,    1.17,  4.72e-08 ],
	[ nan,   70000,     700,    1.51,    1.72,  1.06e-07 ],
	[ nan,   80000,     800,    2.05,    2.23,  1.21e-07 ],
	[ nan,   90000,     900,    3.16,    3.42,  1.54e-07 ],
	[ nan,  100000,    1000,    3.94,    4.18,  1.29e-07 ],
	[ nan,  200000,    2000,   23.55,   24.30,  1.29e-07 ],
	[ nan,     100,   10000,    0.02,    0.02,  0.00e+00 ],
	[ nan,     200,   20000,    0.09,    0.10,  5.71e-08 ],
	[ nan,     300,   30000,    0.20,    0.24,  4.61e-08 ],
	[ nan,     400,   40000,    0.37,    0.44,  1.47e-07 ],
	[ nan,     500,   50000,    0.63,    0.78,  8.09e-08 ],
	[ nan,     600,   60000,    1.02,    1.25,  1.54e-07 ],
	[ nan,     700,   70000,    1.55,    2.06,  1.49e-07 ],
	[ nan,     800,   80000,    2.31,    2.80,  1.48e-07 ],
	[ nan,     900,   90000,    2.88,    3.49,  9.39e-08 ],
	[ nan,    1000,  100000,    3.80,    4.47,  1.54e-07 ],
	[ nan,    2000,  200000,   25.58,   28.61,  1.21e-07 ],
	[ nan,   12000,   12000,     nan,  107.32,       nan ],
	[ nan,   14000,   14000,     nan,  164.24,       nan ],
	[ nan,   16000,   16000,     nan,  249.46,       nan ],
	[ nan,   18000,   18000,     nan,  351.07,       nan ],
	[ nan,   20000,   20000,     nan,  492.59,       nan ],
])

# numactl --interleave=all ../testing/testing_cgesdd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_cgesdd -US -VS -N 123 -N 1234 --range 12000:20000:2000
cgesdd_US = array([
	[ nan,      10,      10,    0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,    0.00,  0.00e+00 ],
	[ nan,     100,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     200,    0.01,    0.02,  1.13e-07 ],
	[ nan,     300,     300,    0.03,    0.05,  9.69e-08 ],
	[ nan,     400,     400,    0.05,    0.08,  1.18e-07 ],
	[ nan,     500,     500,    0.08,    0.12,  7.95e-08 ],
	[ nan,     600,     600,    0.11,    0.17,  8.61e-08 ],
	[ nan,     700,     700,    0.16,    0.24,  1.02e-07 ],
	[ nan,     800,     800,    0.21,    0.28,  1.34e-07 ],
	[ nan,     900,     900,    0.27,    0.34,  1.30e-07 ],
	[ nan,    1000,    1000,    0.34,    0.47,  9.37e-08 ],
	[ nan,    2000,    2000,    1.78,    1.71,  7.54e-08 ],
	[ nan,    3000,    3000,    5.50,    4.32,  1.38e-07 ],
	[ nan,    4000,    4000,   13.17,    8.49,  5.93e-08 ],
	[ nan,    5000,    5000,   19.47,   14.85,  9.79e-08 ],
	[ nan,    6000,    6000,   33.62,   21.72,  3.34e-07 ],
	[ nan,    7000,    7000,   52.53,   31.90,  4.04e-07 ],
	[ nan,    8000,    8000,   77.26,   44.87,  4.24e-07 ],
	[ nan,    9000,    9000,  109.79,   60.79,  5.84e-07 ],
	[ nan,   10000,   10000,  148.57,   80.43,  9.21e-07 ],
	[ nan,     300,     100,    0.00,    0.01,  0.00e+00 ],
	[ nan,     600,     200,    0.02,    0.03,  1.09e-07 ],
	[ nan,     900,     300,    0.04,    0.06,  8.39e-08 ],
	[ nan,    1200,     400,    0.08,    0.10,  1.08e-07 ],
	[ nan,    1500,     500,    0.13,    0.17,  8.94e-08 ],
	[ nan,    1800,     600,    0.19,    0.25,  9.07e-08 ],
	[ nan,    2100,     700,    0.27,    0.34,  8.55e-08 ],
	[ nan,    2400,     800,    0.38,    0.45,  8.90e-08 ],
	[ nan,    2700,     900,    0.52,    0.64,  7.25e-08 ],
	[ nan,    3000,    1000,    0.65,    0.76,  6.97e-08 ],
	[ nan,    6000,    2000,    2.61,    3.60,  6.44e-08 ],
	[ nan,    9000,    3000,    9.31,    8.84,  8.12e-08 ],
	[ nan,   12000,    4000,   18.35,   20.54,  6.36e-08 ],
	[ nan,   15000,    5000,   35.78,   30.97,  3.23e-07 ],
	[ nan,   18000,    6000,   61.14,   50.47,  6.29e-07 ],
	[ nan,   21000,    7000,   95.76,   76.65,  5.82e-07 ],
	[ nan,   24000,    8000,  141.47,  111.06,  5.75e-07 ],
	[ nan,   27000,    9000,  200.09,  153.85,  5.87e-07 ],
	[ nan,     100,     300,    0.01,    0.01,  0.00e+00 ],
	[ nan,     200,     600,    0.02,    0.03,  1.15e-07 ],
	[ nan,     300,     900,    0.05,    0.06,  8.96e-08 ],
	[ nan,     400,    1200,    0.08,    0.11,  1.13e-07 ],
	[ nan,     500,    1500,    0.12,    0.17,  7.48e-08 ],
	[ nan,     600,    1800,    0.17,    0.24,  9.80e-08 ],
	[ nan,     700,    2100,    0.24,    0.32,  8.80e-08 ],
	[ nan,     800,    2400,    0.31,    0.42,  9.29e-08 ],
	[ nan,     900,    2700,    0.41,    0.53,  7.63e-08 ],
	[ nan,    1000,    3000,    0.51,    0.65,  7.06e-08 ],
	[ nan,    2000,    6000,    2.69,    3.05,  2.62e-07 ],
	[ nan,    3000,    9000,    8.10,    8.41,  7.26e-08 ],
	[ nan,    4000,   12000,   19.86,   17.57,  9.58e-08 ],
	[ nan,    5000,   15000,   37.51,   31.50,  3.53e-07 ],
	[ nan,    6000,   18000,   62.40,   54.38,  6.43e-07 ],
	[ nan,    7000,   21000,  101.87,   79.54,  1.11e-06 ],
	[ nan,    8000,   24000,  145.98,  113.17,  1.42e-06 ],
	[ nan,    9000,   27000,  202.17,  156.29,  2.69e-06 ],
	[ nan,   10000,     100,    0.03,    0.04,  0.00e+00 ],
	[ nan,   20000,     200,    0.13,    0.14,  1.18e-07 ],
	[ nan,   30000,     300,    0.31,    0.34,  9.47e-08 ],
	[ nan,   40000,     400,    0.76,    0.83,  9.10e-08 ],
	[ nan,   50000,     500,    1.27,    1.36,  7.36e-08 ],
	[ nan,   60000,     600,    1.97,    2.11,  1.22e-07 ],
	[ nan,   70000,     700,    2.89,    3.07,  7.58e-08 ],
	[ nan,   80000,     800,    3.98,    4.26,  3.82e-07 ],
	[ nan,   90000,     900,    5.85,    6.18,  6.98e-08 ],
	[ nan,  100000,    1000,    7.50,    7.87,  7.81e-08 ],
	[ nan,  200000,    2000,   48.96,   49.68,  2.08e-07 ],
	[ nan,     100,   10000,    0.04,    0.05,  0.00e+00 ],
	[ nan,     200,   20000,    0.21,    0.23,  1.51e-07 ],
	[ nan,     300,   30000,    0.42,    0.56,  9.45e-08 ],
	[ nan,     400,   40000,    0.84,    0.95,  1.03e-07 ],
	[ nan,     500,   50000,    1.43,    1.65,  2.91e-07 ],
	[ nan,     600,   60000,    2.37,    2.74,  2.66e-07 ],
	[ nan,     700,   70000,    3.60,    4.41,  8.25e-08 ],
	[ nan,     800,   80000,    5.32,    6.01,  7.97e-08 ],
	[ nan,     900,   90000,    6.78,    7.66,  9.33e-08 ],
	[ nan,    1000,  100000,    8.70,    9.72,  4.12e-07 ],
	[ nan,    2000,  200000,   54.45,   59.73,  4.15e-07 ],
	[ nan,   12000,   12000,     nan,  135.14,       nan ],
	[ nan,   14000,   14000,     nan,  202.42,       nan ],
	[ nan,   16000,   16000,     nan,  302.76,       nan ],
	[ nan,   18000,   18000,     nan,  423.28,       nan ],
	[ nan,   20000,   20000,     nan,  579.30,       nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/cgetrf.txt
# numactl --interleave=all ../testing/testing_cgetrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
cgetrf = array([
	[    10,     10,    0.33,   0.00,     0.52,  0.00,  nan ],
	[    20,     20,    0.84,   0.00,     1.32,  0.00,  nan ],
	[    30,     30,    1.98,   0.00,     2.96,  0.00,  nan ],
	[    40,     40,    3.68,   0.00,     4.96,  0.00,  nan ],
	[    50,     50,    5.09,   0.00,     6.49,  0.00,  nan ],
	[    60,     60,    5.73,   0.00,     7.06,  0.00,  nan ],
	[    70,     70,    6.50,   0.00,     1.19,  0.00,  nan ],
	[    80,     80,    9.32,   0.00,     1.78,  0.00,  nan ],
	[    90,     90,   10.70,   0.00,     2.39,  0.00,  nan ],
	[   100,    100,   12.90,   0.00,     3.06,  0.00,  nan ],
	[   200,    200,   36.53,   0.00,    12.83,  0.00,  nan ],
	[   300,    300,   64.79,   0.00,    29.22,  0.00,  nan ],
	[   400,    400,   87.99,   0.00,    47.08,  0.00,  nan ],
	[   500,    500,  113.26,   0.00,    69.03,  0.00,  nan ],
	[   600,    600,  127.67,   0.00,    92.11,  0.01,  nan ],
	[   700,    700,  139.67,   0.01,   116.17,  0.01,  nan ],
	[   800,    800,  155.26,   0.01,   143.91,  0.01,  nan ],
	[   900,    900,  151.48,   0.01,   170.46,  0.01,  nan ],
	[  1000,   1000,  165.10,   0.02,   198.58,  0.01,  nan ],
	[  2000,   2000,  215.26,   0.10,   514.58,  0.04,  nan ],
	[  3000,   3000,  272.83,   0.26,   866.05,  0.08,  nan ],
	[  4000,   4000,  480.88,   0.35,  1122.86,  0.15,  nan ],
	[  5000,   5000,  505.32,   0.66,  1348.73,  0.25,  nan ],
	[  6000,   6000,  433.04,   1.33,  1580.14,  0.36,  nan ],
	[  7000,   7000,  528.25,   1.73,  1744.78,  0.52,  nan ],
	[  8000,   8000,  503.81,   2.71,  1852.65,  0.74,  nan ],
	[  9000,   9000,  378.47,   5.14,  1984.11,  0.98,  nan ],
	[ 10000,  10000,  540.14,   4.94,  2113.90,  1.26,  nan ],
	[ 12000,  12000,  460.35,  10.01,  2265.73,  2.03,  nan ],
	[ 14000,  14000,  463.89,  15.77,  2349.43,  3.11,  nan ],
	[ 16000,  16000,  524.40,  20.83,  2422.50,  4.51,  nan ],
	[ 18000,  18000,  538.98,  28.85,  2489.29,  6.25,  nan ],
	[ 20000,  20000,  577.74,  36.92,  2541.17,  8.39,  nan ],
])

# numactl --interleave=all ../testing/testing_cgetrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.05,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.29,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.77,  0.00,  nan ],
	[    40,     40,  nan,  nan,     1.48,  0.00,  nan ],
	[    50,     50,  nan,  nan,     2.21,  0.00,  nan ],
	[    60,     60,  nan,  nan,     2.89,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.56,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.85,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.17,  0.00,  nan ],
	[   100,    100,  nan,  nan,     1.57,  0.00,  nan ],
	[   200,    200,  nan,  nan,     7.36,  0.00,  nan ],
	[   300,    300,  nan,  nan,    19.19,  0.00,  nan ],
	[   400,    400,  nan,  nan,    34.66,  0.00,  nan ],
	[   500,    500,  nan,  nan,    55.00,  0.01,  nan ],
	[   600,    600,  nan,  nan,    74.26,  0.01,  nan ],
	[   700,    700,  nan,  nan,    98.66,  0.01,  nan ],
	[   800,    800,  nan,  nan,   124.94,  0.01,  nan ],
	[   900,    900,  nan,  nan,   150.72,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   185.45,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   487.35,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   833.69,  0.09,  nan ],
	[  4000,   4000,  nan,  nan,  1174.27,  0.15,  nan ],
	[  5000,   5000,  nan,  nan,  1393.16,  0.24,  nan ],
	[  6000,   6000,  nan,  nan,  1694.11,  0.34,  nan ],
	[  7000,   7000,  nan,  nan,  1911.63,  0.48,  nan ],
	[  8000,   8000,  nan,  nan,  2078.50,  0.66,  nan ],
	[  9000,   9000,  nan,  nan,  2093.74,  0.93,  nan ],
	[ 10000,  10000,  nan,  nan,  2236.40,  1.19,  nan ],
	[ 12000,  12000,  nan,  nan,  2404.34,  1.92,  nan ],
	[ 14000,  14000,  nan,  nan,  2539.97,  2.88,  nan ],
	[ 16000,  16000,  nan,  nan,  2621.75,  4.17,  nan ],
	[ 18000,  18000,  nan,  nan,  2674.37,  5.82,  nan ],
	[ 20000,  20000,  nan,  nan,  2725.37,  7.83,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/cheevd.txt
# numactl --interleave=all ../testing/testing_cheevd -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_cheevd -JN -N 123 -N 1234 --range 12000:20000:2000
cheevd_JN = array([
	[    10,   0.00,    0.00 ],
	[    20,   0.00,    0.00 ],
	[    30,   0.00,    0.00 ],
	[    40,   0.00,    0.00 ],
	[    50,   0.00,    0.00 ],
	[    60,   0.00,    0.00 ],
	[    70,   0.00,    0.00 ],
	[    80,   0.00,    0.00 ],
	[    90,   0.00,    0.00 ],
	[   100,   0.00,    0.00 ],
	[   200,   0.00,    0.01 ],
	[   300,   0.01,    0.01 ],
	[   400,   0.02,    0.02 ],
	[   500,   0.03,    0.03 ],
	[   600,   0.04,    0.04 ],
	[   700,   0.05,    0.05 ],
	[   800,   0.06,    0.07 ],
	[   900,   0.07,    0.07 ],
	[  1000,   0.09,    0.09 ],
	[  2000,   0.42,    0.43 ],
	[  3000,   1.16,    1.27 ],
	[  4000,   2.75,    2.30 ],
	[  5000,   5.49,    3.76 ],
	[  6000,   9.62,    5.75 ],
	[  7000,  12.33,    8.10 ],
	[  8000,  17.10,   11.05 ],
	[  9000,  24.08,   14.83 ],
	[ 10000,  32.77,   19.19 ],
	[ 12000,    nan,   31.05 ],
	[ 14000,    nan,   46.13 ],
	[ 16000,    nan,   65.71 ],
	[ 18000,    nan,   90.81 ],
	[ 20000,    nan,  119.46 ],
])

# numactl --interleave=all ../testing/testing_cheevd -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_cheevd -JV -N 123 -N 1234 --range 12000:20000:2000
cheevd_JV = array([
	[    10,   0.00,    0.00 ],
	[    20,   0.00,    0.00 ],
	[    30,   0.00,    0.00 ],
	[    40,   0.00,    0.00 ],
	[    50,   0.00,    0.00 ],
	[    60,   0.00,    0.00 ],
	[    70,   0.00,    0.00 ],
	[    80,   0.00,    0.00 ],
	[    90,   0.00,    0.00 ],
	[   100,   0.00,    0.00 ],
	[   200,   0.01,    0.01 ],
	[   300,   0.01,    0.01 ],
	[   400,   0.02,    0.02 ],
	[   500,   0.03,    0.03 ],
	[   600,   0.05,    0.04 ],
	[   700,   0.07,    0.06 ],
	[   800,   0.09,    0.07 ],
	[   900,   0.11,    0.09 ],
	[  1000,   0.15,    0.12 ],
	[  2000,   0.77,    0.52 ],
	[  3000,   2.25,    1.43 ],
	[  4000,   5.12,    2.72 ],
	[  5000,   8.45,    4.22 ],
	[  6000,  12.67,    6.40 ],
	[  7000,  20.12,    9.39 ],
	[  8000,  28.20,   12.76 ],
	[  9000,  41.37,   17.21 ],
	[ 10000,  52.65,   22.46 ],
	[ 12000,    nan,   36.62 ],
	[ 14000,    nan,   54.42 ],
	[ 16000,    nan,   78.03 ],
	[ 18000,    nan,  108.75 ],
	[ 20000,    nan,  143.87 ],
])

# numactl --interleave=all ../testing/testing_cheevd_gpu -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_cheevd_gpu -JN -N 123 -N 1234 --range 12000:20000:2000
cheevd_gpu_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.00 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.02 ],
	[   600,  nan,    0.03 ],
	[   700,  nan,    0.05 ],
	[   800,  nan,    0.06 ],
	[   900,  nan,    0.08 ],
	[  1000,  nan,    0.09 ],
	[  2000,  nan,    0.44 ],
	[  3000,  nan,    1.29 ],
	[  4000,  nan,    2.32 ],
	[  5000,  nan,    3.78 ],
	[  6000,  nan,    5.64 ],
	[  7000,  nan,    8.10 ],
	[  8000,  nan,   11.09 ],
	[  9000,  nan,   14.81 ],
	[ 10000,  nan,   19.18 ],
	[ 12000,  nan,   31.06 ],
	[ 14000,  nan,   45.65 ],
	[ 16000,  nan,   65.37 ],
	[ 18000,  nan,   90.12 ],
	[ 20000,  nan,  119.44 ],
])

# numactl --interleave=all ../testing/testing_cheevd_gpu -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_cheevd_gpu -JV -N 123 -N 1234 --range 12000:20000:2000
cheevd_gpu_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.04 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.06 ],
	[   800,  nan,    0.07 ],
	[   900,  nan,    0.09 ],
	[  1000,  nan,    0.12 ],
	[  2000,  nan,    0.50 ],
	[  3000,  nan,    1.42 ],
	[  4000,  nan,    2.58 ],
	[  5000,  nan,    4.23 ],
	[  6000,  nan,    6.49 ],
	[  7000,  nan,    9.44 ],
	[  8000,  nan,   13.01 ],
	[  9000,  nan,   17.35 ],
	[ 10000,  nan,   23.11 ],
	[ 12000,  nan,   37.28 ],
	[ 14000,  nan,   55.41 ],
	[ 16000,  nan,   79.81 ],
	[ 18000,  nan,  110.56 ],
	[ 20000,  nan,  148.26 ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/cheevd_2stage.txt
# numactl --interleave=all ../testing/testing_cheevdx_2stage -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
cheevdx_2stage_JN = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.04 ],
	[   500,    500,   0.06 ],
	[   600,    600,   0.09 ],
	[   700,    700,   0.11 ],
	[   800,    800,   0.13 ],
	[   900,    900,   0.16 ],
	[  1000,   1000,   0.18 ],
	[  2000,   2000,   0.45 ],
	[  3000,   3000,   0.82 ],
	[  4000,   4000,   1.24 ],
	[  5000,   5000,   1.80 ],
	[  6000,   6000,   2.38 ],
	[  7000,   7000,   3.33 ],
	[  8000,   8000,   4.14 ],
	[  9000,   9000,   5.23 ],
	[ 10000,  10000,   6.53 ],
	[ 12000,  12000,   9.65 ],
	[ 14000,  14000,  13.69 ],
	[ 16000,  16000,  18.60 ],
	[ 18000,  18000,  24.68 ],
	[ 20000,  20000,  31.91 ],
])

# numactl --interleave=all ../testing/testing_cheevdx_2stage -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
cheevdx_2stage_JV = array([
	[    10,     10,    0.00 ],
	[    20,     20,    0.00 ],
	[    30,     30,    0.00 ],
	[    40,     40,    0.00 ],
	[    50,     50,    0.00 ],
	[    60,     60,    0.00 ],
	[    70,     70,    0.00 ],
	[    80,     80,    0.00 ],
	[    90,     90,    0.00 ],
	[   100,    100,    0.00 ],
	[   200,    200,    0.01 ],
	[   300,    300,    0.03 ],
	[   400,    400,    0.05 ],
	[   500,    500,    0.08 ],
	[   600,    600,    0.10 ],
	[   700,    700,    0.12 ],
	[   800,    800,    0.15 ],
	[   900,    900,    0.18 ],
	[  1000,   1000,    0.22 ],
	[  2000,   2000,    0.65 ],
	[  3000,   3000,    1.16 ],
	[  4000,   4000,    2.07 ],
	[  5000,   5000,    3.36 ],
	[  6000,   6000,    4.86 ],
	[  7000,   7000,    7.03 ],
	[  8000,   8000,    9.73 ],
	[  9000,   9000,   12.99 ],
	[ 10000,  10000,   17.34 ],
	[ 12000,  12000,   28.42 ],
	[ 14000,  14000,   42.24 ],
	[ 16000,  16000,   60.74 ],
	[ 18000,  18000,   85.76 ],
	[ 20000,  20000,  116.55 ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/chemv.txt
# numactl --interleave=all ../testing/testing_chemv -L -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000 --lapack
chemv_L = array([
	[    10,    0.02,   0.04,    0.03,   0.03,   0.03,   0.03,   0.43,    0.00,  2.13e-07,  2.13e-07,  2.70e-07,  nan ],
	[    11,    0.03,   0.04,    0.04,   0.03,   0.04,   0.03,   0.58,    0.00,  1.94e-07,  1.85e-07,  1.23e-07,  nan ],
	[    12,    0.03,   0.04,    0.04,   0.03,   0.05,   0.03,   0.45,    0.00,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    13,    0.04,   0.04,    0.04,   0.03,   0.06,   0.03,   0.79,    0.00,  1.64e-07,  2.07e-07,  1.64e-07,  nan ],
	[    14,    0.05,   0.04,    0.06,   0.03,   0.06,   0.03,   0.91,    0.00,  2.81e-07,  2.46e-07,  2.81e-07,  nan ],
	[    15,    0.05,   0.04,    0.07,   0.03,   0.07,   0.03,   0.92,    0.00,  1.42e-07,  1.80e-07,  2.84e-07,  nan ],
	[    16,    0.06,   0.04,    0.07,   0.03,   0.08,   0.03,   1.17,    0.00,  1.69e-07,  1.69e-07,  1.69e-07,  nan ],
	[    17,    0.06,   0.04,    0.08,   0.03,   0.08,   0.03,   1.32,    0.00,  1.59e-07,  2.51e-07,  1.59e-07,  nan ],
	[    18,    0.07,   0.04,    0.09,   0.03,   0.09,   0.03,   1.31,    0.00,  2.14e-07,  2.18e-07,  2.18e-07,  nan ],
	[    19,    0.08,   0.04,    0.10,   0.03,   0.10,   0.03,   1.01,    0.00,  2.04e-07,  2.01e-07,  1.25e-07,  nan ],
	[    20,    0.08,   0.04,    0.11,   0.03,   0.12,   0.03,   1.80,    0.00,  1.97e-07,  2.13e-07,  1.97e-07,  nan ],
	[    21,    0.10,   0.04,    0.13,   0.03,   0.13,   0.03,   1.32,    0.00,  2.03e-07,  2.57e-07,  2.57e-07,  nan ],
	[    22,    0.11,   0.04,    0.14,   0.03,   0.14,   0.03,   1.33,    0.00,  1.94e-07,  2.33e-07,  1.94e-07,  nan ],
	[    23,    0.12,   0.04,    0.14,   0.03,   0.15,   0.03,   1.58,    0.00,  1.71e-07,  1.67e-07,  2.49e-07,  nan ],
	[    24,    0.13,   0.04,    0.16,   0.03,   0.17,   0.03,   1.71,    0.00,  1.64e-07,  2.44e-07,  1.87e-07,  nan ],
	[    25,    0.14,   0.04,    0.18,   0.03,   0.18,   0.03,   1.71,    0.00,  2.56e-07,  2.29e-07,  2.16e-07,  nan ],
	[    26,    0.15,   0.04,    0.19,   0.03,   0.19,   0.03,   1.41,    0.00,  1.64e-07,  1.55e-07,  1.64e-07,  nan ],
	[    27,    0.16,   0.04,    0.21,   0.03,   0.21,   0.03,   1.52,    0.00,  2.15e-07,  1.58e-07,  2.23e-07,  nan ],
	[    28,    0.17,   0.04,    0.21,   0.03,   0.22,   0.03,   2.13,    0.00,  2.15e-07,  2.46e-07,  1.52e-07,  nan ],
	[    29,    0.18,   0.04,    0.23,   0.03,   0.23,   0.03,   1.85,    0.00,  2.94e-07,  2.71e-07,  2.21e-07,  nan ],
	[    30,    0.19,   0.04,    0.24,   0.03,   0.24,   0.03,   1.98,    0.00,  2.29e-07,  2.29e-07,  2.62e-07,  nan ],
	[    31,    0.21,   0.04,    0.26,   0.03,   0.26,   0.03,   1.99,    0.00,  1.54e-07,  2.54e-07,  1.54e-07,  nan ],
	[    32,    0.21,   0.04,    0.28,   0.03,   0.28,   0.03,   2.12,    0.00,  1.33e-07,  2.46e-07,  1.49e-07,  nan ],
	[    33,    0.23,   0.04,    0.24,   0.04,   0.28,   0.03,   2.39,    0.00,  2.55e-07,  2.33e-07,  2.08e-07,  nan ],
	[    34,    0.24,   0.04,    0.26,   0.04,   0.30,   0.03,   1.93,    0.01,  2.80e-07,  2.31e-07,  3.17e-07,  nan ],
	[    35,    0.26,   0.04,    0.26,   0.04,   0.32,   0.03,   2.04,    0.01,  2.25e-07,  2.44e-07,  2.44e-07,  nan ],
	[    36,    0.27,   0.04,    0.29,   0.04,   0.34,   0.03,   3.77,    0.00,  3.35e-07,  2.37e-07,  2.37e-07,  nan ],
	[    37,    0.28,   0.04,    0.31,   0.04,   0.37,   0.03,   2.99,    0.00,  2.31e-07,  3.26e-07,  2.13e-07,  nan ],
	[    38,    0.31,   0.04,    0.33,   0.04,   0.39,   0.03,   3.15,    0.00,  3.62e-07,  3.17e-07,  3.05e-07,  nan ],
	[    39,    0.33,   0.04,    0.35,   0.04,   0.38,   0.03,   2.52,    0.01,  2.19e-07,  2.19e-07,  1.96e-07,  nan ],
	[    40,    0.32,   0.04,    0.37,   0.04,   0.41,   0.03,   3.28,    0.00,  2.90e-07,  3.02e-07,  2.90e-07,  nan ],
	[    41,    0.35,   0.04,    0.38,   0.04,   0.44,   0.03,   2.78,    0.01,  3.12e-07,  2.83e-07,  2.83e-07,  nan ],
	[    42,    0.35,   0.04,    0.39,   0.04,   0.46,   0.03,   3.61,    0.00,  2.76e-07,  2.72e-07,  1.87e-07,  nan ],
	[    43,    0.38,   0.04,    0.41,   0.04,   0.49,   0.03,   3.78,    0.00,  2.81e-07,  2.81e-07,  2.88e-07,  nan ],
	[    44,    0.40,   0.04,    0.43,   0.04,   0.50,   0.03,   3.20,    0.01,  2.82e-07,  2.68e-07,  1.94e-07,  nan ],
	[    45,    0.40,   0.04,    0.45,   0.04,   0.51,   0.03,   3.34,    0.01,  3.42e-07,  2.62e-07,  2.12e-07,  nan ],
	[    46,    0.43,   0.04,    0.47,   0.04,   0.55,   0.03,   2.93,    0.01,  2.52e-07,  2.62e-07,  3.52e-07,  nan ],
	[    47,    0.46,   0.04,    0.51,   0.04,   0.57,   0.03,   3.06,    0.01,  2.19e-07,  2.47e-07,  2.72e-07,  nan ],
	[    48,    0.47,   0.04,    0.53,   0.04,   0.50,   0.04,   3.80,    0.01,  2.87e-07,  3.55e-07,  2.87e-07,  nan ],
	[    49,    0.49,   0.04,    0.55,   0.04,   0.60,   0.03,   3.19,    0.01,  2.81e-07,  2.34e-07,  2.37e-07,  nan ],
	[    50,    0.51,   0.04,    0.56,   0.04,   0.56,   0.04,   3.32,    0.01,  3.08e-07,  2.75e-07,  2.44e-07,  nan ],
	[    51,    0.52,   0.04,    0.61,   0.04,   0.63,   0.03,   3.59,    0.01,  3.74e-07,  2.72e-07,  2.70e-07,  nan ],
	[    52,    0.57,   0.04,    0.62,   0.04,   0.60,   0.04,   3.73,    0.01,  2.75e-07,  2.23e-07,  1.83e-07,  nan ],
	[    53,    0.59,   0.04,    0.64,   0.04,   0.68,   0.03,   3.73,    0.01,  2.62e-07,  3.62e-07,  3.62e-07,  nan ],
	[    54,    0.60,   0.04,    0.65,   0.04,   0.57,   0.04,   4.02,    0.01,  3.53e-07,  3.00e-07,  3.16e-07,  nan ],
	[    55,    0.62,   0.04,    0.67,   0.04,   0.75,   0.03,   4.01,    0.01,  2.54e-07,  3.47e-07,  2.50e-07,  nan ],
	[    56,    0.63,   0.04,    0.66,   0.04,   0.76,   0.03,   4.32,    0.01,  2.91e-07,  2.07e-07,  2.91e-07,  nan ],
	[    57,    0.65,   0.04,    0.70,   0.04,   0.78,   0.03,   3.86,    0.01,  2.24e-07,  2.70e-07,  2.70e-07,  nan ],
	[    58,    0.64,   0.04,    0.73,   0.04,   0.79,   0.04,   3.51,    0.01,  2.71e-07,  2.71e-07,  2.37e-07,  nan ],
	[    59,    0.68,   0.04,    0.75,   0.04,   0.84,   0.03,   4.13,    0.01,  2.74e-07,  3.77e-07,  4.34e-07,  nan ],
	[    60,    0.70,   0.04,    0.76,   0.04,   0.84,   0.04,   4.13,    0.01,  2.62e-07,  2.62e-07,  2.72e-07,  nan ],
	[    61,    0.71,   0.04,    0.78,   0.04,   0.89,   0.03,   4.26,    0.01,  2.50e-07,  2.52e-07,  2.25e-07,  nan ],
	[    62,    0.73,   0.04,    0.81,   0.04,   0.93,   0.03,   4.00,    0.01,  2.75e-07,  2.54e-07,  2.75e-07,  nan ],
	[    63,    0.76,   0.04,    0.84,   0.04,   0.95,   0.03,   4.70,    0.01,  2.71e-07,  2.71e-07,  3.03e-07,  nan ],
	[    64,    0.86,   0.04,    0.91,   0.04,   1.02,   0.03,   4.69,    0.01,  4.00e-07,  3.77e-07,  3.63e-07,  nan ],
	[    65,    0.79,   0.04,    0.88,   0.04,   0.94,   0.04,   4.27,    0.01,  3.16e-07,  2.42e-07,  2.93e-07,  nan ],
	[    66,    0.76,   0.05,    0.93,   0.04,   0.93,   0.04,   5.15,    0.01,  4.62e-07,  3.66e-07,  2.89e-07,  nan ],
	[    67,    0.80,   0.05,    0.92,   0.04,   0.99,   0.04,   5.31,    0.01,  3.42e-07,  3.43e-07,  3.43e-07,  nan ],
	[    68,    0.86,   0.04,    0.95,   0.04,   1.02,   0.04,   5.29,    0.01,  4.52e-07,  3.55e-07,  2.80e-07,  nan ],
	[    69,    0.83,   0.05,    0.97,   0.04,   1.03,   0.04,   4.80,    0.01,  2.76e-07,  2.47e-07,  3.36e-07,  nan ],
	[    70,    0.85,   0.05,    1.02,   0.04,   1.08,   0.04,   5.09,    0.01,  4.39e-07,  4.49e-07,  4.39e-07,  nan ],
	[    71,    0.93,   0.04,    0.93,   0.04,   1.11,   0.04,   5.23,    0.01,  6.65e-07,  7.60e-07,  7.99e-07,  nan ],
	[    72,    0.97,   0.04,    1.12,   0.04,   1.18,   0.04,   5.22,    0.01,  3.18e-07,  3.28e-07,  3.18e-07,  nan ],
	[    73,    0.85,   0.05,    1.15,   0.04,   1.24,   0.04,   4.80,    0.01,  3.77e-07,  3.30e-07,  3.30e-07,  nan ],
	[    74,    1.01,   0.04,    1.18,   0.04,   1.24,   0.04,   5.51,    0.01,  3.26e-07,  3.14e-07,  3.46e-07,  nan ],
	[    75,    1.04,   0.04,    1.17,   0.04,   1.27,   0.04,   4.58,    0.01,  3.22e-07,  3.05e-07,  3.26e-07,  nan ],
	[    76,    1.05,   0.04,    1.21,   0.04,   1.31,   0.04,   5.81,    0.01,  4.14e-07,  3.05e-07,  3.17e-07,  nan ],
	[    77,    0.97,   0.05,    1.24,   0.04,   1.31,   0.04,   5.97,    0.01,  4.03e-07,  3.99e-07,  3.22e-07,  nan ],
	[    78,    1.06,   0.05,    1.28,   0.04,   1.38,   0.04,   5.48,    0.01,  3.09e-07,  4.18e-07,  3.28e-07,  nan ],
	[    79,    1.11,   0.05,    1.30,   0.04,   1.37,   0.04,   5.08,    0.01,  3.05e-07,  3.98e-07,  3.24e-07,  nan ],
	[    80,    1.13,   0.05,    1.30,   0.04,   1.41,   0.04,   5.76,    0.01,  2.90e-07,  3.81e-07,  3.44e-07,  nan ],
	[    81,    1.12,   0.05,    1.38,   0.04,   1.38,   0.04,   5.90,    0.01,  3.16e-07,  3.40e-07,  3.16e-07,  nan ],
	[    82,    1.19,   0.05,    1.34,   0.04,   1.37,   0.04,   4.99,    0.01,  3.75e-07,  3.97e-07,  3.72e-07,  nan ],
	[    83,    1.17,   0.05,    1.41,   0.04,   1.40,   0.04,   6.19,    0.01,  4.11e-07,  4.11e-07,  4.69e-07,  nan ],
	[    84,    1.22,   0.05,    1.44,   0.04,   1.47,   0.04,   6.51,    0.01,  3.74e-07,  2.87e-07,  3.27e-07,  nan ],
	[    85,    1.28,   0.05,    1.43,   0.04,   1.50,   0.04,   5.87,    0.01,  4.23e-07,  2.84e-07,  2.69e-07,  nan ],
	[    86,    1.34,   0.05,    1.54,   0.04,   1.54,   0.04,   6.01,    0.01,  2.66e-07,  2.74e-07,  3.58e-07,  nan ],
	[    87,    1.37,   0.05,    1.54,   0.04,   1.58,   0.04,   6.30,    0.01,  3.62e-07,  3.51e-07,  2.77e-07,  nan ],
	[    88,    1.40,   0.05,    1.62,   0.04,   1.66,   0.04,   6.95,    0.01,  3.47e-07,  4.36e-07,  3.57e-07,  nan ],
	[    89,    1.29,   0.05,    1.57,   0.04,   1.66,   0.04,   6.43,    0.01,  2.71e-07,  3.53e-07,  3.46e-07,  nan ],
	[    90,    1.34,   0.05,    1.57,   0.04,   1.68,   0.04,   4.76,    0.01,  5.09e-07,  3.42e-07,  4.24e-07,  nan ],
	[   100,    1.69,   0.05,    1.98,   0.04,   2.03,   0.04,   7.40,    0.01,  2.41e-07,  2.41e-07,  2.16e-07,  nan ],
	[   110,    2.05,   0.05,    2.34,   0.04,   2.34,   0.04,   7.48,    0.01,  4.39e-07,  3.47e-07,  3.92e-07,  nan ],
	[   120,    2.33,   0.05,    2.70,   0.04,   2.70,   0.04,   7.77,    0.02,  4.26e-07,  2.72e-07,  2.84e-07,  nan ],
	[   130,    2.28,   0.06,    3.24,   0.04,   2.99,   0.05,   7.65,    0.02,  4.84e-07,  5.01e-07,  4.84e-07,  nan ],
	[   140,    2.88,   0.06,    3.67,   0.04,   3.46,   0.05,   8.75,    0.02,  4.39e-07,  4.36e-07,  5.45e-07,  nan ],
	[   150,    3.50,   0.05,    4.12,   0.04,   3.87,   0.05,   9.08,    0.02,  5.48e-07,  6.12e-07,  5.31e-07,  nan ],
	[   160,    3.75,   0.06,    4.79,   0.04,   4.23,   0.05,   9.42,    0.02,  4.98e-07,  4.05e-07,  4.77e-07,  nan ],
	[   170,    4.23,   0.06,    5.18,   0.05,   4.75,   0.05,   8.98,    0.03,  5.46e-07,  6.35e-07,  5.46e-07,  nan ],
	[   180,    4.75,   0.06,    5.80,   0.05,   5.03,   0.05,  10.44,    0.03,  5.36e-07,  6.17e-07,  5.24e-07,  nan ],
	[   190,    5.02,   0.06,    6.20,   0.05,   5.60,   0.05,  10.01,    0.03,  5.68e-07,  4.89e-07,  5.64e-07,  nan ],
	[   200,    5.56,   0.06,    7.01,   0.05,   6.09,   0.05,  10.40,    0.03,  6.15e-07,  6.88e-07,  5.35e-07,  nan ],
	[   210,    5.94,   0.06,    7.57,   0.05,   6.45,   0.06,  10.42,    0.03,  5.09e-07,  4.11e-07,  4.36e-07,  nan ],
	[   220,    6.39,   0.06,    7.94,   0.05,   6.96,   0.06,  10.55,    0.04,  6.33e-07,  5.93e-07,  5.81e-07,  nan ],
	[   230,    7.01,   0.06,    8.72,   0.05,   7.32,   0.06,  10.96,    0.04,  5.47e-07,  6.77e-07,  5.47e-07,  nan ],
	[   240,    7.48,   0.06,    9.63,   0.05,   8.28,   0.06,  11.31,    0.04,  5.55e-07,  6.74e-07,  5.55e-07,  nan ],
	[   250,    7.99,   0.06,   10.05,   0.05,   8.37,   0.06,  10.93,    0.05,  7.32e-07,  6.13e-07,  6.10e-07,  nan ],
	[   260,    8.12,   0.07,   10.66,   0.05,   8.77,   0.06,  11.35,    0.05,  8.24e-07,  5.98e-07,  8.30e-07,  nan ],
	[   270,    8.88,   0.07,   11.71,   0.05,   9.61,   0.06,  11.49,    0.05,  6.09e-07,  8.09e-07,  7.15e-07,  nan ],
	[   280,    9.28,   0.07,   12.36,   0.05,   9.87,   0.06,  11.91,    0.05,  5.69e-07,  6.63e-07,  6.74e-07,  nan ],
	[   290,    9.81,   0.07,   12.72,   0.05,  10.24,   0.07,  11.67,    0.06,  8.01e-07,  8.44e-07,  7.31e-07,  nan ],
	[   300,   10.47,   0.07,   14.18,   0.05,  11.12,   0.07,  11.86,    0.06,  8.15e-07,  8.28e-07,  8.28e-07,  nan ],
	[   310,   11.17,   0.07,   14.53,   0.05,  11.37,   0.07,  11.70,    0.07,  7.50e-07,  7.94e-07,  8.47e-07,  nan ],
	[   320,   12.51,   0.07,   16.44,   0.05,  12.11,   0.07,  11.28,    0.07,  7.64e-07,  7.64e-07,  6.69e-07,  nan ],
	[   330,   11.84,   0.07,   15.89,   0.06,  12.49,   0.07,  11.96,    0.07,  7.63e-07,  7.75e-07,  8.53e-07,  nan ],
	[   340,   12.57,   0.07,   16.94,   0.05,  12.73,   0.07,  12.41,    0.07,  9.91e-07,  8.09e-07,  8.09e-07,  nan ],
	[   350,   13.10,   0.08,   17.87,   0.06,  13.67,   0.07,  12.14,    0.08,  7.45e-07,  8.27e-07,  7.03e-07,  nan ],
	[   360,   13.86,   0.08,   18.58,   0.06,  13.91,   0.07,  12.55,    0.08,  9.13e-07,  7.58e-07,  7.82e-07,  nan ],
	[   370,   13.89,   0.08,   19.30,   0.06,  14.10,   0.08,  12.23,    0.09,  6.91e-07,  7.05e-07,  7.70e-07,  nan ],
	[   380,   15.30,   0.08,   19.61,   0.06,  15.30,   0.08,  12.73,    0.09,  1.22e-06,  8.04e-07,  8.83e-07,  nan ],
	[   390,   15.07,   0.08,   21.44,   0.06,  15.48,   0.08,  11.75,    0.10,  1.02e-06,  8.75e-07,  8.75e-07,  nan ],
	[   400,   15.85,   0.08,   22.93,   0.06,  16.48,   0.08,  12.99,    0.10,  9.92e-07,  8.53e-07,  8.39e-07,  nan ],
	[   410,   16.46,   0.08,   22.83,   0.06,  16.65,   0.08,  12.50,    0.11,  8.22e-07,  8.93e-07,  8.22e-07,  nan ],
	[   420,   16.64,   0.09,   23.20,   0.06,  16.88,   0.08,  12.64,    0.11,  6.70e-07,  7.41e-07,  6.89e-07,  nan ],
	[   430,   17.49,   0.08,   22.16,   0.07,  17.64,   0.08,  12.78,    0.12,  8.70e-07,  9.99e-07,  9.23e-07,  nan ],
	[   440,   18.26,   0.09,   25.07,   0.06,  18.11,   0.09,  12.23,    0.13,  8.69e-07,  8.09e-07,  8.12e-07,  nan ],
	[   450,   18.04,   0.09,   25.44,   0.06,  18.28,   0.09,  12.79,    0.13,  8.92e-07,  7.58e-07,  7.53e-07,  nan ],
	[   460,   19.30,   0.09,   26.88,   0.06,  19.10,   0.09,  13.05,    0.13,  1.01e-06,  8.31e-07,  8.68e-07,  nan ],
	[   470,   19.88,   0.09,   27.64,   0.06,  19.72,   0.09,  12.95,    0.14,  7.93e-07,  8.60e-07,  8.47e-07,  nan ],
	[   480,   21.02,   0.09,   29.83,   0.06,  20.57,   0.09,  13.19,    0.14,  8.04e-07,  8.65e-07,  9.26e-07,  nan ],
	[   490,   21.15,   0.09,   28.76,   0.07,  20.51,   0.09,  12.93,    0.15,  1.07e-06,  9.26e-07,  9.34e-07,  nan ],
	[   500,   22.03,   0.09,   29.94,   0.07,  20.93,   0.10,  13.13,    0.15,  8.54e-07,  7.55e-07,  7.55e-07,  nan ],
	[   510,   22.97,   0.09,   30.71,   0.07,  21.72,   0.10,  12.72,    0.16,  9.81e-07,  9.59e-07,  9.81e-07,  nan ],
	[   520,   23.04,   0.09,   31.93,   0.07,  22.36,   0.10,  12.53,    0.17,  1.00e-06,  9.46e-07,  9.46e-07,  nan ],
	[   530,   23.00,   0.10,   32.26,   0.07,  22.56,   0.10,  12.97,    0.17,  9.50e-07,  1.05e-06,  1.05e-06,  nan ],
	[   540,   24.17,   0.10,   33.95,   0.07,  23.14,   0.10,  13.06,    0.18,  1.29e-06,  9.72e-07,  1.24e-06,  nan ],
	[   550,   24.06,   0.10,   34.62,   0.07,  24.00,   0.10,  12.97,    0.19,  1.32e-06,  1.14e-06,  1.24e-06,  nan ],
	[   560,   25.12,   0.10,   36.38,   0.07,  24.42,   0.10,  13.37,    0.19,  1.42e-06,  1.32e-06,  1.31e-06,  nan ],
	[   570,   25.60,   0.10,   36.68,   0.07,  24.62,   0.11,  12.95,    0.20,  1.39e-06,  1.50e-06,  1.28e-06,  nan ],
	[   580,   25.72,   0.10,   36.86,   0.07,  25.20,   0.11,  13.42,    0.20,  9.60e-07,  8.68e-07,  9.60e-07,  nan ],
	[   590,   25.85,   0.11,   37.65,   0.07,  24.70,   0.11,  13.29,    0.21,  1.35e-06,  1.45e-06,  1.27e-06,  nan ],
	[   600,   26.50,   0.11,   38.57,   0.07,  26.21,   0.11,  13.23,    0.22,  1.13e-06,  1.17e-06,  1.12e-06,  nan ],
	[   610,   26.41,   0.11,   39.24,   0.08,  26.18,   0.11,  13.15,    0.23,  1.10e-06,  1.12e-06,  1.12e-06,  nan ],
	[   620,   27.28,   0.11,   40.03,   0.08,  27.05,   0.11,  13.34,    0.23,  1.35e-06,  1.21e-06,  1.12e-06,  nan ],
	[   630,   28.16,   0.11,   40.82,   0.08,  27.19,   0.12,  12.94,    0.25,  8.12e-07,  8.93e-07,  8.93e-07,  nan ],
	[   640,   30.08,   0.11,   42.65,   0.08,  28.06,   0.12,  13.40,    0.25,  1.17e-06,  1.30e-06,  1.17e-06,  nan ],
	[   650,   29.18,   0.12,   43.45,   0.08,  28.03,   0.12,  13.28,    0.26,  1.17e-06,  1.07e-06,  1.05e-06,  nan ],
	[   660,   29.12,   0.12,   42.59,   0.08,  27.96,   0.12,  13.33,    0.26,  1.30e-06,  1.21e-06,  1.32e-06,  nan ],
	[   670,   30.19,   0.12,   44.53,   0.08,  29.26,   0.12,  13.05,    0.28,  1.48e-06,  1.39e-06,  1.56e-06,  nan ],
	[   680,   30.91,   0.12,   44.68,   0.08,  29.39,   0.13,  13.44,    0.28,  1.21e-06,  1.27e-06,  1.26e-06,  nan ],
	[   690,   30.79,   0.12,   45.48,   0.08,  28.49,   0.13,  13.40,    0.28,  1.24e-06,  1.16e-06,  1.24e-06,  nan ],
	[   700,   31.93,   0.12,   46.68,   0.08,  30.68,   0.13,  13.64,    0.29,  1.35e-06,  1.21e-06,  1.28e-06,  nan ],
	[   710,   32.10,   0.13,   48.15,   0.08,  30.88,   0.13,  13.17,    0.31,  1.25e-06,  1.22e-06,  1.13e-06,  nan ],
	[   720,   32.46,   0.13,   48.28,   0.09,  31.69,   0.13,  13.59,    0.31,  1.78e-06,  1.54e-06,  1.53e-06,  nan ],
	[   730,   32.64,   0.13,   49.09,   0.09,  31.66,   0.13,  13.15,    0.32,  1.78e-06,  1.85e-06,  1.93e-06,  nan ],
	[   740,   33.54,   0.13,   49.90,   0.09,  31.85,   0.14,  13.60,    0.32,  1.41e-06,  1.33e-06,  1.41e-06,  nan ],
	[   750,   34.45,   0.13,   50.57,   0.09,  31.79,   0.14,  13.19,    0.34,  1.06e-06,  1.22e-06,  1.17e-06,  nan ],
	[   760,   35.12,   0.13,   52.06,   0.09,  33.08,   0.14,  13.35,    0.35,  1.54e-06,  1.72e-06,  1.71e-06,  nan ],
	[   770,   34.91,   0.14,   52.73,   0.09,  33.00,   0.14,  13.31,    0.36,  1.04e-06,  1.04e-06,  1.11e-06,  nan ],
	[   780,   36.39,   0.13,   54.84,   0.09,  34.32,   0.14,  13.39,    0.36,  1.12e-06,  1.28e-06,  1.18e-06,  nan ],
	[   790,   36.74,   0.14,   54.36,   0.09,  34.28,   0.15,  13.30,    0.38,  1.52e-06,  1.35e-06,  1.42e-06,  nan ],
	[   800,   37.16,   0.14,   56.92,   0.09,  35.10,   0.15,  13.61,    0.38,  1.38e-06,  1.30e-06,  1.30e-06,  nan ],
	[   810,   37.83,   0.14,   56.55,   0.09,  35.75,   0.15,  13.49,    0.39,  1.30e-06,  1.36e-06,  1.23e-06,  nan ],
	[   820,   37.99,   0.14,   57.37,   0.09,  35.94,   0.15,  13.44,    0.40,  1.16e-06,  1.15e-06,  1.36e-06,  nan ],
	[   830,   39.18,   0.14,   58.04,   0.10,  36.58,   0.15,  13.50,    0.41,  1.28e-06,  1.11e-06,  1.12e-06,  nan ],
	[   840,   39.27,   0.14,   59.59,   0.09,  36.72,   0.15,  13.63,    0.41,  1.38e-06,  1.38e-06,  1.45e-06,  nan ],
	[   850,   39.43,   0.15,   60.26,   0.10,  37.08,   0.16,  13.56,    0.43,  1.01e-06,  1.08e-06,  1.08e-06,  nan ],
	[   860,   40.62,   0.15,   61.08,   0.10,  38.01,   0.16,  13.56,    0.44,  1.21e-06,  1.07e-06,  1.07e-06,  nan ],
	[   870,   40.97,   0.15,   63.13,   0.10,  38.66,   0.16,  13.54,    0.45,  1.19e-06,  1.47e-06,  1.12e-06,  nan ],
	[   880,   41.91,   0.15,   63.95,   0.10,  39.26,   0.16,  13.55,    0.46,  1.32e-06,  1.18e-06,  1.26e-06,  nan ],
	[   890,   42.33,   0.15,   63.54,   0.10,  39.38,   0.16,  13.59,    0.47,  1.24e-06,  1.15e-06,  1.26e-06,  nan ],
	[   900,   42.14,   0.15,   64.82,   0.10,  39.57,   0.16,  13.61,    0.48,  1.43e-06,  1.32e-06,  1.38e-06,  nan ],
	[  1000,   48.56,   0.16,   73.53,   0.11,  44.28,   0.18,  13.65,    0.59,  1.26e-06,  1.39e-06,  1.43e-06,  nan ],
	[  1100,   53.01,   0.18,   82.80,   0.12,  30.00,   0.32,  13.85,    0.70,  1.62e-06,  1.48e-06,  1.48e-06,  nan ],
	[  1200,   58.57,   0.20,   91.63,   0.13,  33.05,   0.35,  13.78,    0.84,  1.53e-06,  1.53e-06,  1.43e-06,  nan ],
	[  1300,   62.39,   0.22,  100.30,   0.13,  34.08,   0.40,  14.13,    0.96,  2.10e-06,  2.18e-06,  2.00e-06,  nan ],
	[  1400,   70.34,   0.22,  111.40,   0.14,  37.73,   0.42,  14.16,    1.11,  2.37e-06,  2.09e-06,  2.06e-06,  nan ],
	[  1500,   73.51,   0.25,  117.90,   0.15,  40.22,   0.45,  14.09,    1.28,  2.01e-06,  1.73e-06,  1.73e-06,  nan ],
	[  1600,   78.88,   0.26,  124.25,   0.16,  42.09,   0.49,  13.70,    1.50,  1.84e-06,  1.98e-06,  1.99e-06,  nan ],
	[  1700,   83.53,   0.28,  131.51,   0.18,  44.06,   0.53,  12.64,    1.83,  1.90e-06,  2.09e-06,  1.89e-06,  nan ],
	[  1800,   89.19,   0.29,  138.08,   0.19,  46.50,   0.56,  12.02,    2.16,  2.27e-06,  2.32e-06,  2.04e-06,  nan ],
	[  1900,   93.54,   0.31,  148.20,   0.20,  49.14,   0.59,  11.78,    2.45,  2.27e-06,  2.08e-06,  1.94e-06,  nan ],
	[  2000,   98.26,   0.33,  151.09,   0.21,  51.40,   0.62,  11.57,    2.77,  2.41e-06,  2.20e-06,  2.12e-06,  nan ],
	[  2100,  100.87,   0.35,  156.37,   0.23,  38.58,   0.92,  11.53,    3.06,  2.33e-06,  2.47e-06,  2.35e-06,  nan ],
	[  2200,  108.85,   0.36,  164.82,   0.24,  40.74,   0.95,  11.62,    3.33,  2.41e-06,  2.62e-06,  2.43e-06,  nan ],
	[  2300,  114.08,   0.37,  172.11,   0.25,  42.18,   1.00,  11.70,    3.62,  2.65e-06,  2.50e-06,  2.51e-06,  nan ],
	[  2400,  119.45,   0.39,  182.97,   0.25,  44.08,   1.05,  11.57,    3.99,  2.51e-06,  2.74e-06,  2.65e-06,  nan ],
	[  2500,  122.36,   0.41,  188.88,   0.26,  45.82,   1.09,  11.65,    4.29,  2.87e-06,  2.60e-06,  2.67e-06,  nan ],
	[  2600,  126.16,   0.43,  191.85,   0.28,  46.93,   1.15,  11.71,    4.62,  2.64e-06,  2.72e-06,  2.92e-06,  nan ],
	[  2700,  132.65,   0.44,  201.11,   0.29,  49.16,   1.19,  11.65,    5.01,  2.82e-06,  2.94e-06,  2.94e-06,  nan ],
	[  2800,  135.53,   0.46,  204.35,   0.31,  50.61,   1.24,  11.74,    5.35,  2.73e-06,  2.55e-06,  2.65e-06,  nan ],
	[  2900,  140.82,   0.48,  208.98,   0.32,  52.27,   1.29,  11.69,    5.76,  2.62e-06,  2.53e-06,  2.64e-06,  nan ],
	[  3000,  143.81,   0.50,  213.08,   0.34,  53.52,   1.35,  11.71,    6.15,  3.28e-06,  2.94e-06,  3.15e-06,  nan ],
	[  3100,  149.08,   0.52,  219.02,   0.35,  43.28,   1.78,  11.63,    6.61,  2.84e-06,  2.84e-06,  2.68e-06,  nan ],
	[  3200,  152.65,   0.54,  234.17,   0.35,  45.03,   1.82,  11.71,    7.00,  2.50e-06,  2.83e-06,  2.78e-06,  nan ],
	[  3300,  159.08,   0.55,  232.55,   0.37,  46.39,   1.88,  11.80,    7.39,  3.05e-06,  2.75e-06,  2.67e-06,  nan ],
	[  3400,  161.69,   0.57,  239.69,   0.39,  47.50,   1.95,  11.85,    7.80,  3.29e-06,  3.45e-06,  2.89e-06,  nan ],
	[  3500,  165.61,   0.59,  246.83,   0.40,  48.75,   2.01,  11.80,    8.31,  2.75e-06,  2.74e-06,  2.74e-06,  nan ],
	[  3600,  172.02,   0.60,  253.08,   0.41,  50.18,   2.07,  16.34,    6.35,  2.92e-06,  3.01e-06,  2.83e-06,  nan ],
	[  3700,  173.68,   0.63,  257.16,   0.43,  51.24,   2.14,  17.70,    6.19,  2.64e-06,  2.66e-06,  2.78e-06,  nan ],
	[  3800,  178.86,   0.65,  260.32,   0.44,  52.53,   2.20,  17.85,    6.47,  2.87e-06,  3.09e-06,  2.99e-06,  nan ],
	[  3900,  178.21,   0.68,  261.83,   0.46,  54.10,   2.25,  17.88,    6.81,  3.52e-06,  3.90e-06,  3.41e-06,  nan ],
	[  4000,  176.90,   0.72,  264.57,   0.48,  54.84,   2.33,  17.49,    7.32,  3.26e-06,  3.19e-06,  3.56e-06,  nan ],
	[  4100,  176.55,   0.76,  267.42,   0.50,  46.36,   2.90,  17.89,    7.52,  3.35e-06,  3.85e-06,  3.39e-06,  nan ],
	[  4200,  177.54,   0.80,  263.86,   0.54,  47.32,   2.98,  17.92,    7.88,  3.97e-06,  3.47e-06,  3.69e-06,  nan ],
	[  4300,  179.58,   0.82,  266.60,   0.56,  48.74,   3.04,  17.92,    8.26,  3.72e-06,  4.09e-06,  3.63e-06,  nan ],
	[  4400,  181.62,   0.85,  264.81,   0.59,  49.48,   3.13,  17.94,    8.64,  3.89e-06,  4.00e-06,  3.89e-06,  nan ],
	[  4500,  182.47,   0.89,  260.92,   0.62,  50.27,   3.22,  11.88,   13.64,  3.50e-06,  3.78e-06,  3.95e-06,  nan ],
	[  4600,  183.67,   0.92,  257.71,   0.66,  50.97,   3.32,  11.87,   14.27,  3.67e-06,  4.01e-06,  3.72e-06,  nan ],
	[  4700,  184.72,   0.96,  259.89,   0.68,  52.52,   3.37,  11.92,   14.83,  3.25e-06,  3.96e-06,  3.71e-06,  nan ],
	[  4800,  187.38,   0.98,  264.12,   0.70,  53.26,   3.46,  11.86,   15.54,  3.40e-06,  3.51e-06,  3.35e-06,  nan ],
	[  4900,  185.09,   1.04,  257.55,   0.75,  54.26,   3.54,  17.92,   10.72,  3.81e-06,  3.63e-06,  3.41e-06,  nan ],
	[  5000,  188.73,   1.06,  260.19,   0.77,  54.69,   3.66,  17.95,   11.14,  3.82e-06,  3.93e-06,  3.72e-06,  nan ],
	[  5100,  190.45,   1.09,  262.16,   0.79,  55.95,   3.72,  17.73,   11.74,  4.54e-06,  4.33e-06,  4.23e-06,  nan ],
	[  5200,  192.36,   1.12,  262.91,   0.82,  49.08,   4.41,  17.85,   12.12,  4.56e-06,  3.60e-06,  3.86e-06,  nan ],
	[  5300,  193.60,   1.16,  262.91,   0.85,  49.76,   4.52,  17.83,   12.61,  4.35e-06,  4.20e-06,  3.78e-06,  nan ],
	[  5400,  193.16,   1.21,  266.39,   0.88,  50.60,   4.61,  17.84,   13.08,  4.37e-06,  4.19e-06,  4.18e-06,  nan ],
	[  5500,  194.28,   1.25,  264.26,   0.92,  51.45,   4.70,  17.80,   13.60,  3.96e-06,  4.21e-06,  3.98e-06,  nan ],
	[  5600,  198.71,   1.26,  272.75,   0.92,  52.53,   4.78,  17.81,   14.09,  4.30e-06,  4.23e-06,  3.93e-06,  nan ],
	[  5700,  199.54,   1.30,  267.73,   0.97,  52.54,   4.95,  17.77,   14.63,  4.82e-06,  4.57e-06,  4.21e-06,  nan ],
	[  5800,  197.35,   1.36,  267.61,   1.01,  53.22,   5.06,  17.96,   14.99,  4.72e-06,  4.16e-06,  4.56e-06,  nan ],
	[  5900,  202.59,   1.37,  269.39,   1.03,  54.38,   5.12,  17.99,   15.48,  4.44e-06,  4.57e-06,  4.22e-06,  nan ],
	[  6000,  202.86,   1.42,  269.46,   1.07,  55.07,   5.23,  18.02,   15.99,  3.96e-06,  4.19e-06,  4.38e-06,  nan ],
	[  6100,  204.80,   1.45,  272.44,   1.09,  55.32,   5.38,  17.96,   16.58,  4.42e-06,  4.36e-06,  4.19e-06,  nan ],
	[  6200,  205.47,   1.50,  270.75,   1.14,  49.75,   6.18,  17.78,   17.30,  4.30e-06,  3.72e-06,  3.64e-06,  nan ],
	[  6300,  206.78,   1.54,  273.59,   1.16,  50.60,   6.28,  17.88,   17.76,  4.10e-06,  3.97e-06,  3.92e-06,  nan ],
	[  6400,  209.15,   1.57,  274.94,   1.19,  50.75,   6.46,  18.50,   17.72,  4.27e-06,  4.06e-06,  3.99e-06,  nan ],
	[  6500,  208.96,   1.62,  279.63,   1.21,  51.65,   6.55,  17.95,   18.83,  4.34e-06,  4.60e-06,  4.64e-06,  nan ],
	[  6600,  212.16,   1.64,  277.73,   1.26,  52.33,   6.66,  17.97,   19.40,  4.47e-06,  4.21e-06,  4.35e-06,  nan ],
	[  6700,  214.83,   1.67,  279.78,   1.28,  52.66,   6.82,  17.92,   20.04,  4.60e-06,  3.92e-06,  4.14e-06,  nan ],
	[  6800,  213.14,   1.74,  278.42,   1.33,  54.04,   6.85,  18.04,   20.51,  5.02e-06,  4.63e-06,  4.54e-06,  nan ],
	[  6900,  215.99,   1.76,  279.74,   1.36,  53.63,   7.10,  12.00,   31.75,  4.32e-06,  4.04e-06,  4.03e-06,  nan ],
	[  7000,  215.79,   1.82,  282.51,   1.39,  54.89,   7.14,  11.92,   32.89,  3.98e-06,  4.41e-06,  3.93e-06,  nan ],
	[  7100,  217.10,   1.86,  283.87,   1.42,  54.94,   7.34,  12.02,   33.55,  3.96e-06,  4.29e-06,  3.89e-06,  nan ],
	[  7200,  221.01,   1.88,  286.11,   1.45,  50.47,   8.22,  17.55,   23.64,  4.42e-06,  4.70e-06,  4.21e-06,  nan ],
	[  7300,  221.62,   1.92,  284.11,   1.50,  51.04,   8.35,  17.55,   24.30,  4.03e-06,  3.88e-06,  4.02e-06,  nan ],
	[  7400,  222.31,   1.97,  286.22,   1.53,  51.85,   8.45,  17.70,   24.75,  4.23e-06,  4.36e-06,  4.17e-06,  nan ],
	[  7500,  222.59,   2.02,  287.78,   1.56,  52.22,   8.62,  17.82,   25.26,  5.06e-06,  4.69e-06,  4.76e-06,  nan ],
	[  7600,  227.90,   2.03,  283.90,   1.63,  52.97,   8.73,  17.75,   26.04,  4.94e-06,  5.63e-06,  4.43e-06,  nan ],
	[  7700,  227.23,   2.09,  283.90,   1.67,  52.92,   8.97,  16.34,   29.04,  4.60e-06,  4.57e-06,  4.37e-06,  nan ],
	[  7800,  224.75,   2.17,  285.01,   1.71,  53.98,   9.02,  17.74,   27.44,  4.75e-06,  4.47e-06,  4.62e-06,  nan ],
	[  7900,  223.73,   2.23,  287.83,   1.73,  55.03,   9.07,  17.80,   28.05,  5.08e-06,  4.45e-06,  4.42e-06,  nan ],
	[  8000,  224.79,   2.28,  285.78,   1.79,  54.93,   9.32,  17.88,   28.64,  5.85e-06,  5.49e-06,  5.40e-06,  nan ],
	[  8100,  225.61,   2.33,  285.48,   1.84,  55.34,   9.49,  17.06,   30.78,  5.83e-06,  5.85e-06,  5.81e-06,  nan ],
	[  8200,  226.43,   2.38,  284.67,   1.89,  50.28,  10.70,  16.70,   32.21,  4.92e-06,  4.59e-06,  5.04e-06,  nan ],
	[  8300,  226.93,   2.43,  284.73,   1.94,  51.76,  10.65,  17.42,   31.64,  5.43e-06,  5.51e-06,  5.62e-06,  nan ],
	[  8400,  225.65,   2.50,  288.82,   1.95,  51.60,  10.94,  17.82,   31.68,  4.96e-06,  5.60e-06,  5.12e-06,  nan ],
	[  8500,  230.14,   2.51,  284.36,   2.03,  51.93,  11.13,  16.84,   34.32,  5.41e-06,  5.41e-06,  5.77e-06,  nan ],
	[  8600,  226.99,   2.61,  281.52,   2.10,  53.55,  11.05,  17.82,   33.21,  5.15e-06,  4.98e-06,  5.10e-06,  nan ],
	[  8700,  226.50,   2.67,  288.13,   2.10,  53.27,  11.37,  18.11,   33.44,  5.43e-06,  5.18e-06,  5.21e-06,  nan ],
	[  8800,  225.48,   2.75,  283.69,   2.18,  53.82,  11.51,  17.91,   34.60,  5.13e-06,  5.60e-06,  5.31e-06,  nan ],
	[  8900,  226.91,   2.79,  284.31,   2.23,  54.31,  11.67,  17.05,   37.18,  5.01e-06,  4.99e-06,  5.12e-06,  nan ],
	[  9000,  229.18,   2.83,  283.49,   2.29,  54.58,  11.87,  16.97,   38.18,  5.66e-06,  5.96e-06,  5.92e-06,  nan ],
	[ 10000,  234.24,   3.42,  288.01,   2.78,  54.67,  14.64,  18.34,   43.63,  5.57e-06,  5.37e-06,  5.66e-06,  nan ],
	[ 12000,  240.07,   4.80,  292.20,   3.94,  54.92,  20.98,  17.49,   65.86,  7.29e-06,  6.05e-06,  6.26e-06,  nan ],
	[ 14000,  247.97,   6.32,  294.55,   5.32,  55.24,  28.39,  17.01,   92.20,  6.63e-06,  6.07e-06,  6.92e-06,  nan ],
	[ 16000,  252.80,   8.10,  293.73,   6.97,  55.60,  36.84,  15.59,  131.37,  6.96e-06,  8.01e-06,  7.20e-06,  nan ],
	[ 18000,  253.24,  10.24,  296.15,   8.75,  54.83,  47.28,  16.62,  155.97,  8.14e-06,  8.25e-06,  7.92e-06,  nan ],
	[ 20000,  261.48,  12.24,  295.01,  10.85,  54.07,  59.19,  17.37,  184.20,  8.79e-06,  8.79e-06,  9.38e-06,  nan ],
])

# numactl --interleave=all ../testing/testing_chemv -U -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000 --lapack
chemv_U = array([
	[    10,    0.02,   0.04,    0.03,   0.03,   0.03,   0.03,   0.48,    0.00,  2.13e-07,  1.07e-07,  2.86e-07,  nan ],
	[    11,    0.03,   0.03,    0.04,   0.03,   0.04,   0.03,   0.38,    0.00,  1.94e-07,  1.23e-07,  1.73e-07,  nan ],
	[    12,    0.03,   0.04,    0.05,   0.03,   0.05,   0.03,   0.60,    0.00,  1.78e-07,  1.59e-07,  1.78e-07,  nan ],
	[    13,    0.04,   0.04,    0.06,   0.03,   0.06,   0.03,   0.70,    0.00,  2.07e-07,  1.49e-07,  1.51e-07,  nan ],
	[    14,    0.05,   0.04,    0.07,   0.03,   0.07,   0.03,   0.91,    0.00,  1.52e-07,  1.52e-07,  2.04e-07,  nan ],
	[    15,    0.06,   0.04,    0.08,   0.03,   0.08,   0.03,   1.04,    0.00,  1.95e-07,  1.42e-07,  1.80e-07,  nan ],
	[    16,    0.06,   0.04,    0.09,   0.03,   0.09,   0.02,   1.17,    0.00,  1.33e-07,  2.40e-07,  2.38e-07,  nan ],
	[    17,    0.07,   0.04,    0.10,   0.03,   0.09,   0.03,   1.32,    0.00,  1.59e-07,  1.62e-07,  1.59e-07,  nan ],
	[    18,    0.08,   0.04,    0.11,   0.03,   0.10,   0.03,   1.47,    0.00,  2.37e-07,  2.12e-07,  2.37e-07,  nan ],
	[    19,    0.09,   0.03,    0.12,   0.03,   0.12,   0.03,   1.63,    0.00,  3.17e-07,  2.24e-07,  2.24e-07,  nan ],
	[    20,    0.10,   0.03,    0.14,   0.03,   0.13,   0.03,   1.80,    0.00,  1.97e-07,  1.55e-07,  2.13e-07,  nan ],
	[    21,    0.10,   0.04,    0.15,   0.03,   0.15,   0.03,   1.98,    0.00,  2.84e-07,  1.83e-07,  2.75e-07,  nan ],
	[    22,    0.11,   0.04,    0.17,   0.03,   0.16,   0.03,   2.17,    0.00,  2.60e-07,  3.57e-07,  1.94e-07,  nan ],
	[    23,    0.13,   0.04,    0.18,   0.03,   0.17,   0.03,   2.10,    0.00,  2.99e-07,  1.85e-07,  2.52e-07,  nan ],
	[    24,    0.14,   0.04,    0.19,   0.03,   0.19,   0.03,   2.57,    0.00,  2.41e-07,  2.38e-07,  2.40e-07,  nan ],
	[    25,    0.14,   0.04,    0.19,   0.03,   0.19,   0.03,   1.85,    0.00,  2.36e-07,  2.41e-07,  2.41e-07,  nan ],
	[    26,    0.15,   0.04,    0.21,   0.03,   0.21,   0.03,   2.00,    0.00,  1.85e-07,  1.64e-07,  1.64e-07,  nan ],
	[    27,    0.16,   0.04,    0.22,   0.03,   0.22,   0.03,   2.15,    0.00,  2.23e-07,  2.13e-07,  2.55e-07,  nan ],
	[    28,    0.18,   0.04,    0.23,   0.03,   0.25,   0.03,   2.31,    0.00,  2.46e-07,  2.28e-07,  2.75e-07,  nan ],
	[    29,    0.19,   0.04,    0.25,   0.03,   0.26,   0.03,   2.47,    0.00,  1.97e-07,  2.71e-07,  1.47e-07,  nan ],
	[    30,    0.19,   0.04,    0.26,   0.03,   0.27,   0.03,   2.64,    0.00,  2.01e-07,  1.42e-07,  2.29e-07,  nan ],
	[    31,    0.21,   0.04,    0.27,   0.03,   0.29,   0.03,   2.60,    0.00,  1.95e-07,  2.54e-07,  2.63e-07,  nan ],
	[    32,    0.24,   0.04,    0.27,   0.03,   0.31,   0.03,   2.25,    0.00,  2.15e-07,  2.46e-07,  1.81e-07,  nan ],
	[    33,    0.25,   0.04,    0.24,   0.04,   0.29,   0.03,   2.39,    0.00,  2.33e-07,  1.83e-07,  2.38e-07,  nan ],
	[    34,    0.26,   0.04,    0.25,   0.04,   0.33,   0.03,   3.12,    0.00,  3.37e-07,  2.31e-07,  3.41e-07,  nan ],
	[    35,    0.28,   0.04,    0.27,   0.04,   0.35,   0.03,   2.52,    0.00,  3.31e-07,  3.45e-07,  3.31e-07,  nan ],
	[    36,    0.30,   0.04,    0.29,   0.04,   0.37,   0.03,   3.48,    0.00,  3.35e-07,  3.18e-07,  2.37e-07,  nan ],
	[    37,    0.30,   0.04,    0.32,   0.04,   0.40,   0.03,   2.99,    0.00,  2.31e-07,  3.46e-07,  2.92e-07,  nan ],
	[    38,    0.32,   0.04,    0.32,   0.04,   0.42,   0.03,   4.20,    0.00,  3.05e-07,  2.37e-07,  3.62e-07,  nan ],
	[    39,    0.34,   0.04,    0.35,   0.04,   0.42,   0.03,   4.08,    0.00,  3.09e-07,  3.09e-07,  1.97e-07,  nan ],
	[    40,    0.37,   0.04,    0.38,   0.04,   0.46,   0.03,   3.48,    0.00,  2.13e-07,  2.13e-07,  2.38e-07,  nan ],
	[    41,    0.36,   0.04,    0.40,   0.04,   0.48,   0.03,   3.44,    0.00,  3.35e-07,  2.83e-07,  2.33e-07,  nan ],
	[    42,    0.36,   0.04,    0.40,   0.04,   0.51,   0.03,   2.92,    0.01,  3.05e-07,  2.76e-07,  2.81e-07,  nan ],
	[    43,    0.40,   0.04,    0.44,   0.04,   0.51,   0.03,   3.78,    0.00,  4.70e-07,  3.66e-07,  3.75e-07,  nan ],
	[    44,    0.41,   0.04,    0.44,   0.04,   0.56,   0.03,   3.95,    0.00,  2.76e-07,  2.68e-07,  3.48e-07,  nan ],
	[    45,    0.45,   0.04,    0.46,   0.04,   0.56,   0.03,   4.13,    0.00,  2.68e-07,  3.39e-07,  3.06e-07,  nan ],
	[    46,    0.49,   0.04,    0.49,   0.04,   0.60,   0.03,   4.31,    0.00,  2.78e-07,  2.62e-07,  4.15e-07,  nan ],
	[    47,    0.48,   0.04,    0.49,   0.04,   0.61,   0.03,   4.50,    0.00,  3.42e-07,  4.08e-07,  2.57e-07,  nan ],
	[    48,    0.51,   0.04,    0.53,   0.04,   0.63,   0.03,   3.80,    0.01,  3.28e-07,  3.20e-07,  2.51e-07,  nan ],
	[    49,    0.51,   0.04,    0.56,   0.04,   0.64,   0.03,   3.95,    0.01,  3.90e-07,  3.48e-07,  3.40e-07,  nan ],
	[    50,    0.57,   0.04,    0.59,   0.04,   0.66,   0.03,   4.11,    0.01,  3.08e-07,  3.15e-07,  3.24e-07,  nan ],
	[    51,    0.57,   0.04,    0.61,   0.04,   0.69,   0.03,   3.59,    0.01,  2.92e-07,  3.08e-07,  3.08e-07,  nan ],
	[    52,    0.60,   0.04,    0.64,   0.04,   0.74,   0.03,   4.45,    0.01,  3.10e-07,  3.69e-07,  2.94e-07,  nan ],
	[    53,    0.64,   0.04,    0.66,   0.03,   0.75,   0.03,   3.73,    0.01,  3.86e-07,  3.60e-07,  3.60e-07,  nan ],
	[    54,    0.64,   0.04,    0.68,   0.04,   0.80,   0.03,   4.79,    0.01,  3.60e-07,  2.55e-07,  2.30e-07,  nan ],
	[    55,    0.65,   0.04,    0.71,   0.04,   0.83,   0.03,   6.13,    0.00,  2.94e-07,  2.77e-07,  4.04e-07,  nan ],
	[    56,    0.70,   0.04,    0.76,   0.03,   0.83,   0.03,   6.36,    0.00,  3.47e-07,  2.81e-07,  3.47e-07,  nan ],
	[    57,    0.70,   0.04,    0.77,   0.03,   0.86,   0.03,   5.33,    0.01,  2.76e-07,  2.68e-07,  2.76e-07,  nan ],
	[    58,    0.71,   0.04,    0.79,   0.04,   0.93,   0.03,   5.51,    0.01,  2.94e-07,  2.63e-07,  2.37e-07,  nan ],
	[    59,    0.77,   0.04,    0.82,   0.03,   0.95,   0.03,   4.79,    0.01,  2.76e-07,  2.67e-07,  2.04e-07,  nan ],
	[    60,    0.72,   0.04,    0.80,   0.04,   0.89,   0.03,   4.95,    0.01,  2.70e-07,  3.18e-07,  2.29e-07,  nan ],
	[    61,    0.78,   0.04,    0.83,   0.04,   0.95,   0.03,   5.12,    0.01,  3.26e-07,  3.13e-07,  3.15e-07,  nan ],
	[    62,    0.81,   0.04,    0.73,   0.04,   1.02,   0.03,   4.56,    0.01,  3.48e-07,  2.75e-07,  3.31e-07,  nan ],
	[    63,    0.79,   0.04,    0.86,   0.04,   1.05,   0.03,   4.70,    0.01,  3.09e-07,  3.63e-07,  3.09e-07,  nan ],
	[    64,    0.93,   0.04,    0.96,   0.04,   1.05,   0.03,   6.70,    0.01,  3.37e-07,  4.00e-07,  3.77e-07,  nan ],
	[    65,    0.79,   0.04,    0.94,   0.04,   1.02,   0.03,   5.80,    0.01,  2.95e-07,  3.71e-07,  3.52e-07,  nan ],
	[    66,    0.83,   0.04,    0.96,   0.04,   1.05,   0.03,   5.15,    0.01,  3.52e-07,  3.66e-07,  3.52e-07,  nan ],
	[    67,    0.84,   0.04,    0.94,   0.04,   1.08,   0.03,   5.92,    0.01,  5.09e-07,  3.42e-07,  2.90e-07,  nan ],
	[    68,    0.88,   0.04,    0.99,   0.04,   1.11,   0.03,   5.47,    0.01,  3.39e-07,  3.39e-07,  3.37e-07,  nan ],
	[    69,    0.91,   0.04,    1.03,   0.04,   1.18,   0.03,   4.95,    0.01,  5.10e-07,  3.99e-07,  4.46e-07,  nan ],
	[    70,    0.93,   0.04,    1.03,   0.04,   1.18,   0.03,   5.60,    0.01,  3.49e-07,  4.37e-07,  3.93e-07,  nan ],
	[    71,    0.93,   0.04,    1.09,   0.04,   1.24,   0.03,   5.76,    0.01,  4.43e-07,  3.27e-07,  3.27e-07,  nan ],
	[    72,    0.99,   0.04,    1.15,   0.04,   1.24,   0.03,   5.92,    0.01,  3.44e-07,  4.25e-07,  3.35e-07,  nan ],
	[    73,    1.09,   0.04,    1.14,   0.04,   1.28,   0.03,   6.08,    0.01,  5.23e-07,  3.30e-07,  4.25e-07,  nan ],
	[    74,    1.01,   0.04,    1.21,   0.04,   1.32,   0.03,   5.51,    0.01,  5.26e-07,  4.16e-07,  4.25e-07,  nan ],
	[    75,    1.12,   0.04,    1.17,   0.04,   1.36,   0.03,   6.42,    0.01,  3.67e-07,  3.67e-07,  3.67e-07,  nan ],
	[    76,    1.15,   0.04,    1.27,   0.04,   1.38,   0.03,   6.82,    0.01,  3.62e-07,  4.02e-07,  5.03e-07,  nan ],
	[    77,    1.18,   0.04,    1.28,   0.04,   1.51,   0.03,   6.76,    0.01,  4.43e-07,  4.23e-07,  4.23e-07,  nan ],
	[    78,    1.25,   0.04,    1.34,   0.04,   1.50,   0.03,   6.31,    0.01,  4.15e-07,  3.53e-07,  4.03e-07,  nan ],
	[    79,    1.24,   0.04,    1.38,   0.04,   1.49,   0.03,   6.47,    0.01,  4.13e-07,  3.05e-07,  3.09e-07,  nan ],
	[    80,    1.24,   0.04,    1.41,   0.04,   1.53,   0.03,   6.63,    0.01,  3.44e-07,  3.84e-07,  3.81e-07,  nan ],
	[    81,    1.30,   0.04,    1.48,   0.04,   1.48,   0.04,   7.73,    0.01,  3.83e-07,  3.02e-07,  4.71e-07,  nan ],
	[    82,    1.25,   0.04,    1.48,   0.04,   1.52,   0.04,   7.92,    0.01,  3.79e-07,  3.79e-07,  3.84e-07,  nan ],
	[    83,    1.28,   0.04,    1.47,   0.04,   1.57,   0.04,   9.41,    0.01,  4.95e-07,  3.68e-07,  4.60e-07,  nan ],
	[    84,    1.30,   0.04,    1.52,   0.04,   1.55,   0.04,   8.31,    0.01,  3.85e-07,  3.74e-07,  3.74e-07,  nan ],
	[    85,    1.37,   0.04,    1.55,   0.04,   1.63,   0.04,   8.22,    0.01,  3.81e-07,  3.59e-07,  2.84e-07,  nan ],
	[    86,    1.36,   0.04,    1.54,   0.04,   1.67,   0.04,   8.42,    0.01,  3.56e-07,  3.59e-07,  3.66e-07,  nan ],
	[    87,    1.40,   0.04,    1.62,   0.04,   1.67,   0.04,   7.83,    0.01,  5.37e-07,  3.51e-07,  3.57e-07,  nan ],
	[    88,    1.47,   0.04,    1.70,   0.04,   1.75,   0.04,   8.01,    0.01,  3.47e-07,  2.74e-07,  2.91e-07,  nan ],
	[    89,    1.43,   0.05,    1.65,   0.04,   1.74,   0.04,   7.95,    0.01,  3.66e-07,  3.83e-07,  4.29e-07,  nan ],
	[    90,    1.46,   0.05,    1.68,   0.04,   1.83,   0.04,   7.27,    0.01,  5.09e-07,  4.43e-07,  4.32e-07,  nan ],
	[   100,    1.89,   0.04,    2.03,   0.04,   2.13,   0.04,  10.02,    0.01,  3.89e-07,  3.15e-07,  4.58e-07,  nan ],
	[   110,    2.18,   0.05,    2.45,   0.04,   2.59,   0.04,  10.83,    0.01,  3.54e-07,  4.16e-07,  4.17e-07,  nan ],
	[   120,    2.70,   0.04,    2.98,   0.04,   2.98,   0.04,  10.64,    0.01,  4.52e-07,  4.45e-07,  3.83e-07,  nan ],
	[   130,    2.85,   0.05,    3.19,   0.04,   3.33,   0.04,  12.47,    0.01,  5.25e-07,  4.84e-07,  5.01e-07,  nan ],
	[   140,    3.29,   0.05,    3.86,   0.04,   3.86,   0.04,  12.09,    0.01,  4.41e-07,  4.61e-07,  4.46e-07,  nan ],
	[   150,    3.70,   0.05,    4.21,   0.04,   4.21,   0.04,  13.86,    0.01,  5.09e-07,  5.09e-07,  4.10e-07,  nan ],
	[   160,    4.05,   0.05,    5.29,   0.04,   4.69,   0.04,  13.76,    0.02,  5.33e-07,  4.98e-07,  4.98e-07,  nan ],
	[   170,    4.68,   0.05,    5.18,   0.05,   5.07,   0.05,  13.78,    0.02,  5.46e-07,  5.40e-07,  5.55e-07,  nan ],
	[   180,    5.22,   0.05,    5.93,   0.04,   5.43,   0.05,  15.44,    0.02,  6.99e-07,  5.99e-07,  7.82e-07,  nan ],
	[   190,    5.81,   0.05,    6.04,   0.05,   6.07,   0.05,  15.26,    0.02,  4.90e-07,  5.02e-07,  4.84e-07,  nan ],
	[   200,    5.78,   0.06,    7.19,   0.04,   6.60,   0.05,  16.10,    0.02,  5.35e-07,  6.52e-07,  5.55e-07,  nan ],
	[   210,    6.34,   0.06,    7.89,   0.05,   7.10,   0.05,  16.20,    0.02,  6.50e-07,  6.54e-07,  6.58e-07,  nan ],
	[   220,    6.59,   0.06,    8.30,   0.05,   7.50,   0.05,  16.19,    0.02,  6.28e-07,  6.95e-07,  6.94e-07,  nan ],
	[   230,    7.35,   0.06,    8.01,   0.05,   8.05,   0.05,  16.39,    0.03,  7.33e-07,  7.99e-07,  7.99e-07,  nan ],
	[   240,    8.14,   0.06,    9.44,   0.05,   8.76,   0.05,  17.84,    0.03,  6.36e-07,  8.92e-07,  7.66e-07,  nan ],
	[   250,    8.98,   0.06,   10.71,   0.05,   8.98,   0.06,  17.88,    0.03,  6.57e-07,  6.22e-07,  6.74e-07,  nan ],
	[   260,    8.24,   0.07,   11.07,   0.05,   9.24,   0.06,  17.55,    0.03,  7.07e-07,  5.88e-07,  5.93e-07,  nan ],
	[   270,    9.28,   0.06,   10.84,   0.05,   9.80,   0.06,  17.20,    0.03,  7.24e-07,  5.90e-07,  6.99e-07,  nan ],
	[   280,   10.02,   0.06,   12.36,   0.05,  10.50,   0.06,  18.63,    0.03,  6.68e-07,  6.78e-07,  6.74e-07,  nan ],
	[   290,   10.54,   0.06,   13.01,   0.05,  11.08,   0.06,  18.30,    0.04,  6.74e-07,  7.39e-07,  7.37e-07,  nan ],
	[   300,   10.80,   0.07,   13.43,   0.05,  11.28,   0.06,  18.97,    0.04,  7.41e-07,  7.41e-07,  6.51e-07,  nan ],
	[   310,   11.53,   0.07,   13.79,   0.06,  12.05,   0.06,  18.41,    0.04,  8.25e-07,  7.88e-07,  7.88e-07,  nan ],
	[   320,   12.46,   0.07,   16.76,   0.05,  12.88,   0.06,  19.61,    0.04,  9.54e-07,  8.59e-07,  9.54e-07,  nan ],
	[   330,   12.32,   0.07,   16.17,   0.05,  13.25,   0.07,  19.84,    0.04,  6.94e-07,  6.63e-07,  6.54e-07,  nan ],
	[   340,   12.73,   0.07,   17.24,   0.05,  13.43,   0.07,  19.78,    0.05,  8.09e-07,  8.08e-07,  7.24e-07,  nan ],
	[   350,   13.27,   0.07,   16.38,   0.06,  14.28,   0.07,  17.64,    0.06,  7.19e-07,  8.04e-07,  8.04e-07,  nan ],
	[   360,   14.27,   0.07,   18.27,   0.06,  14.90,   0.07,  19.32,    0.05,  9.17e-07,  8.52e-07,  9.32e-07,  nan ],
	[   370,   15.48,   0.07,   19.30,   0.06,  15.07,   0.07,  20.05,    0.05,  8.49e-07,  8.50e-07,  7.78e-07,  nan ],
	[   380,   16.32,   0.07,   20.70,   0.06,  15.90,   0.07,  20.35,    0.06,  8.87e-07,  8.14e-07,  9.00e-07,  nan ],
	[   390,   15.43,   0.08,   17.98,   0.07,  16.53,   0.07,  20.01,    0.06,  8.92e-07,  8.75e-07,  1.03e-06,  nan ],
	[   400,   16.68,   0.08,   21.47,   0.06,  17.11,   0.08,  19.81,    0.06,  9.56e-07,  8.70e-07,  9.44e-07,  nan ],
	[   410,   17.10,   0.08,   22.55,   0.06,  17.53,   0.08,  20.15,    0.07,  8.22e-07,  8.21e-07,  8.19e-07,  nan ],
	[   420,   17.07,   0.08,   22.50,   0.06,  18.17,   0.08,  19.16,    0.07,  9.47e-07,  8.75e-07,  8.75e-07,  nan ],
	[   430,   18.10,   0.08,   21.85,   0.07,  17.89,   0.08,  20.62,    0.07,  9.25e-07,  9.33e-07,  9.25e-07,  nan ],
	[   440,   18.95,   0.08,   24.32,   0.06,  19.17,   0.08,  21.30,    0.07,  1.11e-06,  1.05e-06,  1.11e-06,  nan ],
	[   450,   18.28,   0.09,   24.61,   0.07,  19.82,   0.08,  20.85,    0.08,  9.22e-07,  9.87e-07,  1.04e-06,  nan ],
	[   460,   19.10,   0.09,   25.72,   0.07,  20.18,   0.08,  21.26,    0.08,  8.93e-07,  9.38e-07,  8.93e-07,  nan ],
	[   470,   20.15,   0.09,   24.62,   0.07,  17.92,   0.10,  21.12,    0.08,  1.09e-06,  1.04e-06,  1.05e-06,  nan ],
	[   480,   21.02,   0.09,   31.27,   0.06,  21.97,   0.08,  20.09,    0.09,  8.33e-07,  9.56e-07,  8.94e-07,  nan ],
	[   490,   21.67,   0.09,   27.87,   0.07,  21.44,   0.09,  21.21,    0.09,  1.00e-06,  1.00e-06,  1.06e-06,  nan ],
	[   500,   22.80,   0.09,   29.52,   0.07,  22.26,   0.09,  21.35,    0.09,  9.53e-07,  1.15e-06,  1.10e-06,  nan ],
	[   510,   22.91,   0.09,   27.44,   0.08,  22.68,   0.09,  21.09,    0.10,  8.90e-07,  9.11e-07,  8.90e-07,  nan ],
	[   520,   22.86,   0.09,   30.53,   0.07,  23.57,   0.09,  20.63,    0.11,  9.99e-07,  8.82e-07,  9.39e-07,  nan ],
	[   530,   23.75,   0.09,   31.72,   0.07,  23.22,   0.10,  20.68,    0.11,  9.50e-07,  8.56e-07,  9.94e-07,  nan ],
	[   540,   24.11,   0.10,   32.06,   0.07,  24.59,   0.10,  21.66,    0.11,  1.17e-06,  1.19e-06,  1.19e-06,  nan ],
	[   550,   24.76,   0.10,   28.51,   0.09,  24.70,   0.10,  21.70,    0.11,  1.22e-06,  1.01e-06,  1.12e-06,  nan ],
	[   560,   25.42,   0.10,   33.07,   0.08,  25.67,   0.10,  21.53,    0.12,  1.20e-06,  1.32e-06,  1.42e-06,  nan ],
	[   570,   26.34,   0.10,   35.26,   0.07,  26.09,   0.10,  21.90,    0.12,  1.21e-06,  1.10e-06,  1.18e-06,  nan ],
	[   580,   25.72,   0.10,   33.29,   0.08,  26.95,   0.10,  21.93,    0.12,  1.16e-06,  1.27e-06,  1.17e-06,  nan ],
	[   590,   26.31,   0.11,   32.17,   0.09,  27.11,   0.10,  21.65,    0.13,  1.34e-06,  1.45e-06,  1.45e-06,  nan ],
	[   600,   26.73,   0.11,   37.03,   0.08,  27.27,   0.11,  21.70,    0.13,  1.12e-06,  1.10e-06,  1.00e-06,  nan ],
	[   610,   27.88,   0.11,   36.81,   0.08,  27.88,   0.11,  21.92,    0.14,  1.18e-06,  1.13e-06,  1.18e-06,  nan ],
	[   620,   28.80,   0.11,   37.59,   0.08,  28.29,   0.11,  22.49,    0.14,  1.28e-06,  1.28e-06,  1.21e-06,  nan ],
	[   630,   28.96,   0.11,   35.69,   0.09,  29.15,   0.11,  21.22,    0.15,  1.07e-06,  1.07e-06,  1.16e-06,  nan ],
	[   640,   30.08,   0.11,   45.02,   0.07,  29.63,   0.11,  22.18,    0.15,  1.15e-06,  1.24e-06,  1.14e-06,  nan ],
	[   650,   28.94,   0.12,   40.37,   0.08,  29.73,   0.11,  22.31,    0.15,  1.13e-06,  1.05e-06,  1.13e-06,  nan ],
	[   660,   30.39,   0.11,   41.04,   0.09,  30.65,   0.11,  21.70,    0.16,  1.20e-06,  1.19e-06,  1.37e-06,  nan ],
	[   670,   30.50,   0.12,   37.46,   0.10,  30.75,   0.12,  22.10,    0.16,  1.28e-06,  1.28e-06,  1.28e-06,  nan ],
	[   680,   31.93,   0.12,   43.19,   0.09,  32.00,   0.12,  22.34,    0.17,  1.26e-06,  1.35e-06,  1.26e-06,  nan ],
	[   690,   32.08,   0.12,   43.39,   0.09,  32.02,   0.12,  21.66,    0.18,  1.19e-06,  1.35e-06,  1.17e-06,  nan ],
	[   700,   32.69,   0.12,   44.65,   0.09,  31.93,   0.12,  22.60,    0.17,  1.52e-06,  1.41e-06,  1.40e-06,  nan ],
	[   710,   32.10,   0.13,   37.84,   0.11,  33.17,   0.12,  22.07,    0.18,  1.21e-06,  1.39e-06,  1.22e-06,  nan ],
	[   720,   33.78,   0.12,   46.24,   0.09,  33.52,   0.12,  22.61,    0.18,  1.27e-06,  1.27e-06,  1.27e-06,  nan ],
	[   730,   33.37,   0.13,   46.91,   0.09,  32.34,   0.13,  22.48,    0.19,  1.43e-06,  1.42e-06,  1.34e-06,  nan ],
	[   740,   34.29,   0.13,   48.20,   0.09,  33.54,   0.13,  22.08,    0.20,  1.66e-06,  1.52e-06,  1.63e-06,  nan ],
	[   750,   35.82,   0.13,   42.88,   0.11,  33.41,   0.13,  22.30,    0.20,  1.32e-06,  1.26e-06,  1.38e-06,  nan ],
	[   760,   35.90,   0.13,   49.16,   0.09,  34.55,   0.13,  22.04,    0.21,  1.29e-06,  1.37e-06,  1.30e-06,  nan ],
	[   770,   35.72,   0.13,   49.59,   0.10,  35.72,   0.13,  22.83,    0.21,  1.43e-06,  1.43e-06,  1.51e-06,  nan ],
	[   780,   36.66,   0.13,   50.75,   0.10,  35.57,   0.14,  22.06,    0.22,  1.33e-06,  1.25e-06,  1.35e-06,  nan ],
	[   790,   37.33,   0.13,   45.91,   0.11,  36.55,   0.14,  21.74,    0.23,  1.28e-06,  1.47e-06,  1.32e-06,  nan ],
	[   800,   37.16,   0.14,   59.60,   0.09,  36.90,   0.14,  22.20,    0.23,  1.53e-06,  1.37e-06,  1.60e-06,  nan ],
	[   810,   38.69,   0.14,   53.66,   0.10,  36.76,   0.14,  22.28,    0.24,  1.26e-06,  1.29e-06,  1.21e-06,  nan ],
	[   820,   39.86,   0.14,   54.47,   0.10,  37.67,   0.14,  22.83,    0.24,  1.36e-06,  1.42e-06,  1.41e-06,  nan ],
	[   830,   40.34,   0.14,   48.45,   0.11,  38.09,   0.14,  22.44,    0.25,  1.25e-06,  1.35e-06,  1.28e-06,  nan ],
	[   840,   39.60,   0.14,   56.07,   0.10,  39.01,   0.14,  22.25,    0.25,  1.37e-06,  1.29e-06,  1.33e-06,  nan ],
	[   850,   40.82,   0.14,   56.22,   0.10,  38.86,   0.15,  22.89,    0.25,  1.32e-06,  1.50e-06,  1.45e-06,  nan ],
	[   860,   40.89,   0.14,   58.77,   0.10,  40.03,   0.15,  22.70,    0.26,  1.19e-06,  1.16e-06,  1.21e-06,  nan ],
	[   870,   41.84,   0.14,   47.38,   0.13,  40.71,   0.15,  21.89,    0.28,  1.20e-06,  1.40e-06,  1.27e-06,  nan ],
	[   880,   43.38,   0.14,   60.96,   0.10,  41.65,   0.15,  22.48,    0.28,  1.39e-06,  1.39e-06,  1.35e-06,  nan ],
	[   890,   44.08,   0.14,   60.37,   0.11,  41.47,   0.15,  22.35,    0.28,  1.27e-06,  1.24e-06,  1.18e-06,  nan ],
	[   900,   42.94,   0.15,   62.30,   0.10,  42.47,   0.15,  22.84,    0.28,  1.24e-06,  1.24e-06,  1.31e-06,  nan ],
	[  1000,   49.78,   0.16,   69.72,   0.11,  47.07,   0.17,  22.63,    0.35,  1.53e-06,  1.32e-06,  1.38e-06,  nan ],
	[  1100,   54.50,   0.18,   72.86,   0.13,  30.68,   0.32,  23.02,    0.42,  1.35e-06,  1.34e-06,  1.45e-06,  nan ],
	[  1200,   60.70,   0.19,   84.88,   0.14,  33.64,   0.34,  23.16,    0.50,  2.06e-06,  1.82e-06,  1.83e-06,  nan ],
	[  1300,   55.01,   0.25,   92.01,   0.15,  34.45,   0.39,  23.37,    0.58,  1.88e-06,  1.78e-06,  1.88e-06,  nan ],
	[  1400,   72.67,   0.22,   99.30,   0.16,  38.39,   0.41,  23.79,    0.66,  1.92e-06,  1.86e-06,  1.94e-06,  nan ],
	[  1500,   74.82,   0.24,  105.40,   0.17,  39.78,   0.45,  23.19,    0.78,  2.00e-06,  1.68e-06,  1.80e-06,  nan ],
	[  1600,   79.46,   0.26,  129.68,   0.16,  41.74,   0.49,  23.06,    0.89,  2.14e-06,  1.91e-06,  1.95e-06,  nan ],
	[  1700,   86.66,   0.27,  123.01,   0.19,  44.24,   0.52,  21.51,    1.08,  2.16e-06,  1.93e-06,  2.24e-06,  nan ],
	[  1800,   90.98,   0.29,  130.31,   0.20,  46.66,   0.56,  19.88,    1.31,  1.97e-06,  1.90e-06,  2.10e-06,  nan ],
	[  1900,   95.68,   0.30,  133.95,   0.22,  49.06,   0.59,  18.47,    1.56,  2.03e-06,  2.07e-06,  1.93e-06,  nan ],
	[  2000,  100.69,   0.32,  136.23,   0.24,  51.66,   0.62,  17.13,    1.87,  2.38e-06,  2.45e-06,  2.20e-06,  nan ],
	[  2100,  106.00,   0.33,  134.74,   0.26,  39.09,   0.90,  16.69,    2.12,  2.10e-06,  2.10e-06,  2.10e-06,  nan ],
	[  2200,  109.14,   0.36,  142.43,   0.27,  40.32,   0.96,  16.80,    2.31,  2.00e-06,  2.33e-06,  1.91e-06,  nan ],
	[  2300,  117.01,   0.36,  140.74,   0.30,  41.72,   1.01,  16.46,    2.57,  2.33e-06,  2.28e-06,  2.34e-06,  nan ],
	[  2400,  120.72,   0.38,  181.59,   0.25,  43.55,   1.06,  16.28,    2.83,  2.71e-06,  2.67e-06,  2.55e-06,  nan ],
	[  2500,  122.57,   0.41,  154.41,   0.32,  45.82,   1.09,  16.40,    3.05,  3.04e-06,  3.15e-06,  2.94e-06,  nan ],
	[  2600,  126.72,   0.43,  155.88,   0.35,  46.37,   1.17,  16.49,    3.28,  2.45e-06,  2.44e-06,  2.63e-06,  nan ],
	[  2700,  132.37,   0.44,  159.44,   0.37,  49.21,   1.19,  16.46,    3.55,  2.81e-06,  2.80e-06,  2.99e-06,  nan ],
	[  2800,  134.63,   0.47,  156.48,   0.40,  48.64,   1.29,  16.74,    3.75,  3.14e-06,  2.89e-06,  3.23e-06,  nan ],
	[  2900,  142.67,   0.47,  165.01,   0.41,  52.46,   1.28,  16.87,    3.99,  3.03e-06,  2.95e-06,  2.95e-06,  nan ],
	[  3000,  145.54,   0.49,  173.15,   0.42,  54.90,   1.31,  16.74,    4.30,  2.65e-06,  2.92e-06,  2.77e-06,  nan ],
	[  3100,  147.92,   0.52,  175.62,   0.44,  43.02,   1.79,  17.30,    4.45,  3.07e-06,  3.39e-06,  3.23e-06,  nan ],
	[  3200,  156.11,   0.52,  201.85,   0.41,  44.09,   1.86,  17.10,    4.79,  3.16e-06,  3.15e-06,  2.68e-06,  nan ],
	[  3300,  160.20,   0.54,  187.09,   0.47,  46.14,   1.89,  16.81,    5.18,  3.85e-06,  3.85e-06,  4.00e-06,  nan ],
	[  3400,  159.76,   0.58,  183.57,   0.50,  47.40,   1.95,  16.85,    5.49,  2.96e-06,  2.87e-06,  2.95e-06,  nan ],
	[  3500,  169.64,   0.58,  187.77,   0.52,  48.54,   2.02,  16.93,    5.79,  2.93e-06,  2.66e-06,  2.93e-06,  nan ],
	[  3600,  171.68,   0.60,  193.87,   0.54,  49.77,   2.08,  16.38,    6.33,  3.42e-06,  3.34e-06,  3.94e-06,  nan ],
	[  3700,  177.02,   0.62,  194.97,   0.56,  51.23,   2.14,  17.01,    6.44,  2.87e-06,  2.78e-06,  2.98e-06,  nan ],
	[  3800,  177.55,   0.65,  199.97,   0.58,  52.69,   2.19,  17.17,    6.73,  2.70e-06,  2.64e-06,  2.96e-06,  nan ],
	[  3900,  185.25,   0.66,  198.28,   0.61,  53.65,   2.27,  17.09,    7.12,  3.01e-06,  3.01e-06,  3.20e-06,  nan ],
	[  4000,  185.07,   0.69,  218.95,   0.58,  55.00,   2.33,  17.30,    7.40,  3.19e-06,  3.50e-06,  3.22e-06,  nan ],
	[  4100,  185.79,   0.72,  193.57,   0.69,  47.71,   2.82,  17.36,    7.75,  3.16e-06,  3.20e-06,  3.28e-06,  nan ],
	[  4200,  188.51,   0.75,  196.39,   0.72,  46.70,   3.02,  17.17,    8.22,  2.94e-06,  3.14e-06,  3.07e-06,  nan ],
	[  4300,  194.74,   0.76,  204.16,   0.72,  47.52,   3.11,  17.33,    8.54,  4.10e-06,  3.99e-06,  3.65e-06,  nan ],
	[  4400,  201.50,   0.77,  202.00,   0.77,  48.71,   3.18,  17.39,    8.91,  3.93e-06,  4.10e-06,  4.11e-06,  nan ],
	[  4500,  201.57,   0.80,  205.10,   0.79,  50.25,   3.23,  17.43,    9.30,  3.64e-06,  3.49e-06,  3.36e-06,  nan ],
	[  4600,  209.26,   0.81,  205.51,   0.82,  51.11,   3.31,  15.54,   10.90,  3.72e-06,  4.14e-06,  3.82e-06,  nan ],
	[  4700,  208.98,   0.85,  211.97,   0.83,  52.10,   3.39,  17.40,   10.16,  3.53e-06,  3.32e-06,  3.55e-06,  nan ],
	[  4800,  210.43,   0.88,  237.95,   0.77,  53.06,   3.47,  17.41,   10.59,  3.75e-06,  3.49e-06,  3.81e-06,  nan ],
	[  4900,  217.10,   0.89,  213.25,   0.90,  54.31,   3.54,  17.45,   11.01,  4.77e-06,  4.12e-06,  3.99e-06,  nan ],
	[  5000,  220.07,   0.91,  214.44,   0.93,  54.85,   3.65,  17.64,   11.34,  3.91e-06,  4.21e-06,  4.11e-06,  nan ],
	[  5100,  221.63,   0.94,  215.03,   0.97,  55.77,   3.73,  17.55,   11.86,  3.84e-06,  4.02e-06,  4.12e-06,  nan ],
	[  5200,  221.95,   0.97,  218.59,   0.99,  47.87,   4.52,  17.37,   12.45,  3.98e-06,  3.85e-06,  4.13e-06,  nan ],
	[  5300,  225.50,   1.00,  218.45,   1.03,  49.23,   4.57,  17.46,   12.87,  4.05e-06,  4.15e-06,  4.07e-06,  nan ],
	[  5400,  225.88,   1.03,  219.94,   1.06,  50.10,   4.66,  17.50,   13.33,  4.03e-06,  4.35e-06,  4.22e-06,  nan ],
	[  5500,  226.48,   1.07,  220.67,   1.10,  50.76,   4.77,  17.63,   13.73,  4.02e-06,  3.92e-06,  3.83e-06,  nan ],
	[  5600,  235.15,   1.07,  248.71,   1.01,  51.88,   4.84,  17.56,   14.29,  4.29e-06,  4.24e-06,  4.10e-06,  nan ],
	[  5700,  237.42,   1.10,  229.86,   1.13,  52.78,   4.93,  17.63,   14.75,  4.77e-06,  5.23e-06,  4.92e-06,  nan ],
	[  5800,  240.12,   1.12,  222.08,   1.21,  53.80,   5.00,  17.57,   15.32,  4.00e-06,  3.68e-06,  3.96e-06,  nan ],
	[  5900,  241.34,   1.15,  223.01,   1.25,  54.37,   5.12,  17.83,   15.62,  3.98e-06,  4.41e-06,  4.25e-06,  nan ],
	[  6000,  245.38,   1.17,  226.65,   1.27,  55.40,   5.20,  17.69,   16.29,  4.32e-06,  4.43e-06,  4.34e-06,  nan ],
	[  6100,  251.08,   1.19,  226.94,   1.31,  56.13,   5.30,  17.78,   16.75,  4.43e-06,  4.31e-06,  4.53e-06,  nan ],
	[  6200,  250.66,   1.23,  229.03,   1.34,  49.51,   6.21,  17.66,   17.41,  4.39e-06,  4.14e-06,  4.38e-06,  nan ],
	[  6300,  254.26,   1.25,  224.30,   1.42,  49.81,   6.38,  17.96,   17.69,  4.73e-06,  4.70e-06,  4.44e-06,  nan ],
	[  6400,  255.05,   1.29,  254.86,   1.29,  50.81,   6.45,  19.39,   16.90,  4.45e-06,  4.46e-06,  4.65e-06,  nan ],
	[  6500,  257.07,   1.32,  229.34,   1.47,  51.65,   6.55,  17.83,   18.96,  4.66e-06,  4.47e-06,  4.30e-06,  nan ],
	[  6600,  262.05,   1.33,  230.85,   1.51,  52.49,   6.64,  17.76,   19.63,  4.92e-06,  4.68e-06,  4.77e-06,  nan ],
	[  6700,  268.84,   1.34,  229.66,   1.56,  52.93,   6.79,  17.93,   20.03,  4.93e-06,  4.88e-06,  4.54e-06,  nan ],
	[  6800,  266.42,   1.39,  228.25,   1.62,  53.75,   6.88,  17.72,   20.89,  4.60e-06,  4.45e-06,  4.60e-06,  nan ],
	[  6900,  272.72,   1.40,  230.34,   1.65,  54.45,   7.00,  17.89,   21.30,  4.67e-06,  4.89e-06,  4.82e-06,  nan ],
	[  7000,  271.73,   1.44,  230.65,   1.70,  55.32,   7.09,  17.64,   22.23,  4.26e-06,  4.55e-06,  4.39e-06,  nan ],
	[  7100,  273.67,   1.47,  232.08,   1.74,  56.22,   7.17,  17.91,   22.53,  4.55e-06,  4.41e-06,  4.58e-06,  nan ],
	[  7200,  278.37,   1.49,  264.05,   1.57,  49.71,   8.34,  17.56,   23.62,  4.22e-06,  4.27e-06,  4.21e-06,  nan ],
	[  7300,  279.23,   1.53,  235.73,   1.81,  50.80,   8.39,  17.52,   24.33,  5.24e-06,  5.12e-06,  5.04e-06,  nan ],
	[  7400,  280.54,   1.56,  236.34,   1.85,  51.65,   8.48,  17.61,   24.88,  4.60e-06,  4.37e-06,  4.52e-06,  nan ],
	[  7500,  282.18,   1.60,  235.77,   1.91,  52.00,   8.66,  17.76,   25.35,  5.21e-06,  4.73e-06,  4.97e-06,  nan ],
	[  7600,  288.17,   1.60,  240.57,   1.92,  52.78,   8.76,  17.65,   26.18,  4.72e-06,  4.69e-06,  4.97e-06,  nan ],
	[  7700,  288.05,   1.65,  234.87,   2.02,  53.40,   8.88,  16.58,   28.61,  4.32e-06,  4.09e-06,  4.32e-06,  nan ],
	[  7800,  290.45,   1.68,  236.11,   2.06,  54.22,   8.98,  17.44,   27.92,  4.46e-06,  4.44e-06,  4.60e-06,  nan ],
	[  7900,  283.08,   1.76,  238.01,   2.10,  54.64,   9.14,  17.63,   28.33,  4.46e-06,  4.52e-06,  4.59e-06,  nan ],
	[  8000,  284.83,   1.80,  266.16,   1.92,  55.18,   9.28,  17.62,   29.06,  5.27e-06,  4.86e-06,  4.56e-06,  nan ],
	[  8100,  285.15,   1.84,  239.94,   2.19,  56.10,   9.36,  17.51,   29.98,  4.34e-06,  4.73e-06,  4.33e-06,  nan ],
	[  8200,  279.18,   1.93,  236.82,   2.27,  51.46,  10.45,  15.26,   35.25,  4.80e-06,  4.50e-06,  4.77e-06,  nan ],
	[  8300,  284.90,   1.93,  237.39,   2.32,  50.96,  10.82,  16.33,   33.75,  5.24e-06,  4.67e-06,  4.71e-06,  nan ],
	[  8400,  275.54,   2.05,  239.22,   2.36,  51.64,  10.93,  17.48,   32.30,  5.19e-06,  4.73e-06,  5.00e-06,  nan ],
	[  8500,  282.83,   2.04,  240.19,   2.41,  52.42,  11.03,  17.69,   32.68,  5.19e-06,  5.32e-06,  5.76e-06,  nan ],
	[  8600,  277.33,   2.13,  239.49,   2.47,  53.07,  11.15,  17.58,   33.67,  5.26e-06,  5.40e-06,  5.19e-06,  nan ],
	[  8700,  279.48,   2.17,  238.42,   2.54,  53.38,  11.34,  17.01,   35.61,  5.61e-06,  5.89e-06,  5.50e-06,  nan ],
	[  8800,  272.11,   2.28,  267.76,   2.31,  54.03,  11.47,  16.51,   37.54,  5.56e-06,  6.12e-06,  5.88e-06,  nan ],
	[  8900,  275.67,   2.30,  241.99,   2.62,  54.68,  11.59,  17.40,   36.43,  5.21e-06,  5.30e-06,  5.21e-06,  nan ],
	[  9000,  274.03,   2.37,  238.98,   2.71,  55.44,  11.69,  16.98,   38.17,  5.86e-06,  5.36e-06,  5.21e-06,  nan ],
	[ 10000,  274.49,   2.91,  246.94,   3.24,  55.32,  14.46,  17.31,   46.23,  6.36e-06,  6.46e-06,  6.26e-06,  nan ],
	[ 12000,  274.26,   4.20,  280.47,   4.11,  55.04,  20.93,  17.06,   67.55,  6.27e-06,  6.43e-06,  6.34e-06,  nan ],
	[ 14000,  292.13,   5.37,  252.32,   6.22,  55.11,  28.45,  16.79,   93.39,  6.79e-06,  6.49e-06,  6.80e-06,  nan ],
	[ 16000,  295.55,   6.93,  288.43,   7.10,  54.95,  37.27,  15.60,  131.33,  8.87e-06,  8.64e-06,  9.27e-06,  nan ],
	[ 18000,  284.73,   9.10,  258.53,  10.03,  54.31,  47.73,  16.48,  157.29,  7.91e-06,  8.04e-06,  8.33e-06,  nan ],
	[ 20000,  289.58,  11.05,  293.12,  10.92,  53.44,  59.88,  17.02,  187.98,  9.58e-06,  1.02e-05,  9.50e-06,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/cpotrf.txt
# numactl --interleave=all ../testing/testing_cpotrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
cpotrf = array([
	[    10,    0.58,   0.00,     0.01,  0.00,  0.00e+00,  nan ],
	[    20,    2.38,   0.00,     0.04,  0.00,  0.00e+00,  nan ],
	[    30,    4.93,   0.00,     0.14,  0.00,  0.00e+00,  nan ],
	[    40,    7.57,   0.00,     1.74,  0.00,  0.00e+00,  nan ],
	[    50,    5.15,   0.00,     1.98,  0.00,  0.00e+00,  nan ],
	[    60,    6.24,   0.00,     3.51,  0.00,  0.00e+00,  nan ],
	[    70,    7.05,   0.00,     4.54,  0.00,  0.00e+00,  nan ],
	[    80,    7.53,   0.00,     4.75,  0.00,  0.00e+00,  nan ],
	[    90,    8.31,   0.00,     2.52,  0.00,  0.00e+00,  nan ],
	[   100,    8.85,   0.00,     3.15,  0.00,  0.00e+00,  nan ],
	[   200,   39.21,   0.00,    19.03,  0.00,  0.00e+00,  nan ],
	[   300,   80.28,   0.00,    18.95,  0.00,  2.34e-08,  nan ],
	[   400,  128.27,   0.00,    36.75,  0.00,  5.29e-08,  nan ],
	[   500,  175.16,   0.00,    60.68,  0.00,  4.22e-08,  nan ],
	[   600,  233.85,   0.00,    73.22,  0.00,  6.85e-08,  nan ],
	[   700,  255.29,   0.00,   103.40,  0.00,  5.89e-08,  nan ],
	[   800,  287.89,   0.00,   115.33,  0.01,  5.12e-08,  nan ],
	[   900,  297.80,   0.00,   149.62,  0.01,  4.63e-08,  nan ],
	[  1000,  312.24,   0.00,   192.25,  0.01,  4.57e-08,  nan ],
	[  2000,  409.53,   0.03,   587.48,  0.02,  6.35e-08,  nan ],
	[  3000,  505.24,   0.07,  1033.54,  0.03,  8.19e-08,  nan ],
	[  4000,  510.86,   0.17,  1327.08,  0.06,  6.61e-08,  nan ],
	[  5000,  507.46,   0.33,  1558.07,  0.11,  1.55e-07,  nan ],
	[  6000,  543.03,   0.53,  1763.25,  0.16,  1.23e-07,  nan ],
	[  7000,  295.94,   1.55,  1891.97,  0.24,  1.03e-07,  nan ],
	[  8000,  558.87,   1.22,  2030.45,  0.34,  8.98e-08,  nan ],
	[  9000,  559.29,   1.74,  2144.32,  0.45,  1.61e-07,  nan ],
	[ 10000,  559.54,   2.38,  2225.49,  0.60,  1.56e-07,  nan ],
	[ 12000,  562.13,   4.10,  2386.38,  0.97,  1.74e-07,  nan ],
	[ 14000,  570.07,   6.42,  2502.72,  1.46,  3.35e-07,  nan ],
	[ 16000,  561.25,   9.73,  2590.73,  2.11,  3.84e-07,  nan ],
	[ 18000,  569.21,  13.66,  2648.06,  2.94,  2.48e-06,  nan ],
	[ 20000,  572.18,  18.64,  2709.18,  3.94,  2.96e-06,  nan ],
])

# numactl --interleave=all ../testing/testing_cpotrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
cpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.05,  0.00,  nan ],
	[    40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,  nan,  nan,     0.19,  0.00,  nan ],
	[    60,  nan,  nan,     0.33,  0.00,  nan ],
	[    70,  nan,  nan,     0.51,  0.00,  nan ],
	[    80,  nan,  nan,     0.73,  0.00,  nan ],
	[    90,  nan,  nan,     0.99,  0.00,  nan ],
	[   100,  nan,  nan,     1.32,  0.00,  nan ],
	[   200,  nan,  nan,    22.58,  0.00,  nan ],
	[   300,  nan,  nan,    14.80,  0.00,  nan ],
	[   400,  nan,  nan,    28.82,  0.00,  nan ],
	[   500,  nan,  nan,    50.70,  0.00,  nan ],
	[   600,  nan,  nan,    64.69,  0.00,  nan ],
	[   700,  nan,  nan,    93.27,  0.00,  nan ],
	[   800,  nan,  nan,   107.08,  0.01,  nan ],
	[   900,  nan,  nan,   141.28,  0.01,  nan ],
	[  1000,  nan,  nan,   182.81,  0.01,  nan ],
	[  2000,  nan,  nan,   633.37,  0.02,  nan ],
	[  3000,  nan,  nan,  1156.79,  0.03,  nan ],
	[  4000,  nan,  nan,  1512.06,  0.06,  nan ],
	[  5000,  nan,  nan,  1762.48,  0.09,  nan ],
	[  6000,  nan,  nan,  1986.81,  0.15,  nan ],
	[  7000,  nan,  nan,  2113.33,  0.22,  nan ],
	[  8000,  nan,  nan,  2259.03,  0.30,  nan ],
	[  9000,  nan,  nan,  2354.05,  0.41,  nan ],
	[ 10000,  nan,  nan,  2431.16,  0.55,  nan ],
	[ 12000,  nan,  nan,  2564.09,  0.90,  nan ],
	[ 14000,  nan,  nan,  2667.63,  1.37,  nan ],
	[ 16000,  nan,  nan,  2753.41,  1.98,  nan ],
	[ 18000,  nan,  nan,  2788.92,  2.79,  nan ],
	[ 20000,  nan,  nan,  2848.59,  3.74,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/dgeev.txt
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# numactl --interleave=all ../testing/testing_dgeev -RN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_dgeev -RN -N 123 -N 1234 --range 12000:20000:2000
dgeev_RN = array([
	[    10,    0.00,   0.00,  0.00e+00,  nan ],
	[    20,    0.00,   0.00,  0.00e+00,  nan ],
	[    30,    0.00,   0.00,  0.00e+00,  nan ],
	[    40,    0.00,   0.00,  1.20e-15,  nan ],
	[    50,    0.00,   0.00,  1.03e-15,  nan ],
	[    60,    0.00,   0.00,  1.10e-15,  nan ],
	[    70,    0.00,   0.00,  1.66e-15,  nan ],
	[    80,    0.00,   0.01,  2.05e-15,  nan ],
	[    90,    0.00,   0.01,  1.30e-15,  nan ],
	[   100,    0.01,   0.01,  1.57e-15,  nan ],
	[   200,    0.04,   0.05,  2.38e-15,  nan ],
	[   300,    0.09,   0.10,  2.50e-15,  nan ],
	[   400,    0.17,   0.15,  2.72e-15,  nan ],
	[   500,    0.21,   0.20,  2.59e-15,  nan ],
	[   600,    0.40,   0.39,  3.07e-15,  nan ],
	[   700,    0.53,   0.51,  3.38e-15,  nan ],
	[   800,    0.62,   0.59,  3.35e-15,  nan ],
	[   900,    0.77,   0.75,  3.59e-15,  nan ],
	[  1000,    0.89,   0.85,  3.57e-15,  nan ],
	[  2000,    3.14,   2.71,  4.04e-15,  nan ],
	[  3000,    9.61,   8.08,  5.10e-15,  nan ],
	[  4000,   17.12,  13.38,  5.38e-15,  nan ],
	[  5000,   28.48,  18.73,  5.56e-15,  nan ],
	[  6000,   48.01,  35.36,  6.90e-15,  nan ],
	[  7000,   67.44,  46.81,  7.39e-15,  nan ],
	[  8000,   85.95,  56.89,  7.24e-15,  nan ],
	[  9000,  110.44,  71.13,  7.38e-15,  nan ],
	[ 10000,  136.88,  87.96,  7.55e-15,  nan ],
	[ 12000, nan, 160.98, nan, nan ],
	[ 14000, nan, 228.10, nan, nan ],
	[ 16000, nan, 246.26, nan, nan ],
	[ 18000, nan, 301.91, nan, nan ],
	[ 20000, nan, 435.68, nan, nan ],
])

# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# numactl --interleave=all ../testing/testing_dgeev -RV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_dgeev -RV -N 123 -N 1234 --range 12000:20000:2000
dgeev_RV = array([
	[    10,    0.00,    0.00,  0.00e+00,  nan ],
	[    20,    0.00,    0.00,  0.00e+00,  nan ],
	[    30,    0.00,    0.00,  0.00e+00,  nan ],
	[    40,    0.00,    0.01,  1.20e-15,  nan ],
	[    50,    0.00,    0.01,  1.14e-15,  nan ],
	[    60,    0.00,    0.01,  1.10e-15,  nan ],
	[    70,    0.00,    0.01,  1.66e-15,  nan ],
	[    80,    0.01,    0.01,  1.88e-15,  nan ],
	[    90,    0.01,    0.01,  1.30e-15,  nan ],
	[   100,    0.01,    0.02,  1.48e-15,  nan ],
	[   200,    0.06,    0.07,  1.97e-15,  nan ],
	[   300,    0.18,    0.14,  2.66e-15,  nan ],
	[   400,    0.22,    0.28,  2.70e-15,  nan ],
	[   500,    0.30,    0.28,  2.74e-15,  nan ],
	[   600,    0.50,    0.46,  3.27e-15,  nan ],
	[   700,    0.68,    0.63,  3.18e-15,  nan ],
	[   800,    0.83,    0.75,  3.27e-15,  nan ],
	[   900,    1.02,    0.92,  3.71e-15,  nan ],
	[  1000,    1.67,    1.16,  3.39e-15,  nan ],
	[  2000,    5.31,    3.83,  3.90e-15,  nan ],
	[  3000,   18.47,   10.43,  5.15e-15,  nan ],
	[  4000,   34.19,   16.77,  5.42e-15,  nan ],
	[  5000,   57.35,   27.81,  5.48e-15,  nan ],
	[  6000,  102.25,   43.77,  6.66e-15,  nan ],
	[  7000,  138.34,   58.79,  7.26e-15,  nan ],
	[  8000,  194.40,   78.75,  7.13e-15,  nan ],
	[  9000,  280.08,   98.89,  7.29e-15,  nan ],
	[ 10000,  360.04,  126.69,  7.68e-15,  nan ],
	[ 12000, nan, 268.11, nan, nan ],
	[ 14000, nan, 368.44, nan, nan ],
	[ 16000, nan, 526.02, nan, nan ],
	[ 18000, nan, 668.79, nan, nan ],
	[ 20000, nan, 984.19, nan, nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/dgeqrf.txt
# numactl --interleave=all ../testing/testing_dgeqrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
dgeqrf = array([
	[    10,     10,    0.39,   0.00,     0.02,   0.00,  nan ],
	[    20,     20,    0.78,   0.00,     0.19,   0.00,  nan ],
	[    30,     30,    1.52,   0.00,     0.59,   0.00,  nan ],
	[    40,     40,    2.21,   0.00,     1.11,   0.00,  nan ],
	[    50,     50,    2.77,   0.00,     1.72,   0.00,  nan ],
	[    60,     60,    3.05,   0.00,     2.25,   0.00,  nan ],
	[    70,     70,    3.27,   0.00,     0.59,   0.00,  nan ],
	[    80,     80,    3.52,   0.00,     0.92,   0.00,  nan ],
	[    90,     90,    3.73,   0.00,     1.21,   0.00,  nan ],
	[   100,    100,    4.30,   0.00,     1.57,   0.00,  nan ],
	[   200,    200,   12.06,   0.00,     5.42,   0.00,  nan ],
	[   300,    300,   23.51,   0.00,    11.58,   0.00,  nan ],
	[   400,    400,   36.42,   0.00,    18.88,   0.00,  nan ],
	[   500,    500,   40.81,   0.00,    27.88,   0.01,  nan ],
	[   600,    600,   49.48,   0.01,    36.89,   0.01,  nan ],
	[   700,    700,   60.41,   0.01,    45.68,   0.01,  nan ],
	[   800,    800,   68.68,   0.01,    56.20,   0.01,  nan ],
	[   900,    900,   63.93,   0.02,    66.29,   0.01,  nan ],
	[  1000,   1000,   70.67,   0.02,    75.91,   0.02,  nan ],
	[  2000,   2000,  104.81,   0.10,   198.77,   0.05,  nan ],
	[  3000,   3000,  126.03,   0.29,   313.10,   0.12,  nan ],
	[  4000,   4000,  132.62,   0.64,   413.94,   0.21,  nan ],
	[  5000,   5000,  158.71,   1.05,   534.12,   0.31,  nan ],
	[  6000,   6000,  185.47,   1.55,   648.51,   0.44,  nan ],
	[  7000,   7000,  172.75,   2.65,   666.05,   0.69,  nan ],
	[  8000,   8000,  232.91,   2.93,   761.23,   0.90,  nan ],
	[  9000,   9000,  214.13,   4.54,   811.74,   1.20,  nan ],
	[ 10000,  10000,  186.64,   7.15,   841.42,   1.58,  nan ],
	[ 12000,  12000,  255.67,   9.01,   892.54,   2.58,  nan ],
	[ 14000,  14000,  270.31,  13.54,   964.08,   3.80,  nan ],
	[ 16000,  16000,  270.83,  20.17,   990.72,   5.51,  nan ],
	[ 18000,  18000,  276.94,  28.08,  1008.26,   7.71,  nan ],
	[ 20000,  20000,  278.54,  38.30,  1021.23,  10.45,  nan ],
])

# numactl --interleave=all ../testing/testing_dgeqrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.03,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.06,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.12,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.20,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.24,   0.00,  nan ],
	[    80,     80,  nan,  nan,     0.35,   0.00,  nan ],
	[    90,     90,  nan,  nan,     0.53,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.40,   0.00,  nan ],
	[   200,    200,  nan,  nan,     3.35,   0.00,  nan ],
	[   300,    300,  nan,  nan,     7.82,   0.00,  nan ],
	[   400,    400,  nan,  nan,    13.59,   0.01,  nan ],
	[   500,    500,  nan,  nan,    21.08,   0.01,  nan ],
	[   600,    600,  nan,  nan,    28.62,   0.01,  nan ],
	[   700,    700,  nan,  nan,    37.52,   0.01,  nan ],
	[   800,    800,  nan,  nan,    46.27,   0.01,  nan ],
	[   900,    900,  nan,  nan,    54.61,   0.02,  nan ],
	[  1000,   1000,  nan,  nan,    65.99,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   176.48,   0.06,  nan ],
	[  3000,   3000,  nan,  nan,   311.86,   0.12,  nan ],
	[  4000,   4000,  nan,  nan,   400.19,   0.21,  nan ],
	[  5000,   5000,  nan,  nan,   515.47,   0.32,  nan ],
	[  6000,   6000,  nan,  nan,   620.50,   0.46,  nan ],
	[  7000,   7000,  nan,  nan,   691.09,   0.66,  nan ],
	[  8000,   8000,  nan,  nan,   747.63,   0.91,  nan ],
	[  9000,   9000,  nan,  nan,   790.41,   1.23,  nan ],
	[ 10000,  10000,  nan,  nan,   826.83,   1.61,  nan ],
	[ 12000,  12000,  nan,  nan,   889.01,   2.59,  nan ],
	[ 14000,  14000,  nan,  nan,   926.10,   3.95,  nan ],
	[ 16000,  16000,  nan,  nan,   967.55,   5.65,  nan ],
	[ 18000,  18000,  nan,  nan,   991.20,   7.85,  nan ],
	[ 20000,  20000,  nan,  nan,  1009.71,  10.56,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/dgesvd.txt
# numactl --interleave=all ../testing/testing_dgesvd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_dgesvd -UN -VN -N 123 -N 1234 --range 12000:20000:2000
dgesvd_UN = array([
	[ nan,      10,      10,    0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,    0.00,  0.00e+00 ],
	[ nan,     100,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     200,    0.01,    0.02,  2.67e-16 ],
	[ nan,     300,     300,    0.02,    0.04,  3.99e-16 ],
	[ nan,     400,     400,    0.02,    0.05,  3.94e-16 ],
	[ nan,     500,     500,    0.03,    0.07,  4.37e-16 ],
	[ nan,     600,     600,    0.05,    0.09,  5.24e-16 ],
	[ nan,     700,     700,    0.06,    0.12,  4.47e-16 ],
	[ nan,     800,     800,    0.08,    0.15,  6.04e-16 ],
	[ nan,     900,     900,    0.11,    0.19,  6.56e-16 ],
	[ nan,    1000,    1000,    0.14,    0.23,  6.89e-16 ],
	[ nan,    2000,    2000,    0.55,    0.90,  9.76e-16 ],
	[ nan,    3000,    3000,    2.00,    2.31,  1.04e-15 ],
	[ nan,    4000,    4000,    6.12,    4.67,  1.45e-15 ],
	[ nan,    5000,    5000,   11.98,    8.29,  1.06e-15 ],
	[ nan,    6000,    6000,   20.84,   13.29,  1.14e-15 ],
	[ nan,    7000,    7000,   41.23,   20.10,  1.15e-15 ],
	[ nan,    8000,    8000,   64.52,   28.72,  1.30e-15 ],
	[ nan,    9000,    9000,   90.39,   39.91,  1.80e-15 ],
	[ nan,   10000,   10000,  104.62,   53.29,  2.26e-15 ],
	[ nan,     300,     100,    0.01,    0.00,  0.00e+00 ],
	[ nan,     600,     200,    0.01,    0.02,  2.24e-16 ],
	[ nan,     900,     300,    0.02,    0.03,  3.25e-16 ],
	[ nan,    1200,     400,    0.03,    0.06,  2.82e-16 ],
	[ nan,    1500,     500,    0.05,    0.08,  2.58e-16 ],
	[ nan,    1800,     600,    0.06,    0.12,  3.29e-16 ],
	[ nan,    2100,     700,    0.09,    0.15,  4.02e-16 ],
	[ nan,    2400,     800,    0.12,    0.19,  3.45e-16 ],
	[ nan,    2700,     900,    0.18,    0.26,  3.85e-16 ],
	[ nan,    3000,    1000,    0.22,    0.32,  4.99e-16 ],
	[ nan,    6000,    2000,    1.24,    1.48,  5.49e-16 ],
	[ nan,    9000,    3000,    3.91,    3.90,  5.54e-16 ],
	[ nan,   12000,    4000,    7.47,    6.92,  5.16e-16 ],
	[ nan,   15000,    5000,   15.45,   12.20,  9.19e-16 ],
	[ nan,   18000,    6000,   28.53,   20.09,  9.01e-16 ],
	[ nan,   21000,    7000,   42.31,   32.50,  1.00e-15 ],
	[ nan,   24000,    8000,   64.50,   43.13,  1.20e-15 ],
	[ nan,   27000,    9000,   90.94,   59.73,  1.46e-15 ],
	[ nan,     100,     300,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     600,    0.01,    0.02,  3.37e-16 ],
	[ nan,     300,     900,    0.02,    0.04,  2.08e-16 ],
	[ nan,     400,    1200,    0.04,    0.07,  2.34e-16 ],
	[ nan,     500,    1500,    0.06,    0.10,  4.05e-16 ],
	[ nan,     600,    1800,    0.08,    0.13,  3.34e-16 ],
	[ nan,     700,    2100,    0.12,    0.18,  3.74e-16 ],
	[ nan,     800,    2400,    0.14,    0.22,  3.71e-16 ],
	[ nan,     900,    2700,    0.19,    0.28,  3.83e-16 ],
	[ nan,    1000,    3000,    0.23,    0.34,  4.80e-16 ],
	[ nan,    2000,    6000,    1.22,    1.49,  5.46e-16 ],
	[ nan,    3000,    9000,    3.48,    4.35,  7.72e-16 ],
	[ nan,    4000,   12000,    7.87,    7.12,  8.42e-16 ],
	[ nan,    5000,   15000,   15.61,   12.69,  6.88e-16 ],
	[ nan,    6000,   18000,   27.73,   20.71,  8.67e-16 ],
	[ nan,    7000,   21000,   44.22,   31.38,  1.63e-15 ],
	[ nan,    8000,   24000,   75.60,   45.05,  1.13e-15 ],
	[ nan,    9000,   27000,   94.58,   62.38,  8.26e-16 ],
	[ nan,   10000,     100,    0.01,    0.01,  0.00e+00 ],
	[ nan,   20000,     200,    0.05,    0.06,  2.25e-16 ],
	[ nan,   30000,     300,    0.13,    0.15,  1.15e-16 ],
	[ nan,   40000,     400,    0.35,    0.39,  1.12e-16 ],
	[ nan,   50000,     500,    0.57,    0.62,  1.90e-16 ],
	[ nan,   60000,     600,    0.87,    0.95,  1.83e-16 ],
	[ nan,   70000,     700,    1.22,    1.32,  1.17e-16 ],
	[ nan,   80000,     800,    1.63,    1.77,  1.08e-16 ],
	[ nan,   90000,     900,    2.26,    2.44,  1.23e-16 ],
	[ nan,  100000,    1000,    2.97,    3.16,  1.18e-16 ],
	[ nan,  200000,    2000,   16.38,   18.51,  1.27e-16 ],
	[ nan,     100,   10000,    0.01,    0.01,  0.00e+00 ],
	[ nan,     200,   20000,    0.04,    0.05,  1.47e-16 ],
	[ nan,     300,   30000,    0.13,    0.16,  1.20e-16 ],
	[ nan,     400,   40000,    0.27,    0.33,  1.31e-16 ],
	[ nan,     500,   50000,    0.51,    0.60,  1.19e-16 ],
	[ nan,     600,   60000,    0.90,    1.11,  1.80e-16 ],
	[ nan,     700,   70000,    1.42,    1.75,  1.59e-16 ],
	[ nan,     800,   80000,    1.48,    1.94,  1.25e-16 ],
	[ nan,     900,   90000,    1.81,    2.23,  1.13e-16 ],
	[ nan,    1000,  100000,    2.32,    2.87,  1.18e-16 ],
	[ nan,    2000,  200000,   18.49,   19.80,  2.21e-16 ],
	[ nan,   12000,   12000,     nan,   89.03,       nan ],
	[ nan,   14000,   14000,     nan,  136.55,       nan ],
	[ nan,   16000,   16000,     nan,  200.64,       nan ],
	[ nan,   18000,   18000,     nan,  283.72,       nan ],
	[ nan,   20000,   20000,     nan,  383.69,       nan ],
])

# numactl --interleave=all ../testing/testing_dgesvd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_dgesvd -US -VS -N 123 -N 1234 --range 12000:20000:2000
dgesvd_US = array([
	[ nan,      10,      10,    0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.01,    0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.01,    0.01,  0.00e+00 ],
	[ nan,      70,      70,    0.01,    0.01,  0.00e+00 ],
	[ nan,      80,      80,    0.01,    0.01,  0.00e+00 ],
	[ nan,      90,      90,    0.02,    0.02,  0.00e+00 ],
	[ nan,     100,     100,    0.02,    0.02,  0.00e+00 ],
	[ nan,     200,     200,    0.07,    0.07,  8.04e-16 ],
	[ nan,     300,     300,    0.04,    0.06,  1.07e-15 ],
	[ nan,     400,     400,    0.08,    0.10,  1.57e-15 ],
	[ nan,     500,     500,    0.12,    0.16,  1.61e-15 ],
	[ nan,     600,     600,    0.19,    0.23,  1.29e-15 ],
	[ nan,     700,     700,    0.26,    0.32,  1.47e-15 ],
	[ nan,     800,     800,    0.34,    0.41,  1.76e-15 ],
	[ nan,     900,     900,    0.45,    0.53,  1.52e-15 ],
	[ nan,    1000,    1000,    0.57,    0.66,  2.00e-15 ],
	[ nan,    2000,    2000,    2.96,    3.19,  2.39e-15 ],
	[ nan,    3000,    3000,    9.04,   10.32,  2.56e-15 ],
	[ nan,    4000,    4000,   15.93,   17.38,  3.06e-15 ],
	[ nan,    5000,    5000,   27.97,   24.91,  3.46e-15 ],
	[ nan,    6000,    6000,   46.88,   39.68,  3.50e-15 ],
	[ nan,    7000,    7000,   70.82,   57.71,  3.48e-15 ],
	[ nan,    8000,    8000,  101.88,   79.37,  3.46e-15 ],
	[ nan,    9000,    9000,  141.46,  108.91,  3.67e-15 ],
	[ nan,   10000,   10000,  188.83,  142.74,  3.61e-15 ],
	[ nan,     300,     100,    0.02,    0.03,  8.04e-16 ],
	[ nan,     600,     200,    0.09,    0.10,  1.26e-15 ],
	[ nan,     900,     300,    0.06,    0.08,  1.34e-15 ],
	[ nan,    1200,     400,    0.11,    0.13,  1.55e-15 ],
	[ nan,    1500,     500,    0.19,    0.21,  1.60e-15 ],
	[ nan,    1800,     600,    0.27,    0.32,  1.93e-15 ],
	[ nan,    2100,     700,    0.38,    0.43,  1.89e-15 ],
	[ nan,    2400,     800,    0.50,    0.56,  2.20e-15 ],
	[ nan,    2700,     900,    0.65,    0.71,  2.21e-15 ],
	[ nan,    3000,    1000,    0.87,    0.93,  2.09e-15 ],
	[ nan,    6000,    2000,    4.50,    4.71,  2.58e-15 ],
	[ nan,    9000,    3000,   13.95,   13.81,  3.24e-15 ],
	[ nan,   12000,    4000,   27.41,   25.70,  3.29e-15 ],
	[ nan,   15000,    5000,   49.99,   49.94,  3.21e-15 ],
	[ nan,   18000,    6000,   85.94,   75.30,  3.27e-15 ],
	[ nan,   21000,    7000,  133.51,  114.62,  3.75e-15 ],
	[ nan,   24000,    8000,  185.61,  156.88,  4.15e-15 ],
	[ nan,   27000,    9000,  266.07,  223.30,  4.48e-15 ],
	[ nan,     100,     300,    0.03,    0.02,  8.88e-16 ],
	[ nan,     200,     600,    0.07,    0.08,  1.18e-15 ],
	[ nan,     300,     900,    0.07,    0.09,  1.35e-15 ],
	[ nan,     400,    1200,    0.13,    0.16,  1.56e-15 ],
	[ nan,     500,    1500,    0.22,    0.25,  1.65e-15 ],
	[ nan,     600,    1800,    0.36,    0.39,  2.05e-15 ],
	[ nan,     700,    2100,    0.50,    0.54,  1.88e-15 ],
	[ nan,     800,    2400,    0.69,    0.79,  2.00e-15 ],
	[ nan,     900,    2700,    0.92,    1.00,  2.16e-15 ],
	[ nan,    1000,    3000,    1.03,    1.20,  2.06e-15 ],
	[ nan,    2000,    6000,    7.04,    6.13,  2.87e-15 ],
	[ nan,    3000,    9000,   16.61,   16.02,  2.97e-15 ],
	[ nan,    4000,   12000,   32.35,   31.32,  3.24e-15 ],
	[ nan,    5000,   15000,   57.68,   53.71,  3.44e-15 ],
	[ nan,    6000,   18000,   95.97,   88.80,  3.40e-15 ],
	[ nan,    7000,   21000,  144.70,  132.15,  3.59e-15 ],
	[ nan,    8000,   24000,  211.10,  189.81,  4.34e-15 ],
	[ nan,    9000,   27000,  285.25,  254.88,  4.20e-15 ],
	[ nan,   10000,     100,    0.05,    0.06,  0.00e+00 ],
	[ nan,   20000,     200,    0.25,    0.28,  1.11e-15 ],
	[ nan,   30000,     300,    0.32,    0.48,  1.43e-15 ],
	[ nan,   40000,     400,    0.64,    0.99,  1.30e-15 ],
	[ nan,   50000,     500,    1.56,    1.84,  1.81e-15 ],
	[ nan,   60000,     600,    1.99,    2.64,  1.98e-15 ],
	[ nan,   70000,     700,    2.56,    4.10,  2.07e-15 ],
	[ nan,   80000,     800,    3.22,    5.51,  2.00e-15 ],
	[ nan,   90000,     900,    4.24,    8.01,  2.18e-15 ],
	[ nan,  100000,    1000,    6.88,   10.25,  2.26e-15 ],
	[ nan,  200000,    2000,   35.73,   70.87,  2.83e-15 ],
	[ nan,     100,   10000,    0.06,    0.06,  0.00e+00 ],
	[ nan,     200,   20000,    0.27,    0.39,  1.21e-15 ],
	[ nan,     300,   30000,    0.36,    0.62,  1.36e-15 ],
	[ nan,     400,   40000,    0.60,    1.18,  1.38e-15 ],
	[ nan,     500,   50000,    2.16,    3.22,  1.93e-15 ],
	[ nan,     600,   60000,    2.53,    4.05,  1.92e-15 ],
	[ nan,     700,   70000,    3.00,    5.34,  1.98e-15 ],
	[ nan,     800,   80000,    3.43,    7.29,  2.02e-15 ],
	[ nan,     900,   90000,    4.09,    8.56,  2.11e-15 ],
	[ nan,    1000,  100000,    8.05,   14.48,  2.19e-15 ],
	[ nan,    2000,  200000,   39.95,   83.14,  2.81e-15 ],
	[ nan,   12000,   12000,     nan,  229.41,       nan ],
	[ nan,   14000,   14000,     nan,  351.88,       nan ],
	[ nan,   16000,   16000,     nan,  510.99,       nan ],
	[ nan,   18000,   18000,     nan,  721.40,       nan ],
	[ nan,   20000,   20000,     nan,  923.75,       nan ],
])

# numactl --interleave=all ../testing/testing_dgesdd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_dgesdd -UN -VN -N 123 -N 1234 --range 12000:20000:2000
dgesdd_UN = array([
	[ nan,      10,      10,    0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,    0.00,  0.00e+00 ],
	[ nan,     100,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     200,    0.01,    0.01,  2.67e-16 ],
	[ nan,     300,     300,    0.01,    0.03,  3.99e-16 ],
	[ nan,     400,     400,    0.02,    0.05,  3.94e-16 ],
	[ nan,     500,     500,    0.03,    0.07,  4.37e-16 ],
	[ nan,     600,     600,    0.05,    0.09,  5.24e-16 ],
	[ nan,     700,     700,    0.06,    0.12,  4.47e-16 ],
	[ nan,     800,     800,    0.08,    0.16,  6.04e-16 ],
	[ nan,     900,     900,    0.10,    0.20,  6.56e-16 ],
	[ nan,    1000,    1000,    0.13,    0.24,  6.89e-16 ],
	[ nan,    2000,    2000,    0.56,    0.91,  9.76e-16 ],
	[ nan,    3000,    3000,    2.03,    2.34,  1.04e-15 ],
	[ nan,    4000,    4000,    5.49,    4.70,  1.45e-15 ],
	[ nan,    5000,    5000,   11.45,    8.34,  1.06e-15 ],
	[ nan,    6000,    6000,   20.85,   13.43,  1.14e-15 ],
	[ nan,    7000,    7000,   33.32,   20.06,  1.15e-15 ],
	[ nan,    8000,    8000,   52.97,   28.60,  1.30e-15 ],
	[ nan,    9000,    9000,   76.50,   39.75,  1.80e-15 ],
	[ nan,   10000,   10000,  100.95,   53.00,  2.26e-15 ],
	[ nan,     300,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     600,     200,    0.01,    0.02,  2.24e-16 ],
	[ nan,     900,     300,    0.02,    0.03,  3.25e-16 ],
	[ nan,    1200,     400,    0.03,    0.06,  2.82e-16 ],
	[ nan,    1500,     500,    0.05,    0.08,  2.58e-16 ],
	[ nan,    1800,     600,    0.06,    0.11,  3.29e-16 ],
	[ nan,    2100,     700,    0.09,    0.15,  4.02e-16 ],
	[ nan,    2400,     800,    0.11,    0.19,  3.45e-16 ],
	[ nan,    2700,     900,    0.15,    0.25,  3.85e-16 ],
	[ nan,    3000,    1000,    0.18,    0.30,  4.99e-16 ],
	[ nan,    6000,    2000,    0.89,    1.27,  5.49e-16 ],
	[ nan,    9000,    3000,    2.89,    3.34,  5.54e-16 ],
	[ nan,   12000,    4000,    8.55,    6.81,  5.16e-16 ],
	[ nan,   15000,    5000,   15.29,   12.21,  9.19e-16 ],
	[ nan,   18000,    6000,   26.99,   19.64,  9.01e-16 ],
	[ nan,   21000,    7000,   43.99,   30.41,  1.00e-15 ],
	[ nan,   24000,    8000,   64.34,   43.19,  1.20e-15 ],
	[ nan,   27000,    9000,   90.76,   60.68,  1.46e-15 ],
	[ nan,     100,     300,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     600,    0.01,    0.02,  3.37e-16 ],
	[ nan,     300,     900,    0.02,    0.04,  2.08e-16 ],
	[ nan,     400,    1200,    0.04,    0.06,  2.34e-16 ],
	[ nan,     500,    1500,    0.06,    0.10,  4.05e-16 ],
	[ nan,     600,    1800,    0.09,    0.13,  3.34e-16 ],
	[ nan,     700,    2100,    0.12,    0.18,  3.74e-16 ],
	[ nan,     800,    2400,    0.16,    0.22,  3.71e-16 ],
	[ nan,     900,    2700,    0.19,    0.28,  3.83e-16 ],
	[ nan,    1000,    3000,    0.26,    0.33,  4.80e-16 ],
	[ nan,    2000,    6000,    1.21,    1.47,  5.46e-16 ],
	[ nan,    3000,    9000,    4.05,    4.03,  7.72e-16 ],
	[ nan,    4000,   12000,   10.89,    8.72,  8.42e-16 ],
	[ nan,    5000,   15000,   19.62,   15.59,  6.88e-16 ],
	[ nan,    6000,   18000,   27.59,   20.74,  8.67e-16 ],
	[ nan,    7000,   21000,  145.46,   34.08,  1.72e-15 ],
	[ nan,    8000,   24000,  221.78,   45.49,  1.23e-15 ],
	[ nan,    9000,   27000,  307.86,   65.13,  1.18e-15 ],
	[ nan,   10000,     100,    0.01,    0.01,  0.00e+00 ],
	[ nan,   20000,     200,    0.05,    0.06,  2.25e-16 ],
	[ nan,   30000,     300,    0.17,    0.19,  1.15e-16 ],
	[ nan,   40000,     400,    0.35,    0.38,  1.12e-16 ],
	[ nan,   50000,     500,    0.58,    0.82,  1.90e-16 ],
	[ nan,   60000,     600,    0.87,    1.22,  1.83e-16 ],
	[ nan,   70000,     700,    1.21,    1.70,  1.17e-16 ],
	[ nan,   80000,     800,    1.71,    2.30,  1.08e-16 ],
	[ nan,   90000,     900,    2.25,    2.48,  1.23e-16 ],
	[ nan,  100000,    1000,    2.97,    3.15,  1.18e-16 ],
	[ nan,  200000,    2000,   16.67,   18.74,  1.27e-16 ],
	[ nan,     100,   10000,    0.01,    0.01,  0.00e+00 ],
	[ nan,     200,   20000,    0.05,    0.05,  1.47e-16 ],
	[ nan,     300,   30000,    0.13,    0.16,  1.20e-16 ],
	[ nan,     400,   40000,    0.27,    0.32,  1.31e-16 ],
	[ nan,     500,   50000,    0.47,    0.59,  1.19e-16 ],
	[ nan,     600,   60000,    0.74,    0.89,  1.80e-16 ],
	[ nan,     700,   70000,    1.15,    1.40,  1.59e-16 ],
	[ nan,     800,   80000,    1.48,    1.85,  1.25e-16 ],
	[ nan,     900,   90000,    1.79,    2.21,  1.13e-16 ],
	[ nan,    1000,  100000,    2.30,    2.86,  1.18e-16 ],
	[ nan,    2000,  200000,   17.73,   19.81,  2.21e-16 ],
	[ nan,   12000,   12000,     nan,   88.94,       nan ],
	[ nan,   14000,   14000,     nan,  136.26,       nan ],
	[ nan,   16000,   16000,     nan,  201.12,       nan ],
	[ nan,   18000,   18000,     nan,  284.34,       nan ],
	[ nan,   20000,   20000,     nan,  384.28,       nan ],
])

# numactl --interleave=all ../testing/testing_dgesdd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_dgesdd -US -VS -N 123 -N 1234 --range 12000:20000:2000
dgesdd_US = array([
	[ nan,      10,      10,    0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,    0.01,  0.00e+00 ],
	[ nan,     100,     100,    0.00,    0.01,  0.00e+00 ],
	[ nan,     200,     200,    0.02,    0.03,  4.76e-16 ],
	[ nan,     300,     300,    0.04,    0.06,  2.70e-16 ],
	[ nan,     400,     400,    0.07,    0.10,  2.86e-16 ],
	[ nan,     500,     500,    0.10,    0.15,  1.72e-16 ],
	[ nan,     600,     600,    0.15,    0.20,  1.93e-16 ],
	[ nan,     700,     700,    0.20,    0.27,  2.02e-16 ],
	[ nan,     800,     800,    0.26,    0.34,  3.32e-16 ],
	[ nan,     900,     900,    0.34,    0.43,  1.87e-16 ],
	[ nan,    1000,    1000,    0.43,    0.52,  1.70e-16 ],
	[ nan,    2000,    2000,    1.67,    1.98,  2.38e-16 ],
	[ nan,    3000,    3000,    4.34,    4.72,  3.04e-16 ],
	[ nan,    4000,    4000,   10.00,    8.81,  2.46e-16 ],
	[ nan,    5000,    5000,   19.11,   14.98,  3.44e-16 ],
	[ nan,    6000,    6000,   32.87,   23.25,  5.45e-16 ],
	[ nan,    7000,    7000,   50.49,   34.00,  1.90e-16 ],
	[ nan,    8000,    8000,   75.19,   47.69,  2.50e-16 ],
	[ nan,    9000,    9000,  105.72,   64.55,  1.16e-16 ],
	[ nan,   10000,   10000,  145.44,   86.00,  2.02e-16 ],
	[ nan,     300,     100,    0.01,    0.01,  0.00e+00 ],
	[ nan,     600,     200,    0.02,    0.03,  2.71e-16 ],
	[ nan,     900,     300,    0.04,    0.06,  2.35e-16 ],
	[ nan,    1200,     400,    0.07,    0.10,  2.54e-16 ],
	[ nan,    1500,     500,    0.12,    0.16,  1.91e-16 ],
	[ nan,    1800,     600,    0.16,    0.22,  1.95e-16 ],
	[ nan,    2100,     700,    0.23,    0.30,  2.11e-16 ],
	[ nan,    2400,     800,    0.29,    0.38,  2.17e-16 ],
	[ nan,    2700,     900,    0.38,    0.48,  1.57e-16 ],
	[ nan,    3000,    1000,    0.50,    0.62,  1.65e-16 ],
	[ nan,    6000,    2000,    2.34,    2.69,  1.46e-16 ],
	[ nan,    9000,    3000,    6.60,    6.92,  3.43e-16 ],
	[ nan,   12000,    4000,   14.93,   13.85,  3.68e-16 ],
	[ nan,   15000,    5000,   28.14,   24.18,  2.37e-16 ],
	[ nan,   18000,    6000,   48.62,   39.55,  1.48e-16 ],
	[ nan,   21000,    7000,   74.91,   58.68,  1.22e-16 ],
	[ nan,   24000,    8000,  111.06,   84.07,  1.32e-16 ],
	[ nan,   27000,    9000,  154.94,  118.93,  1.44e-16 ],
	[ nan,     100,     300,    0.01,    0.01,  0.00e+00 ],
	[ nan,     200,     600,    0.02,    0.03,  3.53e-16 ],
	[ nan,     300,     900,    0.05,    0.07,  2.04e-16 ],
	[ nan,     400,    1200,    0.08,    0.11,  2.63e-16 ],
	[ nan,     500,    1500,    0.13,    0.17,  1.97e-16 ],
	[ nan,     600,    1800,    0.18,    0.23,  1.87e-16 ],
	[ nan,     700,    2100,    0.26,    0.33,  2.06e-16 ],
	[ nan,     800,    2400,    0.31,    0.39,  2.18e-16 ],
	[ nan,     900,    2700,    0.40,    0.50,  1.99e-16 ],
	[ nan,    1000,    3000,    0.52,    0.64,  3.76e-16 ],
	[ nan,    2000,    6000,    2.42,    2.76,  1.45e-16 ],
	[ nan,    3000,    9000,    6.84,    7.11,  1.64e-16 ],
	[ nan,    4000,   12000,   15.39,   14.13,  1.42e-16 ],
	[ nan,    5000,   15000,   28.76,   24.61,  2.57e-16 ],
	[ nan,    6000,   18000,   49.84,   40.72,  3.34e-16 ],
	[ nan,    7000,   21000,   76.80,   60.42,  2.11e-16 ],
	[ nan,    8000,   24000,  113.92,   85.81,  1.35e-16 ],
	[ nan,    9000,   27000,  156.77,  116.94,  3.32e-16 ],
	[ nan,   10000,     100,    0.03,    0.03,  0.00e+00 ],
	[ nan,   20000,     200,    0.17,    0.18,  2.63e-16 ],
	[ nan,   30000,     300,    0.30,    0.32,  2.05e-16 ],
	[ nan,   40000,     400,    0.60,    0.65,  2.41e-16 ],
	[ nan,   50000,     500,    1.49,    1.55,  3.60e-16 ],
	[ nan,   60000,     600,    1.87,    1.96,  1.70e-16 ],
	[ nan,   70000,     700,    2.39,    2.52,  1.94e-16 ],
	[ nan,   80000,     800,    2.97,    3.20,  3.52e-16 ],
	[ nan,   90000,     900,    3.91,    4.10,  1.57e-16 ],
	[ nan,  100000,    1000,    6.46,    6.74,  1.56e-16 ],
	[ nan,  200000,    2000,   34.85,   35.71,  1.44e-16 ],
	[ nan,     100,   10000,    0.03,    0.04,  0.00e+00 ],
	[ nan,     200,   20000,    0.19,    0.23,  2.35e-16 ],
	[ nan,     300,   30000,    0.34,    0.41,  2.49e-16 ],
	[ nan,     400,   40000,    0.56,    0.67,  3.43e-16 ],
	[ nan,     500,   50000,    2.10,    2.49,  1.86e-16 ],
	[ nan,     600,   60000,    2.39,    2.89,  1.83e-16 ],
	[ nan,     700,   70000,    2.86,    3.46,  1.80e-16 ],
	[ nan,     800,   80000,    3.23,    3.80,  1.92e-16 ],
	[ nan,     900,   90000,    3.79,    4.40,  2.49e-16 ],
	[ nan,    1000,  100000,    7.67,    9.14,  1.49e-16 ],
	[ nan,    2000,  200000,   38.24,   41.57,  1.63e-16 ],
	[ nan,   12000,   12000,     nan,  145.92,       nan ],
	[ nan,   14000,   14000,     nan,  206.68,       nan ],
	[ nan,   16000,   16000,     nan,  303.65,       nan ],
	[ nan,   18000,   18000,     nan,  413.97,       nan ],
	[ nan,   20000,   20000,     nan,  552.63,       nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/dgetrf.txt
# numactl --interleave=all ../testing/testing_dgetrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
dgetrf = array([
	[    10,     10,    0.03,   0.00,    0.09,  0.00,  nan ],
	[    20,     20,    0.14,   0.00,    0.24,  0.00,  nan ],
	[    30,     30,    0.37,   0.00,    0.49,  0.00,  nan ],
	[    40,     40,    0.67,   0.00,    0.85,  0.00,  nan ],
	[    50,     50,    0.97,   0.00,    1.13,  0.00,  nan ],
	[    60,     60,    1.27,   0.00,    1.53,  0.00,  nan ],
	[    70,     70,    1.69,   0.00,    2.02,  0.00,  nan ],
	[    80,     80,    2.27,   0.00,    2.73,  0.00,  nan ],
	[    90,     90,    2.82,   0.00,    3.19,  0.00,  nan ],
	[   100,    100,    3.45,   0.00,    3.74,  0.00,  nan ],
	[   200,    200,   11.53,   0.00,    3.69,  0.00,  nan ],
	[   300,    300,   21.58,   0.00,    8.21,  0.00,  nan ],
	[   400,    400,   33.48,   0.00,   13.91,  0.00,  nan ],
	[   500,    500,   43.77,   0.00,   21.00,  0.00,  nan ],
	[   600,    600,   56.33,   0.00,   28.32,  0.01,  nan ],
	[   700,    700,   60.95,   0.00,   35.39,  0.01,  nan ],
	[   800,    800,   72.49,   0.00,   43.96,  0.01,  nan ],
	[   900,    900,   78.26,   0.01,   51.05,  0.01,  nan ],
	[  1000,   1000,   76.28,   0.01,   60.73,  0.01,  nan ],
	[  2000,   2000,   99.36,   0.05,  153.07,  0.03,  nan ],
	[  3000,   3000,  109.96,   0.16,  248.50,  0.07,  nan ],
	[  4000,   4000,  171.59,   0.25,  340.14,  0.13,  nan ],
	[  5000,   5000,  184.05,   0.45,  437.88,  0.19,  nan ],
	[  6000,   6000,  175.65,   0.82,  529.60,  0.27,  nan ],
	[  7000,   7000,  201.05,   1.14,  593.39,  0.39,  nan ],
	[  8000,   8000,  232.90,   1.47,  651.45,  0.52,  nan ],
	[  9000,   9000,  221.73,   2.19,  703.38,  0.69,  nan ],
	[ 10000,  10000,  248.58,   2.68,  739.56,  0.90,  nan ],
	[ 12000,  12000,  157.27,   7.32,  809.69,  1.42,  nan ],
	[ 14000,  14000,  169.63,  10.78,  854.90,  2.14,  nan ],
	[ 16000,  16000,  196.69,  13.88,  891.83,  3.06,  nan ],
	[ 18000,  18000,  181.36,  21.44,  915.36,  4.25,  nan ],
	[ 20000,  20000,  200.49,  26.60,  946.51,  5.63,  nan ],
])

# numactl --interleave=all ../testing/testing_dgetrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.09,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.24,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.49,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.70,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.06,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.22,  0.00,  nan ],
	[    80,     80,  nan,  nan,     1.63,  0.00,  nan ],
	[    90,     90,  nan,  nan,     1.98,  0.00,  nan ],
	[   100,    100,  nan,  nan,     2.40,  0.00,  nan ],
	[   200,    200,  nan,  nan,     2.66,  0.00,  nan ],
	[   300,    300,  nan,  nan,     6.75,  0.00,  nan ],
	[   400,    400,  nan,  nan,    12.40,  0.00,  nan ],
	[   500,    500,  nan,  nan,    19.47,  0.00,  nan ],
	[   600,    600,  nan,  nan,    27.85,  0.01,  nan ],
	[   700,    700,  nan,  nan,    36.87,  0.01,  nan ],
	[   800,    800,  nan,  nan,    46.64,  0.01,  nan ],
	[   900,    900,  nan,  nan,    56.38,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    65.94,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   181.52,  0.03,  nan ],
	[  3000,   3000,  nan,  nan,   309.37,  0.06,  nan ],
	[  4000,   4000,  nan,  nan,   400.52,  0.11,  nan ],
	[  5000,   5000,  nan,  nan,   516.45,  0.16,  nan ],
	[  6000,   6000,  nan,  nan,   623.33,  0.23,  nan ],
	[  7000,   7000,  nan,  nan,   706.47,  0.32,  nan ],
	[  8000,   8000,  nan,  nan,   776.60,  0.44,  nan ],
	[  9000,   9000,  nan,  nan,   801.42,  0.61,  nan ],
	[ 10000,  10000,  nan,  nan,   858.18,  0.78,  nan ],
	[ 12000,  12000,  nan,  nan,   860.44,  1.34,  nan ],
	[ 14000,  14000,  nan,  nan,   976.78,  1.87,  nan ],
	[ 16000,  16000,  nan,  nan,  1008.20,  2.71,  nan ],
	[ 18000,  18000,  nan,  nan,  1024.99,  3.79,  nan ],
	[ 20000,  20000,  nan,  nan,  1047.48,  5.09,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/dpotrf.txt
# numactl --interleave=all ../testing/testing_dpotrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
dpotrf = array([
	[    10,    0.18,  0.00,     0.00,  0.00,  0.00e+00,  nan ],
	[    20,    0.48,  0.00,     0.01,  0.00,  0.00e+00,  nan ],
	[    30,    1.04,  0.00,     0.03,  0.00,  0.00e+00,  nan ],
	[    40,    1.16,  0.00,     0.33,  0.00,  0.00e+00,  nan ],
	[    50,    1.59,  0.00,     0.59,  0.00,  0.00e+00,  nan ],
	[    60,    1.93,  0.00,     0.85,  0.00,  0.00e+00,  nan ],
	[    70,    1.82,  0.00,     0.97,  0.00,  0.00e+00,  nan ],
	[    80,    1.76,  0.00,     1.14,  0.00,  0.00e+00,  nan ],
	[    90,    1.61,  0.00,     0.48,  0.00,  0.00e+00,  nan ],
	[   100,    1.63,  0.00,     0.59,  0.00,  0.00e+00,  nan ],
	[   200,   11.89,  0.00,     4.48,  0.00,  0.00e+00,  nan ],
	[   300,   24.24,  0.00,     4.74,  0.00,  5.37e-17,  nan ],
	[   400,   37.17,  0.00,     9.21,  0.00,  1.17e-16,  nan ],
	[   500,   54.07,  0.00,    15.73,  0.00,  8.46e-17,  nan ],
	[   600,   74.40,  0.00,    18.79,  0.00,  1.43e-16,  nan ],
	[   700,   89.16,  0.00,    26.33,  0.00,  1.18e-16,  nan ],
	[   800,  102.38,  0.00,    30.56,  0.01,  1.05e-16,  nan ],
	[   900,  122.93,  0.00,    42.93,  0.01,  9.60e-17,  nan ],
	[  1000,  118.17,  0.00,    55.79,  0.01,  8.76e-17,  nan ],
	[  2000,  191.26,  0.01,   173.49,  0.02,  1.05e-16,  nan ],
	[  3000,  222.16,  0.04,   307.20,  0.03,  1.52e-16,  nan ],
	[  4000,  222.55,  0.10,   487.39,  0.04,  1.28e-16,  nan ],
	[  5000,  231.60,  0.18,   574.75,  0.07,  2.28e-16,  nan ],
	[  6000,  230.86,  0.31,   654.39,  0.11,  1.86e-16,  nan ],
	[  7000,  147.34,  0.78,   724.31,  0.16,  1.70e-16,  nan ],
	[  8000,  255.79,  0.67,   790.66,  0.22,  1.55e-16,  nan ],
	[  9000,  250.26,  0.97,   827.72,  0.29,  2.71e-16,  nan ],
	[ 10000,  243.07,  1.37,   864.14,  0.39,  2.49e-16,  nan ],
	[ 12000,  258.70,  2.23,   932.02,  0.62,  2.23e-16,  nan ],
	[ 14000,  272.41,  3.36,   981.04,  0.93,  2.03e-16,  nan ],
	[ 16000,  270.48,  5.05,  1022.76,  1.34,  1.85e-16,  nan ],
	[ 18000,  279.97,  6.94,  1044.47,  1.86,  3.48e-16,  nan ],
	[ 20000,  290.99,  9.16,  1072.08,  2.49,  3.29e-16,  nan ],
])

# numactl --interleave=all ../testing/testing_dpotrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
dpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.03,  0.00,  nan ],
	[    50,  nan,  nan,     0.05,  0.00,  nan ],
	[    60,  nan,  nan,     0.08,  0.00,  nan ],
	[    70,  nan,  nan,     0.13,  0.00,  nan ],
	[    80,  nan,  nan,     0.19,  0.00,  nan ],
	[    90,  nan,  nan,     0.26,  0.00,  nan ],
	[   100,  nan,  nan,     0.33,  0.00,  nan ],
	[   200,  nan,  nan,     7.59,  0.00,  nan ],
	[   300,  nan,  nan,     4.16,  0.00,  nan ],
	[   400,  nan,  nan,     8.19,  0.00,  nan ],
	[   500,  nan,  nan,    14.89,  0.00,  nan ],
	[   600,  nan,  nan,    19.41,  0.00,  nan ],
	[   700,  nan,  nan,    27.40,  0.00,  nan ],
	[   800,  nan,  nan,    32.89,  0.01,  nan ],
	[   900,  nan,  nan,    42.61,  0.01,  nan ],
	[  1000,  nan,  nan,    56.12,  0.01,  nan ],
	[  2000,  nan,  nan,   199.60,  0.01,  nan ],
	[  3000,  nan,  nan,   359.18,  0.03,  nan ],
	[  4000,  nan,  nan,   587.53,  0.04,  nan ],
	[  5000,  nan,  nan,   685.19,  0.06,  nan ],
	[  6000,  nan,  nan,   805.43,  0.09,  nan ],
	[  7000,  nan,  nan,   862.82,  0.13,  nan ],
	[  8000,  nan,  nan,   934.77,  0.18,  nan ],
	[  9000,  nan,  nan,   965.19,  0.25,  nan ],
	[ 10000,  nan,  nan,   993.38,  0.34,  nan ],
	[ 12000,  nan,  nan,  1051.02,  0.55,  nan ],
	[ 14000,  nan,  nan,  1093.94,  0.84,  nan ],
	[ 16000,  nan,  nan,  1125.16,  1.21,  nan ],
	[ 18000,  nan,  nan,  1138.27,  1.71,  nan ],
	[ 20000,  nan,  nan,  1157.84,  2.30,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/dsyevd.txt
# numactl --interleave=all ../testing/testing_dsyevd -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_dsyevd -JN -N 123 -N 1234 --range 12000:20000:2000
dsyevd_JN = array([
	[    10,   0.00,    0.00 ],
	[    20,   0.00,    0.00 ],
	[    30,   0.00,    0.00 ],
	[    40,   0.00,    0.00 ],
	[    50,   0.00,    0.00 ],
	[    60,   0.00,    0.00 ],
	[    70,   0.00,    0.00 ],
	[    80,   0.00,    0.00 ],
	[    90,   0.00,    0.00 ],
	[   100,   0.00,    0.00 ],
	[   200,   0.00,    0.00 ],
	[   300,   0.01,    0.01 ],
	[   400,   0.02,    0.02 ],
	[   500,   0.02,    0.02 ],
	[   600,   0.03,    0.03 ],
	[   700,   0.04,    0.04 ],
	[   800,   0.06,    0.06 ],
	[   900,   0.07,    0.07 ],
	[  1000,   0.09,    0.09 ],
	[  2000,   0.38,    0.39 ],
	[  3000,   0.83,    1.31 ],
	[  4000,   1.88,    2.33 ],
	[  5000,   3.78,    3.79 ],
	[  6000,   6.73,    5.72 ],
	[  7000,  10.70,    8.07 ],
	[  8000,  17.34,   11.10 ],
	[  9000,  24.02,   14.68 ],
	[ 10000,  31.29,   19.03 ],
	[ 12000,    nan,   30.50 ],
	[ 14000,    nan,   44.78 ],
	[ 16000,    nan,   63.92 ],
	[ 18000,    nan,   87.26 ],
	[ 20000,    nan,  115.13 ],
])

# numactl --interleave=all ../testing/testing_dsyevd -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_dsyevd -JV -N 123 -N 1234 --range 12000:20000:2000
dsyevd_JV = array([
	[    10,   0.00,    0.00 ],
	[    20,   0.00,    0.00 ],
	[    30,   0.00,    0.00 ],
	[    40,   0.00,    0.00 ],
	[    50,   0.00,    0.00 ],
	[    60,   0.00,    0.00 ],
	[    70,   0.00,    0.00 ],
	[    80,   0.00,    0.00 ],
	[    90,   0.00,    0.00 ],
	[   100,   0.00,    0.00 ],
	[   200,   0.01,    0.01 ],
	[   300,   0.02,    0.01 ],
	[   400,   0.03,    0.02 ],
	[   500,   0.04,    0.03 ],
	[   600,   0.06,    0.04 ],
	[   700,   0.08,    0.05 ],
	[   800,   0.10,    0.07 ],
	[   900,   0.13,    0.09 ],
	[  1000,   0.17,    0.11 ],
	[  2000,   0.79,    0.43 ],
	[  3000,   2.56,    1.39 ],
	[  4000,   5.01,    2.48 ],
	[  5000,   9.42,    3.98 ],
	[  6000,  15.74,    6.19 ],
	[  7000,  23.71,    8.75 ],
	[  8000,  33.23,   11.66 ],
	[  9000,  42.97,   15.61 ],
	[ 10000,  51.43,   20.52 ],
	[ 12000,    nan,   32.95 ],
	[ 14000,    nan,   49.69 ],
	[ 16000,    nan,   70.70 ],
	[ 18000,    nan,   98.13 ],
	[ 20000,    nan,  130.27 ],
])

# numactl --interleave=all ../testing/testing_dsyevd_gpu -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_dsyevd_gpu -JN -N 123 -N 1234 --range 12000:20000:2000
dsyevd_gpu_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.05 ],
	[   800,  nan,    0.07 ],
	[   900,  nan,    0.08 ],
	[  1000,  nan,    0.11 ],
	[  2000,  nan,    0.45 ],
	[  3000,  nan,    1.34 ],
	[  4000,  nan,    2.35 ],
	[  5000,  nan,    3.78 ],
	[  6000,  nan,    5.68 ],
	[  7000,  nan,    8.09 ],
	[  8000,  nan,   11.06 ],
	[  9000,  nan,   14.71 ],
	[ 10000,  nan,   18.94 ],
	[ 12000,  nan,   30.40 ],
	[ 14000,  nan,   44.57 ],
	[ 16000,  nan,   63.61 ],
	[ 18000,  nan,   87.04 ],
	[ 20000,  nan,  114.71 ],
])

# numactl --interleave=all ../testing/testing_dsyevd_gpu -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_dsyevd_gpu -JV -N 123 -N 1234 --range 12000:20000:2000
dsyevd_gpu_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.03 ],
	[   600,  nan,    0.04 ],
	[   700,  nan,    0.05 ],
	[   800,  nan,    0.07 ],
	[   900,  nan,    0.09 ],
	[  1000,  nan,    0.11 ],
	[  2000,  nan,    0.43 ],
	[  3000,  nan,    1.38 ],
	[  4000,  nan,    2.54 ],
	[  5000,  nan,    3.92 ],
	[  6000,  nan,    6.03 ],
	[  7000,  nan,    8.72 ],
	[  8000,  nan,   12.18 ],
	[  9000,  nan,   16.47 ],
	[ 10000,  nan,   21.41 ],
	[ 12000,  nan,   35.06 ],
	[ 14000,  nan,   52.53 ],
	[ 16000,  nan,   75.86 ],
	[ 18000,  nan,  105.16 ],
	[ 20000,  nan,  141.32 ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/dsyevd_2stage.txt
# numactl --interleave=all ../testing/testing_dsyevdx_2stage -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
dsyevdx_2stage_JN = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.01 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.03 ],
	[   500,    500,   0.04 ],
	[   600,    600,   0.07 ],
	[   700,    700,   0.08 ],
	[   800,    800,   0.11 ],
	[   900,    900,   0.12 ],
	[  1000,   1000,   0.15 ],
	[  2000,   2000,   0.40 ],
	[  3000,   3000,   0.85 ],
	[  4000,   4000,   1.32 ],
	[  5000,   5000,   1.82 ],
	[  6000,   6000,   2.68 ],
	[  7000,   7000,   3.46 ],
	[  8000,   8000,   4.50 ],
	[  9000,   9000,   5.53 ],
	[ 10000,  10000,   6.77 ],
	[ 12000,  12000,   9.92 ],
	[ 14000,  14000,  13.57 ],
	[ 16000,  16000,  17.96 ],
	[ 18000,  18000,  23.39 ],
	[ 20000,  20000,  29.93 ],
])

# numactl --interleave=all ../testing/testing_dsyevdx_2stage -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
dsyevdx_2stage_JV = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.01 ],
	[   300,    300,   0.03 ],
	[   400,    400,   0.04 ],
	[   500,    500,   0.06 ],
	[   600,    600,   0.09 ],
	[   700,    700,   0.11 ],
	[   800,    800,   0.13 ],
	[   900,    900,   0.15 ],
	[  1000,   1000,   0.17 ],
	[  2000,   2000,   0.54 ],
	[  3000,   3000,   1.08 ],
	[  4000,   4000,   1.88 ],
	[  5000,   5000,   2.91 ],
	[  6000,   6000,   4.37 ],
	[  7000,   7000,   6.05 ],
	[  8000,   8000,   8.51 ],
	[  9000,   9000,  11.15 ],
	[ 10000,  10000,  14.21 ],
	[ 12000,  12000,  22.86 ],
	[ 14000,  14000,  34.15 ],
	[ 16000,  16000,  47.65 ],
	[ 18000,  18000,  66.85 ],
	[ 20000,  20000,  90.53 ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/dsymv.txt
# numactl --interleave=all ../testing/testing_dsymv -L -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000 --lapack
dsymv_L = array([
	[    10,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.08,   0.00,  1.78e-16,  8.88e-17,  8.88e-17,  nan ],
	[    11,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.12,   0.00,  4.04e-17,  8.07e-17,  8.07e-17,  nan ],
	[    12,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.16,   0.00,  1.11e-16,  3.70e-17,  3.70e-17,  nan ],
	[    13,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.17,   0.00,  6.83e-17,  6.83e-17,  6.83e-17,  nan ],
	[    14,   0.01,   0.04,   0.01,   0.03,   0.02,   0.03,   0.22,   0.00,  6.34e-17,  6.34e-17,  6.34e-17,  nan ],
	[    15,   0.01,   0.04,   0.02,   0.03,   0.02,   0.03,   0.17,   0.00,  1.18e-16,  1.18e-16,  1.18e-16,  nan ],
	[    16,   0.01,   0.04,   0.02,   0.03,   0.02,   0.03,   0.25,   0.00,  1.11e-16,  1.11e-16,  1.11e-16,  nan ],
	[    17,   0.02,   0.04,   0.02,   0.03,   0.02,   0.03,   0.32,   0.00,  1.04e-16,  1.04e-16,  1.57e-16,  nan ],
	[    18,   0.02,   0.04,   0.02,   0.03,   0.03,   0.03,   0.36,   0.00,  9.87e-17,  1.48e-16,  9.87e-17,  nan ],
	[    19,   0.02,   0.04,   0.03,   0.03,   0.03,   0.03,   0.35,   0.00,  4.67e-17,  4.67e-17,  4.67e-17,  nan ],
	[    20,   0.02,   0.04,   0.03,   0.03,   0.03,   0.03,   0.29,   0.00,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    21,   0.03,   0.04,   0.03,   0.03,   0.04,   0.02,   0.30,   0.00,  8.46e-17,  1.69e-16,  8.46e-17,  nan ],
	[    22,   0.03,   0.04,   0.03,   0.03,   0.04,   0.03,   0.25,   0.00,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    23,   0.03,   0.04,   0.04,   0.03,   0.04,   0.03,   0.36,   0.00,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    24,   0.03,   0.04,   0.04,   0.03,   0.05,   0.03,   0.42,   0.00,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    25,   0.04,   0.04,   0.04,   0.03,   0.05,   0.03,   0.45,   0.00,  7.11e-17,  7.11e-17,  7.11e-17,  nan ],
	[    26,   0.04,   0.04,   0.05,   0.03,   0.05,   0.03,   0.49,   0.00,  1.37e-16,  1.37e-16,  1.37e-16,  nan ],
	[    27,   0.04,   0.04,   0.05,   0.03,   0.05,   0.03,   0.49,   0.00,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    28,   0.04,   0.04,   0.05,   0.03,   0.06,   0.03,   0.85,   0.00,  1.90e-16,  1.90e-16,  1.27e-16,  nan ],
	[    29,   0.05,   0.04,   0.06,   0.03,   0.06,   0.03,   0.61,   0.00,  1.23e-16,  1.23e-16,  1.23e-16,  nan ],
	[    30,   0.05,   0.04,   0.06,   0.03,   0.07,   0.03,   0.65,   0.00,  1.18e-16,  1.18e-16,  1.18e-16,  nan ],
	[    31,   0.05,   0.04,   0.06,   0.03,   0.07,   0.03,   0.64,   0.00,  1.15e-16,  1.15e-16,  1.15e-16,  nan ],
	[    32,   0.06,   0.04,   0.07,   0.03,   0.08,   0.03,   0.52,   0.00,  1.11e-16,  1.11e-16,  1.11e-16,  nan ],
	[    33,   0.06,   0.04,   0.06,   0.04,   0.08,   0.03,   0.55,   0.00,  1.61e-16,  1.08e-16,  1.08e-16,  nan ],
	[    34,   0.06,   0.04,   0.06,   0.04,   0.08,   0.03,   0.59,   0.00,  2.09e-16,  2.09e-16,  1.57e-16,  nan ],
	[    35,   0.07,   0.04,   0.07,   0.04,   0.09,   0.03,   0.81,   0.00,  1.02e-16,  1.52e-16,  1.02e-16,  nan ],
	[    36,   0.07,   0.04,   0.07,   0.04,   0.10,   0.03,   0.93,   0.00,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    37,   0.07,   0.04,   0.07,   0.04,   0.10,   0.03,   0.69,   0.00,  1.44e-16,  9.60e-17,  1.44e-16,  nan ],
	[    38,   0.08,   0.04,   0.08,   0.04,   0.11,   0.03,   0.96,   0.00,  1.40e-16,  9.35e-17,  1.40e-16,  nan ],
	[    39,   0.08,   0.04,   0.07,   0.04,   0.11,   0.03,   0.82,   0.00,  1.37e-16,  9.11e-17,  9.11e-17,  nan ],
	[    40,   0.08,   0.04,   0.09,   0.04,   0.12,   0.03,   0.81,   0.00,  8.88e-17,  1.33e-16,  8.88e-17,  nan ],
	[    41,   0.09,   0.04,   0.09,   0.04,   0.12,   0.03,   0.85,   0.00,  1.73e-16,  1.73e-16,  1.73e-16,  nan ],
	[    42,   0.10,   0.04,   0.10,   0.04,   0.12,   0.03,   0.89,   0.00,  2.11e-16,  1.27e-16,  8.46e-17,  nan ],
	[    43,   0.10,   0.04,   0.10,   0.04,   0.13,   0.03,   0.93,   0.00,  1.65e-16,  1.65e-16,  1.65e-16,  nan ],
	[    44,   0.10,   0.04,   0.10,   0.04,   0.12,   0.03,   0.98,   0.00,  1.21e-16,  1.61e-16,  1.61e-16,  nan ],
	[    45,   0.11,   0.04,   0.11,   0.04,   0.14,   0.03,   1.09,   0.00,  1.18e-16,  1.58e-16,  1.18e-16,  nan ],
	[    46,   0.10,   0.04,   0.12,   0.04,   0.15,   0.03,   1.07,   0.00,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    47,   0.12,   0.04,   0.12,   0.04,   0.16,   0.03,   1.11,   0.00,  1.51e-16,  1.51e-16,  1.51e-16,  nan ],
	[    48,   0.13,   0.04,   0.13,   0.04,   0.17,   0.03,   1.16,   0.00,  2.22e-16,  2.22e-16,  2.22e-16,  nan ],
	[    49,   0.14,   0.04,   0.14,   0.04,   0.17,   0.03,   1.21,   0.00,  1.45e-16,  2.18e-16,  1.45e-16,  nan ],
	[    50,   0.13,   0.04,   0.14,   0.04,   0.18,   0.03,   1.02,   0.01,  2.13e-16,  2.13e-16,  1.42e-16,  nan ],
	[    51,   0.15,   0.04,   0.14,   0.04,   0.18,   0.03,   1.06,   0.01,  2.09e-16,  1.39e-16,  1.39e-16,  nan ],
	[    52,   0.15,   0.04,   0.15,   0.04,   0.20,   0.03,   1.36,   0.00,  1.37e-16,  1.37e-16,  1.37e-16,  nan ],
	[    53,   0.15,   0.04,   0.15,   0.04,   0.20,   0.03,   1.14,   0.01,  1.34e-16,  2.01e-16,  1.34e-16,  nan ],
	[    54,   0.16,   0.04,   0.16,   0.04,   0.20,   0.03,   1.47,   0.00,  1.32e-16,  1.32e-16,  1.32e-16,  nan ],
	[    55,   0.17,   0.04,   0.16,   0.04,   0.22,   0.03,   1.23,   0.01,  1.29e-16,  1.94e-16,  1.29e-16,  nan ],
	[    56,   0.18,   0.04,   0.17,   0.04,   0.23,   0.03,   1.58,   0.00,  3.17e-16,  1.90e-16,  1.90e-16,  nan ],
	[    57,   0.18,   0.04,   0.17,   0.04,   0.24,   0.03,   1.32,   0.01,  1.87e-16,  1.87e-16,  1.87e-16,  nan ],
	[    58,   0.17,   0.04,   0.18,   0.04,   0.24,   0.03,   1.37,   0.01,  1.23e-16,  1.23e-16,  1.23e-16,  nan ],
	[    59,   0.19,   0.04,   0.19,   0.04,   0.24,   0.03,   1.41,   0.01,  1.81e-16,  1.81e-16,  1.20e-16,  nan ],
	[    60,   0.20,   0.04,   0.18,   0.04,   0.24,   0.03,   1.46,   0.01,  1.78e-16,  1.18e-16,  1.18e-16,  nan ],
	[    61,   0.19,   0.04,   0.19,   0.04,   0.26,   0.03,   1.51,   0.01,  2.33e-16,  1.75e-16,  1.75e-16,  nan ],
	[    62,   0.21,   0.04,   0.20,   0.04,   0.26,   0.03,   1.56,   0.01,  1.72e-16,  1.72e-16,  1.15e-16,  nan ],
	[    63,   0.21,   0.04,   0.21,   0.04,   0.27,   0.03,   1.35,   0.01,  1.13e-16,  1.13e-16,  1.13e-16,  nan ],
	[    64,   0.22,   0.04,   0.22,   0.04,   0.29,   0.03,   1.40,   0.01,  1.67e-16,  1.11e-16,  2.22e-16,  nan ],
	[    65,   0.20,   0.04,   0.21,   0.04,   0.27,   0.03,   1.38,   0.01,  2.19e-16,  1.64e-16,  1.64e-16,  nan ],
	[    66,   0.20,   0.05,   0.22,   0.04,   0.29,   0.03,   1.48,   0.01,  2.15e-16,  2.69e-16,  2.15e-16,  nan ],
	[    67,   0.21,   0.04,   0.23,   0.04,   0.27,   0.03,   1.27,   0.01,  1.59e-16,  1.59e-16,  1.59e-16,  nan ],
	[    68,   0.20,   0.05,   0.23,   0.04,   0.29,   0.03,   1.57,   0.01,  1.57e-16,  1.57e-16,  1.04e-16,  nan ],
	[    69,   0.22,   0.04,   0.24,   0.04,   0.30,   0.03,   1.56,   0.01,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    70,   0.22,   0.05,   0.25,   0.04,   0.31,   0.03,   1.60,   0.01,  2.03e-16,  2.54e-16,  2.54e-16,  nan ],
	[    71,   0.24,   0.04,   0.25,   0.04,   0.33,   0.03,   1.43,   0.01,  2.50e-16,  2.00e-16,  2.00e-16,  nan ],
	[    72,   0.23,   0.05,   0.26,   0.04,   0.33,   0.03,   1.70,   0.01,  1.97e-16,  1.97e-16,  1.48e-16,  nan ],
	[    73,   0.25,   0.04,   0.26,   0.04,   0.33,   0.03,   1.81,   0.01,  1.95e-16,  1.95e-16,  1.95e-16,  nan ],
	[    74,   0.25,   0.04,   0.28,   0.04,   0.36,   0.03,   1.86,   0.01,  1.44e-16,  1.92e-16,  1.92e-16,  nan ],
	[    75,   0.27,   0.04,   0.29,   0.04,   0.37,   0.03,   1.65,   0.01,  2.37e-16,  1.89e-16,  1.89e-16,  nan ],
	[    76,   0.28,   0.04,   0.30,   0.04,   0.38,   0.03,   1.96,   0.01,  1.40e-16,  2.34e-16,  1.87e-16,  nan ],
	[    77,   0.28,   0.04,   0.29,   0.04,   0.38,   0.03,   1.68,   0.01,  2.77e-16,  1.85e-16,  1.85e-16,  nan ],
	[    78,   0.29,   0.04,   0.31,   0.04,   0.40,   0.03,   1.78,   0.01,  2.28e-16,  2.73e-16,  2.28e-16,  nan ],
	[    79,   0.29,   0.04,   0.31,   0.04,   0.38,   0.03,   1.83,   0.01,  1.80e-16,  2.25e-16,  1.80e-16,  nan ],
	[    80,   0.29,   0.04,   0.32,   0.04,   0.39,   0.03,   1.87,   0.01,  2.66e-16,  1.78e-16,  1.78e-16,  nan ],
	[    81,   0.30,   0.04,   0.32,   0.04,   0.35,   0.04,   1.64,   0.01,  2.63e-16,  2.19e-16,  1.75e-16,  nan ],
	[    82,   0.30,   0.05,   0.33,   0.04,   0.41,   0.03,   1.68,   0.01,  1.73e-16,  1.73e-16,  1.30e-16,  nan ],
	[    83,   0.30,   0.05,   0.34,   0.04,   0.42,   0.03,   1.77,   0.01,  1.71e-16,  1.71e-16,  1.71e-16,  nan ],
	[    84,   0.32,   0.04,   0.34,   0.04,   0.43,   0.03,   1.76,   0.01,  2.11e-16,  2.11e-16,  1.69e-16,  nan ],
	[    85,   0.34,   0.04,   0.36,   0.04,   0.44,   0.03,   1.80,   0.01,  1.67e-16,  1.67e-16,  2.09e-16,  nan ],
	[    86,   0.33,   0.05,   0.36,   0.04,   0.45,   0.03,   1.85,   0.01,  1.65e-16,  2.07e-16,  1.65e-16,  nan ],
	[    87,   0.33,   0.05,   0.36,   0.04,   0.47,   0.03,   1.69,   0.01,  2.45e-16,  2.45e-16,  2.45e-16,  nan ],
	[    88,   0.34,   0.05,   0.37,   0.04,   0.46,   0.03,   1.99,   0.01,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    89,   0.34,   0.05,   0.38,   0.04,   0.50,   0.03,   1.82,   0.01,  2.40e-16,  1.60e-16,  1.60e-16,  nan ],
	[    90,   0.38,   0.04,   0.41,   0.04,   0.53,   0.03,   2.08,   0.01,  2.37e-16,  2.37e-16,  1.58e-16,  nan ],
	[   100,   0.46,   0.04,   0.48,   0.04,   0.60,   0.03,   2.57,   0.01,  1.78e-16,  2.13e-16,  2.13e-16,  nan ],
	[   110,   0.53,   0.05,   0.58,   0.04,   0.70,   0.04,   2.44,   0.01,  2.58e-16,  2.58e-16,  3.23e-16,  nan ],
	[   120,   0.63,   0.05,   0.66,   0.04,   0.81,   0.04,   2.65,   0.01,  2.37e-16,  2.96e-16,  2.37e-16,  nan ],
	[   130,   0.66,   0.05,   0.74,   0.05,   0.92,   0.04,   2.60,   0.01,  2.19e-16,  2.73e-16,  2.19e-16,  nan ],
	[   140,   0.77,   0.05,   0.86,   0.05,   1.03,   0.04,   2.81,   0.01,  3.05e-16,  2.54e-16,  3.05e-16,  nan ],
	[   150,   0.85,   0.05,   0.98,   0.05,   1.23,   0.04,   2.64,   0.02,  2.37e-16,  2.37e-16,  2.84e-16,  nan ],
	[   160,   1.01,   0.05,   1.12,   0.05,   1.39,   0.04,   3.00,   0.02,  2.22e-16,  1.78e-16,  1.78e-16,  nan ],
	[   170,   1.07,   0.05,   1.21,   0.05,   1.50,   0.04,   1.50,   0.04,  4.18e-16,  4.18e-16,  4.18e-16,  nan ],
	[   180,   1.30,   0.05,   1.36,   0.05,   1.67,   0.04,   1.76,   0.04,  2.37e-16,  2.76e-16,  2.37e-16,  nan ],
	[   190,   1.45,   0.05,   1.51,   0.05,   1.90,   0.04,   1.73,   0.04,  3.74e-16,  3.74e-16,  3.74e-16,  nan ],
	[   200,   1.36,   0.06,   1.58,   0.05,   1.97,   0.04,   1.83,   0.04,  5.68e-16,  6.39e-16,  5.68e-16,  nan ],
	[   210,   1.47,   0.06,   1.74,   0.05,   2.11,   0.04,   1.77,   0.05,  4.74e-16,  4.74e-16,  4.74e-16,  nan ],
	[   220,   1.62,   0.06,   1.87,   0.05,   2.32,   0.04,   1.80,   0.05,  4.52e-16,  3.88e-16,  3.88e-16,  nan ],
	[   230,   1.83,   0.06,   2.04,   0.05,   2.48,   0.04,   1.90,   0.06,  4.33e-16,  4.33e-16,  3.71e-16,  nan ],
	[   240,   2.02,   0.06,   2.10,   0.06,   2.68,   0.04,   2.23,   0.05,  3.55e-16,  2.96e-16,  3.55e-16,  nan ],
	[   250,   2.17,   0.06,   2.32,   0.05,   2.85,   0.04,   2.16,   0.06,  3.41e-16,  3.41e-16,  3.41e-16,  nan ],
	[   260,   2.03,   0.07,   2.48,   0.05,   2.88,   0.05,   3.23,   0.04,  3.83e-16,  3.28e-16,  3.28e-16,  nan ],
	[   270,   2.28,   0.06,   2.66,   0.06,   3.04,   0.05,   2.76,   0.05,  4.74e-16,  4.21e-16,  4.21e-16,  nan ],
	[   280,   2.50,   0.06,   2.92,   0.05,   3.42,   0.05,   3.08,   0.05,  4.57e-16,  4.06e-16,  3.55e-16,  nan ],
	[   290,   2.59,   0.07,   3.01,   0.06,   3.44,   0.05,   3.37,   0.05,  4.41e-16,  3.43e-16,  4.41e-16,  nan ],
	[   300,   2.78,   0.06,   3.17,   0.06,   3.61,   0.05,   3.28,   0.06,  6.63e-16,  4.74e-16,  4.74e-16,  nan ],
	[   310,   3.01,   0.06,   3.38,   0.06,   3.87,   0.05,   2.92,   0.07,  4.13e-16,  4.58e-16,  4.58e-16,  nan ],
	[   320,   3.12,   0.07,   3.67,   0.06,   4.20,   0.05,   3.16,   0.07,  4.00e-16,  4.00e-16,  3.55e-16,  nan ],
	[   330,   3.03,   0.07,   3.69,   0.06,   4.20,   0.05,   3.32,   0.07,  6.03e-16,  5.17e-16,  5.17e-16,  nan ],
	[   340,   3.26,   0.07,   3.86,   0.06,   4.54,   0.05,   3.27,   0.07,  5.02e-16,  4.60e-16,  5.02e-16,  nan ],
	[   350,   3.57,   0.07,   4.04,   0.06,   4.73,   0.05,   3.00,   0.08,  4.06e-16,  4.06e-16,  4.87e-16,  nan ],
	[   360,   3.52,   0.07,   4.26,   0.06,   4.82,   0.05,   3.38,   0.08,  6.32e-16,  4.74e-16,  5.53e-16,  nan ],
	[   370,   3.81,   0.07,   4.35,   0.06,   5.01,   0.05,   3.27,   0.08,  5.38e-16,  5.38e-16,  5.38e-16,  nan ],
	[   380,   4.08,   0.07,   4.65,   0.06,   5.37,   0.05,   3.49,   0.08,  5.98e-16,  5.98e-16,  6.73e-16,  nan ],
	[   390,   3.96,   0.08,   4.77,   0.06,   5.44,   0.06,   4.24,   0.07,  6.56e-16,  5.83e-16,  5.10e-16,  nan ],
	[   400,   4.17,   0.08,   5.10,   0.06,   5.73,   0.06,   4.86,   0.07,  8.53e-16,  7.82e-16,  7.11e-16,  nan ],
	[   410,   4.43,   0.08,   5.03,   0.07,   6.02,   0.06,   5.03,   0.07,  4.85e-16,  4.85e-16,  4.85e-16,  nan ],
	[   420,   4.48,   0.08,   5.28,   0.07,   6.10,   0.06,   5.05,   0.07,  6.77e-16,  6.77e-16,  5.41e-16,  nan ],
	[   430,   4.75,   0.08,   5.45,   0.07,   6.29,   0.06,   4.26,   0.09,  6.61e-16,  7.27e-16,  5.95e-16,  nan ],
	[   440,   4.73,   0.08,   5.71,   0.07,   6.46,   0.06,   4.68,   0.08,  5.17e-16,  5.17e-16,  5.17e-16,  nan ],
	[   450,   4.77,   0.09,   5.79,   0.07,   6.33,   0.06,   4.82,   0.08,  5.05e-16,  5.05e-16,  5.05e-16,  nan ],
	[   460,   5.11,   0.08,   6.24,   0.07,   6.95,   0.06,   4.87,   0.09,  8.65e-16,  8.03e-16,  7.41e-16,  nan ],
	[   470,   5.26,   0.08,   6.52,   0.07,   7.25,   0.06,   4.43,   0.10,  6.05e-16,  6.05e-16,  6.05e-16,  nan ],
	[   480,   5.78,   0.08,   6.89,   0.07,   7.69,   0.06,   4.44,   0.10,  6.51e-16,  6.51e-16,  6.51e-16,  nan ],
	[   490,   5.94,   0.08,   6.89,   0.07,   7.29,   0.07,   4.76,   0.10,  7.54e-16,  7.54e-16,  7.54e-16,  nan ],
	[   500,   5.95,   0.08,   7.15,   0.07,   7.70,   0.07,   4.59,   0.11,  8.53e-16,  7.96e-16,  8.53e-16,  nan ],
	[   510,   6.51,   0.08,   7.44,   0.07,   8.16,   0.06,   4.49,   0.12,  8.36e-16,  7.80e-16,  7.80e-16,  nan ],
	[   520,   5.96,   0.09,   7.53,   0.07,   8.09,   0.07,   6.23,   0.09,  7.65e-16,  6.01e-16,  5.47e-16,  nan ],
	[   530,   6.25,   0.09,   7.72,   0.07,   8.25,   0.07,   6.61,   0.09,  6.97e-16,  6.44e-16,  6.44e-16,  nan ],
	[   540,   6.64,   0.09,   7.88,   0.07,   8.34,   0.07,   6.22,   0.09,  6.84e-16,  5.79e-16,  5.26e-16,  nan ],
	[   550,   6.67,   0.09,   7.97,   0.08,   8.53,   0.07,   5.56,   0.11,  5.17e-16,  5.17e-16,  6.20e-16,  nan ],
	[   560,   6.97,   0.09,   8.37,   0.08,   8.87,   0.07,   5.56,   0.11,  5.58e-16,  5.58e-16,  6.09e-16,  nan ],
	[   570,   7.07,   0.09,   8.56,   0.08,   9.04,   0.07,   5.52,   0.12,  8.48e-16,  6.98e-16,  7.98e-16,  nan ],
	[   580,   6.95,   0.10,   8.75,   0.08,   9.36,   0.07,   5.85,   0.12,  6.86e-16,  6.86e-16,  6.37e-16,  nan ],
	[   590,   6.96,   0.10,   8.95,   0.08,   9.44,   0.07,   5.45,   0.13,  8.19e-16,  8.19e-16,  7.23e-16,  nan ],
	[   600,   7.20,   0.10,   8.92,   0.08,   9.76,   0.07,   5.50,   0.13,  7.58e-16,  7.58e-16,  7.58e-16,  nan ],
	[   610,   7.52,   0.10,   8.98,   0.08,   9.80,   0.08,   5.64,   0.13,  6.52e-16,  5.13e-16,  6.06e-16,  nan ],
	[   620,   7.69,   0.10,   9.18,   0.08,  10.00,   0.08,   5.59,   0.14,  5.96e-16,  6.42e-16,  5.96e-16,  nan ],
	[   630,   8.04,   0.10,   9.47,   0.08,  10.45,   0.08,   5.56,   0.14,  6.77e-16,  7.22e-16,  6.77e-16,  nan ],
	[   640,   7.89,   0.10,   9.53,   0.09,  10.65,   0.08,   7.34,   0.11,  5.77e-16,  6.22e-16,  5.77e-16,  nan ],
	[   650,   7.91,   0.11,   9.73,   0.09,  10.86,   0.08,   7.63,   0.11,  7.00e-16,  6.12e-16,  6.12e-16,  nan ],
	[   660,   8.08,   0.11,   9.79,   0.09,  10.89,   0.08,   7.45,   0.12,  7.32e-16,  6.46e-16,  6.46e-16,  nan ],
	[   670,   8.33,   0.11,  10.00,   0.09,  11.12,   0.08,   6.51,   0.14,  5.51e-16,  5.51e-16,  5.51e-16,  nan ],
	[   680,   8.50,   0.11,  10.30,   0.09,  11.60,   0.08,   6.56,   0.14,  5.85e-16,  5.85e-16,  6.69e-16,  nan ],
	[   690,   8.68,   0.11,  10.36,   0.09,  11.46,   0.08,   6.45,   0.15,  6.18e-16,  5.77e-16,  4.94e-16,  nan ],
	[   700,   8.78,   0.11,  10.55,   0.09,  11.83,   0.08,   6.63,   0.15,  6.50e-16,  6.90e-16,  7.31e-16,  nan ],
	[   710,   8.55,   0.12,  10.64,   0.09,  12.03,   0.08,   6.23,   0.16,  1.04e-15,  9.61e-16,  8.81e-16,  nan ],
	[   720,   8.94,   0.12,  11.17,   0.09,  12.51,   0.08,   6.57,   0.16,  9.47e-16,  9.47e-16,  9.47e-16,  nan ],
	[   730,   9.21,   0.12,  11.25,   0.09,  12.00,   0.09,   6.71,   0.16,  8.57e-16,  7.79e-16,  7.01e-16,  nan ],
	[   740,   9.39,   0.12,  11.41,   0.10,  12.33,   0.09,   6.76,   0.16,  7.68e-16,  6.91e-16,  6.91e-16,  nan ],
	[   750,   9.55,   0.12,  11.72,   0.10,  12.40,   0.09,   6.39,   0.18,  7.58e-16,  7.58e-16,  8.34e-16,  nan ],
	[   760,   9.55,   0.12,  11.80,   0.10,  12.87,   0.09,   6.54,   0.18,  6.73e-16,  5.98e-16,  5.98e-16,  nan ],
	[   770,   9.65,   0.12,  11.97,   0.10,  12.90,   0.09,   8.08,   0.15,  7.38e-16,  5.91e-16,  6.64e-16,  nan ],
	[   780,   9.68,   0.13,  12.31,   0.10,  12.68,   0.10,   8.18,   0.15,  1.02e-15,  1.02e-15,  9.47e-16,  nan ],
	[   790,  10.16,   0.12,  12.36,   0.10,  13.44,   0.09,   7.66,   0.16,  7.91e-16,  7.20e-16,  7.91e-16,  nan ],
	[   800,  10.24,   0.13,  12.68,   0.10,  13.64,   0.09,   7.59,   0.17,  8.53e-16,  8.53e-16,  7.82e-16,  nan ],
	[   810,  10.44,   0.13,  12.76,   0.10,  13.67,   0.10,   7.30,   0.18,  9.82e-16,  8.42e-16,  8.42e-16,  nan ],
	[   820,  10.60,   0.13,  12.95,   0.10,  14.19,   0.09,   7.44,   0.18,  8.32e-16,  8.32e-16,  8.32e-16,  nan ],
	[   830,  10.69,   0.13,  13.24,   0.10,  14.36,   0.10,   7.38,   0.19,  1.03e-15,  9.59e-16,  8.90e-16,  nan ],
	[   840,  10.62,   0.13,  13.32,   0.11,  14.56,   0.10,   7.65,   0.18,  7.44e-16,  8.12e-16,  8.80e-16,  nan ],
	[   850,  10.87,   0.13,  13.67,   0.11,  14.91,   0.10,   7.45,   0.19,  8.69e-16,  9.36e-16,  9.36e-16,  nan ],
	[   860,  11.05,   0.13,  13.96,   0.11,  14.82,   0.10,   7.52,   0.20,  9.91e-16,  9.25e-16,  1.06e-15,  nan ],
	[   870,  11.21,   0.14,  13.91,   0.11,  15.03,   0.10,   7.22,   0.21,  9.80e-16,  7.84e-16,  7.84e-16,  nan ],
	[   880,  11.57,   0.13,  14.48,   0.11,  15.48,   0.10,   7.25,   0.21,  8.40e-16,  9.04e-16,  9.04e-16,  nan ],
	[   890,  11.84,   0.13,  14.43,   0.11,  15.69,   0.10,   7.14,   0.22,  9.58e-16,  8.94e-16,  9.58e-16,  nan ],
	[   900,  11.49,   0.14,  14.35,   0.11,  15.60,   0.10,   8.77,   0.19,  1.01e-15,  1.01e-15,  1.01e-15,  nan ],
	[  1000,  13.08,   0.15,  16.69,   0.12,  17.39,   0.12,   7.98,   0.25,  1.08e-15,  9.66e-16,  1.02e-15,  nan ],
	[  1100,  14.25,   0.17,  18.95,   0.13,  11.94,   0.20,   8.68,   0.28,  1.09e-15,  9.30e-16,  9.82e-16,  nan ],
	[  1200,  16.01,   0.18,  21.06,   0.14,  12.99,   0.22,   9.14,   0.32,  9.47e-16,  9.47e-16,  9.00e-16,  nan ],
	[  1300,  16.83,   0.20,  22.85,   0.15,  13.64,   0.25,   8.13,   0.42,  8.31e-16,  9.62e-16,  1.01e-15,  nan ],
	[  1400,  19.13,   0.21,  24.67,   0.16,  15.21,   0.26,   8.23,   0.48,  1.14e-15,  1.22e-15,  1.06e-15,  nan ],
	[  1500,  20.01,   0.23,  26.68,   0.17,  16.02,   0.28,   8.88,   0.51,  1.29e-15,  1.06e-15,  1.21e-15,  nan ],
	[  1600,  21.45,   0.24,  28.27,   0.18,  16.68,   0.31,   8.60,   0.60,  1.28e-15,  1.28e-15,  1.28e-15,  nan ],
	[  1700,  22.23,   0.26,  29.65,   0.20,  17.38,   0.33,   9.79,   0.59,  1.20e-15,  1.27e-15,  1.27e-15,  nan ],
	[  1800,  24.09,   0.27,  31.92,   0.20,  18.37,   0.35,   9.71,   0.67,  1.14e-15,  1.33e-15,  1.26e-15,  nan ],
	[  1900,  25.25,   0.29,  33.30,   0.22,  19.36,   0.37,   9.19,   0.79,  1.56e-15,  1.56e-15,  1.62e-15,  nan ],
	[  2000,  26.17,   0.31,  34.50,   0.23,  20.31,   0.39,   9.68,   0.83,  1.53e-15,  1.53e-15,  1.48e-15,  nan ],
	[  2100,  27.56,   0.32,  36.29,   0.24,  15.24,   0.58,   9.79,   0.90,  1.57e-15,  1.57e-15,  1.52e-15,  nan ],
	[  2200,  28.81,   0.34,  37.40,   0.26,  16.27,   0.60,  10.19,   0.95,  1.65e-15,  1.86e-15,  1.71e-15,  nan ],
	[  2300,  30.49,   0.35,  39.50,   0.27,  16.75,   0.63,  10.14,   1.04,  1.58e-15,  1.43e-15,  1.43e-15,  nan ],
	[  2400,  32.01,   0.36,  40.72,   0.28,  17.67,   0.65,  10.36,   1.11,  1.47e-15,  1.37e-15,  1.42e-15,  nan ],
	[  2500,  32.48,   0.39,  42.37,   0.30,  18.29,   0.68,  10.59,   1.18,  1.64e-15,  1.59e-15,  1.59e-15,  nan ],
	[  2600,  33.65,   0.40,  43.77,   0.31,  18.78,   0.72,  10.59,   1.28,  1.62e-15,  1.62e-15,  1.53e-15,  nan ],
	[  2700,  35.75,   0.41,  45.42,   0.32,  19.68,   0.74,  10.93,   1.33,  1.39e-15,  1.35e-15,  1.52e-15,  nan ],
	[  2800,  35.97,   0.44,  46.14,   0.34,  19.91,   0.79,  10.83,   1.45,  1.54e-15,  1.54e-15,  1.54e-15,  nan ],
	[  2900,  37.56,   0.45,  47.68,   0.35,  20.95,   0.80,  10.81,   1.56,  1.72e-15,  1.72e-15,  1.72e-15,  nan ],
	[  3000,  38.63,   0.47,  49.75,   0.36,  21.61,   0.83,  11.28,   1.60,  1.67e-15,  1.59e-15,  1.59e-15,  nan ],
	[  3100,  39.72,   0.48,  50.06,   0.38,  17.46,   1.10,  11.06,   1.74,  2.05e-15,  2.05e-15,  2.13e-15,  nan ],
	[  3200,  41.31,   0.50,  52.14,   0.39,  18.10,   1.13,  11.23,   1.82,  1.85e-15,  1.99e-15,  1.63e-15,  nan ],
	[  3300,  42.38,   0.51,  52.25,   0.42,  18.59,   1.17,  11.04,   1.97,  2.00e-15,  1.86e-15,  1.86e-15,  nan ],
	[  3400,  43.15,   0.54,  53.80,   0.43,  19.11,   1.21,  11.21,   2.06,  1.94e-15,  2.14e-15,  1.94e-15,  nan ],
	[  3500,  44.06,   0.56,  55.20,   0.44,  19.70,   1.24,  11.74,   2.09,  2.01e-15,  2.08e-15,  2.14e-15,  nan ],
	[  3600,  45.81,   0.57,  56.00,   0.46,  20.15,   1.29,  11.81,   2.19,  2.21e-15,  2.15e-15,  2.21e-15,  nan ],
	[  3700,  46.26,   0.59,  58.76,   0.47,  20.65,   1.33,  11.35,   2.41,  2.09e-15,  2.09e-15,  1.97e-15,  nan ],
	[  3800,  47.83,   0.60,  58.70,   0.49,  21.02,   1.37,  11.75,   2.46,  2.21e-15,  1.97e-15,  2.15e-15,  nan ],
	[  3900,  48.45,   0.63,  59.33,   0.51,  21.73,   1.40,  11.44,   2.66,  2.16e-15,  2.16e-15,  1.92e-15,  nan ],
	[  4000,  48.00,   0.67,  60.97,   0.52,  22.02,   1.45,  11.89,   2.69,  2.22e-15,  2.22e-15,  2.16e-15,  nan ],
	[  4100,  47.03,   0.72,  60.69,   0.55,  18.23,   1.84,  12.25,   2.75,  1.94e-15,  2.05e-15,  2.11e-15,  nan ],
	[  4200,  47.30,   0.75,  62.90,   0.56,  18.99,   1.86,  11.88,   2.97,  1.84e-15,  2.11e-15,  2.11e-15,  nan ],
	[  4300,  47.85,   0.77,  63.66,   0.58,  19.51,   1.90,  11.94,   3.10,  2.54e-15,  2.59e-15,  2.54e-15,  nan ],
	[  4400,  48.29,   0.80,  65.87,   0.59,  19.90,   1.95,  12.02,   3.22,  2.22e-15,  2.17e-15,  2.33e-15,  nan ],
	[  4500,  48.81,   0.83,  65.12,   0.62,  20.39,   1.99,  12.08,   3.35,  2.37e-15,  2.27e-15,  2.37e-15,  nan ],
	[  4600,  49.91,   0.85,  64.91,   0.65,  20.77,   2.04,  12.37,   3.42,  2.22e-15,  2.13e-15,  2.08e-15,  nan ],
	[  4700,  49.98,   0.88,  65.28,   0.68,  21.20,   2.08,  12.02,   3.67,  2.90e-15,  2.47e-15,  2.52e-15,  nan ],
	[  4800,  49.71,   0.93,  66.32,   0.69,  21.58,   2.14,  12.64,   3.65,  2.27e-15,  2.37e-15,  2.46e-15,  nan ],
	[  4900,  49.81,   0.96,  66.16,   0.73,  21.95,   2.19,  12.18,   3.94,  2.27e-15,  2.23e-15,  2.13e-15,  nan ],
	[  5000,  50.01,   1.00,  67.04,   0.75,  22.14,   2.26,  12.41,   4.03,  2.32e-15,  2.27e-15,  2.18e-15,  nan ],
	[  5100,  51.42,   1.01,  66.80,   0.78,  22.66,   2.30,  12.40,   4.20,  2.14e-15,  2.14e-15,  2.10e-15,  nan ],
	[  5200,  51.03,   1.06,  67.28,   0.80,  19.77,   2.74,  12.34,   4.38,  2.54e-15,  2.54e-15,  2.45e-15,  nan ],
	[  5300,  51.22,   1.10,  67.78,   0.83,  20.15,   2.79,  12.44,   4.52,  2.15e-15,  1.93e-15,  2.10e-15,  nan ],
	[  5400,  51.66,   1.13,  68.23,   0.85,  20.42,   2.86,  12.63,   4.62,  2.11e-15,  1.98e-15,  2.06e-15,  nan ],
	[  5500,  52.38,   1.16,  68.23,   0.89,  20.62,   2.93,  12.49,   4.84,  1.98e-15,  2.23e-15,  2.11e-15,  nan ],
	[  5600,  52.98,   1.18,  67.88,   0.92,  21.24,   2.95,  12.69,   4.94,  2.19e-15,  2.44e-15,  2.35e-15,  nan ],
	[  5700,  53.27,   1.22,  67.76,   0.96,  21.39,   3.04,  12.56,   5.17,  2.55e-15,  2.39e-15,  2.47e-15,  nan ],
	[  5800,  52.85,   1.27,  67.96,   0.99,  21.74,   3.10,  12.93,   5.21,  2.43e-15,  2.35e-15,  2.20e-15,  nan ],
	[  5900,  53.73,   1.30,  67.67,   1.03,  22.10,   3.15,  12.72,   5.48,  2.54e-15,  2.31e-15,  2.31e-15,  nan ],
	[  6000,  53.58,   1.34,  67.43,   1.07,  22.44,   3.21,  12.59,   5.72,  2.80e-15,  2.50e-15,  2.58e-15,  nan ],
	[  6100,  54.41,   1.37,  68.54,   1.09,  22.77,   3.27,  12.85,   5.79,  2.53e-15,  2.16e-15,  2.24e-15,  nan ],
	[  6200,  54.73,   1.41,  67.70,   1.14,  20.19,   3.81,  12.71,   6.05,  2.49e-15,  2.57e-15,  2.42e-15,  nan ],
	[  6300,  54.61,   1.45,  67.79,   1.17,  20.63,   3.85,  11.99,   6.62,  2.53e-15,  2.45e-15,  2.67e-15,  nan ],
	[  6400,  55.39,   1.48,  66.94,   1.22,  20.79,   3.94,  12.24,   6.69,  2.98e-15,  2.70e-15,  2.49e-15,  nan ],
	[  6500,  55.93,   1.51,  68.43,   1.24,  20.98,   4.03,  12.20,   6.93,  2.59e-15,  2.59e-15,  2.45e-15,  nan ],
	[  6600,  56.95,   1.53,  68.77,   1.27,  21.40,   4.07,  13.12,   6.64,  2.82e-15,  3.03e-15,  3.24e-15,  nan ],
	[  6700,  57.16,   1.57,  68.70,   1.31,  21.58,   4.16,  12.92,   6.95,  3.67e-15,  3.46e-15,  3.67e-15,  nan ],
	[  6800,  56.47,   1.64,  68.77,   1.34,  21.92,   4.22,  13.20,   7.00,  3.21e-15,  3.21e-15,  3.41e-15,  nan ],
	[  6900,  57.86,   1.65,  68.71,   1.39,  22.00,   4.33,  13.21,   7.21,  3.23e-15,  2.83e-15,  3.10e-15,  nan ],
	[  7000,  57.29,   1.71,  69.27,   1.42,  22.54,   4.35,  13.24,   7.40,  2.99e-15,  2.79e-15,  2.73e-15,  nan ],
	[  7100,  57.65,   1.75,  68.93,   1.46,  22.70,   4.44,  13.15,   7.67,  2.82e-15,  3.07e-15,  2.82e-15,  nan ],
	[  7200,  58.99,   1.76,  68.49,   1.51,  20.49,   5.06,  13.31,   7.79,  3.16e-15,  2.91e-15,  3.03e-15,  nan ],
	[  7300,  58.70,   1.82,  69.63,   1.53,  20.72,   5.14,  11.90,   8.96,  3.05e-15,  2.87e-15,  2.74e-15,  nan ],
	[  7400,  58.86,   1.86,  70.03,   1.56,  21.09,   5.19,  12.42,   8.82,  3.13e-15,  3.13e-15,  3.07e-15,  nan ],
	[  7500,  59.28,   1.90,  69.75,   1.61,  21.21,   5.31,  13.23,   8.50,  2.97e-15,  3.03e-15,  3.27e-15,  nan ],
	[  7600,  60.15,   1.92,  70.24,   1.64,  21.25,   5.44,  13.56,   8.52,  3.23e-15,  3.35e-15,  3.29e-15,  nan ],
	[  7700,  59.48,   1.99,  69.56,   1.70,  21.78,   5.44,  13.38,   8.87,  2.78e-15,  2.60e-15,  2.60e-15,  nan ],
	[  7800,  60.10,   2.02,  69.94,   1.74,  22.13,   5.50,  13.26,   9.18,  2.62e-15,  2.80e-15,  3.09e-15,  nan ],
	[  7900,  59.30,   2.10,  69.74,   1.79,  22.30,   5.60,  13.19,   9.46,  2.88e-15,  3.28e-15,  3.34e-15,  nan ],
	[  8000,  59.49,   2.15,  69.84,   1.83,  22.48,   5.69,  13.37,   9.57,  2.90e-15,  3.01e-15,  3.30e-15,  nan ],
	[  8100,  59.81,   2.19,  70.90,   1.85,  22.78,   5.76,  13.30,   9.86,  3.26e-15,  2.92e-15,  2.86e-15,  nan ],
	[  8200,  60.23,   2.23,  70.27,   1.91,  20.56,   6.54,  13.34,  10.08,  3.33e-15,  3.11e-15,  3.33e-15,  nan ],
	[  8300,  60.44,   2.28,  71.99,   1.91,  20.47,   6.73,  12.27,  11.23,  3.51e-15,  3.51e-15,  3.45e-15,  nan ],
	[  8400,  59.45,   2.37,  72.09,   1.96,  21.17,   6.67,  13.52,  10.44,  2.92e-15,  3.03e-15,  2.87e-15,  nan ],
	[  8500,  60.75,   2.38,  71.72,   2.02,  21.46,   6.73,  13.45,  10.75,  3.69e-15,  3.42e-15,  3.32e-15,  nan ],
	[  8600,  60.21,   2.46,  71.43,   2.07,  21.66,   6.83,  13.69,  10.81,  2.86e-15,  3.23e-15,  3.01e-15,  nan ],
	[  8700,  60.15,   2.52,  72.86,   2.08,  21.87,   6.92,  13.45,  11.25,  3.55e-15,  3.76e-15,  3.71e-15,  nan ],
	[  8800,  59.74,   2.59,  71.06,   2.18,  22.09,   7.01,  13.50,  11.48,  3.36e-15,  3.36e-15,  3.67e-15,  nan ],
	[  8900,  59.81,   2.65,  72.41,   2.19,  22.27,   7.11,  13.55,  11.69,  3.37e-15,  3.58e-15,  3.27e-15,  nan ],
	[  9000,  60.54,   2.68,  72.72,   2.23,  22.26,   7.28,  13.67,  11.85,  4.19e-15,  4.60e-15,  4.55e-15,  nan ],
	[ 10000,  62.19,   3.22,  73.00,   2.74,  22.35,   8.95,  13.92,  14.37,  3.41e-15,  3.59e-15,  3.41e-15,  nan ],
	[ 12000,  63.23,   4.55,  72.79,   3.96,  21.94,  13.13,  14.20,  20.28,  3.87e-15,  3.79e-15,  4.24e-15,  nan ],
	[ 14000,  65.70,   5.97,  74.63,   5.25,  21.84,  17.95,  14.41,  27.20,  4.09e-15,  3.90e-15,  3.83e-15,  nan ],
	[ 16000,  66.71,   7.68,  74.49,   6.87,  22.46,  22.80,  13.87,  36.92,  4.72e-15,  4.89e-15,  4.77e-15,  nan ],
	[ 18000,  66.65,   9.72,  75.07,   8.63,  22.22,  29.17,  14.30,  45.32,  5.41e-15,  5.10e-15,  5.15e-15,  nan ],
	[ 20000,  67.73,  11.81,  75.33,  10.62,  21.30,  37.56,  14.99,  53.37,  5.32e-15,  5.73e-15,  5.82e-15,  nan ],
])

# numactl --interleave=all ../testing/testing_dsymv -U -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000 --lapack
dsymv_U = array([
	[    10,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.10,   0.00,  8.88e-17,  4.44e-17,  8.88e-17,  nan ],
	[    11,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.12,   0.00,  4.04e-17,  8.07e-17,  8.07e-17,  nan ],
	[    12,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.16,   0.00,  7.40e-17,  3.70e-17,  3.70e-17,  nan ],
	[    13,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.17,   0.00,  6.83e-17,  6.83e-17,  6.83e-17,  nan ],
	[    14,   0.01,   0.04,   0.01,   0.03,   0.01,   0.03,   0.20,   0.00,  6.34e-17,  6.34e-17,  6.34e-17,  nan ],
	[    15,   0.01,   0.04,   0.02,   0.03,   0.02,   0.03,   0.17,   0.00,  5.92e-17,  5.92e-17,  1.18e-16,  nan ],
	[    16,   0.01,   0.04,   0.02,   0.03,   0.02,   0.03,   0.19,   0.00,  1.11e-16,  1.11e-16,  5.55e-17,  nan ],
	[    17,   0.02,   0.04,   0.02,   0.03,   0.02,   0.03,   0.32,   0.00,  1.57e-16,  2.09e-16,  1.04e-16,  nan ],
	[    18,   0.02,   0.04,   0.02,   0.03,   0.03,   0.03,   0.22,   0.00,  1.48e-16,  9.87e-17,  9.87e-17,  nan ],
	[    19,   0.02,   0.04,   0.03,   0.03,   0.03,   0.03,   0.40,   0.00,  9.35e-17,  9.35e-17,  9.35e-17,  nan ],
	[    20,   0.02,   0.04,   0.03,   0.03,   0.03,   0.03,   0.29,   0.00,  8.88e-17,  8.88e-17,  8.88e-17,  nan ],
	[    21,   0.02,   0.04,   0.03,   0.03,   0.04,   0.03,   0.43,   0.00,  1.69e-16,  8.46e-17,  8.46e-17,  nan ],
	[    22,   0.03,   0.04,   0.03,   0.03,   0.04,   0.03,   0.53,   0.00,  1.61e-16,  1.61e-16,  1.61e-16,  nan ],
	[    23,   0.03,   0.04,   0.04,   0.03,   0.04,   0.03,   0.36,   0.00,  1.54e-16,  7.72e-17,  7.72e-17,  nan ],
	[    24,   0.03,   0.04,   0.04,   0.03,   0.04,   0.03,   0.63,   0.00,  1.48e-16,  2.22e-16,  1.48e-16,  nan ],
	[    25,   0.03,   0.04,   0.04,   0.03,   0.05,   0.03,   0.42,   0.00,  1.42e-16,  1.42e-16,  1.42e-16,  nan ],
	[    26,   0.04,   0.04,   0.05,   0.03,   0.05,   0.03,   0.45,   0.00,  2.05e-16,  1.37e-16,  2.05e-16,  nan ],
	[    27,   0.04,   0.04,   0.05,   0.03,   0.06,   0.03,   0.53,   0.00,  1.32e-16,  1.32e-16,  1.97e-16,  nan ],
	[    28,   0.05,   0.04,   0.06,   0.03,   0.06,   0.03,   0.52,   0.00,  1.27e-16,  1.90e-16,  1.27e-16,  nan ],
	[    29,   0.05,   0.04,   0.06,   0.03,   0.06,   0.03,   0.56,   0.00,  1.23e-16,  1.84e-16,  1.23e-16,  nan ],
	[    30,   0.05,   0.04,   0.06,   0.03,   0.07,   0.03,   0.65,   0.00,  1.78e-16,  1.18e-16,  1.78e-16,  nan ],
	[    31,   0.05,   0.04,   0.07,   0.03,   0.08,   0.03,   0.64,   0.00,  1.15e-16,  2.29e-16,  1.72e-16,  nan ],
	[    32,   0.06,   0.04,   0.07,   0.03,   0.08,   0.03,   0.68,   0.00,  1.67e-16,  1.67e-16,  1.67e-16,  nan ],
	[    33,   0.06,   0.04,   0.06,   0.04,   0.07,   0.03,   0.78,   0.00,  1.61e-16,  1.08e-16,  1.08e-16,  nan ],
	[    34,   0.06,   0.04,   0.06,   0.04,   0.08,   0.03,   0.59,   0.00,  2.09e-16,  2.61e-16,  1.57e-16,  nan ],
	[    35,   0.07,   0.04,   0.06,   0.04,   0.09,   0.03,   0.62,   0.00,  1.52e-16,  1.52e-16,  1.02e-16,  nan ],
	[    36,   0.07,   0.04,   0.07,   0.04,   0.09,   0.03,   0.93,   0.00,  1.48e-16,  1.97e-16,  9.87e-17,  nan ],
	[    37,   0.08,   0.04,   0.07,   0.04,   0.10,   0.03,   0.98,   0.00,  1.92e-16,  1.44e-16,  1.92e-16,  nan ],
	[    38,   0.08,   0.04,   0.08,   0.04,   0.10,   0.03,   0.78,   0.00,  1.87e-16,  1.40e-16,  1.40e-16,  nan ],
	[    39,   0.08,   0.04,   0.08,   0.04,   0.11,   0.03,   1.01,   0.00,  9.11e-17,  9.11e-17,  1.37e-16,  nan ],
	[    40,   0.08,   0.04,   0.09,   0.04,   0.11,   0.03,   0.46,   0.01,  1.33e-16,  1.78e-16,  1.78e-16,  nan ],
	[    41,   0.09,   0.04,   0.09,   0.04,   0.12,   0.03,   0.90,   0.00,  2.60e-16,  1.73e-16,  1.73e-16,  nan ],
	[    42,   0.10,   0.04,   0.09,   0.04,   0.13,   0.03,   1.17,   0.00,  1.69e-16,  1.27e-16,  1.27e-16,  nan ],
	[    43,   0.10,   0.04,   0.10,   0.04,   0.13,   0.03,   0.99,   0.00,  1.65e-16,  2.48e-16,  1.65e-16,  nan ],
	[    44,   0.11,   0.04,   0.10,   0.04,   0.14,   0.03,   1.38,   0.00,  1.61e-16,  1.61e-16,  2.42e-16,  nan ],
	[    45,   0.11,   0.04,   0.09,   0.05,   0.14,   0.03,   1.09,   0.00,  1.58e-16,  1.58e-16,  1.18e-16,  nan ],
	[    46,   0.12,   0.04,   0.11,   0.04,   0.15,   0.03,   1.40,   0.00,  1.54e-16,  1.54e-16,  1.54e-16,  nan ],
	[    47,   0.12,   0.04,   0.12,   0.04,   0.16,   0.03,   1.18,   0.00,  1.51e-16,  1.51e-16,  1.51e-16,  nan ],
	[    48,   0.13,   0.04,   0.12,   0.04,   0.16,   0.03,   1.52,   0.00,  1.48e-16,  1.48e-16,  1.48e-16,  nan ],
	[    49,   0.13,   0.04,   0.13,   0.04,   0.17,   0.03,   1.28,   0.00,  2.18e-16,  2.90e-16,  2.18e-16,  nan ],
	[    50,   0.13,   0.04,   0.13,   0.04,   0.17,   0.03,   1.34,   0.00,  2.13e-16,  2.13e-16,  2.13e-16,  nan ],
	[    51,   0.14,   0.04,   0.14,   0.04,   0.18,   0.03,   1.06,   0.01,  2.09e-16,  2.09e-16,  2.09e-16,  nan ],
	[    52,   0.15,   0.04,   0.13,   0.04,   0.18,   0.03,   1.36,   0.00,  2.73e-16,  2.05e-16,  2.05e-16,  nan ],
	[    53,   0.15,   0.04,   0.15,   0.04,   0.20,   0.03,   1.41,   0.00,  2.01e-16,  2.68e-16,  2.01e-16,  nan ],
	[    54,   0.16,   0.04,   0.15,   0.04,   0.20,   0.03,   1.19,   0.01,  1.97e-16,  2.63e-16,  1.97e-16,  nan ],
	[    55,   0.16,   0.04,   0.16,   0.04,   0.21,   0.03,   1.23,   0.01,  1.94e-16,  1.94e-16,  1.29e-16,  nan ],
	[    56,   0.17,   0.04,   0.18,   0.04,   0.22,   0.03,   1.58,   0.00,  2.54e-16,  2.54e-16,  2.54e-16,  nan ],
	[    57,   0.18,   0.04,   0.18,   0.04,   0.23,   0.03,   1.73,   0.00,  1.87e-16,  1.87e-16,  1.87e-16,  nan ],
	[    58,   0.19,   0.04,   0.18,   0.04,   0.24,   0.03,   1.37,   0.01,  2.45e-16,  1.84e-16,  1.84e-16,  nan ],
	[    59,   0.19,   0.04,   0.19,   0.04,   0.24,   0.03,   1.41,   0.01,  2.41e-16,  2.41e-16,  2.41e-16,  nan ],
	[    60,   0.20,   0.04,   0.19,   0.04,   0.25,   0.03,   1.46,   0.01,  2.96e-16,  2.96e-16,  2.96e-16,  nan ],
	[    61,   0.20,   0.04,   0.19,   0.04,   0.22,   0.03,   1.51,   0.01,  1.75e-16,  1.75e-16,  1.75e-16,  nan ],
	[    62,   0.21,   0.04,   0.20,   0.04,   0.27,   0.03,   1.56,   0.01,  2.29e-16,  1.72e-16,  1.72e-16,  nan ],
	[    63,   0.22,   0.04,   0.18,   0.04,   0.28,   0.03,   1.61,   0.01,  2.26e-16,  2.26e-16,  2.26e-16,  nan ],
	[    64,   0.23,   0.04,   0.22,   0.04,   0.29,   0.03,   1.66,   0.01,  2.78e-16,  2.22e-16,  2.22e-16,  nan ],
	[    65,   0.19,   0.04,   0.21,   0.04,   0.27,   0.03,   1.44,   0.01,  2.73e-16,  2.19e-16,  3.28e-16,  nan ],
	[    66,   0.19,   0.05,   0.22,   0.04,   0.28,   0.03,   1.48,   0.01,  2.15e-16,  1.61e-16,  2.15e-16,  nan ],
	[    67,   0.20,   0.04,   0.22,   0.04,   0.29,   0.03,   1.53,   0.01,  1.59e-16,  1.59e-16,  1.59e-16,  nan ],
	[    68,   0.21,   0.04,   0.24,   0.04,   0.29,   0.03,   1.87,   0.01,  2.09e-16,  2.09e-16,  1.57e-16,  nan ],
	[    69,   0.21,   0.05,   0.24,   0.04,   0.31,   0.03,   1.62,   0.01,  2.57e-16,  2.57e-16,  2.06e-16,  nan ],
	[    70,   0.23,   0.04,   0.23,   0.04,   0.32,   0.03,   1.67,   0.01,  3.55e-16,  2.54e-16,  2.54e-16,  nan ],
	[    71,   0.23,   0.05,   0.24,   0.04,   0.32,   0.03,   1.48,   0.01,  4.00e-16,  2.00e-16,  3.00e-16,  nan ],
	[    72,   0.23,   0.05,   0.26,   0.04,   0.33,   0.03,   1.76,   0.01,  1.97e-16,  1.97e-16,  1.97e-16,  nan ],
	[    73,   0.25,   0.04,   0.27,   0.04,   0.32,   0.03,   1.56,   0.01,  2.43e-16,  1.95e-16,  2.43e-16,  nan ],
	[    74,   0.24,   0.05,   0.28,   0.04,   0.35,   0.03,   1.86,   0.01,  2.88e-16,  2.40e-16,  1.92e-16,  nan ],
	[    75,   0.26,   0.04,   0.28,   0.04,   0.36,   0.03,   1.91,   0.01,  2.37e-16,  1.89e-16,  1.89e-16,  nan ],
	[    76,   0.26,   0.05,   0.29,   0.04,   0.37,   0.03,   1.96,   0.01,  1.87e-16,  2.34e-16,  2.34e-16,  nan ],
	[    77,   0.26,   0.05,   0.29,   0.04,   0.36,   0.03,   1.68,   0.01,  2.77e-16,  2.77e-16,  1.85e-16,  nan ],
	[    78,   0.29,   0.04,   0.31,   0.04,   0.39,   0.03,   2.07,   0.01,  2.28e-16,  2.28e-16,  2.28e-16,  nan ],
	[    79,   0.29,   0.04,   0.31,   0.04,   0.38,   0.03,   1.83,   0.01,  3.15e-16,  2.70e-16,  2.70e-16,  nan ],
	[    80,   0.30,   0.04,   0.33,   0.04,   0.43,   0.03,   1.81,   0.01,  3.55e-16,  3.11e-16,  2.66e-16,  nan ],
	[    81,   0.31,   0.04,   0.33,   0.04,   0.43,   0.03,   1.92,   0.01,  2.19e-16,  2.19e-16,  2.19e-16,  nan ],
	[    82,   0.31,   0.04,   0.34,   0.04,   0.43,   0.03,   1.97,   0.01,  2.17e-16,  1.73e-16,  2.17e-16,  nan ],
	[    83,   0.30,   0.05,   0.34,   0.04,   0.42,   0.03,   2.02,   0.01,  3.00e-16,  2.57e-16,  2.57e-16,  nan ],
	[    84,   0.32,   0.04,   0.35,   0.04,   0.43,   0.03,   1.81,   0.01,  3.38e-16,  2.54e-16,  2.54e-16,  nan ],
	[    85,   0.32,   0.05,   0.35,   0.04,   0.44,   0.03,   1.80,   0.01,  2.51e-16,  2.51e-16,  2.51e-16,  nan ],
	[    86,   0.32,   0.05,   0.36,   0.04,   0.44,   0.03,   2.09,   0.01,  2.48e-16,  2.48e-16,  2.48e-16,  nan ],
	[    87,   0.35,   0.04,   0.36,   0.04,   0.46,   0.03,   1.89,   0.01,  3.27e-16,  2.45e-16,  2.45e-16,  nan ],
	[    88,   0.35,   0.04,   0.38,   0.04,   0.47,   0.03,   1.93,   0.01,  3.23e-16,  2.42e-16,  2.42e-16,  nan ],
	[    89,   0.34,   0.05,   0.38,   0.04,   0.47,   0.03,   1.98,   0.01,  2.40e-16,  2.40e-16,  2.40e-16,  nan ],
	[    90,   0.36,   0.05,   0.40,   0.04,   0.50,   0.03,   1.81,   0.01,  2.37e-16,  2.37e-16,  2.37e-16,  nan ],
	[   100,   0.45,   0.05,   0.46,   0.04,   0.58,   0.04,   2.23,   0.01,  2.13e-16,  2.13e-16,  2.13e-16,  nan ],
	[   110,   0.54,   0.05,   0.54,   0.05,   0.72,   0.03,   2.18,   0.01,  2.58e-16,  2.58e-16,  3.23e-16,  nan ],
	[   120,   0.66,   0.04,   0.69,   0.04,   0.83,   0.04,   2.44,   0.01,  3.55e-16,  2.96e-16,  3.55e-16,  nan ],
	[   130,   0.66,   0.05,   0.76,   0.05,   0.95,   0.04,   2.65,   0.01,  3.83e-16,  3.83e-16,  3.28e-16,  nan ],
	[   140,   0.76,   0.05,   0.86,   0.05,   1.03,   0.04,   3.31,   0.01,  4.06e-16,  4.57e-16,  4.57e-16,  nan ],
	[   150,   0.87,   0.05,   0.94,   0.05,   1.19,   0.04,   2.84,   0.02,  3.32e-16,  2.84e-16,  3.32e-16,  nan ],
	[   160,   0.99,   0.05,   1.10,   0.05,   1.32,   0.04,   3.04,   0.02,  5.33e-16,  4.00e-16,  4.44e-16,  nan ],
	[   170,   1.07,   0.05,   1.18,   0.05,   1.45,   0.04,   1.77,   0.03,  3.34e-16,  3.34e-16,  3.34e-16,  nan ],
	[   180,   1.25,   0.05,   1.36,   0.05,   1.63,   0.04,   1.86,   0.04,  3.95e-16,  3.16e-16,  2.76e-16,  nan ],
	[   190,   1.30,   0.06,   1.37,   0.05,   1.81,   0.04,   2.25,   0.03,  2.99e-16,  3.74e-16,  3.74e-16,  nan ],
	[   200,   1.41,   0.06,   1.61,   0.05,   1.92,   0.04,   2.18,   0.04,  4.26e-16,  4.26e-16,  3.55e-16,  nan ],
	[   210,   1.47,   0.06,   1.67,   0.05,   2.10,   0.04,   2.40,   0.04,  4.06e-16,  3.38e-16,  4.06e-16,  nan ],
	[   220,   1.50,   0.06,   1.91,   0.05,   2.25,   0.04,   2.57,   0.04,  5.17e-16,  4.52e-16,  4.52e-16,  nan ],
	[   230,   1.74,   0.06,   1.80,   0.06,   2.42,   0.04,   2.42,   0.04,  4.94e-16,  6.18e-16,  6.18e-16,  nan ],
	[   240,   2.00,   0.06,   2.14,   0.05,   2.58,   0.04,   2.45,   0.05,  4.74e-16,  5.33e-16,  4.74e-16,  nan ],
	[   250,   2.16,   0.06,   2.24,   0.06,   2.91,   0.04,   2.56,   0.05,  4.55e-16,  4.55e-16,  3.98e-16,  nan ],
	[   260,   2.03,   0.07,   2.51,   0.05,   2.83,   0.05,   3.41,   0.04,  4.37e-16,  4.92e-16,  4.37e-16,  nan ],
	[   270,   2.18,   0.07,   2.40,   0.06,   3.12,   0.05,   3.49,   0.04,  4.74e-16,  4.74e-16,  5.79e-16,  nan ],
	[   280,   2.43,   0.06,   2.86,   0.06,   3.28,   0.05,   3.57,   0.04,  5.08e-16,  5.08e-16,  5.08e-16,  nan ],
	[   290,   2.59,   0.07,   2.72,   0.06,   3.50,   0.05,   3.85,   0.04,  5.88e-16,  5.88e-16,  5.39e-16,  nan ],
	[   300,   2.70,   0.07,   3.17,   0.06,   3.68,   0.05,   4.01,   0.05,  6.16e-16,  6.63e-16,  6.63e-16,  nan ],
	[   310,   2.79,   0.07,   3.16,   0.06,   3.78,   0.05,   4.37,   0.04,  4.58e-16,  4.58e-16,  5.04e-16,  nan ],
	[   320,   3.16,   0.07,   3.37,   0.06,   4.10,   0.05,   4.18,   0.05,  4.88e-16,  4.88e-16,  4.88e-16,  nan ],
	[   330,   3.12,   0.07,   3.31,   0.07,   4.28,   0.05,   4.13,   0.05,  4.31e-16,  4.31e-16,  5.17e-16,  nan ],
	[   340,   3.26,   0.07,   3.58,   0.06,   4.38,   0.05,   4.84,   0.05,  5.02e-16,  5.02e-16,  5.02e-16,  nan ],
	[   350,   3.32,   0.07,   3.67,   0.07,   4.62,   0.05,   5.23,   0.05,  6.50e-16,  5.68e-16,  4.87e-16,  nan ],
	[   360,   3.52,   0.07,   4.19,   0.06,   4.91,   0.05,   4.89,   0.05,  6.32e-16,  4.74e-16,  4.74e-16,  nan ],
	[   370,   3.81,   0.07,   4.17,   0.07,   4.98,   0.06,   4.66,   0.06,  5.38e-16,  5.38e-16,  4.61e-16,  nan ],
	[   380,   3.92,   0.07,   4.38,   0.07,   5.26,   0.06,   4.45,   0.07,  5.98e-16,  5.24e-16,  5.24e-16,  nan ],
	[   390,   4.02,   0.08,   4.06,   0.08,   5.54,   0.06,   5.87,   0.05,  5.10e-16,  5.10e-16,  5.10e-16,  nan ],
	[   400,   4.11,   0.08,   4.88,   0.07,   5.54,   0.06,   6.17,   0.05,  5.68e-16,  5.68e-16,  5.68e-16,  nan ],
	[   410,   4.16,   0.08,   4.96,   0.07,   5.79,   0.06,   5.18,   0.07,  6.93e-16,  7.63e-16,  6.93e-16,  nan ],
	[   420,   4.26,   0.08,   4.98,   0.07,   6.01,   0.06,   5.53,   0.06,  5.41e-16,  5.41e-16,  5.41e-16,  nan ],
	[   430,   4.57,   0.08,   5.22,   0.07,   6.19,   0.06,   6.50,   0.06,  7.93e-16,  7.93e-16,  8.59e-16,  nan ],
	[   440,   4.84,   0.08,   5.88,   0.07,   6.59,   0.06,   6.07,   0.06,  5.81e-16,  5.81e-16,  6.46e-16,  nan ],
	[   450,   4.56,   0.09,   5.42,   0.07,   6.55,   0.06,   5.49,   0.07,  6.32e-16,  6.32e-16,  6.32e-16,  nan ],
	[   460,   5.00,   0.08,   6.24,   0.07,   6.82,   0.06,   5.72,   0.07,  6.80e-16,  6.80e-16,  6.80e-16,  nan ],
	[   470,   5.09,   0.09,   5.84,   0.08,   7.14,   0.06,   6.93,   0.06,  6.05e-16,  6.05e-16,  5.44e-16,  nan ],
	[   480,   5.38,   0.09,   6.59,   0.07,   7.45,   0.06,   6.80,   0.07,  8.29e-16,  7.70e-16,  7.70e-16,  nan ],
	[   490,   5.40,   0.09,   6.02,   0.08,   7.50,   0.06,   5.94,   0.08,  9.28e-16,  8.70e-16,  9.28e-16,  nan ],
	[   500,   5.69,   0.09,   6.33,   0.08,   7.59,   0.07,   5.95,   0.08,  9.09e-16,  8.53e-16,  7.96e-16,  nan ],
	[   510,   5.80,   0.09,   6.51,   0.08,   7.89,   0.07,   6.53,   0.08,  6.69e-16,  7.24e-16,  6.69e-16,  nan ],
	[   520,   5.77,   0.09,   6.30,   0.09,   7.86,   0.07,   7.33,   0.07,  6.56e-16,  7.11e-16,  6.56e-16,  nan ],
	[   530,   5.86,   0.10,   6.78,   0.08,   8.17,   0.07,   6.71,   0.08,  9.12e-16,  8.58e-16,  9.65e-16,  nan ],
	[   540,   6.20,   0.09,   6.88,   0.08,   8.45,   0.07,   6.94,   0.08,  7.37e-16,  7.37e-16,  7.89e-16,  nan ],
	[   550,   6.25,   0.10,   6.19,   0.10,   8.53,   0.07,   7.87,   0.08,  7.23e-16,  7.75e-16,  8.27e-16,  nan ],
	[   560,   6.41,   0.10,   7.22,   0.09,   8.61,   0.07,   8.26,   0.08,  6.60e-16,  7.61e-16,  7.11e-16,  nan ],
	[   570,   6.52,   0.10,   7.30,   0.09,   8.92,   0.07,   7.22,   0.09,  7.48e-16,  7.48e-16,  7.48e-16,  nan ],
	[   580,   6.48,   0.10,   7.40,   0.09,   9.21,   0.07,   7.50,   0.09,  7.35e-16,  7.84e-16,  6.86e-16,  nan ],
	[   590,   6.46,   0.11,   7.84,   0.09,   9.32,   0.07,   8.31,   0.08,  6.74e-16,  6.26e-16,  6.26e-16,  nan ],
	[   600,   6.75,   0.11,   8.11,   0.09,   9.63,   0.07,   8.29,   0.09,  9.00e-16,  7.58e-16,  7.11e-16,  nan ],
	[   610,   6.90,   0.11,   8.27,   0.09,   9.09,   0.08,   7.37,   0.10,  7.45e-16,  7.92e-16,  7.92e-16,  nan ],
	[   620,   7.26,   0.11,   8.12,   0.09,  10.00,   0.08,   7.34,   0.10,  9.17e-16,  9.17e-16,  9.17e-16,  nan ],
	[   630,   7.43,   0.11,   8.64,   0.09,  10.17,   0.08,   7.86,   0.10,  6.77e-16,  7.22e-16,  7.22e-16,  nan ],
	[   640,   7.66,   0.11,   8.56,   0.10,  10.52,   0.08,   8.54,   0.10,  7.99e-16,  7.11e-16,  7.99e-16,  nan ],
	[   650,   7.29,   0.12,   8.55,   0.10,  10.32,   0.08,   7.70,   0.11,  7.00e-16,  7.87e-16,  7.00e-16,  nan ],
	[   660,   7.72,   0.11,   9.08,   0.10,  11.02,   0.08,   7.87,   0.11,  7.32e-16,  7.32e-16,  6.89e-16,  nan ],
	[   670,   7.89,   0.11,   9.18,   0.10,  11.53,   0.08,   9.09,   0.10,  8.48e-16,  8.91e-16,  9.33e-16,  nan ],
	[   680,   8.41,   0.11,   9.64,   0.10,  11.74,   0.08,   8.99,   0.10,  7.52e-16,  7.11e-16,  7.52e-16,  nan ],
	[   690,   8.35,   0.11,   9.92,   0.10,  11.76,   0.08,   8.30,   0.11,  8.24e-16,  7.41e-16,  7.41e-16,  nan ],
	[   700,   8.54,   0.11,   9.62,   0.10,  12.00,   0.08,   8.04,   0.12,  8.12e-16,  7.31e-16,  6.50e-16,  nan ],
	[   710,   8.42,   0.12,   8.40,   0.12,  11.86,   0.09,   9.35,   0.11,  9.61e-16,  9.61e-16,  8.81e-16,  nan ],
	[   720,   8.87,   0.12,  10.83,   0.10,  12.37,   0.08,   9.72,   0.11,  8.68e-16,  7.89e-16,  8.68e-16,  nan ],
	[   730,   8.88,   0.12,  10.58,   0.10,  12.40,   0.09,   8.27,   0.13,  7.79e-16,  7.01e-16,  7.79e-16,  nan ],
	[   740,   9.00,   0.12,  10.34,   0.11,  12.20,   0.09,   8.70,   0.13,  8.45e-16,  9.22e-16,  9.99e-16,  nan ],
	[   750,   9.30,   0.12,  10.84,   0.10,  12.53,   0.09,   9.47,   0.12,  9.09e-16,  8.34e-16,  8.34e-16,  nan ],
	[   760,   9.33,   0.12,  10.90,   0.11,  12.70,   0.09,   9.48,   0.12,  8.98e-16,  8.23e-16,  8.98e-16,  nan ],
	[   770,   9.12,   0.13,  11.42,   0.10,  12.94,   0.09,   8.19,   0.14,  8.12e-16,  8.86e-16,  8.86e-16,  nan ],
	[   780,   9.29,   0.13,  11.61,   0.10,  13.24,   0.09,   8.35,   0.15,  9.47e-16,  1.02e-15,  9.47e-16,  nan ],
	[   790,   9.55,   0.13,  11.57,   0.11,  13.44,   0.09,   8.93,   0.14,  8.63e-16,  9.35e-16,  8.63e-16,  nan ],
	[   800,   9.77,   0.13,  11.87,   0.11,  13.78,   0.09,   8.96,   0.14,  1.28e-15,  1.28e-15,  1.21e-15,  nan ],
	[   810,  10.19,   0.13,  11.53,   0.11,  13.99,   0.09,   8.60,   0.15,  1.05e-15,  1.12e-15,  1.05e-15,  nan ],
	[   820,  10.36,   0.13,  12.72,   0.11,  14.01,   0.10,   8.80,   0.15,  1.11e-15,  1.04e-15,  1.04e-15,  nan ],
	[   830,  10.44,   0.13,  12.08,   0.11,  14.36,   0.10,   9.50,   0.15,  9.59e-16,  8.90e-16,  1.03e-15,  nan ],
	[   840,  10.32,   0.14,  13.44,   0.11,  14.42,   0.10,   9.54,   0.15,  8.80e-16,  8.80e-16,  9.47e-16,  nan ],
	[   850,  10.57,   0.14,  12.26,   0.12,  14.59,   0.10,   8.72,   0.17,  9.36e-16,  9.36e-16,  9.36e-16,  nan ],
	[   860,  10.90,   0.14,  13.59,   0.11,  15.11,   0.10,   9.13,   0.16,  1.26e-15,  1.26e-15,  1.26e-15,  nan ],
	[   870,  11.00,   0.14,  11.49,   0.13,  15.13,   0.10,   9.70,   0.16,  1.18e-15,  1.31e-15,  1.18e-15,  nan ],
	[   880,  11.23,   0.14,  13.72,   0.11,  15.67,   0.10,   9.75,   0.16,  8.40e-16,  9.04e-16,  9.04e-16,  nan ],
	[   890,  11.67,   0.14,  14.15,   0.11,  15.69,   0.10,   9.28,   0.17,  9.58e-16,  1.02e-15,  1.15e-15,  nan ],
	[   900,  11.26,   0.14,  15.15,   0.11,  15.75,   0.10,   8.92,   0.18,  1.07e-15,  1.01e-15,  1.01e-15,  nan ],
	[  1000,  12.92,   0.15,  15.27,   0.13,  17.42,   0.11,  10.07,   0.20,  1.08e-15,  1.08e-15,  1.14e-15,  nan ],
	[  1100,  14.15,   0.17,  16.57,   0.15,  12.11,   0.20,  10.05,   0.24,  1.14e-15,  1.19e-15,  1.19e-15,  nan ],
	[  1200,  16.01,   0.18,  19.07,   0.15,  13.29,   0.22,  10.40,   0.28,  1.18e-15,  1.28e-15,  1.18e-15,  nan ],
	[  1300,  16.83,   0.20,  20.12,   0.17,  13.47,   0.25,  10.04,   0.34,  1.27e-15,  1.18e-15,  1.18e-15,  nan ],
	[  1400,  19.04,   0.21,  22.42,   0.17,  15.21,   0.26,  11.47,   0.34,  1.14e-15,  1.06e-15,  1.06e-15,  nan ],
	[  1500,  19.76,   0.23,  24.18,   0.19,  16.14,   0.28,  10.85,   0.42,  1.36e-15,  1.29e-15,  1.44e-15,  nan ],
	[  1600,  21.34,   0.24,  24.53,   0.21,  16.32,   0.31,  10.97,   0.47,  1.35e-15,  1.42e-15,  1.49e-15,  nan ],
	[  1700,  22.23,   0.26,  27.29,   0.21,  17.06,   0.34,  11.36,   0.51,  1.34e-15,  1.40e-15,  1.47e-15,  nan ],
	[  1800,  23.59,   0.27,  29.88,   0.22,  18.06,   0.36,  11.64,   0.56,  1.83e-15,  1.89e-15,  1.83e-15,  nan ],
	[  1900,  25.53,   0.28,  31.96,   0.23,  19.02,   0.38,  11.86,   0.61,  1.62e-15,  1.38e-15,  1.44e-15,  nan ],
	[  2000,  25.98,   0.31,  30.66,   0.26,  20.05,   0.40,  12.45,   0.64,  1.82e-15,  1.82e-15,  1.76e-15,  nan ],
	[  2100,  27.58,   0.32,  32.55,   0.27,  15.43,   0.57,  11.36,   0.78,  1.84e-15,  1.79e-15,  1.73e-15,  nan ],
	[  2200,  28.56,   0.34,  35.35,   0.27,  16.00,   0.61,  11.81,   0.82,  1.76e-15,  1.76e-15,  1.76e-15,  nan ],
	[  2300,  31.05,   0.34,  36.75,   0.29,  16.67,   0.63,  11.33,   0.93,  1.78e-15,  1.73e-15,  1.73e-15,  nan ],
	[  2400,  31.05,   0.37,  37.41,   0.31,  17.54,   0.66,  11.36,   1.01,  1.61e-15,  1.52e-15,  1.52e-15,  nan ],
	[  2500,  32.40,   0.39,  38.37,   0.33,  18.28,   0.68,  10.94,   1.14,  1.91e-15,  1.59e-15,  1.77e-15,  nan ],
	[  2600,  32.83,   0.41,  39.78,   0.34,  18.73,   0.72,  11.19,   1.21,  1.53e-15,  1.66e-15,  1.62e-15,  nan ],
	[  2700,  34.48,   0.42,  41.90,   0.35,  19.42,   0.75,  11.02,   1.32,  1.60e-15,  1.56e-15,  1.60e-15,  nan ],
	[  2800,  34.48,   0.45,  39.21,   0.40,  20.24,   0.78,  11.73,   1.34,  1.79e-15,  1.79e-15,  1.71e-15,  nan ],
	[  2900,  36.91,   0.46,  43.70,   0.39,  20.88,   0.81,  11.01,   1.53,  1.80e-15,  1.80e-15,  1.88e-15,  nan ],
	[  3000,  38.14,   0.47,  45.14,   0.40,  21.56,   0.84,  11.16,   1.61,  1.97e-15,  1.89e-15,  1.89e-15,  nan ],
	[  3100,  39.55,   0.49,  46.43,   0.41,  17.51,   1.10,  11.38,   1.69,  2.13e-15,  2.20e-15,  2.20e-15,  nan ],
	[  3200,  40.65,   0.50,  44.64,   0.46,  18.04,   1.14,  11.63,   1.76,  1.99e-15,  1.99e-15,  2.06e-15,  nan ],
	[  3300,  41.90,   0.52,  48.43,   0.45,  18.62,   1.17,  11.64,   1.87,  2.14e-15,  2.07e-15,  2.14e-15,  nan ],
	[  3400,  42.05,   0.55,  49.41,   0.47,  19.16,   1.21,  11.72,   1.97,  2.34e-15,  2.21e-15,  2.14e-15,  nan ],
	[  3500,  44.08,   0.56,  50.31,   0.49,  19.79,   1.24,  11.44,   2.14,  2.34e-15,  2.47e-15,  2.40e-15,  nan ],
	[  3600,  44.40,   0.58,  49.30,   0.53,  20.10,   1.29,  11.61,   2.23,  2.34e-15,  2.21e-15,  2.27e-15,  nan ],
	[  3700,  45.03,   0.61,  51.19,   0.54,  20.56,   1.33,  11.82,   2.32,  2.52e-15,  2.52e-15,  2.58e-15,  nan ],
	[  3800,  46.75,   0.62,  51.96,   0.56,  21.23,   1.36,  11.71,   2.47,  2.33e-15,  2.45e-15,  2.45e-15,  nan ],
	[  3900,  48.45,   0.63,  51.84,   0.59,  21.20,   1.44,  11.86,   2.57,  2.22e-15,  2.16e-15,  2.16e-15,  nan ],
	[  4000,  48.14,   0.66,  49.78,   0.64,  22.24,   1.44,  11.76,   2.72,  2.56e-15,  2.67e-15,  2.50e-15,  nan ],
	[  4100,  47.62,   0.71,  52.71,   0.64,  19.29,   1.74,  11.40,   2.95,  2.88e-15,  2.83e-15,  2.88e-15,  nan ],
	[  4200,  49.01,   0.72,  51.97,   0.68,  18.98,   1.86,  11.95,   2.95,  2.76e-15,  2.65e-15,  2.98e-15,  nan ],
	[  4300,  49.92,   0.74,  54.32,   0.68,  19.58,   1.89,  11.53,   3.21,  2.27e-15,  2.27e-15,  2.33e-15,  nan ],
	[  4400,  52.69,   0.74,  54.47,   0.71,  19.94,   1.94,  11.51,   3.36,  2.38e-15,  2.43e-15,  2.48e-15,  nan ],
	[  4500,  51.86,   0.78,  56.73,   0.71,  20.42,   1.98,  11.59,   3.50,  2.83e-15,  3.03e-15,  2.73e-15,  nan ],
	[  4600,  53.78,   0.79,  56.51,   0.75,  20.65,   2.05,  11.79,   3.59,  2.52e-15,  2.52e-15,  2.87e-15,  nan ],
	[  4700,  53.89,   0.82,  55.79,   0.79,  21.07,   2.10,  11.50,   3.84,  2.52e-15,  2.66e-15,  2.76e-15,  nan ],
	[  4800,  55.34,   0.83,  55.53,   0.83,  21.56,   2.14,  11.81,   3.90,  2.51e-15,  2.42e-15,  2.46e-15,  nan ],
	[  4900,  55.73,   0.86,  57.46,   0.84,  22.04,   2.18,  11.58,   4.15,  2.51e-15,  2.55e-15,  2.55e-15,  nan ],
	[  5000,  55.62,   0.90,  58.90,   0.85,  22.07,   2.27,  11.47,   4.36,  2.46e-15,  2.32e-15,  2.50e-15,  nan ],
	[  5100,  57.19,   0.91,  58.26,   0.89,  22.86,   2.28,  11.50,   4.52,  2.41e-15,  2.36e-15,  2.36e-15,  nan ],
	[  5200,  57.79,   0.94,  59.77,   0.91,  19.68,   2.75,  11.75,   4.60,  2.62e-15,  2.54e-15,  2.67e-15,  nan ],
	[  5300,  57.92,   0.97,  60.68,   0.93,  20.16,   2.79,  11.41,   4.92,  2.57e-15,  2.66e-15,  2.53e-15,  nan ],
	[  5400,  57.92,   1.01,  60.71,   0.96,  20.48,   2.85,  11.66,   5.00,  2.69e-15,  2.44e-15,  2.44e-15,  nan ],
	[  5500,  57.36,   1.06,  59.97,   1.01,  20.90,   2.89,  11.55,   5.24,  2.40e-15,  2.40e-15,  2.32e-15,  nan ],
	[  5600,  60.03,   1.04,  58.03,   1.08,  21.27,   2.95,  11.93,   5.26,  2.52e-15,  2.68e-15,  2.68e-15,  nan ],
	[  5700,  60.52,   1.07,  62.55,   1.04,  21.54,   3.02,  11.54,   5.63,  2.63e-15,  2.63e-15,  2.63e-15,  nan ],
	[  5800,  61.85,   1.09,  60.57,   1.11,  21.81,   3.08,  11.70,   5.75,  3.14e-15,  2.98e-15,  3.06e-15,  nan ],
	[  5900,  62.06,   1.12,  61.46,   1.13,  22.20,   3.14,  11.67,   5.96,  3.08e-15,  3.01e-15,  3.08e-15,  nan ],
	[  6000,  62.57,   1.15,  61.82,   1.16,  22.59,   3.19,  11.80,   6.10,  3.41e-15,  3.26e-15,  3.41e-15,  nan ],
	[  6100,  63.08,   1.18,  62.60,   1.19,  22.95,   3.24,  11.69,   6.37,  3.28e-15,  2.83e-15,  2.98e-15,  nan ],
	[  6200,  64.07,   1.20,  62.61,   1.23,  20.37,   3.77,  11.87,   6.48,  3.01e-15,  3.08e-15,  3.01e-15,  nan ],
	[  6300,  65.45,   1.21,  61.45,   1.29,  20.03,   3.96,  11.74,   6.76,  3.68e-15,  3.75e-15,  3.61e-15,  nan ],
	[  6400,  64.93,   1.26,  58.56,   1.40,  20.90,   3.92,  11.84,   6.92,  3.98e-15,  3.77e-15,  4.05e-15,  nan ],
	[  6500,  65.92,   1.28,  62.28,   1.36,  20.58,   4.11,  11.78,   7.17,  3.08e-15,  3.29e-15,  3.64e-15,  nan ],
	[  6600,  65.71,   1.33,  61.66,   1.41,  20.95,   4.16,  12.02,   7.25,  3.72e-15,  3.58e-15,  3.58e-15,  nan ],
	[  6700,  68.39,   1.31,  62.49,   1.44,  21.65,   4.15,  11.61,   7.74,  4.00e-15,  4.14e-15,  3.94e-15,  nan ],
	[  6800,  67.86,   1.36,  63.22,   1.46,  22.09,   4.19,  11.69,   7.92,  3.81e-15,  3.68e-15,  3.54e-15,  nan ],
	[  6900,  68.62,   1.39,  64.96,   1.47,  22.17,   4.30,  11.73,   8.12,  2.97e-15,  3.10e-15,  3.30e-15,  nan ],
	[  7000,  68.59,   1.43,  63.44,   1.54,  22.59,   4.34,  11.79,   8.31,  3.51e-15,  4.03e-15,  3.77e-15,  nan ],
	[  7100,  69.02,   1.46,  63.78,   1.58,  22.61,   4.46,  11.71,   8.61,  3.20e-15,  3.27e-15,  3.07e-15,  nan ],
	[  7200,  69.69,   1.49,  59.39,   1.75,  20.51,   5.06,  11.81,   8.78,  3.03e-15,  3.28e-15,  3.16e-15,  nan ],
	[  7300,  70.32,   1.52,  65.56,   1.63,  20.84,   5.12,  11.67,   9.14,  3.55e-15,  3.61e-15,  3.43e-15,  nan ],
	[  7400,  70.71,   1.55,  64.05,   1.71,  21.22,   5.16,  11.87,   9.23,  3.38e-15,  3.81e-15,  3.50e-15,  nan ],
	[  7500,  71.08,   1.58,  64.36,   1.75,  21.38,   5.26,  11.64,   9.67,  3.70e-15,  3.58e-15,  3.70e-15,  nan ],
	[  7600,  72.62,   1.59,  64.66,   1.79,  21.65,   5.34,  11.86,   9.74,  3.47e-15,  3.47e-15,  3.23e-15,  nan ],
	[  7700,  72.22,   1.64,  66.14,   1.79,  21.80,   5.44,  11.86,  10.00,  3.72e-15,  3.72e-15,  3.60e-15,  nan ],
	[  7800,  73.26,   1.66,  65.96,   1.85,  21.55,   5.65,  11.87,  10.25,  3.26e-15,  3.44e-15,  3.56e-15,  nan ],
	[  7900,  71.34,   1.75,  65.33,   1.91,  21.77,   5.73,  11.78,  10.60,  3.45e-15,  3.63e-15,  3.51e-15,  nan ],
	[  8000,  71.64,   1.79,  62.02,   2.06,  22.12,   5.79,  11.71,  10.93,  3.30e-15,  3.30e-15,  3.41e-15,  nan ],
	[  8100,  72.07,   1.82,  68.17,   1.92,  22.85,   5.74,  11.69,  11.23,  3.82e-15,  3.87e-15,  3.65e-15,  nan ],
	[  8200,  71.16,   1.89,  66.52,   2.02,  21.27,   6.32,  11.81,  11.38,  3.49e-15,  3.44e-15,  3.49e-15,  nan ],
	[  8300,  71.55,   1.93,  65.12,   2.12,  21.21,   6.50,  11.73,  11.74,  3.45e-15,  3.45e-15,  3.56e-15,  nan ],
	[  8400,  69.69,   2.03,  66.92,   2.11,  21.36,   6.61,  11.80,  11.96,  3.63e-15,  3.57e-15,  3.41e-15,  nan ],
	[  8500,  71.16,   2.03,  66.82,   2.16,  21.61,   6.69,  11.72,  12.33,  4.01e-15,  4.01e-15,  3.85e-15,  nan ],
	[  8600,  70.11,   2.11,  67.09,   2.21,  21.88,   6.76,  11.84,  12.49,  3.75e-15,  3.44e-15,  3.44e-15,  nan ],
	[  8700,  71.31,   2.12,  68.17,   2.22,  22.05,   6.87,  11.94,  12.68,  3.35e-15,  3.45e-15,  3.61e-15,  nan ],
	[  8800,  68.87,   2.25,  62.78,   2.47,  21.68,   7.14,  12.00,  12.91,  4.19e-15,  4.29e-15,  4.55e-15,  nan ],
	[  8900,  69.64,   2.27,  67.22,   2.36,  22.11,   7.16,  12.07,  13.12,  3.83e-15,  3.68e-15,  3.99e-15,  nan ],
	[  9000,  69.42,   2.33,  66.24,   2.45,  22.05,   7.35,  12.00,  13.50,  3.33e-15,  3.44e-15,  3.44e-15,  nan ],
	[ 10000,  69.35,   2.88,  68.43,   2.92,  22.20,   9.01,  11.94,  16.76,  3.87e-15,  3.68e-15,  3.73e-15,  nan ],
	[ 12000,  69.47,   4.15,  66.25,   4.35,  22.61,  12.74,  12.36,  23.30,  5.15e-15,  5.08e-15,  5.08e-15,  nan ],
	[ 14000,  73.44,   5.34,  72.60,   5.40,  22.62,  17.33,  12.92,  30.34,  5.07e-15,  5.26e-15,  4.87e-15,  nan ],
	[ 16000,  74.38,   6.88,  68.74,   7.45,  22.66,  22.60,  12.30,  41.64,  5.12e-15,  4.89e-15,  5.06e-15,  nan ],
	[ 18000,  72.12,   8.99,  72.46,   8.94,  21.82,  29.70,  12.93,  50.12,  6.11e-15,  6.27e-15,  6.67e-15,  nan ],
	[ 20000,  72.84,  10.98,  70.18,  11.40,  20.99,  38.12,  13.39,  59.77,  5.96e-15,  5.68e-15,  5.73e-15,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/log.txt
# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/readme.txt
# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/setup.txt
# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/sgeev.txt
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# numactl --interleave=all ../testing/testing_sgeev -RN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_sgeev -RN -N 123 -N 1234 --range 12000:20000:2000
sgeev_RN = array([
	[    10,   0.00,   0.00,  0.00e+00,  nan ],
	[    20,   0.00,   0.00,  0.00e+00,  nan ],
	[    30,   0.00,   0.00,  0.00e+00,  nan ],
	[    40,   0.00,   0.00,  4.65e-07,  nan ],
	[    50,   0.00,   0.00,  4.79e-07,  nan ],
	[    60,   0.00,   0.00,  5.09e-07,  nan ],
	[    70,   0.00,   0.00,  5.73e-07,  nan ],
	[    80,   0.00,   0.01,  6.43e-07,  nan ],
	[    90,   0.00,   0.01,  6.30e-07,  nan ],
	[   100,   0.00,   0.01,  7.35e-07,  nan ],
	[   200,   0.03,   0.03,  8.91e-07,  nan ],
	[   300,   0.06,   0.06,  1.04e-06,  nan ],
	[   400,   0.10,   0.11,  1.31e-06,  nan ],
	[   500,   0.13,   0.13,  1.29e-06,  nan ],
	[   600,   0.26,   0.27,  1.83e-06,  nan ],
	[   700,   0.32,   0.32,  1.84e-06,  nan ],
	[   800,   0.40,   0.39,  1.93e-06,  nan ],
	[   900,   0.52,   0.47,  2.52e-06,  nan ],
	[  1000,   0.57,   0.59,  2.42e-06,  nan ],
	[  2000,   1.56,   1.54,  2.71e-06,  nan ],
	[  3000,   4.64,   4.56,  5.33e-06,  nan ],
	[  4000,   8.19,   7.16,  6.73e-06,  nan ],
	[  5000,  12.99,  10.24,  6.61e-06,  nan ],
	[  6000,  22.86,  18.81,  1.55e-05,  nan ],
	[  7000,  33.20,  25.32,  1.74e-05,  nan ],
	[  8000,  44.92,  31.83,  1.70e-05,  nan ],
	[  9000,  54.73,  41.44,  1.68e-05,  nan ],
	[ 10000,  70.16,  49.82,  1.76e-05,  nan ],
	[ 12000, nan, 71.23, nan, nan ],
	[ 14000, nan, 92.16, nan, nan ],
	[ 16000, nan, 124.63, nan, nan ],
	[ 18000, nan, 161.39, nan, nan ],
	[ 20000, nan, 202.40, nan, nan ],
])

# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# numactl --interleave=all ../testing/testing_sgeev -RV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_sgeev -RV -N 123 -N 1234 --range 12000:20000:2000
sgeev_RV = array([
	[    10,    0.00,   0.00,  0.00e+00,  nan ],
	[    20,    0.00,   0.00,  0.00e+00,  nan ],
	[    30,    0.00,   0.00,  0.00e+00,  nan ],
	[    40,    0.00,   0.00,  4.65e-07,  nan ],
	[    50,    0.00,   0.01,  4.79e-07,  nan ],
	[    60,    0.00,   0.01,  5.09e-07,  nan ],
	[    70,    0.00,   0.01,  5.73e-07,  nan ],
	[    80,    0.00,   0.01,  6.84e-07,  nan ],
	[    90,    0.01,   0.01,  6.89e-07,  nan ],
	[   100,    0.01,   0.01,  6.77e-07,  nan ],
	[   200,    0.04,   0.05,  9.23e-07,  nan ],
	[   300,    0.08,   0.09,  1.11e-06,  nan ],
	[   400,    0.19,   0.13,  1.17e-06,  nan ],
	[   500,    0.19,   0.27,  1.35e-06,  nan ],
	[   600,    0.34,   0.31,  1.73e-06,  nan ],
	[   700,    0.62,   0.38,  1.87e-06,  nan ],
	[   800,    0.77,   0.68,  1.86e-06,  nan ],
	[   900,    0.99,   0.65,  2.23e-06,  nan ],
	[  1000,    1.18,   0.99,  2.42e-06,  nan ],
	[  2000,    3.65,   2.34,  2.66e-06,  nan ],
	[  3000,   10.98,   5.86,  6.73e-06,  nan ],
	[  4000,   23.34,   9.23,  6.02e-06,  nan ],
	[  5000,   40.30,  14.32,  6.85e-06,  nan ],
	[  6000,   57.92,  34.35,  1.38e-05,  nan ],
	[  7000,   85.35,  34.08,  1.69e-05,  nan ],
	[  8000,  109.09,  44.85,  1.73e-05,  nan ],
	[  9000,  147.61,  55.41,  1.88e-05,  nan ],
	[ 10000,  189.16,  68.84,  1.70e-05,  nan ],
	[ 12000, nan, 101.43, nan, nan ],
	[ 14000, nan, 148.04, nan, nan ],
	[ 16000, nan, 208.56, nan, nan ],
	[ 18000, nan, 251.16, nan, nan ],
	[ 20000, nan, 329.45, nan, nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/sgeqrf.txt
# numactl --interleave=all ../testing/testing_sgeqrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
sgeqrf = array([
	[    10,     10,    0.19,   0.00,     0.00,  0.00,  nan ],
	[    20,     20,    0.55,   0.00,     0.04,  0.00,  nan ],
	[    30,     30,    1.05,   0.00,     0.12,  0.00,  nan ],
	[    40,     40,    1.89,   0.00,     1.01,  0.00,  nan ],
	[    50,     50,    2.20,   0.00,     1.48,  0.00,  nan ],
	[    60,     60,    3.08,   0.00,     2.19,  0.00,  nan ],
	[    70,     70,    3.16,   0.00,     2.48,  0.00,  nan ],
	[    80,     80,    3.85,   0.00,     1.57,  0.00,  nan ],
	[    90,     90,    3.97,   0.00,     1.87,  0.00,  nan ],
	[   100,    100,    3.95,   0.00,     1.51,  0.00,  nan ],
	[   200,    200,   14.07,   0.00,     6.56,  0.00,  nan ],
	[   300,    300,   31.91,   0.00,    14.41,  0.00,  nan ],
	[   400,    400,   66.72,   0.00,    26.18,  0.00,  nan ],
	[   500,    500,   89.49,   0.00,    38.71,  0.00,  nan ],
	[   600,    600,   86.50,   0.00,    54.54,  0.01,  nan ],
	[   700,    700,  101.51,   0.00,    67.47,  0.01,  nan ],
	[   800,    800,  121.79,   0.01,    87.78,  0.01,  nan ],
	[   900,    900,  106.09,   0.01,   102.12,  0.01,  nan ],
	[  1000,   1000,  128.52,   0.01,   122.24,  0.01,  nan ],
	[  2000,   2000,  193.06,   0.06,   330.74,  0.03,  nan ],
	[  3000,   3000,  243.41,   0.15,   560.04,  0.06,  nan ],
	[  4000,   4000,  265.74,   0.32,   717.33,  0.12,  nan ],
	[  5000,   5000,  284.24,   0.59,   916.14,  0.18,  nan ],
	[  6000,   6000,  295.27,   0.98,  1025.16,  0.28,  nan ],
	[  7000,   7000,  319.50,   1.43,  1109.35,  0.41,  nan ],
	[  8000,   8000,  319.59,   2.14,  1346.25,  0.51,  nan ],
	[  9000,   9000,  310.83,   3.13,  1458.30,  0.67,  nan ],
	[ 10000,  10000,  348.94,   3.82,  1571.59,  0.85,  nan ],
	[ 12000,  12000,  403.33,   5.71,  1705.67,  1.35,  nan ],
	[ 14000,  14000,  489.37,   7.48,  1766.55,  2.07,  nan ],
	[ 16000,  16000,  520.48,  10.49,  1891.88,  2.89,  nan ],
	[ 18000,  18000,  529.23,  14.69,  1927.11,  4.04,  nan ],
	[ 20000,  20000,  532.25,  20.04,  2059.15,  5.18,  nan ],
])

# numactl --interleave=all ../testing/testing_sgeqrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.04,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.18,  0.00,  nan ],
	[    60,     60,  nan,  nan,     0.27,  0.00,  nan ],
	[    70,     70,  nan,  nan,     0.41,  0.00,  nan ],
	[    80,     80,  nan,  nan,     0.59,  0.00,  nan ],
	[    90,     90,  nan,  nan,     0.79,  0.00,  nan ],
	[   100,    100,  nan,  nan,     0.81,  0.00,  nan ],
	[   200,    200,  nan,  nan,     7.25,  0.00,  nan ],
	[   300,    300,  nan,  nan,    14.33,  0.00,  nan ],
	[   400,    400,  nan,  nan,    24.01,  0.00,  nan ],
	[   500,    500,  nan,  nan,    28.72,  0.01,  nan ],
	[   600,    600,  nan,  nan,    42.28,  0.01,  nan ],
	[   700,    700,  nan,  nan,    58.05,  0.01,  nan ],
	[   800,    800,  nan,  nan,    69.31,  0.01,  nan ],
	[   900,    900,  nan,  nan,    83.06,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,   103.35,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   285.61,  0.04,  nan ],
	[  3000,   3000,  nan,  nan,   485.46,  0.07,  nan ],
	[  4000,   4000,  nan,  nan,   658.79,  0.13,  nan ],
	[  5000,   5000,  nan,  nan,   845.89,  0.20,  nan ],
	[  6000,   6000,  nan,  nan,   969.34,  0.30,  nan ],
	[  7000,   7000,  nan,  nan,  1055.68,  0.43,  nan ],
	[  8000,   8000,  nan,  nan,  1133.29,  0.60,  nan ],
	[  9000,   9000,  nan,  nan,  1267.92,  0.77,  nan ],
	[ 10000,  10000,  nan,  nan,  1470.62,  0.91,  nan ],
	[ 12000,  12000,  nan,  nan,  1631.16,  1.41,  nan ],
	[ 14000,  14000,  nan,  nan,  1725.38,  2.12,  nan ],
	[ 16000,  16000,  nan,  nan,  1843.85,  2.96,  nan ],
	[ 18000,  18000,  nan,  nan,  1872.06,  4.15,  nan ],
	[ 20000,  20000,  nan,  nan,  1967.07,  5.42,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/sgesvd.txt
# numactl --interleave=all ../testing/testing_sgesvd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_sgesvd -UN -VN -N 123 -N 1234 --range 12000:20000:2000
sgesvd_UN = array([
	[ nan,      10,      10,   0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,   0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,   0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,   0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,   0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,   0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,   0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,   0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,   0.00,    0.00,  0.00e+00 ],
	[ nan,     100,     100,   0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     200,   0.00,    0.01,  1.39e-07 ],
	[ nan,     300,     300,   0.01,    0.03,  1.50e-07 ],
	[ nan,     400,     400,   0.02,    0.04,  1.83e-07 ],
	[ nan,     500,     500,   0.03,    0.07,  1.56e-07 ],
	[ nan,     600,     600,   0.04,    0.08,  2.27e-07 ],
	[ nan,     700,     700,   0.05,    0.10,  2.14e-07 ],
	[ nan,     800,     800,   0.06,    0.13,  2.09e-07 ],
	[ nan,     900,     900,   0.08,    0.17,  1.88e-07 ],
	[ nan,    1000,    1000,   0.11,    0.20,  2.01e-07 ],
	[ nan,    2000,    2000,   0.42,    0.75,  4.35e-07 ],
	[ nan,    3000,    3000,   1.11,    1.78,  3.33e-07 ],
	[ nan,    4000,    4000,   2.78,    3.35,  3.07e-07 ],
	[ nan,    5000,    5000,   6.14,    6.01,  3.31e-07 ],
	[ nan,    6000,    6000,  10.36,    9.51,  3.83e-07 ],
	[ nan,    7000,    7000,  16.49,   14.08,  2.99e-07 ],
	[ nan,    8000,    8000,  25.07,   19.88,  6.05e-07 ],
	[ nan,    9000,    9000,  43.09,   27.32,  4.00e-07 ],
	[ nan,   10000,   10000,  50.60,   36.13,  5.40e-07 ],
	[ nan,     300,     100,   0.00,    0.00,  0.00e+00 ],
	[ nan,     600,     200,   0.01,    0.01,  8.81e-08 ],
	[ nan,     900,     300,   0.01,    0.03,  1.41e-07 ],
	[ nan,    1200,     400,   0.02,    0.05,  1.25e-07 ],
	[ nan,    1500,     500,   0.03,    0.07,  1.28e-07 ],
	[ nan,    1800,     600,   0.05,    0.09,  1.34e-07 ],
	[ nan,    2100,     700,   0.06,    0.12,  1.45e-07 ],
	[ nan,    2400,     800,   0.08,    0.16,  1.66e-07 ],
	[ nan,    2700,     900,   0.11,    0.20,  1.25e-07 ],
	[ nan,    3000,    1000,   0.13,    0.25,  1.54e-07 ],
	[ nan,    6000,    2000,   0.56,    0.98,  2.25e-07 ],
	[ nan,    9000,    3000,   1.49,    2.40,  2.16e-07 ],
	[ nan,   12000,    4000,   3.49,    4.61,  5.07e-07 ],
	[ nan,   15000,    5000,   7.73,    8.25,  6.15e-07 ],
	[ nan,   18000,    6000,  13.22,   13.19,  4.18e-07 ],
	[ nan,   21000,    7000,  21.43,   19.70,  4.15e-07 ],
	[ nan,   24000,    8000,  32.54,   28.09,  3.89e-07 ],
	[ nan,   27000,    9000,  47.11,   38.47,  3.85e-07 ],
	[ nan,     100,     300,   0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     600,   0.02,    0.03,  1.32e-07 ],
	[ nan,     300,     900,   0.05,    0.06,  1.57e-07 ],
	[ nan,     400,    1200,   0.03,    0.06,  1.17e-07 ],
	[ nan,     500,    1500,   0.05,    0.08,  1.29e-07 ],
	[ nan,     600,    1800,   0.07,    0.11,  1.48e-07 ],
	[ nan,     700,    2100,   0.10,    0.15,  1.65e-07 ],
	[ nan,     800,    2400,   0.11,    0.19,  1.10e-07 ],
	[ nan,     900,    2700,   0.15,    0.24,  2.54e-07 ],
	[ nan,    1000,    3000,   0.18,    0.29,  2.98e-07 ],
	[ nan,    2000,    6000,   0.78,    1.14,  2.26e-07 ],
	[ nan,    3000,    9000,   2.13,    2.88,  3.59e-07 ],
	[ nan,    4000,   12000,   4.92,    5.64,  1.65e-07 ],
	[ nan,    5000,   15000,  10.07,   10.27,  3.37e-07 ],
	[ nan,    6000,   18000,  17.90,   16.52,  3.57e-07 ],
	[ nan,    7000,   21000,  29.22,   25.18,  2.40e-07 ],
	[ nan,    8000,   24000,  44.44,   35.63,  8.85e-07 ],
	[ nan,    9000,   27000,  64.44,   49.80,  4.88e-07 ],
	[ nan,   10000,     100,   0.01,    0.01,  0.00e+00 ],
	[ nan,   20000,     200,   0.03,    0.04,  1.46e-07 ],
	[ nan,   30000,     300,   0.09,    0.11,  5.42e-08 ],
	[ nan,   40000,     400,   0.18,    0.21,  1.35e-07 ],
	[ nan,   50000,     500,   0.29,    0.33,  1.06e-07 ],
	[ nan,   60000,     600,   0.54,    0.60,  1.14e-07 ],
	[ nan,   70000,     700,   0.76,    0.70,  1.27e-07 ],
	[ nan,   80000,     800,   1.02,    1.13,  1.39e-07 ],
	[ nan,   90000,     900,   1.52,    1.68,  1.43e-07 ],
	[ nan,  100000,    1000,   1.91,    2.00,  1.62e-07 ],
	[ nan,  200000,    2000,   9.31,    9.71,  1.53e-07 ],
	[ nan,     100,   10000,   0.01,    0.01,  0.00e+00 ],
	[ nan,     200,   20000,   0.04,    0.05,  5.61e-08 ],
	[ nan,     300,   30000,   0.11,    0.13,  1.90e-07 ],
	[ nan,     400,   40000,   0.21,    0.25,  1.54e-07 ],
	[ nan,     500,   50000,   0.38,    0.45,  1.59e-07 ],
	[ nan,     600,   60000,   0.59,    0.68,  9.55e-08 ],
	[ nan,     700,   70000,   0.92,    1.06,  1.15e-07 ],
	[ nan,     800,   80000,   1.30,    1.41,  1.16e-07 ],
	[ nan,     900,   90000,   1.37,    1.91,  1.34e-07 ],
	[ nan,    1000,  100000,   1.70,    2.00,  1.20e-07 ],
	[ nan,    2000,  200000,  10.67,   12.41,  1.32e-07 ],
	[ nan,   12000,   12000,    nan,   59.13,       nan ],
	[ nan,   14000,   14000,    nan,   90.98,       nan ],
	[ nan,   16000,   16000,    nan,  132.72,       nan ],
	[ nan,   18000,   18000,    nan,  186.77,       nan ],
	[ nan,   20000,   20000,    nan,  252.78,       nan ],
])

# numactl --interleave=all ../testing/testing_sgesvd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_sgesvd -US -VS -N 123 -N 1234 --range 12000:20000:2000
sgesvd_US = array([
	[ nan,      10,      10,    0.00,     0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,     0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,     0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,     0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,     0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.01,     0.01,  0.00e+00 ],
	[ nan,      70,      70,    0.01,     0.01,  0.00e+00 ],
	[ nan,      80,      80,    0.01,     0.01,  0.00e+00 ],
	[ nan,      90,      90,    0.01,     0.01,  0.00e+00 ],
	[ nan,     100,     100,    0.02,     0.02,  0.00e+00 ],
	[ nan,     200,     200,    0.07,     0.08,  4.26e-07 ],
	[ nan,     300,     300,    0.03,     0.05,  5.55e-07 ],
	[ nan,     400,     400,    0.06,     0.08,  5.70e-07 ],
	[ nan,     500,     500,    0.10,     0.14,  6.17e-07 ],
	[ nan,     600,     600,    0.14,     0.18,  6.34e-07 ],
	[ nan,     700,     700,    0.19,     0.24,  7.23e-07 ],
	[ nan,     800,     800,    0.24,     0.31,  6.47e-07 ],
	[ nan,     900,     900,    0.33,     0.41,  6.73e-07 ],
	[ nan,    1000,    1000,    0.40,     0.50,  7.57e-07 ],
	[ nan,    2000,    2000,    2.13,     2.49,  7.90e-07 ],
	[ nan,    3000,    3000,    6.45,     7.47,  8.74e-07 ],
	[ nan,    4000,    4000,   13.40,    14.00,  1.19e-06 ],
	[ nan,    5000,    5000,   24.85,    25.92,  1.18e-06 ],
	[ nan,    6000,    6000,   46.27,    45.70,  1.33e-06 ],
	[ nan,    7000,    7000,   68.91,    66.84,  1.20e-06 ],
	[ nan,    8000,    8000,  100.17,    94.51,  1.38e-06 ],
	[ nan,    9000,    9000,  144.22,   133.45,  1.48e-06 ],
	[ nan,   10000,   10000,  196.26,   185.84,  1.51e-06 ],
	[ nan,     300,     100,    0.03,     0.03,  3.39e-07 ],
	[ nan,     600,     200,    0.09,     0.10,  5.14e-07 ],
	[ nan,     900,     300,    0.05,     0.06,  6.26e-07 ],
	[ nan,    1200,     400,    0.09,     0.10,  6.72e-07 ],
	[ nan,    1500,     500,    0.14,     0.16,  7.55e-07 ],
	[ nan,    1800,     600,    0.19,     0.24,  8.33e-07 ],
	[ nan,    2100,     700,    0.31,     0.34,  7.59e-07 ],
	[ nan,    2400,     800,    0.36,     0.40,  8.05e-07 ],
	[ nan,    2700,     900,    0.47,     0.55,  8.06e-07 ],
	[ nan,    3000,    1000,    0.64,     0.73,  8.18e-07 ],
	[ nan,    6000,    2000,    2.92,     3.25,  1.02e-06 ],
	[ nan,    9000,    3000,    7.98,     8.76,  1.18e-06 ],
	[ nan,   12000,    4000,   17.06,    17.90,  1.21e-06 ],
	[ nan,   15000,    5000,   32.06,    31.83,  1.31e-06 ],
	[ nan,   18000,    6000,   58.21,    55.14,  1.46e-06 ],
	[ nan,   21000,    7000,   87.31,    83.26,  1.50e-06 ],
	[ nan,   24000,    8000,  122.31,   112.47,  2.18e-06 ],
	[ nan,   27000,    9000,  182.96,   166.99,  2.15e-06 ],
	[ nan,     100,     300,    0.03,     0.02,  4.08e-07 ],
	[ nan,     200,     600,    0.07,     0.08,  5.54e-07 ],
	[ nan,     300,     900,    0.06,     0.07,  6.26e-07 ],
	[ nan,     400,    1200,    0.10,     0.12,  6.54e-07 ],
	[ nan,     500,    1500,    0.16,     0.19,  7.33e-07 ],
	[ nan,     600,    1800,    0.23,     0.27,  7.28e-07 ],
	[ nan,     700,    2100,    0.35,     0.39,  7.75e-07 ],
	[ nan,     800,    2400,    0.44,     0.50,  7.89e-07 ],
	[ nan,     900,    2700,    0.55,     0.63,  8.65e-07 ],
	[ nan,    1000,    3000,    0.70,     0.78,  8.86e-07 ],
	[ nan,    2000,    6000,    3.55,     3.81,  1.10e-06 ],
	[ nan,    3000,    9000,    8.96,     9.76,  1.23e-06 ],
	[ nan,    4000,   12000,   19.39,    20.55,  1.25e-06 ],
	[ nan,    5000,   15000,   36.86,    37.47,  1.48e-06 ],
	[ nan,    6000,   18000,   62.41,    63.05,  1.26e-06 ],
	[ nan,    7000,   21000,  100.85,    98.62,  1.61e-06 ],
	[ nan,    8000,   24000,  152.90,   146.32,  2.04e-06 ],
	[ nan,    9000,   27000,  210.15,   204.52,  2.20e-06 ],
	[ nan,   10000,     100,    0.04,     0.04,  0.00e+00 ],
	[ nan,   20000,     200,    0.17,     0.19,  5.70e-07 ],
	[ nan,   30000,     300,    0.19,     0.29,  5.68e-07 ],
	[ nan,   40000,     400,    0.36,     0.58,  5.43e-07 ],
	[ nan,   50000,     500,    0.77,     1.04,  6.95e-07 ],
	[ nan,   60000,     600,    1.03,     1.60,  8.25e-07 ],
	[ nan,   70000,     700,    1.36,     2.17,  8.38e-07 ],
	[ nan,   80000,     800,    1.68,     3.11,  7.57e-07 ],
	[ nan,   90000,     900,    2.27,     4.33,  8.88e-07 ],
	[ nan,  100000,    1000,    3.61,     5.71,  8.58e-07 ],
	[ nan,  200000,    2000,   18.80,    38.52,  1.12e-06 ],
	[ nan,     100,   10000,    0.06,     0.07,  0.00e+00 ],
	[ nan,     200,   20000,    0.25,     0.36,  5.63e-07 ],
	[ nan,     300,   30000,    0.35,     0.56,  5.80e-07 ],
	[ nan,     400,   40000,    0.47,     0.89,  6.00e-07 ],
	[ nan,     500,   50000,    1.75,     2.50,  7.78e-07 ],
	[ nan,     600,   60000,    2.01,     3.36,  8.59e-07 ],
	[ nan,     700,   70000,    2.53,     4.63,  8.29e-07 ],
	[ nan,     800,   80000,    2.50,     5.84,  8.41e-07 ],
	[ nan,     900,   90000,    2.97,     7.43,  9.05e-07 ],
	[ nan,    1000,  100000,    6.02,    12.24,  8.84e-07 ],
	[ nan,    2000,  200000,   24.99,    80.66,  1.08e-06 ],
	[ nan,   12000,   12000,     nan,   318.30,       nan ],
	[ nan,   14000,   14000,     nan,   479.42,       nan ],
	[ nan,   16000,   16000,     nan,   646.10,       nan ],
	[ nan,   18000,   18000,     nan,   980.48,       nan ],
	[ nan,   20000,   20000,     nan,  1358.38,       nan ],
])

# numactl --interleave=all ../testing/testing_sgesdd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_sgesdd -UN -VN -N 123 -N 1234 --range 12000:20000:2000
sgesdd_UN = array([
	[ nan,      10,      10,    0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,    0.00,  0.00e+00 ],
	[ nan,     100,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     200,    0.00,    0.01,  1.39e-07 ],
	[ nan,     300,     300,    0.01,    0.03,  1.50e-07 ],
	[ nan,     400,     400,    0.02,    0.04,  1.83e-07 ],
	[ nan,     500,     500,    0.03,    0.06,  1.56e-07 ],
	[ nan,     600,     600,    0.04,    0.08,  2.27e-07 ],
	[ nan,     700,     700,    0.05,    0.11,  2.14e-07 ],
	[ nan,     800,     800,    0.07,    0.14,  2.09e-07 ],
	[ nan,     900,     900,    0.09,    0.17,  1.88e-07 ],
	[ nan,    1000,    1000,    0.11,    0.21,  2.01e-07 ],
	[ nan,    2000,    2000,    0.45,    0.77,  4.35e-07 ],
	[ nan,    3000,    3000,    1.18,    1.80,  3.33e-07 ],
	[ nan,    4000,    4000,    2.75,    3.37,  3.07e-07 ],
	[ nan,    5000,    5000,    6.23,    6.05,  3.31e-07 ],
	[ nan,    6000,    6000,   11.64,    9.56,  3.83e-07 ],
	[ nan,    7000,    7000,   16.64,   14.19,  2.99e-07 ],
	[ nan,    8000,    8000,   24.95,   19.98,  6.05e-07 ],
	[ nan,    9000,    9000,   38.28,   27.28,  4.00e-07 ],
	[ nan,   10000,   10000,   50.38,   36.32,  5.40e-07 ],
	[ nan,     300,     100,    0.00,    0.00,  0.00e+00 ],
	[ nan,     600,     200,    0.01,    0.01,  8.81e-08 ],
	[ nan,     900,     300,    0.01,    0.03,  1.41e-07 ],
	[ nan,    1200,     400,    0.02,    0.05,  1.25e-07 ],
	[ nan,    1500,     500,    0.04,    0.07,  1.28e-07 ],
	[ nan,    1800,     600,    0.05,    0.10,  1.34e-07 ],
	[ nan,    2100,     700,    0.07,    0.13,  1.45e-07 ],
	[ nan,    2400,     800,    0.08,    0.16,  1.66e-07 ],
	[ nan,    2700,     900,    0.11,    0.21,  1.25e-07 ],
	[ nan,    3000,    1000,    0.14,    0.25,  1.54e-07 ],
	[ nan,    6000,    2000,    0.58,    0.99,  2.25e-07 ],
	[ nan,    9000,    3000,    1.52,    2.43,  2.16e-07 ],
	[ nan,   12000,    4000,    3.53,    4.67,  5.07e-07 ],
	[ nan,   15000,    5000,    7.43,    8.32,  6.15e-07 ],
	[ nan,   18000,    6000,   13.26,   13.25,  4.18e-07 ],
	[ nan,   21000,    7000,   21.64,   19.86,  4.15e-07 ],
	[ nan,   24000,    8000,   32.59,   28.26,  3.89e-07 ],
	[ nan,   27000,    9000,   47.25,   38.72,  3.85e-07 ],
	[ nan,     100,     300,    0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     600,    0.01,    0.02,  1.32e-07 ],
	[ nan,     300,     900,    0.02,    0.04,  1.57e-07 ],
	[ nan,     400,    1200,    0.03,    0.06,  1.17e-07 ],
	[ nan,     500,    1500,    0.05,    0.08,  1.29e-07 ],
	[ nan,     600,    1800,    0.07,    0.11,  1.48e-07 ],
	[ nan,     700,    2100,    0.09,    0.15,  1.65e-07 ],
	[ nan,     800,    2400,    0.11,    0.18,  1.10e-07 ],
	[ nan,     900,    2700,    0.14,    0.23,  2.54e-07 ],
	[ nan,    1000,    3000,    0.17,    0.28,  2.98e-07 ],
	[ nan,    2000,    6000,    0.67,    1.07,  2.26e-07 ],
	[ nan,    3000,    9000,    1.77,    2.63,  3.59e-07 ],
	[ nan,    4000,   12000,    3.89,    4.99,  1.65e-07 ],
	[ nan,    5000,   15000,    8.19,    9.02,  3.37e-07 ],
	[ nan,    6000,   18000,   14.38,   14.33,  3.57e-07 ],
	[ nan,    7000,   21000,   78.58,   21.60,  1.05e-06 ],
	[ nan,    8000,   24000,  135.30,   35.80,  9.08e-07 ],
	[ nan,    9000,   27000,  165.19,   46.06,  1.23e-06 ],
	[ nan,   10000,     100,    0.01,    0.01,  0.00e+00 ],
	[ nan,   20000,     200,    0.03,    0.04,  1.46e-07 ],
	[ nan,   30000,     300,    0.07,    0.09,  5.42e-08 ],
	[ nan,   40000,     400,    0.18,    0.21,  1.35e-07 ],
	[ nan,   50000,     500,    0.29,    0.33,  1.06e-07 ],
	[ nan,   60000,     600,    0.43,    0.49,  1.14e-07 ],
	[ nan,   70000,     700,    0.61,    0.69,  1.27e-07 ],
	[ nan,   80000,     800,    0.83,    0.95,  1.39e-07 ],
	[ nan,   90000,     900,    1.18,    1.32,  1.43e-07 ],
	[ nan,  100000,    1000,    1.50,    1.67,  1.62e-07 ],
	[ nan,  200000,    2000,    8.50,    9.15,  1.53e-07 ],
	[ nan,     100,   10000,    0.01,    0.01,  0.00e+00 ],
	[ nan,     200,   20000,    0.04,    0.05,  5.61e-08 ],
	[ nan,     300,   30000,    0.11,    0.13,  1.90e-07 ],
	[ nan,     400,   40000,    0.21,    0.25,  1.54e-07 ],
	[ nan,     500,   50000,    0.38,    0.44,  1.59e-07 ],
	[ nan,     600,   60000,    0.58,    0.67,  9.55e-08 ],
	[ nan,     700,   70000,    0.91,    1.05,  1.15e-07 ],
	[ nan,     800,   80000,    1.08,    1.28,  1.16e-07 ],
	[ nan,     900,   90000,    1.35,    1.59,  1.34e-07 ],
	[ nan,    1000,  100000,    1.68,    1.98,  1.20e-07 ],
	[ nan,    2000,  200000,   10.47,   12.41,  1.32e-07 ],
	[ nan,   12000,   12000,     nan,   59.29,       nan ],
	[ nan,   14000,   14000,     nan,   91.16,       nan ],
	[ nan,   16000,   16000,     nan,  133.17,       nan ],
	[ nan,   18000,   18000,     nan,  187.37,       nan ],
	[ nan,   20000,   20000,     nan,  253.56,       nan ],
])

# numactl --interleave=all ../testing/testing_sgesdd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_sgesdd -US -VS -N 123 -N 1234 --range 12000:20000:2000
sgesdd_US = array([
	[ nan,      10,      10,   0.00,    0.00,  0.00e+00 ],
	[ nan,      20,      20,   0.00,    0.00,  0.00e+00 ],
	[ nan,      30,      30,   0.00,    0.00,  0.00e+00 ],
	[ nan,      40,      40,   0.00,    0.00,  0.00e+00 ],
	[ nan,      50,      50,   0.00,    0.00,  0.00e+00 ],
	[ nan,      60,      60,   0.00,    0.00,  0.00e+00 ],
	[ nan,      70,      70,   0.00,    0.00,  0.00e+00 ],
	[ nan,      80,      80,   0.00,    0.00,  0.00e+00 ],
	[ nan,      90,      90,   0.00,    0.00,  0.00e+00 ],
	[ nan,     100,     100,   0.00,    0.00,  0.00e+00 ],
	[ nan,     200,     200,   0.01,    0.02,  1.46e-07 ],
	[ nan,     300,     300,   0.02,    0.04,  1.08e-07 ],
	[ nan,     400,     400,   0.04,    0.06,  1.35e-07 ],
	[ nan,     500,     500,   0.06,    0.09,  9.40e-08 ],
	[ nan,     600,     600,   0.08,    0.13,  1.00e-07 ],
	[ nan,     700,     700,   0.12,    0.17,  1.30e-07 ],
	[ nan,     800,     800,   0.15,    0.22,  1.21e-07 ],
	[ nan,     900,     900,   0.20,    0.28,  1.94e-07 ],
	[ nan,    1000,    1000,   0.26,    0.35,  1.44e-07 ],
	[ nan,    2000,    2000,   1.04,    1.27,  9.19e-08 ],
	[ nan,    3000,    3000,   2.70,    3.02,  1.61e-07 ],
	[ nan,    4000,    4000,   5.74,    5.67,  2.67e-07 ],
	[ nan,    5000,    5000,  11.25,   10.54,  7.47e-08 ],
	[ nan,    6000,    6000,  19.51,   15.18,  1.18e-07 ],
	[ nan,    7000,    7000,    nan,     nan,  1.59e+00 ],  # error
	[ nan,    8000,    8000,  43.76,   30.83,  6.45e-07 ],
	[ nan,    9000,    9000,  52.07,   38.95,  2.73e-07 ],
	[ nan,   10000,   10000,  70.55,   51.56,  4.14e-07 ],
	[ nan,     300,     100,   0.00,    0.01,  0.00e+00 ],
	[ nan,     600,     200,   0.01,    0.02,  1.40e-07 ],
	[ nan,     900,     300,   0.03,    0.04,  9.64e-08 ],
	[ nan,    1200,     400,   0.04,    0.07,  1.30e-07 ],
	[ nan,    1500,     500,   0.08,    0.11,  1.01e-07 ],
	[ nan,    1800,     600,   0.11,    0.16,  8.87e-08 ],
	[ nan,    2100,     700,   0.16,    0.22,  9.82e-08 ],
	[ nan,    2400,     800,   0.20,    0.28,  9.38e-08 ],
	[ nan,    2700,     900,   0.23,    0.34,  8.02e-08 ],
	[ nan,    3000,    1000,   0.31,    0.41,  8.69e-08 ],
	[ nan,    6000,    2000,   1.42,    1.78,  1.47e-07 ],
	[ nan,    9000,    3000,   3.48,    4.20,  2.48e-07 ],
	[ nan,   12000,    4000,   7.58,    8.17,  5.86e-07 ],
	[ nan,   15000,    5000,  14.20,   14.30,  6.73e-07 ],
	[ nan,   18000,    6000,  24.70,   23.15,  1.08e-06 ],
	[ nan,   21000,    7000,    nan,     nan,  1.00e+00 ],  # error
	[ nan,   24000,    8000,  55.62,   55.49,  8.97e-07 ],
	[ nan,   27000,    9000,  78.75,   65.22,  8.92e-07 ],
	[ nan,     100,     300,   0.00,    0.01,  0.00e+00 ],
	[ nan,     200,     600,   0.02,    0.02,  1.50e-07 ],
	[ nan,     300,     900,   0.03,    0.05,  9.50e-08 ],
	[ nan,     400,    1200,   0.05,    0.08,  1.08e-07 ],
	[ nan,     500,    1500,   0.09,    0.12,  9.55e-08 ],
	[ nan,     600,    1800,   0.12,    0.17,  9.18e-08 ],
	[ nan,     700,    2100,   0.16,    0.22,  8.74e-08 ],
	[ nan,     800,    2400,   0.19,    0.27,  1.01e-07 ],
	[ nan,     900,    2700,   0.25,    0.34,  7.69e-08 ],
	[ nan,    1000,    3000,   0.33,    0.44,  8.01e-08 ],
	[ nan,    2000,    6000,   1.43,    1.77,  2.61e-07 ],
	[ nan,    3000,    9000,   3.70,    4.37,  5.87e-07 ],
	[ nan,    4000,   12000,   7.70,    8.43,  1.82e-07 ],
	[ nan,    5000,   15000,  14.87,   14.87,  6.99e-08 ],
	[ nan,    6000,   18000,  25.59,   24.14,  7.97e-07 ],
	[ nan,    7000,   21000,    nan,     nan,  9.99e-01 ],  # error
	[ nan,    8000,   24000,  58.16,   49.78,  5.88e-07 ],
	[ nan,    9000,   27000,  81.40,   68.84,  5.35e-07 ],
	[ nan,   10000,     100,   0.02,    0.02,  0.00e+00 ],
	[ nan,   20000,     200,   0.09,    0.10,  1.41e-07 ],
	[ nan,   30000,     300,   0.16,    0.18,  9.99e-08 ],
	[ nan,   40000,     400,   0.31,    0.35,  1.13e-07 ],
	[ nan,   50000,     500,   0.70,    0.75,  1.86e-07 ],
	[ nan,   60000,     600,   0.91,    0.98,  8.39e-08 ],
	[ nan,   70000,     700,   1.32,    1.66,  3.45e-07 ],
	[ nan,   80000,     800,   1.50,    1.63,  8.53e-08 ],
	[ nan,   90000,     900,   2.54,    2.18,  8.31e-08 ],
	[ nan,  100000,    1000,   3.32,    3.47,  2.17e-07 ],
	[ nan,  200000,    2000,  18.16,   17.91,  1.04e-06 ],
	[ nan,     100,   10000,   0.03,    0.04,  0.00e+00 ],
	[ nan,     200,   20000,   0.16,    0.18,  1.54e-07 ],
	[ nan,     300,   30000,   0.32,    0.37,  1.04e-07 ],
	[ nan,     400,   40000,   0.45,    0.54,  1.30e-07 ],
	[ nan,     500,   50000,   1.65,    1.83,  9.39e-08 ],
	[ nan,     600,   60000,   2.10,    2.29,  1.09e-07 ],
	[ nan,     700,   70000,   2.23,    2.52,  8.25e-08 ],
	[ nan,     800,   80000,   2.31,    2.67,  9.70e-08 ],
	[ nan,     900,   90000,   2.72,    3.39,  4.85e-07 ],
	[ nan,    1000,  100000,   5.74,    7.49,  5.27e-07 ],
	[ nan,    2000,  200000,  23.96,   27.54,  7.43e-08 ],
	[ nan,   12000,   12000,    nan,   81.94,       nan ],
	[ nan,   14000,   14000,    nan,    0.00,       nan ],
	[ nan,   16000,   16000,    nan,  170.74,       nan ],
	[ nan,   18000,   18000,    nan,  233.49,       nan ],
	[ nan,   20000,   20000,    nan,  310.28,       nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/sgetrf.txt
# numactl --interleave=all ../testing/testing_sgetrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
sgetrf = array([
	[    10,     10,    0.02,   0.00,     0.08,  0.00,  nan ],
	[    20,     20,    0.18,   0.00,     0.26,  0.00,  nan ],
	[    30,     30,    0.46,   0.00,     0.65,  0.00,  nan ],
	[    40,     40,    0.87,   0.00,     1.11,  0.00,  nan ],
	[    50,     50,    1.21,   0.00,     1.50,  0.00,  nan ],
	[    60,     60,    1.78,   0.00,     2.15,  0.00,  nan ],
	[    70,     70,    1.88,   0.00,     2.64,  0.00,  nan ],
	[    80,     80,    2.99,   0.00,     3.76,  0.00,  nan ],
	[    90,     90,    3.57,   0.00,     3.92,  0.00,  nan ],
	[   100,    100,    4.27,   0.00,     4.84,  0.00,  nan ],
	[   200,    200,   15.86,   0.00,    18.02,  0.00,  nan ],
	[   300,    300,   30.03,   0.00,    10.41,  0.00,  nan ],
	[   400,    400,   48.00,   0.00,    20.52,  0.00,  nan ],
	[   500,    500,   64.40,   0.00,    31.15,  0.00,  nan ],
	[   600,    600,   81.72,   0.00,    40.38,  0.00,  nan ],
	[   700,    700,   97.21,   0.00,    53.75,  0.00,  nan ],
	[   800,    800,  104.67,   0.00,    64.51,  0.01,  nan ],
	[   900,    900,  115.97,   0.00,    78.78,  0.01,  nan ],
	[  1000,   1000,  122.10,   0.01,    93.89,  0.01,  nan ],
	[  2000,   2000,  169.65,   0.03,   238.47,  0.02,  nan ],
	[  3000,   3000,  202.61,   0.09,   407.86,  0.04,  nan ],
	[  4000,   4000,  298.01,   0.14,   586.66,  0.07,  nan ],
	[  5000,   5000,  321.67,   0.26,   726.01,  0.11,  nan ],
	[  6000,   6000,  315.50,   0.46,   883.65,  0.16,  nan ],
	[  7000,   7000,  408.89,   0.56,  1026.42,  0.22,  nan ],
	[  8000,   8000,  397.10,   0.86,  1162.66,  0.29,  nan ],
	[  9000,   9000,  351.10,   1.38,  1268.01,  0.38,  nan ],
	[ 10000,  10000,  441.06,   1.51,  1360.18,  0.49,  nan ],
	[ 12000,  12000,  344.52,   3.34,  1502.10,  0.77,  nan ],
	[ 14000,  14000,  377.47,   4.85,  1600.32,  1.14,  nan ],
	[ 16000,  16000,  361.38,   7.56,  1684.20,  1.62,  nan ],
	[ 18000,  18000,  372.39,  10.44,  1762.74,  2.21,  nan ],
	[ 20000,  20000,  363.56,  14.67,  1916.62,  2.78,  nan ],
])

# numactl --interleave=all ../testing/testing_sgetrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
sgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,  0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,  0.00,  nan ],
	[    30,     30,  nan,  nan,     0.24,  0.00,  nan ],
	[    40,     40,  nan,  nan,     0.44,  0.00,  nan ],
	[    50,     50,  nan,  nan,     0.85,  0.00,  nan ],
	[    60,     60,  nan,  nan,     1.36,  0.00,  nan ],
	[    70,     70,  nan,  nan,     1.29,  0.00,  nan ],
	[    80,     80,  nan,  nan,     2.30,  0.00,  nan ],
	[    90,     90,  nan,  nan,     2.47,  0.00,  nan ],
	[   100,    100,  nan,  nan,     2.88,  0.00,  nan ],
	[   200,    200,  nan,  nan,     9.40,  0.00,  nan ],
	[   300,    300,  nan,  nan,     8.55,  0.00,  nan ],
	[   400,    400,  nan,  nan,    15.82,  0.00,  nan ],
	[   500,    500,  nan,  nan,    25.36,  0.00,  nan ],
	[   600,    600,  nan,  nan,    35.06,  0.00,  nan ],
	[   700,    700,  nan,  nan,    48.80,  0.00,  nan ],
	[   800,    800,  nan,  nan,    59.99,  0.01,  nan ],
	[   900,    900,  nan,  nan,    75.32,  0.01,  nan ],
	[  1000,   1000,  nan,  nan,    89.67,  0.01,  nan ],
	[  2000,   2000,  nan,  nan,   258.38,  0.02,  nan ],
	[  3000,   3000,  nan,  nan,   451.44,  0.04,  nan ],
	[  4000,   4000,  nan,  nan,   652.98,  0.07,  nan ],
	[  5000,   5000,  nan,  nan,   759.29,  0.11,  nan ],
	[  6000,   6000,  nan,  nan,   944.32,  0.15,  nan ],
	[  7000,   7000,  nan,  nan,   992.41,  0.23,  nan ],
	[  8000,   8000,  nan,  nan,  1290.98,  0.26,  nan ],
	[  9000,   9000,  nan,  nan,  1445.80,  0.34,  nan ],
	[ 10000,  10000,  nan,  nan,  1458.11,  0.46,  nan ],
	[ 12000,  12000,  nan,  nan,  1707.08,  0.67,  nan ],
	[ 14000,  14000,  nan,  nan,  1832.60,  1.00,  nan ],
	[ 16000,  16000,  nan,  nan,  1910.36,  1.43,  nan ],
	[ 18000,  18000,  nan,  nan,  1977.86,  1.97,  nan ],
	[ 20000,  20000,  nan,  nan,  2154.23,  2.48,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/spotrf.txt
# numactl --interleave=all ../testing/testing_spotrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
spotrf = array([
	[    10,    0.20,  0.00,     0.00,  0.00,  0.00e+00,  nan ],
	[    20,    0.71,  0.00,     0.01,  0.00,  0.00e+00,  nan ],
	[    30,    1.59,  0.00,     0.03,  0.00,  0.00e+00,  nan ],
	[    40,    2.44,  0.00,     0.08,  0.00,  0.00e+00,  nan ],
	[    50,    2.86,  0.00,     0.15,  0.00,  0.00e+00,  nan ],
	[    60,    3.22,  0.00,     0.25,  0.00,  0.00e+00,  nan ],
	[    70,    3.89,  0.00,     1.74,  0.00,  0.00e+00,  nan ],
	[    80,    4.37,  0.00,     2.20,  0.00,  0.00e+00,  nan ],
	[    90,    4.75,  0.00,     2.77,  0.00,  0.00e+00,  nan ],
	[   100,    5.05,  0.00,     3.32,  0.00,  0.00e+00,  nan ],
	[   200,   15.35,  0.00,     5.55,  0.00,  0.00e+00,  nan ],
	[   300,   31.85,  0.00,     6.33,  0.00,  3.12e-08,  nan ],
	[   400,   56.35,  0.00,    14.33,  0.00,  5.46e-08,  nan ],
	[   500,   76.95,  0.00,    24.27,  0.00,  4.59e-08,  nan ],
	[   600,  109.18,  0.00,    25.97,  0.00,  7.51e-08,  nan ],
	[   700,  117.64,  0.00,    38.64,  0.00,  6.32e-08,  nan ],
	[   800,  160.55,  0.00,    42.07,  0.00,  5.30e-08,  nan ],
	[   900,  176.02,  0.00,    56.08,  0.00,  5.35e-08,  nan ],
	[  1000,  205.07,  0.00,    74.07,  0.00,  4.56e-08,  nan ],
	[  2000,  324.26,  0.01,   289.28,  0.01,  6.27e-08,  nan ],
	[  3000,  406.10,  0.02,   542.31,  0.02,  8.58e-08,  nan ],
	[  4000,  438.41,  0.05,   823.49,  0.03,  7.66e-08,  nan ],
	[  5000,  438.68,  0.10,  1005.16,  0.04,  1.47e-07,  nan ],
	[  6000,  468.96,  0.15,  1215.56,  0.06,  1.10e-07,  nan ],
	[  7000,  239.90,  0.48,  1351.59,  0.08,  9.78e-08,  nan ],
	[  8000,  495.85,  0.34,  1497.78,  0.11,  8.76e-08,  nan ],
	[  9000,  494.29,  0.49,  1592.39,  0.15,  1.56e-07,  nan ],
	[ 10000,  497.62,  0.67,  1688.68,  0.20,  1.45e-07,  nan ],
	[ 12000,  498.60,  1.16,  1847.53,  0.31,  2.46e-07,  nan ],
	[ 14000,  523.04,  1.75,  1985.27,  0.46,  3.21e-07,  nan ],
	[ 16000,  555.08,  2.46,  2088.71,  0.65,  4.48e-07,  nan ],
	[ 18000,  525.76,  3.70,  2173.03,  0.89,  1.03e-06,  nan ],
	[ 20000,  493.82,  5.40,  2258.72,  1.18,  8.70e-07,  nan ],
])

# numactl --interleave=all ../testing/testing_spotrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
spotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.00,  0.00,  nan ],
	[    30,  nan,  nan,     0.01,  0.00,  nan ],
	[    40,  nan,  nan,     0.03,  0.00,  nan ],
	[    50,  nan,  nan,     0.05,  0.00,  nan ],
	[    60,  nan,  nan,     0.08,  0.00,  nan ],
	[    70,  nan,  nan,     0.13,  0.00,  nan ],
	[    80,  nan,  nan,     0.19,  0.00,  nan ],
	[    90,  nan,  nan,     0.27,  0.00,  nan ],
	[   100,  nan,  nan,     0.36,  0.00,  nan ],
	[   200,  nan,  nan,     8.87,  0.00,  nan ],
	[   300,  nan,  nan,     4.79,  0.00,  nan ],
	[   400,  nan,  nan,    10.53,  0.00,  nan ],
	[   500,  nan,  nan,    18.48,  0.00,  nan ],
	[   600,  nan,  nan,    22.56,  0.00,  nan ],
	[   700,  nan,  nan,    33.39,  0.00,  nan ],
	[   800,  nan,  nan,    39.44,  0.00,  nan ],
	[   900,  nan,  nan,    53.18,  0.00,  nan ],
	[  1000,  nan,  nan,    68.17,  0.00,  nan ],
	[  2000,  nan,  nan,   311.14,  0.01,  nan ],
	[  3000,  nan,  nan,   638.03,  0.01,  nan ],
	[  4000,  nan,  nan,   963.19,  0.02,  nan ],
	[  5000,  nan,  nan,  1141.43,  0.04,  nan ],
	[  6000,  nan,  nan,  1410.41,  0.05,  nan ],
	[  7000,  nan,  nan,  1565.92,  0.07,  nan ],
	[  8000,  nan,  nan,  1753.51,  0.10,  nan ],
	[  9000,  nan,  nan,  1858.86,  0.13,  nan ],
	[ 10000,  nan,  nan,  1957.12,  0.17,  nan ],
	[ 12000,  nan,  nan,  2105.38,  0.27,  nan ],
	[ 14000,  nan,  nan,  2236.74,  0.41,  nan ],
	[ 16000,  nan,  nan,  2335.23,  0.58,  nan ],
	[ 18000,  nan,  nan,  2402.33,  0.81,  nan ],
	[ 20000,  nan,  nan,  2472.75,  1.08,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/ssyevd.txt
# numactl --interleave=all ../testing/testing_ssyevd -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_ssyevd -JN -N 123 -N 1234 --range 12000:20000:2000
ssyevd_JN = array([
	[    10,   0.00,   0.00 ],
	[    20,   0.00,   0.00 ],
	[    30,   0.00,   0.00 ],
	[    40,   0.00,   0.00 ],
	[    50,   0.00,   0.00 ],
	[    60,   0.00,   0.00 ],
	[    70,   0.00,   0.00 ],
	[    80,   0.00,   0.00 ],
	[    90,   0.00,   0.00 ],
	[   100,   0.00,   0.00 ],
	[   200,   0.00,   0.00 ],
	[   300,   0.01,   0.01 ],
	[   400,   0.01,   0.01 ],
	[   500,   0.02,   0.02 ],
	[   600,   0.02,   0.02 ],
	[   700,   0.03,   0.03 ],
	[   800,   0.03,   0.03 ],
	[   900,   0.04,   0.04 ],
	[  1000,   0.05,   0.05 ],
	[  2000,   0.22,   0.22 ],
	[  3000,   0.54,   0.88 ],
	[  4000,   1.07,   1.53 ],
	[  5000,   2.00,   2.50 ],
	[  6000,   3.70,   3.72 ],
	[  7000,   5.93,   5.30 ],
	[  8000,   9.21,   7.18 ],
	[  9000,  13.46,   9.56 ],
	[ 10000,  19.20,  12.14 ],
	[ 12000,    nan,  19.38 ],
	[ 14000,    nan,  28.24 ],
	[ 16000,    nan,  39.84 ],
	[ 18000,    nan,  54.66 ],
	[ 20000,    nan,  71.74 ],
])

# numactl --interleave=all ../testing/testing_ssyevd -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_ssyevd -JV -N 123 -N 1234 --range 12000:20000:2000
ssyevd_JV = array([
	[    10,   0.00,   0.00 ],
	[    20,   0.00,   0.00 ],
	[    30,   0.00,   0.00 ],
	[    40,   0.00,   0.00 ],
	[    50,   0.00,   0.00 ],
	[    60,   0.00,   0.00 ],
	[    70,   0.00,   0.00 ],
	[    80,   0.00,   0.00 ],
	[    90,   0.00,   0.00 ],
	[   100,   0.00,   0.00 ],
	[   200,   0.00,   0.01 ],
	[   300,   0.01,   0.01 ],
	[   400,   0.01,   0.02 ],
	[   500,   0.02,   0.02 ],
	[   600,   0.03,   0.03 ],
	[   700,   0.04,   0.04 ],
	[   800,   0.05,   0.04 ],
	[   900,   0.06,   0.06 ],
	[  1000,   0.07,   0.06 ],
	[  2000,   0.31,   0.21 ],
	[  3000,   0.76,   0.89 ],
	[  4000,   1.79,   1.61 ],
	[  5000,   3.20,   2.53 ],
	[  6000,   4.84,   3.83 ],
	[  7000,   7.49,   5.47 ],
	[  8000,  11.24,   7.33 ],
	[  9000,  15.72,   9.63 ],
	[ 10000,  21.62,  12.44 ],
	[ 12000,    nan,  20.27 ],
	[ 14000,    nan,  29.65 ],
	[ 16000,    nan,  41.64 ],
	[ 18000,    nan,  57.79 ],
	[ 20000,    nan,  75.25 ],
])

# numactl --interleave=all ../testing/testing_ssyevd_gpu -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_ssyevd_gpu -JN -N 123 -N 1234 --range 12000:20000:2000
ssyevd_gpu_JN = array([
	[    10,  nan,   0.00 ],
	[    20,  nan,   0.00 ],
	[    30,  nan,   0.00 ],
	[    40,  nan,   0.00 ],
	[    50,  nan,   0.00 ],
	[    60,  nan,   0.00 ],
	[    70,  nan,   0.00 ],
	[    80,  nan,   0.00 ],
	[    90,  nan,   0.00 ],
	[   100,  nan,   0.00 ],
	[   200,  nan,   0.00 ],
	[   300,  nan,   0.01 ],
	[   400,  nan,   0.01 ],
	[   500,  nan,   0.02 ],
	[   600,  nan,   0.02 ],
	[   700,  nan,   0.03 ],
	[   800,  nan,   0.04 ],
	[   900,  nan,   0.05 ],
	[  1000,  nan,   0.06 ],
	[  2000,  nan,   0.24 ],
	[  3000,  nan,   0.88 ],
	[  4000,  nan,   1.52 ],
	[  5000,  nan,   2.49 ],
	[  6000,  nan,   3.72 ],
	[  7000,  nan,   5.28 ],
	[  8000,  nan,   7.17 ],
	[  9000,  nan,   9.55 ],
	[ 10000,  nan,  12.16 ],
	[ 12000,  nan,  19.11 ],
	[ 14000,  nan,  28.13 ],
	[ 16000,  nan,  39.57 ],
	[ 18000,  nan,  54.60 ],
	[ 20000,  nan,  70.85 ],
])

# numactl --interleave=all ../testing/testing_ssyevd_gpu -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_ssyevd_gpu -JV -N 123 -N 1234 --range 12000:20000:2000
ssyevd_gpu_JV = array([
	[    10,  nan,   0.00 ],
	[    20,  nan,   0.00 ],
	[    30,  nan,   0.00 ],
	[    40,  nan,   0.00 ],
	[    50,  nan,   0.00 ],
	[    60,  nan,   0.00 ],
	[    70,  nan,   0.00 ],
	[    80,  nan,   0.00 ],
	[    90,  nan,   0.00 ],
	[   100,  nan,   0.00 ],
	[   200,  nan,   0.01 ],
	[   300,  nan,   0.01 ],
	[   400,  nan,   0.02 ],
	[   500,  nan,   0.03 ],
	[   600,  nan,   0.03 ],
	[   700,  nan,   0.04 ],
	[   800,  nan,   0.05 ],
	[   900,  nan,   0.07 ],
	[  1000,  nan,   0.08 ],
	[  2000,  nan,   0.28 ],
	[  3000,  nan,   0.94 ],
	[  4000,  nan,   1.60 ],
	[  5000,  nan,   2.57 ],
	[  6000,  nan,   3.86 ],
	[  7000,  nan,   5.55 ],
	[  8000,  nan,   7.61 ],
	[  9000,  nan,  10.13 ],
	[ 10000,  nan,  13.08 ],
	[ 12000,  nan,  21.31 ],
	[ 14000,  nan,  31.31 ],
	[ 16000,  nan,  44.91 ],
	[ 18000,  nan,  62.66 ],
	[ 20000,  nan,  82.70 ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/ssyevd_2stage.txt
# numactl --interleave=all ../testing/testing_ssyevdx_2stage -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
ssyevdx_2stage_JN = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.00 ],
	[   300,    300,   0.01 ],
	[   400,    400,   0.03 ],
	[   500,    500,   0.04 ],
	[   600,    600,   0.05 ],
	[   700,    700,   0.06 ],
	[   800,    800,   0.08 ],
	[   900,    900,   0.09 ],
	[  1000,   1000,   0.10 ],
	[  2000,   2000,   0.28 ],
	[  3000,   3000,   0.53 ],
	[  4000,   4000,   0.81 ],
	[  5000,   5000,   1.16 ],
	[  6000,   6000,   1.57 ],
	[  7000,   7000,   2.11 ],
	[  8000,   8000,   2.66 ],
	[  9000,   9000,   3.45 ],
	[ 10000,  10000,   4.17 ],
	[ 12000,  12000,   6.02 ],
	[ 14000,  14000,   8.46 ],
	[ 16000,  16000,  11.33 ],
	[ 18000,  18000,  14.79 ],
	[ 20000,  20000,  18.87 ],
])

# numactl --interleave=all ../testing/testing_ssyevdx_2stage -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
ssyevdx_2stage_JV = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.01 ],
	[   300,    300,   0.02 ],
	[   400,    400,   0.04 ],
	[   500,    500,   0.05 ],
	[   600,    600,   0.06 ],
	[   700,    700,   0.09 ],
	[   800,    800,   0.10 ],
	[   900,    900,   0.12 ],
	[  1000,   1000,   0.14 ],
	[  2000,   2000,   0.37 ],
	[  3000,   3000,   0.73 ],
	[  4000,   4000,   1.30 ],
	[  5000,   5000,   1.87 ],
	[  6000,   6000,   2.78 ],
	[  7000,   7000,   3.83 ],
	[  8000,   8000,   5.25 ],
	[  9000,   9000,   6.86 ],
	[ 10000,  10000,   8.72 ],
	[ 12000,  12000,  13.96 ],
	[ 14000,  14000,  20.54 ],
	[ 16000,  16000,  29.47 ],
	[ 18000,  18000,  40.62 ],
	[ 20000,  20000,  54.40 ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/ssymv.txt
# numactl --interleave=all ../testing/testing_ssymv -L -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000 --lapack
ssymv_L = array([
	[    10,    0.01,  0.03,    0.01,  0.03,   0.01,   0.03,   0.12,   0.00,  4.77e-08,  4.77e-08,  4.77e-08,  nan ],
	[    11,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.14,   0.00,  4.33e-08,  8.67e-08,  4.33e-08,  nan ],
	[    12,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.15,   0.00,  3.97e-08,  1.99e-08,  3.97e-08,  nan ],
	[    13,    0.01,  0.03,    0.01,  0.03,   0.02,   0.02,   0.13,   0.00,  3.67e-08,  3.67e-08,  7.34e-08,  nan ],
	[    14,    0.01,  0.03,    0.02,  0.03,   0.02,   0.02,   0.22,   0.00,  6.81e-08,  3.41e-08,  6.81e-08,  nan ],
	[    15,    0.02,  0.03,    0.02,  0.03,   0.02,   0.02,   0.22,   0.00,  6.36e-08,  6.36e-08,  6.36e-08,  nan ],
	[    16,    0.02,  0.03,    0.02,  0.03,   0.02,   0.02,   0.29,   0.00,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    17,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.21,   0.00,  1.12e-07,  5.61e-08,  5.61e-08,  nan ],
	[    18,    0.02,  0.03,    0.03,  0.03,   0.03,   0.02,   0.24,   0.00,  5.30e-08,  5.30e-08,  5.30e-08,  nan ],
	[    19,    0.03,  0.03,    0.03,  0.03,   0.03,   0.02,   0.27,   0.00,  5.02e-08,  5.02e-08,  5.02e-08,  nan ],
	[    20,    0.03,  0.03,    0.03,  0.03,   0.04,   0.02,   0.29,   0.00,  7.15e-08,  4.77e-08,  7.15e-08,  nan ],
	[    21,    0.03,  0.03,    0.03,  0.03,   0.04,   0.02,   0.30,   0.00,  9.08e-08,  1.36e-07,  6.81e-08,  nan ],
	[    22,    0.03,  0.03,    0.04,  0.03,   0.04,   0.02,   0.35,   0.00,  4.33e-08,  8.67e-08,  4.33e-08,  nan ],
	[    23,    0.04,  0.03,    0.02,  0.06,   0.05,   0.02,   0.58,   0.00,  8.29e-08,  8.29e-08,  8.29e-08,  nan ],
	[    24,    0.04,  0.03,    0.04,  0.03,   0.05,   0.02,   0.56,   0.00,  7.95e-08,  7.95e-08,  7.95e-08,  nan ],
	[    25,    0.04,  0.03,    0.04,  0.03,   0.06,   0.02,   0.42,   0.00,  7.63e-08,  7.63e-08,  3.81e-08,  nan ],
	[    26,    0.04,  0.03,    0.05,  0.03,   0.06,   0.02,   0.49,   0.00,  7.34e-08,  7.34e-08,  3.67e-08,  nan ],
	[    27,    0.05,  0.03,    0.05,  0.03,   0.07,   0.02,   0.53,   0.00,  7.06e-08,  7.06e-08,  7.06e-08,  nan ],
	[    28,    0.05,  0.03,    0.05,  0.03,   0.07,   0.02,   0.52,   0.00,  3.41e-08,  6.81e-08,  6.81e-08,  nan ],
	[    29,    0.05,  0.03,    0.06,  0.03,   0.07,   0.03,   0.56,   0.00,  9.87e-08,  1.32e-07,  6.58e-08,  nan ],
	[    30,    0.06,  0.03,    0.06,  0.03,   0.07,   0.03,   0.60,   0.00,  6.36e-08,  6.36e-08,  6.36e-08,  nan ],
	[    31,    0.07,  0.03,    0.07,  0.03,   0.08,   0.02,   0.64,   0.00,  6.15e-08,  9.23e-08,  9.23e-08,  nan ],
	[    32,    0.07,  0.03,    0.07,  0.03,   0.09,   0.02,   0.68,   0.00,  5.96e-08,  5.96e-08,  5.96e-08,  nan ],
	[    33,    0.07,  0.03,    0.08,  0.03,   0.09,   0.03,   0.78,   0.00,  5.78e-08,  5.78e-08,  5.78e-08,  nan ],
	[    34,    0.07,  0.03,    0.08,  0.03,   0.09,   0.03,   0.77,   0.00,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    35,    0.08,  0.03,    0.08,  0.03,   0.10,   0.03,   0.81,   0.00,  5.45e-08,  5.45e-08,  8.17e-08,  nan ],
	[    36,    0.08,  0.03,    0.09,  0.03,   0.10,   0.03,   0.66,   0.00,  7.95e-08,  5.30e-08,  7.95e-08,  nan ],
	[    37,    0.09,  0.03,    0.09,  0.03,   0.11,   0.03,   0.91,   0.00,  7.73e-08,  5.15e-08,  7.73e-08,  nan ],
	[    38,    0.10,  0.03,    0.10,  0.03,   0.11,   0.03,   0.78,   0.00,  7.53e-08,  1.00e-07,  1.00e-07,  nan ],
	[    39,    0.10,  0.03,    0.10,  0.03,   0.12,   0.03,   0.77,   0.00,  4.89e-08,  4.89e-08,  4.89e-08,  nan ],
	[    40,    0.11,  0.03,    0.11,  0.03,   0.12,   0.03,   1.15,   0.00,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    41,    0.11,  0.03,    0.11,  0.03,   0.13,   0.03,   1.11,   0.00,  6.98e-08,  9.30e-08,  6.98e-08,  nan ],
	[    42,    0.12,  0.03,    0.12,  0.03,   0.13,   0.03,   1.17,   0.00,  6.81e-08,  4.54e-08,  6.81e-08,  nan ],
	[    43,    0.12,  0.03,    0.12,  0.03,   0.15,   0.03,   0.93,   0.00,  8.87e-08,  8.87e-08,  8.87e-08,  nan ],
	[    44,    0.13,  0.03,    0.14,  0.03,   0.16,   0.03,   1.28,   0.00,  1.08e-07,  1.08e-07,  6.50e-08,  nan ],
	[    45,    0.14,  0.03,    0.14,  0.03,   0.16,   0.03,   1.02,   0.00,  8.48e-08,  6.36e-08,  8.48e-08,  nan ],
	[    46,    0.14,  0.03,    0.15,  0.03,   0.18,   0.02,   1.07,   0.00,  8.29e-08,  8.29e-08,  8.29e-08,  nan ],
	[    47,    0.15,  0.03,    0.15,  0.03,   0.18,   0.03,   1.18,   0.00,  1.01e-07,  1.22e-07,  8.12e-08,  nan ],
	[    48,    0.16,  0.03,    0.16,  0.03,   0.19,   0.03,   1.16,   0.00,  7.95e-08,  7.95e-08,  7.95e-08,  nan ],
	[    49,    0.17,  0.03,    0.16,  0.03,   0.19,   0.03,   1.21,   0.00,  7.79e-08,  7.79e-08,  7.79e-08,  nan ],
	[    50,    0.18,  0.03,    0.16,  0.03,   0.20,   0.03,   1.26,   0.00,  1.14e-07,  7.63e-08,  7.63e-08,  nan ],
	[    51,    0.14,  0.04,    0.17,  0.03,   0.20,   0.03,   1.31,   0.00,  7.48e-08,  1.12e-07,  7.48e-08,  nan ],
	[    52,    0.17,  0.03,    0.18,  0.03,   0.20,   0.03,   1.10,   0.01,  1.10e-07,  1.10e-07,  1.47e-07,  nan ],
	[    53,    0.18,  0.03,    0.18,  0.03,   0.21,   0.03,   1.41,   0.00,  1.08e-07,  1.08e-07,  7.20e-08,  nan ],
	[    54,    0.18,  0.03,    0.19,  0.03,   0.22,   0.03,   1.19,   0.01,  7.06e-08,  1.06e-07,  7.06e-08,  nan ],
	[    55,    0.19,  0.03,    0.20,  0.03,   0.22,   0.03,   1.23,   0.01,  6.94e-08,  6.94e-08,  6.94e-08,  nan ],
	[    56,    0.20,  0.03,    0.21,  0.03,   0.23,   0.03,   1.58,   0.00,  6.81e-08,  6.81e-08,  6.81e-08,  nan ],
	[    57,    0.22,  0.03,    0.21,  0.03,   0.24,   0.03,   1.63,   0.00,  6.69e-08,  6.69e-08,  6.69e-08,  nan ],
	[    58,    0.21,  0.03,    0.22,  0.03,   0.24,   0.03,   1.69,   0.00,  6.58e-08,  6.58e-08,  6.58e-08,  nan ],
	[    59,    0.24,  0.03,    0.22,  0.03,   0.25,   0.03,   1.41,   0.01,  6.47e-08,  9.70e-08,  9.70e-08,  nan ],
	[    60,    0.22,  0.03,    0.23,  0.03,   0.26,   0.03,   1.46,   0.01,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    61,    0.25,  0.03,    0.24,  0.03,   0.25,   0.03,   1.51,   0.01,  9.38e-08,  9.38e-08,  1.25e-07,  nan ],
	[    62,    0.25,  0.03,    0.25,  0.03,   0.27,   0.03,   1.26,   0.01,  9.23e-08,  9.23e-08,  9.23e-08,  nan ],
	[    63,    0.24,  0.03,    0.25,  0.03,   0.27,   0.03,   1.35,   0.01,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    64,    0.26,  0.03,    0.26,  0.03,   0.28,   0.03,   1.66,   0.01,  8.94e-08,  8.94e-08,  8.94e-08,  nan ],
	[    65,    0.24,  0.04,    0.23,  0.04,   0.27,   0.03,   1.71,   0.01,  1.47e-07,  1.47e-07,  1.47e-07,  nan ],
	[    66,    0.24,  0.04,    0.22,  0.04,   0.29,   0.03,   2.18,   0.00,  1.44e-07,  1.73e-07,  1.44e-07,  nan ],
	[    67,    0.26,  0.04,    0.25,  0.04,   0.29,   0.03,   1.53,   0.01,  1.42e-07,  8.54e-08,  8.54e-08,  nan ],
	[    68,    0.26,  0.04,    0.25,  0.04,   0.31,   0.03,   1.57,   0.01,  1.12e-07,  8.41e-08,  1.40e-07,  nan ],
	[    69,    0.27,  0.04,    0.25,  0.04,   0.32,   0.03,   2.53,   0.00,  8.29e-08,  8.29e-08,  1.11e-07,  nan ],
	[    70,    0.28,  0.04,    0.27,  0.04,   0.32,   0.03,   1.60,   0.01,  1.09e-07,  8.17e-08,  8.17e-08,  nan ],
	[    71,    0.29,  0.04,    0.28,  0.04,   0.35,   0.03,   1.72,   0.01,  1.61e-07,  1.07e-07,  1.07e-07,  nan ],
	[    72,    0.31,  0.03,    0.29,  0.04,   0.34,   0.03,   2.10,   0.01,  1.06e-07,  1.06e-07,  1.06e-07,  nan ],
	[    73,    0.32,  0.03,    0.30,  0.04,   0.36,   0.03,   2.16,   0.01,  1.57e-07,  1.05e-07,  1.05e-07,  nan ],
	[    74,    0.33,  0.03,    0.31,  0.04,   0.37,   0.03,   2.22,   0.01,  7.73e-08,  5.15e-08,  7.73e-08,  nan ],
	[    75,    0.34,  0.03,    0.32,  0.04,   0.38,   0.03,   2.28,   0.01,  1.02e-07,  7.63e-08,  1.02e-07,  nan ],
	[    76,    0.34,  0.03,    0.33,  0.04,   0.40,   0.03,   2.34,   0.01,  1.00e-07,  1.00e-07,  7.53e-08,  nan ],
	[    77,    0.35,  0.03,    0.33,  0.04,   0.41,   0.03,   2.02,   0.01,  7.43e-08,  7.43e-08,  9.91e-08,  nan ],
	[    78,    0.36,  0.03,    0.35,  0.04,   0.41,   0.03,   1.78,   0.01,  9.78e-08,  9.78e-08,  9.78e-08,  nan ],
	[    79,    0.38,  0.03,    0.35,  0.04,   0.42,   0.03,   1.77,   0.01,  1.45e-07,  9.66e-08,  9.66e-08,  nan ],
	[    80,    0.38,  0.03,    0.36,  0.04,   0.43,   0.03,   2.59,   0.01,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    81,    0.38,  0.04,    0.36,  0.04,   0.43,   0.03,   2.23,   0.01,  9.42e-08,  9.42e-08,  1.41e-07,  nan ],
	[    82,    0.39,  0.04,    0.37,  0.04,   0.44,   0.03,   2.20,   0.01,  1.16e-07,  9.30e-08,  9.30e-08,  nan ],
	[    83,    0.34,  0.04,    0.37,  0.04,   0.46,   0.03,   2.34,   0.01,  9.19e-08,  9.19e-08,  6.89e-08,  nan ],
	[    84,    0.41,  0.04,    0.39,  0.04,   0.48,   0.03,   2.00,   0.01,  9.08e-08,  1.36e-07,  9.08e-08,  nan ],
	[    85,    0.42,  0.04,    0.40,  0.04,   0.49,   0.03,   2.45,   0.01,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    86,    0.42,  0.04,    0.40,  0.04,   0.50,   0.03,   2.09,   0.01,  1.33e-07,  8.87e-08,  8.87e-08,  nan ],
	[    87,    0.44,  0.04,    0.41,  0.04,   0.51,   0.03,   2.14,   0.01,  8.77e-08,  1.32e-07,  1.32e-07,  nan ],
	[    88,    0.44,  0.04,    0.41,  0.04,   0.51,   0.03,   3.13,   0.01,  1.30e-07,  1.30e-07,  1.30e-07,  nan ],
	[    89,    0.46,  0.04,    0.42,  0.04,   0.53,   0.03,   2.32,   0.01,  8.57e-08,  1.29e-07,  8.57e-08,  nan ],
	[    90,    0.45,  0.04,    0.44,  0.04,   0.53,   0.03,   2.75,   0.01,  8.48e-08,  8.48e-08,  8.48e-08,  nan ],
	[   100,    0.54,  0.04,    0.53,  0.04,   0.61,   0.03,   2.49,   0.01,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   110,    0.64,  0.04,    0.62,  0.04,   0.74,   0.03,   3.53,   0.01,  1.04e-07,  1.04e-07,  1.04e-07,  nan ],
	[   120,    0.81,  0.04,    0.77,  0.04,   0.88,   0.03,   3.58,   0.01,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   130,    0.83,  0.04,    0.87,  0.04,   0.95,   0.04,   3.76,   0.01,  1.76e-07,  1.76e-07,  1.47e-07,  nan ],
	[   140,    0.91,  0.04,    1.02,  0.04,   1.10,   0.04,   5.52,   0.01,  1.36e-07,  1.36e-07,  1.36e-07,  nan ],
	[   150,    1.06,  0.04,    1.14,  0.04,   1.26,   0.04,   4.52,   0.01,  2.03e-07,  1.53e-07,  1.27e-07,  nan ],
	[   160,    1.22,  0.04,    1.33,  0.04,   1.43,   0.04,   6.36,   0.01,  1.43e-07,  1.43e-07,  1.43e-07,  nan ],
	[   170,    1.45,  0.04,    1.49,  0.04,   1.61,   0.04,   5.81,   0.01,  1.80e-07,  1.35e-07,  1.80e-07,  nan ],
	[   180,    1.59,  0.04,    1.63,  0.04,   1.59,   0.04,   5.81,   0.01,  1.48e-07,  1.91e-07,  1.48e-07,  nan ],
	[   190,    1.82,  0.04,    1.86,  0.04,   1.96,   0.04,   4.91,   0.01,  2.01e-07,  1.61e-07,  1.61e-07,  nan ],
	[   200,    1.71,  0.05,    1.96,  0.04,   2.01,   0.04,   8.03,   0.01,  2.29e-07,  2.29e-07,  1.91e-07,  nan ],
	[   210,    1.97,  0.05,    2.16,  0.04,   2.21,   0.04,   7.29,   0.01,  1.82e-07,  1.45e-07,  1.45e-07,  nan ],
	[   220,    2.03,  0.05,    2.43,  0.04,   2.49,   0.04,   8.16,   0.01,  2.43e-07,  2.43e-07,  2.08e-07,  nan ],
	[   230,    2.36,  0.05,    2.53,  0.04,   2.53,   0.04,   6.65,   0.02,  2.65e-07,  2.32e-07,  2.32e-07,  nan ],
	[   240,    2.41,  0.05,    2.76,  0.04,   2.82,   0.04,   7.70,   0.02,  2.86e-07,  2.54e-07,  2.54e-07,  nan ],
	[   250,    2.62,  0.05,    2.99,  0.04,   2.99,   0.04,   8.36,   0.02,  1.53e-07,  1.53e-07,  1.83e-07,  nan ],
	[   260,    2.66,  0.05,    3.23,  0.04,   3.22,   0.04,   3.16,   0.04,  2.64e-07,  2.05e-07,  2.64e-07,  nan ],
	[   270,    2.98,  0.05,    3.41,  0.04,   3.41,   0.04,   3.65,   0.04,  2.54e-07,  2.83e-07,  2.83e-07,  nan ],
	[   280,    3.03,  0.05,    3.57,  0.04,   3.59,   0.04,   3.93,   0.04,  3.27e-07,  3.00e-07,  3.00e-07,  nan ],
	[   290,    3.37,  0.05,    3.83,  0.04,   3.69,   0.05,   3.67,   0.05,  3.16e-07,  2.63e-07,  3.16e-07,  nan ],
	[   300,    3.47,  0.05,    4.03,  0.04,   3.92,   0.05,   3.61,   0.05,  2.54e-07,  2.54e-07,  2.54e-07,  nan ],
	[   310,    3.71,  0.05,    4.28,  0.05,   4.19,   0.05,   3.63,   0.05,  2.46e-07,  2.46e-07,  2.21e-07,  nan ],
	[   320,    4.20,  0.05,    4.79,  0.04,   4.68,   0.04,   3.80,   0.05,  2.86e-07,  2.86e-07,  2.38e-07,  nan ],
	[   330,    3.90,  0.06,    4.85,  0.05,   4.56,   0.05,   4.20,   0.05,  2.54e-07,  2.31e-07,  2.31e-07,  nan ],
	[   340,    4.28,  0.05,    5.26,  0.04,   4.74,   0.05,   4.28,   0.05,  3.59e-07,  4.04e-07,  3.59e-07,  nan ],
	[   350,    4.31,  0.06,    5.34,  0.05,   5.00,   0.05,   3.96,   0.06,  2.18e-07,  2.18e-07,  2.18e-07,  nan ],
	[   360,    4.82,  0.05,    5.65,  0.05,   5.12,   0.05,   4.33,   0.06,  2.54e-07,  2.54e-07,  2.54e-07,  nan ],
	[   370,    4.90,  0.06,    6.26,  0.04,   5.48,   0.05,   4.74,   0.06,  2.89e-07,  2.47e-07,  2.89e-07,  nan ],
	[   380,    5.35,  0.05,    6.29,  0.05,   5.68,   0.05,   4.60,   0.06,  2.41e-07,  3.21e-07,  2.81e-07,  nan ],
	[   390,    5.08,  0.06,    6.49,  0.05,   5.98,   0.05,   5.54,   0.06,  3.13e-07,  2.35e-07,  2.35e-07,  nan ],
	[   400,    5.34,  0.06,    6.80,  0.05,   6.17,   0.05,   6.41,   0.05,  2.67e-07,  3.05e-07,  2.67e-07,  nan ],
	[   410,    5.61,  0.06,    7.48,  0.05,   6.61,   0.05,   5.35,   0.06,  2.98e-07,  2.61e-07,  2.61e-07,  nan ],
	[   420,    5.89,  0.06,    7.53,  0.05,   6.65,   0.05,   5.70,   0.06,  2.54e-07,  2.54e-07,  2.54e-07,  nan ],
	[   430,    6.17,  0.06,    7.58,  0.05,   6.76,   0.05,   5.38,   0.07,  3.19e-07,  3.55e-07,  3.19e-07,  nan ],
	[   440,    6.59,  0.06,    5.71,  0.07,   7.47,   0.05,   6.07,   0.06,  2.77e-07,  2.77e-07,  2.43e-07,  nan ],
	[   450,    6.26,  0.06,    8.15,  0.05,   7.28,   0.06,   5.64,   0.07,  2.71e-07,  2.71e-07,  2.71e-07,  nan ],
	[   460,    6.52,  0.07,    8.64,  0.05,   7.70,   0.06,   6.07,   0.07,  2.99e-07,  2.99e-07,  2.65e-07,  nan ],
	[   470,    7.14,  0.06,    9.19,  0.05,   8.22,   0.05,   5.84,   0.08,  3.57e-07,  3.57e-07,  3.57e-07,  nan ],
	[   480,    7.31,  0.06,    9.40,  0.05,   8.10,   0.06,   6.41,   0.07,  3.50e-07,  3.81e-07,  3.50e-07,  nan ],
	[   490,    7.42,  0.06,    9.61,  0.05,   8.17,   0.06,   6.33,   0.08,  3.74e-07,  3.43e-07,  3.43e-07,  nan ],
	[   500,    8.08,  0.06,   10.20,  0.05,   8.65,   0.06,   6.51,   0.08,  3.66e-07,  4.27e-07,  3.97e-07,  nan ],
	[   510,    7.89,  0.07,   10.41,  0.05,   8.71,   0.06,   6.51,   0.08,  3.29e-07,  3.59e-07,  3.59e-07,  nan ],
	[   520,    7.73,  0.07,   10.42,  0.05,   8.71,   0.06,   9.67,   0.06,  2.93e-07,  2.93e-07,  2.93e-07,  nan ],
	[   530,    7.92,  0.07,   11.03,  0.05,   9.08,   0.06,   9.88,   0.06,  3.17e-07,  3.17e-07,  3.17e-07,  nan ],
	[   540,    8.48,  0.07,   11.45,  0.05,   9.14,   0.06,  10.25,   0.06,  3.67e-07,  3.39e-07,  3.39e-07,  nan ],
	[   550,    8.92,  0.07,   11.66,  0.05,   9.45,   0.06,   9.05,   0.07,  3.61e-07,  3.61e-07,  3.61e-07,  nan ],
	[   560,    9.25,  0.07,   12.31,  0.05,   9.69,   0.06,  10.67,   0.06,  3.27e-07,  3.27e-07,  3.00e-07,  nan ],
	[   570,    9.45,  0.07,   12.52,  0.05,   9.72,   0.07,   9.04,   0.07,  3.75e-07,  3.48e-07,  3.75e-07,  nan ],
	[   580,    9.21,  0.07,   12.45,  0.05,   9.78,   0.07,   9.09,   0.07,  3.42e-07,  3.42e-07,  3.42e-07,  nan ],
	[   590,    9.29,  0.08,   13.18,  0.05,  10.09,   0.07,   8.19,   0.09,  4.14e-07,  3.88e-07,  3.62e-07,  nan ],
	[   600,    9.76,  0.07,   13.63,  0.05,  10.29,   0.07,   9.89,   0.07,  3.81e-07,  3.56e-07,  3.56e-07,  nan ],
	[   610,   10.05,  0.07,   13.77,  0.05,  10.35,   0.07,  10.22,   0.07,  3.25e-07,  3.50e-07,  3.25e-07,  nan ],
	[   620,   10.00,  0.08,   13.98,  0.06,  10.69,   0.07,  10.69,   0.07,  3.94e-07,  3.69e-07,  3.94e-07,  nan ],
	[   630,   10.59,  0.08,   14.19,  0.06,  11.04,   0.07,   8.92,   0.09,  3.63e-07,  2.91e-07,  3.15e-07,  nan ],
	[   640,   10.40,  0.08,   15.50,  0.05,  11.07,   0.07,  11.10,   0.07,  4.29e-07,  4.05e-07,  4.05e-07,  nan ],
	[   650,   10.32,  0.08,   15.10,  0.06,  11.45,   0.07,  10.82,   0.08,  3.52e-07,  3.52e-07,  3.05e-07,  nan ],
	[   660,   10.64,  0.08,   15.64,  0.06,  11.65,   0.07,  11.19,   0.08,  3.93e-07,  3.93e-07,  3.70e-07,  nan ],
	[   670,   11.36,  0.08,   16.05,  0.06,  11.82,   0.08,  11.68,   0.08,  4.10e-07,  3.42e-07,  3.64e-07,  nan ],
	[   680,   11.60,  0.08,   16.25,  0.06,  12.03,   0.08,  11.74,   0.08,  4.04e-07,  4.04e-07,  3.59e-07,  nan ],
	[   690,   11.80,  0.08,   16.46,  0.06,  12.38,   0.08,  11.76,   0.08,  5.31e-07,  5.31e-07,  4.87e-07,  nan ],
	[   700,   12.25,  0.08,   16.94,  0.06,  12.40,   0.08,  11.69,   0.08,  3.71e-07,  3.49e-07,  3.27e-07,  nan ],
	[   710,   12.17,  0.08,   17.36,  0.06,  12.60,   0.08,  10.97,   0.09,  3.44e-07,  3.44e-07,  3.44e-07,  nan ],
	[   720,   12.51,  0.08,   18.22,  0.06,  12.96,   0.08,  12.51,   0.08,  4.24e-07,  4.24e-07,  4.66e-07,  nan ],
	[   730,   12.86,  0.08,   18.42,  0.06,  13.20,   0.08,  11.22,   0.10,  5.02e-07,  4.60e-07,  4.60e-07,  nan ],
	[   740,   12.33,  0.09,   18.62,  0.06,  13.22,   0.08,  10.98,   0.10,  4.12e-07,  4.12e-07,  4.12e-07,  nan ],
	[   750,   13.09,  0.09,   19.13,  0.06,  13.58,   0.08,  10.62,   0.11,  3.66e-07,  3.66e-07,  3.66e-07,  nan ],
	[   760,   13.48,  0.09,   19.97,  0.06,  14.10,   0.08,  12.04,   0.10,  4.02e-07,  4.02e-07,  4.02e-07,  nan ],
	[   770,   13.04,  0.09,   19.53,  0.06,  13.95,   0.09,  12.61,   0.09,  6.74e-07,  6.34e-07,  5.94e-07,  nan ],
	[   780,   13.66,  0.09,   20.28,  0.06,  14.31,   0.09,  12.94,   0.09,  4.30e-07,  3.91e-07,  3.91e-07,  nan ],
	[   790,   13.72,  0.09,   20.80,  0.06,  14.68,   0.09,  13.01,   0.10,  4.25e-07,  4.25e-07,  3.86e-07,  nan ],
	[   800,   14.57,  0.09,   21.42,  0.06,  15.10,   0.08,  13.08,   0.10,  4.58e-07,  4.20e-07,  4.58e-07,  nan ],
	[   810,   14.77,  0.09,   21.53,  0.06,  15.26,   0.09,  13.28,   0.10,  4.90e-07,  3.77e-07,  3.77e-07,  nan ],
	[   820,   14.48,  0.09,   22.06,  0.06,  15.30,   0.09,  13.45,   0.10,  3.72e-07,  3.72e-07,  3.72e-07,  nan ],
	[   830,   14.99,  0.09,   21.92,  0.06,  15.68,   0.09,  12.44,   0.11,  4.04e-07,  4.41e-07,  4.04e-07,  nan ],
	[   840,   14.42,  0.10,   22.79,  0.06,  15.89,   0.09,  13.85,   0.10,  4.00e-07,  4.00e-07,  4.00e-07,  nan ],
	[   850,   14.48,  0.10,   22.98,  0.06,  16.10,   0.09,  12.91,   0.11,  5.39e-07,  5.03e-07,  5.03e-07,  nan ],
	[   860,   14.79,  0.10,   23.53,  0.06,  16.26,   0.09,  13.44,   0.11,  5.32e-07,  5.32e-07,  5.32e-07,  nan ],
	[   870,   15.47,  0.10,   23.63,  0.06,  16.47,   0.09,  13.41,   0.11,  3.86e-07,  4.21e-07,  3.86e-07,  nan ],
	[   880,   15.52,  0.10,   24.27,  0.06,  16.85,   0.09,  14.11,   0.11,  4.51e-07,  4.16e-07,  4.16e-07,  nan ],
	[   890,   15.69,  0.10,   24.37,  0.07,  17.23,   0.09,  14.15,   0.11,  4.80e-07,  4.80e-07,  4.80e-07,  nan ],
	[   900,   15.18,  0.11,   24.56,  0.07,  17.09,   0.09,  13.63,   0.12,  3.73e-07,  4.41e-07,  4.07e-07,  nan ],
	[  1000,   17.42,  0.11,   28.18,  0.07,  19.26,   0.10,  15.05,   0.13,  6.71e-07,  6.41e-07,  6.10e-07,  nan ],
	[  1100,   18.64,  0.13,   31.85,  0.08,  20.73,   0.12,  15.95,   0.15,  5.55e-07,  5.83e-07,  5.83e-07,  nan ],
	[  1200,   21.32,  0.14,   35.56,  0.08,  23.43,   0.12,  16.27,   0.18,  6.61e-07,  6.36e-07,  5.85e-07,  nan ],
	[  1300,   22.52,  0.15,   39.74,  0.09,  25.61,   0.13,  15.16,   0.22,  5.87e-07,  5.63e-07,  5.40e-07,  nan ],
	[  1400,   24.82,  0.16,   44.11,  0.09,  28.03,   0.14,  17.36,   0.23,  5.67e-07,  5.67e-07,  5.23e-07,  nan ],
	[  1500,   26.64,  0.17,   48.43,  0.09,  28.53,   0.16,  17.80,   0.25,  6.51e-07,  5.70e-07,  5.70e-07,  nan ],
	[  1600,   29.28,  0.17,   52.80,  0.10,  31.23,   0.16,  16.80,   0.30,  6.10e-07,  6.10e-07,  6.10e-07,  nan ],
	[  1700,   30.94,  0.19,   55.51,  0.10,  33.41,   0.17,  17.01,   0.34,  6.46e-07,  6.10e-07,  5.74e-07,  nan ],
	[  1800,   32.88,  0.20,   60.03,  0.11,  35.83,   0.18,  17.72,   0.37,  8.14e-07,  8.48e-07,  8.14e-07,  nan ],
	[  1900,   34.59,  0.21,   63.39,  0.11,  37.64,   0.19,  17.49,   0.41,  7.39e-07,  7.39e-07,  7.39e-07,  nan ],
	[  2000,   35.91,  0.22,   62.99,  0.13,  36.57,   0.22,  18.03,   0.44,  7.32e-07,  8.54e-07,  8.85e-07,  nan ],
	[  2100,   38.71,  0.23,   64.37,  0.14,  24.24,   0.36,  18.34,   0.48,  8.43e-07,  7.85e-07,  7.85e-07,  nan ],
	[  2200,   39.55,  0.24,   68.15,  0.14,  25.21,   0.38,  17.68,   0.55,  7.21e-07,  7.77e-07,  8.05e-07,  nan ],
	[  2300,   42.16,  0.25,   71.49,  0.15,  25.69,   0.41,  19.45,   0.54,  8.49e-07,  7.70e-07,  7.70e-07,  nan ],
	[  2400,   43.82,  0.26,   76.85,  0.15,  27.05,   0.43,  19.53,   0.59,  6.36e-07,  6.87e-07,  7.12e-07,  nan ],
	[  2500,   44.64,  0.28,   79.11,  0.16,  28.09,   0.45,  20.40,   0.61,  9.03e-07,  8.06e-07,  8.06e-07,  nan ],
	[  2600,   47.16,  0.29,   79.56,  0.17,  28.78,   0.47,  20.10,   0.67,  8.92e-07,  8.45e-07,  8.92e-07,  nan ],
	[  2700,   49.10,  0.30,   86.77,  0.17,  30.20,   0.48,  20.65,   0.71,  7.69e-07,  7.01e-07,  6.78e-07,  nan ],
	[  2800,   50.96,  0.31,   86.11,  0.18,  30.95,   0.51,  20.56,   0.76,  9.37e-07,  9.37e-07,  8.94e-07,  nan ],
	[  2900,   52.28,  0.32,   92.01,  0.18,  32.55,   0.52,  20.59,   0.82,  1.05e-06,  1.05e-06,  1.14e-06,  nan ],
	[  3000,   52.34,  0.34,   94.29,  0.19,  33.28,   0.54,  20.14,   0.89,  9.36e-07,  8.95e-07,  7.73e-07,  nan ],
	[  3100,   55.92,  0.34,   99.19,  0.19,  34.14,   0.56,  21.05,   0.91,  9.06e-07,  9.84e-07,  9.45e-07,  nan ],
	[  3200,   57.40,  0.36,  102.42,  0.20,  35.26,   0.58,  20.63,   0.99,  9.16e-07,  8.77e-07,  8.77e-07,  nan ],
	[  3300,   59.18,  0.37,  105.28,  0.21,  36.38,   0.60,  21.01,   1.04,  9.62e-07,  9.62e-07,  9.25e-07,  nan ],
	[  3400,   61.47,  0.38,  107.06,  0.22,  37.18,   0.62,  21.99,   1.05,  1.15e-06,  1.11e-06,  1.15e-06,  nan ],
	[  3500,   62.83,  0.39,  109.82,  0.22,  38.47,   0.64,  21.55,   1.14,  8.72e-07,  9.42e-07,  8.72e-07,  nan ],
	[  3600,   64.31,  0.40,  112.23,  0.23,  39.29,   0.66,  21.65,   1.20,  1.19e-06,  1.15e-06,  1.15e-06,  nan ],
	[  3700,   66.32,  0.41,  112.73,  0.24,  40.52,   0.68,  21.81,   1.26,  8.58e-07,  8.91e-07,  9.24e-07,  nan ],
	[  3800,   68.15,  0.42,  114.20,  0.25,  41.45,   0.70,  21.72,   1.33,  1.09e-06,  1.03e-06,  1.03e-06,  nan ],
	[  3900,   68.50,  0.44,  111.46,  0.27,  42.61,   0.71,  21.10,   1.44,  1.41e-06,  1.28e-06,  1.25e-06,  nan ],
	[  4000,   69.89,  0.46,  115.53,  0.28,  43.55,   0.74,  21.60,   1.48,  1.13e-06,  1.16e-06,  1.13e-06,  nan ],
	[  4100,   70.07,  0.48,  112.48,  0.30,  31.64,   1.06,  22.46,   1.50,  1.13e-06,  1.10e-06,  1.07e-06,  nan ],
	[  4200,   72.59,  0.49,  114.56,  0.31,  32.55,   1.08,  22.46,   1.57,  1.13e-06,  1.13e-06,  1.10e-06,  nan ],
	[  4300,   74.27,  0.50,  115.18,  0.32,  33.57,   1.10,  22.34,   1.66,  1.02e-06,  1.08e-06,  1.14e-06,  nan ],
	[  4400,   76.37,  0.51,  115.29,  0.34,  34.48,   1.12,  23.15,   1.67,  1.25e-06,  1.22e-06,  1.30e-06,  nan ],
	[  4500,   76.71,  0.53,  115.43,  0.35,  35.56,   1.14,  22.63,   1.79,  1.17e-06,  1.09e-06,  1.03e-06,  nan ],
	[  4600,   78.84,  0.54,  116.27,  0.36,  35.51,   1.19,  22.76,   1.86,  1.41e-06,  1.51e-06,  1.54e-06,  nan ],
	[  4700,   81.08,  0.55,  114.48,  0.39,  36.52,   1.21,  22.28,   1.98,  1.40e-06,  1.22e-06,  1.32e-06,  nan ],
	[  4800,   81.16,  0.57,  118.82,  0.39,  37.35,   1.23,  22.41,   2.06,  1.22e-06,  1.09e-06,  1.09e-06,  nan ],
	[  4900,   79.91,  0.60,  117.74,  0.41,  38.21,   1.26,  22.76,   2.11,  1.35e-06,  1.20e-06,  1.15e-06,  nan ],
	[  5000,   82.00,  0.61,  117.12,  0.43,  37.66,   1.33,  22.60,   2.21,  1.07e-06,  1.07e-06,  1.05e-06,  nan ],
	[  5100,   80.17,  0.65,  117.45,  0.44,  39.48,   1.32,  23.56,   2.21,  1.20e-06,  1.32e-06,  1.24e-06,  nan ],
	[  5200,   81.70,  0.66,  116.58,  0.46,  40.37,   1.34,  23.27,   2.32,  1.29e-06,  1.46e-06,  1.31e-06,  nan ],
	[  5300,   81.21,  0.69,  119.82,  0.47,  40.95,   1.37,  23.43,   2.40,  1.20e-06,  1.27e-06,  1.20e-06,  nan ],
	[  5400,   81.58,  0.72,  122.33,  0.48,  41.73,   1.40,  24.19,   2.41,  1.54e-06,  1.60e-06,  1.51e-06,  nan ],
	[  5500,   81.56,  0.74,  120.29,  0.50,  42.29,   1.43,  23.93,   2.53,  1.40e-06,  1.46e-06,  1.40e-06,  nan ],
	[  5600,   83.85,  0.75,  121.36,  0.52,  42.82,   1.46,  24.02,   2.61,  1.53e-06,  1.31e-06,  1.48e-06,  nan ],
	[  5700,   82.68,  0.79,  121.69,  0.53,  43.45,   1.50,  23.57,   2.76,  1.46e-06,  1.54e-06,  1.54e-06,  nan ],
	[  5800,   82.77,  0.81,  121.50,  0.55,  43.89,   1.53,  23.71,   2.84,  1.47e-06,  1.43e-06,  1.35e-06,  nan ],
	[  5900,   84.00,  0.83,  122.61,  0.57,  45.01,   1.55,  23.29,   2.99,  1.28e-06,  1.24e-06,  1.24e-06,  nan ],
	[  6000,   83.44,  0.86,  124.35,  0.58,  45.60,   1.58,  23.80,   3.03,  1.30e-06,  1.34e-06,  1.26e-06,  nan ],
	[  6100,   84.19,  0.88,  124.28,  0.60,  46.06,   1.62,  23.46,   3.17,  1.52e-06,  1.44e-06,  1.36e-06,  nan ],
	[  6200,   85.34,  0.90,  123.00,  0.63,  36.86,   2.09,  23.43,   3.28,  1.42e-06,  1.30e-06,  1.38e-06,  nan ],
	[  6300,   86.97,  0.91,  126.81,  0.63,  37.77,   2.10,  23.43,   3.39,  1.98e-06,  1.98e-06,  1.98e-06,  nan ],
	[  6400,   86.80,  0.94,  127.42,  0.64,  38.41,   2.13,  23.72,   3.45,  1.49e-06,  1.37e-06,  1.37e-06,  nan ],
	[  6500,   87.20,  0.97,  126.33,  0.67,  38.41,   2.20,  23.73,   3.56,  1.65e-06,  1.50e-06,  1.46e-06,  nan ],
	[  6600,   89.27,  0.98,  127.56,  0.68,  39.28,   2.22,  24.16,   3.61,  1.66e-06,  1.70e-06,  1.63e-06,  nan ],
	[  6700,   88.22,  1.02,  128.06,  0.70,  39.77,   2.26,  24.54,   3.66,  1.49e-06,  1.57e-06,  1.64e-06,  nan ],
	[  6800,   87.85,  1.05,  128.80,  0.72,  40.09,   2.31,  24.62,   3.76,  1.65e-06,  1.69e-06,  1.58e-06,  nan ],
	[  6900,   89.52,  1.06,  132.31,  0.72,  41.00,   2.32,  24.77,   3.84,  1.59e-06,  1.63e-06,  1.59e-06,  nan ],
	[  7000,   88.62,  1.11,  131.59,  0.74,  41.58,   2.36,  24.97,   3.93,  1.36e-06,  1.40e-06,  1.29e-06,  nan ],
	[  7100,   90.76,  1.11,  129.57,  0.78,  42.21,   2.39,  24.30,   4.15,  1.65e-06,  1.55e-06,  1.48e-06,  nan ],
	[  7200,   91.43,  1.13,  131.08,  0.79,  42.55,   2.44,  24.49,   4.23,  2.14e-06,  2.17e-06,  2.14e-06,  nan ],
	[  7300,   90.95,  1.17,  131.57,  0.81,  41.73,   2.55,  23.42,   4.55,  1.64e-06,  1.54e-06,  1.47e-06,  nan ],
	[  7400,   91.28,  1.20,  133.24,  0.82,  42.69,   2.57,  24.15,   4.54,  1.68e-06,  1.68e-06,  1.72e-06,  nan ],
	[  7500,   92.44,  1.22,  133.31,  0.84,  43.92,   2.56,  23.68,   4.75,  1.73e-06,  1.66e-06,  1.73e-06,  nan ],
	[  7600,   94.08,  1.23,  134.35,  0.86,  44.16,   2.62,  23.76,   4.86,  1.73e-06,  1.61e-06,  1.61e-06,  nan ],
	[  7700,   93.17,  1.27,  131.63,  0.90,  44.75,   2.65,  23.55,   5.03,  1.68e-06,  1.68e-06,  1.78e-06,  nan ],
	[  7800,   94.05,  1.29,  132.00,  0.92,  43.82,   2.78,  23.75,   5.12,  1.50e-06,  1.53e-06,  1.53e-06,  nan ],
	[  7900,   94.92,  1.32,  133.10,  0.94,  44.69,   2.79,  23.81,   5.24,  1.51e-06,  1.48e-06,  1.45e-06,  nan ],
	[  8000,   94.76,  1.35,  135.45,  0.95,  45.62,   2.81,  23.75,   5.39,  1.71e-06,  1.86e-06,  1.98e-06,  nan ],
	[  8100,   95.38,  1.38,  135.58,  0.97,  46.44,   2.83,  23.99,   5.47,  1.48e-06,  1.45e-06,  1.42e-06,  nan ],
	[  8200,   96.70,  1.39,  135.74,  0.99,  38.63,   3.48,  23.75,   5.66,  1.58e-06,  1.46e-06,  1.52e-06,  nan ],
	[  8300,   97.79,  1.41,  132.77,  1.04,  39.06,   3.53,  23.80,   5.79,  1.68e-06,  1.65e-06,  1.68e-06,  nan ],
	[  8400,   96.87,  1.46,  133.90,  1.05,  39.60,   3.56,  24.06,   5.87,  1.71e-06,  1.71e-06,  1.83e-06,  nan ],
	[  8500,   99.66,  1.45,  132.72,  1.09,  40.55,   3.56,  23.74,   6.09,  1.67e-06,  1.58e-06,  1.61e-06,  nan ],
	[  8600,   99.49,  1.49,  134.48,  1.10,  41.37,   3.58,  24.24,   6.10,  1.65e-06,  1.67e-06,  1.65e-06,  nan ],
	[  8700,   98.24,  1.54,  134.94,  1.12,  41.63,   3.64,  24.39,   6.21,  1.99e-06,  1.91e-06,  1.82e-06,  nan ],
	[  8800,   98.35,  1.57,  135.75,  1.14,  41.36,   3.75,  24.09,   6.43,  2.03e-06,  1.89e-06,  1.78e-06,  nan ],
	[  8900,   99.21,  1.60,  134.03,  1.18,  41.65,   3.80,  23.92,   6.62,  1.84e-06,  1.73e-06,  1.76e-06,  nan ],
	[  9000,   99.41,  1.63,  134.14,  1.21,  41.37,   3.92,  23.91,   6.78,  1.65e-06,  1.60e-06,  1.55e-06,  nan ],
	[ 10000,  102.31,  1.96,  136.73,  1.46,  46.22,   4.33,  24.12,   8.29,  1.71e-06,  1.95e-06,  1.71e-06,  nan ],
	[ 12000,  103.68,  2.78,  140.23,  2.05,  44.71,   6.44,  24.08,  11.96,  2.08e-06,  1.87e-06,  1.87e-06,  nan ],
	[ 14000,  111.15,  3.53,  141.37,  2.77,  46.60,   8.41,  24.28,  16.14,  2.58e-06,  2.27e-06,  2.55e-06,  nan ],
	[ 16000,  111.21,  4.60,  140.32,  3.65,  46.05,  11.12,  23.63,  21.67,  2.62e-06,  2.59e-06,  2.59e-06,  nan ],
	[ 18000,  113.35,  5.72,  143.53,  4.51,  46.18,  14.03,  24.27,  26.71,  2.50e-06,  2.50e-06,  2.41e-06,  nan ],
	[ 20000,  116.88,  6.84,  143.43,  5.58,  45.19,  17.70,  24.35,  32.85,  2.69e-06,  2.64e-06,  2.66e-06,  nan ],
])

# numactl --interleave=all ../testing/testing_ssymv -U -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000 --lapack
ssymv_U = array([
	[    10,    0.01,  0.03,    0.01,  0.03,   0.01,   0.03,   0.12,   0.00,  9.54e-08,  9.54e-08,  4.77e-08,  nan ],
	[    11,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.12,   0.00,  4.33e-08,  4.33e-08,  4.33e-08,  nan ],
	[    12,    0.01,  0.03,    0.01,  0.03,   0.01,   0.02,   0.16,   0.00,  1.99e-08,  1.99e-08,  3.97e-08,  nan ],
	[    13,    0.01,  0.03,    0.01,  0.03,   0.02,   0.02,   0.17,   0.00,  3.67e-08,  3.67e-08,  7.34e-08,  nan ],
	[    14,    0.01,  0.04,    0.02,  0.03,   0.02,   0.02,   0.20,   0.00,  6.81e-08,  6.81e-08,  6.81e-08,  nan ],
	[    15,    0.02,  0.03,    0.02,  0.03,   0.02,   0.02,   0.15,   0.00,  9.54e-08,  6.36e-08,  9.54e-08,  nan ],
	[    16,    0.02,  0.03,    0.02,  0.03,   0.02,   0.02,   0.25,   0.00,  2.98e-08,  2.98e-08,  5.96e-08,  nan ],
	[    17,    0.02,  0.03,    0.02,  0.03,   0.03,   0.02,   0.32,   0.00,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    18,    0.02,  0.03,    0.03,  0.02,   0.03,   0.02,   0.32,   0.00,  5.30e-08,  7.95e-08,  7.95e-08,  nan ],
	[    19,    0.02,  0.03,    0.03,  0.03,   0.03,   0.02,   0.27,   0.00,  2.51e-08,  5.02e-08,  5.02e-08,  nan ],
	[    20,    0.03,  0.03,    0.03,  0.03,   0.04,   0.02,   0.44,   0.00,  7.15e-08,  7.15e-08,  7.15e-08,  nan ],
	[    21,    0.03,  0.03,    0.04,  0.02,   0.04,   0.02,   0.30,   0.00,  9.08e-08,  9.08e-08,  4.54e-08,  nan ],
	[    22,    0.03,  0.03,    0.04,  0.02,   0.04,   0.02,   0.35,   0.00,  4.33e-08,  8.67e-08,  8.67e-08,  nan ],
	[    23,    0.04,  0.03,    0.02,  0.06,   0.05,   0.02,   0.36,   0.00,  4.15e-08,  4.15e-08,  8.29e-08,  nan ],
	[    24,    0.04,  0.03,    0.05,  0.03,   0.05,   0.02,   0.39,   0.00,  7.95e-08,  7.95e-08,  7.95e-08,  nan ],
	[    25,    0.04,  0.03,    0.05,  0.03,   0.05,   0.02,   0.42,   0.00,  7.63e-08,  7.63e-08,  7.63e-08,  nan ],
	[    26,    0.04,  0.03,    0.05,  0.03,   0.06,   0.03,   0.45,   0.00,  1.10e-07,  1.10e-07,  1.10e-07,  nan ],
	[    27,    0.05,  0.03,    0.06,  0.03,   0.06,   0.03,   0.70,   0.00,  1.06e-07,  7.06e-08,  1.06e-07,  nan ],
	[    28,    0.05,  0.03,    0.05,  0.03,   0.06,   0.03,   0.52,   0.00,  6.81e-08,  6.81e-08,  1.02e-07,  nan ],
	[    29,    0.05,  0.03,    0.06,  0.03,   0.07,   0.02,   0.56,   0.00,  9.87e-08,  1.32e-07,  6.58e-08,  nan ],
	[    30,    0.06,  0.03,    0.07,  0.03,   0.07,   0.03,   0.65,   0.00,  9.54e-08,  9.54e-08,  9.54e-08,  nan ],
	[    31,    0.06,  0.03,    0.08,  0.03,   0.08,   0.02,   0.64,   0.00,  9.23e-08,  9.23e-08,  6.15e-08,  nan ],
	[    32,    0.07,  0.03,    0.08,  0.03,   0.09,   0.02,   0.98,   0.00,  5.96e-08,  5.96e-08,  8.94e-08,  nan ],
	[    33,    0.07,  0.03,    0.08,  0.03,   0.08,   0.03,   1.05,   0.00,  8.67e-08,  8.67e-08,  8.67e-08,  nan ],
	[    34,    0.07,  0.03,    0.09,  0.03,   0.09,   0.03,   0.77,   0.00,  8.41e-08,  1.12e-07,  1.12e-07,  nan ],
	[    35,    0.08,  0.03,    0.09,  0.03,   0.10,   0.03,   0.81,   0.00,  8.17e-08,  8.17e-08,  5.45e-08,  nan ],
	[    36,    0.09,  0.03,    0.10,  0.03,   0.10,   0.03,   0.93,   0.00,  7.95e-08,  1.06e-07,  7.95e-08,  nan ],
	[    37,    0.09,  0.03,    0.10,  0.03,   0.11,   0.03,   0.91,   0.00,  7.73e-08,  7.73e-08,  7.73e-08,  nan ],
	[    38,    0.09,  0.03,    0.11,  0.03,   0.11,   0.03,   0.96,   0.00,  1.00e-07,  1.00e-07,  1.00e-07,  nan ],
	[    39,    0.09,  0.03,    0.12,  0.03,   0.12,   0.03,   1.09,   0.00,  7.34e-08,  4.89e-08,  4.89e-08,  nan ],
	[    40,    0.10,  0.03,    0.12,  0.03,   0.12,   0.03,   1.06,   0.00,  9.54e-08,  7.15e-08,  9.54e-08,  nan ],
	[    41,    0.10,  0.03,    0.12,  0.03,   0.13,   0.03,   1.11,   0.00,  6.98e-08,  9.30e-08,  9.30e-08,  nan ],
	[    42,    0.11,  0.03,    0.13,  0.03,   0.13,   0.03,   1.26,   0.00,  9.08e-08,  9.08e-08,  9.08e-08,  nan ],
	[    43,    0.13,  0.03,    0.14,  0.03,   0.14,   0.03,   1.22,   0.00,  8.87e-08,  8.87e-08,  8.87e-08,  nan ],
	[    44,    0.13,  0.03,    0.15,  0.03,   0.15,   0.03,   1.28,   0.00,  1.30e-07,  1.30e-07,  1.08e-07,  nan ],
	[    45,    0.14,  0.03,    0.15,  0.03,   0.16,   0.03,   1.45,   0.00,  1.06e-07,  8.48e-08,  8.48e-08,  nan ],
	[    46,    0.14,  0.03,    0.16,  0.03,   0.17,   0.03,   1.51,   0.00,  8.29e-08,  8.29e-08,  8.29e-08,  nan ],
	[    47,    0.14,  0.03,    0.17,  0.03,   0.17,   0.03,   1.18,   0.00,  1.22e-07,  1.22e-07,  1.22e-07,  nan ],
	[    48,    0.16,  0.03,    0.17,  0.03,   0.17,   0.03,   1.64,   0.00,  7.95e-08,  1.19e-07,  1.19e-07,  nan ],
	[    49,    0.16,  0.03,    0.17,  0.03,   0.19,   0.03,   1.21,   0.00,  1.56e-07,  1.56e-07,  1.56e-07,  nan ],
	[    50,    0.16,  0.03,    0.18,  0.03,   0.19,   0.03,   1.65,   0.00,  1.14e-07,  7.63e-08,  1.14e-07,  nan ],
	[    51,    0.17,  0.03,    0.18,  0.03,   0.19,   0.03,   1.31,   0.00,  1.12e-07,  1.12e-07,  1.12e-07,  nan ],
	[    52,    0.17,  0.03,    0.18,  0.03,   0.20,   0.03,   1.36,   0.00,  1.10e-07,  7.34e-08,  7.34e-08,  nan ],
	[    53,    0.18,  0.03,    0.19,  0.03,   0.20,   0.03,   1.41,   0.00,  1.44e-07,  1.44e-07,  1.44e-07,  nan ],
	[    54,    0.19,  0.03,    0.20,  0.03,   0.21,   0.03,   1.47,   0.00,  1.06e-07,  1.06e-07,  1.06e-07,  nan ],
	[    55,    0.19,  0.03,    0.21,  0.03,   0.22,   0.03,   1.52,   0.00,  1.39e-07,  1.04e-07,  1.39e-07,  nan ],
	[    56,    0.19,  0.03,    0.21,  0.03,   0.22,   0.03,   1.67,   0.00,  1.36e-07,  1.36e-07,  1.02e-07,  nan ],
	[    57,    0.20,  0.03,    0.22,  0.03,   0.24,   0.03,   1.63,   0.00,  6.69e-08,  1.00e-07,  1.00e-07,  nan ],
	[    58,    0.21,  0.03,    0.22,  0.03,   0.25,   0.03,   1.37,   0.01,  1.32e-07,  9.87e-08,  1.32e-07,  nan ],
	[    59,    0.21,  0.03,    0.24,  0.03,   0.25,   0.03,   1.41,   0.01,  1.29e-07,  1.29e-07,  9.70e-08,  nan ],
	[    60,    0.24,  0.03,    0.24,  0.03,   0.25,   0.03,   1.81,   0.00,  1.27e-07,  1.27e-07,  9.54e-08,  nan ],
	[    61,    0.23,  0.03,    0.24,  0.03,   0.27,   0.03,   1.51,   0.01,  9.38e-08,  9.38e-08,  9.38e-08,  nan ],
	[    62,    0.25,  0.03,    0.25,  0.03,   0.27,   0.03,   1.56,   0.01,  1.23e-07,  1.23e-07,  1.23e-07,  nan ],
	[    63,    0.24,  0.03,    0.25,  0.03,   0.27,   0.03,   1.99,   0.00,  1.51e-07,  9.08e-08,  1.21e-07,  nan ],
	[    64,    0.25,  0.03,    0.26,  0.03,   0.29,   0.03,   2.18,   0.00,  8.94e-08,  8.94e-08,  8.94e-08,  nan ],
	[    65,    0.22,  0.04,    0.22,  0.04,   0.27,   0.03,   2.12,   0.00,  1.17e-07,  8.80e-08,  1.17e-07,  nan ],
	[    66,    0.23,  0.04,    0.23,  0.04,   0.29,   0.03,   1.77,   0.01,  1.73e-07,  1.44e-07,  1.16e-07,  nan ],
	[    67,    0.25,  0.04,    0.20,  0.05,   0.30,   0.03,   2.25,   0.00,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[    68,    0.28,  0.03,    0.25,  0.04,   0.31,   0.03,   2.32,   0.00,  1.40e-07,  1.12e-07,  1.12e-07,  nan ],
	[    69,    0.27,  0.04,    0.27,  0.04,   0.35,   0.03,   1.93,   0.01,  1.38e-07,  1.11e-07,  1.11e-07,  nan ],
	[    70,    0.29,  0.03,    0.27,  0.04,   0.34,   0.03,   2.45,   0.00,  1.09e-07,  1.09e-07,  1.09e-07,  nan ],
	[    71,    0.29,  0.04,    0.26,  0.04,   0.35,   0.03,   2.52,   0.00,  1.34e-07,  1.61e-07,  1.34e-07,  nan ],
	[    72,    0.30,  0.04,    0.28,  0.04,   0.36,   0.03,   2.59,   0.00,  1.59e-07,  1.32e-07,  1.32e-07,  nan ],
	[    73,    0.30,  0.04,    0.29,  0.04,   0.37,   0.03,   2.16,   0.01,  1.57e-07,  1.05e-07,  1.31e-07,  nan ],
	[    74,    0.33,  0.03,    0.29,  0.04,   0.40,   0.03,   2.91,   0.00,  1.80e-07,  1.03e-07,  1.29e-07,  nan ],
	[    75,    0.33,  0.03,    0.31,  0.04,   0.39,   0.03,   2.28,   0.01,  1.53e-07,  1.02e-07,  1.02e-07,  nan ],
	[    76,    0.35,  0.03,    0.31,  0.04,   0.41,   0.03,   2.34,   0.01,  1.00e-07,  1.00e-07,  1.51e-07,  nan ],
	[    77,    0.34,  0.04,    0.32,  0.04,   0.42,   0.03,   2.40,   0.01,  1.49e-07,  1.49e-07,  1.49e-07,  nan ],
	[    78,    0.36,  0.03,    0.32,  0.04,   0.42,   0.03,   2.46,   0.01,  1.22e-07,  9.78e-08,  9.78e-08,  nan ],
	[    79,    0.36,  0.04,    0.32,  0.04,   0.42,   0.03,   2.52,   0.01,  1.45e-07,  1.45e-07,  1.45e-07,  nan ],
	[    80,    0.37,  0.03,    0.34,  0.04,   0.43,   0.03,   2.59,   0.01,  1.43e-07,  1.43e-07,  1.43e-07,  nan ],
	[    81,    0.37,  0.04,    0.34,  0.04,   0.44,   0.03,   2.65,   0.01,  1.41e-07,  9.42e-08,  1.18e-07,  nan ],
	[    82,    0.37,  0.04,    0.35,  0.04,   0.44,   0.03,   2.28,   0.01,  1.63e-07,  1.40e-07,  9.30e-08,  nan ],
	[    83,    0.38,  0.04,    0.36,  0.04,   0.45,   0.03,   3.44,   0.00,  1.38e-07,  1.38e-07,  1.15e-07,  nan ],
	[    84,    0.34,  0.04,    0.37,  0.04,   0.48,   0.03,   2.30,   0.01,  1.82e-07,  1.82e-07,  1.82e-07,  nan ],
	[    85,    0.42,  0.04,    0.39,  0.04,   0.49,   0.03,   2.92,   0.01,  1.35e-07,  1.57e-07,  1.35e-07,  nan ],
	[    86,    0.39,  0.04,    0.39,  0.04,   0.50,   0.03,   2.99,   0.01,  1.33e-07,  1.33e-07,  1.33e-07,  nan ],
	[    87,    0.41,  0.04,    0.40,  0.04,   0.49,   0.03,   2.57,   0.01,  1.75e-07,  1.32e-07,  1.32e-07,  nan ],
	[    88,    0.41,  0.04,    0.42,  0.04,   0.52,   0.03,   3.13,   0.01,  1.30e-07,  1.30e-07,  1.73e-07,  nan ],
	[    89,    0.42,  0.04,    0.42,  0.04,   0.52,   0.03,   2.69,   0.01,  1.71e-07,  1.71e-07,  1.71e-07,  nan ],
	[    90,    0.43,  0.04,    0.42,  0.04,   0.55,   0.03,   3.27,   0.01,  1.27e-07,  1.27e-07,  1.27e-07,  nan ],
	[   100,    0.58,  0.03,    0.52,  0.04,   0.63,   0.03,   3.39,   0.01,  1.14e-07,  1.14e-07,  1.14e-07,  nan ],
	[   110,    0.64,  0.04,    0.63,  0.04,   0.72,   0.03,   4.10,   0.01,  1.73e-07,  2.08e-07,  1.73e-07,  nan ],
	[   120,    0.81,  0.04,    0.74,  0.04,   0.86,   0.03,   4.20,   0.01,  1.91e-07,  1.59e-07,  1.91e-07,  nan ],
	[   130,    0.78,  0.04,    0.88,  0.04,   0.95,   0.04,   4.20,   0.01,  2.35e-07,  1.76e-07,  1.76e-07,  nan ],
	[   140,    0.90,  0.04,    0.99,  0.04,   1.10,   0.04,   4.87,   0.01,  1.63e-07,  1.91e-07,  1.91e-07,  nan ],
	[   150,    1.01,  0.05,    1.13,  0.04,   1.23,   0.04,   4.13,   0.01,  1.78e-07,  2.03e-07,  1.78e-07,  nan ],
	[   160,    1.26,  0.04,    1.32,  0.04,   1.43,   0.04,   6.55,   0.01,  1.91e-07,  1.91e-07,  2.15e-07,  nan ],
	[   170,    1.35,  0.04,    1.49,  0.04,   1.57,   0.04,   5.30,   0.01,  2.24e-07,  2.24e-07,  1.80e-07,  nan ],
	[   180,    1.59,  0.04,    1.64,  0.04,   1.72,   0.04,   7.19,   0.01,  1.70e-07,  1.48e-07,  1.48e-07,  nan ],
	[   190,    1.73,  0.04,    1.77,  0.04,   1.91,   0.04,   7.25,   0.01,  3.21e-07,  2.81e-07,  2.41e-07,  nan ],
	[   200,    1.64,  0.05,    1.96,  0.04,   2.01,   0.04,   8.03,   0.01,  2.29e-07,  2.29e-07,  2.29e-07,  nan ],
	[   210,    1.93,  0.05,    2.16,  0.04,   2.21,   0.04,   7.91,   0.01,  2.54e-07,  2.91e-07,  2.54e-07,  nan ],
	[   220,    1.99,  0.05,    2.27,  0.04,   2.37,   0.04,   8.87,   0.01,  2.77e-07,  2.77e-07,  2.43e-07,  nan ],
	[   230,    2.17,  0.05,    2.53,  0.04,   2.53,   0.04,   7.55,   0.01,  3.32e-07,  2.65e-07,  2.99e-07,  nan ],
	[   240,    2.32,  0.05,    2.70,  0.04,   2.76,   0.04,   7.24,   0.02,  2.23e-07,  2.54e-07,  2.54e-07,  nan ],
	[   250,    2.67,  0.05,    3.06,  0.04,   3.06,   0.04,   7.86,   0.02,  2.14e-07,  2.14e-07,  2.14e-07,  nan ],
	[   260,    2.61,  0.05,    3.01,  0.05,   3.23,   0.04,   3.39,   0.04,  2.93e-07,  2.93e-07,  2.93e-07,  nan ],
	[   270,    2.82,  0.05,    3.41,  0.04,   3.34,   0.04,   3.86,   0.04,  2.83e-07,  2.83e-07,  2.83e-07,  nan ],
	[   280,    2.86,  0.06,    3.57,  0.04,   3.49,   0.05,   4.13,   0.04,  3.00e-07,  2.72e-07,  2.45e-07,  nan ],
	[   290,    3.17,  0.05,    3.93,  0.04,   3.67,   0.05,   4.21,   0.04,  2.63e-07,  2.37e-07,  2.37e-07,  nan ],
	[   300,    3.29,  0.05,    4.12,  0.04,   4.01,   0.05,   4.01,   0.05,  3.31e-07,  3.56e-07,  3.05e-07,  nan ],
	[   310,    3.71,  0.05,    4.47,  0.04,   4.30,   0.04,   4.02,   0.05,  2.71e-07,  2.95e-07,  3.20e-07,  nan ],
	[   320,    3.95,  0.05,    4.79,  0.04,   4.56,   0.05,   3.49,   0.06,  3.34e-07,  3.10e-07,  3.10e-07,  nan ],
	[   330,    3.83,  0.06,    4.87,  0.04,   4.54,   0.05,   3.76,   0.06,  2.54e-07,  2.77e-07,  3.01e-07,  nan ],
	[   340,    4.00,  0.06,    5.17,  0.04,   4.74,   0.05,   3.94,   0.06,  3.59e-07,  2.69e-07,  3.14e-07,  nan ],
	[   350,    4.17,  0.06,    5.48,  0.04,   5.13,   0.05,   3.41,   0.07,  2.83e-07,  2.62e-07,  2.62e-07,  nan ],
	[   360,    4.56,  0.06,    5.92,  0.04,   5.29,   0.05,   4.49,   0.06,  2.97e-07,  2.54e-07,  2.97e-07,  nan ],
	[   370,    4.57,  0.06,    6.09,  0.05,   5.38,   0.05,   4.04,   0.07,  2.89e-07,  2.47e-07,  2.47e-07,  nan ],
	[   380,    4.82,  0.06,    6.29,  0.05,   5.68,   0.05,   4.32,   0.07,  4.02e-07,  3.21e-07,  3.61e-07,  nan ],
	[   390,    4.85,  0.06,    6.46,  0.05,   5.87,   0.05,   6.80,   0.04,  3.13e-07,  3.52e-07,  3.13e-07,  nan ],
	[   400,    5.08,  0.06,    6.97,  0.05,   6.32,   0.05,   7.27,   0.04,  3.43e-07,  2.67e-07,  3.05e-07,  nan ],
	[   410,    5.10,  0.07,    7.18,  0.05,   6.48,   0.05,   6.48,   0.05,  4.09e-07,  4.09e-07,  4.47e-07,  nan ],
	[   420,    5.53,  0.06,    7.38,  0.05,   6.53,   0.05,   6.80,   0.05,  3.27e-07,  3.27e-07,  3.27e-07,  nan ],
	[   430,    5.61,  0.07,    7.89,  0.05,   6.88,   0.05,   6.50,   0.06,  3.55e-07,  3.90e-07,  3.90e-07,  nan ],
	[   440,    6.17,  0.06,    5.54,  0.07,   7.47,   0.05,   6.70,   0.06,  3.81e-07,  3.47e-07,  3.47e-07,  nan ],
	[   450,    5.71,  0.07,    8.47,  0.05,   7.37,   0.06,   6.35,   0.06,  3.73e-07,  4.07e-07,  4.07e-07,  nan ],
	[   460,    6.07,  0.07,    8.85,  0.05,   7.70,   0.06,   6.42,   0.07,  3.32e-07,  3.65e-07,  3.65e-07,  nan ],
	[   470,    6.61,  0.07,    9.43,  0.05,   7.94,   0.06,   5.99,   0.07,  4.55e-07,  3.57e-07,  3.90e-07,  nan ],
	[   480,    6.50,  0.07,    9.59,  0.05,   8.24,   0.06,   6.15,   0.08,  3.18e-07,  3.50e-07,  3.50e-07,  nan ],
	[   490,    6.77,  0.07,    9.05,  0.05,   8.17,   0.06,   5.87,   0.08,  4.36e-07,  4.05e-07,  4.36e-07,  nan ],
	[   500,    7.27,  0.07,   10.25,  0.05,   8.34,   0.06,   6.11,   0.08,  3.97e-07,  4.27e-07,  3.97e-07,  nan ],
	[   510,    7.54,  0.07,   10.41,  0.05,   8.41,   0.06,   5.78,   0.09,  4.19e-07,  3.59e-07,  3.59e-07,  nan ],
	[   520,    7.43,  0.07,   11.25,  0.05,   8.88,   0.06,   9.35,   0.06,  3.52e-07,  3.81e-07,  3.81e-07,  nan ],
	[   530,    7.59,  0.07,   11.46,  0.05,   9.08,   0.06,   8.81,   0.06,  4.89e-07,  4.89e-07,  4.89e-07,  nan ],
	[   540,    7.78,  0.08,   11.73,  0.05,   9.11,   0.06,   8.98,   0.07,  3.96e-07,  3.67e-07,  4.24e-07,  nan ],
	[   550,    8.31,  0.07,   12.40,  0.05,   9.31,   0.07,   8.65,   0.07,  4.44e-07,  4.72e-07,  4.44e-07,  nan ],
	[   560,    8.50,  0.07,   12.37,  0.05,   9.65,   0.07,   8.61,   0.07,  4.36e-07,  4.09e-07,  3.81e-07,  nan ],
	[   570,    8.92,  0.07,   13.00,  0.05,   9.86,   0.07,   8.13,   0.08,  3.75e-07,  3.75e-07,  3.21e-07,  nan ],
	[   580,    8.41,  0.08,   12.73,  0.05,   9.92,   0.07,   8.12,   0.08,  3.95e-07,  3.95e-07,  3.68e-07,  nan ],
	[   590,    8.71,  0.08,   13.67,  0.05,  10.26,   0.07,   7.66,   0.09,  3.62e-07,  4.14e-07,  3.62e-07,  nan ],
	[   600,    9.03,  0.08,   13.63,  0.05,  10.29,   0.07,   7.92,   0.09,  3.81e-07,  3.81e-07,  4.58e-07,  nan ],
	[   610,    9.20,  0.08,   13.77,  0.05,  10.35,   0.07,   7.11,   0.10,  3.75e-07,  3.75e-07,  3.25e-07,  nan ],
	[   620,    9.53,  0.08,   13.98,  0.06,  10.69,   0.07,   7.55,   0.10,  4.18e-07,  3.45e-07,  3.94e-07,  nan ],
	[   630,    9.95,  0.08,   15.02,  0.05,  11.19,   0.07,   7.23,   0.11,  3.88e-07,  4.12e-07,  3.88e-07,  nan ],
	[   640,    9.89,  0.08,   14.90,  0.06,  11.40,   0.07,  12.42,   0.07,  3.58e-07,  4.05e-07,  3.58e-07,  nan ],
	[   650,    9.62,  0.09,   15.71,  0.05,  11.75,   0.07,  11.27,   0.08,  4.46e-07,  4.46e-07,  4.23e-07,  nan ],
	[   660,   10.03,  0.09,   15.57,  0.06,  11.77,   0.07,  11.19,   0.08,  3.70e-07,  3.70e-07,  3.70e-07,  nan ],
	[   670,   10.33,  0.09,   16.61,  0.05,  12.32,   0.07,  10.56,   0.09,  3.64e-07,  3.87e-07,  3.87e-07,  nan ],
	[   680,   10.41,  0.09,   16.53,  0.06,  12.18,   0.08,  10.41,   0.09,  3.59e-07,  3.59e-07,  3.59e-07,  nan ],
	[   690,   10.84,  0.09,   16.73,  0.06,  12.38,   0.08,  10.05,   0.09,  3.98e-07,  3.10e-07,  3.10e-07,  nan ],
	[   700,   11.43,  0.09,   17.22,  0.06,  12.74,   0.08,   9.92,   0.10,  3.71e-07,  3.92e-07,  3.71e-07,  nan ],
	[   710,   10.97,  0.09,   18.02,  0.06,  13.11,   0.08,   9.60,   0.11,  4.30e-07,  4.73e-07,  4.73e-07,  nan ],
	[   720,   11.05,  0.09,   18.22,  0.06,  13.32,   0.08,   9.51,   0.11,  3.81e-07,  4.24e-07,  3.81e-07,  nan ],
	[   730,   11.87,  0.09,   19.38,  0.06,  13.69,   0.08,   8.90,   0.12,  4.18e-07,  4.18e-07,  4.60e-07,  nan ],
	[   740,   11.08,  0.10,   19.25,  0.06,  13.69,   0.08,   9.22,   0.12,  4.54e-07,  4.12e-07,  4.54e-07,  nan ],
	[   750,   11.61,  0.10,   19.44,  0.06,  13.94,   0.08,   8.88,   0.13,  4.48e-07,  4.48e-07,  4.48e-07,  nan ],
	[   760,   12.19,  0.09,   19.97,  0.06,  14.27,   0.08,   9.03,   0.13,  4.42e-07,  4.42e-07,  4.42e-07,  nan ],
	[   770,   11.53,  0.10,   20.49,  0.06,  14.48,   0.08,  12.64,   0.09,  4.76e-07,  4.36e-07,  4.36e-07,  nan ],
	[   780,   12.20,  0.10,   20.69,  0.06,  14.68,   0.08,  13.10,   0.09,  5.48e-07,  5.09e-07,  5.09e-07,  nan ],
	[   790,   12.51,  0.10,   21.14,  0.06,  15.24,   0.08,  12.51,   0.10,  4.64e-07,  4.64e-07,  4.25e-07,  nan ],
	[   800,   12.44,  0.10,   21.76,  0.06,  15.45,   0.08,  12.11,   0.11,  4.96e-07,  5.72e-07,  5.34e-07,  nan ],
	[   810,   12.76,  0.10,   22.68,  0.06,  15.66,   0.08,  11.50,   0.11,  5.27e-07,  6.40e-07,  5.65e-07,  nan ],
	[   820,   13.07,  0.10,   22.41,  0.06,  15.64,   0.09,  11.50,   0.12,  5.58e-07,  5.21e-07,  5.58e-07,  nan ],
	[   830,   13.15,  0.10,   22.60,  0.06,  16.21,   0.09,  11.13,   0.12,  5.88e-07,  5.52e-07,  5.15e-07,  nan ],
	[   840,   12.97,  0.11,   23.52,  0.06,  16.42,   0.09,  11.40,   0.12,  7.27e-07,  6.90e-07,  6.54e-07,  nan ],
	[   850,   13.16,  0.11,   23.70,  0.06,  16.44,   0.09,  10.72,   0.13,  5.03e-07,  4.67e-07,  5.39e-07,  nan ],
	[   860,   13.22,  0.11,   23.89,  0.06,  16.65,   0.09,  10.73,   0.14,  5.68e-07,  5.68e-07,  6.03e-07,  nan ],
	[   870,   13.64,  0.11,   24.83,  0.06,  16.64,   0.09,  10.67,   0.14,  5.96e-07,  5.61e-07,  5.61e-07,  nan ],
	[   880,   13.96,  0.11,   25.01,  0.06,  17.02,   0.09,  10.49,   0.15,  4.86e-07,  4.86e-07,  4.86e-07,  nan ],
	[   890,   14.03,  0.11,   25.10,  0.06,  17.23,   0.09,  10.17,   0.16,  5.83e-07,  5.83e-07,  5.49e-07,  nan ],
	[   900,   13.88,  0.12,   25.77,  0.06,  17.05,   0.10,  14.11,   0.11,  5.09e-07,  5.09e-07,  5.09e-07,  nan ],
	[  1000,   16.02,  0.12,   29.46,  0.07,  18.87,   0.11,  11.84,   0.17,  5.80e-07,  5.80e-07,  5.49e-07,  nan ],
	[  1100,   17.55,  0.14,   32.77,  0.07,  21.25,   0.11,  13.84,   0.17,  5.83e-07,  5.83e-07,  6.10e-07,  nan ],
	[  1200,   19.50,  0.15,   36.52,  0.08,  23.25,   0.12,  15.66,   0.18,  5.59e-07,  5.59e-07,  5.59e-07,  nan ],
	[  1300,   20.77,  0.16,   40.19,  0.08,  25.61,   0.13,  16.99,   0.20,  5.63e-07,  5.87e-07,  6.34e-07,  nan ],
	[  1400,   23.21,  0.17,   45.08,  0.09,  28.22,   0.14,  14.74,   0.27,  6.54e-07,  6.98e-07,  6.54e-07,  nan ],
	[  1500,   24.88,  0.18,   47.94,  0.09,  29.06,   0.15,  16.14,   0.28,  7.32e-07,  6.10e-07,  6.51e-07,  nan ],
	[  1600,   26.96,  0.19,   51.28,  0.10,  31.23,   0.16,  17.43,   0.29,  8.77e-07,  8.01e-07,  8.01e-07,  nan ],
	[  1700,   28.64,  0.20,   57.35,  0.10,  33.27,   0.17,  18.55,   0.31,  7.90e-07,  7.90e-07,  7.18e-07,  nan ],
	[  1800,   30.15,  0.22,   61.80,  0.10,  36.21,   0.18,  19.30,   0.34,  9.16e-07,  8.82e-07,  9.16e-07,  nan ],
	[  1900,   32.72,  0.22,   63.92,  0.11,  38.02,   0.19,  17.45,   0.41,  8.35e-07,  7.71e-07,  8.35e-07,  nan ],
	[  2000,   33.64,  0.24,   62.99,  0.13,  38.11,   0.21,  18.79,   0.43,  8.85e-07,  9.16e-07,  8.54e-07,  nan ],
	[  2100,   36.14,  0.24,   63.92,  0.14,  24.45,   0.36,  19.52,   0.45,  1.02e-06,  1.08e-06,  9.88e-07,  nan ],
	[  2200,   37.23,  0.26,   66.26,  0.15,  25.61,   0.38,  19.06,   0.51,  8.60e-07,  8.60e-07,  8.60e-07,  nan ],
	[  2300,   39.32,  0.27,   64.62,  0.16,  25.95,   0.41,  17.85,   0.59,  8.49e-07,  9.02e-07,  9.02e-07,  nan ],
	[  2400,   40.86,  0.28,   70.67,  0.16,  27.17,   0.42,  19.27,   0.60,  8.65e-07,  8.39e-07,  8.90e-07,  nan ],
	[  2500,   41.56,  0.30,   74.08,  0.17,  28.29,   0.44,  19.84,   0.63,  8.30e-07,  8.79e-07,  8.54e-07,  nan ],
	[  2600,   43.77,  0.31,   76.87,  0.18,  29.15,   0.46,  21.07,   0.64,  7.98e-07,  7.51e-07,  7.98e-07,  nan ],
	[  2700,   45.02,  0.32,   76.76,  0.19,  30.27,   0.48,  21.17,   0.69,  9.27e-07,  8.59e-07,  8.36e-07,  nan ],
	[  2800,   47.85,  0.33,   80.43,  0.20,  31.63,   0.50,  20.56,   0.76,  9.81e-07,  9.81e-07,  9.81e-07,  nan ],
	[  2900,   49.04,  0.34,   83.32,  0.20,  32.85,   0.51,  21.32,   0.79,  1.05e-06,  1.09e-06,  1.09e-06,  nan ],
	[  3000,   50.18,  0.36,   83.82,  0.21,  33.72,   0.53,  21.80,   0.83,  1.10e-06,  9.77e-07,  9.77e-07,  nan ],
	[  3100,   52.09,  0.37,   87.37,  0.22,  34.64,   0.56,  22.30,   0.86,  1.10e-06,  1.14e-06,  1.18e-06,  nan ],
	[  3200,   53.77,  0.38,   85.33,  0.24,  35.39,   0.58,  22.15,   0.93,  1.07e-06,  1.14e-06,  1.07e-06,  nan ],
	[  3300,   55.45,  0.39,   92.30,  0.24,  36.42,   0.60,  20.52,   1.06,  1.18e-06,  1.26e-06,  1.18e-06,  nan ],
	[  3400,   56.30,  0.41,   93.27,  0.25,  38.04,   0.61,  22.09,   1.05,  1.11e-06,  1.18e-06,  1.08e-06,  nan ],
	[  3500,   58.34,  0.42,   96.43,  0.25,  38.72,   0.63,  21.86,   1.12,  1.15e-06,  1.08e-06,  1.12e-06,  nan ],
	[  3600,   59.72,  0.43,   98.95,  0.26,  39.83,   0.65,  24.44,   1.06,  1.19e-06,  1.19e-06,  1.29e-06,  nan ],
	[  3700,   61.69,  0.44,  101.03,  0.27,  40.86,   0.67,  22.10,   1.24,  1.19e-06,  1.19e-06,  1.12e-06,  nan ],
	[  3800,   62.52,  0.46,  102.77,  0.28,  41.68,   0.69,  23.89,   1.21,  1.41e-06,  1.41e-06,  1.38e-06,  nan ],
	[  3900,   65.45,  0.46,   99.78,  0.30,  43.10,   0.71,  23.37,   1.30,  1.22e-06,  1.19e-06,  1.25e-06,  nan ],
	[  4000,   65.33,  0.49,   99.08,  0.32,  43.38,   0.74,  24.34,   1.32,  1.53e-06,  1.28e-06,  1.40e-06,  nan ],
	[  4100,   65.57,  0.51,   93.41,  0.36,  34.00,   0.99,  23.48,   1.43,  1.40e-06,  1.37e-06,  1.34e-06,  nan ],
	[  4200,   68.40,  0.52,  101.66,  0.35,  33.23,   1.06,  21.90,   1.61,  1.31e-06,  1.34e-06,  1.34e-06,  nan ],
	[  4300,   69.54,  0.53,  105.04,  0.35,  33.84,   1.09,  22.07,   1.68,  1.42e-06,  1.50e-06,  1.48e-06,  nan ],
	[  4400,   71.88,  0.54,  105.00,  0.37,  34.86,   1.11,  22.27,   1.74,  1.28e-06,  1.28e-06,  1.28e-06,  nan ],
	[  4500,   72.09,  0.56,  107.74,  0.38,  35.56,   1.14,  22.64,   1.79,  1.36e-06,  1.36e-06,  1.41e-06,  nan ],
	[  4600,   74.38,  0.57,  105.30,  0.40,  36.33,   1.17,  22.34,   1.89,  1.17e-06,  1.25e-06,  1.22e-06,  nan ],
	[  4700,   74.50,  0.59,  109.09,  0.41,  36.83,   1.20,  22.40,   1.97,  1.45e-06,  1.43e-06,  1.45e-06,  nan ],
	[  4800,   77.05,  0.60,  106.92,  0.43,  37.65,   1.22,  22.08,   2.09,  1.55e-06,  1.60e-06,  1.55e-06,  nan ],
	[  4900,   77.96,  0.62,  111.73,  0.43,  38.15,   1.26,  23.02,   2.09,  1.42e-06,  1.49e-06,  1.42e-06,  nan ],
	[  5000,   79.27,  0.63,  112.11,  0.45,  38.41,   1.30,  22.06,   2.27,  1.37e-06,  1.42e-06,  1.46e-06,  nan ],
	[  5100,   79.18,  0.66,  113.37,  0.46,  38.17,   1.36,  22.63,   2.30,  1.39e-06,  1.39e-06,  1.39e-06,  nan ],
	[  5200,   80.88,  0.67,  111.48,  0.49,  40.67,   1.33,  21.41,   2.53,  1.39e-06,  1.39e-06,  1.36e-06,  nan ],
	[  5300,   81.30,  0.69,  115.36,  0.49,  41.43,   1.36,  21.99,   2.56,  1.57e-06,  1.36e-06,  1.38e-06,  nan ],
	[  5400,   83.33,  0.70,  116.23,  0.50,  42.09,   1.39,  21.64,   2.70,  1.51e-06,  1.51e-06,  1.56e-06,  nan ],
	[  5500,   84.40,  0.72,  115.73,  0.52,  42.79,   1.41,  21.69,   2.79,  1.27e-06,  1.31e-06,  1.31e-06,  nan ],
	[  5600,   86.15,  0.73,  118.36,  0.53,  43.20,   1.45,  21.34,   2.94,  1.48e-06,  1.48e-06,  1.44e-06,  nan ],
	[  5700,   86.43,  0.75,  119.51,  0.54,  43.85,   1.48,  21.75,   2.99,  1.54e-06,  1.41e-06,  1.50e-06,  nan ],
	[  5800,   88.09,  0.76,  119.75,  0.56,  44.62,   1.51,  21.06,   3.19,  1.56e-06,  1.56e-06,  1.52e-06,  nan ],
	[  5900,   89.15,  0.78,  116.82,  0.60,  45.42,   1.53,  22.51,   3.09,  1.45e-06,  1.49e-06,  1.53e-06,  nan ],
	[  6000,   89.02,  0.81,  119.38,  0.60,  46.28,   1.56,  21.43,   3.36,  1.79e-06,  1.83e-06,  1.83e-06,  nan ],
	[  6100,   89.76,  0.83,  118.70,  0.63,  46.60,   1.60,  21.27,   3.50,  1.60e-06,  1.56e-06,  1.60e-06,  nan ],
	[  6200,   93.43,  0.82,  119.94,  0.64,  37.02,   2.08,  20.93,   3.67,  1.73e-06,  1.69e-06,  1.65e-06,  nan ],
	[  6300,   93.20,  0.85,  120.83,  0.66,  38.00,   2.09,  21.19,   3.75,  1.78e-06,  1.59e-06,  1.63e-06,  nan ],
	[  6400,   94.62,  0.87,  119.78,  0.68,  38.44,   2.13,  21.54,   3.80,  1.87e-06,  1.95e-06,  1.87e-06,  nan ],
	[  6500,   95.26,  0.89,  121.10,  0.70,  39.00,   2.17,  21.02,   4.02,  1.73e-06,  1.92e-06,  1.84e-06,  nan ],
	[  6600,   97.90,  0.89,  121.86,  0.72,  39.69,   2.20,  21.75,   4.01,  1.89e-06,  1.89e-06,  1.92e-06,  nan ],
	[  6700,   98.03,  0.92,  122.84,  0.73,  40.23,   2.23,  21.04,   4.27,  1.71e-06,  1.60e-06,  1.64e-06,  nan ],
	[  6800,  100.09,  0.92,  122.34,  0.76,  40.43,   2.29,  21.36,   4.33,  1.72e-06,  1.72e-06,  1.76e-06,  nan ],
	[  6900,   99.19,  0.96,  122.87,  0.78,  41.23,   2.31,  22.61,   4.21,  1.56e-06,  1.63e-06,  1.63e-06,  nan ],
	[  7000,  101.56,  0.97,  124.73,  0.79,  41.96,   2.34,  23.13,   4.24,  1.74e-06,  1.74e-06,  1.64e-06,  nan ],
	[  7100,  102.48,  0.98,  123.56,  0.82,  42.42,   2.38,  21.92,   4.60,  1.82e-06,  1.79e-06,  1.65e-06,  nan ],
	[  7200,  103.28,  1.00,  126.14,  0.82,  42.93,   2.42,  22.73,   4.56,  1.86e-06,  1.86e-06,  1.83e-06,  nan ],
	[  7300,  104.19,  1.02,  126.62,  0.84,  43.29,   2.46,  21.86,   4.88,  1.74e-06,  1.81e-06,  1.91e-06,  nan ],
	[  7400,  104.63,  1.05,  127.83,  0.86,  44.01,   2.49,  22.55,   4.86,  1.78e-06,  1.81e-06,  1.85e-06,  nan ],
	[  7500,  106.24,  1.06,  127.41,  0.88,  44.69,   2.52,  23.24,   4.84,  1.86e-06,  1.92e-06,  1.82e-06,  nan ],
	[  7600,  107.78,  1.07,  127.39,  0.91,  44.78,   2.58,  23.04,   5.02,  1.61e-06,  1.57e-06,  1.57e-06,  nan ],
	[  7700,  107.23,  1.11,  126.99,  0.93,  45.51,   2.61,  22.69,   5.23,  2.03e-06,  1.97e-06,  2.03e-06,  nan ],
	[  7800,  108.46,  1.12,  125.72,  0.97,  46.13,   2.64,  22.90,   5.32,  1.82e-06,  1.82e-06,  1.88e-06,  nan ],
	[  7900,  106.97,  1.17,  128.30,  0.97,  46.65,   2.68,  22.91,   5.45,  1.82e-06,  1.92e-06,  1.82e-06,  nan ],
	[  8000,  106.58,  1.20,  125.04,  1.02,  46.22,   2.77,  23.06,   5.55,  1.95e-06,  1.92e-06,  1.95e-06,  nan ],
	[  8100,  106.53,  1.23,  132.57,  0.99,  47.19,   2.78,  22.52,   5.83,  1.87e-06,  1.90e-06,  1.96e-06,  nan ],
	[  8200,  105.98,  1.27,  128.94,  1.04,  40.76,   3.30,  22.43,   6.00,  1.79e-06,  1.79e-06,  1.73e-06,  nan ],
	[  8300,  107.49,  1.28,  130.00,  1.06,  40.47,   3.41,  23.14,   5.95,  2.35e-06,  2.32e-06,  2.24e-06,  nan ],
	[  8400,  104.70,  1.35,  131.05,  1.08,  40.81,   3.46,  22.56,   6.26,  1.83e-06,  1.80e-06,  1.80e-06,  nan ],
	[  8500,  105.64,  1.37,  131.03,  1.10,  41.20,   3.51,  22.65,   6.38,  2.01e-06,  2.13e-06,  2.07e-06,  nan ],
	[  8600,  104.99,  1.41,  130.22,  1.14,  41.66,   3.55,  22.99,   6.43,  1.73e-06,  1.70e-06,  1.76e-06,  nan ],
	[  8700,  104.49,  1.45,  132.24,  1.14,  41.80,   3.62,  22.11,   6.85,  1.96e-06,  1.99e-06,  1.91e-06,  nan ],
	[  8800,  103.32,  1.50,  130.72,  1.18,  42.31,   3.66,  22.25,   6.96,  1.97e-06,  1.91e-06,  1.97e-06,  nan ],
	[  8900,  102.62,  1.54,  131.49,  1.20,  42.77,   3.70,  21.90,   7.24,  1.92e-06,  1.89e-06,  1.89e-06,  nan ],
	[  9000,  104.05,  1.56,  131.82,  1.23,  42.99,   3.77,  22.87,   7.09,  2.12e-06,  1.95e-06,  1.95e-06,  nan ],
	[ 10000,  102.79,  1.95,  134.06,  1.49,  47.61,   4.20,  23.07,   8.67,  2.32e-06,  2.34e-06,  2.37e-06,  nan ],
	[ 12000,  103.79,  2.77,  139.35,  2.07,  46.40,   6.21,  22.99,  12.53,  2.20e-06,  2.36e-06,  2.20e-06,  nan ],
	[ 14000,  109.63,  3.58,  141.79,  2.76,  47.11,   8.32,  23.63,  16.59,  2.69e-06,  2.86e-06,  2.93e-06,  nan ],
	[ 16000,  111.07,  4.61,  139.10,  3.68,  47.04,  10.89,  23.11,  22.15,  2.72e-06,  2.69e-06,  2.66e-06,  nan ],
	[ 18000,  108.86,  5.95,  144.45,  4.49,  46.56,  13.92,  25.10,  25.81,  2.63e-06,  2.77e-06,  2.66e-06,  nan ],
	[ 20000,  110.47,  7.24,  147.04,  5.44,  47.46,  16.86,  24.23,  33.02,  2.93e-06,  2.95e-06,  3.03e-06,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/zgeev.txt
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# numactl --interleave=all ../testing/testing_zgeev -RN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_zgeev -RN -N 123 -N 1234 --range 12000:20000:2000
zgeev_RN = array([
	[    10,    0.00,    0.00,  0.00e+00,  nan ],
	[    20,    0.00,    0.00,  0.00e+00,  nan ],
	[    30,    0.00,    0.00,  0.00e+00,  nan ],
	[    40,    0.00,    0.00,  1.28e-15,  nan ],
	[    50,    0.00,    0.00,  1.40e-15,  nan ],
	[    60,    0.00,    0.00,  3.47e-15,  nan ],
	[    70,    0.01,    0.01,  3.67e-15,  nan ],
	[    80,    0.01,    0.01,  1.38e-15,  nan ],
	[    90,    0.01,    0.01,  1.77e-15,  nan ],
	[   100,    0.01,    0.02,  1.72e-15,  nan ],
	[   200,    0.08,    0.08,  2.36e-15,  nan ],
	[   300,    0.17,    0.17,  2.82e-15,  nan ],
	[   400,    0.30,    0.29,  2.81e-15,  nan ],
	[   500,    0.46,    0.44,  3.09e-15,  nan ],
	[   600,    0.85,    0.85,  3.47e-15,  nan ],
	[   700,    1.08,    1.04,  3.46e-15,  nan ],
	[   800,    1.35,    1.31,  4.08e-15,  nan ],
	[   900,    1.63,    1.54,  3.65e-15,  nan ],
	[  1000,    1.88,    1.83,  3.68e-15,  nan ],
	[  2000,    6.86,    5.86,  4.19e-15,  nan ],
	[  3000,   20.07,   16.63,  5.50e-15,  nan ],
	[  4000,   35.84,   27.79,  5.69e-15,  nan ],
	[  5000,   56.11,   41.93,  5.80e-15,  nan ],
	[  6000,   99.60,   76.57,  6.41e-15,  nan ],
	[  7000,  137.87,  107.21,  7.04e-15,  nan ],
	[  8000,  185.42,  132.76,  6.88e-15,  nan ],
	[  9000,  234.22,  168.45,  7.77e-15,  nan ],
	[ 10000,  295.74,  201.80,  7.22e-15,  nan ],
	[ 12000, nan, 299.54, nan, nan ],
	[ 14000, nan, 415.56, nan, nan ],
	[ 16000, nan, 576.25, nan, nan ],
	[ 18000, nan, 747.18, nan, nan ],
	[ 20000, nan, 964.94, nan, nan ],
])

# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# error: row has 3 fields; first row had 5 fields
# numactl --interleave=all ../testing/testing_zgeev -RV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_zgeev -RV -N 123 -N 1234 --range 12000:20000:2000
zgeev_RV = array([
	[    10,     0.00,    0.00,  0.00e+00,  nan ],
	[    20,     0.00,    0.00,  0.00e+00,  nan ],
	[    30,     0.00,    0.00,  0.00e+00,  nan ],
	[    40,     0.00,    0.01,  1.28e-15,  nan ],
	[    50,     0.00,    0.01,  1.35e-15,  nan ],
	[    60,     0.01,    0.01,  3.47e-15,  nan ],
	[    70,     0.01,    0.01,  3.67e-15,  nan ],
	[    80,     0.01,    0.02,  1.55e-15,  nan ],
	[    90,     0.02,    0.02,  1.97e-15,  nan ],
	[   100,     0.02,    0.04,  1.70e-15,  nan ],
	[   200,     0.12,    0.12,  2.33e-15,  nan ],
	[   300,     0.25,    0.26,  2.75e-15,  nan ],
	[   400,     0.43,    0.41,  2.56e-15,  nan ],
	[   500,     0.71,    0.61,  3.13e-15,  nan ],
	[   600,     1.49,    0.99,  3.69e-15,  nan ],
	[   700,     1.60,    1.26,  3.59e-15,  nan ],
	[   800,     2.60,    1.68,  4.02e-15,  nan ],
	[   900,     3.28,    2.76,  3.73e-15,  nan ],
	[  1000,     4.09,    3.07,  3.70e-15,  nan ],
	[  2000,    18.73,    8.39,  4.07e-15,  nan ],
	[  3000,    50.12,   22.54,  5.47e-15,  nan ],
	[  4000,    95.01,   40.09,  5.79e-15,  nan ],
	[  5000,   166.26,   64.27,  5.72e-15,  nan ],
	[  6000,   285.87,  112.91,  6.41e-15,  nan ],
	[  7000,   445.49,  151.60,  7.18e-15,  nan ],
	[  8000,   606.41,  203.58,  6.69e-15,  nan ],
	[  9000,   828.76,  255.29,  7.84e-15,  nan ],
	[ 10000,  1113.11,  341.79,  7.08e-15,  nan ],
	[ 12000, nan, 538.92, nan, nan ],
	[ 14000, nan, 720.48, nan, nan ],
	[ 16000, nan, 1050.03, nan, nan ],
	[ 18000, nan, 1423.25, nan, nan ],
	[ 20000, nan, 1819.30, nan, nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/zgeqrf.txt
# numactl --interleave=all ../testing/testing_zgeqrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
zgeqrf = array([
	[    10,     10,    0.84,    0.00,     0.08,   0.00,  nan ],
	[    20,     20,    1.75,    0.00,     0.66,   0.00,  nan ],
	[    30,     30,    3.13,    0.00,     1.73,   0.00,  nan ],
	[    40,     40,    4.07,    0.00,     0.87,   0.00,  nan ],
	[    50,     50,    4.95,    0.00,     1.62,   0.00,  nan ],
	[    60,     60,    5.51,    0.00,     2.35,   0.00,  nan ],
	[    70,     70,    5.99,    0.00,     1.71,   0.00,  nan ],
	[    80,     80,    6.30,    0.00,     2.68,   0.00,  nan ],
	[    90,     90,    6.70,    0.00,     3.10,   0.00,  nan ],
	[   100,    100,    9.88,    0.00,     4.42,   0.00,  nan ],
	[   200,    200,   26.15,    0.00,    14.37,   0.00,  nan ],
	[   300,    300,   44.81,    0.00,    29.72,   0.00,  nan ],
	[   400,    400,   49.16,    0.01,    45.61,   0.01,  nan ],
	[   500,    500,   66.11,    0.01,    63.90,   0.01,  nan ],
	[   600,    600,   72.66,    0.02,    83.33,   0.01,  nan ],
	[   700,    700,   85.75,    0.02,   100.08,   0.02,  nan ],
	[   800,    800,   97.57,    0.03,   123.16,   0.02,  nan ],
	[   900,    900,   84.26,    0.05,   141.83,   0.03,  nan ],
	[  1000,   1000,   93.41,    0.06,   163.92,   0.03,  nan ],
	[  2000,   2000,  127.35,    0.34,   386.23,   0.11,  nan ],
	[  3000,   3000,  150.06,    0.96,   597.52,   0.24,  nan ],
	[  4000,   4000,  153.89,    2.22,   747.20,   0.46,  nan ],
	[  5000,   5000,  160.54,    4.15,   777.34,   0.86,  nan ],
	[  6000,   6000,  163.91,    7.03,   884.85,   1.30,  nan ],
	[  7000,   7000,  173.88,   10.52,   951.74,   1.92,  nan ],
	[  8000,   8000,  180.60,   15.12,   982.49,   2.78,  nan ],
	[  9000,   9000,  165.75,   23.46,  1010.42,   3.85,  nan ],
	[ 10000,  10000,  266.60,   20.01,  1025.59,   5.20,  nan ],
	[ 12000,  12000,  274.72,   33.55,  1059.70,   8.70,  nan ],
	[ 14000,  14000,  274.48,   53.33,  1064.07,  13.76,  nan ],
	[ 16000,  16000,  277.98,   78.60,  1086.31,  20.11,  nan ],
	[ 18000,  18000,  278.30,  111.78,  1052.45,  29.56,  nan ],
	[ 20000,  20000,  286.76,  148.80,  1085.36,  39.31,  nan ],
])

# numactl --interleave=all ../testing/testing_zgeqrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgeqrf_gpu = array([
	[    10,     10,  nan,  nan,     0.01,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.05,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.15,   0.00,  nan ],
	[    40,     40,  nan,  nan,     0.33,   0.00,  nan ],
	[    50,     50,  nan,  nan,     0.61,   0.00,  nan ],
	[    60,     60,  nan,  nan,     0.98,   0.00,  nan ],
	[    70,     70,  nan,  nan,     2.25,   0.00,  nan ],
	[    80,     80,  nan,  nan,     3.22,   0.00,  nan ],
	[    90,     90,  nan,  nan,     3.56,   0.00,  nan ],
	[   100,    100,  nan,  nan,     2.72,   0.00,  nan ],
	[   200,    200,  nan,  nan,    11.40,   0.00,  nan ],
	[   300,    300,  nan,  nan,    24.92,   0.01,  nan ],
	[   400,    400,  nan,  nan,    39.85,   0.01,  nan ],
	[   500,    500,  nan,  nan,    55.79,   0.01,  nan ],
	[   600,    600,  nan,  nan,    72.32,   0.02,  nan ],
	[   700,    700,  nan,  nan,    85.06,   0.02,  nan ],
	[   800,    800,  nan,  nan,   101.58,   0.03,  nan ],
	[   900,    900,  nan,  nan,   124.23,   0.03,  nan ],
	[  1000,   1000,  nan,  nan,   143.62,   0.04,  nan ],
	[  2000,   2000,  nan,  nan,   339.13,   0.13,  nan ],
	[  3000,   3000,  nan,  nan,   555.69,   0.26,  nan ],
	[  4000,   4000,  nan,  nan,   701.53,   0.49,  nan ],
	[  5000,   5000,  nan,  nan,   769.41,   0.87,  nan ],
	[  6000,   6000,  nan,  nan,   795.39,   1.45,  nan ],
	[  7000,   7000,  nan,  nan,   877.31,   2.09,  nan ],
	[  8000,   8000,  nan,  nan,   972.67,   2.81,  nan ],
	[  9000,   9000,  nan,  nan,   999.18,   3.89,  nan ],
	[ 10000,  10000,  nan,  nan,  1023.31,   5.21,  nan ],
	[ 12000,  12000,  nan,  nan,  1062.99,   8.67,  nan ],
	[ 14000,  14000,  nan,  nan,  1080.24,  13.55,  nan ],
	[ 16000,  16000,  nan,  nan,  1098.97,  19.88,  nan ],
	[ 18000,  18000,  nan,  nan,  1061.23,  29.31,  nan ],
	[ 20000,  20000,  nan,  nan,  1074.06,  39.73,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/zgesvd.txt
# numactl --interleave=all ../testing/testing_zgesvd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_zgesvd -UN -VN -N 123 -N 1234 --range 12000:20000:2000
zgesvd_UN = array([
	[ nan,      10,      10,    0.00,     0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,     0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,     0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,     0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,     0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,     0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,     0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,     0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,     0.00,  0.00e+00 ],
	[ nan,     100,     100,    0.00,     0.00,  0.00e+00 ],
	[ nan,     200,     200,    0.01,     0.02,  2.36e-16 ],
	[ nan,     300,     300,    0.02,     0.04,  2.77e-16 ],
	[ nan,     400,     400,    0.04,     0.07,  3.99e-16 ],
	[ nan,     500,     500,    0.06,     0.11,  2.76e-16 ],
	[ nan,     600,     600,    0.09,     0.15,  6.17e-16 ],
	[ nan,     700,     700,    0.12,     0.20,  5.03e-16 ],
	[ nan,     800,     800,    0.16,     0.26,  4.48e-16 ],
	[ nan,     900,     900,    0.21,     0.32,  5.70e-16 ],
	[ nan,    1000,    1000,    0.27,     0.40,  5.38e-16 ],
	[ nan,    2000,    2000,    1.27,     1.71,  5.96e-16 ],
	[ nan,    3000,    3000,    5.07,     4.48,  1.02e-15 ],
	[ nan,    4000,    4000,   12.76,     9.25,  9.72e-16 ],
	[ nan,    5000,    5000,   27.12,    16.48,  1.19e-15 ],
	[ nan,    6000,    6000,   44.28,    26.99,  1.48e-15 ],
	[ nan,    7000,    7000,   71.16,    40.66,  9.95e-16 ],
	[ nan,    8000,    8000,  111.98,    59.45,  1.22e-15 ],
	[ nan,    9000,    9000,  152.44,    82.07,  1.08e-15 ],
	[ nan,   10000,   10000,  203.27,   113.26,  1.22e-15 ],
	[ nan,     300,     100,    0.00,     0.00,  0.00e+00 ],
	[ nan,     600,     200,    0.01,     0.02,  2.04e-16 ],
	[ nan,     900,     300,    0.03,     0.05,  2.02e-16 ],
	[ nan,    1200,     400,    0.05,     0.09,  2.94e-16 ],
	[ nan,    1500,     500,    0.08,     0.14,  3.24e-16 ],
	[ nan,    1800,     600,    0.11,     0.19,  3.54e-16 ],
	[ nan,    2100,     700,    0.16,     0.26,  2.70e-16 ],
	[ nan,    2400,     800,    0.21,     0.34,  4.56e-16 ],
	[ nan,    2700,     900,    0.29,     0.45,  2.80e-16 ],
	[ nan,    3000,    1000,    0.37,     0.56,  2.69e-16 ],
	[ nan,    6000,    2000,    3.05,     2.75,  4.35e-16 ],
	[ nan,    9000,    3000,   24.32,     8.16,  6.77e-16 ],
	[ nan,   12000,    4000,   56.81,    16.15,  6.51e-16 ],
	[ nan,   15000,    5000,  107.24,    29.26,  8.00e-16 ],
	[ nan,   18000,    6000,  180.00,    48.59,  7.58e-16 ],
	[ nan,   21000,    7000,  283.60,    73.85,  7.59e-16 ],
	[ nan,   24000,    8000,  424.47,   109.21,  1.35e-15 ],
	[ nan,   27000,    9000,  583.49,   152.69,  1.40e-15 ],
	[ nan,     100,     300,    0.00,     0.00,  0.00e+00 ],
	[ nan,     200,     600,    0.02,     0.03,  2.25e-16 ],
	[ nan,     300,     900,    0.03,     0.06,  2.46e-16 ],
	[ nan,     400,    1200,    0.06,     0.09,  2.29e-16 ],
	[ nan,     500,    1500,    0.09,     0.14,  2.07e-16 ],
	[ nan,     600,    1800,    0.13,     0.20,  2.78e-16 ],
	[ nan,     700,    2100,    0.17,     0.27,  2.58e-16 ],
	[ nan,     800,    2400,    0.23,     0.36,  3.21e-16 ],
	[ nan,     900,    2700,    0.30,     0.45,  3.33e-16 ],
	[ nan,    1000,    3000,    0.38,     0.55,  3.01e-16 ],
	[ nan,    2000,    6000,    2.32,     2.71,  5.72e-16 ],
	[ nan,    3000,    9000,    8.04,     7.51,  6.61e-16 ],
	[ nan,    4000,   12000,   21.06,    16.10,  4.81e-16 ],
	[ nan,    5000,   15000,   38.06,    29.42,  4.59e-16 ],
	[ nan,    6000,   18000,   65.91,    49.10,  6.95e-16 ],
	[ nan,    7000,   21000,  105.21,    74.99,  7.00e-16 ],
	[ nan,    8000,   24000,  170.48,   114.13,  1.45e-15 ],
	[ nan,    9000,   27000,  221.46,   157.55,  1.04e-15 ],
	[ nan,   10000,     100,    0.04,     0.04,  0.00e+00 ],
	[ nan,   20000,     200,    0.13,     0.14,  1.17e-16 ],
	[ nan,   30000,     300,    0.32,     0.34,  8.71e-17 ],
	[ nan,   40000,     400,    0.88,     0.94,  1.21e-16 ],
	[ nan,   50000,     500,    1.41,     1.50,  2.40e-16 ],
	[ nan,   60000,     600,    2.12,     2.27,  9.49e-17 ],
	[ nan,   70000,     700,    3.00,     3.17,  1.07e-16 ],
	[ nan,   80000,     800,    4.07,     4.54,  1.44e-16 ],
	[ nan,   90000,     900,    6.16,     6.40,  1.16e-16 ],
	[ nan,  100000,    1000,    7.75,     8.03,  9.05e-17 ],
	[ nan,  200000,    2000,   47.50,    46.25,  1.32e-16 ],
	[ nan,     100,   10000,    0.03,     0.03,  0.00e+00 ],
	[ nan,     200,   20000,    0.16,     0.18,  9.56e-17 ],
	[ nan,     300,   30000,    0.44,     0.51,  9.92e-17 ],
	[ nan,     400,   40000,    0.94,     1.06,  1.12e-16 ],
	[ nan,     500,   50000,    1.28,     1.79,  1.33e-16 ],
	[ nan,     600,   60000,    2.12,     2.40,  9.52e-17 ],
	[ nan,     700,   70000,    3.24,     3.69,  3.34e-16 ],
	[ nan,     800,   80000,    6.45,     5.84,  1.23e-16 ],
	[ nan,     900,   90000,    5.89,     7.65,  1.10e-16 ],
	[ nan,    1000,  100000,    7.64,     8.32,  9.76e-17 ],
	[ nan,    2000,  200000,   51.61,    53.09,  1.49e-16 ],
	[ nan,   12000,   12000,     nan,   205.12,       nan ],
	[ nan,   14000,   14000,     nan,   302.65,       nan ],
	[ nan,   16000,   16000,     nan,   459.59,       nan ],
	[ nan,   18000,   18000,     nan,   726.86,       nan ],
	[ nan,   20000,   20000,     nan,  1051.32,       nan ],
])

# numactl --interleave=all ../testing/testing_zgesvd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_zgesvd -US -VS -N 123 -N 1234 --range 12000:20000:2000
zgesvd_US = array([
	[ nan,     10,     10,     0.00,     0.00,  0.00e+00 ],
	[ nan,     20,     20,     0.00,     0.00,  0.00e+00 ],
	[ nan,     30,     30,     0.00,     0.00,  0.00e+00 ],
	[ nan,     40,     40,     0.00,     0.00,  0.00e+00 ],
	[ nan,     50,     50,     0.01,     0.01,  0.00e+00 ],
	[ nan,     60,     60,     0.01,     0.01,  0.00e+00 ],
	[ nan,     70,     70,     0.01,     0.01,  0.00e+00 ],
	[ nan,     80,     80,     0.01,     0.02,  0.00e+00 ],
	[ nan,     90,     90,     0.02,     0.02,  0.00e+00 ],
	[ nan,    100,    100,     0.02,     0.02,  0.00e+00 ],
	[ nan,    200,    200,     0.03,     0.05,  7.77e-16 ],
	[ nan,    300,    300,     0.07,     0.11,  9.83e-16 ],
	[ nan,    400,    400,     0.13,     0.18,  9.80e-16 ],
	[ nan,    500,    500,     0.21,     0.28,  1.50e-15 ],
	[ nan,    600,    600,     0.31,     0.40,  1.31e-15 ],
	[ nan,    700,    700,     0.48,     0.58,  1.50e-15 ],
	[ nan,    800,    800,     0.44,     0.60,  1.35e-15 ],
	[ nan,    900,    900,     0.58,     0.73,  1.76e-15 ],
	[ nan,   1000,   1000,     0.75,     0.93,  1.39e-15 ],
	[ nan,   2000,   2000,     4.05,     5.23,  2.53e-15 ],
	[ nan,   3000,   3000,    12.35,    11.77,  2.67e-15 ],
	[ nan,   4000,   4000,    27.15,    23.59,  2.77e-15 ],
	[ nan,   5000,   5000,    51.33,    42.17,  2.98e-15 ],
	[ nan,   6000,   6000,    84.77,    67.41,  2.87e-15 ],
	[ nan,   7000,   7000,   134.19,   102.91,  3.67e-15 ],
	[ nan,   8000,   8000,   198.95,   152.55,  3.65e-15 ],
	[ nan,   9000,   9000,   274.63,   203.97,  3.68e-15 ],
	[ nan,  10000,  10000,   360.54,   269.34,  3.72e-15 ],
	[ nan,    300,    100,     0.03,     0.03,  0.00e+00 ],
	[ nan,    600,    200,     0.04,     0.05,  1.33e-15 ],
	[ nan,    900,    300,     0.09,     0.11,  1.58e-15 ],
	[ nan,   1200,    400,     0.17,     0.20,  1.68e-15 ],
	[ nan,   1500,    500,     0.27,     0.32,  1.81e-15 ],
	[ nan,   1800,    600,     0.40,     0.46,  1.86e-15 ],
	[ nan,   2100,    700,     0.62,     0.69,  1.71e-15 ],
	[ nan,   2400,    800,     0.82,     0.91,  1.85e-15 ],
	[ nan,   2700,    900,     1.10,     1.20,  1.78e-15 ],
	[ nan,   3000,   1000,     1.43,     1.56,  2.04e-15 ],
	[ nan,   6000,   2000,     8.38,     8.35,  2.69e-15 ],
	[ nan,   9000,   3000,    26.67,    24.44,  2.86e-15 ],
	[ nan,  12000,   4000,    57.69,    50.96,  3.48e-15 ],
	[ nan,  15000,   5000,   128.03,    98.29,  3.53e-15 ],
	[ nan,  18000,   6000,   184.48,   154.75,  3.81e-15 ],
	[ nan,  21000,   7000,   293.05,   246.51,  3.82e-15 ],
	[ nan,  24000,   8000,   432.63,   352.15,  3.89e-15 ],
	[ nan,  27000,   9000,   622.29,   507.64,  3.87e-15 ],
	[ nan,    100,    300,     0.03,     0.02,  9.55e-16 ],
	[ nan,    200,    600,     0.08,     0.09,  1.16e-15 ],
	[ nan,    300,    900,     0.23,     0.25,  1.53e-15 ],
	[ nan,    400,   1200,     0.49,     0.55,  1.68e-15 ],
	[ nan,    500,   1500,     0.93,     0.99,  1.73e-15 ],
	[ nan,    600,   1800,     1.55,     1.64,  1.61e-15 ],
	[ nan,    700,   2100,     2.65,     2.75,  1.71e-15 ],
	[ nan,    800,   2400,     4.11,     4.21,  1.86e-15 ],
	[ nan,    900,   2700,     6.18,     6.28,  2.04e-15 ],
	[ nan,   1000,   3000,     8.51,     8.62,  2.15e-15 ],
	[ nan,   2000,   6000,    67.15,    67.41,  2.63e-15 ],
	[ nan,   3000,   9000,   217.67,   218.07,  2.91e-15 ],
	[ nan,   4000,  12000,   524.86,   521.04,  3.23e-15 ],
	[ nan,   5000,  15000,   979.39,   976.14,  3.55e-15 ],
	[ nan,   6000,  18000,  1709.14,  1681.73,  3.79e-15 ],
	[ nan,   7000,  21000,  2641.93,  2636.60,  3.76e-15 ],
	[ nan,  12000,  12000,      nan,   476.02,       nan ],
	[ nan,  14000,  14000,      nan,   727.18,       nan ],
	[ nan,  16000,  16000,      nan,  1068.54,       nan ],
	[ nan,  18000,  18000,      nan,  1534.15,       nan ],
	[ nan,  20000,  20000,      nan,  2138.36,       nan ],
])

# numactl --interleave=all ../testing/testing_zgesdd -UN -VN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_zgesdd -UN -VN -N 123 -N 1234 --range 12000:20000:2000
zgesdd_UN = array([
	[ nan,      10,      10,    0.00,     0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,     0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,     0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,     0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,     0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,     0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,     0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,     0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,     0.00,  0.00e+00 ],
	[ nan,     100,     100,    0.00,     0.00,  0.00e+00 ],
	[ nan,     200,     200,    0.01,     0.02,  2.36e-16 ],
	[ nan,     300,     300,    0.02,     0.04,  2.77e-16 ],
	[ nan,     400,     400,    0.04,     0.07,  3.99e-16 ],
	[ nan,     500,     500,    0.06,     0.11,  2.76e-16 ],
	[ nan,     600,     600,    0.08,     0.15,  6.17e-16 ],
	[ nan,     700,     700,    0.11,     0.20,  5.03e-16 ],
	[ nan,     800,     800,    0.15,     0.26,  4.48e-16 ],
	[ nan,     900,     900,    0.19,     0.34,  5.70e-16 ],
	[ nan,    1000,    1000,    0.25,     0.39,  5.38e-16 ],
	[ nan,    2000,    2000,    1.52,     1.70,  5.96e-16 ],
	[ nan,    3000,    3000,    5.41,     4.51,  1.02e-15 ],
	[ nan,    4000,    4000,   13.92,     9.28,  9.72e-16 ],
	[ nan,    5000,    5000,   25.90,    16.56,  1.19e-15 ],
	[ nan,    6000,    6000,   46.10,    27.14,  1.48e-15 ],
	[ nan,    7000,    7000,   71.24,    40.76,  9.95e-16 ],
	[ nan,    8000,    8000,  121.14,    59.84,  1.22e-15 ],
	[ nan,    9000,    9000,  152.87,    82.33,  1.08e-15 ],
	[ nan,   10000,   10000,  207.36,   113.53,  1.22e-15 ],
	[ nan,     300,     100,    0.00,     0.00,  0.00e+00 ],
	[ nan,     600,     200,    0.01,     0.02,  2.04e-16 ],
	[ nan,     900,     300,    0.03,     0.05,  2.02e-16 ],
	[ nan,    1200,     400,    0.05,     0.09,  2.94e-16 ],
	[ nan,    1500,     500,    0.08,     0.14,  3.24e-16 ],
	[ nan,    1800,     600,    0.12,     0.20,  3.54e-16 ],
	[ nan,    2100,     700,    0.16,     0.27,  2.70e-16 ],
	[ nan,    2400,     800,    0.21,     0.34,  4.56e-16 ],
	[ nan,    2700,     900,    0.30,     0.46,  2.80e-16 ],
	[ nan,    3000,    1000,    0.38,     0.57,  2.69e-16 ],
	[ nan,    6000,    2000,    2.94,     2.79,  4.35e-16 ],
	[ nan,    9000,    3000,   24.20,     7.67,  6.77e-16 ],
	[ nan,   12000,    4000,   55.74,    16.13,  6.51e-16 ],
	[ nan,   15000,    5000,  106.43,    29.37,  1.07e-15 ],
	[ nan,   18000,    6000,  186.68,    48.79,  8.78e-16 ],
	[ nan,   21000,    7000,  286.05,    74.20,  5.84e-16 ],
	[ nan,   24000,    8000,  435.62,   110.07,  7.10e-16 ],
	[ nan,   27000,    9000,  591.54,   152.71,  1.42e-15 ],
	[ nan,     100,     300,    0.00,     0.00,  0.00e+00 ],
	[ nan,     200,     600,    0.02,     0.03,  2.25e-16 ],
	[ nan,     300,     900,    0.04,     0.06,  2.46e-16 ],
	[ nan,     400,    1200,    0.06,     0.10,  2.29e-16 ],
	[ nan,     500,    1500,    0.09,     0.14,  2.07e-16 ],
	[ nan,     600,    1800,    0.13,     0.20,  2.78e-16 ],
	[ nan,     700,    2100,    0.18,     0.28,  2.58e-16 ],
	[ nan,     800,    2400,    0.24,     0.36,  3.21e-16 ],
	[ nan,     900,    2700,    0.31,     0.45,  3.33e-16 ],
	[ nan,    1000,    3000,    0.38,     0.56,  3.01e-16 ],
	[ nan,    2000,    6000,    2.40,     2.73,  5.72e-16 ],
	[ nan,    3000,    9000,    8.12,     7.55,  6.61e-16 ],
	[ nan,    4000,   12000,   22.63,    16.18,  4.81e-16 ],
	[ nan,    5000,   15000,   38.07,    30.06,  4.59e-16 ],
	[ nan,    6000,   18000,   66.16,    49.60,  6.95e-16 ],
	[ nan,    7000,   21000,  120.55,    79.02,  7.00e-16 ],
	[ nan,    8000,   24000,  163.02,   116.92,  1.45e-15 ],
	[ nan,    9000,   27000,  229.13,   156.55,  1.04e-15 ],
	[ nan,   10000,     100,    0.04,     0.04,  0.00e+00 ],
	[ nan,   20000,     200,    0.13,     0.14,  1.17e-16 ],
	[ nan,   30000,     300,    0.31,     0.34,  8.71e-17 ],
	[ nan,   40000,     400,    0.88,     0.94,  1.21e-16 ],
	[ nan,   50000,     500,    1.42,     1.51,  2.40e-16 ],
	[ nan,   60000,     600,    2.15,     2.26,  9.49e-17 ],
	[ nan,   70000,     700,    2.97,     3.23,  1.07e-16 ],
	[ nan,   80000,     800,    4.13,     4.35,  1.44e-16 ],
	[ nan,   90000,     900,    6.16,     6.43,  1.16e-16 ],
	[ nan,  100000,    1000,    7.75,     8.11,  9.05e-17 ],
	[ nan,  200000,    2000,   45.13,    46.32,  1.32e-16 ],
	[ nan,     100,   10000,    0.03,     0.03,  0.00e+00 ],
	[ nan,     200,   20000,    0.12,     0.14,  9.56e-17 ],
	[ nan,     300,   30000,    0.31,     0.37,  9.92e-17 ],
	[ nan,     400,   40000,    0.66,     0.78,  1.12e-16 ],
	[ nan,     500,   50000,    1.23,     1.43,  1.33e-16 ],
	[ nan,     600,   60000,    2.78,     2.39,  9.52e-17 ],
	[ nan,     700,   70000,    4.79,     5.38,  3.34e-16 ],
	[ nan,     800,   80000,    5.26,     6.77,  1.23e-16 ],
	[ nan,     900,   90000,    5.88,     6.42,  1.10e-16 ],
	[ nan,    1000,  100000,    7.68,     8.30,  9.76e-17 ],
	[ nan,    2000,  200000,   51.73,    52.99,  1.49e-16 ],
	[ nan,   12000,   12000,     nan,   205.10,       nan ],
	[ nan,   14000,   14000,     nan,   302.99,       nan ],
	[ nan,   16000,   16000,     nan,   459.61,       nan ],
	[ nan,   18000,   18000,     nan,   726.12,       nan ],
	[ nan,   20000,   20000,     nan,  1051.91,       nan ],
])

# numactl --interleave=all ../testing/testing_zgesdd -US -VS -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 -N 300,100 -N 600,200 -N 900,300 -N 1200,400 -N 1500,500 -N 1800,600 -N 2100,700 -N 2400,800 -N 2700,900 -N 3000,1000 -N 6000,2000 -N 9000,3000 -N 12000,4000 -N 15000,5000 -N 18000,6000 -N 21000,7000 -N 24000,8000 -N 27000,9000 -N 100,300 -N 200,600 -N 300,900 -N 400,1200 -N 500,1500 -N 600,1800 -N 700,2100 -N 800,2400 -N 900,2700 -N 1000,3000 -N 2000,6000 -N 3000,9000 -N 4000,12000 -N 5000,15000 -N 6000,18000 -N 7000,21000 -N 8000,24000 -N 9000,27000 -N 10000,100 -N 20000,200 -N 30000,300 -N 40000,400 -N 50000,500 -N 60000,600 -N 70000,700 -N 80000,800 -N 90000,900 -N 100000,1000 -N 200000,2000 -N 100,10000 -N 200,20000 -N 300,30000 -N 400,40000 -N 500,50000 -N 600,60000 -N 700,70000 -N 800,80000 -N 900,90000 -N 1000,100000 -N 2000,200000 --lapack
# numactl --interleave=all ../testing/testing_zgesdd -US -VS -N 123 -N 1234 --range 12000:20000:2000
zgesdd_US = array([
	[ nan,      10,      10,    0.00,     0.00,  0.00e+00 ],
	[ nan,      20,      20,    0.00,     0.00,  0.00e+00 ],
	[ nan,      30,      30,    0.00,     0.00,  0.00e+00 ],
	[ nan,      40,      40,    0.00,     0.00,  0.00e+00 ],
	[ nan,      50,      50,    0.00,     0.00,  0.00e+00 ],
	[ nan,      60,      60,    0.00,     0.00,  0.00e+00 ],
	[ nan,      70,      70,    0.00,     0.00,  0.00e+00 ],
	[ nan,      80,      80,    0.00,     0.00,  0.00e+00 ],
	[ nan,      90,      90,    0.00,     0.01,  0.00e+00 ],
	[ nan,     100,     100,    0.00,     0.01,  0.00e+00 ],
	[ nan,     200,     200,    0.02,     0.03,  2.55e-16 ],
	[ nan,     300,     300,    0.05,     0.07,  2.04e-16 ],
	[ nan,     400,     400,    0.08,     0.12,  3.05e-16 ],
	[ nan,     500,     500,    0.13,     0.18,  1.73e-16 ],
	[ nan,     600,     600,    0.19,     0.25,  2.89e-16 ],
	[ nan,     700,     700,    0.26,     0.33,  2.73e-16 ],
	[ nan,     800,     800,    0.36,     0.43,  1.86e-16 ],
	[ nan,     900,     900,    0.47,     0.53,  1.40e-16 ],
	[ nan,    1000,    1000,    0.60,     0.65,  2.03e-16 ],
	[ nan,    2000,    2000,    3.64,     2.85,  1.36e-16 ],
	[ nan,    3000,    3000,   12.02,     7.91,  2.55e-16 ],
	[ nan,    4000,    4000,   26.52,    14.53,  1.83e-16 ],
	[ nan,    5000,    5000,   39.45,    24.36,  3.59e-16 ],
	[ nan,    6000,    6000,   67.58,    39.05,  3.93e-16 ],
	[ nan,    7000,    7000,  105.40,    57.86,  1.12e-16 ],
	[ nan,    8000,    8000,  160.90,    83.32,  3.13e-16 ],
	[ nan,    9000,    9000,  221.54,   113.84,  1.69e-16 ],
	[ nan,   10000,   10000,  298.76,   155.25,  1.75e-16 ],
	[ nan,     300,     100,    0.01,     0.01,  0.00e+00 ],
	[ nan,     600,     200,    0.03,     0.04,  2.58e-16 ],
	[ nan,     900,     300,    0.06,     0.08,  2.27e-16 ],
	[ nan,    1200,     400,    0.11,     0.15,  3.01e-16 ],
	[ nan,    1500,     500,    0.18,     0.23,  1.85e-16 ],
	[ nan,    1800,     600,    0.26,     0.34,  3.20e-16 ],
	[ nan,    2100,     700,    0.36,     0.46,  1.88e-16 ],
	[ nan,    2400,     800,    0.49,     0.62,  2.29e-16 ],
	[ nan,    2700,     900,    0.67,     0.82,  1.33e-16 ],
	[ nan,    3000,    1000,    0.84,     1.02,  3.50e-16 ],
	[ nan,    6000,    2000,    6.63,     7.13,  1.23e-16 ],
	[ nan,    9000,    3000,   16.18,    14.80,  1.48e-16 ],
	[ nan,   12000,    4000,   37.43,    31.52,  1.45e-16 ],
	[ nan,   15000,    5000,   72.13,    57.49,  1.34e-16 ],
	[ nan,   18000,    6000,  122.93,    95.44,  1.44e-16 ],
	[ nan,   21000,    7000,  192.75,   146.22,  1.24e-16 ],
	[ nan,   24000,    8000,  284.12,   213.85,  1.18e-16 ],
	[ nan,   27000,    9000,  409.18,   299.23,  1.96e-16 ],
	[ nan,     100,     300,    0.01,     0.01,  0.00e+00 ],
	[ nan,     200,     600,    0.03,     0.04,  2.49e-16 ],
	[ nan,     300,     900,    0.07,     0.09,  2.11e-16 ],
	[ nan,     400,    1200,    0.12,     0.16,  1.93e-16 ],
	[ nan,     500,    1500,    0.19,     0.25,  2.65e-16 ],
	[ nan,     600,    1800,    0.27,     0.36,  1.64e-16 ],
	[ nan,     700,    2100,    0.38,     0.48,  1.68e-16 ],
	[ nan,     800,    2400,    0.51,     0.65,  1.96e-16 ],
	[ nan,     900,    2700,    0.68,     0.82,  1.41e-16 ],
	[ nan,    1000,    3000,    0.86,     1.03,  1.50e-16 ],
	[ nan,    2000,    6000,    5.12,     5.27,  1.55e-16 ],
	[ nan,    3000,    9000,   16.23,    14.76,  4.50e-16 ],
	[ nan,    4000,   12000,   41.48,    32.52,  1.18e-16 ],
	[ nan,    5000,   15000,   72.54,    57.75,  1.33e-16 ],
	[ nan,    6000,   18000,  123.75,    96.73,  4.70e-16 ],
	[ nan,    7000,   21000,  196.11,   150.65,  3.87e-16 ],
	[ nan,    8000,   24000,  287.68,   216.71,  4.97e-16 ],
	[ nan,    9000,   27000,  409.45,   306.23,  4.47e-16 ],
	[ nan,   10000,     100,    0.07,     0.08,  0.00e+00 ],
	[ nan,   20000,     200,    0.30,     0.39,  1.99e-16 ],
	[ nan,   30000,     300,    0.92,     0.98,  4.17e-16 ],
	[ nan,   40000,     400,    2.34,     2.09,  2.35e-16 ],
	[ nan,   50000,     500,    2.51,     4.15,  1.48e-16 ],
	[ nan,   60000,     600,    3.85,     4.17,  1.54e-16 ],
	[ nan,   70000,     700,    5.73,     6.06,  1.90e-16 ],
	[ nan,   80000,     800,    7.92,     8.44,  7.30e-16 ],
	[ nan,   90000,     900,   11.40,    11.93,  1.43e-16 ],
	[ nan,  100000,    1000,   14.80,    15.51,  1.51e-16 ],
	[ nan,  200000,    2000,   93.69,    96.40,  1.28e-16 ],
	[ nan,     100,   10000,    0.05,     0.06,  0.00e+00 ],
	[ nan,     200,   20000,    0.25,     0.29,  2.52e-16 ],
	[ nan,     300,   30000,    0.68,     0.77,  4.22e-16 ],
	[ nan,     400,   40000,    1.45,     1.62,  2.55e-16 ],
	[ nan,     500,   50000,    2.66,     2.97,  1.57e-16 ],
	[ nan,     600,   60000,    4.42,     4.94,  1.58e-16 ],
	[ nan,     700,   70000,    6.74,     7.47,  1.64e-16 ],
	[ nan,     800,   80000,   10.43,    11.24,  4.60e-16 ],
	[ nan,     900,   90000,   12.06,    12.75,  4.05e-16 ],
	[ nan,    1000,  100000,   16.00,    16.80,  1.57e-16 ],
	[ nan,    2000,  200000,  105.10,   107.09,  3.57e-16 ],
	[ nan,   12000,   12000,     nan,   271.00,       nan ],
	[ nan,   14000,   14000,     nan,   401.50,       nan ],
	[ nan,   16000,   16000,     nan,   603.93,       nan ],
	[ nan,   18000,   18000,     nan,   922.22,       nan ],
	[ nan,   20000,   20000,     nan,  1299.06,       nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/zgetrf.txt
# numactl --interleave=all ../testing/testing_zgetrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
zgetrf = array([
	[    10,     10,    0.26,   0.00,     0.32,   0.00,  nan ],
	[    20,     20,    0.64,   0.00,     0.87,   0.00,  nan ],
	[    30,     30,    1.42,   0.00,     1.79,   0.00,  nan ],
	[    40,     40,    2.25,   0.00,     2.57,   0.00,  nan ],
	[    50,     50,    2.27,   0.00,     2.59,   0.00,  nan ],
	[    60,     60,    3.11,   0.00,     3.33,   0.00,  nan ],
	[    70,     70,    5.35,   0.00,     0.92,   0.00,  nan ],
	[    80,     80,    7.31,   0.00,     1.39,   0.00,  nan ],
	[    90,     90,    8.31,   0.00,     1.78,   0.00,  nan ],
	[   100,    100,    9.95,   0.00,     2.30,   0.00,  nan ],
	[   200,    200,   28.20,   0.00,     9.17,   0.00,  nan ],
	[   300,    300,   45.06,   0.00,    19.42,   0.00,  nan ],
	[   400,    400,   63.50,   0.00,    30.62,   0.01,  nan ],
	[   500,    500,   66.47,   0.01,    43.57,   0.01,  nan ],
	[   600,    600,   76.17,   0.01,    56.51,   0.01,  nan ],
	[   700,    700,   93.78,   0.01,    71.39,   0.01,  nan ],
	[   800,    800,   73.41,   0.02,    86.27,   0.02,  nan ],
	[   900,    900,   91.91,   0.02,    90.85,   0.02,  nan ],
	[  1000,   1000,   60.89,   0.04,   115.31,   0.02,  nan ],
	[  2000,   2000,  111.82,   0.19,   269.96,   0.08,  nan ],
	[  3000,   3000,  145.80,   0.49,   521.67,   0.14,  nan ],
	[  4000,   4000,  204.33,   0.84,   629.99,   0.27,  nan ],
	[  5000,   5000,  210.19,   1.59,   687.77,   0.48,  nan ],
	[  6000,   6000,  206.22,   2.79,   782.66,   0.74,  nan ],
	[  7000,   7000,  267.67,   3.42,   838.74,   1.09,  nan ],
	[  8000,   8000,  271.82,   5.02,   890.31,   1.53,  nan ],
	[  9000,   9000,  252.62,   7.70,   922.73,   2.11,  nan ],
	[ 10000,  10000,  276.02,   9.66,   956.23,   2.79,  nan ],
	[ 12000,  12000,  232.82,  19.79,  1003.32,   4.59,  nan ],
	[ 14000,  14000,  256.65,  28.51,  1034.01,   7.08,  nan ],
	[ 16000,  16000,  278.43,  39.23,  1059.97,  10.30,  nan ],
	[ 18000,  18000,  286.40,  54.30,  1067.07,  14.57,  nan ],
	[ 20000,  20000,  289.66,  73.65,  1082.21,  19.71,  nan ],
])

# numactl --interleave=all ../testing/testing_zgetrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zgetrf_gpu = array([
	[    10,     10,  nan,  nan,     0.07,   0.00,  nan ],
	[    20,     20,  nan,  nan,     0.36,   0.00,  nan ],
	[    30,     30,  nan,  nan,     0.90,   0.00,  nan ],
	[    40,     40,  nan,  nan,     1.60,   0.00,  nan ],
	[    50,     50,  nan,  nan,     1.75,   0.00,  nan ],
	[    60,     60,  nan,  nan,     2.67,   0.00,  nan ],
	[    70,     70,  nan,  nan,     0.67,   0.00,  nan ],
	[    80,     80,  nan,  nan,     1.01,   0.00,  nan ],
	[    90,     90,  nan,  nan,     1.36,   0.00,  nan ],
	[   100,    100,  nan,  nan,     1.80,   0.00,  nan ],
	[   200,    200,  nan,  nan,     7.93,   0.00,  nan ],
	[   300,    300,  nan,  nan,    18.87,   0.00,  nan ],
	[   400,    400,  nan,  nan,    32.66,   0.01,  nan ],
	[   500,    500,  nan,  nan,    51.24,   0.01,  nan ],
	[   600,    600,  nan,  nan,    67.59,   0.01,  nan ],
	[   700,    700,  nan,  nan,    89.08,   0.01,  nan ],
	[   800,    800,  nan,  nan,   110.94,   0.01,  nan ],
	[   900,    900,  nan,  nan,   133.24,   0.01,  nan ],
	[  1000,   1000,  nan,  nan,   161.17,   0.02,  nan ],
	[  2000,   2000,  nan,  nan,   401.40,   0.05,  nan ],
	[  3000,   3000,  nan,  nan,   630.06,   0.11,  nan ],
	[  4000,   4000,  nan,  nan,   757.28,   0.23,  nan ],
	[  5000,   5000,  nan,  nan,   784.64,   0.42,  nan ],
	[  6000,   6000,  nan,  nan,   883.64,   0.65,  nan ],
	[  7000,   7000,  nan,  nan,   944.57,   0.97,  nan ],
	[  8000,   8000,  nan,  nan,   995.43,   1.37,  nan ],
	[  9000,   9000,  nan,  nan,   969.28,   2.01,  nan ],
	[ 10000,  10000,  nan,  nan,  1010.49,   2.64,  nan ],
	[ 12000,  12000,  nan,  nan,  1065.84,   4.32,  nan ],
	[ 14000,  14000,  nan,  nan,  1103.78,   6.63,  nan ],
	[ 16000,  16000,  nan,  nan,  1132.22,   9.65,  nan ],
	[ 18000,  18000,  nan,  nan,  1133.64,  13.72,  nan ],
	[ 20000,  20000,  nan,  nan,  1129.45,  18.89,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/zheevd.txt
# numactl --interleave=all ../testing/testing_zheevd -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_zheevd -JN -N 123 -N 1234 --range 12000:20000:2000
zheevd_JN = array([
	[    10,   0.00,    0.00 ],
	[    20,   0.00,    0.00 ],
	[    30,   0.00,    0.00 ],
	[    40,   0.00,    0.00 ],
	[    50,   0.00,    0.00 ],
	[    60,   0.00,    0.00 ],
	[    70,   0.00,    0.00 ],
	[    80,   0.00,    0.00 ],
	[    90,   0.00,    0.00 ],
	[   100,   0.00,    0.00 ],
	[   200,   0.01,    0.01 ],
	[   300,   0.01,    0.01 ],
	[   400,   0.02,    0.02 ],
	[   500,   0.04,    0.04 ],
	[   600,   0.05,    0.05 ],
	[   700,   0.07,    0.07 ],
	[   800,   0.10,    0.10 ],
	[   900,   0.13,    0.13 ],
	[  1000,   0.16,    0.16 ],
	[  2000,   0.80,    0.82 ],
	[  3000,   2.51,    2.03 ],
	[  4000,   6.04,    3.90 ],
	[  5000,   9.41,    6.62 ],
	[  6000,  15.73,   10.26 ],
	[  7000,  23.73,   15.06 ],
	[  8000,  36.43,   21.08 ],
	[  9000,  48.41,   28.74 ],
	[ 10000,  63.89,   37.79 ],
	[ 12000,    nan,   61.61 ],
	[ 14000,    nan,   93.11 ],
	[ 16000,    nan,  135.60 ],
	[ 18000,    nan,  189.18 ],
	[ 20000,    nan,  258.83 ],
])

# numactl --interleave=all ../testing/testing_zheevd -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000 --lapack
# numactl --interleave=all ../testing/testing_zheevd -JV -N 123 -N 1234 --range 12000:20000:2000
zheevd_JV = array([
	[    10,    0.00,    0.00 ],
	[    20,    0.00,    0.00 ],
	[    30,    0.00,    0.00 ],
	[    40,    0.00,    0.00 ],
	[    50,    0.00,    0.00 ],
	[    60,    0.00,    0.00 ],
	[    70,    0.00,    0.00 ],
	[    80,    0.00,    0.00 ],
	[    90,    0.00,    0.00 ],
	[   100,    0.00,    0.00 ],
	[   200,    0.01,    0.01 ],
	[   300,    0.02,    0.02 ],
	[   400,    0.04,    0.03 ],
	[   500,    0.06,    0.05 ],
	[   600,    0.09,    0.07 ],
	[   700,    0.13,    0.09 ],
	[   800,    0.17,    0.12 ],
	[   900,    0.23,    0.16 ],
	[  1000,    0.30,    0.20 ],
	[  2000,    1.57,    0.95 ],
	[  3000,    5.40,    2.39 ],
	[  4000,   10.83,    4.64 ],
	[  5000,   20.30,    7.91 ],
	[  6000,   32.82,   12.42 ],
	[  7000,   52.75,   18.38 ],
	[  8000,   63.81,   25.90 ],
	[  9000,   82.38,   35.02 ],
	[ 10000,  109.63,   46.07 ],
	[ 12000,     nan,   76.29 ],
	[ 14000,     nan,  115.62 ],
	[ 16000,     nan,  168.32 ],
	[ 18000,     nan,  238.85 ],
	[ 20000,     nan,  323.71 ],
])

# numactl --interleave=all ../testing/testing_zheevd_gpu -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_zheevd_gpu -JN -N 123 -N 1234 --range 12000:20000:2000
zheevd_gpu_JN = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.01 ],
	[   400,  nan,    0.02 ],
	[   500,  nan,    0.04 ],
	[   600,  nan,    0.05 ],
	[   700,  nan,    0.08 ],
	[   800,  nan,    0.10 ],
	[   900,  nan,    0.13 ],
	[  1000,  nan,    0.16 ],
	[  2000,  nan,    0.82 ],
	[  3000,  nan,    2.04 ],
	[  4000,  nan,    3.98 ],
	[  5000,  nan,    6.65 ],
	[  6000,  nan,   10.23 ],
	[  7000,  nan,   15.04 ],
	[  8000,  nan,   20.99 ],
	[  9000,  nan,   28.68 ],
	[ 10000,  nan,   37.68 ],
	[ 12000,  nan,   61.37 ],
	[ 14000,  nan,   92.66 ],
	[ 16000,  nan,  135.23 ],
	[ 18000,  nan,  188.62 ],
	[ 20000,  nan,    0.00 ],
])

# numactl --interleave=all ../testing/testing_zheevd_gpu -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:10000:1000
# numactl --interleave=all ../testing/testing_zheevd_gpu -JV -N 123 -N 1234 --range 12000:20000:2000
zheevd_gpu_JV = array([
	[    10,  nan,    0.00 ],
	[    20,  nan,    0.00 ],
	[    30,  nan,    0.00 ],
	[    40,  nan,    0.00 ],
	[    50,  nan,    0.00 ],
	[    60,  nan,    0.00 ],
	[    70,  nan,    0.00 ],
	[    80,  nan,    0.00 ],
	[    90,  nan,    0.00 ],
	[   100,  nan,    0.00 ],
	[   200,  nan,    0.01 ],
	[   300,  nan,    0.02 ],
	[   400,  nan,    0.04 ],
	[   500,  nan,    0.05 ],
	[   600,  nan,    0.07 ],
	[   700,  nan,    0.10 ],
	[   800,  nan,    0.13 ],
	[   900,  nan,    0.17 ],
	[  1000,  nan,    0.24 ],
	[  2000,  nan,    0.97 ],
	[  3000,  nan,    2.35 ],
	[  4000,  nan,    4.58 ],
	[  5000,  nan,    7.77 ],
	[  6000,  nan,   12.29 ],
	[  7000,  nan,   17.88 ],
	[  8000,  nan,   25.17 ],
	[  9000,  nan,   35.09 ],
	[ 10000,  nan,   46.07 ],
	[ 12000,  nan,   75.65 ],
	[ 14000,  nan,  116.57 ],
	[ 16000,  nan,  169.13 ],
	[ 18000,  nan,  239.42 ],
	[ 20000,  nan,    0.00 ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/zheevd_2stage.txt
# numactl --interleave=all ../testing/testing_zheevdx_2stage -JN -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
zheevdx_2stage_JN = array([
	[    10,     10,   0.00 ],
	[    20,     20,   0.00 ],
	[    30,     30,   0.00 ],
	[    40,     40,   0.00 ],
	[    50,     50,   0.00 ],
	[    60,     60,   0.00 ],
	[    70,     70,   0.00 ],
	[    80,     80,   0.00 ],
	[    90,     90,   0.00 ],
	[   100,    100,   0.00 ],
	[   200,    200,   0.01 ],
	[   300,    300,   0.04 ],
	[   400,    400,   0.07 ],
	[   500,    500,   0.10 ],
	[   600,    600,   0.14 ],
	[   700,    700,   0.17 ],
	[   800,    800,   0.20 ],
	[   900,    900,   0.25 ],
	[  1000,   1000,   0.29 ],
	[  2000,   2000,   0.67 ],
	[  3000,   3000,   1.30 ],
	[  4000,   4000,   2.09 ],
	[  5000,   5000,   3.03 ],
	[  6000,   6000,   4.37 ],
	[  7000,   7000,   5.92 ],
	[  8000,   8000,   7.57 ],
	[  9000,   9000,   9.91 ],
	[ 10000,  10000,  12.54 ],
	[ 12000,  12000,  18.96 ],
	[ 14000,  14000,  27.71 ],
	[ 16000,  16000,  39.82 ],
	[ 18000,  18000,  54.75 ],
	[ 20000,  20000,  72.94 ],
])

# numactl --interleave=all ../testing/testing_zheevdx_2stage -JV -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
zheevdx_2stage_JV = array([
	[    10,     10,    0.00 ],
	[    20,     20,    0.00 ],
	[    30,     30,    0.00 ],
	[    40,     40,    0.00 ],
	[    50,     50,    0.00 ],
	[    60,     60,    0.00 ],
	[    70,     70,    0.00 ],
	[    80,     80,    0.00 ],
	[    90,     90,    0.00 ],
	[   100,    100,    0.00 ],
	[   200,    200,    0.01 ],
	[   300,    300,    0.04 ],
	[   400,    400,    0.08 ],
	[   500,    500,    0.12 ],
	[   600,    600,    0.16 ],
	[   700,    700,    0.21 ],
	[   800,    800,    0.25 ],
	[   900,    900,    0.31 ],
	[  1000,   1000,    0.36 ],
	[  2000,   2000,    1.01 ],
	[  3000,   3000,    1.98 ],
	[  4000,   4000,    3.62 ],
	[  5000,   5000,    5.85 ],
	[  6000,   6000,    8.97 ],
	[  7000,   7000,   12.95 ],
	[  8000,   8000,   18.26 ],
	[  9000,   9000,   25.38 ],
	[ 10000,  10000,   33.32 ],
	[ 12000,  12000,   53.75 ],
	[ 14000,  14000,   86.57 ],
	[ 16000,  16000,  125.16 ],
	[ 18000,  18000,  180.23 ],
	[ 20000,  20000,  185.39 ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/zhemv.txt
# numactl --interleave=all ../testing/testing_zhemv -L -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000 --lapack
zhemv_L = array([
	[    10,    0.02,   0.04,   0.03,   0.03,   0.03,   0.03,   0.32,    0.00,  7.12e-16,  3.55e-16,  7.12e-16,  nan ],
	[    11,    0.03,   0.04,   0.04,   0.03,   0.04,   0.03,   0.51,    0.00,  2.28e-16,  2.28e-16,  2.42e-16,  nan ],
	[    12,    0.03,   0.04,   0.05,   0.03,   0.05,   0.03,   0.60,    0.00,  3.99e-16,  4.50e-16,  3.05e-16,  nan ],
	[    13,    0.04,   0.04,   0.05,   0.03,   0.06,   0.03,   0.79,    0.00,  3.06e-16,  5.47e-16,  2.82e-16,  nan ],
	[    14,    0.05,   0.04,   0.06,   0.03,   0.07,   0.03,   0.21,    0.01,  2.84e-16,  3.59e-16,  2.84e-16,  nan ],
	[    15,    0.05,   0.04,   0.07,   0.03,   0.08,   0.02,   0.64,    0.00,  2.65e-16,  2.96e-16,  2.96e-16,  nan ],
	[    16,    0.06,   0.04,   0.08,   0.03,   0.09,   0.02,   0.72,    0.00,  2.48e-16,  4.46e-16,  2.48e-16,  nan ],
	[    17,    0.07,   0.04,   0.09,   0.03,   0.09,   0.03,   1.17,    0.00,  4.67e-16,  7.01e-16,  4.31e-16,  nan ],
	[    18,    0.07,   0.04,   0.10,   0.03,   0.11,   0.03,   1.47,    0.00,  2.21e-16,  4.07e-16,  4.07e-16,  nan ],
	[    19,    0.08,   0.04,   0.12,   0.03,   0.12,   0.03,   1.01,    0.00,  3.74e-16,  4.18e-16,  3.74e-16,  nan ],
	[    20,    0.09,   0.04,   0.13,   0.03,   0.13,   0.03,   1.11,    0.00,  4.19e-16,  4.19e-16,  3.97e-16,  nan ],
	[    21,    0.09,   0.04,   0.14,   0.03,   0.14,   0.03,   1.98,    0.00,  3.49e-16,  4.79e-16,  4.23e-16,  nan ],
	[    22,    0.11,   0.04,   0.14,   0.03,   0.15,   0.03,   2.17,    0.00,  5.11e-16,  4.84e-16,  5.82e-16,  nan ],
	[    23,    0.12,   0.04,   0.16,   0.03,   0.17,   0.03,   1.45,    0.00,  2.18e-16,  3.45e-16,  3.45e-16,  nan ],
	[    24,    0.13,   0.04,   0.18,   0.03,   0.18,   0.03,   1.58,    0.00,  7.55e-16,  3.05e-16,  3.31e-16,  nan ],
	[    25,    0.14,   0.04,   0.19,   0.03,   0.18,   0.03,   1.85,    0.00,  3.18e-16,  3.55e-16,  3.04e-16,  nan ],
	[    26,    0.14,   0.04,   0.20,   0.03,   0.21,   0.03,   1.85,    0.00,  4.32e-16,  3.86e-16,  3.42e-16,  nan ],
	[    27,    0.16,   0.04,   0.22,   0.03,   0.22,   0.03,   1.52,    0.00,  5.62e-16,  3.29e-16,  3.96e-16,  nan ],
	[    28,    0.17,   0.04,   0.23,   0.03,   0.23,   0.03,   1.73,    0.00,  3.86e-16,  4.57e-16,  4.57e-16,  nan ],
	[    29,    0.18,   0.04,   0.24,   0.03,   0.25,   0.03,   1.75,    0.00,  3.87e-16,  4.90e-16,  3.87e-16,  nan ],
	[    30,    0.19,   0.04,   0.25,   0.03,   0.27,   0.03,   1.87,    0.00,  5.30e-16,  4.27e-16,  4.74e-16,  nan ],
	[    31,    0.20,   0.04,   0.29,   0.03,   0.28,   0.03,   1.61,    0.01,  5.13e-16,  4.73e-16,  2.72e-16,  nan ],
	[    32,    0.21,   0.04,   0.30,   0.03,   0.30,   0.03,   2.12,    0.00,  2.48e-16,  4.58e-16,  4.00e-16,  nan ],
	[    33,    0.23,   0.04,   0.23,   0.04,   0.31,   0.03,   2.25,    0.00,  4.44e-16,  4.44e-16,  4.44e-16,  nan ],
	[    34,    0.25,   0.04,   0.25,   0.04,   0.33,   0.03,   2.38,    0.00,  8.93e-16,  4.67e-16,  8.62e-16,  nan ],
	[    35,    0.27,   0.04,   0.27,   0.04,   0.35,   0.03,   2.04,    0.01,  4.09e-16,  4.54e-16,  6.11e-16,  nan ],
	[    36,    0.26,   0.04,   0.28,   0.04,   0.36,   0.03,   2.83,    0.00,  4.41e-16,  4.93e-16,  5.94e-16,  nan ],
	[    37,    0.29,   0.04,   0.31,   0.04,   0.38,   0.03,   2.28,    0.01,  6.07e-16,  4.29e-16,  3.96e-16,  nan ],
	[    38,    0.29,   0.04,   0.32,   0.04,   0.40,   0.03,   3.15,    0.00,  3.85e-16,  5.91e-16,  4.18e-16,  nan ],
	[    39,    0.33,   0.04,   0.33,   0.04,   0.41,   0.03,   2.52,    0.01,  5.76e-16,  3.67e-16,  3.76e-16,  nan ],
	[    40,    0.32,   0.04,   0.36,   0.04,   0.44,   0.03,   2.65,    0.01,  5.02e-16,  4.78e-16,  4.78e-16,  nan ],
	[    41,    0.33,   0.04,   0.37,   0.04,   0.46,   0.03,   2.25,    0.01,  5.48e-16,  5.27e-16,  5.48e-16,  nan ],
	[    42,    0.35,   0.04,   0.38,   0.04,   0.49,   0.03,   2.45,    0.01,  5.67e-16,  6.10e-16,  5.67e-16,  nan ],
	[    43,    0.38,   0.04,   0.40,   0.04,   0.49,   0.03,   2.57,    0.01,  4.13e-16,  5.54e-16,  4.67e-16,  nan ],
	[    44,    0.40,   0.04,   0.37,   0.04,   0.53,   0.03,   2.69,    0.01,  6.66e-16,  4.84e-16,  5.11e-16,  nan ],
	[    45,    0.43,   0.04,   0.43,   0.04,   0.56,   0.03,   2.42,    0.01,  4.47e-16,  4.99e-16,  6.75e-16,  nan ],
	[    46,    0.45,   0.04,   0.47,   0.04,   0.61,   0.03,   2.93,    0.01,  6.19e-16,  6.18e-16,  4.65e-16,  nan ],
	[    47,    0.47,   0.04,   0.48,   0.04,   0.61,   0.03,   3.64,    0.01,  6.76e-16,  7.56e-16,  5.07e-16,  nan ],
	[    48,    0.50,   0.04,   0.50,   0.04,   0.63,   0.03,   3.80,    0.01,  4.68e-16,  5.92e-16,  4.68e-16,  nan ],
	[    49,    0.51,   0.04,   0.52,   0.04,   0.64,   0.03,   3.95,    0.01,  4.59e-16,  4.37e-16,  3.63e-16,  nan ],
	[    50,    0.53,   0.04,   0.54,   0.04,   0.64,   0.03,   3.32,    0.01,  4.02e-16,  4.32e-16,  4.49e-16,  nan ],
	[    51,    0.55,   0.04,   0.57,   0.04,   0.72,   0.03,   3.10,    0.01,  6.23e-16,  6.86e-16,  6.86e-16,  nan ],
	[    52,    0.59,   0.04,   0.56,   0.04,   0.75,   0.03,   3.22,    0.01,  5.84e-16,  4.44e-16,  4.37e-16,  nan ],
	[    53,    0.59,   0.04,   0.58,   0.04,   0.77,   0.03,   3.23,    0.01,  5.40e-16,  5.73e-16,  4.50e-16,  nan ],
	[    54,    0.60,   0.04,   0.62,   0.04,   0.77,   0.03,   4.02,    0.01,  6.71e-16,  5.43e-16,  5.30e-16,  nan ],
	[    55,    0.62,   0.04,   0.64,   0.04,   0.83,   0.03,   3.16,    0.01,  4.66e-16,  4.66e-16,  4.66e-16,  nan ],
	[    56,    0.61,   0.04,   0.64,   0.04,   0.80,   0.03,   3.27,    0.01,  5.11e-16,  4.01e-16,  3.92e-16,  nan ],
	[    57,    0.62,   0.04,   0.67,   0.04,   0.80,   0.03,   4.48,    0.01,  3.94e-16,  3.94e-16,  3.79e-16,  nan ],
	[    58,    0.66,   0.04,   0.67,   0.04,   0.86,   0.03,   4.63,    0.01,  3.68e-16,  4.42e-16,  3.87e-16,  nan ],
	[    59,    0.71,   0.04,   0.71,   0.04,   0.87,   0.03,   4.13,    0.01,  4.34e-16,  4.85e-16,  5.55e-16,  nan ],
	[    60,    0.69,   0.04,   0.74,   0.04,   0.92,   0.03,   3.35,    0.01,  4.27e-16,  4.27e-16,  5.30e-16,  nan ],
	[    61,    0.74,   0.04,   0.73,   0.04,   0.95,   0.03,   3.37,    0.01,  4.80e-16,  4.70e-16,  5.21e-16,  nan ],
	[    62,    0.73,   0.04,   0.75,   0.04,   1.02,   0.03,   4.56,    0.01,  5.73e-16,  5.84e-16,  5.13e-16,  nan ],
	[    63,    0.68,   0.05,   0.79,   0.04,   1.02,   0.03,   3.59,    0.01,  6.77e-16,  5.04e-16,  5.04e-16,  nan ],
	[    64,    0.88,   0.04,   0.86,   0.04,   1.04,   0.03,   4.85,    0.01,  5.55e-16,  6.68e-16,  4.74e-16,  nan ],
	[    65,    0.72,   0.05,   0.81,   0.04,   0.99,   0.04,   4.40,    0.01,  4.51e-16,  4.67e-16,  4.51e-16,  nan ],
	[    66,    0.75,   0.05,   0.85,   0.04,   1.05,   0.03,   4.40,    0.01,  6.46e-16,  5.80e-16,  6.81e-16,  nan ],
	[    67,    0.78,   0.05,   0.87,   0.04,   1.05,   0.04,   4.05,    0.01,  4.74e-16,  5.30e-16,  4.74e-16,  nan ],
	[    68,    0.79,   0.05,   0.90,   0.04,   1.11,   0.03,   4.17,    0.01,  6.27e-16,  4.31e-16,  4.67e-16,  nan ],
	[    69,    0.83,   0.05,   0.91,   0.04,   1.11,   0.04,   4.30,    0.01,  6.26e-16,  6.37e-16,  6.51e-16,  nan ],
	[    70,    0.85,   0.05,   0.95,   0.04,   1.17,   0.03,   4.42,    0.01,  6.60e-16,  6.42e-16,  6.42e-16,  nan ],
	[    71,    0.84,   0.05,   0.96,   0.04,   1.17,   0.04,   5.08,    0.01,  1.00e-15,  8.07e-16,  7.22e-16,  nan ],
	[    72,    0.90,   0.05,   1.01,   0.04,   1.33,   0.03,   4.23,    0.01,  8.14e-16,  7.89e-16,  6.24e-16,  nan ],
	[    73,    0.93,   0.05,   1.04,   0.04,   1.24,   0.04,   4.34,    0.01,  7.02e-16,  5.92e-16,  7.02e-16,  nan ],
	[    74,    0.95,   0.05,   1.07,   0.04,   1.35,   0.03,   4.93,    0.01,  7.74e-16,  7.74e-16,  6.15e-16,  nan ],
	[    75,    0.97,   0.05,   1.12,   0.04,   1.35,   0.03,   5.83,    0.01,  1.07e-15,  8.04e-16,  8.04e-16,  nan ],
	[    76,    0.95,   0.05,   1.10,   0.04,   1.43,   0.03,   4.30,    0.01,  6.27e-16,  7.71e-16,  7.71e-16,  nan ],
	[    77,    0.97,   0.05,   1.15,   0.04,   1.38,   0.04,   4.83,    0.01,  6.65e-16,  7.44e-16,  5.61e-16,  nan ],
	[    78,    0.99,   0.05,   1.16,   0.04,   1.42,   0.04,   4.43,    0.01,  6.57e-16,  5.54e-16,  5.15e-16,  nan ],
	[    79,    1.02,   0.05,   1.18,   0.04,   1.50,   0.03,   4.64,    0.01,  7.42e-16,  9.17e-16,  7.68e-16,  nan ],
	[    80,    1.02,   0.05,   1.18,   0.04,   1.54,   0.03,   4.76,    0.01,  6.40e-16,  5.62e-16,  5.62e-16,  nan ],
	[    81,    1.05,   0.05,   1.21,   0.04,   1.48,   0.04,   5.34,    0.01,  7.49e-16,  7.23e-16,  7.23e-16,  nan ],
	[    82,    1.12,   0.05,   1.24,   0.04,   1.52,   0.04,   4.99,    0.01,  5.48e-16,  6.99e-16,  5.48e-16,  nan ],
	[    83,    1.10,   0.05,   1.25,   0.04,   1.56,   0.04,   5.74,    0.01,  7.26e-16,  7.66e-16,  7.26e-16,  nan ],
	[    84,    1.13,   0.05,   1.28,   0.05,   1.60,   0.04,   5.13,    0.01,  6.16e-16,  7.18e-16,  5.35e-16,  nan ],
	[    85,    1.15,   0.05,   1.31,   0.05,   1.63,   0.04,   4.93,    0.01,  6.89e-16,  8.52e-16,  6.89e-16,  nan ],
	[    86,    1.26,   0.05,   1.40,   0.04,   1.73,   0.03,   6.01,    0.01,  5.23e-16,  5.23e-16,  5.96e-16,  nan ],
	[    87,    1.29,   0.05,   1.40,   0.04,   1.71,   0.04,   5.50,    0.01,  6.53e-16,  6.85e-16,  5.48e-16,  nan ],
	[    88,    1.28,   0.05,   1.43,   0.04,   1.85,   0.03,   5.75,    0.01,  5.11e-16,  6.66e-16,  5.82e-16,  nan ],
	[    89,    1.32,   0.05,   1.49,   0.04,   1.84,   0.04,   5.41,    0.01,  7.14e-16,  5.05e-16,  5.05e-16,  nan ],
	[    90,    1.34,   0.05,   1.46,   0.05,   1.83,   0.04,   5.42,    0.01,  7.93e-16,  8.14e-16,  8.24e-16,  nan ],
	[   100,    1.59,   0.05,   1.73,   0.05,   2.14,   0.04,   6.68,    0.01,  6.55e-16,  5.17e-16,  6.03e-16,  nan ],
	[   110,    1.89,   0.05,   2.05,   0.05,   2.51,   0.04,   6.98,    0.01,  5.33e-16,  5.78e-16,  6.59e-16,  nan ],
	[   120,    2.16,   0.05,   2.37,   0.05,   2.91,   0.04,   6.89,    0.02,  7.32e-16,  7.11e-16,  5.59e-16,  nan ],
	[   130,    2.32,   0.06,   2.73,   0.05,   3.19,   0.04,   6.83,    0.02,  9.78e-16,  8.54e-16,  8.90e-16,  nan ],
	[   140,    2.69,   0.06,   3.11,   0.05,   3.69,   0.04,   7.55,    0.02,  6.42e-16,  8.67e-16,  8.37e-16,  nan ],
	[   150,    3.07,   0.06,   3.43,   0.05,   4.12,   0.04,   7.55,    0.02,  8.09e-16,  9.52e-16,  8.94e-16,  nan ],
	[   160,    3.44,   0.06,   4.15,   0.05,   4.69,   0.04,   8.58,    0.02,  8.88e-16,  9.06e-16,  9.57e-16,  nan ],
	[   170,    3.82,   0.06,   4.33,   0.05,   5.18,   0.05,   8.98,    0.03,  1.02e-15,  1.17e-15,  9.00e-16,  nan ],
	[   180,    4.22,   0.06,   4.66,   0.06,   5.56,   0.05,   8.70,    0.03,  9.68e-16,  9.99e-16,  1.03e-15,  nan ],
	[   190,    4.47,   0.07,   5.02,   0.06,   6.07,   0.05,   9.11,    0.03,  1.08e-15,  1.09e-15,  1.09e-15,  nan ],
	[   200,    4.74,   0.07,   5.47,   0.06,   6.44,   0.05,   8.30,    0.04,  1.14e-15,  9.95e-16,  9.10e-16,  nan ],
	[   210,    5.00,   0.07,   5.82,   0.06,   6.81,   0.05,   9.37,    0.04,  1.12e-15,  1.21e-15,  1.03e-15,  nan ],
	[   220,    5.49,   0.07,   6.39,   0.06,   7.64,   0.05,   8.65,    0.05,  1.05e-15,  1.04e-15,  9.32e-16,  nan ],
	[   230,    6.10,   0.07,   6.77,   0.06,   8.05,   0.05,   9.07,    0.05,  1.38e-15,  1.17e-15,  1.41e-15,  nan ],
	[   240,    6.53,   0.07,   7.37,   0.06,   8.57,   0.05,   9.09,    0.05,  1.19e-15,  1.09e-15,  1.21e-15,  nan ],
	[   250,    6.72,   0.07,   7.73,   0.07,   8.83,   0.06,   9.46,    0.05,  1.16e-15,  1.27e-15,  1.04e-15,  nan ],
	[   260,    7.15,   0.08,   8.24,   0.07,   9.39,   0.06,   9.20,    0.06,  1.35e-15,  1.11e-15,  1.11e-15,  nan ],
	[   270,    7.32,   0.08,   8.60,   0.07,   9.92,   0.06,   9.96,    0.06,  1.28e-15,  1.26e-15,  1.10e-15,  nan ],
	[   280,    7.69,   0.08,   9.15,   0.07,  10.37,   0.06,   9.55,    0.07,  1.06e-15,  1.09e-15,  1.28e-15,  nan ],
	[   290,    8.34,   0.08,   9.27,   0.07,  10.74,   0.06,   9.68,    0.07,  1.38e-15,  1.96e-15,  1.58e-15,  nan ],
	[   300,    8.82,   0.08,  10.05,   0.07,  11.50,   0.06,   9.76,    0.07,  1.36e-15,  1.20e-15,  1.41e-15,  nan ],
	[   310,    9.10,   0.08,  10.16,   0.08,  11.70,   0.07,   9.21,    0.08,  1.44e-15,  1.48e-15,  1.31e-15,  nan ],
	[   320,   10.30,   0.08,  11.10,   0.07,  12.28,   0.07,  10.15,    0.08,  2.05e-15,  2.08e-15,  2.08e-15,  nan ],
	[   330,    9.92,   0.09,  11.54,   0.08,  12.70,   0.07,   9.95,    0.09,  1.72e-15,  1.57e-15,  1.39e-15,  nan ],
	[   340,   10.45,   0.09,  11.91,   0.08,  12.90,   0.07,   9.39,    0.10,  1.35e-15,  1.53e-15,  1.38e-15,  nan ],
	[   350,   11.07,   0.09,  12.29,   0.08,  13.67,   0.07,   9.92,    0.10,  1.31e-15,  1.34e-15,  1.31e-15,  nan ],
	[   360,   11.43,   0.09,  12.69,   0.08,  13.52,   0.08,   9.73,    0.11,  1.41e-15,  1.61e-15,  1.47e-15,  nan ],
	[   370,   11.44,   0.10,  13.25,   0.08,  14.50,   0.08,  10.09,    0.11,  1.54e-15,  1.24e-15,  1.40e-15,  nan ],
	[   380,   11.84,   0.10,  13.63,   0.09,  15.06,   0.08,   9.99,    0.12,  1.67e-15,  1.67e-15,  1.67e-15,  nan ],
	[   390,   12.00,   0.10,  14.04,   0.09,  15.62,   0.08,  10.19,    0.12,  1.46e-15,  1.89e-15,  1.46e-15,  nan ],
	[   400,   12.47,   0.10,  14.76,   0.09,  16.48,   0.08,  10.28,    0.12,  1.48e-15,  1.73e-15,  1.56e-15,  nan ],
	[   410,   13.10,   0.10,  14.86,   0.09,  16.65,   0.08,  10.22,    0.13,  1.58e-15,  1.55e-15,  1.80e-15,  nan ],
	[   420,   13.23,   0.11,  15.39,   0.09,  17.27,   0.08,   9.83,    0.14,  1.33e-15,  1.33e-15,  1.28e-15,  nan ],
	[   430,   13.39,   0.11,  15.80,   0.09,  17.69,   0.08,  10.24,    0.14,  1.76e-15,  1.72e-15,  1.67e-15,  nan ],
	[   440,   13.75,   0.11,  16.02,   0.10,  18.26,   0.09,   9.97,    0.16,  1.43e-15,  1.43e-15,  1.42e-15,  nan ],
	[   450,   14.14,   0.11,  16.59,   0.10,  18.94,   0.09,  10.28,    0.16,  1.48e-15,  1.69e-15,  1.66e-15,  nan ],
	[   460,   14.75,   0.12,  17.55,   0.10,  19.30,   0.09,  10.16,    0.17,  1.98e-15,  1.86e-15,  1.87e-15,  nan ],
	[   470,   14.90,   0.12,  17.37,   0.10,  19.88,   0.09,  10.31,    0.17,  1.93e-15,  1.53e-15,  1.47e-15,  nan ],
	[   480,   15.54,   0.12,  18.69,   0.10,  20.79,   0.09,  10.38,    0.18,  1.88e-15,  1.70e-15,  1.62e-15,  nan ],
	[   490,   15.66,   0.12,  18.32,   0.11,  20.10,   0.10,  10.41,    0.19,  1.77e-15,  1.72e-15,  1.94e-15,  nan ],
	[   500,   15.79,   0.13,  18.74,   0.11,  20.93,   0.10,  10.50,    0.19,  2.06e-15,  1.82e-15,  1.59e-15,  nan ],
	[   510,   16.70,   0.12,  19.15,   0.11,  21.51,   0.10,  10.33,    0.20,  1.56e-15,  1.62e-15,  1.41e-15,  nan ],
	[   520,   16.54,   0.13,  19.57,   0.11,  21.87,   0.10,  10.04,    0.22,  1.99e-15,  1.77e-15,  1.82e-15,  nan ],
	[   530,   16.94,   0.13,  20.11,   0.11,  22.35,   0.10,  10.49,    0.21,  2.27e-15,  2.27e-15,  2.45e-15,  nan ],
	[   540,   17.18,   0.14,  20.70,   0.11,  22.92,   0.10,  10.48,    0.22,  1.84e-15,  1.80e-15,  1.76e-15,  nan ],
	[   550,   17.86,   0.14,  20.90,   0.12,  23.56,   0.10,  10.46,    0.23,  1.89e-15,  1.91e-15,  1.89e-15,  nan ],
	[   560,   18.22,   0.14,  22.07,   0.11,  24.20,   0.10,  10.30,    0.24,  1.65e-15,  1.64e-15,  1.63e-15,  nan ],
	[   570,   18.10,   0.14,  22.44,   0.12,  24.79,   0.11,  10.55,    0.25,  2.06e-15,  2.11e-15,  2.06e-15,  nan ],
	[   580,   18.74,   0.14,  22.86,   0.12,  25.26,   0.11,  10.42,    0.26,  2.48e-15,  2.48e-15,  2.26e-15,  nan ],
	[   590,   18.86,   0.15,  23.05,   0.12,  25.62,   0.11,  10.54,    0.26,  1.94e-15,  2.34e-15,  2.32e-15,  nan ],
	[   600,   19.50,   0.15,  23.70,   0.12,  26.04,   0.11,  10.69,    0.27,  1.95e-15,  1.95e-15,  2.16e-15,  nan ],
	[   610,   19.90,   0.15,  24.07,   0.12,  26.46,   0.11,  10.40,    0.29,  2.15e-15,  1.59e-15,  1.72e-15,  nan ],
	[   620,   20.05,   0.15,  24.44,   0.13,  25.86,   0.12,  10.62,    0.29,  2.22e-15,  2.12e-15,  2.21e-15,  nan ],
	[   630,   20.96,   0.15,  24.91,   0.13,  27.64,   0.12,  10.57,    0.30,  1.99e-15,  1.99e-15,  1.99e-15,  nan ],
	[   640,   21.90,   0.15,  26.09,   0.13,  28.58,   0.11,  10.60,    0.31,  1.80e-15,  1.88e-15,  1.99e-15,  nan ],
	[   650,   21.05,   0.16,  26.07,   0.13,  28.71,   0.12,  10.53,    0.32,  1.99e-15,  1.93e-15,  1.80e-15,  nan ],
	[   660,   21.80,   0.16,  26.44,   0.13,  29.12,   0.12,  10.75,    0.32,  2.21e-15,  1.83e-15,  1.83e-15,  nan ],
	[   670,   21.94,   0.16,  26.86,   0.13,  29.95,   0.12,  10.59,    0.34,  2.43e-15,  2.21e-15,  2.10e-15,  nan ],
	[   680,   22.34,   0.17,  27.04,   0.14,  30.14,   0.12,  10.75,    0.34,  2.01e-15,  2.02e-15,  1.84e-15,  nan ],
	[   690,   23.00,   0.17,  27.84,   0.14,  30.79,   0.12,  10.55,    0.36,  2.38e-15,  2.38e-15,  2.22e-15,  nan ],
	[   700,   22.95,   0.17,  28.26,   0.14,  31.44,   0.12,  10.71,    0.37,  2.36e-15,  2.44e-15,  2.28e-15,  nan ],
	[   710,   23.22,   0.17,  28.49,   0.14,  31.80,   0.13,  10.50,    0.39,  1.96e-15,  2.41e-15,  2.12e-15,  nan ],
	[   720,   24.18,   0.17,  29.69,   0.14,  32.70,   0.13,  10.60,    0.39,  2.08e-15,  2.38e-15,  2.44e-15,  nan ],
	[   730,   24.58,   0.17,  29.86,   0.14,  31.88,   0.13,  10.76,    0.40,  2.34e-15,  2.32e-15,  2.19e-15,  nan ],
	[   740,   24.95,   0.18,  30.28,   0.14,  32.76,   0.13,  10.76,    0.41,  2.35e-15,  2.62e-15,  2.48e-15,  nan ],
	[   750,   25.05,   0.18,  30.65,   0.15,  33.12,   0.14,  10.68,    0.42,  2.29e-15,  2.06e-15,  2.02e-15,  nan ],
	[   760,   25.89,   0.18,  31.52,   0.15,  33.60,   0.14,  10.67,    0.43,  2.72e-15,  2.85e-15,  2.69e-15,  nan ],
	[   770,   26.23,   0.18,  31.29,   0.15,  33.73,   0.14,  10.54,    0.45,  2.25e-15,  2.58e-15,  1.92e-15,  nan ],
	[   780,   25.54,   0.19,  32.31,   0.15,  34.38,   0.14,  10.79,    0.45,  2.17e-15,  2.15e-15,  2.10e-15,  nan ],
	[   790,   27.21,   0.18,  32.73,   0.15,  35.03,   0.14,  10.55,    0.47,  2.55e-15,  2.65e-15,  2.51e-15,  nan ],
	[   800,   27.44,   0.19,  32.90,   0.16,  35.39,   0.14,  10.68,    0.48,  2.42e-15,  2.03e-15,  2.11e-15,  nan ],
	[   810,   27.54,   0.19,  33.93,   0.15,  35.75,   0.15,  10.75,    0.49,  2.39e-15,  2.26e-15,  2.27e-15,  nan ],
	[   820,   28.22,   0.19,  34.09,   0.16,  36.17,   0.15,  10.75,    0.50,  2.92e-15,  2.91e-15,  2.77e-15,  nan ],
	[   830,   28.59,   0.19,  34.72,   0.16,  37.35,   0.15,  10.72,    0.51,  1.94e-15,  2.20e-15,  2.20e-15,  nan ],
	[   840,   28.58,   0.20,  35.14,   0.16,  37.47,   0.15,  10.84,    0.52,  2.50e-15,  2.34e-15,  2.40e-15,  nan ],
	[   850,   29.40,   0.20,  35.98,   0.16,  37.83,   0.15,  10.70,    0.54,  2.43e-15,  2.21e-15,  2.04e-15,  nan ],
	[   860,   29.77,   0.20,  36.61,   0.16,  38.25,   0.15,  10.72,    0.55,  2.66e-15,  2.60e-15,  2.60e-15,  nan ],
	[   870,   29.72,   0.20,  36.09,   0.17,  38.84,   0.16,  10.70,    0.57,  2.61e-15,  2.62e-15,  2.36e-15,  nan ],
	[   880,   30.55,   0.20,  36.92,   0.17,  39.26,   0.16,  10.72,    0.58,  2.15e-15,  2.25e-15,  2.10e-15,  nan ],
	[   890,   30.53,   0.21,  37.60,   0.17,  39.44,   0.16,  10.65,    0.60,  2.23e-15,  2.30e-15,  2.39e-15,  nan ],
	[   900,   30.62,   0.21,  37.09,   0.17,  39.57,   0.16,  10.73,    0.60,  2.49e-15,  2.58e-15,  2.54e-15,  nan ],
	[  1000,   33.94,   0.24,  41.49,   0.19,  42.81,   0.19,  10.16,    0.79,  2.91e-15,  2.52e-15,  2.56e-15,  nan ],
	[  1100,   37.44,   0.26,  45.53,   0.21,  27.85,   0.35,   9.57,    1.01,  3.65e-15,  2.94e-15,  2.90e-15,  nan ],
	[  1200,   40.48,   0.28,  49.93,   0.23,  30.18,   0.38,   8.96,    1.29,  3.29e-15,  3.26e-15,  3.42e-15,  nan ],
	[  1300,   44.08,   0.31,  53.91,   0.25,  31.11,   0.44,   8.55,    1.58,  2.97e-15,  2.80e-15,  2.83e-15,  nan ],
	[  1400,   47.85,   0.33,  59.91,   0.26,  33.75,   0.47,   8.43,    1.86,  3.26e-15,  3.47e-15,  3.08e-15,  nan ],
	[  1500,   50.89,   0.35,  63.24,   0.28,  36.63,   0.49,   8.34,    2.16,  2.93e-15,  3.07e-15,  2.96e-15,  nan ],
	[  1600,   54.97,   0.37,  68.78,   0.30,  38.18,   0.54,   8.34,    2.46,  3.13e-15,  3.02e-15,  3.13e-15,  nan ],
	[  1700,   58.15,   0.40,  73.70,   0.31,  40.75,   0.57,   8.46,    2.73,  3.36e-15,  3.41e-15,  3.22e-15,  nan ],
	[  1800,   61.93,   0.42,  74.78,   0.35,  42.04,   0.62,   7.97,    3.26,  4.38e-15,  4.54e-15,  4.69e-15,  nan ],
	[  1900,   64.79,   0.45,  77.07,   0.38,  43.80,   0.66,   8.46,    3.42,  3.59e-15,  3.83e-15,  3.83e-15,  nan ],
	[  2000,   63.78,   0.50,  77.73,   0.41,  45.61,   0.70,   8.25,    3.88,  3.65e-15,  3.67e-15,  3.70e-15,  nan ],
	[  2100,   65.12,   0.54,  78.31,   0.45,  35.17,   1.00,   8.42,    4.19,  6.07e-15,  5.02e-15,  6.11e-15,  nan ],
	[  2200,   66.12,   0.59,  79.08,   0.49,  36.87,   1.05,   8.50,    4.56,  3.96e-15,  3.89e-15,  3.66e-15,  nan ],
	[  2300,   67.64,   0.63,  79.33,   0.53,  38.40,   1.10,   7.98,    5.31,  4.81e-15,  4.26e-15,  4.18e-15,  nan ],
	[  2400,   69.44,   0.66,  79.52,   0.58,  40.37,   1.14,   8.37,    5.51,  4.94e-15,  6.12e-15,  5.51e-15,  nan ],
	[  2500,   70.65,   0.71,  78.92,   0.63,  41.15,   1.22,   8.45,    5.92,  4.82e-15,  4.92e-15,  4.91e-15,  nan ],
	[  2600,   71.10,   0.76,  79.94,   0.68,  41.06,   1.32,   8.43,    6.42,  4.04e-15,  4.36e-15,  3.99e-15,  nan ],
	[  2700,   73.30,   0.80,  78.75,   0.74,  41.38,   1.41,   8.46,    6.90,  5.41e-15,  4.79e-15,  5.22e-15,  nan ],
	[  2800,   74.27,   0.84,  81.09,   0.77,  40.04,   1.57,   8.45,    7.43,  5.05e-15,  5.05e-15,  5.07e-15,  nan ],
	[  2900,   74.79,   0.90,  81.60,   0.82,  45.48,   1.48,   8.55,    7.87,  5.33e-15,  5.35e-15,  6.01e-15,  nan ],
	[  3000,   75.74,   0.95,  82.71,   0.87,  45.77,   1.57,   8.57,    8.41,  4.80e-15,  4.72e-15,  4.70e-15,  nan ],
	[  3100,   77.07,   1.00,  83.88,   0.92,  38.46,   2.00,   8.44,    9.12,  5.19e-15,  5.50e-15,  5.79e-15,  nan ],
	[  3200,   79.04,   1.04,  84.32,   0.97,  40.68,   2.01,   9.28,    8.83,  5.40e-15,  5.92e-15,  5.50e-15,  nan ],
	[  3300,   80.47,   1.08,  86.12,   1.01,  41.08,   2.12,   8.57,   10.17,  4.76e-15,  5.11e-15,  5.94e-15,  nan ],
	[  3400,   82.30,   1.12,  86.62,   1.07,  42.24,   2.19,   8.56,   10.81,  4.99e-15,  4.91e-15,  5.38e-15,  nan ],
	[  3500,   83.29,   1.18,  87.62,   1.12,  43.15,   2.27,   8.51,   11.53,  5.52e-15,  5.19e-15,  5.40e-15,  nan ],
	[  3600,   86.08,   1.20,  88.05,   1.18,  44.19,   2.35,   8.32,   12.47,  5.32e-15,  4.66e-15,  4.72e-15,  nan ],
	[  3700,   87.23,   1.26,  87.52,   1.25,  44.50,   2.46,   8.49,   12.90,  5.90e-15,  5.96e-15,  5.76e-15,  nan ],
	[  3800,   88.36,   1.31,  88.82,   1.30,  45.25,   2.55,   8.54,   13.53,  6.32e-15,  6.32e-15,  5.98e-15,  nan ],
	[  3900,   87.07,   1.40,  88.85,   1.37,  46.91,   2.59,   8.45,   14.40,  5.69e-15,  5.87e-15,  6.08e-15,  nan ],
	[  4000,   88.44,   1.45,  88.74,   1.44,  46.01,   2.78,   8.46,   15.14,  6.07e-15,  6.24e-15,  6.19e-15,  nan ],
	[  4100,   87.08,   1.54,  87.99,   1.53,  39.11,   3.44,   8.02,   16.77,  7.58e-15,  6.75e-15,  7.00e-15,  nan ],
	[  4200,   87.63,   1.61,  89.12,   1.58,  41.80,   3.38,   8.46,   16.69,  5.38e-15,  5.44e-15,  5.83e-15,  nan ],
	[  4300,   89.69,   1.65,  88.50,   1.67,  42.61,   3.47,   8.48,   17.44,  7.09e-15,  7.48e-15,  6.63e-15,  nan ],
	[  4400,   89.09,   1.74,  89.77,   1.73,  42.65,   3.63,   8.45,   18.34,  8.27e-15,  8.48e-15,  7.80e-15,  nan ],
	[  4500,   90.53,   1.79,  89.39,   1.81,  44.73,   3.62,   8.54,   18.98,  6.07e-15,  6.87e-15,  5.92e-15,  nan ],
	[  4600,   90.99,   1.86,  89.97,   1.88,  46.32,   3.66,   8.51,   19.91,  6.07e-15,  5.73e-15,  6.28e-15,  nan ],
	[  4700,   91.79,   1.93,  88.97,   1.99,  46.40,   3.81,   8.63,   20.48,  7.42e-15,  9.41e-15,  8.83e-15,  nan ],
	[  4800,   92.24,   2.00,  89.51,   2.06,  46.22,   3.99,   8.61,   21.41,  6.90e-15,  7.21e-15,  7.59e-15,  nan ],
	[  4900,   91.62,   2.10,  89.53,   2.15,  47.08,   4.08,   8.63,   22.28,  6.72e-15,  7.17e-15,  6.66e-15,  nan ],
	[  5000,   93.22,   2.15,  90.24,   2.22,  47.22,   4.24,   8.69,   23.03,  7.08e-15,  6.39e-15,  6.93e-15,  nan ],
	[  5100,   93.30,   2.23,  90.50,   2.30,  48.08,   4.33,   8.56,   24.33,  6.77e-15,  7.20e-15,  7.69e-15,  nan ],
	[  5200,   94.57,   2.29,  91.42,   2.37,  43.32,   4.99,   8.60,   25.16,  7.67e-15,  7.32e-15,  7.63e-15,  nan ],
	[  5300,   94.93,   2.37,  91.98,   2.44,  43.36,   5.18,   8.68,   25.90,  8.51e-15,  8.42e-15,  7.62e-15,  nan ],
	[  5400,   95.94,   2.43,  91.80,   2.54,  43.40,   5.38,   8.58,   27.20,  6.74e-15,  7.04e-15,  6.83e-15,  nan ],
	[  5500,   96.33,   2.51,  91.94,   2.63,  44.17,   5.48,   8.61,   28.11,  7.61e-15,  7.40e-15,  6.95e-15,  nan ],
	[  5600,   98.33,   2.55,  90.93,   2.76,  45.35,   5.53,   8.60,   29.19,  8.96e-15,  8.30e-15,  8.46e-15,  nan ],
	[  5700,   98.07,   2.65,  91.81,   2.83,  45.65,   5.70,   8.30,   31.33,  7.18e-15,  8.18e-15,  7.36e-15,  nan ],
	[  5800,   97.04,   2.77,  91.75,   2.93,  47.07,   5.72,   8.65,   31.13,  8.33e-15,  7.19e-15,  7.67e-15,  nan ],
	[  5900,   97.70,   2.85,  92.54,   3.01,  47.89,   5.82,   8.66,   32.15,  8.18e-15,  9.25e-15,  8.50e-15,  nan ],
	[  6000,   98.22,   2.93,  92.45,   3.12,  48.03,   6.00,   8.70,   33.10,  6.85e-15,  7.70e-15,  7.43e-15,  nan ],
	[  6100,   98.14,   3.03,  92.98,   3.20,  48.07,   6.19,   8.73,   34.12,  7.53e-15,  7.95e-15,  7.67e-15,  nan ],
	[  6200,   98.52,   3.12,  93.10,   3.30,  43.58,   7.06,   8.71,   35.31,  8.04e-15,  7.28e-15,  7.24e-15,  nan ],
	[  6300,   98.32,   3.23,  92.46,   3.43,  44.14,   7.19,   8.27,   38.41,  8.91e-15,  8.75e-15,  8.86e-15,  nan ],
	[  6400,   98.67,   3.32,  91.86,   3.57,  44.43,   7.38,   9.01,   36.38,  7.11e-15,  7.39e-15,  7.25e-15,  nan ],
	[  6500,   99.61,   3.39,  91.89,   3.68,  44.72,   7.56,   8.61,   39.29,  7.85e-15,  8.97e-15,  8.40e-15,  nan ],
	[  6600,   99.82,   3.49,  92.43,   3.77,  45.88,   7.60,   8.65,   40.31,  7.30e-15,  7.44e-15,  7.23e-15,  nan ],
	[  6700,  100.14,   3.59,  92.53,   3.88,  45.81,   7.84,   8.25,   43.52,  9.14e-15,  9.40e-15,  8.89e-15,  nan ],
	[  6800,   99.89,   3.70,  92.20,   4.01,  46.40,   7.97,   8.28,   44.69,  9.71e-15,  9.71e-15,  9.76e-15,  nan ],
	[  6900,  101.56,   3.75,  92.92,   4.10,  47.09,   8.09,   8.60,   44.27,  8.25e-15,  8.55e-15,  8.55e-15,  nan ],
	[  7000,  100.61,   3.90,  92.69,   4.23,  47.77,   8.21,   8.20,   47.84,  8.67e-15,  7.43e-15,  7.18e-15,  nan ],
	[  7100,  100.06,   4.03,  92.70,   4.35,  47.61,   8.47,   8.25,   48.90,  8.33e-15,  8.20e-15,  7.92e-15,  nan ],
	[  7200,  102.27,   4.06,  92.94,   4.46,  44.55,   9.31,   8.01,   51.82,  8.59e-15,  7.78e-15,  8.34e-15,  nan ],
	[  7300,  102.25,   4.17,  93.57,   4.56,  45.50,   9.37,   7.83,   54.43,  8.85e-15,  7.86e-15,  8.24e-15,  nan ],
	[  7400,  102.76,   4.26,  93.29,   4.70,  45.45,   9.64,   8.06,   54.36,  8.38e-15,  8.65e-15,  8.38e-15,  nan ],
	[  7500,  103.87,   4.33,  93.21,   4.83,  45.06,   9.99,   8.05,   55.95,  9.37e-15,  9.78e-15,  9.40e-15,  nan ],
	[  7600,  103.63,   4.46,  93.03,   4.97,  46.54,   9.93,   8.07,   57.30,  9.15e-15,  8.27e-15,  8.71e-15,  nan ],
	[  7700,  102.60,   4.62,  92.84,   5.11,  46.49,  10.20,   8.06,   58.86,  8.84e-15,  8.34e-15,  9.15e-15,  nan ],
	[  7800,  101.70,   4.79,  93.50,   5.21,  46.78,  10.41,   7.56,   64.38,  8.12e-15,  9.13e-15,  8.24e-15,  nan ],
	[  7900,  102.27,   4.88,  93.08,   5.36,  47.24,  10.57,   7.65,   65.30,  1.04e-14,  1.05e-14,  1.02e-14,  nan ],
	[  8000,  102.91,   4.98,  93.18,   5.50,  47.04,  10.89,   7.60,   67.39,  1.06e-14,  9.34e-15,  1.00e-14,  nan ],
	[  8100,  103.61,   5.07,  93.63,   5.61,  47.82,  10.98,   7.51,   69.88,  1.12e-14,  1.27e-14,  1.21e-14,  nan ],
	[  8200,  103.55,   5.20,  93.57,   5.75,  44.49,  12.09,   7.34,   73.33,  9.85e-15,  9.72e-15,  9.45e-15,  nan ],
	[  8300,  103.89,   5.31,  92.99,   5.93,  44.66,  12.34,   7.25,   76.05,  9.43e-15,  9.61e-15,  8.37e-15,  nan ],
	[  8400,  104.67,   5.39,  93.49,   6.04,  45.01,  12.54,   7.59,   74.43,  9.52e-15,  9.29e-15,  1.09e-14,  nan ],
	[  8500,  104.98,   5.51,  93.86,   6.16,  46.82,  12.35,   7.54,   76.66,  8.73e-15,  9.08e-15,  9.34e-15,  nan ],
	[  8600,  104.79,   5.65,  93.81,   6.31,  46.54,  12.71,   7.67,   77.11,  9.74e-15,  1.02e-14,  8.91e-15,  nan ],
	[  8700,  104.13,   5.82,  94.23,   6.43,  46.01,  13.16,   7.58,   79.95,  9.92e-15,  9.88e-15,  1.02e-14,  nan ],
	[  8800,  104.67,   5.92,  93.37,   6.64,  47.09,  13.16,   7.81,   79.29,  9.75e-15,  9.41e-15,  9.62e-15,  nan ],
	[  8900,  104.72,   6.05,  94.26,   6.72,  46.79,  13.55,   8.11,   78.18,  9.93e-15,  9.80e-15,  1.06e-14,  nan ],
	[  9000,  105.16,   6.16,  93.86,   6.91,  47.55,  13.63,   8.05,   80.53,  1.05e-14,  1.03e-14,  1.03e-14,  nan ],
	[ 10000,  106.63,   7.50,  94.69,   8.45,  47.55,  16.83,   8.26,   96.87,  9.28e-15,  1.01e-14,  9.12e-15,  nan ],
	[ 12000,  109.91,  10.48,  93.78,  12.28,  48.20,  23.90,   8.27,  139.25,  1.42e-14,  1.38e-14,  1.30e-14,  nan ],
	[ 14000,  108.23,  14.49,  94.48,  16.60,  48.30,  32.47,   8.44,  185.88,  1.34e-14,  1.27e-14,  1.28e-14,  nan ],
	[ 16000,  107.08,  19.13,  94.38,  21.70,  47.40,  43.21,   8.74,  234.35,  1.32e-14,  1.36e-14,  1.26e-14,  nan ],
	[ 18000,  107.55,  24.10,  95.12,  27.25,  47.25,  54.86,   8.35,  310.50,  1.44e-14,  1.48e-14,  1.40e-14,  nan ],
	[ 20000,  106.70,  29.99,  94.26,  33.95,  47.20,  67.80,   8.19,  390.92,  1.64e-14,  1.48e-14,  1.55e-14,  nan ],
])

# numactl --interleave=all ../testing/testing_zhemv -U -N 123 -N 1234 --range 10:90:1 --range 100:900:10 --range 1000:9000:100 --range 10000:20000:2000 --lapack
zhemv_U = array([
	[    10,    0.02,   0.04,    0.03,   0.03,   0.04,   0.03,   0.43,    0.00,  7.16e-16,  3.66e-16,  7.16e-16,  nan ],
	[    11,    0.03,   0.04,    0.04,   0.03,   0.05,   0.02,   0.51,    0.00,  3.33e-16,  2.91e-16,  2.28e-16,  nan ],
	[    12,    0.04,   0.04,    0.05,   0.03,   0.05,   0.03,   0.60,    0.00,  5.78e-16,  3.31e-16,  2.96e-16,  nan ],
	[    13,    0.04,   0.04,    0.06,   0.03,   0.06,   0.02,   0.70,    0.00,  3.42e-16,  5.51e-16,  2.05e-16,  nan ],
	[    14,    0.04,   0.04,    0.07,   0.02,   0.08,   0.02,   0.81,    0.00,  2.84e-16,  2.54e-16,  2.84e-16,  nan ],
	[    15,    0.05,   0.04,    0.08,   0.03,   0.08,   0.03,   0.92,    0.00,  3.74e-16,  3.60e-16,  3.74e-16,  nan ],
	[    16,    0.06,   0.04,    0.09,   0.03,   0.09,   0.03,   1.17,    0.00,  3.33e-16,  4.44e-16,  3.51e-16,  nan ],
	[    17,    0.06,   0.04,    0.10,   0.03,   0.09,   0.03,   0.81,    0.00,  4.31e-16,  2.34e-16,  4.31e-16,  nan ],
	[    18,    0.07,   0.04,    0.11,   0.03,   0.10,   0.03,   1.31,    0.00,  2.79e-16,  4.07e-16,  4.07e-16,  nan ],
	[    19,    0.08,   0.04,    0.11,   0.03,   0.11,   0.03,   1.09,    0.00,  4.18e-16,  4.18e-16,  4.18e-16,  nan ],
	[    20,    0.09,   0.04,    0.13,   0.03,   0.13,   0.03,   1.11,    0.00,  3.97e-16,  5.35e-16,  3.97e-16,  nan ],
	[    21,    0.10,   0.04,    0.14,   0.03,   0.14,   0.03,   1.22,    0.00,  3.49e-16,  3.78e-16,  3.49e-16,  nan ],
	[    22,    0.11,   0.04,    0.15,   0.03,   0.15,   0.03,   1.45,    0.00,  5.11e-16,  4.91e-16,  4.04e-16,  nan ],
	[    23,    0.12,   0.04,    0.16,   0.03,   0.17,   0.03,   1.45,    0.00,  3.18e-16,  5.57e-16,  3.09e-16,  nan ],
	[    24,    0.12,   0.04,    0.18,   0.03,   0.18,   0.03,   1.58,    0.00,  4.68e-16,  4.68e-16,  3.05e-16,  nan ],
	[    25,    0.13,   0.04,    0.20,   0.03,   0.19,   0.03,   1.85,    0.00,  4.26e-16,  5.68e-16,  4.26e-16,  nan ],
	[    26,    0.15,   0.04,    0.21,   0.03,   0.20,   0.03,   1.85,    0.00,  3.42e-16,  4.32e-16,  4.58e-16,  nan ],
	[    27,    0.15,   0.04,    0.22,   0.03,   0.22,   0.03,   1.99,    0.00,  5.43e-16,  5.43e-16,  3.96e-16,  nan ],
	[    28,    0.16,   0.04,    0.23,   0.03,   0.23,   0.03,   2.13,    0.00,  4.26e-16,  3.83e-16,  4.01e-16,  nan ],
	[    29,    0.18,   0.04,    0.25,   0.03,   0.25,   0.03,   2.28,    0.00,  3.68e-16,  3.47e-16,  2.88e-16,  nan ],
	[    30,    0.20,   0.04,    0.27,   0.03,   0.27,   0.03,   1.98,    0.00,  3.35e-16,  3.35e-16,  5.92e-16,  nan ],
	[    31,    0.21,   0.04,    0.27,   0.03,   0.28,   0.03,   2.11,    0.00,  4.73e-16,  3.44e-16,  3.44e-16,  nan ],
	[    32,    0.23,   0.04,    0.30,   0.03,   0.30,   0.03,   2.12,    0.00,  4.58e-16,  4.58e-16,  4.58e-16,  nan ],
	[    33,    0.24,   0.04,    0.22,   0.04,   0.30,   0.03,   1.82,    0.01,  4.81e-16,  4.81e-16,  4.44e-16,  nan ],
	[    34,    0.27,   0.04,    0.24,   0.04,   0.33,   0.03,   2.38,    0.00,  7.01e-16,  7.01e-16,  4.93e-16,  nan ],
	[    35,    0.27,   0.04,    0.26,   0.04,   0.37,   0.03,   2.04,    0.01,  4.13e-16,  4.54e-16,  4.19e-16,  nan ],
	[    36,    0.28,   0.04,    0.28,   0.04,   0.37,   0.03,   2.83,    0.00,  4.22e-16,  4.41e-16,  6.00e-16,  nan ],
	[    37,    0.30,   0.04,    0.30,   0.04,   0.39,   0.03,   2.81,    0.00,  4.29e-16,  5.81e-16,  4.19e-16,  nan ],
	[    38,    0.33,   0.04,    0.32,   0.04,   0.40,   0.03,   2.40,    0.01,  7.54e-16,  7.48e-16,  6.27e-16,  nan ],
	[    39,    0.34,   0.04,    0.33,   0.04,   0.42,   0.03,   2.52,    0.01,  5.47e-16,  6.11e-16,  6.11e-16,  nan ],
	[    40,    0.36,   0.04,    0.36,   0.04,   0.46,   0.03,   2.65,    0.01,  6.40e-16,  5.02e-16,  5.62e-16,  nan ],
	[    41,    0.36,   0.04,    0.37,   0.04,   0.48,   0.03,   2.78,    0.01,  5.29e-16,  5.27e-16,  5.21e-16,  nan ],
	[    42,    0.40,   0.04,    0.39,   0.04,   0.50,   0.03,   2.45,    0.01,  5.15e-16,  5.15e-16,  3.78e-16,  nan ],
	[    43,    0.39,   0.04,    0.40,   0.04,   0.49,   0.03,   2.57,    0.01,  5.03e-16,  5.03e-16,  5.03e-16,  nan ],
	[    44,    0.42,   0.04,    0.42,   0.04,   0.53,   0.03,   2.69,    0.01,  5.11e-16,  4.91e-16,  6.46e-16,  nan ],
	[    45,    0.43,   0.04,    0.43,   0.04,   0.56,   0.03,   2.81,    0.01,  8.50e-16,  8.05e-16,  8.50e-16,  nan ],
	[    46,    0.47,   0.04,    0.45,   0.04,   0.58,   0.03,   2.53,    0.01,  5.18e-16,  6.29e-16,  4.88e-16,  nan ],
	[    47,    0.47,   0.04,    0.47,   0.04,   0.59,   0.03,   2.64,    0.01,  6.46e-16,  7.57e-16,  6.06e-16,  nan ],
	[    48,    0.47,   0.04,    0.49,   0.04,   0.61,   0.03,   2.75,    0.01,  4.97e-16,  4.68e-16,  5.34e-16,  nan ],
	[    49,    0.47,   0.04,    0.49,   0.04,   0.62,   0.03,   2.86,    0.01,  7.25e-16,  5.80e-16,  5.85e-16,  nan ],
	[    50,    0.50,   0.04,    0.51,   0.04,   0.64,   0.03,   2.88,    0.01,  5.68e-16,  5.70e-16,  6.03e-16,  nan ],
	[    51,    0.55,   0.04,    0.55,   0.04,   0.65,   0.03,   3.10,    0.01,  5.74e-16,  5.57e-16,  5.74e-16,  nan ],
	[    52,    0.54,   0.04,    0.57,   0.04,   0.70,   0.03,   3.11,    0.01,  7.36e-16,  6.83e-16,  6.83e-16,  nan ],
	[    53,    0.59,   0.04,    0.58,   0.04,   0.72,   0.03,   2.85,    0.01,  5.47e-16,  4.24e-16,  5.36e-16,  nan ],
	[    54,    0.61,   0.04,    0.58,   0.04,   0.75,   0.03,   2.96,    0.01,  6.87e-16,  6.61e-16,  6.71e-16,  nan ],
	[    55,    0.62,   0.04,    0.62,   0.04,   0.78,   0.03,   2.82,    0.01,  5.33e-16,  5.52e-16,  5.33e-16,  nan ],
	[    56,    0.66,   0.04,    0.65,   0.04,   0.81,   0.03,   3.18,    0.01,  5.38e-16,  4.57e-16,  4.57e-16,  nan ],
	[    57,    0.64,   0.04,    0.67,   0.04,   0.81,   0.03,   2.94,    0.01,  6.71e-16,  6.36e-16,  5.14e-16,  nan ],
	[    58,    0.66,   0.04,    0.67,   0.04,   0.86,   0.03,   3.05,    0.01,  7.35e-16,  6.93e-16,  7.38e-16,  nan ],
	[    59,    0.68,   0.04,    0.70,   0.04,   0.86,   0.03,   3.15,    0.01,  4.34e-16,  4.97e-16,  4.93e-16,  nan ],
	[    60,    0.74,   0.04,    0.72,   0.04,   0.92,   0.03,   3.26,    0.01,  5.30e-16,  4.88e-16,  4.74e-16,  nan ],
	[    61,    0.73,   0.04,    0.73,   0.04,   0.92,   0.03,   3.05,    0.01,  8.40e-16,  7.81e-16,  1.10e-15,  nan ],
	[    62,    0.75,   0.04,    0.75,   0.04,   0.99,   0.03,   3.89,    0.01,  6.88e-16,  6.88e-16,  5.84e-16,  nan ],
	[    63,    0.82,   0.04,    0.77,   0.04,   0.95,   0.03,   3.59,    0.01,  5.64e-16,  6.86e-16,  4.79e-16,  nan ],
	[    64,    0.93,   0.04,    0.84,   0.04,   1.04,   0.03,   3.35,    0.01,  5.55e-16,  4.97e-16,  4.97e-16,  nan ],
	[    65,    0.72,   0.05,    0.78,   0.04,   1.02,   0.03,   3.45,    0.01,  4.89e-16,  6.65e-16,  4.89e-16,  nan ],
	[    66,    0.79,   0.05,    0.81,   0.04,   1.05,   0.03,   3.25,    0.01,  5.62e-16,  6.89e-16,  4.81e-16,  nan ],
	[    67,    0.80,   0.05,    0.87,   0.04,   1.08,   0.03,   3.28,    0.01,  6.50e-16,  8.55e-16,  8.55e-16,  nan ],
	[    68,    0.82,   0.05,    0.90,   0.04,   1.14,   0.03,   3.37,    0.01,  6.36e-16,  5.33e-16,  5.22e-16,  nan ],
	[    69,    0.85,   0.05,    0.93,   0.04,   1.14,   0.03,   3.26,    0.01,  6.51e-16,  6.51e-16,  6.18e-16,  nan ],
	[    70,    0.89,   0.04,    0.93,   0.04,   1.18,   0.03,   5.09,    0.01,  6.42e-16,  6.11e-16,  6.28e-16,  nan ],
	[    71,    0.86,   0.05,    0.94,   0.04,   1.24,   0.03,   4.11,    0.01,  6.41e-16,  6.17e-16,  6.33e-16,  nan ],
	[    72,    0.88,   0.05,    0.96,   0.04,   1.21,   0.04,   3.86,    0.01,  1.01e-15,  9.92e-16,  7.96e-16,  nan ],
	[    73,    0.93,   0.05,    0.99,   0.04,   1.24,   0.04,   3.88,    0.01,  9.93e-16,  7.85e-16,  7.79e-16,  nan ],
	[    74,    0.95,   0.05,    1.02,   0.04,   1.28,   0.04,   4.08,    0.01,  9.06e-16,  8.59e-16,  7.92e-16,  nan ],
	[    75,    0.93,   0.05,    1.04,   0.04,   1.36,   0.03,   4.58,    0.01,  8.00e-16,  7.94e-16,  7.87e-16,  nan ],
	[    76,    0.94,   0.05,    1.09,   0.04,   1.35,   0.03,   5.20,    0.01,  7.54e-16,  5.91e-16,  7.48e-16,  nan ],
	[    77,    1.01,   0.05,    1.10,   0.04,   1.38,   0.04,   3.76,    0.01,  7.61e-16,  7.44e-16,  5.61e-16,  nan ],
	[    78,    1.06,   0.05,    1.13,   0.04,   1.46,   0.03,   4.16,    0.01,  8.15e-16,  7.29e-16,  7.78e-16,  nan ],
	[    79,    1.04,   0.05,    1.13,   0.05,   1.46,   0.03,   5.08,    0.01,  7.68e-16,  9.04e-16,  7.25e-16,  nan ],
	[    80,    1.11,   0.05,    1.19,   0.04,   1.49,   0.04,   4.29,    0.01,  7.32e-16,  6.40e-16,  5.62e-16,  nan ],
	[    81,    1.14,   0.05,    1.19,   0.05,   1.48,   0.04,   4.87,    0.01,  5.70e-16,  7.57e-16,  7.75e-16,  nan ],
	[    82,    1.17,   0.05,    1.24,   0.04,   1.57,   0.03,   4.59,    0.01,  6.25e-16,  6.93e-16,  5.30e-16,  nan ],
	[    83,    1.08,   0.05,    1.27,   0.04,   1.60,   0.04,   5.60,    0.01,  6.90e-16,  7.06e-16,  8.56e-16,  nan ],
	[    84,    1.20,   0.05,    1.30,   0.04,   1.60,   0.04,   4.08,    0.01,  7.80e-16,  6.98e-16,  5.67e-16,  nan ],
	[    85,    1.25,   0.05,    1.34,   0.04,   1.68,   0.04,   4.93,    0.01,  7.01e-16,  6.70e-16,  6.72e-16,  nan ],
	[    86,    1.26,   0.05,    1.34,   0.05,   1.67,   0.04,   4.59,    0.01,  7.79e-16,  8.26e-16,  9.95e-16,  nan ],
	[    87,    1.28,   0.05,    1.37,   0.05,   1.71,   0.04,   5.17,    0.01,  6.98e-16,  5.17e-16,  5.89e-16,  nan ],
	[    88,    1.26,   0.05,    1.44,   0.04,   1.75,   0.04,   6.29,    0.01,  1.03e-15,  8.43e-16,  7.22e-16,  nan ],
	[    89,    1.29,   0.05,    1.40,   0.05,   1.74,   0.04,   5.41,    0.01,  1.12e-15,  8.60e-16,  1.01e-15,  nan ],
	[    90,    1.37,   0.05,    1.46,   0.05,   1.83,   0.04,   4.68,    0.01,  8.14e-16,  7.89e-16,  7.06e-16,  nan ],
	[   100,    1.56,   0.05,    1.69,   0.05,   2.08,   0.04,   4.80,    0.02,  1.02e-15,  9.10e-16,  1.02e-15,  nan ],
	[   110,    1.96,   0.05,    1.96,   0.05,   2.57,   0.04,   6.14,    0.02,  9.08e-16,  7.79e-16,  6.59e-16,  nan ],
	[   120,    2.24,   0.05,    2.39,   0.05,   2.84,   0.04,   7.30,    0.02,  7.58e-16,  7.20e-16,  7.49e-16,  nan ],
	[   130,    2.48,   0.06,    2.48,   0.06,   3.19,   0.04,   7.17,    0.02,  1.32e-15,  1.11e-15,  1.34e-15,  nan ],
	[   140,    2.78,   0.06,    2.99,   0.05,   3.78,   0.04,   7.91,    0.02,  1.02e-15,  8.18e-16,  8.12e-16,  nan ],
	[   150,    3.14,   0.06,    3.24,   0.06,   4.24,   0.04,   7.26,    0.03,  1.14e-15,  1.14e-15,  1.14e-15,  nan ],
	[   160,    3.39,   0.06,    3.82,   0.05,   4.61,   0.04,   9.03,    0.02,  1.07e-15,  9.57e-16,  8.93e-16,  nan ],
	[   170,    3.90,   0.06,    3.84,   0.06,   4.94,   0.05,   7.76,    0.03,  1.03e-15,  1.02e-15,  1.02e-15,  nan ],
	[   180,    4.22,   0.06,    4.22,   0.06,   5.43,   0.05,   7.67,    0.03,  9.99e-16,  1.01e-15,  9.48e-16,  nan ],
	[   190,    4.84,   0.06,    4.79,   0.06,   5.96,   0.05,   9.39,    0.03,  1.25e-15,  1.06e-15,  1.06e-15,  nan ],
	[   200,    4.90,   0.07,    5.45,   0.06,   6.47,   0.05,   9.52,    0.03,  1.30e-15,  1.46e-15,  1.28e-15,  nan ],
	[   210,    5.30,   0.07,    5.48,   0.06,   6.96,   0.05,   9.55,    0.04,  1.03e-15,  1.35e-15,  1.08e-15,  nan ],
	[   220,    5.66,   0.07,    5.66,   0.07,   7.50,   0.05,   9.29,    0.04,  9.69e-16,  1.17e-15,  1.05e-15,  nan ],
	[   230,    5.69,   0.07,    5.92,   0.07,   7.87,   0.05,   9.87,    0.04,  1.11e-15,  1.17e-15,  9.96e-16,  nan ],
	[   240,    6.53,   0.07,    6.92,   0.07,   8.57,   0.05,   9.44,    0.05,  1.28e-15,  1.21e-15,  1.19e-15,  nan ],
	[   250,    7.27,   0.07,    7.18,   0.07,   8.98,   0.06,   9.68,    0.05,  1.60e-15,  1.38e-15,  1.37e-15,  nan ],
	[   260,    6.98,   0.08,    7.36,   0.07,   9.39,   0.06,   9.55,    0.06,  1.54e-15,  1.32e-15,  1.32e-15,  nan ],
	[   270,    7.62,   0.08,    8.04,   0.07,   9.92,   0.06,   9.76,    0.06,  1.34e-15,  1.32e-15,  1.28e-15,  nan ],
	[   280,    8.09,   0.08,    8.40,   0.08,  10.33,   0.06,  10.02,    0.06,  1.73e-15,  1.77e-15,  1.45e-15,  nan ],
	[   290,    8.57,   0.08,    8.78,   0.08,  10.54,   0.06,   9.68,    0.07,  1.98e-15,  2.16e-15,  1.96e-15,  nan ],
	[   300,    8.82,   0.08,    9.17,   0.08,  11.16,   0.06,   9.67,    0.07,  1.36e-15,  1.41e-15,  1.59e-15,  nan ],
	[   310,    9.53,   0.08,    9.53,   0.08,  11.70,   0.07,  10.16,    0.08,  1.30e-15,  1.47e-15,  1.30e-15,  nan ],
	[   320,   10.30,   0.08,   11.10,   0.07,  12.11,   0.07,  10.27,    0.08,  1.60e-15,  1.45e-15,  1.43e-15,  nan ],
	[   330,    9.74,   0.09,   10.67,   0.08,  12.70,   0.07,  10.06,    0.09,  1.72e-15,  1.48e-15,  1.35e-15,  nan ],
	[   340,   10.12,   0.09,   10.09,   0.09,  13.25,   0.07,   9.99,    0.09,  1.50e-15,  1.34e-15,  1.20e-15,  nan ],
	[   350,   11.19,   0.09,   10.92,   0.09,  14.04,   0.07,   9.92,    0.10,  1.50e-15,  1.70e-15,  1.50e-15,  nan ],
	[   360,   11.43,   0.09,   11.83,   0.09,  14.22,   0.07,  10.02,    0.10,  1.56e-15,  1.59e-15,  1.42e-15,  nan ],
	[   370,   12.07,   0.09,   12.07,   0.09,  14.64,   0.08,  10.48,    0.10,  2.48e-15,  1.92e-15,  2.00e-15,  nan ],
	[   380,   12.60,   0.09,   12.47,   0.09,  15.90,   0.07,  10.16,    0.11,  1.92e-15,  1.74e-15,  1.81e-15,  nan ],
	[   390,   12.00,   0.10,   12.11,   0.10,  16.06,   0.08,  10.17,    0.12,  1.90e-15,  1.76e-15,  1.55e-15,  nan ],
	[   400,   12.83,   0.10,   13.51,   0.10,  16.68,   0.08,  10.28,    0.12,  1.48e-15,  1.43e-15,  1.57e-15,  nan ],
	[   410,   13.10,   0.10,   14.08,   0.10,  16.90,   0.08,  10.24,    0.13,  1.68e-15,  1.62e-15,  1.68e-15,  nan ],
	[   420,   13.91,   0.10,   13.62,   0.10,  17.47,   0.08,   9.77,    0.14,  1.97e-15,  1.81e-15,  1.67e-15,  nan ],
	[   430,   14.41,   0.10,   14.82,   0.10,  17.89,   0.08,  10.31,    0.14,  1.72e-15,  1.67e-15,  1.60e-15,  nan ],
	[   440,   14.92,   0.10,   14.81,   0.10,  18.73,   0.08,  10.43,    0.15,  1.94e-15,  1.94e-15,  2.07e-15,  nan ],
	[   450,   14.63,   0.11,   14.76,   0.11,  18.48,   0.09,  10.36,    0.16,  1.97e-15,  2.16e-15,  1.88e-15,  nan ],
	[   460,   15.32,   0.11,   16.49,   0.10,  19.52,   0.09,  10.23,    0.17,  1.50e-15,  1.51e-15,  1.73e-15,  nan ],
	[   470,   15.27,   0.12,   15.27,   0.12,  19.94,   0.09,  10.55,    0.17,  2.21e-15,  2.23e-15,  2.19e-15,  nan ],
	[   480,   16.22,   0.11,   18.33,   0.10,  20.57,   0.09,  10.62,    0.17,  2.12e-15,  2.17e-15,  2.33e-15,  nan ],
	[   490,   16.59,   0.12,   16.91,   0.11,  20.94,   0.09,  10.70,    0.18,  2.37e-15,  2.62e-15,  2.12e-15,  nan ],
	[   500,   16.86,   0.12,   15.94,   0.13,  21.30,   0.09,  10.50,    0.19,  1.64e-15,  1.82e-15,  1.71e-15,  nan ],
	[   510,   17.54,   0.12,   16.55,   0.13,  21.99,   0.09,  10.19,    0.20,  1.58e-15,  1.57e-15,  1.78e-15,  nan ],
	[   520,   17.23,   0.13,   17.95,   0.12,  22.41,   0.10,  10.39,    0.21,  1.97e-15,  1.97e-15,  1.97e-15,  nan ],
	[   530,   18.04,   0.12,   17.73,   0.13,  22.51,   0.10,  10.78,    0.21,  1.93e-15,  1.77e-15,  1.63e-15,  nan ],
	[   540,   18.55,   0.13,   18.31,   0.13,  23.20,   0.10,  10.54,    0.22,  1.88e-15,  1.69e-15,  1.70e-15,  nan ],
	[   550,   18.68,   0.13,   17.08,   0.14,  23.56,   0.10,  10.65,    0.23,  2.28e-15,  1.88e-15,  1.89e-15,  nan ],
	[   560,   19.36,   0.13,   18.77,   0.13,  24.14,   0.10,  10.76,    0.23,  2.29e-15,  2.04e-15,  1.92e-15,  nan ],
	[   570,   20.35,   0.13,   19.04,   0.14,  24.62,   0.11,  10.47,    0.25,  2.59e-15,  2.60e-15,  2.40e-15,  nan ],
	[   580,   19.85,   0.14,   19.28,   0.14,  24.98,   0.11,  10.58,    0.26,  2.07e-15,  1.96e-15,  1.85e-15,  nan ],
	[   590,   20.65,   0.14,   19.78,   0.14,  26.08,   0.11,  10.62,    0.26,  2.04e-15,  2.26e-15,  2.17e-15,  nan ],
	[   600,   21.06,   0.14,   20.92,   0.14,  26.50,   0.11,  10.77,    0.27,  2.09e-15,  2.10e-15,  1.90e-15,  nan ],
	[   610,   21.62,   0.14,   20.03,   0.15,  27.09,   0.11,  10.73,    0.28,  2.08e-15,  2.15e-15,  2.22e-15,  nan ],
	[   620,   22.18,   0.14,   21.41,   0.14,  27.51,   0.11,  10.74,    0.29,  2.07e-15,  2.22e-15,  2.03e-15,  nan ],
	[   630,   22.25,   0.14,   21.36,   0.15,  27.70,   0.11,  10.79,    0.29,  1.82e-15,  2.00e-15,  2.02e-15,  nan ],
	[   640,   23.96,   0.14,   22.04,   0.15,  28.52,   0.12,  10.99,    0.30,  1.99e-15,  1.80e-15,  1.96e-15,  nan ],
	[   650,   22.45,   0.15,   22.00,   0.15,  28.48,   0.12,  10.86,    0.31,  2.23e-15,  2.31e-15,  2.31e-15,  nan ],
	[   660,   22.50,   0.16,   23.63,   0.15,  29.36,   0.12,  10.65,    0.33,  3.14e-15,  2.97e-15,  2.80e-15,  nan ],
	[   670,   23.85,   0.15,   22.50,   0.16,  29.72,   0.12,  10.84,    0.33,  2.60e-15,  2.74e-15,  2.59e-15,  nan ],
	[   680,   24.22,   0.15,   23.78,   0.16,  30.61,   0.12,  10.81,    0.34,  2.49e-15,  2.64e-15,  2.39e-15,  nan ],
	[   690,   24.63,   0.15,   23.41,   0.16,  30.55,   0.12,  10.91,    0.35,  2.49e-15,  2.31e-15,  2.48e-15,  nan ],
	[   700,   25.16,   0.16,   24.27,   0.16,  31.44,   0.12,  10.70,    0.37,  2.29e-15,  2.48e-15,  2.45e-15,  nan ],
	[   710,   24.93,   0.16,   22.45,   0.18,  32.04,   0.13,  10.78,    0.38,  2.08e-15,  2.24e-15,  2.05e-15,  nan ],
	[   720,   25.94,   0.16,   24.76,   0.17,  32.76,   0.13,  10.79,    0.39,  2.46e-15,  2.25e-15,  2.23e-15,  nan ],
	[   730,   26.04,   0.16,   25.56,   0.17,  32.64,   0.13,  10.84,    0.39,  2.83e-15,  2.65e-15,  2.81e-15,  nan ],
	[   740,   26.76,   0.16,   25.97,   0.17,  32.08,   0.14,  10.63,    0.41,  2.92e-15,  2.31e-15,  2.30e-15,  nan ],
	[   750,   27.65,   0.16,   27.17,   0.17,  32.44,   0.14,  10.87,    0.41,  2.43e-15,  2.29e-15,  2.44e-15,  nan ],
	[   760,   27.90,   0.17,   26.64,   0.17,  32.15,   0.14,  10.90,    0.42,  3.01e-15,  2.86e-15,  2.85e-15,  nan ],
	[   770,   27.46,   0.17,   28.44,   0.17,  34.19,   0.14,  10.70,    0.44,  3.40e-15,  3.40e-15,  3.26e-15,  nan ],
	[   780,   28.02,   0.17,   27.24,   0.18,  34.61,   0.14,  10.70,    0.46,  2.62e-15,  2.77e-15,  2.48e-15,  nan ],
	[   790,   28.58,   0.17,   28.94,   0.17,  35.20,   0.14,  10.87,    0.46,  2.23e-15,  2.41e-15,  2.25e-15,  nan ],
	[   800,   29.51,   0.17,   29.68,   0.17,  35.86,   0.14,  10.94,    0.47,  2.84e-15,  2.84e-15,  2.99e-15,  nan ],
	[   810,   29.68,   0.18,   29.06,   0.18,  36.28,   0.14,  10.89,    0.48,  2.89e-15,  2.45e-15,  2.62e-15,  nan ],
	[   820,   30.59,   0.18,   29.43,   0.18,  36.17,   0.15,  10.59,    0.51,  2.55e-15,  2.65e-15,  2.65e-15,  nan ],
	[   830,   30.51,   0.18,   30.35,   0.18,  37.84,   0.15,  10.85,    0.51,  2.38e-15,  2.39e-15,  2.50e-15,  nan ],
	[   840,   30.56,   0.19,   31.25,   0.18,  36.21,   0.16,  10.98,    0.52,  3.80e-15,  3.80e-15,  3.53e-15,  nan ],
	[   850,   31.14,   0.19,   29.69,   0.20,  36.19,   0.16,  10.82,    0.54,  2.54e-15,  2.41e-15,  2.41e-15,  nan ],
	[   860,   31.55,   0.19,   32.58,   0.18,  37.50,   0.16,  10.74,    0.55,  2.57e-15,  2.39e-15,  2.41e-15,  nan ],
	[   870,   31.92,   0.19,   26.98,   0.22,  38.66,   0.16,  10.77,    0.56,  2.61e-15,  2.49e-15,  2.49e-15,  nan ],
	[   880,   32.86,   0.19,   31.82,   0.20,  39.08,   0.16,  10.89,    0.57,  2.63e-15,  2.60e-15,  2.65e-15,  nan ],
	[   890,   33.24,   0.19,   33.62,   0.19,  38.47,   0.16,  10.87,    0.58,  2.17e-15,  2.23e-15,  2.19e-15,  nan ],
	[   900,   33.45,   0.19,   34.16,   0.19,  39.86,   0.16,  10.48,    0.62,  2.92e-15,  2.58e-15,  2.45e-15,  nan ],
	[  1000,   37.63,   0.21,   34.97,   0.23,  43.53,   0.18,  10.86,    0.74,  2.75e-15,  2.39e-15,  2.28e-15,  nan ],
	[  1100,   40.58,   0.24,   35.92,   0.27,  27.77,   0.35,  10.57,    0.92,  3.10e-15,  3.31e-15,  3.31e-15,  nan ],
	[  1200,   44.71,   0.26,   38.95,   0.30,  30.43,   0.38,  10.14,    1.14,  3.27e-15,  3.54e-15,  3.03e-15,  nan ],
	[  1300,   47.67,   0.28,   42.18,   0.32,  30.36,   0.45,   9.67,    1.40,  3.71e-15,  4.77e-15,  4.67e-15,  nan ],
	[  1400,   52.67,   0.30,   45.50,   0.34,  31.90,   0.49,   8.82,    1.78,  4.06e-15,  4.23e-15,  4.23e-15,  nan ],
	[  1500,   55.45,   0.32,   46.08,   0.39,  35.83,   0.50,   8.33,    2.16,  3.79e-15,  3.79e-15,  4.40e-15,  nan ],
	[  1600,   60.29,   0.34,   57.59,   0.36,  37.61,   0.55,   8.38,    2.45,  3.87e-15,  3.98e-15,  3.71e-15,  nan ],
	[  1700,   63.40,   0.37,   50.98,   0.45,  39.70,   0.58,   8.24,    2.81,  4.07e-15,  3.89e-15,  3.92e-15,  nan ],
	[  1800,   66.14,   0.39,   53.81,   0.48,  41.51,   0.62,   7.93,    3.27,  4.04e-15,  4.17e-15,  4.17e-15,  nan ],
	[  1900,   71.02,   0.41,   55.25,   0.52,  42.37,   0.68,   8.20,    3.53,  4.44e-15,  4.57e-15,  4.45e-15,  nan ],
	[  2000,   71.83,   0.45,   55.71,   0.57,  44.73,   0.72,   8.44,    3.80,  4.12e-15,  4.09e-15,  4.36e-15,  nan ],
	[  2100,   77.09,   0.46,   56.87,   0.62,  35.13,   1.00,   8.31,    4.25,  4.33e-15,  4.13e-15,  3.90e-15,  nan ],
	[  2200,   80.21,   0.48,   58.54,   0.66,  37.37,   1.04,   8.46,    4.58,  3.99e-15,  4.60e-15,  4.26e-15,  nan ],
	[  2300,   85.89,   0.49,   59.31,   0.71,  39.32,   1.08,   7.58,    5.58,  5.14e-15,  5.16e-15,  5.14e-15,  nan ],
	[  2400,   87.35,   0.53,   73.20,   0.63,  40.37,   1.14,   8.44,    5.46,  4.63e-15,  4.93e-15,  4.38e-15,  nan ],
	[  2500,   88.39,   0.57,   60.21,   0.83,  41.49,   1.21,   8.39,    5.96,  5.48e-15,  5.67e-15,  5.66e-15,  nan ],
	[  2600,   92.00,   0.59,   62.27,   0.87,  41.50,   1.30,   8.44,    6.41,  6.89e-15,  6.86e-15,  6.86e-15,  nan ],
	[  2700,   95.34,   0.61,   63.70,   0.92,  42.34,   1.38,   8.32,    7.01,  5.06e-15,  5.02e-15,  5.08e-15,  nan ],
	[  2800,   99.17,   0.63,   65.10,   0.96,  40.73,   1.54,   8.52,    7.37,  5.39e-15,  5.55e-15,  4.89e-15,  nan ],
	[  2900,  101.96,   0.66,   65.42,   1.03,  45.86,   1.47,   8.45,    7.97,  5.04e-15,  5.06e-15,  5.35e-15,  nan ],
	[  3000,  106.13,   0.68,   66.45,   1.08,  47.26,   1.52,   8.58,    8.39,  5.21e-15,  5.16e-15,  5.10e-15,  nan ],
	[  3100,  109.10,   0.71,   66.88,   1.15,  39.32,   1.96,   8.44,    9.12,  6.08e-15,  5.41e-15,  5.52e-15,  nan ],
	[  3200,  111.18,   0.74,   84.48,   0.97,  40.78,   2.01,   9.40,    8.72,  5.40e-15,  5.55e-15,  5.55e-15,  nan ],
	[  3300,  114.71,   0.76,   65.63,   1.33,  41.59,   2.10,   8.52,   10.22,  5.67e-15,  6.10e-15,  5.81e-15,  nan ],
	[  3400,  118.31,   0.78,   67.38,   1.37,  42.34,   2.19,   8.59,   10.77,  6.46e-15,  6.11e-15,  5.92e-15,  nan ],
	[  3500,  119.57,   0.82,   68.80,   1.43,  43.50,   2.25,   8.23,   11.91,  6.11e-15,  5.59e-15,  5.51e-15,  nan ],
	[  3600,  121.28,   0.86,   70.23,   1.48,  44.80,   2.32,   8.62,   12.03,  5.81e-15,  5.82e-15,  6.10e-15,  nan ],
	[  3700,  125.08,   0.88,   71.94,   1.52,  45.09,   2.43,   8.46,   12.95,  5.44e-15,  5.65e-15,  5.69e-15,  nan ],
	[  3800,  124.67,   0.93,   69.65,   1.66,  45.79,   2.52,   8.57,   13.48,  6.23e-15,  6.12e-15,  5.89e-15,  nan ],
	[  3900,  127.07,   0.96,   69.67,   1.75,  46.87,   2.60,   8.36,   14.56,  5.81e-15,  6.08e-15,  5.63e-15,  nan ],
	[  4000,  124.81,   1.03,   90.74,   1.41,  47.66,   2.69,   8.56,   14.96,  6.16e-15,  6.28e-15,  6.37e-15,  nan ],
	[  4100,  118.74,   1.13,   70.58,   1.91,  40.03,   3.36,   7.91,   17.02,  6.16e-15,  6.89e-15,  6.55e-15,  nan ],
	[  4200,  119.23,   1.18,   72.66,   1.94,  41.23,   3.42,   8.54,   16.53,  7.28e-15,  6.54e-15,  6.54e-15,  nan ],
	[  4300,  123.19,   1.20,   71.31,   2.07,  43.62,   3.39,   8.39,   17.64,  6.06e-15,  6.35e-15,  6.19e-15,  nan ],
	[  4400,  123.57,   1.25,   71.43,   2.17,  44.10,   3.51,   8.61,   17.99,  6.31e-15,  6.39e-15,  6.21e-15,  nan ],
	[  4500,  122.49,   1.32,   73.13,   2.22,  44.33,   3.66,   8.51,   19.05,  6.75e-15,  6.53e-15,  6.80e-15,  nan ],
	[  4600,  124.43,   1.36,   73.00,   2.32,  47.09,   3.60,   8.62,   19.65,  6.95e-15,  7.40e-15,  7.37e-15,  nan ],
	[  4700,  121.57,   1.45,   74.37,   2.38,  46.25,   3.82,   8.54,   20.71,  6.19e-15,  6.62e-15,  6.54e-15,  nan ],
	[  4800,  122.52,   1.50,   96.13,   1.92,  46.64,   3.95,   8.78,   21.01,  7.21e-15,  6.83e-15,  7.21e-15,  nan ],
	[  4900,  122.46,   1.57,   73.67,   2.61,  46.77,   4.11,   8.66,   22.20,  8.24e-15,  7.80e-15,  7.62e-15,  nan ],
	[  5000,  122.73,   1.63,   73.47,   2.72,  47.53,   4.21,   8.84,   22.64,  7.47e-15,  7.83e-15,  7.64e-15,  nan ],
	[  5100,  125.23,   1.66,   74.42,   2.80,  48.79,   4.27,   8.62,   24.14,  8.39e-15,  8.64e-15,  8.40e-15,  nan ],
	[  5200,  123.58,   1.75,   74.00,   2.92,  43.87,   4.93,   8.82,   24.54,  8.76e-15,  8.93e-15,  8.76e-15,  nan ],
	[  5300,  124.05,   1.81,   74.14,   3.03,  44.07,   5.10,   8.68,   25.89,  8.93e-15,  8.59e-15,  8.96e-15,  nan ],
	[  5400,  123.26,   1.89,   75.76,   3.08,  44.53,   5.24,   8.74,   26.71,  7.28e-15,  7.42e-15,  7.64e-15,  nan ],
	[  5500,  123.76,   1.96,   75.16,   3.22,  44.60,   5.43,   8.58,   28.22,  7.53e-15,  6.95e-15,  7.25e-15,  nan ],
	[  5600,  124.36,   2.02,  100.65,   2.49,  45.59,   5.50,   8.70,   28.85,  8.12e-15,  8.45e-15,  8.29e-15,  nan ],
	[  5700,  124.34,   2.09,   76.28,   3.41,  45.89,   5.67,   8.56,   30.36,  8.20e-15,  8.11e-15,  8.18e-15,  nan ],
	[  5800,  125.79,   2.14,   75.49,   3.57,  47.11,   5.71,   8.82,   30.53,  9.28e-15,  8.33e-15,  9.10e-15,  nan ],
	[  5900,  124.52,   2.24,   75.43,   3.69,  47.70,   5.84,   8.64,   32.24,  7.88e-15,  7.56e-15,  7.23e-15,  nan ],
	[  6000,  126.63,   2.27,   77.19,   3.73,  48.87,   5.90,   8.79,   32.78,  7.60e-15,  7.88e-15,  7.89e-15,  nan ],
	[  6100,  126.48,   2.35,   76.96,   3.87,  49.28,   6.04,   8.77,   33.94,  8.49e-15,  9.36e-15,  8.90e-15,  nan ],
	[  6200,  128.33,   2.40,   76.92,   4.00,  44.21,   6.96,   8.88,   34.62,  7.79e-15,  7.88e-15,  7.82e-15,  nan ],
	[  6300,  128.64,   2.47,   78.32,   4.06,  44.65,   7.11,   8.28,   38.37,  8.40e-15,  8.02e-15,  8.72e-15,  nan ],
	[  6400,  130.37,   2.51,   99.72,   3.29,  44.87,   7.30,   9.31,   35.20,  8.53e-15,  8.69e-15,  8.98e-15,  nan ],
	[  6500,  129.73,   2.61,   77.68,   4.35,  44.56,   7.59,   8.65,   39.07,  7.96e-15,  7.22e-15,  8.35e-15,  nan ],
	[  6600,  129.05,   2.70,   78.07,   4.46,  46.14,   7.55,   8.84,   39.44,  8.75e-15,  9.98e-15,  9.18e-15,  nan ],
	[  6700,  129.63,   2.77,   78.89,   4.55,  46.25,   7.77,   8.21,   43.75,  7.78e-15,  7.94e-15,  7.79e-15,  nan ],
	[  6800,  130.11,   2.84,   77.55,   4.77,  46.11,   8.02,   8.38,   44.16,  9.95e-15,  1.02e-14,  9.63e-15,  nan ],
	[  6900,  132.42,   2.88,   77.51,   4.91,  47.32,   8.05,   8.68,   43.87,  8.70e-15,  8.51e-15,  8.58e-15,  nan ],
	[  7000,  132.11,   2.97,   77.44,   5.06,  47.29,   8.29,   8.03,   48.82,  9.23e-15,  8.75e-15,  8.67e-15,  nan ],
	[  7100,  130.84,   3.08,   79.01,   5.11,  48.41,   8.33,   8.19,   49.24,  7.97e-15,  8.42e-15,  7.83e-15,  nan ],
	[  7200,  133.64,   3.10,  104.62,   3.96,  44.57,   9.31,   7.42,   55.87,  7.83e-15,  8.23e-15,  8.59e-15,  nan ],
	[  7300,  134.35,   3.17,   78.00,   5.47,  45.62,   9.35,   8.05,   52.98,  9.41e-15,  9.67e-15,  8.93e-15,  nan ],
	[  7400,  133.10,   3.29,   77.69,   5.64,  46.42,   9.44,   7.93,   55.26,  7.64e-15,  7.70e-15,  8.69e-15,  nan ],
	[  7500,  134.19,   3.35,   79.07,   5.69,  45.24,   9.95,   8.06,   55.85,  8.08e-15,  8.51e-15,  8.18e-15,  nan ],
	[  7600,  133.65,   3.46,   80.06,   5.77,  46.47,   9.95,   7.86,   58.79,  8.45e-15,  8.41e-15,  8.41e-15,  nan ],
	[  7700,  133.93,   3.54,   78.08,   6.08,  46.58,  10.19,   7.94,   59.78,  8.20e-15,  8.11e-15,  8.77e-15,  nan ],
	[  7800,  134.88,   3.61,   80.00,   6.08,  46.99,  10.36,   7.43,   65.54,  8.40e-15,  8.81e-15,  8.86e-15,  nan ],
	[  7900,  135.15,   3.70,   79.34,   6.29,  48.09,  10.39,   7.61,   65.62,  9.47e-15,  9.87e-15,  9.62e-15,  nan ],
	[  8000,  135.98,   3.77,  106.31,   4.82,  48.54,  10.55,   7.72,   66.34,  9.00e-15,  8.96e-15,  9.01e-15,  nan ],
	[  8100,  135.44,   3.88,   81.52,   6.44,  49.33,  10.64,   7.49,   70.09,  8.90e-15,  9.06e-15,  9.18e-15,  nan ],
	[  8200,  132.35,   4.07,   78.47,   6.86,  45.01,  11.95,   7.24,   74.27,  9.72e-15,  8.68e-15,  8.99e-15,  nan ],
	[  8300,  134.90,   4.09,   79.44,   6.94,  45.46,  12.13,   7.25,   76.07,  9.44e-15,  9.66e-15,  9.87e-15,  nan ],
	[  8400,  133.44,   4.23,   79.71,   7.08,  45.43,  12.43,   7.44,   75.88,  8.45e-15,  8.24e-15,  8.49e-15,  nan ],
	[  8500,  135.17,   4.28,   81.17,   7.12,  46.07,  12.55,   7.58,   76.31,  8.87e-15,  9.55e-15,  9.26e-15,  nan ],
	[  8600,  133.05,   4.45,   81.00,   7.31,  47.31,  12.51,   7.51,   78.85,  1.07e-14,  1.17e-14,  1.08e-14,  nan ],
	[  8700,  134.32,   4.51,   79.55,   7.61,  46.78,  12.95,   7.53,   80.44,  9.70e-15,  9.67e-15,  9.25e-15,  nan ],
	[  8800,  132.06,   4.69,  105.78,   5.86,  47.15,  13.14,   7.73,   80.16,  9.47e-15,  9.71e-15,  9.30e-15,  nan ],
	[  8900,  132.62,   4.78,   79.86,   7.94,  47.32,  13.39,   8.08,   78.45,  1.21e-14,  1.29e-14,  1.17e-14,  nan ],
	[  9000,  134.10,   4.83,   80.08,   8.09,  46.93,  13.81,   7.93,   81.68,  9.94e-15,  9.76e-15,  1.00e-14,  nan ],
	[ 10000,  132.85,   6.02,   81.20,   9.85,  49.07,  16.31,   8.17,   97.90,  1.00e-14,  1.21e-14,  1.12e-14,  nan ],
	[ 12000,  133.77,   8.61,  109.13,  10.56,  47.54,  24.24,   8.04,  143.23,  1.21e-14,  1.22e-14,  1.28e-14,  nan ],
	[ 14000,  129.49,  12.11,   82.64,  18.98,  47.09,  33.30,   8.25,  190.13,  1.34e-14,  1.31e-14,  1.34e-14,  nan ],
	[ 16000,  127.06,  16.12,  113.98,  17.97,  47.68,  42.96,   8.86,  231.23,  1.39e-14,  1.28e-14,  1.23e-14,  nan ],
	[ 18000,  124.90,  20.75,   84.69,  30.61,  46.84,  55.34,   8.57,  302.51,  1.60e-14,  1.45e-14,  1.56e-14,  nan ],
	[ 20000,  121.56,  26.33,  116.43,  27.49,  47.09,  67.96,   8.44,  379.07,  1.66e-14,  1.67e-14,  1.79e-14,  nan ],
])

# ------------------------------------------------------------
# file: v1.7.0/cuda7.0-k40c/zpotrf.txt
# numactl --interleave=all ../testing/testing_zpotrf -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000 --lapack
zpotrf = array([
	[    10,    0.87,   0.00,     0.00,  0.00,  0.00e+00,  nan ],
	[    20,    2.38,   0.00,     0.04,  0.00,  0.00e+00,  nan ],
	[    30,    4.28,   0.00,     0.13,  0.00,  0.00e+00,  nan ],
	[    40,    3.94,   0.00,     1.29,  0.00,  0.00e+00,  nan ],
	[    50,    4.84,   0.00,     2.24,  0.00,  0.00e+00,  nan ],
	[    60,    5.33,   0.00,     3.11,  0.00,  0.00e+00,  nan ],
	[    70,    5.24,   0.00,     1.28,  0.00,  0.00e+00,  nan ],
	[    80,    5.90,   0.00,     1.73,  0.00,  0.00e+00,  nan ],
	[    90,    6.04,   0.00,     2.20,  0.00,  0.00e+00,  nan ],
	[   100,    6.28,   0.00,     2.65,  0.00,  0.00e+00,  nan ],
	[   200,   25.81,   0.00,    13.96,  0.00,  0.00e+00,  nan ],
	[   300,   56.16,   0.00,    13.13,  0.00,  4.60e-17,  nan ],
	[   400,   68.43,   0.00,    28.45,  0.00,  9.22e-17,  nan ],
	[   500,   96.67,   0.00,    45.26,  0.00,  8.37e-17,  nan ],
	[   600,  118.04,   0.00,    54.23,  0.01,  1.26e-16,  nan ],
	[   700,  125.19,   0.00,    74.13,  0.01,  1.09e-16,  nan ],
	[   800,  156.41,   0.00,    81.94,  0.01,  9.73e-17,  nan ],
	[   900,  174.76,   0.01,   110.02,  0.01,  8.99e-17,  nan ],
	[  1000,  179.26,   0.01,   133.10,  0.01,  7.99e-17,  nan ],
	[  2000,  216.59,   0.05,   384.82,  0.03,  1.11e-16,  nan ],
	[  3000,  235.99,   0.15,   557.22,  0.06,  1.51e-16,  nan ],
	[  4000,  246.47,   0.35,   683.78,  0.12,  1.28e-16,  nan ],
	[  5000,  247.03,   0.67,   752.88,  0.22,  2.16e-16,  nan ],
	[  6000,  258.11,   1.12,   828.84,  0.35,  1.86e-16,  nan ],
	[  7000,  193.60,   2.36,   878.54,  0.52,  1.65e-16,  nan ],
	[  8000,  259.62,   2.63,   921.87,  0.74,  1.53e-16,  nan ],
	[  9000,  260.80,   3.73,   951.32,  1.02,  2.76e-16,  nan ],
	[ 10000,  262.12,   5.09,   982.70,  1.36,  2.58e-16,  nan ],
	[ 12000,  277.14,   8.31,  1033.33,  2.23,  2.34e-16,  nan ],
	[ 14000,  259.18,  14.12,  1059.99,  3.45,  2.13e-16,  nan ],
	[ 16000,  280.69,  19.46,  1088.03,  5.02,  1.97e-16,  nan ],
	[ 18000,  290.98,  26.73,  1103.11,  7.05,  3.72e-16,  nan ],
	[ 20000,  292.30,  36.50,  1117.33,  9.55,  3.53e-16,  nan ],
])

# numactl --interleave=all ../testing/testing_zpotrf_gpu -N 123 -N 1234 --range 10:90:10 --range 100:900:100 --range 1000:9000:1000 --range 10000:20000:2000
zpotrf_gpu = array([
	[    10,  nan,  nan,     0.00,  0.00,  nan ],
	[    20,  nan,  nan,     0.01,  0.00,  nan ],
	[    30,  nan,  nan,     0.05,  0.00,  nan ],
	[    40,  nan,  nan,     0.10,  0.00,  nan ],
	[    50,  nan,  nan,     0.20,  0.00,  nan ],
	[    60,  nan,  nan,     0.33,  0.00,  nan ],
	[    70,  nan,  nan,     0.50,  0.00,  nan ],
	[    80,  nan,  nan,     0.71,  0.00,  nan ],
	[    90,  nan,  nan,     0.95,  0.00,  nan ],
	[   100,  nan,  nan,     1.20,  0.00,  nan ],
	[   200,  nan,  nan,     7.45,  0.00,  nan ],
	[   300,  nan,  nan,    11.42,  0.00,  nan ],
	[   400,  nan,  nan,    24.92,  0.00,  nan ],
	[   500,  nan,  nan,    42.18,  0.00,  nan ],
	[   600,  nan,  nan,    54.31,  0.01,  nan ],
	[   700,  nan,  nan,    77.55,  0.01,  nan ],
	[   800,  nan,  nan,    85.61,  0.01,  nan ],
	[   900,  nan,  nan,   116.31,  0.01,  nan ],
	[  1000,  nan,  nan,   142.35,  0.01,  nan ],
	[  2000,  nan,  nan,   440.39,  0.02,  nan ],
	[  3000,  nan,  nan,   642.45,  0.06,  nan ],
	[  4000,  nan,  nan,   781.62,  0.11,  nan ],
	[  5000,  nan,  nan,   860.47,  0.19,  nan ],
	[  6000,  nan,  nan,   920.77,  0.31,  nan ],
	[  7000,  nan,  nan,   966.61,  0.47,  nan ],
	[  8000,  nan,  nan,  1004.76,  0.68,  nan ],
	[  9000,  nan,  nan,  1031.70,  0.94,  nan ],
	[ 10000,  nan,  nan,  1054.21,  1.27,  nan ],
	[ 12000,  nan,  nan,  1096.39,  2.10,  nan ],
	[ 14000,  nan,  nan,  1117.84,  3.27,  nan ],
	[ 16000,  nan,  nan,  1139.11,  4.80,  nan ],
	[ 18000,  nan,  nan,  1151.46,  6.75,  nan ],
	[ 20000,  nan,  nan,  1151.52,  9.26,  nan ],
])

