'''OpenGL extension ARM.mali_shader_binary

This module customises the behaviour of the 
OpenGL.raw.GLES2.ARM.mali_shader_binary to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension enables OpenGL ES 2.0 applications running on ARM
	Mali graphics cores to use shaders precompiled with the Mali ESSL
	shader compiler.
	
	The shader objects loaded with this extension are equivalent to
	shaders created from source, i.e. there are no additional
	restrictions on which other shader objects they can be linked to,
	nor on which OpenGL ES states they can be used with.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARM/mali_shader_binary.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.ARM.mali_shader_binary import *
from OpenGL.raw.GLES2.ARM.mali_shader_binary import _EXTENSION_NAME

def glInitMaliShaderBinaryARM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION