# 2021-10-26 Triage Log

Multiple regressions this week, several of which were in rollups, without much
to balance them out on the improvements front.

Triage done by **@simulacrum**.
Revision range: [d45ed7502ad225739270a368528725930f54b7b6..3c8f001d454b1b495f7472d8430ef8fdf10aac11](https://perf.rust-lang.org/?start=d45ed7502ad225739270a368528725930f54b7b6&end=3c8f001d454b1b495f7472d8430ef8fdf10aac11&absolute=false&stat=instructions%3Au)

5 Regressions, 4 Improvements, 3 Mixed; 3 of them in rollups;
35 comparisons made in total

#### Regressions

resolve: Use `NameBinding` for local variables and generic parameters [#89100](https://github.com/rust-lang/rust/issues/89100)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=42983a28ab3c70728da7a9b932b667c978dd898d&end=6162529a01473bbb2427fa27354cbafc3c514eee&stat=instructions:u) (up to 99.5% on `incr-unchanged` builds of `style-servo`)
- Reverted in #90130.

Rollup of 6 pull requests [#90235](https://github.com/rust-lang/rust/issues/90235)
- Very large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=ed08a67566d7d1d9dd2ad928ff21c23e841a4345&end=00d5e42e776da900049fe19087bc9b0057ec70cd&stat=instructions:u) (up to 9.8% on `incr-full` builds of `deeply-nested-async`)
- Probably caused by new compiler-internal lint
  ([#89558](https://github.com/rust-lang/rust/pull/89558)), which appears to be
  run on end-user code (despite being allow-by-default). Suggested a few
  possible fixes or a revert if we can't do so quickly.

Inline CStr::from_ptr [#90007](https://github.com/rust-lang/rust/issues/90007)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=01198792a608b05e624b0127e76dd0753057016c&end=514b3877956dc594823106b66c164f8cdbc8b3da&stat=instructions:u) (up to 0.4% on `incr-unchanged` builds of `helloworld`)
- Regression limited to stress tests and fairly minor. Seems likely to be a
  litle extra work in codegen, as the regressions are all in -opt builds. This
  change is done to permit better optimization, skipping a call to strlen in
  some cases, so seems worthwhile.

Implement coherence checks for negative trait impls [#90104](https://github.com/rust-lang/rust/issues/90104)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=55ccbd090d96ec3bb28dbcb383e65bbfa3c293ff&end=aa5740c715001f981515ed46faaddebf67cb9539&stat=instructions:u) (up to 0.6% on `full` builds of `diesel`)
- Looks like a real regression, but the feature is important and the regression
  is relatively small.

Rollup of 5 pull requests [#90203](https://github.com/rust-lang/rust/issues/90203)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=aa5740c715001f981515ed46faaddebf67cb9539&end=91b931926fd49fc97d1e39f2b8206abf1d77ce7d&stat=instructions:u) (up to 0.6% on `full` builds of `externs`)
- Regression limited to rustdoc, likely due to the addition of code-scraping
  from the examples directory. Does not seem major enough to warrant deep
  investigation, but have left a comment on the likely PR.


#### Improvements

Adopt let_else across the compiler [#89933](https://github.com/rust-lang/rust/issues/89933)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=c2452de12046850b8d4c00ce361569b24ad3ad8d&end=1af55d19c7a9189374d89472f97dc119659bb67e&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `deeply-nested-async`)
- Not clear exactly what the speedup comes from, but seems generally positive.

Revert "resolve: Use NameBinding for local variables and generic parameters" [#90130](https://github.com/rust-lang/rust/issues/90130)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=e015ef5b2633960e7653b744d7a1c3d1d336313a&end=547a6ffee0cf4da9929a9e3d49546dc87d607735&stat=instructions:u) (up to -49.8% on `incr-unchanged` builds of `style-servo`)
- Reverting a regression listed above.

Specialize HashStable for [u8] slices [#90208](https://github.com/rust-lang/rust/issues/90208)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=a99c9d6518690023914abdbaad572634f857c4c2&end=bdcb52851231dc14bc6a7915dc62528cae7b8137&stat=instructions:u) (up to -8.0% on `incr-full` builds of `ctfe-stress-4`)
- Found as part of perf investigation, speeds up primarily CTFE-heavy workloads.

Build the query vtable directly. [#90210](https://github.com/rust-lang/rust/issues/90210)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=41d8c94d454f23239715a6433df79e46df8bce04&end=28d0e75269ad092662fef27f44c6aa029c376d49&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `helloworld`)
- Nice win on many benchmarks, though a small one.


#### Mixed

Rollup of 10 pull requests [#90067](https://github.com/rust-lang/rust/issues/90067)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=1af55d19c7a9189374d89472f97dc119659bb67e&end=42983a28ab3c70728da7a9b932b667c978dd898d&stat=instructions:u) (up to -1.4% on `incr-patched: println` builds of `coercions`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=1af55d19c7a9189374d89472f97dc119659bb67e&end=42983a28ab3c70728da7a9b932b667c978dd898d&stat=instructions:u) (up to 1.1% on `incr-patched: b9b3e592dd cherry picked` builds of `style-servo`)
- Left a comment with a few suggestions, but the regression and improvements
  seem both major and without obvious cause.

Merge the two depkind vtables [#89978](https://github.com/rust-lang/rust/issues/89978)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3d71e749a244890cd370d49963e747cf92f4a037&end=efd0483949496b067cd5f7569d1b28cd3d5d3c72&stat=instructions:u) (up to -2.0% on `incr-unchanged` builds of `helloworld`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3d71e749a244890cd370d49963e747cf92f4a037&end=efd0483949496b067cd5f7569d1b28cd3d5d3c72&stat=instructions:u) (up to 0.9% on `incr-unchanged` builds of `clap-rs`)
- Improvements mostly outweigh the regressions


Make new symbol mangling scheme default for compiler itself. [#90054](https://github.com/rust-lang/rust/issues/90054)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=514b3877956dc594823106b66c164f8cdbc8b3da&end=a3f7c4db0373aa077f86cdd1bf11122845d3b65a&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `deeply-nested-async`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=514b3877956dc594823106b66c164f8cdbc8b3da&end=a3f7c4db0373aa077f86cdd1bf11122845d3b65a&stat=instructions:u) (up to 0.4% on `incr-unchanged` builds of `deep-vector`)
- Mostly improvements, and digging in is hard since tools like rustfilt have
  slightly different output across the symbol mangling boundary. Regressions
  seem limited to a just a few benchmarks and are small enough that this seems
  acceptable.

#### Untriaged Pull Requests

- [#90235 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/90235)
- [#90067 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/90067)
- [#90054 Make new symbol mangling scheme default for compiler itself.](https://github.com/rust-lang/rust/pull/90054)
- [#89939 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89939)
- [#89858 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89858)
- [#89695 Move top part of print_item to Tera templates](https://github.com/rust-lang/rust/pull/89695)
- [#89608 Rollup of 12 pull requests](https://github.com/rust-lang/rust/pull/89608)
- [#89534 Introduce `tcx.get_diagnostic_name`](https://github.com/rust-lang/rust/pull/89534)
- [#89435 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89435)
- [#89405 Fix clippy lints](https://github.com/rust-lang/rust/pull/89405)
- [#89263 Suggest both of immutable and mutable trait implementations](https://github.com/rust-lang/rust/pull/89263)
- [#89165 Fix read_to_end to not grow an exact size buffer](https://github.com/rust-lang/rust/pull/89165)
- [#89125 Don't use projection cache or candidate cache in intercrate mode](https://github.com/rust-lang/rust/pull/89125)
- [#89124 Index and hash HIR as part of lowering](https://github.com/rust-lang/rust/pull/89124)
- [#89103 Migrate in-tree crates to 2021](https://github.com/rust-lang/rust/pull/89103)
- [#89100 resolve: Use `NameBinding` for local variables and generic parameters](https://github.com/rust-lang/rust/pull/89100)
- [#89047 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89047)
- [#89030 Introduce `Rvalue::ShallowInitBox`](https://github.com/rust-lang/rust/pull/89030)
- [#88945 Remove concept of 'completion' from the projection cache](https://github.com/rust-lang/rust/pull/88945)
- [#88880 Rework HIR API to make invocations of the hir_crate query harder.](https://github.com/rust-lang/rust/pull/88880)
- [#88824 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/88824)
- [#88804 Revise never type fallback algorithm](https://github.com/rust-lang/rust/pull/88804)
- [#88719 Point at argument instead of call for their obligations](https://github.com/rust-lang/rust/pull/88719)
- [#88703 Gather module items after lowering.](https://github.com/rust-lang/rust/pull/88703)
- [#88627 Do not preallocate HirIds](https://github.com/rust-lang/rust/pull/88627)
- [#88575 Querify `FnAbi::of_{fn_ptr,instance}` as `fn_abi_of_{fn_ptr,instance}`.](https://github.com/rust-lang/rust/pull/88575)
- [#88540 add `slice::swap_unchecked`](https://github.com/rust-lang/rust/pull/88540)
- [#88308 Morph `layout_raw` query into `layout_of`.](https://github.com/rust-lang/rust/pull/88308)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)

