// generated by diplomat-tool
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * See the [Rust documentation for `PluralCategory`](https://docs.rs/icu/latest/icu/plurals/enum.PluralCategory.html) for more information.
 */


export class PluralCategory {
    #value = undefined;

    static #values = new Map([
        ["Zero", 0],
        ["One", 1],
        ["Two", 2],
        ["Few", 3],
        ["Many", 4],
        ["Other", 5]
    ]);

    static getAllEntries() {
        return PluralCategory.#values.entries();
    }

    #internalConstructor(value) {
        if (arguments.length > 1 && arguments[0] === diplomatRuntime.internalConstructor) {
            // We pass in two internalConstructor arguments to create *new*
            // instances of this type, otherwise the enums are treated as singletons.
            if (arguments[1] === diplomatRuntime.internalConstructor ) {
                this.#value = arguments[2];
                return this;
            }
            return PluralCategory.#objectValues[arguments[1]];
        }

        if (value instanceof PluralCategory) {
            return value;
        }

        let intVal = PluralCategory.#values.get(value);

        // Nullish check, checks for null or undefined
        if (intVal != null) {
            return PluralCategory.#objectValues[intVal];
        }

        throw TypeError(value + " is not a PluralCategory and does not correspond to any of its enumerator values.");
    }

    static fromValue(value) {
        return new PluralCategory(value);
    }

    get value(){
        return [...PluralCategory.#values.keys()][this.#value];
    }

    get ffiValue(){
        return this.#value;
    }
    static #objectValues = [
        new PluralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 0),
        new PluralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 1),
        new PluralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 2),
        new PluralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 3),
        new PluralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 4),
        new PluralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.internalConstructor, 5),
    ];

    static Zero = PluralCategory.#objectValues[0];
    static One = PluralCategory.#objectValues[1];
    static Two = PluralCategory.#objectValues[2];
    static Few = PluralCategory.#objectValues[3];
    static Many = PluralCategory.#objectValues[4];
    static Other = PluralCategory.#objectValues[5];


    /**
     * Construct from a string in the format
     * [specified in TR35](https://unicode.org/reports/tr35/tr35-numbers.html#Language_Plural_Rules)
     *
     * See the [Rust documentation for `get_for_cldr_string`](https://docs.rs/icu/latest/icu/plurals/enum.PluralCategory.html#method.get_for_cldr_string) for more information.
     *
     * See the [Rust documentation for `get_for_cldr_bytes`](https://docs.rs/icu/latest/icu/plurals/enum.PluralCategory.html#method.get_for_cldr_bytes) for more information.
     */
    static getForCldrString(s) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const sSlice = diplomatRuntime.DiplomatBuf.str8(wasm, s);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 5, 4, true);


        const result = wasm.icu4x_PluralCategory_get_for_cldr_string_mv1(diplomatReceive.buffer, ...sSlice.splat());

        try {
            if (!diplomatReceive.resultFlag) {
                return null;
            }
            return new PluralCategory(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    constructor(value) {
        return this.#internalConstructor(...arguments)
    }
}