; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2,X86-SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2,X64-SSE,X64-SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,X64-SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL

;
; Truncate
;

define i1 @trunc_v2i64_v2i1(<2 x i64>) nounwind {
; SSE2-LABEL: trunc_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllq $63, %xmm0
; SSE2-NEXT:    movmskpd %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v2i64_v2i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: trunc_v2i64_v2i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v2i64_v2i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v2i64_v2i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v2i64_v2i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [1,1]
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = trunc <2 x i64> %0 to <2 x i1>
  %b = call i1 @llvm.vector.reduce.or.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v4i32_v4i1(<4 x i32>) nounwind {
; SSE2-LABEL: trunc_v4i32_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v4i32_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: trunc_v4i32_v4i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v4i32_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v4i32_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v4i32_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4294967297,4294967297]
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = trunc <4 x i32> %0 to <4 x i1>
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i16_v8i1(<8 x i16>) nounwind {
; SSE2-LABEL: trunc_v8i16_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    testl $21845, %eax # imm = 0x5555
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v8i16_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: trunc_v8i16_v8i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v8i16_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v8i16_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v8i16_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [281479271743489,281479271743489]
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = trunc <8 x i16> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i8_v16i1(<16 x i8>) nounwind {
; SSE2-LABEL: trunc_v16i8_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v16i8_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: trunc_v16i8_v16i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v16i8_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v16i8_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v16i8_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [72340172838076673,72340172838076673]
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = trunc <16 x i8> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v4i64_v4i1(<4 x i64>) nounwind {
; SSE2-LABEL: trunc_v4i64_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v4i64_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v4i64_v4i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <4 x i64> %0 to <4 x i1>
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i32_v8i1(<8 x i32>) nounwind {
; SSE2-LABEL: trunc_v8i32_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v8i32_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v8i32_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <8 x i32> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i16_v16i1(<16 x i16>) nounwind {
; SSE2-LABEL: trunc_v16i16_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    testl $21845, %eax # imm = 0x5555
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v16i16_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i16_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <16 x i16> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v32i8_v32i1(<32 x i8>) nounwind {
; SSE2-LABEL: trunc_v32i8_v32i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v32i8_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v32i8_v32i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <32 x i8> %0 to <32 x i1>
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i64_v8i1(<8 x i64>) nounwind {
; X86-SSE2-LABEL: trunc_v8i64_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; X86-SSE2-NEXT:    pslld $16, %xmm0
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],mem[0,2]
; X86-SSE2-NEXT:    pslld $16, %xmm2
; X86-SSE2-NEXT:    psrad $16, %xmm2
; X86-SSE2-NEXT:    packssdw %xmm2, %xmm0
; X86-SSE2-NEXT:    psllw $15, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: trunc_v8i64_v8i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; X64-SSE2-NEXT:    pslld $16, %xmm2
; X64-SSE2-NEXT:    psrad $16, %xmm2
; X64-SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; X64-SSE2-NEXT:    pslld $16, %xmm0
; X64-SSE2-NEXT:    psrad $16, %xmm0
; X64-SSE2-NEXT:    packssdw %xmm2, %xmm0
; X64-SSE2-NEXT:    psllw $15, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; X64-SSE2-NEXT:    setne %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v8i64_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1]
; AVX512-NEXT:    vptestmd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <8 x i64> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i32_v16i1(<16 x i32>) nounwind {
; X86-SSE2-LABEL: trunc_v16i32_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    por 8(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    pslld $31, %xmm1
; X86-SSE2-NEXT:    movmskps %xmm1, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: trunc_v16i32_v16i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    por %xmm3, %xmm1
; X64-SSE2-NEXT:    por %xmm2, %xmm0
; X64-SSE2-NEXT:    por %xmm1, %xmm0
; X64-SSE2-NEXT:    pslld $31, %xmm0
; X64-SSE2-NEXT:    movmskps %xmm0, %eax
; X64-SSE2-NEXT:    testl %eax, %eax
; X64-SSE2-NEXT:    setne %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v16i32_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <16 x i32> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v32i16_v32i1(<32 x i16>) nounwind {
; X86-SSE2-LABEL: trunc_v32i16_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    por 8(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    psllw $7, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    testl $21845, %eax # imm = 0x5555
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: trunc_v32i16_v32i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    por %xmm3, %xmm1
; X64-SSE2-NEXT:    por %xmm2, %xmm0
; X64-SSE2-NEXT:    por %xmm1, %xmm0
; X64-SSE2-NEXT:    psllw $7, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    testl $21845, %eax # imm = 0x5555
; X64-SSE2-NEXT:    setne %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v32i16_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v32i16_v32i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <32 x i16> %0 to <32 x i1>
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v64i8_v64i1(<64 x i8>) nounwind {
; X86-SSE2-LABEL: trunc_v64i8_v64i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    por 8(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    psllw $7, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: trunc_v64i8_v64i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    por %xmm3, %xmm1
; X64-SSE2-NEXT:    por %xmm2, %xmm0
; X64-SSE2-NEXT:    por %xmm1, %xmm0
; X64-SSE2-NEXT:    psllw $7, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    testl %eax, %eax
; X64-SSE2-NEXT:    setne %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v64i8_v64i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v64i8_v64i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <64 x i8> %0 to <64 x i1>
  %b = call i1 @llvm.vector.reduce.or.v64i1(<64 x i1> %a)
  ret i1 %b
}

;
; Comparison With Zero
;

define i1 @icmp0_v2i64_v2i1(<2 x i64>) nounwind {
; SSE2-LABEL: icmp0_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    movmskpd %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v2i64_v2i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm0, %xmm1
; SSE41-NEXT:    movmskpd %xmm1, %eax
; SSE41-NEXT:    testl %eax, %eax
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: icmp0_v2i64_v2i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX1OR2-NEXT:    vtestpd %xmm0, %xmm0
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v2i64_v2i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $3, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v2i64_v2i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $3, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v2i64_v2i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmq %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <2 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v4i32_v4i1(<4 x i32>) nounwind {
; SSE-LABEL: icmp0_v4i32_v4i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    movmskps %xmm1, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1OR2-LABEL: icmp0_v4i32_v4i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1OR2-NEXT:    vtestps %xmm0, %xmm0
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v4i32_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $15, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v4i32_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $15, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v4i32_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmd %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <4 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v8i16_v8i1(<8 x i16>) nounwind {
; SSE-LABEL: icmp0_v8i16_v8i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpeqw %xmm0, %xmm1
; SSE-NEXT:    pmovmskb %xmm1, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1OR2-LABEL: icmp0_v8i16_v8i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpmovmskb %xmm0, %eax
; AVX1OR2-NEXT:    testl %eax, %eax
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v8i16_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v8i16_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestnmw %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v8i16_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmw %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i16> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v16i8_v16i1(<16 x i8>) nounwind {
; SSE-LABEL: icmp0_v16i8_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE-NEXT:    pmovmskb %xmm1, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1OR2-LABEL: icmp0_v16i8_v16i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1OR2-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpmovmskb %xmm0, %eax
; AVX1OR2-NEXT:    testl %eax, %eax
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v16i8_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovmskb %xmm0, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v16i8_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v16i8_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmb %xmm0, %xmm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <16 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v4i64_v4i1(<4 x i64>) nounwind {
; SSE2-LABEL: icmp0_v4i64_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,3],xmm1[1,3]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE2-NEXT:    andps %xmm2, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v4i64_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm2, %xmm2
; SSE41-NEXT:    pcmpeqq %xmm2, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE41-NEXT:    packssdw %xmm1, %xmm0
; SSE41-NEXT:    movmskps %xmm0, %eax
; SSE41-NEXT:    testl %eax, %eax
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp0_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vtestpd %xmm0, %xmm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vtestpd %ymm0, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v4i64_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $15, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v4i64_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $15, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v4i64_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmq %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <4 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v8i32_v8i1(<8 x i32>) nounwind {
; SSE-LABEL: icmp0_v8i32_v8i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqd %xmm2, %xmm1
; SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: icmp0_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vtestps %xmm0, %xmm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vtestps %ymm0, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v8i32_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v8i32_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v8i32_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmd %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v16i16_v16i1(<16 x i16>) nounwind {
; SSE-LABEL: icmp0_v16i16_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqw %xmm2, %xmm1
; SSE-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: icmp0_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v16i16_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v16i16_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestnmw %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v16i16_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmw %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <16 x i16> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v32i8_v32i1(<32 x i8>) nounwind {
; SSE-LABEL: icmp0_v32i8_v32i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqb %xmm2, %xmm1
; SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1-LABEL: icmp0_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v32i8_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovmskb %ymm0, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v32i8_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestd %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v32i8_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmb %ymm0, %ymm0, %k0
; AVX512VL-NEXT:    kortestd %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <32 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v8i64_v8i1(<8 x i64>) nounwind {
; X86-SSE2-LABEL: icmp0_v8i64_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpeqd %xmm3, %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm1[1,0,3,2]
; X86-SSE2-NEXT:    pand %xmm1, %xmm4
; X86-SSE2-NEXT:    pcmpeqd %xmm3, %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    packssdw %xmm4, %xmm1
; X86-SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,0,3,2]
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqd 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm3[1,0,3,2]
; X86-SSE2-NEXT:    pand %xmm3, %xmm2
; X86-SSE2-NEXT:    packssdw %xmm2, %xmm0
; X86-SSE2-NEXT:    packssdw %xmm0, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp0_v8i64_v8i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pxor %xmm4, %xmm4
; X64-SSE2-NEXT:    pcmpeqd %xmm4, %xmm3
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm3[1,0,3,2]
; X64-SSE2-NEXT:    pand %xmm3, %xmm5
; X64-SSE2-NEXT:    pcmpeqd %xmm4, %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,0,3,2]
; X64-SSE2-NEXT:    pand %xmm2, %xmm3
; X64-SSE2-NEXT:    packssdw %xmm5, %xmm3
; X64-SSE2-NEXT:    pcmpeqd %xmm4, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; X64-SSE2-NEXT:    pand %xmm1, %xmm2
; X64-SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X64-SSE2-NEXT:    pand %xmm0, %xmm1
; X64-SSE2-NEXT:    packssdw %xmm2, %xmm1
; X64-SSE2-NEXT:    packssdw %xmm3, %xmm1
; X64-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X64-SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; X64-SSE2-NEXT:    setne %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp0_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm4, %xmm4
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm3
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm2
; SSE41-NEXT:    packssdw %xmm3, %xmm2
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm0
; SSE41-NEXT:    packssdw %xmm1, %xmm0
; SSE41-NEXT:    packssdw %xmm2, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    testl %eax, %eax
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp0_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vtestps %xmm0, %xmm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vtestps %ymm0, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v8i64_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v8i64_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v8i64_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v16i32_v16i1(<16 x i32>) nounwind {
; X86-SSE2-LABEL: icmp0_v16i32_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpeqd %xmm3, %xmm1
; X86-SSE2-NEXT:    pcmpeqd %xmm3, %xmm0
; X86-SSE2-NEXT:    packssdw %xmm1, %xmm0
; X86-SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; X86-SSE2-NEXT:    pcmpeqd 8(%ebp), %xmm3
; X86-SSE2-NEXT:    packssdw %xmm3, %xmm2
; X86-SSE2-NEXT:    packsswb %xmm2, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp0_v16i32_v16i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pxor %xmm4, %xmm4
; X64-SSE-NEXT:    pcmpeqd %xmm4, %xmm3
; X64-SSE-NEXT:    pcmpeqd %xmm4, %xmm2
; X64-SSE-NEXT:    packssdw %xmm3, %xmm2
; X64-SSE-NEXT:    pcmpeqd %xmm4, %xmm1
; X64-SSE-NEXT:    pcmpeqd %xmm4, %xmm0
; X64-SSE-NEXT:    packssdw %xmm1, %xmm0
; X64-SSE-NEXT:    packsswb %xmm2, %xmm0
; X64-SSE-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp0_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp0_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <16 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v32i16_v32i1(<32 x i16>) nounwind {
; X86-SSE2-LABEL: icmp0_v32i16_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpeqw %xmm3, %xmm1
; X86-SSE2-NEXT:    pcmpeqw %xmm3, %xmm2
; X86-SSE2-NEXT:    pcmpeqw %xmm3, %xmm0
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqw 8(%ebp), %xmm3
; X86-SSE2-NEXT:    por %xmm1, %xmm3
; X86-SSE2-NEXT:    packsswb %xmm3, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp0_v32i16_v32i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pxor %xmm4, %xmm4
; X64-SSE-NEXT:    pcmpeqw %xmm4, %xmm2
; X64-SSE-NEXT:    pcmpeqw %xmm4, %xmm0
; X64-SSE-NEXT:    por %xmm2, %xmm0
; X64-SSE-NEXT:    pcmpeqw %xmm4, %xmm3
; X64-SSE-NEXT:    pcmpeqw %xmm4, %xmm1
; X64-SSE-NEXT:    por %xmm3, %xmm1
; X64-SSE-NEXT:    packsswb %xmm1, %xmm0
; X64-SSE-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp0_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v32i16_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v32i16_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptestnmw %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestd %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v32i16_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmw %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kortestd %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <32 x i16> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v64i8_v64i1(<64 x i8>) nounwind {
; X86-SSE2-LABEL: icmp0_v64i8_v64i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pxor %xmm3, %xmm3
; X86-SSE2-NEXT:    pcmpeqb %xmm3, %xmm1
; X86-SSE2-NEXT:    pcmpeqb %xmm3, %xmm2
; X86-SSE2-NEXT:    pcmpeqb %xmm3, %xmm0
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqb 8(%ebp), %xmm3
; X86-SSE2-NEXT:    por %xmm1, %xmm3
; X86-SSE2-NEXT:    por %xmm0, %xmm3
; X86-SSE2-NEXT:    pmovmskb %xmm3, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp0_v64i8_v64i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pxor %xmm4, %xmm4
; X64-SSE-NEXT:    pcmpeqb %xmm4, %xmm2
; X64-SSE-NEXT:    pcmpeqb %xmm4, %xmm0
; X64-SSE-NEXT:    por %xmm2, %xmm0
; X64-SSE-NEXT:    pcmpeqb %xmm4, %xmm3
; X64-SSE-NEXT:    pcmpeqb %xmm4, %xmm1
; X64-SSE-NEXT:    por %xmm3, %xmm1
; X64-SSE-NEXT:    por %xmm0, %xmm1
; X64-SSE-NEXT:    pmovmskb %xmm1, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp0_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm4
; AVX1-NEXT:    vpor %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v64i8_v64i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm1
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm1, %ymm1
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovmskb %ymm0, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v64i8_v64i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512BW-NEXT:    kortestq %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v64i8_v64i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vptestnmb %zmm0, %zmm0, %k0
; AVX512VL-NEXT:    kortestq %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <64 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.or.v64i1(<64 x i1> %a)
  ret i1 %b
}

; Comparison
;

define i1 @icmp_v2i64_v2i1(<2 x i64>, <2 x i64>) nounwind {
; SSE2-LABEL: icmp_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm0, %xmm1
; SSE2-NEXT:    movmskpd %xmm1, %eax
; SSE2-NEXT:    testl %eax, %eax
; SSE2-NEXT:    setne %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp_v2i64_v2i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqq %xmm1, %xmm0
; SSE41-NEXT:    movmskpd %xmm0, %eax
; SSE41-NEXT:    testl %eax, %eax
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: icmp_v2i64_v2i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX1OR2-NEXT:    vtestpd %xmm0, %xmm0
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v2i64_v2i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $3, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v2i64_v2i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $3, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v2i64_v2i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <2 x i64> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v4i32_v4i1(<4 x i32>, <4 x i32>) nounwind {
; SSE-LABEL: icmp_v4i32_v4i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE-NEXT:    movmskps %xmm0, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1OR2-LABEL: icmp_v4i32_v4i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1OR2-NEXT:    vtestps %xmm0, %xmm0
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v4i32_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $15, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v4i32_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $15, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v4i32_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <4 x i32> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i16_v8i1(<8 x i16>, <8 x i16>) nounwind {
; SSE-LABEL: icmp_v8i16_v8i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqw %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1OR2-LABEL: icmp_v8i16_v8i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpmovmskb %xmm0, %eax
; AVX1OR2-NEXT:    testl %eax, %eax
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v8i16_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovsxwq %xmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v8i16_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v8i16_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqw %xmm1, %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i16> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i8_v16i1(<16 x i8>, <16 x i8>) nounwind {
; SSE-LABEL: icmp_v16i8_v16i1:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    testl %eax, %eax
; SSE-NEXT:    setne %al
; SSE-NEXT:    ret{{[l|q]}}
;
; AVX1OR2-LABEL: icmp_v16i8_v16i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpmovmskb %xmm0, %eax
; AVX1OR2-NEXT:    testl %eax, %eax
; AVX1OR2-NEXT:    setne %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v16i8_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX512F-NEXT:    vpmovmskb %xmm0, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v16i8_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v16i8_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqb %xmm1, %xmm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    retq
  %a = icmp eq <16 x i8> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v4i64_v4i1(<4 x i64>, <4 x i64>) nounwind {
; X86-SSE2-LABEL: icmp_v4i64_v4i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqd 8(%ebp), %xmm1
; X86-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X86-SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,3],xmm1[1,3]
; X86-SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; X86-SSE2-NEXT:    andps %xmm2, %xmm0
; X86-SSE2-NEXT:    movmskps %xmm0, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v4i64_v4i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqd %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; X64-SSE2-NEXT:    movdqa %xmm0, %xmm2
; X64-SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[1,3],xmm1[1,3]
; X64-SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; X64-SSE2-NEXT:    andps %xmm2, %xmm0
; X64-SSE2-NEXT:    movmskps %xmm0, %eax
; X64-SSE2-NEXT:    testl %eax, %eax
; X64-SSE2-NEXT:    setne %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v4i64_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqq %xmm3, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE41-NEXT:    packssdw %xmm1, %xmm0
; SSE41-NEXT:    movmskps %xmm0, %eax
; SSE41-NEXT:    testl %eax, %eax
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vtestpd %xmm0, %xmm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqq %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vtestpd %ymm0, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v4i64_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb $15, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v4i64_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb $15, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v4i64_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqq %ymm1, %ymm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <4 x i64> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i32_v8i1(<8 x i32>, <8 x i32>) nounwind {
; X86-SSE2-LABEL: icmp_v8i32_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqd 8(%ebp), %xmm1
; X86-SSE2-NEXT:    packssdw %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp_v8i32_v8i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pcmpeqd %xmm3, %xmm1
; X64-SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; X64-SSE-NEXT:    packssdw %xmm1, %xmm0
; X64-SSE-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vtestps %xmm0, %xmm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vtestps %ymm0, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v8i32_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v8i32_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v8i32_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqd %ymm1, %ymm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i32> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i16_v16i1(<16 x i16>, <16 x i16>) nounwind {
; X86-SSE2-LABEL: icmp_v16i16_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pcmpeqw %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqw 8(%ebp), %xmm1
; X86-SSE2-NEXT:    packsswb %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp_v16i16_v16i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pcmpeqw %xmm3, %xmm1
; X64-SSE-NEXT:    pcmpeqw %xmm2, %xmm0
; X64-SSE-NEXT:    packsswb %xmm1, %xmm0
; X64-SSE-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v16i16_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v16i16_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v16i16_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqw %ymm1, %ymm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <16 x i16> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v32i8_v32i1(<32 x i8>, <32 x i8>) nounwind {
; X86-SSE2-LABEL: icmp_v32i8_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pcmpeqb %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqb 8(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp_v32i8_v32i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pcmpeqb %xmm3, %xmm1
; X64-SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; X64-SSE-NEXT:    por %xmm1, %xmm0
; X64-SSE-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v32i8_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovmskb %ymm0, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v32i8_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    # kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512BW-NEXT:    # kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kortestd %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v32i8_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqb %ymm1, %ymm0, %k0
; AVX512VL-NEXT:    kortestd %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <32 x i8> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i64_v8i1(<8 x i64>, <8 x i64>) nounwind {
; X86-SSE2-LABEL: icmp_v8i64_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqd 72(%ebp), %xmm3
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm3[1,0,3,2]
; X86-SSE2-NEXT:    pand %xmm3, %xmm4
; X86-SSE2-NEXT:    pcmpeqd 56(%ebp), %xmm2
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,0,3,2]
; X86-SSE2-NEXT:    pand %xmm2, %xmm3
; X86-SSE2-NEXT:    packssdw %xmm4, %xmm3
; X86-SSE2-NEXT:    pcmpeqd 40(%ebp), %xmm1
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; X86-SSE2-NEXT:    pand %xmm1, %xmm2
; X86-SSE2-NEXT:    pcmpeqd 24(%ebp), %xmm0
; X86-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    packssdw %xmm2, %xmm1
; X86-SSE2-NEXT:    packssdw %xmm3, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v8i64_v8i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqd %xmm7, %xmm3
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm7 = xmm3[1,0,3,2]
; X64-SSE2-NEXT:    pand %xmm3, %xmm7
; X64-SSE2-NEXT:    pcmpeqd %xmm6, %xmm2
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,0,3,2]
; X64-SSE2-NEXT:    pand %xmm2, %xmm3
; X64-SSE2-NEXT:    packssdw %xmm7, %xmm3
; X64-SSE2-NEXT:    pcmpeqd %xmm5, %xmm1
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; X64-SSE2-NEXT:    pand %xmm1, %xmm2
; X64-SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; X64-SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; X64-SSE2-NEXT:    pand %xmm0, %xmm1
; X64-SSE2-NEXT:    packssdw %xmm2, %xmm1
; X64-SSE2-NEXT:    packssdw %xmm3, %xmm1
; X64-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X64-SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; X64-SSE2-NEXT:    setne %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqq %xmm7, %xmm3
; SSE41-NEXT:    pcmpeqq %xmm6, %xmm2
; SSE41-NEXT:    packssdw %xmm3, %xmm2
; SSE41-NEXT:    pcmpeqq %xmm5, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm4, %xmm0
; SSE41-NEXT:    packssdw %xmm1, %xmm0
; SSE41-NEXT:    packssdw %xmm2, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    testl %eax, %eax
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpeqq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vtestps %xmm0, %xmm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqq %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vtestps %ymm0, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v8i64_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v8i64_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v8i64_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqq %zmm1, %zmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <8 x i64> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i32_v16i1(<16 x i32>, <16 x i32>) nounwind {
; X86-SSE2-LABEL: icmp_v16i32_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqd 72(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqd 56(%ebp), %xmm2
; X86-SSE2-NEXT:    packssdw %xmm3, %xmm2
; X86-SSE2-NEXT:    pcmpeqd 40(%ebp), %xmm1
; X86-SSE2-NEXT:    pcmpeqd 24(%ebp), %xmm0
; X86-SSE2-NEXT:    packssdw %xmm1, %xmm0
; X86-SSE2-NEXT:    packsswb %xmm2, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp_v16i32_v16i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pcmpeqd %xmm7, %xmm3
; X64-SSE-NEXT:    pcmpeqd %xmm6, %xmm2
; X64-SSE-NEXT:    packssdw %xmm3, %xmm2
; X64-SSE-NEXT:    pcmpeqd %xmm5, %xmm1
; X64-SSE-NEXT:    pcmpeqd %xmm4, %xmm0
; X64-SSE-NEXT:    packssdw %xmm1, %xmm0
; X64-SSE-NEXT:    packsswb %xmm2, %xmm0
; X64-SSE-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm5
; AVX1-NEXT:    vpcmpeqd %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpackssdw %xmm4, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm4
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpackssdw %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <16 x i32> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v32i16_v32i1(<32 x i16>, <32 x i16>) nounwind {
; X86-SSE2-LABEL: icmp_v32i16_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqw 56(%ebp), %xmm2
; X86-SSE2-NEXT:    pcmpeqw 24(%ebp), %xmm0
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqw 72(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqw 40(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm3, %xmm1
; X86-SSE2-NEXT:    packsswb %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp_v32i16_v32i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pcmpeqw %xmm6, %xmm2
; X64-SSE-NEXT:    pcmpeqw %xmm4, %xmm0
; X64-SSE-NEXT:    por %xmm2, %xmm0
; X64-SSE-NEXT:    pcmpeqw %xmm7, %xmm3
; X64-SSE-NEXT:    pcmpeqw %xmm5, %xmm1
; X64-SSE-NEXT:    por %xmm3, %xmm1
; X64-SSE-NEXT:    packsswb %xmm1, %xmm0
; X64-SSE-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpeqw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqw %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqw %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v32i16_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpcmpeqw %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpcmpeqw %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovsxwd %ymm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v32i16_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kortestd %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v32i16_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqw %zmm1, %zmm0, %k0
; AVX512VL-NEXT:    kortestd %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <32 x i16> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v64i8_v64i1(<64 x i8>, <64 x i8>) nounwind {
; X86-SSE2-LABEL: icmp_v64i8_v64i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqb 56(%ebp), %xmm2
; X86-SSE2-NEXT:    pcmpeqb 24(%ebp), %xmm0
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqb 72(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqb 40(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm3, %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    testl %eax, %eax
; X86-SSE2-NEXT:    setne %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE-LABEL: icmp_v64i8_v64i1:
; X64-SSE:       # %bb.0:
; X64-SSE-NEXT:    pcmpeqb %xmm6, %xmm2
; X64-SSE-NEXT:    pcmpeqb %xmm4, %xmm0
; X64-SSE-NEXT:    por %xmm2, %xmm0
; X64-SSE-NEXT:    pcmpeqb %xmm7, %xmm3
; X64-SSE-NEXT:    pcmpeqb %xmm5, %xmm1
; X64-SSE-NEXT:    por %xmm3, %xmm1
; X64-SSE-NEXT:    por %xmm0, %xmm1
; X64-SSE-NEXT:    pmovmskb %xmm1, %eax
; X64-SSE-NEXT:    testl %eax, %eax
; X64-SSE-NEXT:    setne %al
; X64-SSE-NEXT:    retq
;
; AVX1-LABEL: icmp_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm4
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm5
; AVX1-NEXT:    vpor %xmm4, %xmm5, %xmm4
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm3
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpcmpeqb %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpor %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    testl %eax, %eax
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqb %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpcmpeqb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    testl %eax, %eax
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: icmp_v64i8_v64i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vextracti64x4 $1, %zmm1, %ymm2
; AVX512F-NEXT:    vextracti64x4 $1, %zmm0, %ymm3
; AVX512F-NEXT:    vpcmpeqb %ymm2, %ymm3, %ymm2
; AVX512F-NEXT:    vpcmpeqb %ymm1, %ymm0, %ymm0
; AVX512F-NEXT:    vpor %ymm2, %ymm0, %ymm0
; AVX512F-NEXT:    vpmovmskb %ymm0, %eax
; AVX512F-NEXT:    testl %eax, %eax
; AVX512F-NEXT:    setne %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp_v64i8_v64i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kortestq %k0, %k0
; AVX512BW-NEXT:    setne %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp_v64i8_v64i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpcmpeqb %zmm1, %zmm0, %k0
; AVX512VL-NEXT:    kortestq %k0, %k0
; AVX512VL-NEXT:    setne %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = icmp eq <64 x i8> %0, %1
  %b = call i1 @llvm.vector.reduce.or.v64i1(<64 x i1> %a)
  ret i1 %b
}

declare i1 @llvm.vector.reduce.or.v2i1(<2 x i1>)
declare i1 @llvm.vector.reduce.or.v4i1(<4 x i1>)
declare i1 @llvm.vector.reduce.or.v8i1(<8 x i1>)
declare i1 @llvm.vector.reduce.or.v16i1(<16 x i1>)
declare i1 @llvm.vector.reduce.or.v32i1(<32 x i1>)
declare i1 @llvm.vector.reduce.or.v64i1(<64 x i1>)
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; AVX: {{.*}}
