# ===- Hex numbers writer for wctype include files -----------*- python -*--==#
#
# Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
# See https://llvm.org/LICENSE.txt for license information.
# SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
#
# ==------------------------------------------------------------------------==#


def write_hex_conversions(file_path: str, mappings: dict[int, int]) -> None:
    """Writes the given mapping as hex numbers to the given file path"""
    with open(file_path, "w") as file:
        title = file_path.split("/")[-1].split(".")[0].replace("_", " ")
        file.write(
            f"""//===-- Auto-generated {title} case mappings table -------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
"""
            + "// DO NOT EDIT MANUALLY.\n"
            + "// This file is generated by libc/utils/wctype_utils scripts.\n"
            + "// This file is meant to be included directly into LLVM libc code\n"
            + "// Format: {from_codepoint, to_codepoint}\n"
            + f"// Info: {len(mappings)} entries\n\n"
        )
        for i, key in enumerate(mappings):
            file.write("{")
            file.write(f"0x{key:X}, 0x{mappings[key]:X}")
            if i == len(mappings) - 1:
                file.write("}\n")
            else:
                file.write("},\n")
