/*
  Copyright (C) 1997-2025 Sam Lantinga <slouken@libsdl.org>

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely.
*/

/* Test for availability of ALL SDL3 symbols */

#define SDL_DISABLE_ANALYZE_MACROS

#include <SDL3/SDL.h>
#include <SDL3/SDL_vulkan.h>

#if !defined(SDL_PLATFORM_ANDROID)
extern SDL_DECLSPEC void SDLCALL SDL_GetAndroidActivity(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetAndroidCachePath(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetAndroidExternalStoragePath(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetAndroidExternalStorageState(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetAndroidInternalStoragePath(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetAndroidJNIEnv(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetAndroidSDKVersion(void);
extern SDL_DECLSPEC void SDLCALL SDL_IsChromebook(void);
extern SDL_DECLSPEC void SDLCALL SDL_IsDeXMode(void);
extern SDL_DECLSPEC void SDLCALL SDL_RequestAndroidPermission(void);
extern SDL_DECLSPEC void SDLCALL SDL_SendAndroidBackButton(void);
extern SDL_DECLSPEC void SDLCALL SDL_SendAndroidMessage(void);
extern SDL_DECLSPEC void SDLCALL SDL_ShowAndroidToast(void);
#endif

#if !defined(SDL_PLATFORM_GDK)
extern SDL_DECLSPEC void SDLCALL SDL_GDKResumeGPU(void);
extern SDL_DECLSPEC void SDLCALL SDL_GDKSuspendGPU(void);
extern SDL_DECLSPEC void SDLCALL SDL_GDKSuspendComplete(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetGDKDefaultUser(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetGDKTaskQueue(void);
#endif

#if !defined(SDL_PLATFORM_IOS)
extern SDL_DECLSPEC void SDLCALL SDL_OnApplicationDidChangeStatusBarOrientation(void);
extern SDL_DECLSPEC void SDLCALL SDL_SetiOSAnimationCallback(void);
extern SDL_DECLSPEC void SDLCALL SDL_SetiOSEventPump(void);
#endif

#if !defined(SDL_PLATFORM_LINUX)
extern SDL_DECLSPEC void SDLCALL SDL_SetLinuxThreadPriority(void);
extern SDL_DECLSPEC void SDLCALL SDL_SetLinuxThreadPriorityAndPolicy(void);
#endif

#if !(defined(SDL_PLATFORM_WIN32) || defined(SDL_PLATFORM_WINGDK))
extern SDL_DECLSPEC void SDLCALL SDL_GetDXGIOutputInfo(void);
extern SDL_DECLSPEC void SDLCALL SDL_GetDirect3D9AdapterIndex(void);
#endif

#if !defined(SDL_PLATFORM_WINDOWS)
extern SDL_DECLSPEC void SDLCALL SDL_SetWindowsMessageHook(void);
#endif

extern SDL_DECLSPEC void SDLCALL SDL_RegisterApp(void);
extern SDL_DECLSPEC void SDLCALL SDL_UnregisterApp(void);
extern SDL_DECLSPEC void SDLCALL SDL_EnterAppMainCallbacks(void);
extern SDL_DECLSPEC void SDLCALL SDL_RunApp(void);
extern SDL_DECLSPEC void SDLCALL SDL_SetMainReady(void);

extern SDL_DECLSPEC void SDLCALL JNI_OnLoad(void);

#define SDL_SYMBOL_ITEM(S) { #S, (SDL_FunctionPointer)S }

const static struct {
    const char *name;
    SDL_FunctionPointer address;
} sdl_symbols[] = {
    SDL_SYMBOL_ITEM(JNI_OnLoad),
    SDL_SYMBOL_ITEM(SDL_SetX11EventHook),
    SDL_SYMBOL_ITEM(SDL_AcquireCameraFrame),
    SDL_SYMBOL_ITEM(SDL_AcquireGPUCommandBuffer),
    SDL_SYMBOL_ITEM(SDL_AcquireGPUSwapchainTexture),
    SDL_SYMBOL_ITEM(SDL_AddAtomicInt),
    SDL_SYMBOL_ITEM(SDL_AddEventWatch),
    SDL_SYMBOL_ITEM(SDL_AddGamepadMapping),
    SDL_SYMBOL_ITEM(SDL_AddGamepadMappingsFromFile),
    SDL_SYMBOL_ITEM(SDL_AddGamepadMappingsFromIO),
    SDL_SYMBOL_ITEM(SDL_AddHintCallback),
    SDL_SYMBOL_ITEM(SDL_AddSurfaceAlternateImage),
    SDL_SYMBOL_ITEM(SDL_AddTimer),
    SDL_SYMBOL_ITEM(SDL_AddTimerNS),
    SDL_SYMBOL_ITEM(SDL_AddVulkanRenderSemaphores),
    SDL_SYMBOL_ITEM(SDL_AttachVirtualJoystick),
    SDL_SYMBOL_ITEM(SDL_AudioDevicePaused),
    SDL_SYMBOL_ITEM(SDL_BeginGPUComputePass),
    SDL_SYMBOL_ITEM(SDL_BeginGPUCopyPass),
    SDL_SYMBOL_ITEM(SDL_BeginGPURenderPass),
    SDL_SYMBOL_ITEM(SDL_BindAudioStream),
    SDL_SYMBOL_ITEM(SDL_BindAudioStreams),
    SDL_SYMBOL_ITEM(SDL_BindGPUComputePipeline),
    SDL_SYMBOL_ITEM(SDL_BindGPUComputeSamplers),
    SDL_SYMBOL_ITEM(SDL_BindGPUComputeStorageBuffers),
    SDL_SYMBOL_ITEM(SDL_BindGPUComputeStorageTextures),
    SDL_SYMBOL_ITEM(SDL_BindGPUFragmentSamplers),
    SDL_SYMBOL_ITEM(SDL_BindGPUFragmentStorageBuffers),
    SDL_SYMBOL_ITEM(SDL_BindGPUFragmentStorageTextures),
    SDL_SYMBOL_ITEM(SDL_BindGPUGraphicsPipeline),
    SDL_SYMBOL_ITEM(SDL_BindGPUIndexBuffer),
    SDL_SYMBOL_ITEM(SDL_BindGPUVertexBuffers),
    SDL_SYMBOL_ITEM(SDL_BindGPUVertexSamplers),
    SDL_SYMBOL_ITEM(SDL_BindGPUVertexStorageBuffers),
    SDL_SYMBOL_ITEM(SDL_BindGPUVertexStorageTextures),
    SDL_SYMBOL_ITEM(SDL_BlitGPUTexture),
    SDL_SYMBOL_ITEM(SDL_BlitSurface9Grid),
    SDL_SYMBOL_ITEM(SDL_BlitSurface),
    SDL_SYMBOL_ITEM(SDL_BlitSurfaceScaled),
    SDL_SYMBOL_ITEM(SDL_BlitSurfaceTiled),
    SDL_SYMBOL_ITEM(SDL_BlitSurfaceTiledWithScale),
    SDL_SYMBOL_ITEM(SDL_BlitSurfaceUnchecked),
    SDL_SYMBOL_ITEM(SDL_BlitSurfaceUncheckedScaled),
    SDL_SYMBOL_ITEM(SDL_BroadcastCondition),
    SDL_SYMBOL_ITEM(SDL_CaptureMouse),
    SDL_SYMBOL_ITEM(SDL_ClaimWindowForGPUDevice),
    SDL_SYMBOL_ITEM(SDL_CleanupTLS),
    SDL_SYMBOL_ITEM(SDL_ClearAudioStream),
    SDL_SYMBOL_ITEM(SDL_ClearClipboardData),
    SDL_SYMBOL_ITEM(SDL_ClearComposition),
    SDL_SYMBOL_ITEM(SDL_ClearError),
    SDL_SYMBOL_ITEM(SDL_ClearProperty),
    SDL_SYMBOL_ITEM(SDL_ClearSurface),
    SDL_SYMBOL_ITEM(SDL_CloseAudioDevice),
    SDL_SYMBOL_ITEM(SDL_CloseCamera),
    SDL_SYMBOL_ITEM(SDL_CloseGamepad),
    SDL_SYMBOL_ITEM(SDL_CloseHaptic),
    SDL_SYMBOL_ITEM(SDL_CloseIO),
    SDL_SYMBOL_ITEM(SDL_CloseJoystick),
    SDL_SYMBOL_ITEM(SDL_CloseSensor),
    SDL_SYMBOL_ITEM(SDL_CloseStorage),
    SDL_SYMBOL_ITEM(SDL_CompareAndSwapAtomicInt),
    SDL_SYMBOL_ITEM(SDL_CompareAndSwapAtomicPointer),
    SDL_SYMBOL_ITEM(SDL_CompareAndSwapAtomicU32),
    SDL_SYMBOL_ITEM(SDL_ComposeCustomBlendMode),
    SDL_SYMBOL_ITEM(SDL_ConvertAudioSamples),
    SDL_SYMBOL_ITEM(SDL_ConvertEventToRenderCoordinates),
    SDL_SYMBOL_ITEM(SDL_ConvertPixels),
    SDL_SYMBOL_ITEM(SDL_ConvertPixelsAndColorspace),
    SDL_SYMBOL_ITEM(SDL_ConvertSurface),
    SDL_SYMBOL_ITEM(SDL_ConvertSurfaceAndColorspace),
    SDL_SYMBOL_ITEM(SDL_CopyFile),
    SDL_SYMBOL_ITEM(SDL_CopyGPUBufferToBuffer),
    SDL_SYMBOL_ITEM(SDL_CopyGPUTextureToTexture),
    SDL_SYMBOL_ITEM(SDL_CopyProperties),
    SDL_SYMBOL_ITEM(SDL_CopyStorageFile),
    SDL_SYMBOL_ITEM(SDL_CreateAudioStream),
    SDL_SYMBOL_ITEM(SDL_CreateColorCursor),
    SDL_SYMBOL_ITEM(SDL_CreateCondition),
    SDL_SYMBOL_ITEM(SDL_CreateCursor),
    SDL_SYMBOL_ITEM(SDL_CreateDirectory),
    SDL_SYMBOL_ITEM(SDL_CreateEnvironment),
    SDL_SYMBOL_ITEM(SDL_CreateGPUBuffer),
    SDL_SYMBOL_ITEM(SDL_CreateGPUComputePipeline),
    SDL_SYMBOL_ITEM(SDL_CreateGPUDevice),
    SDL_SYMBOL_ITEM(SDL_CreateGPUDeviceWithProperties),
    SDL_SYMBOL_ITEM(SDL_CreateGPUGraphicsPipeline),
    SDL_SYMBOL_ITEM(SDL_CreateGPUSampler),
    SDL_SYMBOL_ITEM(SDL_CreateGPUShader),
    SDL_SYMBOL_ITEM(SDL_CreateGPUTexture),
    SDL_SYMBOL_ITEM(SDL_CreateGPUTransferBuffer),
    SDL_SYMBOL_ITEM(SDL_CreateHapticEffect),
    SDL_SYMBOL_ITEM(SDL_CreateMutex),
    SDL_SYMBOL_ITEM(SDL_CreatePalette),
    SDL_SYMBOL_ITEM(SDL_CreatePopupWindow),
    SDL_SYMBOL_ITEM(SDL_CreateProcess),
    SDL_SYMBOL_ITEM(SDL_CreateProcessWithProperties),
    SDL_SYMBOL_ITEM(SDL_CreateProperties),
    SDL_SYMBOL_ITEM(SDL_CreateRWLock),
    SDL_SYMBOL_ITEM(SDL_CreateRenderer),
    SDL_SYMBOL_ITEM(SDL_CreateRendererWithProperties),
    SDL_SYMBOL_ITEM(SDL_CreateSemaphore),
    SDL_SYMBOL_ITEM(SDL_CreateSoftwareRenderer),
    SDL_SYMBOL_ITEM(SDL_CreateStorageDirectory),
    SDL_SYMBOL_ITEM(SDL_CreateSurface),
    SDL_SYMBOL_ITEM(SDL_CreateSurfaceFrom),
    SDL_SYMBOL_ITEM(SDL_CreateSurfacePalette),
    SDL_SYMBOL_ITEM(SDL_CreateSystemCursor),
    SDL_SYMBOL_ITEM(SDL_CreateTexture),
    SDL_SYMBOL_ITEM(SDL_CreateTextureFromSurface),
    SDL_SYMBOL_ITEM(SDL_CreateTextureWithProperties),
    SDL_SYMBOL_ITEM(SDL_CreateThreadRuntime),
    SDL_SYMBOL_ITEM(SDL_CreateThreadWithPropertiesRuntime),
    SDL_SYMBOL_ITEM(SDL_CreateWindow),
    SDL_SYMBOL_ITEM(SDL_CreateWindowAndRenderer),
    SDL_SYMBOL_ITEM(SDL_CreateWindowWithProperties),
    SDL_SYMBOL_ITEM(SDL_CursorVisible),
    SDL_SYMBOL_ITEM(SDL_DateTimeToTime),
    SDL_SYMBOL_ITEM(SDL_Delay),
    SDL_SYMBOL_ITEM(SDL_DelayNS),
    SDL_SYMBOL_ITEM(SDL_DestroyAudioStream),
    SDL_SYMBOL_ITEM(SDL_DestroyCondition),
    SDL_SYMBOL_ITEM(SDL_DestroyCursor),
    SDL_SYMBOL_ITEM(SDL_DestroyEnvironment),
    SDL_SYMBOL_ITEM(SDL_DestroyGPUDevice),
    SDL_SYMBOL_ITEM(SDL_DestroyHapticEffect),
    SDL_SYMBOL_ITEM(SDL_DestroyMutex),
    SDL_SYMBOL_ITEM(SDL_DestroyPalette),
    SDL_SYMBOL_ITEM(SDL_DestroyProcess),
    SDL_SYMBOL_ITEM(SDL_DestroyProperties),
    SDL_SYMBOL_ITEM(SDL_DestroyRWLock),
    SDL_SYMBOL_ITEM(SDL_DestroyRenderer),
    SDL_SYMBOL_ITEM(SDL_DestroySemaphore),
    SDL_SYMBOL_ITEM(SDL_DestroySurface),
    SDL_SYMBOL_ITEM(SDL_DestroyTexture),
    SDL_SYMBOL_ITEM(SDL_DestroyWindow),
    SDL_SYMBOL_ITEM(SDL_DestroyWindowSurface),
    SDL_SYMBOL_ITEM(SDL_DetachThread),
    SDL_SYMBOL_ITEM(SDL_DetachVirtualJoystick),
    SDL_SYMBOL_ITEM(SDL_DisableScreenSaver),
    SDL_SYMBOL_ITEM(SDL_DispatchGPUCompute),
    SDL_SYMBOL_ITEM(SDL_DispatchGPUComputeIndirect),
    SDL_SYMBOL_ITEM(SDL_DownloadFromGPUBuffer),
    SDL_SYMBOL_ITEM(SDL_DownloadFromGPUTexture),
    SDL_SYMBOL_ITEM(SDL_DrawGPUIndexedPrimitives),
    SDL_SYMBOL_ITEM(SDL_DrawGPUIndexedPrimitivesIndirect),
    SDL_SYMBOL_ITEM(SDL_DrawGPUPrimitives),
    SDL_SYMBOL_ITEM(SDL_DrawGPUPrimitivesIndirect),
    SDL_SYMBOL_ITEM(SDL_DuplicateSurface),
    SDL_SYMBOL_ITEM(SDL_EGL_GetCurrentConfig),
    SDL_SYMBOL_ITEM(SDL_EGL_GetCurrentDisplay),
    SDL_SYMBOL_ITEM(SDL_EGL_GetProcAddress),
    SDL_SYMBOL_ITEM(SDL_EGL_GetWindowSurface),
    SDL_SYMBOL_ITEM(SDL_EGL_SetAttributeCallbacks),
    SDL_SYMBOL_ITEM(SDL_EnableScreenSaver),
    SDL_SYMBOL_ITEM(SDL_EndGPUComputePass),
    SDL_SYMBOL_ITEM(SDL_EndGPUCopyPass),
    SDL_SYMBOL_ITEM(SDL_EndGPURenderPass),
    SDL_SYMBOL_ITEM(SDL_EnterAppMainCallbacks),
    SDL_SYMBOL_ITEM(SDL_EnumerateDirectory),
    SDL_SYMBOL_ITEM(SDL_EnumerateProperties),
    SDL_SYMBOL_ITEM(SDL_EnumerateStorageDirectory),
    SDL_SYMBOL_ITEM(SDL_EventEnabled),
    SDL_SYMBOL_ITEM(SDL_FillSurfaceRect),
    SDL_SYMBOL_ITEM(SDL_FillSurfaceRects),
    SDL_SYMBOL_ITEM(SDL_FilterEvents),
    SDL_SYMBOL_ITEM(SDL_FlashWindow),
    SDL_SYMBOL_ITEM(SDL_FlipSurface),
    SDL_SYMBOL_ITEM(SDL_FlushAudioStream),
    SDL_SYMBOL_ITEM(SDL_FlushEvent),
    SDL_SYMBOL_ITEM(SDL_FlushEvents),
    SDL_SYMBOL_ITEM(SDL_FlushIO),
    SDL_SYMBOL_ITEM(SDL_FlushRenderer),
    SDL_SYMBOL_ITEM(SDL_GDKResumeGPU),
    SDL_SYMBOL_ITEM(SDL_GDKSuspendComplete),
    SDL_SYMBOL_ITEM(SDL_GDKSuspendGPU),
    SDL_SYMBOL_ITEM(SDL_GL_CreateContext),
    SDL_SYMBOL_ITEM(SDL_GL_DestroyContext),
    SDL_SYMBOL_ITEM(SDL_GL_ExtensionSupported),
    SDL_SYMBOL_ITEM(SDL_GL_GetAttribute),
    SDL_SYMBOL_ITEM(SDL_GL_GetCurrentContext),
    SDL_SYMBOL_ITEM(SDL_GL_GetCurrentWindow),
    SDL_SYMBOL_ITEM(SDL_GL_GetProcAddress),
    SDL_SYMBOL_ITEM(SDL_GL_GetSwapInterval),
    SDL_SYMBOL_ITEM(SDL_GL_LoadLibrary),
    SDL_SYMBOL_ITEM(SDL_GL_MakeCurrent),
    SDL_SYMBOL_ITEM(SDL_GL_ResetAttributes),
    SDL_SYMBOL_ITEM(SDL_GL_SetAttribute),
    SDL_SYMBOL_ITEM(SDL_GL_SetSwapInterval),
    SDL_SYMBOL_ITEM(SDL_GL_SwapWindow),
    SDL_SYMBOL_ITEM(SDL_GL_UnloadLibrary),
    SDL_SYMBOL_ITEM(SDL_GPUSupportsProperties),
    SDL_SYMBOL_ITEM(SDL_GPUSupportsShaderFormats),
    SDL_SYMBOL_ITEM(SDL_GPUTextureFormatTexelBlockSize),
    SDL_SYMBOL_ITEM(SDL_GPUTextureSupportsFormat),
    SDL_SYMBOL_ITEM(SDL_GPUTextureSupportsSampleCount),
    SDL_SYMBOL_ITEM(SDL_GUIDToString),
    SDL_SYMBOL_ITEM(SDL_GamepadConnected),
    SDL_SYMBOL_ITEM(SDL_GamepadEventsEnabled),
    SDL_SYMBOL_ITEM(SDL_GamepadHasAxis),
    SDL_SYMBOL_ITEM(SDL_GamepadHasButton),
    SDL_SYMBOL_ITEM(SDL_GamepadHasSensor),
    SDL_SYMBOL_ITEM(SDL_GamepadSensorEnabled),
    SDL_SYMBOL_ITEM(SDL_GenerateMipmapsForGPUTexture),
    SDL_SYMBOL_ITEM(SDL_GetAndroidActivity),
    SDL_SYMBOL_ITEM(SDL_GetAndroidCachePath),
    SDL_SYMBOL_ITEM(SDL_GetAndroidExternalStoragePath),
    SDL_SYMBOL_ITEM(SDL_GetAndroidExternalStorageState),
    SDL_SYMBOL_ITEM(SDL_GetAndroidInternalStoragePath),
    SDL_SYMBOL_ITEM(SDL_GetAndroidJNIEnv),
    SDL_SYMBOL_ITEM(SDL_GetAndroidSDKVersion),
    SDL_SYMBOL_ITEM(SDL_GetAppMetadataProperty),
    SDL_SYMBOL_ITEM(SDL_GetAssertionHandler),
    SDL_SYMBOL_ITEM(SDL_GetAssertionReport),
    SDL_SYMBOL_ITEM(SDL_GetAtomicInt),
    SDL_SYMBOL_ITEM(SDL_GetAtomicPointer),
    SDL_SYMBOL_ITEM(SDL_GetAtomicU32),
    SDL_SYMBOL_ITEM(SDL_GetAudioDeviceChannelMap),
    SDL_SYMBOL_ITEM(SDL_GetAudioDeviceFormat),
    SDL_SYMBOL_ITEM(SDL_GetAudioDeviceGain),
    SDL_SYMBOL_ITEM(SDL_GetAudioDeviceName),
    SDL_SYMBOL_ITEM(SDL_GetAudioDriver),
    SDL_SYMBOL_ITEM(SDL_GetAudioFormatName),
    SDL_SYMBOL_ITEM(SDL_GetAudioPlaybackDevices),
    SDL_SYMBOL_ITEM(SDL_GetAudioRecordingDevices),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamAvailable),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamData),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamDevice),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamFormat),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamFrequencyRatio),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamGain),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamInputChannelMap),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamOutputChannelMap),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamProperties),
    SDL_SYMBOL_ITEM(SDL_GetAudioStreamQueued),
    SDL_SYMBOL_ITEM(SDL_GetBasePath),
    SDL_SYMBOL_ITEM(SDL_GetBooleanProperty),
    SDL_SYMBOL_ITEM(SDL_GetCPUCacheLineSize),
    SDL_SYMBOL_ITEM(SDL_GetCameraDriver),
    SDL_SYMBOL_ITEM(SDL_GetCameraFormat),
    SDL_SYMBOL_ITEM(SDL_GetCameraID),
    SDL_SYMBOL_ITEM(SDL_GetCameraName),
    SDL_SYMBOL_ITEM(SDL_GetCameraPermissionState),
    SDL_SYMBOL_ITEM(SDL_GetCameraPosition),
    SDL_SYMBOL_ITEM(SDL_GetCameraProperties),
    SDL_SYMBOL_ITEM(SDL_GetCameraSupportedFormats),
    SDL_SYMBOL_ITEM(SDL_GetCameras),
    SDL_SYMBOL_ITEM(SDL_GetClipboardData),
    SDL_SYMBOL_ITEM(SDL_GetClipboardMimeTypes),
    SDL_SYMBOL_ITEM(SDL_GetClipboardText),
    SDL_SYMBOL_ITEM(SDL_GetClosestFullscreenDisplayMode),
    SDL_SYMBOL_ITEM(SDL_GetCurrentAudioDriver),
    SDL_SYMBOL_ITEM(SDL_GetCurrentCameraDriver),
    SDL_SYMBOL_ITEM(SDL_GetCurrentDisplayMode),
    SDL_SYMBOL_ITEM(SDL_GetCurrentDisplayOrientation),
    SDL_SYMBOL_ITEM(SDL_GetCurrentRenderOutputSize),
    SDL_SYMBOL_ITEM(SDL_GetCurrentThreadID),
    SDL_SYMBOL_ITEM(SDL_GetCurrentTime),
    SDL_SYMBOL_ITEM(SDL_GetCurrentVideoDriver),
    SDL_SYMBOL_ITEM(SDL_GetCursor),
    SDL_SYMBOL_ITEM(SDL_GetDXGIOutputInfo),
    SDL_SYMBOL_ITEM(SDL_GetDateTimeLocalePreferences),
    SDL_SYMBOL_ITEM(SDL_GetDayOfWeek),
    SDL_SYMBOL_ITEM(SDL_GetDayOfYear),
    SDL_SYMBOL_ITEM(SDL_GetDaysInMonth),
    SDL_SYMBOL_ITEM(SDL_GetDefaultAssertionHandler),
    SDL_SYMBOL_ITEM(SDL_GetDefaultCursor),
    SDL_SYMBOL_ITEM(SDL_GetDesktopDisplayMode),
    SDL_SYMBOL_ITEM(SDL_GetDirect3D9AdapterIndex),
    SDL_SYMBOL_ITEM(SDL_GetDisplayBounds),
    SDL_SYMBOL_ITEM(SDL_GetDisplayContentScale),
    SDL_SYMBOL_ITEM(SDL_GetDisplayForPoint),
    SDL_SYMBOL_ITEM(SDL_GetDisplayForRect),
    SDL_SYMBOL_ITEM(SDL_GetDisplayForWindow),
    SDL_SYMBOL_ITEM(SDL_GetDisplayName),
    SDL_SYMBOL_ITEM(SDL_GetDisplayProperties),
    SDL_SYMBOL_ITEM(SDL_GetDisplayUsableBounds),
    SDL_SYMBOL_ITEM(SDL_GetDisplays),
    SDL_SYMBOL_ITEM(SDL_GetEnvironment),
    SDL_SYMBOL_ITEM(SDL_GetEnvironmentVariable),
    SDL_SYMBOL_ITEM(SDL_GetEnvironmentVariables),
    SDL_SYMBOL_ITEM(SDL_GetError),
    SDL_SYMBOL_ITEM(SDL_GetEventFilter),
    SDL_SYMBOL_ITEM(SDL_GetFloatProperty),
    SDL_SYMBOL_ITEM(SDL_GetFullscreenDisplayModes),
    SDL_SYMBOL_ITEM(SDL_GetGDKDefaultUser),
    SDL_SYMBOL_ITEM(SDL_GetGDKTaskQueue),
    SDL_SYMBOL_ITEM(SDL_GetGPUDeviceDriver),
    SDL_SYMBOL_ITEM(SDL_GetGPUDriver),
    SDL_SYMBOL_ITEM(SDL_GetGPUShaderFormats),
    SDL_SYMBOL_ITEM(SDL_GetGPUSwapchainTextureFormat),
    SDL_SYMBOL_ITEM(SDL_GetGamepadAppleSFSymbolsNameForAxis),
    SDL_SYMBOL_ITEM(SDL_GetGamepadAppleSFSymbolsNameForButton),
    SDL_SYMBOL_ITEM(SDL_GetGamepadAxis),
    SDL_SYMBOL_ITEM(SDL_GetGamepadAxisFromString),
    SDL_SYMBOL_ITEM(SDL_GetGamepadBindings),
    SDL_SYMBOL_ITEM(SDL_GetGamepadButton),
    SDL_SYMBOL_ITEM(SDL_GetGamepadButtonFromString),
    SDL_SYMBOL_ITEM(SDL_GetGamepadButtonLabel),
    SDL_SYMBOL_ITEM(SDL_GetGamepadButtonLabelForType),
    SDL_SYMBOL_ITEM(SDL_GetGamepadConnectionState),
    SDL_SYMBOL_ITEM(SDL_GetGamepadFirmwareVersion),
    SDL_SYMBOL_ITEM(SDL_GetGamepadFromID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadFromPlayerIndex),
    SDL_SYMBOL_ITEM(SDL_GetGamepadGUIDForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadJoystick),
    SDL_SYMBOL_ITEM(SDL_GetGamepadMapping),
    SDL_SYMBOL_ITEM(SDL_GetGamepadMappingForGUID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadMappingForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadMappings),
    SDL_SYMBOL_ITEM(SDL_GetGamepadName),
    SDL_SYMBOL_ITEM(SDL_GetGamepadNameForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadPath),
    SDL_SYMBOL_ITEM(SDL_GetGamepadPathForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadPlayerIndex),
    SDL_SYMBOL_ITEM(SDL_GetGamepadPlayerIndexForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadPowerInfo),
    SDL_SYMBOL_ITEM(SDL_GetGamepadProduct),
    SDL_SYMBOL_ITEM(SDL_GetGamepadProductForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadProductVersion),
    SDL_SYMBOL_ITEM(SDL_GetGamepadProductVersionForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadProperties),
    SDL_SYMBOL_ITEM(SDL_GetGamepadSensorData),
    SDL_SYMBOL_ITEM(SDL_GetGamepadSensorDataRate),
    SDL_SYMBOL_ITEM(SDL_GetGamepadSerial),
    SDL_SYMBOL_ITEM(SDL_GetGamepadSteamHandle),
    SDL_SYMBOL_ITEM(SDL_GetGamepadStringForAxis),
    SDL_SYMBOL_ITEM(SDL_GetGamepadStringForButton),
    SDL_SYMBOL_ITEM(SDL_GetGamepadStringForType),
    SDL_SYMBOL_ITEM(SDL_GetGamepadTouchpadFinger),
    SDL_SYMBOL_ITEM(SDL_GetGamepadType),
    SDL_SYMBOL_ITEM(SDL_GetGamepadTypeForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepadTypeFromString),
    SDL_SYMBOL_ITEM(SDL_GetGamepadVendor),
    SDL_SYMBOL_ITEM(SDL_GetGamepadVendorForID),
    SDL_SYMBOL_ITEM(SDL_GetGamepads),
    SDL_SYMBOL_ITEM(SDL_GetGlobalMouseState),
    SDL_SYMBOL_ITEM(SDL_GetGlobalProperties),
    SDL_SYMBOL_ITEM(SDL_GetGrabbedWindow),
    SDL_SYMBOL_ITEM(SDL_GetHapticEffectStatus),
    SDL_SYMBOL_ITEM(SDL_GetHapticFeatures),
    SDL_SYMBOL_ITEM(SDL_GetHapticFromID),
    SDL_SYMBOL_ITEM(SDL_GetHapticID),
    SDL_SYMBOL_ITEM(SDL_GetHapticName),
    SDL_SYMBOL_ITEM(SDL_GetHapticNameForID),
    SDL_SYMBOL_ITEM(SDL_GetHaptics),
    SDL_SYMBOL_ITEM(SDL_GetHint),
    SDL_SYMBOL_ITEM(SDL_GetHintBoolean),
    SDL_SYMBOL_ITEM(SDL_GetIOProperties),
    SDL_SYMBOL_ITEM(SDL_GetIOSize),
    SDL_SYMBOL_ITEM(SDL_GetIOStatus),
    SDL_SYMBOL_ITEM(SDL_GetJoystickAxis),
    SDL_SYMBOL_ITEM(SDL_GetJoystickAxisInitialState),
    SDL_SYMBOL_ITEM(SDL_GetJoystickBall),
    SDL_SYMBOL_ITEM(SDL_GetJoystickButton),
    SDL_SYMBOL_ITEM(SDL_GetJoystickConnectionState),
    SDL_SYMBOL_ITEM(SDL_GetJoystickFirmwareVersion),
    SDL_SYMBOL_ITEM(SDL_GetJoystickFromID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickFromPlayerIndex),
    SDL_SYMBOL_ITEM(SDL_GetJoystickGUID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickGUIDForID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickGUIDInfo),
    SDL_SYMBOL_ITEM(SDL_GetJoystickHat),
    SDL_SYMBOL_ITEM(SDL_GetJoystickID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickName),
    SDL_SYMBOL_ITEM(SDL_GetJoystickNameForID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickPath),
    SDL_SYMBOL_ITEM(SDL_GetJoystickPathForID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickPlayerIndex),
    SDL_SYMBOL_ITEM(SDL_GetJoystickPlayerIndexForID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickPowerInfo),
    SDL_SYMBOL_ITEM(SDL_GetJoystickProduct),
    SDL_SYMBOL_ITEM(SDL_GetJoystickProductForID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickProductVersion),
    SDL_SYMBOL_ITEM(SDL_GetJoystickProductVersionForID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickProperties),
    SDL_SYMBOL_ITEM(SDL_GetJoystickSerial),
    SDL_SYMBOL_ITEM(SDL_GetJoystickType),
    SDL_SYMBOL_ITEM(SDL_GetJoystickTypeForID),
    SDL_SYMBOL_ITEM(SDL_GetJoystickVendor),
    SDL_SYMBOL_ITEM(SDL_GetJoystickVendorForID),
    SDL_SYMBOL_ITEM(SDL_GetJoysticks),
    SDL_SYMBOL_ITEM(SDL_GetKeyFromName),
    SDL_SYMBOL_ITEM(SDL_GetKeyFromScancode),
    SDL_SYMBOL_ITEM(SDL_GetKeyName),
    SDL_SYMBOL_ITEM(SDL_GetKeyboardFocus),
    SDL_SYMBOL_ITEM(SDL_GetKeyboardNameForID),
    SDL_SYMBOL_ITEM(SDL_GetKeyboardState),
    SDL_SYMBOL_ITEM(SDL_GetKeyboards),
    SDL_SYMBOL_ITEM(SDL_GetLogOutputFunction),
    SDL_SYMBOL_ITEM(SDL_GetLogPriority),
    SDL_SYMBOL_ITEM(SDL_GetMasksForPixelFormat),
    SDL_SYMBOL_ITEM(SDL_GetMaxHapticEffects),
    SDL_SYMBOL_ITEM(SDL_GetMaxHapticEffectsPlaying),
    SDL_SYMBOL_ITEM(SDL_GetMemoryFunctions),
    SDL_SYMBOL_ITEM(SDL_GetMice),
    SDL_SYMBOL_ITEM(SDL_GetModState),
    SDL_SYMBOL_ITEM(SDL_GetMouseFocus),
    SDL_SYMBOL_ITEM(SDL_GetMouseNameForID),
    SDL_SYMBOL_ITEM(SDL_GetMouseState),
    SDL_SYMBOL_ITEM(SDL_GetNaturalDisplayOrientation),
    SDL_SYMBOL_ITEM(SDL_GetNumAllocations),
    SDL_SYMBOL_ITEM(SDL_GetNumAudioDrivers),
    SDL_SYMBOL_ITEM(SDL_GetNumCameraDrivers),
    SDL_SYMBOL_ITEM(SDL_GetNumGPUDrivers),
    SDL_SYMBOL_ITEM(SDL_GetNumGamepadTouchpadFingers),
    SDL_SYMBOL_ITEM(SDL_GetNumGamepadTouchpads),
    SDL_SYMBOL_ITEM(SDL_GetNumHapticAxes),
    SDL_SYMBOL_ITEM(SDL_GetNumJoystickAxes),
    SDL_SYMBOL_ITEM(SDL_GetNumJoystickBalls),
    SDL_SYMBOL_ITEM(SDL_GetNumJoystickButtons),
    SDL_SYMBOL_ITEM(SDL_GetNumJoystickHats),
    SDL_SYMBOL_ITEM(SDL_GetNumLogicalCPUCores),
    SDL_SYMBOL_ITEM(SDL_GetNumRenderDrivers),
    SDL_SYMBOL_ITEM(SDL_GetNumVideoDrivers),
    SDL_SYMBOL_ITEM(SDL_GetNumberProperty),
    SDL_SYMBOL_ITEM(SDL_GetOriginalMemoryFunctions),
    SDL_SYMBOL_ITEM(SDL_GetPathInfo),
    SDL_SYMBOL_ITEM(SDL_GetPerformanceCounter),
    SDL_SYMBOL_ITEM(SDL_GetPerformanceFrequency),
    SDL_SYMBOL_ITEM(SDL_GetPixelFormatDetails),
    SDL_SYMBOL_ITEM(SDL_GetPixelFormatForMasks),
    SDL_SYMBOL_ITEM(SDL_GetPixelFormatName),
    SDL_SYMBOL_ITEM(SDL_GetPlatform),
    SDL_SYMBOL_ITEM(SDL_GetPointerProperty),
    SDL_SYMBOL_ITEM(SDL_GetPowerInfo),
    SDL_SYMBOL_ITEM(SDL_GetPrefPath),
    SDL_SYMBOL_ITEM(SDL_GetPreferredLocales),
    SDL_SYMBOL_ITEM(SDL_GetPrimaryDisplay),
    SDL_SYMBOL_ITEM(SDL_GetPrimarySelectionText),
    SDL_SYMBOL_ITEM(SDL_GetProcessInput),
    SDL_SYMBOL_ITEM(SDL_GetProcessOutput),
    SDL_SYMBOL_ITEM(SDL_GetProcessProperties),
    SDL_SYMBOL_ITEM(SDL_GetPropertyType),
    SDL_SYMBOL_ITEM(SDL_GetRGB),
    SDL_SYMBOL_ITEM(SDL_GetRGBA),
    SDL_SYMBOL_ITEM(SDL_GetRealGamepadType),
    SDL_SYMBOL_ITEM(SDL_GetRealGamepadTypeForID),
    SDL_SYMBOL_ITEM(SDL_GetRectAndLineIntersection),
    SDL_SYMBOL_ITEM(SDL_GetRectAndLineIntersectionFloat),
    SDL_SYMBOL_ITEM(SDL_GetRectEnclosingPoints),
    SDL_SYMBOL_ITEM(SDL_GetRectEnclosingPointsFloat),
    SDL_SYMBOL_ITEM(SDL_GetRectIntersection),
    SDL_SYMBOL_ITEM(SDL_GetRectIntersectionFloat),
    SDL_SYMBOL_ITEM(SDL_GetRectUnion),
    SDL_SYMBOL_ITEM(SDL_GetRectUnionFloat),
    SDL_SYMBOL_ITEM(SDL_GetRelativeMouseState),
    SDL_SYMBOL_ITEM(SDL_GetRenderClipRect),
    SDL_SYMBOL_ITEM(SDL_GetRenderColorScale),
    SDL_SYMBOL_ITEM(SDL_GetRenderDrawBlendMode),
    SDL_SYMBOL_ITEM(SDL_GetRenderDrawColor),
    SDL_SYMBOL_ITEM(SDL_GetRenderDrawColorFloat),
    SDL_SYMBOL_ITEM(SDL_GetRenderDriver),
    SDL_SYMBOL_ITEM(SDL_GetRenderLogicalPresentation),
    SDL_SYMBOL_ITEM(SDL_GetRenderLogicalPresentationRect),
    SDL_SYMBOL_ITEM(SDL_GetRenderMetalCommandEncoder),
    SDL_SYMBOL_ITEM(SDL_GetRenderMetalLayer),
    SDL_SYMBOL_ITEM(SDL_GetRenderOutputSize),
    SDL_SYMBOL_ITEM(SDL_GetRenderSafeArea),
    SDL_SYMBOL_ITEM(SDL_GetRenderScale),
    SDL_SYMBOL_ITEM(SDL_GetRenderTarget),
    SDL_SYMBOL_ITEM(SDL_GetRenderVSync),
    SDL_SYMBOL_ITEM(SDL_GetRenderViewport),
    SDL_SYMBOL_ITEM(SDL_GetRenderWindow),
    SDL_SYMBOL_ITEM(SDL_GetRenderer),
    SDL_SYMBOL_ITEM(SDL_GetRendererFromTexture),
    SDL_SYMBOL_ITEM(SDL_GetRendererName),
    SDL_SYMBOL_ITEM(SDL_GetRendererProperties),
    SDL_SYMBOL_ITEM(SDL_GetRevision),
    SDL_SYMBOL_ITEM(SDL_GetSIMDAlignment),
    SDL_SYMBOL_ITEM(SDL_GetScancodeFromKey),
    SDL_SYMBOL_ITEM(SDL_GetScancodeFromName),
    SDL_SYMBOL_ITEM(SDL_GetScancodeName),
    SDL_SYMBOL_ITEM(SDL_GetSemaphoreValue),
    SDL_SYMBOL_ITEM(SDL_GetSensorData),
    SDL_SYMBOL_ITEM(SDL_GetSensorFromID),
    SDL_SYMBOL_ITEM(SDL_GetSensorID),
    SDL_SYMBOL_ITEM(SDL_GetSensorName),
    SDL_SYMBOL_ITEM(SDL_GetSensorNameForID),
    SDL_SYMBOL_ITEM(SDL_GetSensorNonPortableType),
    SDL_SYMBOL_ITEM(SDL_GetSensorNonPortableTypeForID),
    SDL_SYMBOL_ITEM(SDL_GetSensorProperties),
    SDL_SYMBOL_ITEM(SDL_GetSensorType),
    SDL_SYMBOL_ITEM(SDL_GetSensorTypeForID),
    SDL_SYMBOL_ITEM(SDL_GetSensors),
    SDL_SYMBOL_ITEM(SDL_GetSilenceValueForFormat),
    SDL_SYMBOL_ITEM(SDL_GetStorageFileSize),
    SDL_SYMBOL_ITEM(SDL_GetStoragePathInfo),
    SDL_SYMBOL_ITEM(SDL_GetStorageSpaceRemaining),
    SDL_SYMBOL_ITEM(SDL_GetStringProperty),
    SDL_SYMBOL_ITEM(SDL_GetSurfaceAlphaMod),
    SDL_SYMBOL_ITEM(SDL_GetSurfaceBlendMode),
    SDL_SYMBOL_ITEM(SDL_GetSurfaceClipRect),
    SDL_SYMBOL_ITEM(SDL_GetSurfaceColorKey),
    SDL_SYMBOL_ITEM(SDL_GetSurfaceColorMod),
    SDL_SYMBOL_ITEM(SDL_GetSurfaceColorspace),
    SDL_SYMBOL_ITEM(SDL_GetSurfaceImages),
    SDL_SYMBOL_ITEM(SDL_GetSurfacePalette),
    SDL_SYMBOL_ITEM(SDL_GetSurfaceProperties),
    SDL_SYMBOL_ITEM(SDL_GetSystemRAM),
    SDL_SYMBOL_ITEM(SDL_GetSystemTheme),
    SDL_SYMBOL_ITEM(SDL_GetTLS),
    SDL_SYMBOL_ITEM(SDL_GetTextInputArea),
    SDL_SYMBOL_ITEM(SDL_GetTextureAlphaMod),
    SDL_SYMBOL_ITEM(SDL_GetTextureAlphaModFloat),
    SDL_SYMBOL_ITEM(SDL_GetTextureBlendMode),
    SDL_SYMBOL_ITEM(SDL_GetTextureColorMod),
    SDL_SYMBOL_ITEM(SDL_GetTextureColorModFloat),
    SDL_SYMBOL_ITEM(SDL_GetTextureProperties),
    SDL_SYMBOL_ITEM(SDL_GetTextureScaleMode),
    SDL_SYMBOL_ITEM(SDL_GetTextureSize),
    SDL_SYMBOL_ITEM(SDL_GetThreadID),
    SDL_SYMBOL_ITEM(SDL_GetThreadName),
    SDL_SYMBOL_ITEM(SDL_GetTicks),
    SDL_SYMBOL_ITEM(SDL_GetTicksNS),
    SDL_SYMBOL_ITEM(SDL_GetTouchDeviceName),
    SDL_SYMBOL_ITEM(SDL_GetTouchDeviceType),
    SDL_SYMBOL_ITEM(SDL_GetTouchDevices),
    SDL_SYMBOL_ITEM(SDL_GetTouchFingers),
    SDL_SYMBOL_ITEM(SDL_GetUserFolder),
    SDL_SYMBOL_ITEM(SDL_GetVersion),
    SDL_SYMBOL_ITEM(SDL_GetVideoDriver),
    SDL_SYMBOL_ITEM(SDL_GetWindowAspectRatio),
    SDL_SYMBOL_ITEM(SDL_GetWindowBordersSize),
    SDL_SYMBOL_ITEM(SDL_GetWindowDisplayScale),
    SDL_SYMBOL_ITEM(SDL_GetWindowFlags),
    SDL_SYMBOL_ITEM(SDL_GetWindowFromEvent),
    SDL_SYMBOL_ITEM(SDL_GetWindowFromID),
    SDL_SYMBOL_ITEM(SDL_GetWindowFullscreenMode),
    SDL_SYMBOL_ITEM(SDL_GetWindowICCProfile),
    SDL_SYMBOL_ITEM(SDL_GetWindowID),
    SDL_SYMBOL_ITEM(SDL_GetWindowKeyboardGrab),
    SDL_SYMBOL_ITEM(SDL_GetWindowMaximumSize),
    SDL_SYMBOL_ITEM(SDL_GetWindowMinimumSize),
    SDL_SYMBOL_ITEM(SDL_GetWindowMouseGrab),
    SDL_SYMBOL_ITEM(SDL_GetWindowMouseRect),
    SDL_SYMBOL_ITEM(SDL_GetWindowOpacity),
    SDL_SYMBOL_ITEM(SDL_GetWindowParent),
    SDL_SYMBOL_ITEM(SDL_GetWindowPixelDensity),
    SDL_SYMBOL_ITEM(SDL_GetWindowPixelFormat),
    SDL_SYMBOL_ITEM(SDL_GetWindowPosition),
    SDL_SYMBOL_ITEM(SDL_GetWindowProperties),
    SDL_SYMBOL_ITEM(SDL_GetWindowRelativeMouseMode),
    SDL_SYMBOL_ITEM(SDL_GetWindowSafeArea),
    SDL_SYMBOL_ITEM(SDL_GetWindowSize),
    SDL_SYMBOL_ITEM(SDL_GetWindowSizeInPixels),
    SDL_SYMBOL_ITEM(SDL_GetWindowSurface),
    SDL_SYMBOL_ITEM(SDL_GetWindowSurfaceVSync),
    SDL_SYMBOL_ITEM(SDL_GetWindowTitle),
    SDL_SYMBOL_ITEM(SDL_GetWindows),
    SDL_SYMBOL_ITEM(SDL_GlobDirectory),
    SDL_SYMBOL_ITEM(SDL_GlobStorageDirectory),
    SDL_SYMBOL_ITEM(SDL_HapticEffectSupported),
    SDL_SYMBOL_ITEM(SDL_HapticRumbleSupported),
    SDL_SYMBOL_ITEM(SDL_HasARMSIMD),
    SDL_SYMBOL_ITEM(SDL_HasAVX2),
    SDL_SYMBOL_ITEM(SDL_HasAVX512F),
    SDL_SYMBOL_ITEM(SDL_HasAVX),
    SDL_SYMBOL_ITEM(SDL_HasAltiVec),
    SDL_SYMBOL_ITEM(SDL_HasClipboardData),
    SDL_SYMBOL_ITEM(SDL_HasClipboardText),
    SDL_SYMBOL_ITEM(SDL_HasEvent),
    SDL_SYMBOL_ITEM(SDL_HasEvents),
    SDL_SYMBOL_ITEM(SDL_HasGamepad),
    SDL_SYMBOL_ITEM(SDL_HasJoystick),
    SDL_SYMBOL_ITEM(SDL_HasKeyboard),
    SDL_SYMBOL_ITEM(SDL_HasLASX),
    SDL_SYMBOL_ITEM(SDL_HasLSX),
    SDL_SYMBOL_ITEM(SDL_HasMMX),
    SDL_SYMBOL_ITEM(SDL_HasMouse),
    SDL_SYMBOL_ITEM(SDL_HasNEON),
    SDL_SYMBOL_ITEM(SDL_HasPrimarySelectionText),
    SDL_SYMBOL_ITEM(SDL_HasProperty),
    SDL_SYMBOL_ITEM(SDL_HasRectIntersection),
    SDL_SYMBOL_ITEM(SDL_HasRectIntersectionFloat),
    SDL_SYMBOL_ITEM(SDL_HasSSE2),
    SDL_SYMBOL_ITEM(SDL_HasSSE3),
    SDL_SYMBOL_ITEM(SDL_HasSSE41),
    SDL_SYMBOL_ITEM(SDL_HasSSE42),
    SDL_SYMBOL_ITEM(SDL_HasSSE),
    SDL_SYMBOL_ITEM(SDL_HasScreenKeyboardSupport),
    SDL_SYMBOL_ITEM(SDL_HideCursor),
    SDL_SYMBOL_ITEM(SDL_HideWindow),
    SDL_SYMBOL_ITEM(SDL_IOFromConstMem),
    SDL_SYMBOL_ITEM(SDL_IOFromDynamicMem),
    SDL_SYMBOL_ITEM(SDL_IOFromFile),
    SDL_SYMBOL_ITEM(SDL_IOFromMem),
    SDL_SYMBOL_ITEM(SDL_IOprintf),
    SDL_SYMBOL_ITEM(SDL_IOvprintf),
    SDL_SYMBOL_ITEM(SDL_Init),
    SDL_SYMBOL_ITEM(SDL_InitHapticRumble),
    SDL_SYMBOL_ITEM(SDL_InitSubSystem),
    SDL_SYMBOL_ITEM(SDL_InsertGPUDebugLabel),
    SDL_SYMBOL_ITEM(SDL_IsChromebook),
    SDL_SYMBOL_ITEM(SDL_IsDeXMode),
    SDL_SYMBOL_ITEM(SDL_IsGamepad),
    SDL_SYMBOL_ITEM(SDL_IsJoystickHaptic),
    SDL_SYMBOL_ITEM(SDL_IsJoystickVirtual),
    SDL_SYMBOL_ITEM(SDL_IsMouseHaptic),
    SDL_SYMBOL_ITEM(SDL_IsTV),
    SDL_SYMBOL_ITEM(SDL_IsTablet),
    SDL_SYMBOL_ITEM(SDL_JoystickConnected),
    SDL_SYMBOL_ITEM(SDL_JoystickEventsEnabled),
    SDL_SYMBOL_ITEM(SDL_KillProcess),
    SDL_SYMBOL_ITEM(SDL_LoadBMP),
    SDL_SYMBOL_ITEM(SDL_LoadBMP_IO),
    SDL_SYMBOL_ITEM(SDL_LoadFile),
    SDL_SYMBOL_ITEM(SDL_LoadFile_IO),
    SDL_SYMBOL_ITEM(SDL_LoadFunction),
    SDL_SYMBOL_ITEM(SDL_LoadObject),
    SDL_SYMBOL_ITEM(SDL_LoadWAV),
    SDL_SYMBOL_ITEM(SDL_LoadWAV_IO),
    SDL_SYMBOL_ITEM(SDL_LockAudioStream),
    SDL_SYMBOL_ITEM(SDL_LockJoysticks),
    SDL_SYMBOL_ITEM(SDL_LockMutex),
    SDL_SYMBOL_ITEM(SDL_LockProperties),
    SDL_SYMBOL_ITEM(SDL_LockRWLockForReading),
    SDL_SYMBOL_ITEM(SDL_LockRWLockForWriting),
    SDL_SYMBOL_ITEM(SDL_LockSpinlock),
    SDL_SYMBOL_ITEM(SDL_LockSurface),
    SDL_SYMBOL_ITEM(SDL_LockTexture),
    SDL_SYMBOL_ITEM(SDL_LockTextureToSurface),
    SDL_SYMBOL_ITEM(SDL_Log),
    SDL_SYMBOL_ITEM(SDL_LogCritical),
    SDL_SYMBOL_ITEM(SDL_LogDebug),
    SDL_SYMBOL_ITEM(SDL_LogError),
    SDL_SYMBOL_ITEM(SDL_LogInfo),
    SDL_SYMBOL_ITEM(SDL_LogMessage),
    SDL_SYMBOL_ITEM(SDL_LogMessageV),
    SDL_SYMBOL_ITEM(SDL_LogTrace),
    SDL_SYMBOL_ITEM(SDL_LogVerbose),
    SDL_SYMBOL_ITEM(SDL_LogWarn),
    SDL_SYMBOL_ITEM(SDL_MapGPUTransferBuffer),
    SDL_SYMBOL_ITEM(SDL_MapRGB),
    SDL_SYMBOL_ITEM(SDL_MapRGBA),
    SDL_SYMBOL_ITEM(SDL_MapSurfaceRGB),
    SDL_SYMBOL_ITEM(SDL_MapSurfaceRGBA),
    SDL_SYMBOL_ITEM(SDL_MaximizeWindow),
    SDL_SYMBOL_ITEM(SDL_MemoryBarrierAcquireFunction),
    SDL_SYMBOL_ITEM(SDL_MemoryBarrierReleaseFunction),
    SDL_SYMBOL_ITEM(SDL_Metal_CreateView),
    SDL_SYMBOL_ITEM(SDL_Metal_DestroyView),
    SDL_SYMBOL_ITEM(SDL_Metal_GetLayer),
    SDL_SYMBOL_ITEM(SDL_MinimizeWindow),
    SDL_SYMBOL_ITEM(SDL_MixAudio),
    SDL_SYMBOL_ITEM(SDL_OnApplicationDidChangeStatusBarOrientation),
    SDL_SYMBOL_ITEM(SDL_OnApplicationDidEnterBackground),
    SDL_SYMBOL_ITEM(SDL_OnApplicationDidEnterForeground),
    SDL_SYMBOL_ITEM(SDL_OnApplicationDidReceiveMemoryWarning),
    SDL_SYMBOL_ITEM(SDL_OnApplicationWillEnterBackground),
    SDL_SYMBOL_ITEM(SDL_OnApplicationWillEnterForeground),
    SDL_SYMBOL_ITEM(SDL_OnApplicationWillTerminate),
    SDL_SYMBOL_ITEM(SDL_OpenAudioDevice),
    SDL_SYMBOL_ITEM(SDL_OpenAudioDeviceStream),
    SDL_SYMBOL_ITEM(SDL_OpenCamera),
    SDL_SYMBOL_ITEM(SDL_OpenFileStorage),
    SDL_SYMBOL_ITEM(SDL_OpenGamepad),
    SDL_SYMBOL_ITEM(SDL_OpenHaptic),
    SDL_SYMBOL_ITEM(SDL_OpenHapticFromJoystick),
    SDL_SYMBOL_ITEM(SDL_OpenHapticFromMouse),
    SDL_SYMBOL_ITEM(SDL_OpenIO),
    SDL_SYMBOL_ITEM(SDL_OpenJoystick),
    SDL_SYMBOL_ITEM(SDL_OpenSensor),
    SDL_SYMBOL_ITEM(SDL_OpenStorage),
    SDL_SYMBOL_ITEM(SDL_OpenTitleStorage),
    SDL_SYMBOL_ITEM(SDL_OpenURL),
    SDL_SYMBOL_ITEM(SDL_OpenUserStorage),
    SDL_SYMBOL_ITEM(SDL_OutOfMemory),
    SDL_SYMBOL_ITEM(SDL_PauseAudioDevice),
    SDL_SYMBOL_ITEM(SDL_PauseAudioStreamDevice),
    SDL_SYMBOL_ITEM(SDL_PauseHaptic),
    SDL_SYMBOL_ITEM(SDL_PeepEvents),
    SDL_SYMBOL_ITEM(SDL_PlayHapticRumble),
    SDL_SYMBOL_ITEM(SDL_PollEvent),
    SDL_SYMBOL_ITEM(SDL_PopGPUDebugGroup),
    SDL_SYMBOL_ITEM(SDL_PremultiplyAlpha),
    SDL_SYMBOL_ITEM(SDL_PremultiplySurfaceAlpha),
    SDL_SYMBOL_ITEM(SDL_PumpEvents),
    SDL_SYMBOL_ITEM(SDL_PushEvent),
    SDL_SYMBOL_ITEM(SDL_PushGPUComputeUniformData),
    SDL_SYMBOL_ITEM(SDL_PushGPUDebugGroup),
    SDL_SYMBOL_ITEM(SDL_PushGPUFragmentUniformData),
    SDL_SYMBOL_ITEM(SDL_PushGPUVertexUniformData),
    SDL_SYMBOL_ITEM(SDL_PutAudioStreamData),
    SDL_SYMBOL_ITEM(SDL_QueryGPUFence),
    SDL_SYMBOL_ITEM(SDL_Quit),
    SDL_SYMBOL_ITEM(SDL_QuitSubSystem),
    SDL_SYMBOL_ITEM(SDL_RaiseWindow),
    SDL_SYMBOL_ITEM(SDL_ReadIO),
    SDL_SYMBOL_ITEM(SDL_ReadProcess),
    SDL_SYMBOL_ITEM(SDL_ReadS16BE),
    SDL_SYMBOL_ITEM(SDL_ReadS16LE),
    SDL_SYMBOL_ITEM(SDL_ReadS32BE),
    SDL_SYMBOL_ITEM(SDL_ReadS32LE),
    SDL_SYMBOL_ITEM(SDL_ReadS64BE),
    SDL_SYMBOL_ITEM(SDL_ReadS64LE),
    SDL_SYMBOL_ITEM(SDL_ReadS8),
    SDL_SYMBOL_ITEM(SDL_ReadStorageFile),
    SDL_SYMBOL_ITEM(SDL_ReadSurfacePixel),
    SDL_SYMBOL_ITEM(SDL_ReadSurfacePixelFloat),
    SDL_SYMBOL_ITEM(SDL_ReadU16BE),
    SDL_SYMBOL_ITEM(SDL_ReadU16LE),
    SDL_SYMBOL_ITEM(SDL_ReadU32BE),
    SDL_SYMBOL_ITEM(SDL_ReadU32LE),
    SDL_SYMBOL_ITEM(SDL_ReadU64BE),
    SDL_SYMBOL_ITEM(SDL_ReadU64LE),
    SDL_SYMBOL_ITEM(SDL_ReadU8),
    SDL_SYMBOL_ITEM(SDL_RegisterApp),
    SDL_SYMBOL_ITEM(SDL_RegisterEvents),
    SDL_SYMBOL_ITEM(SDL_ReleaseCameraFrame),
    SDL_SYMBOL_ITEM(SDL_ReleaseGPUBuffer),
    SDL_SYMBOL_ITEM(SDL_ReleaseGPUComputePipeline),
    SDL_SYMBOL_ITEM(SDL_ReleaseGPUFence),
    SDL_SYMBOL_ITEM(SDL_ReleaseGPUGraphicsPipeline),
    SDL_SYMBOL_ITEM(SDL_ReleaseGPUSampler),
    SDL_SYMBOL_ITEM(SDL_ReleaseGPUShader),
    SDL_SYMBOL_ITEM(SDL_ReleaseGPUTexture),
    SDL_SYMBOL_ITEM(SDL_ReleaseGPUTransferBuffer),
    SDL_SYMBOL_ITEM(SDL_ReleaseWindowFromGPUDevice),
    SDL_SYMBOL_ITEM(SDL_ReloadGamepadMappings),
    SDL_SYMBOL_ITEM(SDL_RemoveEventWatch),
    SDL_SYMBOL_ITEM(SDL_RemoveHintCallback),
    SDL_SYMBOL_ITEM(SDL_RemovePath),
    SDL_SYMBOL_ITEM(SDL_RemoveStoragePath),
    SDL_SYMBOL_ITEM(SDL_RemoveSurfaceAlternateImages),
    SDL_SYMBOL_ITEM(SDL_RemoveTimer),
    SDL_SYMBOL_ITEM(SDL_RenamePath),
    SDL_SYMBOL_ITEM(SDL_RenameStoragePath),
    SDL_SYMBOL_ITEM(SDL_RenderClear),
    SDL_SYMBOL_ITEM(SDL_RenderClipEnabled),
    SDL_SYMBOL_ITEM(SDL_RenderCoordinatesFromWindow),
    SDL_SYMBOL_ITEM(SDL_RenderCoordinatesToWindow),
    SDL_SYMBOL_ITEM(SDL_RenderFillRect),
    SDL_SYMBOL_ITEM(SDL_RenderFillRects),
    SDL_SYMBOL_ITEM(SDL_RenderGeometry),
    SDL_SYMBOL_ITEM(SDL_RenderGeometryRaw),
    SDL_SYMBOL_ITEM(SDL_RenderLine),
    SDL_SYMBOL_ITEM(SDL_RenderLines),
    SDL_SYMBOL_ITEM(SDL_RenderPoint),
    SDL_SYMBOL_ITEM(SDL_RenderPoints),
    SDL_SYMBOL_ITEM(SDL_RenderPresent),
    SDL_SYMBOL_ITEM(SDL_RenderReadPixels),
    SDL_SYMBOL_ITEM(SDL_RenderRect),
    SDL_SYMBOL_ITEM(SDL_RenderRects),
    SDL_SYMBOL_ITEM(SDL_RenderTexture9Grid),
    SDL_SYMBOL_ITEM(SDL_RenderTexture),
    SDL_SYMBOL_ITEM(SDL_RenderTextureRotated),
    SDL_SYMBOL_ITEM(SDL_RenderTextureTiled),
    SDL_SYMBOL_ITEM(SDL_RenderViewportSet),
    SDL_SYMBOL_ITEM(SDL_ReportAssertion),
    SDL_SYMBOL_ITEM(SDL_RequestAndroidPermission),
    SDL_SYMBOL_ITEM(SDL_ResetAssertionReport),
    SDL_SYMBOL_ITEM(SDL_ResetHint),
    SDL_SYMBOL_ITEM(SDL_ResetHints),
    SDL_SYMBOL_ITEM(SDL_ResetKeyboard),
    SDL_SYMBOL_ITEM(SDL_ResetLogPriorities),
    SDL_SYMBOL_ITEM(SDL_RestoreWindow),
    SDL_SYMBOL_ITEM(SDL_ResumeAudioDevice),
    SDL_SYMBOL_ITEM(SDL_ResumeAudioStreamDevice),
    SDL_SYMBOL_ITEM(SDL_ResumeHaptic),
    SDL_SYMBOL_ITEM(SDL_RumbleGamepad),
    SDL_SYMBOL_ITEM(SDL_RumbleGamepadTriggers),
    SDL_SYMBOL_ITEM(SDL_RumbleJoystick),
    SDL_SYMBOL_ITEM(SDL_RumbleJoystickTriggers),
    SDL_SYMBOL_ITEM(SDL_RunApp),
    SDL_SYMBOL_ITEM(SDL_RunHapticEffect),
    SDL_SYMBOL_ITEM(SDL_SaveBMP),
    SDL_SYMBOL_ITEM(SDL_SaveBMP_IO),
    SDL_SYMBOL_ITEM(SDL_ScaleSurface),
    SDL_SYMBOL_ITEM(SDL_ScreenKeyboardShown),
    SDL_SYMBOL_ITEM(SDL_ScreenSaverEnabled),
    SDL_SYMBOL_ITEM(SDL_SeekIO),
    SDL_SYMBOL_ITEM(SDL_SendAndroidBackButton),
    SDL_SYMBOL_ITEM(SDL_SendAndroidMessage),
    SDL_SYMBOL_ITEM(SDL_SendGamepadEffect),
    SDL_SYMBOL_ITEM(SDL_SendJoystickEffect),
    SDL_SYMBOL_ITEM(SDL_SendJoystickVirtualSensorData),
    SDL_SYMBOL_ITEM(SDL_SetAppMetadata),
    SDL_SYMBOL_ITEM(SDL_SetAppMetadataProperty),
    SDL_SYMBOL_ITEM(SDL_SetAssertionHandler),
    SDL_SYMBOL_ITEM(SDL_SetAtomicInt),
    SDL_SYMBOL_ITEM(SDL_SetAtomicPointer),
    SDL_SYMBOL_ITEM(SDL_SetAtomicU32),
    SDL_SYMBOL_ITEM(SDL_SetAudioDeviceGain),
    SDL_SYMBOL_ITEM(SDL_SetAudioPostmixCallback),
    SDL_SYMBOL_ITEM(SDL_SetAudioStreamFormat),
    SDL_SYMBOL_ITEM(SDL_SetAudioStreamFrequencyRatio),
    SDL_SYMBOL_ITEM(SDL_SetAudioStreamGain),
    SDL_SYMBOL_ITEM(SDL_SetAudioStreamGetCallback),
    SDL_SYMBOL_ITEM(SDL_SetAudioStreamInputChannelMap),
    SDL_SYMBOL_ITEM(SDL_SetAudioStreamOutputChannelMap),
    SDL_SYMBOL_ITEM(SDL_SetAudioStreamPutCallback),
    SDL_SYMBOL_ITEM(SDL_SetBooleanProperty),
    SDL_SYMBOL_ITEM(SDL_SetClipboardData),
    SDL_SYMBOL_ITEM(SDL_SetClipboardText),
    SDL_SYMBOL_ITEM(SDL_SetCurrentThreadPriority),
    SDL_SYMBOL_ITEM(SDL_SetCursor),
    SDL_SYMBOL_ITEM(SDL_SetEnvironmentVariable),
    SDL_SYMBOL_ITEM(SDL_SetError),
    SDL_SYMBOL_ITEM(SDL_SetEventEnabled),
    SDL_SYMBOL_ITEM(SDL_SetEventFilter),
    SDL_SYMBOL_ITEM(SDL_SetFloatProperty),
    SDL_SYMBOL_ITEM(SDL_SetGPUBlendConstants),
    SDL_SYMBOL_ITEM(SDL_SetGPUBufferName),
    SDL_SYMBOL_ITEM(SDL_SetGPUScissor),
    SDL_SYMBOL_ITEM(SDL_SetGPUStencilReference),
    SDL_SYMBOL_ITEM(SDL_SetGPUSwapchainParameters),
    SDL_SYMBOL_ITEM(SDL_SetGPUTextureName),
    SDL_SYMBOL_ITEM(SDL_SetGPUViewport),
    SDL_SYMBOL_ITEM(SDL_SetGamepadEventsEnabled),
    SDL_SYMBOL_ITEM(SDL_SetGamepadLED),
    SDL_SYMBOL_ITEM(SDL_SetGamepadMapping),
    SDL_SYMBOL_ITEM(SDL_SetGamepadPlayerIndex),
    SDL_SYMBOL_ITEM(SDL_SetGamepadSensorEnabled),
    SDL_SYMBOL_ITEM(SDL_SetHapticAutocenter),
    SDL_SYMBOL_ITEM(SDL_SetHapticGain),
    SDL_SYMBOL_ITEM(SDL_SetHint),
    SDL_SYMBOL_ITEM(SDL_SetHintWithPriority),
    SDL_SYMBOL_ITEM(SDL_SetInitialized),
    SDL_SYMBOL_ITEM(SDL_SetJoystickEventsEnabled),
    SDL_SYMBOL_ITEM(SDL_SetJoystickLED),
    SDL_SYMBOL_ITEM(SDL_SetJoystickPlayerIndex),
    SDL_SYMBOL_ITEM(SDL_SetJoystickVirtualAxis),
    SDL_SYMBOL_ITEM(SDL_SetJoystickVirtualBall),
    SDL_SYMBOL_ITEM(SDL_SetJoystickVirtualButton),
    SDL_SYMBOL_ITEM(SDL_SetJoystickVirtualHat),
    SDL_SYMBOL_ITEM(SDL_SetJoystickVirtualTouchpad),
    SDL_SYMBOL_ITEM(SDL_SetLinuxThreadPriority),
    SDL_SYMBOL_ITEM(SDL_SetLinuxThreadPriorityAndPolicy),
    SDL_SYMBOL_ITEM(SDL_SetLogOutputFunction),
    SDL_SYMBOL_ITEM(SDL_SetLogPriorities),
    SDL_SYMBOL_ITEM(SDL_SetLogPriority),
    SDL_SYMBOL_ITEM(SDL_SetLogPriorityPrefix),
    SDL_SYMBOL_ITEM(SDL_SetMainReady),
    SDL_SYMBOL_ITEM(SDL_SetMemoryFunctions),
    SDL_SYMBOL_ITEM(SDL_SetModState),
    SDL_SYMBOL_ITEM(SDL_SetNumberProperty),
    SDL_SYMBOL_ITEM(SDL_SetPaletteColors),
    SDL_SYMBOL_ITEM(SDL_SetPointerProperty),
    SDL_SYMBOL_ITEM(SDL_SetPointerPropertyWithCleanup),
    SDL_SYMBOL_ITEM(SDL_SetPrimarySelectionText),
    SDL_SYMBOL_ITEM(SDL_SetRenderClipRect),
    SDL_SYMBOL_ITEM(SDL_SetRenderColorScale),
    SDL_SYMBOL_ITEM(SDL_SetRenderDrawBlendMode),
    SDL_SYMBOL_ITEM(SDL_SetRenderDrawColor),
    SDL_SYMBOL_ITEM(SDL_SetRenderDrawColorFloat),
    SDL_SYMBOL_ITEM(SDL_SetRenderLogicalPresentation),
    SDL_SYMBOL_ITEM(SDL_SetRenderScale),
    SDL_SYMBOL_ITEM(SDL_SetRenderTarget),
    SDL_SYMBOL_ITEM(SDL_SetRenderVSync),
    SDL_SYMBOL_ITEM(SDL_SetRenderViewport),
    SDL_SYMBOL_ITEM(SDL_SetScancodeName),
    SDL_SYMBOL_ITEM(SDL_SetStringProperty),
    SDL_SYMBOL_ITEM(SDL_SetSurfaceAlphaMod),
    SDL_SYMBOL_ITEM(SDL_SetSurfaceBlendMode),
    SDL_SYMBOL_ITEM(SDL_SetSurfaceClipRect),
    SDL_SYMBOL_ITEM(SDL_SetSurfaceColorKey),
    SDL_SYMBOL_ITEM(SDL_SetSurfaceColorMod),
    SDL_SYMBOL_ITEM(SDL_SetSurfaceColorspace),
    SDL_SYMBOL_ITEM(SDL_SetSurfacePalette),
    SDL_SYMBOL_ITEM(SDL_SetSurfaceRLE),
    SDL_SYMBOL_ITEM(SDL_SetTLS),
    SDL_SYMBOL_ITEM(SDL_SetTextInputArea),
    SDL_SYMBOL_ITEM(SDL_SetTextureAlphaMod),
    SDL_SYMBOL_ITEM(SDL_SetTextureAlphaModFloat),
    SDL_SYMBOL_ITEM(SDL_SetTextureBlendMode),
    SDL_SYMBOL_ITEM(SDL_SetTextureColorMod),
    SDL_SYMBOL_ITEM(SDL_SetTextureColorModFloat),
    SDL_SYMBOL_ITEM(SDL_SetTextureScaleMode),
    SDL_SYMBOL_ITEM(SDL_SetWindowAlwaysOnTop),
    SDL_SYMBOL_ITEM(SDL_SetWindowAspectRatio),
    SDL_SYMBOL_ITEM(SDL_SetWindowBordered),
    SDL_SYMBOL_ITEM(SDL_SetWindowFocusable),
    SDL_SYMBOL_ITEM(SDL_SetWindowFullscreen),
    SDL_SYMBOL_ITEM(SDL_SetWindowFullscreenMode),
    SDL_SYMBOL_ITEM(SDL_SetWindowHitTest),
    SDL_SYMBOL_ITEM(SDL_SetWindowIcon),
    SDL_SYMBOL_ITEM(SDL_SetWindowKeyboardGrab),
    SDL_SYMBOL_ITEM(SDL_SetWindowMaximumSize),
    SDL_SYMBOL_ITEM(SDL_SetWindowMinimumSize),
    SDL_SYMBOL_ITEM(SDL_SetWindowModal),
    SDL_SYMBOL_ITEM(SDL_SetWindowMouseGrab),
    SDL_SYMBOL_ITEM(SDL_SetWindowMouseRect),
    SDL_SYMBOL_ITEM(SDL_SetWindowOpacity),
    SDL_SYMBOL_ITEM(SDL_SetWindowParent),
    SDL_SYMBOL_ITEM(SDL_SetWindowPosition),
    SDL_SYMBOL_ITEM(SDL_SetWindowRelativeMouseMode),
    SDL_SYMBOL_ITEM(SDL_SetWindowResizable),
    SDL_SYMBOL_ITEM(SDL_SetWindowShape),
    SDL_SYMBOL_ITEM(SDL_SetWindowSize),
    SDL_SYMBOL_ITEM(SDL_SetWindowSurfaceVSync),
    SDL_SYMBOL_ITEM(SDL_SetWindowTitle),
    SDL_SYMBOL_ITEM(SDL_SetWindowsMessageHook),
    SDL_SYMBOL_ITEM(SDL_SetX11EventHook),
    SDL_SYMBOL_ITEM(SDL_SetiOSAnimationCallback),
    SDL_SYMBOL_ITEM(SDL_SetiOSEventPump),
    SDL_SYMBOL_ITEM(SDL_ShouldInit),
    SDL_SYMBOL_ITEM(SDL_ShouldQuit),
    SDL_SYMBOL_ITEM(SDL_ShowAndroidToast),
    SDL_SYMBOL_ITEM(SDL_ShowCursor),
    SDL_SYMBOL_ITEM(SDL_ShowMessageBox),
    SDL_SYMBOL_ITEM(SDL_ShowOpenFileDialog),
    SDL_SYMBOL_ITEM(SDL_ShowOpenFolderDialog),
    SDL_SYMBOL_ITEM(SDL_ShowSaveFileDialog),
    SDL_SYMBOL_ITEM(SDL_ShowSimpleMessageBox),
    SDL_SYMBOL_ITEM(SDL_ShowWindow),
    SDL_SYMBOL_ITEM(SDL_ShowWindowSystemMenu),
    SDL_SYMBOL_ITEM(SDL_SignalCondition),
    SDL_SYMBOL_ITEM(SDL_SignalSemaphore),
    SDL_SYMBOL_ITEM(SDL_StartTextInput),
    SDL_SYMBOL_ITEM(SDL_StartTextInputWithProperties),
    SDL_SYMBOL_ITEM(SDL_StepUTF8),
    SDL_SYMBOL_ITEM(SDL_StopHapticEffect),
    SDL_SYMBOL_ITEM(SDL_StopHapticEffects),
    SDL_SYMBOL_ITEM(SDL_StopHapticRumble),
    SDL_SYMBOL_ITEM(SDL_StopTextInput),
    SDL_SYMBOL_ITEM(SDL_StorageReady),
    SDL_SYMBOL_ITEM(SDL_StringToGUID),
    SDL_SYMBOL_ITEM(SDL_SubmitGPUCommandBuffer),
    SDL_SYMBOL_ITEM(SDL_SubmitGPUCommandBufferAndAcquireFence),
    SDL_SYMBOL_ITEM(SDL_SurfaceHasAlternateImages),
    SDL_SYMBOL_ITEM(SDL_SurfaceHasColorKey),
    SDL_SYMBOL_ITEM(SDL_SurfaceHasRLE),
    SDL_SYMBOL_ITEM(SDL_SyncWindow),
    SDL_SYMBOL_ITEM(SDL_TellIO),
    SDL_SYMBOL_ITEM(SDL_TextInputActive),
    SDL_SYMBOL_ITEM(SDL_TimeFromWindows),
    SDL_SYMBOL_ITEM(SDL_TimeToDateTime),
    SDL_SYMBOL_ITEM(SDL_TimeToWindows),
    SDL_SYMBOL_ITEM(SDL_TryLockMutex),
    SDL_SYMBOL_ITEM(SDL_TryLockRWLockForReading),
    SDL_SYMBOL_ITEM(SDL_TryLockRWLockForWriting),
    SDL_SYMBOL_ITEM(SDL_TryLockSpinlock),
    SDL_SYMBOL_ITEM(SDL_TryWaitSemaphore),
    SDL_SYMBOL_ITEM(SDL_UCS4ToUTF8),
    SDL_SYMBOL_ITEM(SDL_UnbindAudioStream),
    SDL_SYMBOL_ITEM(SDL_UnbindAudioStreams),
    SDL_SYMBOL_ITEM(SDL_UnloadObject),
    SDL_SYMBOL_ITEM(SDL_UnlockAudioStream),
    SDL_SYMBOL_ITEM(SDL_UnlockJoysticks),
    SDL_SYMBOL_ITEM(SDL_UnlockMutex),
    SDL_SYMBOL_ITEM(SDL_UnlockProperties),
    SDL_SYMBOL_ITEM(SDL_UnlockRWLock),
    SDL_SYMBOL_ITEM(SDL_UnlockSpinlock),
    SDL_SYMBOL_ITEM(SDL_UnlockSurface),
    SDL_SYMBOL_ITEM(SDL_UnlockTexture),
    SDL_SYMBOL_ITEM(SDL_UnmapGPUTransferBuffer),
    SDL_SYMBOL_ITEM(SDL_UnregisterApp),
    SDL_SYMBOL_ITEM(SDL_UnsetEnvironmentVariable),
    SDL_SYMBOL_ITEM(SDL_UpdateGamepads),
    SDL_SYMBOL_ITEM(SDL_UpdateHapticEffect),
    SDL_SYMBOL_ITEM(SDL_UpdateJoysticks),
    SDL_SYMBOL_ITEM(SDL_UpdateNVTexture),
    SDL_SYMBOL_ITEM(SDL_UpdateSensors),
    SDL_SYMBOL_ITEM(SDL_UpdateTexture),
    SDL_SYMBOL_ITEM(SDL_UpdateWindowSurface),
    SDL_SYMBOL_ITEM(SDL_UpdateWindowSurfaceRects),
    SDL_SYMBOL_ITEM(SDL_UpdateYUVTexture),
    SDL_SYMBOL_ITEM(SDL_UploadToGPUBuffer),
    SDL_SYMBOL_ITEM(SDL_UploadToGPUTexture),
    SDL_SYMBOL_ITEM(SDL_Vulkan_CreateSurface),
    SDL_SYMBOL_ITEM(SDL_Vulkan_DestroySurface),
    SDL_SYMBOL_ITEM(SDL_Vulkan_GetInstanceExtensions),
    SDL_SYMBOL_ITEM(SDL_Vulkan_GetPresentationSupport),
    SDL_SYMBOL_ITEM(SDL_Vulkan_GetVkGetInstanceProcAddr),
    SDL_SYMBOL_ITEM(SDL_Vulkan_LoadLibrary),
    SDL_SYMBOL_ITEM(SDL_Vulkan_UnloadLibrary),
    SDL_SYMBOL_ITEM(SDL_WaitCondition),
    SDL_SYMBOL_ITEM(SDL_WaitConditionTimeout),
    SDL_SYMBOL_ITEM(SDL_WaitEvent),
    SDL_SYMBOL_ITEM(SDL_WaitEventTimeout),
    SDL_SYMBOL_ITEM(SDL_WaitForGPUFences),
    SDL_SYMBOL_ITEM(SDL_WaitForGPUIdle),
    SDL_SYMBOL_ITEM(SDL_WaitProcess),
    SDL_SYMBOL_ITEM(SDL_WaitSemaphore),
    SDL_SYMBOL_ITEM(SDL_WaitSemaphoreTimeout),
    SDL_SYMBOL_ITEM(SDL_WaitThread),
    SDL_SYMBOL_ITEM(SDL_WarpMouseGlobal),
    SDL_SYMBOL_ITEM(SDL_WarpMouseInWindow),
    SDL_SYMBOL_ITEM(SDL_WasInit),
    SDL_SYMBOL_ITEM(SDL_WindowHasSurface),
    SDL_SYMBOL_ITEM(SDL_WindowSupportsGPUPresentMode),
    SDL_SYMBOL_ITEM(SDL_WindowSupportsGPUSwapchainComposition),
    SDL_SYMBOL_ITEM(SDL_WriteIO),
    SDL_SYMBOL_ITEM(SDL_WriteS16BE),
    SDL_SYMBOL_ITEM(SDL_WriteS16LE),
    SDL_SYMBOL_ITEM(SDL_WriteS32BE),
    SDL_SYMBOL_ITEM(SDL_WriteS32LE),
    SDL_SYMBOL_ITEM(SDL_WriteS64BE),
    SDL_SYMBOL_ITEM(SDL_WriteS64LE),
    SDL_SYMBOL_ITEM(SDL_WriteS8),
    SDL_SYMBOL_ITEM(SDL_WriteStorageFile),
    SDL_SYMBOL_ITEM(SDL_WriteSurfacePixel),
    SDL_SYMBOL_ITEM(SDL_WriteSurfacePixelFloat),
    SDL_SYMBOL_ITEM(SDL_WriteU16BE),
    SDL_SYMBOL_ITEM(SDL_WriteU16LE),
    SDL_SYMBOL_ITEM(SDL_WriteU32BE),
    SDL_SYMBOL_ITEM(SDL_WriteU32LE),
    SDL_SYMBOL_ITEM(SDL_WriteU64BE),
    SDL_SYMBOL_ITEM(SDL_WriteU64LE),
    SDL_SYMBOL_ITEM(SDL_WriteU8),
    SDL_SYMBOL_ITEM(SDL_abs),
    SDL_SYMBOL_ITEM(SDL_acos),
    SDL_SYMBOL_ITEM(SDL_acosf),
    SDL_SYMBOL_ITEM(SDL_aligned_alloc),
    SDL_SYMBOL_ITEM(SDL_aligned_free),
    SDL_SYMBOL_ITEM(SDL_asin),
    SDL_SYMBOL_ITEM(SDL_asinf),
    SDL_SYMBOL_ITEM(SDL_asprintf),
    SDL_SYMBOL_ITEM(SDL_atan2),
    SDL_SYMBOL_ITEM(SDL_atan2f),
    SDL_SYMBOL_ITEM(SDL_atan),
    SDL_SYMBOL_ITEM(SDL_atanf),
    SDL_SYMBOL_ITEM(SDL_atof),
    SDL_SYMBOL_ITEM(SDL_atoi),
    SDL_SYMBOL_ITEM(SDL_bsearch),
    SDL_SYMBOL_ITEM(SDL_bsearch_r),
    SDL_SYMBOL_ITEM(SDL_calloc),
    SDL_SYMBOL_ITEM(SDL_ceil),
    SDL_SYMBOL_ITEM(SDL_ceilf),
    SDL_SYMBOL_ITEM(SDL_copysign),
    SDL_SYMBOL_ITEM(SDL_copysignf),
    SDL_SYMBOL_ITEM(SDL_cos),
    SDL_SYMBOL_ITEM(SDL_cosf),
    SDL_SYMBOL_ITEM(SDL_crc16),
    SDL_SYMBOL_ITEM(SDL_crc32),
    SDL_SYMBOL_ITEM(SDL_exp),
    SDL_SYMBOL_ITEM(SDL_expf),
    SDL_SYMBOL_ITEM(SDL_fabs),
    SDL_SYMBOL_ITEM(SDL_fabsf),
    SDL_SYMBOL_ITEM(SDL_floor),
    SDL_SYMBOL_ITEM(SDL_floorf),
    SDL_SYMBOL_ITEM(SDL_fmod),
    SDL_SYMBOL_ITEM(SDL_fmodf),
    SDL_SYMBOL_ITEM(SDL_free),
    SDL_SYMBOL_ITEM(SDL_getenv),
    SDL_SYMBOL_ITEM(SDL_getenv_unsafe),
    SDL_SYMBOL_ITEM(SDL_hid_ble_scan),
    SDL_SYMBOL_ITEM(SDL_hid_close),
    SDL_SYMBOL_ITEM(SDL_hid_device_change_count),
    SDL_SYMBOL_ITEM(SDL_hid_enumerate),
    SDL_SYMBOL_ITEM(SDL_hid_exit),
    SDL_SYMBOL_ITEM(SDL_hid_free_enumeration),
    SDL_SYMBOL_ITEM(SDL_hid_get_device_info),
    SDL_SYMBOL_ITEM(SDL_hid_get_feature_report),
    SDL_SYMBOL_ITEM(SDL_hid_get_indexed_string),
    SDL_SYMBOL_ITEM(SDL_hid_get_input_report),
    SDL_SYMBOL_ITEM(SDL_hid_get_manufacturer_string),
    SDL_SYMBOL_ITEM(SDL_hid_get_product_string),
    SDL_SYMBOL_ITEM(SDL_hid_get_report_descriptor),
    SDL_SYMBOL_ITEM(SDL_hid_get_serial_number_string),
    SDL_SYMBOL_ITEM(SDL_hid_init),
    SDL_SYMBOL_ITEM(SDL_hid_open),
    SDL_SYMBOL_ITEM(SDL_hid_open_path),
    SDL_SYMBOL_ITEM(SDL_hid_read),
    SDL_SYMBOL_ITEM(SDL_hid_read_timeout),
    SDL_SYMBOL_ITEM(SDL_hid_send_feature_report),
    SDL_SYMBOL_ITEM(SDL_hid_set_nonblocking),
    SDL_SYMBOL_ITEM(SDL_hid_write),
    SDL_SYMBOL_ITEM(SDL_iconv),
    SDL_SYMBOL_ITEM(SDL_iconv_close),
    SDL_SYMBOL_ITEM(SDL_iconv_open),
    SDL_SYMBOL_ITEM(SDL_iconv_string),
    SDL_SYMBOL_ITEM(SDL_isalnum),
    SDL_SYMBOL_ITEM(SDL_isalpha),
    SDL_SYMBOL_ITEM(SDL_isblank),
    SDL_SYMBOL_ITEM(SDL_iscntrl),
    SDL_SYMBOL_ITEM(SDL_isdigit),
    SDL_SYMBOL_ITEM(SDL_isgraph),
    SDL_SYMBOL_ITEM(SDL_isinf),
    SDL_SYMBOL_ITEM(SDL_isinff),
    SDL_SYMBOL_ITEM(SDL_islower),
    SDL_SYMBOL_ITEM(SDL_isnan),
    SDL_SYMBOL_ITEM(SDL_isnanf),
    SDL_SYMBOL_ITEM(SDL_isprint),
    SDL_SYMBOL_ITEM(SDL_ispunct),
    SDL_SYMBOL_ITEM(SDL_isspace),
    SDL_SYMBOL_ITEM(SDL_isupper),
    SDL_SYMBOL_ITEM(SDL_isxdigit),
    SDL_SYMBOL_ITEM(SDL_itoa),
    SDL_SYMBOL_ITEM(SDL_lltoa),
    SDL_SYMBOL_ITEM(SDL_log10),
    SDL_SYMBOL_ITEM(SDL_log10f),
    SDL_SYMBOL_ITEM(SDL_log),
    SDL_SYMBOL_ITEM(SDL_logf),
    SDL_SYMBOL_ITEM(SDL_lround),
    SDL_SYMBOL_ITEM(SDL_lroundf),
    SDL_SYMBOL_ITEM(SDL_ltoa),
    SDL_SYMBOL_ITEM(SDL_malloc),
    SDL_SYMBOL_ITEM(SDL_memcmp),
    SDL_SYMBOL_ITEM(SDL_memcpy),
    SDL_SYMBOL_ITEM(SDL_memmove),
    SDL_SYMBOL_ITEM(SDL_memset4),
    SDL_SYMBOL_ITEM(SDL_memset),
    SDL_SYMBOL_ITEM(SDL_modf),
    SDL_SYMBOL_ITEM(SDL_modff),
    SDL_SYMBOL_ITEM(SDL_murmur3_32),
    SDL_SYMBOL_ITEM(SDL_pow),
    SDL_SYMBOL_ITEM(SDL_powf),
    SDL_SYMBOL_ITEM(SDL_qsort),
    SDL_SYMBOL_ITEM(SDL_qsort_r),
    SDL_SYMBOL_ITEM(SDL_rand),
    SDL_SYMBOL_ITEM(SDL_rand_bits),
    SDL_SYMBOL_ITEM(SDL_rand_bits_r),
    SDL_SYMBOL_ITEM(SDL_rand_r),
    SDL_SYMBOL_ITEM(SDL_randf),
    SDL_SYMBOL_ITEM(SDL_randf_r),
    SDL_SYMBOL_ITEM(SDL_realloc),
    SDL_SYMBOL_ITEM(SDL_round),
    SDL_SYMBOL_ITEM(SDL_roundf),
    SDL_SYMBOL_ITEM(SDL_scalbn),
    SDL_SYMBOL_ITEM(SDL_scalbnf),
    SDL_SYMBOL_ITEM(SDL_setenv_unsafe),
    SDL_SYMBOL_ITEM(SDL_sin),
    SDL_SYMBOL_ITEM(SDL_sinf),
    SDL_SYMBOL_ITEM(SDL_snprintf),
    SDL_SYMBOL_ITEM(SDL_sqrt),
    SDL_SYMBOL_ITEM(SDL_sqrtf),
    SDL_SYMBOL_ITEM(SDL_srand),
    SDL_SYMBOL_ITEM(SDL_sscanf),
    SDL_SYMBOL_ITEM(SDL_strcasecmp),
    SDL_SYMBOL_ITEM(SDL_strcasestr),
    SDL_SYMBOL_ITEM(SDL_strchr),
    SDL_SYMBOL_ITEM(SDL_strcmp),
    SDL_SYMBOL_ITEM(SDL_strdup),
    SDL_SYMBOL_ITEM(SDL_strlcat),
    SDL_SYMBOL_ITEM(SDL_strlcpy),
    SDL_SYMBOL_ITEM(SDL_strlen),
    SDL_SYMBOL_ITEM(SDL_strlwr),
    SDL_SYMBOL_ITEM(SDL_strncasecmp),
    SDL_SYMBOL_ITEM(SDL_strncmp),
    SDL_SYMBOL_ITEM(SDL_strndup),
    SDL_SYMBOL_ITEM(SDL_strnlen),
    SDL_SYMBOL_ITEM(SDL_strnstr),
    SDL_SYMBOL_ITEM(SDL_strpbrk),
    SDL_SYMBOL_ITEM(SDL_strrchr),
    SDL_SYMBOL_ITEM(SDL_strrev),
    SDL_SYMBOL_ITEM(SDL_strstr),
    SDL_SYMBOL_ITEM(SDL_strtod),
    SDL_SYMBOL_ITEM(SDL_strtok_r),
    SDL_SYMBOL_ITEM(SDL_strtol),
    SDL_SYMBOL_ITEM(SDL_strtoll),
    SDL_SYMBOL_ITEM(SDL_strtoul),
    SDL_SYMBOL_ITEM(SDL_strtoull),
    SDL_SYMBOL_ITEM(SDL_strupr),
    SDL_SYMBOL_ITEM(SDL_swprintf),
    SDL_SYMBOL_ITEM(SDL_tan),
    SDL_SYMBOL_ITEM(SDL_tanf),
    SDL_SYMBOL_ITEM(SDL_tolower),
    SDL_SYMBOL_ITEM(SDL_toupper),
    SDL_SYMBOL_ITEM(SDL_trunc),
    SDL_SYMBOL_ITEM(SDL_truncf),
    SDL_SYMBOL_ITEM(SDL_uitoa),
    SDL_SYMBOL_ITEM(SDL_ulltoa),
    SDL_SYMBOL_ITEM(SDL_ultoa),
    SDL_SYMBOL_ITEM(SDL_unsetenv_unsafe),
    SDL_SYMBOL_ITEM(SDL_utf8strlcpy),
    SDL_SYMBOL_ITEM(SDL_utf8strlen),
    SDL_SYMBOL_ITEM(SDL_utf8strnlen),
    SDL_SYMBOL_ITEM(SDL_vasprintf),
    SDL_SYMBOL_ITEM(SDL_vsnprintf),
    SDL_SYMBOL_ITEM(SDL_vsscanf),
    SDL_SYMBOL_ITEM(SDL_vswprintf),
    SDL_SYMBOL_ITEM(SDL_wcscasecmp),
    SDL_SYMBOL_ITEM(SDL_wcscmp),
    SDL_SYMBOL_ITEM(SDL_wcsdup),
    SDL_SYMBOL_ITEM(SDL_wcslcat),
    SDL_SYMBOL_ITEM(SDL_wcslcpy),
    SDL_SYMBOL_ITEM(SDL_wcslen),
    SDL_SYMBOL_ITEM(SDL_wcsncasecmp),
    SDL_SYMBOL_ITEM(SDL_wcsncmp),
    SDL_SYMBOL_ITEM(SDL_wcsnlen),
    SDL_SYMBOL_ITEM(SDL_wcsnstr),
    SDL_SYMBOL_ITEM(SDL_wcsstr),
    SDL_SYMBOL_ITEM(SDL_wcstol),
    SDL_SYMBOL_ITEM(SDL_StepBackUTF8),
    SDL_SYMBOL_ITEM(SDL_DelayPrecise),
    SDL_SYMBOL_ITEM(SDL_CalculateGPUTextureFormatSize),
    SDL_SYMBOL_ITEM(SDL_SetErrorV),
    SDL_SYMBOL_ITEM(SDL_GetDefaultLogOutputFunction),
    SDL_SYMBOL_ITEM(SDL_RenderDebugText),
    SDL_SYMBOL_ITEM(SDL_GetSandbox),
    SDL_SYMBOL_ITEM(SDL_CancelGPUCommandBuffer),
    SDL_SYMBOL_ITEM(SDL_SaveFile_IO),
    SDL_SYMBOL_ITEM(SDL_SaveFile),
    SDL_SYMBOL_ITEM(SDL_GetCurrentDirectory),
    SDL_SYMBOL_ITEM(SDL_IsAudioDevicePhysical),
    SDL_SYMBOL_ITEM(SDL_IsAudioDevicePlayback),
    SDL_SYMBOL_ITEM(SDL_AsyncIOFromFile),
    SDL_SYMBOL_ITEM(SDL_GetAsyncIOSize),
    SDL_SYMBOL_ITEM(SDL_ReadAsyncIO),
    SDL_SYMBOL_ITEM(SDL_WriteAsyncIO),
    SDL_SYMBOL_ITEM(SDL_CloseAsyncIO),
    SDL_SYMBOL_ITEM(SDL_CreateAsyncIOQueue),
    SDL_SYMBOL_ITEM(SDL_DestroyAsyncIOQueue),
    SDL_SYMBOL_ITEM(SDL_GetAsyncIOResult),
    SDL_SYMBOL_ITEM(SDL_WaitAsyncIOResult),
    SDL_SYMBOL_ITEM(SDL_SignalAsyncIOQueue),
    SDL_SYMBOL_ITEM(SDL_LoadFileAsync),
    SDL_SYMBOL_ITEM(SDL_ShowFileDialogWithProperties),
    SDL_SYMBOL_ITEM(SDL_IsMainThread),
    SDL_SYMBOL_ITEM(SDL_RunOnMainThread),
    SDL_SYMBOL_ITEM(SDL_SetGPUAllowedFramesInFlight),
    SDL_SYMBOL_ITEM(SDL_RenderTextureAffine),
    SDL_SYMBOL_ITEM(SDL_WaitForGPUSwapchain),
    SDL_SYMBOL_ITEM(SDL_WaitAndAcquireGPUSwapchainTexture),
    SDL_SYMBOL_ITEM(SDL_RenderDebugTextFormat),
    SDL_SYMBOL_ITEM(SDL_CreateTray),
    SDL_SYMBOL_ITEM(SDL_SetTrayIcon),
    SDL_SYMBOL_ITEM(SDL_SetTrayTooltip),
    SDL_SYMBOL_ITEM(SDL_CreateTrayMenu),
    SDL_SYMBOL_ITEM(SDL_CreateTraySubmenu),
    SDL_SYMBOL_ITEM(SDL_GetTrayMenu),
    SDL_SYMBOL_ITEM(SDL_GetTraySubmenu),
    SDL_SYMBOL_ITEM(SDL_GetTrayEntries),
    SDL_SYMBOL_ITEM(SDL_RemoveTrayEntry),
    SDL_SYMBOL_ITEM(SDL_InsertTrayEntryAt),
    SDL_SYMBOL_ITEM(SDL_SetTrayEntryLabel),
    SDL_SYMBOL_ITEM(SDL_GetTrayEntryLabel),
    SDL_SYMBOL_ITEM(SDL_SetTrayEntryChecked),
    SDL_SYMBOL_ITEM(SDL_GetTrayEntryChecked),
    SDL_SYMBOL_ITEM(SDL_SetTrayEntryEnabled),
    SDL_SYMBOL_ITEM(SDL_GetTrayEntryEnabled),
    SDL_SYMBOL_ITEM(SDL_SetTrayEntryCallback),
    SDL_SYMBOL_ITEM(SDL_DestroyTray),
    SDL_SYMBOL_ITEM(SDL_GetTrayEntryParent),
    SDL_SYMBOL_ITEM(SDL_GetTrayMenuParentEntry),
    SDL_SYMBOL_ITEM(SDL_GetTrayMenuParentTray),
    SDL_SYMBOL_ITEM(SDL_GetThreadState),
    SDL_SYMBOL_ITEM(SDL_AudioStreamDevicePaused),
    SDL_SYMBOL_ITEM(SDL_ClickTrayEntry),
    SDL_SYMBOL_ITEM(SDL_UpdateTrays),
    SDL_SYMBOL_ITEM(SDL_StretchSurface),
    SDL_SYMBOL_ITEM(SDL_SetRelativeMouseTransform),
    SDL_SYMBOL_ITEM(SDL_RenderTexture9GridTiled),
    SDL_SYMBOL_ITEM(SDL_SetDefaultTextureScaleMode),
    SDL_SYMBOL_ITEM(SDL_GetDefaultTextureScaleMode),
    SDL_SYMBOL_ITEM(SDL_CreateGPURenderState),
    SDL_SYMBOL_ITEM(SDL_SetGPURenderStateFragmentUniforms),
    SDL_SYMBOL_ITEM(SDL_SetGPURenderState),
    SDL_SYMBOL_ITEM(SDL_DestroyGPURenderState),
    SDL_SYMBOL_ITEM(SDL_SetWindowProgressState),
    SDL_SYMBOL_ITEM(SDL_SetWindowProgressValue),
    SDL_SYMBOL_ITEM(SDL_GetWindowProgressState),
    SDL_SYMBOL_ITEM(SDL_GetWindowProgressValue),
    SDL_SYMBOL_ITEM(SDL_SetRenderTextureAddressMode),
    SDL_SYMBOL_ITEM(SDL_GetRenderTextureAddressMode),
    SDL_SYMBOL_ITEM(SDL_GetGPUDeviceProperties),
    SDL_SYMBOL_ITEM(SDL_CreateGPURenderer),
    SDL_SYMBOL_ITEM(SDL_PutAudioStreamPlanarData),
    SDL_SYMBOL_ITEM(SDL_GetEventDescription),
    SDL_SYMBOL_ITEM(SDL_PutAudioStreamDataNoCopy),
    SDL_SYMBOL_ITEM(SDL_AddAtomicU32),
    SDL_SYMBOL_ITEM(SDL_hid_get_properties),
    SDL_SYMBOL_ITEM(SDL_GetPixelFormatFromGPUTextureFormat),
    SDL_SYMBOL_ITEM(SDL_GetGPUTextureFormatFromPixelFormat),
    SDL_SYMBOL_ITEM(SDL_SetTexturePalette),
    SDL_SYMBOL_ITEM(SDL_GetTexturePalette),
    SDL_SYMBOL_ITEM(SDL_GetGPURendererDevice),
    /* extra symbols go here (don't modify this line) */
    { NULL, NULL }
};

static void print_usage(const char *argv0)
{
    SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "Usage: %s [number [number] ...]\n", argv0);
}

int main(int argc, char *argv[])
{
    static const int count_sdl_symbols = (int)SDL_arraysize(sdl_symbols) - 1;
    int i;
    int result = 0;
    SDL_Log("There are %d SDL3 symbols", count_sdl_symbols);
    for (i = 1; i < argc; i++) {
        Sint64 symbol_index = -1;
        char *endp = NULL;
        symbol_index = (Sint64)SDL_strtol(argv[i], &endp, 10);
        if (*endp != '\0') {
            print_usage(argv[0]);
            return 1;
        }
        if (symbol_index < 0 || symbol_index >= count_sdl_symbols) {
            SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "Index %" SDL_PRIs64 " is out of range", symbol_index);
            result = 1;
            continue;
        }
        SDL_Log("Address of %s is %p", sdl_symbols[symbol_index].name, sdl_symbols[symbol_index].address);
    }
    return result;
}
