---
myst:
  html_meta:
    keywords: LaTeX, compiler un document LaTeX, générer un PDF, produire un fichier PDF
---
# Comment générer un PDF à partir d'un document LaTeX ?

Il existe trois moyens principaux de générer un [PDF](/5_fichiers/formats/pdf/start)
avec LaTeX :

- l'utilisation d'un générateur PDF direct de type TeX tel que
  [`pdfTeX`](/1_generalites/glossaire/pdftex) ;
- la conversion directe d'un fichier [DVI](/5_fichiers/formats/dvi/start) ;
- la voie de la « distillation » d'Adobe, qui transforme un document PostScript
  en document PDF.

Pour les documents simples sans hyperliens, vous pouvez soit :

- traiter le document directement en PDF avec
  [`pdfTeX`](/1_generalites/glossaire/pdftex),
  [`LuaTeX`](/1_generalites/glossaire/luatex) ou
  [`XeTeX`](/1_generalites/glossaire/xetex). Ce sont les méthodes les plus
  couramment utilisées ;
- sur une machine Windows ou Macintosh avec les outils appropriés installés,
  envoyer votre sortie imprimable vers un générateur de PDF à la place d'un
  pilote d'imprimante. Cette solution n'est appropriée que pour les documents
  simples : les générateurs de PDF ne peuvent pas créer d'hyperliens ;
- traiter le document avec LaTeX pour obtenir un DVI puis générer un PDF
  directement à partir de ce DVI en utilisant `dvipdfm` ou `dvipdfmx` ;
- traiter le document de manière à générer une sortie PostScript, puis utiliser
  le programme `Adobe Distiller`. Bien qu'il n'y ait pas d'implémentation
  gratuite de toutes les fonctionnalités d’`Adobe Distiller`, toutes les
  versions récentes de [Ghostscript](https://www.ghostscript.com/) fournissent
  une mécanique approchante assez fiable (en se méfiant des problèmes liés aux
  [sorties associée à la chaine DVI-Postscript](/5_fichiers/formats/pdf/generer_un_fichier_pdf_de_qualite)).

## La gestion des références croisées et hyperliens

Pour traduire toutes les références croisées LaTeX en liens PDF, vous avez
besoin d'une extension LaTeX pour redéfinir les commandes internes. Il en existe
deux pour LaTeX, toutes deux capables de se conformer à la 
[spécification HyperTeX](/3_composition/document/document_creation/comment_faire_un_document_hypertexte) :

- <ctanpkg:hyperref> de Heiko Oberdiek, que presque tout le monde utilise ;
- <ctanpkg:hyper> de Michael Mehlich, qui n'a pas été mis à jour depuis 2000.

<ctanpkg:hyperref> peut souvent déterminer comment générer de l'hypertexte
à partir de son environnement, mais il existe un large éventail d'options de
configuration que vous pouvez donner via `\usepackage`. L'extension peut
fonctionner en utilisant les primitives `pdfTeX`, les commandes hyperTeX
`\special` ou spécifiques au pilote DVI `\special`. Les programmes `dvips` et
`DVIPSONE` peuvent traduire le DVI avec ces commandes `\special` en PostScript
acceptable pour `Distiller`. De même, `dvipdfm` et `dvipdfmx` ont des commandes
`\special` qui leur sont propres.

## Visualisation du PDF

Vous trouverez sur Wikipedia 
[une liste de logiciels de visualisation](wpfr:Portable_Document_Format#Affichage) 
en français et [une
section plus informative sur ces logiciels](wp:PDF#Viewers_and_editors) en
anglais.  Privilégiez-en un qui actualise automatiquement la vue du fichier
lorsque vous le recompilez après l'avoir ouvert, ou qui du moins propose un
raccourci clavier facile d'accès pour actualiser et un temps de rechargement
rapide.

## Cas particulier de Plain TeX

Si vous utilisez [Plain TeX](/1_generalites/glossaire/plain_tex), les
commandes d [Eplain](/1_generalites/glossaire/eplain) peuvent vous aider à créer
des documents PDF avec des hyperliens. Il peut fonctionner en utilisant des
primitives `pdfTeX` ou les commandes `\special` pour les pilotes DVI
`dvipdfm`/`dvipdfmx`.

:::{sources}
[Making PDF documents from (La)TeX](faquk:FAQ-acrobat)
:::
