/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * OMAP44xx PRM instance offset macros
 *
 * Copyright (C) 2009-2011 Texas Instruments, Inc.
 * Copyright (C) 2009-2010 Nokia Corporation
 *
 * Paul Walmsley (paul@pwsan.com)
 * Rajendra Nayak (rnayak@ti.com)
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 *
 * XXX This file needs to be updated to align on one of "OMAP4", "OMAP44XX",
 *     or "OMAP4430".
 */

#ifndef __ARCH_ARM_MACH_OMAP2_PRM44XX_H
#define __ARCH_ARM_MACH_OMAP2_PRM44XX_H

#include "prm44xx_54xx.h"
#include "prm.h"

#define OMAP4430_PRM_BASE		0x4a306000

#define OMAP44XX_PRM_REGADDR(inst, reg)				\
	OMAP2_L4_IO_ADDRESS(OMAP4430_PRM_BASE + (inst) + (reg))


/* PRM instances */
#define OMAP4430_PRM_OCP_SOCKET_INST	0x0000
#define OMAP4430_PRM_CKGEN_INST		0x0100
#define OMAP4430_PRM_MPU_INST		0x0300
#define OMAP4430_PRM_TESLA_INST		0x0400
#define OMAP4430_PRM_ABE_INST		0x0500
#define OMAP4430_PRM_ALWAYS_ON_INST	0x0600
#define OMAP4430_PRM_CORE_INST		0x0700
#define OMAP4430_PRM_IVAHD_INST		0x0f00
#define OMAP4430_PRM_CAM_INST		0x1000
#define OMAP4430_PRM_DSS_INST		0x1100
#define OMAP4430_PRM_GFX_INST		0x1200
#define OMAP4430_PRM_L3INIT_INST	0x1300
#define OMAP4430_PRM_L4PER_INST		0x1400
#define OMAP4430_PRM_CEFUSE_INST	0x1600
#define OMAP4430_PRM_WKUP_INST		0x1700
#define OMAP4430_PRM_WKUP_CM_INST	0x1800
#define OMAP4430_PRM_EMU_INST		0x1900
#define OMAP4430_PRM_EMU_CM_INST	0x1a00
#define OMAP4430_PRM_DEVICE_INST	0x1b00

/* PRM clockdomain register offsets (from instance start) */
#define OMAP4430_PRM_WKUP_CM_WKUP_CDOFFS	0x0000
#define OMAP4430_PRM_EMU_CM_EMU_CDOFFS		0x0000

/* OMAP4 specific register offsets */
#define OMAP4_RM_RSTST					0x0004
#define OMAP4_PM_PWSTCTRL				0x0000
#define OMAP4_PM_PWSTST					0x0004

/* PRM.OCP_SOCKET_PRM register offsets */
#define OMAP4_REVISION_PRM_OFFSET			0x0000
#define OMAP4_PRM_IRQSTATUS_MPU_OFFSET			0x0010
#define OMAP4430_PRM_IRQSTATUS_MPU			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0010)
#define OMAP4_PRM_IRQSTATUS_MPU_2_OFFSET		0x0014
#define OMAP4_PRM_IRQENABLE_MPU_OFFSET			0x0018
#define OMAP4430_PRM_IRQENABLE_MPU			OMAP44XX_PRM_REGADDR(OMAP4430_PRM_OCP_SOCKET_INST, 0x0018)

/* PRM.MPU_PRM register offsets */
#define OMAP4_RM_MPU_MPU_CONTEXT_OFFSET			0x0024

/* PRM.DEVICE_PRM register offsets */
#define OMAP4_PRM_RSTCTRL_OFFSET			0x0000
#define OMAP4_PRM_VOLTCTRL_OFFSET			0x0010
#define OMAP4_PRM_IO_PMCTRL_OFFSET			0x0020
#define OMAP4_PRM_VOLTSETUP_CORE_OFF_OFFSET		0x0028
#define OMAP4_PRM_VOLTSETUP_MPU_OFF_OFFSET		0x002c
#define OMAP4_PRM_VOLTSETUP_IVA_OFF_OFFSET		0x0030
#define OMAP4_PRM_VOLTSETUP_CORE_RET_SLEEP_OFFSET	0x0034
#define OMAP4_PRM_VOLTSETUP_MPU_RET_SLEEP_OFFSET	0x0038
#define OMAP4_PRM_VOLTSETUP_IVA_RET_SLEEP_OFFSET	0x003c
#define OMAP4_PRM_VP_CORE_CONFIG_OFFSET			0x0040
#define OMAP4_PRM_VP_CORE_STATUS_OFFSET			0x0044
#define OMAP4_PRM_VP_CORE_VLIMITTO_OFFSET		0x0048
#define OMAP4_PRM_VP_CORE_VOLTAGE_OFFSET		0x004c
#define OMAP4_PRM_VP_CORE_VSTEPMAX_OFFSET		0x0050
#define OMAP4_PRM_VP_CORE_VSTEPMIN_OFFSET		0x0054
#define OMAP4_PRM_VP_MPU_CONFIG_OFFSET			0x0058
#define OMAP4_PRM_VP_MPU_STATUS_OFFSET			0x005c
#define OMAP4_PRM_VP_MPU_VLIMITTO_OFFSET		0x0060
#define OMAP4_PRM_VP_MPU_VOLTAGE_OFFSET			0x0064
#define OMAP4_PRM_VP_MPU_VSTEPMAX_OFFSET		0x0068
#define OMAP4_PRM_VP_MPU_VSTEPMIN_OFFSET		0x006c
#define OMAP4_PRM_VP_IVA_CONFIG_OFFSET			0x0070
#define OMAP4_PRM_VP_IVA_STATUS_OFFSET			0x0074
#define OMAP4_PRM_VP_IVA_VLIMITTO_OFFSET		0x0078
#define OMAP4_PRM_VP_IVA_VOLTAGE_OFFSET			0x007c
#define OMAP4_PRM_VP_IVA_VSTEPMAX_OFFSET		0x0080
#define OMAP4_PRM_VP_IVA_VSTEPMIN_OFFSET		0x0084
#define OMAP4_PRM_VC_SMPS_SA_OFFSET			0x0088
#define OMAP4_PRM_VC_VAL_SMPS_RA_VOL_OFFSET		0x008c
#define OMAP4_PRM_VC_VAL_SMPS_RA_CMD_OFFSET		0x0090
#define OMAP4_PRM_VC_VAL_CMD_VDD_CORE_L_OFFSET		0x0094
#define OMAP4_PRM_VC_VAL_CMD_VDD_MPU_L_OFFSET		0x0098
#define OMAP4_PRM_VC_VAL_CMD_VDD_IVA_L_OFFSET		0x009c
#define OMAP4_PRM_VC_VAL_BYPASS_OFFSET			0x00a0
#define OMAP4_PRM_VC_CFG_CHANNEL_OFFSET			0x00a4
#define OMAP4_PRM_VC_CFG_I2C_MODE_OFFSET		0x00a8
#define OMAP4_PRM_VC_CFG_I2C_CLK_OFFSET			0x00ac

#endif
