// SPDX-License-Identifier: GPL-2.0
#include <linux/font.h>
#include <linux/module.h>

#define FONTDATAMAX 16384

static const struct font_data fontdata_ter16x32 = {
	{ 0, 0, FONTDATAMAX, 0 }, {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 0 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x7f, 0xfc,
	0xf0, 0x1e, 0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e,
	0xee, 0xee, 0xee, 0xee, 0xe0, 0x0e, 0xe0, 0x0e,
	0xe0, 0x0e, 0xe0, 0x0e, 0xef, 0xee, 0xe7, 0xce,
	0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e, 0xf0, 0x1e,
	0x7f, 0xfc, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 1 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8, 0x7f, 0xfc,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0xe3, 0x8e, 0xe3, 0x8e, 0xff, 0xfe, 0xff, 0xfe,
	0xff, 0xfe, 0xff, 0xfe, 0xe0, 0x0e, 0xf0, 0x1e,
	0xf8, 0x3e, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0x7f, 0xfc, 0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 2 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x78, 0x3c, 0xfc, 0x7e, 0xfe, 0xfe, 0xff, 0xfe,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0x7f, 0xfc, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0,
	0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 3 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x80, 0x07, 0xc0, 0x0f, 0xe0,
	0x1f, 0xf0, 0x3f, 0xf8, 0x7f, 0xfc, 0xff, 0xfe,
	0xff, 0xfe, 0x7f, 0xfc, 0x3f, 0xf8, 0x1f, 0xf0,
	0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 4 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x0f, 0xe0,
	0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0,
	0x07, 0xc0, 0x03, 0x80, 0x3b, 0xb8, 0x7f, 0xfc,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0x7f, 0xfc, 0x3b, 0xb8, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 5 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x07, 0xc0, 0x0f, 0xe0, 0x1f, 0xf0, 0x3f, 0xf8,
	0x7f, 0xfc, 0x7f, 0xfc, 0xff, 0xfe, 0xff, 0xfe,
	0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x7b, 0xbc,
	0x3b, 0xb8, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 6 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x07, 0xe0, 0x0f, 0xf0, 0x0f, 0xf0,
	0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 7 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xfc, 0x3f, 0xf8, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f,
	0xf0, 0x0f, 0xf0, 0x0f, 0xf8, 0x1f, 0xfc, 0x3f,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 8 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xc0, 0x07, 0xe0, 0x0e, 0x70, 0x0c, 0x30,
	0x0c, 0x30, 0x0e, 0x70, 0x07, 0xe0, 0x03, 0xc0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 9 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xfc, 0x3f, 0xf8, 0x1f, 0xf1, 0x8f, 0xf3, 0xcf,
	0xf3, 0xcf, 0xf1, 0x8f, 0xf8, 0x1f, 0xfc, 0x3f,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 10 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xfe, 0x03, 0xfe,
	0x00, 0x1e, 0x00, 0x3e, 0x00, 0x76, 0x00, 0xe6,
	0x01, 0xc6, 0x03, 0x86, 0x3f, 0xe0, 0x7f, 0xf0,
	0xf0, 0x78, 0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38,
	0xe0, 0x38, 0xe0, 0x38, 0xe0, 0x38, 0xf0, 0x78,
	0x7f, 0xf0, 0x3f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 11 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8,
	0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x7f, 0xfc, 0x7f, 0xfc, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 12 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfc, 0x3f, 0xfc,
	0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c,
	0x3f, 0xfc, 0x3f, 0xfc, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0xf8, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 13 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x7f, 0xfe,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x7f, 0xfe, 0x7f, 0xfe, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x3e,
	0xf0, 0x3c, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 14 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x73, 0x9c, 0x73, 0x9c,
	0x3b, 0xb8, 0x1f, 0xf0, 0x0f, 0xe0, 0x7c, 0x7c,
	0x7c, 0x7c, 0x0f, 0xe0, 0x1f, 0xf0, 0x3b, 0xb8,
	0x73, 0x9c, 0x73, 0x9c, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 15 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xc0, 0x00, 0xf0, 0x00, 0xfc, 0x00, 0xff, 0x00,
	0xff, 0xc0, 0xff, 0xf0, 0xff, 0xfc, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xfc, 0xff, 0xf0, 0xff, 0xc0,
	0xff, 0x00, 0xfc, 0x00, 0xf0, 0x00, 0xc0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 16 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x03, 0x00, 0x0f, 0x00, 0x3f, 0x00, 0xff,
	0x03, 0xff, 0x0f, 0xff, 0x3f, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x3f, 0xff, 0x0f, 0xff, 0x03, 0xff,
	0x00, 0xff, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 17 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0f, 0xe0, 0x1f, 0xf0, 0x3b, 0xb8, 0x73, 0x9c,
	0x63, 0x8c, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x63, 0x8c,
	0x73, 0x9c, 0x3b, 0xb8, 0x1f, 0xf0, 0x0f, 0xe0,
	0x07, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 18 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 19 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xfe, 0x3f, 0xfe,
	0x79, 0xce, 0x71, 0xce, 0x71, 0xce, 0x71, 0xce,
	0x71, 0xce, 0x71, 0xce, 0x79, 0xce, 0x3f, 0xce,
	0x1f, 0xce, 0x01, 0xce, 0x01, 0xce, 0x01, 0xce,
	0x01, 0xce, 0x01, 0xce, 0x01, 0xce, 0x01, 0xce,
	0x01, 0xce, 0x01, 0xce, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 20 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x07, 0xe0, 0x0f, 0xf0, 0x1e, 0x78, 0x1c, 0x38,
	0x1c, 0x00, 0x1e, 0x00, 0x0f, 0xc0, 0x0f, 0xe0,
	0x1c, 0xf0, 0x1c, 0x78, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x1e, 0x38, 0x0f, 0x38, 0x07, 0xf0,
	0x03, 0xf0, 0x00, 0x78, 0x00, 0x38, 0x1c, 0x38,
	0x1e, 0x78, 0x0f, 0xf0, 0x07, 0xe0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 21 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0x7f, 0xfe,
	0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe,
	0x7f, 0xfe, 0x7f, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 22 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0f, 0xe0, 0x1f, 0xf0, 0x3b, 0xb8, 0x73, 0x9c,
	0x63, 0x8c, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x63, 0x8c, 0x73, 0x9c, 0x3b, 0xb8,
	0x1f, 0xf0, 0x0f, 0xe0, 0x07, 0xc0, 0x03, 0x80,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 23 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0f, 0xe0, 0x1f, 0xf0, 0x3b, 0xb8, 0x73, 0x9c,
	0x63, 0x8c, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 24 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x63, 0x8c,
	0x73, 0x9c, 0x3b, 0xb8, 0x1f, 0xf0, 0x0f, 0xe0,
	0x07, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 25 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0xc0, 0x00, 0xe0, 0x00, 0x70,
	0x00, 0x38, 0x00, 0x1c, 0x7f, 0xfe, 0x7f, 0xfe,
	0x7f, 0xfe, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 26 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x00, 0x07, 0x00, 0x0e, 0x00,
	0x1c, 0x00, 0x38, 0x00, 0x7f, 0xfe, 0x7f, 0xfe,
	0x7f, 0xfe, 0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 27 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 28 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x60, 0x0e, 0x70, 0x1c, 0x38,
	0x38, 0x1c, 0x70, 0x0e, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x70, 0x0e, 0x38, 0x1c, 0x1c, 0x38,
	0x0e, 0x70, 0x06, 0x60, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 29 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x80, 0x01, 0x80, 0x03, 0xc0, 0x03, 0xc0,
	0x07, 0xe0, 0x07, 0xe0, 0x0f, 0xf0, 0x0f, 0xf0,
	0x1f, 0xf8, 0x1f, 0xf8, 0x3f, 0xfc, 0x3f, 0xfc,
	0x7f, 0xfe, 0x7f, 0xfe, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 30 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0x7f, 0xfe, 0x7f, 0xfe,
	0x3f, 0xfc, 0x3f, 0xfc, 0x1f, 0xf8, 0x1f, 0xf8,
	0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0, 0x07, 0xe0,
	0x03, 0xc0, 0x03, 0xc0, 0x01, 0x80, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 31 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 32 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 33 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 34 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x7f, 0xfc,
	0x7f, 0xfc, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x7f, 0xfc,
	0x7f, 0xfc, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 35 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x1f, 0xf0,
	0x3f, 0xf8, 0x7b, 0xbc, 0x73, 0x9c, 0x73, 0x80,
	0x73, 0x80, 0x73, 0x80, 0x7b, 0x80, 0x3f, 0xf0,
	0x1f, 0xf8, 0x03, 0xbc, 0x03, 0x9c, 0x03, 0x9c,
	0x03, 0x9c, 0x73, 0x9c, 0x7b, 0xbc, 0x3f, 0xf8,
	0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 36 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x1c, 0x3f, 0x9c,
	0x3b, 0xb8, 0x3b, 0xb8, 0x3f, 0xf0, 0x1f, 0x70,
	0x00, 0xe0, 0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0,
	0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x07, 0x00,
	0x0e, 0xf8, 0x0f, 0xfc, 0x1d, 0xdc, 0x1d, 0xdc,
	0x39, 0xfc, 0x38, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 37 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x1f, 0xe0,
	0x38, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x70,
	0x38, 0x70, 0x1c, 0xe0, 0x0f, 0xc0, 0x0f, 0x80,
	0x1f, 0xce, 0x38, 0xee, 0x70, 0x7c, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x78, 0x7c,
	0x3f, 0xee, 0x1f, 0xce, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 38 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 39 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x07, 0x00, 0x07, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x07, 0x00, 0x07, 0x00, 0x03, 0x80,
	0x01, 0xc0, 0x00, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 40 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x07, 0x00,
	0x03, 0x80, 0x01, 0xc0, 0x01, 0xc0, 0x00, 0xe0,
	0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0,
	0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0,
	0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 41 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x1c, 0x70,
	0x0e, 0xe0, 0x07, 0xc0, 0x03, 0x80, 0x7f, 0xfc,
	0x7f, 0xfc, 0x03, 0x80, 0x07, 0xc0, 0x0e, 0xe0,
	0x1c, 0x70, 0x38, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 42 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x7f, 0xfc,
	0x7f, 0xfc, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 43 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 44 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 45 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 46 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x70, 0x00, 0x70,
	0x00, 0xe0, 0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0,
	0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x07, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x1c, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 47 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x70, 0x7c, 0x70, 0xfc, 0x71, 0xdc, 0x73, 0x9c,
	0x77, 0x1c, 0x7e, 0x1c, 0x7c, 0x1c, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 48 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0x80,
	0x0f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x1f, 0xf0, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 49 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 50 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x3c, 0x0f, 0xf8,
	0x0f, 0xf8, 0x00, 0x3c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 51 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x3c,
	0x00, 0x7c, 0x00, 0xfc, 0x01, 0xdc, 0x03, 0x9c,
	0x07, 0x1c, 0x0e, 0x1c, 0x1c, 0x1c, 0x38, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 52 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x00, 0x3c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 53 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x3f, 0xf8,
	0x78, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 54 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x38,
	0x00, 0x38, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0,
	0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 55 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c, 0x3f, 0xf8,
	0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 56 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x3c,
	0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 57 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 58 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 59 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x38,
	0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00,
	0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0, 0x00, 0x70,
	0x00, 0x38, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 60 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 61 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x1c, 0x00,
	0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
	0x00, 0xe0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
	0x1c, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 62 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 63 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x3f, 0xfc,
	0x78, 0x0e, 0x70, 0x06, 0x71, 0xfe, 0x73, 0xfe,
	0x77, 0x8e, 0x77, 0x0e, 0x77, 0x0e, 0x77, 0x0e,
	0x77, 0x0e, 0x77, 0x0e, 0x77, 0x0e, 0x77, 0x9e,
	0x73, 0xfe, 0x71, 0xf6, 0x70, 0x00, 0x78, 0x00,
	0x3f, 0xfe, 0x1f, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 64 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 65 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x38, 0x7f, 0xf0, 0x7f, 0xf0,
	0x70, 0x38, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 66 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 67 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xc0, 0x7f, 0xf0,
	0x70, 0x78, 0x70, 0x38, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x38, 0x70, 0x78,
	0x7f, 0xf0, 0x7f, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 68 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x7f, 0xe0,
	0x7f, 0xe0, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 69 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x7f, 0xe0,
	0x7f, 0xe0, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 70 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x71, 0xfc,
	0x71, 0xfc, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 71 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc,
	0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 72 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x0f, 0xe0,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 73 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x00, 0xfe,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x78, 0x78,
	0x3f, 0xf0, 0x1f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 74 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x0c, 0x70, 0x1c,
	0x70, 0x38, 0x70, 0x70, 0x70, 0xe0, 0x71, 0xc0,
	0x73, 0x80, 0x77, 0x00, 0x7e, 0x00, 0x7c, 0x00,
	0x7c, 0x00, 0x7e, 0x00, 0x77, 0x00, 0x73, 0x80,
	0x71, 0xc0, 0x70, 0xe0, 0x70, 0x70, 0x70, 0x38,
	0x70, 0x1c, 0x70, 0x0c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 75 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 76 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x0e, 0x70, 0x0e,
	0x78, 0x1e, 0x7c, 0x3e, 0x7e, 0x7e, 0x7e, 0x7e,
	0x77, 0xee, 0x73, 0xce, 0x73, 0xce, 0x71, 0x8e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 77 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x7c, 0x1c, 0x7e, 0x1c, 0x77, 0x1c, 0x73, 0x9c,
	0x71, 0xdc, 0x70, 0xfc, 0x70, 0x7c, 0x70, 0x3c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 78 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 79 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 80 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x73, 0x9c, 0x79, 0xfc,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x38, 0x00, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 81 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xf0, 0x7f, 0xf8,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x7e, 0x00, 0x77, 0x00,
	0x73, 0x80, 0x71, 0xc0, 0x70, 0xe0, 0x70, 0x70,
	0x70, 0x38, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 82 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x78, 0x00, 0x3f, 0xf0,
	0x1f, 0xf8, 0x00, 0x3c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 83 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 84 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 85 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x0e, 0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0,
	0x07, 0xc0, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 86 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e,
	0x71, 0x8e, 0x73, 0xce, 0x73, 0xce, 0x77, 0xee,
	0x7e, 0x7e, 0x7e, 0x7e, 0x7c, 0x3e, 0x78, 0x1e,
	0x70, 0x0e, 0x70, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 87 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x38, 0x38, 0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70,
	0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0, 0x07, 0xc0,
	0x07, 0xc0, 0x07, 0xc0, 0x0e, 0xe0, 0x0e, 0xe0,
	0x1c, 0x70, 0x1c, 0x70, 0x38, 0x38, 0x38, 0x38,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 88 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x38, 0x38, 0x38, 0x38, 0x1c, 0x70,
	0x1c, 0x70, 0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0,
	0x07, 0xc0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 89 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x38,
	0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 90 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x0f, 0xf0,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x0f, 0xf0, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 91 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x1c, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x01, 0xc0, 0x01, 0xc0, 0x00, 0xe0, 0x00, 0xe0,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 92 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xf0, 0x0f, 0xf0,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70,
	0x0f, 0xf0, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 93 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x07, 0xc0, 0x0e, 0xe0, 0x1c, 0x70,
	0x38, 0x38, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 94 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 95 */
	0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 96 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 97 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 98 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 99 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 100 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 101 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x01, 0xfe,
	0x03, 0xc0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x3f, 0xf8, 0x3f, 0xf8, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 102 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x3c, 0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0x00,	/* 103 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 104 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 105 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xf8, 0x00, 0xf8, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x3c, 0x78, 0x1f, 0xf0, 0x0f, 0xe0, 0x00, 0x00,	/* 106 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x1c, 0x38, 0x38, 0x38, 0x70, 0x38, 0xe0,
	0x39, 0xc0, 0x3b, 0x80, 0x3f, 0x00, 0x3f, 0x00,
	0x3b, 0x80, 0x39, 0xc0, 0x38, 0xe0, 0x38, 0x70,
	0x38, 0x38, 0x38, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 107 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0x80, 0x0f, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 108 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x73, 0xbc, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 109 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 110 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 111 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x00, 0x00,	/* 112 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x00,	/* 113 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x73, 0xfc, 0x77, 0xfc, 0x7e, 0x00, 0x7c, 0x00,
	0x78, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 114 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x00,
	0x70, 0x00, 0x78, 0x00, 0x3f, 0xf0, 0x1f, 0xf8,
	0x00, 0x3c, 0x00, 0x1c, 0x00, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 115 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x7f, 0xf0, 0x7f, 0xf0, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x80,
	0x03, 0xfc, 0x01, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 116 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 117 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0,
	0x07, 0xc0, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 118 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x7b, 0xbc,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 119 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x38, 0x38,
	0x1c, 0x70, 0x0e, 0xe0, 0x07, 0xc0, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x38, 0x38, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 120 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x3c, 0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0x00,	/* 121 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 122 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x03, 0xf0,
	0x07, 0x80, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x3e, 0x00,
	0x3e, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x80,
	0x03, 0xf0, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 123 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 124 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x3f, 0x00,
	0x07, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x01, 0xf0,
	0x01, 0xf0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x07, 0x80,
	0x3f, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 125 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x1c, 0x3f, 0x1c, 0x77, 0x9c, 0x73, 0xdc,
	0x71, 0xf8, 0x70, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 126 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0f, 0xe0, 0x1e, 0xf0, 0x3c, 0x78, 0x78, 0x3c,
	0xf0, 0x1e, 0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e,
	0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e, 0xe0, 0x0e,
	0xff, 0xfe, 0xff, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 127 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x00, 0x00,	/* 128 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 129 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 130 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 131 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 132 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 133 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x0e, 0xe0,
	0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 134 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x00, 0x00,	/* 135 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 136 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 137 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 138 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 139 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 140 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 141 */
	0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 142 */
	0x00, 0x00, 0x07, 0xc0, 0x0e, 0xe0, 0x0e, 0xe0,
	0x0e, 0xe0, 0x07, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 143 */
	0x00, 0x00, 0x00, 0x70, 0x00, 0xe0, 0x01, 0xc0,
	0x03, 0x80, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x7f, 0xe0,
	0x7f, 0xe0, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 144 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf8, 0x7f, 0xfc, 0x03, 0x9e, 0x03, 0x8e,
	0x03, 0x8e, 0x3f, 0x8e, 0x7f, 0xfe, 0xf3, 0xfe,
	0xe3, 0x80, 0xe3, 0x80, 0xe3, 0x80, 0xf3, 0xce,
	0x7f, 0xfe, 0x3e, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 145 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x7f, 0xfe,
	0xf1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
	0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xff, 0xfe,
	0xff, 0xfe, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
	0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
	0xe1, 0xfe, 0xe1, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 146 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 147 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 148 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 149 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x07, 0xc0,
	0x0e, 0xe0, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 150 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 151 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x3c, 0x3f, 0xf8, 0x3f, 0xf0, 0x00, 0x00,	/* 152 */
	0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 153 */
	0x00, 0x00, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 154 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x1f, 0xf0, 0x3f, 0xf8, 0x7b, 0xbc, 0x73, 0x9c,
	0x73, 0x80, 0x73, 0x80, 0x73, 0x80, 0x73, 0x80,
	0x73, 0x80, 0x73, 0x80, 0x73, 0x9c, 0x7b, 0xbc,
	0x3f, 0xf8, 0x1f, 0xf0, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 155 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x0f, 0xf0,
	0x1e, 0x78, 0x1c, 0x38, 0x1c, 0x00, 0x1c, 0x00,
	0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x7f, 0xe0,
	0x7f, 0xe0, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00,
	0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x1c, 0x1c, 0x1c,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 156 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x38, 0x38, 0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70,
	0x0e, 0xe0, 0x0e, 0xe0, 0x07, 0xc0, 0x07, 0xc0,
	0x03, 0x80, 0x03, 0x80, 0x3f, 0xf8, 0x3f, 0xf8,
	0x03, 0x80, 0x03, 0x80, 0x3f, 0xf8, 0x3f, 0xf8,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 157 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0x80,
	0xe3, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0, 0xe1, 0xc0,
	0xe1, 0xc0, 0xe1, 0xc0, 0xe3, 0xc0, 0xff, 0xf0,
	0xff, 0x70, 0xe0, 0x70, 0xe3, 0xfe, 0xe3, 0xfe,
	0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70, 0xe0, 0x70,
	0xe0, 0x7e, 0xe0, 0x3e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 158 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x03, 0xfc,
	0x03, 0x9c, 0x03, 0x9c, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x1f, 0xf0, 0x1f, 0xf0,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x73, 0x80, 0x73, 0x80,
	0x7f, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 159 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xf0, 0x3f, 0xf8, 0x00, 0x3c, 0x00, 0x1c,
	0x00, 0x1c, 0x1f, 0xfc, 0x3f, 0xfc, 0x78, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 160 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x80, 0x0f, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x0f, 0xe0, 0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 161 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xf0, 0x3f, 0xf8, 0x78, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 162 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x3f, 0xfc, 0x1f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 163 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0x38, 0x3b, 0xb8,
	0x3b, 0xb8, 0x39, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xf0, 0x7f, 0xf8, 0x70, 0x3c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 164 */
	0x00, 0x00, 0x1f, 0x38, 0x3b, 0xb8, 0x3b, 0xb8,
	0x39, 0xf0, 0x00, 0x00, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x1c,
	0x7c, 0x1c, 0x7e, 0x1c, 0x77, 0x1c, 0x73, 0x9c,
	0x71, 0xdc, 0x70, 0xfc, 0x70, 0x7c, 0x70, 0x3c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 165 */
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xe0, 0x1f, 0xf0,
	0x00, 0x38, 0x00, 0x38, 0x0f, 0xf8, 0x1f, 0xf8,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1f, 0xf8,
	0x0f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,
	0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 166 */
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x1f, 0xf0,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38,
	0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x1f, 0xf0,
	0x0f, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf8,
	0x3f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 167 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 168 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 169 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 170 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x3c, 0x00,
	0x7c, 0x06, 0x1c, 0x0e, 0x1c, 0x1c, 0x1c, 0x38,
	0x1c, 0x70, 0x1c, 0xe0, 0x1d, 0xc0, 0x03, 0x80,
	0x07, 0x00, 0x0e, 0xfc, 0x1d, 0xfe, 0x39, 0xce,
	0x71, 0xce, 0x60, 0x1c, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xfe, 0x01, 0xfe, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 171 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x1e, 0x00,
	0x3e, 0x00, 0x0e, 0x00, 0x0e, 0x06, 0x0e, 0x0e,
	0x0e, 0x1c, 0x0e, 0x38, 0x0e, 0x70, 0x00, 0xe0,
	0x01, 0xce, 0x03, 0x9e, 0x07, 0x3e, 0x0e, 0x7e,
	0x1c, 0xee, 0x39, 0xce, 0x73, 0xfe, 0x63, 0xfe,
	0x00, 0x0e, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 172 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 173 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0xce, 0x03, 0x9c, 0x07, 0x38, 0x0e, 0x70,
	0x1c, 0xe0, 0x39, 0xc0, 0x73, 0x80, 0x73, 0x80,
	0x39, 0xc0, 0x1c, 0xe0, 0x0e, 0x70, 0x07, 0x38,
	0x03, 0x9c, 0x01, 0xce, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 174 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x73, 0x80, 0x39, 0xc0, 0x1c, 0xe0, 0x0e, 0x70,
	0x07, 0x38, 0x03, 0x9c, 0x01, 0xce, 0x01, 0xce,
	0x03, 0x9c, 0x07, 0x38, 0x0e, 0x70, 0x1c, 0xe0,
	0x39, 0xc0, 0x73, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 175 */
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,
	0xaa, 0xaa, 0x00, 0x00, 0xaa, 0xaa, 0x00, 0x00,	/* 176 */
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,
	0xaa, 0xaa, 0x55, 0x55, 0xaa, 0xaa, 0x55, 0x55,	/* 177 */
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,
	0xff, 0xff, 0xaa, 0xaa, 0xff, 0xff, 0xaa, 0xaa,	/* 178 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 179 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0xff, 0x80, 0xff, 0x80,
	0xff, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 180 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0x03, 0x80,
	0x03, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 181 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0xfe, 0x70, 0xfe, 0x70,
	0xfe, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 182 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xf0, 0xff, 0xf0,
	0xff, 0xf0, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 183 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0x03, 0x80,
	0x03, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 184 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0xfe, 0x70, 0xfe, 0x70, 0xfe, 0x70, 0x00, 0x70,
	0x00, 0x70, 0xfe, 0x70, 0xfe, 0x70, 0xfe, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 185 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 186 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xf0, 0xff, 0xf0, 0xff, 0xf0, 0x00, 0x70,
	0x00, 0x70, 0xfe, 0x70, 0xfe, 0x70, 0xfe, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 187 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0xfe, 0x70, 0xfe, 0x70, 0xfe, 0x70, 0x00, 0x70,
	0x00, 0x70, 0xff, 0xf0, 0xff, 0xf0, 0xff, 0xf0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 188 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0xff, 0xf0, 0xff, 0xf0,
	0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 189 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0x03, 0x80,
	0x03, 0x80, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 190 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0x80, 0xff, 0x80,
	0xff, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 191 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0xff, 0x03, 0xff,
	0x03, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 192 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 193 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 194 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0xff, 0x03, 0xff,
	0x03, 0xff, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 195 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 196 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 197 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0xff, 0x03, 0xff, 0x03, 0xff, 0x03, 0x80,
	0x03, 0x80, 0x03, 0xff, 0x03, 0xff, 0x03, 0xff,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 198 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x7f, 0x0e, 0x7f,
	0x0e, 0x7f, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 199 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x00,
	0x0e, 0x00, 0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 200 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x7f,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 201 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 202 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 203 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x00,
	0x0e, 0x00, 0x0e, 0x7f, 0x0e, 0x7f, 0x0e, 0x7f,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 204 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 205 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0x00, 0x00,
	0x00, 0x00, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 206 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 207 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 208 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00,
	0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 209 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 210 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0f, 0xff, 0x0f, 0xff,
	0x0f, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 211 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0xff, 0x03, 0xff, 0x03, 0xff, 0x03, 0x80,
	0x03, 0x80, 0x03, 0xff, 0x03, 0xff, 0x03, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 212 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x03, 0xff, 0x03, 0xff, 0x03, 0xff, 0x03, 0x80,
	0x03, 0x80, 0x03, 0xff, 0x03, 0xff, 0x03, 0xff,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 213 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0f, 0xff, 0x0f, 0xff,
	0x0f, 0xff, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 214 */
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,
	0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70, 0x0e, 0x70,	/* 215 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x03, 0x80,
	0x03, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 216 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0xff, 0x80, 0xff, 0x80,
	0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 217 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0xff, 0x03, 0xff,
	0x03, 0xff, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 218 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 219 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,	/* 220 */
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00,	/* 221 */
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff,	/* 222 */
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 223 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xee, 0x3f, 0xfe, 0x78, 0x3c, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x70, 0x38, 0x78, 0x3c,
	0x3f, 0xfe, 0x1f, 0xee, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 224 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x3f, 0xe0, 0x7f, 0xf0,
	0x70, 0x78, 0x70, 0x38, 0x70, 0x38, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x70, 0x7f, 0xf0, 0x7f, 0xf0,
	0x70, 0x38, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x3c,
	0x7f, 0xf8, 0x7f, 0xf0, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x00, 0x00,	/* 225 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 226 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 227 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc,
	0x70, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 228 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xfe, 0x3f, 0xfe, 0x78, 0xf0, 0x70, 0x78,
	0x70, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 229 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x3c, 0x70, 0x7c, 0x70, 0xfc,
	0x7f, 0xdc, 0x7f, 0x9c, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x00, 0x00,	/* 230 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0xc0,
	0x01, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 231 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x1f, 0xf0, 0x3f, 0xf8, 0x7b, 0xbc, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c, 0x73, 0x9c,
	0x73, 0x9c, 0x7b, 0xbc, 0x3f, 0xf8, 0x1f, 0xf0,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 232 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x77, 0xdc,
	0x77, 0xdc, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 233 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x3f, 0xf8,
	0x78, 0x3c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x38, 0x38, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70,
	0x7c, 0x7c, 0x7c, 0x7c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 234 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf0, 0x1f, 0xf0,
	0x0e, 0x00, 0x07, 0x00, 0x03, 0x80, 0x01, 0xc0,
	0x0f, 0xe0, 0x1f, 0xf0, 0x38, 0x38, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x78, 0x3c,
	0x3f, 0xf8, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 235 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf8,
	0x7f, 0xfc, 0xe7, 0xce, 0xe3, 0x8e, 0xe3, 0x8e,
	0xe3, 0x8e, 0xe3, 0x8e, 0xe7, 0xce, 0x7f, 0xfc,
	0x3e, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 236 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x1c,
	0x00, 0x38, 0x00, 0x38, 0x0f, 0xf0, 0x1f, 0xf8,
	0x38, 0xfc, 0x38, 0xfc, 0x39, 0xdc, 0x39, 0xdc,
	0x3b, 0x9c, 0x3b, 0x9c, 0x3f, 0x1c, 0x3f, 0x1c,
	0x1f, 0xf8, 0x0f, 0xf0, 0x1c, 0x00, 0x1c, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 237 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x07, 0xfc, 0x1f, 0xfc, 0x3c, 0x00,
	0x38, 0x00, 0x70, 0x00, 0x70, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x70, 0x00, 0x70, 0x00, 0x38, 0x00,
	0x3c, 0x00, 0x1f, 0xfc, 0x07, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 238 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x07, 0xc0, 0x1f, 0xf0,
	0x3c, 0x78, 0x38, 0x38, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c, 0x70, 0x1c,
	0x70, 0x1c, 0x70, 0x1c, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 239 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 240 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x7f, 0xfc,
	0x7f, 0xfc, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x7f, 0xfc, 0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 241 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0,
	0x00, 0x70, 0x00, 0x38, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xfc, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 242 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x70,
	0x00, 0xe0, 0x01, 0xc0, 0x03, 0x80, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x03, 0x80, 0x01, 0xc0, 0x00, 0xe0,
	0x00, 0x70, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x3f, 0xfc, 0x3f, 0xfc, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 243 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x03, 0xfc,
	0x03, 0x9c, 0x03, 0x9c, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,	/* 244 */
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x73, 0x80, 0x73, 0x80,
	0x7f, 0x80, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 245 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc,
	0x7f, 0xfc, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 246 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x1c,
	0x7f, 0xbc, 0x7b, 0xfc, 0x70, 0xf8, 0x00, 0x00,
	0x00, 0x00, 0x3e, 0x1c, 0x7f, 0xbc, 0x7b, 0xfc,
	0x70, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 247 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0xe0, 0x1f, 0xf0, 0x1c, 0x70, 0x1c, 0x70,
	0x1c, 0x70, 0x1c, 0x70, 0x1f, 0xf0, 0x0f, 0xe0,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 248 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0, 0x07, 0xe0,
	0x07, 0xe0, 0x07, 0xe0, 0x03, 0xc0, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 249 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x03, 0x80,
	0x03, 0x80, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 250 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3e,
	0x00, 0x3e, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38,
	0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x70, 0x38,
	0x70, 0x38, 0x70, 0x38, 0x78, 0x38, 0x3c, 0x38,
	0x1e, 0x38, 0x0f, 0x38, 0x07, 0xb8, 0x03, 0xf8,
	0x01, 0xf8, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 251 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1f, 0xe0, 0x1f, 0xf0, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38, 0x1c, 0x38,
	0x1c, 0x38, 0x1c, 0x38, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 252 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0,
	0x1f, 0xf0, 0x1c, 0x70, 0x1c, 0x70, 0x00, 0xe0,
	0x01, 0xc0, 0x03, 0x80, 0x07, 0x00, 0x0e, 0x00,
	0x1f, 0xf0, 0x1f, 0xf0, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 253 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1f, 0xf8, 0x1f, 0xf8,
	0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8,
	0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8,
	0x1f, 0xf8, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 254 */
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,	/* 255 */
} };


const struct font_desc font_ter_16x32 = {
	.idx	= TER16x32_IDX,
	.name	= "TER16x32",
	.width	= 16,
	.height = 32,
	.data	= fontdata_ter16x32.data,
#ifdef __sparc__
	.pref	= 5,
#else
	.pref	= -1,
#endif
};
