// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/clouddms/v1/clouddms_resources.proto

package clouddms

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The database engine types.
type DatabaseEngine int32

const (
	// The source database engine of the migration job is unknown.
	DatabaseEngine_DATABASE_ENGINE_UNSPECIFIED DatabaseEngine = 0
	// The source engine is MySQL.
	DatabaseEngine_MYSQL DatabaseEngine = 1
	// The source engine is PostgreSQL.
	DatabaseEngine_POSTGRESQL DatabaseEngine = 2
)

// Enum value maps for DatabaseEngine.
var (
	DatabaseEngine_name = map[int32]string{
		0: "DATABASE_ENGINE_UNSPECIFIED",
		1: "MYSQL",
		2: "POSTGRESQL",
	}
	DatabaseEngine_value = map[string]int32{
		"DATABASE_ENGINE_UNSPECIFIED": 0,
		"MYSQL":                       1,
		"POSTGRESQL":                  2,
	}
)

func (x DatabaseEngine) Enum() *DatabaseEngine {
	p := new(DatabaseEngine)
	*p = x
	return p
}

func (x DatabaseEngine) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseEngine) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[0].Descriptor()
}

func (DatabaseEngine) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[0]
}

func (x DatabaseEngine) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseEngine.Descriptor instead.
func (DatabaseEngine) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{0}
}

// The database providers.
type DatabaseProvider int32

const (
	// The database provider is unknown.
	DatabaseProvider_DATABASE_PROVIDER_UNSPECIFIED DatabaseProvider = 0
	// CloudSQL runs the database.
	DatabaseProvider_CLOUDSQL DatabaseProvider = 1
	// RDS runs the database.
	DatabaseProvider_RDS DatabaseProvider = 2
)

// Enum value maps for DatabaseProvider.
var (
	DatabaseProvider_name = map[int32]string{
		0: "DATABASE_PROVIDER_UNSPECIFIED",
		1: "CLOUDSQL",
		2: "RDS",
	}
	DatabaseProvider_value = map[string]int32{
		"DATABASE_PROVIDER_UNSPECIFIED": 0,
		"CLOUDSQL":                      1,
		"RDS":                           2,
	}
)

func (x DatabaseProvider) Enum() *DatabaseProvider {
	p := new(DatabaseProvider)
	*p = x
	return p
}

func (x DatabaseProvider) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatabaseProvider) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[1].Descriptor()
}

func (DatabaseProvider) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[1]
}

func (x DatabaseProvider) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatabaseProvider.Descriptor instead.
func (DatabaseProvider) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{1}
}

// Specifies The kind of ssl configuration used.
type SslConfig_SslType int32

const (
	// Unspecified.
	SslConfig_SSL_TYPE_UNSPECIFIED SslConfig_SslType = 0
	// Only 'ca_certificate' specified.
	SslConfig_SERVER_ONLY SslConfig_SslType = 1
	// Both server ('ca_certificate'), and client ('client_key',
	// 'client_certificate') specified.
	SslConfig_SERVER_CLIENT SslConfig_SslType = 2
)

// Enum value maps for SslConfig_SslType.
var (
	SslConfig_SslType_name = map[int32]string{
		0: "SSL_TYPE_UNSPECIFIED",
		1: "SERVER_ONLY",
		2: "SERVER_CLIENT",
	}
	SslConfig_SslType_value = map[string]int32{
		"SSL_TYPE_UNSPECIFIED": 0,
		"SERVER_ONLY":          1,
		"SERVER_CLIENT":        2,
	}
)

func (x SslConfig_SslType) Enum() *SslConfig_SslType {
	p := new(SslConfig_SslType)
	*p = x
	return p
}

func (x SslConfig_SslType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SslConfig_SslType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[2].Descriptor()
}

func (SslConfig_SslType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[2]
}

func (x SslConfig_SslType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SslConfig_SslType.Descriptor instead.
func (SslConfig_SslType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{0, 0}
}

// Specifies when the instance should be activated.
type CloudSqlSettings_SqlActivationPolicy int32

const (
	// unspecified policy.
	CloudSqlSettings_SQL_ACTIVATION_POLICY_UNSPECIFIED CloudSqlSettings_SqlActivationPolicy = 0
	// The instance is always up and running.
	CloudSqlSettings_ALWAYS CloudSqlSettings_SqlActivationPolicy = 1
	// The instance should never spin up.
	CloudSqlSettings_NEVER CloudSqlSettings_SqlActivationPolicy = 2
)

// Enum value maps for CloudSqlSettings_SqlActivationPolicy.
var (
	CloudSqlSettings_SqlActivationPolicy_name = map[int32]string{
		0: "SQL_ACTIVATION_POLICY_UNSPECIFIED",
		1: "ALWAYS",
		2: "NEVER",
	}
	CloudSqlSettings_SqlActivationPolicy_value = map[string]int32{
		"SQL_ACTIVATION_POLICY_UNSPECIFIED": 0,
		"ALWAYS":                            1,
		"NEVER":                             2,
	}
)

func (x CloudSqlSettings_SqlActivationPolicy) Enum() *CloudSqlSettings_SqlActivationPolicy {
	p := new(CloudSqlSettings_SqlActivationPolicy)
	*p = x
	return p
}

func (x CloudSqlSettings_SqlActivationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudSqlSettings_SqlActivationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[3].Descriptor()
}

func (CloudSqlSettings_SqlActivationPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[3]
}

func (x CloudSqlSettings_SqlActivationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudSqlSettings_SqlActivationPolicy.Descriptor instead.
func (CloudSqlSettings_SqlActivationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{6, 0}
}

// The storage options for Cloud SQL databases.
type CloudSqlSettings_SqlDataDiskType int32

const (
	// Unspecified.
	CloudSqlSettings_SQL_DATA_DISK_TYPE_UNSPECIFIED CloudSqlSettings_SqlDataDiskType = 0
	// SSD disk.
	CloudSqlSettings_PD_SSD CloudSqlSettings_SqlDataDiskType = 1
	// HDD disk.
	CloudSqlSettings_PD_HDD CloudSqlSettings_SqlDataDiskType = 2
)

// Enum value maps for CloudSqlSettings_SqlDataDiskType.
var (
	CloudSqlSettings_SqlDataDiskType_name = map[int32]string{
		0: "SQL_DATA_DISK_TYPE_UNSPECIFIED",
		1: "PD_SSD",
		2: "PD_HDD",
	}
	CloudSqlSettings_SqlDataDiskType_value = map[string]int32{
		"SQL_DATA_DISK_TYPE_UNSPECIFIED": 0,
		"PD_SSD":                         1,
		"PD_HDD":                         2,
	}
)

func (x CloudSqlSettings_SqlDataDiskType) Enum() *CloudSqlSettings_SqlDataDiskType {
	p := new(CloudSqlSettings_SqlDataDiskType)
	*p = x
	return p
}

func (x CloudSqlSettings_SqlDataDiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudSqlSettings_SqlDataDiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[4].Descriptor()
}

func (CloudSqlSettings_SqlDataDiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[4]
}

func (x CloudSqlSettings_SqlDataDiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudSqlSettings_SqlDataDiskType.Descriptor instead.
func (CloudSqlSettings_SqlDataDiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{6, 1}
}

// The database engine type and version.
type CloudSqlSettings_SqlDatabaseVersion int32

const (
	// Unspecified version.
	CloudSqlSettings_SQL_DATABASE_VERSION_UNSPECIFIED CloudSqlSettings_SqlDatabaseVersion = 0
	// MySQL 5.6.
	CloudSqlSettings_MYSQL_5_6 CloudSqlSettings_SqlDatabaseVersion = 1
	// MySQL 5.7.
	CloudSqlSettings_MYSQL_5_7 CloudSqlSettings_SqlDatabaseVersion = 2
	// PostgreSQL 9.6.
	CloudSqlSettings_POSTGRES_9_6 CloudSqlSettings_SqlDatabaseVersion = 3
	// PostgreSQL 11.
	CloudSqlSettings_POSTGRES_11 CloudSqlSettings_SqlDatabaseVersion = 4
	// PostgreSQL 10.
	CloudSqlSettings_POSTGRES_10 CloudSqlSettings_SqlDatabaseVersion = 5
	// MySQL 8.0.
	CloudSqlSettings_MYSQL_8_0 CloudSqlSettings_SqlDatabaseVersion = 6
	// PostgreSQL 12.
	CloudSqlSettings_POSTGRES_12 CloudSqlSettings_SqlDatabaseVersion = 7
	// PostgreSQL 13.
	CloudSqlSettings_POSTGRES_13 CloudSqlSettings_SqlDatabaseVersion = 8
)

// Enum value maps for CloudSqlSettings_SqlDatabaseVersion.
var (
	CloudSqlSettings_SqlDatabaseVersion_name = map[int32]string{
		0: "SQL_DATABASE_VERSION_UNSPECIFIED",
		1: "MYSQL_5_6",
		2: "MYSQL_5_7",
		3: "POSTGRES_9_6",
		4: "POSTGRES_11",
		5: "POSTGRES_10",
		6: "MYSQL_8_0",
		7: "POSTGRES_12",
		8: "POSTGRES_13",
	}
	CloudSqlSettings_SqlDatabaseVersion_value = map[string]int32{
		"SQL_DATABASE_VERSION_UNSPECIFIED": 0,
		"MYSQL_5_6":                        1,
		"MYSQL_5_7":                        2,
		"POSTGRES_9_6":                     3,
		"POSTGRES_11":                      4,
		"POSTGRES_10":                      5,
		"MYSQL_8_0":                        6,
		"POSTGRES_12":                      7,
		"POSTGRES_13":                      8,
	}
)

func (x CloudSqlSettings_SqlDatabaseVersion) Enum() *CloudSqlSettings_SqlDatabaseVersion {
	p := new(CloudSqlSettings_SqlDatabaseVersion)
	*p = x
	return p
}

func (x CloudSqlSettings_SqlDatabaseVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloudSqlSettings_SqlDatabaseVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[5].Descriptor()
}

func (CloudSqlSettings_SqlDatabaseVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[5]
}

func (x CloudSqlSettings_SqlDatabaseVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloudSqlSettings_SqlDatabaseVersion.Descriptor instead.
func (CloudSqlSettings_SqlDatabaseVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{6, 2}
}

// The current migration job states.
type MigrationJob_State int32

const (
	// The state of the migration job is unknown.
	MigrationJob_STATE_UNSPECIFIED MigrationJob_State = 0
	// The migration job is down for maintenance.
	MigrationJob_MAINTENANCE MigrationJob_State = 1
	// The migration job is in draft mode and no resources are created.
	MigrationJob_DRAFT MigrationJob_State = 2
	// The migration job is being created.
	MigrationJob_CREATING MigrationJob_State = 3
	// The migration job is created, not started and is fully editable.
	MigrationJob_NOT_STARTED MigrationJob_State = 4
	// The migration job is running.
	MigrationJob_RUNNING MigrationJob_State = 5
	// The migration job failed.
	MigrationJob_FAILED MigrationJob_State = 6
	// The migration job has been completed.
	MigrationJob_COMPLETED MigrationJob_State = 7
	// The migration job is being deleted.
	MigrationJob_DELETING MigrationJob_State = 8
	// The migration job is being stopped.
	MigrationJob_STOPPING MigrationJob_State = 9
	// The migration job is currently stopped.
	MigrationJob_STOPPED MigrationJob_State = 10
	// The migration job has been deleted.
	MigrationJob_DELETED MigrationJob_State = 11
	// The migration job is being updated.
	MigrationJob_UPDATING MigrationJob_State = 12
	// The migration job is starting.
	MigrationJob_STARTING MigrationJob_State = 13
	// The migration job is restarting.
	MigrationJob_RESTARTING MigrationJob_State = 14
	// The migration job is resuming.
	MigrationJob_RESUMING MigrationJob_State = 15
)

// Enum value maps for MigrationJob_State.
var (
	MigrationJob_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "MAINTENANCE",
		2:  "DRAFT",
		3:  "CREATING",
		4:  "NOT_STARTED",
		5:  "RUNNING",
		6:  "FAILED",
		7:  "COMPLETED",
		8:  "DELETING",
		9:  "STOPPING",
		10: "STOPPED",
		11: "DELETED",
		12: "UPDATING",
		13: "STARTING",
		14: "RESTARTING",
		15: "RESUMING",
	}
	MigrationJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"MAINTENANCE":       1,
		"DRAFT":             2,
		"CREATING":          3,
		"NOT_STARTED":       4,
		"RUNNING":           5,
		"FAILED":            6,
		"COMPLETED":         7,
		"DELETING":          8,
		"STOPPING":          9,
		"STOPPED":           10,
		"DELETED":           11,
		"UPDATING":          12,
		"STARTING":          13,
		"RESTARTING":        14,
		"RESUMING":          15,
	}
)

func (x MigrationJob_State) Enum() *MigrationJob_State {
	p := new(MigrationJob_State)
	*p = x
	return p
}

func (x MigrationJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[6].Descriptor()
}

func (MigrationJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[6]
}

func (x MigrationJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationJob_State.Descriptor instead.
func (MigrationJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{11, 0}
}

// The current migration job phase.
type MigrationJob_Phase int32

const (
	// The phase of the migration job is unknown.
	MigrationJob_PHASE_UNSPECIFIED MigrationJob_Phase = 0
	// The migration job is in the full dump phase.
	MigrationJob_FULL_DUMP MigrationJob_Phase = 1
	// The migration job is CDC phase.
	MigrationJob_CDC MigrationJob_Phase = 2
	// The migration job is running the promote phase.
	MigrationJob_PROMOTE_IN_PROGRESS MigrationJob_Phase = 3
	// Only RDS flow - waiting for source writes to stop
	MigrationJob_WAITING_FOR_SOURCE_WRITES_TO_STOP MigrationJob_Phase = 4
	// Only RDS flow - the sources writes stopped, waiting for dump to begin
	MigrationJob_PREPARING_THE_DUMP MigrationJob_Phase = 5
)

// Enum value maps for MigrationJob_Phase.
var (
	MigrationJob_Phase_name = map[int32]string{
		0: "PHASE_UNSPECIFIED",
		1: "FULL_DUMP",
		2: "CDC",
		3: "PROMOTE_IN_PROGRESS",
		4: "WAITING_FOR_SOURCE_WRITES_TO_STOP",
		5: "PREPARING_THE_DUMP",
	}
	MigrationJob_Phase_value = map[string]int32{
		"PHASE_UNSPECIFIED":                 0,
		"FULL_DUMP":                         1,
		"CDC":                               2,
		"PROMOTE_IN_PROGRESS":               3,
		"WAITING_FOR_SOURCE_WRITES_TO_STOP": 4,
		"PREPARING_THE_DUMP":                5,
	}
)

func (x MigrationJob_Phase) Enum() *MigrationJob_Phase {
	p := new(MigrationJob_Phase)
	*p = x
	return p
}

func (x MigrationJob_Phase) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationJob_Phase) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[7].Descriptor()
}

func (MigrationJob_Phase) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[7]
}

func (x MigrationJob_Phase) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationJob_Phase.Descriptor instead.
func (MigrationJob_Phase) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{11, 1}
}

// The type of migration job (one-time or continuous).
type MigrationJob_Type int32

const (
	// The type of the migration job is unknown.
	MigrationJob_TYPE_UNSPECIFIED MigrationJob_Type = 0
	// The migration job is a one time migration.
	MigrationJob_ONE_TIME MigrationJob_Type = 1
	// The migration job is a continuous migration.
	MigrationJob_CONTINUOUS MigrationJob_Type = 2
)

// Enum value maps for MigrationJob_Type.
var (
	MigrationJob_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "ONE_TIME",
		2: "CONTINUOUS",
	}
	MigrationJob_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"ONE_TIME":         1,
		"CONTINUOUS":       2,
	}
)

func (x MigrationJob_Type) Enum() *MigrationJob_Type {
	p := new(MigrationJob_Type)
	*p = x
	return p
}

func (x MigrationJob_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationJob_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[8].Descriptor()
}

func (MigrationJob_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[8]
}

func (x MigrationJob_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationJob_Type.Descriptor instead.
func (MigrationJob_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{11, 2}
}

// The current connection profile state (e.g. DRAFT, READY, or FAILED).
type ConnectionProfile_State int32

const (
	// The state of the connection profile is unknown.
	ConnectionProfile_STATE_UNSPECIFIED ConnectionProfile_State = 0
	// The connection profile is in draft mode and fully editable.
	ConnectionProfile_DRAFT ConnectionProfile_State = 1
	// The connection profile is being created.
	ConnectionProfile_CREATING ConnectionProfile_State = 2
	// The connection profile is ready.
	ConnectionProfile_READY ConnectionProfile_State = 3
	// The connection profile is being updated.
	ConnectionProfile_UPDATING ConnectionProfile_State = 4
	// The connection profile is being deleted.
	ConnectionProfile_DELETING ConnectionProfile_State = 5
	// The connection profile has been deleted.
	ConnectionProfile_DELETED ConnectionProfile_State = 6
	// The last action on the connection profile failed.
	ConnectionProfile_FAILED ConnectionProfile_State = 7
)

// Enum value maps for ConnectionProfile_State.
var (
	ConnectionProfile_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "DRAFT",
		2: "CREATING",
		3: "READY",
		4: "UPDATING",
		5: "DELETING",
		6: "DELETED",
		7: "FAILED",
	}
	ConnectionProfile_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"DRAFT":             1,
		"CREATING":          2,
		"READY":             3,
		"UPDATING":          4,
		"DELETING":          5,
		"DELETED":           6,
		"FAILED":            7,
	}
)

func (x ConnectionProfile_State) Enum() *ConnectionProfile_State {
	p := new(ConnectionProfile_State)
	*p = x
	return p
}

func (x ConnectionProfile_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ConnectionProfile_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[9].Descriptor()
}

func (ConnectionProfile_State) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[9]
}

func (x ConnectionProfile_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ConnectionProfile_State.Descriptor instead.
func (ConnectionProfile_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{12, 0}
}

// A general error code describing the type of error that occurred.
type MigrationJobVerificationError_ErrorCode int32

const (
	// An unknown error occurred
	MigrationJobVerificationError_ERROR_CODE_UNSPECIFIED MigrationJobVerificationError_ErrorCode = 0
	// We failed to connect to one of the connection profile.
	MigrationJobVerificationError_CONNECTION_FAILURE MigrationJobVerificationError_ErrorCode = 1
	// We failed to authenticate to one of the connection profile.
	MigrationJobVerificationError_AUTHENTICATION_FAILURE MigrationJobVerificationError_ErrorCode = 2
	// One of the involved connection profiles has an invalid configuration.
	MigrationJobVerificationError_INVALID_CONNECTION_PROFILE_CONFIG MigrationJobVerificationError_ErrorCode = 3
	// The versions of the source and the destination are incompatible.
	MigrationJobVerificationError_VERSION_INCOMPATIBILITY MigrationJobVerificationError_ErrorCode = 4
	// The types of the source and the destination are incompatible.
	MigrationJobVerificationError_CONNECTION_PROFILE_TYPES_INCOMPATIBILITY MigrationJobVerificationError_ErrorCode = 5
	// No pglogical extension installed on databases, applicable for postgres.
	MigrationJobVerificationError_NO_PGLOGICAL_INSTALLED MigrationJobVerificationError_ErrorCode = 7
	// pglogical node already exists on databases, applicable for postgres.
	MigrationJobVerificationError_PGLOGICAL_NODE_ALREADY_EXISTS MigrationJobVerificationError_ErrorCode = 8
	// The value of parameter wal_level is not set to logical.
	MigrationJobVerificationError_INVALID_WAL_LEVEL MigrationJobVerificationError_ErrorCode = 9
	// The value of parameter shared_preload_libraries does not include
	// pglogical.
	MigrationJobVerificationError_INVALID_SHARED_PRELOAD_LIBRARY MigrationJobVerificationError_ErrorCode = 10
	// The value of parameter max_replication_slots is not sufficient.
	MigrationJobVerificationError_INSUFFICIENT_MAX_REPLICATION_SLOTS MigrationJobVerificationError_ErrorCode = 11
	// The value of parameter max_wal_senders is not sufficient.
	MigrationJobVerificationError_INSUFFICIENT_MAX_WAL_SENDERS MigrationJobVerificationError_ErrorCode = 12
	// The value of parameter max_worker_processes is not sufficient.
	MigrationJobVerificationError_INSUFFICIENT_MAX_WORKER_PROCESSES MigrationJobVerificationError_ErrorCode = 13
	// Extensions installed are either not supported or having unsupported
	// versions.
	MigrationJobVerificationError_UNSUPPORTED_EXTENSIONS MigrationJobVerificationError_ErrorCode = 14
	// Unsupported migration type.
	MigrationJobVerificationError_UNSUPPORTED_MIGRATION_TYPE MigrationJobVerificationError_ErrorCode = 15
	// Invalid RDS logical replication.
	MigrationJobVerificationError_INVALID_RDS_LOGICAL_REPLICATION MigrationJobVerificationError_ErrorCode = 16
	// The gtid_mode is not supported, applicable for MySQL.
	MigrationJobVerificationError_UNSUPPORTED_GTID_MODE MigrationJobVerificationError_ErrorCode = 17
	// The table definition is not support due to missing primary key or replica
	// identity.
	MigrationJobVerificationError_UNSUPPORTED_TABLE_DEFINITION MigrationJobVerificationError_ErrorCode = 18
	// The definer is not supported.
	MigrationJobVerificationError_UNSUPPORTED_DEFINER MigrationJobVerificationError_ErrorCode = 19
	// Migration is already running at the time of restart request.
	MigrationJobVerificationError_CANT_RESTART_RUNNING_MIGRATION MigrationJobVerificationError_ErrorCode = 21
)

// Enum value maps for MigrationJobVerificationError_ErrorCode.
var (
	MigrationJobVerificationError_ErrorCode_name = map[int32]string{
		0:  "ERROR_CODE_UNSPECIFIED",
		1:  "CONNECTION_FAILURE",
		2:  "AUTHENTICATION_FAILURE",
		3:  "INVALID_CONNECTION_PROFILE_CONFIG",
		4:  "VERSION_INCOMPATIBILITY",
		5:  "CONNECTION_PROFILE_TYPES_INCOMPATIBILITY",
		7:  "NO_PGLOGICAL_INSTALLED",
		8:  "PGLOGICAL_NODE_ALREADY_EXISTS",
		9:  "INVALID_WAL_LEVEL",
		10: "INVALID_SHARED_PRELOAD_LIBRARY",
		11: "INSUFFICIENT_MAX_REPLICATION_SLOTS",
		12: "INSUFFICIENT_MAX_WAL_SENDERS",
		13: "INSUFFICIENT_MAX_WORKER_PROCESSES",
		14: "UNSUPPORTED_EXTENSIONS",
		15: "UNSUPPORTED_MIGRATION_TYPE",
		16: "INVALID_RDS_LOGICAL_REPLICATION",
		17: "UNSUPPORTED_GTID_MODE",
		18: "UNSUPPORTED_TABLE_DEFINITION",
		19: "UNSUPPORTED_DEFINER",
		21: "CANT_RESTART_RUNNING_MIGRATION",
	}
	MigrationJobVerificationError_ErrorCode_value = map[string]int32{
		"ERROR_CODE_UNSPECIFIED":                   0,
		"CONNECTION_FAILURE":                       1,
		"AUTHENTICATION_FAILURE":                   2,
		"INVALID_CONNECTION_PROFILE_CONFIG":        3,
		"VERSION_INCOMPATIBILITY":                  4,
		"CONNECTION_PROFILE_TYPES_INCOMPATIBILITY": 5,
		"NO_PGLOGICAL_INSTALLED":                   7,
		"PGLOGICAL_NODE_ALREADY_EXISTS":            8,
		"INVALID_WAL_LEVEL":                        9,
		"INVALID_SHARED_PRELOAD_LIBRARY":           10,
		"INSUFFICIENT_MAX_REPLICATION_SLOTS":       11,
		"INSUFFICIENT_MAX_WAL_SENDERS":             12,
		"INSUFFICIENT_MAX_WORKER_PROCESSES":        13,
		"UNSUPPORTED_EXTENSIONS":                   14,
		"UNSUPPORTED_MIGRATION_TYPE":               15,
		"INVALID_RDS_LOGICAL_REPLICATION":          16,
		"UNSUPPORTED_GTID_MODE":                    17,
		"UNSUPPORTED_TABLE_DEFINITION":             18,
		"UNSUPPORTED_DEFINER":                      19,
		"CANT_RESTART_RUNNING_MIGRATION":           21,
	}
)

func (x MigrationJobVerificationError_ErrorCode) Enum() *MigrationJobVerificationError_ErrorCode {
	p := new(MigrationJobVerificationError_ErrorCode)
	*p = x
	return p
}

func (x MigrationJobVerificationError_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationJobVerificationError_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[10].Descriptor()
}

func (MigrationJobVerificationError_ErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes[10]
}

func (x MigrationJobVerificationError_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationJobVerificationError_ErrorCode.Descriptor instead.
func (MigrationJobVerificationError_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{13, 0}
}

// SSL configuration information.
type SslConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ssl config type according to 'client_key', 'client_certificate' and
	// 'ca_certificate'.
	Type SslConfig_SslType `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.clouddms.v1.SslConfig_SslType" json:"type,omitempty"`
	// Input only. The unencrypted PKCS#1 or PKCS#8 PEM-encoded private key associated with
	// the Client Certificate. If this field is used then the 'client_certificate'
	// field is mandatory.
	ClientKey string `protobuf:"bytes,2,opt,name=client_key,json=clientKey,proto3" json:"client_key,omitempty"`
	// Input only. The x509 PEM-encoded certificate that will be used by the replica to
	// authenticate against the source database server.If this field is used then
	// the 'client_key' field is mandatory.
	ClientCertificate string `protobuf:"bytes,3,opt,name=client_certificate,json=clientCertificate,proto3" json:"client_certificate,omitempty"`
	// Required. Input only. The x509 PEM-encoded certificate of the CA that signed the source database
	// server's certificate. The replica will use this certificate to verify
	// it's connecting to the right host.
	CaCertificate string `protobuf:"bytes,4,opt,name=ca_certificate,json=caCertificate,proto3" json:"ca_certificate,omitempty"`
}

func (x *SslConfig) Reset() {
	*x = SslConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SslConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SslConfig) ProtoMessage() {}

func (x *SslConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SslConfig.ProtoReflect.Descriptor instead.
func (*SslConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{0}
}

func (x *SslConfig) GetType() SslConfig_SslType {
	if x != nil {
		return x.Type
	}
	return SslConfig_SSL_TYPE_UNSPECIFIED
}

func (x *SslConfig) GetClientKey() string {
	if x != nil {
		return x.ClientKey
	}
	return ""
}

func (x *SslConfig) GetClientCertificate() string {
	if x != nil {
		return x.ClientCertificate
	}
	return ""
}

func (x *SslConfig) GetCaCertificate() string {
	if x != nil {
		return x.CaCertificate
	}
	return ""
}

// Specifies connection parameters required specifically for MySQL databases.
type MySqlConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The IP or hostname of the source MySQL database.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Required. The network port of the source MySQL database.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Required. The username that Database Migration Service will use to connect to the
	// database. The value is encrypted when stored in Database Migration Service.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Input only. The password for the user that Database Migration Service will be using to
	// connect to the database. This field is not returned on request, and the
	// value is encrypted when stored in Database Migration Service.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// Output only. Indicates If this connection profile password is stored.
	PasswordSet bool `protobuf:"varint,5,opt,name=password_set,json=passwordSet,proto3" json:"password_set,omitempty"`
	// SSL configuration for the destination to connect to the source database.
	Ssl *SslConfig `protobuf:"bytes,6,opt,name=ssl,proto3" json:"ssl,omitempty"`
	// If the source is a Cloud SQL database, use this field to
	// provide the Cloud SQL instance ID of the source.
	CloudSqlId string `protobuf:"bytes,7,opt,name=cloud_sql_id,json=cloudSqlId,proto3" json:"cloud_sql_id,omitempty"`
}

func (x *MySqlConnectionProfile) Reset() {
	*x = MySqlConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MySqlConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MySqlConnectionProfile) ProtoMessage() {}

func (x *MySqlConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MySqlConnectionProfile.ProtoReflect.Descriptor instead.
func (*MySqlConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{1}
}

func (x *MySqlConnectionProfile) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *MySqlConnectionProfile) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *MySqlConnectionProfile) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *MySqlConnectionProfile) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *MySqlConnectionProfile) GetPasswordSet() bool {
	if x != nil {
		return x.PasswordSet
	}
	return false
}

func (x *MySqlConnectionProfile) GetSsl() *SslConfig {
	if x != nil {
		return x.Ssl
	}
	return nil
}

func (x *MySqlConnectionProfile) GetCloudSqlId() string {
	if x != nil {
		return x.CloudSqlId
	}
	return ""
}

// Specifies connection parameters required specifically for PostgreSQL
// databases.
type PostgreSqlConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The IP or hostname of the source PostgreSQL database.
	Host string `protobuf:"bytes,1,opt,name=host,proto3" json:"host,omitempty"`
	// Required. The network port of the source PostgreSQL database.
	Port int32 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// Required. The username that Database Migration Service will use to connect to the
	// database. The value is encrypted when stored in Database Migration Service.
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Input only. The password for the user that Database Migration Service will be using to
	// connect to the database. This field is not returned on request, and the
	// value is encrypted when stored in Database Migration Service.
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
	// Output only. Indicates If this connection profile password is stored.
	PasswordSet bool `protobuf:"varint,5,opt,name=password_set,json=passwordSet,proto3" json:"password_set,omitempty"`
	// SSL configuration for the destination to connect to the source database.
	Ssl *SslConfig `protobuf:"bytes,6,opt,name=ssl,proto3" json:"ssl,omitempty"`
	// If the source is a Cloud SQL database, use this field to
	// provide the Cloud SQL instance ID of the source.
	CloudSqlId string `protobuf:"bytes,7,opt,name=cloud_sql_id,json=cloudSqlId,proto3" json:"cloud_sql_id,omitempty"`
}

func (x *PostgreSqlConnectionProfile) Reset() {
	*x = PostgreSqlConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PostgreSqlConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostgreSqlConnectionProfile) ProtoMessage() {}

func (x *PostgreSqlConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostgreSqlConnectionProfile.ProtoReflect.Descriptor instead.
func (*PostgreSqlConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{2}
}

func (x *PostgreSqlConnectionProfile) GetHost() string {
	if x != nil {
		return x.Host
	}
	return ""
}

func (x *PostgreSqlConnectionProfile) GetPort() int32 {
	if x != nil {
		return x.Port
	}
	return 0
}

func (x *PostgreSqlConnectionProfile) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *PostgreSqlConnectionProfile) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *PostgreSqlConnectionProfile) GetPasswordSet() bool {
	if x != nil {
		return x.PasswordSet
	}
	return false
}

func (x *PostgreSqlConnectionProfile) GetSsl() *SslConfig {
	if x != nil {
		return x.Ssl
	}
	return nil
}

func (x *PostgreSqlConnectionProfile) GetCloudSqlId() string {
	if x != nil {
		return x.CloudSqlId
	}
	return ""
}

// Specifies required connection parameters, and, optionally, the parameters
// required to create a Cloud SQL destination database instance.
type CloudSqlConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Cloud SQL instance ID that this connection profile is associated with.
	CloudSqlId string `protobuf:"bytes,1,opt,name=cloud_sql_id,json=cloudSqlId,proto3" json:"cloud_sql_id,omitempty"`
	// Immutable. Metadata used to create the destination Cloud SQL database.
	Settings *CloudSqlSettings `protobuf:"bytes,2,opt,name=settings,proto3" json:"settings,omitempty"`
	// Output only. The Cloud SQL database instance's private IP.
	PrivateIp string `protobuf:"bytes,3,opt,name=private_ip,json=privateIp,proto3" json:"private_ip,omitempty"`
	// Output only. The Cloud SQL database instance's public IP.
	PublicIp string `protobuf:"bytes,4,opt,name=public_ip,json=publicIp,proto3" json:"public_ip,omitempty"`
}

func (x *CloudSqlConnectionProfile) Reset() {
	*x = CloudSqlConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudSqlConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSqlConnectionProfile) ProtoMessage() {}

func (x *CloudSqlConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSqlConnectionProfile.ProtoReflect.Descriptor instead.
func (*CloudSqlConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{3}
}

func (x *CloudSqlConnectionProfile) GetCloudSqlId() string {
	if x != nil {
		return x.CloudSqlId
	}
	return ""
}

func (x *CloudSqlConnectionProfile) GetSettings() *CloudSqlSettings {
	if x != nil {
		return x.Settings
	}
	return nil
}

func (x *CloudSqlConnectionProfile) GetPrivateIp() string {
	if x != nil {
		return x.PrivateIp
	}
	return ""
}

func (x *CloudSqlConnectionProfile) GetPublicIp() string {
	if x != nil {
		return x.PublicIp
	}
	return ""
}

// An entry for an Access Control list.
type SqlAclEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The allowlisted value for the access control list.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	// The access control entry entry expiration.
	//
	// Types that are assignable to Expiration:
	//	*SqlAclEntry_ExpireTime
	//	*SqlAclEntry_Ttl
	Expiration isSqlAclEntry_Expiration `protobuf_oneof:"expiration"`
	// A label to identify this entry.
	Label string `protobuf:"bytes,3,opt,name=label,proto3" json:"label,omitempty"`
}

func (x *SqlAclEntry) Reset() {
	*x = SqlAclEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlAclEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlAclEntry) ProtoMessage() {}

func (x *SqlAclEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlAclEntry.ProtoReflect.Descriptor instead.
func (*SqlAclEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{4}
}

func (x *SqlAclEntry) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (m *SqlAclEntry) GetExpiration() isSqlAclEntry_Expiration {
	if m != nil {
		return m.Expiration
	}
	return nil
}

func (x *SqlAclEntry) GetExpireTime() *timestamppb.Timestamp {
	if x, ok := x.GetExpiration().(*SqlAclEntry_ExpireTime); ok {
		return x.ExpireTime
	}
	return nil
}

func (x *SqlAclEntry) GetTtl() *durationpb.Duration {
	if x, ok := x.GetExpiration().(*SqlAclEntry_Ttl); ok {
		return x.Ttl
	}
	return nil
}

func (x *SqlAclEntry) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

type isSqlAclEntry_Expiration interface {
	isSqlAclEntry_Expiration()
}

type SqlAclEntry_ExpireTime struct {
	// The time when this access control entry expires in
	// [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example:
	// `2012-11-15T16:19:00.094Z`.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=expire_time,json=expireTime,proto3,oneof"`
}

type SqlAclEntry_Ttl struct {
	// Input only. The time-to-leave of this access control entry.
	Ttl *durationpb.Duration `protobuf:"bytes,11,opt,name=ttl,proto3,oneof"`
}

func (*SqlAclEntry_ExpireTime) isSqlAclEntry_Expiration() {}

func (*SqlAclEntry_Ttl) isSqlAclEntry_Expiration() {}

// IP Management configuration.
type SqlIpConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether the instance should be assigned an IPv4 address or not.
	EnableIpv4 *wrapperspb.BoolValue `protobuf:"bytes,1,opt,name=enable_ipv4,json=enableIpv4,proto3" json:"enable_ipv4,omitempty"`
	// The resource link for the VPC network from which the Cloud SQL instance is
	// accessible for private IP. For example,
	// `projects/myProject/global/networks/default`. This setting can
	// be updated, but it cannot be removed after it is set.
	PrivateNetwork string `protobuf:"bytes,2,opt,name=private_network,json=privateNetwork,proto3" json:"private_network,omitempty"`
	// Whether SSL connections over IP should be enforced or not.
	RequireSsl *wrapperspb.BoolValue `protobuf:"bytes,3,opt,name=require_ssl,json=requireSsl,proto3" json:"require_ssl,omitempty"`
	// The list of external networks that are allowed to connect to the instance
	// using the IP. See
	// https://en.wikipedia.org/wiki/CIDR_notation#CIDR_notation, also known as
	// 'slash' notation (e.g. `192.168.100.0/24`).
	AuthorizedNetworks []*SqlAclEntry `protobuf:"bytes,4,rep,name=authorized_networks,json=authorizedNetworks,proto3" json:"authorized_networks,omitempty"`
}

func (x *SqlIpConfig) Reset() {
	*x = SqlIpConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SqlIpConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SqlIpConfig) ProtoMessage() {}

func (x *SqlIpConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SqlIpConfig.ProtoReflect.Descriptor instead.
func (*SqlIpConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{5}
}

func (x *SqlIpConfig) GetEnableIpv4() *wrapperspb.BoolValue {
	if x != nil {
		return x.EnableIpv4
	}
	return nil
}

func (x *SqlIpConfig) GetPrivateNetwork() string {
	if x != nil {
		return x.PrivateNetwork
	}
	return ""
}

func (x *SqlIpConfig) GetRequireSsl() *wrapperspb.BoolValue {
	if x != nil {
		return x.RequireSsl
	}
	return nil
}

func (x *SqlIpConfig) GetAuthorizedNetworks() []*SqlAclEntry {
	if x != nil {
		return x.AuthorizedNetworks
	}
	return nil
}

// Settings for creating a Cloud SQL database instance.
type CloudSqlSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The database engine type and version.
	DatabaseVersion CloudSqlSettings_SqlDatabaseVersion `protobuf:"varint,1,opt,name=database_version,json=databaseVersion,proto3,enum=google.cloud.clouddms.v1.CloudSqlSettings_SqlDatabaseVersion" json:"database_version,omitempty"`
	// The resource labels for a Cloud SQL instance to use to annotate any related
	// underlying resources such as Compute Engine VMs.
	// An object containing a list of "key": "value" pairs.
	//
	// Example: `{ "name": "wrench", "mass": "18kg", "count": "3" }`.
	UserLabels map[string]string `protobuf:"bytes,2,rep,name=user_labels,json=userLabels,proto3" json:"user_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The tier (or machine type) for this instance, for example:
	// `db-n1-standard-1` (MySQL instances) or
	// `db-custom-1-3840` (PostgreSQL instances).
	// For more information, see
	// [Cloud SQL Instance
	// Settings](https://cloud.google.com/sql/docs/mysql/instance-settings).
	Tier string `protobuf:"bytes,3,opt,name=tier,proto3" json:"tier,omitempty"`
	// The maximum size to which storage capacity can be automatically increased.
	// The default value is 0, which specifies that there is no limit.
	StorageAutoResizeLimit *wrapperspb.Int64Value `protobuf:"bytes,4,opt,name=storage_auto_resize_limit,json=storageAutoResizeLimit,proto3" json:"storage_auto_resize_limit,omitempty"`
	// The activation policy specifies when the instance is activated; it is
	// applicable only when the instance state is 'RUNNABLE'. Valid values:
	//
	// 'ALWAYS': The instance is on, and remains so even in
	// the absence of connection requests.
	//
	// `NEVER`: The instance is off; it is not activated, even if a
	// connection request arrives.
	ActivationPolicy CloudSqlSettings_SqlActivationPolicy `protobuf:"varint,5,opt,name=activation_policy,json=activationPolicy,proto3,enum=google.cloud.clouddms.v1.CloudSqlSettings_SqlActivationPolicy" json:"activation_policy,omitempty"`
	// The settings for IP Management. This allows to enable or disable the
	// instance IP and manage which external networks can connect to the instance.
	// The IPv4 address cannot be disabled.
	IpConfig *SqlIpConfig `protobuf:"bytes,6,opt,name=ip_config,json=ipConfig,proto3" json:"ip_config,omitempty"`
	// [default: ON] If you enable this setting, Cloud SQL checks your available
	// storage every 30 seconds. If the available storage falls below a threshold
	// size, Cloud SQL automatically adds additional storage capacity. If the
	// available storage repeatedly falls below the threshold size, Cloud SQL
	// continues to add storage until it reaches the maximum of 30 TB.
	AutoStorageIncrease *wrapperspb.BoolValue `protobuf:"bytes,7,opt,name=auto_storage_increase,json=autoStorageIncrease,proto3" json:"auto_storage_increase,omitempty"`
	// The database flags passed to the Cloud SQL instance at startup.
	// An object containing a list of "key": value pairs.
	// Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
	DatabaseFlags map[string]string `protobuf:"bytes,8,rep,name=database_flags,json=databaseFlags,proto3" json:"database_flags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The type of storage: `PD_SSD` (default) or `PD_HDD`.
	DataDiskType CloudSqlSettings_SqlDataDiskType `protobuf:"varint,9,opt,name=data_disk_type,json=dataDiskType,proto3,enum=google.cloud.clouddms.v1.CloudSqlSettings_SqlDataDiskType" json:"data_disk_type,omitempty"`
	// The storage capacity available to the database, in GB.
	// The minimum (and default) size is 10GB.
	DataDiskSizeGb *wrapperspb.Int64Value `protobuf:"bytes,10,opt,name=data_disk_size_gb,json=dataDiskSizeGb,proto3" json:"data_disk_size_gb,omitempty"`
	// The Google Cloud Platform zone where your Cloud SQL datdabse instance is
	// located.
	Zone string `protobuf:"bytes,11,opt,name=zone,proto3" json:"zone,omitempty"`
	// The Database Migration Service source connection profile ID,
	// in the format:
	// `projects/my_project_name/locations/us-central1/connectionProfiles/connection_profile_ID`
	SourceId string `protobuf:"bytes,12,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// Input only. Initial root password.
	RootPassword string `protobuf:"bytes,13,opt,name=root_password,json=rootPassword,proto3" json:"root_password,omitempty"`
	// Output only. Indicates If this connection profile root password is stored.
	RootPasswordSet bool `protobuf:"varint,14,opt,name=root_password_set,json=rootPasswordSet,proto3" json:"root_password_set,omitempty"`
	// The Cloud SQL default instance level collation.
	Collation string `protobuf:"bytes,15,opt,name=collation,proto3" json:"collation,omitempty"`
}

func (x *CloudSqlSettings) Reset() {
	*x = CloudSqlSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudSqlSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudSqlSettings) ProtoMessage() {}

func (x *CloudSqlSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudSqlSettings.ProtoReflect.Descriptor instead.
func (*CloudSqlSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{6}
}

func (x *CloudSqlSettings) GetDatabaseVersion() CloudSqlSettings_SqlDatabaseVersion {
	if x != nil {
		return x.DatabaseVersion
	}
	return CloudSqlSettings_SQL_DATABASE_VERSION_UNSPECIFIED
}

func (x *CloudSqlSettings) GetUserLabels() map[string]string {
	if x != nil {
		return x.UserLabels
	}
	return nil
}

func (x *CloudSqlSettings) GetTier() string {
	if x != nil {
		return x.Tier
	}
	return ""
}

func (x *CloudSqlSettings) GetStorageAutoResizeLimit() *wrapperspb.Int64Value {
	if x != nil {
		return x.StorageAutoResizeLimit
	}
	return nil
}

func (x *CloudSqlSettings) GetActivationPolicy() CloudSqlSettings_SqlActivationPolicy {
	if x != nil {
		return x.ActivationPolicy
	}
	return CloudSqlSettings_SQL_ACTIVATION_POLICY_UNSPECIFIED
}

func (x *CloudSqlSettings) GetIpConfig() *SqlIpConfig {
	if x != nil {
		return x.IpConfig
	}
	return nil
}

func (x *CloudSqlSettings) GetAutoStorageIncrease() *wrapperspb.BoolValue {
	if x != nil {
		return x.AutoStorageIncrease
	}
	return nil
}

func (x *CloudSqlSettings) GetDatabaseFlags() map[string]string {
	if x != nil {
		return x.DatabaseFlags
	}
	return nil
}

func (x *CloudSqlSettings) GetDataDiskType() CloudSqlSettings_SqlDataDiskType {
	if x != nil {
		return x.DataDiskType
	}
	return CloudSqlSettings_SQL_DATA_DISK_TYPE_UNSPECIFIED
}

func (x *CloudSqlSettings) GetDataDiskSizeGb() *wrapperspb.Int64Value {
	if x != nil {
		return x.DataDiskSizeGb
	}
	return nil
}

func (x *CloudSqlSettings) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *CloudSqlSettings) GetSourceId() string {
	if x != nil {
		return x.SourceId
	}
	return ""
}

func (x *CloudSqlSettings) GetRootPassword() string {
	if x != nil {
		return x.RootPassword
	}
	return ""
}

func (x *CloudSqlSettings) GetRootPasswordSet() bool {
	if x != nil {
		return x.RootPasswordSet
	}
	return false
}

func (x *CloudSqlSettings) GetCollation() string {
	if x != nil {
		return x.Collation
	}
	return ""
}

// The source database will allow incoming connections from the destination
// database's public IP. You can retrieve the Cloud SQL instance's public IP
// from the Cloud SQL console or using Cloud SQL APIs. No additional
// configuration is required.
type StaticIpConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StaticIpConnectivity) Reset() {
	*x = StaticIpConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StaticIpConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StaticIpConnectivity) ProtoMessage() {}

func (x *StaticIpConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StaticIpConnectivity.ProtoReflect.Descriptor instead.
func (*StaticIpConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{7}
}

// The details needed to configure a reverse SSH tunnel between the source and
// destination databases. These details will be used when calling the
// generateSshScript method (see
// https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs/generateSshScript)
// to produce the script that will help set up the reverse SSH tunnel, and to
// set up the VPC peering between the Cloud SQL private network and the VPC.
type ReverseSshConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The IP of the virtual machine (Compute Engine) used as the bastion server
	// for the SSH tunnel.
	VmIp string `protobuf:"bytes,1,opt,name=vm_ip,json=vmIp,proto3" json:"vm_ip,omitempty"`
	// Required. The forwarding port of the virtual machine (Compute Engine) used as the
	// bastion server for the SSH tunnel.
	VmPort int32 `protobuf:"varint,2,opt,name=vm_port,json=vmPort,proto3" json:"vm_port,omitempty"`
	// The name of the virtual machine (Compute Engine) used as the bastion server
	// for the SSH tunnel.
	Vm string `protobuf:"bytes,3,opt,name=vm,proto3" json:"vm,omitempty"`
	// The name of the VPC to peer with the Cloud SQL private network.
	Vpc string `protobuf:"bytes,4,opt,name=vpc,proto3" json:"vpc,omitempty"`
}

func (x *ReverseSshConnectivity) Reset() {
	*x = ReverseSshConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReverseSshConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReverseSshConnectivity) ProtoMessage() {}

func (x *ReverseSshConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReverseSshConnectivity.ProtoReflect.Descriptor instead.
func (*ReverseSshConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{8}
}

func (x *ReverseSshConnectivity) GetVmIp() string {
	if x != nil {
		return x.VmIp
	}
	return ""
}

func (x *ReverseSshConnectivity) GetVmPort() int32 {
	if x != nil {
		return x.VmPort
	}
	return 0
}

func (x *ReverseSshConnectivity) GetVm() string {
	if x != nil {
		return x.Vm
	}
	return ""
}

func (x *ReverseSshConnectivity) GetVpc() string {
	if x != nil {
		return x.Vpc
	}
	return ""
}

// The details of the VPC where the source database is located in Google Cloud.
// We will use this information to set up the VPC peering connection between
// Cloud SQL and this VPC.
type VpcPeeringConnectivity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the VPC network to peer with the Cloud SQL private network.
	Vpc string `protobuf:"bytes,1,opt,name=vpc,proto3" json:"vpc,omitempty"`
}

func (x *VpcPeeringConnectivity) Reset() {
	*x = VpcPeeringConnectivity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VpcPeeringConnectivity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VpcPeeringConnectivity) ProtoMessage() {}

func (x *VpcPeeringConnectivity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VpcPeeringConnectivity.ProtoReflect.Descriptor instead.
func (*VpcPeeringConnectivity) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{9}
}

func (x *VpcPeeringConnectivity) GetVpc() string {
	if x != nil {
		return x.Vpc
	}
	return ""
}

// A message defining the database engine and provider.
type DatabaseType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The database provider.
	Provider DatabaseProvider `protobuf:"varint,1,opt,name=provider,proto3,enum=google.cloud.clouddms.v1.DatabaseProvider" json:"provider,omitempty"`
	// The database engine.
	Engine DatabaseEngine `protobuf:"varint,2,opt,name=engine,proto3,enum=google.cloud.clouddms.v1.DatabaseEngine" json:"engine,omitempty"`
}

func (x *DatabaseType) Reset() {
	*x = DatabaseType{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatabaseType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatabaseType) ProtoMessage() {}

func (x *DatabaseType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatabaseType.ProtoReflect.Descriptor instead.
func (*DatabaseType) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{10}
}

func (x *DatabaseType) GetProvider() DatabaseProvider {
	if x != nil {
		return x.Provider
	}
	return DatabaseProvider_DATABASE_PROVIDER_UNSPECIFIED
}

func (x *DatabaseType) GetEngine() DatabaseEngine {
	if x != nil {
		return x.Engine
	}
	return DatabaseEngine_DATABASE_ENGINE_UNSPECIFIED
}

// Represents a Database Migration Service migration job object.
type MigrationJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name (URI) of this migration job resource, in the form of:
	// projects/{project}/locations/{location}/instances/{instance}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the migration job resource was created.
	// A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
	// Example: "2014-10-02T15:01:23.045123456Z".
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the migration job resource was last updated.
	// A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
	// Example: "2014-10-02T15:01:23.045123456Z".
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The resource labels for migration job to use to annotate any related
	// underlying resources such as Compute Engine VMs. An object containing a
	// list of "key": "value" pairs.
	//
	// Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The migration job display name.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The current migration job state.
	State MigrationJob_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.clouddms.v1.MigrationJob_State" json:"state,omitempty"`
	// Output only. The current migration job phase.
	Phase MigrationJob_Phase `protobuf:"varint,7,opt,name=phase,proto3,enum=google.cloud.clouddms.v1.MigrationJob_Phase" json:"phase,omitempty"`
	// Required. The migration job type.
	Type MigrationJob_Type `protobuf:"varint,8,opt,name=type,proto3,enum=google.cloud.clouddms.v1.MigrationJob_Type" json:"type,omitempty"`
	// The path to the dump file in Google Cloud Storage,
	// in the format: (gs://[BUCKET_NAME]/[OBJECT_NAME]).
	DumpPath string `protobuf:"bytes,9,opt,name=dump_path,json=dumpPath,proto3" json:"dump_path,omitempty"`
	// Required. The resource name (URI) of the source connection profile.
	Source string `protobuf:"bytes,10,opt,name=source,proto3" json:"source,omitempty"`
	// Required. The resource name (URI) of the destination connection profile.
	Destination string `protobuf:"bytes,11,opt,name=destination,proto3" json:"destination,omitempty"`
	// The connectivity method.
	//
	// Types that are assignable to Connectivity:
	//	*MigrationJob_ReverseSshConnectivity
	//	*MigrationJob_VpcPeeringConnectivity
	//	*MigrationJob_StaticIpConnectivity
	Connectivity isMigrationJob_Connectivity `protobuf_oneof:"connectivity"`
	// Output only. The duration of the migration job (in seconds). A duration in seconds
	// with up to nine fractional digits, terminated by 's'. Example: "3.5s".
	Duration *durationpb.Duration `protobuf:"bytes,12,opt,name=duration,proto3" json:"duration,omitempty"`
	// Output only. The error details in case of state FAILED.
	Error *status.Status `protobuf:"bytes,13,opt,name=error,proto3" json:"error,omitempty"`
	// The database engine type and provider of the source.
	SourceDatabase *DatabaseType `protobuf:"bytes,14,opt,name=source_database,json=sourceDatabase,proto3" json:"source_database,omitempty"`
	// The database engine type and provider of the destination.
	DestinationDatabase *DatabaseType `protobuf:"bytes,15,opt,name=destination_database,json=destinationDatabase,proto3" json:"destination_database,omitempty"`
	// Output only. If the migration job is completed, the time when it was completed.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *MigrationJob) Reset() {
	*x = MigrationJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationJob) ProtoMessage() {}

func (x *MigrationJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationJob.ProtoReflect.Descriptor instead.
func (*MigrationJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{11}
}

func (x *MigrationJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MigrationJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MigrationJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *MigrationJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *MigrationJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MigrationJob) GetState() MigrationJob_State {
	if x != nil {
		return x.State
	}
	return MigrationJob_STATE_UNSPECIFIED
}

func (x *MigrationJob) GetPhase() MigrationJob_Phase {
	if x != nil {
		return x.Phase
	}
	return MigrationJob_PHASE_UNSPECIFIED
}

func (x *MigrationJob) GetType() MigrationJob_Type {
	if x != nil {
		return x.Type
	}
	return MigrationJob_TYPE_UNSPECIFIED
}

func (x *MigrationJob) GetDumpPath() string {
	if x != nil {
		return x.DumpPath
	}
	return ""
}

func (x *MigrationJob) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *MigrationJob) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (m *MigrationJob) GetConnectivity() isMigrationJob_Connectivity {
	if m != nil {
		return m.Connectivity
	}
	return nil
}

func (x *MigrationJob) GetReverseSshConnectivity() *ReverseSshConnectivity {
	if x, ok := x.GetConnectivity().(*MigrationJob_ReverseSshConnectivity); ok {
		return x.ReverseSshConnectivity
	}
	return nil
}

func (x *MigrationJob) GetVpcPeeringConnectivity() *VpcPeeringConnectivity {
	if x, ok := x.GetConnectivity().(*MigrationJob_VpcPeeringConnectivity); ok {
		return x.VpcPeeringConnectivity
	}
	return nil
}

func (x *MigrationJob) GetStaticIpConnectivity() *StaticIpConnectivity {
	if x, ok := x.GetConnectivity().(*MigrationJob_StaticIpConnectivity); ok {
		return x.StaticIpConnectivity
	}
	return nil
}

func (x *MigrationJob) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *MigrationJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *MigrationJob) GetSourceDatabase() *DatabaseType {
	if x != nil {
		return x.SourceDatabase
	}
	return nil
}

func (x *MigrationJob) GetDestinationDatabase() *DatabaseType {
	if x != nil {
		return x.DestinationDatabase
	}
	return nil
}

func (x *MigrationJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isMigrationJob_Connectivity interface {
	isMigrationJob_Connectivity()
}

type MigrationJob_ReverseSshConnectivity struct {
	// The details needed to communicate to the source over Reverse SSH
	// tunnel connectivity.
	ReverseSshConnectivity *ReverseSshConnectivity `protobuf:"bytes,101,opt,name=reverse_ssh_connectivity,json=reverseSshConnectivity,proto3,oneof"`
}

type MigrationJob_VpcPeeringConnectivity struct {
	// The details of the VPC network that the source database is located in.
	VpcPeeringConnectivity *VpcPeeringConnectivity `protobuf:"bytes,102,opt,name=vpc_peering_connectivity,json=vpcPeeringConnectivity,proto3,oneof"`
}

type MigrationJob_StaticIpConnectivity struct {
	// static ip connectivity data (default, no additional details needed).
	StaticIpConnectivity *StaticIpConnectivity `protobuf:"bytes,103,opt,name=static_ip_connectivity,json=staticIpConnectivity,proto3,oneof"`
}

func (*MigrationJob_ReverseSshConnectivity) isMigrationJob_Connectivity() {}

func (*MigrationJob_VpcPeeringConnectivity) isMigrationJob_Connectivity() {}

func (*MigrationJob_StaticIpConnectivity) isMigrationJob_Connectivity() {}

// A connection profile definition.
type ConnectionProfile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of this connection profile resource in the form of
	// projects/{project}/locations/{location}/instances/{instance}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The timestamp when the resource was created.
	// A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
	// Example: "2014-10-02T15:01:23.045123456Z".
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was last updated.
	// A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds.
	// Example: "2014-10-02T15:01:23.045123456Z".
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The resource labels for connection profile to use to annotate any related
	// underlying resources such as Compute Engine VMs. An object containing a
	// list of "key": "value" pairs.
	//
	// Example: `{ "name": "wrench", "mass": "1.3kg", "count": "3" }`.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The current connection profile state (e.g. DRAFT, READY, or FAILED).
	State ConnectionProfile_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.clouddms.v1.ConnectionProfile_State" json:"state,omitempty"`
	// The connection profile display name.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The connection profile definition.
	//
	// Types that are assignable to ConnectionProfile:
	//	*ConnectionProfile_Mysql
	//	*ConnectionProfile_Postgresql
	//	*ConnectionProfile_Cloudsql
	ConnectionProfile isConnectionProfile_ConnectionProfile `protobuf_oneof:"connection_profile"`
	// Output only. The error details in case of state FAILED.
	Error *status.Status `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
	// The database provider.
	Provider DatabaseProvider `protobuf:"varint,8,opt,name=provider,proto3,enum=google.cloud.clouddms.v1.DatabaseProvider" json:"provider,omitempty"`
}

func (x *ConnectionProfile) Reset() {
	*x = ConnectionProfile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConnectionProfile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConnectionProfile) ProtoMessage() {}

func (x *ConnectionProfile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConnectionProfile.ProtoReflect.Descriptor instead.
func (*ConnectionProfile) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{12}
}

func (x *ConnectionProfile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ConnectionProfile) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ConnectionProfile) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ConnectionProfile) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ConnectionProfile) GetState() ConnectionProfile_State {
	if x != nil {
		return x.State
	}
	return ConnectionProfile_STATE_UNSPECIFIED
}

func (x *ConnectionProfile) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *ConnectionProfile) GetConnectionProfile() isConnectionProfile_ConnectionProfile {
	if m != nil {
		return m.ConnectionProfile
	}
	return nil
}

func (x *ConnectionProfile) GetMysql() *MySqlConnectionProfile {
	if x, ok := x.GetConnectionProfile().(*ConnectionProfile_Mysql); ok {
		return x.Mysql
	}
	return nil
}

func (x *ConnectionProfile) GetPostgresql() *PostgreSqlConnectionProfile {
	if x, ok := x.GetConnectionProfile().(*ConnectionProfile_Postgresql); ok {
		return x.Postgresql
	}
	return nil
}

func (x *ConnectionProfile) GetCloudsql() *CloudSqlConnectionProfile {
	if x, ok := x.GetConnectionProfile().(*ConnectionProfile_Cloudsql); ok {
		return x.Cloudsql
	}
	return nil
}

func (x *ConnectionProfile) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ConnectionProfile) GetProvider() DatabaseProvider {
	if x != nil {
		return x.Provider
	}
	return DatabaseProvider_DATABASE_PROVIDER_UNSPECIFIED
}

type isConnectionProfile_ConnectionProfile interface {
	isConnectionProfile_ConnectionProfile()
}

type ConnectionProfile_Mysql struct {
	// A MySQL database connection profile.
	Mysql *MySqlConnectionProfile `protobuf:"bytes,100,opt,name=mysql,proto3,oneof"`
}

type ConnectionProfile_Postgresql struct {
	// A PostgreSQL database connection profile.
	Postgresql *PostgreSqlConnectionProfile `protobuf:"bytes,101,opt,name=postgresql,proto3,oneof"`
}

type ConnectionProfile_Cloudsql struct {
	// A CloudSQL database connection profile.
	Cloudsql *CloudSqlConnectionProfile `protobuf:"bytes,102,opt,name=cloudsql,proto3,oneof"`
}

func (*ConnectionProfile_Mysql) isConnectionProfile_ConnectionProfile() {}

func (*ConnectionProfile_Postgresql) isConnectionProfile_ConnectionProfile() {}

func (*ConnectionProfile_Cloudsql) isConnectionProfile_ConnectionProfile() {}

// Error message of a verification Migration job.
type MigrationJobVerificationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. An instance of ErrorCode specifying the error that occurred.
	ErrorCode MigrationJobVerificationError_ErrorCode `protobuf:"varint,1,opt,name=error_code,json=errorCode,proto3,enum=google.cloud.clouddms.v1.MigrationJobVerificationError_ErrorCode" json:"error_code,omitempty"`
	// Output only. A formatted message with further details about the error and a CTA.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Output only. A specific detailed error message, if supplied by the engine.
	ErrorDetailMessage string `protobuf:"bytes,3,opt,name=error_detail_message,json=errorDetailMessage,proto3" json:"error_detail_message,omitempty"`
}

func (x *MigrationJobVerificationError) Reset() {
	*x = MigrationJobVerificationError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MigrationJobVerificationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationJobVerificationError) ProtoMessage() {}

func (x *MigrationJobVerificationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationJobVerificationError.ProtoReflect.Descriptor instead.
func (*MigrationJobVerificationError) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP(), []int{13}
}

func (x *MigrationJobVerificationError) GetErrorCode() MigrationJobVerificationError_ErrorCode {
	if x != nil {
		return x.ErrorCode
	}
	return MigrationJobVerificationError_ERROR_CODE_UNSPECIFIED
}

func (x *MigrationJobVerificationError) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *MigrationJobVerificationError) GetErrorDetailMessage() string {
	if x != nil {
		return x.ErrorDetailMessage
	}
	return ""
}

var File_google_cloud_clouddms_v1_clouddms_resources_proto protoreflect.FileDescriptor

var file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70,
	0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xa1, 0x02, 0x0a, 0x09, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x53, 0x73, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x09,
	0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x4b, 0x65, 0x79, 0x12, 0x32, 0x0a, 0x12, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x11, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a,
	0x0e, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x63,
	0x61, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0x47, 0x0a, 0x07,
	0x53, 0x73, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x53, 0x53, 0x4c, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x43, 0x4c, 0x49,
	0x45, 0x4e, 0x54, 0x10, 0x02, 0x22, 0x90, 0x02, 0x0a, 0x16, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x68, 0x6f, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x04, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x61, 0x73, 0x73, 0x77,
	0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x74, 0x12,
	0x35, 0x0a, 0x03, 0x73, 0x73, 0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x52, 0x03, 0x73, 0x73, 0x6c, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x73, 0x71, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x64, 0x22, 0x95, 0x02, 0x0a, 0x1b, 0x50, 0x6f, 0x73,
	0x74, 0x67, 0x72, 0x65, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x68, 0x6f, 0x73, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x68, 0x6f, 0x73,
	0x74, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x1f, 0x0a, 0x08, 0x75, 0x73,
	0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x08, 0x70,
	0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0,
	0x41, 0x04, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12,
	0x26, 0x0a, 0x0c, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x53, 0x65, 0x74, 0x12, 0x35, 0x0a, 0x03, 0x73, 0x73, 0x6c, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x73, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x03, 0x73, 0x73, 0x6c, 0x12, 0x20,
	0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x49, 0x64,
	0x22, 0xd5, 0x01, 0x0a, 0x19, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x25,
	0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x71, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x53, 0x71, 0x6c, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x08, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x70,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x49, 0x70, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
	0x5f, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x22, 0xba, 0x01, 0x0a, 0x0b, 0x53, 0x71, 0x6c,
	0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3d,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48,
	0x00, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x32, 0x0a,
	0x03, 0x74, 0x74, 0x6c, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x48, 0x00, 0x52, 0x03, 0x74, 0x74,
	0x6c, 0x12, 0x14, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x0c, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x02, 0x0a, 0x0b, 0x53, 0x71, 0x6c, 0x49, 0x70, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x69, 0x70, 0x76, 0x34, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f,
	0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x70,
	0x76, 0x34, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x69,
	0x76, 0x61, 0x74, 0x65, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x72,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x73, 0x73, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x69, 0x72, 0x65, 0x53, 0x73, 0x6c, 0x12, 0x56, 0x0a, 0x13, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x71, 0x6c, 0x41, 0x63, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x12, 0x61, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x22, 0xe5, 0x0b, 0x0a, 0x10, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x68, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x53, 0x71, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x53, 0x71, 0x6c, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x5b, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x2e, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72,
	0x12, 0x56, 0x0a, 0x19, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x6f,
	0x5f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x16, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x65, 0x73,
	0x69, 0x7a, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x6b, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e,
	0x53, 0x71, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x42, 0x0a, 0x09, 0x69, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x71, 0x6c, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x08, 0x69, 0x70, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x15, 0x61, 0x75, 0x74,
	0x6f, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61,
	0x73, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x49, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x0e, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12,
	0x60, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x71, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x2e, 0x53, 0x71, 0x6c, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x46, 0x0a, 0x11, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49,
	0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x44,
	0x69, 0x73, 0x6b, 0x53, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x1b, 0x0a,
	0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x6f,
	0x6f, 0x74, 0x5f, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x72, 0x6f, 0x6f, 0x74, 0x50, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x12, 0x2f, 0x0a, 0x11, 0x72, 0x6f, 0x6f, 0x74, 0x5f, 0x70, 0x61, 0x73,
	0x73, 0x77, 0x6f, 0x72, 0x64, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x6f, 0x6f, 0x74, 0x50, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x53, 0x65, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x3d, 0x0a, 0x0f, 0x55, 0x73, 0x65, 0x72, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x1a, 0x40, 0x0a, 0x12, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x46, 0x6c,
	0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x53, 0x0a, 0x13, 0x53, 0x71, 0x6c, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x25, 0x0a, 0x21, 0x53,
	0x51, 0x4c, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x4f,
	0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x4c, 0x57, 0x41, 0x59, 0x53, 0x10, 0x01, 0x12, 0x09,
	0x0a, 0x05, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10, 0x02, 0x22, 0x4d, 0x0a, 0x0f, 0x53, 0x71, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e,
	0x53, 0x51, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x50, 0x44, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x44, 0x5f, 0x48, 0x44, 0x44, 0x10, 0x02, 0x22, 0xbd, 0x01, 0x0a, 0x12, 0x53, 0x71, 0x6c,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x24, 0x0a, 0x20, 0x53, 0x51, 0x4c, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f,
	0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35,
	0x5f, 0x36, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x5f, 0x35, 0x5f,
	0x37, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45, 0x53, 0x5f,
	0x39, 0x5f, 0x36, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52, 0x45,
	0x53, 0x5f, 0x31, 0x31, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52,
	0x45, 0x53, 0x5f, 0x31, 0x30, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x4d, 0x59, 0x53, 0x51, 0x4c,
	0x5f, 0x38, 0x5f, 0x30, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47, 0x52,
	0x45, 0x53, 0x5f, 0x31, 0x32, 0x10, 0x07, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x4f, 0x53, 0x54, 0x47,
	0x52, 0x45, 0x53, 0x5f, 0x31, 0x33, 0x10, 0x08, 0x22, 0x16, 0x0a, 0x14, 0x53, 0x74, 0x61, 0x74,
	0x69, 0x63, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x22, 0x72, 0x0a, 0x16, 0x52, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x53, 0x73, 0x68, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a, 0x05, 0x76, 0x6d,
	0x5f, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x76, 0x6d, 0x49, 0x70, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x76, 0x6d, 0x50, 0x6f,
	0x72, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x76, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02,
	0x76, 0x6d, 0x12, 0x10, 0x0a, 0x03, 0x76, 0x70, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x76, 0x70, 0x63, 0x22, 0x2a, 0x0a, 0x16, 0x56, 0x70, 0x63, 0x50, 0x65, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x76, 0x70, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x76, 0x70, 0x63,
	0x22, 0x98, 0x01, 0x0a, 0x0c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x40, 0x0a, 0x06, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x52, 0x06, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x22, 0xe3, 0x0e, 0x0a, 0x0c,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x47, 0x0a, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x50,
	0x68, 0x61, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x70, 0x68, 0x61, 0x73, 0x65,
	0x12, 0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x64, 0x75, 0x6d, 0x70, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x64, 0x75, 0x6d, 0x70, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x18, 0x72, 0x65, 0x76, 0x65, 0x72,
	0x73, 0x65, 0x5f, 0x73, 0x73, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x53, 0x73, 0x68, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x16, 0x72,
	0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x53, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x6c, 0x0a, 0x18, 0x76, 0x70, 0x63, 0x5f, 0x70, 0x65, 0x65,
	0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x18, 0x66, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x70, 0x63, 0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x16, 0x76, 0x70, 0x63,
	0x50, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x12, 0x66, 0x0a, 0x16, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x5f, 0x69, 0x70,
	0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x67, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x69, 0x63, 0x49, 0x70, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x69, 0x74, 0x79, 0x48, 0x00, 0x52, 0x14, 0x73, 0x74, 0x61, 0x74, 0x69, 0x63, 0x49, 0x70, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x12, 0x3a, 0x0a, 0x08, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4f, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x12, 0x59, 0x0a, 0x14, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x13, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xf1, 0x01, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x41,
	0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x44,
	0x52, 0x41, 0x46, 0x54, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x4e, 0x4f, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x52,
	0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47,
	0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0d,
	0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0c, 0x0a,
	0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x53,
	0x54, 0x4f, 0x50, 0x50, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f,
	0x50, 0x50, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x44, 0x10, 0x0b, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10,
	0x0c, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0d, 0x12,
	0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0e, 0x12,
	0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x0f, 0x22, 0x8e, 0x01,
	0x0a, 0x05, 0x50, 0x68, 0x61, 0x73, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x48, 0x41, 0x53, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x44, 0x55, 0x4d, 0x50, 0x10, 0x01, 0x12, 0x07, 0x0a,
	0x03, 0x43, 0x44, 0x43, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x50, 0x52, 0x4f, 0x4d, 0x4f, 0x54,
	0x45, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12,
	0x25, 0x0a, 0x21, 0x57, 0x41, 0x49, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x53, 0x5f, 0x54, 0x4f, 0x5f,
	0x53, 0x54, 0x4f, 0x50, 0x10, 0x04, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x45, 0x50, 0x41, 0x52,
	0x49, 0x4e, 0x47, 0x5f, 0x54, 0x48, 0x45, 0x5f, 0x44, 0x55, 0x4d, 0x50, 0x10, 0x05, 0x22, 0x3a,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08,
	0x4f, 0x4e, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x4f,
	0x4e, 0x54, 0x49, 0x4e, 0x55, 0x4f, 0x55, 0x53, 0x10, 0x02, 0x3a, 0x75, 0xea, 0x41, 0x72, 0x0a,
	0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x45, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x73, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62,
	0x7d, 0x42, 0x0e, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x22, 0xa7, 0x08, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x4f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05,
	0x6d, 0x79, 0x73, 0x71, 0x6c, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x79, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52,
	0x05, 0x6d, 0x79, 0x73, 0x71, 0x6c, 0x12, 0x57, 0x0a, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72,
	0x65, 0x73, 0x71, 0x6c, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x53, 0x71, 0x6c,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x6f, 0x73, 0x74, 0x67, 0x72, 0x65, 0x73, 0x71, 0x6c, 0x12,
	0x51, 0x0a, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73, 0x71, 0x6c, 0x18, 0x66, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x53, 0x71, 0x6c, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x48, 0x00, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x73,
	0x71, 0x6c, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x52,
	0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x77, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x52, 0x41, 0x46, 0x54, 0x10, 0x01, 0x12,
	0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a,
	0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10,
	0x06, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x3a, 0x85, 0x01,
	0xea, 0x41, 0x81, 0x01, 0x0a, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x4f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x7d, 0x42, 0x14, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0xfd, 0x06, 0x0a, 0x1d,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x56, 0x65, 0x72, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x65, 0x0a,
	0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x35,
	0x0a, 0x14, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x12, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x93, 0x05, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x16, 0x0a, 0x12, 0x43, 0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41,
	0x49, 0x4c, 0x55, 0x52, 0x45, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x55, 0x54, 0x48, 0x45,
	0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x55, 0x52,
	0x45, 0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x43,
	0x4f, 0x4e, 0x4e, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c,
	0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x56, 0x45,
	0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x04, 0x12, 0x2c, 0x0a, 0x28, 0x43, 0x4f, 0x4e, 0x4e, 0x45,
	0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x53, 0x5f, 0x49, 0x4e, 0x43, 0x4f, 0x4d, 0x50, 0x41, 0x54, 0x49, 0x42, 0x49, 0x4c,
	0x49, 0x54, 0x59, 0x10, 0x05, 0x12, 0x1a, 0x0a, 0x16, 0x4e, 0x4f, 0x5f, 0x50, 0x47, 0x4c, 0x4f,
	0x47, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4c, 0x4c, 0x45, 0x44, 0x10,
	0x07, 0x12, 0x21, 0x0a, 0x1d, 0x50, 0x47, 0x4c, 0x4f, 0x47, 0x49, 0x43, 0x41, 0x4c, 0x5f, 0x4e,
	0x4f, 0x44, 0x45, 0x5f, 0x41, 0x4c, 0x52, 0x45, 0x41, 0x44, 0x59, 0x5f, 0x45, 0x58, 0x49, 0x53,
	0x54, 0x53, 0x10, 0x08, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f,
	0x57, 0x41, 0x4c, 0x5f, 0x4c, 0x45, 0x56, 0x45, 0x4c, 0x10, 0x09, 0x12, 0x22, 0x0a, 0x1e, 0x49,
	0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x50, 0x52,
	0x45, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x4c, 0x49, 0x42, 0x52, 0x41, 0x52, 0x59, 0x10, 0x0a, 0x12,
	0x26, 0x0a, 0x22, 0x49, 0x4e, 0x53, 0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f,
	0x4d, 0x41, 0x58, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x53, 0x4c, 0x4f, 0x54, 0x53, 0x10, 0x0b, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x53, 0x55, 0x46,
	0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x57, 0x41, 0x4c, 0x5f,
	0x53, 0x45, 0x4e, 0x44, 0x45, 0x52, 0x53, 0x10, 0x0c, 0x12, 0x25, 0x0a, 0x21, 0x49, 0x4e, 0x53,
	0x55, 0x46, 0x46, 0x49, 0x43, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x4d, 0x41, 0x58, 0x5f, 0x57, 0x4f,
	0x52, 0x4b, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x45, 0x53, 0x10, 0x0d,
	0x12, 0x1a, 0x0a, 0x16, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f,
	0x45, 0x58, 0x54, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x0e, 0x12, 0x1e, 0x0a, 0x1a,
	0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x4d, 0x49, 0x47, 0x52,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x10, 0x0f, 0x12, 0x23, 0x0a, 0x1f,
	0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x52, 0x44, 0x53, 0x5f, 0x4c, 0x4f, 0x47, 0x49,
	0x43, 0x41, 0x4c, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x10, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44,
	0x5f, 0x47, 0x54, 0x49, 0x44, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x10, 0x11, 0x12, 0x20, 0x0a, 0x1c,
	0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x54, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x44, 0x45, 0x46, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x12, 0x12, 0x17,
	0x0a, 0x13, 0x55, 0x4e, 0x53, 0x55, 0x50, 0x50, 0x4f, 0x52, 0x54, 0x45, 0x44, 0x5f, 0x44, 0x45,
	0x46, 0x49, 0x4e, 0x45, 0x52, 0x10, 0x13, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x41, 0x4e, 0x54, 0x5f,
	0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x5f,
	0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x15, 0x2a, 0x4c, 0x0a, 0x0e, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x12, 0x1f, 0x0a,
	0x1b, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09,
	0x0a, 0x05, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x4f, 0x53,
	0x54, 0x47, 0x52, 0x45, 0x53, 0x51, 0x4c, 0x10, 0x02, 0x2a, 0x4c, 0x0a, 0x10, 0x44, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x12, 0x21, 0x0a,
	0x1d, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x44,
	0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x07,
	0x0a, 0x03, 0x52, 0x44, 0x53, 0x10, 0x02, 0x42, 0xce, 0x01, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x6d, 0x73, 0x2e, 0x56, 0x31, 0xca,
	0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x44, 0x6d, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x44, 0x4d, 0x53, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescOnce sync.Once
	file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescData = file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDesc
)

func file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescGZIP() []byte {
	file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescOnce.Do(func() {
		file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescData)
	})
	return file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDescData
}

var file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes = make([]protoimpl.EnumInfo, 11)
var file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_google_cloud_clouddms_v1_clouddms_resources_proto_goTypes = []interface{}{
	(DatabaseEngine)(0),                          // 0: google.cloud.clouddms.v1.DatabaseEngine
	(DatabaseProvider)(0),                        // 1: google.cloud.clouddms.v1.DatabaseProvider
	(SslConfig_SslType)(0),                       // 2: google.cloud.clouddms.v1.SslConfig.SslType
	(CloudSqlSettings_SqlActivationPolicy)(0),    // 3: google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy
	(CloudSqlSettings_SqlDataDiskType)(0),        // 4: google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType
	(CloudSqlSettings_SqlDatabaseVersion)(0),     // 5: google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion
	(MigrationJob_State)(0),                      // 6: google.cloud.clouddms.v1.MigrationJob.State
	(MigrationJob_Phase)(0),                      // 7: google.cloud.clouddms.v1.MigrationJob.Phase
	(MigrationJob_Type)(0),                       // 8: google.cloud.clouddms.v1.MigrationJob.Type
	(ConnectionProfile_State)(0),                 // 9: google.cloud.clouddms.v1.ConnectionProfile.State
	(MigrationJobVerificationError_ErrorCode)(0), // 10: google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode
	(*SslConfig)(nil),                            // 11: google.cloud.clouddms.v1.SslConfig
	(*MySqlConnectionProfile)(nil),               // 12: google.cloud.clouddms.v1.MySqlConnectionProfile
	(*PostgreSqlConnectionProfile)(nil),          // 13: google.cloud.clouddms.v1.PostgreSqlConnectionProfile
	(*CloudSqlConnectionProfile)(nil),            // 14: google.cloud.clouddms.v1.CloudSqlConnectionProfile
	(*SqlAclEntry)(nil),                          // 15: google.cloud.clouddms.v1.SqlAclEntry
	(*SqlIpConfig)(nil),                          // 16: google.cloud.clouddms.v1.SqlIpConfig
	(*CloudSqlSettings)(nil),                     // 17: google.cloud.clouddms.v1.CloudSqlSettings
	(*StaticIpConnectivity)(nil),                 // 18: google.cloud.clouddms.v1.StaticIpConnectivity
	(*ReverseSshConnectivity)(nil),               // 19: google.cloud.clouddms.v1.ReverseSshConnectivity
	(*VpcPeeringConnectivity)(nil),               // 20: google.cloud.clouddms.v1.VpcPeeringConnectivity
	(*DatabaseType)(nil),                         // 21: google.cloud.clouddms.v1.DatabaseType
	(*MigrationJob)(nil),                         // 22: google.cloud.clouddms.v1.MigrationJob
	(*ConnectionProfile)(nil),                    // 23: google.cloud.clouddms.v1.ConnectionProfile
	(*MigrationJobVerificationError)(nil),        // 24: google.cloud.clouddms.v1.MigrationJobVerificationError
	nil,                                          // 25: google.cloud.clouddms.v1.CloudSqlSettings.UserLabelsEntry
	nil,                                          // 26: google.cloud.clouddms.v1.CloudSqlSettings.DatabaseFlagsEntry
	nil,                                          // 27: google.cloud.clouddms.v1.MigrationJob.LabelsEntry
	nil,                                          // 28: google.cloud.clouddms.v1.ConnectionProfile.LabelsEntry
	(*timestamppb.Timestamp)(nil),                // 29: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                  // 30: google.protobuf.Duration
	(*wrapperspb.BoolValue)(nil),                 // 31: google.protobuf.BoolValue
	(*wrapperspb.Int64Value)(nil),                // 32: google.protobuf.Int64Value
	(*status.Status)(nil),                        // 33: google.rpc.Status
}
var file_google_cloud_clouddms_v1_clouddms_resources_proto_depIdxs = []int32{
	2,  // 0: google.cloud.clouddms.v1.SslConfig.type:type_name -> google.cloud.clouddms.v1.SslConfig.SslType
	11, // 1: google.cloud.clouddms.v1.MySqlConnectionProfile.ssl:type_name -> google.cloud.clouddms.v1.SslConfig
	11, // 2: google.cloud.clouddms.v1.PostgreSqlConnectionProfile.ssl:type_name -> google.cloud.clouddms.v1.SslConfig
	17, // 3: google.cloud.clouddms.v1.CloudSqlConnectionProfile.settings:type_name -> google.cloud.clouddms.v1.CloudSqlSettings
	29, // 4: google.cloud.clouddms.v1.SqlAclEntry.expire_time:type_name -> google.protobuf.Timestamp
	30, // 5: google.cloud.clouddms.v1.SqlAclEntry.ttl:type_name -> google.protobuf.Duration
	31, // 6: google.cloud.clouddms.v1.SqlIpConfig.enable_ipv4:type_name -> google.protobuf.BoolValue
	31, // 7: google.cloud.clouddms.v1.SqlIpConfig.require_ssl:type_name -> google.protobuf.BoolValue
	15, // 8: google.cloud.clouddms.v1.SqlIpConfig.authorized_networks:type_name -> google.cloud.clouddms.v1.SqlAclEntry
	5,  // 9: google.cloud.clouddms.v1.CloudSqlSettings.database_version:type_name -> google.cloud.clouddms.v1.CloudSqlSettings.SqlDatabaseVersion
	25, // 10: google.cloud.clouddms.v1.CloudSqlSettings.user_labels:type_name -> google.cloud.clouddms.v1.CloudSqlSettings.UserLabelsEntry
	32, // 11: google.cloud.clouddms.v1.CloudSqlSettings.storage_auto_resize_limit:type_name -> google.protobuf.Int64Value
	3,  // 12: google.cloud.clouddms.v1.CloudSqlSettings.activation_policy:type_name -> google.cloud.clouddms.v1.CloudSqlSettings.SqlActivationPolicy
	16, // 13: google.cloud.clouddms.v1.CloudSqlSettings.ip_config:type_name -> google.cloud.clouddms.v1.SqlIpConfig
	31, // 14: google.cloud.clouddms.v1.CloudSqlSettings.auto_storage_increase:type_name -> google.protobuf.BoolValue
	26, // 15: google.cloud.clouddms.v1.CloudSqlSettings.database_flags:type_name -> google.cloud.clouddms.v1.CloudSqlSettings.DatabaseFlagsEntry
	4,  // 16: google.cloud.clouddms.v1.CloudSqlSettings.data_disk_type:type_name -> google.cloud.clouddms.v1.CloudSqlSettings.SqlDataDiskType
	32, // 17: google.cloud.clouddms.v1.CloudSqlSettings.data_disk_size_gb:type_name -> google.protobuf.Int64Value
	1,  // 18: google.cloud.clouddms.v1.DatabaseType.provider:type_name -> google.cloud.clouddms.v1.DatabaseProvider
	0,  // 19: google.cloud.clouddms.v1.DatabaseType.engine:type_name -> google.cloud.clouddms.v1.DatabaseEngine
	29, // 20: google.cloud.clouddms.v1.MigrationJob.create_time:type_name -> google.protobuf.Timestamp
	29, // 21: google.cloud.clouddms.v1.MigrationJob.update_time:type_name -> google.protobuf.Timestamp
	27, // 22: google.cloud.clouddms.v1.MigrationJob.labels:type_name -> google.cloud.clouddms.v1.MigrationJob.LabelsEntry
	6,  // 23: google.cloud.clouddms.v1.MigrationJob.state:type_name -> google.cloud.clouddms.v1.MigrationJob.State
	7,  // 24: google.cloud.clouddms.v1.MigrationJob.phase:type_name -> google.cloud.clouddms.v1.MigrationJob.Phase
	8,  // 25: google.cloud.clouddms.v1.MigrationJob.type:type_name -> google.cloud.clouddms.v1.MigrationJob.Type
	19, // 26: google.cloud.clouddms.v1.MigrationJob.reverse_ssh_connectivity:type_name -> google.cloud.clouddms.v1.ReverseSshConnectivity
	20, // 27: google.cloud.clouddms.v1.MigrationJob.vpc_peering_connectivity:type_name -> google.cloud.clouddms.v1.VpcPeeringConnectivity
	18, // 28: google.cloud.clouddms.v1.MigrationJob.static_ip_connectivity:type_name -> google.cloud.clouddms.v1.StaticIpConnectivity
	30, // 29: google.cloud.clouddms.v1.MigrationJob.duration:type_name -> google.protobuf.Duration
	33, // 30: google.cloud.clouddms.v1.MigrationJob.error:type_name -> google.rpc.Status
	21, // 31: google.cloud.clouddms.v1.MigrationJob.source_database:type_name -> google.cloud.clouddms.v1.DatabaseType
	21, // 32: google.cloud.clouddms.v1.MigrationJob.destination_database:type_name -> google.cloud.clouddms.v1.DatabaseType
	29, // 33: google.cloud.clouddms.v1.MigrationJob.end_time:type_name -> google.protobuf.Timestamp
	29, // 34: google.cloud.clouddms.v1.ConnectionProfile.create_time:type_name -> google.protobuf.Timestamp
	29, // 35: google.cloud.clouddms.v1.ConnectionProfile.update_time:type_name -> google.protobuf.Timestamp
	28, // 36: google.cloud.clouddms.v1.ConnectionProfile.labels:type_name -> google.cloud.clouddms.v1.ConnectionProfile.LabelsEntry
	9,  // 37: google.cloud.clouddms.v1.ConnectionProfile.state:type_name -> google.cloud.clouddms.v1.ConnectionProfile.State
	12, // 38: google.cloud.clouddms.v1.ConnectionProfile.mysql:type_name -> google.cloud.clouddms.v1.MySqlConnectionProfile
	13, // 39: google.cloud.clouddms.v1.ConnectionProfile.postgresql:type_name -> google.cloud.clouddms.v1.PostgreSqlConnectionProfile
	14, // 40: google.cloud.clouddms.v1.ConnectionProfile.cloudsql:type_name -> google.cloud.clouddms.v1.CloudSqlConnectionProfile
	33, // 41: google.cloud.clouddms.v1.ConnectionProfile.error:type_name -> google.rpc.Status
	1,  // 42: google.cloud.clouddms.v1.ConnectionProfile.provider:type_name -> google.cloud.clouddms.v1.DatabaseProvider
	10, // 43: google.cloud.clouddms.v1.MigrationJobVerificationError.error_code:type_name -> google.cloud.clouddms.v1.MigrationJobVerificationError.ErrorCode
	44, // [44:44] is the sub-list for method output_type
	44, // [44:44] is the sub-list for method input_type
	44, // [44:44] is the sub-list for extension type_name
	44, // [44:44] is the sub-list for extension extendee
	0,  // [0:44] is the sub-list for field type_name
}

func init() { file_google_cloud_clouddms_v1_clouddms_resources_proto_init() }
func file_google_cloud_clouddms_v1_clouddms_resources_proto_init() {
	if File_google_cloud_clouddms_v1_clouddms_resources_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SslConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MySqlConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PostgreSqlConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudSqlConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlAclEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SqlIpConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudSqlSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StaticIpConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReverseSshConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VpcPeeringConnectivity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DatabaseType); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConnectionProfile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MigrationJobVerificationError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*SqlAclEntry_ExpireTime)(nil),
		(*SqlAclEntry_Ttl)(nil),
	}
	file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*MigrationJob_ReverseSshConnectivity)(nil),
		(*MigrationJob_VpcPeeringConnectivity)(nil),
		(*MigrationJob_StaticIpConnectivity)(nil),
	}
	file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*ConnectionProfile_Mysql)(nil),
		(*ConnectionProfile_Postgresql)(nil),
		(*ConnectionProfile_Cloudsql)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDesc,
			NumEnums:      11,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_clouddms_v1_clouddms_resources_proto_goTypes,
		DependencyIndexes: file_google_cloud_clouddms_v1_clouddms_resources_proto_depIdxs,
		EnumInfos:         file_google_cloud_clouddms_v1_clouddms_resources_proto_enumTypes,
		MessageInfos:      file_google_cloud_clouddms_v1_clouddms_resources_proto_msgTypes,
	}.Build()
	File_google_cloud_clouddms_v1_clouddms_resources_proto = out.File
	file_google_cloud_clouddms_v1_clouddms_resources_proto_rawDesc = nil
	file_google_cloud_clouddms_v1_clouddms_resources_proto_goTypes = nil
	file_google_cloud_clouddms_v1_clouddms_resources_proto_depIdxs = nil
}
